<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
define('FOPEN_READ', 'rb');
define('FOPEN_READ_WRITE', 'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE', 'ab');
define('FOPEN_READ_WRITE_CREATE', 'a+b');
define('FOPEN_WRITE_CREATE_STRICT', 'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
define('EXIT_SUCCESS', 0); // no errors
define('EXIT_ERROR', 1); // generic error
define('EXIT_CONFIG', 3); // configuration error
define('EXIT_UNKNOWN_FILE', 4); // file not found
define('EXIT_UNKNOWN_CLASS', 5); // unknown class
define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
define('EXIT_USER_INPUT', 7); // invalid user input
define('EXIT_DATABASE', 8); // database error
define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code

//Pet constants

//Image Dir
//server path
define('UPLOAD_IMG_PATH','assets/images/');
//local path
//define('UPLOAD_IMG_PATH', '/opt/lampp/htdocs/petnew/images/');


//API Messages
define('USER_FOUND', 'user found');
define('USER_NOT_FOUND', 'We could not find this email or password combination. Please try again.');
define('USER_CONFIRMATION', 'Please confirm your email, You must be receive an email.');
define('PASSWORD_UPDATED', 'password updated');
define('PASSWORD_NOTMATCHED', 'your old password did not match');
define('EMAIL_EXISTS', 'This email already exists');
define('USER_REGISTERED', 'Registration successful');
define('EMAIL_NOT_EXISTS', 'Email not found');
define('ACTIVITY_SEND', 'All Activity send');
define('IS_FOLLOW_TRUE','1');
define('IS_FOLLOW_FALSE','0');

define('ACTIVATE', "Your account is activated by admin ");
define('INACTIVATE', "Your account is deactivated by admin ");
define('NOTFOLLOW', "You can not follow your profile. ");

define('REQUEST', "Get All Request");
define('NOREQUEST', "Request not available please add your request");
define('NOTACTIVATE', "Your account is pending for verification");
define('OTP_FAIL', "OTP not send please try after some time.");
define('PROFILE_UPDATE_FAILED', "Profile not updated please try again later.");
define('SEND_USER_ID', "please send user id");
define('DONE', "Done");
define('NOT_DONE', "Not Done");
define('INVALID_REQUEST', "Invalid Request");
define('SUCCESS', "Success");
define('NO_TASK', "No Task Found");
define('FAILED', "Failed");
define('REMOVEUSER', "User Removed Successfully.");
define('REQUEST_SUCCESS', "Your request sent successfully");
define('OTHER', "Other");
define('RECORD_FILTER', "Filter Record");
define('NO_RECORD', "No Record Found");
define('VIEW', "View");
define('CONTACTTITLE', "Contact");
define('GET_CONTACT_REQUEST', "Contact Details fetch Successfully.");
define('GET_NOTIFICATION_REQUEST', "Notification Details fetch Successfully.");
define('LOGIN_FLASH',"Please enter valid Username or Password");
define('VERIFIED', " is verified by admin.");
define('NOT_VERIFIED', " is unverified");

define('STU_TBL', 'student');
define('Staff_TBL','staff');
define('STU_LOGIN', 'Student Login successfully.');
define('NOTOFICATION_TBL', "notifications");

define('ADD_SUPPORT', ' add support');
define('GENRATE MY TICKET', 'Ticket generated successfully');
define('GET MY TICKET', 'my_ticket');
define('UPDATE_PROFILE', 'Profile update successfully');
define('SIGNUP_PROFILE','Signup successfully');
define('NOT_RESPONDING', 'Please try after some time');
define('TRY_AGAIN', "Try Again");
define('CHT_TBL', 'chat');
define('MSG_SEND', "Message sent successfully");
define('CHAT_HST', "Get chat history.");
define('GET_CHAT', "Get my conversation.");
define('NO_CHAT', "Not yet any conversation.");
define('GET_DATA', "Get All data");
define('FIRE_BASE_KEY',"AAAA6IATn3A:APA91bH_2zsQibTFgn_yEJg5K9l0S6T1EnFlFdwSitzdqJxm3KQSz5m2aBMZyfR2zy3EVCQ4WhlChuxCLqqa-hMqHDVy-I_Z-AtZqlWwFlp3KI7cd5wZ_o9rIUdmjjYFqbf_vRpu6htg");


/*NOtification Type*/
define('Chat','7001');
define('Notification','7002');
define('support','7003');





