<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Admin extends CI_Controller
{
    public function __construct()
    {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        } else {
            $this->headerData=[];
        }

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }

    public function GoogleLogin() {
        if(isset($_GET['code'])) {
            if($userData = $this->google->getAuthenticate()){
                $domain_name = substr(strrchr($userData['email'], "@"), 1);
               // $validDomains = ['gmail.com','garciapharmacy.com','hcpcaregivers.com'];
                $validDomains = ['hcpcaregivers.com','garciapharmacy.com'];
                if(in_array($domain_name, $validDomains))
                {
                    $userID = $this->Comman_model->checkGoogleUser($userData);
                    $where = [];
                    $where['googleUserId'] = $userData['googleUserId'];
                    $userDetails = $this->Comman_model->get_row('users_portal', $where);

                    $where = [];
                    $where['googleUserId'] = $userData['googleUserId'];
                    $supervisorDetails = $this->Comman_model->get_row('supervisor', $where);

                    //print_r($userDetails);die;

                    $sess_array = array(
                       'name' => $userData['name'],
                       'id' => $userDetails['user_id'],
                       'googleId' => $userID,
                       'userlevel' => $userDetails['userlevel'],
                       'useragency' => $userDetails['agency'],
                       'userId' => $supervisorDetails['supervisor_id'],
                       'image_url' => $userDetails['image_url'],
                       'googleUser'=>true,
                   );
                    $this->session->set_userdata($sess_array);
                    $this->session->set_userdata('name',$userData['name']);
                    redirect('Admin/home'); 
                    //redirect('admin/client');
                }else{
                    $data['loginURL'] = $this->google->get_login_url();
                    $this->session->set_flashdata('msg', 'Sorry, your account is not valid, please contact our technical support team.');
                    redirect('',$data);
                }
            }
        }
        else{
            $data['loginURL'] = $this->google->get_login_url();
            $this->session->set_flashdata('msg', 'Sorry, something went wrong. Try Again.');
            redirect('Admin/login',$data);
        }
    }

    public function calendarData()
    {
        $startDate = $this->input->get('start');
        $endDate = $this->input->get('end');
        $calenderData = $this->google->getCalendarEvent($startDate,$endDate);
        die(json_encode($calenderData));
    }
    public function seeAttach($messageId,$partId)
    {
        $messageId = base64_decode($messageId);
        $partId = base64_decode($partId);
        $data['inboxDetails'] = $this->google->fetchAttachment($messageId,$partId);
    }
    public function inboxEmail($label='INBOX',$nextPageToken='')
    {
        if(isset($_SESSION['name'])) 
        {
            $getResponseEmail = $this->google->inboxEmails($_SESSION['id'],$label,$nextPageToken);
            $data['label'] = $label;
            $data['nextPageToken'] = isset($getResponseEmail['pageToken'])?$getResponseEmail['pageToken']:'';
            unset($getResponseEmail['pageToken']);
            $data['prevPageToken'] = $nextPageToken;
            $data['inboxEmails'] = $getResponseEmail;
            $this->load->view('common/header.php',$this->headerData);
            $this->load->view('common/sidebar.php');
            $this->load->view('inbox_email.php',$data);
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function inboxDetail($messageId)
    {
        if(isset($_SESSION['name'])) 
        {
            $messageId = base64_decode($messageId);
            $data['inboxDetails'] = $this->google->inboxDetails($_SESSION['id'],$messageId);
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('inbox_detail.php',$data);
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function inboxCompose()
    {
        if(isset($_SESSION['name'])) 
        {
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('inbox_compose.php');
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function inboxReply()
    {
        $data['messageId'] = $this->input->post('messageId');
        $data['subject'] = $this->input->post('subject');
        $data['to_email'] = $this->input->post('to_email');
        if(isset($_SESSION['name'])) 
        {
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('inbox_compose.php',$data);
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    function x_week_range($date) {
        $ts = strtotime($date);
        $start = (date('w', $ts) == 0) ? $ts : strtotime('last sunday', $ts);
        return array(date('c',strtotime('-1 day', $start)),
         date('c', strtotime('+1 day',strtotime('next saturday', $start))));
    }
    public function sendCompose()
    {
        $to_email =$this->input->post('to_email'); 
        $subject = $this->input->post('subject');
        $msg = $this->input->post('msg');
        $messageId = $this->input->post('messageId');
        $getResponse = $this->google->sendMail($to_email,$subject,$msg,$messageId);
        redirect('Admin/inboxCompose');    
    }
    public function googleTaskStatus()
    {
        $taskId = $this->input->post('taskId');
        $this->google->changeTaskStatus($taskId);
    }
    public function googleTaskInsert()
    {
        date_default_timezone_set('America/Chicago');
        $title= $this->input->post('title');
        $notes= $this->input->post('desc');
        $dueDate= $this->input->post('dueDate');
        $dueDate = date('c',strtotime($dueDate));
        $this->google->taskInsert($title,$notes,$dueDate);
        redirect('Admin/home', 'refresh');
    }
    public function googleEventAdd()
    {
        $title = $this->input->post('title');
        $startTime = $this->input->post('start');
        $endTime = $this->input->post('end');
        $date = $this->input->post('selectedDate');
        $start = strtotime($date.' '.$startTime);
        $end = strtotime($date.' '.$endTime);
        $reminder = $this->input->post('reminder');
        $eventArr = [
            'summary'=>$title,
            'start'=>['dateTime'=>date('c',$start),'timeZone' => 'America/Chicago'],
            'end'=>['dateTime'=>date('c',$end),'timeZone' => 'America/Chicago'],
        ];
        if($reminder == 'on')
        {
            $eventArr['reminders']=[
                'useDefault' => FALSE,
                'overrides' => 
                array(
                    array('method' => 'email', 'minutes' => 24 * 60),
                )
            ];
        }
        $this->google->googleEventInsert($eventArr);
    }
    public function googleEventDelete()
    {
        $eventId = $this->input->post('id');
        $this->google->googleEventDelete($eventId);
    }
    public function Chats()
    {
        if(isset($_SESSION['name'])) 
        {
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('chatuser.php');
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function newMessageNotifyList()
    {
        $user_id = $this->receiverId; 
        $sql = "SELECT * from user_chat where receiverId = $user_id and seenState=1 and notified IN (0,1)";
        $res=$this->db->query($sql);
        $i=0;
        $messageArr=[];
        foreach ($res->result_Array() as $key => $value) {
            $messageArr[$i]['senderName'] = $this->db->get_where('users_portal', array('user_id' => $value['senderId']))->row()->name;
            $messageArr[$i]['message'] = $value['message'];
            $i++;
        }
        return $messageArr;
    }


    

    public function index() {
        if (isset($_SESSION['name'])) { 
            $total_parent  = $this->Api_model->count('parent');
            $total_staff   = $this->Api_model->count('staff');
            $total_student = $this->Api_model->count('student');    
            $getstaff              = $this->Api_model->getAllDataLimit('staff', 5);
            $data['getstaff']      = $getstaff;
            $data['total_parent']  = $total_parent;
            $data['total_staff']   = $total_staff;
            $data['total_student'] = $total_student;
            $data['page']          = 'home';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('dashboard.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    
    public function Chatpage() {
        if(isset($_SESSION['name'])) {
            $data['user_reciver_id'] = $this->uri->segment(3);
            $data['task1'] = $this->Api_model->getAllData('task');
            $data['task'] = $this->Api_model->getAllDataLimit('task','5');
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('viewChat.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function Test() {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('test.php');
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function demo_map() {
        // echo "hello"; die;
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('demo_map.php');
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function Addtestclient() {
        if(isset($_SESSION['name'])) {
            $this->load->view('addtestclient.php');
            
            // $this->load->view('common/header.php');
            // $this->load->view('common/sidebar.php');
            // $this->load->view('addtestclient.php');
            // $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    // For View & Insert Client
    public function Client()   //Listing/View Client
    {
        if(isset($_SESSION['name'])) {

        	//print_r($_SESSION);die;
            // $data['patient'] = $this->db->get('patient')->result();
            //$where= [];
            // $where['Agency'] = $_SESSION['agency'];
            //$data['patient'] = $this->Api_model->getAllDataWhere($where, 'patient');

            $data['patient']    =   $this->client->get_clients($_SESSION['agency']);

            $where= [];
            $where['Agency'] = $_SESSION['agency'];
            $data['districts'] = $this->Api_model->getAllDataWhere($where, 'tbldistricts');

            $where= [];
            $data['agencyLocation'] = $this->Api_model->getAllDataWhere($where, 'agency_location');

            $where= [];
            $data['supervisor'] = $this->Api_model->getAllDataWhere($where, 'supervisor');


            $message1 = $message2 = '';
            if (empty($data['patient']) &&  !empty($this->input->post('lastname'))) {
                $lastname = $this->input->post('lastname');
                $MySQLx = "SELECT SQL_CALC_FOUND_ROWS patient.lastname, patient.firstname, Agency FROM patient WHERE patient.lastname LIKE '%".$lastname."%' ";      
                $objExecx = $this->Comman_model->getCustomQueryData($MySQLx);
                $intRows = 0;
                foreach ($objExecx as $key => $objResultx) {
                    $intRows++; 
                    $Agency = $objResultx["Agency"];

                    if ($Agency == 1) {
                        $AgencyName = 'HM';
                    }
                    if ($Agency == 2) {
                        $AgencyName = 'SC';
                    }
                    if ($Agency == 3) {
                        $AgencyName = 'CG';
                    }
                    if ($Agency == 4) {
                        $AgencyName = 'RF';
                    }        
                    $message1 .= '<div class="text-center"><b>"'.$objResultx["lastname"].", ".$objResultx["firstname"].", ".$AgencyName.'"</b></div></br>';
                }

                if ($intRows == 0)  {
                    $message2 .= '<h2 class="text-center">Zero Result. Please check other Agencies.</h2>';
                }
            }

            // $data['patient']    =   [];
            $data['message1'] = $message1;
            $data['message2'] = $message2;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('viewClient.php',$data);
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function importPatientCSV() {
        //print_r($_FILES);die;
        if(!empty($_FILES['patientcsv'])){
            $img_data   =   [];
            $img_data['path']   =   'image/uploads';
            $img_data['file_name']  =   'patientcsv';
            $img_data['allowed_type']   =   '*';
            $img_data['old_file']   =   '';
            $img_data['width']  =   '';
            $img_data['height'] =   '';
            $img_data['quality']    =   '60%';
            $img_data['image_compress'] =   False;

            $img=$this->uploadfiles($img_data);

            //print_r($img);die;
            if(!empty($img['status']=='1')){
                $filename = $img['url'];
                $fileurl = base_url('image/uploads').'/'.$filename;

                if (($handle = fopen($fileurl, "r")) !== FALSE) {
                    while (($data = fgetcsv($handle, 100000, ",")) !== FALSE) {
                        $num = count($data);
                        // echo "<p> $num fields in line $row: <br /></p>\n";
                        //$row++;
                        //for ($c=0; $c < $num; $c++) {
                        //echo $data[$c] . "<br />\n";
                        //}
                        $patient_id = $data[0];
                        $med_medicaidno = $data[4];
                        $med_status2 = $data[3];
                        $med_effdate = date('Y-m-d',strtotime($data[5]));
                        $med_enddate = date('Y-m-d',strtotime($data[6]));

                        /*$query1 = mysql_query("UPDATE  patient 
                        SET med_medicaidno='$med_medicaidno' 
                        WHERE patient_id = '$patient_id'" ) or die (mysql_error());*/

                        $where = [];
                        $where['patient_id'] = $patient_id;
                        $dataArray = [];
                        $dataArray['med_medicaidno'] = $med_medicaidno;
                        $this->Comman_model->update('patient', $where, $dataArray);

                        //echo $med_effdate.' '.$med_enddate.'</br>';               
                        $confirm1 = 0;
                        $confirm2 = 0;
                        list($years,$months,$days)=explode("-",$med_effdate);

                        if(@checkdate($months,$days,$years)) {
                            $confirm1 = 1;
                        }
                        
                        list($years,$months,$days)=explode("-",$med_enddate);
                        if(@checkdate($months,$days,$years)) {
                            $confirm2 = 1;
                        }

                        if ($confirm1 == 1 && $confirm2 == 1 ) {

                            if ( $med_effdate > date('Y-m-d') ) {
                                $med_status = 'Pending';
                                //$query1 = mysql_query("UPDATE  patient SET med_status='$med_status' WHERE patient_id = '$patient_id'" ) or die (mysql_error());
                                //echo "Pending";
                                $where = [];
                                $where['patient_id'] = $patient_id;
                                $dataArray = [];
                                $dataArray['med_status'] = $med_status;
                                $this->Comman_model->update('patient', $where, $dataArray);

                            }

                            if ( date('Y-m-d')  <=  $med_enddate &&    date('Y-m-d') >= $med_effdate ) {
                                $med_status = 'Active';
                                //$query1 = mysql_query("UPDATE  patient SET med_status='$med_status' WHERE patient_id = '$patient_id'" ) or die (mysql_error());
                                //echo "Active";

                                $where = [];
                                $where['patient_id'] = $patient_id;
                                $dataArray = [];
                                $dataArray['med_status'] = $med_status;
                                $this->Comman_model->update('patient', $where, $dataArray);
                            }

                            if(date('Y-m-d')  > $med_enddate) {
                                $med_status = 'Expired';
                                //$query1 = mysql_query("UPDATE  patient SET med_status='$med_status' WHERE patient_id = '$patient_id'" ) or die (mysql_error());
                                //echo "Expired";

                                $where = [];
                                $where['patient_id'] = $patient_id;
                                $dataArray = [];
                                $dataArray['med_status'] = $med_status;
                                $this->Comman_model->update('patient', $where, $dataArray);
                            }

                        }   

                            /*$query1 = mysql_query("UPDATE  patient 
                            SET med_effdate='$med_effdate', 
                            med_enddate='$med_enddate'              
                            WHERE patient_id = '$patient_id'" ) or die (mysql_error());*/

                            $where = [];
                            $where['patient_id'] = $patient_id;
                            $dataArray = [];
                            $dataArray['med_effdate'] = $med_effdate;
                            $this->Comman_model->update('patient', $where, $dataArray);

                        if ($med_status2 == 'NE' )  {
                            /*$query1 = mysql_query("UPDATE  patient 
                            SET med_status='$med_status2' 
                            WHERE patient_id = '$patient_id'" ) or die (mysql_error());*/
                            //echo "hello";

                            $where = [];
                            $where['patient_id'] = $patient_id;
                            $dataArray = [];
                            $dataArray['med_status'] = $med_status2;
                            $this->Comman_model->update('patient', $where, $dataArray);

                        }               

                    }
                    fclose($handle);

                    $data['file'] = $_FILES;

                    //print_r($data['file']);

                    $this->load->view('common/header.php');
                    $this->load->view('common/sidebar.php');
                    $this->load->view('importPatientCSV.php',$data);
                    $this->load->view('common/footer.php');
                }
            }
        }
    }

    public function AddClient()   //Insert AddClient
    {
        //print_r($_SESSION);
        if(isset($_SESSION['name'])) {
            $data = [];
            $FULLHOURS = '';
            $data['validateClient'] = 'validate';
            if(isset($_SESSION['client'])) {
                $data['validateClient'] = $_SESSION['client'];
            }
            $data['patient_image'] = base_url('assets2/texst.jpg');
            if(!empty($_GET['patient'])) {
                $where  = [];
                $where['patient_id']    =   $_GET['patient'];
                $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
                if(!empty($data['patientData']['image_path'])) {
                    $data['patient_image'] = base_url('image/client_image/'.$data['patientData']['image_path']);
                }

                if(empty($data['patientData'])){
                    redirect('Admin/AddClient');
                }

                if(!empty($data['patientData']['DistrictID_Ref'])) {
                    $where = [];
                    $where['DistrictID_Ref'] = $data['patientData']['DistrictID_Ref'];
                    $where['Agency'] = $_SESSION['agency'];  
                    $data['districtDataMco'] = $this->Comman_model->get_rows('tbldistrictmanagers', $where);

                    $where = [];
                    $where['DistrictID'] = $data['patientData']['DistrictID_Ref'];
                    $where['Agency'] = $_SESSION['agency'];  
                    $districtRow = $this->Comman_model->get_row('tbldistricts', $where);
                    $data['FULLHOURS'] = $districtRow['full_hours'];
                }
                

                $where  = [];
                $where['ea.patient_id']    =   $_GET['patient'];
                $like = [];
                $not_like = [];
                $not_like['ea.pin'] = '+';   
                $data['assignEmployeeData']    =   $this->client->get_assigned_employee($where, $like, $not_like);

                $data['validateClient'] = 'add';

                $where = [];
                $where['patient_id'] = $_GET['patient'];
                $patientService = $this->Comman_model->countrow('tblpatientservices', $where);
                if($patientService==0) {
                    $dataArray = [];
                    $dataArray['patient_id'] = $_GET['patient'];
                    $dataArray['Agency'] = $_SESSION['agency'];
                    $this->Comman_model->insert('tblpatientservices', $dataArray);
                }


                $where = [];
                $where['patient_id']  = $_GET['patient'];
                $where['category']  = 'facesheet';
                $data['patient_facesheet'] = $this->Comman_model->get_row('patient_image', $where);

                $where = [];
                $where['patient_id']  = $_GET['patient'];
                $where['category']  = 'insurance';
                $data['patient_insurance'] = $this->Comman_model->get_row('patient_image', $where);

                $where = [];
                $where['patient_id']  = $_GET['patient'];
                $where['category']  = 'plan_of_care';
                $data['patient_plan_of_care'] = $this->Comman_model->get_row('patient_image', $where);


                $where  =   [];
                $where['agency_code'] =   $data['patientData']['Agency'];
                $data['agencyData'] = $this->Comman_model->get_row('agency', $where);


                $where  =   [];
                $where['dt.patient_id'] =   $_GET['patient'];
                $where['td.Agency'] =   $_SESSION['agency'];
                $data['DistrictID_temp_Data'] = $this->client->getPreviousDistricts($where);
            }

            if(!empty($_SESSION['agency'])) {

                $where  =   [];
                $where['Agency'] =   $_SESSION['agency'];
                $where['firstname!='] =   '';
                $data['allEmployeeData'] = $this->Comman_model->get_rows('employee', $where, 'name', 'asc');

                $where  =   [];
                $where['Agency'] =   $_SESSION['agency'];
                $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where, 'DistrictNumber', 'asc');

            }

            $where = [];
            $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');


            $where= [];
            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where);

            $where= [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where);

            $where= [];
            $data['allAgencyData'] = $this->Comman_model->get_rows('agency', $where);

            /*$where= [];
            $data['agencyLocation'] = $this->Api_model->getAllDataWhere($where, 'agency_location');

            $where= [];
            $data['supervisor'] = $this->Api_model->getAllDataWhere($where, 'supervisor');*/


            //print_r($_SESSION);die;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('addClient.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function submit_AddClient() {

        $id  = $this->input->post('patient_id');

        if($id) {

            $where = [];
            $where['patient_id']  = $id;
            $patientData = $this->Comman_model->get_row('patient', $where);

            $dataArray = [];
           
            if(!empty($_FILES['client_image'])){
                $img_data   =   [];
                $img_data['path']   =   'image/client_image';
                $img_data['file_name']  =   'client_image';
                $img_data['allowed_type']   =   'png|jpg|jpeg';
                $img_data['old_file']   =   '';
                $img_data['width']  =   200;
                $img_data['height'] =   200;
                $img_data['quality']    =   '60%';
                $img_data['image_compress'] =   False;

                $img=$this->uploadfiles($img_data);
                if(!empty($img['status']=='1')){
                    $dataArray['image_path']=$img['url'];
                }

                //print_r($_FILES);
                //print_r($img);die;
            }


            /****************** Client Profile *********************/
            $dataArray['userdate']  =   date("Y-m-d H:i:s");
            $dataArray['IsActive']  =   $this->input->post('isActive');
            $dataArray['reason']  =   $this->input->post('reason');
            $dataArray['Agency']  =   $this->input->post('agency_code');
            $dataArray['agency_location']  =   $this->input->post('agency_location');
            $dataArray['device']  =   $this->input->post('device');
            $dataArray['firstname']  =   $this->input->post('firstname');
            $dataArray['lastname']  =   $this->input->post('lastname');
            $dataArray['middlename']  =   $this->input->post('mi');
            $dataArray['name']  =   $this->input->post('lastname').', '.$this->input->post('firstname');
            $dataArray['gender']  =   $this->input->post('gender');
            $dataArray['CustomFieldBirthday']  =   $this->input->post('birthday');
            $dataArray['zerotag'] = $this->input->post('zerotag');
            $dataArray['popalert'] = $this->input->post('popalert');
            $dataArray['popnotes']  =   $this->input->post('popnotes');

            // $dataArray['addaddress'] => $this->input->post('addaddress');
            $dataArray['city']  =   $this->input->post('city');
            $dataArray['ShipAddressState'] = $this->input->post('state');
            $dataArray['zipcode']  =   $this->input->post('zipcode');
            $dataArray['ShipAddressCity']  =   $this->input->post('city');
            $dataArray['ShipAddressState']  =   $this->input->post('state');
            $dataArray['ShipAddressPostalCode']  =   $this->input->post('zipcode');
            $dataArray['ShipAddressAddr2'] = $this->input->post('address1');
            $dataArray['ShipAddressAddr3'] = $this->input->post('address2');
            $dataArray['latitude']  =   $this->input->post('latitude');
            $dataArray['longitude']  =   $this->input->post('longitude');
            $dataArray['macAddress']  =   $this->input->post('macaddress');

            if(empty($patientData['phone'])) {
                $dataArray['phone']  =   $this->input->post('phone');
            }

            $dataArray['phone2']  =   $this->input->post('phone2');
            $dataArray['contactperson']  =   $this->input->post('contact_person');
            $dataArray['contactno']  =   $this->input->post('contact_no');
            $dataArray['race']  =   $this->input->post('race');
            $dataArray['DNR']  =   $this->input->post('DNR');

            /******************** Client Services *************************/
            if(empty($patientData['supervisor_id'])) {
                //$dataArray['supervisor_id']  =   $this->input->post('suplid');
            }
            $dataArray['Notes']  =   $this->input->post('notes');
            $dataArray['VisitationNotesNew']  =   $this->input->post('visitationNotesNew');

            if(!empty($this->input->post('daily_hours_check')) && $this->input->post('daily_hours_check')==1){
                $dataArray['dailyhrs']  =   $this->input->post('dailyhrs');    
                $dataArray['dailyhrslimit']  =   $this->input->post('daily_hours_check');    
            }

            if(!empty($this->input->post('listTask'))) {
                $dataArray['tasks']  =   implode(',', $this->input->post('listTask'));    
            }

            $dataArray['mon_limit']  =   $this->input->post('mon_limit', true);    
            $dataArray['tue_limit']  =   $this->input->post('tue_limit', true);    
            $dataArray['wed_limit']  =   $this->input->post('wed_limit', true);    
            $dataArray['thu_limit']  =   $this->input->post('thu_limit', true);    
            $dataArray['fri_limit']  =   $this->input->post('fri_limit', true);    
            $dataArray['sat_limit']  =   $this->input->post('sat_limit', true);    
            $dataArray['sun_limit']  =   $this->input->post('sun_limit', true);    


            /******************** Client Billing *************************/
            $dataArray['DistrictID_Ref']  =   $this->input->post('DistrictID_Ref');
            $dataArray['NewDistrictStartDate'] = $this->input->post('transferred_date');
            //$dataArray['DistrictID_temp'] = $this->input->post('DistrictID_temp');
            $dataArray['phonefax']  =   $this->input->post('phonefax');
            $dataArray['DistrictManagerID_Ref']  =   $this->input->post('DistrictManagerID_Ref');
            $dataArray['BillType']  =   $this->input->post('BillType');
            $dataArray['BillAddressAddr2']  =   $this->input->post('BillAddressAddr2');
            $dataArray['BillAddressAddr3']  =   $this->input->post('BillAddressAddr3');
            $dataArray['BillAddressAddr4']  =   $this->input->post('BillAddressAddr4');
            $dataArray['BillAddressCity']  =   $this->input->post('BillAddressCity');
            $dataArray['BillAddressState']  =   $this->input->post('BillAddressState');
            $dataArray['BillAddressPostalCode']  =   $this->input->post('BillAddressPostalCode');
            $dataArray['CustomFieldCaseNumber']  =   $this->input->post('CustomFieldCaseNumber');
            $dataArray['MedicareNo']  =   $this->input->post('MedicareNo');
            $dataArray['CustomFieldSSN']  =   $this->input->post('CustomFieldSSN');
            $dataArray['FHCA']  =   $this->input->post('FHCA');
            $dataArray['icd10']  =   $this->input->post('icd10');
            $dataArray['JobStartDate'] = $this->input->post('element_5_1');
            $dataArray['JobEndDate'] = $this->input->post('element_6_1');
            $dataArray['HMKRHours']  =   $this->input->post('HMKRHours');
            $dataArray['LPNHours']  =   $this->input->post('LPNHours');
            $dataArray['insurance_id_no1a']  =   $this->input->post('insurance_id_no1a');
            $dataArray['service']  =   $this->input->post('service');
            $dataArray['med_medicaidno']  =   $this->input->post('med_medicaidno');
            $dataArray['med_status']  =   $this->input->post('med_status');
            $dataArray['med_effdate'] = $this->input->post('element_20_1');
            $dataArray['med_enddate'] = $this->input->post('element_30_1');
            $dataArray['relationship']  =   $this->input->post('relationship');
            $dataArray['groupno']  =   $this->input->post('groupno');
            $dataArray['validfrom'] = $this->input->post('element_7_1');
            $dataArray['validto'] = $this->input->post('element_8_1');
            $dataArray['authorization']  =   $this->input->post('authorization');
            $dataArray['CNAHours']  =   $this->input->post('CNAHours');
            $dataArray['RNHours']  =   $this->input->post('RNHours');
            if(!empty($this->input->post('date_received'))) {
                $dataArray['date_received']  =   date('Y-m-d', strtotime($this->input->post('date_received')));    
            }

            if(!empty($this->input->post('date_terminated'))) {
                $dataArray['date_terminated']  =   date('Y-m-d', strtotime($this->input->post('date_terminated')));    
            }


            // $dataArray['client_image'] = $image;

            $where = [];
            $where['patient_id'] = $id;
            $data = $this->Comman_model->update('patient', $where, $dataArray);

            $this->session->unset_userdata('client');

            if($data) {

                if(!empty($dataArray['HMKRHours']) && $patientData['HMKRHours']!=$_POST['HMKRHours']) {
                    $otherdb = $this->load->database('otherdb', TRUE); 
                    $dataOther = [];
                    $dataOther['changeDate'] = date('Y-m-d');
                    $dataOther['previous_approved_hours'] = $patientData['HMKRHours'];
                    $dataOther['new_approved_hours'] = $dataArray['HMKRHours'];
                    $dataOther['date_received'] = $dataArray['date_received'];
                    if(!empty($dataArray['med_effdate'])) {
                        $dataOther['effective_date'] = date('Y-m-d', strtotime($dataArray['med_effdate']));    
                    }
                    $dataOther['patient_id'] = $id;
                    $dataOther['supervisor_id'] = $_POST['suplid'];
                    $dataOther['user_id'] = $this->session->userdata('id');
                    $dataOther['user_level'] = $this->session->userdata('userlevel');
                    $dataOther['agency'] = $patientData['Agency'];
                    $dataOther['patient_location']  =   $this->input->post('agency_location');
                    $dataOther['createdOn'] = date('Y-m-d H:i:s');
                    $insrtttt = $otherdb->insert('patient_approve_hours', $dataOther);
                }


                if($dataArray['IsActive']!='' && ($patientData['IsActive']!=$_POST['isActive'])) {
                    $otherdb = $this->load->database('otherdb', TRUE); 
                    $dataOther = [];
                    $dataOther['changeDate'] = date('Y-m-d');
                    $dataOther['previous_status'] = $patientData['IsActive'];
                    $dataOther['new_status'] = $dataArray['IsActive'];
                    $dataOther['patient_id'] = $id;
                    $dataOther['supervisor_id'] = $_POST['suplid'];
                    $dataOther['user_id'] = $this->session->userdata('id');
                    $dataOther['user_level'] = $this->session->userdata('userlevel');
                    $dataOther['agency'] = $patientData['Agency'];
                    $dataOther['patient_location']  =   $this->input->post('agency_location');
                    $dataOther['worked_hours']  =   $this->getWorkedHoursStatus($patientData['Agency'], $id);
                    $dataOther['createdOn'] = date('Y-m-d H:i:s');
                    $insrtttt = $otherdb->insert('patient_status', $dataOther);
                    //print_r($dataOther);
                    //print_r($dataArray['IsActive']);
                    //print_r($insrtttt);die;
                }

                $dataArray = [];
                $dataArray['patient_id'] = $patientData['patient_id'];
                $dataArray['old_value'] = json_encode($patientData);
                $dataArray['new_value'] = json_encode($_POST);
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['user_level'] = $this->session->userdata('userlevel');
                $dataArray['agency'] = $this->session->userdata('agency');
                $dataArray['createdOn'] = date('Y-m-d H:i:s');
                insertHelper('patient_update_history', $dataArray);

                if(!empty($_FILES['facesheet'])){
                    $img_data   =   [];
                    $img_data['path']   =   'Dropbox';
                    $img_data['file_name']  =   'facesheet';
                    $img_data['allowed_type']   =   'pdf';
                    $img_data['old_file']   =   '';
                    $img_data['width']  =   '';
                    $img_data['height'] =   '';
                    $img_data['quality']    =   '90%';
                    $img_data['image_compress'] =   False;

                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $docArray   =   [];
                        $docArray['file_name']  =   $img['url'];
                        $docArray['patient_id'] =   $id;
                        $docArray['type'] = 'PDF';
                        $docArray['category'] = 'facesheet';
                        $docArray['uploaded_by']    =   $_SESSION['name'];
                        $docArray['timestamp'] = date("Y-m-d H:i:s");
                        $this->Comman_model->insert('patient_image', $docArray);
                    }
                }
                

                if(!empty($_FILES['insurance'])){
                    $img_data   =   [];
                    $img_data['path']   =   'Dropbox';
                    $img_data['file_name']  =   'insurance';
                    $img_data['allowed_type']   =   'pdf';
                    $img_data['old_file']   =   '';
                    $img_data['width']  =   '';
                    $img_data['height'] =   '';
                    $img_data['quality']    =   '90%';
                    $img_data['image_compress'] =   False;

                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $docArray   =   [];
                        $docArray['file_name']  =   $img['url'];
                        $docArray['patient_id'] =   $id;
                        $docArray['type'] = 'PDF';
                        $docArray['category'] = 'insurance';
                        $docArray['uploaded_by']    =   $_SESSION['name'];
                        $docArray['timestamp'] = date("Y-m-d H:i:s");
                        $this->Comman_model->insert('patient_image', $docArray);
                    }
                }


                if(!empty($_FILES['plan_of_care'])){
                    $img_data   =   [];
                    $img_data['path']   =   'Dropbox';
                    $img_data['file_name']  =   'plan_of_care';
                    $img_data['allowed_type']   =   'pdf';
                    $img_data['old_file']   =   '';
                    $img_data['width']  =   '';
                    $img_data['height'] =   '';
                    $img_data['quality']    =   '90%';
                    $img_data['image_compress'] =   False;

                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $docArray   =   [];
                        $docArray['file_name']  =   $img['url'];
                        $docArray['patient_id'] =   $id;
                        $docArray['type'] = 'PDF';
                        $docArray['category'] = 'plan_of_care';
                        $docArray['uploaded_by']    =   $_SESSION['name'];
                        $docArray['timestamp'] = date("Y-m-d H:i:s");
                        $this->Comman_model->insert('patient_image', $docArray);
                    }
                }

                $this->session->set_flashdata('message','Patient profile has been added successfully.');
                redirect('admin/AddClient?patient='.$patientData['patient_id']);
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
                redirect('admin/AddClient?patient='.$patientData['patient_id']);
            }
        }
    }
    

    public function getWorkedHoursStatus($agency, $patient_id) {
        if($agency==1 || $agency==3) {
            $sql = "SELECT SUM(period1+period2) as total_hrs FROM employee_finalsheet WHERE Agency = ".$agency." and patient_id=".$patient_id." GROUP BY year";
        } else {
            $sql = "SELECT SUM(total_hrs) as total_hrs FROM employee_2finalsheet WHERE Agency = ".$agency." and patient_id=".$patient_id."";
        }
        $row = $this->Comman_model->getCustomQueryData($sql, 'row');
        if($row['total_hrs']>0) {
            return 1;
        } else {
            return 0;
        }
    }


    public function uploadfiles($img_data=[]){
        $folder =   $img_data['path'];
        $file = $img_data['file_name'];
        $allowed_types =    $img_data['allowed_type'];
        $older =    $img_data['old_file'];
        $width  =   $img_data['width'];
        $height =   $img_data['height'];
        $quality    =   $img_data['quality'];

        if(!empty($_FILES[$file]) && $_FILES[$file]['size'] > 0){          
            if(!empty($older)){
                $postimgurl = FCPATH."$folder/". $older;
                unlink($postimgurl);
            }
            $config =   [];
            $config['upload_path']     = './'."$folder".'/'; 
            $config['allowed_types']   = $allowed_types;
            $new_name = $file.time().rand(0000,9999);
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if($this->upload->do_upload($file)){
                $postimg =$this->upload->data()['file_name'] ;
                $postimgurl = base_url()."$folder/". $postimg;
                chmod($this->upload->data()['full_path'],0777);
                if($img_data['image_compress']){
                    $config =   [];
                    $config['image_library'] = 'gd2';  
                    $config['source_image'] = './'."$folder".'/'.$postimg;  
                    $config['create_thumb'] = FALSE;  
                    $config['maintain_ratio'] = FALSE;  

                    $config['quality'] = $quality;  
                    if(!empty($width)){
                        $config['width'] = $width;  
                    }
                    if(!empty($height)){
                        $config['height'] = $height;  
                    }
                    
                    $config['new_image'] = './'."$folder".'/'.$postimg;  
                    
                    $this->load->library('image_lib', $config);  
                    $this->image_lib->initialize($config);
                    if($this->image_lib->resize()){
                        $this->image_lib->clear();
                        $data['url'] =  $postimg;
                        $data['status'] = 1;
                    }else{
                        $data['status'] = 0;
                        $data['msg']=$this->upload->display_errors();
                    }  
                }else{
                    $data['url'] =  $postimg;
                    $data['status'] = 1;
                }
            }else{
                $data['status']=0;
                $data['msg']=$this->upload->display_errors();
            }
            return $data;
        }
    }

    public function EditClient()   //Update EditClient
    {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('editClient.php');
            $this->load->view('common/footer.php');
        }else{
            redirect();
        }
    }
    public function delete_Client()   //Delete Client
    {
        $id = $this->input->get('patient_id');
        $data = $this->db->where('patient_id',$id)->delete('patient');
        if($data) {
            $this->session->set_flashdata('message','Delete Data Successfully');
            redirect('Admin/Client');
        } else {
            $this->session->set_flashdata('message','Somthing Went Wrong');
            redirect('Admin/Client');
        }
    }

    public function validateClient() 
    {
        $postData = $this->input->post();
        if(!empty($postData['firstname']) && !empty($postData['lastname']) && !empty($postData['birthday'])) {
            $where  =   [];
            $where['agency>'] = 0;
            $where['CustomFieldBirthday'] = date('Y-m-d',strtotime($postData['birthday']));
            $like   =   [];
            $like['firstname'] = $postData['firstname'];
            $like['lastname'] = $postData['lastname'];
            $num_rows = $this->client->get_rows('patient', '', $where, '', $like, true);
            if($num_rows==0) {
                $dataArray  =   [];
                $dataArray['firstname'] =   $postData['firstname'];
                $dataArray['lastname'] =   $postData['lastname'];
                $dataArray['CustomFieldBirthday'] =   date('Y-m-d',strtotime($postData['birthday']));
                $insertData = $this->Comman_model->insert('patient', $dataArray);
                if($insertData){
                    $this->session->set_userdata('client','add');
                    echo $insertData;     
                } else {
                    $this->session->set_userdata('client','validate');
                    echo 0;
                }
            } else {
                $this->session->set_userdata('client','validate');
                echo 0;
            }
        }
    }



    // For View & Insert CaseManager
    public function CaseManager()   //Listing/View CaseManager
    {
        if(isset($_SESSION['name'])) {
            $data['casemanager'] = $this->db->order_by('DMID','ASC')->get('tbldistrictmanagers')->result();

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $like = [];
            $like['DMName'] = @$_POST['byname'];
            $data['casemanager'] = $this->client->get_rows('tbldistrictmanagers', '*',$where, '', $like);
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('casemanager/view.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function addCaseManager()   //Add CaseManager
    {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['tbldistrictsData'] = $this->Comman_model->get_rows('tbldistricts', $where, 'DistrictNumber', 'asc');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('casemanager/add.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function editCaseManager($id)   //Edit CaseManager
    {
        if(isset($_SESSION['name'])) {
            $data['casemanager'] = $this->db->order_by('DMID','ASC')->get('tbldistrictmanagers')->result();

            $where = [];
            $where['id'] = $id;
            $data['casemanagerData'] = $this->Comman_model->get_row('tbldistrictmanagers', $where);

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['tbldistrictsData'] = $this->Comman_model->get_rows('tbldistricts', $where, 'DistrictNumber', 'asc');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('casemanager/edit.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function submit_CaseManager()
    {
        
        $dataArray = [];        
        $dataArray['DistrictID_Ref'] = $this->input->post('DistrictID_Ref');
        $dataArray['DMName'] = $this->input->post('DMName');
        $dataArray['Agency'] = $this->session->userdata('agency');

        if(!empty($this->input->post('save'))) {

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $casemanagerData = $this->Comman_model->get_rows('tbldistrictmanagers', $where, 'id', 'desc', '*', '1');
            $dataArray['DMID'] = $casemanagerData[0]['DMID']+1;

            $insertId = $this->Comman_model->insert('tbldistrictmanagers', $dataArray);
            if($insertId) {
                $this->session->set_flashdata('message','Case manager has been added successfully');
                redirect('Admin/CaseManager');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
                redirect('Admin/CaseManager');
            }

        } 

        if(!empty($this->input->post('update'))) {

            $id = $this->input->post('id');
            $where = [];
            $where['id'] = $id;
            $updateId = $this->Comman_model->update('tbldistrictmanagers', $where, $dataArray);
            if($updateId) {
                $this->session->set_flashdata('message','Case manager has been updated successfully');
                redirect('Admin/CaseManager');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
                redirect('Admin/CaseManager');
            }
        }
    }
    public function delete_CaseManager()   //Delete CaseManager
    {
        $id = $this->input->get('DMID');
        $data = $this->db->where('DMID',$id)->delete('tbldistrictmanagers');
        if($data) {
            $this->session->set_flashdata('message','Case manager has been deleted successfully');
            redirect('Admin/CaseManager');
        } else {
            $this->session->set_flashdata('message','Somthing Went Wrong');
            redirect('Admin/CaseManager');
        }
    }


    // For View & Insert Districts
    public function Districts()   //Listing/View Districts
    {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $data['districts'] = $this->client->get_districts($agency_code);
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('district/viewDistrict.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function addDistrict() {
        if(isset($_SESSION['name'])) {

            $data['payorSourceData'] = $this->Comman_model->get_rows('payor_source');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('district/add.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function editDistrict($id) {
        if(isset($_SESSION['name'])) {
            $where = [];
            $where['recid'] = $id;
            $data['districtData'] = $this->Comman_model->get_row('tbldistricts', $where);
            $data['payorSourceData'] = $this->Comman_model->get_rows('payor_source');


            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('district/edit.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function submit_Districts() {
        $id = $this->input->post('recid');

        $dataArray = [];
        
        $dataArray['DistrictNumber'] = $this->input->post('DistrictNumber');
        $dataArray['DistrictName'] = $this->input->post('DistrictName');
        $dataArray['mco'] = $this->input->post('mco');
        $dataArray['BillingAddress'] = $this->input->post('BillingAddress');
        $dataArray['BillingAddress2'] = $this->input->post('BillingAddress2');
        $dataArray['City'] = $this->input->post('City');
        $dataArray['State'] = $this->input->post('State');
        $dataArray['Zip'] = $this->input->post('Zip');
        $dataArray['Country'] = $this->input->post('Country');
        $dataArray['PhoneNumber'] = $this->input->post('PhoneNumber');
        $dataArray['FaxNumber'] = $this->input->post('FaxNumber');
        $dataArray['Notes'] = $this->input->post('Notes');
        $dataArray['DMName'] = $this->input->post('DMName');
        $dataArray['Billing'] = $this->input->post('Billing');
        $dataArray['Diagnosis'] = $this->input->post('Diagnosis');
        $dataArray['HCPCS24a'] = $this->input->post('HCPCS24a');
        $dataArray['Diagnosis_Pointer24e'] = $this->input->post('Diagnosis_Pointer24e');
        $dataArray['PayorID'] = $this->input->post('PayorID');
        $dataArray['Biller'] = $this->input->post('Biller');
        $dataArray['Agency'] = $this->session->userdata('agency');

        $dataArray['servicecomm'] = $this->input->post('servicecomm');
        $dataArray['full_hours'] = $this->input->post('full_hours');
        $dataArray['payor_source_id'] = $this->input->post('PayorSource');
        $dataArray['billing_id'] = $this->input->post('billing_id');
        $dataArray['ParentRef_ListID'] = $this->input->post('ParentRef_ListID');
        $dataArray['ParentRef_FullName'] = $this->input->post('ParentRef_FullName');




        if($id == '') {

            $districtData = $this->Comman_model->get_rows('tbldistricts', '', 'recid', 'desc', '*', '1');
            $dataArray['DistrictID'] = $districtData[0]['DistrictID'] + 1;

            $insertId = $this->Comman_model->insert('tbldistricts', $dataArray);
            
            if($insertId) {
                $this->session->set_flashdata('message','Add Data Successfully');
                redirect('Admin/Districts');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
                redirect('Admin/Districts');
            }
        } else {

            $where = [];
            $where['recid'] = $id;

            $updateId = $this->Comman_model->update('tbldistricts', $where, $dataArray);

            if($updateId) {
                $this->session->set_flashdata('message','Update Data Successfully');
                redirect('Admin/Districts');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
                redirect('Admin/Districts');
            }
        }
    }
    public function delete_Districts()   //Delete Districts
    {
        $id = $this->input->get('recid');
        $data = $this->db->where('recid',$id)->delete('tbldistricts');
        if($data) {
            $this->session->set_flashdata('message','Delete Data Successfully');
            redirect('Admin/Districts');
        } else {
            $this->session->set_flashdata('message','Somthing Went Wrong');
            redirect('Admin/Districts');
        }
    }


    // Reports
    public function vendorAuthorization()
    {
        if(isset($_SESSION['name'])) {

            $data['month'] = @$_GET['month'];
            $data['year'] = @$_GET['year'];
            $data['month2'] = @$_GET['month2'];
            $data['year2'] = @$_GET['year2'];

            if ($data['year'] == null || $data['year'] == '') {
               $data['year'] = date('Y');
            }
            if ($data['month'] == null || $data['month'] == '') {
               $data['month'] = date('m');
            }
            if ($data['year2'] == null || $data['year2'] == '') {
               $data['year2'] = date('Y');
            }
            if ($data['month2'] == null || $data['month2'] == '') {
               $data['month2'] = date('m');
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('vendorAuthorization.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    } 


    public function getVendorAuthorizationPdf() {
            $month = @$_GET['month'];
            $year = @$_GET['year'];
            $month2 = @$_GET['month2'];
            $year2 = @$_GET['year2'];
            $a_date = $year.'-'.$month.'-01';
            $b_date = $year2.'-'.$month2.'-01';
            $lastdate = date("Y-m-t", strtotime($b_date));
            $firstdate = date("Y-m-d", strtotime($a_date));

            require_once(APPPATH . 'libraries/pdf.php'); 
            $cnt = 0;
            $ctr = 0;
            $max  = 40;
            $spc = 40;
            $orient = 'P';
            $pdf=new PDF($orient, 'mm',array(215.9,279.4) );
            //$pdf=new PDF('L');

            //array(100,150)
            $pdf->AliasNbPages();
            $pdf->AddPage($orient);

            $pdf->SetFont('Arial','',8);
            $pdf->SetLeftMargin(10);


            //$sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient inner JOIN tbldistricts
            //ON DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code'  AND patient.Agency = '$agency_code' AND JobEndDate >= '$firsdate' AND JobEndDate <= '$lastdate'  ORDER BY patient.lastname";         

            $agency_code = $this->session->userdata('agency');
            $result = $this->client->get_vendor_authorization_patient($agency_code, $firstdate, $lastdate);
            $pdf->setxy(10,$spc);
            $page = 0;

            foreach ($result as $key => $row) {

                if ($cnt >= $max) {
                  $page = $page + 1;
                  $cnt = 0; 
                  $pdf->AliasNbPages();
                  $pdf->AddPage($orient);
                  $pdf->setxy(10,$spc);
                }
                   
               $DistrictID_Ref = $row['DistrictID_Ref'];       
               /*$strSQL = "SELECT * FROM tbldistrictmanagers WHERE Agency = '$agency_code'  AND  DistrictID_Ref = '$DistrictID_Ref' ORDER BY DMID ASC" ;
               $objExec = mysql_query($strSQL);  
               $objResult = mysql_fetch_array($objExec);*/

               $where = [];
               $where['Agency'] = $agency_code;
               $where['DistrictID_Ref'] = $DistrictID_Ref;
               $objResult = $this->Comman_model->get_row('tbldistrictmanagers', $where);

               $DMName = $objResult['DMName'];     
               $StaffingCoordinator = $row['StaffingCoordinator'];     
               $suplid = $row['supervisor_id'];        
               
               //$strSQL = "SELECT * FROM supervisor WHERE supervisor_id = '$suplid'" ;
               $val = -1;
               //$strSQL = "SELECT * FROM employee WHERE Agency = '$agency_code' AND StaffingCoordinator = '$val' AND employee_id = '$StaffingCoordinator' ";
               //$objExec = mysql_query($strSQL);
               //$objResult = mysql_fetch_array($objExec);

               $where = [];
               $where['supervisor_id'] = $suplid;
               $supResult = $this->Comman_model->get_row('supervisor', $where);

               $staffname = $supResult['lastname'].','.$supResult['firstname'];
               $cnt = $cnt + 1;
               $pdf->Cell(40,5,$row['DistrictNumber'].'-'.substr($row['DistrictName'],0,23),1,0,'L');          
               $pdf->Cell(32,5,substr($DMName,0,20),1,0,'L');       
               $pdf->Cell(20,5,$row['CustomFieldCaseNumber'],1,0,'L');       
               $pdf->Cell(32,5,$row['name'],1,0,'L');       
               $pdf->Cell(32,5,$staffname,1,0,'L');      
               $JobStartDate = date("m/d/Y",strtotime($row['JobStartDate']));
               $JobEndDate = date("m/d/Y",strtotime($row['JobEndDate']));      
               $pdf->Cell(20,5,$JobStartDate,1,0,'L');       
               $pdf->Cell(20,5,$JobEndDate,1,1,'L');       
         

            }

            $pdf->Output();
    }

    public function getVendorAuthorizationExcel() {
            $month = @$_GET['month'];
            $year = @$_GET['year'];
            $month2 = @$_GET['month2'];
            $year2 = @$_GET['year2'];
            $a_date = $year.'-'.$month.'-01';
            $b_date = $year2.'-'.$month2.'-01';
            $lastdate = date("Y-m-t", strtotime($b_date));
            $firstdate = date("Y-m-d", strtotime($a_date));

            $temp = "CREATE TEMPORARY TABLE `temp_trans` (
                                  `District` varchar(40) NOT NULL,
                                  `CaseManager` varchar(40) NOT NULL,
                                  `CaseNumber` varchar(11) NOT NULL,
                                  `PatientName` varchar(40) NOT NULL,
                                  `Supervisor` varchar(40) NOT NULL,
                                  `ServiceStartDate` varchar(12) NOT NULL,
                                  `ServiceEndDate` varchar(12) NOT NULL )";

            $tempresult = $this->client->createTemporaryTable($temp);
            

            $agency_code = $this->session->userdata('agency');
            $result = $this->client->get_vendor_authorization_patient($agency_code, $firstdate, $lastdate);
            $page = 0;

            foreach ($result as $key => $row) {
                   
                $DistrictID_Ref = $row['DistrictID_Ref'];       

                $where = [];
                $where['Agency'] = $agency_code;
                $where['DistrictID_Ref'] = $DistrictID_Ref;
                $objResult = $this->Comman_model->get_row('tbldistrictmanagers', $where);

                $DMName = $objResult['DMName'];     
                $StaffingCoordinator = $row['StaffingCoordinator'];     
                $suplid = $row['supervisor_id'];        

                $val = -1;

                $where = [];
                $where['supervisor_id'] = $suplid;
                $supResult = $this->Comman_model->get_row('supervisor', $where);

                $staffname = $supResult['lastname'].','.$supResult['firstname'];
                $District = $row['DistrictNumber'].'-'.$row['DistrictName'];          
                $CaseManager = substr($DMName,0,20);       
                $CaseNumber = $row['CustomFieldCaseNumber'];       
                $PatientName = $row['name'];       
                $ServiceStartDate = $row['JobStartDate'];       
                $ServiceEndDate = $row['JobEndDate'];  

                $dataArray = [];
                $dataArray['District']= $District;
                $dataArray['CaseManager'] = $CaseManager;
                $dataArray['CaseNumber'] = $CaseNumber;
                $dataArray['PatientName'] = $PatientName;
                $dataArray['Supervisor'] = $staffname;
                $dataArray['ServiceStartDate'] = $ServiceStartDate;
                $dataArray['ServiceEndDate'] =  $ServiceEndDate;
                
                $this->Comman_model->insert('temp_trans', $dataArray);

            }

            // file name for download
            $filename = "ExpiringVendorReport_" . date('Ymd') . ".xls";

            header("Content-Disposition: attachment; filename=\"$filename\"");
            header("Content-Type: application/vnd.ms-excel");

            $flag = false;
            $row2 = 0;
            $arry = array(' ',' ',' ',' ');
            $result = $this->Comman_model->get_rows('temp_trans');
            foreach ($result as $key => $row) {
                if(!$flag) {
                  // display field/column names as first row
                  array_walk($row, array($this,'cleanData'));

                  echo implode("\t",$arry) . "\r\n";
                  echo implode("\t", array_keys($row)) . "\r\n";
                  $flag = true;
                }
                array_walk($row, array($this, 'cleanData'));
                $x = 1;
                echo implode("\t", array_values($row)) . "\r\n";
            }                 
    }

    public function cleanData(&$str)  {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    public function patientReport()
    {
        if(isset($_SESSION['name'])) {

            $data['IsActive'] = @$_GET['IsActive'];
            $data['idoa'] = @$_GET['idoa'];
            if ($data['IsActive'] == '' || $data['IsActive'] == null )  {
               $data['IsActive'] = 0;
            } 

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patientReport.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function getPatientReportPdf() {

        $agency_code = $this->session->userdata('agency');     
        $IsActive = @$_GET['IsActive'];
        $idoa = @$_GET['idoa'];

        $cnt = 0;
        $ctr = 0;
        $max  = 40;
        $spc = 40;
        $orient = 'P';
        require_once(APPPATH . 'libraries/patient-report-pdf.php'); 
        $pdf = new patientReportPDF($orient, 'mm',array(215.9,279.4) );
        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->Comman_model->get_row('agency', $where);

        $_SESSION['AgencyName'] = $agencyData['agency_shortname'];
        $_SESSION['title'] = "Inactive";
        if ($IsActive == 1 )  {
          $_SESSION['title'] = "Active";
        }
        //array(100,150)
        $pdf->AliasNbPages();
        $pdf->AddPage($orient);

        $pdf->SetFont('Arial','',8);
        $pdf->SetLeftMargin(10);

        

        $result = $this->client->get_patient_report($agency_code, $IsActive, $idoa);


        $pdf->setxy(10,$spc);
        $page = 0;
        $counter = 0;

        foreach ($result as $key => $row) {

            if ($cnt >= $max) {
                $page = $page + 1;
                $cnt = 0; 
                $pdf->AliasNbPages();
                $pdf->AddPage($orient);
                $pdf->setxy(10,$spc);
            }

            $counter++;   
            $phone = $row['phone'];
            $clientid = $row['clientid'];
            $ccucontract = $row['ccucontract'];
            $gender = $row['gender'];
            $ptid = $row['patient_id'];
            $CustomFieldBirthday = date("m/d/Y",strtotime($row['CustomFieldBirthday']));
               
               
            $DistrictID_Ref = $row['DistrictID_Ref'];       

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $where['DistrictID_Ref'] = $DistrictID_Ref;
            $objResult = $this->Comman_model->get_row('tbldistrictmanagers', $where);

            $DMName = $objResult['DMName'];     
            $StaffingCoordinator = $row['StaffingCoordinator'];     
            $suplid = $row['supervisor_id'];        

            $val = -1;

            $where = [];
            $where['supervisor_id'] = $suplid;
            $objResult = $this->Comman_model->get_row('supervisor', $where);

            $staffname = $objResult['lastname'].','.$objResult['firstname'];
            $cnt = $cnt + 1;
            $pdf->Cell(40,5,$row['DistrictNumber'].'-'.substr($row['DistrictName'],0,23),1,0,'L');          
            $pdf->Cell(32,5,$row['lastname'].', '.$row['firstname'].' '.$row['middlename'] ,1,0,'L');       
            $pdf->Cell(18,5,$CustomFieldBirthday,1,0,'L');       
            $pdf->Cell(22,5,$phone,1,0,'L');       
            $pdf->Cell(16,5,$clientid,1,0,'L');       
            $pdf->Cell(15,5,$ptid,1,0,'L');       
            $pdf->Cell(22,5,$ccucontract,1,0,'L');       
            $pdf->Cell(8,5,$gender,1,0,'C');       
            $pdf->Cell(15,5,$row['CustomFieldCaseNumber'],1,0,'L');       
            $pdf->Cell(16,5,$row['insurance_id_no1a'],1,1,'L');       

        }

            $pdf->Cell(30,5,'',0,1,'R');
            $pdf->Cell(100,5,'Total:'.$counter,0,0,'L');
        /*
            $pdf->Cell(30,5,$pricetopay2,1,0,'R');
            $pdf->Cell(30,5,$discount2,1,0,'R');       
            $pdf->Cell(30,5,$subtotal2,1,0,'R');       
            $pdf->Cell(30,5,$amount2,1,1,'R');

        */
        $pdf->Output();
    }

    public function getPatientReportExcel() {
        $agency_code = $this->session->userdata('agency');     
        $IsActive = $_GET['IsActive'];                          
        $idoa = $_GET['idoa'];                          

        $temp = "CREATE TEMPORARY TABLE `temp_trans` (
          `District` varchar(40) NOT NULL,
          `PatientName` varchar(40) NOT NULL,
          `BirthDate` varchar(20) NOT NULL,
          `Phone` varchar(20) NOT NULL,
          `ALTPhone` varchar(20) NOT NULL,
          `Gender` varchar(20) NOT NULL,
          `CaseNumber` varchar(20) NOT NULL,
          `PortalID` varchar(20) NOT NULL,
          `MemberID` varchar(20) NOT NULL )";

        $tempresult = $this->client->createTemporaryTable($temp);
        
        $result = $this->client->get_patient_report($agency_code, $IsActive, $idoa);

        foreach ($result as $key => $row) {
         
            $PortalID = $row['patient_id'];
            $phone = $row['phone'];
            $phone2 = $row['phone2'];
            $gender = $row['gender'];
            $BirthDate =  date("m/d/Y",strtotime($row['CustomFieldBirthday']));
            $CaseNumber = $row['CustomFieldCaseNumber'];       
            $PatientName = $row['name'].' '.$row['middlename'];   
            
            $District = $row['DistrictNumber'].'-'.$row['DistrictName'];
            $MemberID = $row['insurance_id_no1a'];     

            $dataArray = [];
            $dataArray['District']= $District;
            $dataArray['PatientName'] = $PatientName;
            $dataArray['BirthDate'] = $BirthDate;
            $dataArray['Phone'] = $phone;
            $dataArray['ALTPhone'] = $phone2;
            $dataArray['Gender'] = $gender;
            $dataArray['CaseNumber'] =  $CaseNumber;
            $dataArray['PortalID'] =  $PortalID;
            $dataArray['MemberID'] =  $MemberID;
            
            $this->Comman_model->insert('temp_trans', $dataArray);
         
         } 

        // file name for download
        $filename = "PatientStatusReport_" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        $row2 = 0;
        $arry = array(' ',' ',' ',' ');
        $result = $this->Comman_model->get_rows('temp_trans');
        foreach ($result as $key => $row) {
            if(!$flag) {
                // display field/column names as first row
                array_walk($row, array($this,'cleanData'));

                echo implode("\t",$arry) . "\r\n";
                echo implode("\t", array_keys($row)) . "\r\n";
                $flag = true;
            }
            array_walk($row, array($this, 'cleanData'));
            $x = 1;
            echo implode("\t", array_values($row)) . "\r\n";
        }                 
    }


    public function ClientStatusReport() {
        if(isset($_SESSION['name'])) {

            $data['IsActive'] = @$_GET['IsActive'];              
            $data['fhca'] = @$_GET['fhca'];              
            $data['suplid'] = @$_GET['suplid'];    
            $data['agency_location'] = @$_GET['agency_location'];          
            if ($data['IsActive'] == '' || $data['IsActive'] == null )  {
               $data['IsActive'] = 1;
            } 
            if ($data['fhca'] == '' || $data['fhca'] == null )  {
               $data['fhca'] = 1;
            } 


            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor','','name','asc');
            $data['locationData'] = $this->Comman_model->get_rows('agency_location');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('clientStatusReport.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function ClientStatusReportPdf() {
        if(isset($_SESSION['name'])) {


            $agency_code = $this->session->userdata('agency');
            $IsActive = @$_GET['IsActive'];              
            $fhca = @$_GET['fhca'];              
            $suplid = @$_GET['suplid'];   
            $agency_location = @$_GET['agency_location'];           
            if ($IsActive == '' || $IsActive == null )  {
               $IsActive = 1;
            } 
            if ($fhca == '' || $fhca == null )  {
               $fhca = 1;
            } 

            $cnt = 0;
            $ctr = 0;
            $max  = 40;
            $spc = 40;
            $orient = 'P';
            require_once(APPPATH . 'libraries/client-status-report-pdf.php'); 
            $pdf=new clientStatusReportPDF($orient, 'mm',array(215.9,279.4) );
            //$pdf=new PDF('L');
            $where = [];
            $where['agency_code'] = $agency_code;
            $agencyData = $this->Comman_model->get_row('agency', $where);

            $_SESSION['AgencyName'] = $agencyData['agency_shortname'];

            $_SESSION['title'] = " NON FHCA ";
            if ($fhca == 1 )  {
              $_SESSION['title'] = " FHCA ";
            }
            //array(100,150)
            $pdf->AliasNbPages();
            $pdf->AddPage($orient);

            $pdf->SetFont('Arial','',8);
            $pdf->SetLeftMargin(10);
            $cond = '';

            if ($fhca == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

            if ($suplid != '' ) {
                
                $cond = " supervisor_id = '$suplid' AND ";
                
            }                
                                
            $pdf->setxy(10,$spc);
            $page = 0;
            $counter = 0;

            if(!empty($agency_location)) {
                $cond .= " agency_location = '$agency_location' AND "; 
            }

            $result = $this->client->get_client_status_report($agency_code, $cond, $IsActive, $fhca);

            foreach ($result as $key => $row) {

                if ($cnt >= $max) {
                  $page = $page + 1;
                  $cnt = 0; 
                  $pdf->AliasNbPages();
                  $pdf->AddPage($orient);
                  $pdf->setxy(10,$spc);
                }
             
                $ptid = $row['patient_id'];
                $suplid = $row['supervisor_id'];           

                $where = [];
                $where['supervisor_id'] = $suplid;
                $objResult2 = $this->Comman_model->get_row('supervisor', $where);

                $staffname = $objResult2['lastname'].','.$objResult2['firstname'];
                $name = $row['name'];

                $where = [];
                $where['patient_id'] = $ptid;
                $where['Agency'] = $agency_code;
                $objResult2 = $this->Comman_model->get_row('tblpatientsvisits', $where);

                $VisitDoneDate = $objResult2['VisitDoneDate'];
            
                if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00') {
                    
                    $VisitDoneDate = date("Y-m-d",strtotime($row['JobStartDate']));
                    if ($row['JobStartDate']  == '' || $row['JobStartDate'] == '0000-00-00'  || $row['JobStartDate'] == '--' ) {
                          $VisitDoneDate = "0000-00-00";
                    }
                } 
                $days = $multiplex;
                $first = strtotime($VisitDoneDate); 
                $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
                $nextvisit = date("Y-m-d",$next); 
                $datediff = $next - $first;
                $diff = ceil($datediff/(60*60*24));
                $today = date("Y-m-d");
                $date1 = new DateTime($VisitDoneDate);
                $date2 = new DateTime($nextvisit);

                $date2 = new DateTime($VisitDoneDate);
                $date1 = new DateTime($today);
                 //$JobStartDate 
                
                $diff = $date2->diff($date1)->format("%a");
                
                $date2=date_create($today);
                $date1=date_create($nextvisit);
                $diff=date_diff($date1,$date2);
                $diff4 = $diff->format("%a");

                                
                //echo $name.' - '.$staffname.' - '.$VisitDoneDate.' - '.$nextvisit.' - '.$diff.'</br>';

               //if ($diff <= $multiplex )  { $diff = 0;}
               if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00'  ) { 
                    $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
               } else {
                   $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
                   $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
               }
               
               $cnt = $cnt + 1;
               $pdf->Cell(40,5,$name,1,0,'L');          
               $pdf->Cell(10,5,$row['IsActive'],1,0,'L');          
               $pdf->Cell(32,5,$staffname,1,0,'L');       
               $pdf->Cell(22,5,$VisitDoneDate,1,0,'L');       
               $pdf->Cell(22,5,$nextvisit,1,0,'L');
               $pdf->SetFillColor(200,20,24);    
               if ($diff4 > $multiplex ) { $val = 'true';} else  { $val = '';}     
               $pdf->Cell(22,5," ".$diff4,1,1,'L',$val);       

             }

             $pdf->Cell(30,5,'*'.$multiplex,0,1,'L');

            $pdf->Output();
        } else {
            redirect();
        }
    }

    public function ClientStatusReportExcel() {
        $agency_code = $this->session->userdata('agency');     
        $fhca = $_GET['fhca'];
        $suplid = $_GET['suplid'];
        $IsActive = $_GET['IsActive'];

        $temp = "CREATE TEMPORARY TABLE `temp_trans` (
          `PatientName` varchar(40) NOT NULL,
          `Supervisor` varchar(40) NOT NULL,
          `LastVisit` varchar(20) NOT NULL,
          `NextVisit` varchar(20) NOT NULL,
          `Overdue` varchar(20) NOT NULL )";

        $tempresult = $this->client->createTemporaryTable($temp);
          
        $cond = '';
        if ($fhca == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

        if ($suplid != '' ) {
            
            $cond = " supervisor_id = '$suplid' AND ";
            
        }                
                            
        $result = $this->client->get_client_status_report($agency_code, $cond, $IsActive, $fhca);

        foreach ($result as $key => $row) {

            $ptid = $row['patient_id'];
            $suplid = $row['supervisor_id'];           
            $where = [];
            $where['supervisor_id'] = $suplid;
            $objResult2 = $this->Comman_model->get_row('supervisor', $where);

            $Supervisor = $objResult2['lastname'].','.$objResult2['firstname'];
            $PatientName = $row['name'];

            $where = [];
            $where['patient_id'] = $ptid;
            $where['Agency'] = $agency_code;
            $objResult2 = $this->Comman_model->get_row('tblpatientsvisits', $where);

            $VisitDoneDate = $objResult2['VisitDoneDate'];
            if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00') {
                $VisitDoneDate = date("Y-m-d",strtotime($row['JobStartDate']));
            }
            
            $days = $multiplex;
            $first = strtotime($VisitDoneDate); 
            $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
            $nextvisit = date("Y-m-d",$next); 
            $datediff = $next - $first;
            $diff = ceil($datediff/(60*60*24));
            $today = date("Y-m-d");
            $date1 = new DateTime($VisitDoneDate);
            $date2 = new DateTime($nextvisit);

            $date2 = new DateTime($VisitDoneDate);
            $date1 = new DateTime($today);
            
            
            $diff = $date2->diff($date1)->format("%a");
            //echo $name.' - '.$staffname.' - '.$VisitDoneDate.' - '.$nextvisit.' - '.$diff.'</br>';
            if ($diff <= $multiplex )  { $diff = 0;}
            if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00' ) { 
                $VisitDoneDate = ''; $nextvisit = '';  $diff = '';
            } else {
                $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
                $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
            }

            $dataArray = [];
            $dataArray['PatientName']= $PatientName;
            $dataArray['Supervisor'] = $Supervisor;
            $dataArray['LastVisit'] = $VisitDoneDate;
            $dataArray['NextVisit'] = $nextvisit;
            $dataArray['Overdue'] = $diff;
            
            $this->Comman_model->insert('temp_trans', $dataArray);
         
         
         } 


        // file name for download
        $filename = "NON-FHCA_CLient_Report" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        $row2 = 0;
        $arry = array(' ',' ',' ',' ');
        $result = $this->Comman_model->get_rows('temp_trans');
        foreach ($result as $key => $row) {
            if(!$flag) {
                // display field/column names as first row
                array_walk($row, array($this,'cleanData'));

                echo implode("\t",$arry) . "\r\n";
                echo implode("\t", array_keys($row)) . "\r\n";
                $flag = true;
            }
            array_walk($row, array($this, 'cleanData'));
            $x = 1;
            echo implode("\t", array_values($row)) . "\r\n";
        }         
    }

    public function schedule() {
        if(isset($_SESSION['name'])) {

            if(empty($_POST['year'])) {
                $_POST['year'] = date('Y');
            }

            if(empty($_POST['month'])) {
                $_POST['month'] = date('m');
            }

            if(empty($_POST['IsActive'])) {
                $_POST['IsActive'] = 1;
            }

            if (!empty($_POST['formSubmit']) && $_POST['formSubmit'] == 'Save') {
                $ptid = $_POST['ptid'];
                $emplid = $_POST['emplid'];
                $eom = 31;
                for ( $d=1;$d <= $eom; $d++) {
                    $col = 'day'.sprintf("%02s", $d);
                    $arr[$d] = $_POST[$col];               
                }

                $where = [];
                $where['year'] = $_POST['year'];
                $where['month'] = $_POST['month'];
                $where['patient_id'] = $_POST['ptid'];
                $where['employee_id'] = $_POST['emplid'];
                $findResult = get_employee_schedule($where);

                if ($findResult == 0 )  {

                    $dataArray = [];
                    $dataArray['employee_schedule_id'] = null;
                    $dataArray['patient_id'] = $_POST['ptid'];
                    $dataArray['employee_id'] = $_POST['emplid'];
                    $dataArray['year'] = $_POST['year'];
                    $dataArray['month'] = $_POST['month'];
                    $dataArray['Agency'] = $this->session->userdata('agency');

                    $record_id = $this->Comman_model->insert('employee_schedule', $dataArray);

                } else {
                    $record_id = $findResult['employee_schedule_id'];
                }              

                $dataArray = [];
                $dataArray['day01'] = $arr[1];
                $dataArray['day02'] = $arr[2];
                $dataArray['day03'] = $arr[3];
                $dataArray['day04'] = $arr[4];
                $dataArray['day05'] = $arr[5];
                $dataArray['day06'] = $arr[6];
                $dataArray['day07'] = $arr[7];
                $dataArray['day08'] = $arr[8];
                $dataArray['day09'] = $arr[9];
                $dataArray['day10'] = $arr[10];
                $dataArray['day11'] = $arr[11];
                $dataArray['day12'] = $arr[12];
                $dataArray['day13'] = $arr[13];
                $dataArray['day14'] = $arr[14];
                $dataArray['day15'] = $arr[15];
                $dataArray['day16'] = $arr[16];
                $dataArray['day17'] = $arr[17];
                $dataArray['day18'] = $arr[18];
                $dataArray['day19'] = $arr[19];
                $dataArray['day20'] = $arr[20];
                $dataArray['day21'] = $arr[21];
                $dataArray['day22'] = $arr[22];
                $dataArray['day23'] = $arr[23];
                $dataArray['day24'] = $arr[24];
                $dataArray['day25'] = $arr[25];
                $dataArray['day26'] = $arr[26];
                $dataArray['day27'] = $arr[27];
                $dataArray['day28'] = $arr[28];
                $dataArray['day29'] = $arr[29];
                $dataArray['day30'] = $arr[30];
                $dataArray['day31'] = $arr[31];


                $where = [];
                $where['employee_schedule_id'] = $record_id;
                $upd = $this->Comman_model->update('employee_schedule', $where, $dataArray);

            }   

            
            $data['scheduleData'] = $this->client->get_schedule_data();

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('schedule.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function uploadScheduleExcel() {
        if(!empty($_POST['btnUpload']) && $_POST['btnUpload']=='Load Excel') {
            //print_r($_FILES);die;
            if(!empty($_FILES['fileUpload'])){
                $img_data   =   [];
                $img_data['path']   =   'image/uploads';
                $img_data['file_name']  =   'fileUpload';
                $img_data['allowed_type']   =   '*';
                $img_data['old_file']   =   '';
                $img_data['width']  =   '';
                $img_data['height'] =   '';
                $img_data['quality']    =   '60%';
                $img_data['image_compress'] =   False;

                $img=$this->uploadfiles($img_data);

                if(!empty($img['status']=='1')){
                    $filename = $img['url'];
                    $fileurl = base_url('image/uploads').'/'.$filename;
                    $myfile = fopen($fileurl, "r") or die("Unable to open file!");
                    $cntr = 0;
                    // Output one line until end-of-file
                    while(!feof($myfile)) {
                        $line = fgets($myfile);
                        if (substr($line,0,1) != ',' ) { 
                            $t = explode(",",$line);
                        }
                        $cntr++;
                    }
                    fclose($myfile);

                    $data['file'] = $_FILES;

                    $this->load->view('common/header.php');
                    $this->load->view('common/sidebar.php');
                    $this->load->view('importScheduleCSV.php', $data);
                    $this->load->view('common/footer.php');
                }
            }
        }
    }

    public function customReport() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where);

            $where = [];
            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where);

            $data['customReportData'] = $this->client->getClientCustomReport();

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('customReport.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function sixtyDaysReport()
    {
        if(isset($_SESSION['name'])) {


            $suplid2 =  @$_POST["suplid2"];

            $temp = "CREATE TEMPORARY TABLE `temployee_clock` (
                      `patient_id` int(11) NOT NULL,
                      `date` date NOT NULL )";

            $str = $this->client->createTemporaryTable($temp);          

            $where = [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where);


            $datetrans = date("Y-m-d");
             // $datetrans = "2016-06-07";
            for ($count=1;$count<=62;$count++) {
             
               $date = strtotime(date("Y-m-d", strtotime($datetrans)) . " -".$count."days");
               if  ($count == 1) {  $todte  = date("Y-m-d",$date);     }
               if  ($count == 62) {  $fromdte  = date("Y-m-d",$date);     }

                  //echo date("Y-m-d",$date).'</br>';

                $month = date("m",$date);
                $year = date("Y",$date);
                $day = date("d",$date);
                $date = date("Y-m-d",$date);

                $where = [];
                $where['IsActive'] = 1;
                if(!empty($suplid2)) {
                    $where['supervisor_id'] = $suplid2;
                }
                $mainExec = $this->Comman_model->get_rows('patient', $where);
                 //$mainSQL = "SELECT * FROM patient  WHERE IsActive = 1 ".$condition1;
                 // echo $mainSQL;
                 //$mainExec = mysql_query($mainSQL);
                 //while($mainResult = mysql_fetch_array($mainExec)) {  

                foreach ($mainExec as $key => $mainResult) {
                
                    $ptid = $mainResult['patient_id']; 
                    $Agency = $mainResult['Agency'];
                    
                    if ($Agency == 1 || $Agency == 2)  {
                       //$usrSQL = "SELECT * FROM employee_timesheet WHERE month = '$month'  AND year = '$year' AND patient_id = '$ptid' ";

                       $where = [];
                       $where['month'] = $month;
                       $where['year'] = $year;
                       $where['patient_id'] = $ptid;
                       $usrquery = $this->Comman_model->get_rows('employee_timesheet', $where);

                       //echo $usrSQL."</br>";        
                       //$usrquery = mysql_query($usrSQL) or die (mysql_error());
                       //while ($usrrow = mysql_fetch_array($usrquery)) {
                       foreach ($usrquery as $key => $usrrow) {
                           $fld =  'day'.sprintf("%02s", $day);
                          // echo $usrrow[$fld]. $usrSQL.'</br>';
                           if ($usrrow[$fld] != 0 )    {
                                 //echo $mainResult['name'];
                                // echo $ptid." ".$Agency."</br>";
                                $dataArray = [];
                                $dataArray['patient_id'] = $ptid;
                                $dataArray['date'] = $date;
                                $insert = $this->Comman_model->insert('temployee_clock', $dataArray);

                                /*$insert = mysql_query("INSERT INTO temployee_clock (
                                            patient_id,
                                            date
                                            ) VALUES (
                                            '$ptid',
                                            '$date'
                                             
                                            ) ") or die (mysql_error());*/
                               
                           }
                       }
                    }
                    
                    if ($Agency == 2  || $Agency == 4) {
                        
                        $where = [];
                        $where['end_date>='] = $date;
                        $where['start_date<='] = $date;
                        $chkResult = $this->Comman_model->get_row('table_2weekly', $where);


                        /*$chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$date' AND start_date  <= '$date'";
                        $chkExec = mysql_query($chkSQL);
                        //check for pair
                        $chkResult = mysql_fetch_array($chkExec);*/

                        //print_r($chkResult);die;

                        $start = '';
                        $end = '';
                        if ($chkResult != 0)  {
                             $start = $chkResult['start_date'];
                             $end= $chkResult['end_date'];
                             $startdate = @$thedate;   
                             //echo $start.'</br>';
                        }    
                      

                        $where = [];
                        $where['start_date'] = $start;
                        $where['patient_id'] =  $ptid;

                        $usrquery2 = $this->Comman_model->get_rows('employee_2weekly', $where);

                       //$usrSQL2 = "SELECT * FROM employee_2weekly WHERE start_date = '$start' AND patient_id = '$ptid' ";   
                       //$usrquery2 = mysql_query($usrSQL2) or die (mysql_error());
                       //while ($usrrow2 = mysql_fetch_array($usrquery2)) {
                        foreach ($usrquery2 as $key => $usrrow2) {
                            // $fld2 =  'd'.sprintf("%02s", $day);
                            //for ($daycnt=1;$daycnt<=3;$daycnt++)  {
                            //$fld2 = (date("d",$date) - date("d",$start)) + 1;   
                            $fld2 = date("d",strtotime($start)) ;

                            //$fld =  'd'.sprintf("%02s", $fld2);
                            // echo $usrrow[$fld]. $usrSQL.'</br>';
                            $datediff = strtotime($date)  - strtotime($start) ;
                            $diff =  (floor($datediff / (60 * 60 * 24))) + 1;
                            $fld2 =  'd'.sprintf("%02s", $diff);
                            // echo $mainResult['name'].'  '.$start.' '.$fld2.' '.$date.' '.$fld2.'</br>';



                            if ($usrrow2[$fld2] != 0 )    {

                                $dataArray = [];
                                $dataArray['patient_id'] =  $ptid;
                                $dataArray['date'] = $date;

                                $insert = $this->Comman_model->insert('temployee_clock', $dataArray);

                                /*$insert = mysql_query("INSERT INTO temployee_clock (
                                patient_id,
                                date
                                ) VALUES (
                                '$ptid',
                                '$date'

                                ) ") or die (mysql_error());*/

                            }
                            //}
                       
                       }
                        
                        
                    }   
                 
                 }
             
             
               }



            $data['fromdte'] = $fromdte;

            $data['todte'] = $todte;

            $data['zeroHorData'] = $this->client->getZeroHourData($suplid2, $fromdte, $todte);

            $data['agencyData'] = $this->Comman_model->get_rows('agency');
 
            $data['suplid2'] = $suplid2;

            if(!empty($suplid2)) {
                $where = [];
                $where['supervisor_id'] = $suplid2;
                $data['supervisor'] = $this->Comman_model->get_row('supervisor', $where);
            }
            
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('sixtyDaysReport.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function PAreport()
    {
        if(isset($_SESSION['name'])) {

            $data['DistrictID_Ref2'] = @$_GET["DistrictID_Ref2"];
            $data['suplid2'] = @$_GET["suplid2"];

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where);

            $where = [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('PAreport.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function PAreportPdf() {

        $DistrictID_Ref2 = @$_GET["DistrictID_Ref2"];
        $suplid2 = @$_GET["suplid2"];
        $agency_code = $this->session->userdata('agency');

        $cnt = 0;
        $ctr = 0;
        $max  = 40;
        $spc = 40;
        $orient = 'P';
        require_once(APPPATH . 'libraries/pa-report-pdf.php'); 
        $pdf=new paReportPDF($orient, 'mm',array(215.9,279.4) );
        //$pdf=new PDF('L');

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->Comman_model->get_row('agency', $where);

        $_SESSION['AgencyName'] = $agencyData['agency_shortname'];
        /*$_SESSION['title'] = "Inactive";
        if ($IsActive == 1 )  {
          $_SESSION['title'] = "Active";
        }*/

        //array(100,150)
        $pdf->AliasNbPages();
        $pdf->AddPage($orient);

        $pdf->SetFont('Arial','',8);
        $pdf->SetLeftMargin(10);

        $result = $this->client->get_pa_report($agency_code, $suplid2, $DistrictID_Ref2);

        $pdf->setxy(10,$spc);
        $page = 0;
        $counter = 0;
        foreach ($result as $key => $row) {
            
            //echo $row["lastname"]."-----".$row["authorization"]."------".date("m/d/Y",strtotime($row["validfrom"]))."-----".date("m/d/Y",strtotime($row["validto"]))."-----"."</br>";
            
            $validfrom = $row["validfrom"];
            $validto = $row["validto"];
            $patient_auth_history_id = $row["patient_auth_history_id"];
             //  if (($paymentDate > $contractDateBegin) && ($paymentDate < $contractDateEnd))
          
            if ($validfrom == "0000-00-00" || $validfrom ==  "--"  ||  $validfrom == "" )  { 
              $validfrom = "";
            }
            if ($validto == "0000-00-00" || $validto ==  "--"  || $validto == "" )  { 
              $validto = "";
            }
          
          
            if ($cnt >= $max) {
              $page = $page + 1;
              $cnt = 0; 
              $pdf->AliasNbPages();
              $pdf->AddPage($orient);
              $pdf->setxy(10,$spc);
              
              
           }
               $counter++;   
               $staffname = $objResult['lastname'].','.$objResult['firstname'];
               $cnt = $cnt + 1;
               $pdf->Cell(32,5,$row['lastname'].', '.$row['firstname'] ,1,0,'L');       
               $pdf->Cell(25,5,$row['authorization'],1,0,'L');      
               $pdf->Cell(20,5,$validfrom,1,0,'L');         
               $pdf->Cell(20,5,$validto,1,0,'L');       
               $pdf->Cell(30,5,$row["suplastname"].", ".$row["suplastname"],1,0,'L');       
               $pdf->Cell(65,5,$row['DistrictName'],1,1,'L');       
        }
        $pdf->Output();
    }

    public function PAreportExcel() {
        date_default_timezone_set('America/Chicago');
 
        //$dbh = mysql_connect ("localhost","root","") or die('Cannot connect to the DB because: ' . mysql_error());
        //mysql_select_db ("demoivr") or die ('cannot find database' . mysql_error());

        $filename = "PA_" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $agency_code = $this->session->userdata('agency');     

        $DistrictID_Ref2 = $_GET["DistrictID_Ref2"];
        $suplid2 = $_GET["suplid2"];


        $result = $this->client->get_pa_report($agency_code, $suplid2, $DistrictID_Ref2);
        ?>
        <table>
        <tr>
        <td> Patient Name </td>
        <td> Authorization </td>
        <td> Date From  </td>
        <td> Date To </td>
        <td> Supervisor </td>
        <td> District </td>
        </tr>
        <?php 
        foreach ($result as $key => $row) {
            //echo $row["lastname"]."-----".$row["authorization"]."------".date("m/d/Y",strtotime($row["validfrom"]))."-----".date("m/d/Y",strtotime($row["validto"]))."-----"."</br>";
            
            $validfrom = $row["validfrom"];
            $validto = $row["validto"];
            $patient_auth_history_id = $row["patient_auth_history_id"];
             //  if (($paymentDate > $contractDateBegin) && ($paymentDate < $contractDateEnd))
          
            if ($validfrom == "0000-00-00" || $validfrom ==  "--"  ||  $validfrom == "" )  { 
              $validfrom = "";
            }

            if ($validto == "0000-00-00" || $validto ==  "--"  || $validto == "" )  { 
              $validto = "";
            }
          
          
            //$staffname = $objResult['lastname'].','.$objResult['firstname'];
            $cnt = $cnt + 1;
            echo "<tr> <td>".$row['lastname'].', '.$row['firstname']."</td>";       
            echo "<td>".$row['authorization']."</td>";       
            echo "<td>".$validfrom."</td>";      
            echo "<td>".$validto."</td>";        
            echo "<td>".$row["suplastname"].", ".$row["suplastname"]."</td>";        
            echo "<td>".$row['DistrictName']."</td> </tr>";      
        }
        echo "</table>";
    }

    public function idoaActivityLog()
    {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('idoaActivityLog.php');
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function idoa()
    {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('idoa.php');
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function eclaimActivityLog()
    {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('EclaimActivityLog.php');
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function eclaimIdoa()
    {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('EclaimIdoa.php');
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function Eclaim()
    {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('Eclaim.php');
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

//    public function Chat()
//     {
//     if(isset($_SESSION['name'])) 
//         {
//        $data['user']=  $this->Api_model->getAllData('users_portal');
//       $this ->load -> view('common/header.php');
//       $this ->load -> view('common/sidebar.php');
//       $this ->load ->view('chat.php',$data);
//       $this ->load -> view('common/footer.php');
//     }else{
//       redirect();
//     }
// }

   public function sendmsg()
    {

        $this->form_validation->set_rules('chat_type', 'chat_type', 'required');
        if ($this->form_validation->run() == false) {
            $this->Api_model->responseFailed(0, "Chat type not available");
            exit();
        }

        $user_id    = $this->input->post('admin_id', TRUE);
       
        // $media      = $this->input->post('media', TRUE);
        $chat_type  = $this->input->post('chat_type', TRUE);

        $send_by  = $this->input->post('send_by', TRUE);
        $userStatus = $this->Api_model->getSingleRow('admin', array(
            'id' => $user_id
        ));

         if ($userStatus) {
            if ($userStatus->status == 1) {
                if (isset($chat_type)) {
                    $data['chat_type'] = $this->input->post('chat_type', TRUE);
                } else {
                    $data['chat_type'] = '1';
                }
                
                $data['admin_id']          = $this->input->post('admin_id', TRUE);
                $data['customer_id'] = $this->input->post('customer_id', TRUE);
                $data['message']          = $this->input->post('message', TRUE);
                 $data['send_by']      = $this->input->post('send_by', TRUE);
                $data['date']             = time();
                
            
            }


                $chatId = $this->Api_model->insertGetId('chat', $data);

                if ($chatId) { redirect('Admin/Chat');

                }
                  
                    }
                      
                
                else {
                      redirect('Admin/Chat');
                    // $this->Api_model->responseFailed(0, TRY_AGAIN);
                }
           }

    public function addStudent()
    {
        if (isset($_SESSION['name'])) {
            $parent_id       = $this->uri->segment(3);
            $where           = array(
                'parent_id' => $parent_id
            );
            $data['parent']  = $this->Api_model->getSingleRow('parent', $where);
            $data['student'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'student');
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['session'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'session');
            $data['page']    = 'addstudent';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('addstudent.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_student()
    {
        if (isset($_SESSION['name'])) {
            $this->form_validation->set_rules('student_num', 'Student Number', 'required');
            $this->form_validation->set_rules('first_name', 'First Name', 'required'); //callback_customAlpha
            $this->form_validation->set_rules('last_name', 'Last Name', 'required');
            $this->form_validation->set_rules('gender', 'Gender', 'required');
            $this->form_validation->set_rules('date_of_birth', 'Date Of Birth', 'required');
            $this->form_validation->set_rules('class_id', 'Class', 'required');
            $this->form_validation->set_rules('session_id', 'Session', 'required');
            $this->form_validation->set_rules('email', 'Email', 'required');
            $this->form_validation->set_rules('local_guardian_name', 'Local Guardian Name', 'required');
            $this->form_validation->set_rules('local_guardian_address', 'Local Guardian Address', 'required');
            $this->form_validation->set_rules('local_guardian_phone', 'Local Guardian Phone', 'required');
            $this->form_validation->set_rules('local_guardian_email', 'Local Guardian Email', 'required');
            $this->form_validation->set_rules('country_code', 'country_code', 'required');
            
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'addstuent';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('addstudent.php', $data);
                $this->load->view('common/footer.php');
            } else {
                $data['student_num']            = $this->input->post('student_num');
                $data['first_name']             = $this->input->post('first_name');
                $data['middle_name']            = $this->input->post('middle_name');
                $data['last_name']              = $this->input->post('last_name');
                $data['gender']                 = $this->input->post('gender');
                $data['country_code']           = $this->input->post('country_code');
                $data['date_of_birth']          = $this->input->post('date_of_birth');
                $data['class_id']               = $this->input->post('class_id');
                $data['session_id']             = $this->input->post('session_id');
                $data['email']                  = $this->input->post('email');
                $data['local_guardian_name']    = $this->input->post('local_guardian_name');
                $data['local_guardian_address'] = $this->input->post('local_guardian_address');
                $data['local_guardian_phone']   = $this->input->post('local_guardian_phone');
                $data['local_guardian_email']   = $this->input->post('local_guardian_email');
                $data['parent_id']              = $this->input->post('parent_id');
                $data['image']                  = $this->input->post('image');
                $data['create_date']            = time();
                $data['update_date']            = time();
                $data['status']                 = 1;
                $config['upload_path']          = './assets/images/student/';
                $config['allowed_types']        = 'gif|jpg|jpeg|png';
                $config['max_size']             = 10000;
                $config['file_name']            = time();
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                $image = "";
                if ($this->upload->do_upload('image')) {
                    $image         = './assets/images/student/' . $this->upload->data('file_name');
                    $data['image'] = $image;
                } else {
                    echo "image is not inserted";
                    // $error = $this->upload->display_errors();
                    // print_r($error);
                    
                }
                // $error = $this->upload->display_errors();
                //         print_r($error);
                $data['student'] = $this->Api_model->insert('student', $data);

                
                if (isset($data['student'])) {
                    $student = $this->Api_model->getStudentLimitOne();
                    
                    // print_r($student[0]->student_id);
                    
                    if (isset($student)) {
                        $student_id                  = $student[0]->student_id;
                        $form_data                   = array(
                            'session_id' => $this->input->post('session_id'),
                            'student_id' => $student[0]->student_id,
                            'class_id' => $this->input->post('class_id')
                        );
                        $data['student_session_map'] = $this->Api_model->insert('student_session_map', $form_data);
                        $this->session->set_flashdata('msg1', 'Student added Successfully');

                        redirect('Admin/studentlist');
                    } else {
                        echo "data  is not inserted";
                        
                    }
                    
                    redirect('Admin/studentlist');
                } else {
                    echo "student data  is not inserted";
                }
            }
        } else {
            redirect('Admin/index');
        }
    }
    public function updateClass()
    {
        if (isset($_SESSION['name'])) {
            
            $student_id                  = $this->uri->segment(3);
            $where                       = array(
                'student_id' => $student_id
            );
            $data['student']             = $this->Api_model->getSingleRow('student', $where);
            $data['class']               = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['student_session_map'] = $this->Api_model->GetSsc();
            $data['session']             = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'session');
            
            $data['page'] = 'updateClass';
            
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_student_class.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
        
    }
    public function update_student_class_action()
    {
        if (isset($_SESSION['name'])) {
            $student_id       = $this->input->post('student_id');
            $data['class_id'] = $this->input->post('class_id');
            $where            = array(
                'student_id' => $student_id
            );
            $student          = $this->Api_model->updateSingleRow('student', $where, $data);


            if (isset($student)) {
                $studentt                    = $this->Api_model->getSingleRow('student_session_map', $where, $data);
                // print_r($studentt->session_id);
                // exit();
                $form_data                   = array(
                    'session_id' => $studentt->session_id,
                    'student_id' => $this->input->post('student_id'),
                    'class_id' => $this->input->post('class_id')
                );
                $data['student_session_map'] = $this->Api_model->insert('student_session_map', $form_data);
                 $this->session->set_flashdata('msg3', 'Student Class updated Successfully');
                
            } else {
                echo "student Class is not Update";
            }
            redirect('Admin/studentlist');
        } else {
            redirect('Admin/login');
        }
    }
    public function updateSession()
    {
        if (isset($_SESSION['name'])) {
            
            $student_id                  = $this->uri->segment(3);
            $where                       = array(
                'student_id' => $student_id
            );
            $data['student']             = $this->Api_model->getSingleRow('student', $where);
            $data['class']               = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['student_session_map'] = $this->Api_model->GetSsc();
            $data['session']             = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'session');
            
            $data['page'] = 'updateSession';
            
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_student_session.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
        
    }
    public function update_student_session_action()
    {
        if (isset($_SESSION['name'])) {
            $student_id         = $this->input->post('student_id');
            $data['class_id']   = $this->input->post('class_id');
            $data['session_id'] = $this->input->post('session_id');
            $where              = array(
                'student_id' => $student_id
            );
            $student            = $this->Api_model->updateSingleRow('student', $where, $data);
            
            if (isset($student)) {
                $studentt                    = $this->Api_model->getSingleRow('student_session_map', $where, $data);
                // print_r($studentt->session_id);
                // exit();
                $form_data                   = array(
                    'session_id' => $this->input->post('session_id'),
                    'student_id' => $this->input->post('student_id'),
                    'class_id' => $this->input->post('class_id')
                );
                $data['student_session_map'] = $this->Api_model->insert('student_session_map', $form_data);
                $this->session->set_flashdata('msg4', 'Student session updated Successfully');
                
            } else {
                echo "student Class is not Update";
            }
            redirect('Admin/studentlist');
        } else {
            redirect('Admin/login');
        }
    }
    
    
    public function Student_session_list()
    {
        if (isset($_SESSION['name'])) {
            // $getdata   = $this->Api_model->getAllDataWhere(array(
            //     'status' => 1
            // ), 'student_session_map');
            $getdata = $this->Api_model->GetSsc();
            
            $data['student_session_data'] = $getdata;
            $data['page']                 = 'student_session_list';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('student_session_map_list.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function change_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('student_session_map', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('student_session_map', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('student_session_map', array(
                'id' => $id
            ));
            
            redirect('Admin/Student_session_list');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('student_session_map', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('student_session_map', array(
                'id' => $id
            ));
            
            redirect('Admin/Student_session_list');
        }
    }
    public function updateSessionData()
    {
        if (isset($_SESSION['name'])) {
            
            $id              = $this->uri->segment(3);
            $where           = array(
                'id' => $id
            );
            $data['student'] = $this->Api_model->getSingleRow('student_session_map', $where);
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['session'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'session');
            
            $data['page'] = 'updateSessionData';
            
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_session_data.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
        
    }
    public function update_session_data_action()
    {
        if (isset($_SESSION['name'])) {
            $id                 = $this->input->post('id');
            // $data['student_num']         =   $this->input->post('student_num');
            $data['class_id']   = $this->input->post('class_id');
            $data['session_id'] = $this->input->post('session_id');
            $where              = array(
                'id' => $id
            );
            $update=$this->Api_model->updateSingleRow('student_session_map', $where, $data);
            if (isset($update)) {
            $data = $this->Api_model->getSingleRow('student_session_map', $where);
            if($data)
            {   
            $where              = array(
                'student_id' => $data->student_id,
                );
               $form_data           = array(
                    'session_id' => $data->session_id,
                    'class_id' => $data->class_id
                );
          $this->Api_model->updateSingleRow('student',$where,$form_data);   
          redirect('Admin/Student_session_list');
            }
         }

        } else {
            redirect('Admin/login');
        }
    }
    public function updateClassData()
    {
        if (isset($_SESSION['name'])) {
            
            $id              = $this->uri->segment(3);
            $where           = array(
                'id' => $id
            );
            $data['student'] = $this->Api_model->getSingleRow('student_session_map', $where);
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['page']    = 'updateClassData';
            
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_class_data.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
        
    }
    public function update_class_data_action()
    {
        if (isset($_SESSION['name'])) {
            $id               = $this->input->post('id');
            // $data['student_num']         =   $this->input->post('student_num');
            $data['class_id'] = $this->input->post('class_id');
            $where            = array(
                'id' => $id
            );
           $update= $this->Api_model->updateSingleRow('student_session_map', $where, $data);
            if (isset($update)) {
            $data = $this->Api_model->getSingleRow('student_session_map', $where);
            if($data)
            {   
            $where              = array(
                'student_id' => $data->student_id,
                );
               $form_data           = array(
                    'class_id' => $data->class_id
                );
          $this->Api_model->updateSingleRow('student',$where,$form_data);   
          redirect('Admin/Student_session_list');
            }
         }

            // $error = $this->upload->display_errors();
            //         print_r($error);
            //         exit();
            redirect('Admin/Student_session_list');
        } else {
            redirect('Admin/login');
        }
    }
    ##############################################################################################
    
    
    /*
    User list
    */
    public function studentlist()
    {
        if (isset($_SESSION['name'])) {
            $where          = array(
                'parent.status' => 1
            );
            $data['parent'] = $this->Api_model->GetStudent();
            $data['page']   = 'studentlist';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('studentlist.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    
    public function updatestudent()
    {
        if (isset($_SESSION['name'])) {
            
            $student_id      = $this->uri->segment(3);
            $where           = array(
                'student_id' => $student_id
            );
            $data['student'] = $this->Api_model->getSingleRow('student', $where);
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['session'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'session');
            
            $data['page'] = 'addstudent';
            
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_student.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
        
    }
    public function update_student_action()
    {
        if (isset($_SESSION['name'])) {
            $student_id                     = $this->input->post('student_id');
            // $data['student_num']         =   $this->input->post('student_num');
            $data['first_name']             = $this->input->post('first_name');
            $data['middle_name']            = $this->input->post('middle_name');
            $data['last_name']              = $this->input->post('last_name');
            $data['gender']                 = $this->input->post('gender');
            $data['country_code']           = $this->input->post('country_code');
            $data['date_of_birth']          = $this->input->post('date_of_birth');
            $data['class_id']               = $this->input->post('class_id');
            $data['session_id']             = $this->input->post('session_id');
            $data['email']                  = $this->input->post('email');
            $data['local_guardian_name']    = $this->input->post('local_guardian_name');
            $data['local_guardian_address'] = $this->input->post('local_guardian_address');
            $data['local_guardian_phone']   = $this->input->post('local_guardian_phone');
            $data['local_guardian_email']   = $this->input->post('local_guardian_email');

            if ($_FILES['image']['name'] != "") {
                $config['upload_path']   = './assets/images/student/';
                $config['allowed_types'] = 'gif|jpg|jpeg|png';
                $config['max_size']      = 10000;
                $config['file_name']     = time();
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                $studentimage = "";
                if ($this->upload->do_upload('image')) {
                    $studentimage  = './assets/images/student/' . $this->upload->data('file_name');
                    $data['image'] = $studentimage;
                } else {
                    echo "image is not inserted";
                }
            }
            $where = array(
                'student_id' => $student_id
            );
            $this->Api_model->updateSingleRow('student', $where, $data);
             $this->session->set_flashdata('msg2', 'Student updated Successfully');
           
            redirect('Admin/studentlist');
        } else {
            redirect('Admin/login');
        }
    }
    public function change_student_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'student_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('student', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('student', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('student', array(
                'student_id' => $id
            ));
            
            redirect('Admin/studentlist');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('student', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('student', array(
                'student_id' => $id
            ));
            
            redirect('Admin/studentlist');
        }
    }
    // public function deletestudent()
    // {
    //     $id = $this->uri->segment('3');
    //     $this->Api_model->deleteRecord(array(
    //         'student_id' => $id
    //     ), 'student');
    //     redirect('Admin/studentlist');
    // }
    #########################################################################
    public function addClass()
    {
        if (isset($_SESSION['name'])) {
            $data['get_class'] = $this->Api_model->getAllData('class');
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('addclass.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_class_action()
    {
        if (isset($_SESSION['name'])) {
            $datas['get_class'] = $this->Api_model->getAllData('class');
            // print_r($datas['get_class']);
            // exit();
            $this->form_validation->set_rules('class_name', 'Class Name', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Class';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('addclass.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['class_name']  = $this->input->post('class_name');
                // $data['section'] = $this->input->post('section');
                $data['create_date'] = time();
                $data['update_date'] = time();
                $this->Api_model->insert('class', $data);
                $this->session->set_flashdata('msg2', 'Class Added Successfully');

                redirect('Admin/addClass');
            }
        } else {
            redirect();
        }
    }
    
    public function change_class_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'class_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('class', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('class', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('class', array(
                'class_id' => $id
            ));
            
            redirect('Admin/addClass');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('class', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('class', array(
                'class_id' => $id
            ));
            
            redirect('Admin/addClass');
        }
    }
    public function update_class_action()
    {
        if (isset($_SESSION['name'])) {
            $class_id           = $this->input->post('id');
            $data['class_name'] = $this->input->post('class_name');
            // $data['section'] = $this->input->post('section');
            $where              = array(
                'class_id' => $class_id
            );
            $this->Api_model->updateSingleRow('class', $where, $data);
              $this->session->set_flashdata('msg1', 'Class updated Successfully');
            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/addClass');
        } else {
            redirect('Admin/login');
        }
    }



     public function Chat()
    {
        if (isset($_SESSION['name'])) {
            // $student_id=$this->uri->segment(3);
            // $where = array('student_id'=>$student_id);
            // $data['student']=$this->Api_model->getSingleRow('student',$where);
            $data['user']=$this->Api_model->getAllDataWhere(array('status'=>1),'users_portal');
            $data['page'] = 'addparent';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('chat.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    ####################################################################################
    public function addparent()
    {
        if (isset($_SESSION['name'])) {
            // $student_id=$this->uri->segment(3);
            // $where = array('student_id'=>$student_id);
            // $data['student']=$this->Api_model->getSingleRow('student',$where);
            // $data['parent']=$this->Api_model->getAllDataWhere(array('status'=>1),'parent');
            $data['page'] = 'addparent';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('add_parent.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_parent()
    {
        if (isset($_SESSION['name'])) {
            //$this->form_validation->set_rules('parent_number', 'Parent Number', 'required');
            $this->form_validation->set_rules('father_name', 'Father Name', 'required'); //callback_customAlpha
            $this->form_validation->set_rules('mother_name', 'Mother Name', 'required');
            $this->form_validation->set_rules('local_address', 'Local Addres', 'required');
            $this->form_validation->set_rules('permanent_address', 'Permanent Address ', 'required');
            $this->form_validation->set_rules('email', 'Email', 'required');
            $this->form_validation->set_rules('password', 'Password', 'required');
            $this->form_validation->set_rules('primary_phone_num', 'Primary Phone Number ', 'required');
            $this->form_validation->set_rules('secondary_phone_num', 'Secondary Phone Number', 'required');
            $this->form_validation->set_rules('country_code', 'country_code', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'addparent';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('add_parent.php', $data);
                $this->load->view('common/footer.php');
            } else {
                $data['parent_number']       = time();
                $data['father_name']         = $this->input->post('father_name');
                $data['mother_name']         = $this->input->post('mother_name');
                $data['local_address']       = $this->input->post('local_address');
                $data['email']               = $this->input->post('email');
                $data['password']            = $this->input->post('password');
                $data['permanent_address']   = $this->input->post('permanent_address');
                $data['primary_phone_num']   = $this->input->post('primary_phone_num');
                $data['secondary_phone_num'] = $this->input->post('secondary_phone_num');
                $data['country_code']        = $this->input->post('country_code');
                $data['create_date']         = time();
                $data['update_date']         = time();
                $data['image']               = $this->input->post('image');
                $data['status']              = 1;
                $config['upload_path']       = './assets/images/parent/';
                $config['allowed_types']     = 'gif|jpg|jpeg|png';
                $config['max_size']          = 10000;
                $config['file_name']         = time();
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                $image = "";
                if ($this->upload->do_upload('image')) {
                    $image         = './assets/images/parent/' . $this->upload->data('file_name');
                    $data['image'] = $image;
                } else {
                    echo "image is not inserted";
                }
                $this->Api_model->insert('parent', $data);
                $this->session->set_flashdata('msg1', 'parent added Successfully');
                redirect('Admin/parentlist');
            }
        } else {
            redirect('Admin/index');
        }
    }
    /*
    User list
    */
    public function parentlist()
    {
        if (isset($_SESSION['name'])) {
            $get_parent     = $this->Api_model->getAllData('parent');
            $data['student'] = $get_parent;
            $data['page']    = 'parentlist';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('parentlist.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function updateparent()
    {
        if (isset($_SESSION['name'])) {
            $student_id     = $this->uri->segment(3);
            $where          = array(
                'parent_id' => $student_id
            );
            $data['parent'] = $this->Api_model->getSingleRow('parent', $where);
            // $data['parent']=$this->Api_model->getAllDataWhere(array('status'=>1),'parent');
            $data['page']   = 'addperent';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_parent.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function update_parent_action()
    {
        if (isset($_SESSION['name'])) {
            $parent_id                   = $this->input->post('parent_id');
            $data['father_name']         = $this->input->post('father_name');
            $data['mother_name']         = $this->input->post('mother_name');
            $data['local_address']       = $this->input->post('local_address');
            $data['permanent_address']   = $this->input->post('permanent_address');
            $data['email']               = $this->input->post('email');
            $data['password']            = $this->input->post('password');
            $data['primary_phone_num']   = $this->input->post('primary_phone_num');
            $data['secondary_phone_num'] = $this->input->post('secondary_phone_num');
            $data['country_code']        = $this->input->post('country_code');
            $data['update_date']         = time();
            // $data['student_id'] = $this->input->post('student_id');
            if ($_FILES['image']['name'] != "") {
                $config['upload_path']   = './assets/images/parent/';
                $config['allowed_types'] = 'gif|jpg|jpeg|png';
                $config['max_size']      = 10000;
                $config['file_name']     = time();
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                $productsimage = "";
                if ($this->upload->do_upload('image')) {
                    $productsimage = './assets/images/parent/' . $this->upload->data('file_name');
                    $data['image'] = $productsimage;
                } else {
                    echo "image is not inserted";
                }
            }
            $where = array(
                'parent_id' => $parent_id
            );
            $this->Api_model->updateSingleRow('parent', $where, $data);
            $this->session->set_flashdata('msg2', 'updated Successfully');
            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/parentlist');
        } else {
            redirect('Admin/login');
        }
    }
     public function change_parent_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'parent_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('parent', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('parent', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('parent', array(
                'parent_id' => $id
            ));
            
            redirect('Admin/parentlist');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('parent', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('parent', array(
                'parent_id' => $id
            ));
            
            redirect('Admin/parentlist');
        }
    }
    // public function deleteparent()
    // {
    //     $id = $this->uri->segment('3');
    //     $this->Api_model->deleteRecord(array(
    //         'parent_id' => $id
    //     ), 'parent');
    //     redirect('Admin/parentlist');
    // }
    #########################################################################
    public function addClassStaff()
    {
        if (isset($_SESSION['name'])) {
            $data['staff'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['class'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['page']  = 'addClassStaff';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('add_staff_class.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_class_staff_action()
    {
        if (isset($_SESSION['name'])) {
            $data['staff_id']   = $this->input->post('staff_id');
            $data['class_id']   = $this->input->post('class_id');
            $data['status']     = 1;
            $data['created_at'] = time();
            $staff_id = $data['staff_id'];
            $class_id =  $data['class_id']; 
               	
                $datas=$this->Api_model->getDataByTwoFields($staff_id,$class_id);
              
                if(!$datas)
                {
                $this->Api_model->insert('staff_class', $data);
                $this->session->set_flashdata('msg2', 'Successfully adedd');
                redirect('Admin/ClassStaffList');
                }
                else{
                 $this->session->set_flashdata('msg1', 'data is already Uploaded.');
                  redirect('Admin/ClassStaffList');

                }
            }
             else {
            redirect('Admin/index');
        }
    }
    /*
    User list
    */
    public function ClassStaffList()
    {
        if (isset($_SESSION['name'])) {
            $get_data      = $this->Api_model->getDataStaffClass('staff_class');
            $data['staff'] = $get_data;
            // print_r($data['staff']);
            // exit();
            $data['page']  = 'ClassStaffList';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('staff_class_list.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function UpdateStaffClass()
    {
        if (isset($_SESSION['name'])) {
            $staff_class_id      = $this->uri->segment(3);
            $where               = array(
                'staff_class_id' => $staff_class_id
            );
            $data['staff_class'] = $this->Api_model->getSingleRow('staff_class', $where);
            $data['class']       = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['staff']       = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['page']        = 'UpdateClassStaff';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_staff_class.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function update_class_staff_action()
    {
        if (isset($_SESSION['name'])) {
            $staff_class_id   = $this->input->post('staff_class_id');
            $data['staff_id'] = $this->input->post('staff_id');
            $data['class_id'] = $this->input->post('class_id');
            $data['status']   = 1;
            $where            = array(
                'staff_class_id' => $staff_class_id
            );
            $this->Api_model->updateSingleRow('staff_class', $where, $data);
            redirect('Admin/ClassStaffList');
        } else {
            redirect('Admin/login');
        }
    }
    public function change_staff_class_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'staff_class_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('staff_class', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('staff_class', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('staff_class', array(
                'staff_class_id' => $id
            ));
            
            redirect('Admin/ClassStaffList');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('staff_class', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('staff_class', array(
                'staff_class_id' => $id
            ));
            
            redirect('Admin/ClassStaffList');
        }
    }
    #########################################################################
    public function addStaffRole()
    {
        if (isset($_SESSION['name'])) {
            $data['get_staff_role'] = $this->Api_model->getAllData('role');
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('add_staff_role.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_staff_role_action()
    {
        if (isset($_SESSION['name'])) {
            $datas['get_staff_role'] = $this->Api_model->getAllData('role');
            $this->form_validation->set_rules('role', 'Staff Role', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Saff Role';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('addclass.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['role']        = $this->input->post('role');
                $data['create_date'] = time();
                $data['update_date'] = time();
                $this->Api_model->insert('role', $data);
                $this->session->set_flashdata('msg1', 'Staff role added successfully');
                redirect('Admin/addStaffRole');
            }
        } else {
            redirect();
        }
    }
    public function change_staff_role_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'role_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('role', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('role', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('role', array(
                'role_id' => $id
            ));
            
            redirect('Admin/addStaffRole');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('role', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('role', array(
                'role_id' => $id
            ));
            
            redirect('Admin/addStaffRole');
        }
    }
    public function update_staff_role_action()
    {
        if (isset($_SESSION['name'])) {
            $staff_role_id = $this->input->post('id');
            $data['role']  = $this->input->post('role');
            $where         = array(
                'role_id' => $staff_role_id
            );
            $this->Api_model->updateSingleRow('role', $where, $data);
            $this->session->set_flashdata('msg2', 'Staff role updated successfully');
              
            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/addStaffRole');
        } else {
            redirect('Admin/login');
        }
    }
    ###############################################################################
    public function addStaffPosition()
    {
        if (isset($_SESSION['name'])) {
            $data['get_staff_position'] = $this->Api_model->getAllData('staff_position');
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('add_staff_position.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_staff_position_action()
    {
        if (isset($_SESSION['name'])) {
            $datas['get_staff_role'] = $this->Api_model->getAllData('staff_position');
            $this->form_validation->set_rules('staff_position_name', 'Staff Position', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Saff Position';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('add_staff_position.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['staff_position_name'] = $this->input->post('staff_position_name');
                $data['create_date']         = date('Y-m-d H:i:s');
                $data['update_date']         = date('Y-m-d H:i:s');
                $this->Api_model->insert('staff_position', $data);
                $this->session->set_flashdata('msg1', 'Successfully adedd');

                redirect('Admin/addStaffPosition');
            }
        } else {
            redirect();
        }
    }
    public function change_staff_position_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'staff_position_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('staff_position', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('staff_position', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('staff_position', array(
                'staff_position_id' => $id
            ));
            
            redirect('Admin/addStaffPosition');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('staff_position', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('staff_position', array(
                'staff_position_id' => $id
            ));
            
            redirect('Admin/addStaffPosition');
        }
    }
    public function update_staff_position_action()
    {
        if (isset($_SESSION['name'])) {
            $staff_position_id           = $this->input->post('id');
            $data['staff_position_name'] = $this->input->post('staff_position_name');
            $where                       = array(
                'staff_position_id' => $staff_position_id
            );
            $this->Api_model->updateSingleRow('staff_position', $where, $data);
            $this->session->set_flashdata('msg2', 'Successfully updated');

            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/addStaffPosition');
        } else {
            redirect('Admin/login');
        }
    }
    ################################################################################
    public function addSubject()
    {
        if (isset($_SESSION['name'])) {
            $data['get_subject'] = $this->Api_model->getAllData('subject');
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('addsubject.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_subject_action()
    {
        if (isset($_SESSION['name'])) {
            $datas['get_subject'] = $this->Api_model->getAllData('subject');
            $this->form_validation->set_rules('subject_name', 'Subject Name', 'required');
            $this->form_validation->set_rules('subject_code', 'Subject Code', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Subject';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('addsubject.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['subject_name'] = $this->input->post('subject_name');
                $data['subject_code'] = $this->input->post('subject_code');
                $data['create_date']  = time();
                $data['update_date']  = time();
                $subject_name = $data['subject_name'];
                $subject_code =  $data['subject_code']; 
                
                $datas=$this->Api_model->getDataBy2Field($subject_name,$subject_code);
              
                if(!$datas)
                {
                $this->Api_model->insert('subject', $data);
                $this->session->set_flashdata('msg1', 'Subject added Successfully');
                redirect('Admin/addSubject');
                }
                else{
                 $this->session->set_flashdata('msg', 'Subjcet is already Uploaded.');
                  redirect('Admin/addSubject');

                }
            }
        } else {
            redirect();
        }
    }
    
    public function update_subject_action()
    {
        if (isset($_SESSION['name'])) {
            $subject_id           = $this->input->post('id');
            $data['subject_name'] = $this->input->post('subject_name');
            $data['subject_code'] = $this->input->post('subject_code');
            $where                = array(
                'subject_id' => $subject_id
            );
            $this->Api_model->updateSingleRow('subject', $where, $data);
             $this->session->set_flashdata('msg2', 'Subject updated Successfully');

            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/addSubject');
        } else {
            redirect('Admin/login');
        }
    }
    
    public function change_subject_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'subject_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('subject', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('subject', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('subject', array(
                'subject_id' => $id
            ));
            
            redirect('Admin/addSubject');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('subject', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('subject', array(
                'subject_id' => $id
            ));
            
            redirect('Admin/addSubject');
        }
    }
    ################################################################################
    public function addClassSubject()
    {
        if (isset($_SESSION['name'])) {
            $data['class']             = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['subject']           = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            // $data['class_subject_combination'] = $this->Api_model->getAllDataWhere(array('status' => 1), 'class_subject_combination');
            $data['get_class_subject'] = $this->Api_model->getDataBy3Table();
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('add_class_subject.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_class_subject_action()
    {
        if (isset($_SESSION['name'])) {
            $datas['class']                     = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $datas['subject']                   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            $datas['class_subject_combination'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class_subject_combination');
            $datas['get_class_subject']         = $this->Api_model->getDataBy3Table();
            $this->form_validation->set_rules('class_id', 'Class Name', 'required');
            $this->form_validation->set_rules('subject_id', 'Subject Name', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Class Subject';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('add_class_subject.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['class_id']    = $this->input->post('class_id');
                $data['subject_id']  = $this->input->post('subject_id');
                $data['create_date'] = time();
                $data['update_date'] = time();
                $data['status']      = 1;
                $class_id = $data['class_id'];
                $subject_id =  $data['subject_id']; 
               	
                $datas=$this->Api_model->getDataByTwoField($class_id,$subject_id);
              
                if(!$datas)
                {
                $this->Api_model->insert('class_subject_combination', $data);
                $this->session->set_flashdata('msg2', 'Successfully adedd');
                redirect('Admin/addClassSubject');
                }
                else{

                // echo "<script>alert('data is already Uploaded');
                //   window.location.href='addClassSubject'; 
                //    </script>";  
                 $this->session->set_flashdata('msg1', 'data is already Uploaded.');
                  redirect('Admin/addClassSubject');

                }

            }
        } else {
            redirect();
        }
    }

    
    
    public function change_class_subject_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            's_c_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('class_subject_combination', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('class_subject_combination', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('class_subject_combination', array(
                's_c_id' => $id
            ));
            
            redirect('Admin/addClassSubject');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('class_subject_combination', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('class_subject_combination', array(
                's_c_id' => $id
            ));
            
            redirect('Admin/addClassSubject');
        }
    }
    public function updateClassSubject()
    {
        if (isset($_SESSION['name'])) {
            $s_c_id          = $this->uri->segment(3);
            $where           = array(
                's_c_id' => $s_c_id
            );
            $data['csc']     = $this->Api_model->getSingleRow('class_subject_combination', $where);
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['subject'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            $data['page']    = 'updateClassSuject';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_class_subject.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function update_class_subject_action()
    {
        if (isset($_SESSION['name'])) {
            $s_c_id             = $this->input->post('s_c_id');
            $data['class_id']   = $this->input->post('class_id');
            $data['subject_id'] = $this->input->post('subject_id');
            $where              = array(
                's_c_id' => $s_c_id
            );
            $this->Api_model->updateSingleRow('class_subject_combination', $where, $data);
            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/addClassSubject');
        } else {
            redirect('Admin/login');
        }
    }
    // ####################################################################################
    public function addSession()
    {
        if (isset($_SESSION['name'])) {
            $data['get_session'] = $this->Api_model->getAllData('session');
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('add_session.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_session_action()
    {
        if (isset($_SESSION['name'])) {
            $datas['get_session'] = $this->Api_model->getAllData('session');
            $this->form_validation->set_rules('start_year', 'Start Year', 'required');
            $this->form_validation->set_rules('end_year', 'End Year', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Session';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('add_session.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['start_year'] = $this->input->post('start_year');
                $data['end_year']   = $this->input->post('end_year');
                $data['created_at'] = time();
                $data['status']     = 1;
                $start_year = $data['start_year'];
                $end_year =  $data['end_year']; 
               	
                $datas=$this->Api_model->getDataByTwoFieldd($start_year,$end_year);
              
                if(!$datas)
                {
                $this->Api_model->insert('session', $data);
                $this->session->set_flashdata('msg2', 'Successfully adedd');
                redirect('Admin/addSession');
                }
                else{

                // echo "<script>alert('data is already Uploaded');
                //   window.location.href='addClassSubject'; 
                //    </script>";  
                 $this->session->set_flashdata('msg1', 'data is already Uploaded.');
                  redirect('Admin/addSession');

                }
            }
        } else {
            redirect();
        }
    }
    
    // public function update_session_action()
    // {
    //     if (isset($_SESSION['name'])) {
    //         $session_id         = $this->input->post('id');
    //         $data['start_year'] = $this->input->post('start_year');
    //         $data['end_year']   = $this->input->post('end_year');
    //         $where              = array(
    //             'session_id' => $session_id
    //         );
    //         $this->Api_model->updateSingleRow('session', $where, $data);
    //         // $this->Api_model->updateSingleRow('breed',$where, $data);
    //         redirect('Admin/addSession');
    //     } else {
    //         redirect('Admin/login');
    //     }
    // }
    public function updateSessionList()
    {
        if (isset($_SESSION['name'])) {
            $session_id   = $this->uri->segment(3);
            $where           = array(
                'session_id' => $session_id
            );
            $data['session']     = $this->Api_model->getSingleRow('session', $where);
            // print_r($data['session']);
            // exit();
            $data['page']    = 'updateSessionList';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_session_list.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function update_session_list_action()
    {
        if (isset($_SESSION['name'])) {
            $session_id   = $this->input->post('session_id');
           $data['start_year'] = $this->input->post('start_year');
           $data['end_year']   = $this->input->post('end_year');
            $where              = array(
                'session_id' => $session_id
            );
            $this->Api_model->updateSingleRow('session', $where, $data);
            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/addSession');
        } else {
            redirect('Admin/login');
        }
    }
    public function change_session_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'session_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('session', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('session', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('session', array(
                'session_id' => $id
            ));
            
            redirect('Admin/addSession');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('session', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('session', array(
                'session_id' => $id
            ));
            
            redirect('Admin/addSession');
        }
    }
    // ####################################################################################
    public function addstaff()
    {
        if (isset($_SESSION['name'])) {
            $data['staff']          = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['staff_role']     = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'role');
            $data['staff_position'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff_position');
            $data['page']           = 'addstaff';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('add_staff.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_staff()
    {
        if (isset($_SESSION['name'])) {
            $data['staff_number']        = $this->input->post('staff_number');
            $data['staff_role']          = $this->input->post('staff_role');
            $data['staff_position']      = $this->input->post('staff_position');
            $data['title']               = $this->input->post('title');
            $data['first_name']          = $this->input->post('first_name');
            $data['middle_name']         = $this->input->post('middle_name');
            $data['last_name']           = $this->input->post('last_name');
            $data['gender']              = $this->input->post('gender');
            $data['date_of_birth']       = $this->input->post('date_of_birth');
            $data['local_address']       = $this->input->post('local_address');
            $data['permanent_address']   = $this->input->post('permanent_address');
            $data['email']               = $this->input->post('email');
            $data['password']            = $this->input->post('password');
            $data['primary_phone_num']   = $this->input->post('primary_phone_num');
            $data['secondary_phone_num'] = $this->input->post('secondary_phone_num');
            $data['city']                = $this->input->post('city');
            $data['state']               = $this->input->post('state');
            $data['qualifications']      = $this->input->post('qualifications');
            // $image              =          $this->input->post('image');
            $data['country_code']        = $this->input->post('country_code');
            $data['status']              = 1;
            $config['upload_path']       = './assets/images/staff/';
            $config['allowed_types']     = 'gif|jpg|jpeg|png';
            $config['max_size']          = 10000;
            $config['file_name']         = time();
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $image = "";
            if ($this->upload->do_upload('image')) {
                $image         = './assets/images/staff/' . $this->upload->data('file_name');
                $data['image'] = $image;
            } else {
                echo "image is not inserted";
            }
            $this->Api_model->insert('staff', $data);
            $this->session->set_flashdata('msg1', 'Staff added Successfully');
            redirect('Admin/stafflist');
        } else {
            redirect('Admin/index');
        }
    }
    public function change_staff_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'staff_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('staff', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('staff', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('staff', array(
                'staff_id' => $id
            ));
            
            redirect('Admin/stafflist');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('staff', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('staff', array(
                'staff_id' => $id
            ));
            
            redirect('Admin/stafflist');
        }
    }
    /*
    User list
    */
    public function stafflist()
    {
        if (isset($_SESSION['name'])) {
            $getstaff      = $this->Api_model->getAllData('staff');
            $data['staff'] = $getstaff;
            $data['page']  = 'stafflist';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('stafflist.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function updatestaff()
    {
        if (isset($_SESSION['name'])) {
            $staff_id               = $this->uri->segment(3);
            $where                  = array(
                'staff_id' => $staff_id
            );
            $data['staff']          = $this->Api_model->getSingleRow('staff', $where);
            $data['staff_role']     = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'role');
            $data['staff_position'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff_position');
            $data['page']           = 'addstaff';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_staff.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function update_staff_action()
    {
        if (isset($_SESSION['name'])) {
            $staff_id                    = $this->input->post('staff_id');
            //$data['staff_number']  =   $this->input->post('staff_number');
            $data['staff_role']          = $this->input->post('staff_role');
            $data['staff_position']      = $this->input->post('staff_position');
            $data['title']               = $this->input->post('title');
            $data['first_name']          = $this->input->post('first_name');
            $data['middle_name']         = $this->input->post('middle_name');
            $data['last_name']           = $this->input->post('last_name');
            $data['gender']              = $this->input->post('gender');
            $data['date_of_birth']       = $this->input->post('date_of_birth');
            $data['local_address']       = $this->input->post('local_address');
            $data['permanent_address']   = $this->input->post('permanent_address');
            $data['email']               = $this->input->post('email');
            $data['password']            = $this->input->post('password');
            $data['primary_phone_num']   = $this->input->post('primary_phone_num');
            $data['secondary_phone_num'] = $this->input->post('secondary_phone_num');
            $data['city']                = $this->input->post('city');
            $data['state']               = $this->input->post('state');
            $data['qualifications']      = $this->input->post('qualifications');
            $data['country_code']        = $this->input->post('country_code');

            // $data['image']       =   $this->input->post('image');
            $data['status']              = 1;
            if ($_FILES['image']['name'] != "") {
                $config['upload_path']   = './assets/images/staff/';
                $config['allowed_types'] = 'gif|jpg|jpeg|png';
                $config['max_size']      = 10000;
                $config['file_name']     = time();
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                $staffimage = "";
                if ($this->upload->do_upload('image')) {
                    $staffimage    = './assets/images/staff/' . $this->upload->data('file_name');
                    $data['image'] = $staffimage;
                } else {
                    echo "image is not inserted";
                }
            }
            $where = array(
                'staff_id' => $staff_id
            );
            $this->Api_model->updateSingleRow('staff', $where, $data);
            $this->session->set_flashdata('msg2', 'Staff updated Successfully');
            // $this->Api_model->updateSingleRow('breed',$where, $data);
            redirect('Admin/stafflist');
        } else {
            redirect('Admin/login');
        }
    }
    public function deletestaff()
    {
        $id = $this->uri->segment('3');
        $this->Api_model->deleteRecord(array(
            'staff_id' => $id
        ), 'staff');
        redirect('Admin/stafflist');
    }
    ################################################################################
    public function addTimeTable()
    {
        if (isset($_SESSION['name'])) {
            $data['class']      = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['subject']    = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            $data['staff']      = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            //$data['time_table'] = $this->Api_model->getAllDataWhere(array('status' => 1), 'time_table');
            $data['Time_table'] = $this->Api_model->getDataByfourTable('time_table');
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('add_time_table.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function add_Time_Table_action()
    {
        if (isset($_SESSION['name'])) {
            $this->form_validation->set_rules('class_id', 'Class Name', 'required');
            $this->form_validation->set_rules('subject_id', 'Subject Name', 'required');
            $this->form_validation->set_rules('staff_id', 'Staff Name', 'required');
            $this->form_validation->set_rules('day', 'Day', 'required');
            $this->form_validation->set_rules('from', 'From', 'required');
            $this->form_validation->set_rules('to', 'To', 'required');
            $this->form_validation->set_rules('date', 'Date', 'required');
            
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Time Table';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('add_time_table.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['class_id']    = $this->input->post('class_id');
                $data['subject_id']  = $this->input->post('subject_id');
                $data['staff_id']    = $this->input->post('staff_id');
                $data['day']         = $this->input->post('day');
                $data['from']        = $this->input->post('from');
                $data['to']          = $this->input->post('to');
                $data['date']        = $this->input->post('date');
                $data['create_date'] = date('Y-m-d H:i:s');
                $data['update_date'] = date('Y-m-d H:i:s');
                $data['status']      = 1;
                $this->Api_model->insert('time_table', $data);
                redirect('Admin/TimeTablelist');
            }
        } else {
            redirect();
        }
    }
    public function TimeTableList()
    {
        if (isset($_SESSION['name'])) {
            $data['Time_table'] = $this->Api_model->getDataByfourTable('time_table');
            $data['page']       = 'TimeTablelist';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('time_table_list.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    
    
    public function change_Time_Table_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'tt_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('time_table', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('time_table', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('time_table', array(
                'tt_id' => $id
            ));
            
            redirect('Admin/TimeTableList');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('time_table', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('time_table', array(
                'tt_id' => $id
            ));
            
            redirect('Admin/TimeTableList');
        }
    }
    public function updateTimeTable()
    {
        if (isset($_SESSION['name'])) {
            $tt_id              = $this->uri->segment(3);
            $where              = array(
                'tt_id' => $tt_id
            );
            $data['time_table'] = $this->Api_model->getSingleRow('time_table', $where);
            $data['class']      = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['subject']    = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            $data['staff']      = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['page']       = 'updateTimeTable';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('update_time_table.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function update_Time_Table_action()
    {
        if (isset($_SESSION['name'])) {
            $tt_id               = $this->input->post('tt_id');
            $data['class_id']    = $this->input->post('class_id');
            $data['subject_id']  = $this->input->post('subject_id');
            $data['staff_id']    = $this->input->post('staff_id');
            $data['day']         = $this->input->post('day');
            $data['from']        = $this->input->post('from');
            $data['to']          = $this->input->post('to');
            $data['date']        = $this->input->post('date');
            $data['create_date'] = time();
            $data['update_date'] = time();
            $data['status']      = 1;
            $where               = array(
                'tt_id' => $tt_id
            );
            $this->Api_model->updateSingleRow('time_table', $where, $data);
            redirect('Admin/TimeTableList');
        } else {
            redirect('Admin/login');
        }
    }
    public function deleteTimeTable()
    {
        $id = $this->uri->segment('3');
        $this->Api_model->deleteRecord(array(
            'tt_id' => $id
        ), 'time_table');
        redirect('Admin/TimeTableList');
    }
    
    
    public function getSubject($id)
    {
        
        $data = $this->Api_model->getAllDataWhere(array(
            'class_id' => $id
        ), 'class_subject_combination');
        
        if (count($data) > 0) {
            echo '<option value="">Please Select Subject</option>';
            
            
            foreach ($data as $data1) {
                
                $data1 = $this->Api_model->getAllDataWhere(array(
                    'subject_id' => $data1->subject_id
                ), 'subject');
                foreach ($data1 as $data0) {
                    echo '<option value=' . $data0->subject_id . '>' . $data0->subject_name . '</option>';
                }
            }
        } else {
            echo '<option value="">No Subject Found</option>';
        }
        
    }
    
    public function getSubject1($id)
    {
        $data = $this->Api_model->getAllDataWhere(array(
            'staff_id' => $id
        ), 'staff_schedule');
        if (count($data) > 0) {
            echo '<option value="">Please Select Subject</option>';
            foreach ($data as $data1) {
                $data1 = $this->Api_model->getAllDataWhere(array(
                    'subject_id' => $data1->subject_id
                ), 'subject');
                foreach ($data1 as $data0) {
                    echo '<option value=' . $data0->subject_id . '>' . $data0->subject_name . '</option>';
                }
            }
        } else {
            echo '<option value="">No Subject Found</option>';
        }
    }
    
    
    public function getStudent($id)
    {
        print_r($id);
        $data = $this->Api_model->getAllDataWhere(array(
            'class_id' => $id
        ), 'student');
        
        if (count($data) > 0) {
            echo '<option value="">Please Select Student Name</option>';
            
            
            foreach ($data as $data1) {
                echo '<option value=' . $data1->student_id . '>' . $data1->first_name . ' ' . $data1->middle_name . ' ' . $data1->last_name . '</option>';
                
            }
        } else {
            echo '<option value="">No Student Found</option>';
        }
        
    }
    
    
    // public function getSession($id)
    // {
        
        
    //     $data = $this->Api_model->getSessionByStudent($id);
        
    //     if (count($data) > 0) {
    //         echo '<option value="">Please Select Session </option>';
            
            
    //         foreach ($data as $data1) {
    //             echo '<option value=' . $data1->session_id . '>' . $data1->start_year . ' - ' . $data1->end_year . ' </option>';
                
    //         }
    //     } else {
    //         echo '<option value="">No Session Found</option>';
    //     }
        
    // }

    public function getSession($id)
    {
        $data = $this->Api_model->getSessionByStudentId($id);

        
        if (count($data) > 0) {
            echo '<option value="">Please Select Session Name</option>';
            
            
            foreach ($data as $session) {
                
                
                echo '<option value=' . $session->session_id . '>' . $session->start_year . '-' . $session->end_year . '</option>';
                
            }
        } else {
            echo '<option value="">No Session Found</option>';
        }
        
    }
    
    public function getClass($id)
    {
        
        $data = $this->Api_model->getAllDataWhere(array(
            'staff_id' => $id,
            'status' => 1
        ), 'staff_class');
        
        if (count($data) > 0) {
            echo '<option value="">Please Select Class</option>';
            
            
            foreach ($data as $data1) {
                
                $data1 = $this->Api_model->getAllDataWhere(array(
                    'class_id' => $data1->class_id
                ), 'class');
                foreach ($data1 as $data0) {
                    echo '<option value=' . $data0->class_id . '>' . $data0->class_name . '</option>';
                    
                }
            }
        } else {
            echo '<option value="">No Subject Found</option>';
        }
        
    }
    
    
    public function addClassSchedule()
    {
        if (isset($_SESSION['name'])) {
            $data['class']          = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['subject']        = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            $data['class_schedule'] = $this->Api_model->getAllData('class_schedule');
            $class_id               = $this->input->post('class_id');
            if (isset($class_id)) {
                
                $data['class_id'] = $class_id;
                $dataMonday       = array();
                $dataTuesday      = array();
                $dataWednesday    = array();
                $dataThursday     = array();
                $dataFriday       = array();
                $dataSaturday     = array();
                $monday           = $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($monday as $monday) {
                    $subject_check = $this->Api_model->getSingleRow('class_schedule', array(
                        'day_id' => 1,
                        'class_id' => $class_id,
                        'subject_id' => $monday->subject_id
                    ));
                    
                    if ($subject_check) {
                        
                        $monday->check = 1;
                    } else {
                        $monday->check = 0;
                        
                    }
                    
                    array_push($dataMonday, $monday);
                }
                
                $data['monday'] = $dataMonday;
                ####################################
                
                $tuesday = $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($tuesday as $tuesday) {
                    $subject_check = $this->Api_model->getSingleRow('class_schedule', array(
                        'day_id' => 2,
                        'class_id' => $class_id,
                        'subject_id' => $tuesday->subject_id
                    ));
                    if ($subject_check) {
                        
                        $tuesday->check = 1;
                    } else {
                        $tuesday->check = 0;
                        
                    }
                    
                    array_push($dataTuesday, $tuesday);
                }
                
                $data['tuesday'] = $dataTuesday;
                #####################################
                
                $wednesday = $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($wednesday as $wednesday) {
                    $subject_check = $this->Api_model->getSingleRow('class_schedule', array(
                        'day_id' => 3,
                        'class_id' => $class_id,
                        'subject_id' => $wednesday->subject_id
                    ));
                    
                    if ($subject_check) {
                        
                        $wednesday->check = 1;
                    } else {
                        $wednesday->check = 0;
                        
                    }
                    
                    array_push($dataWednesday, $wednesday);
                }
                
                $data['wednesday'] = $dataWednesday;
                ########################################
                
                $thursday = $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($thursday as $thursday) {
                    $subject_check = $this->Api_model->getSingleRow('class_schedule', array(
                        'day_id' => 4,
                        'class_id' => $class_id,
                        'subject_id' => $thursday->subject_id
                    ));
                    
                    if ($subject_check) {
                        
                        $thursday->check = 1;
                    } else {
                        $thursday->check = 0;
                        
                    }
                    
                    array_push($dataThursday, $thursday);
                }
                
                $data['thursday'] = $dataThursday;
                ########################################
                $friday           = $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($friday as $friday) {
                    $subject_check = $this->Api_model->getSingleRow('class_schedule', array(
                        'day_id' => 5,
                        'class_id' => $class_id,
                        'subject_id' => $friday->subject_id
                    ));
                    
                    if ($subject_check) {
                        
                        $friday->check = 1;
                    } else {
                        $friday->check = 0;
                        
                    }
                    
                    array_push($dataFriday, $friday);
                }
                
                $data['friday'] = $dataFriday;
                ########################################
                $saturday       = $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($saturday as $saturday) {
                    $subject_check = $this->Api_model->getSingleRow('class_schedule', array(
                        'day_id' => 6,
                        'class_id' => $class_id,
                        'subject_id' => $saturday->subject_id
                    ));
                    
                    if ($subject_check) {
                        
                        $saturday->check = 1;
                    } else {
                        $saturday->check = 0;
                        
                    }
                    
                    array_push($dataSaturday, $saturday);
                }
                
                $data['saturday'] = $dataSaturday;
                ########################################
                
            } else {
                $data['class_sc'] = array();
            }
            
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('add_class_schedule.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('Admin/addClassSchedule');
        }
    }
    
    
    public function add_Class_Schedule_Action()
    {
        if (isset($_SESSION['name'])) {
            $datas['class_schedule'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class_schedule');
            $data['class_id']        = $this->input->post('class_id');
            $data['day_id']          = $this->input->post('day_id');
            $data['created_at']      =time();
            $subject_id              = $this->input->post('subject_id');
            $this->Api_model->deleteRecord(array(
                'class_id' => $data['class_id'],
                'day_id' => $data['day_id']
            ), 'class_schedule');
            foreach ($subject_id as $subject_id) {
                $data['subject_id'] = $subject_id;
                $this->Api_model->insert('class_schedule', $data);
            }
            redirect('Admin/addClassSchedule');
            
        } else {
            redirect('Admin/addClassSchedule');
        }
    }
    public function addStaffSchedule()
    {
        if (isset($_SESSION['name'])) {
            
            $data['class_schedule'] = $this->Api_model->getAllData('class_schedule');
            $data['staff']          = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['class']          = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $class_id               = $this->input->post('class_id');
            $day_id                 = $this->input->post('day_id');
            $staff_id               = $this->input->post('staff_id');
            if (isset($class_id, $day_id)) {
                $data['class_id'] = $class_id;
                $data['day_id']   = $day_id;
                $data['staff_id'] = $staff_id;
                $dataMonday       = array();
                $monday           = $this->Api_model->getDataBy4TableWhere($class_id, $day_id);
                // $monday= $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($monday as $monday) {
                    $subject_check = $this->Api_model->getSingleRow('staff_schedule', array(
                        'day_id' => 1,
                        'class_id' => $class_id,
                        'staff_id' => $staff_id,
                        'subject_id' => $monday->subject_id
                    ));
                    
                    // print_r($subject_check);
                    // exit();
                    if ($subject_check) {
                        
                        $monday->check = 1;
                    } else {
                        $monday->check = 0;
                        
                    }
                    
                    array_push($dataMonday, $monday);
                }
                
                $data['monday'] = $dataMonday;
                ####################################
                $dataTuesday    = array();
                $tuesday        = $this->Api_model->getDataBy4TableWhere($class_id, $day_id);
                // $monday= $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($tuesday as $tuesday) {
                    $subject_check = $this->Api_model->getSingleRow('staff_schedule', array(
                        'day_id' => 2,
                        'class_id' => $class_id,
                        'staff_id' => $staff_id,
                        'subject_id' => $tuesday->subject_id
                    ));
                    
                    // print_r($subject_check);
                    // exit();
                    if ($subject_check) {
                        
                        $tuesday->check = 1;
                    } else {
                        $tuesday->check = 0;
                        
                    }
                    
                    array_push($dataTuesday, $tuesday);
                }
                
                $data['tuesday'] = $dataTuesday;
                ####################################
                
                $dataWednesday = array();
                $wednesday     = $this->Api_model->getDataBy4TableWhere($class_id, $day_id);
                // $monday= $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($wednesday as $wednesday) {
                    $subject_check = $this->Api_model->getSingleRow('staff_schedule', array(
                        'day_id' => 3,
                        'class_id' => $class_id,
                        'staff_id' => $staff_id,
                        'subject_id' => $wednesday->subject_id
                    ));
                    
                    // print_r($subject_check);
                    // exit();
                    if ($subject_check) {
                        
                        $wednesday->check = 1;
                    } else {
                        $wednesday->check = 0;
                        
                    }
                    
                    array_push($dataWednesday, $wednesday);
                }
                
                $data['wednesday'] = $dataWednesday;
                ####################################
                
                $dataThursday = array();
                $thursday     = $this->Api_model->getDataBy4TableWhere($class_id, $day_id);
                // $monday= $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($thursday as $thursday) {
                    $subject_check = $this->Api_model->getSingleRow('staff_schedule', array(
                        'day_id' => 4,
                        'class_id' => $class_id,
                        'staff_id' => $staff_id,
                        'subject_id' => $thursday->subject_id
                    ));
                    
                    // print_r($subject_check);
                    // exit();
                    if ($subject_check) {
                        
                        $thursday->check = 1;
                    } else {
                        $thursday->check = 0;
                        
                    }
                    
                    array_push($dataThursday, $thursday);
                }
                
                $data['thursday'] = $dataThursday;
                ####################################
                
                $dataFriday = array();
                $friday     = $this->Api_model->getDataBy4TableWhere($class_id, $day_id);
                // $monday= $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($friday as $friday) {
                    $subject_check = $this->Api_model->getSingleRow('staff_schedule', array(
                        'day_id' => 5,
                        'class_id' => $class_id,
                        'staff_id' => $staff_id,
                        'subject_id' => $friday->subject_id
                    ));
                    
                    // print_r($subject_check);
                    // exit();
                    if ($subject_check) {
                        
                        $friday->check = 1;
                    } else {
                        $friday->check = 0;
                        
                    }
                    
                    array_push($dataFriday, $friday);
                }
                
                $data['friday'] = $dataFriday;
                ##########################################
                
                $dataSaturday = array();
                $saturday     = $this->Api_model->getDataBy4TableWhere($class_id, $day_id);
                // $monday= $this->Api_model->getDataBy3TableWhere($class_id);
                foreach ($saturday as $saturday) {
                    $subject_check = $this->Api_model->getSingleRow('staff_schedule', array(
                        'day_id' => 6,
                        'class_id' => $class_id,
                        'staff_id' => $staff_id,
                        'subject_id' => $saturday->subject_id
                    ));
                    
                    // print_r($subject_check);
                    // exit();
                    if ($subject_check) {
                        
                        $saturday->check = 1;
                    } else {
                        $saturday->check = 0;
                        
                    }
                    
                    array_push($dataSaturday, $saturday);
                }
                
                $data['saturday'] = $dataSaturday;
                // print_r($data['monday']);
                // exit();          
                // $data['tuesday']=$this->Api_model->getDataBy4TableWhere($class_id,$day_id);
                // $data['wednesday']=$this->Api_model->getDataBy4TableWhere($class_id,$day_id);
                // $data['thursday']=$this->Api_model->getDataBy4TableWhere($class_id,$day_id);
                // $data['friday']=$this->Api_model->getDataBy4TableWhere($class_id,$day_id);
                // $data['saturday']=$this->getDataBy4TableWhere($class_id,$day_id);
            } else {
                $data['class_sc'] = array();
            }
            
            // $data['page']    = 'staffschedulelist';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('add_staff_schedule.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('Admin/addClassSchedule');
        }
    }
    
    public function add_Staff_Schedule_Action()
    {
        
        if (isset($_SESSION['name'])) {
            
            $data['staff_id']   = $this->input->post('staff_id');
            $data['class_id']   = $this->input->post('class_id');
            $data['day_id']     = $this->input->post('day_id');
            $subject_id         = $this->input->post('subject_id');
            $data['created_at'] = time();
            foreach ($subject_id as $subject_id) {
                $data['subject_id'] = $subject_id;
                $this->Api_model->deleteRecord(array(
                    'class_id' => $data['class_id'],
                    'day_id' => $data['day_id'],
                    'subject_id' => $data['subject_id']
                ), 'staff_schedule');
                $this->Api_model->insert('staff_schedule', $data);
            }
            redirect('Admin/addStaffSchedule');
            
        } else {
            redirect();
        }
    }
    
    public function getSubjectt($id)
    {
        // print_r($id);
        $data = $this->Api_model->getAllDataWhere(array(
            'class_id' => $id
        ), 'class_subject_combination');
        
        if (count($data) > 0) {
            foreach ($data as $data1) {
                
                $data1 = $this->Api_model->getAllDataWhere(array(
                    'subject_id' => $data1->subject_id
                ), 'subject');
                foreach ($data1 as $data0) {
                    echo '<div class="checkbox checkbox-info checkbox-circle">
                                        <input  type="checkbox" name="subject_id[]" value="' . $data0->subject_id . '">
                                        <label > ' . $data0->subject_name . ' </label>
                                    </div>';
                    
                    // echo '<option value=' . $data0->subject_id . '>' . $data0->subject_name . '</option>';
                }
            }
        } else {
            echo '<option value="">No Subject Found</option>';
        }
        
    }
    
    #################################################################################
    public function addResult()
    {
        if (isset($_SESSION['name'])) {
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['subject'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            $data['student'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'student');
            $data['staff']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['session'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'session');
            
            
            $data['result'] = $this->Api_model->getAllData('result');
            $data['result'] = $this->Api_model->getDataBy4Table('result');
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('add_result.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function add_Result_action()
    {
        if (isset($_SESSION['name'])) {
            $this->form_validation->set_rules('class_id', 'Class Name', 'required');
            $this->form_validation->set_rules('subject_id', 'Subject Name', 'required');
            $this->form_validation->set_rules('student_id', 'Student Name', 'required');
            $this->form_validation->set_rules('marks', 'Marks', 'required');
            $this->form_validation->set_rules('out_of', 'OutOf', 'required');
            $this->form_validation->set_rules('grade', 'Grade', 'required');
            $this->form_validation->set_rules('comment', 'Comment', 'required');
            
            if ($this->form_validation->run() == FALSE) {
                $data['page'] = 'Add Result';
                $this->load->view('common/head.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('add_result.php', $data, $datas);
                $this->load->view('common/footer.php');
            } else {
                $data['class_id']    = $this->input->post('class_id');
                $data['staff_id']    = $this->input->post('staff_id');
                $data['subject_id']  = $this->input->post('subject_id');
                $data['student_id']  = $this->input->post('student_id');
                $data['session_id']  = $this->input->post('session_id');
                $data['marks']       = $this->input->post('marks');
                $data['assignment']  = $this->input->post('assignment');
                $data['assignment1'] = $this->input->post('assignment1');
                $data['lab']         = $this->input->post('lab');
                $data['project']     = $this->input->post('project');
                $data['total']       = $this->input->post('total');
                $data['out_of']      = $this->input->post('out_of');
                $data['grade']       = $this->input->post('grade');
                $data['comment']     = $this->input->post('comment');
                $data['create_date'] = time();
                $data['update_date'] = time();
                $data['status']      = 1;
                $class_id = $data['class_id'];
                $subject_id =  $data['subject_id']; 
                $staff_id = $data['staff_id'];
                $student_id =  $data['student_id']; 
                $session_id =  $data['session_id'];                	
                $datas=$this->Api_model->getDataByfourField($class_id,$subject_id,$staff_id,$student_id,$session_id);
              
                if(!$datas)
                {
                 $this->Api_model->insert('result', $data);
                $this->session->set_flashdata('msg2', 'Successfully result uploaded');
                redirect('Admin/ResultList');
                }
                else{
                 $this->session->set_flashdata('msg1', 'Result is already Uploaded.');
                  redirect('Admin/ResultList');

                }
            }
        }
         else {
            redirect();
        }
    }

    public function ResultList()
    {
        if (isset($_SESSION['name'])) {
            $datas['get_class'] = $this->Api_model->getAllData('class');
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['staff']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            // $data['parent'] = $this->Api_model->GetStudent();
          
            $data['class_id']               = $this->input->post('class_id');
            $class_id= $data['class_id'];
            $data['staff_id']              = $this->input->post('staff_id');
            $staff_id= $data['staff_id'];
            if (isset($class_id)) {
                    // $data['result'] = $this->Api_model->getDataBy4Table('result');
             $data['result'] = $this->Api_model->getDataBy4Table($staff_id,$class_id);

                  }
              
         }
            $data['page']   = 'ResultList';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('result_list.php', $data);
            $this->load->view('common/footer.php');
        }


    public function updateResult()
    {
        if (isset($_SESSION['name'])) {
            $result_id       = $this->uri->segment(3);
            $where           = array(
                'result_id' => $result_id
            );
            $data['result']  = $this->Api_model->getSingleRow('result', $where);
            $resultt = $data['result'];
            $data['subjectData']= $this->Api_model->getAllDataWhere(array(
                    'staff_id' =>$resultt->staff_id,
                    'class_id' =>$resultt->class_id
                   ), 'staff_schedule');
           $subjectData = $data['subjectData'];
         
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['subject'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'subject');
            $data['student'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'student');
            $data['staff']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['session'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'session');
            $data['page']    = 'updateResult';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('Update_result.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    public function update_result_action()
    {
        if (isset($_SESSION['name'])) {
            $result_id           = $this->input->post('result_id');
            $data['class_id']    = $this->input->post('class_id');
            $data['staff_id']    = $this->input->post('staff_id');
            $data['subject_id']  = $this->input->post('subject_id');
            $data['student_id']  = $this->input->post('student_id');
            $data['session_id']  = $this->input->post('session_id');
            $data['marks']       = $this->input->post('marks');
            $data['assignment']  = $this->input->post('assignment');
            $data['assignment1'] = $this->input->post('assignment1');
            $data['lab']         = $this->input->post('lab');
            $data['project']     = $this->input->post('project');
            $data['total']       = $this->input->post('total');
            $data['out_of']      = $this->input->post('out_of');
            $data['grade']       = $this->input->post('grade');
            $data['comment']     = $this->input->post('comment');
            $data['create_date'] = time();
            $data['update_date'] = time();
            $data['status']      = 1;
            $where               = array(
                'result_id' => $result_id
            );
            $this->Api_model->updateSingleRow('result', $where, $data);
            $this->session->set_flashdata('msg3', 'Result updated Successfully.');
            redirect('Admin/ResultList');
        } else {
            redirect('Admin/login');
        }
    }
    public function change_Result_status()
    {
        $id      = $_GET['id'];
        $status  = $_GET['status'];
        $request = $_GET['request'];
        $where   = array(
            'result_id' => $id
        );
        $data    = array(
            'status' => $status
        );
        $update  = $this->Api_model->updateSingleRow('result', $where, $data);
        
        if ($request == 1) {
            $getdata  = $this->Api_model->getSingleRow('result', $where);
            $user_id  = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('result', array(
                'result_id' => $id
            ));
            
            redirect('Admin/ResultList');
        } elseif ($request == 2) {
            $getdata  = $this->Api_model->getSingleRow('result', $where);
            $id       = $getdata->id;
            $userdata = $this->Api_model->getSingleRow('result', array(
                'result_id' => $id
            ));
            
            redirect('Admin/ResultList');
        }
    }

    #####################################################################################################
    public function addClassStudentResult()
    {
        if (isset($_SESSION['name'])) {
            $datas['get_class'] = $this->Api_model->getAllData('class');
            $data['class']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'class');
            $data['staff']   = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'staff');
            $data['parent'] = $this->Api_model->GetStudent();
            $data['result'] = $this->Api_model->getAllData('result');
            $data['class_id']               = $this->input->post('class_id');
            $class_id= $data['class_id'];
            $data['staff_id']              = $this->input->post('staff_id');
            $staff_id= $data['staff_id'];
            if (isset($class_id)) {
            	   $data['monday']       =$this->Api_model->GetStudentByClass($class_id);
            	   $monday =   $data['monday'];
            	   foreach($monday as $monday)
            	   {
            	   $student_id=$monday->student_id;
                   $data['session'] = $this->Api_model->getSessionByStudentId($student_id);
                   // $data['staff_schedule'] = $this->Api_model->getAllDataWhere(array(
                   // 'class_id' => $class_id,
                   // 'staff_id'=> $staff_id
                   // ), 'staff_schedule');
                     $data['staff_schedule'] = $this->Api_model->GetSubject($staff_id,$class_id);


                   $staff_schedule=$data['staff_schedule'];
                  
                  }
              }
            }

            else {
            	   $data['monday']       =$this->Api_model->GetStudentByClass(0);
            }
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('Add_result.php', $data);
            $this->load->view('common/footer.php');
     }
    
    public function add_Class_Result_Action()
    {
        if (isset($_SESSION['name'])) {
            $datas['result'] = $this->Api_model->getAllDataWhere(array(
                'status' => 1
            ), 'result');

                $data['class_id']    = $this->input->post('class_id');
                $data['staff_id']    = $this->input->post('staff_id');
                $data['subject_id']  = $this->input->post('subject_id');
                $data['student_id']  = $this->input->post('student_id');
                $data['session_id']  = $this->input->post('session_id');
                $data['marks']       = $this->input->post('marks');
                $data['assignment']  = $this->input->post('assignment');
                $data['assignment1'] = $this->input->post('assignment1');
                $data['lab']         = $this->input->post('lab');
                $data['project']     = $this->input->post('project');
                $data['total']       = $this->input->post('total');
                $data['out_of']      = $this->input->post('out_of');
                $data['grade']       = $this->input->post('grade');
                $data['comment']     = $this->input->post('comment');
                $data['create_date'] = time();
                $data['update_date'] = time();
                $data['status']      = 1;
                $class_id = $data['class_id'];
                $subject_id =  $data['subject_id']; 
                $staff_id = $data['staff_id'];
                $student_id =  $data['student_id']; 
                $session_id =  $data['session_id'];            	
                $datas=$this->Api_model->getDataByfourField($class_id,$subject_id,$staff_id,$session_id,$student_id);
                if(!$datas)
                {
                 $this->Api_model->insert('result', $data);
                $this->session->set_flashdata('msg2', 'Successfully result uploaded');
                redirect('Admin/ResultList');
                }
                else{
                 $this->session->set_flashdata('msg1', 'Result is already Uploaded.');
                  redirect('Admin/ResultList');

                }
        }
    }

    #############################################################################
      public function app_setting()
    {
      if(isset($_SESSION['name'])) 
      {
        $data['firebase_setting']= $this->Api_model->getSingleRow('firebase_keys',array('id'=>1));
        $data['page']='app_setting';
        $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('app_setting.php', $data);
            $this->load->view('common/footer.php');
      }
      else
      {
        redirect('');
      }
    }

     public function firebaseSetting()
    {
      $data['firebase_key']= $this->input->post('firebase_key', TRUE);
    

      $this->Api_model->updateSingleRow('firebase_keys', array('id'=>1), $data);
      $this->session->set_flashdata('msg', 'Firebase key changed successfully.');
      redirect('Admin/app_setting');
    }


    #################################################################################
    
    public function notification()
    {
        if (isset($_SESSION['name'])) {
            $data['student'] = $this->Api_model->getAllData('staff');
            $data['page']    = 'notification';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('notification.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

     public function notificationForStudent()
    {
        if (isset($_SESSION['name'])) {
            $data['student'] = $this->Api_model->getAllData('parent');
            $data['page']    = 'notification';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('notification_parent.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

      public function SupportStaff()
    {
        if (isset($_SESSION['name'])) {
            $data['student'] = $this->Api_model->getAllDataWhere(array('role'=>1),'ticket');
            $data['page']    = 'notification';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('support_staff.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }
     public function SupportParent()
    {
        if (isset($_SESSION['name'])) {
            $data['student'] = $this->Api_model->getAllDataWhere(array('role'=>2),'ticket');
            $data['page']    = 'notification';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('support_parent.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function putnotification()
    {
        $id    = explode(',', $_POST['staff_id']);
        $count = count($id);
       

        for ($i = 0; $i < $count; $i++) {
            $user_id = $id[$i];
           
            $title   = $_POST['title'];

            $msg     = $_POST['message'];

            if ($user_id != 0) {
            //     $device_token = $getToken->device_token;
            // print_r($device_token);
            // exit();
                // $this->firebase_with_class($device_token, '', '', $title, $msg);

                $getToken     = $this->Api_model->getSingleOneRow('staff', array(
                    'staff_id' => $user_id
                ));

                $device_token = $getToken->device_token;
                // $this->firebase_notification($user_id,$title,$msg);
                $staff_name	=	$getToken->first_name;
                $type     =7002;
                $this->firebase_with_class($device_token,$user_id,$staff_name, $type,$title, $msg);
                $data['user_id']    = $user_id;
              
                $data['title']      = $title;
                $data['msg']        = $msg;
                $data['type']		=7002;
                 $data['role']   = 1;
                $data['created_at'] = time();
                

                $this->Api_model->insert('notifications', $data);
           			
            }

        }
       redirect('Admin/notification');
    }

  public function putnotificationParent()
    {
        $id    = explode(',', $_POST['parent_id']);
        $count = count($id);
       

        for ($i = 0; $i < $count; $i++) {
            $user_id = $id[$i];
           
            $title   = $_POST['title'];

            $msg     = $_POST['message'];

            if ($user_id != 0) {
            //     $device_token = $getToken->device_token;
            // print_r($device_token);
            // exit();
                // $this->firebase_with_class($device_token, '', '', $title, $msg);

                $getToken     = $this->Api_model->getSingleOneRow('parent', array(
                    'parent_id' => $user_id
                ));

                $device_token = $getToken->device_token;
                // $this->firebase_notification($user_id,$title,$msg);
                $staff_name =   $getToken->father_name;
                $type     =7002;
                $this->firebase_with_class($device_token,$user_id,$staff_name, $type,$title, $msg);
                $data['user_id']    = $user_id;
              
                $data['title']      = $title;
                $data['msg']        = $msg;
                $data['type']       =7002;
                 $data['role']   = 0;
                $data['created_at'] = time();
                

                $this->Api_model->insert('notifications', $data);
                    
            }

        }
       redirect('Admin/notificationForStudent');
    }



      public function PushSupportParent()
    {
                $user_id      = $this->uri->segment(3);

                $getToken     = $this->Api_model->getSingleRow('parent', array(
                    'parent_id' => $user_id
                ));

                $data1['status']             = 1;
               $where = array(
                'user_id' => $user_id,
                'role'=> 2
            );
       $update =     $this->Api_model->updateSingleRow('ticket', $where, $data1);
 
     
            $title   = 'Hello';
            $msg     = 'Your Problem is solved';
              $type     =7003;
                $device_token = $getToken->device_token;
                $parent_name=$getToken->father_name;
                $this->firebase_with_class($device_token, $user_id, $parent_name, $type, $title, $msg);
                $data['user_id']    = $user_id;
                $data['title']      = $title;
                $data['msg']        = $msg;
                $data['type']		=7003;
    	        $data['role']	=       2;
                $data['created_at'] = time();
                
                            $this->Api_model->insert('notifications', $data);

        
       redirect('Admin/SupportParent');
      }

     public function PushSupportStaff()
    {
            $user_id      = $this->uri->segment(3);

                $getToken     = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $user_id
                ));

                $data1['status']             = 1;
               $where = array(
                'user_id' => $user_id,
                'role'=> 1
            );
       $update =     $this->Api_model->updateSingleRow('ticket', $where, $data1);
 
     
            $title   = 'Hello';
            $msg     = 'Your Problem is solved';
            $type     =7003;
                $device_token = $getToken->device_token;
                $parent_name=$getToken->first_name;
                $this->firebase_with_class($device_token, $user_id, $parent_name, $type,$title, $msg);
                $data['user_id']    = $user_id;
                $data['title']      = $title;
                $data['msg']        = $msg;
                $data['type']       =7003;
                $data['role']   =2;
                $data['created_at'] = time();
               
               $this->Api_model->insert('notifications', $data);
        redirect('Admin/SupportStaff');
    }
    /*Firebase for notification*/
    public function firebase_notification($user_id, $title, $msg)
    {
        $get_data = $this->Api_model->getSingleRow('parent', array(
            'parent_id' => $user_id
        ));
          $FIRE_BASE_KEY=$this->Api_model->getSingleRow('firebase_keys',array('id'=>1));
          $api_key=$FIRE_BASE_KEY->firebase_key;
        if ($get_data->device_token) {
            if ($get_data->role_id == 1) {
                $API_ACCESS_KEY = $api_key;
            } else {
                $API_ACCESS_KEY = $api_key;
            }
            $registrationIds = $get_data->device_token;
            $msg             = array(
                'body' => $msg,
                'title' => $title,
                'icon' => 'myIcon',
                /*Default Icon*/
                'sound' => 'mySound'
                /*Default sound*/
            );
            $fields          = array(
                'to' => $registrationIds,
                'notification' => $msg
            );
            $headers         = array(
                'Authorization: key=' . $API_ACCESS_KEY,
                'Content-Type: application/json'
            );
            #Send Reponse To FireBase Server
            $ch              = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
            $result = curl_exec($ch);
            curl_close($ch);
        }
    }

    public function home() {
        if(isset($_SESSION['name'])) {
            $data['task1']  =  $this->Api_model->getAllData('task');
            $data['task']   =  $this->Api_model->getAllDataLimit('task','5');
            $data['agency'] =  0;
            if(isset($_SESSION['agency']) && !empty($_SESSION['agency'])){
                $data['agency'] = $_SESSION['agency'];
            }

            //if($this->session->userdata('userlevel')=='S') {
            if(checkUserLevel('S', $this->session->userdata('userlevel'))) {
                
                $agency_code = $this->session->userdata('agency');
                $supervisor_id = $this->session->userdata('userId');
                //$supervisor_id = $this->session->userdata('id');
                $googleUserId = $this->session->userdata('googleId');

                $where = [];
                $where['googleUserId'] = $googleUserId;
                $data['userData'] = $this->Comman_model->get_row('users_portal', $where);

                //print_r($data['userData']);die;


                //$data['totalAssignedClient'] = $this->Comman_model->getActiveClient($agency_code, $supervisor_id);
                $data['totalAssignedClient'] = $this->Comman_model->getActiveClient($agency_code, $supervisor_id,1);    
                

                $data['totalAssignedClientHours'] = $this->Comman_model->getAssignedClientHours($agency_code, $supervisor_id);    
                //$data['totalAssignedClientHours'] = $this->Comman_model->getTotalAssignedClientHours($agency_code, $supervisor_id);    

                $month = '';
                $totalBilledHoursByMonth = $totalHoursByMonth = '';
                if($agency_code==1 || $agency_code==3){
                    $where = [];
                    $where['ef.Agency'] = $agency_code;
                    $where['pt.supervisor_id'] = $supervisor_id;
                    $pmonth = date('n')-1;
                    $data['totalBilledHours'] = $this->Comman_model->getBilledtHours($where, $pmonth);        


                    /***** Get Previous Month ******/
                    for ($i=1; $i < date('n') ; $i++) { 
                        $month .= "'".date("F", mktime(0, 0, 0, $i, 10))."',"; 
                        $totalBilledHoursByMonth .= $this->Comman_model->getBilledtHours($where, $i).',';
                        //$totalHoursByMonth .= $this->Comman_model->getAssignedClientHoursByMonth($agency_code, $supervisor_id, 1, $i).',';
                        $totalHoursByMonth .= $data['totalAssignedClientHours'].',';
                    }

                } else {
                    $where = [];
                    $where['ef.Agency'] = $agency_code;
                    $where['pt.supervisor_id'] = $supervisor_id;
                    $pmonth = date('n')-1;
                    $data['totalBilledHours'] = $this->Comman_model->getBilledtHoursOtherAgency($where, $pmonth);        


                    for ($i=1; $i < date('n') ; $i++) { 
                        $month .= "'".date("F", mktime(0, 0, 0, $i, 10))."',"; 
                        $totalBilledHoursByMonth .= $this->Comman_model->getBilledtHoursOtherAgency($where, $i).',';
                        //$totalHoursByMonth .= $this->Comman_model->getAssignedClientHoursByMonth($agency_code, $supervisor_id, 1, $i).',';
                        $totalHoursByMonth .= $data['totalAssignedClientHours'].',';
                    }

                    $data['month'] = rtrim($month,',');
                    $data['totalBilledHoursByMonth'] = rtrim($totalBilledHoursByMonth,',');
                    $data['totalHoursByMonth'] = rtrim($totalHoursByMonth,',');
                }

                $data['month'] = rtrim($month,',');
                $data['totalBilledHoursByMonth'] = rtrim($totalBilledHoursByMonth,',');
                $data['totalHoursByMonth'] = rtrim($totalHoursByMonth,',');
                

                $data['totalClientOnHold'] = $this->Comman_model->getActiveClient($agency_code, $supervisor_id, 2);    

                //$data['totalClientOnHold'] = $this->Comman_model->getTotalClientByStatus($agency_code,$supervisor_id,2);   


                $where = [];
                $where['supervisor_id']  = $this->session->userdata('userId');
                $data['recentTerminations']  = $this->Comman_model->getRecentTerminations($where);    


                $where = [];
                $where['em.Agency'] = $agency_code;
                $where['em.supervisor_id'] = $supervisor_id;
                $limit = '5';
                if(!empty($_GET['limit'])) {
                    $limit = $_GET['limit'];  
                }

                $data['listFortyHoursWeek'] = $this->Comman_model->getListFortyHoursWeek($where, $limit);        
                $data['limit'] = $limit;

                $where = [];
                $where['em.Agency'] = $agency_code;
                $where['em.supervisor_id'] = $supervisor_id;
                $where['ec.isIn'] = 1;
                //$where['pt.device!='] = 0;
                //$where['ec.location_verified'] = 0;
                $limit2 = '5';
                if(!empty($_GET['limit2'])) {
                    $limit2 = $_GET['limit2'];  
                }
                $data['listAppUserLocation'] = $this->Comman_model->getListAppUserLocation($where, $limit2);        
                $data['limit2'] = $limit2;

            }

            //if($this->session->userdata('userlevel')=='X') {
            if(checkUserLevel('X', $this->session->userdata('userlevel'))) {    
                $where = [];
                $where['em.Agency'] = $agency_code;
                //$where['em.supervisor_id'] = $supervisor_id;
                $limit = '5';
                if(!empty($_GET['limit'])) {
                    $limit = $_GET['limit'];  
                }

                $data['listFortyHoursWeek'] = $this->Comman_model->getListFortyHoursWeek($where, $limit);        
                $data['limit'] = $limit;
            }

            if(isset($_SESSION['googleUser']))
                $data['googleTasks']= $this->google->getGoogleTask();

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('dashboard.php',$data);
        } else {
            redirect();
        }
    }


    function changeLocationStatus() {
        $postData = $this->input->post();

        if(!empty($postData['employeeClockId']) && !empty($postData['locationStatus']) && !empty($postData['confirmPassword'])) {
            $where = [];
            $where['googleUserId'] = $this->session->userdata('id');
            $where['password'] = md5($postData['confirmPassword']);
            $userData = $this->Comman_model->get_row('users_portal', $where);
            if(count($userData)>0){

                $where = [];
                $where['employee_clock_id'] = $postData['employeeClockId'];

                $dataArray = [];
                $dataArray['location_verified'] = $postData['locationStatus'];

                $this->Comman_model->update('employee_clock', $where, $dataArray);

                $postcomment = "Location has been verified ".date('Y-m-d');
                $this->postlog($postcomment); 
            } else {
                $this->session->set_flashdata('error_message','Invalid password. Please try again...');
            }
        }
        redirect($this->agent->referrer());
    }

    public function postlog($postcomment) {
        $postuser = $this->session->userdata('name');
        $postdate = date("Y-m-d H:i:s");
        $postagency = $this->session->userdata('agency');
        $postmode = 0;
        $notesid = 0;
        $postcategory = '';

        $dataArray = [];
        $dataArray['postdate'] = $postdate;
        $dataArray['postuser'] = $postuser;
        $dataArray['postagency'] = $postagency;
        $dataArray['postperiod'] = $postmode;
        $dataArray['postcomment'] = $postcomment;
        $dataArray['postcategory'] = $postcategory;
        $dataArray['notesid'] = $notesid;

        $postlog_id = $this->Comman_model->insert('postlog', $dataArray);

    }


    function getAddress(){

        $latitude = $this->input->post('latitude');
        $longitude = $this->input->post('longitude');

        if(!empty($latitude) && !empty($longitude)){
            //Send request and receive json data by address
            $geocodeFromLatLong = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&key=AIzaSyB3iE3D6Mksh20jN9n1lYT9Aawul-q97m0'); 
            $output = json_decode($geocodeFromLatLong);
            $status = $output->status;
            //Get address from json data
            $address = ($status=="OK")?$output->results[1]->formatted_address:'';
            //Return address of the given latitude and longitude
            if(!empty($address)){
                //echo $address;
                echo $address;
            }else{
                return false;
            }
        }else{
            return false;   
        }
    }




    public function sidebarAgency(){


        $agency= $this->input->post('Agency', TRUE);  
        $updatePassword = $this->input->post('update_password', TRUE);  

        //print_r($agency);die;
        //print_r($update_password);die;
        
        if(!empty($updatePassword)) {
            $where = [];
            $where['googleUserId'] = $this->session->userdata('googleId');
            $userData = $this->Comman_model->get_row('users_portal', $where);
            if(empty($userData['password'])) {
                $newPassword= $this->input->post('newPassword', TRUE);
                $confirmPassword= $this->input->post('confirmPassword', TRUE);
                if(!empty($newPassword) && !empty($confirmPassword)) {
                    if($newPassword==$confirmPassword) {
                        $dataArray = [];
                        $dataArray['password'] = md5($newPassword);
                        $this->Comman_model->update('users_portal', $where, $dataArray);
                    } else {
                        $this->session->set_flashdata('message','Password not matched. Please try again...');
                        //redirect($this->agent->referrer());
                    }
                } else {
                    $this->session->set_flashdata('message','Invalid password. Please try again...');
                    //redirect($this->agent->referrer());
                }
            }
        }

        if(!empty($agency)) {
            $sess_array = array(
                   'agency' => $agency
                 );
            $this->session->set_userdata($sess_array);

            $where = [];
            $where['supervisor_id'] = $this->session->userdata('userId');
            $where['Agency!='] = '0';
            $count = $this->Comman_model->countrow('supervisor', $where);

            if($count==0) {
                $where = [];
                $where['supervisor_id'] = $this->session->userdata('userId');
                $dataArray = [];
                $dataArray['Agency'] = $agency;

                $this->Comman_model->update('supervisor', $where, $dataArray);
            }

        } 
        //redirect($this->agent->referrer());
        redirect('admin/client');
    }


    public function login() {
        //print_r($this->input->post());die;

        if( !empty( $this->input->post( 'submit' ) ) ){
            $this->form_validation->set_rules('name', 'Username', 'trim|required');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            $this->form_validation->set_rules('Agency', 'Agency', 'trim|required');

            if ($this->form_validation->run() != false) {
                $agency = $this->input->post('Agency', TRUE);
                $name = $this->input->post('name', TRUE);
                $password = md5($this->input->post('password', TRUE));
                $data['name'] = $name;
                $data['password'] = $password;

                $sess_array = array();
                $getdata = $this->Api_model->getSingleRow('users_portal',$data);

                if($getdata) {
                    if($getdata->status==1) {
                        $agencyCheck = false;
                        $userAgency = $getdata->agency;
                        if(!empty($userAgency)) {
                            $userAgency = explode(',', $userAgency);
                            if(in_array($agency, $userAgency)) {
                                $agencyCheck = true;
                            }
                        }
                        if($agencyCheck) {
                            $this->session->unset_userdata($sess_array);
                            $sess_array = array(
                                                    'name' => $getdata->name,
                                                    'id' => $getdata->user_id,
                                                    'agency' => $agency,
                                                    'useragency' => $getdata->agency,
                                                    'userlevel' => $getdata->userlevel
                                                );


                            $this->session->set_userdata( $sess_array);
                            $dataget['get_data'] = $getdata;
                            $dataget['see_data'] = $sess_array;
                            redirect('Admin/home');   
                        } else {
                            $this->app->message('Invalid agency. Please try again...', 'error');
                            redirect('');
                        }

                    } else {
                        $this->app->message('Your account has been block. Contact to admin.', 'error');
                        redirect('');
                    }
                } else {
                    $this->app->message('Please enter valid Username or Password', 'error');
                    redirect('');              
                }
            }
        }
    }

    public function signup()
    {
        $this->load->view('common/head.php');
        $this->load->view('signup.php');
        $this->load->view('common/footer.php');
    }
    public function forgotpassword()
    {
        $this->load->view('common/head.php');
        $this->load->view('forgotpassword.php');
        $this->load->view('common/footer.php');
    }
   
    //     function firebase_with_class($device_token, $sender_id, $senderName, $title, $msg1)
    // {
       
    //     $staff = $this->Api_model->getSingleRow('staff', array(
    //         'device_token' => $device_token
    //     ));
       		
    //     // if ($staff->device_type == "ios") {
    //     //     $API_ACCESS_KEY = FIRE_BASE_KEY;
            
    //     //     $msg    = array(
    //     //         'body' => $msg1,
    //     //         'title' => $title,
    //     //         'icon' => 'myicon',
    //     //         /*Default Icon*/
    //     //         'sound' => 'default'
    //     //         /*Default sound*/
    //     //     );
    //     //     $fields = array(
    //     //         'to' => $device_token,
    //     //         'notification' => $msg
    //     //     );
            
            
    //     //     $headers = array(
    //     //         'Authorization: key=' . $API_ACCESS_KEY,
    //     //         'Content-Type: application/json'
    //     //     );
    //     //     #Send Reponse To FireBase Server    
    //     //     $ch      = curl_init();
    //     //     curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    //     //     curl_setopt($ch, CURLOPT_POST, true);
    //     //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //     //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    //     //     curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    //     //     $result = curl_exec($ch);
    //     //     curl_close($ch);
    //     // } else {
    //         $FCMPushNotification = new \BD\FCMPushNotification(FIRE_BASE_KEY);
    //         $sDeviceToken        = $device_token;
    //         $aPayload            = array(
    //             'data' => array(
    //                 'title' => $title,
    //                 'type' => 7002,
    //                 "sender_id" => $sender_id,
    //                 'body' => $msg1,
    //                 "senderName" => $senderName
    //             )
    //         );
            
    //         $aOptions = array(
    //             'time_to_live' => 15 //means messages that can't be delivered immediately are discarded. 
    //         );
            
    //         $aResult = $FCMPushNotification->sendToDevice($sDeviceToken, $aPayload, $aOptions // optional
    //             );
    //         return $aResult;
    //     }
    
     function firebase_with_class($device_token, $sender_id, $senderName,$type, $title, $msg1)
    {
       
        $staff = $this->Api_model->getSingleRow('staff', array(
            'device_token' => $device_token
        ));
         
          $FIRE_BASE_KEY=$this->Api_model->getSingleRow('firebase_keys',array('id'=>1));
          $api_key=$FIRE_BASE_KEY->firebase_key;


        // if ($staff->device_type == "ios") {
        //     $API_ACCESS_KEY = FIRE_BASE_KEY;
            
        //     $msg    = array(
        //         'body' => $msg1,
        //         'title' => $title,
        //         'icon' => 'myicon',
        //         /*Default Icon*/
        //         'sound' => 'default'
        //         /*Default sound*/
        //     );
        //     $fields = array(
        //         'to' => $device_token,
        //         'notification' => $msg
        //     );
            
            
        //     $headers = array(
        //         'Authorization: key=' . $API_ACCESS_KEY,
        //         'Content-Type: application/json'
        //     );
        //     #Send Reponse To FireBase Server    
        //     $ch      = curl_init();
        //     curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        //     curl_setopt($ch, CURLOPT_POST, true);
        //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //     curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        //     $result = curl_exec($ch);
        //     curl_close($ch);
        // } else {
            $FCMPushNotification = new \BD\FCMPushNotification($api_key);
            $sDeviceToken        = $device_token;
            $aPayload            = array(
                'data' => array(
                    'title' => $title,
                    'type' => $type,
                    "sender_id" => $sender_id,
                    'body' => $msg1,
                    "senderName" => $senderName
                )
            );
            
            $aOptions = array(
                'time_to_live' => 15 //means messages that can't be delivered immediately are discarded. 
            );
            
            $aResult = $FCMPushNotification->sendToDevice($sDeviceToken, $aPayload, $aOptions // optional
                );
            return $aResult;
        }

    public function logout()
    {
        $this->session->sess_destroy();
        redirect('./', 'refresh');
    }
} 