<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Agency extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model','comman');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->library('user_agent');
    }

    
    public function index() {
        if (isset($_SESSION['name'])) { 
            $data['page']  = 'Agency';
            $data['agencyData'] = $this->comman->get_rows('agency','','agency_id','desc');
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('agency/view.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect($this->agent->referrer());
        }
    }  

    public function add() {
        if (isset($_SESSION['name'])) { 

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('agency_code', 'Agency Code', 'trim|required');
                $this->form_validation->set_rules('adp_code', 'ADP Code', 'trim|required');
                $this->form_validation->set_rules('adp_batch_id', 'ADP Batch Id', 'trim|required');
                $this->form_validation->set_rules('agency_shortname', 'Agency shortname', 'trim|required');
                $this->form_validation->set_rules('agency_name', 'Agency Name', 'trim|required');
                $this->form_validation->set_rules('agency_addr1', 'Agency Address', 'trim|required');
                $this->form_validation->set_rules('agency_npi', 'NPI', 'trim|required');
                $this->form_validation->set_rules('agency_providers', 'Providers', 'trim|required');
                $this->form_validation->set_rules('agency_tax', 'Tax', 'trim|required');
                $this->form_validation->set_rules('CMS150024J', 'CMS150024J', 'trim|required');
                $this->form_validation->set_rules('agency_phone', 'Phone', 'trim|required');
                $this->form_validation->set_rules('agency_fax', 'Fax', 'trim|required');
                $this->form_validation->set_rules('agency_city', 'City', 'trim|required');
                $this->form_validation->set_rules('agency_state', 'State', 'trim|required');
                $this->form_validation->set_rules('agency_zip', 'Zip', 'trim|required');
                $this->form_validation->set_rules('agency_group', 'Group', 'trim|required');
                $this->form_validation->set_rules('agency_logo', 'Logo', 'trim|required');
                $this->form_validation->set_rules('taxonomy', 'Taxonomy', 'trim|required');


                if ($this->form_validation->run() != false) {

                    $dataArray                      = [];
                    $dataArray['agency_code']       = $this->input->post('agency_code',true);
                    $dataArray['ADP_code']          = $this->input->post('adp_code',true);
                    $dataArray['adp_batch_id']          = $this->input->post('adp_batch_id',true);                    
                    $dataArray['agency_shortname']  = $this->input->post('agency_shortname',true);
                    $dataArray['agency_name']       = $this->input->post('agency_name',true);
                    $dataArray['agency_addr1']      = $this->input->post('agency_addr1',true);
                    $dataArray['agency_addr2']      = $this->input->post('agency_addr2',true);
                    $dataArray['agency_npi']        = $this->input->post('agency_npi',true);
                    $dataArray['agency_providers']  = $this->input->post('agency_providers',true);
                    $dataArray['agency_tax']        = $this->input->post('agency_tax',true);
                    $dataArray['CMS150024J']        = $this->input->post('CMS150024J',true);
                    $dataArray['agency_phone']      = $this->input->post('agency_phone',true);
                    $dataArray['agency_fax']        = $this->input->post('agency_fax',true);
                    $dataArray['agency_city']       = $this->input->post('agency_city',true);
                    $dataArray['agency_state']      = $this->input->post('agency_state',true);
                    $dataArray['agency_zip']        = $this->input->post('agency_zip',true);
                    $dataArray['agency_group']      = $this->input->post('agency_group',true);
                    $dataArray['agency_logo']       = $this->input->post('agency_logo',true);
                    $dataArray['Taxonomy']          = $this->input->post('taxonomy',true);

                    $inserId = $this->comman->insert( "agency", $dataArray );

                    if($inserId){
                        $this->app->message('Agency has been added successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('agency','refresh');
                }
            }

            $data['page'] = 'Add User';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('agency/add.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function edit($pageId='') {

        if (isset($_SESSION['name'])) { 

            if(!empty($pageId)){
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['agency_id'] = $pageId;
                $pageData   =   $this->comman->get_row('agency',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ){

                $this->form_validation->set_rules('agency_code', 'Agency Code', 'trim|required');
                $this->form_validation->set_rules('adp_code', 'ADP Code', 'trim|required');
                $this->form_validation->set_rules('adp_batch_id', 'ADP Batch Id', 'trim|required');
                $this->form_validation->set_rules('agency_shortname', 'Agency shortname', 'trim|required');
                $this->form_validation->set_rules('agency_name', 'Agency Name', 'trim|required');
                $this->form_validation->set_rules('agency_addr1', 'Agency Address', 'trim|required');
                $this->form_validation->set_rules('agency_npi', 'NPI', 'trim|required');
                $this->form_validation->set_rules('agency_providers', 'Providers', 'trim|required');
                $this->form_validation->set_rules('agency_tax', 'Tax', 'trim|required');
                $this->form_validation->set_rules('CMS150024J', 'CMS150024J', 'trim|required');
                $this->form_validation->set_rules('agency_phone', 'Phone', 'trim|required');
                $this->form_validation->set_rules('agency_fax', 'Fax', 'trim|required');
                $this->form_validation->set_rules('agency_city', 'City', 'trim|required');
                $this->form_validation->set_rules('agency_state', 'State', 'trim|required');
                $this->form_validation->set_rules('agency_zip', 'Zip', 'trim|required');
                $this->form_validation->set_rules('agency_group', 'Group', 'trim|required');
                $this->form_validation->set_rules('agency_logo', 'Logo', 'trim|required');
                $this->form_validation->set_rules('taxonomy', 'Taxonomy', 'trim|required');


                if ($this->form_validation->run() != false) {

                    $dataArray                      =   [];
                    $dataArray['agency_code']       =   $this->input->post('agency_code',true);
                    $dataArray['ADP_code']          =   $this->input->post('adp_code',true);
                    $dataArray['adp_batch_id']          = $this->input->post('adp_batch_id',true);                    
                    $dataArray['agency_shortname']  =   $this->input->post('agency_shortname',true);
                    $dataArray['agency_name']       =   $this->input->post('agency_name',true);
                    $dataArray['agency_addr1']      =   $this->input->post('agency_addr1',true);
                    $dataArray['agency_addr2']      =   $this->input->post('agency_addr2',true);
                    $dataArray['agency_npi']        =   $this->input->post('agency_npi',true);
                    $dataArray['agency_providers']  =   $this->input->post('agency_providers',true);
                    $dataArray['agency_tax']        =   $this->input->post('agency_tax',true);
                    $dataArray['CMS150024J']        =   $this->input->post('CMS150024J',true);
                    $dataArray['agency_phone']      =   $this->input->post('agency_phone',true);
                    $dataArray['agency_fax']        =   $this->input->post('agency_fax',true);
                    $dataArray['agency_city']       =   $this->input->post('agency_city',true);
                    $dataArray['agency_state']      =   $this->input->post('agency_state',true);
                    $dataArray['agency_zip']        =   $this->input->post('agency_zip',true);
                    $dataArray['agency_group']      =   $this->input->post('agency_group',true);
                    $dataArray['agency_logo']       =   $this->input->post('agency_logo',true);
                    $dataArray['Taxonomy']          = $this->input->post('taxonomy',true);

                    $where              =   [];
                    $where['agency_id'] =   $pageId;

                    $updateId = $this->comman->update( "agency", $where, $dataArray );

                    if($updateId){
                        $this->app->message('Agency has been updated successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('agency','refresh');
                }
            }

            $data['page'] = 'Update Agency';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('agency/edit.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect('');
        }
    }  

    public function delete($recordId){
        if(!empty($recordId)){
            $recordId       = decode64($recordId);
            $where          = [];
            $where['agency_id'] = $recordId;
            $check = $this->comman->delete_row('agency',$where);
            $this->app->message('Agency has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

} 