<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class CronJob extends CI_Controller {

  public function __construct() {
      parent::__construct();
      $this->load->library('session');
      $this->load->helper('form');
      $this->load->helper('url');
      $this->load->helper('new_helper');
      $this->load->database();
      $this->load->library('form_validation');
      $this->load->model('Comman_model','comman');
      $this->load->model('Api_model');
      $this->load->model('Client_model', 'client');
      $this->load->library('user_agent');
      /**** load phpmailer library for send mail ****/ 
      $this->load->library('phpmailer_lib');
  }

  public function clientVisitOld() {

    $weeks = 1;
    $sql = "select * from client_visit_tracking order by id desc limit 1";
    $res = $this->comman->getCustomQueryData($sql, 'row');
    if(!empty($res)) {
      $weeks = $res['weeks']+1;
    }

    $supervisorData = $this->comman->get_rows('supervisor');
    if(!empty($supervisorData)) {
      $dataArray = [];
      foreach ($supervisorData as $key => $row) {
        $agency_code = $row['Agency'];
        $supervisor_id = $row['supervisor_id'];
        $location_id = $row['agency_location'];
        $where = [];
        $where['agency_location_code'] = $location_id;
        $locationData = $this->comman->get_row('agency_location', $where);
        $location_name = $locationData['agency_location_name'];
        $totalActiveClient = $this->comman->getActiveClient($agency_code, $supervisor_id,1);

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->comman->get_row('agency', $where);

        $totalClientOnHold = $this->comman->getActiveClient($agency_code, $supervisor_id, 2);    


        $cond = " supervisor_id = '$supervisor_id' AND ";
        if(!empty($location_id)) {
            $cond .= " agency_location = '$location_id' AND "; 
        }
        $overDueData = $this->client->get_client_status_report($agency_code, $cond, 1, 2);

        $totalOverdue = 0;
        foreach ($overDueData as $key => $row1) {
             
          $ptid = $row1['patient_id'];

          $where = [];
          $where['patient_id'] = $ptid;
          $where['Agency'] = $agency_code;
          $objResult2 = $this->comman->get_rows('tblpatientsvisits', $where, 'recid', 'desc');

          $VisitDoneDate = @$objResult2[0]['VisitDoneDate'];
      
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00') {
              $VisitDoneDate = date("Y-m-d",strtotime($row1['JobStartDate']));
              if($row1['JobStartDate'] == '' || $row1['JobStartDate'] == '0000-00-00'  || $row1['JobStartDate'] == '--' ) {
                $VisitDoneDate = "0000-00-00";
              }
          }

          $VisitDoneDate1 = date('Y-m-d', strtotime($VisitDoneDate));

          if ($row1['FHCA'] == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

          $days = $multiplex;
          $first = strtotime($VisitDoneDate); 
          $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
          $nextvisit = date("Y-m-d",$next); 
          $nextvisit1 = $nextvisit; 
          $datediff = $next - $first;
          $diff = ceil($datediff/(60*60*24));
          $today = date("Y-m-d");
          $date1 = new DateTime($VisitDoneDate);
          $date2 = new DateTime($nextvisit);

          $date2 = new DateTime($VisitDoneDate);
          $date1 = new DateTime($today);
           //$JobStartDate 
                
          $diff = $date2->diff($date1)->format("%a");
          
          $date2=date_create($today);
          $date1=date_create($nextvisit);
          $diff=date_diff($date1,$date2);
          $diff4 = $diff->format("%a");

                                
          //if ($diff <= $multiplex )  { $diff = 0;}
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00'  ) { 
            $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
          } else {
            $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
            $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
          }

          if ($diff4 > $multiplex &&  $VisitDoneDate1<=$today) { $val = 'true';} else  { $val = '';}     
          $Days_Before_Overdue = $overdue = '';
          if ( $today <= $nextvisit1 ) {
            if ( $diff4!='' ) {
              $Days_Before_Overdue = $diff4;    
              //$totalOverdue++;
            }
          } else {
            if ( $diff4!='' ) {
              $val = 'true';    
              $totalOverdue++;
              $overdue = $diff4;    
            }
          }
        }

        $percentage = ($totalOverdue*100)/$totalActiveClient;
        $percentage = number_format((float)$percentage, 2, '.', '');

        $dataArray[$key]['transaction_date'] = date('Y-m-d');
        $dataArray[$key]['supervisor'] = $row['name'];
        $dataArray[$key]['supervisor_id'] = $row['supervisor_id'];
        $dataArray[$key]['agency'] = $agencyData['agency_codename'];
        $dataArray[$key]['agency_id'] = $agency_code;
        $dataArray[$key]['location'] = $location_name;
        $dataArray[$key]['location_id'] = $location_id;
        $dataArray[$key]['active_clients'] = $totalActiveClient;
        $dataArray[$key]['onhold_clients'] = $totalClientOnHold;        
        $dataArray[$key]['visit_overdue'] = $totalOverdue;
        $dataArray[$key]['percentage'] = $percentage;
        $dataArray[$key]['weeks'] = $weeks;        

        if($totalActiveClient>0) {
          $this->comman->insert('client_visit_tracking', $dataArray[$key]);  
        }
      }
      //print_r($dataArray);
    }
  }


  public function clientVisit() {

    $weeks = 1;
    $sql = "select * from client_visit_tracking order by id desc limit 1";
    $res = $this->comman->getCustomQueryData($sql, 'row');
    if(!empty($res)) {
      $weeks = $res['weeks']+1;
    }

    $where = [];
    $allAgencyData = $this->comman->get_rows('agency', $where);
    foreach ($allAgencyData as $key => $raw) {
      $where = [];
      $where['supervisor_id!='] = 0;
      $supervisorData = $this->comman->get_rows('supervisor', $where);  
      $dataArray = [];
      foreach ($supervisorData as $key => $row) {
        $agency_code = $raw['agency_code'];  
        $supervisor_id = $row['supervisor_id'];
        $location_id = $row['agency_location'];

        $where = [];
        $where['agency_location_code'] = $location_id;
        $locationData = $this->comman->get_row('agency_location', $where);
        $location_name = $locationData['agency_location_name'];
        $totalActiveClient = $this->comman->getActiveClient($agency_code, $supervisor_id,1);

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->comman->get_row('agency', $where);
        $totalClientOnHold = $this->comman->getActiveClient($agency_code, $supervisor_id, 2); 

        $cond = " supervisor_id = '$supervisor_id' AND ";
        if(!empty($location_id)) {
            $cond .= " agency_location = '$location_id' AND "; 
        }

        $cond .= " on_hold = 'no' AND "; 
        $overDueData = $this->client->get_client_status_report($agency_code, $cond, 1, 2);

        $totalOverdue = 0;
        $HMKRHours = 0;
        foreach ($overDueData as $key => $row1) {
             
          $ptid = $row1['patient_id'];

          $where = [];
          $where['patient_id'] = $ptid;
          $where['Agency'] = $agency_code;
          $objResult2 = $this->comman->get_rows('tblpatientsvisits', $where, 'recid', 'desc');

          $VisitDoneDate = @$objResult2[0]['VisitDoneDate'];
      
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00') {
              $VisitDoneDate = date("Y-m-d",strtotime($row1['JobStartDate']));
              if($row1['JobStartDate'] == '' || $row1['JobStartDate'] == '0000-00-00'  || $row1['JobStartDate'] == '--' ) {
                $VisitDoneDate = "0000-00-00";
              }
          }

          $VisitDoneDate1 = date('Y-m-d', strtotime($VisitDoneDate));

          if ($row1['FHCA'] == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

          $days = $multiplex;
          $first = strtotime($VisitDoneDate); 
          $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
          $nextvisit = date("Y-m-d",$next); 
          $nextvisit1 = $nextvisit; 
          $datediff = $next - $first;
          $diff = ceil($datediff/(60*60*24));
          $today = date("Y-m-d");
          $date1 = new DateTime($VisitDoneDate);
          $date2 = new DateTime($nextvisit);

          $date2 = new DateTime($VisitDoneDate);
          $date1 = new DateTime($today);
           //$JobStartDate 
                
          $diff = $date2->diff($date1)->format("%a");
          
          $date2=date_create($today);
          $date1=date_create($nextvisit);
          $diff=date_diff($date1,$date2);
          $diff4 = $diff->format("%a");

                                
          //if ($diff <= $multiplex )  { $diff = 0;}
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00'  ) { 
            $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
          } else {
            $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
            $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
          }

          if ($diff4 > $multiplex &&  $VisitDoneDate1<=$today) { $val = 'true';} else  { $val = '';}     
          $Days_Before_Overdue = $overdue = '';
          if ( $today <= $nextvisit1 ) {
            if ( $diff4!='' ) {
              $Days_Before_Overdue = $diff4;    
              //$totalOverdue++;
            }
          } else {
            if ( $diff4!='' ) {
              $val = 'true';    
              $totalOverdue++;
              $overdue = $diff4;    
            }
          }

          $where = [];
          $where['patient_id'] = $ptid;
          $where['IsActive'] = 1;
          $ptData = $this->comman->get_row('patient', $where);
          $HMKRHours = $HMKRHours + $ptData['HMKRHours'];

        }

        $percentage = ($totalOverdue*100)/$totalActiveClient;
        $percentage = number_format((float)$percentage, 2, '.', '');

        $dataArray[$key]['transaction_date'] = date('Y-m-d');
        $dataArray[$key]['supervisor'] = $row['name'];
        $dataArray[$key]['supervisor_id'] = $row['supervisor_id'];
        $dataArray[$key]['agency'] = $agencyData['agency_codename'];
        $dataArray[$key]['agency_id'] = $agency_code;
        $dataArray[$key]['location'] = $location_name;
        $dataArray[$key]['location_id'] = $location_id;
        $dataArray[$key]['active_clients'] = $totalActiveClient;
        $dataArray[$key]['onhold_clients'] = $totalClientOnHold;        
        $dataArray[$key]['visit_overdue'] = $totalOverdue;
        $dataArray[$key]['percentage'] = $percentage;
        $dataArray[$key]['weeks'] = $weeks;        
        $dataArray[$key]['HMKRHours'] = $HMKRHours;        

        if($totalActiveClient>0) {
          $this->comman->insert('client_visit_tracking', $dataArray[$key]);  
        }

      }
    }
  }


  public function clientVisit2() {

    $weeks = 1;
    $sql = "select * from client_visit_tracking_test order by id desc limit 1";
    $res = $this->comman->getCustomQueryData($sql, 'row');
    if(!empty($res)) {
      $weeks = $res['weeks']+1;
    }

    $where = [];
    $allAgencyData = $this->comman->get_rows('agency', $where);
    foreach ($allAgencyData as $key => $raw) {
      $where = [];
      $where['supervisor_id!='] = 0;
      $supervisorData = $this->comman->get_rows('supervisor', $where);  
      $dataArray = [];
      foreach ($supervisorData as $key => $row) {
        $agency_code = $raw['agency_code'];  
        $supervisor_id = $row['supervisor_id'];
        $location_id = $row['agency_location'];

        $where = [];
        $where['agency_location_code'] = $location_id;
        $locationData = $this->comman->get_row('agency_location', $where);
        $location_name = $locationData['agency_location_name'];
        $totalActiveClient = $this->comman->getActiveClient($agency_code, $supervisor_id,1);

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->comman->get_row('agency', $where);
        $totalClientOnHold = $this->comman->getActiveClient($agency_code, $supervisor_id, 2); 

        $cond = " supervisor_id = '$supervisor_id' AND ";
        if(!empty($location_id)) {
            $cond .= " agency_location = '$location_id' AND "; 
        }

        $overDueData = $this->client->get_client_status_report($agency_code, $cond, 1, 2);

        $totalOverdue = 0;
        foreach ($overDueData as $key => $row1) {
             
          $ptid = $row1['patient_id'];

          $where = [];
          $where['patient_id'] = $ptid;
          $where['Agency'] = $agency_code;
          $objResult2 = $this->comman->get_rows('tblpatientsvisits', $where, 'recid', 'desc');

          $VisitDoneDate = @$objResult2[0]['VisitDoneDate'];
      
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00') {
              $VisitDoneDate = date("Y-m-d",strtotime($row1['JobStartDate']));
              if($row1['JobStartDate'] == '' || $row1['JobStartDate'] == '0000-00-00'  || $row1['JobStartDate'] == '--' ) {
                $VisitDoneDate = "0000-00-00";
              }
          }

          $VisitDoneDate1 = date('Y-m-d', strtotime($VisitDoneDate));

          if ($row1['FHCA'] == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

          $days = $multiplex;
          $first = strtotime($VisitDoneDate); 
          $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
          $nextvisit = date("Y-m-d",$next); 
          $nextvisit1 = $nextvisit; 
          $datediff = $next - $first;
          $diff = ceil($datediff/(60*60*24));
          $today = date("Y-m-d");
          $date1 = new DateTime($VisitDoneDate);
          $date2 = new DateTime($nextvisit);

          $date2 = new DateTime($VisitDoneDate);
          $date1 = new DateTime($today);
           //$JobStartDate 
                
          $diff = $date2->diff($date1)->format("%a");
          
          $date2=date_create($today);
          $date1=date_create($nextvisit);
          $diff=date_diff($date1,$date2);
          $diff4 = $diff->format("%a");

                                
          //if ($diff <= $multiplex )  { $diff = 0;}
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00'  ) { 
            $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
          } else {
            $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
            $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
          }

          if ($diff4 > $multiplex &&  $VisitDoneDate1<=$today) { $val = 'true';} else  { $val = '';}     
          $Days_Before_Overdue = $overdue = '';
          if ( $today <= $nextvisit1 ) {
            if ( $diff4!='' ) {
              $Days_Before_Overdue = $diff4;    
              //$totalOverdue++;
            }
          } else {
            if ( $diff4!='' ) {
              $val = 'true';    
              $totalOverdue++;
              $overdue = $diff4;    
            }
          }
        }

        $percentage = ($totalOverdue*100)/$totalActiveClient;
        $percentage = number_format((float)$percentage, 2, '.', '');

        $dataArray[$key]['transaction_date'] = date('Y-m-d');
        $dataArray[$key]['supervisor'] = $row['name'];
        $dataArray[$key]['supervisor_id'] = $row['supervisor_id'];
        $dataArray[$key]['agency'] = $agencyData['agency_codename'];
        $dataArray[$key]['agency_id'] = $agency_code;
        $dataArray[$key]['location'] = $location_name;
        $dataArray[$key]['location_id'] = $location_id;
        $dataArray[$key]['active_clients'] = $totalActiveClient;
        $dataArray[$key]['onhold_clients'] = $totalClientOnHold;        
        $dataArray[$key]['visit_overdue'] = $totalOverdue;
        $dataArray[$key]['percentage'] = $percentage;
        $dataArray[$key]['weeks'] = $weeks;        

        if($totalActiveClient>0) {
          $this->comman->insert('client_visit_tracking_test', $dataArray[$key]);  
        }

      }
    }

    /************ SEPARATION ****************/
    /*
    if(!empty($supervisorData)) {
      $dataArray = [];
      foreach ($supervisorData as $key => $row) {
        $agency_code = $row['Agency'];
        $supervisor_id = $row['supervisor_id'];
        $location_id = $row['agency_location'];
        $where = [];
        $where['agency_location_code'] = $location_id;
        $locationData = $this->comman->get_row('agency_location', $where);
        $location_name = $locationData['agency_location_name'];
        $totalActiveClient = $this->comman->getActiveClient($agency_code, $supervisor_id,1);

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->comman->get_row('agency', $where);

        $totalClientOnHold = $this->comman->getActiveClient($agency_code, $supervisor_id, 2);    


        $cond = " supervisor_id = '$supervisor_id' AND ";
        if(!empty($location_id)) {
            $cond .= " agency_location = '$location_id' AND "; 
        }
        $overDueData = $this->client->get_client_status_report($agency_code, $cond, 1, 2);

        $totalOverdue = 0;
        foreach ($overDueData as $key => $row1) {
             
          $ptid = $row1['patient_id'];

          $where = [];
          $where['patient_id'] = $ptid;
          $where['Agency'] = $agency_code;
          $objResult2 = $this->comman->get_rows('tblpatientsvisits', $where, 'recid', 'desc');

          $VisitDoneDate = @$objResult2[0]['VisitDoneDate'];
      
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00') {
              $VisitDoneDate = date("Y-m-d",strtotime($row1['JobStartDate']));
              if($row1['JobStartDate'] == '' || $row1['JobStartDate'] == '0000-00-00'  || $row1['JobStartDate'] == '--' ) {
                $VisitDoneDate = "0000-00-00";
              }
          }

          $VisitDoneDate1 = date('Y-m-d', strtotime($VisitDoneDate));

          if ($row1['FHCA'] == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

          $days = $multiplex;
          $first = strtotime($VisitDoneDate); 
          $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
          $nextvisit = date("Y-m-d",$next); 
          $nextvisit1 = $nextvisit; 
          $datediff = $next - $first;
          $diff = ceil($datediff/(60*60*24));
          $today = date("Y-m-d");
          $date1 = new DateTime($VisitDoneDate);
          $date2 = new DateTime($nextvisit);

          $date2 = new DateTime($VisitDoneDate);
          $date1 = new DateTime($today);
           //$JobStartDate 
                
          $diff = $date2->diff($date1)->format("%a");
          
          $date2=date_create($today);
          $date1=date_create($nextvisit);
          $diff=date_diff($date1,$date2);
          $diff4 = $diff->format("%a");

                                
          //if ($diff <= $multiplex )  { $diff = 0;}
          if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00'  ) { 
            $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
          } else {
            $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
            $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
          }

          if ($diff4 > $multiplex &&  $VisitDoneDate1<=$today) { $val = 'true';} else  { $val = '';}     
          $Days_Before_Overdue = $overdue = '';
          if ( $today <= $nextvisit1 ) {
            if ( $diff4!='' ) {
              $Days_Before_Overdue = $diff4;    
              //$totalOverdue++;
            }
          } else {
            if ( $diff4!='' ) {
              $val = 'true';    
              $totalOverdue++;
              $overdue = $diff4;    
            }
          }
        }

        $percentage = ($totalOverdue*100)/$totalActiveClient;
        $percentage = number_format((float)$percentage, 2, '.', '');

        $dataArray[$key]['transaction_date'] = date('Y-m-d');
        $dataArray[$key]['supervisor'] = $row['name'];
        $dataArray[$key]['supervisor_id'] = $row['supervisor_id'];
        $dataArray[$key]['agency'] = $agencyData['agency_codename'];
        $dataArray[$key]['agency_id'] = $agency_code;
        $dataArray[$key]['location'] = $location_name;
        $dataArray[$key]['location_id'] = $location_id;
        $dataArray[$key]['active_clients'] = $totalActiveClient;
        $dataArray[$key]['onhold_clients'] = $totalClientOnHold;        
        $dataArray[$key]['visit_overdue'] = $totalOverdue;
        $dataArray[$key]['percentage'] = $percentage;
        $dataArray[$key]['weeks'] = $weeks;        

        if($totalActiveClient>0) {
          $this->comman->insert('client_visit_tracking', $dataArray[$key]);  
        }
      }
      //print_r($dataArray);
    }*/
  }


  public function trackCovid19VaxEmployee() {
    $where = [];
    $allAgencyData = $this->comman->get_rows('agency', $where);
    $x=0;
    foreach ($allAgencyData as $key => $row) {
      $where = [];
      $where['Agency'] = $row['agency_code'];
      $where['covid_vax'] = 1;
      $employeeData = $this->comman->get_rows('employee', $where);      
      if(!empty($employeeData)) {

        foreach ($employeeData as $key => $empRow) {
          $where = [];
          $where['supervisor_id'] = $empRow['supervisor_id'];
          $supData = $this->comman->get_row('supervisor', $where);
          $dataArray = [];
          if(!empty($supData)) {
            $dataArray['supervisor_id'] = $empRow['supervisor_id'];
            $dataArray['supervisor_name'] = $supData['name'];

            $where = [];
            $where['agency_location_code'] = $supData['agency_location'];
            $locationData = $this->comman->get_row('agency_location', $where);

            $dataArray['location_id'] = $supData['agency_location'];
            $dataArray['location'] = $locationData['agency_location_name'];
          }
          $dataArray['Agency'] = $row['agency_code'];
          $dataArray['month_number'] = date('m');
          $dataArray['months'] = date('F');
          $dataArray['year'] = date('Y');
          $dataArray['employee_id'] = $empRow['employee_id'];
          $dataArray['employee_name'] = $empRow['name'];
          if($empRow['covid_vax']==1) {
            $covid_vax = 'Yes';
          } else {
            $covid_vax = 'No';
          }
          $dataArray['vaccinated'] = $covid_vax;
          $dataArray['positive'] = $empRow['covid_test_positive'];
          $this->comman->insert('tracking_covid19vax_employee', $dataArray);
          $x++;
        }
      }
    }

    echo $x .' new records has been insert successfully.';
  }

  public function trackCovid19VaxPatient() {
    $where = [];
    $allAgencyData = $this->comman->get_rows('agency', $where);
    $x=0;
    foreach ($allAgencyData as $key => $row) {
      $where = [];
      $where['Agency'] = $row['agency_code'];
      $where['covid_vax'] = 1;
      $patientData = $this->comman->get_rows('patient', $where);      
      if(!empty($patientData)) {
        foreach ($patientData as $key => $patRow) {
          $where = [];
          $where['supervisor_id'] = $patRow['supervisor_id'];
          $supData = $this->comman->get_row('supervisor', $where);
          $dataArray = [];
          if(!empty($supData)) {
            $dataArray['supervisor_id'] = $patRow['supervisor_id'];
            $dataArray['supervisor_name'] = $supData['name'];

            $where = [];
            $where['agency_location_code'] = $supData['agency_location'];
            $locationData = $this->comman->get_row('agency_location', $where);

            $dataArray['location_id'] = $supData['agency_location'];
            $dataArray['location'] = $locationData['agency_location_name'];
          }
          $dataArray['Agency'] = $row['agency_code'];
          $dataArray['month_number'] = date('m');
          $dataArray['months'] = date('F');
          $dataArray['year'] = date('Y');
          $dataArray['patient_id'] = $patRow['patient_id'];
          $dataArray['patient_name'] = $patRow['name'];
          if($patRow['covid_vax']==1) {
            $covid_vax = 'Yes';
          } else {
            $covid_vax = 'No';
          }
          $dataArray['vaccinated'] = $covid_vax;
          //$dataArray['positive'] = $patRow['covid_test_positive'];
          $this->comman->insert('tracking_covid19vax_patient', $dataArray);
          $x++;
        }
      }
    }
    echo $x .' new records has been insert successfully.';
  }

  public function patientTimerOld() {
    $startTime = date('H:i a');
    $ZERO = 0;           
    /* if (date('d') == 1)  {
      $query = mysql_query("UPDATE  employee_assignment SET  monthly_sum = '$ZERO'" ) or die (mysql_error());
    } */
    $p = '1242';
    $DAYBEFORE = date("Y-m-d");  
    $STARTDATE =  date('Y-m-d', strtotime($DAYBEFORE. ' -14 days'));

    echo "date:".$STARTDATE;
    //$STARTDATE = '2020-02-24';
    $MONTH = date("m");
    $YEAR= date("Y");
    //$MONTH = 2;
    //$YEAR= 2020;
    $strSQL1 = "SELECT * FROM patient where IsActive = 1 ";   
    $objExec1 = get_custom_query_data($strSQL1);
    foreach ($objExec1 as $key => $objResult1) {
      $patient_id = $objResult1["patient_id"];
      $supervisor_id = $objResult1["supervisor_id"];
      $Agency = $objResult1["Agency"];


      /******* patienttimer.php code start ********/
      $DistrictID_Ref = $objResult1["DistrictID_Ref"];
      $full_hours = "";
      $distSQL1 = "SELECT * FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref' AND Agency = '$Agency'" ;
      $distResult1 = get_custom_query_data($distSQL1, 'row');
      if (!empty($distResult1)) {
        $full_hours = $distResult1['full_hours'];   
      }   
      //$patient_id = $objResult1["patient_id"];     
      $A = $objResult1["HMKRHours"];
      /******* patienttimer.php code end ********/


      $strSQL3 = "SELECT * FROM employee_assignment WHERE patient_id = $patient_id  ";
      $objExec3 = get_custom_query_data($strSQL3);
      foreach ($objExec3 as $key => $objResult3) {
        $employee_id =$objResult3["employee_id"];
        
        if ($Agency == 2 || $Agency  == 4) {
          $strSQL4 = "SELECT  * FROM employee_2weekly WHERE start_date >= '$STARTDATE' and patient_id =  '$patient_id' AND employee_id = '$employee_id'";
          $objExec4 = get_custom_query_data($strSQL4);
          echo $strSQL4."</br>";
          if(!empty($objExec4)) {
            foreach ($objExec4 as $key => $objResult4) {
              for ($num = 1; $num <= 14; $num++ ) {
                $z = sprintf("%02s", $num); 
                $fld = 'date'.$z;
                $val = 'd'.$z;
                $dte = $objResult4[$fld]; 
                $totweek = $totweek +  $objResult4[$val]; 
                $hrs = $objResult4[$val];
                if ($dte != '0000-00-00')  {
                  $chkSQL = "SELECT * FROM employee_timesheet_weekly WHERE end_date >= '$dte' AND start_date  <= '$dte'";
                  $chkResult = get_custom_query_data($chkSQL, 'row');
                  if (!empty($chkResult)) {
                    $start = $chkResult['start_date'];
                    $end= $chkResult['end_date'];
                  }               

                  $checkSQL = "SELECT * FROM employee_monthly WHERE patient_id = '$patient_id' AND employee_id = '$employee_id' AND dtrtransdate = '$dte'";
                  $checkResult = get_custom_query_data($checkSQL, 'row');
                  if (empty($checkResult))  {
                    echo "xxxxx".$dte."  ".$start." ".$hrs."</br>";
                    $month = date("m",strtotime($dte));
                    $year = date("Y",strtotime($dte));
                    $insert = "INSERT INTO employee_monthly (
                    employee_monthly_id,
                    patient_id,
                    employee_id,
                    dtrtransdate,
                    hours,
                    weekdate,
                    month,
                    year,
                    supervisor_id
                    ) VALUES (
                    null,
                    '$patient_id',
                    '$employee_id',
                    '$dte',
                    '$hrs',
                    '$start',
                    '$month',
                    '$year',
                    '$supervisor_id'
                    ) ";
                    ////customInsertHelper($insert);
                  }                 

                  $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND weekdate = '$start' ";
                  $objResult = get_custom_query_data($strSQL, 'row');
                  $HRS = $objResult["HRS"];

                  $query2 = "UPDATE employee_monthly SET weekly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND weekdate = '$start'";
                  ////customUpdateHelper($query2);

                  $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND month = '$month' AND year = '$year' ";
                  $objResult = get_custom_query_data($strSQL, 'row');
                  $HRS = $objResult["HRS"];

                  $query2 = "UPDATE employee_monthly SET monthly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND month = '$month' AND year = '$year'";
                  ////customUpdateHelper($query2);
                }
              }
            }
          }


          /*********** update.php code start **************/
          $STARTDATE2 = date("Y-m-d");
          $MONTH2 = date("m");
          $YEAR2 = date("Y");

          echo "SC/RF";

          $chkSQL = "SELECT * FROM employee_timesheet_weekly WHERE end_date >= '$STARTDATE2' AND start_date  <= '$STARTDATE2'";
          $chkResult = get_custom_query_data($chkSQL, 'row');

          if (!empty($chkResult)) {
            $start = $chkResult['start_date'];
            $end= $chkResult['end_date'];
          }               
          $strSQL = "SELECT * FROM employee_monthly WHERE patient_id = $patient_id AND weekdate = '$start' ";
          $objResult = get_custom_query_data($strSQL, 'row');
          if(!empty($objResult)) {
            $monthly_sum = $objResult["monthly_sum"];
            $weekly_sum = $objResult["weekly_sum"];
            $query = "UPDATE employee_assignment SET compute_current_week_worked_hours = '$weekly_sum', compute_approved_worked_hours ='$monthly_sum' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id'";
            ////customUpdateHelper($query);
          }
          /*********** update.php code end **************/
        }

        if ($Agency == 1 || $Agency == 3) {
          $strSQL4 = "SELECT * FROM employee_timesheet WHERE month >= '$MONTH' AND year >= '$YEAR' AND patient_id =  '$patient_id' AND employee_id = '$employee_id' ";
          $objExec4 = get_custom_query_data($strSQL4);
          echo $strSQL4."</br>";

          if(!empty($objExec4)) {
            foreach ($objExec4 as $key => $objResult4) {
              $year = $objResult4["year"];
              $month = $objResult4["month"];
              $dt = date("$year-$month-01");

              $first = date("Y-m-01", strtotime($dt));
              $last = date("Y-m-t", strtotime($dt));

              $lst = date("t",strtotime($last));
              for ($num = 1; $num <= $lst ; $num++ )  {
                $z = sprintf("%02s", $num); 
                $val = 'day'.$z;
                $dte ="$year-$month-$z";
                $hrs = $objResult4[$val];
                $chkSQL = "SELECT * FROM employee_timesheet_weekly WHERE end_date >= '$dte' AND start_date  <= '$dte'";
                $chkResult = get_custom_query_data($chkSQL, 'row');
                if (!empty($chkResult)) {
                  $start = $chkResult['start_date'];
                  $end= $chkResult['end_date'];
                }              

                if ($hrs != 0)  {                        
                  echo $dte."  ".$start." ".$hrs."</br>";
                  $checkSQL = "SELECT * FROM employee_monthly WHERE  patient_id = '$patient_id'  AND employee_id = '$employee_id' AND dtrtransdate = '$dte'";
                  $checkResult = get_custom_query_data($checkSQL, 'row');
                  if (empty($checkResult)) {
                    $insert = "INSERT INTO  employee_monthly (
                    employee_monthly_id,
                    patient_id,
                    employee_id,
                    dtrtransdate,
                    hours,
                    weekdate,
                    month,
                    year,
                    supervisor_id
                    ) VALUES (
                    null,
                    '$patient_id',
                    '$employee_id',
                    '$dte',
                    '$hrs',
                    '$start',
                    '$month',
                    '$year',
                    '$supervisor_id'
                    ) ";
                    ////customInsertHelper($insert);
                  }

                  $query2 = "UPDATE employee_monthly SET weekly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND weekdate = '$start' ";
                  ////customUpdateHelper($query2);

                  $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND month = '$month' AND year = '$year' ";
                  $objResult = get_custom_query_data($strSQL, 'row');
                  $HRS = $objResult["HRS"];

                  $query2 = "UPDATE employee_monthly SET monthly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND month = '$month' AND year = '$year'";             
                  ////customUpdateHelper($query2);
                }
              }
            }
          }

          /*********** update.php code start **************/
          echo "HM/CG";
          $STARTDATE2 = date("Y-m-d");
          $MONTH2 = date("m");
          $YEAR2 = date("Y");
          $strSQL = "SELECT * FROM employee_monthly WHERE patient_id = $patient_id AND month = '$MONTH2' AND year = '$YEAR2' ";
          $objResult = get_custom_query_data($strSQL, 'row');

          if(!empty($objResult)) {
            $monthly_sum = $objResult["monthly_sum"];
            $weekly_sum = $objResult["weekly_sum"];
            $query = "UPDATE employee_assignment SET compute_current_week_worked_hours = '$weekly_sum', compute_approved_worked_hours  ='$monthly_sum' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id'";
            ////customUpdateHelper($query);
          }
          /*********** update.php code end **************/
        }


        /********** patienttimer.php code start *************/
        $sql0 = "SELECT total_limit FROM employee_assignment WHERE patient_id = '$patient_id'";
        $row0 = get_custom_query_data($sql0, 'row');

        //$sql1 = "SELECT * FROM employee_assignment WHERE patient_id = '$patient_id' AND employee_id = '$employee_id'";
        //$res1 = get_custom_query_data($sql1); 
        //foreach ($res1 as $key => $row1) {

          //$B = $row1["total_limit"];  // daily limit per day
          $day = date('D');
          // echo $day;
          if ($day == 'Mon')  {
            $B = $objResult3["mon_limit"];  echo "Mon";
          }
          if ($day == 'Tue')  {
            $B = $objResult3["tue_limit"];  echo "Tue";
          }
          if ($day == 'Wed')  {
            $B = $objResult3["wed_limit"];  echo "Wed";
          }
          if ($day == 'Thu')  {
            $B = $objResult3["thu_limit"];  echo "thu";
          }     
          if ($day == 'Fri')  {
            $B = $objResult3["fri_limit"];  echo "Fri";
          }
          if ($day == 'Sat')  {
            $B = $objResult3["sat_limit"]; echo "Sat";
          }
          if ($day == 'Sun')  {
            $B = $objResult3["sun_limit"]; echo "Sun"; 
          }

          $C = $objResult3["compute_approved_worked_hours"];   // $C total monthly worked hours
          $D = $A - $C;   // $ A = Approve Hours
          $E = $objResult3["timer_approved_hours"];
          $F = $objResult3["compute_current_weekly_hours"];
          //user :itops
          //Tupper2019itops
          $G = $objResult3["compute_current_week_worked_hours"];

          echo "".$patient_id." - ".$objResult1["lastname"].$objResult1["firstname"]."</BR>";
          echo "</br>";
          echo "A=".$A."</br>";
          echo "B=".$B."</br>";
          echo "C=".$C."</br>";
          echo "D=".$D."</br>";
          echo "E=".$E."</br>";
          echo "</BR>FULL HOURS=".$full_hours."</BR>";

          if ($full_hours  == "yes") {
            if ($D >= $C ) {
              $E = $B;  
            } else {
              $E = $D;                        
            }                       
            $query = "UPDATE employee_assignment SET timer_approved_hours = '$E' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id' ";
            ////customUpdateHelper($query);
          } else {
            $H = $F - $G;
            if ($H >= $B)  {
              $E =  $B;
            } else {
              $E = $H;
            }                       
            $query2 = "UPDATE employee_assignment SET timer_approved_hours = '$E' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id'";
            ////customUpdateHelper($query2);
          }
        //}
        /********** patienttimer.php code end *************/
      }
    }

    echo 'Success <br>';  

    $endTime = date('H:i a');
    echo 'Start Time: '.$startTime.'<br>';
    echo 'End Time: '.$endTime.'<br>';
  }


  public function patientTimer() {
    $startTime = date('H:i a');
    $ZERO = 0;           
    /* if (date('d') == 1)  {
      $query = mysql_query("UPDATE  employee_assignment SET  monthly_sum = '$ZERO'" ) or die (mysql_error());
    } */
    $p = '1242';
    $DAYBEFORE = date("Y-m-d");  
    //$STARTDATE =  date('Y-m-d', strtotime($DAYBEFORE. ' -14 days'));

    //$chkSQL = "SELECT * FROM table_2weekly WHERE end_date >= '$DAYBEFORE' AND start_date  <= '$DAYBEFORE'";
    $chkSQL = "SELECT * FROM employee_timesheet_weekly WHERE end_date >= '$DAYBEFORE' AND start_date  <= '$DAYBEFORE'";
    $chkResult = get_custom_query_data($chkSQL, 'row');
    $STARTDATE = $chkResult['start_date'];

    echo "date:".$STARTDATE;
    //$STARTDATE = '2020-02-24';
    //$MONTH = date("m");
    //$YEAR= date("Y");

    $MONTH = date("m", strtotime($STARTDATE));
    $YEAR= date("Y", strtotime($STARTDATE));

    //$MONTH = 2;
    //$YEAR= 2020;
    $strSQL1 = "SELECT * FROM patient where IsActive = 1 ";   
    $objExec1 = get_custom_query_data($strSQL1);
    foreach ($objExec1 as $key => $objResult1) {
      $patient_id = $objResult1["patient_id"];
      $supervisor_id = $objResult1["supervisor_id"];
      $Agency = $objResult1["Agency"];


      /******* patienttimer.php code start ********/
      $DistrictID_Ref = $objResult1["DistrictID_Ref"];
      $full_hours = "";
      $distSQL1 = "SELECT * FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref' AND Agency = '$Agency'" ;
      $distResult1 = get_custom_query_data($distSQL1, 'row');
      if (!empty($distResult1)) {
        $full_hours = $distResult1['full_hours'];   
      }   
      //$patient_id = $objResult1["patient_id"];     
      $A = $objResult1["HMKRHours"];
      /******* patienttimer.php code end ********/


      $strSQL3 = "SELECT * FROM employee_assignment WHERE patient_id = $patient_id  ";
      $objExec3 = get_custom_query_data($strSQL3);
      foreach ($objExec3 as $key => $objResult3) {
        $employee_id =$objResult3["employee_id"];
        
        if ($Agency == 2 || $Agency  == 4) {
          $strSQL4 = "SELECT  * FROM employee_2weekly WHERE start_date >= '$STARTDATE' and patient_id =  '$patient_id' AND employee_id = '$employee_id'";
          $objExec4 = get_custom_query_data($strSQL4);
          echo $strSQL4."</br>";
          if(!empty($objExec4)) {
            foreach ($objExec4 as $key => $objResult4) {
              for ($num = 1; $num <= 14; $num++ ) {
                $z = sprintf("%02s", $num); 
                $fld = 'date'.$z;
                $val = 'd'.$z;
                $dte = $objResult4[$fld]; 
                $totweek = $totweek +  $objResult4[$val]; 
                $hrs = $objResult4[$val];
                if ($dte != '0000-00-00')  {
                  $chkSQL = "SELECT * FROM employee_timesheet_weekly WHERE end_date >= '$dte' AND start_date  <= '$dte'";
                  $chkResult = get_custom_query_data($chkSQL, 'row');
                  if (!empty($chkResult)) {
                    $start = $chkResult['start_date'];
                    $end= $chkResult['end_date'];
                  }               

                  $checkSQL = "SELECT * FROM employee_monthly WHERE patient_id = '$patient_id' AND employee_id = '$employee_id' AND dtrtransdate = '$dte'";
                  $checkResult = get_custom_query_data($checkSQL, 'row');
                  if (empty($checkResult))  {
                    echo "xxxxx".$dte."  ".$start." ".$hrs."</br>";
                    $month = date("m",strtotime($dte));
                    $year = date("Y",strtotime($dte));
                    $insert = "INSERT INTO employee_monthly (
                    employee_monthly_id,
                    patient_id,
                    employee_id,
                    dtrtransdate,
                    hours,
                    weekdate,
                    month,
                    year,
                    supervisor_id
                    ) VALUES (
                    null,
                    '$patient_id',
                    '$employee_id',
                    '$dte',
                    '$hrs',
                    '$start',
                    '$month',
                    '$year',
                    '$supervisor_id'
                    ) ";
                    customInsertHelper($insert);
                  }                 

                  $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND weekdate = '$start' ";
                  $objResult = get_custom_query_data($strSQL, 'row');
                  $HRS = $objResult["HRS"];

                  $query2 = "UPDATE employee_monthly SET weekly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND weekdate = '$start'";
                  customUpdateHelper($query2);

                  $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND month = '$month' AND year = '$year' ";
                  $objResult = get_custom_query_data($strSQL, 'row');
                  $HRS = $objResult["HRS"];

                  $query2 = "UPDATE employee_monthly SET monthly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND month = '$month' AND year = '$year'";
                  customUpdateHelper($query2);
                }
              }
            }
          } else {
            $insert = "INSERT INTO  employee_monthly (
            employee_monthly_id,
            patient_id,
            employee_id,
            dtrtransdate,
            hours,
            weekdate,
            month,
            year,
            supervisor_id
            ) VALUES (
            null,
            '$patient_id',
            '$employee_id',
            '$STARTDATE',
            '0.00',
            '$STARTDATE',
            '$MONTH',
            '$YEAR',
            '$supervisor_id'
            ) ";

            customInsertHelper($insert);

            $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND weekdate = '$STARTDATE' ";
            $objResult = get_custom_query_data($strSQL, 'row');
            $HRS = $objResult["HRS"];

            $query2 = "UPDATE employee_monthly SET weekly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND weekdate = '$STARTDATE'";
            customUpdateHelper($query2);

            $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND  month = '$MONTH' AND year = '$YEAR' ";
            $objResult = get_custom_query_data($strSQL, 'row');
            $HRS = $objResult["HRS"];

            $query2 = "UPDATE employee_monthly SET monthly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND month = '$MONTH' AND year = '$YEAR'";
            customUpdateHelper($query2);
          }


          /*********** update.php code start **************/
          $STARTDATE2 = date("Y-m-d");
          $MONTH2 = date("m");
          $YEAR2 = date("Y");

          echo "SC/RF";

          $chkSQL = "SELECT * FROM employee_timesheet_weekly WHERE end_date >= '$STARTDATE2' AND start_date  <= '$STARTDATE2'";
          $chkResult = get_custom_query_data($chkSQL, 'row');

          if (!empty($chkResult)) {
            $start = $chkResult['start_date'];
            $end= $chkResult['end_date'];
          }               
          $strSQL = "SELECT * FROM employee_monthly WHERE patient_id = $patient_id AND weekdate = '$start' ";
          $objResult = get_custom_query_data($strSQL, 'row');
          if(!empty($objResult)) {
            $monthly_sum = $objResult["monthly_sum"];
            $weekly_sum = $objResult["weekly_sum"];
            $query = "UPDATE employee_assignment SET compute_current_week_worked_hours = '$weekly_sum', compute_approved_worked_hours ='$monthly_sum' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id'";
            customUpdateHelper($query);
          }
          /*********** update.php code end **************/
        }

        if ($Agency == 1 || $Agency == 3) {
          $strSQL4 = "SELECT * FROM employee_timesheet WHERE month >= '$MONTH' AND year >= '$YEAR' AND patient_id =  '$patient_id' AND employee_id = '$employee_id' ";
          $objExec4 = get_custom_query_data($strSQL4);
          echo $strSQL4."</br>";

          if(!empty($objExec4)) {
            foreach ($objExec4 as $key => $objResult4) {
              $year = $objResult4["year"];
              $month = $objResult4["month"];
              $dt = date("$year-$month-01");

              $first = date("Y-m-01", strtotime($dt));
              $last = date("Y-m-t", strtotime($dt));

              $lst = date("t",strtotime($last));
              for ($num = 1; $num <= $lst ; $num++ )  {
                $z = sprintf("%02s", $num); 
                $val = 'day'.$z;
                $dte ="$year-$month-$z";
                $hrs = $objResult4[$val];
                $chkSQL = "SELECT * FROM employee_timesheet_weekly WHERE end_date >= '$dte' AND start_date  <= '$dte'";
                $chkResult = get_custom_query_data($chkSQL, 'row');
                if (!empty($chkResult)) {
                  $start = $chkResult['start_date'];
                  $end= $chkResult['end_date'];
                }              

                if ($hrs != 0)  {                        
                  echo $dte."  ".$start." ".$hrs."</br>";
                  $checkSQL = "SELECT * FROM employee_monthly WHERE  patient_id = '$patient_id'  AND employee_id = '$employee_id' AND dtrtransdate = '$dte'";
                  $checkResult = get_custom_query_data($checkSQL, 'row');
                  if (empty($checkResult)) {
                    $insert = "INSERT INTO employee_monthly (
                    employee_monthly_id,
                    patient_id,
                    employee_id,
                    dtrtransdate,
                    hours,
                    weekdate,
                    month,
                    year,
                    supervisor_id
                    ) VALUES (
                    null,
                    '$patient_id',
                    '$employee_id',
                    '$dte',
                    '$hrs',
                    '$start',
                    '$month',
                    '$year',
                    '$supervisor_id'
                    ) ";
                    customInsertHelper($insert);
                  }

                  $query2 = "UPDATE employee_monthly SET weekly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND weekdate = '$start' ";
                  customUpdateHelper($query2);

                  $strSQL = "SELECT SUM(hours) AS HRS FROM employee_monthly WHERE patient_id = $patient_id AND month = '$month' AND year = '$year' ";
                  $objResult = get_custom_query_data($strSQL, 'row');
                  $HRS = $objResult["HRS"];

                  $query2 = "UPDATE employee_monthly SET monthly_sum = '$HRS' WHERE patient_id  = '$patient_id' AND month = '$month' AND year = '$year'";             
                  customUpdateHelper($query2);
                }
              }
            }
          }

          /*********** update.php code start **************/
          echo "HM/CG";
          $STARTDATE2 = date("Y-m-d");
          $MONTH2 = date("m");
          $YEAR2 = date("Y");
          $strSQL = "SELECT * FROM employee_monthly WHERE patient_id = $patient_id AND month = '$MONTH2' AND year = '$YEAR2' ";
          $objResult = get_custom_query_data($strSQL, 'row');

          if(!empty($objResult)) {
            $monthly_sum = $objResult["monthly_sum"];
            $weekly_sum = $objResult["weekly_sum"];
            $query = "UPDATE employee_assignment SET compute_current_week_worked_hours = '$weekly_sum', compute_approved_worked_hours  ='$monthly_sum' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id'";
            customUpdateHelper($query);
          }
          /*********** update.php code end **************/
        }


        /********** patienttimer.php code start *************/
        $sql0 = "SELECT total_limit FROM employee_assignment WHERE patient_id = '$patient_id'";
        $row0 = get_custom_query_data($sql0, 'row');

        //$sql1 = "SELECT * FROM employee_assignment WHERE patient_id = '$patient_id' AND employee_id = '$employee_id'";
        //$res1 = get_custom_query_data($sql1); 
        //foreach ($res1 as $key => $row1) {

          //$B = $row1["total_limit"];  // daily limit per day
          $day = date('D');
          // echo $day;
          if ($day == 'Mon')  {
            $B = $objResult3["mon_limit"];  echo "Mon";
          }
          if ($day == 'Tue')  {
            $B = $objResult3["tue_limit"];  echo "Tue";
          }
          if ($day == 'Wed')  {
            $B = $objResult3["wed_limit"];  echo "Wed";
          }
          if ($day == 'Thu')  {
            $B = $objResult3["thu_limit"];  echo "thu";
          }     
          if ($day == 'Fri')  {
            $B = $objResult3["fri_limit"];  echo "Fri";
          }
          if ($day == 'Sat')  {
            $B = $objResult3["sat_limit"]; echo "Sat";
          }
          if ($day == 'Sun')  {
            $B = $objResult3["sun_limit"]; echo "Sun"; 
          }

          $C = $objResult3["compute_approved_worked_hours"];   // $C total monthly worked hours
          $D = $A - $C;   // $ A = Approve Hours
          $E = $objResult3["timer_approved_hours"];
          $F = $objResult3["compute_current_weekly_hours"];
          //user :itops
          //Tupper2019itops
          $G = $objResult3["compute_current_week_worked_hours"];

          echo "".$patient_id." - ".$objResult1["lastname"].$objResult1["firstname"]."</BR>";
          echo "</br>";
          echo "A=".$A."</br>";
          echo "B=".$B."</br>";
          echo "C=".$C."</br>";
          echo "D=".$D."</br>";
          echo "E=".$E."</br>";
          echo "</BR>FULL HOURS=".$full_hours."</BR>";

          if ($full_hours  == "yes") {
            if ($D >= $C ) {
              $E = $B;  
            } else {
              $E = $D;                        
            }                       
            $query = "UPDATE employee_assignment SET timer_approved_hours = '$E' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id' ";
            customUpdateHelper($query);
          } else {
            $H = $F - $G;
            if ($H >= $B)  {
              $E =  $B;
            } else {
              $E = $H;
            }                       
            $query2 = "UPDATE employee_assignment SET timer_approved_hours = '$E' WHERE patient_id  = '$patient_id' AND employee_id = '$employee_id'";
            customUpdateHelper($query2);
          }
        //}
        /********** patienttimer.php code end *************/
      }
    }

    echo 'Success <br>';  

    $endTime = date('H:i a');
    echo 'Start Time: '.$startTime.'<br>';
    echo 'End Time: '.$endTime.'<br>';
  }


  function mispunchDailyTracking3() {
    $tmpdte = date('Y-m-d');
    $agency_code = 3;

    $this->db->where('transaction_date',$tmpdte);
    $this->db->where('agency_id',$agency_code);
    $this->db->delete('employee_mispunch_tracking');

    $where = [];
    $where['su.firstname!='] = '';
    $where['su.supervisor_id!='] = 0;
    $allSupervisorData = $this->comman->getAssignedSupervisor($where, 'lastname', 'asc');
    foreach ($allSupervisorData as $key => $row) {

      $supervisorId = $row['supervisor_id'];

      $MySQLALL = "
      SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
      employee_clock.patient_id AS pt_id,
      employee_clock.employee_id,
      employee_clock.date,
      employee_clock.tagedit,
      employee_clock.latitude,
      employee_clock.longitude,
      employee_clock.isIn,
      employee_clock.employee_clock_id,
      employee.supervisor_id,
      patient.patient_id, 
      patient.name as pt_name,
      patient.phone,
      patient.Agency,
      employee.name as empl_name,
      employee.pin,
      supervisor.lastname as supl_lastname,
      supervisor.firstname as supl_firstname,
      supervisor.name as supl_name,
      supervisor.supervisor_id as supl_id
      FROM employee_clock,patient,employee,supervisor

      WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn >=  1  AND DATE(date) >='$tmpdte' AND DATE(date) <='$tmpdte' AND patient.Agency = '$agency_code' AND patient.supervisor_id='$supervisorId' AND reset IS NULL GROUP BY patient_id ORDER BY employee_clock_id ASC ";
      $mispunchDataBySup = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      foreach ($mispunchDataBySup as $key => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
        }
      }

      if(count($empArr)>0) {
        $where = [];
        $where['agency_location_code'] = $row['agency_location'];
        $locationData = $this->comman->get_row('agency_location', $where);

        $where = [];
        //$where['agency_code'] = $row['Agency'];
        $where['agency_code'] = $agency_code;              
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $tmpdte;
        $dataArray['supervisor'] = $row['name'];
        $dataArray['supervisor_id'] = $row['supervisor_id'];
        $dataArray['agency'] = $agencyData['agency_codename'];
        //$dataArray['agency_id'] = $row['Agency'];
        $dataArray['agency_id'] = $agency_code;
        $dataArray['location_id'] = $row['agency_location'];
        $dataArray['location'] = $locationData['agency_location_name'];
        $dataArray['total_employee'] = count($empArr);

        $this->comman->insert('employee_mispunch_tracking', $dataArray);
        //echo 'Records has been added successfully.';
      }
    }
    echo 'Scripts has been run successfully.';
  }


  function mispunchDailyTracking1() {
    $tmpdte = date('Y-m-d');
    $agency_code = 1;

    $this->db->where('transaction_date',$tmpdte);
    $this->db->where('agency_id',$agency_code);
    $this->db->delete('employee_mispunch_tracking');

    $where = [];
    $where['su.firstname!='] = '';
    $where['su.supervisor_id!='] = 0;
    $allSupervisorData = $this->comman->getAssignedSupervisor($where, 'lastname', 'asc');
    foreach ($allSupervisorData as $key => $row) {

      $supervisorId = $row['supervisor_id'];

      $MySQLALL = "
      SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
      employee_clock.patient_id AS pt_id,
      employee_clock.employee_id,
      employee_clock.date,
      employee_clock.tagedit,
      employee_clock.latitude,
      employee_clock.longitude,
      employee_clock.isIn,
      employee_clock.employee_clock_id,
      employee.supervisor_id,
      patient.patient_id, 
      patient.name as pt_name,
      patient.phone,
      patient.Agency,
      employee.name as empl_name,
      employee.pin,
      supervisor.lastname as supl_lastname,
      supervisor.firstname as supl_firstname,
      supervisor.name as supl_name,
      supervisor.supervisor_id as supl_id
      FROM employee_clock,patient,employee,supervisor

      WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn >=  1  AND DATE(date) >='$tmpdte' AND DATE(date) <='$tmpdte' AND patient.Agency = '$agency_code' AND patient.supervisor_id='$supervisorId' AND reset IS NULL GROUP BY patient_id ORDER BY employee_clock_id ASC ";
      $mispunchDataBySup = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      foreach ($mispunchDataBySup as $key => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
        }
      }

      if(count($empArr)>0) {
        $where = [];
        $where['agency_location_code'] = $row['agency_location'];
        $locationData = $this->comman->get_row('agency_location', $where);

        $where = [];
        //$where['agency_code'] = $row['Agency'];
        $where['agency_code'] = $agency_code;              
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $tmpdte;
        $dataArray['supervisor'] = $row['name'];
        $dataArray['supervisor_id'] = $row['supervisor_id'];
        $dataArray['agency'] = $agencyData['agency_codename'];
        //$dataArray['agency_id'] = $row['Agency'];
        $dataArray['agency_id'] = $agency_code;
        $dataArray['location_id'] = $row['agency_location'];
        $dataArray['location'] = $locationData['agency_location_name'];
        $dataArray['total_employee'] = count($empArr);

        $this->comman->insert('employee_mispunch_tracking', $dataArray);
        //echo 'Records has been added successfully.';
      }
    }
    echo 'Scripts has been run successfully.';
  }

  function mispunchDailyTracking4() {
    $tmpdte = date('Y-m-d');
    $agency_code = 4;

    $this->db->where('transaction_date',$tmpdte);
    $this->db->where('agency_id',$agency_code);
    $this->db->delete('employee_mispunch_tracking');

    $where = [];
    $where['su.firstname!='] = '';
    $where['su.supervisor_id!='] = 0;
    $allSupervisorData = $this->comman->getAssignedSupervisor($where, 'lastname', 'asc');
    foreach ($allSupervisorData as $key => $row) {

      $supervisorId = $row['supervisor_id'];

      $MySQLALL = "
      SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
      employee_clock.patient_id AS pt_id,
      employee_clock.employee_id,
      employee_clock.date,
      employee_clock.tagedit,
      employee_clock.latitude,
      employee_clock.longitude,
      employee_clock.isIn,
      employee_clock.employee_clock_id,
      employee.supervisor_id,
      patient.patient_id, 
      patient.name as pt_name,
      patient.phone,
      patient.Agency,
      employee.name as empl_name,
      employee.pin,
      supervisor.lastname as supl_lastname,
      supervisor.firstname as supl_firstname,
      supervisor.name as supl_name,
      supervisor.supervisor_id as supl_id
      FROM employee_clock,patient,employee,supervisor

      WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn >=  1  AND DATE(date) >='$tmpdte' AND DATE(date) <='$tmpdte' AND patient.Agency = '$agency_code' AND patient.supervisor_id='$supervisorId' AND reset IS NULL GROUP BY patient_id ORDER BY employee_clock_id ASC ";
      $mispunchDataBySup = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      foreach ($mispunchDataBySup as $key => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
        }
      }

      if(count($empArr)>0) {
        $where = [];
        $where['agency_location_code'] = $row['agency_location'];
        $locationData = $this->comman->get_row('agency_location', $where);

        $where = [];
        //$where['agency_code'] = $row['Agency'];
        $where['agency_code'] = $agency_code;              
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $tmpdte;
        $dataArray['supervisor'] = $row['name'];
        $dataArray['supervisor_id'] = $row['supervisor_id'];
        $dataArray['agency'] = $agencyData['agency_codename'];
        //$dataArray['agency_id'] = $row['Agency'];
        $dataArray['agency_id'] = $agency_code;
        $dataArray['location_id'] = $row['agency_location'];
        $dataArray['location'] = $locationData['agency_location_name'];
        $dataArray['total_employee'] = count($empArr);

        $this->comman->insert('employee_mispunch_tracking', $dataArray);
        //echo 'Records has been added successfully.';
      }
    }
    echo 'Scripts has been run successfully.';
  }

  function mispunchDailyTracking2() {
    $tmpdte = date('Y-m-d');
    $agency_code = 2;

    $this->db->where('transaction_date',$tmpdte);
    $this->db->where('agency_id',$agency_code);
    $this->db->delete('employee_mispunch_tracking');

    $where = [];
    $where['su.firstname!='] = '';
    $where['su.supervisor_id!='] = 0;
    $allSupervisorData = $this->comman->getAssignedSupervisor($where, 'lastname', 'asc');
    foreach ($allSupervisorData as $key => $row) {

      $supervisorId = $row['supervisor_id'];

      $MySQLALL = "
      SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
      employee_clock.patient_id AS pt_id,
      employee_clock.employee_id,
      employee_clock.date,
      employee_clock.tagedit,
      employee_clock.latitude,
      employee_clock.longitude,
      employee_clock.isIn,
      employee_clock.employee_clock_id,
      employee.supervisor_id,
      patient.patient_id, 
      patient.name as pt_name,
      patient.phone,
      patient.Agency,
      employee.name as empl_name,
      employee.pin,
      supervisor.lastname as supl_lastname,
      supervisor.firstname as supl_firstname,
      supervisor.name as supl_name,
      supervisor.supervisor_id as supl_id
      FROM employee_clock,patient,employee,supervisor

      WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn >=  1  AND DATE(date) >='$tmpdte' AND DATE(date) <='$tmpdte' AND patient.Agency = '$agency_code' AND patient.supervisor_id='$supervisorId' AND reset IS NULL GROUP BY patient_id ORDER BY employee_clock_id ASC ";
      $mispunchDataBySup = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      foreach ($mispunchDataBySup as $key => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
        }
      }

      if(count($empArr)>0) {
        $where = [];
        $where['agency_location_code'] = $row['agency_location'];
        $locationData = $this->comman->get_row('agency_location', $where);

        $where = [];
        //$where['agency_code'] = $row['Agency'];
        $where['agency_code'] = $agency_code;              
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $tmpdte;
        $dataArray['supervisor'] = $row['name'];
        $dataArray['supervisor_id'] = $row['supervisor_id'];
        $dataArray['agency'] = $agencyData['agency_codename'];
        //$dataArray['agency_id'] = $row['Agency'];
        $dataArray['agency_id'] = $agency_code;
        $dataArray['location_id'] = $row['agency_location'];
        $dataArray['location'] = $locationData['agency_location_name'];
        $dataArray['total_employee'] = count($empArr);

        $this->comman->insert('employee_mispunch_tracking', $dataArray);
        //echo 'Records has been added successfully.';
      }
    }
    echo 'Scripts has been run successfully.';
  }

  function updateMispunchSupAndEmployee() {
    $fromD = date('Y-m-d',strtotime("-1 days"));

    $this->db->where('transaction_date',$fromD);
    $this->db->delete('mispunch_update_tracking');

    $where = [];
    $where['su.firstname!='] = '';
    $where['su.supervisor_id!='] = 0;
    $allSupervisorData = $this->comman->getAssignedSupervisor($where, 'lastname', 'asc');

    foreach ($allSupervisorData as $key => $row) {
      $supervisorId = $row['supervisor_id'];

      $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),tbl_missedpunch_update.employee_id,employee.Agency as empAgency FROM tbl_missedpunch_update,patient,employee,supervisor WHERE (patient.patient_id = tbl_missedpunch_update.client_id AND tbl_missedpunch_update.employee_id = employee.employee_id) AND DATE(timestamp) >='$fromD' AND DATE(timestamp) <='$fromD' AND patient.supervisor_id='$supervisorId' GROUP BY patient_id ORDER BY tbl_missedpunch_update.id ASC";
      $mispunchUpdateDataBySup = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
      foreach ($mispunchUpdateDataBySup as $key => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
          if($row1['empAgency']==1) {
              $empHomeMakers++;
          }
          if($row1['empAgency']==2) {
              $empSeniorcare++;
          }
          if($row1['empAgency']==3) {
              $caregivers++;
          }
          if($row1['empAgency']==4) {
              $rockford++;
          }
        }
      }

      $total_employee = 'Homemakers: '.$empHomeMakers.'<br>';
      $total_employee .= 'Seniorcare: '.$empSeniorcare.'<br>';
      $total_employee .= 'Caregivers: '.$caregivers.'<br>';
      $total_employee .= 'Rockford: '.$rockford.'<br>';

      if(count($empArr)>0) {
        $where = [];
        $where['agency_location_code'] = $row['agency_location'];
        $locationData = $this->comman->get_row('agency_location', $where);

        $where = [];
        $where['agency_code'] = $row['Agency'];
        //$where['agency_code'] = $agency_code;              
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $fromD;
        $dataArray['supervisor'] = $row['name'];
        $dataArray['supervisor_id'] = $row['supervisor_id'];
        $dataArray['agency'] = $agencyData['agency_codename'];
        $dataArray['agency_id'] = $row['Agency'];
        //$dataArray['agency_id'] = $agency_code;
        $dataArray['location_id'] = $row['agency_location'];
        $dataArray['location'] = $locationData['agency_location_name'];
        $dataArray['total_employee_sup'] = count($empArr);
        $dataArray['total_employee'] = $total_employee;

        $this->comman->insert('mispunch_update_tracking', $dataArray);
        $this->session->set_flashdata('message', 'Record has been added successfully.');
      }
    }



    /************** Agency Wise EMployees *****************/
    $this->db->where('transaction_date',$fromD);
    $this->db->delete('mispunch_update_tracking_employee');

    $where = [];
    $allAgencyData = $this->comman->get_rows('agency', $where);

    foreach ($allAgencyData as $key => $row) {
      $agencyCode = $row['agency_code'];

      $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),tbl_missedpunch_update.employee_id,employee.Agency as empAgency FROM tbl_missedpunch_update,patient,employee WHERE (patient.patient_id = tbl_missedpunch_update.client_id AND tbl_missedpunch_update.employee_id = employee.employee_id) AND DATE(timestamp) >='$fromD' AND DATE(timestamp) <='$fromD' AND employee.Agency='$agencyCode' GROUP BY patient_id ORDER BY tbl_missedpunch_update.id ASC ";
      $mispunchUpdateDataBySup = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
      foreach ($mispunchUpdateDataBySup as $key => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
        }
      }

      if(count($empArr)>0) {

        $where = [];
        $where['agency_code'] = $agencyCode;
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $fromD;
        $dataArray['agency'] = $row['agency_codename'];
        $dataArray['agency_id'] = $agencyCode;
        $dataArray['total_employee'] = count($empArr);

        $this->comman->insert('mispunch_update_tracking_employee', $dataArray);
        $this->session->set_flashdata('message', 'Record has been added successfully.');
      }
    }
    echo 'Scripts has been run successfully.';
  }

  function weeklyMobileusersTracking() {
    $sql = "SELECT transaction_date FROM employee_mobileusers_tracking ORDER BY ID DESC LIMIT 1";
    $row = $this->comman->getCustomQueryData($sql, 'row');
    $currentDate = date('Y-m-d',strtotime("-1 days"));
    if(!empty($row)) {
      $transactionDate = $row['transaction_date'];      
      $date1 = new DateTime($transactionDate);
      $date2 = new DateTime($currentDate);
      $interval = $date1->diff($date2);
      $day = $interval->d; 
      if($day>=7) {
        $fromD = date('Y-m-d', strtotime("+1 day", strtotime($transactionDate)));
        $this->mobileUsersTracking($fromD, $currentDate);
      }
    } else {
      $fromD = date('Y-m-d', strtotime("-1 week", strtotime($currentDate)));
      $this->mobileUsersTracking($fromD, $currentDate);
    }
  }

  function mobileUsersTracking($transactionDate, $currentDate) {
    //$fromD = date('Y-m-d',strtotime("-1 days"));
    //$toD = date('Y-m-d',strtotime("-1 days"));

    $fromD = $transactionDate;
    $toD = $currentDate;
    
    $this->db->where('transaction_date',$toD);
    $this->db->delete('employee_mobileusers_tracking');

    $where = [];
    $where['su.firstname!='] = '';
    $where['su.supervisor_id!='] = 0;
    $allSupervisorData = $this->comman->getAssignedSupervisor($where, 'lastname', 'asc');

    $empHomeMakersAll = $empSeniorcareAll = $empCaregiversAll = $empRockfordAll = 0;
    foreach ($allSupervisorData as $key => $row) {
      $supervisorId = $row['supervisor_id'];
      $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(employee_clock_id), employee_clock.tagedit,employee_clock.date,employee_clock.employee_id,employee_clock.patient_id, employee.Agency as empAgency FROM employee_clock,patient,employee WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id) AND DATE(date) >='$fromD' AND DATE(date) <='$toD' AND tagedit IN (4,6,7) AND patient.supervisor_id='$supervisorId' ORDER BY employee_clock.employee_clock_id ASC";

      $mobileUserDataBySup = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
      $android = $webapp = $ios = 0;
      foreach ($mobileUserDataBySup as $key => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
          if($row1['tagedit']==4) {
            $android++;
          }
          if($row1['tagedit']==6) {
            $ios++;
          }
          if($row1['tagedit']==7) {
            $webapp++;
          }
        }
      }

      if(count($empArr)>0) {
        $where = [];
        $where['agency_location_code'] = $row['agency_location'];
        $locationData = $this->comman->get_row('agency_location', $where);

        $where = [];
        $where['agency_code'] = $row['Agency'];
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $toD;
        $dataArray['supervisor'] = $row['name'];
        $dataArray['supervisor_id'] = $row['supervisor_id'];
        $dataArray['agency'] = $agencyData['agency_codename'];
        $dataArray['agency_id'] = $row['Agency'];
        $dataArray['location_id'] = $row['agency_location'];
        $dataArray['location'] = $locationData['agency_location_name'];
        $dataArray['total_employee'] = count($empArr);
        $dataArray['android_user'] = $android;
        $dataArray['ios_user'] = $ios;
        $dataArray['webapp_user'] = $webapp;

        $this->comman->insert('employee_mobileusers_tracking', $dataArray);
      }
    }

    

    /************** Agency Wise Employees *****************/
    $this->db->where('transaction_date',$toD);
    $this->db->delete('mobile_user_tracking_employee');

    $where = [];
    $allAgencyData = $this->comman->get_rows('agency', $where);
    foreach ($allAgencyData as $key => $row) {
      $agencyCode = $row['agency_code'];
      $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(employee_clock_id), employee_clock.tagedit,employee_clock.date,employee_clock.employee_id,employee_clock.patient_id, employee.Agency as empAgency FROM employee_clock,patient,employee WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id) AND DATE(date) >='$fromD' AND DATE(date) <='$toD' AND tagedit IN (4,6,7) AND employee.Agency='$agencyCode' ORDER BY employee_clock.employee_clock_id ASC";

      $mobileUserDataByEmployee = $this->comman->getCustomQueryData($MySQLALL);
      $empArr = [];
      $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
      $android = $webapp = $ios = 0;
      foreach ($mobileUserDataByEmployee as $key1 => $row1) {
        if(!in_array($row1['employee_id'], $empArr)) {
          array_push($empArr, $row1['employee_id']);
          if($row1['tagedit']==4) {
            $android++;
          }
          if($row1['tagedit']==6) {
            $ios++;
          }
          if($row1['tagedit']==7) {
            $webapp++;
          }
        }
      }

      if(count($empArr)>0) {
        $where = [];
        $where['agency_code'] = $agencyCode;
        $agencyData = $this->comman->get_row('agency', $where);

        $dataArray = [];
        $dataArray['transaction_date'] = $toD;
        $dataArray['agency'] = $row['agency_codename'];
        $dataArray['agency_id'] = $agencyCode;
        $dataArray['total_employee'] = count($empArr);
        $dataArray['android_user'] = $android;
        $dataArray['ios_user'] = $ios;
        $dataArray['webapp_user'] = $webapp;

        $this->comman->insert('mobile_user_tracking_employee', $dataArray);
      }
    }
    /************** Agency Wise Employees End*****************/

    /************** Agency Location Wise Employees *****************/
    $this->db->where('transaction_date',$toD);
    $this->db->delete('mobile_location_user_tracking_employee');

    $where = [];
    $allAgencyLocationData = $this->comman->get_rows('agency_location', $where);
    foreach ($allAgencyLocationData as $key => $row) {
        $agencyLocationCode = $row['agency_location_code'];

        $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(employee_clock_id), employee_clock.tagedit,employee_clock.date,employee_clock.employee_id,employee_clock.patient_id, employee.Agency as empAgency FROM employee_clock,patient,employee WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id) AND DATE(date) >='$fromD' AND DATE(date) <='$toD' AND tagedit IN (4,6,7) AND employee.agency_location='$agencyLocationCode' ORDER BY employee_clock.employee_clock_id ASC";

        $mobileUserDataByEmployee = $this->comman->getCustomQueryData($MySQLALL);
        $empArr = [];
        $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
        $android = $webapp = $ios = 0;
        foreach ($mobileUserDataByEmployee as $key1 => $row1) {
            if(!in_array($row1['employee_id'], $empArr)) {
                array_push($empArr, $row1['employee_id']);
                if($row1['tagedit']==4) {
                    $android++;
                }
                if($row1['tagedit']==6) {
                    $ios++;
                }
                if($row1['tagedit']==7) {
                    $webapp++;
                }
            }
        }

        if(count($empArr)>0) {
            /*$where = [];
            $where['agency_code'] = $agencyLocationCode;
            $agencyData = $this->comman->get_row('agency', $where);*/

            $dataArray = [];
            $dataArray['transaction_date'] = $toD;
            $dataArray['location'] = $row['agency_location_name'];
            $dataArray['location_id'] = $agencyLocationCode;
            $dataArray['total_employee'] = count($empArr);
            $dataArray['android_user'] = $android;
            $dataArray['ios_user'] = $ios;
            $dataArray['webapp_user'] = $webapp;

            $this->comman->insert('mobile_location_user_tracking_employee', $dataArray);
        }
    }
    /************** Agency Location Wise Employees End*****************/
    echo 'Scripts has been run successfully.';
  }


  public function updateEmployeeWorker() {
    $pdate = date('Y-m-d',strtotime("-1 days"));

    $sql = "SELECT DISTINCT(employee_id), tagedit, employee_clock_id FROM employee_clock WHERE DATE(date)='".$pdate."' AND isIn=2 AND tagedit IS NOT NULL";
    $empCLockData = $this->comman->getCustomQueryData($sql);
    $x=0;
    foreach ($empCLockData as $key => $row) {
        //echo 'Employee Id : '.$row['employee_id'].' |||| tagedit : '.$row['tagedit'].' |||| Employee Clock Id : '.$row['employee_clock_id'];
        //echo '<br>';
        $where = [];
        $where['employee_id'] = $row['employee_id'];
        if($row['tagedit']==7) { // Web App
          $dataArray = [];
          $dataArray['web_app_user'] = 1;
          $this->comman->update('employee', $where, $dataArray);
          $x++;
        }
        if($row['tagedit']==6 || $row['tagedit']==4) { // IOS OR ANDROID
          $dataArray = [];
          $dataArray['app_user'] = 1;
          $this->comman->update('employee', $where, $dataArray);
          $x++;
        }
        if($row['tagedit']==3) { // Timesheet
          $dataArray = [];
          $dataArray['timesheet'] = 1;
          $this->comman->update('employee', $where, $dataArray);
          $x++;
        }
    }

    $sql = "SELECT DISTINCT(employee_id), tagedit, employee_clock_id FROM employee_clock WHERE DATE(date)='".$pdate."' AND isIn=2 AND tagedit IS NULL";
    $empCLockData = $this->comman->getCustomQueryData($sql);
    //$x=0;
    foreach ($empCLockData as $key => $row) {
      $where = [];
      $where['employee_id'] = $row['employee_id'];

      $dataArray = [];
      $dataArray['ivr_user'] = 1;
      $this->comman->update('employee', $where, $dataArray);

      $x++;
    }
    echo $x.' Employee profile updated successfully.';
  }

  public function supervisorTrackingAll() {
    //$monday = date('Y-m-d',strtotime('last monday'));
    //$sunday = date('Y-m-d');

    //$monday = '2022-06-13';
    $sunday = '2022-06-26';

    $fromDate = date("Y-m-d", strtotime("$sunday -7 days")); //for minus
    $toDate = date("Y-m-d", strtotime("$sunday -1 days")); //for minus

    $endDate = date('2022-01-02');

    $x=0;
    while($fromDate>=$endDate) {
      $sql = "SELECT * FROM supervisor WHERE supervisor_id!=0 AND name!=''";
      $res = $this->comman->getCustomQueryData($sql);      
      foreach ($res as $key => $row) {
        // code...
        $username = $row['firstname'].' '.$row['lastname'];
        $sqlt = "SELECT * FROM tracking_tblweeklydiscussionsnew WHERE username LIKE '%".$username."%' AND WeekStartingDate>='".$fromDate."' AND WeekStartingDate<='".$toDate."'";
        $rest = $this->comman->getCustomQueryData($sqlt);

        $sqla = "SELECT * FROM agency WHERE agency_code ='".$row['Agency']."'";
        $rowa = $this->comman->getCustomQueryData($sqla, 'row');

        $sqll = "SELECT * FROM agency_location WHERE agency_location_code ='".$row['agency_location']."'";
        $rowl = $this->comman->getCustomQueryData($sqll, 'row');

        $transactionDate = date("Y-m-d", strtotime("$toDate +1 days")); //for minus

        if(count($rest)>0) {
          $dataArray = [];
          $dataArray['transaction_date'] = $transactionDate;
          $dataArray['supervisor'] = $username;
          $dataArray['supervisor_id'] = $row['supervisor_id'];
          $dataArray['agency'] = @$rowa['agency_codename'];
          $dataArray['agency_id'] = @$rowa['agency_code'];
          $dataArray['location'] = @$rowl['agency_location_name'];
          $dataArray['location_id'] = @$rowl['agency_location_code'];
          $dataArray['Weekly_Activity'] = count($rest);
          $this->comman->insert('supervisor_tracking', $dataArray);
          $x++;
        }
      }

      //echo $fromDate.'==='.$toDate.'==='.$transactionDate;
      //echo '<br>';

      $toDate = date("Y-m-d", strtotime("$fromDate -1 days")); //for minus
      $fromDate = date("Y-m-d", strtotime("$fromDate -7 days")); //for minus
      
    }
    echo $x.' record inserted successfully.';
  }

  public function supervisorTracking() {
    $sunday = date('Y-m-d');
    $fromDate = date("Y-m-d", strtotime("$sunday -7 days")); //for minus
    $toDate = date("Y-m-d", strtotime("$sunday -1 days")); //for minus

    $x=0;
    $sql = "SELECT * FROM supervisor WHERE supervisor_id!=0 AND name!=''";
    $res = $this->comman->getCustomQueryData($sql);      
    foreach ($res as $key => $row) {
      // code...
      $username = $row['firstname'].' '.$row['lastname'];
      $sqlt = "SELECT * FROM tracking_tblweeklydiscussionsnew WHERE username LIKE '%".$username."%' AND WeekStartingDate>='".$fromDate."' AND WeekStartingDate<='".$toDate."'";
      $rest = $this->comman->getCustomQueryData($sqlt);

      $sqla = "SELECT * FROM agency WHERE agency_code ='".$row['Agency']."'";
      $rowa = $this->comman->getCustomQueryData($sqla, 'row');

      $sqll = "SELECT * FROM agency_location WHERE agency_location_code ='".$row['agency_location']."'";
      $rowl = $this->comman->getCustomQueryData($sqll, 'row');

      $transactionDate = date("Y-m-d", strtotime("$toDate +1 days")); //for minus

      if(count($rest)>0) {
        $dataArray = [];
        $dataArray['transaction_date'] = $sunday;
        $dataArray['supervisor'] = $username;
        $dataArray['supervisor_id'] = $row['supervisor_id'];
        $dataArray['agency'] = @$rowa['agency_codename'];
        $dataArray['agency_id'] = @$rowa['agency_code'];
        $dataArray['location'] = @$rowl['agency_location_name'];
        $dataArray['location_id'] = @$rowl['agency_location_code'];
        $dataArray['Weekly_Activity'] = count($rest);
        $this->comman->insert('supervisor_tracking', $dataArray);
        $x++;
      }
    }
    //echo $fromDate.'==='.$toDate.'==='.$transactionDate;
    //echo '<br>';
    echo $x.' record inserted successfully.';
  }


  /****** Unassigned employee using unassigned date from client profile ********/
  function unassignedEmployeeByDate() {
    $where = [];
    $where['unassigned_date'] = date('Y-m-d');
    //$where['patient_id'] = '11685';
    $eaData = $this->comman->get_rows('employee_assignment', $where);

    $x=0;
    if(!empty($eaData)) {
      foreach ($eaData as $key => $row) {
        $where = [];
        $where['patient_id'] = $row['patient_id'];
        $where['employee_id'] = $row['employee_id'];

        $dataArray  =   [];
        if (substr($row['pin'],0,1) != '+')  {
          $dataArray['pin'] = '+'.$row['pin'];
        }

        if(!empty($dataArray)) {
          $dataArray['unassigned_date'] = '';
          $this->comman->update('employee_assignment', $where, $dataArray);

          $where = [];
          $where['patient_id'] = $row['patient_id'];
          $patientData = $this->comman->get_row('patient', $where);

          $where = [];
          $where['employee_id'] = $row['employee_id'];
          $employeeData = $this->comman->get_row('employee', $where);

          ############### USER ACTION TRACKING START ####################
          $dataArray1 = [];
          $dataArray1['user_id'] = $row['unassigned_date_by_user_id'];
          $dataArray1['username'] = $row['unassigned_date_by_username'];
          $dataArray1['user_action'] = $row['unassigned_date_by_username']. ' user unassigned worker '.$employeeData['name'].' from client id '.$patientData['patient_id'].' by using unassigned date at '. date('m/d/Y H:i:s');
          $this->comman->insert('users_tracking', $dataArray1);  

          $oldData = [];
          $newData = [];

          $oldData['assigned_employee'] = 'Assigned';
          $oldData['employee_name'] = $employeeData['name'];

          $newData['assigned_employee'] = 'Unassigned';
          $newData['employee_name'] = $employeeData['name'];

          $dataArray2 = [];
          $dataArray2['patient_id'] = $patientData['patient_id'];
          $dataArray2['old_value'] = json_encode($oldData);
          $dataArray2['new_value'] = json_encode($newData);
          $dataArray2['user_id'] = $row['unassigned_date_by_user_id'];
          //$dataArray2['user_level'] = $this->session->userdata('userlevel');
          //$dataArray2['agency'] = $this->session->userdata('agency');
          $dataArray2['createdOn'] = date('Y-m-d H:i:s');
          insertHelper('patient_update_history', $dataArray2);
          ############### USER ACTION TRACKING END ####################  

          if(!empty($patientData['supervisor_id'])) {
            $where = [];
            $where['supervisor_id'] = $patientData['supervisor_id'];
            $supData = $this->comman->get_row('supervisor', $where);

            if(!empty($supData['email'])) {
              $to = trim($supData['email']);
              $to2 = "compliance@hcpcaregivers.com";

              //$to = "ankityadav036@gmail.com";
              //$to2 = "";

              $subject = "Employee has been unassigned from client id : ".$row['patient_id'];
              //$message = "Employee ".$employeeData['name']." (".$row['employee_id'].") has been unassigned from client ".$patientData['name']." (".$row['patient_id'].") on date : ".date('m/d/Y');

              $message = '<h3>Client Name / Id : '.$patientData['name'].' / '.$row['patient_id'].'</h3>';
              $message .= '<h3>Unassigned date set by username : '.$row['unassigned_date_by_username'].'</h3>';
              $message .= '<h3>List of unassigned employee are :</h3>';
              $message .= '<table border=1 cellspace=0 cellpadding=10>';        
              $message .= '<tr><th>Employee Name</th><th>Status</th><th>Date</th></tr>';

              $message .= '<tr>';
              $message .= '<td>'.$employeeData['name'].' ('.$row['employee_id'].')</td>';
              $message .= '<td>Unassigned</td>';
              $message .= '<td>'.date('m/d/Y').'</td>';
              $message .= '</tr>';
              $message .= '</table>';

              // Always set content-type when sending HTML email
              $headers = "MIME-Version: 1.0" . "\r\n";
              $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
              // More headers
              $headers .= 'From: <compliance@hcpcaregivers.com>' . "\r\n";        
              $this->sendPHPMailerMail($to, $to2, $subject, $message, $headers);
            }
          }
          $x++;
        }
      }      
    }
    echo $x.' employees has been unassigned.';
  }

  function sendPHPMailerMail($to, $to2, $subject, $message, $headers) {
      if(!empty($to)) {
          $mail = $this->phpmailer_lib->load();

          $mail->IsSMTP(); // set mailer to use SMTP
          $mail->Host        = "smtp.office365.com";  // specify main and backup server
          $mail->SMTPAuth    = true;     // turn on SMTP authentication
          $mail->SMTPDebug   = 0; 
          $mail->SMTPSecure  = "STARTTLS";
          $mail->Port        = 587;
          $mail->Username    = "rdsrm@hcpfinancial.onmicrosoft.com";  // SMTP username
          $mail->Password    = "Onedrive5301!"; // SMTP password
          //$mail->CharSet     = 'UTF-8';
          $mail->SMTPAuth    = true;
          $mail->From        = "rdsrm@hcpfinancial.onmicrosoft.com";
          $mail->FromName    = "HCP Support";
          $mail->AddAddress($to);   // name is optional
          if(!empty($to2)) {
            $mail->AddAddress($to2);
          }
          $mail->IsHTML(true);                                  // set email format to HTML
          $mail->Subject = $subject;
          $mail->Body    = $message;
          if(!$mail->Send()) {
              return false;
          }   
      }
      return true;
  }

  /****** Check termination date and update client status and unassigned all employees ********/
  function checkTerminationDate() {
    $where = [];
    $where['termination_status'] = 1;
    $where['termination_date'] = date('m-d-Y');
    //$where['patient_id'] = '11685';
    $patientData = $this->comman->get_rows('patient', $where);
    $x=0;
    if(!empty($patientData)) {      
      foreach ($patientData as $key => $row) {
        $where = [];
        $where['patient_id'] = $row['patient_id'];

        $dataArray = [];
        $dataArray['IsActive'] = 0;
        $dataArray['termination_status'] = 0;
        $dataArray['reason'] = $row['termination_reason'];
        $this->comman->update('patient', $where, $dataArray);

        /****** unassigned all assigned employee ********/
        $this->unassignedEmployee($row['patient_id'], $row['termination_by_user_id'], $row['termination_by_username']);
        $x++;
      }      
    }
    echo $x.' patient unassigned all employees.';
  }

  public function unassignedEmployee($clientId, $userId, $username) {
    $where  =   [];
    $where['patient_id'] = $clientId;
    $eaData = $this->comman->get_rows('employee_assignment', $where);
    if(!empty($eaData)) {

      $where = [];
      $where['patient_id'] = $clientId;
      $patientData = $this->comman->get_row('patient', $where);      

      if(!empty($patientData['supervisor_id'])) {

        $where = [];
        $where['supervisor_id'] = $patientData['supervisor_id'];
        $supData = $this->comman->get_row('supervisor', $where);

        $message = '<h3>Client Name / Id : '.$patientData['name'].' / '.$clientId.'</h3>';
        $message .= '<h3>Termination date set by username : '.$username.'</h3>';
        //$message .= '<h3>List of unassigned employees are :</h3>';
        //$message .= '<table border=1 cellspace=0 cellpadding=10>';        
        //$message .= '<tr><th>Employee Name</th><th>Status</th><th>Date</th></tr>';

        foreach ($eaData as $key => $row) {
          $where = [];
          $where['patient_id'] = $row['patient_id'];
          $where['employee_id'] = $row['employee_id'];

          $dataArray  =   [];
          if (substr($row['pin'],0,1) != '+')  {
            $dataArray['pin'] = '+'.$row['pin'];
          }

          if(!empty($dataArray)) {
            $this->comman->update('employee_assignment', $where, $dataArray);

            $where = [];
            $where['employee_id'] = $row['employee_id'];
            $employeeData = $this->comman->get_row('employee', $where);
            //$message .= '<tr>';
            //$message .= '<td>'.$employeeData['name'].' ('.$row['employee_id'].')</td>';
            //$message .= '<td>Unassigned</td>';
            //$message .= '<td>'.date('m/d/Y').'</td>';
            //$message .= '</tr>';

            ############### USER ACTION TRACKING START ####################
            $dataArray1 = [];
            $dataArray1['user_id'] = $userId;
            $dataArray1['username'] = $username;
            $dataArray1['user_action'] = $username. ' user unassigned worker '.$employeeData['name'].' from client id '.$patientData['patient_id'].' by using termination date at '. date('m/d/Y H:i:s');
            $this->comman->insert('users_tracking', $dataArray1);  

            $oldData = [];
            $newData = [];

            $oldData['assigned_employee'] = 'Assigned';
            $oldData['employee_name'] = $employeeData['name'];

            $newData['assigned_employee'] = 'Unassigned';
            $newData['employee_name'] = $employeeData['name'];

            $dataArray2 = [];
            $dataArray2['patient_id'] = $patientData['patient_id'];
            $dataArray2['old_value'] = json_encode($oldData);
            $dataArray2['new_value'] = json_encode($newData);
            $dataArray2['user_id'] = $userId;
            //$dataArray2['user_level'] = $this->session->userdata('userlevel');
            //$dataArray2['agency'] = $this->session->userdata('agency');
            $dataArray2['createdOn'] = date('Y-m-d H:i:s');
            insertHelper('patient_update_history', $dataArray2);
            ############### USER ACTION TRACKING END #################### 
          }
        }

        //$message .= '</table>';

        if(!empty($supData['email'])) {
          $to = trim($supData['email']);
          //$to2 = "compliance@hcpcaregivers.com";
          $to2 = "client.coordination@hcpcaregivers.com";
          //$to = "ankityadav036@gmail.com";
          //$to2 = "";

          $subject = "Terminated client id : ".$clientId;
          // Always set content-type when sending HTML email
          $headers = "MIME-Version: 1.0" . "\r\n";
          $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
          // More headers
          //$headers .= 'From: <compliance@hcpcaregivers.com>' . "\r\n";        
          $headers .= 'From: <client.coordination@hcpcaregivers.com>' . "\r\n";        
          $this->sendPHPMailerMail($to, $to2, $subject, $message, $headers);

          $to3 = 'billing@hcpcaregivers.com';
          $this->sendPHPMailerMail($to3, '', $subject, $message, $headers);
          $to4 = 'payroll@hcpcaregivers.com';
          $this->sendPHPMailerMail($to4, '', $subject, $message, $headers);
        }
      }
    }
  }
} 