<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Employee extends CI_Controller
{
    public function __construct() {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->model('Employee_model', 'employee');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        }
        else
            $this->headerData=[];

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }


    public function index() {
        if(isset($_SESSION['name'])) {
            $where = [];
            $where['Agency'] = $_SESSION['agency'];
            $employee = $this->Api_model->getAllDataWhere($where, 'employee');
            $data['user'] = $employee;
            $data['page'] = 'employee';

            if(!empty($this->input->post('search'))) {
                //print_r($this->input->post());die;
            }

            $cond1 = $cond2 = $cond3 = "";
            if (!empty($_POST['active2'])) { 
               $active2 = $_POST['active2']; 
               $cond1 = " AND Status = '$active2'";
            }

            if(!empty($_POST['suplid2'])) {
                $suplid2 = $_POST['suplid2']; 
                $cond2 = "AND employee.supervisor_id = '$suplid2'";   
            }

            $agency_code = $this->session->userdata('agency');
            $cond3 = "AND employee.Agency = '$agency_code'";

            if(!empty($_POST['mobile'])) {
                $mobile = $_POST['mobile']; 
                $cond4 = "AND employee.mobile like '%".$mobile."%'";   
            }

            if(!empty($_POST['phone'])) {
                $phone = $_POST['phone']; 
                $cond5 = "AND employee.phone like '%".$phone."%'";   
            }

            if(!empty($_POST['search'])) {
               $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                            employee.employee_id,
                            employee.lastname AS empl_lastname,
                            employee.firstname AS empl_firstname,
                            employee.mobile,
                            employee.phone,
                            employee.useradd,
                            employee.userdate,
                            employee.pin,
                            employee.Status,
                            employee.Agency,
                            employee.name,
                            employee.popalert,
                            employee.popnotes,
                            employee.supervisor_id,
                            employee.ssn,
                            EmployeeAddressPostalCode,
                            supervisor.firstname AS sup_firstname, 
                            supervisor.name AS sup_name,
                            supervisor.lastname AS sup_lastname     
                            FROM employee,supervisor WHERE   supervisor.supervisor_id = employee.supervisor_id   AND
                            employee.pin LIKE '%".@$_POST['pin2']."%' AND 
                            employee.employee_id LIKE '%".@$_POST['employee_id2']."%' AND 
                            employee.EmployeeAddressPostalCode LIKE '%".@$_POST['zipcode2']."%' AND 
                            employee.firstname LIKE '%".@$_POST['firstname2']."%' AND employee.lastname LIKE '%".@$_POST['lastname2']."%' AND employee.ssn LIKE '%".@$_POST['ssn']."%' 
                            ".$cond1.$cond2.$cond3.$cond4.$cond5." ";
                            //ORDER BY ".$sortorder." ".$desc."    LIMIT " .$from. ", " .$to . " "; 


                $data['employeeData'] = $this->employee->getCustomQueryData($MySQL);  
            }          
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php',$data);
            $this->load->view('employee/view.php',$data);
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function add() {
        if(isset($_SESSION['name'])) {
            $dataArray = [];
            $dataArray['Agency'] = $this->session->userdata('agency');
            $insert = $this->Comman_model->insert('employee', $dataArray);
            if($insert) {
                redirect('employee/edit?id='.$insert.'&action=add');
            } else {
                redirect('employee');
            }               
        } else {
            redirect();
        }
    }


    public function addOLD1() {
        if(isset($_SESSION['name'])) {

            /*$id = $this->input->get('id');

            $data['row'] = $this->db->where('employee_id',$id)->get('employee')->row_array();
            $employeeData = $data['row'];

            $where = [];
            $where['agency_id'] = $data['row']['Agency'];
            $data['agencyData'] = $this->Comman_model->get_row('agency', $where);

            $AgencyName = 'Hcpemployees/'.$data['agencyData']['agency_codename'];
            $lastname = str_replace("'","",$data['row']['lastname']);
            $firstname = str_replace("'","",$data['row']['firstname']);
            $folderPath = "/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$id;
            $dirname = FCPATH.$folderPath;
            $data['folderPath'] = $folderPath;*/

            if(!empty($this->input->post())) {

                $firstname = $this->input->post('firstname', TRUE);
                $lastname = $this->input->post('lastname', TRUE);
                $name = $lastname.', '.$firstname;

                $compliance = $this->input->post('formcheck', TRUE);
                if(!empty($compliance)) {
                    $compliance = implode(',', $compliance);
                }

                $dataArray = [];
                $dataArray['employee_id'] = $this->input->post('employee_id', TRUE);
                $dataArray['name'] = $name;
                $dataArray['firstname'] = $firstname;
                $dataArray['lastname'] = $lastname;
                $dataArray['mobile'] = $this->input->post('mobile', TRUE);
                $dataArray['supervisor_id'] = $this->input->post('suplid', TRUE);
                $dataArray['supervisor_id2'] = $this->input->post('suplidS2', TRUE);
                $dataArray['supervisor_id3'] = $this->input->post('suplidS3', TRUE);
                $dataArray['pin'] = $this->input->post('pin', TRUE);
                $dataArray['ADP'] = $this->input->post('ADP', TRUE);
                $dataArray['Agency'] = $this->session->userdata('agency');
                $dataArray['EmployeeAddressAddr1'] = $this->input->post('EmployeeAddressAddr1', TRUE);
                $dataArray['EmployeeAddressAddr2'] = $this->input->post('EmployeeAddressAddr2', TRUE);
                $dataArray['EmployeeAddressCity'] = $this->input->post('EmployeeAddressCity', TRUE);
                $dataArray['EmployeeAddressState'] = $this->input->post('EmployeeAddressState', TRUE);
                $dataArray['EmployeeAddressPostalCode'] = $this->input->post('EmployeeAddressPostalCode', TRUE);
                $dataArray['phone'] = $this->input->post('phone', TRUE);
                $dataArray['height'] = $this->input->post('height', TRUE);
                $dataArray['weight'] = $this->input->post('weight', TRUE);
                $dataArray['CPRCard'] = $this->input->post('CPRCard', TRUE);
                $dataArray['gender'] = $this->input->post('gender', TRUE);

                $language = '';
                if(!empty($this->input->post('language'))) {
                    $language= implode(',', $this->input->post('language'));
                }
                $dataArray['language'] = $language;
                $dataArray['other_language'] = $this->input->post('otherLanguage');

                $dataArray['EmployeeTypeID_Ref'] = $this->input->post('EmployeeTypeID_Ref', TRUE);
                $dataArray['ssn'] = $this->input->post('ssn', TRUE);
                $dataArray['HiredDate'] = $this->input->post('HiredDate', TRUE);
                $dataArray['BirthDate'] = $this->input->post('BirthDate', TRUE);
                $dataArray['StaffingCoordinator'] = $this->input->post('StaffingCoordinator', TRUE);
                $dataArray['Status'] = $this->input->post('Status', TRUE);
                $dataArray['DriveOnJob'] = $this->input->post('DriveOnJob', TRUE);
                $dataArray['InsOnFile'] = $this->input->post('InsOnFile', TRUE);
                $dataArray['StateIDOrLicense'] = $this->input->post('StateIDOrLicense', TRUE);
                $dataArray['SSCARD'] = $this->input->post('SSCARD', TRUE);
                $dataArray['CriminalCheck'] = $this->input->post('CriminalCheck', TRUE);
                $dataArray['TBTEST'] = $this->input->post('TBTEST', TRUE);
                $dataArray['StateLic'] = $this->input->post('StateLic', TRUE);
                $dataArray['shift'] = $this->input->post('shift', TRUE);
                $dataArray['popalert'] = $this->input->post('popalert', TRUE);
                $dataArray['popnotes'] = $this->input->post('popnotes', TRUE);
                $dataArray['email'] = $this->input->post('email2', TRUE);
                $dataArray['Notes'] = $this->input->post('Notes', TRUE);
                $dataArray['useradd'] = $this->input->post('useradd', TRUE);
                $dataArray['userdate'] = $this->input->post('userdate', TRUE);
                $dataArray['compliance'] = $compliance;
                $dataArray['race'] = $this->input->post('race', TRUE);
                $dataArray['geofencing'] = $this->input->post('geofencing', TRUE);

                $old_image = '';
                if(!empty($data['row']['emp_image'])) {
                    $old_image = $data['row']['emp_image'];
                }

                if(!empty($_FILES['emp_image'])){
                    $img_data   =   [];
                    $img_data['path']   =   'image/emp_image';
                    $img_data['file_name']  =   'emp_image';
                    $img_data['allowed_type']   =   'png|jpg|jpeg';
                    $img_data['old_file']   =   $old_image;
                    $img_data['width']  =   200;
                    $img_data['height'] =   200;
                    $img_data['quality']    =   '60%';
                    $img_data['image_compress'] =   False;

                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $dataArray['emp_image']=$img['url'];
                    }
                }

                if(!empty($_FILES['workersefile'])){
                    $allowedExts = array("pdf");
                    $temp = explode(".", $_FILES["workersefile"]["name"]);
                    $extension = end($temp);
                    if ((($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "image/jpeg") || ($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "application/pdf")) && ($_FILES["workersefile"]["size"] < 200000000) && in_array($extension, $allowedExts)) {
                        
                        if ($_FILES["workersefile"]["error"] > 0) {
                            //echo "Return Code: " . $_FILES["workersefile"]["error"] . "<br>";
                        } else {                                
                            if (!file_exists($dirname)) {
                                mkdir($dirname, 0777, true);
                            }   
                            $exttype = 'PDF';
                            
                            if (file_exists($dirname.'/'. $_FILES["workersefile"]["name"])) {
                                //echo $_FILES["workersefile"]["name"] . " already exists. ";
                            } else {
                                $xfile = $_FILES["workersefile"]["name"];
                                move_uploaded_file($_FILES["workersefile"]["tmp_name"],$dirname.'/'. $xfile);
                                $dataArray1 = [];
                                $dataArray1['file_name'] = $xfile;
                                $dataArray1['type'] = $exttype;
                                $dataArray1['timestamp'] = date("Y-m-d H:i:s");
                                $dataArray1['uploaded_by'] = $this->session->userdata('name');
                                $insert = $this->Comman_model->insert('patient_image', $dataArray1);
                            }
                        }

                    }
                }



                $id = $this->Comman_model->insert('employee', $dataArray);

                if($id) {

                    $dataArray = [];
                    $dataArray['employee_id'] = $id;
                    $dataArray['old_value'] = json_encode($employeeData);
                    $dataArray['new_value'] = json_encode($_POST);
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['user_level'] = $this->session->userdata('userlevel');
                    $dataArray['agency'] = $this->session->userdata('agency');
                    $dataArray['createdOn'] = date('Y-m-d H:i:s');
                    insertHelper('employee_update_history', $dataArray);

                    $this->session->set_flashdata('message','Employee has been added successfully.');
                    redirect('employee/edit?id='.$id);
                } else {
                    $this->session->set_flashdata('message','Somthing Went Wrong');
                    redirect('employee/edit?id='.$id);
                }
                
            }

            //print_r('expression');die;

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['employeetypesData'] = $this->Comman_model->get_rows('tblemployeetypes', $where);

            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            /*$where = [];
            $where['ea.employee_id'] = $id;
            $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where);*/

            $where = [];
            $where['start_date <='] = date("Y-m-d");
            $data['weeklyData'] = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);

            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');
            $data['agency_code'] = $this->session->userdata('agency');


            $datetrans = date("Y-m-d");
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
                $action = 1;
            } else { $action = 2; }

            $year = date("Y");
            $month = date("m");

            if ($action == 1) {
                $cutoff = 1;
                $eom = 15;
                $tdate2 = strtotime($year.'-'.$month.'-01');
                $fromdate = date("Y-m-d",$tdate2);
                $tdate2 = strtotime($year.'-'.$month.'-15');
                $todate = date("Y-m-d",$tdate2);        
            } 

            if ($action ==2) {
                $cutoff = 16;
                $eom = 31;
                $tdate2 = strtotime($year.'-'.$month.'-16');
                $fromdate = date("Y-m-d",$tdate2);
                $todate = date("Y-m-t",strtotime($datetrans));          
            }

            $Agency = $this->session->userdata('agency');

            if ($Agency == 2 || $Agency == 4) {
                $thedate = $datetrans;
                $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
                //$chkExec = mysql_query($chkSQL);
                //check for pair
                //$chkResult = mysql_fetch_array($chkExec);
                $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                if (!empty($chkResult))  {
                    $fromdate = $chkResult['start_date'];
                    $todate= $chkResult['end_date'];
                    //$startdate = $thedate;   
                }    

            }          


            /*$aSQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id), 
            missed_punch.patient_id AS pt_id, 
            missed_punch.employee_id, 
            missed_punch.date, 
            missed_punch.rec_id, 
            missed_punch.tagedit, 
            missed_punch.latitude, 
            missed_punch.longitude, 
            missed_punch.isIn, 
            missed_punch.paired, 
            missed_punch.employee_clock_id, 
            patient.patient_id, 
            patient.firstname as pt_name, 
            patient.phone, 
            patient.Agency, 
            employee.name as empl_name, 
            employee.pin, 
            employee.phone, 
            employee.mobile, 
            employee.shift 
            FROM missed_punch,patient,employee 
            WHERE (patient.patient_id = missed_punch.patient_id AND missed_punch.employee_id = employee.employee_id ) AND isIn >= 1 
            AND DATE(date) >= '$fromdate'  AND DATE(date)    <= '$todate'
            AND employee.shift = 0       
            AND employee.employee_id = '$id'
            AND reset IS NULL  AND paired = 0 ORDER BY employee.lastname asc, employee_clock_id ASC ";

            $data['missedPunchData'] = $this->employee->getCustomQueryData($aSQL);*/

            $data['action'] = 'add';
            if (!empty($this->input->get('action'))) {
                $data['action'] = $this->input->get('action');
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add-employee.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }



    public function edit() {

        if(isset($_SESSION['name'])) {

            $id = $this->input->get('id');

            $data['row'] = $this->db->where('employee_id',$id)->get('employee')->row_array();
            $employeeData = $data['row'];

            $where = [];
            $where['agency_id'] = $data['row']['Agency'];
            $data['agencyData'] = $this->Comman_model->get_row('agency', $where);

            $AgencyName = 'Hcpemployees/'.$data['agencyData']['agency_codename'];
            $lastname = str_replace("'","",$data['row']['lastname']);
            $firstname = str_replace("'","",$data['row']['firstname']);
            $folderPath = "/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$id;
            $dirname = FCPATH.$folderPath;
            $data['folderPath'] = $folderPath;

            if(!empty($this->input->post()) && !empty($id)) {

                $firstname = $this->input->post('firstname', TRUE);
                $lastname = $this->input->post('lastname', TRUE);
                $name = $lastname.', '.$firstname;

                $compliance = $this->input->post('formcheck', TRUE);
                if(!empty($compliance)) {
                    $compliance = implode(',', $compliance);
                }

                $dataArray = [];
                $dataArray['employee_id'] = $this->input->post('employee_id', TRUE);
                $dataArray['name'] = $name;
                $dataArray['firstname'] = $firstname;
                $dataArray['lastname'] = $lastname;
                $dataArray['mobile'] = $this->input->post('mobile', TRUE);
                $dataArray['supervisor_id'] = $this->input->post('suplid', TRUE);
                $dataArray['supervisor_id2'] = $this->input->post('suplidS2', TRUE);
                $dataArray['supervisor_id3'] = $this->input->post('suplidS3', TRUE);
                $dataArray['pin'] = $this->input->post('pin', TRUE);
                $dataArray['ADP'] = $this->input->post('ADP', TRUE);
                $dataArray['Agency'] = $this->session->userdata('agency');
                $dataArray['EmployeeAddressAddr1'] = $this->input->post('EmployeeAddressAddr1', TRUE);
                $dataArray['EmployeeAddressAddr2'] = $this->input->post('EmployeeAddressAddr2', TRUE);
                $dataArray['EmployeeAddressCity'] = $this->input->post('EmployeeAddressCity', TRUE);
                $dataArray['EmployeeAddressState'] = $this->input->post('EmployeeAddressState', TRUE);
                $dataArray['EmployeeAddressPostalCode'] = $this->input->post('EmployeeAddressPostalCode', TRUE);
                $dataArray['phone'] = $this->input->post('phone', TRUE);
                $dataArray['height'] = $this->input->post('height', TRUE);
                $dataArray['weight'] = $this->input->post('weight', TRUE);
                $dataArray['CPRCard'] = $this->input->post('CPRCard', TRUE);
                $dataArray['gender'] = $this->input->post('gender', TRUE);

                $language = '';
                if(!empty($this->input->post('language'))) {
                    $language= implode(',', $this->input->post('language'));
                }
                $dataArray['language'] = $language;
                $dataArray['other_language'] = $this->input->post('otherLanguage');

                $dataArray['EmployeeTypeID_Ref'] = $this->input->post('EmployeeTypeID_Ref', TRUE);
                $dataArray['ssn'] = $this->input->post('ssn', TRUE);
                $dataArray['HiredDate'] = $this->input->post('HiredDate', TRUE);
                $dataArray['BirthDate'] = $this->input->post('BirthDate', TRUE);
                $dataArray['StaffingCoordinator'] = $this->input->post('StaffingCoordinator', TRUE);
                $dataArray['Status'] = $this->input->post('Status', TRUE);
                $dataArray['DriveOnJob'] = $this->input->post('DriveOnJob', TRUE);
                $dataArray['InsOnFile'] = $this->input->post('InsOnFile', TRUE);
                $dataArray['StateIDOrLicense'] = $this->input->post('StateIDOrLicense', TRUE);
                $dataArray['SSCARD'] = $this->input->post('SSCARD', TRUE);
                $dataArray['CriminalCheck'] = $this->input->post('CriminalCheck', TRUE);
                $dataArray['TBTEST'] = $this->input->post('TBTEST', TRUE);
                $dataArray['StateLic'] = $this->input->post('StateLic', TRUE);
                $dataArray['shift'] = $this->input->post('shift', TRUE);
                $dataArray['popalert'] = $this->input->post('popalert', TRUE);
                $dataArray['popnotes'] = $this->input->post('popnotes', TRUE);
                $dataArray['email'] = $this->input->post('email2', TRUE);
                $dataArray['Notes'] = $this->input->post('Notes', TRUE);
                $dataArray['useradd'] = $this->input->post('useradd', TRUE);
                $dataArray['userdate'] = $this->input->post('userdate', TRUE);
                $dataArray['compliance'] = $compliance;
                $dataArray['race'] = $this->input->post('race', TRUE);
                $dataArray['geofencing'] = $this->input->post('geofencing', TRUE);

                $old_image = '';
                if(!empty($data['row']['emp_image'])) {
                    $old_image = $data['row']['emp_image'];
                }

                if(!empty($_FILES['emp_image'])){
                    $img_data   =   [];
                    $img_data['path']   =   'image/emp_image';
                    $img_data['file_name']  =   'emp_image';
                    $img_data['allowed_type']   =   'png|jpg|jpeg';
                    $img_data['old_file']   =   $old_image;
                    $img_data['width']  =   200;
                    $img_data['height'] =   200;
                    $img_data['quality']    =   '60%';
                    $img_data['image_compress'] =   False;

                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $dataArray['emp_image']=$img['url'];
                    }
                }

                if(!empty($_FILES['workersefile'])){
                    $allowedExts = array("pdf");
                    $temp = explode(".", $_FILES["workersefile"]["name"]);
                    $extension = end($temp);
                    if ((($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "image/jpeg") || ($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "application/pdf")) && ($_FILES["workersefile"]["size"] < 200000000) && in_array($extension, $allowedExts)) {
                        
                        if ($_FILES["workersefile"]["error"] > 0) {
                            //echo "Return Code: " . $_FILES["workersefile"]["error"] . "<br>";
                        } else {                                
                            if (!file_exists($dirname)) {
                                mkdir($dirname, 0777, true);
                            }   
                            $exttype = 'PDF';
                            
                            if (file_exists($dirname.'/'. $_FILES["workersefile"]["name"])) {
                                //echo $_FILES["workersefile"]["name"] . " already exists. ";
                            } else {
                                $xfile = $_FILES["workersefile"]["name"];
                                move_uploaded_file($_FILES["workersefile"]["tmp_name"],$dirname.'/'. $xfile);
                                $dataArray1 = [];
                                $dataArray1['file_name'] = $xfile;
                                $dataArray1['type'] = $exttype;
                                $dataArray1['timestamp'] = date("Y-m-d H:i:s");
                                $dataArray1['uploaded_by'] = $this->session->userdata('name');
                                $insert = $this->Comman_model->insert('patient_image', $dataArray1);
                            }
                        }

                    }
                }



                $where = [];
                $where['employee_id'] = $id;
                $update = $this->Comman_model->update('employee', $where, $dataArray);

                if($update) {

                    $dataArray = [];
                    $dataArray['employee_id'] = $id;
                    $dataArray['old_value'] = json_encode($employeeData);
                    $dataArray['new_value'] = json_encode($_POST);
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['user_level'] = $this->session->userdata('userlevel');
                    $dataArray['agency'] = $this->session->userdata('agency');
                    $dataArray['createdOn'] = date('Y-m-d H:i:s');
                    insertHelper('employee_update_history', $dataArray);

                    $this->session->set_flashdata('message','Employee has been updated successfully.');
                    redirect('employee/edit?id='.$id);
                } else {
                    $this->session->set_flashdata('message','Somthing Went Wrong');
                    redirect('employee/edit?id='.$id);
                }
                
            }

            

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['employeetypesData'] = $this->Comman_model->get_rows('tblemployeetypes', $where);

            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            $where = [];
            $where['ea.employee_id'] = $id;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where, $like, $not_like);

            $where = [];
            $where['start_date <='] = date("Y-m-d");
            $data['weeklyData'] = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);

            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');
            $data['agency_code'] = $this->session->userdata('agency');


            $datetrans = date("Y-m-d");
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
                $action = 1;
            } else { $action = 2; }

            $year = date("Y");
            $month = date("m");

            if ($action == 1) {
                $cutoff = 1;
                $eom = 15;
                $tdate2 = strtotime($year.'-'.$month.'-01');
                $fromdate = date("Y-m-d",$tdate2);
                $tdate2 = strtotime($year.'-'.$month.'-15');
                $todate = date("Y-m-d",$tdate2);        
            } 

            if ($action ==2) {
                $cutoff = 16;
                $eom = 31;
                $tdate2 = strtotime($year.'-'.$month.'-16');
                $fromdate = date("Y-m-d",$tdate2);
                $todate = date("Y-m-t",strtotime($datetrans));          
            }

            $Agency = $this->session->userdata('agency');

            if ($Agency == 2 || $Agency == 4) {
                $thedate = $datetrans;
                $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
                //$chkExec = mysql_query($chkSQL);
                //check for pair
                //$chkResult = mysql_fetch_array($chkExec);
                $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                if (!empty($chkResult))  {
                    $fromdate = $chkResult['start_date'];
                    $todate= $chkResult['end_date'];
                    //$startdate = $thedate;   
                }    

            }          


            $aSQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id), 
            missed_punch.patient_id AS pt_id, 
            missed_punch.employee_id, 
            missed_punch.date, 
            missed_punch.rec_id, 
            missed_punch.tagedit, 
            missed_punch.latitude, 
            missed_punch.longitude, 
            missed_punch.isIn, 
            missed_punch.paired, 
            missed_punch.employee_clock_id, 
            patient.patient_id, 
            patient.firstname as pt_name, 
            patient.phone, 
            patient.Agency, 
            employee.name as empl_name, 
            employee.pin, 
            employee.phone, 
            employee.mobile, 
            employee.shift 
            FROM missed_punch,patient,employee 
            WHERE (patient.patient_id = missed_punch.patient_id AND missed_punch.employee_id = employee.employee_id ) AND isIn >= 1 
            AND DATE(date) >= '$fromdate'  AND DATE(date)    <= '$todate'
            AND employee.shift = 0       
            AND employee.employee_id = '$id'
            AND reset IS NULL  AND paired = 0 ORDER BY employee.lastname asc, employee_clock_id ASC ";

            $data['missedPunchData'] = $this->employee->getCustomQueryData($aSQL);

            $data['action'] = 'edit';
            if (!empty($this->input->get('action'))) {
                $data['action'] = $this->input->get('action');
            }


            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function delAssignEmployee($emplId, $patientId) {
        if(!empty($emplId) && !empty($patientId)) {
            $where = [];
            $where['employee_id'] = $emplId;
            $where['patient_id'] = $patientId;
            $data = $this->Comman_model->delete_row('employee_assignment', $where);
            if($data) {
                $this->session->set_flashdata('message','Delete Data Successfully');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
            }
        } 
        redirect($this->agent->referrer());
    }


    public function getByAssignStatus() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id'])) {
            $where = [];
            $where['ea.employee_id'] = $postData['employee_id'];
            $like = [];
            if($postData['status']=='false') {
              $like['ea.pin'] = '+'; 
            }
            $not_like = [];
            if($postData['status']=='true') {
              $not_like['ea.pin'] = '+';   
            }
            $eaData    =   $this->employee->getAssignedPatientData($where, $like, $not_like);
            $data = '';
            $total_limit = 0;
            if(!empty($eaData)) {
                $td1 = $td2 = $td3 = $td6 = '';
                foreach ($eaData as $key => $row) {

                    $pin = $row['pin'];
                    if (substr($pin,0,1) != '+')  {
                        $total_limit = $total_limit + $row['total_limit'];
                    }

                    $font_weight = 'normal';
                    $color1 = 'black';
                    if($row['total_limit']>0) {
                        $font_weight = 'bold';
                        $color1 = 'blue';
                    }
                    if($row['total_limit']>40) {
                        $font_weight = 'bold';
                        $color1 = 'red';
                    }

                    $data .= '<tr><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['patient_id'].'</td><td class="'.$classid.'" bgcolor="'.$color.'"><a target="_blank" href="'.base_url('admin/AddClient?patient=').$row['patient_id'].'" title="Edit record.." >'.$row['name'].'</a></td><td style="font-weight: <?php echo $font_weight; ?>;color: <?php echo $color1; ?>" align="center">'.$row['total_limit'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['HMKRHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['CNAHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['LPNHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['RNHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['pin'].'</td>';

                    //if($_SESSION['userlevel']=='A') {    
                    if(checkUserLevel('A', $this->session->userdata('userlevel'))) {   
                        $onclick = "return confirm('Are you sure you want to delete this?');";
                        $data .= '<td class="'.$classid.'" style="width:10%"><center><a href="'.base_url('employee/delAssignEmployee/'.$row['employee_id'].'/'.$row['patient_id']).'" title="Delete" class="btn btn-xs btn-danger" onclick="'.$onclick.'"><i class="fa fa-trash"></i></a></center></td>';
                    }
                  $data .= '</tr>';
                } 
            } else {
                $data = '<tr align="center"><td colspan="9">No data found.</td></tr>';
            }
            print_r($data);
        }
    }

    public function changeAgency(){
        $postData = $this->input->post();

        if(!empty($postData['userName']) && !empty($postData['password'])) {
            $where = [];
            $where['name'] = $postData['userName'];
            $where['password'] = md5($postData['password']);
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);
            if($check && (checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('C', $this->session->userdata('userlevel')) || checkUserLevel('I', $this->session->userdata('userlevel')))) {
                $where = [];
                $where['employee_id'] = $postData['employee_id'];
                $dataArray = [];
                $dataArray['Agency'] = $postData['changeAgency'];
                $dataArray['changenotes'] = $postData['changeNotes'];
                $update = $this->Comman_model->update('employee', $where, $dataArray);
                if($update) {
                    echo 1;
                } else {
                    echo 2;
                }
            } else {
                echo 0;
            }
        }
    }

    public function uploadfiles($img_data=[]){
        $folder =   $img_data['path'];
        $file = $img_data['file_name'];
        $allowed_types =    $img_data['allowed_type'];
        $older =    $img_data['old_file'];
        $width  =   $img_data['width'];
        $height =   $img_data['height'];
        $quality    =   $img_data['quality'];

        if(!empty($_FILES[$file]) && $_FILES[$file]['size'] > 0){          
            if(!empty($older)){
                $postimgurl = FCPATH."$folder/". $older;
                unlink($postimgurl);
            }
            $config =   [];
            $config['upload_path']     = './'."$folder".'/'; 
            $config['allowed_types']   = $allowed_types;
            $new_name = $file.time().rand(0000,9999);
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if($this->upload->do_upload($file)){
                $postimg =$this->upload->data()['file_name'] ;
                $postimgurl = base_url()."$folder/". $postimg;
                chmod($this->upload->data()['full_path'],0777);
                if($img_data['image_compress']){
                    $config =   [];
                    $config['image_library'] = 'gd2';  
                    $config['source_image'] = './'."$folder".'/'.$postimg;  
                    $config['create_thumb'] = FALSE;  
                    $config['maintain_ratio'] = FALSE;  

                    $config['quality'] = $quality;  
                    if(!empty($width)){
                        $config['width'] = $width;  
                    }
                    if(!empty($height)){
                        $config['height'] = $height;  
                    }
                    
                    $config['new_image'] = './'."$folder".'/'.$postimg;  
                    
                    $this->load->library('image_lib', $config);  
                    $this->image_lib->initialize($config);
                    if($this->image_lib->resize()){
                        $this->image_lib->clear();
                        $data['url'] =  $postimg;
                        $data['status'] = 1;
                    }else{
                        $data['status'] = 0;
                        $data['msg']=$this->upload->display_errors();
                    }  
                }else{
                    $data['url'] =  $postimg;
                    $data['status'] = 1;
                }
            }else{
                $data['status']=0;
                $data['msg']=$this->upload->display_errors();
            }
            return $data;
        }
    }
    
    public function statusReport() {
        if(isset($_SESSION['name'])) {
            $data['Status'] = @$_GET['Status'];
            $data['race'] = @$_GET['race'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/status-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function getReportPdf() {

        $agency_code = $this->session->userdata('agency');     
        $Status = @$_GET['Status'];
        $race = @$_GET['race'];

        //array(100,150)
        $cnt = 0;
        $ctr = 0;
        $max  = 40;
        $spc = 40;
        $orient = 'P';
        require_once(APPPATH . 'libraries/employee-report-pdf.php'); 
        $pdf = new employeeReportPDF($orient, 'mm',array(215.9,279.4) );
        //$pdf=new PDF($orient, 'mm',array(215.9,279.4) );

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->Comman_model->get_row('agency', $where);

        $_SESSION['AgencyName'] = $agencyData['agency_shortname'];
        $_SESSION['title'] = "Inactive";
        if($Status==1) {$_SESSION['title'] = "Active"; }
        if($Status==2) {$_SESSION['title'] = "Applicant"; }
        if($Status==3) {$_SESSION['title'] = "InActive"; }
        if($Status==4) {$_SESSION['title'] = "Poor Worker"; } 
        if($Status==5) {$_SESSION['title'] = "Re-Hireable"; } 
        if($Status==6) {$_SESSION['title'] = "Stole Money"; } 
        
        //$pdf=new PDF('L');

        //array(100,150)
        $pdf->AliasNbPages();
        $pdf->AddPage($orient);

        $pdf->SetFont('Arial','',8);
        $pdf->SetLeftMargin(10);


        $sql = "SELECT * FROM patient";
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%'  AND Status = 3 ORDER BY employee.lastname";       

        if ($Status == 1 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code'  AND race LIKE '%$race%' AND Status = 1 ORDER BY employee.lastname";       
        }

        if ($Status == 2 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code'  AND race LIKE '%4race%' AND Status = 2 ORDER BY employee.lastname";       
        }

        if ($Status == 4 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 4 ORDER BY employee.lastname";        
        }

        if ($Status == 5 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 5 ORDER BY employee.lastname";        
        }

        if ($Status == 6 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 6 ORDER BY employee.lastname";        
        }

        //$result = mysql_query($sql);
        $result = $this->employee->getCustomQueryData($sql);
        $pdf->setxy(10,$spc);
        $page = 0;
        $counter = 0;
        //while(($row = mysql_fetch_array($result))) {
        foreach ($result as $key => $row) {

            if ($cnt >= $max) {
                $page = $page + 1;
                $cnt = 0; 
                $pdf->AliasNbPages();
                $pdf->AddPage($orient);
                $pdf->setxy(10,$spc);
            }

            $counter++;   
            $phone = $row['phone'];
            $phone2 = $row['mobile'];
            $race2 = $row['race'];
            $Birthdate = date("m/d/Y",strtotime($row['BirthDate']));

            $cnt = $cnt + 1;
            $pdf->Cell(62,5,$row['name'],1,0,'L');       
            $pdf->Cell(18,5,$Birthdate,1,0,'L');       
            $pdf->Cell(22,5,$phone,1,0,'L');       
            $pdf->Cell(22,5,$phone2,1,0,'L');       
            $pdf->Cell(22,5,$race2,1,1,'L');       

        }

        $pdf->Cell(30,5,'',0,1,'R');
        $pdf->Cell(100,5,'Total:'.$counter,0,0,'L');
        $pdf->Output();
    }

    public function getReportExcel() {
        $agency_code = $this->session->userdata('agency');     
        $Status = $_GET['Status'];                          
        $race = $_GET['race'];                          

        $temp = "CREATE TEMPORARY TABLE `temp_trans` (
        `EmployeeName` varchar(40) NOT NULL,
        `BirthDate` varchar(20) NOT NULL,
        `Phone` varchar(20) NOT NULL,
        `ALTPhone` varchar(20) NOT NULL,
        `race` varchar(20) NOT NULL )";

        $tempresult = $this->client->createTemporaryTable($temp);

        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 3 AND race LIKE '%$race%'  ORDER BY employee.lastname";       

        if ($Status == 1 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 1 AND race LIKE '%$race%'   ORDER BY employee.lastname";          
        }

        if ($Status == 2 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 2 AND race LIKE '%$race%'  ORDER BY employee.lastname";       
        }

        if ($Status == 4 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 4  AND race LIKE '%$race%'  ORDER BY employee.lastname";          
        }

        if ($Status == 5 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 5  AND race LIKE '%$race%'  ORDER BY employee.lastname";          
        }

        if ($Status == 6 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 6  AND race LIKE '%$race%' ORDER BY employee.lastname";       
        }

        //$result = mysql_query($sql);
        $result = $this->employee->getCustomQueryData($sql);
        //while(($row = mysql_fetch_array($result))) {
        foreach ($result as $key => $row) {

            $phone = $row['phone'];
            $phone2 = $row['mobile'];
            $race2 = $row['race'];
            $BirthDate = date("m/d/Y",strtotime($row['BirthDate']));
            $EmployeeName = $row['name'];   

            $dataArray = [];
            $dataArray['EmployeeName'] = $EmployeeName;
            $dataArray['BirthDate'] = $BirthDate;
            $dataArray['Phone'] = $phone;
            $dataArray['ALTPhone'] = $phone2;
            $dataArray['race'] = $race2;

            $insert = $this->Comman_model->insert('temp_trans', $dataArray);

        } 


        // file name for download
        $filename = "EmployeeStatusReport_" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        $row2 = 0;
        $arry = array(' ',' ',' ',' ');
        $result = $this->Comman_model->get_rows('temp_trans');
        foreach ($result as $key => $row) {
            if(!$flag) {
              // display field/column names as first row
              array_walk($row, array($this,'cleanData'));

              echo implode("\t",$arry) . "\r\n";
              echo implode("\t", array_keys($row)) . "\r\n";
              $flag = true;
            }
            array_walk($row, array($this, 'cleanData'));
            $x = 1;
            echo implode("\t", array_values($row)) . "\r\n";
        }                 
    }

    public function cleanData(&$str)  {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    public function compliance() {
        if(isset($_SESSION['name'])) {
            $Agency = $this->session->userdata('agency');
            $drpSQL = "SELECT  
                        employee.lastname AS empl_lastname,
                        employee.firstname AS empl_firstname,
                        compliance
                        FROM employee,supervisor  
                        WHERE supervisor.supervisor_id = employee.supervisor_id  AND  employee.Agency = '$Agency' AND compliance != ''  ORDER BY employee.lastname ASC";

            $data['complianceData'] = $this->employee->getCustomQueryData($drpSQL);            

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/compliance.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    
    public function delete_Employee() {
        $id = $this->input->get('employee_id');
        $data = $this->db->where('employee_id',$id)->delete('employee');
        if($data) {
            $this->session->set_flashdata('message','Delete Data Successfully');
            redirect('employee');
        } else {
            $this->session->set_flashdata('message','Somthing Went Wrong');
            redirect('employee');
        }
    }


    public function copyProfileToAgency() {

        $postData = $this->input->post();
        $userid = $postData['pid']; 
        $newagency = $postData['newag'];
        $usrag = '';

        $cols=array();
        $result = "SHOW COLUMNS FROM employee";

        $result = $this->employee->getCustomQueryData($result);

        foreach ($result as $key => $r) {
            if (!in_array($r["Field"],array("employee_id","Agency","mobile","pin","sms","supervisor_id","VisitationNotes","AssignedStaffingCoordinator","StateLic","upsize_ts"))) {
                $cols[]= $r["Field"];
            } 
        }

        //print_r($cols);die;

        $result = "SELECT * FROM employee WHERE employee_id='".$userid."'";
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {    
            $usrag = $r['Agency'];
            $mob = $r['mobile']==''?"' '":"'".$r['mobile']."'";
            $pn = $r['pin']==''?"' '":"'".$r['pin']."'";
            $sms = $r['sms']==''?"' '":"'".$r['sms']."'";
            $supid = $r['supervisor_id']==''?"' '":"'".$r['supervisor_id']."'";
            $vsnote = $r['VisitationNotes']==''?"' '":"'".$r['VisitationNotes']."'";
            $ascoor = $r['AssignedStaffingCoordinator']==''?"' '":"'".$r['AssignedStaffingCoordinator']."'";
            $stl = $r['StateLic']==''?"' '":"'".$r['StateLic']."'";
            $upsts = $r['upsize_ts']==''?"' '":"'".$r['upsize_ts']."'";    


            $dataArray = [];
            $dataArray['Agency'] = $newagency;
            $dataArray['mobile'] = $mob;
            $dataArray['pin'] = $pn;
            $dataArray['sms'] = $sms;
            $dataArray['supervisor_id'] = $supid;
            $dataArray['VisitationNotes'] = $vsnote;
            $dataArray['AssignedStaffingCoordinator'] = $ascoor;
            $dataArray['StateLic'] = $stl;
            $dataArray['upsize_ts'] = $upsts;

            //print_r($dataArray);die;
            $count=count($cols);
            foreach($cols as $counter=>$col) {
                $dataArray[$col] = $r[$col]=='' ? 'NULL' : $r[$col];
            }

            $newuserid = $this->Comman_model->insert('employee', $dataArray);
            
        }

        $cols = array();
        $result = "SHOW COLUMNS FROM employee_assignment"; 
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {
            if (!in_array($r["Field"],array("employee_id"))) {
                $cols[]= $r["Field"];
            } 
        }

        $result = "SELECT * FROM employee_assignment WHERE employee_id='".$userid."'";
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {

            $dataArray = [];
            $dataArray['employee_id'] = $newuserid;
            $count=count($cols);
            foreach($cols as $counter=>$col) {
                $dataArray[$col] = $r[$col]=='' ? 'NULL' : $r[$col];
            }

            $insertId = $this->Comman_model->insert('employee_assignment', $dataArray);
        }  

        $dataArray = [];
        $dataArray['Status'] = 3;
        $where = [];
        $where['employee_id'] = $userid;
        $update = $this->Comman_model->update('employee', $where, $dataArray);

        $where = [];
        $where['employee_id'] = $userid;
        $employeeData = $this->Comman_model->get_row('employee', $where);

        //migrate image too
        $filename = FCPATH."image/emp_image/".$employeeData['emp_image'];
        $newfilename = 'E'.$newuserid.'.jpg';
        if(file_exists($filename)) {
            if(!copy($filename,FCPATH.'image/emp_image/'.$newfilename))
            die('unable to copy');
        }

        $dataArray = [];
        $dataArray['emp_image'] = $newfilename;
        $where = [];
        $where['employee_id'] = $newuserid;
        $update = $this->Comman_model->update('employee', $where, $dataArray);

        echo 'success';
    }

    public function history() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $where  = [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            /*$where= [];
            $where['patient_id'] = $_GET['patient'];
            $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where);
            $data['patient_id'] =  $_GET['patient']; */

            $limit = 5;
            if(!empty($this->input->post('limit'))) {
              $limit = $this->input->post('limit');  
            }

            $where  = [];
            $where['puh.employee_id'] = $_GET['employee'];
            $data['patientHistoryData']    =   $this->Comman_model->getEmployeeHistory($where, $limit);

            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            $where = [];
            $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $data['limit'] = $limit;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/history.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function customReport() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where);

            $where = [];
            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'name', 'asc');

            $data['employeeData']    =   $this->client->getEmployeeCustomReport();

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/custom-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }
    
} 