<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class EmployeeClock extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model','comman');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->library('user_agent');
    }

    
    public function index() {
        if (isset($_SESSION['name'])) { 
            $fromdate = date('Y-m-d');
            if(!empty($_GET['fromdate'])) {
                $fromdate = $_GET['fromdate'];
            }
            $todate2 = date('Y-m-d');
            if(!empty($_GET['todate'])) {
                $todate2 = $_GET['todate'];
            }
            $empId = $_GET['empId'];            

            if(!empty($_GET['clientName']))
            {
                $clientName = $_GET['clientName'];
                $sql="SELECT GROUP_CONCAT(patient_id) as clientIds FROM patient where name like '%{$clientName}%' OR firstname like '%{$clientName}%' OR lastname like '%{$clientName}%' and status = 1";
                $resClients = $this->comman->getCustomQueryData($sql,'row');
                $clientIds = $resClients['clientIds'];
            }
            if(!empty($_GET['empName']))
            {
                $empName = $_GET['empName'];
                $sql="SELECT GROUP_CONCAT(employee_id) as empIds FROM employee where name like '%{$empName}%' OR firstname like '%{$empName}%' OR lastname like '%{$empName}%' and Status = 1";
                $resEmployees = $this->comman->getCustomQueryData($sql,'row');
                $empIds = $resEmployees['empIds'];
            }
            if(!empty($fromdate) && !empty($todate2))
            {
                // var_dump($fromdate);
                $sql="SELECT * from employee_clock where DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate2' ";
                if(isset($clientIds))
                    $sql.=" and patient_id in ($clientIds) ";
                if(isset($empIds))
                    $sql.=" AND employee_id in ($empIds)";
                if(isset($empId) && $empId!='')      
                    $sql.=" AND employee_id = $empId";                
                // $sql="SELECT * from employee_clock LIMIT 100";    

                //echo $sql;
                $clockData = $this->comman->getCustomQueryData($sql);
            } else {
                $clockData = [];
            }

            $data['empId'] = $empId;
            $data['fromdate'] = $fromdate;
            $data['todate'] = $todate2;
            $data['page']  = 'EmployeeClock';
            $data['clockData'] = $clockData;
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employeeClock/view.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }  

    public function ViewHistory() {
        if (isset($_SESSION['name'])) { 
            $fromdate = date('Y-m-d');
            if(!empty($_GET['fromdate'])) {
                $fromdate = $_GET['fromdate'];
            }

            $todate2 = date('Y-m-d');
            if(!empty($_GET['todate'])) {
                $todate2 = $_GET['todate'];
            }
            if(!empty($fromdate) && !empty($todate2))
            {
                $sql="SELECT * from employee_clock_view_history where DATE(transaction_date) >= '$fromdate'  AND DATE(transaction_date) <= '$todate2'";
                $clockData = $this->comman->getCustomQueryData($sql);
            }
            else{
                $clockData = [];
            }
            $data['page']  = 'EmployeeClock';
            $data['clockData'] = $clockData;
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employeeClock/viewHistory.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }
    public function ViewSupervisior() {
        if (isset($_SESSION['name'])) { 
            $sql="SELECT * from supervisor where is_active = 0";
            $supervisiorData = $this->comman->getCustomQueryData($sql);
            $data['page']  = 'supervisor';
            $data['supervisiorData'] = $supervisiorData;
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employeeClock/viewSupervisior.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    } 

    public function editedData()
    {
        if(!empty($_POST['data']))
        {
            foreach ($_POST['data'] as $key => $value) 
            {
                $userName= $_SESSION['name'];
                $date = date('Y-m-d');
                $sql = "INSERT into employee_clock_view_history select 'id' as view_history_id,e.*,'$userName' as username,CURRENT_TIMESTAMP as transaction_date  from employee_clock e where e.employee_clock_id = $key";
                $this->db->query($sql);

                $this->db->where('employee_clock_id',$key);
                $this->db->update('employee_clock',$value);

                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user updated employee clock id '.$key.' at '. date('m/d/Y H:i:s');
                    $this->comman->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################

            }
            echo 1;
        }
        else
            echo 0;
    }
    public function EditedSupervisiorData()
    {
        if(!empty($_POST['data']))
        {
            foreach ($_POST['data'] as $key => $value) 
            {
                $userName= $_SESSION['name'];
                $date = date('Y-m-d');
                // $sql = "INSERT into employee_clock_view_history select 'id' as view_history_id,e.*,'$userName' as username,CURRENT_TIMESTAMP as transaction_date  from employee_clock e where e.employee_clock_id = $key";
                // $this->db->query($sql);

                $this->db->where('supervisor_id',$key);
                $this->db->update('supervisor',$value);

                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user updated supervisor id '.$key.' at '. date('m/d/Y H:i:s');
                    $this->comman->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################

            }
            echo 1;
        }
        else
            echo 0;
    }
    public function authenticateUser(){
        $postData = $this->input->post();
        if(!empty($postData['password'])) 
        {
            $where = [];
            $where['name'] = $_SESSION['name'];
            $where['password'] = md5($postData['password']);
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);
            if($check && (checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('C', $this->session->userdata('userlevel')) || checkUserLevel('I', $this->session->userdata('userlevel'))))
            {
                echo 1;
            } else {
                echo 0;
            }
        }
    }
    public function delete(){
        foreach ($_POST['deleteIds'] as $key => $value) {
            $where['employee_clock_id'] = $value;
            $check = $this->comman->delete_row('employee_clock',$where);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted employee clock id '.$value.' at '. date('m/d/Y H:i:s');
                $this->comman->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################


        }
        echo 1;
    }
    public function DeleteSupervisior(){
        foreach ($_POST['deleteIds'] as $key => $value) {
            $where['supervisor_id'] = $value;
            $check = $this->comman->updateSingleRow('supervisor',$where,['is_active'=>1]);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user updated status to supervsior id '.$value.' at '. date('m/d/Y H:i:s');
                $this->comman->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################

        }
        echo 1;
    }

} 