<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Employee extends CI_Controller
{
    public function __construct() {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->model('Employee_model', 'employee');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        }
        else
            $this->headerData=[];

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }


    public function index() {
        if(isset($_SESSION['name'])) {
            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $employee = $this->Api_model->getAllDataWhere($where, 'employee');
            $data['user'] = $employee;
            $data['page'] = 'employee';

            $search = $this->input->post('search');

            if(!empty($search)) {
                //print_r($this->input->post());die;
            }

            $cond1 = $cond2 = $cond3 = "";
            //$cond1 = " AND Status = '1'";
            if (!empty($_POST['active2'])) { 
               $active2 = $_POST['active2']; 
               $cond1 = " AND Status = '$active2'";
            }

            if (!empty($_POST['flag'])) { 
               $flag = $_POST['flag']; 
               $cond1 .= " AND flag = '$flag'";
            }

            if(isset($_POST['newHire']) && $_POST['newHire']!='') {
                $newHire = $_POST['newHire']; 
                $cond1 .= " AND newHire = '$newHire'";   
            }

            if(isset($_POST['dd']) && $_POST['dd']!='') {
                $dd = $_POST['dd']; 
                $cond1 .= " AND directdeposit = '$dd'";   
            }

            $suplid2 = $_POST['suplid2']; 
            if($suplid2!='') {    
                $cond2 = " AND employee.supervisor_id = '$suplid2'";   
            }

            $dementia = $_POST['dementia']; 
            if($dementia!='') {    
                $cond2 .= " AND employee.dementia = '$dementia'";   
            }

            $covid_vax = $_POST['covid_vax']; 
            if($covid_vax!='') {    
                $cond2 .= " AND employee.covid_vax = '$covid_vax'";   
            }

            if(!empty($search) && $search=='searchbyKeyword') {                
                $keyword = $_POST['keyword']; 
                if($keyword=="Active") {
                    $cond2 .= " AND Status = 1";   
                }
                if($keyword=="Alzheimer's/Dementia Trained") {
                    $cond2 .= " AND employee.dementia = 1";   
                }
                if($keyword=="Covid19 Vax") {
                    $cond2 .= " AND employee.covid_vax = 1";   
                }
                if($keyword=="Male") {
                    $cond2 .= " AND employee.gender = 0";   
                }
                if($keyword=="Female") {
                    $cond2 .= " AND employee.gender = 1";   
                }
                if($keyword=="White") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Asian") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Black") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="American Indian") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Hispanic") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Mixed") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Others") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="English") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Spanish") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Tagalog") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="French") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Arabic") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Other") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }                
            }

            $agency_code = $this->session->userdata('agency');
            $cond3 = " AND employee.Agency = '$agency_code'";

            if(!empty($_POST['agency_location'])) {
                $agency_location = $_POST['agency_location']; 
                $cond4 = " AND employee.agency_location = '$agency_location'";
            }

            if(!empty($_POST['mobile'])) {
                $mobile = $_POST['mobile']; 
                $cond4 = " AND employee.mobile like '%".$mobile."%'";   
            }

            if(!empty($_POST['phone'])) {
                $phone = $_POST['phone']; 
                $cond5 = " AND employee.phone like '%".$phone."%'";   
            }


            /********* Filter By tags *************/
            if(!empty($_GET['status']) && $_GET['status']=='Active'){
                $cond1     =   " AND Status = '1'";
            }

            if(!empty($_GET['dementia']) && $_GET['dementia']=='dementia'){
                $cond3 .= " AND employee.dementia = '1'";  
            }

            if(!empty($_GET['covid19']) && $_GET['covid19']=='Covid19 Vax'){
                $cond3 .= " AND employee.covid_vax = '1'";  
            }

            if(!empty($_GET['gender'])) {
                $cond3 .= ' AND employee.gender IN ("' . implode('", "', $_GET['gender']) . '")';  
            }

            if(!empty($_GET['race'])) {
                $cond3 .= ' AND employee.race IN ("' . implode('", "', $_GET['race']) . '")';  
            }

            $cc = $xx = '';
            if(!empty($_GET['language'])) {
                $language = [];
                $language = $_GET['language'];
                $x=1;
                foreach ($language as $key => $lang) {
                    if($x==1) {
                        $cc .= " AND ( employee.language LIKE '%".$lang."%'";  
                        $xx .= " AND employee.language LIKE '%".$lang."%'";  
                    } else {
                        $cc .= " OR employee.language LIKE '%".$lang."%'";  
                        $xx .= " OR employee.language LIKE '%".$lang."%'";  
                    }
                    $x++;
                }
                if($x==1) {
                    $cond3 .= $xx;
                } else {
                    $cond3 .= $cc.' )';
                }
            }            

            if(!empty($_POST['search']) || (!empty($_GET['action']) && $_GET['action']=='tags')) {
               $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                            employee.employee_id,
                            employee.lastname AS empl_lastname,
                            employee.firstname AS empl_firstname,
                            employee.agency_location,
                            employee.mobile,
                            employee.phone,
                            employee.useradd,
                            employee.userdate,
                            employee.pin,
                            employee.Status,
                            employee.flag,
                            employee.newHire,
                            employee.Agency,
                            employee.name,
                            employee.popalert,
                            employee.popnotes,
                            employee.supervisor_id,
                            employee.ssn,
                            employee.directdeposit,
                            employee.dementia,
                            employee.covid_vax,
                            employee.EmployeeAddressPostalCode,
                            supervisor.firstname AS sup_firstname, 
                            supervisor.name AS sup_name,
                            supervisor.lastname AS sup_lastname     
                            FROM employee,supervisor WHERE supervisor.supervisor_id = employee.supervisor_id AND
                            employee.pin LIKE '%".@$_POST['pin2']."%' AND 
                            employee.employee_id LIKE '%".@$_POST['employee_id2']."%' AND 
                            employee.EmployeeAddressPostalCode LIKE '%".@$_POST['zipcode2']."%' AND 
                            employee.firstname LIKE '%".@$_POST['firstname2']."%' AND employee.lastname LIKE '%".@$_POST['lastname2']."%' AND employee.ssn LIKE '%".@$_POST['ssn']."%' 
                            ".$cond1.$cond2.$cond3.$cond4.$cond5." ";
                            //ORDER BY ".$sortorder." ".$desc."    LIMIT " .$from. ", " .$to . " "; 



                $data['employeeData'] = $this->employee->getCustomQueryData($MySQL);  
            }   

            $where= [];
            $data['agencyLocation'] = $this->Api_model->getAllDataWhere($where, 'agency_location');

            //print_r($data['employeeData']);die;
            $where = [];
            $where['is_supervisor'] = 1;
            $where['lastname!='] = '';
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php',$data);
            $this->load->view('employee/view.php',$data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect();
        }
    }

    public function add() {

        if(isset($_SESSION['name'])) {
            $mysql = 'select * from employee order by employee_id desc limit 1';
            $row = $this->Comman_model->getCustomQueryData($mysql, 'row');
            if(!empty($row['employee_id'])) {
                $employee_id = $row['employee_id'] + 1;
            } else {
                $employee_id = 1;
            }

            if($employee_id) {
                if(!empty($_GET['type']) && $_GET['type']=='applicant' && !empty($_GET['applicant_id'])) {
                    redirect('employee/edit?id='.$employee_id.'&action=add&type=applicant&applicant_id='.$_GET['applicant_id']);
                } else {
                    redirect('employee/edit?id='.$employee_id.'&action=add');
                }
            } else {
                redirect('employee');
            }

        } else {
            redirect();
        }
    }


    public function addOLD1() {
        if(isset($_SESSION['name'])) {

            /*$id = $this->input->get('id');

            $data['row'] = $this->db->where('employee_id',$id)->get('employee')->row_array();
            $employeeData = $data['row'];

            $where = [];
            $where['agency_id'] = $data['row']['Agency'];
            $data['agencyData'] = $this->Comman_model->get_row('agency', $where);

            $AgencyName = 'Hcpemployees/'.$data['agencyData']['agency_codename'];
            $lastname = str_replace("'","",$data['row']['lastname']);
            $firstname = str_replace("'","",$data['row']['firstname']);
            $folderPath = "/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$id;
            $dirname = FCPATH.$folderPath;
            $data['folderPath'] = $folderPath;*/

            if(!empty($this->input->post())) {

                $firstname = $this->input->post('firstname', TRUE);
                $lastname = $this->input->post('lastname', TRUE);
                $name = $lastname.', '.$firstname;

                $compliance = $this->input->post('formcheck', TRUE);
                if(!empty($compliance)) {
                    $compliance = implode(',', $compliance);
                }

                $dataArray = [];
                $dataArray['employee_id'] = $this->input->post('employee_id', TRUE);
                $dataArray['name'] = $name;
                $dataArray['firstname'] = $firstname;
                $dataArray['lastname'] = $lastname;
                $dataArray['mobile'] = $this->input->post('mobile', TRUE);
                $dataArray['supervisor_id'] = $this->input->post('suplid', TRUE);
                $dataArray['supervisor_id2'] = $this->input->post('suplidS2', TRUE);
                $dataArray['supervisor_id3'] = $this->input->post('suplidS3', TRUE);
                $dataArray['pin'] = $this->input->post('pin', TRUE);
                $dataArray['ADP'] = $this->input->post('ADP', TRUE);
                $dataArray['Agency'] = $this->session->userdata('agency');
                $dataArray['EmployeeAddressAddr1'] = $this->input->post('EmployeeAddressAddr1', TRUE);
                $dataArray['EmployeeAddressAddr2'] = $this->input->post('EmployeeAddressAddr2', TRUE);
                $dataArray['EmployeeAddressCity'] = $this->input->post('EmployeeAddressCity', TRUE);
                $dataArray['EmployeeAddressState'] = $this->input->post('EmployeeAddressState', TRUE);
                $dataArray['EmployeeAddressPostalCode'] = $this->input->post('EmployeeAddressPostalCode', TRUE);
                $dataArray['phone'] = $this->input->post('phone', TRUE);
                $dataArray['height'] = $this->input->post('height', TRUE);
                $dataArray['weight'] = $this->input->post('weight', TRUE);
                $dataArray['CPRCard'] = $this->input->post('CPRCard', TRUE);
                $dataArray['gender'] = $this->input->post('gender', TRUE);

                $language = '';
                if(!empty($this->input->post('language'))) {
                    $language= implode(',', $this->input->post('language'));
                }
                $dataArray['language'] = $language;
                $dataArray['other_language'] = $this->input->post('otherLanguage');

                $dataArray['EmployeeTypeID_Ref'] = $this->input->post('EmployeeTypeID_Ref', TRUE);
                $dataArray['ssn'] = $this->input->post('ssn', TRUE);
                $dataArray['HiredDate'] = $this->input->post('HiredDate', TRUE);
                $dataArray['BirthDate'] = $this->input->post('BirthDate', TRUE);
                $dataArray['StaffingCoordinator'] = $this->input->post('StaffingCoordinator', TRUE);
                $dataArray['Status'] = $this->input->post('Status', TRUE);
                $dataArray['DriveOnJob'] = $this->input->post('DriveOnJob', TRUE);
                $dataArray['InsOnFile'] = $this->input->post('InsOnFile', TRUE);
                $dataArray['StateIDOrLicense'] = $this->input->post('StateIDOrLicense', TRUE);
                $dataArray['SSCARD'] = $this->input->post('SSCARD', TRUE);
                $dataArray['CriminalCheck'] = $this->input->post('CriminalCheck', TRUE);
                $dataArray['TBTEST'] = $this->input->post('TBTEST', TRUE);
                $dataArray['StateLic'] = $this->input->post('StateLic', TRUE);
                $dataArray['shift'] = $this->input->post('shift', TRUE);
                $dataArray['popalert'] = $this->input->post('popalert', TRUE);
                $dataArray['popnotes'] = $this->input->post('popnotes', TRUE);
                $dataArray['email'] = $this->input->post('email2', TRUE);
                $dataArray['Notes'] = $this->input->post('Notes', TRUE);
                $dataArray['useradd'] = $this->input->post('useradd', TRUE);
                $dataArray['userdate'] = $this->input->post('userdate', TRUE);
                $dataArray['compliance'] = $compliance;
                $dataArray['race'] = $this->input->post('race', TRUE);
                $dataArray['geofencing'] = $this->input->post('geofencing', TRUE);

                $old_image = '';
                if(!empty($data['row']['emp_image'])) {
                    $old_image = $data['row']['emp_image'];
                }

                if(!empty($_FILES['emp_image'])){
                    $img_data   =   [];
                    $img_data['path']   =   'image/emp_image';
                    $img_data['file_name']  =   'emp_image';
                    $img_data['allowed_type']   =   'png|jpg|jpeg';
                    $img_data['old_file']   =   $old_image;
                    $img_data['width']  =   200;
                    $img_data['height'] =   200;
                    $img_data['quality']    =   '60%';
                    $img_data['image_compress'] =   False;

                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $dataArray['emp_image']=$img['url'];
                    }
                }

                if(!empty($_FILES['workersefile'])){
                    $allowedExts = array("pdf");
                    $temp = explode(".", $_FILES["workersefile"]["name"]);
                    $extension = end($temp);
                    if ((($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "image/jpeg") || ($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "application/pdf")) && ($_FILES["workersefile"]["size"] < 200000000) && in_array($extension, $allowedExts)) {
                        
                        if ($_FILES["workersefile"]["error"] > 0) {
                            //echo "Return Code: " . $_FILES["workersefile"]["error"] . "<br>";
                        } else {                                
                            if (!file_exists($dirname)) {
                                mkdir($dirname, 0777, true);
                            }   
                            $exttype = 'PDF';
                            
                            if (file_exists($dirname.'/'. $_FILES["workersefile"]["name"])) {
                                //echo $_FILES["workersefile"]["name"] . " already exists. ";
                            } else {
                                $xfile = $_FILES["workersefile"]["name"];
                                move_uploaded_file($_FILES["workersefile"]["tmp_name"],$dirname.'/'. $xfile);
                                $dataArray1 = [];
                                $dataArray1['file_name'] = $xfile;
                                $dataArray1['type'] = $exttype;
                                $dataArray1['timestamp'] = date("Y-m-d H:i:s");
                                $dataArray1['uploaded_by'] = $this->session->userdata('name');
                                $insert = $this->Comman_model->insert('patient_image', $dataArray1);
                            }
                        }

                    }
                }



                $id = $this->Comman_model->insert('employee', $dataArray);

                if($id) {

                    $dataArray = [];
                    $dataArray['employee_id'] = $id;
                    $dataArray['old_value'] = json_encode($employeeData);
                    $dataArray['new_value'] = json_encode($_POST);
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['user_level'] = $this->session->userdata('userlevel');
                    $dataArray['agency'] = $this->session->userdata('agency');
                    $dataArray['createdOn'] = date('Y-m-d H:i:s');
                    insertHelper('employee_update_history', $dataArray);

                    $this->session->set_flashdata('message','Employee has been added successfully.');
                    redirect('employee/edit?id='.$id);
                } else {
                    $this->session->set_flashdata('message','Somthing Went Wrong');
                    redirect('employee/edit?id='.$id);
                }
                
            }

            //print_r('expression');die;

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['employeetypesData'] = $this->Comman_model->get_rows('tblemployeetypes', $where);

            //$data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            $where = [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');

            /*$where = [];
            $where['ea.employee_id'] = $id;
            $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where);*/

            $where = [];
            $where['start_date <='] = date("Y-m-d");
            $data['weeklyData'] = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);

            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');
            $data['agency_code'] = $this->session->userdata('agency');


            $datetrans = date("Y-m-d");
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
                $action = 1;
            } else { $action = 2; }

            $year = date("Y");
            $month = date("m");

            if ($action == 1) {
                $cutoff = 1;
                $eom = 15;
                $tdate2 = strtotime($year.'-'.$month.'-01');
                $fromdate = date("Y-m-d",$tdate2);
                $tdate2 = strtotime($year.'-'.$month.'-15');
                $todate = date("Y-m-d",$tdate2);        
            } 

            if ($action ==2) {
                $cutoff = 16;
                $eom = 31;
                $tdate2 = strtotime($year.'-'.$month.'-16');
                $fromdate = date("Y-m-d",$tdate2);
                $todate = date("Y-m-t",strtotime($datetrans));          
            }

            $Agency = $this->session->userdata('agency');

            if ($Agency == 2 || $Agency == 4) {
                $thedate = $datetrans;
                $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
                //$chkExec = mysql_query($chkSQL);
                //check for pair
                //$chkResult = mysql_fetch_array($chkExec);
                $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                if (!empty($chkResult))  {
                    $fromdate = $chkResult['start_date'];
                    $todate= $chkResult['end_date'];
                    //$startdate = $thedate;   
                }    

            }          


            /*$aSQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id), 
            missed_punch.patient_id AS pt_id, 
            missed_punch.employee_id, 
            missed_punch.date, 
            missed_punch.rec_id, 
            missed_punch.tagedit, 
            missed_punch.latitude, 
            missed_punch.longitude, 
            missed_punch.isIn, 
            missed_punch.paired, 
            missed_punch.employee_clock_id, 
            patient.patient_id, 
            patient.firstname as pt_name, 
            patient.phone, 
            patient.Agency, 
            employee.name as empl_name, 
            employee.pin, 
            employee.phone, 
            employee.mobile, 
            employee.shift 
            FROM missed_punch,patient,employee 
            WHERE (patient.patient_id = missed_punch.patient_id AND missed_punch.employee_id = employee.employee_id ) AND isIn >= 1 
            AND DATE(date) >= '$fromdate'  AND DATE(date)    <= '$todate'
            AND employee.shift = 0       
            AND employee.employee_id = '$id'
            AND reset IS NULL  AND paired = 0 ORDER BY employee.lastname asc, employee_clock_id ASC ";

            $data['missedPunchData'] = $this->employee->getCustomQueryData($aSQL);*/

            $data['action'] = 'add';
            if (!empty($this->input->get('action'))) {
                $data['action'] = $this->input->get('action');
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add-employee.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }



    public function edit() {

        if(isset($_SESSION['name'])) {

            $id = $this->input->get('id');
            $agency = $this->session->userdata('agency');

            $data['row'] = $this->db->where('employee_id',$id)->get('employee')->row_array();
            $employeeData = $data['row'];

            $where = [];
            $where['agency_id'] = $data['row']['Agency'];
            $data['agencyData'] = $this->Comman_model->get_row('agency', $where);

            $where = [];
            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where);

            /*$AgencyName = 'Hcpemployees/'.$data['agencyData']['agency_codename'];
            $lastname = str_replace("'","",$data['row']['lastname']);
            $firstname = str_replace("'","",$data['row']['firstname']);
            $folderPath = "/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$id;
            $dirname = FCPATH.$folderPath;
            $data['folderPath'] = $folderPath;*/

            if(!empty($this->input->post()) && !empty($id)) {

                $this->form_validation->set_rules('firstname', 'Firstname', 'trim|required');
                $this->form_validation->set_rules('lastname', 'Lastname', 'trim|required');
                $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required');
                $this->form_validation->set_rules('mobile', 'Mobile Number', 'trim|required');
                $this->form_validation->set_rules('BirthDate', 'Date of Birth', 'trim|required');
                $this->form_validation->set_rules('location', 'Location', 'trim|required');
                
                $this->form_validation->set_rules('EmployeeAddressAddr1', 'Employee Address', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressCity', 'City', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressState', 'State', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressPostalCode', 'Zipcode', 'trim|required');
                $this->form_validation->set_rules('pin', 'Pin', 'trim|required');
                $this->form_validation->set_rules('shift', 'Shift Code', 'trim|required');
                $this->form_validation->set_rules('race', 'Race', 'trim|required');
                $this->form_validation->set_rules('language[]', 'Language', 'trim|required');

                //$this->form_validation->set_rules('ADP', 'ADP', 'trim|required');
                //$this->form_validation->set_rules('height', 'Height', 'trim|required');
                //$this->form_validation->set_rules('weight', 'Weight', 'trim|required');
                $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
                $this->form_validation->set_rules('ssn', 'SSN', 'trim|required');

                //$this->form_validation->set_rules('CPRCard', 'CPR Card', 'trim|required');
                //$this->form_validation->set_rules('InsOnFile', 'InsOnFile', 'trim|required');
                $this->form_validation->set_rules('EmployeeTypeID_Ref', 'Employee Type', 'trim|required');

                $this->form_validation->set_rules('DriveOnJob', 'Drive On Job', 'trim|required');
                //$this->form_validation->set_rules('StateIDOrLicense', 'State License ID', 'trim|required');

                //$this->form_validation->set_rules('StateLic', 'State License No.', 'trim|required');
                $this->form_validation->set_rules('SSCARD', 'SS CARD', 'trim|required');
                $this->form_validation->set_rules('CriminalCheck', 'BackGround Check', 'trim|required');
                //$this->form_validation->set_rules('TBTEST', 'TB TEST', 'trim|required');

                $this->form_validation->set_rules('HiredDate', 'Hired Date', 'trim|required');
                $this->form_validation->set_rules('evaluationDate', 'Evaluation Date', 'trim|required');
                //$this->form_validation->set_rules('aieDate', ' Auto Insurance Expiration Date', 'trim|required');
                

                if ($this->form_validation->run() != false) {

                    $firstname = $this->input->post('firstname', TRUE);
                    $lastname = $this->input->post('lastname', TRUE);
                    $name = $lastname.', '.$firstname;

                    $compliance = $this->input->post('formcheck', TRUE);
                    if(!empty($compliance)) {
                        $compliance = implode(',', $compliance);
                    } else {
                        $compliance = '';
                    }

                    $dataArray = [];
                    $dataArray['employee_id'] = $this->input->post('employee_id', TRUE);
                    $dataArray['name'] = $name;
                    $dataArray['firstname'] = $firstname;
                    $dataArray['lastname'] = $lastname;
                    $dataArray['mobile'] = $this->input->post('mobile', TRUE);
                    $dataArray['supervisor_id'] = $this->input->post('suplid', TRUE);
                    $dataArray['supervisor_id2'] = $this->input->post('suplidS2', TRUE);
                    $dataArray['supervisor_id3'] = $this->input->post('suplidS3', TRUE);
                    $dataArray['pin'] = $this->input->post('pin', TRUE);
                    $dataArray['hcpadmin'] = $this->input->post('hcpAdmin', TRUE);                    

                    $ADP = $this->input->post('ADP', TRUE);

                    $dataArray['ADP'] = $ADP;
                    $dataArray['directdeposit'] = $this->input->post('directDeposit', TRUE);
                    $dataArray['dementia'] = $this->input->post('dementia', TRUE);

                    $dataArray['covid_vax'] = $this->input->post('covid_vax', TRUE);

                    $dataArray['covid_test_positive'] = $this->input->post('covid_test_positive', TRUE);
                    
                    $dataArray['Agency'] = $this->session->userdata('agency');
                    $dataArray['agency_location'] = $this->input->post('location');
                    $dataArray['EmployeeAddressAddr1'] = $this->input->post('EmployeeAddressAddr1', TRUE);
                    $dataArray['EmployeeAddressAddr2'] = $this->input->post('EmployeeAddressAddr2', TRUE);
                    $dataArray['EmployeeAddressCity'] = $this->input->post('EmployeeAddressCity', TRUE);
                    $dataArray['EmployeeAddressState'] = $this->input->post('EmployeeAddressState', TRUE);
                    $dataArray['EmployeeAddressPostalCode'] = $this->input->post('EmployeeAddressPostalCode', TRUE);
                    $dataArray['phone'] = $this->input->post('phone', TRUE);
                    $dataArray['height'] = $this->input->post('height', TRUE);
                    $dataArray['weight'] = $this->input->post('weight', TRUE);
                    $dataArray['CPRCard'] = $this->input->post('CPRCard', TRUE);
                    $dataArray['gender'] = $this->input->post('gender', TRUE);

                    

                    $language = '';
                    if(!empty($this->input->post('language'))) {
                        $language= implode(',', $this->input->post('language'));
                    }
                    $dataArray['language'] = $language;
                    $dataArray['other_language'] = $this->input->post('otherLanguage');

                    $dataArray['EmployeeTypeID_Ref'] = $this->input->post('EmployeeTypeID_Ref', TRUE);
                    $dataArray['ssn'] = $this->input->post('ssn', TRUE);
                    $dataArray['HiredDate'] = $this->input->post('HiredDate', TRUE);
                    $dataArray['BirthDate'] = $this->input->post('BirthDate', TRUE);
                    $dataArray['StaffingCoordinator'] = $this->input->post('StaffingCoordinator', TRUE);

                    $Status = $this->input->post('Status', TRUE);
                    $dataArray['Status'] = $Status;


                    $dataArray['flag'] = $this->input->post('flag', TRUE);
                    $dataArray['DriveOnJob'] = $this->input->post('DriveOnJob', TRUE);
                    $dataArray['InsOnFile'] = $this->input->post('InsOnFile', TRUE);
                    $dataArray['StateIDOrLicense'] = $this->input->post('StateIDOrLicense', TRUE);
                    $dataArray['SSCARD'] = $this->input->post('SSCARD', TRUE);
                    $dataArray['CriminalCheck'] = $this->input->post('CriminalCheck', TRUE);
                    $dataArray['TBTEST'] = $this->input->post('TBTEST', TRUE);


                    $dataArray['evaluation_date'] = $this->input->post('evaluationDate', TRUE);
                    $dataArray['auto_insurance_expiration_date'] = $this->input->post('aieDate', TRUE);

                    $dataArray['StateLic'] = $this->input->post('StateLic', TRUE);
                    $dataArray['shift'] = $this->input->post('shift', TRUE);
                    if(!empty($this->input->post('popalert', TRUE))) {
                        $popalert = $this->input->post('popalert', TRUE);
                    } else {
                        $popalert = 0;
                    }
                    $dataArray['popalert'] = $popalert;
                    $dataArray['popnotes'] = $this->input->post('popnotes', TRUE);
                    $dataArray['email'] = $this->input->post('email2', TRUE);
                    $dataArray['Notes'] = $this->input->post('Notes', TRUE);
                    //$dataArray['useradd'] = $this->input->post('useradd', TRUE);
                    //$dataArray['userdate'] = $this->input->post('userdate', TRUE);
                    $dataArray['compliance'] = $compliance;
                    $dataArray['race'] = $this->input->post('race', TRUE);
                    $dataArray['geofencing'] = $this->input->post('geofencing', TRUE);

                    $old_image = '';
                    if(!empty($data['row']['emp_image'])) {
                        $old_image = $data['row']['emp_image'];
                    }

                    if(!empty($_FILES['emp_image'])){
                        $img_data   =   [];
                        $img_data['path']   =   'image/emp_image';
                        $img_data['file_name']  =   'emp_image';
                        $img_data['allowed_type']   =   'png|jpg|jpeg';
                        $img_data['old_file']   =   $old_image;
                        $img_data['width']  =   200;
                        $img_data['height'] =   200;
                        $img_data['quality']    =   '60%';
                        $img_data['image_compress'] =   False;

                        $img=$this->uploadfiles($img_data);
                        if(!empty($img['status']=='1')){
                            $dataArray['emp_image']=$img['url'];
                        }
                    }

                    
                    $where = [];
                    $where['employee_id'] = $id;
                    $check = $this->Comman_model->countrow('employee', $where);

                    $pageaction = $this->input->post('pageaction');

                    if($check>0 && $pageaction=='edit') {
                        
                        /*** Unassign employee from client when status is inactive ***/                    
                        if($Status==3) {
                            $this->unassignedEmployee($id);
                        }

                        if(!empty($ADP) && $ADP!=0) {
                            $dataArray['newHire'] = 0;
                        } else {
                            $dataArray['newHire'] = $this->input->post('newHire', TRUE);     
                        }
                        
                        $update = $this->Comman_model->update('employee', $where, $dataArray);

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated employee id '.$id.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################


                    } else {
                        if(!empty($ADP) && $ADP!=0) {
                            $dataArray['newHire'] = 0;
                        } else {
                            $dataArray['newHire'] = 1;    
                        }                        
                        $update = $this->Comman_model->insert('employee', $dataArray);
                        $id = $update;

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user added employee id '.$id.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $dataArray = [];
                        $dataArray['pin'] = $id;
                        $where = [];
                        $where['employee_id'] = $id;
                        $this->Comman_model->update('employee', $where, $dataArray);

                        /***** Update Applicant Hired Status *****/
                        if(!empty($_REQUEST['type']) && $_REQUEST['type']=='applicant') {
                            $applicant_id = $_REQUEST['applicant_id'];
                            $updateQuery = "UPDATE employee SET `hired` = '1' WHERE applicant_id = '$applicant_id'";
                            get_data_other_db($updateQuery, 'query', 'hcp_application');
                        }
                    }                

                    if(!empty($_FILES['workersefile'])){
                        $_FILES['file'] = $_FILES['workersefile'];    
                        $uploadmsg = $this->uploadEmployeeFile($id);
                        $this->session->set_flashdata('message', $uploadmsg);
                    }

                    if($update) {
                        $dataArray = [];
                        $dataArray['employee_id'] = $id;
                        $dataArray['old_value'] = json_encode($employeeData);
                        $dataArray['new_value'] = json_encode($_POST);
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['user_level'] = $this->session->userdata('userlevel');
                        $dataArray['agency'] = $this->session->userdata('agency');
                        $dataArray['createdOn'] = date('Y-m-d H:i:s');
                        insertHelper('employee_update_history', $dataArray);

                        $tab_index = $this->input->post('tab_index');

                        $this->session->set_flashdata('message','Employee has been updated successfully.');
                        redirect('employee/edit?id='.$id.'&tab_index='.$tab_index);
                    } else {
                        $tab_index = $this->input->post('tab_index');
                        $this->session->set_flashdata('message','Somthing Went Wrong');
                        redirect('employee/edit?id='.$id.'&tab_index='.$tab_index);
                    }

                }
                
            }

            

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['employeetypesData'] = $this->Comman_model->get_rows('tblemployeetypes', $where);


            $where = [];
            $where['is_supervisor'] = 1;
            $where['lastname!='] = '';
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');


            if(!empty($id)) {

                $where = [];
                //$where['employee_id!='] = $id;
                $where['ssn'] = $employeeData['ssn'];
                $where['BirthDate'] = $employeeData['BirthDate'];
                $otherAgencyEmployee = $this->Comman_model->get_rows('employee', $where);
                if(!empty($otherAgencyEmployee)) {
                    $agencyHours = [];
                    foreach ($otherAgencyEmployee as $key => $otherEmp) {
                        $where = [];
                        $where['agency_id'] = $otherEmp['Agency'];
                        $otherAgencyData = $this->Comman_model->get_row('agency', $where);
                        $otherAgencyName = $otherAgencyData['agency_codename'];

                        $total_limit = 0;
                        $where = [];
                        $where['ea.employee_id'] = $otherEmp['employee_id'];
                        $like = [];
                        $not_like = [];
                        $not_like['ea.pin'] = '+';   
                        $otherAssignedPatientData = $this->employee->getAssignedPatientData($where, $like, $not_like);    
                        if(!empty($otherAssignedPatientData)) {
                            foreach ($otherAssignedPatientData as $key => $otherAssign) {
                                $total_limit = $total_limit + $otherAssign['total_limit'];                                
                            }
                            if(!empty($total_limit)) {
                                $agencyHours[$otherAgencyName] = $total_limit;    
                            }                            
                        }
                    }
                }

                $data['agencyHours'] = $agencyHours;


                $where = [];
                $where['ea.employee_id'] = $id;
                $like = [];
                $not_like = [];
                $not_like['ea.pin'] = '+';   
                $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where, $like, $not_like);    

                $where = [];
                $where['ea.employee_id'] = $id;
                $data['assignedPatientData1'] = $this->employee->getAssignedPatientData($where);    
            }
            

            $where = [];
            $where['start_date <='] = date("Y-m-d");
            $data['weeklyData'] = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);

            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');
            $data['agency_code'] = $this->session->userdata('agency');


            $datetrans = date("Y-m-d");
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
                $action = 1;
            } else { $action = 2; }

            $year = date("Y");
            $month = date("m");

            if ($action == 1) {
                $cutoff = 1;
                $eom = 15;
                $tdate2 = strtotime($year.'-'.$month.'-01');
                $fromdate = date("Y-m-d",$tdate2);
                $tdate2 = strtotime($year.'-'.$month.'-15');
                $todate = date("Y-m-d",$tdate2);        
            } 

            if ($action ==2) {
                $cutoff = 16;
                $eom = 31;
                $tdate2 = strtotime($year.'-'.$month.'-16');
                $fromdate = date("Y-m-d",$tdate2);
                $todate = date("Y-m-t",strtotime($datetrans));          
            }

            $Agency = $this->session->userdata('agency');

            if ($Agency == 2 || $Agency == 4) {
                $thedate = $datetrans;
                $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
                //$chkExec = mysql_query($chkSQL);
                //check for pair
                //$chkResult = mysql_fetch_array($chkExec);
                $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                if (!empty($chkResult))  {
                    $fromdate = $chkResult['start_date'];
                    $todate= $chkResult['end_date'];
                    //$startdate = $thedate;   
                }    

            }          


            $aSQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id), 
            missed_punch.patient_id AS pt_id, 
            missed_punch.employee_id, 
            missed_punch.date, 
            missed_punch.rec_id, 
            missed_punch.tagedit, 
            missed_punch.latitude, 
            missed_punch.longitude, 
            missed_punch.isIn, 
            missed_punch.paired, 
            missed_punch.employee_clock_id, 
            patient.patient_id, 
            patient.firstname as pt_name, 
            patient.phone, 
            patient.Agency, 
            employee.name as empl_name, 
            employee.pin, 
            employee.phone, 
            employee.mobile, 
            employee.shift 
            FROM missed_punch,patient,employee 
            WHERE (patient.patient_id = missed_punch.patient_id AND missed_punch.employee_id = employee.employee_id ) AND isIn >= 1 
            AND DATE(date) >= '$fromdate'  AND DATE(date)    <= '$todate'
            AND employee.shift = 0       
            AND employee.employee_id = '$id'
            AND reset IS NULL  AND paired = 0 ORDER BY employee.lastname asc, employee_clock_id ASC ";

            $data['missedPunchData'] = $this->employee->getCustomQueryData($aSQL);

            $data['action'] = 'edit';
            if (!empty($this->input->get('action'))) {
                $data['action'] = $this->input->get('action');
            }


            $data['id'] = $id;


            $where = [];
            $where['employee_id'] = $id;
            $data['rewardsData'] = $this->Comman_model->get_row('employee_rewards', $where);



            $sql = "select * from employee_notes_history where employee_id=".$id." order by id desc";
            $employeeNotesData = $this->Comman_model->getCustomQueryData($sql);
            $employeeNotes = '';
            if(!empty($employeeNotesData)) {
                foreach ($employeeNotesData as $key => $row) {
                    $notesDate = date('m/d/Y', strtotime($row['createdOn']));
                    $employeeNotes .= $notesDate.' '.$row['employee_notes']."'\r\n'";
                }
            }

            //$data['employeeNotes'] = $this->Comman_model->getCustomQueryData($sql, 'row');
            $data['employeeNotes'] = $employeeNotes;

            if(!empty($_REQUEST['type']) && $_REQUEST['type']=='applicant') {
                $applicant_id = $_REQUEST['applicant_id'];
                $query = "SELECT * FROM employee where applicant_id='".$applicant_id."'";
                $applicantData  = get_data_other_db($query, 'row', 'hcp_application');
                $data['applicantData']      = $applicantData;

                $data['row']['flag'] = 2;
                $data['row']['newHire'] = 1;
                $data['row']['firstname'] = $applicantData['first_name'];
                $data['row']['lastname'] = $applicantData['last_name'];
                $data['row']['email'] = $applicantData['email'];
                $data['row']['contact_number'] = $applicantData['phone'];
                $data['row']['BirthDate'] = $applicantData['BirthDate'];
                $data['row']['EmployeeAddressAddr1'] = $applicantData['EmployeeAddressAddr1'];
                $data['row']['EmployeeAddressAddr2'] = $applicantData['EmployeeAddressAddr2'];
                $data['row']['EmployeeAddressAddr3'] = $applicantData['EmployeeAddressAddr3'];
                $data['row']['EmployeeAddressCity'] = $applicantData['EmployeeAddressCity'];
                $data['row']['EmployeeAddressState'] = $applicantData['EmployeeAddressState'];
                $data['row']['EmployeeAddressPostalCode'] = $applicantData['EmployeeAddressPostalCode'];

                if($applicantData['gender']=='Male') {
                    $data['row']['gender'] = 0;
                }
                if($applicantData['gender']=='Female') {
                    $data['row']['gender'] = 1;
                }
                if($applicantData['gender']=='Prefer not to say') {
                    $data['row']['gender'] = 2;
                }
                $data['row']['popnotes'] = $applicantData['message'];
            }

            //print_r($data['action']);die;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function workerEfile($employee_id) {
      if(isset($_SESSION['name'])) {  
        $where = [];
        $where['employee_id'] = $employee_id;
        $employeeData = $this->Comman_model->get_row('employee', $where);

        $Agency = $employeeData['Agency'];

        if ($Agency == 1) {
            $AgencyName = 'HM';
        }
        if ($Agency == 2) {
            $AgencyName = 'SC';
        }
        if ($Agency == 3) {
            $AgencyName = 'CG';
        }
        if ($Agency == 4) {
            $AgencyName = 'RF';
        }
        $AgencyName = 'Hcpemployees/'.$AgencyName; 
        $dirname = $AgencyName."/".$employeeData['lastname'].'_'.$employeeData['firstname'].'_'.$employeeData['employee_id'];

        $data['url'] = "http://gohcp.dyndns.org/Dropbox/".$dirname;

        $data['employee_id'] = $employee_id;
        $this->load->view('employee/worker-efile.php',$data);
      } else {
        redirect();
      }
    }

    public function upload() {
      $upload = 'err'; 
      if(!empty($_FILES['workerefile'])) {
        // File upload configuration 
        $_FILES['file'] = $_FILES['workerefile'];
        $upload = $this->uploadEmployeeFile($_POST['employee_id']);
        //$upload = 'ok'; 
      } 
      echo $upload;
    }

    public function uploadEmployeeFile($employee_id) {
        $Agency = $this->session->userdata('agency');
        if ($Agency == 1) {
            $AgencyName = 'HM';
        }
        if ($Agency == 2) {
            $AgencyName = 'SC';
        }
        if ($Agency == 3) {
            $AgencyName = 'CG';
        }
        if ($Agency == 4) {
            $AgencyName = 'RF';
        }
        $msg = '';
        $AgencyName = 'Hcpemployees/'.$AgencyName;
        $allowedExts = array("pdf","PDF");
        $temp = explode(".", $_FILES["file"]["name"]);
        $extension = end($temp);
        $ext =  explode("/",$_FILES["file"]["type"]);
        $recno = $employee_id;
        $pictype = 'doc_';
        $elx = $_FILES["file"]["type"];
        $query = "SELECT * FROM employee WHERE employee_id = '$recno' ";
        $row = $this->Comman_model->getCustomQueryData($query, 'row');
        $lastname = str_replace("'","",$row['lastname']);
        $firstname = str_replace("'","",$row['firstname']);
        $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$recno;

        if (!file_exists($dirname)) {
            mkdir($dirname, 0777, true);
        }   
        $exttype = 'PDF';
        $timestamp = date("Y-m-d H:i:s"); 
        $xfile = '';

        $dataArray = [];
        $dataArray['patient_image_id'] = NULL;
        $dataArray['file_name'] = $xfile;
        $dataArray['type'] = $exttype;
        $dataArray['timestamp'] = $timestamp;
        $dataArray['uploaded_by'] = $this->session->userdata('name');
        $idfile = $this->Comman_model->insert('patient_image', $dataArray);

        $idfile2 = date("YmdH:i:s");
        $xfile = $pictype.$idfile2;
        $xfile = $_FILES["file"]["name"];   

        $where = [];
        $where['patient_image_id'] = $idfile;

        $dataArray = [];
        $dataArray['file_name'] = $xfile;

        $this->Comman_model->update('patient_image', $where, $dataArray);

        if ((($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "image/jpeg")
        || ($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "application/pdf"))
        && ($_FILES["file"]["size"] < 200000000)
        && in_array($extension, $allowedExts)) {

            if ($_FILES["file"]["error"] > 0) {
                $msg = "Return Code: " . $_FILES["file"]["error"] . "<br>";
            } else {
                $msg = "Upload: " . $_FILES["file"]["name"] . "<br>";
                $msg .= "Type: " . $_FILES["file"]["type"] . "<br>";
                $msg .= "Size: " . ($_FILES["file"]["size"] / 1024) . " kB<br>";
                $msg .= "Temp file: " . $_FILES["file"]["tmp_name"] . "<br>";
                if (file_exists("uploads/".$AgencyName.'/'. $_FILES["file"]["name"])) {
                    $msg = $_FILES["file"]["name"] . " already exists. ";
                } else {
                    move_uploaded_file($_FILES["file"]["tmp_name"],$dirname.'/'. $xfile);
                    //$msg = "Stored in: " .$dirname.'/'. $_FILES["file"]["name"];
                    $msg = "ok";
                }
            }

        } else {
            $msg = "Invalid file";
        }

        return $msg;
    }

    public function unassignedEmployee($employeeId) {
        $where  =   [];
        $where['employee_id']   =   $employeeId;
        $eaData = $this->Comman_model->get_rows('employee_assignment', $where);
        if(!empty($eaData)) {
            foreach ($eaData as $key => $row) {

                $where = [];
                $where['patient_id'] = $row['patient_id'];
                $where['employee_id'] = $row['employee_id'];

                $dataArray  =   [];
                if (substr($row['pin'],0,1) != '+')  {
                    $dataArray['pin'] = '+'.$row['pin'];
                }

                if(!empty($dataArray)) {
                    $this->Comman_model->update('employee_assignment', $where, $dataArray);    
                }
            }
        }
    }


    public function copyNotes() {
        $sql = "select * from employee";
        $employeeData = $this->Comman_model->getCustomQueryData($sql);
        foreach ($employeeData as $key => $row) {
            if(!empty(trim($row['Notes']))) {
                $dataArray = [];
                $dataArray['employee_notes'] = $row['Notes'];
                $dataArray['employee_id'] = $row['employee_id'];
                $dataArray['user_id'] = '6';
                $dataArray['username'] = 'admin';
                $dataArray['createdOn'] = date('Y-m-d H:i:s');

               // $this->Comman_model->insert('employee_notes_history', $dataArray);    
            }
        }

        echo 'successfully';
    }

    

    public function delAssignEmployee($emplId, $patientId) {
        if(!empty($emplId) && !empty($patientId)) {
            $where = [];
            $where['employee_id'] = $emplId;
            $where['patient_id'] = $patientId;
            $data = $this->Comman_model->delete_row('employee_assignment', $where);
            if($data) {
                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted assigned client id '.$patientId.' from employee id '.$emplId.' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################

                $this->session->set_flashdata('message','Delete Data Successfully');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
            }
        } 
        redirect($this->agent->referrer());
    }


    public function getByAssignStatus() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id'])) {
            $where = [];
            $where['ea.employee_id'] = $postData['employee_id'];
            $like = [];
            if($postData['status']=='false') {
              $like['ea.pin'] = '+'; 
            }
            $not_like = [];
            if($postData['status']=='true') {
              $not_like['ea.pin'] = '+';   
            }
            $eaData    =   $this->employee->getAssignedPatientData($where, $like, $not_like);
            $data = '';
            $total_limit = 0;
            if(!empty($eaData)) {
                $td1 = $td2 = $td3 = $td6 = '';
                foreach ($eaData as $key => $row) {

                    $pin = $row['pin'];
                    if (substr($pin,0,1) != '+')  {
                        $total_limit = $total_limit + $row['total_limit'];
                    }

                    $font_weight = 'normal';
                    $color1 = 'black';
                    if($row['total_limit']>0) {
                        $font_weight = 'bold';
                        $color1 = 'blue';
                    }
                    if($row['total_limit']>40) {
                        $font_weight = 'bold';
                        $color1 = 'red';
                    }

                    $where = [];
                    $where['supervisor_id'] = $row['supervisor_id'];
                    $supervisorData = $this->Comman_model->get_row('supervisor', $where);
                    $supervisorName = 'Supervisor: ';
                    if(!empty($supervisorData['name'])) {
                        $supervisorName .= $supervisorData['name'];    
                    }

                    /*$data .= '<tr><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['patient_id'].'</td><td class="'.$classid.'" bgcolor="'.$color.'"><a target="_blank" href="'.base_url('admin/AddClient?patient=').$row['patient_id'].'" title="'.$supervisorName.'<br>(Click to edit record..)" data-toggle="tooltip" data-html="true" data-placement="top">'.$row['name'].'</a></td><td style="font-weight: <?php echo $font_weight; ?>;color: <?php echo $color1; ?>" align="center">'.$row['total_limit'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['HMKRHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['CNAHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['LPNHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['RNHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['pin'].'</td>';*/

                    /*$data .= '<tr><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['patient_id'].'</td><td class="'.$classid.'" bgcolor="'.$color.'"><a target="_blank" href="'.base_url('admin/AddClient?patient=').$row['patient_id'].'" title="'.$supervisorName.'<br>(Click to edit record..)" data-toggle="tooltip" data-html="true" data-placement="top">'.$row['name'].'</a></td><td class="'.$classid.'"><a target="_blank" href="'.base_url('supervisor/edit?id=').$supervisorData['supervisor_id'].'">'.$supervisorData['name'].'</a></td><td style="font-weight: <?php echo $font_weight; ?>;color: <?php echo $color1; ?>" align="center">'.$row['total_limit'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['HMKRHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['pin'].'</td>';*/

                    $sql = "select * from employee_clock where employee_id = ".$row['employee_id']." and patient_id = ".$row['patient_id']." order by employee_clock_id desc limit 2";
                    $LastDayData = get_custom_query_data($sql);
                    $lstData = '';
                    $lstcheck = true;
                    $lstisIn = $lstDate = $lstOut = '';
                    if(!empty($LastDayData)) {
                        foreach ($LastDayData as $key => $lstRow) {
                            if($lstRow['isIn']==1) {
                                $lstcheck = false;
                                $lstDate = '<p style="margin-bottom: 0px;">'.date('m/d/Y', strtotime($lstRow['date'])).'</p>';
                                //lstisIn = '<p style="margin-bottom: 0px;"><b>In:</b> '.date('H:i', strtotime($lstRow['date'])).'</p>';
                            }
                            if($lstRow['isIn']==2) {
                                //$lstOut = '<p style="margin-bottom: 0px;"><b>Out:</b> '.date('h:i:s', strtotime($lstRow['date'])).'</p>';
                            }
                        }
                    }

                    if($lstcheck) {
                        $lstData = 'NA';
                    } else {
                        $lstData = $lstDate;
                    }

                    $data .= '<tr><td class="'.$classid.'" bgcolor="'.$color.'"><p style="margin-bottom: 0px;"><b>PTID :</b> '.$row['patient_id'].'</p><a target="_blank" href="'.base_url('admin/AddClient?patient=').$row['patient_id'].'" title="'.$supervisorName.'<br>(Click to edit record..)" data-toggle="tooltip" data-html="true" data-placement="top">'.$row['name'].'</a></td><td class="'.$classid.'"><a target="_blank" href="'.base_url('supervisor/edit?id=').$supervisorData['supervisor_id'].'">'.$supervisorData['name'].'</a></td><td style="font-weight: <?php echo $font_weight; ?>;color: <?php echo $color1; ?>" align="center">'.$row['total_limit'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['HMKRHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['pin'].'</td><td class="'.$classid.' text-center" bgcolor="'.$color.'">'.$lstData.'</td>';    


                    //if($_SESSION['userlevel']=='A') {    
                    if(checkUserLevel('A', $this->session->userdata('userlevel'))) {   
                        $onclick = "return confirm('Are you sure you want to delete this?');";
                        $data .= '<td class="'.$classid.'" style="width:5%"><center><a href="'.base_url('employee/delAssignEmployee/'.$row['employee_id'].'/'.$row['patient_id']).'" title="Delete" class="btn btn-xs btn-danger" onclick="'.$onclick.'"><i class="fa fa-trash"></i></a></center></td>';
                    }
                  $data .= '</tr>';
                } 
            } else {
                $data = '<tr align="center"><td colspan="9">No data found.</td></tr>';
            }
            print_r($data);
        }
    }


    public function getTimesheetViwer() {
        $postData = $this->input->post();
        if(!empty($postData['employee_id'])) {

            $agency_code = $this->session->userdata('agency');

            $where = [];
            $where['ea.employee_id'] = $postData['employee_id'];
            $like = [];
            if($postData['status']=='false') {
              $like['ea.pin'] = '+'; 
            }
            $not_like = [];
            if($postData['status']=='true') {
              $not_like['ea.pin'] = '+';   
            }
            $eaData    =   $this->employee->getAssignedPatientData($where, $like, $not_like);

            if ($agency_code == 2 || $agency_code == 4 )  {
                $where = [];
                $where['start_date <='] = date("Y-m-d");
                $weeklyData = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);       

                $x=0;$start = [];
                if(!empty($weeklyData)) {
                    foreach ($weeklyData as $key => $roww) {
                        $start[$x] = $roww['start_date'];
                        $x++;
                    }
                }

                $data = '';

                if(!empty($eaData)) {
                    foreach ($eaData as $key => $emprow) {
                        $data .= '<tr>
                        <td>'.$emprow['name'].'
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[0].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 1 <a/>  
                        <center>
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[1].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 2 <a/>  
                        </center>   
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[2].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 3 <a/>
                        </center>
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[3].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 4 <a/>  
                        </center>
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[4].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 5 <a/>  
                        </center>
                        </td>
                        </tr>';
                    } 
                } else {
                    $data = '<tr align="center"><td colspan="6">No data found.</td></tr>';
                }

                print_r($data);
            }

            if ($agency_code == 1 || $agency_code == 3 )  {
                $dday = date('Y-m-d');
                $mmonth =  date('m',strtotime($dday));
                $yyear = date('Y',strtotime($dday));
                $dday = $yyear.'-'.$mmonth.'-01';
                $period1[0] = $yyear.$mmonth.'15'; 
                $period2[0] = $yyear.$mmonth.'16'; 
                $MONTH[0] =  date('M',strtotime($dday));
                for ($x=1;$x<=4;$x++) {
                    $mdate = strtotime($dday.' -'.$x.' months');
                    $mmonth = date('m',$mdate);
                    $yyear = date('Y',$mdate);
                    $period1[$x] = $yyear.$mmonth.'15'; 
                    $period2[$x] = $yyear.$mmonth.'16'; 
                    $MONTH[$x] =   date('M', strtotime("-".$x." month"));
                    $MONTH[$x] =   date('M',$mdate);
                }

                if(!empty($eaData)) {
                    foreach ($eaData as $key => $emprow) {
                        $data .= '<tr><td>'.$emprow['name'].'</td>';
                        for ($x=0;$x<=4;$x++) {
                        $data .= '<td>
                            <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.$period1[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero="  target="_blank"> Period 1 <a/>  

                            <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.$period2[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> Period 2 <a/>   
                        </td>';
                        }
                        $data .= '</tr>';
                    }
                }
                print_r($data);
            }
        }
    }



    public function changeAgency(){
        $postData = $this->input->post();

        if(!empty($postData['password'])) {
            $where = [];
            //$where['name'] = $postData['userName'];
            $where['user_id'] = $this->session->userdata('id');
            $where['password'] = md5($postData['password']);
            //$where['find_in_set("A",userlevel)<>'] = 0;
            $where['(find_in_set("A",userlevel) OR find_in_set("C",userlevel) OR find_in_set("I",userlevel))<>'] = 0;
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);
            if($check && (checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('C', $this->session->userdata('userlevel')) || checkUserLevel('I', $this->session->userdata('userlevel')))) {
                $where = [];
                $where['employee_id'] = $postData['employee_id'];
                $dataArray = [];
                $dataArray['Agency'] = $postData['changeAgency'];
                $dataArray['changenotes'] = $postData['changeNotes'];
                $update = $this->Comman_model->update('employee', $where, $dataArray);
                if($update) {

                    $where = [];
                    $where['agency_code'] = $postData['changeAgency'];
                    $agencyData = $this->Comman_model->get_row('agency', $where);

                    ############### USER ACTION TRACKING START ####################
                    if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user update agency to '.$agencyData['agency_codename'].' for employee id '.$postData['employee_id'].' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);    
                    }
                    ############### USER ACTION TRACKING END ####################


                    echo 1;
                } else {
                    echo 2;
                }
            } else {
                echo 0;
            }
        }
    }

    public function uploadfiles($img_data=[]){
        $folder =   $img_data['path'];
        $file = $img_data['file_name'];
        $allowed_types =    $img_data['allowed_type'];
        $older =    $img_data['old_file'];
        $width  =   $img_data['width'];
        $height =   $img_data['height'];
        $quality    =   $img_data['quality'];

        if(!empty($_FILES[$file]) && $_FILES[$file]['size'] > 0){          
            if(!empty($older)){
                $postimgurl = FCPATH."$folder/". $older;
                unlink($postimgurl);
            }
            $config =   [];
            $config['upload_path']     = './'."$folder".'/'; 
            $config['allowed_types']   = $allowed_types;
            $new_name = $file.time().rand(0000,9999);
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if($this->upload->do_upload($file)){
                $postimg =$this->upload->data()['file_name'] ;
                $postimgurl = base_url()."$folder/". $postimg;
                chmod($this->upload->data()['full_path'],0777);
                if($img_data['image_compress']){
                    $config =   [];
                    $config['image_library'] = 'gd2';  
                    $config['source_image'] = './'."$folder".'/'.$postimg;  
                    $config['create_thumb'] = FALSE;  
                    $config['maintain_ratio'] = FALSE;  

                    $config['quality'] = $quality;  
                    if(!empty($width)){
                        $config['width'] = $width;  
                    }
                    if(!empty($height)){
                        $config['height'] = $height;  
                    }
                    
                    $config['new_image'] = './'."$folder".'/'.$postimg;  
                    
                    $this->load->library('image_lib', $config);  
                    $this->image_lib->initialize($config);
                    if($this->image_lib->resize()){
                        $this->image_lib->clear();
                        $data['url'] =  $postimg;
                        $data['status'] = 1;
                    }else{
                        $data['status'] = 0;
                        $data['msg']=$this->upload->display_errors();
                    }  
                }else{
                    $data['url'] =  $postimg;
                    $data['status'] = 1;
                }
            }else{
                $data['status']=0;
                $data['msg']=$this->upload->display_errors();
            }
            return $data;
        }
    }
    
    public function statusReport() {
        if(isset($_SESSION['name'])) {
            $data['Status'] = @$_GET['Status'];
            $data['race'] = @$_GET['race'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/status-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function getReportPdf() {

        $agency_code = $this->session->userdata('agency');     
        $Status = @$_GET['Status'];
        $race = @$_GET['race'];

        //array(100,150)
        $cnt = 0;
        $ctr = 0;
        $max  = 40;
        $spc = 40;
        $orient = 'P';
        require_once(APPPATH . 'libraries/employee-report-pdf.php'); 
        $pdf = new employeeReportPDF($orient, 'mm',array(215.9,279.4) );
        //$pdf=new PDF($orient, 'mm',array(215.9,279.4) );

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->Comman_model->get_row('agency', $where);

        $_SESSION['AgencyName'] = $agencyData['agency_shortname'];
        $_SESSION['title'] = "Inactive";
        if($Status==1) {$_SESSION['title'] = "Active"; }
        if($Status==2) {$_SESSION['title'] = "Applicant"; }
        if($Status==3) {$_SESSION['title'] = "InActive"; }
        if($Status==4) {$_SESSION['title'] = "Poor Worker"; } 
        if($Status==5) {$_SESSION['title'] = "Re-Hireable"; } 
        if($Status==6) {$_SESSION['title'] = "Stole Money"; } 
        
        //$pdf=new PDF('L');

        //array(100,150)
        $pdf->AliasNbPages();
        $pdf->AddPage($orient);

        $pdf->SetFont('Arial','',8);
        $pdf->SetLeftMargin(10);


        $sql = "SELECT * FROM patient";
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%'  AND Status = 3 ORDER BY employee.lastname";       

        if ($Status == 1 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code'  AND race LIKE '%$race%' AND Status = 1 ORDER BY employee.lastname";       
        }

        if ($Status == 2 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code'  AND race LIKE '%4race%' AND Status = 2 ORDER BY employee.lastname";       
        }

        if ($Status == 4 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 4 ORDER BY employee.lastname";        
        }

        if ($Status == 5 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 5 ORDER BY employee.lastname";        
        }

        if ($Status == 6 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 6 ORDER BY employee.lastname";        
        }

        //$result = mysql_query($sql);
        $result = $this->employee->getCustomQueryData($sql);
        $pdf->setxy(10,$spc);
        $page = 0;
        $counter = 0;
        //while(($row = mysql_fetch_array($result))) {
        foreach ($result as $key => $row) {

            if ($cnt >= $max) {
                $page = $page + 1;
                $cnt = 0; 
                $pdf->AliasNbPages();
                $pdf->AddPage($orient);
                $pdf->setxy(10,$spc);
            }

            $counter++;   
            $phone = $row['phone'];
            $phone2 = $row['mobile'];
            $race2 = $row['race'];
            $Birthdate = date("m/d/Y",strtotime($row['BirthDate']));

            $cnt = $cnt + 1;
            $pdf->Cell(62,5,$row['name'],1,0,'L');       
            $pdf->Cell(18,5,$Birthdate,1,0,'L');       
            $pdf->Cell(22,5,$phone,1,0,'L');       
            $pdf->Cell(22,5,$phone2,1,0,'L');       
            $pdf->Cell(22,5,$race2,1,1,'L');       

        }

        $pdf->Cell(30,5,'',0,1,'R');
        $pdf->Cell(100,5,'Total:'.$counter,0,0,'L');
        $pdf->Output();
    }

    public function getReportExcel() {
        $agency_code = $this->session->userdata('agency');     
        $Status = $_GET['Status'];                          
        $race = $_GET['race'];                          

        $temp = "CREATE TEMPORARY TABLE `temp_trans` (
        `EmployeeName` varchar(40) NOT NULL,
        `BirthDate` varchar(20) NOT NULL,
        `Phone` varchar(20) NOT NULL,
        `ALTPhone` varchar(20) NOT NULL,
        `race` varchar(20) NOT NULL )";

        $tempresult = $this->client->createTemporaryTable($temp);

        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 3 AND race LIKE '%$race%'  ORDER BY employee.lastname";       

        if ($Status == 1 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 1 AND race LIKE '%$race%'   ORDER BY employee.lastname";          
        }

        if ($Status == 2 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 2 AND race LIKE '%$race%'  ORDER BY employee.lastname";       
        }

        if ($Status == 4 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 4  AND race LIKE '%$race%'  ORDER BY employee.lastname";          
        }

        if ($Status == 5 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 5  AND race LIKE '%$race%'  ORDER BY employee.lastname";          
        }

        if ($Status == 6 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 6  AND race LIKE '%$race%' ORDER BY employee.lastname";       
        }

        //$result = mysql_query($sql);
        $result = $this->employee->getCustomQueryData($sql);
        //while(($row = mysql_fetch_array($result))) {
        foreach ($result as $key => $row) {

            $phone = $row['phone'];
            $phone2 = $row['mobile'];
            $race2 = $row['race'];
            $BirthDate = date("m/d/Y",strtotime($row['BirthDate']));
            $EmployeeName = $row['name'];   

            $dataArray = [];
            $dataArray['EmployeeName'] = $EmployeeName;
            $dataArray['BirthDate'] = $BirthDate;
            $dataArray['Phone'] = $phone;
            $dataArray['ALTPhone'] = $phone2;
            $dataArray['race'] = $race2;

            $insert = $this->Comman_model->insert('temp_trans', $dataArray);

        } 


        // file name for download
        $filename = "EmployeeStatusReport_" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        $row2 = 0;
        $arry = array(' ',' ',' ',' ');
        $result = $this->Comman_model->get_rows('temp_trans');
        foreach ($result as $key => $row) {
            if(!$flag) {
              // display field/column names as first row
              array_walk($row, array($this,'cleanData'));

              echo implode("\t",$arry) . "\r\n";
              echo implode("\t", array_keys($row)) . "\r\n";
              $flag = true;
            }
            array_walk($row, array($this, 'cleanData'));
            $x = 1;
            echo implode("\t", array_values($row)) . "\r\n";
        }                 
    }

    public function cleanData(&$str)  {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    public function compliance() {
        if(isset($_SESSION['name'])) {
            $Agency = $this->session->userdata('agency');
            $drpSQL = "SELECT  
                        employee.lastname AS empl_lastname,
                        employee.firstname AS empl_firstname,
                        compliance
                        FROM employee,supervisor  
                        WHERE supervisor.supervisor_id = employee.supervisor_id  AND  employee.Agency = '$Agency' AND compliance != ''  ORDER BY employee.lastname ASC";

            $data['complianceData'] = $this->employee->getCustomQueryData($drpSQL);            

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/compliance.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    
    public function delete_Employee() {
        $id = $this->input->get('employee_id');
        $data = $this->db->where('employee_id',$id)->delete('employee');
        if($data) {

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user delete employee id '.$id.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################

            $this->session->set_flashdata('message','Employee deleted successfully.');
            redirect('employee');
        } else {
            $this->session->set_flashdata('message','Somthing Went Wrong');
            redirect('employee');
        }
    }


    public function copyProfileToAgency() {

        $postData = $this->input->post();
        $userid = $postData['pid']; 
        $newagency = $postData['newag'];
        $usrag = '';

        $cols=array();
        $result = "SHOW COLUMNS FROM employee";

        $result = $this->employee->getCustomQueryData($result);

        foreach ($result as $key => $r) {
            if (!in_array($r["Field"],array("employee_id","Agency","mobile","pin","sms","supervisor_id","VisitationNotes","AssignedStaffingCoordinator","StateLic","upsize_ts","ADP","supervisor_id2","supervisor_id3"))) {
                $cols[]= $r["Field"];
            } 
        }

        //print_r($cols);die;

        $result = "SELECT * FROM employee WHERE employee_id='".$userid."'";
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {    
            $usrag = $r['Agency'];
            $mob = $r['mobile']==''?"' '":"'".$r['mobile']."'";
            $pn = $r['pin']==''?'':$r['pin'];
            $sms = $r['sms']==''?"' '":"'".$r['sms']."'";
            $supid = $r['supervisor_id']==''?"' '":"'".$r['supervisor_id']."'";
            $vsnote = $r['VisitationNotes']==''?"' '":"'".$r['VisitationNotes']."'";
            $ascoor = $r['AssignedStaffingCoordinator']==''?"' '":"'".$r['AssignedStaffingCoordinator']."'";
            $stl = $r['StateLic']==''?"' '":"'".$r['StateLic']."'";
            $upsts = $r['upsize_ts']==''?"' '":"'".$r['upsize_ts']."'";    


            $dataArray = [];
            $dataArray['Agency'] = $newagency;
            $dataArray['mobile'] = $mob;
            $dataArray['pin'] = $pn;
            $dataArray['sms'] = $sms;
            //$dataArray['supervisor_id'] = $supid;
            $dataArray['VisitationNotes'] = $vsnote;
            $dataArray['AssignedStaffingCoordinator'] = $ascoor;
            $dataArray['StateLic'] = $stl;
            $dataArray['upsize_ts'] = $upsts;

            //print_r($dataArray);die;
            $count=count($cols);
            foreach($cols as $counter=>$col) {
                $dataArray[$col] = $r[$col]=='' ? 'NULL' : $r[$col];
            }

            $newuserid = $this->Comman_model->insert('employee', $dataArray);
            
        }

        /*$cols = array();
        $result = "SHOW COLUMNS FROM employee_assignment"; 
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {
            if (!in_array($r["Field"],array("employee_id"))) {
                $cols[]= $r["Field"];
            } 
        }

        $result = "SELECT * FROM employee_assignment WHERE employee_id='".$userid."'";
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {

            $dataArray = [];
            $dataArray['employee_id'] = $newuserid;
            $count=count($cols);
            foreach($cols as $counter=>$col) {
                $dataArray[$col] = $r[$col]=='' ? 'NULL' : $r[$col];
            }

            $insertId = $this->Comman_model->insert('employee_assignment', $dataArray);
        }  */

        $dataArray = [];
        $dataArray['Status'] = 3;
        $where = [];
        $where['employee_id'] = $userid;
        $update = $this->Comman_model->update('employee', $where, $dataArray);

        $where = [];
        $where['employee_id'] = $userid;
        $employeeData = $this->Comman_model->get_row('employee', $where);

        //migrate image too
        $filename = FCPATH."image/emp_image/".$employeeData['emp_image'];
        $newfilename = 'E'.$newuserid.'.jpg';
        if(file_exists($filename)) {
            if(!copy($filename,FCPATH.'image/emp_image/'.$newfilename)){
                //die('unable to copy');    
            }            
        }

        $dataArray = [];
        $dataArray['emp_image'] = $newfilename;
        $where = [];
        $where['employee_id'] = $newuserid;
        $update = $this->Comman_model->update('employee', $where, $dataArray);

        ############### USER ACTION TRACKING START ####################
        if($this->session->userdata('id')!=6) {
            $dataArray = [];
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['user_action'] = $this->session->userdata('name'). ' user copy profile employee id '.$userid.' at '. date('m/d/Y H:i:s');
            $this->Comman_model->insert('users_tracking', $dataArray);    
        }
        ############### USER ACTION TRACKING END ####################

        echo 'success';
    }

    public function history() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $where  = [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            /*$where= [];
            $where['patient_id'] = $_GET['patient'];
            $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where);
            $data['patient_id'] =  $_GET['patient']; */

            $limit = 5;
            if(!empty($this->input->post('limit'))) {
              $limit = $this->input->post('limit');  
            }

            $where  = [];
            $where['puh.employee_id'] = $_GET['employee'];
            $data['patientHistoryData']    =   $this->Comman_model->getEmployeeHistory($where, $limit);

            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            $where = [];
            $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $data['limit'] = $limit;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/history.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function customReport() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where);

            $where = [];
            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $where['is_supervisor'] = 1;
            $where['lastname!='] = '';
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'name', 'asc');

            if(isset($_POST['search']) && $_POST['search']=='Search') {
                $data['employeeData']    =   $this->client->getEmployeeCustomReport();
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/custom-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function billedHours() {
        if(isset($_SESSION['name'])) {

            $MySql = "select * from patient where IsActive = 1 and patient_id=2416";
            $result = $this->Comman_model->getCustomQueryData($MySql);
            foreach ($result as $key => $row) {

                $where  =   [];
                $where['agency_location_code'] =   $row['agency_location'];
                $locationData = $this->Comman_model->get_row('agency_location', $where);

                $where  =   [];
                $where['agency_code'] =   $row['Agency'];
                $agencyData = $this->Comman_model->get_row('agency', $where);

                $where = [];
                $where['supervisor_id'] = $row['supervisor_id'];
                $supervisorData = $this->Comman_model->get_row('supervisor', $where);

                $where  =   [];
                $where['DistrictID'] =   $row['DistrictID_Ref'];
                $where['Agency'] =   $row['Agency'];
                $districtData = $this->Comman_model->get_row('tbldistricts', $where);

                //die;
                $fldnum = 0;
                $stat = "";

                $patient = $row['patient_id'];
                $month = '06';

                $start = date('Y-m-d', strtotime('2020-'.$month.'-01'));
                $end = date('Y-m-t', strtotime($start));
                
                

                $chkSQL = "SELECT * FROM employee_2finalsheet where start_date>='".$start."' AND start_date<='".$end."' AND patient_id = '".$patient."' order by employee_2finalsheet_id";  

                //$chkSQL = "SELECT * FROM employee_2finalsheet where patient_id = '".$patient."' AND MONTH(start_date) = '$month' AND YEAR(start_date) = '2020' order by employee_2finalsheet_id";  

                $objExec = $this->Comman_model->getCustomQueryData($chkSQL);

                $dataArray = [];
                $Total = 0;
                foreach ($objExec as $key => $objResult) {

                    $daycnt = 0;
                    $thrsleft = $objResult['total_hrs'];
                    $thrsallow = $objResult['total_allow'];
                    $EmployeeTypeID_Ref = $objResult['service_type'];
                    $TEmployeeTypeID_Ref = $objResult['service_type'];
                    $xserv = $objResult['service_type'];
                    $note1 = $objResult['note1'];

                    $checkBilled = false;
                    
                    $month = $year = '';
                    for ($cal=0; $cal < 14; $cal++) {
                        $ptid = $objResult['patient_id'];
                        $startdate = $objResult['start_date'];
                        $fldnum = $cal + 1;
                        $date = strtotime(date("Y-m-d", strtotime($startdate)) . " + ".$cal."days");
                        $datetrans = date("Y-m-d",$date);
                        if($datetrans>$end) {
                            break;
                        }
                        //echo '<br>';
                        $month = date("m",$date);
                        $year = date("Y",$date);
                        $d =  'd'.sprintf("%02s", $fldnum);
                        $dt =  'date'.sprintf("%02s", $fldnum);
                        $arr[$fldnum] = $objResult[$d];
                        $stat[$fldnum] = "";

                        $chkSQL2 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND total_paid=0";
                        $objResult2 = $this->Comman_model->getCustomQueryData($chkSQL2, 'row');
                        if (!empty($objResult2))  {
                            $stat[$fldnum] = $objResult2['status'];
                            if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                                if ($objResult2['total_paid'] == 0 )  {
                                    $stat[$fldnum] = "Billed";
                                }
                                if ($objResult2['total_paid'] > 0 )  {
                                    $stat[$fldnum] = "Paid";
                                }
                                if ($objResult2['total_paid'] > 0 && $objResult2['remarks'] != '' )  {
                                    $stat[$fldnum] = "Rejected";
                                }
                           }
                        } else {
                            $chkSQL3 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS null AND total_paid=0";
                            $objResult3 = $this->Comman_model->getCustomQueryData($chkSQL3, 'row');

                            $stat[$fldnum] = $objResult3['status'];
                            if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                               $stat[$fldnum] == 'Pending';
                            }  

                            $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                            $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');
                            if (!empty($objResult4)) { 
                                $stat[$fldnum] = $objResult4['status'];
                            } 
                            $chkSQL5 = "SELECT * FROM eclaims_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans' AND status = 'Billed'";
                            $objResult5 = $this->Comman_model->getCustomQueryData($chkSQL5, 'row');
                            if(!empty($objResult5) )  { 
                                $stat[$fldnum] = $objResult5['status'];
                            } 
                            $month = date("m",strtotime($datetrans));
                            $year = date("Y",strtotime($datetrans));
                            $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                            $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');

                            if(!empty($objResult4) )  { 
                                $stat[$fldnum] = $objResult4['status'];
                            }

                            $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Billed'";
                            $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');

                            if (!empty($objResult8) )  { 
                                $stat[$fldnum] = $objResult8['status'];
                            }

                            $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Reverse'";
                               //echo $chkSQL8;
                               $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');
                                   if (!empty($objResult8) )  { 
                                      $stat[$fldnum] = $objResult8['status'];
                                   }        
                        }

                        //echo $stat[$fldnum];

                        //if($stat[$fldnum]=='Billed') {
                            $d = date('d',$date);
                            //echo $d.' ';
                            //echo date('D',$date).' ';
                            //echo date('m',$date).' ';
                            //echo date('Y',$date).' ';
                            //echo $arr[$fldnum].' ';
                            //echo $stat[$fldnum].' ';
                            $checkBilled = true;
                            
                            //$dataArray[$objResult[$dt]] = $arr[$fldnum];
                            if($objResult[$dt]<=$end) {
                                $Total = $Total + $arr[$fldnum];
                                $dataArray['day'.$d] = $arr[$fldnum];
                            }

                            
                        //} else{
                           // continue;
                        //}
                    } 
                    if($checkBilled) {
                        $monthName = date('F', mktime(0, 0, 0, $month, 10));
                        $dataArray['status'] = 'Billed';
                        $dataArray['month'] = $month;
                        $dataArray['month_name'] = $monthName;
                        $dataArray['year'] = $year;
                        $dataArray['total_hrs'] = $Total;                    
                        $dataArray['patient_id'] = $objResult['patient_id'];
                        //$dataArray['employee_id'] = $objResult['employee_id'];
                        $dataArray['Agency'] = $objResult['Agency'];
                        $dataArray['agency_name'] = $agencyData['agency_codename'];
                        $dataArray['ApproveHours'] = $row['HMKRHours'];
                        $dataArray['location'] = $locationData['agency_location_name'];
                        $dataArray['supervisor_id'] = $row['supervisor_id'];
                        $dataArray['supervisor_name'] = $supervisorData['name'];
                        $dataArray['full_hours'] = $districtData['full_hours'];
                        $dataArray['district_id'] = $districtData['DistrictID'];
                        $dataArray['district'] = $districtData['DistrictNumber'].'-'.$districtData['DistrictName'];
                        $dataArray['patient_name'] = $row['name'];
                    }
                }

                if(!empty($dataArray)){
                    //$this->Comman_model->insert('billed_hours_old', $dataArray);
                }
                print_r($dataArray);
            }
            echo 'Done';
        } else {
            redirect();
        }
    }


    public function billedHourSettings() {
        if(isset($_SESSION['name'])) {

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/billed-hours.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function billedHourSettingsFromTo() {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/billed-hours-from-to.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function setBilledHours() {

        $runYear = $this->input->post('year');
        $runMonth = $this->input->post('month');
        $status = $this->input->post('status');

        //echo $runYear.'-'.$runMonth;die;

        if(!empty($runYear) && !empty($runMonth)) {
            $where = [];
            $where['IsActive'] = $status;
            if($status==1) {
                $or_where['IsActive'] = 3;
            }
            if($status==0) {
                $or_where['IsActive'] = 2;
            }
            //$where['patient_id'] = 11185;
            //$patientData = $this->Comman_model->get_rows('patient', $where, '', '', '', '', '', '', $or_where);
            $patientData = $this->Comman_model->get_rows2('patient', $where, $or_where);
            foreach ($patientData as $key => $row) {

                $where = [];
                $where['supervisor_id'] = $row['supervisor_id'];
                $supervisorData = $this->Comman_model->get_row('supervisor', $where);

                $where  =   [];
                $where['DistrictID'] =   $row['DistrictID_Ref'];
                $where['Agency'] =   $row['Agency'];
                $districtData = $this->Comman_model->get_row('tbldistricts', $where);

                $where  =   [];
                $where['agency_code'] =   $row['Agency'];
                $agencyData = $this->Comman_model->get_row('agency', $where);

                $where  =   [];
                $where['agency_location_code'] =   $row['agency_location'];
                $locationData = $this->Comman_model->get_row('agency_location', $where);

                $patientId = $row['patient_id'];
                $patientName = $row['name'];
                $HMKRHours = $row['HMKRHours'];
                $supervisorId = $supervisorData['supervisor_id'];
                $supervisorName = $supervisorData['name'];
                $districtId = $districtData['DistrictID'];
                $district = $districtData['DistrictNumber'].'-'.$districtData['DistrictName'];
                $full_hours = $districtData['full_hours'];
                $location = $locationData['agency_location_name'];
                $locationId = $locationData['agency_location_code'];
                $agency = $row['Agency'];
                $agency_name = $agencyData['agency_codename'];

                if($row['IsActive']==1 || $row['IsActive']==3) {
                    $clientStatus = 'Active';
                } else {
                    $clientStatus = 'Inactive';
                }

                if($agency==1 || $agency==3) {
                    for ($month=$runMonth; $month <=$runMonth ; $month++) { 
                        $this->billedHours13($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);
                    }
                }
                if($agency==2 || $agency==4) {
                    for ($month=$runMonth; $month <=$runMonth ; $month++) { 
                        //$this->billedHours24($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name);
                        $this->billedHours24New($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);
                        
                    }
                }
            }
            $this->session->set_flashdata('message','Billed hours has been saved successfully.');
            redirect('employee/billedHourSettings');
        } else {
            redirect($this->agent->referrer());
        }
    }

    public function setBilledHoursFromTo() {

        $runYear = $this->input->post('year');
        $runMonth = $this->input->post('fromMonth');
        $toMonth = $this->input->post('toMonth');
        $status = $this->input->post('status');

        //echo $runYear.'-'.$runMonth;die;

        if(!empty($runYear) && !empty($runMonth)) {
            $where = [];
            $where['IsActive'] = $status;
            if($status==1) {
                $or_where['IsActive'] = 3;
            }
            if($status==0) {
                $or_where['IsActive'] = 2;
            }
            //$where['patient_id'] = 11185;
            //$patientData = $this->Comman_model->get_rows('patient', $where, '', '', '', '', '', '', $or_where);
            $patientData = $this->Comman_model->get_rows2('patient', $where, $or_where);
            foreach ($patientData as $key => $row) {

                $where = [];
                $where['supervisor_id'] = $row['supervisor_id'];
                $supervisorData = $this->Comman_model->get_row('supervisor', $where);

                $where  =   [];
                $where['DistrictID'] =   $row['DistrictID_Ref'];
                $where['Agency'] =   $row['Agency'];
                $districtData = $this->Comman_model->get_row('tbldistricts', $where);

                $where  =   [];
                $where['agency_code'] =   $row['Agency'];
                $agencyData = $this->Comman_model->get_row('agency', $where);

                $where  =   [];
                $where['agency_location_code'] =   $row['agency_location'];
                $locationData = $this->Comman_model->get_row('agency_location', $where);

                $patientId = $row['patient_id'];
                $patientName = $row['name'];
                $HMKRHours = $row['HMKRHours'];
                $supervisorId = $supervisorData['supervisor_id'];
                $supervisorName = $supervisorData['name'];
                $districtId = $districtData['DistrictID'];
                $district = $districtData['DistrictNumber'].'-'.$districtData['DistrictName'];
                $full_hours = $districtData['full_hours'];
                $location = $locationData['agency_location_name'];
                $locationId = $locationData['agency_location_code'];
                $agency = $row['Agency'];
                $agency_name = $agencyData['agency_codename'];

                if($row['IsActive']==1 || $row['IsActive']==3) {
                    $clientStatus = 'Active';
                } else {
                    $clientStatus = 'Inactive';
                }

                if($agency==1 || $agency==3) {
                    for ($month=$runMonth; $month<=$toMonth; $month++) { 
                        $this->billedHours13($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);
                    }
                }
                if($agency==2 || $agency==4) {
                    for ($month=$runMonth; $month<=$toMonth; $month++) { 
                        //$this->billedHours24($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name);
                        $this->billedHours24New($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);                        
                    }
                }
            }
            $this->session->set_flashdata('message','Billed hours has been saved successfully.');
            redirect('employee/billedHourSettings');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function billedHours13($patient, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus) {
        //$patient ='1213';  
        //$month = 6;
        //$agency = 2;   

        $where = [];
        $where['patient_id'] = $patient;
        $where['year'] = $runYear;
        $where['month'] = $month;
        
        $billedData = $this->Comman_model->get_rows('employee_finalsheet', $where);
        if(!empty($billedData)) {
            $total = 0;
            $dataArray = [];
            $monthName = date('F', mktime(0, 0, 0, $month, 10));
            $dataArray['month']  = $month;
            $dataArray['month_name'] = $monthName;
            $dataArray['year']  = $runYear;
            $dataArray['patient_id'] = $patient;
            $dataArray['Agency'] = $agency;
            $dataArray['agency_name'] = $agency_name;
            $dataArray['status'] = 'Billed';
            $dataArray['patient_name'] = $patientName;
            $dataArray['supervisor_name'] = $supervisorName;
            $dataArray['district'] = $district;
            $dataArray['full_hours'] = $full_hours;
            $dataArray['location'] = $location;
            $dataArray['ApproveHours'] = $HMKRHours;
            $dataArray['district_id'] = $districtId;
            $dataArray['supervisor_id'] = $supervisorId;
            $dataArray['location_id'] = $locationId;
            foreach ($billedData as $key => $row) {
                $total = $total + ($row['period1']+$row['period2']);
            }
            $dataArray['total_hrs'] = $total;
            $dataArray['under_over_hours'] = ($HMKRHours-$total);
            $dataArray['client_status'] = $clientStatus;

            /************ DELETE BILLED HOURS START ***************/
            $where = [];
            $where['month'] = $month;
            $where['year'] = $runYear;
            $where['patient_id'] = $patient;
            $this->Comman_model->delete_row('billed_hours_old', $where);
            /************ DELETE BILLED HOURS END ***************/
            
            $this->Comman_model->insert('billed_hours_old', $dataArray);
        }
    }


    public function billedHours24New($patient, $month_para, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus) {
        //$patient ='1213';  
        //$month = 6;
        //$agency = 2;   

        $where = [];
        $where['patient_id'] = $patient;
        $where['year'] = $runYear;
        $where['month'] = $month_para;
        
        $billedData = $this->Comman_model->get_rows('employee_finalsheet', $where);
        if(!empty($billedData)) {
            $total = 0;
            $dataArray = [];
            $monthName = date('F', mktime(0, 0, 0, $month_para, 10));
            $dataArray['month']  = $month_para;
            $dataArray['month_name'] = $monthName;
            $dataArray['year']  = $runYear;
            $dataArray['patient_id'] = $patient;
            $dataArray['Agency'] = $agency;
            $dataArray['agency_name'] = $agency_name;
            $dataArray['status'] = 'Billed';
            $dataArray['patient_name'] = $patientName;
            $dataArray['supervisor_name'] = $supervisorName;
            $dataArray['district'] = $district;
            $dataArray['full_hours'] = $full_hours;
            $dataArray['location'] = $location;
            $dataArray['ApproveHours'] = $HMKRHours;
            $dataArray['district_id'] = $districtId;
            $dataArray['supervisor_id'] = $supervisorId;
            $dataArray['location_id'] = $locationId;
            foreach ($billedData as $key => $row) {
                $total = $total + ($row['period1']+$row['period2']);

                for ($cal=1; $cal <= 31; $cal++) {
                    $d =  'day'.sprintf("%02s", $cal);
                    $dataArray[$d] = $dataArray[$d] + $row[$d];
                }

            }
            $dataArray['total_hrs'] = $total;
            $dataArray['under_over_hours'] = ($HMKRHours-$total);
            $dataArray['client_status'] = $clientStatus;


            //print_r($dataArray);die;

            /************ DELETE BILLED HOURS START ***************/
            $where = [];
            $where['month'] = $month_para;
            $where['year'] = $runYear;
            $where['patient_id'] = $patient;
            $this->Comman_model->delete_row('billed_hours_old', $where);
            /************ DELETE BILLED HOURS END ***************/
            
            $this->Comman_model->insert('billed_hours_old', $dataArray);
        }
    }




    public function billedHours24($patient, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name) {
      $patientId = $patient;

      $datetrans = date("Y-m-d", mktime(0, 0, 0, $month, 1));

      /*$year = date("Y",strtotime($datetrans)); 
      $month = date("m",strtotime($datetrans)); 
      $tdate = strtotime($year.'-'.$month.'-01');
      $action = 2;

      if ($action ==2) {
        $cutoff = 16;
        $eom = 31;
        $tdate2 = strtotime($year.'-'.$month.'-01');
        $fromdate = date("Y-m-d",$tdate2);
        $todate = date("Y-m-t",$tdate);         
      }*/

      $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE patient_id = '$patientId' AND isIn = 1 AND MONTH(date) = '$month' AND YEAR(date) = '2020' ORDER BY date ";

      $singleViewData = $this->Comman_model->getCustomQueryData($MySQL); 

      $curdate = date('m/d/Y');
      $index = 0;
      $timetotal = 0;
      $billedHour = 0;
      $dataArray =[];
      foreach($singleViewData as $row) {
        //$bgcolor = ""; 
        $timedate = date("Y-m-d",strtotime($row['date'])) ;
        $temp = '';
        $c1 = $row['employee_clock_id'];
        $temp = date('H:i',strtotime($row['date']));

        $latitude = $row['latitude'];
        $task3 = $row['tasks'];
        $task1 = trim($row['ivr_task']);
        $ivr_task = trim($row['tasks']);
        $task2 = "";
        $t = explode(":",$temp );
        $hr1 = $t[0];
        $mn1 = $t[1];
        $fdate = date('Y-m-d',strtotime($row['date']));
        $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

        $disp1 = $hr1 + ($mn1 / 60);
        $tot1 = quarter($disp1);
        $tot1 = number_format($tot1,2);
        $from_time=$tot1;

        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);
        $timein = '';
        if ($orig != 0) { $timein =  date('H:i',strtotime($orig['date'])); }

        $x = '2';
        $rec_id = $row['rec_id'];

        $where = [];
        $where['employee_id'] = $row['employee_id'];
        $where['patient_id'] = $row['patient_id'];
        $where['DATE(date)'] = $timedate;
        $where['isIn'] = $x;
        $where['rec_id'] = $rec_id;
        $rowdate = get_employee_clock($where);

        $to_time=strtotime($rowdate['date']);
        $total = number_format((($to_time - $from_time) / 60) / 60,2);

        $temp = '';
        $c2 = null;
        if ($rowdate != 0 ) {
          $temp = date('H:i',strtotime($rowdate['date'])); $c2 = $rowdate['employee_clock_id']; $task2 = trim($rowdate['ivr_task']); 
        }
        $t = explode(":",$temp );
        $hr2 = $t[0];
        $mn2 = $t[1];
        $fdate = date('Y-m-d',strtotime($rowdate['date']));
        $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

        $disp2 = $hr2 + ($mn2 / 60);
        $tot2 = quarter($disp2);
        $tot2 = number_format($tot2,2);

        $to_time=$tot2;

        if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') || empty($rowdate) )  {
            $total = 0;
        } else {
            $total = $to_time - $from_time;
        }

        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);

        $timeout = '';       
        if ($orig != 0) { $timeout =  date('H:i',strtotime($orig['date'])); }
        if ($from_time != null && $to_time != null ) {
          if ($rowdate != 0 )   {
            $timetotal =  $timetotal + quarter(abs($total));    
          } 
        }  

        $billedHour = $billedHour + quarter(abs($total));

      } 

        $dataArray['month'] = $month;
        $dataArray['year'] = 2020;
        $dataArray['Agency'] = $agency;      
        $dataArray['patient_id'] = $patient;
        $dataArray['status'] = 'Billed';
        $dataArray['total_hrs'] = $billedHour;
        $dataArray['patient_name'] = $patientName;
        $dataArray['supervisor_name'] = $supervisorName;
        $dataArray['district'] = $district;
        $dataArray['full_hours'] = $full_hours;
        $dataArray['location'] = $location;
        $dataArray['HMKRHours'] = $HMKRHours;
        $dataArray['district_id'] = $districtId;
        $dataArray['supervisor_id'] = $supervisorId;
        $dataArray['location_id'] = $locationId;
        $dataArray['under_over_hours'] = ($HMKRHours-$billedHour);

        $this->Comman_model->insert('billed_hours', $dataArray);

    }

    public function billedHours24NewOld($patient, $month_para, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear) {


        

        //die;
        $fldnum = 0;
        $stat = "";

        $start = date('Y-m-d', strtotime($runYear.'-'.$month_para.'-01'));
        $end = date('Y-m-t', strtotime($start));
        //$patient = $row['patient_id'];

        $chkSQL = "SELECT * FROM table_2weekly where end_date>='".$start."' order by table_2weekly_id limit 1";  

        //$chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$start' AND start_date  <= '$start'";

        $row = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
        $start = $row['start_date'];
        //$end = $row['end_date'];

        echo $chkSQL = "SELECT * FROM employee_2finalsheet where start_date>='".$start."' AND start_date<='".$end."' AND patient_id = '".$patient."' order by employee_2finalsheet_id";  
        //$chkSQL = "SELECT * FROM employee_2finalsheet where patient_id = '".$patient."' AND MONTH(start_date) = '$month_para' AND YEAR(start_date) = '2020' order by employee_2finalsheet_id";  

        echo '<br>';

        $objExec = $this->Comman_model->getCustomQueryData($chkSQL);

        $dataArray = [];
        $totalArray = [];
        $Total = 0;
        foreach ($objExec as $key => $objResult) {

            $daycnt = 0;
            $thrsleft = $objResult['total_hrs'];
            $thrsallow = $objResult['total_allow'];
            $EmployeeTypeID_Ref = $objResult['service_type'];
            $TEmployeeTypeID_Ref = $objResult['service_type'];
            $xserv = $objResult['service_type'];
            $note1 = $objResult['note1'];

            $checkBilled = false;
            
            $month = $year = '';
            for ($cal=0; $cal < 14; $cal++) {
                $ptid = $objResult['patient_id'];
                $startdate = $objResult['start_date'];
                $fldnum = $cal + 1;
                $date = strtotime(date("Y-m-d", strtotime($startdate)) . " + ".$cal."days");
                $datetrans = date("Y-m-d",$date);

                if($datetrans>$end) {
                    //break;
                }
                //echo '<br>';
                $month = date("m",$date);
                $year = date("Y",$date);
                $d =  'd'.sprintf("%02s", $fldnum);
                $dt =  'date'.sprintf("%02s", $fldnum);
                $arr[$fldnum] = $objResult[$d];
                $stat[$fldnum] = "";

                $chkSQL2 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND total_paid=0";
                $objResult2 = $this->Comman_model->getCustomQueryData($chkSQL2, 'row');
                if (!empty($objResult2))  {
                    $stat[$fldnum] = $objResult2['status'];
                    if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                        if ($objResult2['total_paid'] == 0 )  {
                            $stat[$fldnum] = "Billed";
                        }
                        if ($objResult2['total_paid'] > 0 )  {
                            $stat[$fldnum] = "Paid";
                        }
                        if ($objResult2['total_paid'] > 0 && $objResult2['remarks'] != '' )  {
                            $stat[$fldnum] = "Rejected";
                        }
                   }
                } else {
                    $chkSQL3 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS null AND total_paid=0";
                    $objResult3 = $this->Comman_model->getCustomQueryData($chkSQL3, 'row');

                    $stat[$fldnum] = $objResult3['status'];
                    if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                       $stat[$fldnum] == 'Pending';
                    }  

                    $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                    $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');
                    if (!empty($objResult4)) { 
                        $stat[$fldnum] = $objResult4['status'];
                    } 
                    $chkSQL5 = "SELECT * FROM eclaims_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans' AND status = 'Billed'";
                    $objResult5 = $this->Comman_model->getCustomQueryData($chkSQL5, 'row');
                    if(!empty($objResult5) )  { 
                        $stat[$fldnum] = $objResult5['status'];
                    } 
                    $month = date("m",strtotime($datetrans));
                    $year = date("Y",strtotime($datetrans));
                    $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                    $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');

                    if(!empty($objResult4) )  { 
                        $stat[$fldnum] = $objResult4['status'];
                    }

                    $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Billed'";
                    $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');

                    if (!empty($objResult8) )  { 
                        $stat[$fldnum] = $objResult8['status'];
                    }

                    $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Reverse'";
                    //echo $chkSQL8;
                    $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');
                    if (!empty($objResult8) )  { 
                      $stat[$fldnum] = $objResult8['status'];
                    }        
                }

                //echo $stat[$fldnum];

                //if($stat[$fldnum]=='Billed') {
                    $d = date('d',$date);
                    //echo $d.' ';
                    //echo date('D',$date).' ';
                    //echo date('m',$date).' ';
                    //echo date('Y',$date).' ';
                    //echo $arr[$fldnum].' ';
                    //echo $stat[$fldnum].' ';
                    $checkBilled = true;
                    
                    //$dataArray[$objResult[$dt]] = $arr[$fldnum];

                    //echo $objResult[$dt];
                    //echo $end;die;

                    if($objResult[$dt]<$end) {
                        //$Total = $Total + $arr[$fldnum];
                        $dataArray['day'.$d] = $arr[$fldnum];
                        $totalArray['day'.$d] = $arr[$fldnum];

                        echo $d.'=>'.$dataArray['day'.$d].'<br>';
                    }

                    
                //} else{
                   // continue;
                //}
            } 

            //print_r($dataArray);die;

            if($checkBilled) {
                $monthName = date('F', mktime(0, 0, 0, $month_para, 10));
                $dataArray['status'] = 'Billed';
                $dataArray['month'] = $month_para;
                $dataArray['month_name'] = $monthName;
                $dataArray['year'] = $year;
                //$dataArray['total_hrs'] = $Total;                    
                $dataArray['patient_id'] = $patient;
                //$dataArray['employee_id'] = $objResult['employee_id'];
                $dataArray['Agency'] = $agency;
                $dataArray['agency_name'] = $agency_name;
                $dataArray['ApproveHours'] = $HMKRHours;
                $dataArray['location'] = $location;
                $dataArray['supervisor_id'] = $supervisorId;
                $dataArray['supervisor_name'] = $supervisorName;
                $dataArray['full_hours'] = $full_hours;
                $dataArray['district_id'] = $districtId;
                $dataArray['district'] = $district;
                $dataArray['patient_name'] = $patientName;
                $dataArray['location_id'] = $locationId;
                //$dataArray['under_over_hours'] = ($HMKRHours-$Total);
                //$dataArray['Available_Hours'] = ($HMKRHours-$Total);
            }
        }

        if(!empty($dataArray)) {

            //print_r($dataArray);die;

            $Total = array_sum($totalArray);
            $dataArray['total_hrs'] = $Total;
            $dataArray['under_over_hours'] = ($HMKRHours-$Total);

            print_r($dataArray);die;
            /************ DELETE BILLED HOURS START ***************/
            $where = [];
            $where['month'] = $month_para;
            $where['year'] = $year;
            $where['patient_id'] = $patient;
            $this->Comman_model->delete_row('billed_hours_old', $where);
            /************ DELETE BILLED HOURS END ***************/

            /************ INSERT NEW BILLED HOURS START ***************/
            $this->Comman_model->insert('billed_hours_old', $dataArray);
            /************ INSERT NEW BILLED HOURS START ***************/
        }
    }
  
    public function patientHistory() {
        $employee_id = $this->input->get('employee');
        if(isset($_SESSION['name']) && $employee_id!='') {

            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            $fromD  = date('Y-m-d', strtotime("first day of -2 month"));
            $toD    = date('Y-m-d', strtotime('last day of this month'));
            $keyword = '';
            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }       
            }
            
            $data['patientWeeklytData'] = $this->client->get_weekly_discussions($fromD, $toD, $_GET['patient'], $_SESSION['agency'], $keyword, $employee_id);

            $data['patient_id'] =  $_GET['patient']; 
            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['keyword'] = $keyword;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/assigned-patient.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function setEmployeeNotes() {
        $employee_id = $this->input->post('employee_id');
        $Notes = $this->input->post('Notes');
        if(isset($_SESSION['name']) && $employee_id!='' && $Notes!='') {

            $sql = "select * from employee_notes_history where employee_id='".$employee_id."' order by id desc limit 1";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');

            $dataArray = [];
            $dataArray['employee_id'] = $employee_id;
            $dataArray['employee_notes'] = $Notes;
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['createdOn'] = date('Y-m-d H:i:s');
            $result = $this->Comman_model->insert('employee_notes_history', $dataArray);
            if($result) {

                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user add notes to employee id '.$employee_id.' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);  

                    ################## Employee Notes Tracking Start ######################
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['old_notes'] = $row['employee_notes'];
                    $dataArray['message'] = $this->session->userdata('name'). ' user add notes to employee id '.$employee_id.' at '. date('m/d/Y H:i:s');
                    $dataArray['new_notes'] = $Notes;
                    $dataArray['change_user_id'] = $employee_id;
                    $dataArray['user_type'] = 'employee';
                    $this->Comman_model->insert('notes_tracking', $dataArray);
                    ################## Employee Notes Tracking End #########################
                }
                ############### USER ACTION TRACKING END ####################

                echo 1;
            } else {
                echo 0;
            }
        } else {
            echo 0;
        }
    }

    public function notesHistory() {
        $employee_id = $this->input->get('employee');
        if(isset($_SESSION['name']) && $employee_id!='') {
            
            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeNotesData'] = $this->Comman_model->get_rows('employee_notes_history', $where, 'id', 'desc');

            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/notes-history.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function deleteNotes($notesId) {
        if(!empty($notesId)) {
            $where = [];
            $where['id'] = $notesId;
            $notesData = $this->Comman_model->get_row('employee_notes_history', $where);
            $data = $this->Comman_model->delete_row('employee_notes_history', $where);
            if($data) {
                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user delete notes from employee id '.$notesData['employee_id'].' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################
                $this->session->set_flashdata('message','Notes has been deleted successfully.');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong.');
            }
        } 
        redirect($this->agent->referrer());      
    }

    /*public function getFlag() {
        $where = [];
        $where['Status!=1 and Status!='] = 3;
        $getEmployeeData = $this->Comman_model->get_rows('employee', $where);
        //print_r(count($getEmployeeData));die;
        $x=0;
        foreach ($getEmployeeData as $key => $row) {
            $dataArray = [];
            $dataArray['flag'] = $row['Status'];

            $where = [];
            $where['employee_id'] = $row['employee_id'];

            $this->Comman_model->update('employee', $where, $dataArray);
            $x++;
        }

        echo $x;
    }*/


    public function report() {
        if(isset($_SESSION['name'])) {

            $data = [];

            $agency = $this->session->userdata('agency');

            $where = [];
            $where['em.Status'] = 1;
            $where['pa.IsActive'] = 1;
            $where['em.Agency'] = $agency;
            $where['pa.Agency'] = $agency;
            $where['ea.total_limit'] = 0;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedPatientData'] = $this->employee->getActiveAssignedEmployeeData($where, $like, $not_like);    

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function manualTimesheet() {
        $employee_id = $this->input->get('employee');
        if(isset($_SESSION['name']) && $employee_id!='') {
            
            $csql = "select manual_timesheet_tracking.*, patient.name from manual_timesheet_tracking left join patient on manual_timesheet_tracking.patient_id=patient.patient_id where manual_timesheet_tracking.employee_id='".$employee_id."' order by manual_timesheet_tracking.id desc";
            $data['manualTimesheetData'] = $this->Comman_model->getCustomQueryData($csql);

            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/manual-timesheet.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function weeklyHourReport() {
        if(isset($_SESSION['name'])) {

            $data = [];

            $agency = $this->session->userdata('agency');

            $where = [];
            $where['em.Status'] = 1;
            $where['pa.IsActive'] = 1;
            $where['em.Agency'] = $agency;
            $where['pa.Agency'] = $agency;
            if($_GET['workHour'] && $_GET['workHour']==40) {
                $where['ea.total_limit>'] = 40;
            }
            if($_GET['workHour'] && $_GET['workHour']==50) {
                $where['ea.total_limit>'] = 50;
            }
            //$where['ea.total_limit'] = 0;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedPatientData'] = $this->employee->getActiveAssignedEmployeeData($where, $like, $not_like);    

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/weekly-hour-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function totalWeeklyHourReport() {
        if(isset($_SESSION['name'])) {

            $data = [];

            $agency = $this->session->userdata('agency');

            $where = [];
            $where['em.Status'] = 1;
            //$where['pa.IsActive'] = 1;
            $where['em.Agency'] = $agency;
            //$where['pa.Agency'] = $agency;
            $having = '';
            if($_GET['workHour'] && $_GET['workHour']==40) {
                $having = "totalWorkedHours>40";
            }
            if($_GET['workHour'] && $_GET['workHour']==50) {
                $having = "totalWorkedHours>50";
            }
            //$where['ea.total_limit'] = 0;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedEmployeeData'] = $this->employee->getTotalWorkHourEmployeeData($where, $like, $not_like, $having);    
            //print_r($data['assignedEmployeeData']);die;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/total-weekly-hour-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function redeemCash() {
        if(isset($_SESSION['name'])) {
            $cashAmount = $_POST['cashAmount'];
            $emplid = $_POST['emplid'];
            if(!empty($cashAmount) && !empty($emplid)) {
                $where = [];
                $where['employee_id'] = $emplid;
                $rewardsData = $this->Comman_model->get_row('employee_rewards', $where);
                if($rewardsData['available_cash']>=$cashAmount) {

                    $dataArray = [];
                    $dataArray['employee_id'] = $emplid;
                    $dataArray['redeem_cash'] = $cashAmount;
                    $dataArray['created_on'] = date('Y-m-d h:i:s');
                    $this->Comman_model->insert('employee_redeem_history', $dataArray);

                    $where = [];
                    $where['employee_id'] = $emplid;

                    $dataArray1 = [];
                    $dataArray1['available_cash'] = $rewardsData['available_cash']-$cashAmount;

                    $this->Comman_model->update('employee_rewards', $where, $dataArray1);

                    print_r(1);
                } else {
                    print_r(2);
                }
            }
        } else {
            redirect();
        } 
    }
} 