<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Evv extends CI_Controller {
    public function __construct() {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        } else {
            $this->headerData=[];
        }

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
    }

    function employeesData() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        $cond = "";

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND (emp.name LIKE '%".$search."%' OR emp.employee_id LIKE '%".$search."%')";
        }

        if(!empty($_GET['datefrom']) && !empty($_GET['dateto'])) {
            $datefrom = $_GET['datefrom']; $dateto = $_GET['dateto'];
        } else {
            $datefrom = date('Y-m-d'); $dateto = date('Y-m-d');
        }

        $agency_code = $this->session->userdata('agency');

        $totalRec = 0;
        $datas = [];
        $data = [];
        $i = 0;
        $sql = "SELECT ec1.rec_id as rec_id, ec1.date as d1, ec2.date as d2, ec1.employee_clock_id, ec1.employee_id, emp.name as emp_name FROM employee_clock ec1, employee_clock ec2, employee as emp WHERE ec1.rec_id = ec2.rec_id AND ec1.employee_id = emp.employee_id AND emp.Agency = '$agency_code' $cond AND DATE(ec1.date)>='$datefrom' AND DATE(ec1.date)<='$dateto' AND ec1.isIn = 1 AND ec2.isIn = 2 AND ec1.rec_id IS NOT NULL AND ec2.rec_id IS NOT NULL";
        $Tsql = $sql;
        $sql .= " $sLimit";
        $res = $this->Comman_model->getCustomQueryData($sql);
        $Tres = $this->Comman_model->getCustomQueryData($Tsql);

        foreach ($res as $key => $row) {
            $rec_id = $row['rec_id'];
            $param  = [];
            if(!empty($row['d2'])) {
                $employeeId = $row['employee_id'];
                $employeeClockId = $row['employee_clock_id'];
                $sqlem = "SELECT transaction_id FROM hhax.visits WHERE employee_id = '$employeeId' AND employee_clock_id = '$employeeClockId'";
                $rowem = $this->Comman_model->getCustomQueryData($sqlem, 'row');

                /******* Calculate Time In  ********/
                $temp = date('H:i',strtotime($row['d1']));
                $pairdate = date('Y-m-d',strtotime($row['d1']));
                $t = explode(":",$temp );
                $hrr1 = $t[0];
                $mnn1 = $t[1];

                $actual1 = $hrr1.':'.$mnn1; 
                $disp1 = $hrr1 + ($mnn1 / 60);
                $tot1 = quarter($disp1);
                $disp1 = quarter2($disp1);
                $disp1 = number_format($disp1,2);
                $tot1 = number_format($tot1,2);

                $t = explode(".",$disp1 );
                $hr1 = $t[0];
                $mn1 = $t[1];

                $fdate = date('Y-m-d',strtotime($row['d1']));
                $timedate = date('Y-m-d',strtotime($row['d1']));
                $idate = $fdate.' '.$hrr1.':'.$mnn1.':'.'00';
                $from_time=strtotime($idate);

                $timeInn = $hr1.':'.$mn1;

                /******* Calculate Time Out  ********/
                $temp = date('H:i',strtotime($row['d2']));
                $t = explode(":",$temp );
                $hrr2 = @$t[0];
                $mnn2 = @$t[1];
                $actual2 = $hrr2.':'.$mnn2; 
                $disp2 = $hrr2 + ($mnn2 / 60);
                $tot2 = quarter($disp2);
                $disp2 = quarter2($disp2);
                $disp2 = number_format($disp2,2);
                $tot2 = number_format($tot2,2);

                $t = explode(".",$disp2 );
                $hr2 = @$t[0];
                $mn2 = @$t[1];

                $fdate = date('Y-m-d',strtotime($row['d2']));
                $idate = $fdate.' '.$hrr2.':'.$mnn2.':'.'00';
                $to_time=strtotime($idate);

                $timeOut = $hr2.':'.$mn2;

                $total = number_format((($to_time - $from_time) / 60) / 60,2);

                $total2 =  $tot2 - $tot1;

                $param[0]   = $row['employee_clock_id'];
                $param[1]   = $row['employee_id'];
                $param[2]   = $row['emp_name'];
                $param[3]   = date('Y-m-d', strtotime($row['d1']));
                $param[4]   = $timeInn;
                $param[5]   = $timeOut;
                $param[6]   = abs($total2);    
                if(!empty($rowem['transaction_id'])) {
                    $param[7]   = 'Transaction Id: '.$rowem['transaction_id'];    
                } else {
                    $param[7]   = 'Not Generated';
                }            
            }

            if(!empty($param)) {
                $data[$key] = $param;
            }
        }

        $recordsTotal = count($Tres);
        $recordsFiltered = count($Tres);
                
        $nex = 0;

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        $response['lblTotal'] = $lblTotal;
        $response['sql'] = $sql;
        print_r(json_encode($response));        
    }

    function employeesDataNew() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        $cond = "";

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND (hhax.visits.employee_name LIKE '%".$search."%' OR hhax.visits.employee_id LIKE '%".$search."%')";
        }

        if(!empty($_GET['datefrom']) && !empty($_GET['dateto'])) {
            $datefrom = $_GET['datefrom']; $dateto = $_GET['dateto'];
        } else {
            $datefrom = date('Y-m-d'); $dateto = date('Y-m-d');
        }

        $agency_code = $this->session->userdata('agency');

        $totalRec = 0;
        $datas = [];
        $data = [];
        $i = 0;
        $sql = "SELECT hhax.visits.* FROM hhax.visits WHERE hhax.visits.agency_code = '$agency_code' $cond AND DATE(hhax.visits.date_in)>='$datefrom' AND DATE(hhax.visits.date_in)<='$dateto'";
        $Tsql = $sql;
        $sql .= " $sLimit";
        $res = $this->Comman_model->getCustomQueryData($sql);
        $Tres = $this->Comman_model->getCustomQueryData($Tsql);

        foreach ($res as $key => $row) {
            $param  = [];
            $employeeId = $row['employee_id'];
            $employeeClockId = $row['employee_clock_id'];            

            $param[0]   = $row['id'];
            $param[1]   = $row['employee_id'];
            $param[2]   = $row['employee_name'];
            $param[3]   = $row['date_in'];
            $param[4]   = $row['time_in'];
            $param[5]   = $row['time_out'];
            $param[6]   = $row['hours'];
            if(!empty($row['transaction_id'])) {
                $param[7]   = 'Transaction Id: '.$row['transaction_id'];    
            } else {
                $param[7]   = 'Not Submitted';
            }

            if(!empty($param)) {
                $data[$key] = $param;
            }
        }

        $recordsTotal = count($Tres);
        $recordsFiltered = count($Tres);
                
        $nex = 0;

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        $response['lblTotal'] = $lblTotal;
        $response['sql'] = $sql;
        print_r(json_encode($response));        
    }

    function employeesDataCaregivers() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        $cond = "";

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND (hhax.caregivers.employee_name LIKE '%".$search."%' OR hhax.caregivers.employee_id LIKE '%".$search."%')";
        }

        if(!empty($_GET['datefrom']) && !empty($_GET['dateto'])) {
            $datefrom = $_GET['datefrom']; $dateto = $_GET['dateto'];
        } else {
            $datefrom = date('Y-m-d'); $dateto = date('Y-m-d');
        }

        $agency_code = $this->session->userdata('agency');

        $totalRec = 0;
        $datas = [];
        $data = [];
        $i = 0;
        $sql = "SELECT hhax.caregivers.* FROM hhax.caregivers WHERE hhax.caregivers.agency_code = '$agency_code' $cond AND DATE(hhax.caregivers.date_in)>='$datefrom' AND DATE(hhax.caregivers.date_in)<='$dateto'";
        $Tsql = $sql;
        $sql .= " $sLimit";
        $res = $this->Comman_model->getCustomQueryData($sql);
        $Tres = $this->Comman_model->getCustomQueryData($Tsql);

        foreach ($res as $key => $row) {
            $param  = [];
            $employeeId = $row['employee_id'];
            $employeeClockId = $row['employee_clock_id'];            

            $param[0]   = $row['id'];
            $param[1]   = $row['employee_id'];
            $param[2]   = $row['employee_name'];
            $param[3]   = $row['date_in'];
            $param[4]   = $row['time_in'];
            $param[5]   = $row['time_out'];
            $param[6]   = $row['hours'];
            if(!empty($row['transaction_id'])) {
                $param[7]   = 'Transaction Id: '.$row['transaction_id'];    
            } else {
                $param[7]   = 'Not Submitted';
            }

            if(!empty($param)) {
                $data[$key] = $param;
            }
        }

        $recordsTotal = count($Tres);
        $recordsFiltered = count($Tres);
                
        $nex = 0;

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        $response['lblTotal'] = $lblTotal;
        $response['sql'] = $sql;
        print_r(json_encode($response));        
    }

    function employeesData2() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        $cond = "";

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND (emp.name LIKE '%".$search."%' OR emp.employee_id LIKE '%".$search."%')";
        }

        if(!empty($_GET['datefrom']) && !empty($_GET['dateto'])) {
            $datefrom = $_GET['datefrom']; $dateto = $_GET['dateto'];
        } else {
            $datefrom = date('Y-m-d'); $dateto = date('Y-m-d');
        }

        $agency_code = $this->session->userdata('agency');

        $totalRec = 0;
        $datas = [];
        $data = [];
        $i = 0;
        $sql = "SELECT ec1.rec_id as rec_id, ec1.date as d1, ec2.date as d2, ec1.employee_clock_id, ec1.employee_id, emp.name as emp_name FROM employee_clock ec1, employee_clock ec2, employee as emp WHERE ec1.rec_id = ec2.rec_id AND ec1.employee_id = emp.employee_id AND emp.Agency = '$agency_code' $cond AND DATE(ec1.date)>='$datefrom' AND DATE(ec1.date)<='$dateto' AND ec1.isIn = 1 AND ec2.isIn = 2 AND ec1.rec_id IS NOT NULL AND ec2.rec_id IS NOT NULL";
        $Tsql = $sql;
        $sql .= " $sLimit";
        $res = $this->Comman_model->getCustomQueryData($sql);
        $Tres = $this->Comman_model->getCustomQueryData($Tsql);

        foreach ($res as $key => $row) {
            $rec_id = $row['rec_id'];
            $param  = [];
            if(!empty($row['d2'])) {
                $employeeId = $row['employee_id'];
                $employeeClockId = $row['employee_clock_id'];
                $sqlem = "SELECT transaction_id FROM hhax.caregivers WHERE employee_id = '$employeeId' AND employee_clock_id = '$employeeClockId'";
                $rowem = $this->Comman_model->getCustomQueryData($sqlem, 'row');

                /******* Calculate Time In  ********/
                $temp = date('H:i',strtotime($row['d1']));
                $pairdate = date('Y-m-d',strtotime($row['d1']));
                $t = explode(":",$temp );
                $hrr1 = $t[0];
                $mnn1 = $t[1];

                $actual1 = $hrr1.':'.$mnn1; 
                $disp1 = $hrr1 + ($mnn1 / 60);
                $tot1 = quarter($disp1);
                $disp1 = quarter2($disp1);
                $disp1 = number_format($disp1,2);
                $tot1 = number_format($tot1,2);

                $t = explode(".",$disp1 );
                $hr1 = $t[0];
                $mn1 = $t[1];

                $fdate = date('Y-m-d',strtotime($row['d1']));
                $timedate = date('Y-m-d',strtotime($row['d1']));
                $idate = $fdate.' '.$hrr1.':'.$mnn1.':'.'00';
                $from_time=strtotime($idate);

                $timeInn = $hr1.':'.$mn1;

                /******* Calculate Time Out  ********/
                $temp = date('H:i',strtotime($row['d2']));
                $t = explode(":",$temp );
                $hrr2 = @$t[0];
                $mnn2 = @$t[1];
                $actual2 = $hrr2.':'.$mnn2; 
                $disp2 = $hrr2 + ($mnn2 / 60);
                $tot2 = quarter($disp2);
                $disp2 = quarter2($disp2);
                $disp2 = number_format($disp2,2);
                $tot2 = number_format($tot2,2);

                $t = explode(".",$disp2 );
                $hr2 = @$t[0];
                $mn2 = @$t[1];

                $fdate = date('Y-m-d',strtotime($row['d2']));
                $idate = $fdate.' '.$hrr2.':'.$mnn2.':'.'00';
                $to_time=strtotime($idate);

                $timeOut = $hr2.':'.$mn2;

                $total = number_format((($to_time - $from_time) / 60) / 60,2);

                $total2 =  $tot2 - $tot1;

                $param[0]   = $row['employee_clock_id'];
                $param[1]   = $row['employee_id'];
                $param[2]   = $row['emp_name'];
                $param[3]   = date('Y-m-d', strtotime($row['d1']));
                $param[4]   = $timeInn;
                $param[5]   = $timeOut;
                $param[6]   = abs($total2);     
                if(!empty($rowem['transaction_id'])) {
                    $param[7]   = 'Transaction Id: '.$rowem['transaction_id'];    
                } else {
                    $param[7]   = 'Not Generated';
                }                
            }

            if(!empty($param)) {
                $data[$key] = $param;
            }
        }

        $recordsTotal = count($Tres);
        $recordsFiltered = count($Tres);
                
        $nex = 0;

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        $response['lblTotal'] = $lblTotal;
        $response['sql'] = $sql;
        print_r(json_encode($response));        
    }

    function generateEmployeeEVVOld() {
        $action = @$_POST['action'];
        $datefrom = @$_POST['datefrom'];
        $dateto = @$_POST['dateto'];

        if(!empty($_POST['params']) && !empty($action) && $action=='selected') {
            $params = rtrim($_POST['params'], '|');
            $employeeClockIds = explode('|', $params);
            if(!empty($employeeClockIds)) {
                $updateCheck = false;
                foreach ($employeeClockIds as $key => $employeeClockId) {

                    $data['visits'] = [];

                    $param = [];
                    $param['providerTaxID'] = '999999999';
                    $param['office']['qualifier'] = 'NPI';
                    $param['office']['identifier'] = 'NP02';
                    $param['member']['qualifier'] = 'MedicaidID';
                    $param['member']['identifier'] = '1EG4TE5NL74';
                    $param['caregiver']['qualifier'] = 'ExternalID';
                    $param['caregiver']['identifier'] = '1001';
                    $param['payerID'] = 'LCDP';
                    $param['externalVisitID'] = '101';
                    $param['procedureCode'] = 'T019';
                    $param['timezone'] = 'US/Eastern';
                    $param['scheduleStartTime'] = '2020-09-23T12:16';
                    $param['scheduleEndTime'] = '2020-09-23T13:16';

                    $param['evv']['clockIn']['callDateTime'] = '2020-09-23T13:16:00';
                    $param['evv']['clockOut']['callDateTime'] = '2020-09-23T13:16:00';

                    $data['visits'] = [$param];

                    $response  = $this->getVisitsResponse($data);
                    $response  = json_decode($response, true);

                    //$response  = json_encode($data);
                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {

                        $sql = "SELECT employee_id FROM employee_clock WHERE employee_clock_id = '".$employeeClockId."'";
                        $row = $this->Comman_model->getCustomQueryData($sql, 'row');

                        $insertArray = [];
                        $insertArray['transaction_id'] = $response['transactionId'];
                        $insertArray['href'] = $response['links']['href'];
                        $insertArray['employee_id'] = $row['employee_id'];
                        $insertArray['employee_clock_id'] = $employeeClockId;
                        $this->Comman_model->insert('hhax.visits', $insertArray);
                        $updateCheck = true;                        
                    }
                }

                if($updateCheck) {
                    $this->session->set_flashdata('message','Visits hhax record has been created successfully.');
                    print_r(1);
                } else {
                    $this->session->set_flashdata('message','Oops! something went wrong. Please try again.');
                    print_r(0);
                }
            }
        }

        if(!empty($_POST['params']) && !empty($action) && $action=='All' && !empty($datefrom) && !empty($dateto) && $_POST['params']=='All') {

            $agency_code = $this->session->userdata('agency');

            $sql = "SELECT ec1.rec_id as rec_id, ec1.date as d1, ec2.date as d2, ec1.employee_clock_id, ec1.employee_id, emp.name as emp_name FROM employee_clock ec1, employee_clock ec2, employee as emp WHERE ec1.rec_id = ec2.rec_id AND ec1.employee_id = emp.employee_id AND emp.Agency = '$agency_code' AND DATE(ec1.date)>='$datefrom' AND DATE(ec1.date)<='$dateto' AND ec1.isIn = 1 AND ec2.isIn = 2 AND ec1.rec_id IS NOT NULL AND ec2.rec_id IS NOT NULL";
            $res = $this->Comman_model->getCustomQueryData($sql);

            if(!empty($res)) {
                $updateCheck = false;
                foreach ($res as $key => $row) {

                    $data['visits'] = [];

                    $param = [];
                    $param['providerTaxID'] = '999999999';
                    $param['office']['qualifier'] = 'NPI';
                    $param['office']['identifier'] = 'NP02';
                    $param['member']['qualifier'] = 'MedicaidID';
                    $param['member']['identifier'] = '1EG4TE5NL74';
                    $param['caregiver']['qualifier'] = 'ExternalID';
                    $param['caregiver']['identifier'] = '1001';
                    $param['payerID'] = 'LCDP';
                    $param['externalVisitID'] = '101';
                    $param['procedureCode'] = 'T019';
                    $param['timezone'] = 'US/Eastern';
                    $param['scheduleStartTime'] = '2020-09-23T12:16';
                    $param['scheduleEndTime'] = '2020-09-23T13:16';

                    $param['evv']['clockIn']['callDateTime'] = '2020-09-23T13:16:00';
                    $param['evv']['clockOut']['callDateTime'] = '2020-09-23T13:16:00';

                    $data['visits'] = [$param];

                    $response  = $this->getVisitsResponse($data);
                    $response  = json_decode($response, true);

                    //$response  = json_encode($data);
                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {
                        $insertArray = [];
                        $insertArray['transaction_id'] = $response['transactionId'];
                        $insertArray['href'] = $response['links']['href'];
                        $insertArray['employee_id'] = $row['employee_id'];
                        $insertArray['employee_clock_id'] = $row['employee_clock_id'];
                        $this->Comman_model->insert('hhax.visits', $insertArray);
                        $updateCheck = true;                        
                    }
                }

                if($updateCheck) {
                    $this->session->set_flashdata('message','Visits hhax records has been created successfully.');
                    print_r(1);
                } else {
                    $this->session->set_flashdata('message','Oops! something went wrong. Please try again.');
                    print_r(0);
                }
            }
        }
    }

    function generateEmployeeEVV() {
        $action = @$_POST['action'];
        $datefrom = @$_POST['datefrom'];
        $dateto = @$_POST['dateto'];

        if(!empty($_POST['params']) && !empty($action) && $action=='selected') {
            $params = rtrim($_POST['params'], '|');
            $visitIds = explode('|', $params);
            if(!empty($visitIds)) {
                $updateCheck = false;
                foreach ($visitIds as $key => $visitId) {

                    $data['visits'] = [];

                    $sql = "SELECT agency_code, patient_id, employee_id, rec_id, clock_in, clock_out FROM hhax.visits WHERE id = '$visitId'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    $agency_code = $row['agency_code'];
                    $patient_id = $row['patient_id'];
                    $employee_id = $row['employee_id'];
                    $rec_id = $row['rec_id'];
                    $clock_in = $row['clock_in'];
                    $clock_out = $row['clock_out'];

                    $asql = "SELECT agency_tax, hhax_office_qualifier FROM agency WHERE agency_code = '$agency_code'";
                    $arow = $this->Comman_model->getCustomQueryData($asql, 'row');
                    $agency_tax = $arow['agency_tax'];
                    $hhax_office_qualifier = $arow['hhax_office_qualifier'];

                    $psql = "SELECT hhax__member_qualifier, med_medicaidno, DistrictID_Ref FROM patient WHERE patient_id = '$patient_id'";
                    $prow = $this->Comman_model->getCustomQueryData($psql, 'row');
                    $hhax__member_qualifier = $prow['hhax__member_qualifier'];
                    $med_medicaidno = $prow['med_medicaidno'];
                    $DistrictID_Ref = $prow['DistrictID_Ref'];

                    $esql = "SELECT hhax_caregiver_ExternalID FROM employee WHERE employee_id = '$employee_id'";
                    $erow = $this->Comman_model->getCustomQueryData($esql, 'row');
                    $hhax_caregiver_ExternalID = $erow['hhax_caregiver_ExternalID'];

                    $dsql = "SELECT hhax_payer_initials, hhax_procedure_code FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref'";
                    $drow = $this->Comman_model->getCustomQueryData($dsql, 'row');
                    $hhax_payer_initials = $drow['hhax_payer_initials'];
                    $hhax_procedure_code = $drow['hhax_procedure_code'];

                    $tsql = "SELECT timezone FROM hhax_defaults WHERE id = '1'";
                    $trow = $this->Comman_model->getCustomQueryData($tsql, 'row');
                    $timezone = $trow['timezone'];

                    $param = [];
                    //$param['providerTaxID'] = '999999999';
                    $param['providerTaxID'] = $agency_tax;
                    //$param['office']['qualifier'] = 'NPI';
                    $param['office']['qualifier'] = $hhax_office_qualifier;
                    //$param['office']['identifier'] = 'NP02';
                    $param['office']['identifier'] = $agency_tax;
                    //$param['member']['qualifier'] = 'MedicaidID';
                    $param['member']['qualifier'] = $hhax__member_qualifier;
                    //$param['member']['identifier'] = '1EG4TE5NL74';
                    $param['member']['identifier'] = $med_medicaidno;
                    //$param['caregiver']['qualifier'] = 'ExternalID';
                    $param['caregiver']['qualifier'] = $hhax_caregiver_ExternalID;
                    //$param['caregiver']['identifier'] = '1001';
                    $param['caregiver']['identifier'] = $employee_id;
                    //$param['payerID'] = 'LCDP';
                    $param['payerID'] = $hhax_payer_initials;
                    //$param['externalVisitID'] = '101';
                    $param['externalVisitID'] = $rec_id;
                    //$param['procedureCode'] = 'T019';
                    $param['procedureCode'] = $hhax_procedure_code;                    
                    //$param['timezone'] = 'US/Eastern';
                    $param['timezone'] = $timezone;                    
                    //$param['scheduleStartTime'] = '2020-09-23T12:16';
                    $param['scheduleStartTime'] = date('Y-m-d\Th:i');
                    //$param['scheduleEndTime'] = '2020-09-23T13:16';
                    $param['scheduleEndTime'] = date('Y-m-d\Th:i');
                    //$param['evv']['clockIn']['callDateTime'] = '2020-09-23T13:16:00';
                    $param['evv']['clockIn']['callDateTime'] = date('Y-m-d\Th:i', strtotime($clock_in));
                    //$param['evv']['clockOut']['callDateTime'] = '2020-09-23T13:16:00';
                    $param['evv']['clockOut']['callDateTime'] = date('Y-m-d\Th:i', strtotime($clock_out));;

                    $data['visits'] = [$param];

                    $Jresponse  = $this->getVisitsResponse($data);
                    $response  = json_decode($Jresponse, true);

                    //$response  = json_encode($data);
                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {
                        
                        $where = [];
                        $where['id'] = $visitId;

                        $updateArray = [];
                        $updateArray['transaction_id'] = $response['transactionId'];
                        $updateArray['href'] = $response['links']['href'];
                        $updateArray['request'] = json_encode($data);
                        $updateArray['response'] = $Jresponse;

                        $this->Comman_model->update('hhax.visits', $where, $updateArray);
                        $updateCheck = true;                        
                    }
                }

                if($updateCheck) {
                    $this->session->set_flashdata('message','Visits hhax record has been created successfully.');
                    print_r(1);
                } else {
                    $this->session->set_flashdata('message','Oops! something went wrong. Please try again.');
                    print_r(0);
                }
            }
        }

        if(!empty($_POST['params']) && !empty($action) && $action=='All' && !empty($datefrom) && !empty($dateto) && $_POST['params']=='All') {

            $agency_code = $this->session->userdata('agency');

            $sql = "SELECT agency_code, patient_id, employee_id, rec_id, clock_in, clock_out FROM hhax.visits WHERE agency_code = '$agency_code' AND DATE(date_in)>='$datefrom' AND DATE(date_in)<='$dateto' AND transaction_id = '' ORDER BY id DESC LIMIT 100";
            $res = $this->Comman_model->getCustomQueryData($sql);

            if(!empty($res)) {
                $updateCheck = false;
                foreach ($res as $key => $row) {

                    $data['visits'] = [];

                    $agency_code = $row['agency_code'];
                    $patient_id = $row['patient_id'];
                    $employee_id = $row['employee_id'];
                    $rec_id = $row['rec_id'];
                    $clock_in = $row['clock_in'];
                    $clock_out = $row['clock_out'];

                    $asql = "SELECT agency_tax, hhax_office_qualifier FROM agency WHERE agency_code = '$agency_code'";
                    $arow = $this->Comman_model->getCustomQueryData($asql, 'row');
                    $agency_tax = $arow['agency_tax'];
                    $hhax_office_qualifier = $arow['hhax_office_qualifier'];

                    $psql = "SELECT hhax__member_qualifier, med_medicaidno, DistrictID_Ref FROM patient WHERE patient_id = '$patient_id'";
                    $prow = $this->Comman_model->getCustomQueryData($psql, 'row');
                    $hhax__member_qualifier = $prow['hhax__member_qualifier'];
                    $med_medicaidno = $prow['med_medicaidno'];
                    $DistrictID_Ref = $prow['DistrictID_Ref'];

                    $esql = "SELECT hhax_caregiver_ExternalID FROM employee WHERE employee_id = '$employee_id'";
                    $erow = $this->Comman_model->getCustomQueryData($esql, 'row');
                    $hhax_caregiver_ExternalID = $erow['hhax_caregiver_ExternalID'];

                    $dsql = "SELECT hhax_payer_initials, hhax_procedure_code FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref'";
                    $drow = $this->Comman_model->getCustomQueryData($dsql, 'row');
                    $hhax_payer_initials = $drow['hhax_payer_initials'];
                    $hhax_procedure_code = $drow['hhax_procedure_code'];

                    $tsql = "SELECT timezone FROM hhax_defaults WHERE id = '1'";
                    $trow = $this->Comman_model->getCustomQueryData($tsql, 'row');
                    $timezone = $trow['timezone'];

                    $param = [];
                    $param['providerTaxID'] = $agency_tax;
                    $param['office']['qualifier'] = $hhax_office_qualifier;
                    $param['office']['identifier'] = $agency_tax;
                    $param['member']['qualifier'] = $hhax__member_qualifier;
                    $param['member']['identifier'] = $med_medicaidno;
                    $param['caregiver']['qualifier'] = $hhax_caregiver_ExternalID;
                    $param['caregiver']['identifier'] = $employee_id;
                    $param['payerID'] = $hhax_payer_initials;
                    $param['externalVisitID'] = $rec_id;
                    $param['procedureCode'] = $hhax_procedure_code;                    
                    $param['timezone'] = $timezone;                    
                    $param['scheduleStartTime'] = date('Y-m-d\Th:i');
                    $param['scheduleEndTime'] = date('Y-m-d\Th:i');
                    $param['evv']['clockIn']['callDateTime'] = date('Y-m-d\Th:i', strtotime($clock_in));
                    $param['evv']['clockOut']['callDateTime'] = date('Y-m-d\Th:i', strtotime($clock_out));;
                    $data['visits'] = [$param];

                    $response  = $this->getVisitsResponse($data);
                    $response  = json_decode($response, true);

                    //$response  = json_encode($data);
                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {
                        $where = [];
                        $where['id'] = $row['id'];

                        $updateArray = [];
                        $updateArray['transaction_id'] = $response['transactionId'];
                        $updateArray['href'] = $response['links']['href'];

                        $this->Comman_model->update('hhax.visits', $where, $updateArray);
                        $updateCheck = true;                        
                    }
                }

                if($updateCheck) {
                    $this->session->set_flashdata('message','Visits hhax records has been created successfully.');
                    print_r(1);
                } else {
                    $this->session->set_flashdata('message','Oops! something went wrong. Please try again.');
                    print_r(0);
                }
            } else {
                $this->session->set_flashdata('error_message','No data found to submit.');
            }
        }
    }

    function generateEmployeeEVVCaregivers() {
        $action = @$_POST['action'];
        $datefrom = @$_POST['datefrom'];
        $dateto = @$_POST['dateto'];

        if(!empty($_POST['params']) && !empty($action) && $action=='selected') {
            $params = rtrim($_POST['params'], '|');
            $caregiversIds = explode('|', $params);
            if(!empty($caregiversIds)) {
                $updateCheck = false;
                foreach ($caregiversIds as $key => $caregiversId) {

                    $sql = "SELECT agency_code, patient_id, employee_id, rec_id, clock_in, clock_out, gender, dob, last_name, first_name, ssn, hired_date, state, zipcode FROM hhax.caregivers WHERE id = '$caregiversId'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');

                    $agency_code = $row['agency_code'];
                    $patient_id = $row['patient_id'];
                    $employee_id = $row['employee_id'];
                    $rec_id = $row['rec_id'];
                    $clock_in = $row['clock_in'];
                    $clock_out = $row['clock_out'];

                    $asql = "SELECT agency_tax, hhax_office_qualifier FROM agency WHERE agency_code = '$agency_code'";
                    $arow = $this->Comman_model->getCustomQueryData($asql, 'row');
                    $agency_tax = $arow['agency_tax'];
                    $hhax_office_qualifier = $arow['hhax_office_qualifier'];

                    $psql = "SELECT hhax__member_qualifier, med_medicaidno, DistrictID_Ref FROM patient WHERE patient_id = '$patient_id'";
                    $prow = $this->Comman_model->getCustomQueryData($psql, 'row');
                    $hhax__member_qualifier = $prow['hhax__member_qualifier'];
                    $med_medicaidno = $prow['med_medicaidno'];
                    $DistrictID_Ref = $prow['DistrictID_Ref'];

                    $esql = "SELECT hhax_caregiver_ExternalID FROM employee WHERE employee_id = '$employee_id'";
                    $erow = $this->Comman_model->getCustomQueryData($esql, 'row');
                    $hhax_caregiver_ExternalID = $erow['hhax_caregiver_ExternalID'];
                    
                    $ssn = $row['ssn'];
                    $BirthDate = $row['dob'];
                    $lastname = $row['last_name'];
                    $firstname = $row['first_name'];
                    if($row['gender']==0) {
                        $gender = 'Male';
                    }
                    if($row['gender']==1) {
                        $gender = 'Female';
                    }
                    if($row['gender']==2) {
                        $gender = 'Other';
                    }

                    $HiredDate = $row['hired_date'];
                    $EmployeeAddressState = $row['state'];
                    $EmployeeAddressPostalCode = $row['zipcode'];

                    $dsql = "SELECT hhax_payer_initials, hhax_procedure_code FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref'";
                    $drow = $this->Comman_model->getCustomQueryData($dsql, 'row');
                    $hhax_payer_initials = $drow['hhax_payer_initials'];
                    $hhax_procedure_code = $drow['hhax_procedure_code'];

                    $tsql = "SELECT timezone FROM hhax_defaults WHERE id = '1'";
                    $trow = $this->Comman_model->getCustomQueryData($tsql, 'row');
                    $timezone = $trow['timezone'];

                    $data = [];
                    $data['providerTaxID'] = $agency_tax;;
                    $data['qualifier'] = $hhax_office_qualifier;
                    $data['externalID'] = $rec_id;
                    $data['ssn'] = $ssn;
                    $data['dateOfBirth'] = $BirthDate;
                    $data['lastName'] = $lastname;
                    $data['firstName'] = $firstname;
                    $data['gender'] = $gender;
                    $data['usertype'] = 'Both';
                    $data['professionalLicenseNumber'] = '1234';
                    $data['hireDate'] = $HiredDate;
                    $data['state'] = $EmployeeAddressState;
                    $data['zipcode'] = $EmployeeAddressPostalCode;

                    $Jresponse  = $this->getCaregiverResponse($data);
                    $response  = json_decode($Jresponse, true);

                    //$response  = json_encode($data);
                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {

                        $where = [];
                        $where['id'] = $caregiversId;

                        $updateArray = [];
                        $updateArray['transaction_id'] = $response['transactionId'];
                        $updateArray['request'] = json_encode($data);
                        $updateArray['response'] = $Jresponse;

                        $this->Comman_model->update('hhax.caregivers', $where, $updateArray);
                        $updateCheck = true; 
                    }
                }

                if($updateCheck) {
                    $this->session->set_flashdata('message','Caregivers hhax record has been created successfully.');
                    print_r(1);
                } else {
                    $this->session->set_flashdata('message','Oops! something went wrong. Please try again.');
                    print_r(0);
                }
            }
        }

        if(!empty($_POST['params']) && !empty($action) && $action=='All' && !empty($datefrom) && !empty($dateto) && $_POST['params']=='All') {

            $agency_code = $this->session->userdata('agency');

            $sql = "SELECT agency_code, patient_id, employee_id, rec_id, clock_in, clock_out FROM hhax.caregivers WHERE agency_code = '$agency_code' AND DATE(date_in)>='$datefrom' AND DATE(date_in)<='$dateto' AND transaction_id = '' ORDER BY id DESC LIMIT 100";
            $res = $this->Comman_model->getCustomQueryData($sql);

            if(!empty($res)) {
                $updateCheck = false;
                foreach ($res as $key => $row) {

                    $agency_code = $row['agency_code'];
                    $patient_id = $row['patient_id'];
                    $employee_id = $row['employee_id'];
                    $rec_id = $row['rec_id'];
                    $clock_in = $row['clock_in'];
                    $clock_out = $row['clock_out'];

                    $asql = "SELECT agency_tax, hhax_office_qualifier FROM agency WHERE agency_code = '$agency_code'";
                    $arow = $this->Comman_model->getCustomQueryData($asql, 'row');
                    $agency_tax = $arow['agency_tax'];
                    $hhax_office_qualifier = $arow['hhax_office_qualifier'];

                    $psql = "SELECT hhax__member_qualifier, med_medicaidno, DistrictID_Ref FROM patient WHERE patient_id = '$patient_id'";
                    $prow = $this->Comman_model->getCustomQueryData($psql, 'row');
                    $hhax__member_qualifier = $prow['hhax__member_qualifier'];
                    $med_medicaidno = $prow['med_medicaidno'];
                    $DistrictID_Ref = $prow['DistrictID_Ref'];

                    $esql = "SELECT hhax_caregiver_ExternalID, ssn, BirthDate, lastname, firstname, gender, HiredDate, EmployeeAddressState, EmployeeAddressPostalCode FROM employee WHERE employee_id = '$employee_id'";
                    $erow = $this->Comman_model->getCustomQueryData($esql, 'row');
                    $hhax_caregiver_ExternalID = $erow['hhax_caregiver_ExternalID'];
                    $ssn = $erow['ssn'];
                    $BirthDate = $erow['BirthDate'];
                    $lastname = $erow['lastname'];
                    $firstname = $erow['firstname'];
                    if($erow['gender']==0) {
                        $gender = 'Male';
                    }
                    if($erow['gender']==1) {
                        $gender = 'Female';
                    }
                    if($erow['gender']==2) {
                        $gender = 'Other';
                    }
                    $HiredDate = $erow['HiredDate'];
                    $EmployeeAddressState = $erow['EmployeeAddressState'];
                    $EmployeeAddressPostalCode = $erow['EmployeeAddressPostalCode'];

                    $dsql = "SELECT hhax_payer_initials, hhax_procedure_code FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref'";
                    $drow = $this->Comman_model->getCustomQueryData($dsql, 'row');
                    $hhax_payer_initials = $drow['hhax_payer_initials'];
                    $hhax_procedure_code = $drow['hhax_procedure_code'];

                    $tsql = "SELECT timezone FROM hhax_defaults WHERE id = '1'";
                    $trow = $this->Comman_model->getCustomQueryData($tsql, 'row');
                    $timezone = $trow['timezone'];

                    $data = [];
                    $data['providerTaxID'] = $agency_tax;;
                    $data['qualifier'] = $hhax_office_qualifier;
                    $data['externalID'] = $rec_id;
                    $data['ssn'] = $ssn;
                    $data['dateOfBirth'] = $BirthDate;
                    $data['lastName'] = $lastname;
                    $data['firstName'] = $firstname;
                    $data['gender'] = $gender;
                    $data['usertype'] = 'Both';
                    $data['professionalLicenseNumber'] = '1234';
                    $data['hireDate'] = $HiredDate;
                    $data['state'] = $EmployeeAddressState;
                    $data['zipcode'] = $EmployeeAddressPostalCode;

                    $Jresponse  = $this->getCaregiverResponse($data);
                    $response  = json_decode($Jresponse, true);

                    //$response  = json_encode($data);
                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {
                        $where = [];
                        $where['id'] = $caregiversId;

                        $updateArray = [];
                        $updateArray['transaction_id'] = $response['transactionId'];
                        $updateArray['request'] = json_encode($data);
                        $updateArray['response'] = $Jresponse;

                        $this->Comman_model->update('hhax.caregivers', $where, $updateArray);
                        $updateCheck = true; 
                    }
                }

                if($updateCheck) {
                    $this->session->set_flashdata('message','Caregivers hhax records has been created successfully.');
                    print_r(1);
                } else {
                    $this->session->set_flashdata('message','Oops! something went wrong. Please try again.');
                    print_r(0);
                }
            }
        }
    }

    function generateHhax() {

        $datefrom = $_POST['datefrom'];
        $dateto = $_POST['dateto'];

        if(!empty($datefrom) && !empty($dateto)) {
            $agency_code = $this->session->userdata('agency');

            $sql = "SELECT ec1.rec_id as rec_id, ec1.date as d1, ec2.date as d2, ec1.employee_clock_id, ec1.employee_id, ec1.patient_id, emp.name as emp_name FROM employee_clock ec1, employee_clock ec2, employee as emp WHERE ec1.rec_id = ec2.rec_id AND ec1.employee_id = emp.employee_id AND emp.Agency = '$agency_code' $cond AND DATE(ec1.date)>='$datefrom' AND DATE(ec1.date)<='$dateto' AND ec1.isIn = 1 AND ec2.isIn = 2 AND ec1.rec_id IS NOT NULL AND ec2.rec_id IS NOT NULL";
            $res = $this->Comman_model->getCustomQueryData($sql);
            $updateCheck = false;
            foreach ($res as $key => $row) {
                $rec_id = $row['rec_id'];
                $param  = [];
                if(!empty($row['d2'])) {
                    $employeeId = $row['employee_id'];
                    $employeeClockId = $row['employee_clock_id'];                

                    /******* Calculate Time In  ********/
                    $temp = date('H:i',strtotime($row['d1']));
                    $pairdate = date('Y-m-d',strtotime($row['d1']));
                    $t = explode(":",$temp );
                    $hrr1 = $t[0];
                    $mnn1 = $t[1];

                    $actual1 = $hrr1.':'.$mnn1; 
                    $disp1 = $hrr1 + ($mnn1 / 60);
                    $tot1 = quarter($disp1);
                    $disp1 = quarter2($disp1);
                    $disp1 = number_format($disp1,2);
                    $tot1 = number_format($tot1,2);

                    $t = explode(".",$disp1 );
                    $hr1 = $t[0];
                    $mn1 = $t[1];

                    $fdate = date('Y-m-d',strtotime($row['d1']));
                    $timedate = date('Y-m-d',strtotime($row['d1']));
                    $idate = $fdate.' '.$hrr1.':'.$mnn1.':'.'00';
                    $from_time=strtotime($idate);

                    $timeInn = $hr1.':'.$mn1;

                    /******* Calculate Time Out  ********/
                    $temp = date('H:i',strtotime($row['d2']));
                    $t = explode(":",$temp );
                    $hrr2 = @$t[0];
                    $mnn2 = @$t[1];
                    $actual2 = $hrr2.':'.$mnn2; 
                    $disp2 = $hrr2 + ($mnn2 / 60);
                    $tot2 = quarter($disp2);
                    $disp2 = quarter2($disp2);
                    $disp2 = number_format($disp2,2);
                    $tot2 = number_format($tot2,2);

                    $t = explode(".",$disp2 );
                    $hr2 = @$t[0];
                    $mn2 = @$t[1];

                    $fdate = date('Y-m-d',strtotime($row['d2']));
                    $idate = $fdate.' '.$hrr2.':'.$mnn2.':'.'00';
                    $to_time=strtotime($idate);

                    $timeOut = $hr2.':'.$mn2;

                    $total = number_format((($to_time - $from_time) / 60) / 60,2);

                    $total2 =  $tot2 - $tot1;

                    $param['employee_clock_id']   = $row['employee_clock_id'];
                    $param['rec_id']   = $row['rec_id'];
                    $param['employee_id']   = $row['employee_id'];
                    $param['patient_id']   = $row['patient_id'];
                    $param['employee_name']   = $row['emp_name'];
                    $param['date_in']   = date('Y-m-d', strtotime($row['d1']));
                    $param['time_in']   = $timeInn;
                    $param['time_out']   = $timeOut;
                    $param['hours']   = abs($total2);    
                    $param['clock_in']   = $row['d1'];
                    $param['clock_out']   = $row['d2'];
                    $param['agency_code']   = $agency_code;    

                    $sqlem = "SELECT transaction_id, id FROM hhax.visits WHERE employee_id = '$employeeId' AND employee_clock_id = '$employeeClockId'";
                    $rowem = $this->Comman_model->getCustomQueryData($sqlem, 'row');

                    if(!empty($rowem['id']) && empty($rowem['transaction_id'])) {
                        $visitsid = $rowem['id'];

                        $where = [];
                        $where['id'] = $visitsid;
                        $this->Comman_model->update('hhax.visits', $where, $param);

                        $updateCheck = true;
                    } else {
                        if(empty($rowem['transaction_id'])) {
                            $this->Comman_model->insert('hhax.visits', $param);    
                            $updateCheck = true;
                        }
                    }
                }
            }
            if($updateCheck) {
                $this->session->set_flashdata('message','Visits hhax records has been generated successfully.');    
            }        
        } else {
            $this->session->set_flashdata('error_message','Please select the date.');    
        }
    }

    function generateHhaxCaregivers() {

        $datefrom = $_POST['datefrom'];
        $dateto = $_POST['dateto'];

        if(!empty($datefrom) && !empty($dateto)) {
            $agency_code = $this->session->userdata('agency');

            $sql = "SELECT ec1.rec_id as rec_id, ec1.date as d1, ec2.date as d2, ec1.employee_clock_id, ec1.employee_id, ec1.patient_id, emp.name as emp_name, emp.HiredDate, emp.BirthDate, emp.lastname, emp.firstname, emp.gender, emp.EmployeeAddressPostalCode, emp.EmployeeAddressState, emp.ssn FROM employee_clock ec1, employee_clock ec2, employee as emp WHERE ec1.rec_id = ec2.rec_id AND ec1.employee_id = emp.employee_id AND emp.Agency = '$agency_code' $cond AND DATE(ec1.date)>='$datefrom' AND DATE(ec1.date)<='$dateto' AND ec1.isIn = 1 AND ec2.isIn = 2 AND ec1.rec_id IS NOT NULL AND ec2.rec_id IS NOT NULL";
            $res = $this->Comman_model->getCustomQueryData($sql);
            $updateCheck = false;
            foreach ($res as $key => $row) {
                $rec_id = $row['rec_id'];
                $param  = [];
                if(!empty($row['d2'])) {
                    $employeeId = $row['employee_id'];
                    $employeeClockId = $row['employee_clock_id'];                

                    /******* Calculate Time In  ********/
                    $temp = date('H:i',strtotime($row['d1']));
                    $pairdate = date('Y-m-d',strtotime($row['d1']));
                    $t = explode(":",$temp );
                    $hrr1 = $t[0];
                    $mnn1 = $t[1];

                    $actual1 = $hrr1.':'.$mnn1; 
                    $disp1 = $hrr1 + ($mnn1 / 60);
                    $tot1 = quarter($disp1);
                    $disp1 = quarter2($disp1);
                    $disp1 = number_format($disp1,2);
                    $tot1 = number_format($tot1,2);

                    $t = explode(".",$disp1 );
                    $hr1 = $t[0];
                    $mn1 = $t[1];

                    $fdate = date('Y-m-d',strtotime($row['d1']));
                    $timedate = date('Y-m-d',strtotime($row['d1']));
                    $idate = $fdate.' '.$hrr1.':'.$mnn1.':'.'00';
                    $from_time=strtotime($idate);

                    $timeInn = $hr1.':'.$mn1;

                    /******* Calculate Time Out  ********/
                    $temp = date('H:i',strtotime($row['d2']));
                    $t = explode(":",$temp );
                    $hrr2 = @$t[0];
                    $mnn2 = @$t[1];
                    $actual2 = $hrr2.':'.$mnn2; 
                    $disp2 = $hrr2 + ($mnn2 / 60);
                    $tot2 = quarter($disp2);
                    $disp2 = quarter2($disp2);
                    $disp2 = number_format($disp2,2);
                    $tot2 = number_format($tot2,2);

                    $t = explode(".",$disp2 );
                    $hr2 = @$t[0];
                    $mn2 = @$t[1];

                    $fdate = date('Y-m-d',strtotime($row['d2']));
                    $idate = $fdate.' '.$hrr2.':'.$mnn2.':'.'00';
                    $to_time=strtotime($idate);

                    $timeOut = $hr2.':'.$mn2;

                    $total = number_format((($to_time - $from_time) / 60) / 60,2);

                    $total2 =  $tot2 - $tot1;

                    $param['employee_clock_id']   = $row['employee_clock_id'];
                    $param['rec_id']   = $row['rec_id'];
                    $param['employee_id']   = $row['employee_id'];
                    $param['patient_id']   = $row['patient_id'];
                    $param['employee_name']   = $row['emp_name'];
                    $param['date_in']   = date('Y-m-d', strtotime($row['d1']));
                    $param['time_in']   = $timeInn;
                    $param['time_out']   = $timeOut;
                    $param['hours']   = abs($total2);    
                    $param['clock_in']   = $row['d1'];
                    $param['clock_out']   = $row['d2'];
                    $param['agency_code']   = $agency_code; 
                    $param['agency_code']   = $agency_code; 
                    $param['hired_date']   = $row['HiredDate']; 
                    $param['dob']   = $row['BirthDate'];
                    $param['last_name']   = $row['lastname'];
                    $param['first_name']   = $row['firstname'];
                    $param['gender']   = $row['gender'];
                    $param['state']   = $row['EmployeeAddressState'];
                    $param['zipcode']   = $row['EmployeeAddressPostalCode'];
                    $param['ssn']   = $row['ssn'];

                    $sqlem = "SELECT transaction_id, id FROM hhax.caregivers WHERE employee_id = '$employeeId' AND employee_clock_id = '$employeeClockId'";
                    $rowem = $this->Comman_model->getCustomQueryData($sqlem, 'row');

                    if(!empty($rowem['id']) && empty($rowem['transaction_id'])) {
                        $visitsid = $rowem['id'];

                        $where = [];
                        $where['id'] = $visitsid;
                        $this->Comman_model->update('hhax.caregivers', $where, $param);

                        $updateCheck = true;
                    } else {
                        if(empty($rowem['transaction_id'])) {
                            $this->Comman_model->insert('hhax.caregivers', $param);    
                            $updateCheck = true;
                        }
                    }
                }
            }
            if($updateCheck) {
                $this->session->set_flashdata('message','Caregivers hhax records has been generated successfully.');    
            }        
        } else {
            $this->session->set_flashdata('error_message','Please select the date.');    
        }
    }

    public function employees() {
        if (isset($_SESSION['name'])) {

            $data = [];
            if(!empty($_GET['datefrom'])) {
                $datefrom = $_GET['datefrom'];
                $data['datefrom'] = $_GET['datefrom'];
            } else {
                $datefrom = date('Y-m-d');
                $data['datefrom'] = date('Y-m-d');
            }

            if(!empty($_GET['dateto'])) {
                $dateto = $_GET['dateto'];
                $data['dateto'] = $_GET['dateto'];
            } else {
                $dateto = date('Y-m-d');
                $data['dateto'] = date('Y-m-d');
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('evv/employee-view.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function employeesCaregiver() {
        if (isset($_SESSION['name'])) {

            $data = [];
            if(!empty($_GET['datefrom'])) {
                $data['datefrom'] = $_GET['datefrom'];
            } else {
                $data['datefrom'] = date('Y-m-d');
            }

            if(!empty($_GET['dateto'])) {
                $data['dateto'] = $_GET['dateto'];
            } else {
                $data['dateto'] = date('Y-m-d');
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('evv/employee-caregiver.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function index() {
        if (isset($_SESSION['name'])) {
            $applicantData  = "";
            if(!empty($_POST['search']) && $_POST['search']=='Search') {

                if(!empty($_POST['providerTaxID']) && !empty($_POST['qualifier']) && !empty($_POST['externalID']) && !empty($_POST['ssn']) && !empty($_POST['dateOfBirth']) && !empty($_POST['lastName']) && !empty($_POST['firstName']) && !empty($_POST['gender']) && !empty($_POST['usertype']) && !empty($_POST['professionalLicenseNumber']) && !empty($_POST['hireDate']) && !empty($_POST['zipcode']) && !empty($_POST['state'])) {

                    $data = [];
                    $data['providerTaxID'] = $_POST['providerTaxID'];
                    $data['qualifier'] = $_POST['qualifier'];
                    $data['externalID'] = $_POST['externalID'];
                    $data['ssn'] = $_POST['ssn'];
                    $data['dateOfBirth'] = $_POST['dateOfBirth'];
                    $data['lastName'] = $_POST['lastName'];
                    $data['firstName'] = $_POST['firstName'];
                    $data['gender'] = $_POST['gender'];
                    $data['usertype'] = $_POST['usertype'];
                    $data['professionalLicenseNumber'] = $_POST['professionalLicenseNumber'];
                    $data['hireDate'] = $_POST['hireDate'];
                    $data['state'] = $_POST['state'];                    
                    $data['zipcode'] = $_POST['zipcode'];

                    $response  = $this->getCaregiverResponse($data);
                    $response  = json_decode($response, true);

                    if(!empty($response['transactionId'])) {
                        $insertArray = [];
                        $insertArray['transactionId'] = $response['transactionId'];
                        $this->Comman_model->insert('hhax_caregivers', $insertArray);

                        $this->session->set_flashdata('message','Caregivers hhax record has been created successfully.');
                        redirect('evv');
                    }
                } else {
                    $this->session->set_flashdata('error_message','Please fill all the required fields');
                    redirect('evv');
                }
            }

            $sql = "SELECT * FROM hhax_caregivers ORDER BY id DESC";
            $res = $this->Comman_model->getCustomQueryData($sql);
            $data['applicantData']      = $res;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('evv/view.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function visits() {
        if (isset($_SESSION['name'])) {
            $applicantData  = "";
            if(!empty($_POST['search']) && $_POST['search']=='Search') {

                if(!empty($_POST['providerTaxID']) && !empty($_POST['office_qualifier']) && !empty($_POST['office_identifier']) && !empty($_POST['member_qualifier']) && !empty($_POST['member_identifier']) && !empty($_POST['caregiver_qualifier']) && !empty($_POST['caregiver_identifier']) && !empty($_POST['payerID']) && !empty($_POST['externalVisitID']) && !empty($_POST['procedureCode']) && !empty($_POST['timezone']) && !empty($_POST['scheduleStartTime']) && !empty($_POST['scheduleEndTime'])) {
                    
                    $data['visits'] = [];

                    $param = [];
                    $param['providerTaxID'] = $_POST['providerTaxID'];
                    $param['office']['qualifier'] = $_POST['office_qualifier'];
                    $param['office']['identifier'] = $_POST['office_identifier'];
                    $param['member']['qualifier'] = $_POST['member_qualifier'];
                    $param['member']['identifier'] = $_POST['member_identifier'];
                    $param['caregiver']['qualifier'] = $_POST['caregiver_qualifier'];
                    $param['caregiver']['identifier'] = $_POST['caregiver_identifier'];
                    $param['payerID'] = $_POST['payerID'];
                    $param['externalVisitID'] = $_POST['externalVisitID'];
                    $param['procedureCode'] = $_POST['procedureCode'];
                    $param['timezone'] = $_POST['timezone'];
                    $param['scheduleStartTime'] = $_POST['scheduleStartTime'];                    
                    $param['scheduleEndTime'] = $_POST['scheduleEndTime'];   

                    $data['visits'] = [$param];

                    //echo json_encode($data);
                    //echo '<br>';

                    $response  = $this->getVisitsResponse($data);
                    $response  = json_decode($response, true);

                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {
                        $insertArray = [];
                        $insertArray['transactionId'] = $response['transactionId'];
                        $insertArray['href'] = $response['links']['href'];
                        $this->Comman_model->insert('hhax_visits', $insertArray);

                        $this->session->set_flashdata('message','Visits hhax record has been created successfully.');
                        redirect('evv/visits');
                    }
                } else {
                    $this->session->set_flashdata('error_message','Please fill all the required fields');
                    redirect('evv/visits');
                }
            }

            $sql = "SELECT * FROM hhax_visits ORDER BY id DESC";
            $res = $this->Comman_model->getCustomQueryData($sql);
            $data['applicantData']      = $res;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('evv/visits.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function visitUpdate() {
        if (isset($_SESSION['name'])) {
            $applicantData  = "";

            if(!empty($_POST['search']) && $_POST['search']=='Search') {
                if(!empty($_POST['evvmsid'])) {
                    
                    $data['visits'] = [];

                    $param = [];
                    $param['providerTaxID'] = $_POST['providerTaxID'];
                    $param['office']['qualifier'] = $_POST['office_qualifier'];
                    $param['office']['identifier'] = $_POST['office_identifier'];
                    $param['member']['qualifier'] = $_POST['member_qualifier'];
                    $param['member']['identifier'] = $_POST['member_identifier'];
                    $param['caregiver']['qualifier'] = $_POST['caregiver_qualifier'];
                    $param['caregiver']['identifier'] = $_POST['caregiver_identifier'];
                    $param['payerID'] = $_POST['payerID'];
                    $param['externalVisitID'] = $_POST['externalVisitID'];
                    $param['procedureCode'] = $_POST['procedureCode'];
                    $param['timezone'] = $_POST['timezone'];
                    $param['scheduleStartTime'] = $_POST['scheduleStartTime'];                    
                    $param['scheduleEndTime'] = $_POST['scheduleEndTime'];   

                    $data['visits'] = [$param];

                    //echo json_encode($data);
                    //echo '<br>';

                    $response  = $this->getVisitsResponse($data);
                    $response  = json_decode($response, true);

                    //print_r($response);die;

                    if(!empty($response['transactionId'])) {
                        $insertArray = [];
                        $insertArray['transactionId'] = $response['transactionId'];
                        $insertArray['href'] = $response['links']['href'];
                        $this->Comman_model->insert('hhax_visits', $insertArray);

                        $this->session->set_flashdata('message','Visits hhax record has been created successfully.');
                        redirect('evv/visits');
                    }
                } else {
                    $this->session->set_flashdata('error_message','Please fill all the required fields');
                    redirect('evv/visits');
                }
            }

            $sql = "SELECT * FROM hhax_visits ORDER BY id DESC";
            $res = $this->Comman_model->getCustomQueryData($sql);
            $data['applicantData']      = $res;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('evv/visits.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function getAccessToken() {
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://implementation.hhaexchange.com/identity/connect/token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'client_id=d11d21b0-b0f5-49ff-b582-d1422eda1617&client_secret=4aba6594-e89a-40fb-a6d0-e9d5fc621cde&scope=write%3Aaggregator&grant_type=client_credentials',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
          ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true);
        return $response['access_token'];
    }
    
    public function getCaregiverResponse($data) {

        $accessToken = $this->getAccessToken();

        $data = json_encode($data);

        //print_r($data);die;

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://implementation.hhaexchange.com/api/v1/caregivers',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => json_encode($data),
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$accessToken
          ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function getVisitsResponse($data) {
        $accessToken = $this->getAccessToken();
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://implementation.hhaexchange.com/api/v1/visits',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => json_encode($data),
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$accessToken
          ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function generateLink() {
        /******** LINK TO GENRATE CODE FOR GETTING ACCESS AND REFRESH TOKEN ********/
        //echo '<a href="https://accounts.google.com/o/oauth2/v2/auth?access_type=offline&scope=https://www.googleapis.com/auth/spreadsheets&response_type=code&redirect_uri=https://portal.1017.solutions/training9/Admin/customer_panel/gsheet/response&client_id=288831144002-mb7frb83f12q1rcdb00e976s0s20vd3i.apps.googleusercontent.com">Click To Generate Code</a>';

        redirect("https://accounts.google.com/o/oauth2/v2/auth?access_type=offline&scope=https://www.googleapis.com/auth/spreadsheets&response_type=code&redirect_uri=https://portal.1017.solutions/training9/Admin/customer_panel/gsheet/response&client_id=288831144002-mb7frb83f12q1rcdb00e976s0s20vd3i.apps.googleusercontent.com");
    }

    function response() {
        $code = $_REQUEST['code'];
        if(!empty($code)) {
            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://oauth2.googleapis.com/token',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS => array('client_id' => '288831144002-mb7frb83f12q1rcdb00e976s0s20vd3i.apps.googleusercontent.com','client_secret' => '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','code' => $code,'grant_type' => 'authorization_code','redirect_uri' => 'https://portal.1017.solutions/training9/Admin/customer_panel/gsheet/response'),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            print_r($response);die;
        }
    }
} 