<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class FileExport extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model','comman');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->library('user_agent');
    }


    public function upload() {
      $message = 'err'; 
      if( $_FILES['file']['name'] != "" ) {
        $img_data   =   [];
        $img_data['path']   =   'image/uploads2';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $dataArray = [];
            $filename = $img['url'];
            $fileurl = base_url('image/uploads2').'/'.$filename;
            //$data = $this->db->empty_table('temp_clock');
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            while(!feof($myfile)) {
                $x = fgets($myfile);
                $cntr++;
                $strtemp = explode(',',$x);
                if ($cntr > 1 && $x != '') {
                    $dataArray[$cntr]['patient_id'] = $strtemp[0];
                    $dataArray[$cntr]['lastVisit']  = $strtemp[3];
                    $dataArray[$cntr]['nextVisit']  = $strtemp[4];
                    $dataArray[$cntr]['Agency']  = $strtemp[5];
                    $dataArray[$cntr]['comments']   = $strtemp[7];
                }    
            }

            //print_r($dataArray);die;
            fclose($myfile);

            $patientData = [];
            if(!empty($dataArray)) {
                $z = 0;
                foreach ($dataArray as $key => $row) {
                    /*$patient_id = date('Y-m-d', strtotime($row['patient_id']));
                    $where = [];
                    $where['patient_id'] = $patient_id;
                    $numRows = $this->comman->countrow('patient', $where);
                    if($numRows==1) {
                        $patientData = $this->comman->get_row('patient', $where);
                        $where = [];
                        $where['patient_id'] = $patientData['patient_id'];
                        

                        $lastVisit = $nextVisit = '';
                        if(!empty($row['lastVisit'])) {
                            $lastVisit = date('Y-m-d', strtotime($row['lastVisit']));    
                        }
                        if(!empty($row['nextVisit'])) {
                            $nextVisit = date('Y-m-d', strtotime($row['nextVisit']));
                        }

                        $dataArray1 = [];
                        $dataArray1['VisitDoneDate']    = $lastVisit;
                        //$dataArray1['NextVisitDate']    = $nextVisit;
                        $dataArray1['VisitationNotes']  = $row['comments'];

                        $this->comman->update('tblpatientsvisits', $where, $dataArray1);
                        $z++;
                    }*/


                    $lastVisit = $nextVisit = '';
                    if(!empty($row['lastVisit'])) {
                      $lastVisit = date('Y-m-d', strtotime($row['lastVisit']));    
                    }
                    if(!empty($row['nextVisit'])) {
                      $nextVisit = date('Y-m-d', strtotime($row['nextVisit']));
                    }

                    $dataArray1 = [];
                    $dataArray1['VisitDoneDate']    = $lastVisit;
                    $dataArray1['patient_id']    = $row['patient_id'];
                    $dataArray1['NextVisitDate']    = $nextVisit;
                    $dataArray1['Agency']    = $row['Agency'];
                    $dataArray1['VisitationNotes']  = $row['comments'];

                    $this->comman->insert('tblpatientsvisits', $dataArray1);

                    $z++;

                }    
                $message = $z.' records has been added successfully.';
            }
          }
      } 
      echo $message;
    }
    
    public function index() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'File Export';

            if(!empty($_GET['getexcel']) && $_GET['getexcel']=='Excel') {
                $fromDate = $toDate = $nextVisitDate = '';
                if(!empty($_GET['fromDate']) && $_GET['fromDate']!='') {
                    $fromDate = date('Y-m-d', strtotime($_GET['fromDate']));
                }
                if(!empty($_GET['toDate']) && $_GET['toDate']!='') {
                    $toDate = date('Y-m-d', strtotime($_GET['toDate']));
                }

                if(!empty($_GET['nextVisitDate']) && $_GET['nextVisitDate']!='') {
                    $nextVisitDate = date('Y-m-d', strtotime($_GET['nextVisitDate']));
                }
                
                if(!empty($nextVisitDate)) {

                    $checkView = false;

                    $result = $this->comman->getpatientVisitData($fromDate, $toDate, $nextVisitDate); 

                    // file name for download
                    $filename = "PATIENT_VISITS_" . date('Ymd') . ".xls";

                    header("Content-Disposition: attachment; filename=\"$filename\"");
                    header("Content-Type: application/vnd.ms-excel");

                    $flag = false;
                    $row2 = 0;
                    $arry = array(' ',' ',' ',' ');
                    foreach ($result as $key => $row) {
                        if(!$flag) {
                            // display field/column names as first row
                            array_walk($row, array($this,'cleanData'));

                            echo implode("\t",$arry) . "\r\n";
                            echo implode("\t", array_keys($row)) . "\r\n";
                            $flag = true;
                        }
                        array_walk($row, array($this, 'cleanData'));
                        $x = 1;
                        echo implode("\t", array_values($row)) . "\r\n";
                    }
                }

            }

            if($checkView) {

                /*
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/view.php', $data);
                //$this->load->view('file-export/view-ssn.php', $data);
                $this->load->view('common/footer-view.php');    
                */

                $this->load->view('common/header-new.php');
                $this->load->view('common/sidebar-new.php', $data);
                $this->load->view('file-export/view-new.php', $data);
            }
        } else {
            redirect($this->agent->referrer());
        }
    }  

    public function cleanData(&$str)  {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    public function uploadfiles($img_data=[]){
      $folder =   $img_data['path'];
      $file = $img_data['file_name'];
      $allowed_types =    $img_data['allowed_type'];
      $older =    $img_data['old_file'];
      $width  =   $img_data['width'];
      $height =   $img_data['height'];
      $quality    =   $img_data['quality'];

      if(!empty($_FILES[$file]) && $_FILES[$file]['size'] > 0){          
          if(!empty($older)){
              $postimgurl = FCPATH."$folder/". $older;
              unlink($postimgurl);
          }
          $config =   [];
          $config['upload_path']     = './'."$folder".'/'; 
          $config['allowed_types']   = $allowed_types;
          $new_name = $file.time().rand(0000,9999);
          $config['file_name'] = $new_name;
          $this->load->library('upload', $config);
          $this->upload->initialize($config);
          if($this->upload->do_upload($file)){
              $postimg =$this->upload->data()['file_name'] ;
              $postimgurl = base_url()."$folder/". $postimg;
              chmod($this->upload->data()['full_path'],0777);
              if($img_data['image_compress']){
                  $config =   [];
                  $config['image_library'] = 'gd2';  
                  $config['source_image'] = './'."$folder".'/'.$postimg;  
                  $config['create_thumb'] = FALSE;  
                  $config['maintain_ratio'] = FALSE;  

                  $config['quality'] = $quality;  
                  if(!empty($width)){
                      $config['width'] = $width;  
                  }
                  if(!empty($height)){
                      $config['height'] = $height;  
                  }
                  
                  $config['new_image'] = './'."$folder".'/'.$postimg;  
                  
                  $this->load->library('image_lib', $config);  
                  $this->image_lib->initialize($config);
                  if($this->image_lib->resize()){
                      $this->image_lib->clear();
                      $data['url'] =  $postimg;
                      $data['status'] = 1;
                  }else{
                      $data['status'] = 0;
                      $data['msg']=$this->upload->display_errors();
                  }  
              }else{
                  $data['url'] =  $postimg;
                  $data['status'] = 1;
              }
          }else{
              $data['status']=0;
              $data['msg']=$this->upload->display_errors();
          }
          return $data;
      }
    }


    public function updateSSN() {
      $message = 'err'; 
      if( $_FILES['file']['name'] != "" ) {
        $img_data   =   [];
        $img_data['path']   =   'image/uploads2';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $filename = $img['url'];
            $fileurl = base_url('image/uploads2').'/'.$filename;
            //$data = $this->db->empty_table('temp_clock');
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            $z = 0;
            while(!feof($myfile)) {
                $x = fgets($myfile);
                $cntr++;
                $strtemp = explode(',',$x);                
                if ($cntr > 1 && $x != '') {
                    if(!empty($strtemp[0])) {

                        $bdate = date('Y-m-d', strtotime($strtemp[3]));

                        /*$where = [];
                        $where['Agency'] = $strtemp[0];
                        $where['ADP'] = $strtemp[1];
                        $where['BirthDate'] = date('Y-m-d', strtotime($strtemp[3]));
                        $employeeData = $this->comman->get_row('employee', $where);*/

                        //$sql = "SELECT * FROM employee WHERE Agency = '".$strtemp[0]."' AND ADP='".$strtemp[1]."' AND BirthDate='".$bdate."' AND ssn IS NULL";
                        $sql = "SELECT * FROM employee WHERE Agency = '".$strtemp[0]."' AND ADP='".$strtemp[1]."' AND BirthDate='".$bdate."'";
                        $employeeData = $this->comman->getCustomQueryData($sql, 'row');

                        if(!empty($employeeData)) {
                            $where = [];
                            $where['employee_id'] = $employeeData['employee_id'];

                            $dataArray1 = [];
                            $dataArray1['ssn'] = $strtemp[2];

                            $this->comman->update('employee', $where, $dataArray1);
                            $z++;    
                        }
                    }                    
                }    
            }
            $message = $z.' records has been added successfully.';
            fclose($myfile);
          }
      } 
      echo $message;
    }

    public function deviceUpload() {
        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php', $data);
        $this->load->view('file-export/device.php', $data);
        $this->load->view('common/footer-view.php');    
    }


    public function updateDevice() {
        $message = 'err'; 
        if( $_FILES['file']['name'] != "" ) {
          $img_data   =   [];
          $img_data['path']   =   'image/device';
          $img_data['file_name']  =   'file';
          $img_data['allowed_type']   =   '*';
          $img_data['old_file']   =   '';
          $img_data['width']  =   '';
          $img_data['height'] =   '';
          $img_data['quality']    =   '60%';
          $img_data['image_compress'] =   False;
  
          $img=$this->uploadfiles($img_data);
  
          if(!empty($img['status']=='1')) {
              $filename = $img['url'];
              $fileurl = base_url('image/device').'/'.$filename;
              //$data = $this->db->empty_table('temp_clock');
              $myfile = fopen($fileurl, "r") or die("Unable to open file!");
              $cntr = 0;
              // Output one line until end-of-file
              $z = 0;
              while(!feof($myfile)) {
                  $x = fgets($myfile);
                  $cntr++;
                  $strtemp = explode(',',$x);                
                  if ($cntr > 1 && $x != '') {
                      if(!empty($strtemp[0])) {
                          $where = [];
                          $where['patient_id'] = $strtemp[0];
    
                          $dataArray1 = [];
                          $dataArray1['device'] = 1;

                          //$this->comman->update('patient', $where, $dataArray1);
                          $z++;    
                      }                    
                  }    
              }
  
              $message = $z.' records has been added successfully.';
              fclose($myfile);
            }
        } 
        echo $message;
      }


      public function mcoUpload() {
        if(isset($_SESSION['name'])) { 


            if(!empty($_POST['rowUpdateId'])) {
                $dataArray = [];
                $dataArray['24_1_f_Charges'] = $_POST['24_1_f_Charges'];
                $dataArray['24_2_f_Charges'] = $_POST['24_2_f_Charges'];
                $dataArray['24_3_f_Charges'] = $_POST['24_3_f_Charges'];
                $dataArray['24_4_f_Charges'] = $_POST['24_4_f_Charges'];
                $dataArray['24_5_f_Charges'] = $_POST['24_5_f_Charges'];
                $dataArray['24_6_f_Charges'] = $_POST['24_6_f_Charges'];
                $dataArray['22_MedicaidResubmissionCode'] = $_POST['22_MedicaidResubmissionCode'];
                $dataArray['22_MedicaidResubmissionRefNo'] = $_POST['22_MedicaidResubmissionRefNo'];

                //$totalCharges28 = $_POST['24_1_f_Charges'] + $_POST['24_2_f_Charges'] + $_POST['24_3_f_Charges'] + $_POST['24_4_f_Charges'] + $_POST['24_5_f_Charges'] + $_POST['24_6_f_Charges'];
                //$dataArray['28_TotalCharge'] = number_format($totalCharges28, 2, '.', '');

                $where = [];
                $where['id'] = $_POST['rowUpdateId'];
                $this->comman->update('mco_upload_data', $where, $dataArray);

                $this->session->set_flashdata('message','MCO Data Has Been Updated Successfully.');
            }

            $data = [];
            $mcoSQL = "SELECT * FROM mco_upload_data WHERE 1";
            if(!empty($_GET['ptName'])) {
                $data['ptName'] = $_GET['ptName'];
                $mcoSQL .= " AND 2_PatientName LIKE '%".$_GET['ptName']."%'";
            }
            if(!empty($_GET['districtMco'])) {
                $data['districtMco'] = $_GET['districtMco'];
                $mcoSQL .= " AND Insurance_Company_Name LIKE '%".$_GET['districtMco']."%'";
            }
            $data['mcoData'] = $this->comman->getCustomQueryData($mcoSQL);

            if($_GET['formSubmit']=='CheckALL') {
                foreach ($data['mcoData'] as $key => $row2) {
                    $rec_id = $row2['id'];
                    $_SESSION['rxx'][$rec_id]  = 'Yes';  
                }
            }

            if($_GET['formSubmit']=='Uncheck') {
                unset($_SESSION['rxx']);
            }

            if ($_GET['formSubmit'] == 'Delete' ) {
                foreach ($data['mcoData'] as $key => $row2) {
                    $rec_id = $row2['id'];
                    if ($_SESSION['rxx'][$rec_id]  == 'Yes')  {
                        $query = "DELETE FROM mco_upload_data WHERE id = '$rec_id'";
                        set_custom_query_data($query);
                    }                        
                }
                unset($_SESSION['rxx']); 
                $data['mcoData'] = $this->comman->getCustomQueryData($mcoSQL);  
                $this->session->set_flashdata('message','Data Has Been Deleted Successfully.');             
            }

            if ($_GET['formSubmit'] == 'Amount Paid') {
                foreach ($data['mcoData'] as $key => $row2) {
                    $rec_id = $row2['id'];
                    if ($_SESSION['rxx'][$rec_id]  == 'Yes')  {
                        $dataArray = [];
                        $dataArray['29_AmountPaid'] = $row2['28_TotalCharge'];

                        $where = [];
                        $where['id'] = $rec_id;
                        $this->comman->update('mco_upload_data', $where, $dataArray);
                    }                        
                }
                unset($_SESSION['rxx']); 
                $data['mcoData'] = $this->comman->getCustomQueryData($mcoSQL);  
                $this->session->set_flashdata('message','MCO Data Has Been Updated Successfully.');             
            }

            if ($_GET['formSubmit'] == 'Adjust Claim') {
                //$rate = $_GET['rate'];
                $rate = 6.24;
                if(!empty($rate)) {
                    $data['rate'] = $rate;
                    foreach ($data['mcoData'] as $key => $row2) {
                        $rec_id = $row2['id'];
                        if ($_SESSION['rxx'][$rec_id]  == 'Yes' && $row2['status']==0)  {

                            $dataArray = [];
                            $dataArray['29_AmountPaid'] = $row2['28_TotalCharge'];

                            $where = [];
                            $where['id'] = $rec_id;
                            $this->comman->update('mco_upload_data', $where, $dataArray);

                            $totalUnit = $row2['24_1_g_Units'] + $row2['24_2_g_Units'] + $row2['24_3_g_Units'] + $row2['24_4_g_Units'] + $row2['24_5_g_Units'] + $row2['24_6_g_Units'];

                            $TotalCharge28 = $totalUnit*$rate;
                            $dataArray = [];
                            $dataArray['28_TotalCharge'] = number_format($TotalCharge28, 2, '.', '');

                            if(!empty($row2['24_1_f_Charges']) && !empty($row2['24_1_g_Units'])) {
                                $dataArray['24_1_f_Charges'] = $row2['24_1_g_Units']*$rate;    
                            }
                            if(!empty($row2['24_2_f_Charges']) && !empty($row2['24_2_g_Units'])) {
                                $dataArray['24_2_f_Charges'] = $row2['24_2_g_Units']*$rate;    
                            }
                            if(!empty($row2['24_3_f_Charges']) && !empty($row2['24_3_g_Units'])) {
                                $dataArray['24_3_f_Charges'] = $row2['24_3_g_Units']*$rate;    
                            }
                            if(!empty($row2['24_4_f_Charges']) && !empty($row2['24_4_g_Units'])) {
                                $dataArray['24_4_f_Charges'] = $row2['24_4_g_Units']*$rate;    
                            }
                            if(!empty($row2['24_5_f_Charges']) && !empty($row2['24_5_g_Units'])) {
                                $dataArray['24_5_f_Charges'] = $row2['24_5_g_Units']*$rate;    
                            }
                            if(!empty($row2['24_6_f_Charges']) && !empty($row2['24_6_g_Units'])) {
                                $dataArray['24_6_f_Charges'] = $row2['24_6_g_Units']*$rate;    
                            }                        

                            $dataArray['status'] = 1;

                            $where = [];
                            $where['id'] = $rec_id;
                            $this->comman->update('mco_upload_data', $where, $dataArray);
                        }                        
                    }
                    unset($_SESSION['rxx']); 
                } else {
                ?>
                <script type="text/javascript">
                    alert('Please enter rate');
                </script>
                <?php    
                }
                $data['mcoData'] = $this->comman->getCustomQueryData($mcoSQL);  
                $this->session->set_flashdata('message','MCO Data Has Been Updated Successfully.');             
            }


            if($_GET['formSubmit']=='Save MI Claim') {
                $sqlCms1500 = "SELECT * FROM cms1500 limit 1";

                $sql = "SELECT * FROM mco_upload_data";
                $filename2 = "TEST".date('YmdHis').".dat";
                $filename2 = "/var/www/html/Test/EDI/".$filename2;
                $filename = $filename2;
                $fh = fopen($filename, 'w') or die("can't open file");
                $flag = false;
                $counter = 0;
                $arry = array(' ',' ',' ',' ');
                $temptime = date("Y-m-d H:i:s");

                $result = get_custom_query_data($sql);
                foreach ($result as $key => $row) {
                    $cms_id2 = $row['id'];
                    $uploadtime = $temptime;
                    if ($_SESSION['rxx'][$cms_id2]  == 'Yes')  {
                        if(!$flag) {
                            $row2 = get_custom_query_data($sqlCms1500, 'row');
                            $stringData = array_keys($row2);
                            for ($cnt=5;$cnt<=200;$cnt++) {
                                if ($cnt < 200)  {        
                                    fwrite($fh, $stringData[$cnt].",");
                                } else {
                                    fwrite($fh, $stringData[$cnt]);     
                                }  
                            }
                            fwrite($fh,Chr(13).Chr(10));
                            $flag = true;
                        }

                        $x = 1;
                        $stringData = array_values($row);  
                        for ($cnt=1;$cnt<=196;$cnt++) {
                            if ($cnt<196)  {      
                                fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                            } else {
                                fwrite($fh, '"'.$stringData[$cnt].'"');       
                            }  
                        }
                        fwrite($fh,Chr(13).Chr(10));
                    }   
                }                 
                fclose($fh);

                unset($_SESSION['rxx']); 

                $url = base_url('dashboardd/savefile')."?filename=".$filename;

                $url2 = base_url('fileExport/mcoUpload')."?districtMco=".$_GET['districtMco']."+&ptName=".$_GET['ptName']."&btnSearch=".$_GET['btnSearch'];
                ?>
                <script>
                    window.open("<?php echo $url;?>"," ","width=100, height=100");
                    window.location = "<?php echo $url2; ?>";
                </script>
                <?php
            }

            $strSQL = "SELECT * FROM tbldistricts WHERE mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->comman->getCustomQueryData($strSQL);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('file-export/mco-file.php', $data);
            $this->load->view('common/footer-view.php');   
        } else {
            redirect();
        } 
    }


    public function updateMCOData() {
        if(isset($_SESSION['name'])) {
            $message = 'err';
            if( $_FILES['file']['name'] != "" ) {
                $img_data   =   [];
                $img_data['path']   =   'image/mco';
                $img_data['file_name']  =   'file';
                $img_data['allowed_type']   =   '*';
                $img_data['old_file']   =   '';
                $img_data['width']  =   '';
                $img_data['height'] =   '';
                $img_data['quality']    =   '60%';
                $img_data['image_compress'] =   False;
      
                $img=$this->uploadfiles($img_data);
      
                if(!empty($img['status']=='1')) {
                    $filename = $img['url'];
                    $fileurl = base_url('image/mco').'/'.$filename;
                    $myfile = fopen($fileurl, "r") or die("Unable to open file!");
                    $cntr = 0;
                    $z = 0;

                    while(!feof($myfile)) {
                        $x = fgets($myfile);
                        $cntr++;
                        $strtemp = str_getcsv($x, ",", "");
                        if ($cntr > 1 && $x != '') {
                            if(!empty($strtemp[0])) {                                
                                $dataArray = [];
                                $dataArray["Insurance_Company_Name"] = $strtemp[0];
                                $dataArray["Insurance_Company_Name_2"] = $strtemp[1];
                                $dataArray["Insurance_Company_Address_1"] = $strtemp[2];
                                $dataArray["Insurance_Company_Address_2"] = $strtemp[3];
                                $dataArray["1_InsuredPlanName"] = $strtemp[4];
                                $dataArray["1a_InsuredIDNo"] = $strtemp[5];
                                $dataArray["2_PatientName"] = $strtemp[6];
                                $dataArray["3_PatientDOB"] = $strtemp[7];
                                $dataArray["3_PatientGender"] = $strtemp[8];
                                $dataArray["4_InsuredName"] = $strtemp[9];
                                $dataArray["5_PatientAddress"] = $strtemp[10];
                                $dataArray["5_PatientCity"] = $strtemp[11];
                                $dataArray["5_PatientState"] = $strtemp[12];
                                $dataArray["5_PatientZip"] = $strtemp[13];
                                $dataArray["5_PatientPhone"] = $strtemp[14];
                                $dataArray["6_PatientRel"] = $strtemp[15];
                                $dataArray["7_InsuredAddr"] = $strtemp[16];
                                $dataArray["7_InsAddCity"] = $strtemp[17];
                                $dataArray["7_InsAddState"] = $strtemp[18];
                                $dataArray["7_InsAddZip"] = $strtemp[19];
                                $dataArray["7_InsAddPhone"] = $strtemp[20];
                                $dataArray["8_NUCC_Use"] = $strtemp[21];
                                $dataArray["8_MaritalStatus"] = $strtemp[22];
                                $dataArray["8_Employed"] = $strtemp[23];
                                $dataArray["8_ReservedForNUCCuse"] = $strtemp[24];
                                $dataArray["9_InsuredName2"] = $strtemp[25];
                                $dataArray["9a_InsuredGroupNo2"] = $strtemp[26];
                                $dataArray["9b_NUCC_Use"] = $strtemp[27];
                                $dataArray["9b_Insureds2DOB"] = $strtemp[28];
                                $dataArray["9b_Insureds2Gender"] = $strtemp[29];
                                $dataArray["9b_ReservedForNUCCuse"] = $strtemp[30];
                                $dataArray["9c_ReservedForNUCCuse"] = $strtemp[31];
                                $dataArray["9c_EmployerName"] = $strtemp[32];
                                $dataArray["9d_InsuredPlanName2"] = $strtemp[33];
                                $dataArray["10a_CondEmployment"] = $strtemp[34];
                                $dataArray["10b_CondAutoAccident"] = $strtemp[35];
                                $dataArray["10c_CondOtherAccident"] = $strtemp[36];
                                $dataArray["10b2_AccidentState"] = $strtemp[37];
                                $dataArray["10d_LocalUse"] = $strtemp[38];
                                $dataArray["11_InsuredGroupNo"] = $strtemp[39];
                                $dataArray["11a_InsuredsDOB"] = $strtemp[40];
                                $dataArray["11a_InsuredsGender"] = $strtemp[41];
                                $dataArray["11b_OhterClaimID"] = $strtemp[42];
                                $dataArray["11b_EmployerName"] = $strtemp[43];
                                $dataArray["11c_InsuredPlanName"] = $strtemp[44];
                                $dataArray["11d_OtherHealthPlan"] = $strtemp[45];
                                $dataArray["12_PatientSign"] = $strtemp[46];
                                $dataArray["12_Date"] = $strtemp[47];
                                $dataArray["13_AuthSign"] = $strtemp[48];
                                $dataArray["14_DateOfCondition"] = $strtemp[49];
                                $dataArray["15_OtherDate"] = $strtemp[50];
                                $dataArray["15_OtherDateInd"] = $strtemp[51];
                                $dataArray["15_FirstDateOfCondition"] = $strtemp[52];
                                $dataArray["16_DateFromNoWork"] = $strtemp[53];
                                $dataArray["16_DateToNoWork"] = $strtemp[54];
                                $dataArray["17_ReferringPhysician"] = $strtemp[55];
                                $dataArray["17_ReferringPhysicianInd"] = $strtemp[56];
                                $dataArray["17a_PhysicianNo"] = $strtemp[57];
                                $dataArray["17b_ReferNPI"] = $strtemp[58];
                                $dataArray["18_DateFromHosp"] = $strtemp[59];
                                $dataArray["18_DateToHosp"] = $strtemp[60];
                                $dataArray["19_LocalUse"] = $strtemp[61];
                                $dataArray["20_OutsideLab"] = $strtemp[62];
                                $dataArray["20_Charges"] = $strtemp[63];
                                $dataArray["21_1_Diagnosis"] = $strtemp[64];
                                $dataArray["21_2_Diagnosis"] = $strtemp[65];
                                $dataArray["21_3_Diagnosis"] = $strtemp[66];
                                $dataArray["21_4_Diagnosis"] = $strtemp[67];
                                $dataArray["21_IcdInd_9_or_10_Indicator"] = $strtemp[68];
                                $dataArray["21_a_Diagnosis"] = $strtemp[69];
                                $dataArray["21_b_Diagnosis"] = $strtemp[70];
                                $dataArray["21_c_Diagnosis"] = $strtemp[71];
                                $dataArray["21_d_Diagnosis"] = $strtemp[72];
                                $dataArray["21_e_Diagnosis"] = $strtemp[73];
                                $dataArray["21_f_Diagnosis"] = $strtemp[74];
                                $dataArray["21_i_Diagnosis"] = $strtemp[75];
                                $dataArray["21_j_Diagnosis"] = $strtemp[76];
                                $dataArray["21_k_Diagnosis"] = $strtemp[77];
                                $dataArray["21_l_Diagnosis"] = $strtemp[78];
                                $dataArray["22_MedicaidResubmissionCode"] = $strtemp[79]!=''?$strtemp[79]:'7';
                                $dataArray["22_MedicaidResubmissionRefNo"] = $strtemp[80];
                                $dataArray["23_PriorAuth"] = $strtemp[81];
                                $dataArray["24_1_a_DOSFrom"] = $strtemp[82];
                                $dataArray["24_1_a_DOSTo"] = $strtemp[83];
                                $dataArray["24_1_b_Place"] = $strtemp[84];
                                $dataArray["24_1_c_EMG"] = $strtemp[85];
                                $dataArray["24_1_d_CPT"] = $strtemp[86];
                                $dataArray["24_1_d_Modifier"] = $strtemp[87];
                                $dataArray["24_1_e_Code"] = $strtemp[88];
                                $dataArray["24_1_f_Charges"] = $strtemp[89];
                                $dataArray["24_1_g_Units"] = $strtemp[90];
                                $dataArray["24_1_h_Epsot"] = $strtemp[91];
                                $dataArray["24_1_i_Qualifier"] = $strtemp[92];
                                $dataArray["24_1_j_ProvLegacyNo"] = $strtemp[93];
                                $dataArray["24_1_j_ProvNPI"] = $strtemp[94];
                                $dataArray["24_1_j_TAXO"] = $strtemp[95];
                                $dataArray["24_1_SrvComment"] = $strtemp[96];
                                $dataArray["24_2_a_DOSFrom"] = $strtemp[97];
                                $dataArray["24_2_a_DOSTo"] = $strtemp[98];
                                $dataArray["24_2_b_Place"] = $strtemp[99];
                                $dataArray["24_2_c_EMG"] = $strtemp[100];
                                $dataArray["24_2_d_CPT"] = $strtemp[101];
                                $dataArray["24_2_d_Modifier"] = $strtemp[102];
                                $dataArray["24_2_e_Code"] = $strtemp[103];
                                $dataArray["24_2_f_Charges"] = $strtemp[104];
                                $dataArray["24_2_g_Units"] = $strtemp[105];
                                $dataArray["24_2_h_Epsot"] = $strtemp[106];
                                $dataArray["24_2_i_Qualifier"] = $strtemp[107];
                                $dataArray["24_2_j_ProvLegacyNo"] = $strtemp[108];
                                $dataArray["24_2_j_ProvNPI"] = $strtemp[109];
                                $dataArray["24_2_j_TAXO"] = $strtemp[110];
                                $dataArray["24_2_SrvComment"] = $strtemp[111];
                                $dataArray["24_3_a_DOSFrom"] = $strtemp[112];
                                $dataArray["24_3_a_DOSTo"] = $strtemp[113];
                                $dataArray["24_3_b_Place"] = $strtemp[114];
                                $dataArray["24_3_c_EMG"] = $strtemp[115];
                                $dataArray["24_3_d_CPT"] = $strtemp[116];
                                $dataArray["24_3_d_Modifier"] = $strtemp[117];
                                $dataArray["24_3_e_Code"] = $strtemp[118];
                                $dataArray["24_3_f_Charges"] = $strtemp[119];
                                $dataArray["24_3_g_Units"] = $strtemp[120];
                                $dataArray["24_3_h_Epsot"] = $strtemp[121];
                                $dataArray["24_3_i_Qualifier"] = $strtemp[122];
                                $dataArray["24_3_j_ProvLegacyNo"] = $strtemp[123];
                                $dataArray["24_3_j_ProvNPI"] = $strtemp[124];
                                $dataArray["24_3_j_TAXO"] = $strtemp[125];
                                $dataArray["24_3_SrvComment"] = $strtemp[126];
                                $dataArray["24_4_a_DOSFrom"] = $strtemp[127];
                                $dataArray["24_4_a_DOSTo"] = $strtemp[128];
                                $dataArray["24_4_b_Place"] = $strtemp[129];
                                $dataArray["24_4_c_EMG"] = $strtemp[130];
                                $dataArray["24_4_d_CPT"] = $strtemp[131];
                                $dataArray["24_4_d_Modifier"] = $strtemp[132];
                                $dataArray["24_4_e_Code"] = $strtemp[133];
                                $dataArray["24_4_f_Charges"] = $strtemp[134];
                                $dataArray["24_4_g_Units"] = $strtemp[135];
                                $dataArray["24_4_h_Epsot"] = $strtemp[136];
                                $dataArray["24_4_i_Qualifier"] = $strtemp[137];
                                $dataArray["24_4_j_ProvLegacyNo"] = $strtemp[138];
                                $dataArray["24_4_j_ProvNPI"] = $strtemp[139];
                                $dataArray["24_4_j_TAXO"] = $strtemp[140];
                                $dataArray["24_4_SrvComment"] = $strtemp[141];
                                $dataArray["24_5_a_DOSFrom"] = $strtemp[142];
                                $dataArray["24_5_a_DOSTo"] = $strtemp[143];
                                $dataArray["24_5_b_Place"] = $strtemp[144];
                                $dataArray["24_5_c_EMG"] = $strtemp[145];
                                $dataArray["24_5_d_CPT"] = $strtemp[146];
                                $dataArray["24_5_d_Modifier"] = $strtemp[147];
                                $dataArray["24_5_e_Code"] = $strtemp[148];
                                $dataArray["24_5_f_Charges"] = $strtemp[149];
                                $dataArray["24_5_g_Units"] = $strtemp[150];
                                $dataArray["24_5_h_Epsot"] = $strtemp[151];
                                $dataArray["24_5_i_Qualifier"] = $strtemp[152];
                                $dataArray["24_5_j_ProvLegacyNo"] = $strtemp[153];
                                $dataArray["24_5_j_ProvNPI"] = $strtemp[154];
                                $dataArray["24_5_j_TAXO"] = $strtemp[155];
                                $dataArray["24_5_SrvComment"] = $strtemp[156];
                                $dataArray["24_6_a_DOSFrom"] = $strtemp[157];
                                $dataArray["24_6_a_DOSTo"] = $strtemp[158];
                                $dataArray["24_6_b_Place"] = $strtemp[159];
                                $dataArray["24_6_c_EMG"] = $strtemp[160];
                                $dataArray["24_6_d_CPT"] = $strtemp[161];
                                $dataArray["24_6_d_Modifier"] = $strtemp[162];
                                $dataArray["24_6_e_Code"] = $strtemp[163];
                                $dataArray["24_6_f_Charges"] = $strtemp[164];
                                $dataArray["24_6_g_Units"] = $strtemp[165];
                                $dataArray["24_6_h_Epsot"] = $strtemp[166];
                                $dataArray["24_6_i_Qualifier"] = $strtemp[167];
                                $dataArray["24_6_j_ProvLegacyNo"] = $strtemp[168];
                                $dataArray["24_6_j_ProvNPI"] = $strtemp[169];
                                $dataArray["24_6_j_TAXO"] = $strtemp[170];
                                $dataArray["24_6_SrvComment"] = $strtemp[171];
                                $dataArray["25_TaxID"] = $strtemp[172];
                                $dataArray["25_SSN_EIN"] = $strtemp[173];
                                $dataArray["26_PatientAcctNo"] = $strtemp[174];
                                $dataArray["27_AcceptAssign"] = $strtemp[175];
                                $dataArray["28_TotalCharge"] = $strtemp[176];
                                $dataArray["29_AmountPaid"] = $strtemp[177];
                                $dataArray["30_ReservedForNUCCuse"] = $strtemp[178];
                                $dataArray["30_BalanceDue"] = $strtemp[179];
                                $dataArray["31_PhysicianSignature"] = $strtemp[180];
                                $dataArray["31_Date"] = $strtemp[181];
                                $dataArray["32_FacilityName"] = $strtemp[182];
                                $dataArray["32_FacilityAddressLine1"] = $strtemp[183];
                                $dataArray["32_FacilityAddressLine2"] = $strtemp[184];
                                $dataArray["32_FacilityCityStateZip"] = $strtemp[185];
                                $dataArray["32_FacilityNPI"] = $strtemp[186];
                                $dataArray["33_ClinicName"] = $strtemp[187];
                                $dataArray["33_ClinicAddressLine1"] = $strtemp[188];
                                $dataArray["33_ClinicAddressLine2"] = $strtemp[189];
                                $dataArray["33_ClinicCityStateZip"] = $strtemp[190];
                                $dataArray["33_PIN"] = $strtemp[191];
                                $dataArray["33_GRP"] = $strtemp[192];
                                $dataArray["33_a_NPI"] = $strtemp[193];
                                $dataArray["33_b_GrpLegacyNo"] = $strtemp[194];
                                $dataArray["33_B_TAXO"] = $strtemp[195];

                                //$sql = $this->db->set($dataArray)->get_compiled_insert('mco_upload_data');
                                //echo $sql;die;

                                $this->comman->insert('mco_upload_data', $dataArray);
                                //echo $this->db->last_query(); die;

                                $z++;
                            }
                        }
                    }
                    $message = $z.' records has been added successfully.';
                    fclose($myfile);
                }
                echo $message;
            }            
        } else {
            redirect();
        }
    }

    public function updateMCODataRead() {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
        //error_reporting(E_ALL);

        $message = 'err';
        $filename = 'file16444043396296.dat';
        $fileurl = base_url('image/mco').'/'.$filename;
        //$data = $this->db->empty_table('temp_clock');
        $myfile = fopen($fileurl, "r") or die("Unable to open file!");
        $cntr = 0;
        // Output one line until end-of-file
        $z = 0;
        while(!feof($myfile)) {
            $x = fgets($myfile);
            $cntr++;
            $strtemp = explode(',',$x);                    
            if ($cntr > 1 && $x != '') {
                if(!empty($strtemp[0])) {

                    foreach ($strtemp as $key => $value) {
                        echo $value;
                        echo '<br>';
                    }

                    //echo $strtemp[0];
                    //echo '<br>';
                    //$where = [];
                    //$where['patient_id'] = $strtemp[0];

                    //$dataArray1 = [];
                    //$dataArray1['device'] = 1;

                    //$this->comman->update('patient', $where, $dataArray1);
                    $z++;    
                }
            }
        }
    }


    public function uploadMCOEligibility() {
      $message = 'err'; 

      if( $_FILES['file']['name'] != "" && !empty($_POST['userGrp'])) {
        $img_data   =   [];
        $img_data['path']   =   'image/mco_eligibility';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $dataArray = [];
            $filename = $img['url'];
            $fileurl = base_url('image/mco_eligibility').'/'.$filename;
            //$data = $this->db->empty_table('temp_clock');
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            while(!feof($myfile)) {
                $x = fgets($myfile);
                $cntr++;
                $strtemp = explode(',',$x);
                if ($cntr > 1 && $x != '') {
                    $dataArray[$cntr]['TxnType'] = $strtemp[0];
                    $dataArray[$cntr]['PayerID']  = $strtemp[1];
                    $dataArray[$cntr]['MemberID']  = $strtemp[2];
                    $dataArray[$cntr]['ProviderID']  = $strtemp[3];
                    $dataArray[$cntr]['ProviderIDType']   = $strtemp[4];
                    $dataArray[$cntr]['ProviderLN']   = $strtemp[5];
                    $dataArray[$cntr]['ProviderEntityType']   = $strtemp[6];
                    $dataArray[$cntr]['StartDate']   = $strtemp[7];
                    $dataArray[$cntr]['EndDate']   = $strtemp[8];
                    $dataArray[$cntr]['ServiceType']   = $strtemp[9];
                    //$dataArray[$cntr]['District_ID']   = $strtemp[10];
                    //$dataArray[$cntr]['Payor_ID']   = $strtemp[11];
                }    
            }

            //print_r($dataArray);die;
            fclose($myfile);

            $patientData = [];
            if(!empty($dataArray)) {
                $z = 0;
                foreach ($dataArray as $key => $row) {
                    $dataArray1 = [];
                    $dataArray1['TxnType']              = $row['TxnType'];
                    $dataArray1['PayerID']              = $row['PayerID'];
                    $dataArray1['MemberID']             = $row['MemberID'];
                    $dataArray1['ProviderID']           = $row['ProviderID'];
                    $dataArray1['ProviderIDType']       = $row['ProviderIDType'];
                    $dataArray1['ProviderLN']           = $row['ProviderLN'];
                    $dataArray1['ProviderEntityType']   = $row['ProviderEntityType'];
                    $dataArray1['StartDate']            = $row['StartDate'];
                    $dataArray1['EndDate']              = $row['EndDate'];
                    $dataArray1['ServiceType']          = $row['ServiceType'];
                    //$dataArray1['District_ID']          = $row['District_ID'];
                    //$dataArray1['Payor_ID']             = $row['Payor_ID'];
                    //$dataArray1['payorGrp']             = $_POST['payorGrp'];
                    //$dataArray1['eliGrp']               = $_POST['payorGrp'];
                    $dataArray1['userGrp']              = $_POST['userGrp'];
                    $dataArray1['userId']               = $this->session->userdata('id');
                    $this->comman->insert('mco_eligibility', $dataArray1);
                    $z++;
                }    
                $message = $z.' records has been added successfully.';
            }
          }
      } 
      echo $message;
    }


    public function mCOEligibility() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'File Export';
            $data['mcoEligibilityData'] = [];
            if(!empty($_GET['search'])) {
                if(!empty($_GET['memberId'])) {
                    $memberId  = $_GET['memberId'];
                    $cond .= " AND MemberID='".$memberId."'";
                }       

                if(!empty($_GET['districtId'])) {
                    $districtId  = $_GET['districtId'];
                    $cond .= " AND District_ID='".$districtId."'";
                }

                $payorGrp  = @$_GET['payorGrp'];
                if($payorGrp!='') {
                    if($payorGrp==8) {
                        $cond .= " AND payorGrp!=eliGrp";
                    } else {
                        $cond .= " AND payorGrp='".$payorGrp."'";    
                    }                    
                }

                $eliGrp  = @$_GET['eliGrp'];
                if($eliGrp!='') {
                    if($elGrp==8) {
                        $cond .= " AND payorGrp!=eliGrp";
                    } else {
                        $cond .= " AND eliGrp='".$eliGrp."'";    
                    }                    
                }

                $userGrp  = @$_GET['userGrp'];
                if($userGrp!='') {
                    $cond .= " AND userGrp='".$userGrp."'";
                }                

                $userId = $this->session->userdata('id');
                $cond .= " AND userId='".$userId."'";

                if(!empty($_GET['startDate'])) {
                    $startDate  = date('Ymd', strtotime($_GET['startDate']));
                    $cond .= " AND StartDate='".$startDate."'";    
                }

                //$sql = "SELECT * FROM mco_eligibility WHERE compare = 0".$cond;
                $sql = "SELECT * FROM mco_eligibility WHERE 1".$cond;
                $data['mcoEligibilityData'] = $this->comman->getCustomQueryData($sql);
            }            

            if ($_GET['formSubmit'] == 'CheckALL' && !empty($_GET['search'])) {
                if(!empty($data['mcoEligibilityData'])) {
                    foreach ($data['mcoEligibilityData'] as $key => $row) {
                        $rec_id = $row['id'];
                        $_SESSION['rxx'][$rec_id]  = 'Yes';  
                    }
                }
            }

            if ($_GET['compareremove'] == 'compareremove' && !empty($_GET['compareremove'])) {
                if(!empty($data['mcoEligibilityData'])) {
                    foreach ($data['mcoEligibilityData'] as $key => $row) {
                        $rec_id = $row['id'];
                        if($_SESSION['rxx'][$rec_id]=='Yes') {
                            $sqlu = "UPDATE mco_eligibility SET compare = 1 WHERE id = '".$rec_id."'";
                            set_custom_query_data($sqlu);
                        }
                    }
                }
                $data['mcoEligibilityData'] = $this->comman->getCustomQueryData($sql);
            }

            if ($_GET['dataremove'] == 'dataremove' && !empty($_GET['dataremove'])) {
                if(!empty($data['mcoEligibilityData'])) {
                    foreach ($data['mcoEligibilityData'] as $key => $row) {
                        $rec_id = $row['id'];
                        if($_SESSION['rxx'][$rec_id]=='Yes') {
                            $sqlu = "DELETE FROM mco_eligibility WHERE id = '".$rec_id."'";
                            set_custom_query_data($sqlu);
                        }
                    }
                }
                unset($_SESSION['rxx']);
                $data['mcoEligibilityData'] = $this->comman->getCustomQueryData($sql);
            }

            if ($_GET['formSubmit']=='Uncheck') {
                unset($_SESSION['rxx']);
            }

            $data['memberId']       =   $memberId;
            $data['districtId']     =   $districtId;
            $data['startDate']      =   $_GET['startDate'];
            $data['search']         =   $_GET['search'];
            $data['payorGrp']       =   $_GET['payorGrp'];            
            $data['eliGrp']         =   $_GET['eliGrp'];            
            $data['userGrp']        =   $_GET['userGrp'];            

            if($checkView) {
                /*
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/mco-eligibility-view.php', $data);
                $this->load->view('common/footer.php');    
                */

                $this->load->view('common/header-new');
                $this->load->view('common/sidebar-new', $data);
                $this->load->view('file-export/mco-eligibility-view-new', $data);
            }
        } else {
            redirect(base_url('login/admin'));
        }
    }  

    public function updateCompliance() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'File Export';

            if($checkView) {
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/view-compliance.php', $data);
                $this->load->view('common/footer-view.php');    
            }
        } else {
            redirect($this->agent->referrer());
        }
    }  

    public function updateEmployeeCompliance() {
      $message = 'err'; 
      if( $_FILES['file']['name'] != "" ) {
        $img_data   =   [];
        $img_data['path']   =   'image/uploads2';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $filename = $img['url'];
            $fileurl = base_url('image/uploads2').'/'.$filename;
            //$data = $this->db->empty_table('temp_clock');
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            $z = 0;
            while(!feof($myfile)) {
                $x = fgets($myfile);
                $cntr++;
                $strtemp = explode(',',$x);   

                //print_r($strtemp);

                if ($cntr > 2 && $x != '') {
                    //print_r($strtemp[2]);die;
                    if(!empty($strtemp[0])) {
                        $compliance = '';
                        if($strtemp[3]=='TRUE') { //App
                            $compliance = '1,';
                        }
                        if($strtemp[4]=='TRUE') { // Marketing
                            $compliance .= '7,';
                        }
                        if($strtemp[5]=='TRUE') { // Assets
                            $compliance .= '9,';
                        }
                        if($strtemp[6]=='TRUE') { // Influenza
                            $compliance .= '10,';
                        }
                        if($strtemp[7]=='TRUE') { // Diploma
                            $compliance .= '2,';
                        }
                        if($strtemp[8]=='TRUE') { // PST
                            $compliance .= '12,';
                        }
                        if($strtemp[9]=='TRUE') { // PST Signed
                            $compliance .= '13,';
                        }
                        if($strtemp[10]=='TRUE') { // ID
                            $compliance .= '14,';
                        }
                        if($strtemp[11]=='TRUE') { // SSC
                            $compliance .= '18,';
                        }
                        if($strtemp[12]=='TRUE') { // I9
                            $compliance .= '6,';
                        }
                        if($strtemp[13]=='TRUE') { // FP
                            $compliance .= '16,';
                        }
                        if($strtemp[14]=='TRUE') { // HB
                            $compliance .= '17,';
                        }
                        if(!empty($strtemp[27])) { //SSN
                            $ssn = $strtemp[27];
                        }

                        //echo rtrim($compliance,',');
                        //echo '<br>';
                        //echo $ssn;die;
                        
                        if(!empty($ssn)) {
                            $sql = "SELECT * FROM employee WHERE ssn LIKE '%".$ssn."%'";
                            $employeeData = $this->comman->getCustomQueryData($sql);

                            //print_r($employeeData);die;

                            if(!empty($employeeData)) {
                                foreach ($employeeData as $key => $rowe) {
                                    // code...
                                    $where = [];
                                    $where['employee_id'] = $rowe['employee_id'];
                                    $dataArray1 = [];
                                    $dataArray1['compliance'] = $compliance;
                                    $this->comman->update('employee', $where, $dataArray1);
                                    $z++;    
                                }                            
                            }
                        }
                    }                    
                }    
            }
            $message = $z.' records has been added successfully.';
            fclose($myfile);
          }
      } 
      echo $message;
    }


    function x12ToOriginal() {
        $message = 'err'; 
        if( $_FILES['file']['name'] != "" ) {
            $img_data                   =   [];
            $img_data['path']           =   'image/x12';
            $img_data['file_name']      =   'file';
            $img_data['allowed_type']   =   '*';
            $img_data['old_file']       =   '';
            $img_data['width']          =   '';
            $img_data['height']         =   '';
            $img_data['quality']        =   '';
            $img_data['image_compress'] =   False;

            $img = $this->uploadfiles($img_data);

            //print_r($img);die;

            if(!empty($img['status']=='1')) {
                $filename   = $img['url'];
                $this->x12Reader($filename);
                echo $message = 'Records has been extracted successfully.';
            }
        } 
    }

    public function x12Upload() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'File Export';

            $sql =  "SELECT * FROM x12_data";            
            $data['extractData'] = $this->comman->getCustomQueryData($sql);

            if($checkView) {
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/x12-view.php', $data);
                $this->load->view('common/footer-view.php');    
            }
        } else {
            redirect($this->agent->referrer());
        }
    }  


    function x12Reader($filename) {
        $message    = 'err'; 
        //$filename   = 'file16638303353051.txt';
        $fileurl    = base_url('image/x12').'/'.$filename;
        $myfile     = fopen($fileurl, "r") or die("Unable to open file!");
        $cntr       = 0;
        // Output one line until end-of-file
        $z = 0;        
        $patientData = [];

        while(!feof($myfile)) {
            $x = fgets($myfile);

            $pattern = "/PRV/i";
            if(preg_match($pattern, $x)) {
                $z++;
                $k = 0;
                $nameLine = explode('*', $x);
                $TAXO = trim(str_replace(array("~"), '', $nameLine[3]));
                $patientData[$z]['"33-B-TAXO"'] = $TAXO;
            }

            $pattern = "/NM1/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);                
                if($nameLine[1]=='85') {
                    $ClinicName = trim(str_replace(array("~"), '', $nameLine[3]));
                    $patientData[$z]['"33-ClinicName"'] = $ClinicName;
                }

                if($nameLine[1]=='PR') {
                    $patientData[$z]['"Insurance Company Name"'] = $nameLine[3];
                    $PatientAcctNo = trim(str_replace(array("~"), '', $nameLine[9]));
                    $patientData[$z]['"26-PatientAcctNo"'] = $PatientAcctNo;
                }
            }

            $pattern = "/DMG/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                $patientData[$z]['"3-PatientDOB"'] = date('Y-m-d', strtotime($nameLine[2]));
                $PatientGender = trim(str_replace(array("~"), '', $nameLine[3]));
                $patientData[$z]['"3-PatientGender"'] = $PatientGender;
            }

            $pattern = "/REF/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);                
                if($nameLine[1]=='G2') {
                    $GrpLegacyNo = trim(str_replace(array("~"), '', $nameLine[2]));
                    $patientData[$z]['"33-b-GrpLegacyNo"'] = $GrpLegacyNo;
                }

                if($nameLine[1]=='G1') {
                    $PriorAuth = trim(str_replace(array("~"), '', $nameLine[2]));
                    $patientData[$z]['"23-PriorAuth"'] = $PriorAuth;
                }
            }

            $pattern = "/SBR/i";
            if(preg_match($pattern, $x)) {                
                $x = fgets($myfile);
                $nameLine = explode('*', $x);
                $patientData[$z]['patient_name'] = $nameLine[3].', '.$nameLine[4];
                $i = 1;
            }            

            $pattern = "/LX/i";
            if(preg_match($pattern, $x)) {
                $x = fgets($myfile);
                $nameLine = explode('*', $x);
                $patientData[$z]['data'][$k]['"24.'.$i.'.f-Charges"'] = $nameLine[2];
                $patientData[$z]['data'][$k]['"24.'.$i.'.g-Units"'] = $nameLine[4];
                $patientData[$z]['data'][$k]['"24.'.$i.'.b-Place"'] = $nameLine[5];
                $eCode = trim(str_replace(array("~"), '', $nameLine[7]));
                $patientData[$z]['data'][$k]['"24.'.$i.'.e-Code"'] = $eCode;
            }

            $pattern = "/DTP/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                $datedStr = trim(str_replace(array("~"), '', $nameLine[3]));
                $dated = explode('-', $datedStr);

                $dfrom1 = date('Y-m-d', strtotime($dated[0]));
                $dto1 = date('Y-m-d', strtotime($dated[1]));

                $patientData[$z]['data'][$k]['"24.'.$i.'.a-DOSFrom"'] = $dfrom1;
                $patientData[$z]['data'][$k]['"24.'.$i.'.a-DOSTo"'] = $dto1;                
            }            

            $pattern = "/NTE/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                $SrvComment = trim(str_replace(array("~"), '', $nameLine[2]));
                $patientData[$z]['data'][$k]['"24.'.$i.'.SrvComment"'] = $SrvComment;
                $i++;                
                $k++;
            }            
        }
        //print_r($patientData);

        if(!empty($patientData)) {
            foreach ($patientData as $key => $row) {
                $dataArray = [];
                $dataArray['33-B-TAXO'] = $row['"33-B-TAXO"'];
                $dataArray['33-ClinicName'] = $row['"33-ClinicName"'];
                $dataArray['patient_name'] = $row['patient_name'];
                $dataArray['3-PatientDOB'] = $row['"3-PatientDOB"'];
                $dataArray['3-PatientGender'] = $row['"3-PatientGender"'];
                $dataArray['Insurance_Company_Name'] = $row['"Insurance Company Name"'];
                $dataArray['26-PatientAcctNo'] = $row['"26-PatientAcctNo"'];
                $dataArray['33-b-GrpLegacyNo'] = $row['"33-b-GrpLegacyNo"'];
                $dataArray['23-PriorAuth'] = $row['"23-PriorAuth"'];

                $insertCHeck = true;

                if(!empty($row['data'])) {
                    $i = 1; $j = 1;
                    foreach ($row['data'] as $key1 => $row1) {
                        // code...
                        if($i<=6) {
                            $dataArray['24-'.$i.'-f-Charges'] = $row1['"24.'.$j.'.f-Charges"'];
                            $dataArray['24-'.$i.'-g-Units'] = $row1['"24.'.$j.'.g-Units"'];
                            $dataArray['24-'.$i.'-b-Place'] = $row1['"24.'.$j.'.b-Place"'];
                            $dataArray['24-'.$i.'-e-Code'] = $row1['"24.'.$j.'.e-Code"'];
                            $dataArray['24-'.$i.'-a-DOSFrom'] = $row1['"24.'.$j.'.a-DOSFrom"'];
                            $dataArray['24-'.$i.'-a-DOSTo'] = $row1['"24.'.$j.'.a-DOSTo"'];
                            $dataArray['24-'.$i.'-SrvComment'] = $row1['"24.'.$j.'.SrvComment"'];
                            if($i==6) {
                                $this->comman->insert('x12_data', $dataArray);         
                                $insertCHeck = false;
                                $i = 0;
                            }
                        }   
                        $i++; $j++;                  
                    }
                }
                if($insertCHeck) {
                    $this->comman->insert('x12_data', $dataArray);    
                }                
            }
        }
        fclose($myfile);
    }

    public function excelX12Report() {

        $sql = "SELECT * FROM x12_data";
        $result = $this->comman->getCustomQueryData($sql);
        $timesheet = 0;
        $dataArray = [];
        $x=0;
        foreach ($result as $key => $row) {
            $dataArray[$x]['clinic_name']  = $row['33-ClinicName'];
            $dataArray[$x]['patient_name'] = $row['patient_name'];
            if(!empty($row['3-PatientDOB'])) {
                $dob = date('m-d-Y', strtotime($row['3-PatientDOB']));   
            }
            $dataArray[$x]['patient_dob']  = $dob;

            /*$dataArray[$x]['dosfrom']  = '';
            $dataArray[$x]['dosto']  = '';
            $dataArray[$x]['Units']  = '';
            $dataArray[$x]['Charges']  = '';*/

            if(!empty($row['24-1-a-DOSFrom'])) {
                $DOSFrom = date('m-d-Y', strtotime($row['24-1-a-DOSFrom']));   
            }
            if(!empty($row['24-1-a-DOSTo'])) {
                $DOSTo = date('m-d-Y', strtotime($row['24-1-a-DOSTo']));   
            }
            $dataArray[$x]['dosfrom']       = $DOSFrom;
            $dataArray[$x]['dosto']         = $DOSTo;
            $dataArray[$x]['Units']         = $row['24-1-g-Units'];
            $dataArray[$x]['Charges']       = $row['24-1-f-Charges'];

            $x++;
            for ($i=2; $i<=6; $i++) {
                $DOSFromm = $DOSToo = '';
                if(!empty($row['24-'.$i.'-a-DOSFrom'])) {
                    $DOSFromm = date('m-d-Y', strtotime($row['24-'.$i.'-a-DOSFrom']));   
                }
                if(!empty($row['24-'.$i.'-a-DOSTo'])) {
                    $DOSToo = date('m-d-Y', strtotime($row['24-'.$i.'-a-DOSTo']));   
                }
                $dataArray[$x]['clinic_name']   = '';
                $dataArray[$x]['patient_name']  = '';
                $dataArray[$x]['patient_dob']   = '';
                $dataArray[$x]['dosfrom']       = $DOSFromm;
                $dataArray[$x]['dosto']         = $DOSToo;
                $dataArray[$x]['Units']         = $row['24-'.$i.'-g-Units'];
                $dataArray[$x]['Charges']       = $row['24-'.$i.'-f-Charges'];
                $x++;
            }

            /*$dataArray[$x]['clinic_name']  = '';
            $dataArray[$x]['patient_name'] = '';
            $dataArray[$x]['patient_dob']  = '';
            $dataArray[$x]['dosfrom']  = '';
            $dataArray[$x]['dosto']  = '';
            $dataArray[$x]['Units']  = '';
            $dataArray[$x]['Charges']  = '';*/
        }

        // file name for download
        $filename = "X12_DATA_" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        $row2 = 0;
        $arry = array(' ',' ',' ',' ');
        $columns = [];
        $columns['Clinic Name'] = '';
        $columns['Patient Name'] = '';
        $columns['Patient DOB'] = '';
        $columns['Dos From'] = '';
        $columns['Dos To'] = '';
        $columns['Units'] = '';
        $columns['Charges'] = '';

        foreach ($dataArray as $key => $row) {
            if(!$flag) {
            // display field/column names as first row
            array_walk($row, 'cleanData');

            echo implode("\t",$arry) . "\r\n";
            echo implode("\t", array_keys($columns)) . "\r\n";
            $flag = true;
            }
            array_walk($row, 'cleanData');
            $x = 1;
            echo implode("\t", array_values($row)) . "\r\n";
        }
    }

    public function deleteAll() {
        $sql = "DELETE FROM x12_data";
        set_custom_query_data($sql);
        $this->app->message('All records has been deleted successfully.', 'success');
        redirect($this->agent->referrer());
    }


    function x12835ToOriginal() {
        $message = 'err'; 
        if( $_FILES['file']['name'] != "" ) {
            $img_data                   =   [];
            $img_data['path']           =   'image/x12835';
            $img_data['file_name']      =   'file';
            $img_data['allowed_type']   =   '*';
            $img_data['old_file']       =   '';
            $img_data['width']          =   '';
            $img_data['height']         =   '';
            $img_data['quality']        =   '';
            $img_data['image_compress'] =   False;

            $img = $this->uploadfiles($img_data);

            //print_r($img);die;

            if(!empty($img['status']=='1')) {
                $filename   = $img['url'];
                $this->x12835Reader($filename);
                echo $message = 'Records has been extracted successfully.';
            }
        } 
    }

    public function x12835Upload() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'File Export';
            $agency  = $_POST['agency'];
            $data['agency']  = $agency;

            $cond = "";
            if(!empty($agency)) {
                $cond .= "AND `33-ClinicName` LIKE '%".$agency."%'";
            }

            $sql =  "SELECT * FROM claims.x12835_data WHERE 1 $cond";
            $data['extractData'] = $this->comman->getCustomQueryData($sql);

            if($checkView) {
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/x12835-view.php', $data);
                $this->load->view('common/footer-view.php');    
            }
        } else {
            redirect($this->agent->referrer());
        }
    }  


    function x12835Reader($filename) {
        $message    = 'err'; 
        //$filename   = 'file16638303353051.txt';
        $fileurl    = base_url('image/x12835').'/'.$filename;
        $myfile     = fopen($fileurl, "r") or die("Unable to open file!");
        $cntr       = 0;
        // Output one line until end-of-file
        $z = 0;        
        $patientData = [];

        $nmCheck = false; $wnCheck = false;
        $nmInsuranceCompanyName = '';
        $PatientAcctNo = '';
        $warrantNumber = '';
        $chargedAmount = '';
        $paidAmount = '';
        //$medicaidno = '';

        while(!feof($myfile)) {            

            $x = fgets($myfile);
            $pattern = "/N1/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                if($nameLine[1]=='PR') {
                    $z++;
                    $k = 0;
                    $i = 1;
                    $InsuranceCompanyName = trim(str_replace(array("~"), '', $nameLine[2]));
                    $patientData[$z]['"Insurance Company Name"'] = $InsuranceCompanyName;
                    $nmCheck = true;
                    $nmInsuranceCompanyName = $InsuranceCompanyName;
                }

                if($nameLine[1]=='PE') {
                    //$medicaidno = trim(str_replace(array("~"), '', $nameLine[4]));
                }                
            }

            $pattern = "/CLP/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                //if($nameLine[1]=='68024') {
                //if($nameLine[1]=='MCDIL') {
                    $warrantNumber = $nameLine[7];
                    $chargedAmount = $nameLine[3];
                    $paidAmount = $nameLine[4];
                    //$patientData[$z]['warrantNumber'] = $warrantNumber;
                    $wnCheck = true;
                //}
            }

            $pattern = "/TRN/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                $checkNumber = $nameLine[2];
            }

            $pattern = "/NM1/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);                
                if($nameLine[1]=='QC') {
                    if($nmCheck==false) {
                        $z++;
                        $patientData[$z]['"Insurance Company Name"'] = $nmInsuranceCompanyName;
                    }
                    $patientData[$z]['patient_name'] = $nameLine[3].', '.$nameLine[4];
                    $patientData[$z]['"26-PatientAcctNo"'] = $PatientAcctNo;
                    $patientData[$z]['warrantNumber'] = $warrantNumber;

                    $patientData[$z]['charged_amount'] = $chargedAmount;
                    $patientData[$z]['paid_amount'] = $paidAmount;

                    $patientData[$z]['checkNumber'] = $checkNumber;

                    $medicaidno = trim(str_replace(array("~"), '', $nameLine[9]));
                    $patientData[$z]['medicaidno'] = $medicaidno;

                    $sd = 0;
                    $am = 0;
                }
                if($nameLine[1]=='82') {                    
                    $ClinicName = trim(str_replace(array("~"), '', $nameLine[3]));
                    $patientData[$z]['"33-ClinicName"'] = $ClinicName;
                    $i++;$k++;
                    $nmCheck = false;
                }
            }            

            $pattern = "/REF/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                if($nameLine[1]=='2U') {
                    $PatientAcctNo = trim(str_replace(array("~"), '', $nameLine[2]));
                    $patientData[$z]['"26-PatientAcctNo"'] = $PatientAcctNo;
                }
            }

            $pattern = "/AMT/i";
            if(preg_match($pattern, $x)) {
                //$x = fgets($myfile);
                $nameLine = explode('*', $x);
                if($nameLine[1]=='B6') {
                    $amount = trim(str_replace(array("~"), '', $nameLine[2]));
                    $patientData[$z]['amount'][$am] = $amount;
                    $am++;
                }
            }

            $pattern = "/DTM/i";
            if(preg_match($pattern, $x)) {
                $nameLine = explode('*', $x);
                if($nameLine[1]=='472') {
                    $serviceDate = trim(str_replace(array("~"), '', $nameLine[2]));
                    $patientData[$z]['serviceDate'][$sd] = date('m/d/Y', strtotime($serviceDate));
                    $sd++;
                }
            }

            
        }

        /*foreach ($patientData as $key => $row) {
            print_r($row['patient_name'].'=='.$row['"33-ClinicName"']);
            echo '<br>';
        }

        die;

        print_r($patientData);die;*/
        

        if(!empty($patientData)) {
            foreach ($patientData as $key => $row) {
                $dataArray = [];
                $dataArray['33-ClinicName'] = $row['"33-ClinicName"'];
                $dataArray['patient_name'] = $row['patient_name'];
                $dataArray['Insurance_Company_Name'] = $row['"Insurance Company Name"'];

                $dataArray['26-PatientAcctNo'] = $row['"26-PatientAcctNo"'];
                $dataArray['warrant_number'] = $row['warrantNumber']!=''?$row['warrantNumber']:'';

                $dataArray['charged_amount'] = $row['charged_amount']!=''?$row['charged_amount']:'';
                $dataArray['paid_amount'] = $row['paid_amount']!=''?$row['paid_amount']:'';

                $dataArray['check_number'] = $row['checkNumber']!=''?$row['checkNumber']:'';
                $dataArray['medicaidno'] = $row['medicaidno']!=''?$row['medicaidno']:'';
                //$dataArray['amount'] = $row['amount'];
                if(!empty($row['amount'])) {
                    $dataArray['amount'] = implode(',', $row['amount']);    
                } else {
                    $dataArray['amount'] = '';
                }
                
                if(!empty($row['serviceDate'])) {
                    $dataArray['service_date'] = implode(',', $row['serviceDate']);    
                } else {
                    $dataArray['service_date'] = '';    
                }                

                $insertCHeck = true;

                if(!empty($row['data'])) {
                    $i = 1; $j = 1;
                    foreach ($row['data'] as $key1 => $row1) {
                        // code...
                        if($i<=6) {
                            //$dataArray['24-'.$i.'-f-Charges'] = $row1['"24.'.$j.'.f-Charges"'];
                            //$dataArray['24-'.$i.'-g-Units'] = $row1['"24.'.$j.'.g-Units"'];
                            //$dataArray['24-'.$i.'-b-Place'] = $row1['"24.'.$j.'.b-Place"'];
                            //$dataArray['24-'.$i.'-e-Code'] = $row1['"24.'.$j.'.e-Code"'];
                            //$dataArray['24-'.$i.'-a-DOSFrom'] = $row1['"24.'.$j.'.a-DOSFrom"'];
                            //$dataArray['24-'.$i.'-a-DOSTo'] = $row1['"24.'.$j.'.a-DOSTo"'];
                            //$dataArray['24-'.$i.'-SrvComment'] = $row1['"24.'.$j.'.SrvComment"'];
                            //if($i==6) {
                                //$this->comman->insert('x12835_data', $dataArray);         
                                //$insertCHeck = false;
                                //$i = 0;
                            //}
                        }
                        $i++; $j++;                  
                    }
                }
                if($insertCHeck) {
                    $this->comman->insert('claims.x12835_data', $dataArray);    
                    $updateTable = true;
                    /*
                    if(!empty($row['serviceDate']) && !empty($row['amount']) && !empty($row['medicaidno']) && $updateTable) {
                        $psql = "SELECT patient_id FROM patient WHERE med_medicaidno = '".$row['medicaidno']."'";
                        $prow = $this->comman->getCustomQueryData($psql, 'row');
                        foreach ($row['serviceDate'] as $skey => $sDate) {
                            if(!empty($prow['patient_id'])) {
                                $amount = $row['amount'][$skey];
                                $sDate = date('Y-m-d', strtotime($sDate));
                                $esql = "SELECT * FROM eclaims_details_test WHERE amount = '".$amount."' AND date = '".$sDate."' AND patient_id = '".$prow['patient_id']."'";
                                $erow = $this->comman->getCustomQueryData($esql, 'row');
                                if(!empty($erow['cms1500_details_id'])) {
                                    //echo $erow['cms1500_details_id'];
                                    //echo '<br>';
                                    $updateArray = [];
                                    $updateArray['paid'] = 1;
                                    //$updateArray['paid_amount']  = $amount;

                                    $where = [];
                                    $where['cms1500_details_id'] = $erow['cms1500_details_id'];
                                    $this->comman->update('eclaims_details_test', $where, $updateArray);

                                    $insertArray = [];
                                    $insertArray['paid_amount']  = $amount;
                                    $insertArray['cms1500_details_id'] = $erow['cms1500_details_id'];
                                    $this->comman->insert('eclaims_paid_amount', $insertArray);

                                }

                                $ltsql = "SELECT * FROM eclaims_detailsLTS_test WHERE amount = '".$amount."' AND date = '".$sDate."' AND patient_id = '".$prow['patient_id']."'";
                                $lrow = $this->comman->getCustomQueryData($ltsql, 'row');
                                if(!empty($lrow['cms1500_details_id'])) {
                                    //echo $lrow['cms1500_details_id'];
                                    //echo '<br>';
                                    $updateLTSArray = [];
                                    $updateLTSArray['paid'] = 1;
                                    //$updateLTSArray['paid_amount']  = $amount;

                                    $where = [];
                                    $where['cms1500_details_id'] = $lrow['cms1500_details_id'];
                                    $this->comman->update('eclaims_detailsLTS_test', $where, $updateLTSArray);

                                    $insertArray = [];
                                    $insertArray['paid_amount']  = $amount;
                                    $insertArray['cms1500_details_id'] = $lrow['cms1500_details_id'];
                                    $this->comman->insert('eclaims_paid_amount', $insertArray);
                                }
                            }
                        }
                    }
                    */
                }
            }
        }
        fclose($myfile);
    }

    public function deleteAllX12835() {
        $sql = "DELETE FROM claims.x12835_data";
        set_custom_query_data($sql);
        $this->app->message('All records has been deleted successfully.', 'success');
        redirect($this->agent->referrer());
    }

    public function portalPayHistory() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'File Export';

            if(!empty($_POST['ftimestamp'])) {
                $timestamp = date('Y-m-d h:i:s', strtotime($_POST['ftimestamp']));
                $cond = " WHERE timestamp = '".$timestamp."'";
                $data['ftimestamp'] = $timestamp;
            } else {
                $timestamp = date('Y-m-d h:i:s');
                $cond = " WHERE timestamp = '".$timestamp."'";
                $data['ftimestamp'] = date('Y-m-d h:i:s');
            }

            if(!empty($_POST['batchid'])) {
                $batchid = $_POST['batchid'];
                $cond = " WHERE batch_id = '".$batchid."'";
                $data['batchid'] = $batchid;
            } else {
                $batchid = date('mdY').'PH';
                $cond = " WHERE batch_id = '".$batchid."'";
                $data['batchid'] = $batchid;
            }

            $sql = "SELECT * FROM portal_pay_history ".$cond." ORDER BY id DESC";
            $userportalpayvalidated = $this->session->userdata('userportalpayvalidated');
            $data['portalPayData'] = [];
            $data['userportalpayvalidated'] = 0;
            if($userportalpayvalidated==1) {
                $data['portalPayData'] = $this->comman->getCustomQueryData($sql);    
                $data['userportalpayvalidated'] = $userportalpayvalidated;
            }

            //print_r($data['userportalpayvalidated']);die;

            if($checkView) {
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/view-portal-pay-history.php', $data);
                $this->load->view('common/footer-view.php');    
            }
        } else {
            redirect($this->agent->referrer());
        }
    } 

    public function getAuthenticatedForPortalPayHistory() {
        $postData = $this->input->post();
        if(!empty($postData['password'])) {
            $where = [];
            //$where['name'] = $postData['userName'];
            $where['user_id'] = $this->session->userdata('id');
            $where['password'] = md5($postData['password']);
            //$where['find_in_set("A",userlevel)<>'] = 0;
            //$where['find_in_set("P",userlevel)<>'] = 0;
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            //$whereOr['find_in_set("A",userlevel)<>'] = 0;
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);
            //if($check && (checkUserLevel('P', $this->session->userdata('userlevel')) || checkUserLevel('A', $this->session->userdata('userlevel')))) {
            if($check) {
                $this->session->set_userdata('userportalpayvalidated', '1');
                echo 1;
            } else {
                $this->session->unset_userdata('userportalpayvalidated');
                echo 0;
            }
        }
    }

    public function updatePortalPayHistory() {
      $message = 'err'; 
      if( $_FILES['file']['name'] != "" ) {
        $img_data   =   [];
        $img_data['path']   =   'image/portal_pay_history';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $filename = $img['url'];
            $fileurl = base_url('image/portal_pay_history').'/'.$filename;
            //$data = $this->db->empty_table('temp_clock');
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            $z = 0;
            while(!feof($myfile)) {
                $x = fgets($myfile);
                $cntr++;
                //$strtemp = explode(',',$x);   
                $strtemp = str_getcsv($x, ",", "");
                /*if ($cntr == 5 && $x != '') {
                    print_r($strtemp);
                }*/               
                if ($cntr > 1 && $x != '') {
                    if(!empty($strtemp[0]) && !empty($strtemp[1])) {
                        $dataArray = [];
                        $dataArray['batch_id'] = date('mdY').'PH';
                        $dataArray['employee_name'] = $strtemp[0];
                        $dataArray['company_code'] = $strtemp[1];
                        $dataArray['adp'] = $strtemp[2];
                        $dataArray['check_voucher'] = $strtemp[3];
                        $dataArray['pay_date'] = date('Y-m-d', strtotime($strtemp[4]));
                        $netPay = 0;
                        if(!empty($strtemp[5])) {
                            $netPay = number_format($strtemp[5], 2);     
                        }                        
                        $dataArray['net_pay'] = $netPay;
                        $dataArray['home_department_code'] = $strtemp[6];
                        $dataArray['home_department_description'] = $strtemp[7];
                        $dataArray['regular_hours'] = $strtemp[8];
                        $dataArray['overtime_hours'] = $strtemp[9];
                        $dataArray['total_hours'] = $strtemp[10];
                        $grossPay = str_replace('US', '', str_replace('"', '', $strtemp[11]));
                        $grossPay = str_replace('$', '', str_replace('"', '', $grossPay));
                        //$grossPay = str_replace('(', '', str_replace('"', '', $grossPay));
                        //$grossPay = str_replace(')', '', str_replace('"', '', $grossPay));
                        $grossPay =  preg_replace("/[\xA0\xC2]/", "", $grossPay);
                        //$grossPay = str_replace(',', '', $grossPay);
                        //$grossPay = number_format($grossPay, 2);
                        $dataArray['gross_pay'] = $grossPay;
                        if($netPay<0) {
                            $dataArray['voided'] = '1';    
                        }
                        $dataArray['adp_location_code'] = $strtemp[12];
                        $dataArray['period_beginning_date'] = date('Y-m-d', strtotime($strtemp[13]));
                        $dataArray['cst'] = $strtemp[14];
                        $dataArray['ist'] = $strtemp[15];
                        $dataArray['atv'] = str_replace('$', '', str_replace('"', '', $strtemp[16]));
                        //print_r($dataArray);die;

                        $insertId = $this->comman->insert('portal_pay_history', $dataArray);
                        if(!empty($insertId)) {
                            $z++;
                        }
                    }
                }
            }
            $message = $z.' records has been added successfully.';
            fclose($myfile);
          }
      } 
      echo $message;
    }

    public function deleteAllPortalPayHistory() {
        if(!empty($_GET['timestamp'])) {
            $timestamp = date('Y-m-d h:i:s', strtotime($_GET['timestamp']));
            $sql = "DELETE FROM portal_pay_history WHERE timestamp = '".$timestamp."'";
            set_custom_query_data($sql);
            $this->app->message('All records with timestamp '.$timestamp.' has been deleted successfully.', 'success');
        } else {
            $this->app->message('Something went wrong. Try again.', 'success');
        }
        redirect($this->agent->referrer());
    }  

    public function deleteWellness() {
        $query = "DELETE FROM wellness_call";
        get_data_other_db($query, 'query', 'wellness');
        $this->app->message('All records with has been deleted successfully.', 'success');
        redirect($this->agent->referrer());
    }

    public function wellness() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'Wellness File Export';

            if($checkView) {
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/view-wellness.php', $data);
                $this->load->view('common/footer-view.php');    
            }
        } else {
            redirect($this->agent->referrer());
        }
    }    

    public function updateWellness() {
      $message = 'err'; 
      if( $_FILES['file']['name'] != "" ) {
        $img_data   =   [];
        $img_data['path']   =   'image/wellness';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $filename = $img['url'];
            $fileurl = base_url('image/wellness').'/'.$filename;
            //$data = $this->db->empty_table('temp_clock');
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            $z = 0;
            while(!feof($myfile)) {
                $x = fgetcsv($myfile);
                $cntr++;
                $strtemp = $x;
                if ($cntr > 1 && $x != '') {
                    if(!empty($strtemp[0]) && !empty($strtemp[1])) {
                        $Submission_Date = date('Y-m-d H:i:s', strtotime($strtemp[0]));
                        $Portal_ID = $strtemp[1];
                        $Issues = $strtemp[2];
                        $Notes = strip_tags($strtemp[3]);
                        $Notes = str_replace("'", "''", "$Notes");
                        $Representative = $strtemp[4];
                        $PCCS_ACTION_TAKEN = $strtemp[5];

                        $query = "INSERT INTO `wellness_call` (`Submission_Date`, `Portal_ID`, `Issues`, `Notes`, `Representative`, `PCCS_ACTION_TAKEN`) VALUES('$Submission_Date', '$Portal_ID', '$Issues', '$Notes', '$Representative', '$PCCS_ACTION_TAKEN')";
                        get_data_other_db($query, 'query', 'wellness');
                        $z++;                        
                    }
                }
            }
            $message = $z.' records has been added successfully.';
            fclose($myfile);
          }
      } 
      echo $message;
    }

    public function employeeHireddate() {
        if (isset($_SESSION['name'])) { 
            $checkView = true;
            $data['page']  = 'Employee Hired Date File Export';

            if($checkView) {
                $this->load->view('common/header.php');
                $this->load->view('common/sidebar.php', $data);
                $this->load->view('file-export/view-hireddate.php', $data);
                $this->load->view('common/footer-view.php');    
            }
        } else {
            redirect($this->agent->referrer());
        }
    }

    public function updateHireddate() {
      $message = 'err'; 
      if( $_FILES['file']['name'] != "" ) {
        $img_data   =   [];
        $img_data['path']   =   'image/wellness';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $filename = $img['url'];
            $fileurl = base_url('image/wellness').'/'.$filename;
            //$data = $this->db->empty_table('temp_clock');
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            $z = 0;
            while(!feof($myfile)) {
                //$x = fgetcsv($myfile);
                //$cntr++;
                //$strtemp = $x;

                $x = fgets($myfile);
                $cntr++;
                $strtemp = str_getcsv($x, ",", "");

                if ($cntr > 1 && $x != '') {                    
                    if(!empty($strtemp[0]) && !empty($strtemp[1])) {                        
                        $ssn = $strtemp[0];
                        $hiredDate = date('Y-m-d', strtotime($strtemp[1]));

                        $query = "UPDATE employee SET `HiredDate` = '$hiredDate' WHERE ssn = '$ssn'";
                        set_custom_query_data($query);
                        $z++;                        
                    }
                }
            }
            $message = $z.' records has been added successfully.';
            fclose($myfile);
          }
      } 
      echo $message;
    }

    public function updatePayments() {
      $message = 'err'; 
      if( $_FILES['file']['name'] != "" ) {
        $img_data   =   [];
        $img_data['path']   =   'image/payments';
        $img_data['file_name']  =   'file';
        $img_data['allowed_type']   =   '*';
        $img_data['old_file']   =   '';
        $img_data['width']  =   '';
        $img_data['height'] =   '';
        $img_data['quality']    =   '60%';
        $img_data['image_compress'] =   False;

        $img=$this->uploadfiles($img_data);

        if(!empty($img['status']=='1')) {
            $filename = $img['url'];
            $fileurl = base_url('image/payments').'/'.$filename;
            $myfile = fopen($fileurl, "r") or die("Unable to open file!");
            $cntr = 0;
            // Output one line until end-of-file
            $z = 0;
            while(!feof($myfile)) {

                $x = fgets($myfile);
                $cntr++;
                $strtemp = str_getcsv($x, ",", "");

                if ($cntr > 1 && $x != '') {                    
                    if(!empty($strtemp[0]) && !empty($strtemp[2])) {

                        $dataArray = [];
                        $dataArray['Payment_No'] = $strtemp[1];
                        $dataArray['Customer'] = $strtemp[2];
                        if(!empty($strtemp[3])) {
                            $dataArray['Payment_Date'] = date('Y-m-d', strtotime($strtemp[3]));
                        }                        
                        $dataArray['Payment_Method'] = $strtemp[4];
                        $dataArray['Check_No'] = $strtemp[5];
                        $dataArray['Invoice_No'] = $strtemp[6];
                        $dataArray['Amount'] = $strtemp[7];
                        $dataArray['Deposit_To_Account'] = $strtemp[8];
                        $dataArray['batch_id'] = date('Y-m-d');
                        $dataArray['status'] = 'add';

                        //print_r($dataArray);die;

                        $agency = $this->session->userdata('agency');

                        $insertCheck = false;

                        if($agency==1) {
                            $this->comman->insert('homemaker.payments', $dataArray);
                            $insertCheck = true;
                        }
                        if($agency==2 || $agency==4) {
                            $this->comman->insert('seniorcare.payments', $dataArray);
                            $insertCheck = true;
                        }
                        if($agency==3) {
                            $this->comman->insert('caregiver.payments', $dataArray);
                            $insertCheck = true;    
                        }                        
                        
                        if($insertCheck) {
                            $z++;    
                        }
                    }
                }
            }
            $message = $z.' records has been added successfully.';
            fclose($myfile);
          }
      } 
      echo $message;
    }
} 