<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Location extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model','comman');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->library('user_agent');
    }

    
    public function index() {
        if (isset($_SESSION['name'])) { 
            $data['page']  = 'Location';
            $data['locationData'] = $this->comman->get_rows('agency_location','','agency_location_id','desc');
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('location/view.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect($this->agent->referrer());
        }
    }  

    public function add() {
        if (isset($_SESSION['name'])) { 

            if( !empty( $this->input->post( 'submit' ) ) ){

                $this->form_validation->set_rules('location_code', 'Location Code', 'trim|required');
                $this->form_validation->set_rules('location_name', 'Location Name', 'trim|required');
                $this->form_validation->set_rules('agency_addr1', 'Agency Location Address', 'trim|required');
                $this->form_validation->set_rules('agency_phone', 'Agency Phone', 'trim|required');
                $this->form_validation->set_rules('agency_fax', 'Agency Fax', 'trim|required');
                $this->form_validation->set_rules('agency_zip', 'Agency Zip', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $dataArray                          = [];
                    $dataArray['agency_location_code']  = $this->input->post('location_code',true);
                    $dataArray['agency_location_name']  = $this->input->post('location_name',true);
                    $dataArray['agency_loc_addr1']      = $this->input->post('agency_addr1',true);
                    $dataArray['agency_loc_addr2']      = $this->input->post('agency_addr2',true);
                    $dataArray['agency_loc_phone']      = $this->input->post('agency_phone',true);
                    $dataArray['agency_loc_fax']        = $this->input->post('agency_fax',true);
                    $dataArray['agency_zipcode']        = $this->input->post('agency_zip',true);
                    $dataArray['QB_ClassRef_ListID']    = $this->input->post('QB_ClassRef_ListID',true);
                    $dataArray['regional_manager']      = $this->input->post('regionalManager',true);
                    $dataArray['branch_manager']        = $this->input->post('branchManager',true);
                    $dataArray['lead_supervisor']       = $this->input->post('leadSupervisor',true);
                    $dataArray['lead_supervisor2']      = $this->input->post('leadSupervisor2',true);
                    $dataArray['lead_supervisor3']      = $this->input->post('leadSupervisor3',true);
                    $dataArray['lead_supervisor4']      = $this->input->post('leadSupervisor4',true);
                    $dataArray['lead_supervisor5']      = $this->input->post('leadSupervisor5',true);
                    $dataArray['lead_supervisor6']      = $this->input->post('leadSupervisor6',true);
                    $dataArray['agency_geofence']       = $this->input->post('geofence',true);
                    $dataArray['adp_location_code']     = $this->input->post('adp_location_code',true);
                    $dataArray['leads_group_email']     = $this->input->post('leads_group_email',true);

                    $inserId = $this->comman->insert( "agency_location", $dataArray );

                    if ($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user added location id '.$inserId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('Location has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('location','refresh');
                }
            }

            $data['page'] = 'Add Agency Location';

            $sql = "SELECT * FROM users_portal WHERE FIND_IN_SET('B', userlevel)";
            $data['usersData'] = $this->comman->getCustomQueryData($sql);

            $sql = "SELECT * FROM users_portal WHERE FIND_IN_SET('L', userlevel)";
            $data['leadUsersData'] = $this->comman->getCustomQueryData($sql);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('location/add.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function edit($pageId='') {

        if (isset($_SESSION['name'])) { 

            if(!empty($pageId)){
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['agency_location_id'] = $pageId;
                $pageData   =   $this->comman->get_row('agency_location',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ){

                $this->form_validation->set_rules('location_code', 'Location Code', 'trim|required');
                $this->form_validation->set_rules('location_name', 'Location Name', 'trim|required');
                $this->form_validation->set_rules('agency_addr1', 'Agency Location Address', 'trim|required');
                $this->form_validation->set_rules('agency_phone', 'Agency Phone', 'trim|required');
                $this->form_validation->set_rules('agency_fax', 'Agency Fax', 'trim|required');
                $this->form_validation->set_rules('agency_zip', 'Agency Zip', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $dataArray                          = [];
                    $dataArray['agency_location_code']  = $this->input->post('location_code',true);
                    $dataArray['agency_location_name']  = $this->input->post('location_name',true);
                    $dataArray['agency_loc_addr1']      = $this->input->post('agency_addr1',true);
                    $dataArray['agency_loc_addr2']      = $this->input->post('agency_addr2',true);
                    $dataArray['agency_loc_phone']      = $this->input->post('agency_phone',true);
                    $dataArray['agency_loc_fax']        = $this->input->post('agency_fax',true);
                    $dataArray['agency_zipcode']        = $this->input->post('agency_zip',true);
                    $dataArray['QB_ClassRef_ListID']    = $this->input->post('QB_ClassRef_ListID',true);
                    $dataArray['regional_manager']      = $this->input->post('regionalManager',true);
                    $dataArray['branch_manager']        = $this->input->post('branchManager',true);
                    $dataArray['lead_supervisor']       = $this->input->post('leadSupervisor',true);
                    $dataArray['lead_supervisor2']      = $this->input->post('leadSupervisor2',true);
                    $dataArray['lead_supervisor3']      = $this->input->post('leadSupervisor3',true);
                    $dataArray['lead_supervisor4']      = $this->input->post('leadSupervisor4',true);
                    $dataArray['lead_supervisor5']      = $this->input->post('leadSupervisor5',true);
                    $dataArray['lead_supervisor6']      = $this->input->post('leadSupervisor6',true);
                    $dataArray['agency_geofence']       = $this->input->post('geofence',true);
                    $dataArray['adp_location_code']     = $this->input->post('adp_location_code',true);
                    $dataArray['leads_group_email']     = $this->input->post('leads_group_email',true);

                    $where              =   [];
                    $where['agency_location_id'] =   $pageId;

                    $updateId = $this->comman->update( "agency_location", $where, $dataArray );

                    if ($updateId) {

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated location id '.$pageId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('Location has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('location','refresh');
                }
            }

            $data['page'] = 'Update Agency Location';

            $sql = "SELECT * FROM users_portal WHERE FIND_IN_SET('B', userlevel)";
            $data['usersData'] = $this->comman->getCustomQueryData($sql);

            $sql = "SELECT * FROM users_portal WHERE FIND_IN_SET('L', userlevel)";
            $data['leadUsersData'] = $this->comman->getCustomQueryData($sql);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('location/edit.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }  

    public function delete($recordId){
        if(!empty($recordId)){
            $recordId       = decode64($recordId);
            $where          = [];
            $where['agency_location_id'] = $recordId;
            $check = $this->comman->delete_row('agency_location',$where);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted location id '.$recordId.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################


            $this->app->message('Location has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

} 