<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
defined('BASEPATH') OR exit('No direct script access allowed');
class Patient extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        //$this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Employee_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }

    public function getWeekdaySchedule() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id'])) {
            $where  =   [];
            $where['patient_id']    =   $postData['patient_id'];
            $where['employee_id']   =   $postData['employee_id'];
            $eaData = $this->Comman_model->get_row('employee_assignment', $where);
            $data = '';
            if(!empty($eaData)) {
                $mon0 = $tue0 = $wed0 = $thu0 = $fri0 = $sat0 = $sun0 = '';
                $mon1 = $tue1 = $wed1 = $thu1 = $fri1 = $sat1 = $sun1 = '';

                if($eaData['mon0']=='Mon'){
                    $mon0 = 'checked';
                }
                if($eaData['tue0']=='Tue'){
                    $tue0 = 'checked';
                }
                if($eaData['wed0']=='Wed'){
                    $wed0 = 'checked';
                }
                if($eaData['thu0']=='Thu'){
                    $thu0 = 'checked';
                }
                if($eaData['fri0']=='Fri'){
                    $fri0 = 'checked';
                }
                if($eaData['sat0']=='Sat'){
                    $sat0 = 'checked';
                }
                if($eaData['sun0']=='Sun'){
                    $sun0 = 'checked';
                }

                if(!empty($eaData['mon'])){
                    $mon1 = $eaData['mon'];
                }
                if(!empty($eaData['tue'])){
                    $tue1 = $eaData['tue'];
                }
                if(!empty($eaData['wed'])){
                    $wed1 = $eaData['wed'];
                }
                if(!empty($eaData['thu'])){
                    $thu1 = $eaData['thu'];
                }
                if(!empty($eaData['fri'])){
                    $fri1 = $eaData['fri'];
                }
                if(!empty($eaData['sat'])){
                    $sat1 = $eaData['sat'];
                }
                if(!empty($eaData['sun'])){
                    $sun1 = $eaData['sun'];
                }


            }
            $data = '<div class="row">
                    <div class="col-md-4">
                      <div class="checkbox checkbox-info text-center">
                        <input type="hidden" name="employee_id" value="'.$postData['employee_id'].'">
                        <input type="hidden" name="patient_id" value="'.$postData['patient_id'].'">
                        <input type="checkbox" name="mon0" id="mon0" value="Mon" '.$mon0.'>
                        <label for="mon0"></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                        <h5 class="text-center">Mon</h5>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center">
                        <input type="text" class="form-control" id="mon1" name="mon1" value="'.$mon1.'"> 
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <div class="checkbox checkbox-info text-center">
                        <input type="checkbox" name="tue0" id="tue0" value="Tue" '.$tue0.'>
                        <label for="tue0"></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                        <h5 class="text-center">Tue</h5>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center">
                        <input type="text" class="form-control" id="tue1" name="tue1" value="'.$tue1.'"> 
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <div class="checkbox checkbox-info text-center">
                        <input type="checkbox" name="wed0" id="wed0" value="Wed" '.$wed0.'>
                        <label for="wed0"></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                       <h5 class="text-center">Wed</h5>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center">
                        <input type="text" class="form-control" id="wed1" name="wed1" value="'.$wed1.'"> 
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <div class="checkbox checkbox-info text-center">
                        <input type="checkbox" name="thu0" id="thu0" value="Thu" '.$thu0.'>
                        <label for="thu0"></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                       <h5 class="text-center">Thu</h5>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center">
                        <input type="text" class="form-control" id="thu1" name="thu1" value="'.$thu1.'"> 
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <div class="checkbox checkbox-info text-center">
                        <input type="checkbox" name="fri0" id="fri0" value="Fri" '.$fri0.'>
                        <label for="fri0"></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                       <h5 class="text-center">Fri</h5>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center">
                        <input type="text" class="form-control" id="fri1" name="fri1" value="'.$fri1.'"> 
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <div class="checkbox checkbox-info text-center">
                        <input type="checkbox" name="sat0" id="sat0" value="Sat" '.$sat0.'>
                        <label for="sat0"></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                       <h5 class="text-center">Sat</h5>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center">
                        <input type="text" class="form-control" id="sat1" name="sat1" value="'.$sat1.'"> 
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <div class="checkbox checkbox-info text-center">
                        <input type="checkbox" name="sun0" id="sun0" value="Sun" '.$sun0.'>
                        <label for="sat0"></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                       <h5 class="text-center">Sun</h5>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center">
                        <input type="text" class="form-control" id="sun1" name="sun1" value="'.$sun1.'"> 
                      </div>
                    </div>
                  </div>';

                  print_r($data);
            
        }
    }

    function getPatientTasks() {
        $postData   =   $this->input->post();
        if(!empty($postData['ptid'])) {

            $ptSql = "SELECT tasks FROM patient WHERE patient_id='".$postData['ptid']."'";
            $ptResult = get_custom_query_data($ptSql, 'row');

            $task = [];
            if(!empty(@$ptResult['tasks'])){
                $task = explode(',', $ptResult['tasks']);
            }

            $where = [];
            $employeeTaskData = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $options = '<div class="col-md-6 task"><div class="form-group"><label>Task<span class="text-danger">*</span></label><select class="form-control" name="task[]" required multiple="multiple"><option value="">Select</option><option value="99">No Task</option>';
            foreach ($employeeTaskData as $key => $row) {
                if(in_array($row['task_code'], $task)) {
                    $options .= '<option value="'.$row['task_code'].'">'.$row['task_name'].'</option>';
                }
            }
            $options .= '</select><div class="help-block with-errors"></div></div></div>';
            print_r($options);
        }
    }

    public function setWeekdaySchedule() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id']) && !empty($postData['patient_id'])) {
            $dataArray  =   [];
            $dataArray['mon']   =   @$postData['mon1'];
            $dataArray['tue']   =   @$postData['tue1'];
            $dataArray['wed']   =   @$postData['wed1'];
            $dataArray['thu']   =   @$postData['thu1'];
            $dataArray['fri']   =   @$postData['fri1'];
            $dataArray['sat']   =   @$postData['sat1'];
            $dataArray['sun']   =   @$postData['sun1'];
            $dataArray['mon0']  =   @$postData['mon0'];
            $dataArray['tue0']  =   @$postData['tue0'];
            $dataArray['wed0']  =   @$postData['wed0'];
            $dataArray['thu0']  =   @$postData['thu0'];
            $dataArray['fri0']  =   @$postData['fri0'];
            $dataArray['sat0']  =   @$postData['sat0'];
            $dataArray['sun0']  =   @$postData['sun0'];

            $where  =   [];
            $where['employee_id']   =   $postData['employee_id'];
            $where['patient_id']   =   $postData['patient_id'];

            $this->Comman_model->update('employee_assignment', $where, $dataArray);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
              $dataArray = [];
              $dataArray['user_id'] = $this->session->userdata('id');
              $dataArray['username'] = $this->session->userdata('name');
              $dataArray['user_action'] = $this->session->userdata('name'). ' user Weekday Schedule has been updated to employee id '.$postData['employee_id'].' from client id '.$postData['patient_id'].' at '. date('m/d/Y H:i:s');
              $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################

            echo 1;
        }
    }

    public function testDate() {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
        //error_reporting(E_ALL);

        $date = "2020-11-11 23:45:52";
        echo DateTime::createFromFormat('d-m-Y H:i:s', $date)->format('m/d/Y h:i:s'); 

        //$date = "10.06.2015 09:25:52";
        //echo DateTime::createFromFormat('d.m.Y H:i:s', $date)->format('Y-m-d h:i:s');


        $date = "2020-11-11 23:45:52";
        $format = "m/d/Y h:i:s";
        echo $date = DateTime::createFromFormat($format, $date)->format($format);
        //echo $date->format($format);
    }

    function getEmployeeComplianceReport() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id'])) {
            $where = [];
            $where['employee_id'] = $postData['employee_id'];
            $empData = $this->Comman_model->get_row('employee', $where);
            if(!empty($empData['compliance'])) {
                $compliance = explode(',', $empData['compliance']);
                $where1 = [];
                $complianceData = $this->Comman_model->countrow('employee_compliance', $where1);
                if(count($compliance)==$complianceData) {
                    print_r(0);
                } else{
                    print_r(1);
                }
            } else {
                print_r(1);
            }
        } else {
            print_r(1);
        }
    }

    public function getDayLimit() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id']) && !empty($postData['patient_id'])) {

            $recno = $postData['patient_id'];
            $employee_id = $postData['employee_id'];
            $fillin = $postData['fillin'];
            $shift2 = $postData['shift2'];

            $fillInSelected = $shift2Selected = '';
            if($fillin==1) {
              $fillInSelected = 'selected="selected"';
            }
            if($shift2==2) {
              $shift2Selected = 'selected="selected"';
            }

            $where = [];
            $where['patient_id'] = $postData['patient_id'];
            $where['employee_id'] = $postData['employee_id'];
            $row1 = $this->Comman_model->get_row('employee_assignment', $where);
            //echo $sql1;
            if (!empty($row1))  {
                if ($row1["mon_limit"] != 0 )  {  $status1="checked"; }  else  { $status1=""; }
                if ($row1["tue_limit"] != 0 )  {  $status2="checked"; }  else  { $status2=""; }
                if ($row1["wed_limit"] != 0 )  {  $status3="checked"; }  else  { $status3=""; }
                if ($row1["thu_limit"] != 0 )  {  $status4="checked"; }  else  { $status4=""; }
                if ($row1["fri_limit"] != 0 )  {  $status5="checked"; }  else  { $status5=""; }
                if ($row1["sat_limit"] != 0 )  {  $status6="checked"; }  else  { $status6=""; }
                if ($row1["sun_limit"] != 0 )  {  $status7="checked"; }  else  { $status7=""; }

                if ($row1["mon_limit1"] != 0 )  {  $status11="checked"; }  else  { $status11=""; }
                if ($row1["tue_limit1"] != 0 )  {  $status21="checked"; }  else  { $status21=""; }
                if ($row1["wed_limit1"] != 0 )  {  $status31="checked"; }  else  { $status31=""; }
                if ($row1["thu_limit1"] != 0 )  {  $status41="checked"; }  else  { $status41=""; }
                if ($row1["fri_limit1"] != 0 )  {  $status51="checked"; }  else  { $status51=""; }
                if ($row1["sat_limit1"] != 0 )  {  $status61="checked"; }  else  { $status61=""; }
                if ($row1["sun_limit1"] != 0 )  {  $status71="checked"; }  else  { $status71=""; }

                if ($row1["mon_limit2"] != 0 )  {  $status12="checked"; }  else  { $status12=""; }
                if ($row1["tue_limit2"] != 0 )  {  $status22="checked"; }  else  { $status22=""; }
                if ($row1["wed_limit2"] != 0 )  {  $status32="checked"; }  else  { $status32=""; }
                if ($row1["thu_limit2"] != 0 )  {  $status42="checked"; }  else  { $status42=""; }
                if ($row1["fri_limit2"] != 0 )  {  $status52="checked"; }  else  { $status52=""; }
                if ($row1["sat_limit2"] != 0 )  {  $status62="checked"; }  else  { $status62=""; }
                if ($row1["sun_limit2"] != 0 )  {  $status72="checked"; }  else  { $status72=""; }

                if ($row1["sup_signature"] == 1 )  {  $status73="checked"; }  else  { $status73=""; }
            }

            $where = [];
            $where['patient_id'] = $postData['patient_id'];
            $row = $this->Comman_model->get_row('patient', $where);

            $total_limit = 0; 
            if ($status1 != '' )  {
                $total_limit = $total_limit + $row1["mon_limit"];
            }
             if ($status2 != '' )  {
                $total_limit = $total_limit + $row1["tue_limit"];
            }

             if ($status3 != '' )  {
                $total_limit = $total_limit + $row1["wed_limit"];
            }

             if ($status4 != '' )  {
                $total_limit = $total_limit + $row1["thu_limit"];
            }

             if ($status5 != '' )  {
                $total_limit = $total_limit + $row1["fri_limit"];
            }

             if ($status6 != '' )  {
                $total_limit = $total_limit + $row1["sat_limit"];
            }

            if ($status7 != '' )  {
                $total_limit = $total_limit + $row1["sun_limit"];
            }


            if ($status11 != '' )  {
                $total_limit = $total_limit + $row1["mon_limit1"];
            }
             if ($status21 != '' )  {
                $total_limit = $total_limit + $row1["tue_limit1"];
            }

             if ($status31 != '' )  {
                $total_limit = $total_limit + $row1["wed_limit1"];
            }

             if ($status41 != '' )  {
                $total_limit = $total_limit + $row1["thu_limit1"];
            }

             if ($status51 != '' )  {
                $total_limit = $total_limit + $row1["fri_limit1"];
            }

             if ($status61 != '' )  {
                $total_limit = $total_limit + $row1["sat_limit1"];
            }

            if ($status71 != '' )  {
                $total_limit = $total_limit + $row1["sun_limit1"];
            }

            if ($status12 != '' )  {
                $total_limit = $total_limit + $row1["mon_limit2"];
            }
             if ($status22 != '' )  {
                $total_limit = $total_limit + $row1["tue_limit2"];
            }

             if ($status32 != '' )  {
                $total_limit = $total_limit + $row1["wed_limit2"];
            }

             if ($status42 != '' )  {
                $total_limit = $total_limit + $row1["thu_limit2"];
            }

             if ($status52 != '' )  {
                $total_limit = $total_limit + $row1["fri_limit2"];
            }

             if ($status62 != '' )  {
                $total_limit = $total_limit + $row1["sat_limit2"];
            }

            if ($status72 != '' )  {
                $total_limit = $total_limit + $row1["sun_limit2"];
            }


            $where = [];
            $where['employee_id'] = $postData['employee_id'];
            $empData = $this->Comman_model->get_row('employee', $where);
            $emplname = $empData['lastname'].', '.$empData['firstname'];

            if(!empty($row1["start_date"])) {
              $start_date = convertDate($row1["start_date"], 'm-d-Y');
            }

            $data = '<div class="modal-header" style="background-color: #2B89F3;">
                      <h4 class="modal-title text-center" id="day-limit-title">'.$emplname.' Daily Limit</h4>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                    <div class="row">
                      <div class="col-md-6">
                        <label>Schedule Dates</label>
                        <div class="checkbox checkbox-info">
                          <input type="checkbox" name="mon" id="mon" value="'.$row["mon_limit"].'" '.$status1.'>
                          <label for="mon">Mon &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["mon_limit"].'</label>
                        </div>

                        <div class="checkbox checkbox-info">
                          <input type="checkbox" name="tue" id="tue" value="'.$row["tue_limit"].'" '.$status2.'>
                          <label for="tue">Tue &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["tue_limit"].'</label>
                        </div>

                        <div class="checkbox checkbox-info">
                          <input type="checkbox" name="wed" id="wed" value="'.$row["wed_limit"].'" '.$status3.'>
                          <label for="wed">Wed &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["wed_limit"].'</label>
                        </div>

                        <div class="checkbox checkbox-info">
                          <input type="checkbox" name="thu" id="thu" value="'.$row["thu_limit"].'" '.$status4.'>
                          <label for="thu">Thu &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["thu_limit"].'</label>
                        </div>

                        <div class="checkbox checkbox-info">
                          <input type="checkbox" name="fri" id="fri" value="'.$row["fri_limit"].'" '.$status5.'>
                          <label for="fri">Fri &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["fri_limit"].'</label>
                        </div>

                        <div class="checkbox checkbox-info">
                          <input type="checkbox" name="sat" id="sat" value="'.$row["sat_limit"].'" '.$status6.'>
                          <label for="sat">Sat &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["sat_limit"].'</label>
                        </div>

                        <div class="checkbox checkbox-info">
                          <input type="checkbox" name="sun" id="sun" value="'.$row["sun_limit"].'" '.$status7.'>
                          <label for="sun">Sun &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["sun_limit"].'</label>
                        </div>

                        <div class="row">
                          <div class="col-md-12" style="display:flex;">
                            <label for="daysperweek" style="margin-top: 7px;margin-right: 10px;margin-bottom: 25px;">Days per Week</label>
                            <input type="text" class="form-control" name="daysperweek" id="daysperweek" value="'.$row1["daysperweek"].'" style="width: 50px;">
                          </div>
                        </div>

                        <div class="row">
                          <div class="form-group col-md-6">
                            <label for="emp_from_time">Start Time</label>
                            <input type="text" class="form-control" name="emp_from_time" id="emp_from_time" value="'.$row1["from_time"].'">
                          </div>

                          <div class="form-group col-md-6">
                            <label for="emp_to_time">End Time</label>
                            <input type="text" class="form-control" name="emp_to_time" id="emp_to_time" value="'.$row1["to_time"].'">
                          </div>
                        </div>
                      </div>
                      <div class="col-md-6">

                        <div class="row">
                            <div class="col-md-6">
                                <label>POC Type</label>
                                <div class="form-group">
                                  <select class="form-control" name="hoursType" id="hoursType" style="width:max-content;" onchange="showSecondHours(this.value);">
                                    <option value="0">Permanent</option>
                                    <option value="1" '.$fillInSelected.'>Fill-Ins</option>
                                    <option value="2" '.$shift2Selected.'>Shift-2</option>
                                  </select>
                                </div>
                            </div>';
                        if(checkUserLevel('P', $this->session->userdata('userlevel')) || checkUserLevel('A', $this->session->userdata('userlevel'))) {    
                            $data .= '<div class="col-md-6">
                                        <label>Temp Rate</label>
                                        <div class="form-group">                                    
                                          <input type="text" class="form-control" name="tempRate" id="tempRate" value="'.$row1['temp_rate'].'">
                                        </div>
                                    </div>';
                        }
                        $data .= '</div>

                        <div class="checkbox checkbox-info second-hour">
                          <input type="checkbox" name="mon1" id="mon1" value="'.$row["mon_limit1"].'" '.$status11.'>
                          <label for="mon1">Mon &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["mon_limit1"].'</label>
                        </div>
                        <div class="checkbox checkbox-info second-hour">
                          <input type="checkbox" name="tue1" id="tue1" value="'.$row["tue_limit1"].'" '.$status21.'>
                          <label for="tue1">Tue &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["tue_limit1"].'</label>
                        </div>
                        <div class="checkbox checkbox-info second-hour">
                          <input type="checkbox" name="wed1" id="wed1" value="'.$row["wed_limit1"].'" '.$status31.'>
                          <label for="wed1">Wed &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["wed_limit1"].'</label>
                        </div>
                        <div class="checkbox checkbox-info second-hour">
                          <input type="checkbox" name="thu1" id="thu1" value="'.$row["thu_limit1"].'" '.$status41.'>
                          <label for="thu1">Thu &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["thu_limit1"].'</label>
                        </div>
                        <div class="checkbox checkbox-info second-hour">
                          <input type="checkbox" name="fri1" id="fri1" value="'.$row["fri_limit1"].'" '.$status51.'>
                          <label for="fri1">Fri &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["fri_limit1"].'</label>
                        </div>
                        <div class="checkbox checkbox-info second-hour">
                          <input type="checkbox" name="sat1" id="sat1" value="'.$row["sat_limit1"].'" '.$status61.'>
                          <label for="sat1">Sat &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["sat_limit1"].'</label>
                        </div>
                        <div class="checkbox checkbox-info second-hour" style="margin-bottom:23px;">
                          <input type="checkbox" name="sun1" id="sun1" value="'.$row["sun_limit1"].'" '.$status71.'>
                          <label for="sun1">Sun &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["sun_limit1"].'</label>
                        </div>
                        <div class="row second-hour">
                          <div class="form-group col-md-6">
                            <label for="emp_from_time1">Start Time</label>
                            <input type="text" class="form-control" name="emp_from_time1" id="emp_from_time1" value="'.$row1["from_time1"].'">
                          </div>

                          <div class="form-group col-md-6">
                            <label for="emp_to_time1">End Time</label>
                            <input type="text" class="form-control" name="emp_to_time1" id="emp_to_time1" value="'.$row1["to_time1"].'">
                          </div>
                        </div>


                        <div class="checkbox checkbox-info shift-hour">
                          <input type="checkbox" name="mon2" id="mon2" value="'.$row["mon_limit2"].'" '.$status12.'>
                          <label for="mon2">Mon &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["mon_limit2"].'</label>
                        </div>
                        <div class="checkbox checkbox-info shift-hour">
                          <input type="checkbox" name="tue2" id="tue2" value="'.$row["tue_limit2"].'" '.$status22.'>
                          <label for="tue2">Tue &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["tue_limit2"].'</label>
                        </div>
                        <div class="checkbox checkbox-info shift-hour">
                          <input type="checkbox" name="wed2" id="wed2" value="'.$row["wed_limit2"].'" '.$status32.'>
                          <label for="wed2">Wed &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["wed_limit2"].'</label>
                        </div>
                        <div class="checkbox checkbox-info shift-hour">
                          <input type="checkbox" name="thu2" id="thu2" value="'.$row["thu_limit2"].'" '.$status42.'>
                          <label for="thu2">Thu &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["thu_limit2"].'</label>
                        </div>
                        <div class="checkbox checkbox-info shift-hour">
                          <input type="checkbox" name="fri2" id="fri2" value="'.$row["fri_limit2"].'" '.$status52.'>
                          <label for="fri2">Fri &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["fri_limit2"].'</label>
                        </div>
                        <div class="checkbox checkbox-info shift-hour">
                          <input type="checkbox" name="sat2" id="sat2" value="'.$row["sat_limit2"].'" '.$status62.'>
                          <label for="sat2">Sat &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["sat_limit2"].'</label>
                        </div>
                        <div class="checkbox checkbox-info shift-hour" style="margin-bottom:23px;">
                          <input type="checkbox" name="sun2" id="sun2" value="'.$row["sun_limit2"].'" '.$status72.'>
                          <label for="sun2">Sun &nbsp;&nbsp;&nbsp;&nbsp; Hours: '. $row["sun_limit2"].'</label>
                        </div>
                        <div class="row shift-hour">
                          <div class="form-group col-md-6">
                            <label for="emp_from_time2">Start Time</label>
                            <input type="text" class="form-control" name="emp_from_time2" id="emp_from_time2" value="'.$row1["from_time2"].'">
                          </div>

                          <div class="form-group col-md-6">
                            <label for="emp_to_time2">End Time</label>
                            <input type="text" class="form-control" name="emp_to_time2" id="emp_to_time2" value="'.$row1["to_time2"].'">
                          </div>
                        </div>

                      </div>
                      </div>


                      <input type="hidden" name="recno" maxlength="100" value="'.$recno.'"  hidden="true" />     
                      <input type="hidden" name="employee_id" maxlength="100" value="'.$employee_id.'" hidden="true"/>

                      <div class="row">
                        <div class="form-group col-md-6">
                          <h6 style="font-weight:500;margin-top: 13px;">TOTAL APPROVED HOURS: '.$total_limit.'</h6>
                        </div>

                        <div class="form-group col-md-6" style="display: flex;">
                          <label for="startDate" style="width: 50%;margin-top: 8px;">Start Date</label>
                            <input type="text" class="form-control startdate-picker" name="startDate" id="startDate" value="'.$start_date.'" readonly="readonly">
                        </div>

                      </div>

                      <div class="checkbox checkbox-info">
                        <input type="checkbox" name="supSignature" id="supSignature" value="1" '.$status73.'>
                        <label for="supSignature">Supervisor Signature</label>
                      </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" name="formSubmit" id="saveAndPrint" value="Submit" class="btn btn-primary">Save & Print POC</button>
                    </div>';
                print_r($data);
        }
    }

    public function setDayLimit() {
        $postData   =   $this->input->post();

        if (!empty($postData['formSubmit']) && $postData["formSubmit"] == "Submit" )  {

            $dataArray = [];
            $dataArray['mon_limit'] = $postData['mon'];
            $dataArray['tue_limit'] = $postData['tue'];
            $dataArray['wed_limit'] = $postData['wed'];
            $dataArray['thu_limit'] = $postData['thu'];
            $dataArray['fri_limit'] = $postData['fri'];
            $dataArray['sat_limit'] = $postData['sat'];
            $dataArray['sun_limit'] = $postData['sun'];

            $dataArray['daysperweek'] = $postData['daysperweek'];

            $dataArray['from_time'] = $postData['emp_from_time'];
            $dataArray['to_time'] = $postData['emp_to_time'];

            $dataArray['start_date'] = $postData['startDate'];
            $dataArray['sup_signature'] = $postData['supSignature'];
            

            $dataArray['mon_limit1'] = $postData['mon1'];
            $dataArray['tue_limit1'] = $postData['tue1'];
            $dataArray['wed_limit1'] = $postData['wed1'];
            $dataArray['thu_limit1'] = $postData['thu1'];
            $dataArray['fri_limit1'] = $postData['fri1'];
            $dataArray['sat_limit1'] = $postData['sat1'];
            $dataArray['sun_limit1'] = $postData['sun1'];
            $dataArray['from_time1'] = $postData['emp_from_time1'];
            $dataArray['to_time1'] = $postData['emp_to_time1'];

            $dataArray['mon_limit2'] = $postData['mon2'];
            $dataArray['tue_limit2'] = $postData['tue2'];
            $dataArray['wed_limit2'] = $postData['wed2'];
            $dataArray['thu_limit2'] = $postData['thu2'];
            $dataArray['fri_limit2'] = $postData['fri2'];
            $dataArray['sat_limit2'] = $postData['sat2'];
            $dataArray['sun_limit2'] = $postData['sun2'];
            $dataArray['from_time2'] = $postData['emp_from_time2'];
            $dataArray['to_time2'] = $postData['emp_to_time2'];

            if(checkUserLevel('P', $this->session->userdata('userlevel')) || checkUserLevel('A', $this->session->userdata('userlevel'))) {    
                $dataArray['temp_rate'] = $postData['tempRate'];
            }

            $dataArray['user_id'] = $this->session->userdata('id');  

            $where = [];
            $where['patient_id'] = $postData['recno'];
            $where['employee_id'] = $postData['employee_id'];

            $this->Comman_model->update('employee_assignment', $where, $dataArray);


            $where = [];
            $where['patient_id'] = $postData['recno'];
            $where['employee_id'] = $postData['employee_id'];
            $row1 = $this->Comman_model->get_row('employee_assignment', $where);

            $total_limit = 0; 

            $day_limit_arr = [];


            if ($row1["mon_limit"] != 0)  {
                $total_limit = $total_limit + $row1["mon_limit"];
                array_push($day_limit_arr, $row1["mon_limit"]);
            }

            if ($row1["tue_limit"] != 0)  {
                $total_limit = $total_limit + $row1["tue_limit"];
                array_push($day_limit_arr, $row1["tue_limit"]);
            }

            if ($row1["wed_limit"] != 0)  {
                $total_limit = $total_limit + $row1["wed_limit"];
                array_push($day_limit_arr, $row1["wed_limit"]);
            }

            if ($row1["thu_limit"] != 0)  {
                $total_limit = $total_limit + $row1["thu_limit"];
                array_push($day_limit_arr, $row1["thu_limit"]);
            }

            if ($row1["fri_limit"] != 0)  {
                $total_limit = $total_limit + $row1["fri_limit"];
                array_push($day_limit_arr, $row1["fri_limit"]);
            }

            if ($row1["sat_limit"] != 0)  {
                $total_limit = $total_limit + $row1["sat_limit"];
                array_push($day_limit_arr, $row1["sat_limit"]);
            }

            if ($row1["sun_limit"] != 0)  {
                $total_limit = $total_limit + $row1["sun_limit"];
                array_push($day_limit_arr, $row1["sun_limit"]);
            }

            if ($row1["mon_limit1"] != 0)  {
                $total_limit = $total_limit + $row1["mon_limit1"];
            }

            if ($row1["tue_limit1"] != 0)  {
                $total_limit = $total_limit + $row1["tue_limit1"];
            }

            if ($row1["wed_limit1"] != 0)  {
                $total_limit = $total_limit + $row1["wed_limit1"];
            }

            if ($row1["thu_limit1"] != 0)  {
                $total_limit = $total_limit + $row1["thu_limit1"];
            }

            if ($row1["fri_limit1"] != 0)  {
                $total_limit = $total_limit + $row1["fri_limit1"];
            }

            if ($row1["sat_limit1"] != 0)  {
                $total_limit = $total_limit + $row1["sat_limit1"];
            }

            if ($row1["sun_limit1"] != 0)  {
                $total_limit = $total_limit + $row1["sun_limit1"];
            }

            if ($row1["mon_limit2"] != 0)  {
                $total_limit = $total_limit + $row1["mon_limit2"];
            }

            if ($row1["tue_limit2"] != 0)  {
                $total_limit = $total_limit + $row1["tue_limit2"];
            }

            if ($row1["wed_limit2"] != 0)  {
                $total_limit = $total_limit + $row1["wed_limit2"];
            }

            if ($row1["thu_limit2"] != 0)  {
                $total_limit = $total_limit + $row1["thu_limit2"];
            }

            if ($row1["fri_limit2"] != 0)  {
                $total_limit = $total_limit + $row1["fri_limit2"];
            }

            if ($row1["sat_limit2"] != 0)  {
                $total_limit = $total_limit + $row1["sat_limit2"];
            }

            if ($row1["sun_limit2"] != 0)  {
                $total_limit = $total_limit + $row1["sun_limit2"];
            }

            $dataArray = [];
            $dataArray['total_limit'] = $total_limit;
            $dataArray['compute_current_weekly_hours'] = $total_limit;
            $dataArray['timer_approved_hours'] = max($day_limit_arr);

            $where = [];
            $where['patient_id'] = $postData['recno'];
            $where['employee_id'] = $postData['employee_id'];

            $this->Comman_model->update('employee_assignment', $where, $dataArray);

            $hoursType = $_POST['hoursType'];

            redirect('patient/clientPOC?emplok=yes&patient='.$postData['recno'].'&emplid2='.$postData['employee_id'].'&hoursType='.$hoursType);
            //$url = base_url('patient/clientPOC').'?emplok=yes&patient='.$postData['recno'].'&emplid2='.$postData['employee_id'];
            //redirect('')
        }
    }


    public function changeAssignStatus() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id']) && !empty($postData['patient_id'])) {
            $where  =   [];
            $where['employee_id']   =   $postData['employee_id'];
            $where['patient_id']   =   $postData['patient_id'];
            $eaData = $this->Comman_model->get_row('employee_assignment', $where);

            $where1 = [];
            $where1['employee_id'] = $postData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where1);

            if(!empty($eaData)) {
                if($employeeData['Status']==1) {
                    $dataArray  =   [];

                    $oldData = [];
                    $newData = [];

                    if ($postData['data_mode'] == 'Assign') {    
                       $dataArray['pin'] = substr($eaData['pin'],1);
                    }
                    if ($postData['data_mode'] == 'UnAssign') {   
                       $dataArray['pin'] = '+'.$eaData['pin'];
                    }

                    $this->Comman_model->update('employee_assignment', $where, $dataArray);                

                    $where = [];
                    $where['patient_id'] = $postData['patient_id'];
                    $patientData = $this->Comman_model->get_row('patient', $where);

                    $username = $this->session->userdata('name');

                    if ($postData['data_mode'] == 'UnAssign') {   
                      $msg = "Worker ".$employeeData['name']." unassigned by ".$username." ".date('m/d/Y');
                      $empmsg = "client ".$patientData['name']." unassigned by ".$username." ".date('m/d/Y');

                      $oldData['assigned_employee'] = 'Assigned';
                      $oldData['employee_name'] = $employeeData['name'];

                      $newData['assigned_employee'] = 'Unassigned';
                      $newData['employee_name'] = $employeeData['name'];

                    }
                    if ($postData['data_mode'] == 'Assign') {    
                      $msg = "Worker ".$employeeData['name']." assigned by ".$username." ".date('m/d/Y');
                      $empmsg = "client ".$patientData['name']." assigned by ".$username." ".date('m/d/Y');

                      $newData['assigned_employee'] = 'Assigned';
                      $newData['employee_name'] = $employeeData['name'];

                      $oldData['assigned_employee'] = 'Unassigned';
                      $oldData['employee_name'] = $employeeData['name'];
                    }

                    ############### USER ACTION TRACKING START ####################
                    if($this->session->userdata('id')!=6) {
                      $dataArray = [];
                      $dataArray['user_id'] = $this->session->userdata('id');
                      $dataArray['username'] = $this->session->userdata('name');
                      if ($postData['data_mode'] == 'UnAssign') {   
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user unassigned worker '.$employeeData['name'].' from client id '.$postData['patient_id'].' at '. date('m/d/Y H:i:s');
                      }
                      if ($postData['data_mode'] == 'Assign') {   
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user assigned worker '.$employeeData['name'].' to client id '.$postData['patient_id'].' at '. date('m/d/Y H:i:s');
                      }
                      $this->Comman_model->insert('users_tracking', $dataArray);    
                    }

                    $dataArray = [];
                    $dataArray['patient_id'] = $postData['patient_id'];
                    $dataArray['old_value'] = json_encode($oldData);
                    $dataArray['new_value'] = json_encode($newData);
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['user_level'] = $this->session->userdata('userlevel');
                    $dataArray['agency'] = $this->session->userdata('agency');
                    $dataArray['createdOn'] = date('Y-m-d H:i:s');
                    insertHelper('patient_update_history', $dataArray);
                    ############### USER ACTION TRACKING END ####################

                    $dataArray = [];
                    $dataArray['Agency'] = $this->session->userdata('agency');
                    $dataArray['patient_id'] = $postData['patient_id'];
                    $dataArray['WeekStartingDate'] = date('Y-m-d');
                    $dataArray['employee_id'] = $postData['employee_id'];
                    $dataArray['ProgressNotesTypeID_Ref'] = 8;
                    $dataArray['ProgressNotesDetails'] = $msg;
                    $dataArray['ProgressNotesDetailsEmp'] = $empmsg;

                    $inserId = $this->Comman_model->insert( "tblweeklydiscussionsnew", $dataArray );


                    $data =  $this->get_assigned_employee_data($postData);

                    print_r($data);
                } else {
                    print_r(0);
                }
            }
        }
    }

    public function getByAssignStatus() {
        $postData   =   $this->input->post();
        if(!empty($postData['patient_id'])) {

            $where = [];
            $where['patient_id'] = $postData['patient_id'];
            $patientData = $this->Comman_model->get_row('patient', $where);

            $where  = [];
            $where['ea.patient_id']    =   $postData['patient_id'];
            $like = [];
            if($postData['status']=='false') {
              $like['ea.pin'] = '+'; 
            }
            $not_like = [];
            if($postData['status']=='true') {
              $not_like['ea.pin'] = '+';   
            }

            $eaData    =   $this->client->get_assigned_employee($where, $like, $not_like);
            $data = '';
            if(!empty($eaData)) {
                $td1 = $td2 = $td3 = $td6 = '';
                foreach ($eaData as $key => $row) {

                  $total_limit = 0;
                  $where = [];
                  $where['employee_id'] = $row['employee_id'];
                  $result = $this->Comman_model->get_rows('employee_assignment', $where);
                  if(!empty($result)) {
                    foreach ($result as $key1 => $row2) {
                      $pin2 = $row2['pin'];
                      if (substr($pin2,0,1) != '+')  {
                        $total_limit = $total_limit + $row['total_limit'];
                      }
                    }
                  }
                  //$total_limit = 50;
                  $font_weight1 = 'normal';
                  $color1 = 'black';
                  if($total_limit>0) {
                    $font_weight1 = 'bold';
                    $color1 = 'blue';
                  }
                  if($total_limit>40) {
                    $font_weight1 = 'bold';
                    $color1 = 'red';
                  }

                  $td1 = '<td style="text-align: center;">'.$row['temp_rate'].'</td><td style="font-weight: '.$font_weight1.';color: '.$color1.';text-align: center;">'.$row['total_limit'].'</td>';

                  if (substr($row['pin'],0,1) == '+')  {
                    $td2 = '<a href="javascript:void(0)" class="assign-status" data-employee-id="'.$row['employee_id'].'" data-mode="Assign" data-status-id="'.$patientData['IsActive'].'">Assign</a>';
                  } else {
                    $td2 = '<a href="javascript:void(0)" class="assign-status" data-employee-id="'.$row['employee_id'].'" data-mode="UnAssign">UnAssign</a>';
                  }

                  if (substr($row['pin'],0,1) == '+')  {
                      $td3 = "<b><font color='red'>OFF</font></b>";             
                  } else {
                      $td3 = "<b><font color='blue'>ON</font></b>";                           
                  }

                  if ($row['relative'] == 0 )  {
                      $td6 = 'No';
                  }             
                  if ($row['relative'] == 1 )  {
                      $td6 = 'Yes';
                  }             

                  $unassigned_date = '';
                  if($row['unassigned_date']!='0000-00-00') {
                      $unassigned_date = $row['unassigned_date'];
                  }

                  $employeeName = $row['lastname'].', '.$row['firstname'];
                  if($row['hcpadmin']==1) {
                    $employeeName = '<strong>HCP </strong>'.$employeeName;
                  }

                  $sql = "SELECT * FROM employee_clock WHERE employee_id = '".$row['employee_id']."' AND patient_id = '".$row['patient_id']."' ORDER BY date DESC LIMIT 2";
                    $LastDayData = get_custom_query_data($sql);
                    $lstData = '';
                    $lstcheck = true;
                    $lstisIn = $lstDate = $lstOut = '';
                    if(!empty($LastDayData)) {
                        foreach ($LastDayData as $key1 => $lstRow) {
                            if($lstRow['isIn']==1) {
                                $lstcheck = false;
                                $lstDate = '<p style="margin-bottom: 0px;">'.date('m/d/Y', strtotime($lstRow['date'])).'</p>';
                            }
                            if($lstRow['isIn']==2) {
                                //$lstOut = '<p style="margin-bottom: 0px;"><b>Out:</b> '.date('h:i:s', strtotime($lstRow['date'])).'</p>';
                            }
                        }
                    }

                    if($lstcheck) {
                        $lstData = 'NA';
                    } else {
                        $lstData = $lstDate;
                    }

                  $data .= '<tr><td><a target="_blank" href="'.base_url('employee/edit').'?id='.$row['employee_id'].'&first=ok">'.$employeeName.'</a><p><a data-toggle="tooltip" data-html="true" data-placement="top" data-original-title="Daily Limit" href="JavaScript:void(0);" class="day-limit" data-employee-id="'.$row['employee_id'].'">Create POC</a></p><p><a target="_blank" href="'.base_url('patient/clientPOC').'?emplok=yes&patient='.$row['patient_id'].'&emplid2='.$row['employee_id'].'">Print POC</a></p><p title="View Calendar"><a class="btn btn-primary btn-sm" target="_blank" href="'.base_url('patient/weeklyEmployeeCalendar').'?patient='.$row['patient_id'].'&employee='.$row['employee_id'].'"><i class="mdi mdi-calendar-month"></i></a></p></td>'.$td1.'<td>'.$td2.'</td><td>'.$td3.'</td><td align="center"><button type="button" class="btn btn-sm btn-info set-weekday" title="Weekday Schedule" data-employee-id="'.$row['employee_id'].'"><i class="mdi mdi-calendar-month"></i></button></td>
                      <td><input style="max-width: 109px;height: 30px;border-radius: 0px;" type="text" name="unassigned_date" class="form-control unassigned-date" value="'.$unassigned_date.'" placeholder="yyyy-mm-dd" data-employee-id="'.$row['employee_id'].'"></td>  
                      <td>'.$row['pin'].'</td>
                      <td>'.$td6.'</td>
                      <td data-sql="'.$sql.'">'.$lstData.'</td>';

                  //if($_SESSION['userlevel']=='A') {    
                  if(checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('L', $this->session->userdata('userlevel'))) {
                      $data .= '<td><button type="button" title="Delete" class="btn btn-sm btn-danger btn-del-assigned" data-employee-id="'.$row['employee_id'].'"><i class="mdi mdi-trash-can-outline"></i></button></td>';
                  }
                  $data .= '</tr>';
                } 
            } else {
                $data = '<tr align="center"><td colspan="9">No data found.</td></tr>';
            }
            print_r($data);
        }
    }


    public function assignEmployee() {
        $postData   =   $this->input->post();
        $agency_code = $this->session->userdata('agency');

        if(!empty($postData['employee_id'])) {
            $where= [];
            $where['employee_id']   =   $postData['employee_id'];
            $where['patient_id']    =   $postData['patient_id'];
            $num = $this->Comman_model->countrow('employee_assignment', $where);            

            if($num==0) {
                $where= [];
                $where['patient_id']   =   $postData['patient_id'];
                $ptRow = $this->Comman_model->get_row('patient', $where);

                $where= [];
                $where['employee_id']   =   $postData['employee_id'];
                //$where['Agency']    =   $agency_code;  
                $empRow = $this->Comman_model->get_row('employee', $where);
                //$empnum = $this->Comman_model->countrow('employee', $where);
                //if($empnum==1) {
                if($ptRow['IsActive']!=0) {
                    if($empRow['Agency']==$ptRow['Agency']) {
                        $where= [];
                        $where['ea.patient_id'] = $postData['patient_id'];
                        $like = [];
                        $not_like = [];
                        $not_like['ea.pin'] = '+';   
                        $this->load->model('Employee_model', 'employee');
                        $assignedPatientData = $this->employee->getAssignedPatientData($where, $like, $not_like);    
                        $empPinCheck = true;
                        $empPin = [];
                        foreach ($assignedPatientData as $key => $objResult) {
                            $where = [];
                            $where['employee_id'] = $objResult['employee_id'];
                            $empData = $this->Comman_model->get_row('employee', $where);
                            array_push($empPin, $empData['pin']);
                        }
                        //print_r($empPin);die;

                        if(!empty($empPin) && in_array($empRow['pin'], $empPin)) {
                            $empPinCheck = false;    
                        }

                        if($empPinCheck) {

                            $total_limit = 0;
                            $where = [];
                            $where['ea.employee_id'] = $postData['employee_id'];
                            $like = [];
                            $not_like = [];
                            $not_like['ea.pin'] = '+';   
                            $this->load->model('Employee_model', 'employee');
                            $assignedPatientData = $this->employee->getAssignedPatientData($where, $like, $not_like);    
                            foreach ($assignedPatientData as $key => $objResult) {
                                $total_limit = $total_limit + $objResult['total_limit'];
                            }

                            $where  =   [];
                            $where['employee_id']  =   $postData['employee_id'];
                            $employeeData = $this->Comman_model->get_row('employee', $where);

                            $where  =   [];
                            $where['patient_id']  =   $postData['patient_id'];
                            $patientData = $this->Comman_model->get_row('patient', $where);

                            if($employeeData['hcpadmin']==1 || $total_limit<50) {                  
                                $hours = 0;
                                $dataArray  =   [];
                                $dataArray['patient_id']    =   $postData['patient_id'];
                                $dataArray['employee_id']   =   $postData['employee_id'];
                                $dataArray['hours']   =   $hours;
                                $dataArray['pin']   =   $employeeData['pin'];
                                $dataArray['employee_agency'] = $empRow['Agency'];
                                $dataArray['patient_agency'] = $patientData['Agency'];
                                $insert = $this->Comman_model->insert('employee_assignment', $dataArray);

                                $where = [];
                                $where['employee_id'] = $postData['employee_id'];
                                $employeeData = $this->Comman_model->get_row('employee', $where);

                                $where = [];
                                $where['patient_id'] = $postData['patient_id'];
                                $patientData = $this->Comman_model->get_row('patient', $where);

                                $username = $this->session->userdata('name');
                                $msg = "New worker ".$employeeData['name']." assigned by ".$username." ".date('m/d/Y');
                                $empmsg = "New client ".$patientData['name']." assigned by ".$username." ".date('m/d/Y');


                                $total_hours = 0;
                                $where = [];
                                $where['employee_id'] = $postData['employee_id'];
                                $result2 = get_rows('employee_assignment', $where);
                                if(!empty($result2)) {
                                    foreach ($result2 as $key2 => $row2) {
                                        $pin2 = $row2['pin'];
                                        if (substr($pin2,0,1) != '+')  {
                                            $total_hours = $total_hours + $row['total_limit'];
                                        }
                                    }
                                }

                                $newData = [];    
                                $newData['assigned_employee'] = 'Assigned (Hours : '.$total_hours.')';
                                $newData['employee_name'] = $employeeData['name'];

                                $oldData = [];    
                                $oldData['assigned_employee'] = 'NA';
                                $oldData['employee_name'] = 'NA';


                                /********** Update status new client to active client start ***********/
                                if($patientData['IsActive']==3) {
                                    $where1  =   [];
                                    $where1['patient_id']   =   $postData['patient_id'];
                                    $dataArray1 = [];
                                    $dataArray1['IsActive'] = 1;
                                    $this->Comman_model->update('patient', $where1, $dataArray1);
                                }
                                /********** Update status new client to active client end ***********/


                                ############### USER ACTION TRACKING START ####################
                                if($this->session->userdata('id')!=6) {
                                  $dataArray = [];
                                  $dataArray['user_id'] = $this->session->userdata('id');
                                  $dataArray['username'] = $this->session->userdata('name');
                                  $dataArray['user_action'] = $this->session->userdata('name'). ' user assign employee '.$employeeData['name'].' to client id '.$postData['patient_id'].' at '. date('m/d/Y H:i:s');
                                  $this->Comman_model->insert('users_tracking', $dataArray);    
                                }

                                $dataArray = [];
                                $dataArray['patient_id'] = $postData['patient_id'];
                                $dataArray['old_value'] = json_encode($oldData);
                                $dataArray['new_value'] = json_encode($newData);
                                $dataArray['user_id'] = $this->session->userdata('id');
                                $dataArray['user_level'] = $this->session->userdata('userlevel');
                                $dataArray['agency'] = $this->session->userdata('agency');
                                $dataArray['createdOn'] = date('Y-m-d H:i:s');
                                insertHelper('patient_update_history', $dataArray);
                                ############### USER ACTION TRACKING END ####################

                                $dataArray = [];
                                $dataArray['Agency'] = $this->session->userdata('agency');
                                $dataArray['patient_id'] = $postData['patient_id'];
                                $dataArray['WeekStartingDate'] = date('Y-m-d');
                                $dataArray['employee_id'] = $postData['employee_id'];
                                $dataArray['ProgressNotesTypeID_Ref'] = 7;
                                $dataArray['ProgressNotesDetails'] = $msg;
                                $dataArray['ProgressNotesDetailsEmp'] = $empmsg;

                                $inserId = $this->Comman_model->insert( "tblweeklydiscussionsnew", $dataArray );

                                $data = [];
                                $data['response'] = 200;
                                $data['message'] = "";
                                if($total_limit>40) {
                                $data['message'] = "FYI, WORKER HAS MORE THAN 40 WEEKLY HOURS";
                                }
                                $data['result'] =  $this->get_assigned_employee_data($postData);
                                print_r(json_encode($data));
                            } else {
                                $data = [];
                                $data['response'] = 201;
                                $data['message'] = "Selected worker's assigned weekly hours is more than 50, please assign other worker for this client";
                                $data['result'] = "NA";
                                print_r(json_encode($data));
                            }
                        } else {
                            $data = [];
                            $data['response'] = 202;
                            $data['message'] = "SAME PIN EMPLOYEE ALREADY ASSIGNED.";
                            $data['result'] = "NA";
                            print_r(json_encode($data));    
                        }
                    } else {
                        $data = [];
                        $data['response'] = 202;
                        $data['message'] = "EMPLOYEE SHOULD BE FROM SAME AGENCY.";
                        $data['result'] = "NA";
                        print_r(json_encode($data));
                    }
                } else {
                    $data = [];
                    $data['response'] = 202;
                    $data['message'] = "CLIENT IS NOT ACTIVE";
                    $data['result'] = "NA";
                    print_r(json_encode($data));      
                }
            } else {
              $data = [];
              $data['response'] = 202;
              $data['message'] = "WORKER ALREADY ASSIGNED.";
              $data['result'] = "NA";
              print_r(json_encode($data));
            }
        }
    }


    public function get_assigned_employee_data($postData=[]) {
        $where  = [];
        $where['ea.patient_id']    =   $postData['patient_id'];

        $like = [];
        if($postData['status']=='false') {
          $like['ea.pin'] = '+'; 
        }
        $not_like = [];
        if($postData['status']=='true') {
          $not_like['ea.pin'] = '+';   
        }

        $assignEmployeeData    =   $this->client->get_assigned_employee($where, $like, $not_like);

        $data = '';
        if(!empty($assignEmployeeData)) {
            $td1 = $td2 = $td3 = $td6 = '';
            foreach ($assignEmployeeData as $key => $row) {

                $total_limit = 0;
                $where = [];
                $where['employee_id'] = $row['employee_id'];
                $result = $this->Comman_model->get_rows('employee_assignment', $where);
                if(!empty($result)) {
                  foreach ($result as $key1 => $row2) {
                    $pin2 = $row2['pin'];
                    if (substr($pin2,0,1) != '+')  {
                      $total_limit = $total_limit + $row['total_limit'];
                    }
                  }
                }
                //$total_limit = 50;
                $font_weight1 = 'normal';
                $color1 = 'black';
                if($total_limit>0) {
                  $font_weight1 = 'bold';
                  $color1 = 'blue';
                }
                if($total_limit>40) {
                  $font_weight1 = 'bold';
                  $color1 = 'red';
                }

                $td1 = '<td style="text-align: center;">'.$row['temp_rate'].'</td><td style="font-weight: '.$font_weight1.';color: '.$color1.';text-align: center;">'.$row['total_limit'].'</td>';

                if (substr($row['pin'],0,1) == '+')  {
                  $td2 = '<a href="javascript:void(0)" class="assign-status" data-employee-id="'.$row['employee_id'].'" data-mode="Assign">Assign</a>';
                } else {
                  $td2 = '<a href="javascript:void(0)" class="assign-status" data-employee-id="'.$row['employee_id'].'" data-mode="UnAssign">UnAssign</a>';
                }

                if (substr($row['pin'],0,1) == '+')  {
                    $td3 = "<b><font color='red'>OFF</font></b>";             
                } else {
                    $td3 = "<b><font color='blue'>ON</font></b>";                           
                }

                if ($row['relative'] == 0 )  {
                    $td6 = 'No';
                }             
                if ($row['relative'] == 1 )  {
                    $td6 = 'Yes';
                }             

                $unassigned_date = '';
                if($row['unassigned_date']!='0000-00-00') {
                    $unassigned_date = $row['unassigned_date'];
                }

               /* $data .= '<tr><td>'.$row['lastname'].', '.$row['firstname'].'</td><td>'.$td2.'</td><td>'.$td3.'</td><td align="center"><button type="button" class="btn btn-sm btn-info set-weekday" title="Weekday Schedule" data-employee-id="'.$row['employee_id'].'"><i class="fas fa-calendar-alt"></i></button></td>
                    <td><input style="max-width: 109px;height: 30px;border-radius: 0px;" type="text" name="unassigned_date" class="form-control unassigned-date" value="'.$unassigned_date.'" placeholder="yyyy-mm-dd" data-employee-id="'.$row['employee_id'].'"></td>  
                    <td>'.$row['pin'].'</td>
                    <td>'.$td6.'</td>';*/

                $employeeName = $row['lastname'].', '.$row['firstname'];
                if($row['hcpadmin']==1) {
                  $employeeName = '<strong>HCP </strong>'.$employeeName;
                }     

                $sql = "SELECT * FROM employee_clock WHERE employee_id = ".$row['employee_id']." AND patient_id = ".$row['patient_id']." ORDER BY date DESC LIMIT 2";
                $LastDayData = get_custom_query_data($sql);
                $lstData = '';
                $lstcheck = true;
                $lstisIn = $lstDate = $lstOut = '';
                if(!empty($LastDayData)) {
                    foreach ($LastDayData as $key1 => $lstRow) {
                        if($lstRow['isIn']==1) {
                            $lstcheck = false;
                            $lstDate = '<p style="margin-bottom: 0px;">'.date('m/d/Y', strtotime($lstRow['date'])).'</p>';
                        }
                        if($lstRow['isIn']==2) {
                            //$lstOut = '<p style="margin-bottom: 0px;"><b>Out:</b> '.date('h:i:s', strtotime($lstRow['date'])).'</p>';
                        }
                    }
                }

                if($lstcheck) {
                    $lstData = 'NA';
                } else {
                    $lstData = $lstDate;
                }

                $data .= '<tr><td><a target="_blank" href="'.base_url('employee/edit').'?id='.$row['employee_id'].'&first=ok">'.$employeeName.'</a><p><a href="JavaScript:void(0);" class="day-limit" data-employee-id="'.$row['employee_id'].'">Day Limit</a></p></td>'.$td1.'<td>'.$td2.'</td><td>'.$td3.'</td><td align="center"><button type="button" class="btn btn-sm btn-info set-weekday" title="Weekday Schedule" data-employee-id="'.$row['employee_id'].'"><i class="mdi mdi-calendar-month"></i></button></td>
                      <td><input style="max-width: 109px;height: 30px;border-radius: 0px;" type="text" name="unassigned_date" class="form-control unassigned-date" value="'.$unassigned_date.'" placeholder="yyyy-mm-dd" data-employee-id="'.$row['employee_id'].'"></td>  
                      <td>'.$row['pin'].'</td>
                      <td>'.$td6.'</td>
                      <td>'.$lstData.'</td>';     

                //if($_SESSION['userlevel']=='A') {    
                if(checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('L', $this->session->userdata('userlevel'))) {
                    $data .= '<td><button type="button" title="Delete" class="btn btn-sm btn-danger btn-del-assigned" data-employee-id="'.$row['employee_id'].'"><i class="mdi mdi-trash-can-outline"></i></button></td>';
                }
                $data .= '</tr>';
            }
        } else {
            $data = '<tr></tr>';
        }
        return $data;
    }


    public function deleteAssignEmployee() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id'])) {
            $where= [];
            $where['employee_id']   =   $postData['employee_id'];
            $where['patient_id']    =   $postData['patient_id'];
            $num = $this->Comman_model->countrow('employee_assignment', $where);
            if($num) {
                $where  =   [];
                $where['employee_id']  =   $postData['employee_id'];
                $where['patient_id']   =   $postData['patient_id'];
                $employeeData = $this->Comman_model->delete_row('employee_assignment', $where);
                //if($insert) {

                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                  $dataArray = [];
                  $dataArray['user_id'] = $this->session->userdata('id');
                  $dataArray['username'] = $this->session->userdata('name');
                  $dataArray['user_action'] = $this->session->userdata('name'). ' user delete assigned/unassigned employee id '.$postData['employee_id'].' from client id '.$postData['patient_id'].' at '. date('m/d/Y H:i:s');
                  $this->Comman_model->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################

                $data =  $this->get_assigned_employee_data($postData);
                print_r($data);
               // }
            }
        }
    }

    public function setUnassignedDate() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id'])) {
            $where= [];
            $where['employee_id']   =   $postData['employee_id'];
            $where['patient_id']    =   $postData['patient_id'];
            $num = $this->Comman_model->countrow('employee_assignment', $where);
            if($num) {
                $where  =   [];
                $where['employee_id']  =   $postData['employee_id'];
                $where['patient_id']   =   $postData['patient_id'];

                $dataArray = [];
                $dataArray['unassigned_date'] = $postData['unassigned_date'];

                $dataArray['unassigned_date_by_user_id'] = $this->session->userdata('id');
                $dataArray['unassigned_date_by_username'] = $this->session->userdata('name');

                $employeeData = $this->Comman_model->update('employee_assignment', $where, $dataArray);

                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                  $dataArray = [];
                  $dataArray['user_id'] = $this->session->userdata('id');
                  $dataArray['username'] = $this->session->userdata('name');
                  $dataArray['user_action'] = $this->session->userdata('name'). ' user updated unassigned date '.$postData['unassigned_date'].' to employee id '.$postData['employee_id'].' for client id '.$postData['patient_id'].' at '. date('m/d/Y H:i:s');
                  $this->Comman_model->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################

                //if($insert) {
                $data =  $this->get_assigned_employee_data($postData);
                print_r($data);
               // }
            }
        }
    }


    public function clientVisit() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {

            $agency_code = $this->session->userdata('agency');

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $where['Agency'] = $agency_code;
            $where['status'] = 0;
            $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where, 'VisitDoneDate', 'desc');
            $data['patient_id'] =  $_GET['patient']; 

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/viewClientVisit.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/viewClientVisit-new.php',$data);
        } else {
            redirect();
        }
    }


    public function addClientVisit() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {

            $where= [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('next_visit_date', 'Next Visit Date', 'trim|required');
                $this->form_validation->set_rules('visit_done_date', 'Visit Done Date', 'trim|required');
                $this->form_validation->set_rules('visitation_notes', 'Visitation Notes', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $nextVisitDate = $this->input->post('next_visit_date',true);
                    $visitDoneDate = $this->input->post('visit_done_date',true);   

                    $nextVisitDate = date('Y-m-d', strtotime($nextVisitDate));
                    $visitDoneDate = date('Y-m-d', strtotime($visitDoneDate));

                    if($nextVisitDate=='0000-00-00' || $visitDoneDate=='0000-00-00') {
                      $this->app->message('Please select a valid date', 'error');
                      redirect('patient/AddClientVisit?patient='.$_GET['patient']);
                    }

                    $dataArray                    = [];
                    $dataArray['Agency']          = $this->session->userdata('agency');
                    $dataArray['patient_id']      = $_GET['patient'];
                    $dataArray['NextVisitDate']   = $nextVisitDate;
                    $dataArray['VisitDoneDate']   = $visitDoneDate;
                    $dataArray['VisitationNotes'] = $this->input->post('visitation_notes',true);
                    $dataArray['user_id']         = $this->session->userdata('id');
                    $dataArray['username']        = $this->session->userdata('name');

                    $inserId = $this->Comman_model->insert( "tblpatientsvisits", $dataArray );

                    if($inserId){

                      ############### USER ACTION TRACKING START ####################
                      if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user add client visit to client id '.$_GET['patient'].' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);    
                      }
                      ############### USER ACTION TRACKING END ####################

                      $this->app->message('Client visit has been added successfully.', 'success');
                    } else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/clientVisit?patient='.$_GET['patient'],'refresh');
                }
            }

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/addClientVisit.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/addClientVisit-new.php',$data);
        } else {
            redirect();
        }
    }


    public function editClientVisit() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['visit'])) {
            $where= [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $where= [];
            $where['recid'] = decode64($_GET['visit']);
            $data['patientVisitData'] = $this->Comman_model->get_row('tblpatientsvisits', $where);
            $data['patientVisitData']['NextVisitDate'] = date('m/d/Y', strtotime($data['patientVisitData']['NextVisitDate']));
            $data['patientVisitData']['VisitDoneDate'] = date('m/d/Y', strtotime($data['patientVisitData']['VisitDoneDate']));

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('next_visit_date', 'Next Visit Date', 'trim|required');
                $this->form_validation->set_rules('visit_done_date', 'Visit Done Date', 'trim|required');
                $this->form_validation->set_rules('visitation_notes', 'Visitation Notes', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $nextVisitDate = $this->input->post('next_visit_date',true);
                    $visitDoneDate = $this->input->post('visit_done_date',true);   

                    $nextVisitDate = date('Y-m-d', strtotime($nextVisitDate));
                    $visitDoneDate = date('Y-m-d', strtotime($visitDoneDate));

                    if($nextVisitDate=='0000-00-00' || $visitDoneDate=='0000-00-00') {
                      $this->app->message('Please select a valid date', 'error');
                      redirect('patient/editClientVisit?patient='.$_GET['patient'].'&visit='.$_GET['visit']);
                    }

                    $dataArray                    = [];
                    $dataArray['Agency']          = $_SESSION['agency'];
                    $dataArray['patient_id']      = $_GET['patient'];
                    $dataArray['NextVisitDate']   = $nextVisitDate;
                    $dataArray['VisitDoneDate']   = $visitDoneDate;
                    $dataArray['VisitationNotes'] = $this->input->post('visitation_notes',true);
                    $dataArray['user_id']         = $this->session->userdata('id');
                    $dataArray['username']        = $this->session->userdata('name');

                    $where  =   [];
                    $where['recid']  =   decode64($_GET['visit']);
                    $update = $this->Comman_model->update( "tblpatientsvisits", $where, $dataArray );

                    if($update){

                      ############### USER ACTION TRACKING START ####################
                      if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user update client visit to client id '.$_GET['patient'].' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);
                      }
                      ############### USER ACTION TRACKING END ####################

                      $this->app->message('Client visit has been updated successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('Patient/clientVisit?patient='.$_GET['patient'],'refresh');
                }
            }
            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/editClientVisit.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/editClientVisit-new.php',$data);
        } else {
            redirect();
        }
    }

    public function updateNextVisit() {
      if(isset($_SESSION['name']) && !empty($_POST['patient']) && !empty($_POST['visit']) && !empty($_POST['nextvisitation_date'])) {

        $where= [];
        $where['patient_id'] = $_POST['patient'];            
        $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

        if( !empty( $this->input->post( 'submit' ) ) ){
          $this->form_validation->set_rules('nextvisitation_date', 'Next Visit Date', 'trim|required');


          if ($this->form_validation->run() != false) {
            
            $nextVisitDate = $this->input->post('nextvisitation_date',true);
            $nextVisitDate = date('Y-m-d', strtotime($nextVisitDate));

            if($nextVisitDate=='0000-00-00') {
              $this->app->message('Please select a valid date', 'error');
              redirect('patient/editClientVisit?patient='.$_POST['patient'].'&visit='.$_POST['visit']);
            }

            $dataArray                    = [];
            $dataArray['NextVisitDate']   = $nextVisitDate;
            $dataArray['user_id']         = $this->session->userdata('id');
            $dataArray['username']        = $this->session->userdata('name');

            $where  =   [];
            $where['recid']  =   decode64($_POST['visit']);
            $update = $this->Comman_model->update("tblpatientsvisits", $where, $dataArray );

            if($update){
              ############### USER ACTION TRACKING START ####################
              if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user update client visit next date to client id '.$_POST['patient'].' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);
              }
              ############### USER ACTION TRACKING END ####################

              $this->app->message('Client visit next date has been updated successfully.', 'success');
            }else{
                $this->app->message('Oops! something went wrong try again.', 'error');                  
            }
            redirect('patient/clientVisit?patient='.$_POST['patient'],'refresh');
          }
        }
      } else {
          redirect();
      }
    }


    public function delete_Client_Visit() {

        $id = $this->input->get('delete_id');
        $dataArray = [];
        $dataArray['status'] = 1;

        $where = [];
        $where['recid'] = $id;

        $visitData = $this->Comman_model->get_row('tblpatientsvisits', $where);

        $ptid = $visitData['patient_id'];

        $data = $this->Comman_model->update('tblpatientsvisits', $where, $dataArray);
        //$data = $this->db->where('recid',$id)->delete('tblpatientsvisits');
        
        if($data) {
            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted client visit from client id '.$visitData['patient_id'].' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);
            }
            ############### USER ACTION TRACKING END ####################
            $this->app->message('Client visit has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops something went wrong.', 'error');
        }
        redirect($this->agent->referrer());  
    }

    public function clientWeekly() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {
            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $fromD  = date('Y-m-d', strtotime("first day of -2 month"));
            $toD    = date('Y-m-d', strtotime('last day of this month'));
            $keyword = '';
            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }       
                //echo $toD;die;         
            }

            
            
            $data['patientWeeklytData'] = $this->client->get_weekly_discussions($fromD, $toD, $_GET['patient'], $_SESSION['agency'], $keyword);

            $data['patient_id'] =  $_GET['patient']; 
            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['keyword'] = $keyword;


            $query = "SELECT * FROM wellness_call WHERE Portal_ID = '".$_GET['patient']."' order by Submission_Date desc";
            $data['clienWellnessData'] = get_data_other_db($query, 'result', 'wellness');

            $type_of_report = 'Critical Incident';
            if(!empty($this->input->post('type_of_report'))) {
                $type_of_report  = $this->input->post('type_of_report');
            }

            $data['type_of_report'] = $type_of_report;

            $patient_id = $_GET['patient'];

            $query = "SELECT * FROM critical_incident WHERE Type_of_Report LIKE '%".$type_of_report."%' AND Client_ID = '".$patient_id."' ORDER BY Submission_Date DESC";
            $data['criticalIncidentData'] = get_data_other_db($query, 'result', 'wellness');

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/viewClientWeekly.php',$data);
            $this->load->view('common/footer.php');
            */            

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/viewClientWeekly-new.php',$data);
        } else {
            redirect();
        }
    }


    public function clientWeeklyCopy() {
        if(isset($_SESSION['name'])) {
            /*$where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);*/

            $fromD  = date('Y-m-d', strtotime("first day of -2 month"));
            $toD    = date('Y-m-d', strtotime('last day of this month'));
            $keyword = '';
            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }       
                //echo $toD;die;         
            }

            $agency_code = $_SESSION['agency'];
            $cond = ' AND patient.FHCA=1 ';
            
            if(!empty($_POST['suplid'])) {
                $cond .= " AND patient.supervisor_id='".$_POST['suplid']."' ";
            }

            $clientStatus =  @$_POST['clientStatus'];
            if($clientStatus!='') {
                $cond .= " AND patient.IsActive='".$clientStatus."' ";
            }

            if(!empty($_POST['notesTypes'])) {
                $cond .= " AND tblprogressnotestypes.ProgressNotesTypeID='".$_POST['notesTypes']."' ";
            } else {
                $cond .= ' AND tblprogressnotestypes.ProgressNotesTypeID=1 ';    
            }

            if(!empty($_POST['onHold'])) {
                $cond .= " AND patient.on_hold='".$_POST['onHold']."' ";
            }

            $MySQL = "SELECT SQL_CALC_FOUND_ROWS distinct
                   tblweeklydiscussionsnew.WeeklyDiscussionID,
                   tblweeklydiscussionsnew.recid,
                   tblweeklydiscussionsnew.EmployeeID_Ref,
                   tblweeklydiscussionsnew.WeekStartingDate,
                   tblweeklydiscussionsnew.ProgressNotesTypeID_Ref,
                   tblweeklydiscussionsnew.patient_id,
                   tblweeklydiscussionsnew.username,
                   tblweeklydiscussionsnew.TransactionDate,
                   employee.employee_ref_id,
                   employee.employee_id,
                   employee.lastname,
                   employee.firstname,
                   employee.name as employee_name,
                   patient.name as patient_name,
                   tblweeklydiscussionsnew.ProgressNotesDetails,
                   tblweeklydiscussionsnew.ProgressNotesDetailsEmp,                   
                   tblprogressnotestypes.ProgressNotesTypeID,
                   tblprogressnotestypes.ProgressNotesType,
                   patient.FHCA,
                   patient.supervisor_id,
                   patient.IsActive
                 FROM tblweeklydiscussionsnew,employee,patient,tblprogressnotestypes  
               WHERE employee.employee_id = tblweeklydiscussionsnew.employee_id AND patient.patient_id = tblweeklydiscussionsnew.patient_id  AND WeekStartingDate >= '$fromD' AND WeekStartingDate  <= '$toD' AND tblprogressnotestypes.ProgressNotesTypeID = tblweeklydiscussionsnew.ProgressNotesTypeID_Ref $cond AND tblweeklydiscussionsnew.Agency = '$agency_code' AND  (tblweeklydiscussionsnew.WeekStartingDate like '%".$keyword."%' OR  employee.name like '%".$keyword."%' OR  tblprogressnotestypes.ProgressNotesType like '%".$keyword."%' OR tblweeklydiscussionsnew.ProgressNotesDetails like '%".$keyword."%') group by tblweeklydiscussionsnew.employee_id, tblweeklydiscussionsnew.patient_id order by tblweeklydiscussionsnew.WeekStartingDate desc";            
            
            //$data['patientWeeklytData'] = $this->client->get_weekly_discussions($fromD, $toD, $_GET['patient'], $_SESSION['agency'], $keyword);

            $data['patientWeeklytData'] = $this->Comman_model->getCustomQueryData($MySQL);    
            $data['locationData'] = $this->Comman_model->get_rows('agency_location');
            $where = [];
            $where['ProgressNotesTypeID!='] = '0';
            $data['notestypesData'] = $this->Comman_model->get_rows('tblprogressnotestypes', $where);

            if(!empty($_POST['agency_location'])) {
                $where = [];
                $where['su.firstname!='] ='';
                $where['su.agency_location'] = $_POST['agency_location'];
                $data['supervisorData'] = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');    
            }

            $data['patient_id'] =  $_POST['patient']; 
            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['keyword'] = $keyword;

            $data['suplid'] = @$_POST['suplid']; 
            $data['notesTypes'] = @$_POST['notesTypes'];
            $data['clientStatus'] = $clientStatus;
            $data['onHold'] = @$_POST['onHold'];
            
            $data['agency_location'] = @$_POST['agency_location'];          

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/viewClientWeeklyCopy.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/viewClientWeeklyCopy-new.php',$data);
        } else {
            redirect();
        }
    }


    public function hcaAppReport() {
        if(isset($_SESSION['name'])) {
            $fromD      = '';
            $toD        = '';
            $keyword    = '';

            $data               =   []; 
            $data['fromD']      =   '';
            $data['toD']        =   '';
            $data['keyword']    =   $keyword;

            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }

                $agency_code = $this->session->userdata('agency');
                $cond = '';
                
                if(!empty($keyword)) {
                    $cond .= " AND employee_clock.vnotes LIKE '%".$keyword."%' ";
                }

                $MySQL = "SELECT employee_clock.date, employee_clock.vnotes, employee.name as employeeName, patient.name as patientName, patient.agency_location as ptAgencyLocation FROM employee_clock,employee,patient WHERE employee.employee_id = employee_clock.employee_id AND patient.patient_id = employee_clock.patient_id  AND employee_clock.date >= '$fromD' AND employee_clock.date <= '$toD' AND patient.Agency = '$agency_code' AND employee_clock.vnotes!='' $cond ORDER BY employee_clock.date desc";
                $data['hcaAppReportData'] = $this->Comman_model->getCustomQueryData($MySQL);

                $data['fromD']      =   date('m/d/Y', strtotime($fromD));
                $data['toD']        =   date('m/d/Y', strtotime($toD));
                $data['keyword']    =   $keyword;
            }            

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/hca-app-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function clientWeeklyCopyPdf() {
        if(isset($_SESSION['name'])) {

            $agency_code = $this->session->userdata('agency');
            $suplid = @$_GET['suplid'];   
            $agency_location = @$_GET['location'];           

            $notesTypess = @$_GET['notesTypess'];           
            $clientStatuss = @$_GET['clientStatuss'];           
            $onHoldd = @$_GET['onHoldd'];           

            $fromD = date('Y-m-d');
            $toD = date('Y-m-d');
            if(!empty($_GET['fromDD'])) {
                $fromD = date('Y-m-d', strtotime($_GET['fromDD']));
            }            
            if(!empty($_GET['toDD'])) {
                $toD = date('Y-m-d', strtotime($_GET['toDD']));
            }

            $fhca = 1;

            $cnt = 0;
            $ctr = 0;
            $max  = 40;
            $spc = 40;
            $orient = 'P';
            require_once(APPPATH . 'libraries/client-phone-call-report-pdf.php'); 
            $pdf=new clientPhoneCallReportPDF($orient, 'mm',array(215.9,279.4) );
            //$pdf=new PDF('L');
            $where = [];
            $where['agency_code'] = $agency_code;
            $agencyData = $this->Comman_model->get_row('agency', $where);

            $_SESSION['AgencyName'] = $agencyData['agency_shortname'];

            $_SESSION['title'] = "All ";
            if($fhca==1) {
                $_SESSION['title'] = "FHCA ";
            }

            if($fhca==0) {
                $_SESSION['title'] = "NON FHCA ";
            }

            
            //array(100,150)
            $pdf->AliasNbPages();
            $pdf->AddPage($orient);

            $pdf->SetFont('Arial','',8);
            $pdf->SetLeftMargin(10);
            $cond = '';

            if ($fhca == 1 ) { $multiplex = 90; } else { $multiplex = 180;}
            $multiplex = 29;

            if ($suplid != '' ) {                
                $cond = " AND patient.supervisor_id = '$suplid' ";                
            }                

            $cond .= ' AND patient.FHCA=1 ';


            //$cond .= ' AND tblprogressnotestypes.ProgressNotesTypeID=1 ';
            if($clientStatuss!='') {
                $cond .= " AND patient.isActive='".$clientStatuss."' ";
            }

            if(!empty($onHoldd)) {
                $cond .= " AND patient.on_hold='".$onHoldd."' ";
            }

            if(!empty($notesTypess)) {
                $cond .= " AND tblprogressnotestypes.ProgressNotesTypeID='".$notesTypess."' ";
            } else {
                $cond .= ' AND tblprogressnotestypes.ProgressNotesTypeID=1 ';    
            }
                                
            $pdf->setxy(10,$spc);
            $page = 0;
            $counter = 0;

            if(!empty($agency_location)) {
                //$cond .= " agency_location = '$agency_location' AND "; 
            }

            $keyword = '';

            //$result = $this->client->get_client_status_report($agency_code, $cond, $IsActive, $fhca);

            $MySQL = "SELECT SQL_CALC_FOUND_ROWS distinct
                   tblweeklydiscussionsnew.WeeklyDiscussionID,
                   tblweeklydiscussionsnew.recid,
                   tblweeklydiscussionsnew.EmployeeID_Ref,
                   tblweeklydiscussionsnew.WeekStartingDate,
                   tblweeklydiscussionsnew.ProgressNotesTypeID_Ref,
                   tblweeklydiscussionsnew.patient_id,
                   tblweeklydiscussionsnew.username,
                   tblweeklydiscussionsnew.TransactionDate,
                   employee.employee_ref_id,
                   employee.employee_id,
                   employee.lastname,
                   employee.firstname,
                   employee.name as employee_name,
                   patient.name as patient_name,
                   tblweeklydiscussionsnew.ProgressNotesDetails,
                   tblweeklydiscussionsnew.ProgressNotesDetailsEmp,                   
                   tblprogressnotestypes.ProgressNotesTypeID,
                   tblprogressnotestypes.ProgressNotesType,
                   patient.FHCA,
                   patient.supervisor_id 
                    FROM tblweeklydiscussionsnew,employee,patient,tblprogressnotestypes  
                WHERE employee.employee_id = tblweeklydiscussionsnew.employee_id AND patient.patient_id = tblweeklydiscussionsnew.patient_id  AND WeekStartingDate >= '$fromD' AND WeekStartingDate  <= '$toD' AND tblprogressnotestypes.ProgressNotesTypeID = tblweeklydiscussionsnew.ProgressNotesTypeID_Ref $cond AND tblweeklydiscussionsnew.Agency = '$agency_code' AND  (tblweeklydiscussionsnew.WeekStartingDate like '%".$keyword."%' OR  employee.name like '%".$keyword."%' OR  tblprogressnotestypes.ProgressNotesType like '%".$keyword."%' OR tblweeklydiscussionsnew.ProgressNotesDetails like '%".$keyword."%') group by tblweeklydiscussionsnew.employee_id, tblweeklydiscussionsnew.patient_id order by tblweeklydiscussionsnew.WeekStartingDate desc"; 

            $result = $this->Comman_model->getCustomQueryData($MySQL);

            foreach ($result as $key => $row) {

                if ($row['FHCA'] == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

                if ($cnt >= $max) {
                    $page = $page + 1;
                    $cnt = 0; 
                    $pdf->AliasNbPages();
                    $pdf->AddPage($orient);
                    $pdf->setxy(10,$spc);
                }
             
                $ptid = $row['patient_id'];
                $suplid = $row['supervisor_id'];           

                $where = [];
                $where['supervisor_id'] = $suplid;
                $objResult2 = $this->Comman_model->get_row('supervisor', $where);
                $staffname = $objResult2['lastname'].','.$objResult2['firstname'];

                $name = $row['patient_name'];

                //$ptid = 4470;

                /*$objSql = "SELECT * FROM tblweeklydiscussionsnew WHERE patient_id='".$ptid."' AND Agency='".$agency_code."' AND ProgressNotesTypeID_Ref = 1 order by WeekStartingDate desc limit 1";
                $objResult2 = $this->Comman_model->getCustomQueryData($objSql, 'row');

                $VisitDoneDate = @$objResult2['WeekStartingDate'];
                $ProgressNotesTypeID_Ref = @$objResult2['ProgressNotesTypeID_Ref'];

                if(empty($VisitDoneDate)) {
                    continue;
                }*/

                $VisitDoneDate = $row['WeekStartingDate'];
                $ProgressNotesTypeID_Ref = $row['ProgressNotesTypeID_Ref'];
                
                $VisitDoneDate1 = date('Y-m-d', strtotime($VisitDoneDate));

                if($ProgressNotesTypeID_Ref==1) {
                    $days = $multiplex = 30;
                } else {
                    $days = $multiplex = 29;
                }

                if($ProgressNotesTypeID_Ref==3) { 
                    $days = $multiplex = 180;
                    if($row['FHCA']==1) {
                        $days = $multiplex = 90;  
                    }
                }
                
                $first = strtotime($VisitDoneDate); 
                $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
                $nextvisit = date("Y-m-d",$next); 
                $nextvisit1 = $nextvisit; 
                $datediff = $next - $first;
                $diff = ceil($datediff/(60*60*24));
                $today = date("Y-m-d");
                $date1 = new DateTime($VisitDoneDate);
                $date2 = new DateTime($nextvisit);

                $date2 = new DateTime($VisitDoneDate);
                $date1 = new DateTime($today);
                 //$JobStartDate 
                
                $diff = $date2->diff($date1)->format("%a");
                
                $date2=date_create($today);
                $date1=date_create($nextvisit);
                $diff=date_diff($date1,$date2);
                $diff4 = $diff->format("%a");

                                
                //echo $name.' - '.$staffname.' - '.$VisitDoneDate.' - '.$nextvisit.' - '.$diff.'</br>';

                //if ($diff <= $multiplex )  { $diff = 0;}
                if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00'  ) { 
                    $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
                } else {
                   $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
                   $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
                }

                $hca = '';
                if($row['FHCA']==0) {
                    $hca = 'No';
                }
                if($row['FHCA']==1) {
                    $hca = 'Yes';
                }
               
                $cnt = $cnt + 1;
                $pdf->Cell(40,5,$name,1,0,'L');          
                //$pdf->Cell(10,5,$row['IsActive'],1,0,'L');          
                $pdf->Cell(10,5,$hca,1,0,'L');          
                $pdf->Cell(42,5,$staffname,1,0,'L');       
                $pdf->Cell(22,5,$VisitDoneDate,1,0,'L');       
                $pdf->Cell(22,5,$nextvisit,1,0,'L');
                $pdf->SetFillColor(200,20,24);    
                //if ($diff4 > $multiplex && $VisitDoneDate1<=$today) { $val = 'true';} else  { $val = '';}     
                if ($diff4 > 0) { $val = '';} else  { $val = '';}     
                $Days_Before_Overdue = $overdue = '';
                if($today <= $nextvisit1) {
                    $Days_Before_Overdue = $diff4;    
                } else {
                    //if($diff4!='' && $diff4 > $multiplex) {
                    if($diff4!='' && $diff4 > 0) {
                        $val = 'true';    
                    } else {
                        $val = '';
                    }
                    $overdue = $diff4;    
                }    
                $pdf->Cell(22,5," ".$overdue,1,0,'L',$val);   
                $pdf->Cell(32,5," ".$Days_Before_Overdue,1,1,'L');
             }

             $pdf->Cell(30,5,'*'.$multiplex,0,1,'L');

            $pdf->Output();
        } else {
            redirect();
        }
    }

    public function clientWeeklyDiscussion() {
        if(isset($_SESSION['name'])) {
            //$fromD  = date('Y-m-d', strtotime("first day of -2 month"));
            //$toD    = date('Y-m-d', strtotime('last day of this month'));

            $fromD  = date('Y-m-d');
            $toD    = date('Y-m-d');

            $keyword = '';
            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }
            }
            
            $agency_code = $this->session->userdata('agency');

            $data['patientWeeklytData'] = $this->client->get_weekly_discussions($fromD, $toD, '', $agency_code, $keyword, '', $_POST['status'], $_POST['contact_type']);

            $data['notesTypeData']    =   $this->Comman_model->get_rows('tblprogressnotestypes');

            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['keyword'] = $keyword;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/view-client-weekly-discussion.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/view-client-weekly-discussion-new.php',$data);
        } else {
            redirect();
        }
    }


    public function agingCare() {
        if(isset($_SESSION['name'])) {
            $fromD  = date('Y-m-d');
            $toD    = date('Y-m-d');

            $keyword = '';
            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }
                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }
            }
            
            $sql = "SELECT * FROM patient_aging_care WHERE date_received>='".$fromD."' AND date_received<='".$toD."' ORDER BY aging_id DESC";
            $data['pageData'] = get_data_other_db($sql, "result", "idoa_aging_db");

            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['keyword'] = $keyword;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/view-patient-aging-care.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function clientWeeklypdf() {
      $this->load->view('patient/client-weekly-pdf.php');
    }

    public function clientPhoneCallReport() {
        if(isset($_SESSION['name'])) {

            $data['IsActive'] = @$_GET['IsActive'];              
            $data['fhca'] = @$_GET['fhca'];              
            $data['suplid'] = @$_GET['suplid'];    
            $data['agency_location'] = @$_GET['agency_location'];          
            $data['onHold'] = @$_GET['onHold'];          
            if ($data['IsActive'] == '' || $data['IsActive'] == null )  {
               //$data['IsActive'] = 1;
            } 
            if ($data['fhca'] == '' || $data['fhca'] == null )  {
               $data['fhca'] = 1;
            } 

            if(!empty($_GET['agency_location'])) {
                $where = [];
                $where['su.firstname!='] ='';
                $where['su.agency_location'] = $_GET['agency_location'];
                $data['supervisorData'] = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');    
            }
            

            //$data['supervisorData'] = $this->Comman_model->get_rows('supervisor','','name','asc');    
            $data['locationData'] = $this->Comman_model->get_rows('agency_location');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/clientPhoneCallReport.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect();
        }
    }

    public function clientPhoneCallReportPdf() {
        if(isset($_SESSION['name'])) {

            $agency_code = $this->session->userdata('agency');
            $IsActive = @$_GET['IsActive'];              
            $fhca = @$_GET['fhca'];              
            $suplid = @$_GET['suplid'];   
            $agency_location = @$_GET['agency_location'];           
            $onHold = @$_GET['onHold'];           
            if ($IsActive == '' || $IsActive == null )  {
               //$IsActive = 1;
            } 
            if ($fhca == '' || $fhca == null )  {
               //$fhca = 1;
            } 

            $cnt = 0;
            $ctr = 0;
            $max  = 40;
            $spc = 40;
            $orient = 'P';
            require_once(APPPATH . 'libraries/client-phone-call-report-pdf.php'); 
            $pdf=new clientPhoneCallReportPDF($orient, 'mm',array(215.9,279.4) );
            //$pdf=new PDF('L');
            $where = [];
            $where['agency_code'] = $agency_code;
            $agencyData = $this->Comman_model->get_row('agency', $where);

            $_SESSION['AgencyName'] = $agencyData['agency_shortname'];

            $_SESSION['title'] = "All ";
            if($fhca==1) {
              $_SESSION['title'] = "FHCA ";
            }

            if($fhca==0) {
              $_SESSION['title'] = "NON FHCA ";
            }

            
            //array(100,150)
            $pdf->AliasNbPages();
            $pdf->AddPage($orient);

            $pdf->SetFont('Arial','',8);
            $pdf->SetLeftMargin(10);
            $cond = '';

            if ($fhca == 1 ) { $multiplex = 90; } else { $multiplex = 180;}
            $multiplex = 29;

            $cond = " supervisor_id!=0 AND ";

            if ($suplid != '' ) {
                
                $cond = " supervisor_id = '$suplid' AND ";
                
            }                
                                
            $pdf->setxy(10,$spc);
            $page = 0;
            $counter = 0;

            if(!empty($agency_location)) {
                $cond .= " agency_location = '$agency_location' AND "; 
            }

            if(!empty($onHold)) {
                $cond .= " on_hold = '$onHold' AND "; 
            }

            $result = $this->client->get_client_status_report($agency_code, $cond, $IsActive, $fhca);

            foreach ($result as $key => $row) {

                if ($row['FHCA'] == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

                if ($cnt >= $max) {
                  $page = $page + 1;
                  $cnt = 0; 
                  $pdf->AliasNbPages();
                  $pdf->AddPage($orient);
                  $pdf->setxy(10,$spc);
                }
             
                $ptid = $row['patient_id'];
                $suplid = $row['supervisor_id'];           

                $where = [];
                $where['supervisor_id'] = $suplid;
                $objResult2 = $this->Comman_model->get_row('supervisor', $where);

                $staffname = $objResult2['lastname'].','.$objResult2['firstname'];
                $name = $row['name'];

                $where = [];
                $where['patient_id'] = $ptid;
                $where['Agency'] = $agency_code;
                $objResult2 = $this->Comman_model->get_rows('tblweeklydiscussionsnew', $where, 'WeekStartingDate', 'desc');

                $VisitDoneDate = @$objResult2[0]['WeekStartingDate'];
                $ProgressNotesTypeID_Ref = @$objResult2[0]['ProgressNotesTypeID_Ref'];
                
                $VisitDoneDate1 = date('Y-m-d', strtotime($VisitDoneDate));

                if($ProgressNotesTypeID_Ref==1) {
                    $days = $multiplex = 30;
                } else {
                    $days = $multiplex = 29;
                }

                if($ProgressNotesTypeID_Ref==3) { 
                    $days = $multiplex = 180;
                    if($row['FHCA']==1) {
                      $days = $multiplex = 90;  
                    }
                }
                
                $first = strtotime($VisitDoneDate); 
                $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
                $nextvisit = date("Y-m-d",$next); 
                $nextvisit1 = $nextvisit; 
                $datediff = $next - $first;
                $diff = ceil($datediff/(60*60*24));
                $today = date("Y-m-d");
                $date1 = new DateTime($VisitDoneDate);
                $date2 = new DateTime($nextvisit);

                $date2 = new DateTime($VisitDoneDate);
                $date1 = new DateTime($today);
                 //$JobStartDate 
                
                $diff = $date2->diff($date1)->format("%a");
                
                $date2=date_create($today);
                $date1=date_create($nextvisit);
                $diff=date_diff($date1,$date2);
                $diff4 = $diff->format("%a");

                                
                //echo $name.' - '.$staffname.' - '.$VisitDoneDate.' - '.$nextvisit.' - '.$diff.'</br>';

               //if ($diff <= $multiplex )  { $diff = 0;}
               if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00'  ) { 
                    $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
               } else {
                   $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
                   $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
               }

               $hca = '';
               if($row['FHCA']==0) {
                 $hca = 'No';
               }
               if($row['FHCA']==1) {
                $hca = 'Yes';
               }
               
                $cnt = $cnt + 1;
                $pdf->Cell(40,5,$name,1,0,'L');          
                //$pdf->Cell(10,5,$row['IsActive'],1,0,'L');          
                $pdf->Cell(10,5,$hca,1,0,'L');          
                $pdf->Cell(42,5,$staffname,1,0,'L');       
                $pdf->Cell(22,5,$VisitDoneDate,1,0,'L');       
                $pdf->Cell(22,5,$nextvisit,1,0,'L');
                $pdf->SetFillColor(200,20,24);    
                if ($diff4 > $multiplex && $VisitDoneDate1<=$today) { $val = 'true';} else  { $val = '';}     
                $Days_Before_Overdue = $overdue = '';
                if($today <= $nextvisit1) {
                    $Days_Before_Overdue = $diff4;    
                } else {
                    if($diff4!='' && $diff4 > $multiplex) {
                        $val = 'true';    
                    }
                    $overdue = $diff4;    
                }    
                $pdf->Cell(22,5," ".$overdue,1,0,'L',$val);   
                $pdf->Cell(32,5," ".$Days_Before_Overdue,1,1,'L');
             }

             $pdf->Cell(30,5,'*'.$multiplex,0,1,'L');

            $pdf->Output();
        } else {
            redirect();
        }
    }

    public function clientPhoneCallReportExcel() {
        $agency_code = $this->session->userdata('agency');     
        $fhca = $_GET['fhca'];
        $suplid = $_GET['suplid'];
        $IsActive = $_GET['IsActive'];
        $agency_location = @$_GET['agency_location'];           
        $onHold = @$_GET['onHold'];           

        $temp = "CREATE TEMPORARY TABLE `temp_trans` (
          `LastName` varchar(40) NOT NULL,
          `FirstName` varchar(40) NOT NULL,
          `Full_Name` varchar(40) NOT NULL,
          `Street_Address` varchar(40) NOT NULL,
          `City` varchar(40) NOT NULL,
          `State` varchar(40) NOT NULL,
          `Zip` varchar(40) NOT NULL,
          `Phone` varchar(40) NOT NULL,
          `DOB` varchar(40) NOT NULL,
          `Supervisor` varchar(40) NOT NULL,
          `Last_Call_Date` varchar(20) NOT NULL,          
          `Next_Call_Date` varchar(20) NOT NULL,
          `No` varchar(20) NOT NULL,
          `Active` varchar(20) NOT NULL,
          `Overdue` varchar(20) NOT NULL, 
          `Days_Before_Overdue` varchar(20) NOT NULL)";
          //`ProgressNotes` text(1000) NOT NULL)";
          

        $tempresult = $this->client->createTemporaryTable($temp);
          
        $cond = '';
        if ($fhca == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

        if ($suplid != '' ) {
            $cond = " supervisor_id = '$suplid' AND ";
        }

        if(!empty($agency_location)) {
            $cond .= " agency_location = '$agency_location' AND "; 
        }
        if(!empty($onHold)) {
            $cond .= " on_hold = '$onHold' AND "; 
        }
                            
        $result = $this->client->get_client_status_report($agency_code, $cond, $IsActive, $fhca);

        foreach ($result as $key => $row) {

            if ($row['FHCA'] == 1 ) { $multiplex = 90; } else { $multiplex = 180;}

            $ptid = $row['patient_id'];
            $suplid = $row['supervisor_id'];           
            $where = [];
            $where['supervisor_id'] = $suplid;
            $objResult2 = $this->Comman_model->get_row('supervisor', $where);

            $Supervisor = $objResult2['lastname'].','.$objResult2['firstname'];
            $PatientName = $row['name'];

            $where = [];
            $where['patient_id'] = $ptid;
            $where['Agency'] = $agency_code;
            $objResult2 = $this->Comman_model->get_rows('tblweeklydiscussionsnew', $where, 'WeekStartingDate', 'desc');
            $VisitDoneDate = @$objResult2[0]['WeekStartingDate'];
            $progressNotes = @$objResult2[0]['ProgressNotesDetails'];
            $ProgressNotesTypeID_Ref = @$objResult2[0]['ProgressNotesTypeID_Ref'];

            $VisitDoneDate1 = date('Y-m-d', strtotime($VisitDoneDate));

            if($ProgressNotesTypeID_Ref==1) {
                $days = $multiplex = 30;
            } else {
                $days = $multiplex = 29;
            }

            if($ProgressNotesTypeID_Ref==3) { 
                $days = $multiplex = 180;
                if($row['FHCA']==1) {
                  $days = $multiplex = 90;  
                }
            }

            $first = strtotime($VisitDoneDate); 
            $next = strtotime(date("Y-m-d", strtotime($VisitDoneDate)) . " + ".$days."days");
            $nextvisit = date("Y-m-d",$next);

            $nextvisit1 = $nextvisit;

            $datediff = $next - $first;
            $diff = ceil($datediff/(60*60*24));
            $today = date("Y-m-d");
            $date1 = new DateTime($VisitDoneDate);
            $date2 = new DateTime($nextvisit);

            $date2 = new DateTime($VisitDoneDate);
            $date1 = new DateTime($today);
            
            
            $diff = $date2->diff($date1)->format("%a");

            $date2=date_create($today);
            $date1=date_create($nextvisit);
            $diff=date_diff($date1,$date2);
            $diff4 = $diff->format("%a");

            //echo $name.' - '.$staffname.' - '.$VisitDoneDate.' - '.$nextvisit.' - '.$diff.'</br>';
            //if ($diff <= $multiplex )  { $diff = 0;}
            if ($VisitDoneDate == '' || $VisitDoneDate == '0000-00-00' ) { 
                $VisitDoneDate = ''; $nextvisit = '';  $diff4 = '';
            } else {
                $VisitDoneDate = date("m/d/Y",strtotime($VisitDoneDate));                    
                $nextvisit = date("m/d/Y",strtotime($nextvisit));                    
            }


            $dataArray = [];
            $dataArray['LastName']= $row['lastname'];
            $dataArray['FirstName']= $row['firstname'];
            $dataArray['Full_Name']= $row['name'];
            $dataArray['Street_Address']= $row['ShipAddressAddr2'];
            $dataArray['City']= $row['ShipAddressCity'];
            $dataArray['State']= $row['ShipAddressState'];
            $dataArray['Zip']= $row['ShipAddressPostalCode'];
            $dataArray['Phone']= $row['phone'];
            $dataArray['DOB']= $row['CustomFieldBirthday'];
            $dataArray['Supervisor'] = $Supervisor;
            $dataArray['Last_Call_Date'] = $VisitDoneDate;            
            $dataArray['Next_Call_Date'] = $nextvisit;
            $dataArray['No'] = $row['FHCA'];
            $dataArray['Active'] = $row['IsActive']==1?'Yes':'No';
            //$dataArray['ProgressNotes'] = $progressNotes!=''?$progressNotes:'';
            $dataArray['Days_Before_Overdue'] = '';    
            $dataArray['Overdue'] = '';    
            if($today <= $nextvisit1) {
                $dataArray['Days_Before_Overdue'] = $diff4;    
            } else {
                $dataArray['Overdue'] = $diff4;    
            }
            $this->Comman_model->insert('temp_trans', $dataArray);
         } 


        // file name for download
        $filename = "client_phone_call_report_" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        $row2 = 0;
        $arry = array(' ',' ',' ',' ');
        $result = $this->Comman_model->get_rows('temp_trans');
        foreach ($result as $key => $row) {
            if(!$flag) {
                // display field/column names as first row
                array_walk($row, array($this,'cleanData'));

                echo implode("\t",$arry) . "\r\n";
                echo implode("\t", array_keys($row)) . "\r\n";
                $flag = true;
            }
            array_walk($row, array($this, 'cleanData'));
            $x = 1;
            echo implode("\t", array_values($row)) . "\r\n";
        }         
    }


    public function addClientWeekly() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {
            $where= [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData = $this->Comman_model->get_row('patient', $where);
            $data['patientData'] = $patientData;

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('weekly_date', 'Date', 'trim|required');
                $this->form_validation->set_rules('employee', 'Employee', 'trim|required');
                $this->form_validation->set_rules('contract_type', 'Contract Type', 'trim|required');
                $this->form_validation->set_rules('visitation_notes', 'Progress notes', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $employee_id = $this->input->post('employee',true);
                    $patient_id = $_GET['patient'];

                    $sql = "select * from tblweeklydiscussionsnew where patient_id='".$patient_id."' and employee_id='".$employee_id."' order by recid desc limit 1";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');


                    $weekly_date = $this->input->post('weekly_date',true);

                    $contract_type = $this->input->post('contract_type',true);

                    $dataArray                    = [];
                    $dataArray['Agency']          = $this->session->userdata('agency');
                    $dataArray['patient_id']      = $_GET['patient'];
                    $dataArray['WeekStartingDate']   = date('Y-m-d', strtotime($weekly_date));
                    $dataArray['employee_id']        = $this->input->post('employee',true);
                    $dataArray['ProgressNotesTypeID_Ref'] = $contract_type;
                    $dataArray['ProgressNotesDetails'] = $this->input->post('visitation_notes',true);
                    $dataArray['user_id']         = $this->session->userdata('id');
                    $dataArray['username']        = $this->session->userdata('name');

                    $inserId = $this->Comman_model->insert( "tblweeklydiscussionsnew", $dataArray );

                    if($inserId) {

                        if($contract_type==10) {
                            /********** Start to insert patient_aging_care table ***********/
                            $status = 'ADD';
                            $patient_id = $patientData['patient_id'];
                            $Agency = $patientData['Agency'];

                            $sqla = "SELECT agency_codename FROM agency WHERE agency_code = '".$Agency."'";
                            $rowa = get_custom_query_data($sqla, 'row');
                            $agency_name = $rowa['agency_codename'];

                            $name = $patientData['name'];
                            $lastname = $patientData['lastname'];
                            $firstname = $patientData['firstname'];
                            $middlename = $patientData['middlename'];
                            //$Notes = $patientData['Notes'];
                            $Notes = $this->input->post('visitation_notes',true);
                            $supervisor_id = $patientData['supervisor_id'];

                            $sqls = "SELECT name, email, agency_location FROM supervisor WHERE supervisor_id = '".$supervisor_id."'";
                            $rows = get_custom_query_data($sqls, 'row');
                            $supervisor_name = $rows['name'];
                            $supervisor_email = $rows['email'];
                            $supervisor_agency_location_id = $rows['agency_location'];      

                            $sqlal = "SELECT agency_location_name, lead_supervisor FROM agency_location WHERE agency_location_code = '".$supervisor_agency_location_id."'";
                            $rowal = get_custom_query_data($sqlal, 'row');
                            $supervisor_agency_location = $rowal['agency_location_name'];      
                            $user_id = $rowal['lead_supervisor'];    

                            $sqls = "SELECT email FROM users_portal WHERE user_id = '".$user_id."'";
                            $rows = get_custom_query_data($sqls, 'row');
                            $lead_supervisor_email = $rows['email'];

                            $idoa = $patientData['idoa']=='Y'?'Yes':'No';
                            $clientid = $patientData['clientid'];
                            $controlno = $patientData['controlno'];
                            $ccucontract = $patientData['ccucontract'];
                            $mco = $patientData['mco']==1?'Yes':'No';
                            $agency_location = $patientData['agency_location'];

                            $sqlal = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$patientData['agency_location']."'";
                            $rowal = get_custom_query_data($sqlal, 'row');
                            $agency_location_name = $rowal['agency_location_name'];

                            $insertQuery = "INSERT INTO patient_aging_care (status, patient_id, Agency, name, lastname, firstname, middlename, Notes, supervisor_id, supervisor, idoa, controlno, ccucontract, mco, agency_location, agency_location_name, source, idoa_clientid, agency_name, client_sup_email, lead_sup_email) VALUES('SENT', '$patient_id', '$Agency', '$name', '$lastname', '$firstname', '$middlename', '$Notes', '$supervisor_id', '$supervisor_name', '$idoa', '$controlno', '$ccucontract', '$mco', '$agency_location', '$agency_location_name', 'portal', '$clientid', '$agency_name', '$supervisor_email', '$lead_supervisor_email')";

                            get_data_other_db($insertQuery, "query", "idoa_aging_db");
                        }

                      ############### USER ACTION TRACKING START ####################
                      if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user add Client Weekly Discussions to client id '.$_GET['patient'].' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);    


                        ################## Patient Notes Tracking Start ######################
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['old_notes'] = $row['ProgressNotesDetails'];
                        $dataArray['message'] = $this->session->userdata('name'). ' user add progress notes to client id '.$_GET['patient'].' at '. date('m/d/Y H:i:s');
                        $dataArray['new_notes'] = $this->input->post('visitation_notes',true);
                        $dataArray['change_user_id'] = $patient_id;
                        $dataArray['user_type'] = 'patient';

                        $typeId = $this->input->post('contract_type',true);
                        $where =[];
                        $where['ProgressNotesTypeID'] = $typeId;
                        $notesTypeData    =   $this->Comman_model->get_row('tblprogressnotestypes', $where);
                        $dataArray['call'] = '';
                        $dataArray['timesheet'] = '';
                        $dataArray['visit'] = '';
                        if($typeId==1) {
                          $dataArray['call'] = $notesTypeData['ProgressNotesType'];
                        }
                        if($typeId==2) {
                          $dataArray['timesheet'] = $notesTypeData['ProgressNotesType'];
                        }
                        if($typeId==3) {
                          $dataArray['visit'] = $notesTypeData['ProgressNotesType'];
                        }
                        $this->Comman_model->insert('notes_tracking', $dataArray);
                        ################## Patient Notes Tracking End #########################

                        $dataArray = [];
                        $dataArray['WeekStartingDate']   = date('Y-m-d', strtotime($weekly_date));
                        $dataArray['Task_Completed'] = $notesTypeData['ProgressNotesType'];
                        $dataArray['username'] = $this->session->userdata('name');

                        $where = [];
                        $where['user_id'] = $this->session->userdata('id');
                        $userData = $this->Comman_model->get_row('users_portal', $where);

                        $dataArray['fullname'] = $userData['firstname'].' '.$userData['lastname'];

                        $where = [];
                        $where['patient_id'] = $patient_id;
                        $patientData = $this->Comman_model->get_row('patient', $where);

                        $where = [];
                        $where['agency_location_code'] = $patientData['agency_location'];
                        $locationData = $this->Comman_model->get_row('agency_location', $where);

                        $dataArray['location'] = $locationData['agency_location_name'];

                        $this->Comman_model->insert('tracking_tblweeklydiscussionsnew', $dataArray);

                      }
                      ############### USER ACTION TRACKING END ####################

                      $this->app->message('Client weekly has been added successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/clientWeekly?patient='.$_GET['patient'],'refresh');
                }
            }

            $where  =   [];
            $where['ea.patient_id']  =   $_GET['patient'];
            $data['weeklyEmployeeData']    =   $this->client->get_weekly_employee($where);            
            $data['notesTypeData']    =   $this->Comman_model->get_rows('tblprogressnotestypes');            

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/addClientWeekly.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/addClientWeekly-new.php',$data);
        } else {
            redirect();
        }
    }

    public function editClientWeekly() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['weekly'])) {
            $where= [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData  =   $this->Comman_model->get_row('patient', $where);
            $data['patientData'] = $patientData;

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('weekly_date', 'Date', 'trim|required');
                $this->form_validation->set_rules('employee', 'Employee', 'trim|required');
                $this->form_validation->set_rules('contract_type', 'Contract Type', 'trim|required');
                $this->form_validation->set_rules('visitation_notes', 'Progress notes', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $employee_id = $this->input->post('employee',true);
                    $patient_id = $_GET['patient'];
                    $recid = decode64($_GET['weekly']);

                    $sql = "select * from tblweeklydiscussionsnew where recid='".$recid."'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');

                    $weekly_date = $this->input->post('weekly_date',true);

                    $contract_type = $this->input->post('contract_type',true);

                    $dataArray                        = [];
                    $dataArray['Agency']              = $this->session->userdata('agency');
                    $dataArray['patient_id']          = $_GET['patient'];
                    $dataArray['WeekStartingDate']    = date('Y-m-d', strtotime($weekly_date));
                    $dataArray['employee_id']         = $this->input->post('employee',true);
                    $dataArray['ProgressNotesTypeID_Ref'] = $contract_type;
                    $dataArray['ProgressNotesDetails'] = $this->input->post('visitation_notes',true);
                    $dataArray['user_id']         = $this->session->userdata('id');
                    $dataArray['username']        = $this->session->userdata('name');

                    $where  =   [];
                    $where['recid']  =   decode64($_GET['weekly']);
                    $update = $this->Comman_model->update( "tblweeklydiscussionsnew", $where, $dataArray );

                    if($update) {

                        if($contract_type==10) {
                            /********** Start to insert patient_aging_care table ***********/
                            $status = 'ADD';
                            $patient_id = $patientData['patient_id'];
                            $Agency = $patientData['Agency'];

                            $sqla = "SELECT agency_codename FROM agency WHERE agency_code = '".$Agency."'";
                            $rowa = get_custom_query_data($sqla, 'row');
                            $agency_name = $rowa['agency_codename'];

                            $name = $patientData['name'];
                            $lastname = $patientData['lastname'];
                            $firstname = $patientData['firstname'];
                            $middlename = $patientData['middlename'];
                            //$Notes = $patientData['Notes'];
                            $Notes = $this->input->post('visitation_notes',true);
                            $supervisor_id = $patientData['supervisor_id'];

                            $sqls = "SELECT name, email, agency_location FROM supervisor WHERE supervisor_id = '".$supervisor_id."'";
                            $rows = get_custom_query_data($sqls, 'row');
                            $supervisor_name = $rows['name'];
                            $supervisor_email = $rows['email'];
                            $supervisor_agency_location_id = $rows['agency_location'];      

                            $sqlal = "SELECT agency_location_name, lead_supervisor FROM agency_location WHERE agency_location_code = '".$supervisor_agency_location_id."'";
                            $rowal = get_custom_query_data($sqlal, 'row');
                            $supervisor_agency_location = $rowal['agency_location_name'];      
                            $user_id = $rowal['lead_supervisor'];    

                            $sqls = "SELECT email FROM users_portal WHERE user_id = '".$user_id."'";
                            $rows = get_custom_query_data($sqls, 'row');
                            $lead_supervisor_email = $rows['email'];

                            $idoa = $patientData['idoa']=='Y'?'Yes':'No';
                            $clientid = $patientData['clientid'];
                            $controlno = $patientData['controlno'];
                            $ccucontract = $patientData['ccucontract'];
                            $mco = $patientData['mco']==1?'Yes':'No';
                            $agency_location = $patientData['agency_location'];

                            $sqlal = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$patientData['agency_location']."'";
                            $rowal = get_custom_query_data($sqlal, 'row');
                            $agency_location_name = $rowal['agency_location_name'];

                            $insertQuery = "INSERT INTO patient_aging_care (status, patient_id, Agency, name, lastname, firstname, middlename, Notes, supervisor_id, supervisor, idoa, controlno, ccucontract, mco, agency_location, agency_location_name, source, idoa_clientid, agency_name, client_sup_email, lead_sup_email) VALUES('SENT', '$patient_id', '$Agency', '$name', '$lastname', '$firstname', '$middlename', '$Notes', '$supervisor_id', '$supervisor_name', '$idoa', '$controlno', '$ccucontract', '$mco', '$agency_location', '$agency_location_name', 'portal', '$clientid', '$agency_name', '$supervisor_email', '$lead_supervisor_email')";

                            get_data_other_db($insertQuery, "query", "idoa_aging_db");
                        }

                      ############### USER ACTION TRACKING START ####################
                      if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user update Client Weekly Discussions to client id '.$_GET['patient'].' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);  


                        ################## Patient Notes Tracking Start ######################
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['old_notes'] = $row['ProgressNotesDetails'];
                        $dataArray['message'] = $this->session->userdata('name'). ' user update progress notes to client id '.$_GET['patient'].' at '. date('m/d/Y H:i:s');
                        $dataArray['new_notes'] = $this->input->post('visitation_notes',true);
                        $dataArray['change_user_id'] = $patient_id;
                        $dataArray['user_type'] = 'patient';

                        $typeId = $this->input->post('contract_type',true);
                        $where =[];
                        $where['ProgressNotesTypeID'] = $typeId;
                        $notesTypeData    =   $this->Comman_model->get_row('tblprogressnotestypes', $where);
                        $dataArray['call'] = '';
                        $dataArray['timesheet'] = '';
                        $dataArray['visit'] = '';
                        if($typeId==1) {
                          $dataArray['call'] = $notesTypeData['ProgressNotesType'];
                        }
                        if($typeId==2) {
                          $dataArray['timesheet'] = $notesTypeData['ProgressNotesType'];
                        }
                        if($typeId==3) {
                          $dataArray['visit'] = $notesTypeData['ProgressNotesType'];
                        }
                        $this->Comman_model->insert('notes_tracking', $dataArray);
                        ################## Patient Notes Tracking End #########################

                      }
                      ############### USER ACTION TRACKING END ####################

                      $this->app->message('Client weekly has been updated successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/clientWeekly?patient='.$_GET['patient'],'refresh');
                }
            }

            $where  =   [];
            $where['ea.patient_id']  =   $_GET['patient'];
            $data['weeklyEmployeeData']    =   $this->client->get_weekly_employee($where);            
            $data['notesTypeData']    =   $this->Comman_model->get_rows('tblprogressnotestypes');            

            $where  =   [];
            $where['recid']  =   decode64($_GET['weekly']);
            $data['weeklyData']    =   $this->Comman_model->get_row('tblweeklydiscussionsnew', $where);
            $data['weeklyData']['WeekStartingDate'] =   date('m/d/Y', strtotime($data['weeklyData']['WeekStartingDate']));

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/editClientWeekly.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/editClientWeekly-new.php',$data);
        } else {
            redirect();
        }
    }

    public function delete_Client_Weekly() {

        $id = $this->input->get('delete_id');

        $where = [];
        $where['recid'] = $id;
        $weeklyData = $this->Comman_model->get_row('tblweeklydiscussionsnew', $where);

        $data = $this->db->where('recid',$id)->delete('tblweeklydiscussionsnew');

        if ($data) {

          ############### USER ACTION TRACKING START ####################
          if($this->session->userdata('id')!=6) {
            $dataArray = [];
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['user_action'] = $this->session->userdata('name'). ' user delete Client Weekly Discussions from client id '.$weeklyData['patient_id'].' at '. date('m/d/Y H:i:s');
            $this->Comman_model->insert('users_tracking', $dataArray);   

            ################## Patient Notes Tracking Start ######################
            $dataArray = [];
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['old_notes'] = $weeklyData['ProgressNotesDetails'];
            $dataArray['message'] = $this->session->userdata('name'). ' user delete progress notes to client id '.$weeklyData['patient_id'].' at '. date('m/d/Y H:i:s');
            $dataArray['new_notes'] = $weeklyData['ProgressNotesDetails'];
            $dataArray['change_user_id'] = $weeklyData['patient_id'];
            $dataArray['user_type'] = 'patient';

            $typeId = $weeklyData['ProgressNotesTypeID_Ref'];
            $where =[];
            $where['ProgressNotesTypeID'] = $typeId;
            $notesTypeData    =   $this->Comman_model->get_row('tblprogressnotestypes', $where);
            $dataArray['call'] = '';
            $dataArray['timesheet'] = '';
            $dataArray['visit'] = '';
            if($typeId==1) {
              $dataArray['call'] = $notesTypeData['ProgressNotesType'];
            }
            if($typeId==2) {
              $dataArray['timesheet'] = $notesTypeData['ProgressNotesType'];
            }
            if($typeId==3) {
              $dataArray['visit'] = $notesTypeData['ProgressNotesType'];
            }
            $this->Comman_model->insert('notes_tracking', $dataArray);
            ################## Patient Notes Tracking End ######################### 
          }
          ############### USER ACTION TRACKING END ######################

          $this->app->message('Client weekly has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops something went wrong.', 'error');
        }
        redirect($this->agent->referrer());

    }


    public function clientVisitation() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {
            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $dateofvisit = $upload_date = $employee = $supervisor = '';

            //print_r($this->input->post());

            if(!empty($this->input->post('search'))) {

                $data['employee']       =   $this->input->post('employee');
                $data['supervisor']     =   $this->input->post('supervisor');

                if(!empty($this->input->post('dateofvisit'))) {
                  $data['dateofvisit']    =   $this->input->post('dateofvisit');
                  $dateofvisit  =     date('Y-m-d', strtotime($this->input->post('dateofvisit')));  
                }
                if(!empty($this->input->post('upload_date'))) {
                  $data['upload_date']    =   $this->input->post('upload_date');
                  $upload_date  =     date('Y-m-d', strtotime($this->input->post('upload_date')));  
                }
                
                $employee     =     $this->input->post('employee');
                $supervisor   =     $this->input->post('supervisor');
            }

            $data['patientVisitationData'] = $this->client->get_patient_visitation($_GET['patient'], $dateofvisit, $upload_date, $employee, $supervisor);

            $data['patient_id'] =  $_GET['patient']; 

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/viewVisitationForm.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/viewVisitationForm-new.php',$data);
        } else {
            redirect();
        }
    }

    function district($patient_id) {
        if(isset($_SESSION['name']) && !empty($patient_id)) {
            $where  = [];
            $where['patient_id'] = $patient_id;
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $where  = [];
            $where['patient_id'] = $patient_id;
            $data['trackingDistrictData'] = $this->Comman_model->get_rows('tracking_district', $where, 'district_id', 'desc');

            $data['patient_id'] = $patient_id;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/view-district.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/view-district-new.php',$data);

        } else {
            redirect();
        }
    }


    function district2($patient_id) {
        if(isset($_SESSION['name']) && !empty($patient_id)) {
            $where  = [];
            $where['patient_id'] = $patient_id;
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $where  = [];
            $where['patient_id'] = $patient_id;
            $data['trackingDistrictData'] = $this->Comman_model->get_rows('district', $where, 'district_id', 'desc');

            $data['patient_id'] = $patient_id;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/view-district2.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/view-district2-new.php',$data);
        } else {
            redirect();
        }
    }

    function deleteDistrict($recordId) {
        if(!empty($recordId)){
            $recordId = decode64($recordId);
            $where  = [];
            $where['district_id'] = $recordId;
            $check = $this->Comman_model->delete_row('tracking_district',$where);

            $this->app->message('District has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    function deleteDistrict2($recordId) {
        if(!empty($recordId)){
            $recordId = decode64($recordId);
            $where  = [];
            $where['district_id'] = $recordId;
            $check = $this->Comman_model->delete_row('district',$where);

            $this->app->message('District has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    function addPatientDistrict($patient_id) {
        if (isset($_SESSION['name'])) { 

            $sql = "SELECT * FROM patient WHERE patient_id='".$patient_id."'";
            $ptRow = $this->Comman_model->getCustomQueryData($sql, 'row');

            if( !empty( $this->input->post( 'submit' ) ) ){

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('modified_date', 'Modified Date', 'trim|required');
                $this->form_validation->set_rules('DistrictID_Ref', 'District', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $DistrictID_Ref = $this->input->post('DistrictID_Ref',true);
                    $modifiedDate = $this->input->post('modified_date',true);

                    //$mco = $this->input->post('mco',true);
                    //if($mco=='') {
                    $sql = "SELECT * FROM tbldistricts WHERE DistrictID='".$DistrictID_Ref."' AND Agency='".$ptRow['Agency']."'";
                    $districtRow = $this->Comman_model->getCustomQueryData($sql, 'row');
                    $mco = $districtRow['mco'];
                    $payorGrp = $districtRow['payorGrp'];
                    //}

                    $dataArray                   = [];
                    $dataArray['start_date']     = $this->input->post('start_date',true);
                    $dataArray['date_modified']  = $modifiedDate;
                    $dataArray['DistrictID_Ref'] = $DistrictID_Ref;
                    $dataArray['mco']            = $mco;
                    $dataArray['month']          = date('n', strtotime($modifiedDate));
                    $dataArray['year']           = date('Y', strtotime($modifiedDate));
                    $dataArray['patient_id']     = $patient_id;
                    $dataArray['payorGrp']       = $payorGrp;

                    $inserId = $this->Comman_model->insert("tracking_district", $dataArray);
                    if ($inserId) {
                        $this->app->message('Patient tracking district has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/district/'.$patient_id,'refresh');
                }
            }

            

            $sql = "SELECT * FROM tbldistricts WHERE Agency='".$ptRow['Agency']."' and DistrictName!='' order by DistrictName asc";
            $allDistrict = $this->Comman_model->getCustomQueryData($sql);

            $data = [];
            $data['allDistrict'] = $allDistrict;
            $data['patient_id'] = $patient_id;


            $data['page'] = 'Add District';
            
            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('patient/add-district.php', $data);
            $this->load->view('common/footer.php');
            */
            
            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php', $data);
            $this->load->view('patient/add-district-new.php', $data);
            
        } else {
            redirect($this->agent->referrer());
        }
    }

    function addPatientDistrict2($patient_id) {
        if (isset($_SESSION['name'])) { 

            $sql = "SELECT * FROM patient WHERE patient_id='".$patient_id."'";
            $ptRow = $this->Comman_model->getCustomQueryData($sql, 'row');

            if( !empty( $this->input->post( 'submit' ) ) ){

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('modified_date', 'Modified Date', 'trim|required');
                $this->form_validation->set_rules('DistrictID_Ref', 'District', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $DistrictID_Ref = $this->input->post('DistrictID_Ref',true);
                    $modifiedDate = $this->input->post('modified_date',true);

                    $sql = "SELECT * FROM tbldistricts WHERE DistrictID='".$DistrictID_Ref."' AND Agency='".$ptRow['Agency']."'";
                    $districtRow = $this->Comman_model->getCustomQueryData($sql, 'row');
                    $mco = $districtRow['mco'];
                    //$mco = $this->input->post('mco',true);

                    $dataArray                   = [];
                    $dataArray['start_date']     = $this->input->post('start_date',true);
                    $dataArray['date_modified']  = $modifiedDate;
                    $dataArray['DistrictID_Ref'] = $DistrictID_Ref;
                    $dataArray['mco']            = $mco;
                    $dataArray['month']          = date('n', strtotime($modifiedDate));
                    $dataArray['year']           = date('Y', strtotime($modifiedDate));
                    $dataArray['patient_id']     = $patient_id;

                    $inserId = $this->Comman_model->insert("district", $dataArray);
                    if ($inserId) {
                        $this->app->message('Patient tracking district has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/district2/'.$patient_id,'refresh');
                }
            }

            

            $sql = "SELECT * FROM tbldistricts WHERE Agency='".$ptRow['Agency']."' and DistrictName!='' order by DistrictName asc";
            $allDistrict = $this->Comman_model->getCustomQueryData($sql);

            $data = [];
            $data['allDistrict'] = $allDistrict;
            $data['patient_id'] = $patient_id;


            $data['page'] = 'Add District';
            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('patient/add-district2.php', $data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php', $data);
            $this->load->view('patient/add-district2-new.php', $data);
        } else {
            redirect($this->agent->referrer());
        }
    }

    function editPatientDistrict($pageId='', $patient_id) {
        if (isset($_SESSION['name'])) { 
            $pageId = $this->uri->segment('3');
            if(!empty($pageId)) {
                //$pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['district_id'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('tracking_district',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('modified_date', 'Modified Date', 'trim|required');
                $this->form_validation->set_rules('DistrictID_Ref', 'District', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $DistrictID_Ref = $this->input->post('DistrictID_Ref',true);
                    $modifiedDate = $this->input->post('modified_date',true);

                    $sql = "SELECT * FROM patient WHERE patient_id='".$patient_id."'";
                    $ptRow = $this->Comman_model->getCustomQueryData($sql, 'row');

                    $sql = "SELECT * FROM tbldistricts WHERE DistrictID='".$DistrictID_Ref."' AND Agency='".$ptRow['Agency']."'";
                    $districtRow = $this->Comman_model->getCustomQueryData($sql, 'row');
                    //$mco = $districtRow['mco'];
                    $mco = $this->input->post('mco',true);

                    $payorGrp = $districtRow['payorGrp'];

                    $dataArray                   = [];
                    $dataArray['start_date']     = $this->input->post('start_date',true);
                    $dataArray['date_modified']  = $modifiedDate;
                    $dataArray['DistrictID_Ref'] = $DistrictID_Ref;
                    $dataArray['mco']            = $mco;
                    $dataArray['month']          = date('n', strtotime($modifiedDate));
                    $dataArray['year']           = date('Y', strtotime($modifiedDate));
                    $dataArray['patient_id']     = $patient_id;
                    $dataArray['payorGrp']       = $payorGrp;

                    $where  =   [];
                    $where['district_id'] =   $pageId;

                    $updateId = $this->Comman_model->update( "tracking_district", $where, $dataArray );

                    if ($updateId) {
                        $this->app->message('Patient tracking district has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/district/'.$patient_id,'refresh');
                }
            }

            $sql = "SELECT * FROM patient WHERE patient_id='".$patient_id."'";
            $ptRow = $this->Comman_model->getCustomQueryData($sql, 'row');

            $sql = "SELECT * FROM tbldistricts WHERE Agency='".$ptRow['Agency']."' and DistrictName!='' order by DistrictName asc";
            $allDistrict = $this->Comman_model->getCustomQueryData($sql);

            $data['allDistrict'] = $allDistrict;
            $data['patient_id'] = $patient_id;

            $data['page'] = 'Update Patient Tracking District';
            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('patient/edit-district.php', $data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php', $data);
            $this->load->view('patient/edit-district-new.php', $data);
        } else {
            redirect('');
        }
    }  


    function editPatientDistrict2($pageId='', $patient_id) {
        if (isset($_SESSION['name'])) { 
            $pageId = $this->uri->segment('3');
            if(!empty($pageId)) {
                //$pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['district_id'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('district',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('modified_date', 'Modified Date', 'trim|required');
                $this->form_validation->set_rules('DistrictID_Ref', 'District', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $DistrictID_Ref = $this->input->post('DistrictID_Ref',true);
                    $modifiedDate = $this->input->post('modified_date',true);

                    $sql = "SELECT * FROM tbldistricts WHERE DistrictID='".$DistrictID_Ref."'";
                    $districtRow = $this->Comman_model->getCustomQueryData($sql, 'row');
                    //$mco = $districtRow['mco'];
                    $mco = $this->input->post('mco',true);

                    $dataArray                   = [];
                    $dataArray['start_date']     = $this->input->post('start_date',true);
                    $dataArray['date_modified']  = $modifiedDate;
                    $dataArray['DistrictID_Ref'] = $DistrictID_Ref;
                    $dataArray['mco']            = $mco;
                    $dataArray['month']          = date('n', strtotime($modifiedDate));
                    $dataArray['year']           = date('Y', strtotime($modifiedDate));
                    $dataArray['patient_id']     = $patient_id;

                    $where  =   [];
                    $where['district_id'] =   $pageId;

                    $updateId = $this->Comman_model->update( "district", $where, $dataArray );

                    if ($updateId) {
                        $this->app->message('Patient tracking district has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/district2/'.$patient_id,'refresh');
                }
            }

            $sql = "SELECT * FROM patient WHERE patient_id='".$patient_id."'";
            $ptRow = $this->Comman_model->getCustomQueryData($sql, 'row');

            $sql = "SELECT * FROM tbldistricts WHERE Agency='".$ptRow['Agency']."' and DistrictName!='' order by DistrictName asc";
            $allDistrict = $this->Comman_model->getCustomQueryData($sql);

            $data['allDistrict'] = $allDistrict;
            $data['patient_id'] = $patient_id;

            $data['page'] = 'Update Patient Tracking District';

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('patient/edit-district2.php', $data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php', $data);
            $this->load->view('patient/edit-district2-new.php', $data);
        } else {
            redirect('');
        }
    }  

    public function clientPOC() {

        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
            //error_reporting(E_ALL);

        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {
          
          $agency_code = $this->session->userdata('agency');     
          $emplok = @$_GET["emplok"];
          $x = @$_GET['formlist'];
          $tasklist = '';
          for ($z = 1 ;$z < 16; $z++ ) {
            $tasklist =  $tasklist.$x[$z].',';
          }

          $data['tasklist'] = $tasklist;

          $recno = @$_GET['patient'];
          $ID = $recno;
          $plc_id = @$_GET['plc_id'];

          $ptid= $ID;
         
          $mon = @$_GET['mon'];
          $tue = @$_GET['tue'];
          $wed = @$_GET['wed'];
          $thu = @$_GET['thu'];
          $fri = @$_GET['fri'];
          $sat = @$_GET['sat'];
          $sun = @$_GET['sun'];

          $emplid2 = @$_GET['emplid2'];
          $location = @$_GET["location"];
          $dailyhrs = @$_GET["dailyhrs"];
          $dailyhrslimit = @$_GET["dailyhrslimit"];


          $homemaker_name = !empty($_GET['homemaker_name'])?$_GET['homemaker_name']:'';
          $homemaker_tel = !empty($_GET['homemaker_tel'])?$_GET['homemaker_tel']:'';
          $date_assigned = !empty($_GET['date_assigned'])?$_GET['date_assigned']:'';
          $date_of_services = !empty($_GET['date_of_services'])?$_GET['date_of_services']:'';
          $client_condition = !empty($_GET['client_condition'])?$_GET['client_condition']:'';
          $no_seen_days = @$_GET['no_seen_days'];
          $no_hours = @$_GET['no_hours'];
          $from_time = @$_GET['from_time'];
          $to_time = @$_GET['to_time'];
          $from_time1 = @$_GET['from_time1'];
          $to_time1 = @$_GET['to_time1'];
          $location = @$_GET['location'];

          $where = [];
          $where['patient_id'] = $recno;
          $row = $this->Comman_model->get_row('patient', $where);

          $data['patientData'] = $row;

          $name= " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['name'];
          $ShipAddressAddr1 = $row['ShipAddressAddr1'];
          $ShipAddressAddr2 = $row['ShipAddressAddr2'];
          $ShipAddressAddr3 = $row['ShipAddressAddr3'];
          $ShipAddressAddr4 = $row['ShipAddressAddr4'];
          $ShipAddressCity = $row['ShipAddressCity'];
          $ShipAddressState = $row['ShipAddressState'];
          $agency_location = $row['agency_location'];

          $mon_limit = $row['mon_limit'];
          $tue_limit = $row['tue_limit'];
          $wed_limit = $row['wed_limit'];
          $thu_limit = $row['thu_limit'];
          $fri_limit = $row['fri_limit'];
          $sat_limit = $row['sat_limit'];
          $sun_limit = $row['sun_limit'];            

          $mon_limit1 = $row['mon_limit1'];
          $tue_limit1 = $row['tue_limit1'];
          $wed_limit1 = $row['wed_limit1'];
          $thu_limit1 = $row['thu_limit1'];
          $fri_limit1 = $row['fri_limit1'];
          $sat_limit1 = $row['sat_limit1'];
          $sun_limit1 = $row['sun_limit1'];  

          $mon_limit2 = $row['mon_limit2'];
          $tue_limit2 = $row['tue_limit2'];
          $wed_limit2 = $row['wed_limit2'];
          $thu_limit2 = $row['thu_limit2'];
          $fri_limit2 = $row['fri_limit2'];
          $sat_limit2 = $row['sat_limit2'];
          $sun_limit2 = $row['sun_limit2'];            

          $ShipAddressPostalCode = $row['ShipAddressPostalCode'];
          $phone =  " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['phone'];
          $address =  " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$ShipAddressAddr1.' '.$ShipAddressAddr2.' '.$ShipAddressAddr3.' '.$ShipAddressAddr4.' '.$ShipAddressCity.' '.$ShipAddressState.' '.$ShipAddressPostalCode;
          $data['address'] = $address;
          $contactperson = " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['contactperson'];
          $contactno = " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['contactno']; 

          if ($_GET['formSubmit'] == 'Print'  || $_GET['formSubmit'] == 'PDF' ||  $_GET['formSubmit'] == 'Submit') {

              $data['formSubmit'] = 'PDF';

              $mon_limit = $_GET['mon_limit'];
              $tue_limit = $_GET['tue_limit'];
              $wed_limit = $_GET['wed_limit'];
              $thu_limit = $_GET['thu_limit'];
              $fri_limit = $_GET['fri_limit'];
              $sat_limit = $_GET['sat_limit'];
              $sun_limit = $_GET['sun_limit'];

              $mon_limit1 = $_GET['mon_limit1'];
              $tue_limit1 = $_GET['tue_limit1'];
              $wed_limit1 = $_GET['wed_limit1'];
              $thu_limit1 = $_GET['thu_limit1'];
              $fri_limit1 = $_GET['fri_limit1'];
              $sat_limit1 = $_GET['sat_limit1'];
              $sun_limit1 = $_GET['sun_limit1'];                

              $mon_limit2 = $_GET['mon_limit2'];
              $tue_limit2 = $_GET['tue_limit2'];
              $wed_limit2 = $_GET['wed_limit2'];
              $thu_limit2 = $_GET['thu_limit2'];
              $fri_limit2 = $_GET['fri_limit2'];
              $sat_limit2 = $_GET['sat_limit2'];
              $sun_limit2 = $_GET['sun_limit2'];

             if ($emplok != "yes") {

                $dataArray = [];
                $dataArray['dailyhrs']  = $dailyhrs;
                $dataArray['mon_limit'] = $mon_limit;
                $dataArray['tue_limit'] = $tue_limit;
                $dataArray['wed_limit'] = $wed_limit;
                $dataArray['thu_limit'] = $thu_limit;
                $dataArray['fri_limit'] = $fri_limit;
                $dataArray['sat_limit'] = $sat_limit;
                $dataArray['sun_limit'] = $sun_limit;

                $dataArray['mon_limit1'] = $mon_limit1;
                $dataArray['tue_limit1'] = $tue_limit1;
                $dataArray['wed_limit1'] = $wed_limit1;
                $dataArray['thu_limit1'] = $thu_limit1;
                $dataArray['fri_limit1'] = $fri_limit1;
                $dataArray['sat_limit1'] = $sat_limit1;
                $dataArray['sun_limit1'] = $sun_limit1;

                $dataArray['mon_limit2'] = $mon_limit2;
                $dataArray['tue_limit2'] = $tue_limit2;
                $dataArray['wed_limit2'] = $wed_limit2;
                $dataArray['thu_limit2'] = $thu_limit2;
                $dataArray['fri_limit2'] = $fri_limit2;
                $dataArray['sat_limit2'] = $sat_limit2;
                $dataArray['sun_limit2'] = $sun_limit2;

                $dataArray['dailyhrslimit'] = $dailyhrslimit;

                $where = [];
                $where['patient_id'] = $recno;
                $this->Comman_model->update('patient', $where, $dataArray);

             }   
          }

          $st = "disabled='disabled'";    
          $add = 0; 
          $strSQL7 = "SELECT * FROM plan_of_care WHERE plc_id = '$plc_id'";
          $objResult7 = $this->Comman_model->getCustomQueryData($strSQL7, 'row');


          if (empty($objResult7)) { 

            if ($_GET['formSubmit'] == 'Print'  || $_GET['formSubmit'] == 'PDF'  || $_GET['formSubmit'] == 'Submit') {

              $created = date("m/d/Y  g:i:s A");
              $data['created'] = $created;
              //echo $created;
              $add = 1;

              $dataArray = [];
              $dataArray['plc_id'] = null;
              $dataArray['patient_id'] = $recno;
              $dataArray['employee_id'] = $emplid2;
              $dataArray['homemaker_tel'] = $homemaker_tel;
              $dataArray['homemaker_name'] = $homemaker_name;
              $dataArray['location'] = $location;
              $dataArray['created'] = $created;

              $plc_id = $this->Comman_model->insert('plan_of_care', $dataArray);
              $plc=  $plc_id; 

              $strSQL6 = "SELECT * FROM employee WHERE employee_id = '$emplid2'";
              $objResult6 = $this->Comman_model->getCustomQueryData($strSQL6, 'row');
              $homemaker_tel = $objResult6['phone'];
              $homemaker_name = $objResult6['lastname'].',  '.$objResult6['firstname'];


              $dataArray = [];
              $dataArray['employee_id'] = $emplid2;
              $dataArray['mon'] = $mon_limit;
              $dataArray['tue'] = $tue_limit;
              $dataArray['wed'] = $wed_limit;
              $dataArray['thu'] = $thu_limit;
              $dataArray['fri'] = $fri_limit;
              $dataArray['sat'] = $sat_limit;
              $dataArray['sun'] = $sun_limit;

              $dataArray['mon1'] = $mon_limit1;
              $dataArray['tue1'] = $tue_limit1;
              $dataArray['wed1'] = $wed_limit1;
              $dataArray['thu1'] = $thu_limit1;
              $dataArray['fri1'] = $fri_limit1;
              $dataArray['sat1'] = $sat_limit1;
              $dataArray['sun1'] = $sun_limit1;

              $dataArray['mon2'] = $mon_limit2;
              $dataArray['tue2'] = $tue_limit2;
              $dataArray['wed2'] = $wed_limit2;
              $dataArray['thu2'] = $thu_limit2;
              $dataArray['fri2'] = $fri_limit2;
              $dataArray['sat2'] = $sat_limit2;
              $dataArray['sun2'] = $sun_limit2;

              $dataArray['tasks'] = $tasklist;
              $dataArray['homemaker_name'] = $homemaker_name;
              $dataArray['homemaker_tel'] = $homemaker_tel;
              $dataArray['date_assigned'] = $date_assigned;
              $dataArray['client_condition'] = $client_condition;
              $dataArray['date_of_services'] = $date_of_services;
              $dataArray['no_seen_days'] = $no_seen_days;
              $dataArray['no_hours'] = $no_hours;
              $dataArray['from_time'] = $from_time;
              $dataArray['to_time'] = $to_time;
              $dataArray['from_time1'] = $from_time1;
              $dataArray['to_time1'] = $to_time1;
              $dataArray['from_time2'] = $from_time2;
              $dataArray['to_time2'] = $to_time2;

              $where = [];
              $where['plc_id'] = $plc_id;

              $this->Comman_model->update('plan_of_care', $where, $dataArray);


              $val = 0;         


              $where = [];
              $where['patient_id'] = $recno;

              $dataArray = [];
              $dataArray['Eating'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Bathing'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Grooming'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Dressing'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Transferring'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Incontinence'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['ManagingMoney'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Telephoning'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['PreparingMeals'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Laundry'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Housework'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['OutsideHome'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['RoutineHealth'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['SpecialHealth'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['BeingAlone'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $t = explode(",",$tasklist);
              $x =  count($t);
              $val = -1;
              for ($idx = 0;$idx <= $x; $idx++) {
                $tc = $t[$idx];
                $where = [];
                $where['patient_id'] = $recno;
                if ($tc == "1")  {
                  $dataArray = [];
                  $dataArray['Eating'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "2")  {
                  $dataArray = [];
                  $dataArray['Bathing'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "3") {
                  $dataArray = [];
                  $dataArray['Grooming'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "4")  {
                  $dataArray['Dressing'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "5")  {
                  $dataArray['Transferring'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "6")  {
                  $dataArray['Incontinence'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "7")  {
                  $dataArray['ManagingMoney'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "8")  {
                  $dataArray['Telephoning'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "9")  {
                  $dataArray['PreparingMeals'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "10")  {
                  $dataArray['Laundry'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "11")  {
                  $dataArray['Housework'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "12")  {
                  $dataArray['OutsideHome'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "13")  {
                  $dataArray['RoutineHealth'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "14")  {
                  $dataArray['SpecialHealth'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "15")  {
                  $dataArray['BeingAlone'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
              }
            }   
          }


          $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
          $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
          $total = $objResult3["toplam"];
        /**/

          $strSQL = "SELECT * FROM plan_of_care WHERE plc_id = '$plc_id'";
          $objResult = $this->Comman_model->getCustomQueryData($strSQL, 'row');

          if (empty($objResult)) {
            if ($total == 1 )   {
              $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
              $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');

              $emplid2 = $objResult4["employee_id"];
              $homemaker_tel = $objResult4["phone"];
              $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
            } 
          } else {

            $mon_limit = $objResult['mon'];
            $tue_limit = $objResult['tue'];
            $wed_limit = $objResult['wed'];
            $thu_limit = $objResult['thu'];
            $fri_limit = $objResult['fri'];
            $sat_limit = $objResult['sat'];
            $sun_limit = $objResult['sun'];

            $mon_limit1 = $objResult['mon1'];
            $tue_limit1 = $objResult['tue1'];
            $wed_limit1 = $objResult['wed1'];
            $thu_limit1 = $objResult['thu1'];
            $fri_limit1 = $objResult['fri1'];
            $sat_limit1 = $objResult['sat1'];
            $sun_limit1 = $objResult['sun1'];

            $mon_limit2 = $objResult['mon2'];
            $tue_limit2 = $objResult['tue2'];
            $wed_limit2 = $objResult['wed2'];
            $thu_limit2 = $objResult['thu2'];
            $fri_limit2 = $objResult['fri2'];
            $sat_limit2 = $objResult['sat2'];
            $sun_limit2 = $objResult['sun2'];

            $homemaker_name = $objResult['homemaker_name'];
            $homemaker_tel = $objResult['homemaker_tel'];
            $date_assigned = $objResult['date_assigned'];
            $client_condition = $objResult['client_condition'];
            $no_seen_days = $objResult['no_seen_days'];
            $no_hours = $objResult['no_hours'];
            $date_of_services = $objResult['date_of_services'];
            $location = $objResult['location'];
            $created = $objResult['created'];

            $from_time = $objResult['from_time'];
            $to_time = $objResult['to_time'];

            $from_time1 = $objResult['from_time1'];
            $to_time1 = $objResult['to_time1'];
            $emplid2 = $objResult['employee_id'];
          }

          if ($mon == 'x')  { $checkstatus1="checked"; }              
          if ($tue == 'x')  { $checkstatus2="checked"; }             
          if ($wed == 'x')  { $checkstatus3="checked"; }             
          if ($thu == 'x')  { $checkstatus4="checked"; }             
          if ($fri == 'x')  { $checkstatus5="checked"; }             
          if ($sat == 'x')  { $checkstatus6="checked"; }             
          if ($sun == 'x')  { $checkstatus7="checked"; }         

          $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
          $total = 0;
          $sqls = $this->Comman_model->getCustomQueryData($sql, 'row');
               
          $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;   
          $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
          foreach ($objExec2 as $key => $objResult2) {
            if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1"; }
            if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2"; }
            if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
            if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
            if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
            if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
            if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
            if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
            if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
            if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
            if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
            if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
            if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
            if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
            if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
          }  

          if ($location == "" ) {
            $location = $agency_location;
          }

          if(!empty($_GET['formSubmit']) && $_GET['formSubmit']=='Print') {
            if(!empty($data['created'])){ $data['st1'] = "disabled='disabled'";}
          }

          $mon = 'x';
          $tue = 'x';
          $wed = 'x';
          $thu = 'x';
          $fri = 'x';
          $sat = 'x';
          $sun = 'x';


          $sql1 = "SELECT * FROM employee_assignment WHERE patient_id = '$recno' AND employee_id = '$emplid2'";
          $row1 = $this->Comman_model->getCustomQueryData($sql1, 'row'); 

          if ($emplok == 'yes')  {
            if ($row1["mon_limit"]  == 0   )  {  $mon_limit = 0;  }
            if ($row1["tue_limit"]  == 0   )  {  $tue_limit = 0;  }
            if ($row1["wed_limit"]  == 0   )  {  $wed_limit = 0;  }
            if ($row1["thu_limit"]  == 0   )  {  $thu_limit = 0;  }
            if ($row1["fri_limit"]  == 0   )  {  $fri_limit = 0;  }
            if ($row1["sat_limit"]  == 0   )  {  $sat_limit = 0;  }
            if ($row1["sun_limit"]  == 0   )  {  $sun_limit = 0;  }

            if ($row1["mon_limit1"]  == 0   )  {  $mon_limit1 = 0;  }
            if ($row1["tue_limit1"]  == 0   )  {  $tue_limit1 = 0;  }
            if ($row1["wed_limit1"]  == 0   )  {  $wed_limit1 = 0;  }
            if ($row1["thu_limit1"]  == 0   )  {  $thu_limit1 = 0;  }
            if ($row1["fri_limit1"]  == 0   )  {  $fri_limit1 = 0;  }
            if ($row1["sat_limit1"]  == 0   )  {  $sat_limit1 = 0;  }
            if ($row1["sun_limit1"]  == 0   )  {  $sun_limit1 = 0;  }

            if ($row1["mon_limit2"]  == 0   )  {  $mon_limit2 = 0;  }
            if ($row1["tue_limit2"]  == 0   )  {  $tue_limit2 = 0;  }
            if ($row1["wed_limit2"]  == 0   )  {  $wed_limit2 = 0;  }
            if ($row1["thu_limit2"]  == 0   )  {  $thu_limit2 = 0;  }
            if ($row1["fri_limit2"]  == 0   )  {  $fri_limit2 = 0;  }
            if ($row1["sat_limit2"]  == 0   )  {  $sat_limit2 = 0;  }
            if ($row1["sun_limit2"]  == 0   )  {  $sun_limit2 = 0;  }

            $data['st1'] = "readonly='readonly'";
          }

          $data['st'] = "disabled='disabled'";

          $where  = [];
          $where['agency_code'] = $agency_code;
          $data['agency']    =   $this->Comman_model->get_row('agency', $where);

          $where  = [];
          $data['agencyLocation']    =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

          $where  = [];
          $data['employeeTask']    =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

          $where  = [];
          $where['pc.patient_id'] = $_GET['patient'];
          $data['planOfCareEmpleyee']    =   $this->client->get_plan_of_care_employee($where);

          $where  = [];
          $where['ea.patient_id'] = $_GET['patient'];
          $data['assignEmployeeData']    =   $this->client->get_assigned_employee($where);

          $where= [];
          $where['patient_id'] = $_GET['patient'];
          $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where);
          $data['patient_id'] =  $_GET['patient']; 


          $where = [];
          $where['patient_id'] = $_GET['patient'];
          $plcData = $this->Comman_model->get_row('plan_of_care', $where);

          $where = [];
          $where['employee_id'] = $plcData['employee_id'];
          $employeeData = $this->Comman_model->get_row('employee', $where);
          $data['homemaker_tel'] = $employeeData['phone'];
          $data['homemaker_name'] = $employeeData['lastname'].',  '.$employeeData['firstname'];
          $data['date_assigned'] = $plcData['date_assigned'];
          //$data['client_condition'] = $plcData['client_condition'];

          $data['emplid2'] = @$_GET['emplid2'];
          $data['Agency'] = $this->session->userdata('agency');

          $data['plc_id'] = @$plc_id;
          $data['add'] = @$add;
          $data['recno'] = @$recno;

          $data['tasklist'] = $tasklist;

          $data['mon_limit'] = $mon_limit;
          $data['tue_limit'] = $tue_limit;
          $data['wed_limit'] = $wed_limit;
          $data['thu_limit'] = $thu_limit;
          $data['fri_limit'] = $fri_limit;
          $data['sat_limit'] = $sat_limit;
          $data['sun_limit'] = $sun_limit; 

          $data['mon_limit1'] = $mon_limit1;
          $data['tue_limit1'] = $tue_limit1;
          $data['wed_limit1'] = $wed_limit1;
          $data['thu_limit1'] = $thu_limit1;
          $data['fri_limit1'] = $fri_limit1;
          $data['sat_limit1'] = $sat_limit1;
          $data['sun_limit1'] = $sun_limit1; 

          $data['mon_limit2'] = $mon_limit2;
          $data['tue_limit2'] = $tue_limit2;
          $data['wed_limit2'] = $wed_limit2;
          $data['thu_limit2'] = $thu_limit2;
          $data['fri_limit2'] = $fri_limit2;
          $data['sat_limit2'] = $sat_limit2;
          $data['sun_limit2'] = $sun_limit2; 

          $data['no_seen_days'] = $no_seen_days; 
          $data['from_time'] = $from_time; 
          $data['to_time'] = $to_time; 
          $data['from_time1'] = $from_time1; 
          $data['to_time1'] = $to_time1; 
          $data['from_time2'] = $from_time2; 
          $data['to_time2'] = $to_time2; 
          $data['no_hours'] = $no_hours; 
          $data['emplok'] = $emplok; 
          

          $data['client_condition'] = $client_condition;

          $data['hoursType'] = $_GET['hoursType'];
 
          $this->load->view('patient-poc.php',$data);
        } else {
          redirect();
        }
    }


    public function clientPOCOLD() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {
          
          $agency_code = $this->session->userdata('agency');     
          $emplok = @$_GET["emplok"];
          $x = @$_GET['formlist'];
          $tasklist = '';
          for ($z = 1 ;$z < 16; $z++ ) {
            $tasklist =  $tasklist.$x[$z].',';
          }

          $data['tasklist'] = $tasklist;

          $recno = @$_GET['patient'];
          $ID = $recno;
          $plc_id = @$_GET['plc_id'];

          $ptid= $ID;
         
          $mon = @$_GET['mon'];
          $tue = @$_GET['tue'];
          $wed = @$_GET['wed'];
          $thu = @$_GET['thu'];
          $fri = @$_GET['fri'];
          $sat = @$_GET['sat'];
          $sun = @$_GET['sun'];

          $emplid2 = @$_GET['emplid2'];
          $location = @$_GET["location"];
          $dailyhrs = @$_GET["dailyhrs"];
          $dailyhrslimit = @$_GET["dailyhrslimit"];


          $homemaker_name = !empty($_GET['homemaker_name'])?$_GET['homemaker_name']:'';
          $homemaker_tel = !empty($_GET['homemaker_tel'])?$_GET['homemaker_tel']:'';
          $date_assigned = !empty($_GET['date_assigned'])?$_GET['date_assigned']:'';
          $date_of_services = !empty($_GET['date_of_services'])?$_GET['date_of_services']:'';
          $client_condition = !empty($_GET['client_condition'])?$_GET['client_condition']:'';
          $no_seen_days = @$_GET['no_seen_days'];
          $no_hours = @$_GET['no_hours'];
          $from_time = @$_GET['from_time'];
          $to_time = @$_GET['to_time'];
          $location = @$_GET['location'];

          $where = [];
          $where['patient_id'] = $recno;
          $row = $this->Comman_model->get_row('patient', $where);

          $data['patientData'] = $row;

          $name= " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['name'];
          $ShipAddressAddr1 = $row['ShipAddressAddr1'];
          $ShipAddressAddr2 = $row['ShipAddressAddr2'];
          $ShipAddressAddr3 = $row['ShipAddressAddr3'];
          $ShipAddressAddr4 = $row['ShipAddressAddr4'];
          $ShipAddressCity = $row['ShipAddressCity'];
          $ShipAddressState = $row['ShipAddressState'];
          $agency_location = $row['agency_location'];

          $mon_limit = $row['mon_limit'];
          $tue_limit = $row['tue_limit'];
          $wed_limit = $row['wed_limit'];
          $thu_limit = $row['thu_limit'];
          $fri_limit = $row['fri_limit'];
          $sat_limit = $row['sat_limit'];
          $sun_limit = $row['sun_limit'];            
          $ShipAddressPostalCode = $row['ShipAddressPostalCode'];
          $phone =  " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['phone'];
          $address =  " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$ShipAddressAddr1.' '.$ShipAddressAddr2.' '.$ShipAddressAddr3.' '.$ShipAddressAddr4.' '.$ShipAddressCity.' '.$ShipAddressState.' '.$ShipAddressPostalCode;
          $data['address'] = $address;
          $contactperson = " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['contactperson'];
          $contactno = " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$row['contactno']; 

          if ($_GET['formSubmit'] == 'Print'  || $_GET['formSubmit'] == 'PDF' ||  $_GET['formSubmit'] == 'Submit') {
              $mon_limit = $_GET['mon_limit'];
              $tue_limit = $_GET['tue_limit'];
              $wed_limit = $_GET['wed_limit'];
              $thu_limit = $_GET['thu_limit'];
              $fri_limit = $_GET['fri_limit'];
              $sat_limit = $_GET['sat_limit'];
              $sun_limit = $_GET['sun_limit'];                

             if ($emplok != "yes") {

                $dataArray = [];
                $dataArray['dailyhrs']  = $dailyhrs;
                $dataArray['mon_limit'] = $mon_limit;
                $dataArray['tue_limit'] = $tue_limit;
                $dataArray['wed_limit'] = $wed_limit;
                $dataArray['thu_limit'] = $thu_limit;
                $dataArray['fri_limit'] = $fri_limit;
                $dataArray['sat_limit'] = $sat_limit;
                $dataArray['sun_limit'] = $sun_limit;
                $dataArray['dailyhrslimit'] = $dailyhrslimit;

                $where = [];
                $where['patient_id'] = $recno;
                $this->Comman_model->update('patient', $where, $dataArray);

             }   
          }

          $st = "disabled='disabled'";    
          $add = 0; 
          $strSQL7 = "SELECT * FROM plan_of_care WHERE plc_id = '$plc_id'";
          $objResult7 = $this->Comman_model->getCustomQueryData($strSQL7, 'row');


          if (empty($objResult7)) { 

            if ($_GET['formSubmit'] == 'Print'  || $_GET['formSubmit'] == 'PDF'  || $_GET['formSubmit'] == 'Submit') {

              $created = date("m/d/Y  g:i:s A");
              $data['created'] = $created;
              //echo $created;
              $add = 1;

              $dataArray = [];
              $dataArray['plc_id'] = null;
              $dataArray['patient_id'] = $recno;
              $dataArray['employee_id'] = $emplid2;
              $dataArray['homemaker_tel'] = $homemaker_tel;
              $dataArray['homemaker_name'] = $homemaker_name;
              $dataArray['location'] = $location;
              $dataArray['created'] = $created;

              $plc_id = $this->Comman_model->insert('plan_of_care', $dataArray);
              $plc=  $plc_id; 

              $strSQL6 = "SELECT * FROM employee WHERE employee_id = '$emplid2'";
              $objResult6 = $this->Comman_model->getCustomQueryData($strSQL6, 'row');
              $homemaker_tel = $objResult6['phone'];
              $homemaker_name = $objResult6['lastname'].',  '.$objResult6['firstname'];


              $dataArray = [];
              $dataArray['employee_id'] = $emplid2;
              $dataArray['mon'] = $mon_limit;
              $dataArray['tue'] = $tue_limit;
              $dataArray['wed'] = $wed_limit;
              $dataArray['thu'] = $thu_limit;
              $dataArray['fri'] = $fri_limit;
              $dataArray['sat'] = $sat_limit;
              $dataArray['sun'] = $sun_limit;
              $dataArray['tasks'] = $tasklist;
              $dataArray['homemaker_name'] = $homemaker_name;
              $dataArray['homemaker_tel'] = $homemaker_tel;
              $dataArray['date_assigned'] = $date_assigned;
              $dataArray['client_condition'] = $client_condition;
              $dataArray['date_of_services'] = $date_of_services;
              $dataArray['no_seen_days'] = $no_seen_days;
              $dataArray['no_hours'] = $no_hours;
              $dataArray['from_time'] = $from_time;
              $dataArray['to_time'] = $to_time;

              $where = [];
              $where['plc_id'] = $plc_id;

              $this->Comman_model->update('plan_of_care', $where, $dataArray);


              $val = 0;         


              $where = [];
              $where['patient_id'] = $recno;

              $dataArray = [];
              $dataArray['Eating'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Bathing'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Grooming'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Dressing'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Transferring'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Incontinence'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['ManagingMoney'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Telephoning'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['PreparingMeals'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Laundry'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['Housework'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['OutsideHome'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['RoutineHealth'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['SpecialHealth'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $dataArray = [];
              $dataArray['BeingAlone'] = $val;
              $this->Comman_model->update('tblpatientservices', $where, $dataArray);

              $t = explode(",",$tasklist);
              $x =  count($t);
              $val = -1;
              for ($idx = 0;$idx <= $x; $idx++) {
                $tc = $t[$idx];
                $where = [];
                $where['patient_id'] = $recno;
                if ($tc == "1")  {
                  $dataArray = [];
                  $dataArray['Eating'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "2")  {
                  $dataArray = [];
                  $dataArray['Bathing'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "3") {
                  $dataArray = [];
                  $dataArray['Grooming'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "4")  {
                  $dataArray['Dressing'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "5")  {
                  $dataArray['Transferring'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "6")  {
                  $dataArray['Incontinence'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "7")  {
                  $dataArray['ManagingMoney'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "8")  {
                  $dataArray['Telephoning'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "9")  {
                  $dataArray['PreparingMeals'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "10")  {
                  $dataArray['Laundry'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "11")  {
                  $dataArray['Housework'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "12")  {
                  $dataArray['OutsideHome'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "13")  {
                  $dataArray['RoutineHealth'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "14")  {
                  $dataArray['SpecialHealth'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
                if ($tc == "15")  {
                  $dataArray['BeingAlone'] = $val;
                  $this->Comman_model->update('tblpatientservices', $where, $dataArray); 
                }
              }
            }   
          }


          $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
          $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
          $total = $objResult3["toplam"];
        /**/

          $strSQL = "SELECT * FROM plan_of_care WHERE plc_id = '$plc_id'";
          $objResult = $this->Comman_model->getCustomQueryData($strSQL, 'row');

          if (empty($objResult)) {
            if ($total == 1 )   {
              $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
              $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');

              $emplid2 = $objResult4["employee_id"];
              $homemaker_tel = $objResult4["phone"];
              $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
            } 
          } else {

            $mon_limit = $objResult['mon'];
            $tue_limit = $objResult['tue'];
            $wed_limit = $objResult['wed'];
            $thu_limit = $objResult['thu'];
            $fri_limit = $objResult['fri'];
            $sat_limit = $objResult['sat'];
            $sun_limit = $objResult['sun'];

            $homemaker_name = $objResult['homemaker_name'];
            $homemaker_tel = $objResult['homemaker_tel'];
            $date_assigned = $objResult['date_assigned'];
            $client_condition = $objResult['client_condition'];
            $no_seen_days = $objResult['no_seen_days'];
            $no_hours = $objResult['no_hours'];
            $date_of_services = $objResult['date_of_services'];
            $location = $objResult['location'];
            $created = $objResult['created'];

            $from_time = $objResult['from_time'];
            $to_time = $objResult['to_time'];
            $emplid2 = $objResult['employee_id'];
          }

          if ($mon == 'x')  { $checkstatus1="checked"; }              
          if ($tue == 'x')  { $checkstatus2="checked"; }             
          if ($wed == 'x')  { $checkstatus3="checked"; }             
          if ($thu == 'x')  { $checkstatus4="checked"; }             
          if ($fri == 'x')  { $checkstatus5="checked"; }             
          if ($sat == 'x')  { $checkstatus6="checked"; }             
          if ($sun == 'x')  { $checkstatus7="checked"; }         

          $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
          $total = 0;
          $sqls = $this->Comman_model->getCustomQueryData($sql, 'row');
               
          $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;   
          $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
          foreach ($objExec2 as $key => $objResult2) {
            if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1"; }
            if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2"; }
            if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
            if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
            if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
            if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
            if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
            if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
            if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
            if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
            if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
            if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
            if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
            if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
            if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
          }  

          if ($location == "" ) {
            $location = $agency_location;
          }

          if(!empty($_GET['formSubmit']) && $_GET['formSubmit']=='Print') {
            if(!empty($data['created'])){ $data['st1'] = "disabled='disabled'";}
          }

          $data['st'] = "disabled='disabled'";

          $where  = [];
          $where['agency_code'] = $agency_code;
          $data['agency']    =   $this->Comman_model->get_row('agency', $where);

          $where  = [];
          $data['agencyLocation']    =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

          $where  = [];
          $data['employeeTask']    =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

          $where  = [];
          $where['pc.patient_id'] = $_GET['patient'];
          $data['planOfCareEmpleyee']    =   $this->client->get_plan_of_care_employee($where);

          $where  = [];
          $where['ea.patient_id'] = $_GET['patient'];
          $data['assignEmployeeData']    =   $this->client->get_assigned_employee($where);

          $where= [];
          $where['patient_id'] = $_GET['patient'];
          $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where);
          $data['patient_id'] =  $_GET['patient']; 


          $where = [];
          $where['patient_id'] = $_GET['patient'];
          $plcData = $this->Comman_model->get_row('plan_of_care', $where);

          $where = [];
          $where['employee_id'] = $plcData['employee_id'];
          $employeeData = $this->Comman_model->get_row('employee', $where);
          $data['homemaker_tel'] = $employeeData['phone'];
          $data['homemaker_name'] = $employeeData['lastname'].',  '.$employeeData['firstname'];
          $data['date_assigned'] = $plcData['date_assigned'];
          $data['client_condition'] = $plcData['client_condition'];

          $data['emplid2'] = @$_GET['emplid2'];
          $data['Agency'] = $this->session->userdata('agency');

          $data['plc_id'] = @$plc_id;
          $data['add'] = @$add;
 
          $this->load->view('patient-poc-old.php',$data);
        } else {
          redirect();
        }
    }

    public function clientPOCTOOOLD() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {
            $data = [];
            if (!empty($_GET['formSubmit']) && ($_GET['formSubmit'] == 'Print'  || $_GET['formSubmit'] == 'PDF' ||  $_GET['formSubmit'] == 'Submit' ))  {

                $dataArray = [];
                if(!empty($_GET['formlist'])) {
                    $dataArray['tasks'] =   implode(',', $_GET['formlist']);
                }
                
                $dataArray['mon_limit'] = $_GET['mon_limit'];
                $dataArray['tue_limit'] = $_GET['tue_limit'];
                $dataArray['wed_limit'] = $_GET['wed_limit'];
                $dataArray['thu_limit'] = $_GET['thu_limit'];
                $dataArray['fri_limit'] = $_GET['fri_limit'];
                $dataArray['sat_limit'] = $_GET['sat_limit'];
                $dataArray['sun_limit'] = $_GET['sun_limit'];   
                $dataArray['dailyhrs'] = $_GET['dailyhrs'];   
                $dataArray['dailyhrslimit'] = @$_GET['dailyhrslimit'];   

                $where = [];
                $where['patient_id']    =   $_GET['patient'];
                $this->Comman_model->update('patient', $where, $dataArray);

            /*}    

            if(!empty($_GET['formSubmit']) && ($_GET['formSubmit'] == 'Print'  || $_GET['formSubmit'] == 'PDF'))
            {*/
                $where = [];
                $where['patient_id'] = $_GET['patient'];
                $num = $this->Comman_model->countrow('plan_of_care', $where);

                $homemaker_tel = $homemaker_name = '';
                if(!empty($_GET['emplid2'])) {
                  $where = [];
                  $where['employee_id'] = $_GET['emplid2'];
                  $employeeData = $this->Comman_model->get_row('employee', $where);
                  $homemaker_tel = @$employeeData['phone'];
                  $homemaker_name = @$employeeData['lastname'].',  '.@$employeeData['firstname']; 
                }
                

                if($num==0) {

                    $data['created'] = date("m/d/Y  g:i:s A");

                    $data['add'] = 1;
                    $dataArray = [];
                    $dataArray['patient_id']  =   $_GET['patient'];
                    $dataArray['employee_id']  =   $_GET['emplid2'];
                    $dataArray['homemaker_tel']  =   @$homemaker_tel;
                    $dataArray['homemaker_name']  =   @$homemaker_name;
                    $dataArray['date_assigned'] = $_GET['date_assigned'];
                    $dataArray['client_condition'] = $_GET['client_condition'];
                    //$dataArray['date_of_services']= @$_GET['date_of_services'];
                    $dataArray['no_seen_days'] = $_GET['no_seen_days'];
                    $dataArray['no_hours'] = $_GET['no_hours'];
                    $dataArray['from_time'] = $_GET['from_time'];
                    $dataArray['to_time'] = $_GET['to_time'];
                    $dataArray['location']  =   $_GET['location'];
                    $dataArray['signature']  =   $_GET['signature'];
                    $dataArray['signed_date']  =   $_GET['date'];
                    $dataArray['created']  =   $data['created'];

                    $data['plc_id'] = $this->Comman_model->insert('plan_of_care', $dataArray);
                   
                    $val = 0;

                    $dataArray  =   [];
                    $dataArray['Eating'] =  $val;
                    $dataArray['Bathing'] = $val;
                    $dataArray['Grooming'] = $val;
                    $dataArray['Dressing'] =  $val;
                    $dataArray['Transferring'] =  $val;
                    $dataArray['Incontinence'] =  $val;
                    $dataArray['ManagingMoney'] = $val;
                    $dataArray['Telephoning']  = $val;
                    $dataArray['PreparingMeals'] = $val;
                    $dataArray['Laundry'] = $val;
                    $dataArray['Housework'] = $val;
                    $dataArray['OutsideHome'] = $val;
                    $dataArray['RoutineHealth'] = $val;
                    $dataArray['SpecialHealth'] = $val;
                    $dataArray['BeingAlone'] = $val;

                    $where = [];
                    $where['patient_id'] = $_GET['patient'];

                    $updateId = $this->Comman_model->update('tblpatientservices', $where, $dataArray);

                    if(!empty($_GET['formlist'])) {

                        $val = -1;
                        $where = [];
                        $where['patient_id'] = $_GET['patient'];

                        foreach ($_GET['formlist'] as $key => $tc) {

                            if ($tc == "1") {
                                $dataArray = [];
                                $dataArray['Eating'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "2") {
                                $dataArray = [];
                                $dataArray['Bathing'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "3") {
                                $dataArray = [];
                                $dataArray['Grooming'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "4") {
                                $dataArray = [];
                                $dataArray['Dressing'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "5") {
                                $dataArray = [];
                                $dataArray['Transferring'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "6") {
                                $dataArray = [];
                                $dataArray['Incontinence'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "7") {
                                $dataArray = [];
                                $dataArray['ManagingMoney'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "8") {
                                $dataArray = [];
                                $dataArray['Telephoning'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "9") {
                                $dataArray = [];
                                $dataArray['PreparingMeals'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "10") {
                                $dataArray = [];
                                $dataArray['Laundry'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "11") {
                                $dataArray = [];
                                $dataArray['Housework'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "12") {
                                $dataArray = [];
                                $dataArray['OutsideHome'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "13") {
                                $dataArray = [];
                                $dataArray['RoutineHealth'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "14") {
                                $dataArray = [];
                                $dataArray['SpecialHealth'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                            if ($tc == "15") {
                                $dataArray = [];
                                $dataArray['BeingAlone'] = $val;
                                $this->Comman_model->update('tblpatientservices', $where, $dataArray);
                            }
                        }
                    }
                } else {

                    $dataArray  =   [];
                    if(!empty($_GET['emplid2'])) {
                        $dataArray['employee_id']  = $_GET['emplid2'];    
                    }
                    $dataArray['homemaker_name'] = $homemaker_name;
                    $dataArray['homemaker_tel'] = $homemaker_tel;
                    $dataArray['date_assigned'] = $_GET['date_assigned'];
                    $dataArray['client_condition'] = $_GET['client_condition'];
                    //$dataArray['date_of_services']= $_GET['date_of_services'];
                    $dataArray['no_seen_days'] = $_GET['no_seen_days'];
                    $dataArray['no_hours'] = $_GET['no_hours'];
                    $dataArray['from_time'] = $_GET['from_time'];
                    $dataArray['to_time'] = $_GET['to_time'];
                    $dataArray['signature']  =   $_GET['signature'];
                    $dataArray['signed_date']  =   $_GET['date'];

                    $where = [];
                    $where['plc_id'] = $_GET['plc_id'];
                    $this->Comman_model->update('plan_of_care', $where, $dataArray);

                    //print_r($where);die;
                }
            }

            $where  =   [];
            $where['patient_id']    =   $_GET['patient'];
            $total = $this->Comman_model->countrow('employee_assignment', $where);

            if(!empty($_GET['plc_id'])) {
                $where = [];
                $where['plc_id'] = $_GET['plc_id'];
                $planOfCareData = $this->Comman_model->get_row('plan_of_care', $where);
            }

            //print_r($planOfCareData);die;

            if(empty($planOfCareData)) {
                if ($total == 1 )     {
                  /*$strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                  $objExec4 = mysql_query($strSQL4);
                  $objResult4 = mysql_fetch_array($objExec4);                          
                  $emplid2 = $objResult4["employee_id"];
                  $homemaker_tel = $objResult4["phone"];
                  $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];*/
                } 
            } else {

                $data['mon'] = $planOfCareData['mon'];
                $data['tue'] = $planOfCareData['tue'];
                $data['wed'] = $planOfCareData['wed'];
                $data['thu'] = $planOfCareData['thu'];
                $data['fri'] = $planOfCareData['fri'];
                $data['sat'] = $planOfCareData['sat'];
                $data['sun'] = $planOfCareData['sun'];
                $data['homemaker_name'] = $planOfCareData['homemaker_name'];
                $data['homemaker_tel'] = $planOfCareData['homemaker_tel'];
                $data['date_assigned'] = $planOfCareData['date_assigned'];
                $data['client_condition'] = $planOfCareData['client_condition'];
                $data['no_seen_days'] = $planOfCareData['no_seen_days'];
                $data['no_hours'] = $planOfCareData['no_hours'];
                $data['date_of_services'] = $planOfCareData['date_of_services'];
                $data['location'] = $planOfCareData['location'];
                $data['created'] = $planOfCareData['created'];
                $data['from_time'] = $planOfCareData['from_time'];
                $data['to_time'] = $planOfCareData['to_time'];
                $data['emplid2'] = $planOfCareData['employee_id'];
                //  echo "hello";
            }   

                /*if ($data['mon'] == 'x')  { $data['checkstatus1']="checked"; }
                if ($data['tue'] == 'x')  { $data['checkstatus2']="checked"; }                         
                if ($data['wed'] == 'x')  { $data['checkstatus3']="checked"; }                         
                if ($data['thu'] == 'x')  { $data['checkstatus4']="checked"; }                         
                if ($data['fri'] == 'x')  { $data['checkstatus5']="checked"; }                         
                if ($data['sat'] == 'x')  { $data['checkstatus6']="checked"; }                         
                if ($data['sun'] == 'x')  { $data['checkstatus7']="checked"; }   */


                /*$where = [];
                $where['patient_id'] = $_GET['patient'];
                $patientServiceData = $this->Comman_model->get_rows('tblpatientservices', $where);
                foreach ($patientServiceData as $key => $row) {
                    if ($row['Eating'] == -1)   { $data['tasklist'] = $data['tasklist'].",1"; }
                    if ($row['Bathing'] == -1)   { $data['tasklist'] = $data['tasklist'].",2";  }
                    if ($row['Grooming'] == -1)   { $data['tasklist'] = $data['tasklist'].",3"; }
                    if ($row['Dressing'] == -1)   { $data['tasklist'] = $data['tasklist'].",4"; } 
                    if ($row['Transferring'] == -1)   { $data['tasklist'] = $data['tasklist'].",5"; }
                    if ($row['Incontinence'] == -1)   { $data['tasklist'] = $data['tasklist'].",6"; }
                    if ($row['ManagingMoney'] == -1)   { $data['tasklist'] = $data['tasklist'].",7"; }
                    if ($row['Telephoning'] == -1)   { $data['tasklist'] = $data['tasklist'].",8"; }
                    if ($row['PreparingMeals'] == -1)   { $data['tasklist'] = $data['tasklist'].",9"; }
                    if ($row['Laundry'] == -1)   { $data['tasklist'] = $data['tasklist'].",10"; } 
                    if ($row['Housework'] == -1)   { $data['tasklist'] = $data['tasklist'].",11"; } 
                    if ($row['OutsideHome'] == -1)   { $data['tasklist'] = $data['tasklist'].",12"; }
                    if ($row['RoutineHealth'] == -1)   { $data['tasklist'] = $data['tasklist'].",13"; } 
                    if ($row['SpecialHealth'] == -1)   { $data['tasklist'] = $data['tasklist'].",14"; }
                    if ($row['BeingAlone'] == -1)   { $data['tasklist'] = $data['tasklist'].",15"; }
                }*/

                if(!empty($_GET['formSubmit']) && $_GET['formSubmit']=='Print') {
                    if (!empty($data['created'])){ $data['st1'] = "disabled='disabled'";}
                }

        //}

            $data['st'] = "disabled='disabled'";        

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
            $data['patientData']['address'] = $data['patientData']['ShipAddressAddr1'].' '.$data['patientData']['ShipAddressAddr2'].' '.$data['patientData']['ShipAddressAddr3'].' '.$data['patientData']['ShipAddressAddr4'].' '.$data['patientData']['ShipAddressCity'].' '.$data['patientData']['ShipAddressState'].' '.$data['patientData']['ShipAddressPostalCode'];

            $where  = [];
            $where['agency_code'] = $_SESSION['agency'];
            $data['agency']    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $data['agencyLocation']    =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $data['employeeTask']    =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $data['planOfCareEmpleyee']    =   $this->client->get_plan_of_care_employee($where);
            //print_r($data['planOfCareEmpleyee']);die;

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $data['assignEmployeeData']    =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where);
            $data['patient_id'] =  $_GET['patient']; 


            $where = [];
            $where['patient_id'] = $_GET['patient'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $data['homemaker_tel'] = $employeeData['phone'];
            $data['homemaker_name'] = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $data['date_assigned'] = $plcData['date_assigned'];
            $data['client_condition'] = $plcData['client_condition'];

            $data['emplid2'] = @$_GET['emplid2'];
            $data['Agency'] = $this->session->userdata('agency');

            /*$this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');*/
            $this->load->view('patient-poc.php',$data);
            /*$this->load->view('common/footer.php');*/
        } else {
            redirect();
        }
    }


    public function saveDayLimit() {

      $patient_id = $this->input->post('patient_id');
      $mon_limit = $this->input->post('mon_limit');
      $tue_limit = $this->input->post('tue_limit');
      $wed_limit = $this->input->post('wed_limit');
      $thu_limit = $this->input->post('thu_limit');
      $fri_limit = $this->input->post('fri_limit');
      $sat_limit = $this->input->post('sat_limit');
      $sun_limit = $this->input->post('sun_limit');
      $from_time = $this->input->post('from_time');
      $to_time = $this->input->post('to_time');

      if(!empty($patient_id)) {
        $dataArray = [];
        $dataArray['mon_limit'] = $mon_limit;
        $dataArray['tue_limit'] = $tue_limit;
        $dataArray['wed_limit'] = $wed_limit;
        $dataArray['thu_limit'] = $thu_limit;
        $dataArray['fri_limit'] = $fri_limit;
        $dataArray['sat_limit'] = $sat_limit;
        $dataArray['sun_limit'] = $sun_limit;

        $total_limit = 0; 
        if ($mon_limit != 0 )  {
          $total_limit = $total_limit + $mon_limit;
        }
        if ($tue_limit != 0 )  {
          $total_limit = $total_limit + $tue_limit;
        }
        if ($wed_limit != 0 )  {
          $total_limit = $total_limit + $wed_limit;
        }
        if ($thu_limit != 0 )  {
          $total_limit = $total_limit + $thu_limit;
        }
        if ($fri_limit != 0 )  {
          $total_limit = $total_limit + $fri_limit;
        }         
        if ($sat_limit != 0 )  {
          $total_limit = $total_limit + $sat_limit;
        }
        if ($sun_limit != 0 )  {
          $total_limit = $total_limit + $sun_limit;
        }

        $dataArray['from_time'] = $from_time;
        $dataArray['to_time'] = $to_time;
        $dataArray['ptotal_limit'] = $total_limit;
  
        $where = [];
        $where['patient_id'] = $patient_id;
        $this->Comman_model->update('patient', $where, $dataArray);

        echo 1;
      } else {
        echo 0;
      }
    }


    public function clientpocpdfOLD2() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $recno = $_GET['patient'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];


            $mon_limit = $patientData['mon_limit'];
            $tue_limit = $patientData['tue_limit'];
            $wed_limit = $patientData['wed_limit'];
            $thu_limit = $patientData['thu_limit'];
            $fri_limit = $patientData['fri_limit'];
            $sat_limit = $patientData['sat_limit'];
            $sun_limit = $patientData['sun_limit']; 

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if (!empty($patientData)) {
              if ($patientData['dailyhrslimit'] == 1) {
                $checklimit  = "x";  
                $dailyhrs = $patientData['dailyhrs'];
              }
            }  

            $where  = [];
            $where['agency_code'] = $_SESSION['agency'];
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $planOfCareEmpleyee  =   $this->client->get_plan_of_care_employee($where);
            $planOfCareEmpleyeeASC  =   $this->client->get_plan_of_care_employee_asc($where);
            //print_r($data['planOfCareEmpleyee']);die;

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $assignEmployeeData   =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $patientVisitData = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            $where = [];
            $where['plc_id'] = $_GET['plc_id'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone, employee_assignment.start_date FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
                if(!empty($objResult4['start_date'])) {
                  //$date_of_services = date('m/d/Y', strtotime($objResult4['start_date']));
                  $date_of_services = convertDate($objResult4["start_date"], 'm-d-Y');
                }
              } 
            } else {

              $mon_limit = $plcData['mon'];
              $tue_limit = $plcData['tue'];
              $wed_limit = $plcData['wed'];
              $thu_limit = $plcData['thu'];
              $fri_limit = $plcData['fri'];
              $sat_limit = $plcData['sat'];
              $sun_limit = $plcData['sun'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;

              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              $no_seen_days = $plcData['no_seen_days'];
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];

              $from_time = $plcData['from_time'];
              $to_time = $plcData['to_time'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];

            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time'];
              $to_time = $row['to_time'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              if(!empty($row['start_date'])) {
                $date_of_services = $row["start_date"];
              }

              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }

              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/

            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            //$current_date = date('m/d/Y');
            $current_date = date('m/d/Y', strtotime($plcData['created']));

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];

            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->showImageErrors = true;
            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px;font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
             $html = '
             <table  style="width:100%;padding-bottom:20px;">

            <tr>
            <td style="width:70%;">   
            <table style="width:100%">   <tr> <td style="width:25%"> Client Name   </td> <td style="border-bottom:1px solid black"> '.$patientData['name'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['phone'].'</td>   </tr> </table>
            </td>
            </tr>

            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.$patientData['address'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.$patientData['contactperson'].'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['contactno'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>

            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
             $html = '
             <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.</p>
            <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:9px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>


            </td>

            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px;" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px;" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px;" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-left:3px;padding-bottom:10px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%;"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%"> 
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];

            //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
                
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }   
            $filename = $dirname.'/POC'.date('mdYH:i:s').'.pdf';
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');
            exit;
        } else {
            redirect();
        }
    }

    public function clientpocpdf() {

        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $recno = $_GET['patient'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];


            $mon_limit = $patientData['mon_limit'];
            $tue_limit = $patientData['tue_limit'];
            $wed_limit = $patientData['wed_limit'];
            $thu_limit = $patientData['thu_limit'];
            $fri_limit = $patientData['fri_limit'];
            $sat_limit = $patientData['sat_limit'];
            $sun_limit = $patientData['sun_limit']; 

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if (!empty($patientData)) {
              if ($patientData['dailyhrslimit'] == 1) {
                $checklimit  = "x";  
                $dailyhrs = $patientData['dailyhrs'];
              }
            }  

            $where  = [];
            $where['agency_code'] = $_SESSION['agency'];
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $planOfCareEmpleyee  =   $this->client->get_plan_of_care_employee($where);
            $planOfCareEmpleyeeASC  =   $this->client->get_plan_of_care_employee_asc($where);
            //print_r($data['planOfCareEmpleyee']);die;

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $assignEmployeeData   =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $patientVisitData = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            $where = [];
            $where['plc_id'] = $_GET['plc_id'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone, employee_assignment.start_date FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
                if(!empty($objResult4['start_date'])) {
                  //$date_of_services = date('m/d/Y', strtotime($objResult4['start_date']));
                  $date_of_services = convertDate($objResult4["start_date"], 'm-d-Y');
                }
              } 
            } else {

              $mon_limit = $plcData['mon'];
              $tue_limit = $plcData['tue'];
              $wed_limit = $plcData['wed'];
              $thu_limit = $plcData['thu'];
              $fri_limit = $plcData['fri'];
              $sat_limit = $plcData['sat'];
              $sun_limit = $plcData['sun'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;

              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              $no_seen_days = $plcData['no_seen_days'];
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];

              $from_time = $plcData['from_time'];
              $to_time = $plcData['to_time'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];

            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time'];
              $to_time = $row['to_time'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              if(!empty($row['start_date'])) {
                $date_of_services = $row["start_date"];
              }

              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }

              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/

            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            //$current_date = date('m/d/Y');
            $current_date = date('m/d/Y', strtotime($plcData['created']));

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];

            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);


            $mpdf->showImageErrors = true;
            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px;font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
             $html = '
             <table  style="width:100%;padding-bottom:20px;">

            <tr>
            <td style="width:70%;">   
            <table style="width:100%">   <tr> <td style="width:25%"> Client Name   </td> <td style="border-bottom:1px solid black"> '.$patientData['name'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['phone'].'</td>   </tr> </table>
            </td>
            </tr>

            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.$patientData['address'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.$patientData['contactperson'].'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['contactno'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>

            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
             $html = '
             <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.</p>
            <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:9px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>


            </td>

            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px;" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px;" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px;" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-left:3px;padding-bottom:10px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%;"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%"> 
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname2 = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
                
            $dirname = "/var/www/html/hcpportal/Admin/customer_panel/assets/files/drive";

            /*
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }
            */

            $file_name = 'POC'.date('mdYH:i:s').'.pdf';
            $filename = $dirname.'/'.$file_name;
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');

            /****** Upload file to SMS server start ******/
            $target_url = "http://sms.1017.solutions/hcpservices/index.php";
            $action     = 'facesheet';
            $filepath   = $dirname.'/'.$file_name;
            $this->fileUploadToSmsServer($target_url, $filepath, $file_name, $dirname2, $action);
            unlink($filename);
            /****** Upload file to SMS server end ******/

            exit;
        } else {
            redirect();
        }
    }


    public function clientpocpdfHoursOLD2() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $recno = $_GET['patient'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];


            $mon_limit = $patientData['mon_limit1'];
            $tue_limit = $patientData['tue_limit1'];
            $wed_limit = $patientData['wed_limit1'];
            $thu_limit = $patientData['thu_limit1'];
            $fri_limit = $patientData['fri_limit1'];
            $sat_limit = $patientData['sat_limit1'];
            $sun_limit = $patientData['sun_limit1']; 

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if (!empty($patientData)) {
              $mon_limit = $patientData['mon_limit1'];
              $tue_limit = $patientData['tue_limit1'];
              $wed_limit = $patientData['wed_limit1'];
              $thu_limit = $patientData['thu_limit1'];
              $fri_limit = $patientData['fri_limit1'];
              $sat_limit = $patientData['sat_limit1'];
              $sun_limit = $patientData['sun_limit1'];                        
              if ($patientData['dailyhrslimit'] == 1) {
                $checklimit  = "x";  
                $dailyhrs = $patientData['dailyhrs'];
              }
            }  

            $where  = [];
            $where['agency_code'] = $this->session->userdata('agency');
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $planOfCareEmpleyee  =   $this->client->get_plan_of_care_employee($where);
            //print_r($data['planOfCareEmpleyee']);die;

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $assignEmployeeData   =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $patientVisitData = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            $where = [];
            $where['plc_id'] = $_GET['plc_id'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
              } 
            } else {

              $mon_limit = $plcData['mon1'];
              $tue_limit = $plcData['tue1'];
              $wed_limit = $plcData['wed1'];
              $thu_limit = $plcData['thu1'];
              $fri_limit = $plcData['fri1'];
              $sat_limit = $plcData['sat1'];
              $sun_limit = $plcData['sun1'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;
              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              //$no_seen_days = $plcData['no_seen_days'];
              
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];


              $from_time = $plcData['from_time1'];
              $to_time = $plcData['to_time1'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];

            /*$this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');*/
            //$this->load->view('patient-poc-pdf.php',$data);
            /*$this->load->view('common/footer.php');*/

            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time1'];
              $to_time = $row['to_time1'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              if(!empty($row['start_date'])) {
                $date_of_services = $row['start_date'];
              }


              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }

              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/


            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            $current_date = date('m/d/Y');
            $current_date = date('m/d/Y', strtotime($plcData['created']));

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];


            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px; font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
             $html = '
             <table  style="width:100%;padding-bottom:20px;">

            <tr>
            <td style="width:70%;">   
            <table style="width:100%">   <tr> <td style="width:25%"> Client Name   </td> <td style="border-bottom:1px solid black"> '.$patientData['name'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['phone'].'</td>   </tr> </table>
            </td>
            </tr>

            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.$patientData['address'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.$patientData['contactperson'].'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['contactno'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>

            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
            $html = '
            <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.
            <br> <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:9px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>


            </td>

            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');;
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px;" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px;" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-bottom:10px;padding-left:3px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%;"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

        

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%;text-align:center;"> 
              <strong><h3>FILL-IN</h3></strong>
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];

            //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
                
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }   
            $filename = $dirname.'/POC'.date('mdYH:i:s').'.pdf';
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');
            exit;
        } else {
            redirect();
        }
    }

    public function clientpocpdfHours() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $recno = $_GET['patient'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];


            $mon_limit = $patientData['mon_limit1'];
            $tue_limit = $patientData['tue_limit1'];
            $wed_limit = $patientData['wed_limit1'];
            $thu_limit = $patientData['thu_limit1'];
            $fri_limit = $patientData['fri_limit1'];
            $sat_limit = $patientData['sat_limit1'];
            $sun_limit = $patientData['sun_limit1']; 

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if (!empty($patientData)) {
              $mon_limit = $patientData['mon_limit1'];
              $tue_limit = $patientData['tue_limit1'];
              $wed_limit = $patientData['wed_limit1'];
              $thu_limit = $patientData['thu_limit1'];
              $fri_limit = $patientData['fri_limit1'];
              $sat_limit = $patientData['sat_limit1'];
              $sun_limit = $patientData['sun_limit1'];                        
              if ($patientData['dailyhrslimit'] == 1) {
                $checklimit  = "x";  
                $dailyhrs = $patientData['dailyhrs'];
              }
            }  

            $where  = [];
            $where['agency_code'] = $this->session->userdata('agency');
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $planOfCareEmpleyee  =   $this->client->get_plan_of_care_employee($where);
            //print_r($data['planOfCareEmpleyee']);die;

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $assignEmployeeData   =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $patientVisitData = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            $where = [];
            $where['plc_id'] = $_GET['plc_id'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
              } 
            } else {

              $mon_limit = $plcData['mon1'];
              $tue_limit = $plcData['tue1'];
              $wed_limit = $plcData['wed1'];
              $thu_limit = $plcData['thu1'];
              $fri_limit = $plcData['fri1'];
              $sat_limit = $plcData['sat1'];
              $sun_limit = $plcData['sun1'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;
              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              //$no_seen_days = $plcData['no_seen_days'];
              
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];


              $from_time = $plcData['from_time1'];
              $to_time = $plcData['to_time1'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];

            /*$this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');*/
            //$this->load->view('patient-poc-pdf.php',$data);
            /*$this->load->view('common/footer.php');*/

            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time1'];
              $to_time = $row['to_time1'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              if(!empty($row['start_date'])) {
                $date_of_services = $row['start_date'];
              }


              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }

              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/


            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            $current_date = date('m/d/Y');
            $current_date = date('m/d/Y', strtotime($plcData['created']));

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];


            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px; font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
             $html = '
             <table  style="width:100%;padding-bottom:20px;">

            <tr>
            <td style="width:70%;">   
            <table style="width:100%">   <tr> <td style="width:25%"> Client Name   </td> <td style="border-bottom:1px solid black"> '.$patientData['name'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['phone'].'</td>   </tr> </table>
            </td>
            </tr>

            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.$patientData['address'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.$patientData['contactperson'].'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['contactno'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>

            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
            $html = '
            <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.
            <br> <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:9px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>


            </td>

            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');;
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px;" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px;" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-bottom:10px;padding-left:3px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%;"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

        

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%;text-align:center;"> 
              <strong><h3>FILL-IN</h3></strong>
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname2 = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];

            $dirname = "/var/www/html/hcpportal/Admin/customer_panel/assets/files/drive";
                
            /*    
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            } 
            */  

            $file_name = 'POC'.date('mdYH:i:s').'.pdf';
            $filename = $dirname.'/'.$file_name;
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');

            /****** Upload file to SMS server start ******/
            $target_url = "http://sms.1017.solutions/hcpservices/index.php";
            $action     = 'facesheet';
            $filepath   = $dirname.'/'.$file_name;
            $this->fileUploadToSmsServer($target_url, $filepath, $file_name, $dirname2, $action);
            unlink($filename);
            /****** Upload file to SMS server end ******/

            exit;
        } else {
            redirect();
        }
    }


    public function empPocPdfHours() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['emplid2'])) {
            $recno = $_GET['patient'];
            $emplid2 = $_GET['emplid2'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if (!empty($patientData)) {
              if ($patientData['dailyhrslimit'] == 1) {
                $checklimit  = "x";  
                $dailyhrs = $patientData['dailyhrs'];
              }
            }  

            $where  = [];
            $where['agency_code'] = $this->session->userdata('agency');
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $sql = "select * from plan_of_care where employee_id=".$_GET['emplid2']." and patient_id=".$recno." order by plc_id desc limit 1";
            $plcData = $this->Comman_model->getCustomQueryData($sql, 'row');

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
              } 
            } else {

              $mon_limit = $plcData['mon'];
              $tue_limit = $plcData['tue'];
              $wed_limit = $plcData['wed'];
              $thu_limit = $plcData['thu'];
              $fri_limit = $plcData['fri'];
              $sat_limit = $plcData['sat'];
              $sun_limit = $plcData['sun'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;
              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              //$no_seen_days = $plcData['no_seen_days'];
              
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];

              $from_time = $plcData['from_time'];
              $to_time = $plcData['to_time'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];

            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time'];
              $to_time = $row['to_time'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              $mon_limit = $row['mon_limit'];
              $tue_limit = $row['tue_limit'];
              $wed_limit = $row['wed_limit'];
              $thu_limit = $row['thu_limit'];
              $fri_limit = $row['fri_limit'];
              $sat_limit = $row['sat_limit'];
              $sun_limit = $row['sun_limit']; 

              if(!empty($row['start_date'])) {
                //$date_of_services = date('m/d/Y', strtotime($row['start_date']));
                $date_of_services = $row['start_date'];
              }

              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }
              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/

            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];

            $current_date = date('m/d/Y');

            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px;font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
             $html = '
            <table  style="width:100%;padding-bottom:20px;">
            <tr>
            <td style="width:70%;">   
            <table style="width:100%">   <tr> <td style="width:25%"> Client Name   </td> <td style="border-bottom:1px solid black"> '.$patientData['name'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['phone'].'</td>   </tr> </table>
            </td>
            </tr>

            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.$patientData['address'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.$patientData['contactperson'].'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['contactno'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>

            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
             $html = '
            <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.</p>
            <br> <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:12px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>
            </td>
            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');;
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px;" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px;" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>

             <br>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-bottom:10px;padding-left:3px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%"> 
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
                
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }

            $filename = $dirname.'/POC'.date('mdYH:i:s').'.pdf';
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');
            exit;
        } else {
            redirect();
        }
    }



    public function empPocPdfHours2() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['emplid2'])) {
            $recno = $_GET['patient'];
            $emplid2 = $_GET['emplid2'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if (!empty($patientData)) {
              if ($patientData['dailyhrslimit'] == 1) {
                $checklimit  = "x";  
                $dailyhrs = $patientData['dailyhrs'];
              }
            }  

            $where  = [];
            $where['agency_code'] = $this->session->userdata('agency');
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $sql = "select * from plan_of_care where employee_id=".$_GET['emplid2']." and patient_id=".$recno." order by plc_id desc limit 1";
            $plcData = $this->Comman_model->getCustomQueryData($sql, 'row');

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
              } 
            } else {

              $mon_limit = $plcData['mon'];
              $tue_limit = $plcData['tue'];
              $wed_limit = $plcData['wed'];
              $thu_limit = $plcData['thu'];
              $fri_limit = $plcData['fri'];
              $sat_limit = $plcData['sat'];
              $sun_limit = $plcData['sun'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;
              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              //$no_seen_days = $plcData['no_seen_days'];
              
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];

              $from_time = $plcData['from_time'];
              $to_time = $plcData['to_time'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];

            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time'];
              $to_time = $row['to_time'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              $mon_limit = $row['mon_limit'];
              $tue_limit = $row['tue_limit'];
              $wed_limit = $row['wed_limit'];
              $thu_limit = $row['thu_limit'];
              $fri_limit = $row['fri_limit'];
              $sat_limit = $row['sat_limit'];
              $sun_limit = $row['sun_limit']; 

              if(!empty($row['start_date'])) {
                //$date_of_services = date('m/d/Y', strtotime($row['start_date']));
                $date_of_services = $row['start_date'];
              }

              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }
              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/

            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];

            $current_date = date('m/d/Y');

            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px;font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
             $html = '
            <table  style="width:100%;padding-bottom:20px;">
            <tr>
            <td style="width:70%;">   
            <table style="width:100%">   <tr> <td style="width:25%"> Client Name   </td> <td style="border-bottom:1px solid black"> '.$patientData['name'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['phone'].'</td>   </tr> </table>
            </td>
            </tr>

            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.$patientData['address'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.$patientData['contactperson'].'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['contactno'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>

            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
             $html = '
            <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.</p>
            <br> <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:12px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>
            </td>
            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');;
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px;" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px;" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>

             <br>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-bottom:10px;padding-left:3px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%"> 
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname2 = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
                
            //$dirname = "/var/www/html/hcpportal/Admin/customer_panel/assets/files/drive/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            //$dirname2 = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];

            /*
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }
            */

            $dirname = "/var/www/html/hcpportal/Admin/customer_panel/assets/files/drive";

            $file_name = 'POC'.date('mdYH:i:s').'.pdf';
            $filename = $dirname.'/'.$file_name;
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');

            /****** Upload file to SMS server start ******/
            $target_url = "http://sms.1017.solutions/hcpservices/index.php";
            $action     = 'facesheet';
            $filepath   = $dirname.'/'.$file_name;
            $this->fileUploadToSmsServer($target_url, $filepath, $file_name, $dirname2, $action);
            unlink($filename);
            /****** Upload file to SMS server end ******/

            exit;
        } else {
            redirect();
        }
    }


    public function clientpocpdfShiftHoursOLD2() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $recno = $_GET['patient'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];


            $mon_limit = $patientData['mon_limit2'];
            $tue_limit = $patientData['tue_limit2'];
            $wed_limit = $patientData['wed_limit2'];
            $thu_limit = $patientData['thu_limit2'];
            $fri_limit = $patientData['fri_limit2'];
            $sat_limit = $patientData['sat_limit2'];
            $sun_limit = $patientData['sun_limit2']; 

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if ($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
              $dailyhrs = $patientData['dailyhrs'];
            } 

            $where  = [];
            $where['agency_code'] = $_SESSION['agency'];
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $planOfCareEmpleyee  =   $this->client->get_plan_of_care_employee($where);

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $assignEmployeeData   =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $patientVisitData = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            $where = [];
            $where['plc_id'] = $_GET['plc_id'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
              } 
            } else {

              $mon_limit = $plcData['mon2'];
              $tue_limit = $plcData['tue2'];
              $wed_limit = $plcData['wed2'];
              $thu_limit = $plcData['thu2'];
              $fri_limit = $plcData['fri2'];
              $sat_limit = $plcData['sat2'];
              $sun_limit = $plcData['sun2'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;
              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              //$no_seen_days = $plcData['no_seen_days'];
              
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];


              $from_time = $plcData['from_time2'];
              $to_time = $plcData['to_time2'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];


            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time2'];
              $to_time = $row['to_time2'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              if(!empty($row['start_date'])) {
                //$date_of_services = date('m/d/Y', strtotime($row['start_date']));
                $date_of_services = $row['start_date'];

              }


              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }
              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/


            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            $current_date = date('m/d/Y');
            $current_date = date('m/d/Y', strtotime($plcData['created']));

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];


            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px; font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
            $html = '
            <table  style="width:100%;padding-bottom:20px;">
            <tr>
            <td style="width:70%;">   
            <table style="width:100%"><tr><td style="width:25%">Client Name</td><td style="border-bottom:1px solid black"> '.trim($patientData['name']).'</td></tr></table>
            </td> 
            <td style="width:30%;"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.trim($patientData['phone']).'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.trim($patientData['address']).'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.trim($patientData['contactperson']).'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.trim($patientData['contactno']).'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>
            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
             $html = '
            <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.</p>
            <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:12px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>


            </td>

            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');;
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-bottom:10px;padding-left:3px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%"> 
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];

            //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
                
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }   
            $filename = $dirname.'/POC'.date('mdYH:i:s').'.pdf';
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');
            exit;
        } else {
            redirect();
        }
    }

    public function clientpocpdfShiftHours() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $recno = $_GET['patient'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];


            $mon_limit = $patientData['mon_limit2'];
            $tue_limit = $patientData['tue_limit2'];
            $wed_limit = $patientData['wed_limit2'];
            $thu_limit = $patientData['thu_limit2'];
            $fri_limit = $patientData['fri_limit2'];
            $sat_limit = $patientData['sat_limit2'];
            $sun_limit = $patientData['sun_limit2']; 

            $clientCondition = $patientData['clientCondition'];


            $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$recno' order by ID asc" ;  
            $objExec2 = $this->Comman_model->getCustomQueryData($mySQL);
            foreach ($objExec2 as $key => $objResult2) {
              if ($objResult2['Eating'] == -1)   { $tasklist = $tasklist.",1";    }
              if ($objResult2['Bathing'] == -1)   { $tasklist = $tasklist.",2";  }
              if ($objResult2['Grooming'] == -1)   { $tasklist = $tasklist.",3"; }
              if ($objResult2['Dressing'] == -1)   { $tasklist = $tasklist.",4"; } 
              if ($objResult2['Transferring'] == -1)   { $tasklist = $tasklist.",5"; }
              if ($objResult2['Incontinence'] == -1)   { $tasklist = $tasklist.",6"; }
              if ($objResult2['ManagingMoney'] == -1)   { $tasklist = $tasklist.",7"; }
              if ($objResult2['Telephoning'] == -1)   { $tasklist = $tasklist.",8"; }
              if ($objResult2['PreparingMeals'] == -1)   { $tasklist = $tasklist.",9"; }
              if ($objResult2['Laundry'] == -1)   { $tasklist = $tasklist.",10"; } 
              if ($objResult2['Housework'] == -1)   { $tasklist = $tasklist.",11"; } 
              if ($objResult2['OutsideHome'] == -1)   { $tasklist = $tasklist.",12"; }
              if ($objResult2['RoutineHealth'] == -1)   { $tasklist = $tasklist.",13"; } 
              if ($objResult2['SpecialHealth'] == -1)   { $tasklist = $tasklist.",14"; }
              if ($objResult2['BeingAlone'] == -1)   { $tasklist = $tasklist.",15"; }
            }      
            $st = "disabled='disabled'"; 

            $strSQL3 = "SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
            $total = $objResult3["toplam"];

            if ($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
              $dailyhrs = $patientData['dailyhrs'];
            } 

            $where  = [];
            $where['agency_code'] = $_SESSION['agency'];
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $planOfCareEmpleyee  =   $this->client->get_plan_of_care_employee($where);

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $assignEmployeeData   =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $patientVisitData = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            $where = [];
            $where['plc_id'] = $_GET['plc_id'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            if (empty($plcData)) {
              if ($total == 1 )   {
                $strSQL4 = "SELECT employee.employee_id, employee.lastname, employee.firstname, employee.phone FROM employee_assignment,employee WHERE employee_assignment.employee_id = employee.employee_id AND patient_id = '$recno'  ORDER BY name ASC";
                $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');              
                $emplid2 = $objResult4["employee_id"];
                $EMPLID = $objResult4["employee_id"];
                $homemaker_tel = $objResult4["phone"];
                $homemaker_name = $objResult4["lastname"].' '.$objResult4["firstname"];
              } 
            } else {

              $mon_limit = $plcData['mon2'];
              $tue_limit = $plcData['tue2'];
              $wed_limit = $plcData['wed2'];
              $thu_limit = $plcData['thu2'];
              $fri_limit = $plcData['fri2'];
              $sat_limit = $plcData['sat2'];
              $sun_limit = $plcData['sun2'];

              $pno_hours = $mon_limit + $tue_limit + $wed_limit + $thu_limit + $fri_limit + $sat_limit + $sun_limit;
              $pno_hours = number_format((float)$pno_hours, 2, '.', '');

              $homemaker_name = $plcData['homemaker_name'];
              $homemaker_tel = $plcData['homemaker_tel'];
              $date_assigned = $plcData['date_assigned'];
              $client_condition = $plcData['client_condition'];
              //$no_seen_days = $plcData['no_seen_days'];
              
              $no_hours = $plcData['no_hours'];
              $date_of_services = $plcData['date_of_services'];
              $location = $plcData['location'];
              $created = $plcData['created'];


              $from_time = $plcData['from_time2'];
              $to_time = $plcData['to_time2'];
              $emplid2 = $plcData['employee_id'];
              $EMPLID = $plcData['employee_id'];
            }

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'].',';
            $homemaker_tel .= $employeeData['mobile'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];


            $x="x";         
            if ($mon == 'x')  { $checkstatus1=$x; }              
            if ($tue == 'x')  { $checkstatus2=$x; }              
            if ($wed == 'x')  { $checkstatus3=$x; }              
            if ($thu == 'x')  { $checkstatus4=$x; }              
            if ($fri == 'x')  { $checkstatus5=$x; }              
            if ($sat == 'x')  { $checkstatus6=$x; }              
            if ($sun == 'x')  { $checkstatus7=$x; }          

            $sql="SELECT count(*) as toplam FROM employee_assignment WHERE patient_id='$recno'";
            $total = 0;
            $sqls = $this->Comman_model->getCustomQueryData($sql,'row');

            if($_GET['emplok']=='yes') {
              $emplid2 = $_GET['emplid2'];
              $sql="SELECT * FROM employee_assignment WHERE patient_id='$recno' and employee_id='$emplid2'";
              $row = $this->Comman_model->getCustomQueryData($sql,'row');              
              $from_time = $row['from_time2'];
              $to_time = $row['to_time2'];
              $no_hours = $row['total_limit'];
              $no_seen_days = $row['daysperweek'];

              if(!empty($row['start_date'])) {
                //$date_of_services = date('m/d/Y', strtotime($row['start_date']));
                $date_of_services = $row['start_date'];

              }


              if(!empty($row['user_id']) && $row['sup_signature']==1) {
                $sql_e = "SELECT * FROM users_portal WHERE user_id='".$row['user_id']."'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE googleUserId='".$row_e['googleUserId']."'";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }
              }
              /*if($row['sup_signature']) {
                $sql_e = "SELECT * FROM patient WHERE patient_id='$recno'";
                $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                $signaturePath = '';
                if(!empty($row_s['signature'])) {
                  $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                  $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                }

                if(empty($signaturePath)) {
                  $sql_e = "SELECT * FROM employee WHERE employee_id='$emplid2'";
                  $row_e = $this->Comman_model->getCustomQueryData($sql_e,'row');

                  $sql_s = "SELECT * FROM supervisor WHERE supervisor_id=".$row_e['supervisor_id']."";
                  $row_s = $this->Comman_model->getCustomQueryData($sql_s,'row');

                  $signaturePath = '';
                  if(!empty($row_s['signature'])) {
                    $signaturePath = base_url('assets2/images/supervisor/signature/'.$row_s['signature']);  
                    $signaturePath = '<img src="'.$signaturePath.'" height="75px" width="255px"/>';
                  }  
                }                
              }*/


            } else {
              $from_time = $patientData['from_time'];
              $to_time = $patientData['to_time'];
              $no_hours = $patientData['ptotal_limit'];
              $no_seen_days = $patientData['daysperweek'];
            }

            if (!empty($plcData)) {
                $no_hours = $pno_hours;
            }

            $current_date = date('m/d/Y');
            $current_date = date('m/d/Y', strtotime($plcData['created']));

            $where  = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $agencyLData    =   $this->Comman_model->get_row('agency_location', $where);

            $agency_loc_addr1 = $agencyLData['agency_loc_addr1'];
            $agency_loc_addr2 = $agencyLData['agency_loc_addr2'];
            $agency_loc_phone = $agencyLData['agency_loc_phone'];
            $agency_loc_fax = $agencyLData['agency_loc_fax'];


            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px; font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }

              $loc = '<p>'.$agency_loc_addr1.'</p>
                <p>'.$agency_loc_addr2.'</p>
                <p> Phone: '.$agency_loc_phone.' </p>
                <p>  Fax: '.$agency_loc_fax.'   </p>';
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
            $html = '
            <table  style="width:100%;padding-bottom:20px;">
            <tr>
            <td style="width:70%;">   
            <table style="width:100%"><tr><td style="width:25%">Client Name</td><td style="border-bottom:1px solid black"> '.trim($patientData['name']).'</td></tr></table>
            </td> 
            <td style="width:30%;"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.trim($patientData['phone']).'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.trim($patientData['address']).'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.trim($patientData['contactperson']).'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.trim($patientData['contactno']).'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>
            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>
            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$clientCondition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
             $html = '
            <p> This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
            <p> The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
            <p> If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.</p>
            <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$no_seen_days.'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$mon_limit.'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$tue_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$wed_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$thu_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$fri_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$sat_limit.'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$sun_limit.'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
              $checklimit  = "x";  
            }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:40px"> '.$from_time.' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$to_time.' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$no_hours.' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:12px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$dailyhrs.'" style="width:20%;height:25px;border:2px solid black"/>


            </td>

            </tr> 
            </table> <br>';  

            if(!empty($date_of_services)) {
              $date_of_services = convertDate($date_of_services, 'm-d-Y');;
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$date_of_services.' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding-bottom:10px;padding-left:3px;" border="0">
            <tr>
            <td style="width:100%;">   
            <table style="width:100%"><tr><td style="font-size:13px;">Notes: '.$patientData['pocNotes'].'</td></tr></table>
            </td>
            </tr>
            </table>';

            $html .= '
            <table  style="width:100%;font-size:100%;padding-left:3px" border="0">
            <tr>
            <td style="width:50%;">   
            <table style="width:100%">   
            <tr> 
            <td style="width:30%;font-size:13px;height:75px;padding-top:45px;"> Supervisor '."'s ". 'Signature  </td> 
            <td style="width:70%;border-bottom:1px solid black"> 
              '.$signaturePath.'
            </td>   
            </tr> 
            </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   
            <tr> 
            <td style="width:20%;font-size:13px;height:75px;padding-top:45px;"> Date:  </td> 
            <td style="border-bottom:1px solid black;height:75px;padding-top:45px;"> '.$current_date.'</td>   </tr> </table>
            </td>
            <td style="width:20%"> 
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            //$dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
            $dirname2 = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];

            $dirname = "/var/www/html/hcpportal/Admin/customer_panel/assets/files/drive";
            
            /*    
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }
            */

            $file_name = 'POC'.date('mdYH:i:s').'.pdf';
            $filename  = $dirname.'/'.$file_name;
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');

            /****** Upload file to SMS server start ******/
            $target_url = "http://sms.1017.solutions/hcpservices/index.php";
            $action     = 'facesheet';
            $filepath   = $dirname.'/'.$file_name;
            $this->fileUploadToSmsServer($target_url, $filepath, $file_name, $dirname2, $action);
            unlink($filename);
            /****** Upload file to SMS server end ******/

            exit;
        } else {
            redirect();
        }
    }

    public function clientpocpdfOld() {
        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $patientData    =   $this->Comman_model->get_row('patient', $where);
            $patientData['address'] = $patientData['ShipAddressAddr1'].' '.$patientData['ShipAddressAddr2'].' '.$patientData['ShipAddressAddr3'].' '.$patientData['ShipAddressAddr4'].' '.$patientData['ShipAddressCity'].' '.$patientData['ShipAddressState'].' '.$patientData['ShipAddressPostalCode'];

            $where  = [];
            $where['agency_code'] = $_SESSION['agency'];
            $agency    =   $this->Comman_model->get_row('agency', $where);

            $where  = [];
            $agencyLocation  =   $this->Comman_model->get_rows('agency_location', $where, 'agency_location_code', 'asc');

            $where  = [];
            $employeeTask  =   $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where  = [];
            $where['pc.patient_id'] = $_GET['patient'];
            $planOfCareEmpleyee  =   $this->client->get_plan_of_care_employee($where);
            //print_r($data['planOfCareEmpleyee']);die;

            $where  = [];
            $where['ea.patient_id'] = $_GET['patient'];
            $assignEmployeeData   =   $this->client->get_assigned_employee($where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $patientVisitData = $this->Comman_model->get_rows('tblpatientsvisits', $where);

            $where = [];
            $where['plc_id'] = $_GET['plc_id'];
            $plcData = $this->Comman_model->get_row('plan_of_care', $where);

            $where = [];
            $where['employee_id'] = $plcData['employee_id'];
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $homemaker_tel = $employeeData['phone'];
            $homemaker_name = $employeeData['lastname'].',  '.$employeeData['firstname'];
            $homemaker_id = $employeeData['employee_id'];
            $date_assigned = $plcData['date_assigned'];
            $client_condition = $plcData['client_condition'];

            /*$this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');*/
            //$this->load->view('patient-poc-pdf.php',$data);
            /*$this->load->view('common/footer.php');*/


            //require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            //$mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 

            require_once '/var/www/html/vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf(['tempDir' => APPPATH . '/custom/temp/dir/']);

            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            $html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }

            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px;font-size: 13px;padding-left:7px;}

            </style>';
            $mpdf->WriteHTML($html);

            $location = 2;  
            if ($location == 1 )   {   
              
              $loc = '  <p> 1025 E. 162nd St.   </p>
                <p>  South Holland, IL. 60473 </p>
                <p>  Office:(708) 808-9890 </p>
                <p>  Fax:(708) 566-4364 </p>
              ';

              }

              if ($location == 2 )   {
                
              $loc = '  <p> 3949 N Pulaski Road </p>
                <p> Chicago, IL 60641</p>
                <p> Phone: 773-283-0090 </p>
                <p>  Fax: 773-5645-818   </p>';
               
              }

              if ($location == 3 )   {   
              $loc = '
              <p> #205, E State St.  </p>
              <p> Rockford, IL 61108 </p>
              <p> Phone: 773-283-0090 </p>
              <p> Fax: 773-5645-818 </p>';
              }
                      
            $html2 = '';
            //input { border-top:2px solid white;border-right:2px solid white;border-left:2px solid white;border-bottom:2px solid black;width:5%;height:25px }

            $html2 = '<style>

            @page {
            margin: 10px;  }

                p { margin-bottom:1px;margin-top:1px}

            </style>';

            $mpdf->WriteHTML($html);

            $html = '<table style="width:95%">
            <tr>
            <td style="width:70%">';


            $html = $html.'<img src="'.base_url('assets/images/agency').'/'.$agency['agency_logo'].'" height="75px"   width="255px"  >  </td>';

            $html = $html.'<td style="width:30%;align:right">'.$loc;

            $html = $html.'</td> </tr> </table>';
            $mpdf->WriteHTML($html);

            $html4 = ' <table style="width:100%;font-size:100px;padding:10px"> <tr> <td> 
             <center>
             <h2>   
            <p style="arial;width:75%;font-size: 20px"> HOMECARE AIDE / HOMEMAKER SERVICE ASSIGNMENT  </p> 
            <p style="arial;width:75%;font-size: 20px"> &  </p>
            <p style="arial;width:75%;font-size:20px"> PLAN OF CARE  </p> 

             </h2>  </center>  </td> </tr> </table>';
            $mpdf->WriteHTML($html4);
             $html = '
             <table  style="width:100%;padding-bottom:20px;">

            <tr>
            <td style="width:70%;">   
            <table style="width:100%">   <tr> <td style="width:25%"> Client Name   </td> <td style="border-bottom:1px solid black"> '.$patientData['name'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['phone'].'</td>   </tr> </table>
            </td>
            </tr>

            <tr>
            <td style="width:100%"  colspan="2">   
            <table style="width:100%">   <tr> <td style="width:9%"> Address  </td> <td style="border-bottom:1px solid black"> '.$patientData['address'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:38%"> Emergency Contact  </td> <td style="border-bottom:1px solid black"> '.$patientData['contactperson'].'</td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$patientData['contactno'].'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%;">   
            <table style="width:100%">   <tr> <td style="width:33%"> Homemaker Name </td> <td style="border-bottom:1px solid black"> '.$homemaker_name.' ('.$homemaker_id.') </td>   </tr> </table>
            </td> 
            <td style="width:40%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Tel/Mob:  </td> <td style="border-bottom:1px solid black;"> '.$homemaker_tel.'</td>   </tr> </table>
            </td>
            </tr>


            <tr>
            <td style="width:60%" >   
            <table style="width:100%">   <tr> <td style="width:25%"> Date Assigned </td> <td style="border-bottom:1px solid black"> '.$date_assigned.'</td>   </tr> </table>
            </td> 
            <td style="width:40%" >   
            </td> 
            </tr>

            <tr>
            <td style="width:60%"  colspan="2" >   
            <table style="width:100%">   <tr> <td style="width:15%"> Client Condition </td> <td style="border-bottom:1px solid black"> '.$client_condition.'</td>   </tr> </table>
            </td> 
            </tr>
            </table>
            ';
             
            $mpdf->WriteHTML($html);
             
             $html = '
             <p>This Plan of Care has to be followed by the Homecare Aide/Homemaker for the above named Client.</p>
             <p>The Plan of Care is designed to meet the Client’s individual needs. It is mandatory to follow the Plan of Care so the Client can best receive the services the State has assigned for him/her.</p>
             <p>If you cannot adhere to this Plan of Care for the Client, please call your Supervisor and discuss the matter.</p>
            <br>';
            $mpdf->WriteHTML($html);
            //$no_seen_days = '5'; 

            $html = '<p> The above named Client is to be seen<input type="text" name="no_seen_days" maxlength="50" value="'.$planOfCareEmpleyee[0]['no_seen_days'].'" style="width:2%;height:50px;margin-bottom:5px"  />Days a week on:</p>
            <br>
            <p>
            Mon <input type="text" name="mon" align="center" maxlength="50" value="'.$patientData['mon_limit'].'" style="width:50px;height:50px;margin-bottom:5px" /> 
            Tue <input type="text" name="tue" maxlength="50" value="'.$patientData['tue_limit'].'" style="width:50px;height:50px;margin-bottom:5px" />
            Wed <input type="text" name="wed" maxlength="50" value="'.$patientData['wed_limit'].'" style="width:50px;height:50px;margin-bottom:5px" />
            Thu <input type="text" name="thu" maxlength="50" value="'.$patientData['thu_limit'].'" style="width:50px;height:50px;margin-bottom:5px" />
            Fri <input type="text" name="fri" maxlength="50" value="'.$patientData['fri_limit'].'" style="width:50px;height:50px;margin-bottom:5px" />
            Sat <input type="text" name="sat" maxlength="50" value="'.$patientData['sat_limit'].'" style="width:50px;height:50px;margin-bottom:5px" />
            Sun <input type="text" name="sun" maxlength="50" value="'.$patientData['sun_limit'].'" style="width:50px;height:50px;margin-bottom:5px" /></p>
            ';

            $mpdf->WriteHTML($html);

            if($patientData['dailyhrslimit'] == 1) {
        $checklimit  = "x";  
      }


            $html =   '<table style="width:100%;border:1px solid white;padding-left:3px;"> 
            <tr> 
            <td style="width:30px;font-size:13px;"> From </td> 
            <td style="border-bottom:1px solid black;width:30px"> '.$plcData['from_time'].' </td> 
            <td style="width:30px;font-size:13px;"> &nbsp;&nbsp; To </td>
            <td style="border-bottom:1px solid black;width:30px"> '.$plcData['to_time'].' </td> 
            <td style="width:10px">  </td>
            <td style="border-bottom:1px solid black;width:40px"> '.$plcData['no_hours'].' </td> 
            <td style="width:100px;font-size:13px;"> Hours per week  
            </td>
            <td style="width:40%">

              <input type="text" name="sun" maxlength="50" value="1" style="width:12px;height:50px;margin-bottom:5px" value="'.$checklimit.'" />
              <b> Daily Hours  </b>   
              <input type="text" name="dailyhrs" maxlength="50" value="'.$patientData['dailyhrs'].'" style="width:20%;height:25px;border:2px solid black"/>


            </td>

            </tr> 
            </table> <br>';  

            if(!empty($plcData['date_of_services'])) {
              $plcData['date_of_services'] = convertDate($plcData['date_of_services'], 'm-d-Y');;
            }

            $mpdf->WriteHTML($html);
            $html =   '<table style="width:55%;border:1px solid white;padding-left:3px;"> <tr> <td style="font-size:13px;"> Start Date of Services   </td>   <td style="width:40%;border-bottom:1px solid black"> '.$plcData['date_of_services'].' </td> </tr> </table> ';  

            $mpdf->WriteHTML($html);

            $html2 = $html2.'         

            <table style="width:100%;height:80%;padding-left:3px;" rowspan="0" colspan="0" valign="0">
            <tr>
            <td style="width:50%;height:50%;font-size:13px" rowspan="0" colspan="0" valign="0">
            <br>
            You should provide only the following duties (checked):
            <br>
            <br>
             <table style="width:100%">
             ';
             //$html2 ='<table style="width:100%">';
            $intRows = 0;
            if(!empty($employeeTask))  {
            foreach ($employeeTask as $key => $row) {
              if ($intRows == 0) { $html2 = $html2.'<tr>'; }
              $z = $row['task_code'];
                  $checkstatus = ''; 
              $patientTask = explode(',', $patientData['tasks']);
              if(in_array($row['task_code'], $patientTask)) {
                  $checkstatus="&nbsp;&nbsp;X";
              }
                      $intRows++;
                
             $html2  =   $html2. '<td style="align:left;font-size:13px;border-bottom:2px solid white"> <p  class="small">';

             $html2 = $html2.'<table> <tr> <td style="width:30px;border-bottom:1px solid black;font-size:13px;" align="left">  '. $checkstatus.' </td>   <td style="width:150px;border:1px solid white;font-size:13px;" align="left" > '.$z.'. '. $row['task_name'].'</td>  </tr> </table>  ';

             $html2 = $html2. '</p> </td>';
             if ($intRows >= 3) { $intRows = 0; } 
             if ($intRows == 0) { $html2 = $html2.'</tr>'; }

             } }
             $html2 = $html2.'</table>
             </td>
             </tr>
             </table>

             <br>
             <br>'; 

            $mpdf->WriteHTML($html2);

            $html = '
            <table  style="width:100%;font-size:100%;padding:10px" border="0">

            <tr>
            <td style="width:40%;">   
            <table style="width:100%">   <tr> <td style="width:50%;font-size:13px;"> Supervisor '."'s ". 'Signature  </td> <td style="border-bottom:1px solid black"> '.$plcData['signature'].'</td>   </tr> </table>
            </td> 
            <td style="width:30%"> 
            <table style="width:100%">   <tr> <td style="width:20%"> Date:  </td> <td style="border-bottom:1px solid black;"> '.$plcData['signed_date'].'</td>   </tr> </table>
            </td>
            <td style="width:20%"> 
            </td>

            </tr>

            </table> ';

            $Agency = $_SESSION['agency'];
            if ($Agency == 1) {
              $AgencyName = 'HM';
            }
            if ($Agency == 2) {
              $AgencyName = 'SC';
            }
            if ($Agency == 3) {
              $AgencyName = 'CG';
            }
            if ($Agency == 4) {
              $AgencyName = 'RF';
            }


            $AgencyName = 'hcp_pdf_files/'.$AgencyName;

            $lastname = str_replace("'","",$patientData['lastname']);
            $firstname = str_replace("'","",$patientData['firstname']);
            $dirname = FCPATH."/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];

            //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$_GET['patient'];
                
            if (!file_exists($dirname)) {
                mkdir($dirname, 0777, true);
            }   
            $filename = $dirname.'/POC'.date('mdYH:i:s').'.pdf';
            $mpdf->WriteHTML($html);

            $mpdf->Output();
            $mpdf->Output($filename,'F');
            exit;
        } else {
            redirect();
        }
    }

    public function patientPocPdfViewOld2() {
      if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
        $data['patient']  = $_GET['patient'];
        $data['plc_id'] = $_GET['plc_id'];
        $data['emplok'] = $_GET['emplok'];
        $data['emplid2'] = $_GET['emplid2'];
        $data['hoursType'] = $_GET['hoursType'];

        $where  = [];
        $where['patient_id'] = $_GET['patient'];            
        $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
        $data['Agency'] = $this->session->userdata('agency');
        $this->load->view('patient-poc-pdf.php',$data);     
      } else {
            redirect();
        } 
    }

    public function patientPocPdfView() {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
        //error_reporting(E_ALL);

        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
            $data['patient']  = $_GET['patient'];
            $data['plc_id'] = $_GET['plc_id'];
            $data['emplok'] = $_GET['emplok'];
            $data['emplid2'] = $_GET['emplid2'];
            $data['hoursType'] = $_GET['hoursType'];

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
            $data['Agency'] = $this->session->userdata('agency');
            //$this->load->view('patient-poc-pdf2.php',$data);     
            $this->load->view('patient-poc-pdf.php',$data);     
        } else {
            redirect();
        } 
    }

    public function employeePocPdfViewOld() {
      if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['emplid2'])) {
        $data['patient']  = $_GET['patient'];
        $data['emplid2'] = $_GET['emplid2'];
        $data['emplok'] = $_GET['emplok'];

        $data['Agency'] = $this->session->userdata('agency');
        $this->load->view('patient/emp-poc-pdf.php',$data);     
      } else {
        redirect();
      } 
    }

    public function employeePocPdfView() {
      if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['emplid2'])) {
        $data['patient']  = $_GET['patient'];
        $data['emplid2'] = $_GET['emplid2'];
        $data['emplok'] = $_GET['emplok'];

        $data['Agency'] = $this->session->userdata('agency');
        //$this->load->view('patient/emp-poc-pdf2.php',$data);     
        $this->load->view('patient/emp-poc-pdf.php',$data);     
      } else {
        redirect();
      } 
    }


    public function patientPocPdfViewOLD() {
      if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['plc_id'])) {
        $data['patient']  = $_GET['patient'];
        $data['plc_id'] = $_GET['plc_id'];
        $data['emplok'] = $_GET['emplok'];
        $data['emplid2'] = $_GET['emplid2'];

        $where  = [];
        $where['patient_id'] = $_GET['patient'];            
        $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
        $data['Agency'] = $this->session->userdata('agency');
        $this->load->view('patient-poc-pdf-old.php',$data);     
      } else {
            redirect();
        } 
    }

    public function getDistrictManagers(){
        $postData = $this->input->post();
        if(!empty($postData['districtManagerID_Ref']) && !empty($postData['agency_id'])) {
            $where = [];
            $where['DistrictID_Ref'] = $postData['districtManagerID_Ref'];
            $where['Agency'] = $postData['agency_id'];  
            $districtData = $this->Comman_model->get_rows('tbldistrictmanagers', $where);
            $data = '';
            if(!empty($districtData)) {
                $data .= '<option value="">Select..</option>';
                foreach ($districtData as $key => $row) {
                    $data .= '<option value="'.$row['DMID'].'">'.$row['DMName'].'</option>';
                }
            } else {
                echo 0;
            }
            print_r($data);
        }
    }


    public function savePreviousDistricts($districtId_Ref, $DistrictID_temp, $NewDistrictStartDate, $NewdistrictId_Ref, $agency_id, $patient_id){
        $postData = $this->input->post();
        if(!empty($postData['districtId_Ref']) && !empty($postData['agency_id'])) {

            $Agency = $agency_id;
            $patient_id = $patient_id;

            $DistrictID_Ref = $districtId_Ref;
            $DistrictID_temp = $DistrictID_temp;
            $NewDistrictStartDate = $NewDistrictStartDate;
            $NewdistrictId_Ref = $NewdistrictId_Ref;            

            $savedistrict =  'no';
            if ($NewdistrictId_Ref!=$DistrictID_temp) {
                $savedistrict = 'yes';
                //echo "im here!!!!!!!!!!!!!!!!!";
                $eff_date = date('Y-m-d', strtotime($NewDistrictStartDate));
                $tempdate = $NewDistrictStartDate;

                $month = date('m',strtotime($eff_date));
                $year = date('Y',strtotime($eff_date));
                //$day = date('d',strtotime($eff_date));
                $today = $eff_date;   // date('Y-m-d');
                $invalid = 0;
                list($mm,$dd,$yy)=explode("/",$tempdate);       
                if(@checkdate($mm,$dd,$yy)) {
                    $d1 = $year.'-'.$month.'-'.$day;
                } else {
                    $invalid = 1;
                    $DistrictID_Ref = $DistrictID_temp;
                }                           

                if ($invalid == 0) {
                    $TchkSQL = "SELECT * FROM table_2weekly WHERE end_date >= '$eff_date' AND start_date  <= '$eff_date'";
                    $TchkResult = get_custom_query_data($TchkSQL, 'row');
                    if (!empty($TchkResult)) {
                        $start_date = $TchkResult['start_date'];
                    }

                    $distSQL1 = "SELECT * FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref' AND Agency = '$Agency'" ;
                    $distResult1 = get_custom_query_data($distSQL1, 'row');
                    if(!empty($distResult1)) {
                        $mco = $distResult1['mco'];
                    }

                    $districtSQL =  "SELECT * FROM district WHERE patient_id = '$patient_id' AND month = '$month'  AND year = '$year'";
                    $districtResult =  get_custom_query_data($districtSQL, 'row');

                    if (empty($districtResult)) {  
                        $insert = "INSERT INTO district (patient_id,month,year,mco,DistrictID_Ref,date_modified,start_date) VALUES ('$patient_id','$month','$year','$mco','$DistrictID_Ref','$today','$start_date')";
                        set_custom_query_data($insert);
                    } else {
                        $district_id = $districtResult['district_id'];  
                        $query = "UPDATE district SET mco = '$mco',DistrictID_Ref='$DistrictID_Ref',date_modified='$today',start_date='$start_date' WHERE district_id = '$district_id'";
                        set_custom_query_data($query);
                    }

                    /************ Start Tracking District ***********/

                    $distSQL1 = "SELECT * FROM tbldistricts WHERE DistrictID = '$DistrictID_temp' AND Agency = '$Agency'" ;
                    $distResult1 = get_custom_query_data($distSQL1, 'row');
                    if(!empty($distResult1)) {
                        $mco1 = $distResult1['mco'];
                    }

                    $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND month = '$month'  AND year = '$year'";
                    $districtResult =  get_custom_query_data($districtSQL, 'row');                    

                    if (empty($districtResult)) {  
                        $insert = "INSERT INTO tracking_district (patient_id,month,year,mco,DistrictID_Ref,date_modified,start_date, previous_district_id, previous_district_mco, previous_district_startdate) VALUES ('$patient_id','$month','$year','$mco','$DistrictID_Ref','$today','$start_date','$DistrictID_temp','$mco1','$start_date')";
                        set_custom_query_data($insert);
                    } else {
                        $district_id = $districtResult['district_id'];  
                        $query = "UPDATE tracking_district SET mco = '$mco',DistrictID_Ref='$DistrictID_Ref',date_modified='$today',start_date='$start_date', previous_district_mco = '$mco1',previous_district_id='$DistrictID_temp',previous_district_startdate='$start_date' WHERE district_id = '$district_id'";
                        set_custom_query_data($query);
                    }
                    /************ End Tracking District ***********/

                    $query = "UPDATE patient SET DistrictID_Ref='$NewdistrictId_Ref',NewDistrictStartDate='$eff_date' WHERE patient_id = '$patient_id'";
                    set_custom_query_data($query);
                }
            }            
        }
    }


    public function getPreviousDistricts(){
        $postData = $this->input->post();
        if(!empty($postData['districtId_Ref']) && !empty($postData['agency_id'])) {

            $Agency = $postData['agency_id'];
            $patient_id = $postData['patient_id'];

            $DistrictID_Ref = $postData['districtId_Ref'];
            $DistrictID_temp = $postData['DistrictID_temp'];
            $NewDistrictStartDate = $postData['NewDistrictStartDate'];
            $NewdistrictId_Ref = $postData['NewdistrictId_Ref'];            

            $savedistrict =  'no';
            if ($NewdistrictId_Ref!=$DistrictID_temp) {
                $savedistrict = 'yes';
                //echo "im here!!!!!!!!!!!!!!!!!";
                $eff_date = date('Y-m-d', strtotime($NewDistrictStartDate));
                $tempdate = $NewDistrictStartDate;

                $month = date('m',strtotime($eff_date));
                $year = date('Y',strtotime($eff_date));
                //$day = date('d',strtotime($eff_date));
                $today = $eff_date;   // date('Y-m-d');
                $invalid = 0;
                list($mm,$dd,$yy)=explode("/",$tempdate);       
                if(@checkdate($mm,$dd,$yy)) {
                    $d1 = $year.'-'.$month.'-'.$day;
                } else {
                    $invalid = 1;
                    $DistrictID_Ref = $DistrictID_temp;
                }                           

                if ($invalid == 0) {
                    $TchkSQL = "SELECT * FROM table_2weekly WHERE end_date >= '$eff_date' AND start_date  <= '$eff_date'";
                    $TchkResult = get_custom_query_data($TchkSQL, 'row');
                    if (!empty($TchkResult)) {
                        $start_date = $TchkResult['start_date'];
                    }

                    $distSQL1 = "SELECT * FROM tbldistricts WHERE DistrictID = '$DistrictID_Ref' AND Agency = '$Agency'" ;
                    $distResult1 = get_custom_query_data($distSQL1, 'row');
                    if(!empty($distResult1)) {
                        $mco = $distResult1['mco'];
                    }

                    $districtSQL =  "SELECT * FROM district WHERE patient_id = '$patient_id' AND month = '$month'  AND year = '$year'";
                    $districtResult =  get_custom_query_data($districtSQL, 'row');

                    if (empty($districtResult)) {  
                        $insert = "INSERT INTO district (patient_id,month,year,mco,DistrictID_Ref,date_modified,start_date) VALUES ('$patient_id','$month','$year','$mco','$DistrictID_Ref','$today','$start_date')";
                        set_custom_query_data($insert);
                    } else {
                        $district_id = $districtResult['district_id'];  
                        $query = "UPDATE district SET mco = '$mco',DistrictID_Ref='$DistrictID_Ref',date_modified='$today',start_date='$start_date' WHERE district_id = '$district_id'";
                        set_custom_query_data($query);
                    }

                    /************ Start Tracking District ***********/

                    $distSQL1 = "SELECT * FROM tbldistricts WHERE DistrictID = '$DistrictID_temp' AND Agency = '$Agency'" ;
                    $distResult1 = get_custom_query_data($distSQL1, 'row');
                    if(!empty($distResult1)) {
                        $mco1 = $distResult1['mco'];
                    }

                    $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND month = '$month'  AND year = '$year'";
                    $districtResult =  get_custom_query_data($districtSQL, 'row');                    

                    if (empty($districtResult)) {  
                        $insert = "INSERT INTO tracking_district (patient_id,month,year,mco,DistrictID_Ref,date_modified,start_date, previous_district_id, previous_district_mco, previous_district_startdate) VALUES ('$patient_id','$month','$year','$mco','$DistrictID_Ref','$today','$start_date','$DistrictID_temp','$mco1','$start_date')";
                        set_custom_query_data($insert);
                    } else {
                        $district_id = $districtResult['district_id'];  
                        $query = "UPDATE tracking_district SET mco = '$mco',DistrictID_Ref='$DistrictID_Ref',date_modified='$today',start_date='$start_date', previous_district_mco = '$mco1',previous_district_id='$DistrictID_temp',previous_district_startdate='$start_date' WHERE district_id = '$district_id'";
                        set_custom_query_data($query);
                    }
                    /************ End Tracking District ***********/

                    $query = "UPDATE patient SET DistrictID_Ref='$NewdistrictId_Ref',NewDistrictStartDate='$eff_date' WHERE patient_id = '$patient_id'";
                    set_custom_query_data($query);
                }
            }


            $strSQL = "SELECT * FROM tbldistricts,district WHERE district.patient_id = '$patient_id' AND Agency = '$Agency' AND tbldistricts.DistrictID = district.DistrictID_Ref  ORDER BY district_id ASC" ;
            $districtData = $this->Comman_model->getCustomQueryData($strSQL);

            $data = '';
            if(!empty($districtData)) {
                $data .= '<option value="">Select..</option>';
                foreach ($districtData as $key => $row) {
                    $selected = "";
                    if($row['DistrictID_Ref']==$postData['districtId_Ref']) {
                        $selected = 'selected="selected"';
                    }
                    $data .= '<option value="'.$row['DistrictID_Ref'].'" '.$selected.'>'.$row['DistrictNumber'].'-'.$row['DistrictName'].'</option>';
                }
            } else {
                echo 0;
            }
            print_r($data);
        }
    }

    public function getDistrictDetail() {
        $postData = $this->input->post();
        if(!empty($postData['districtManagerID_Ref']) && !empty($postData['agency_id'])) {
            $where = [];
            $where['DistrictID'] = $postData['districtManagerID_Ref'];
            $where['Agency'] = $postData['agency_id'];  
            $districtData = $this->Comman_model->get_row('tbldistricts', $where);
            $data = '';
            if(!empty($districtData)) {
                print_r(json_encode($districtData));
            } else {
                echo 0;
            }
        }   
    }

    public function billedHours($patient_id='') {
        if(isset($_SESSION['name']) && !empty($patient_id)) {
            //$where = [];
            //$where['pt.patient_id'] = $patient_id;
            $month = date('n')-1;
            $year = date('Y');
            if(!empty($this->input->post('month'))) {
              $month = $this->input->post('month');  
            }
            if(!empty($this->input->post('year'))) {
              $year = $this->input->post('year');  
            }
            /*$agency = $this->session->userdata('agency');

            if($agency==1 || $agency==3){
              $data['billedHours'] = $this->Comman_model->getBilledtHours($where, $month);
            }

            if($agency==2 || $agency==4){
              $data['billedHours'] = $this->getBilledtHoursFromEmployeeClock($patient_id, $month);
            }*/

            $where = [];
            $where['patient_id'] = $patient_id;
            $where['month'] = $month;
            $where['year'] = $year;
            $billedData = $this->Comman_model->get_row('billed_hours_old', $where); 
            if(!empty($billedData)) {
              $data['billedHours'] = $billedData['total_hrs'];  
            }

            $where = [];
            $where['patient_id'] = $patient_id;
            $data['patientData'] = $this->Comman_model->get_row('patient', $where);

            $data['month'] = $month;
            $data['year'] = $year;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/billed-hours.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/billed-hours-new.php',$data);
        } else {
          redirect('');
        }
    }


    public function getBilledtHoursFromEmployeeClock($patient, $month) {
      $patientId = $patient;

      $agency_code = $this->session->userdata('agency');

      $datetrans = date("Y-m-d", mktime(0, 0, 0, $month, 1));

      $year = date("Y",strtotime($datetrans)); 
      $month = date("m",strtotime($datetrans)); 
      $tdate = strtotime($year.'-'.$month.'-01');
      $action = 2;
      /*if (empty($action) ) {
        $day = date("d",strtotime($datetrans));
        if ($day >= 1 && $day <= 15) {
          $action = 1;
        } else { 
          $action = 2; 
        }
      }*/


      /*if ($action == 1) {
        $cutoff = 1;
        $eom = 15;
        $tdate2 = strtotime($year.'-'.$month.'-01');
        $fromdate = date("Y-m-d",$tdate2);
        $tdate2 = strtotime($year.'-'.$month.'-15');
        $todate = date("Y-m-d",$tdate2);        
      } */


      if ($action ==2) {
        $cutoff = 16;
        $eom = 31;
        //$tdate2 = strtotime($year.'-'.$month.'-16');
        $tdate2 = strtotime($year.'-'.$month.'-01');
        $fromdate = date("Y-m-d",$tdate2);
        $todate = date("Y-m-t",$tdate);         
      }

      //print_r($fromdate);

      /*$fromdate = $this->input->get('start');
      $todate = $this->input->get('end');
      $fromdate = date('Y-m-d', strtotime($fromdate));
      $todate = date('Y-m-d', strtotime($todate));*/

      //print_r($fromdate);die;

      //$MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$patientId' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' AND reset IS NOT NULL ORDER BY date ";

      $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE patient_id = '$patientId' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' ORDER BY date ";

      $singleViewData = $this->Comman_model->getCustomQueryData($MySQL); 

      $curdate = date('m/d/Y');
      $index = 0;
      $timetotal = 0;
      $billedHour = 0;
      foreach($singleViewData as $row) {
        //$bgcolor = ""; 
        $timedate = date("Y-m-d",strtotime($row['date'])) ;
        $temp = '';
        $c1 = $row['employee_clock_id'];
        $temp = date('H:i',strtotime($row['date']));

        $latitude = $row['latitude'];
        $task3 = $row['tasks'];
        $task1 = trim($row['ivr_task']);
        $ivr_task = trim($row['tasks']);
        $task2 = "";
        $t = explode(":",$temp );
        $hr1 = $t[0];
        $mn1 = $t[1];
        $fdate = date('Y-m-d',strtotime($row['date']));
        $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

        $disp1 = $hr1 + ($mn1 / 60);
        $tot1 = quarter($disp1);
        $tot1 = number_format($tot1,2);
        $from_time=$tot1;

        //$scolor = '';
        //if ($row['tagedit'] == 3 ) { $scolor = "red"; }
        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);
        $timein = '';
        if ($orig != 0) { $timein =  date('H:i',strtotime($orig['date'])); }

        $x = '2';
        $rec_id = $row['rec_id'];

        $where = [];
        $where['employee_id'] = $row['employee_id'];
        $where['patient_id'] = $row['patient_id'];
        $where['DATE(date)'] = $timedate;
        $where['isIn'] = $x;
        $where['rec_id'] = $rec_id;
        $rowdate = get_employee_clock($where);

        $to_time=strtotime($rowdate['date']);
        $total = number_format((($to_time - $from_time) / 60) / 60,2);

        $temp = '';
        $c2 = null;
        if ($rowdate != 0 ) {
          $temp = date('H:i',strtotime($rowdate['date'])); $c2 = $rowdate['employee_clock_id']; $task2 = trim($rowdate['ivr_task']); 
        }
        $t = explode(":",$temp );
        $hr2 = $t[0];
        $mn2 = $t[1];
        $fdate = date('Y-m-d',strtotime($rowdate['date']));
        $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

        $disp2 = $hr2 + ($mn2 / 60);
        $tot2 = quarter($disp2);
        $tot2 = number_format($tot2,2);

        $to_time=$tot2;

        if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') || empty($rowdate) )  {
            $total = 0;
        } else {
            $total = $to_time - $from_time;
        }

        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);

        $timeout = '';       
        if ($orig != 0) { $timeout =  date('H:i',strtotime($orig['date'])); }
        if ($from_time != null && $to_time != null ) {
          if ($rowdate != 0 )   {
            $timetotal =  $timetotal + quarter(abs($total));    
          } 
        }   
        $billedHour = $billedHour + quarter(abs($total));
        
      }       
      return $billedHour;
    }

    public function getBilledHours() {
      $month = $this->input->post('month');
      $year = $this->input->post('year');
      $patient_id = $this->input->post('patient_id');
      $billedHours = '0.00';
      if(!empty($year) && !empty($month) && !empty($patient_id)) {
        /*$where = [];
        $where['pt.patient_id'] = $patient_id;
        $agency = $this->session->userdata('agency');
        if($agency==1 || $agency==3){
          $billedHours = $this->Comman_model->getBilledtHours($where, $month);
        }
        if($agency==2 || $agency==4){
          //$billedHours = $this->Comman_model->getBilledtHoursByOther($where, $month);
          $billedHours = $this->getBilledtHoursFromEmployeeClock($patient_id, $month);
        }*/
        $where = [];
        $where['patient_id'] = $patient_id;
        $where['month'] = $month;
        $where['year'] = $year;
        $billedData = $this->Comman_model->get_row('billed_hours_old', $where); 
        if(!empty($billedData)) {
          $billedHours = $billedData['total_hrs'];  
        }
      }
      echo $billedHours;
    }


    public function approvedHours($patient_id='') {
        if(isset($_SESSION['name']) && !empty($patient_id)) {
            $where = [];
            $where['patient_id'] = $patient_id;
            $data['approvedHoursData'] = $this->Comman_model->get_rows('approvehours', $where, 'approvehours_id', 'desc');

            $data['patientData'] = $this->Comman_model->get_row('patient', $where);

            //print_r($data['approvedHoursData']);

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/patient-approved-hours.php',$data);
            //$this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/patient-approved-hours-new.php',$data);
        } else {
          redirect('');
        }
    }


    public function calendarBilledHours() {

      $patientId = $this->input->get('patient');

      $agency_code = $this->session->userdata('agency');

      $datetrans = date("Y-m-d", mktime(0, 0, 0, date("m")-1, 1));

      $year = date("Y",strtotime($datetrans)); 
      $month = date("m",strtotime($datetrans)); 
      $tdate = strtotime($year.'-'.$month.'-01');
      $action = @$_GET['action'];
      if (empty($action) ) {
        $day = date("d",strtotime($datetrans));
        if ($day >= 1 && $day <= 15) {
          $action = 1;
        } else { 
          $action = 2; 
        }
      }

      $action = 2;

      if ($action == 1) {
        $cutoff = 1;
        $eom = 15;
        $tdate2 = strtotime($year.'-'.$month.'-01');
        $fromdate = date("Y-m-d",$tdate2);
        $tdate2 = strtotime($year.'-'.$month.'-15');
        $todate = date("Y-m-d",$tdate2);        
      } 


      if ($action ==2) {
        $cutoff = 16;
        $eom = 31;
        //$tdate2 = strtotime($year.'-'.$month.'-16');
        $tdate2 = strtotime($year.'-'.$month.'-01');
        $fromdate = date("Y-m-d",$tdate2);
        $todate = date("Y-m-t",$tdate);         
      }

      //print_r($fromdate);

      $fromdate = $this->input->get('start');
      $todate = $this->input->get('end');
      $fromdate = date('Y-m-d', strtotime($fromdate));
      $todate = date('Y-m-d', strtotime($todate));

      //print_r($fromdate);die;

      //$MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$patientId' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' AND reset IS NOT NULL ORDER BY date ";

      $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE patient_id = '$patientId' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' ORDER BY date ";

      $singleViewData = $this->Comman_model->getCustomQueryData($MySQL); 

      $curdate = date('m/d/Y');
      $index = 0;
      $timetotal = 0;
      foreach($singleViewData as $row) {
        //$bgcolor = ""; 
        $timedate = date("Y-m-d",strtotime($row['date'])) ;
        $temp = '';
        $c1 = $row['employee_clock_id'];
        $temp = date('H:i',strtotime($row['date']));

        $latitude = $row['latitude'];
        $task3 = $row['tasks'];
        $task1 = trim($row['ivr_task']);
        $ivr_task = trim($row['tasks']);
        $task2 = "";
        $t = explode(":",$temp );
        $hr1 = $t[0];
        $mn1 = $t[1];
        $fdate = date('Y-m-d',strtotime($row['date']));
        $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

        $disp1 = $hr1 + ($mn1 / 60);
        $tot1 = quarter($disp1);
        $tot1 = number_format($tot1,2);
        $from_time=$tot1;

        //$scolor = '';
        //if ($row['tagedit'] == 3 ) { $scolor = "red"; }
        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);
        $timein = '';
        if ($orig != 0) { $timein =  date('H:i',strtotime($orig['date'])); }

        $x = '2';
        $rec_id = $row['rec_id'];

        $where = [];
        $where['employee_id'] = $row['employee_id'];
        $where['patient_id'] = $row['patient_id'];
        $where['DATE(date)'] = $timedate;
        $where['isIn'] = $x;
        $where['rec_id'] = $rec_id;
        $rowdate = get_employee_clock($where);

        $to_time=strtotime($rowdate['date']);
        $total = number_format((($to_time - $from_time) / 60) / 60,2);

        $temp = '';
        $c2 = null;
        if ($rowdate != 0 ) {
          $temp = date('H:i',strtotime($rowdate['date'])); $c2 = $rowdate['employee_clock_id']; $task2 = trim($rowdate['ivr_task']); 
        }
        $t = explode(":",$temp );
        $hr2 = $t[0];
        $mn2 = $t[1];
        $fdate = date('Y-m-d',strtotime($rowdate['date']));
        $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

        $disp2 = $hr2 + ($mn2 / 60);
        $tot2 = quarter($disp2);
        $tot2 = number_format($tot2,2);

        $to_time=$tot2;

        if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') || empty($rowdate))  {
            $total = 0;
        } else {
            $total = $to_time - $from_time;
        }

        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);

        $timeout = '';       
        if ($orig != 0) { $timeout =  date('H:i',strtotime($orig['date'])); }
        //$scolor = '';
        //if ($rowdate['tagedit'] == 3 ) { $scolor = "red"; }
        if ($from_time != null && $to_time != null ) {
          if ($rowdate != 0 )   {
            //echo quarter(abs($total));    
            $timetotal =  $timetotal + quarter(abs($total));    
          } 
        }   
        if ($task1 != null ) {
            $task2 = $task1;
        }
        if ($latitude != null ) {
            $task2 = $task3;
        }
        $list = '';
        if ($task2 == '1')  {
            $task2 = "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16";
        }
        $t = explode(",",$task2 );
        $list = '';
        for ($x = 0;$x <= 16; $x++) {
          $item = @$t[$x];
          $where = [];
          $where['task_code'] = $item;
          $drpResult = get_row('employee_tasks', $where);

          $where = [];
          $where['patient_id'] = $row['patient_id'];
          $objResult2 = get_row('tblpatientservices', $where);
                            
          if ($objResult2['Eating'] == -1  && $item ==  1)   { $list = $list.$drpResult['task_name'].', ';   }
          if ($objResult2['Bathing'] == -1 && $item ==  2)   { $list = $list.$drpResult['task_name'].', ';   }
          if ($objResult2['Grooming'] == -1 && $item ==  3)   { $list = $list.$drpResult['task_name'].', '; }
          if ($objResult2['Dressing'] == -1 && $item ==  4)   { $list = $list.$drpResult['task_name'].', '; } 
          if ($objResult2['Transferring'] == -1 && $item ==  5)   { $list = $list.$drpResult['task_name'].', '; }
          if ($objResult2['Incontinence'] == -1 && $item ==  6)   {$list = $list.$drpResult['task_name'].', ';  }
          if ($objResult2['ManagingMoney'] == -1 && $item ==  7)   { $list = $list.$drpResult['task_name'].', '; }
          if ($objResult2['Telephoning'] == -1 && $item ==  8)   { $list = $list.$drpResult['task_name'].', '; }
          if ($objResult2['PreparingMeals'] == -1 && $item ==  9)   { $list = $list.$drpResult['task_name'].', '; }
          if ($objResult2['Laundry'] == -1 && $item ==  10)   { $list = $list.$drpResult['task_name'].', '; } 
          if ($objResult2['Housework'] == -1 && $item ==  11)   { $list = $list.$drpResult['task_name'].', '; } 
          if ($objResult2['OutsideHome'] == -1 && $item ==  12)   { $list = $list.$drpResult['task_name'].', '; }
          if ($objResult2['RoutineHealth'] == -1 && $item ==  13)   { $list = $list.$drpResult['task_name'].', ';  } 
          if ($objResult2['SpecialHealth'] == -1 && $item ==  14)   { $list = $list.$drpResult['task_name'].', '; }
          if ($objResult2['BeingAlone'] == -1 && $item ==  15)   { $list = $list.$drpResult['task_name'].', '; }
        } 

        if($total!=0) {
          $billedHour = quarter(abs($total));
          $billedHour = $billedHour.' Hr<br><h6 class="billed-text">Billed</h6>';
          $eventArr[] =
                  [
                    'title'=>$billedHour,
                    'description'=>$list,
                    'start'=>date('Y-m-d', strtotime($row['date'])),
                    'end'=>date('Y-m-d', strtotime($row['date'])),
                    'textEscape' => false,
                    //'color' => '#000000',
                    //'backgroundColor' => '#ffffff'
                  ];   
        }
      }       
      print_r(json_encode($eventArr));
    }


    public function calendarBilledHoursNew() {

      $patientId = $this->input->get('patient');
      $month = $this->input->get('month');
      $year = $this->input->get('year');

      $where =[];
      $where['patient_id'] = $patientId;
      $where['month'] = $month;
      $where['year'] = $year;

      $row = $this->Comman_model->get_row('billed_hours_old', $where);

      if(!empty($row)) {
        
        $list = '';

        for ($i=1; $i <= 31 ; $i++) { 
          $d =  'day'.sprintf("%02s", $i);
          //$year = date('Y');
          $start_date = date('Y-m-d', strtotime($year.'-'.$month.'-'.$i));

          $billedHour = $row[$d];
          if(!empty($row[$d]) && $row[$d]!='0.00') {
            $billedHour = $billedHour.' Hr<br><h6 class="billed-text">Billed</h6>';  
          }

          $eventArr[] =
                        [
                          'title'=>$billedHour,
                          'description'=>$list,
                          'start'=>$start_date,
                          'end'=>$start_date,
                          'textEscape' => false,
                          //'color' => '#000000',
                          //'backgroundColor' => '#ffffff'
                        ];
        }
           
      }       
      print_r(json_encode($eventArr));
    }

    public function weeklyCalendar() {
        $patient_id  = $_GET['patient'];
        if(isset($_SESSION['name']) && !empty($patient_id)) {
            $month = date('m');
            $year = date('Y');
            if(!empty($_GET['month'])) {
                //$month  = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                //$year   = $_GET['year'];
            }

            $fromdate   = $year.'-'.$month.'-01';
            $todate     = $year.'-'.$month.'-31';

            $ptid = $patient_id;

            $where = [];
            $where['patient_id'] = $patient_id;
            $data['patientData'] = $this->Comman_model->get_row('patient', $where);

            $data['month']  = $month;
            $data['year']   = $year;
            $data['startDate'] = $fromdate;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/weekly-calendar.php',$data);
            $this->load->view('common/footer.php');
        } else {
          redirect('');
        }
    }

    public function weeklyCalendarData() {
        $patient_id = $this->input->get('patient');
        $month = $this->input->get('month');
        $year = $this->input->get('year');

        $ptid   = $patient_id;

        $where = [];
        $where['patient_id'] = $patient_id;
        $patientData = $this->Comman_model->get_row('patient', $where);

        $HMKRHours = $patientData['HMKRHours'];

        $fromdate   = $year.'-'.$month.'-01';
        $todate     = $year.'-'.$month.'-31';

        if(!empty($patientData)) {        
            $list = '';
            $twh = 0;
            $totalHrs = 0;
            $check = 1;   
            for ($i=1; $i <= 31 ; $i++) { 
                $start_date = date('Y-m-d', strtotime($year.'-'.$month.'-'.$i));
                $billedHour = '';
                //$billedHour = $tableData[$start_date][0];
                //$inout = $tableData[$start_date][1];
                if(in_array(date("l", strtotime($start_date)), ["Monday"])) {
                    $billedHour = $patientData['mon_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Tuesday"])) {
                    $billedHour = $patientData['tue_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Wednesday"])) {
                    $billedHour = $patientData['wed_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Thursday"])) {
                    $billedHour = $patientData['thu_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Friday"])) {
                    $billedHour = $patientData['fri_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Saturday"])) {
                    $billedHour = $patientData['sat_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Sunday"])) {
                    $billedHour = $patientData['sun_limit'];
                }

                if(!empty($billedHour) && $billedHour!='0.00') {
                    //$billedHour = $billedHour.' Hr<br><h6 class="billed-text">'.$inout.'</h6>';
                    $ptotalHrs  = $totalHrs;
                    $totalHrs   = $totalHrs + $billedHour;
                    if($HMKRHours<$totalHrs) {
                        if($check==1) {
                            $billedHour = $HMKRHours-$ptotalHrs;
                        }
                        $check++;
                    }                    
                    if($HMKRHours<$totalHrs && $check>2) {
                        $billedHour = '';
                    }
                } else {
                    if(in_array(date("l", strtotime($start_date)), ["Saturday"])) {
                        //$billedHour = $billedHour.'<h6 class="twh-text">TWH='.$twh.'</h6>';  
                    }
                    $billedHour = '';
                }

                $eventArr[] =
                        [
                          'title'=>$billedHour,
                          'description'=>$list,
                          'start'=>$start_date,
                          'end'=>$start_date,
                          'textEscape' => false,
                          //'color' => '#000000',
                          //'backgroundColor' => '#ffffff'
                        ];
            }           
        }       
        print_r(json_encode($eventArr));
    }


    public function weeklyEmployeeCalendar() {
        $patient_id  = $_GET['patient'];
        $employee_id  = $_GET['employee'];
        if(isset($_SESSION['name']) && !empty($patient_id)) {
            $month = date('m');
            $year = date('Y');
            if(!empty($_GET['month'])) {
                $month  = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                $year   = $_GET['year'];
            }

            $fromdate   = $year.'-'.$month.'-01';
            $todate     = $year.'-'.$month.'-31';

            $ptid = $patient_id;

            $where = [];
            $where['patient_id'] = $patient_id;
            $data['patientData'] = $this->Comman_model->get_row('patient', $where);

            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $data['month']  = $month;
            $data['year']   = $year;
            $data['startDate'] = $fromdate;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/weekly-employee-calendar.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/weekly-employee-calendar-new.php',$data);
            //$this->load->view('common/footer.php');
        } else {
          redirect('');
        }
    }

    public function weeklyEmployeeCalendarData() {
        $patient_id = $this->input->get('patient');
        $employee_id = $this->input->get('employee');
        $month = $this->input->get('month');
        $year = $this->input->get('year');

        $ptid   = $patient_id;

        $where = [];
        $where['patient_id'] = $patient_id;
        $patientData = $this->Comman_model->get_row('patient', $where);

        $HMKRHours = $patientData['HMKRHours'];

        $fromdate   = $year.'-'.$month.'-01';
        $todate     = $year.'-'.$month.'-31';
        $todate     = date('Y-m-t', strtotime($fromdate));
        $end = date('t', strtotime($fromdate));

        $sql = "SELECT * FROM employee_assignment WHERE patient_id = '$patient_id' AND employee_id = '$employee_id'";
        $row = $this->Comman_model->getCustomQueryData($sql,'row');              

        if(!empty($patientData)) {        
            $list = '';
            $twh = 0;
            $totalHrs = 0;
            $check = 1;   
            for ($i=1;$i<=$end;$i++) { 
                $start_date = date('Y-m-d', strtotime($year.'-'.$month.'-'.$i));
                $billedHour = '';
                //$billedHour = $tableData[$start_date][0];
                //$inout = $tableData[$start_date][1];
                if(in_array(date("l", strtotime($start_date)), ["Monday"])) {
                    $billedHour = $row['mon_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Tuesday"])) {
                    $billedHour = $row['tue_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Wednesday"])) {
                    $billedHour = $row['wed_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Thursday"])) {
                    $billedHour = $row['thu_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Friday"])) {
                    $billedHour = $row['fri_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Saturday"])) {
                    $billedHour = $row['sat_limit'];
                }
                if(in_array(date("l", strtotime($start_date)), ["Sunday"])) {
                    $billedHour = $row['sun_limit'];
                }

                if(!empty($billedHour) && $billedHour!='0.00') {
                    //$billedHour = $billedHour.' Hr<br><h6 class="billed-text">'.$inout.'</h6>';
                    $ptotalHrs  = $totalHrs;
                    $totalHrs   = $totalHrs + $billedHour;
                    if($HMKRHours<$totalHrs) {
                        if($check==1) {
                            $billedHour = $HMKRHours-$ptotalHrs;
                        }
                        $check++;
                    }                    
                    if($HMKRHours<$totalHrs && $check>2) {
                        $billedHour = '';
                    }
                } else {
                    if(in_array(date("l", strtotime($start_date)), ["Saturday"])) {
                        //$billedHour = $billedHour.'<h6 class="twh-text">TWH='.$twh.'</h6>';  
                    }
                    $billedHour = '';
                }

                $eventArr[] =
                        [
                          'title'=>$billedHour,
                          'description'=>$list,
                          'start'=>$start_date,
                          'end'=>$start_date,
                          'textEscape' => false,
                          //'color' => '#000000',
                          //'backgroundColor' => '#ffffff'
                        ];
            }           
        }       
        print_r(json_encode($eventArr));
    }


    public function editApproveHours(){

        if(isset($_SESSION['name']) && !empty($_GET['patient']) && !empty($_GET['approvedHoursId'])) {

            $patient_id = $_GET['patient'];
            $approvedHoursId = decode64($_GET['approvedHoursId']);

            $data['patient_id'] = $patient_id;
            $data['approvedHoursId'] = $approvedHoursId;

            $where = [];
            $where['approvehours_id'] = $approvedHoursId;
            $data['approvedHoursData'] = $this->Comman_model->get_row('approvehours', $where);
            if($data['approvedHoursData']['effective_date']=='0000-00-00') {
               $data['effective_date'] = '';
            } else {
               $data['effective_date'] = date('m/d/Y', strtotime($data['approvedHoursData']['effective_date']));
            }


            if( !empty( $this->input->post( 'update' ) ) ){
                $this->form_validation->set_rules('effective_date', 'Effective Date', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $effective_date = date('Y-m-d', strtotime($this->input->post('effective_date',true)));

                    $pdate = $effective_date;

                    $agency_code = $this->session->userdata('agency');
                    if ($agency_code == 2  || $agency_code == 4 )   {
                      $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$pdate' AND start_date  <= '$pdate'";
                      $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                      if (!empty($chkResult)) {
                        $effective = $chkResult['start_date'];
                        $m1 = date('m',strtotime($effective));
                        $y1 = date('Y',strtotime($effective));
                      }  
                    }  

                    if ($agency_code == 1 || $agency_code == 3) {
                      $m1 = date('m',strtotime($pdate));
                      $y1 = date('Y',strtotime($pdate));
                      if (date("d",strtotime($pdate))<= 15){
                        $effective = $y1.'-'.$m1.'-01';             
                        $effective = date("Y-m-d",strtotime($effective));
                      } 
                      if (date("d",strtotime($pdate))>=16) {
                        $effective = $y1.'-'.$m1.'-16';             
                        $effective = date("Y-m-d",strtotime($effective));
                      } 
                    }


                    $dataArray = [];
                    $dataArray['actual_date'] = $pdate;
                    $dataArray['effective_date'] = $effective;
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_id'] = $this->session->userdata('id');

                    $where = [];
                    $where['approvehours_id'] = $approvedHoursId;
                    $updateId = $this->Comman_model->update( "approvehours", $where, $dataArray );

                    if($updateId) {
                        $this->app->message('Approve Hours has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('patient/approvedHours/'.$patient_id,'refresh');
                }
            }

            $data['page'] = 'Update Approved Hours';

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('patient/edit-approved-hours.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php', $data);
            $this->load->view('patient/edit-approved-hours-new.php',$data);
        } else {
            redirect('');
        }
    }

    public function delete_approved_hours($delete_id='') {
        if(!empty($delete_id)) {
            $where  =   [];
            $where['approvehours_id']  =   $delete_id;
            $data = $this->Comman_model->delete_row('approvehours', $where);              
            if($data) {
                $this->app->message('Approve hours has been deleted successfully.', 'success');
            } else {
                $this->app->message('Oops something went wrong.', 'error');
            }
        }
        redirect($this->agent->referrer());
    }


    public function reportFrame($patient_id='') {
        if(isset($_SESSION['name']) && !empty($patient_id)) {

            $condstatus = $status = '';
            if(!empty($this->input->post('status'))) {
                $status = $this->input->post('status');

                if ($status != null)  { 
                    $condstatus = " AND patient.med_status = '$status' ";
                }

                if ($status == null || $status == 'Pending')  {
                    $condstatus = " AND (patient.med_status = 'Pending' OR patient.med_status = '')  "; 
                } 

                if ($status == '30Days')  { 
                    $condstatus = " AND patient.med_status = 'Active' ";
                }
            }




            $data['status'] = $status;

            $data['reportData'] = $this->client->get_all_report($_SESSION['agency'], $condstatus);
            $data['patient_id'] = $patient_id;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report-frame.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/report-frame-new.php',$data);
        }
    }


    public function changeAgency(){
        $postData = $this->input->post();
        if(!empty($postData['password'])) {
            $where = [];
            //$where['name'] = $postData['userName'];
            $where['user_id'] = $this->session->userdata('id');
            $where['password'] = md5($postData['password']);
            //$where['find_in_set("A",userlevel)<>'] = 0;
            $where['(find_in_set("A",userlevel) OR find_in_set("C",userlevel) OR find_in_set("I",userlevel))<>'] = 0;
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);


            if($check && (checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('C', $this->session->userdata('userlevel')) || checkUserLevel('I', $this->session->userdata('userlevel')))) {



                $where = [];
                $where['patient_id'] = $postData['patient_id'];
                $dataArray = [];
                $dataArray['Agency'] = $postData['changeAgency'];
                $dataArray['changenotes'] = $postData['changeNotes'];
                if($postData['changeAgency']==1) {
                  $dataArray['DistrictID_Ref'] = 991;
                }
                if($postData['changeAgency']==2) {
                  $dataArray['DistrictID_Ref'] = 992;
                }
                if($postData['changeAgency']==3) {
                  $dataArray['DistrictID_Ref'] = 993;
                }
                if($postData['changeAgency']==4) {
                  $dataArray['DistrictID_Ref'] = 994;
                }

                $update = $this->Comman_model->update('patient', $where, $dataArray);
                if($update) {

                  $where = [];
                  $where['agency_code'] = $postData['changeAgency'];
                  $agencyData = $this->Comman_model->get_row('agency', $where);

                  ############### USER ACTION TRACKING START ####################
                  if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user update client id '.$postData['patient_id'].' agency to '.$agencyData['agency_codename'].' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);    
                  }
                  ############### USER ACTION TRACKING END ####################

                  echo 1;
                } else {
                    echo 2;
                }
            } else {
                echo 0;
            }
        }
    }
    
    public function changeContact(){
        $postData = $this->input->post();
        if(!empty($postData['password'])) {
            $where = [];
            //$where['name'] = $postData['userName'];
            $where['user_id'] = $this->session->userdata('id');
            $where['password'] = md5($postData['password']);
            //$where['find_in_set("A",userlevel)<>'] = 0;
            $where['(find_in_set("A",userlevel) OR find_in_set("C",userlevel) OR find_in_set("I",userlevel) OR find_in_set("S",userlevel))<>'] = 0;
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);
            if($check && (checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('C', $this->session->userdata('userlevel')) || checkUserLevel('I', $this->session->userdata('userlevel')) || checkUserLevel('S', $this->session->userdata('userlevel')))) {
                $where = [];
                $where['patient_id'] = $postData['patient_id'];
                $dataArray = [];
                $dataArray['phone'] = $postData['changePhone'];
                $dataArray['phone2'] = $postData['changeAltPhone'];
                $update = $this->Comman_model->update('patient', $where, $dataArray);
                if($update) {
                  ############### USER ACTION TRACKING START ####################
                  if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user updated client id '.$postData['patient_id'].' Contact Number to '.$postData['changePhone'].' and Alt Contact Number to '.$postData['changeAltPhone'].' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);    
                  }  
                  ############### USER ACTION TRACKING END ####################
                  echo 1;
                } else {
                    echo 2;
                }
            } else {
                echo 0;
            }
        }
    }

    public function changeSupervisor(){
        $postData = $this->input->post();
        if(!empty($postData['password'])) {
            $user_id = $this->session->userdata('id');
            $where = [];
            //$where['name'] = $postData['userName'];
            $where['user_id'] = $this->session->userdata('id');
            $where['password'] = md5($postData['password']);
            //$where['find_in_set("A",userlevel)<>'] = 0;
            $where['(find_in_set("A",userlevel) OR find_in_set("C",userlevel) OR find_in_set("I",userlevel) OR find_in_set("L",userlevel))<>'] = 0;
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);

            $where = [];
            $where['patient_id'] = $postData['patient_id'];
            $patientData = $this->Comman_model->get_row('patient', $where);

            $where = [];
            $where['agency_location_code'] = $patientData['agency_location'];
            $locationData = $this->Comman_model->get_row('agency_location', $where);

            if(($locationData['lead_supervisor']==$user_id) || ($locationData['lead_supervisor2']==$user_id) || ($locationData['lead_supervisor3']==$user_id) || ($locationData['branch_manager']==$user_id)) {
                if($check && (checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('C', $this->session->userdata('userlevel')) || checkUserLevel('I', $this->session->userdata('userlevel')) || checkUserLevel('L', $this->session->userdata('userlevel')))) {                

                    if(!empty($postData['changeSupervisor'])) {
                        $dataArray = [];
                        $dataArray['supervisor_id'] = $postData['changeSupervisor'];

                        $where = [];
                        $where['patient_id'] = $postData['patient_id'];
                        $update = $this->Comman_model->update('patient', $where, $dataArray);
                        if($update) {
                            if($patientData['supervisor_id']!=$postData['changeSupervisor']) {
                            $where = [];
                            $where['supervisor_id'] = $postData['changeSupervisor'];
                            $supervisorData = $this->Comman_model->get_row('supervisor', $where);                        

                            $tdate = date("Y-m-d H:i:s");
                            $postuser = $this->session->userdata('name');

                            $dataArray = [];
                            $dataArray['patient_supervisor_id'] = null;
                            $dataArray['supervisor_id'] = $postData['changeSupervisor'];
                            $dataArray['supervisor_name'] = $supervisorData['name'];
                            $dataArray['date_modified'] = $tdate;
                            $dataArray['modified_by'] = $postuser;
                            $dataArray['patient_id'] = $postData['patient_id'];

                            $insert = $this->Comman_model->insert('patient_supervisor', $dataArray);

                          ############### USER ACTION TRACKING START ####################
                          if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated client id '.$postData['patient_id'].' supervisor to '.$supervisorData['name'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                          }
                          ############### USER ACTION TRACKING END ####################
                        }
                        echo 1;
                      } 
                    } else {
                      echo 2;
                    }
                } else {
                    echo 0;
                }
            } else {
                echo 4;
            }
        }
    }


    public function history() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {
            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

            $where= [];
            $where['patient_id'] = $_GET['patient'];
            $data['patientVisitData'] = $this->Comman_model->get_rows('tblpatientsvisits', $where);
            $data['patient_id'] =  $_GET['patient']; 

            $limit = 5;
            if(!empty($this->input->post('limit'))) {
              $limit = $this->input->post('limit');  
            }

            $where  = [];
            $where['puh.patient_id'] = $_GET['patient'];            
            $data['patientHistoryData']    =   $this->Comman_model->getPatientHistory($where, $limit);


            $where = [];
            $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $data['limit'] = $limit;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/history.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/history-new.php',$data);
        } else {
            redirect();
        }
    }

    public function findAvailableEmployees() {
        if(isset($_SESSION['name']) && !empty($_GET['patient'])) {

            $where  = [];
            $where['patient_id'] = $_GET['patient'];            
            $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
            $origins = $data['patientData']['ShipAddressAddr2'].' '.$data['patientData']['ShipAddressCity'].' '.$data['patientData']['ShipAddressState'];
            if(!empty($data['patientData']['ShipAddressAddr2'])) {
                //$origins .= ' '.$data['patientData']['ShipAddressAddr3'];  
            }

            //print_r($origins.'<br>');

            $limit = 5; $start = 0;
            if(!empty($this->input->post('showLimit'))) {
                $limit = $this->input->post('showLimit');
            }

            if(!empty($this->input->post('start'))) {
                $start = $this->input->post('start');
            }

            $where  = [];
            $gender = $DriveOnJob = $supervisor = $race = $language = $location = $filterBy = '';
            //$filterBy = 3;
            if(!empty($this->input->post('filterBy'))) {
                $filterBy = $this->input->post('filterBy');
            }

            //$where['em.Status'] = 1;
            if($filterBy==1) {
                $where['em.Status'] = 1;
            }

            if($filterBy==2) {
                $where['em.Status'] = 1;
                $where['em.EmployeeAddressCity'] = $data['patientData']['ShipAddressCity'];
            }

            if($filterBy==3) {
                $where['em.Status'] = 1;
                $where['em.EmployeeAddressPostalCode'] = $data['patientData']['ShipAddressPostalCode'];
            }

            if($filterBy==4) {
                $where['em.Status!='] = 1;
            }

            if($filterBy==5) {
                $where['em.Status!='] = 1;
                $where['em.EmployeeAddressCity'] = $data['patientData']['ShipAddressCity'];
            }

            if($filterBy==6) {
                $where['em.Status!='] = 1;
                $where['em.EmployeeAddressPostalCode'] = $data['patientData']['ShipAddressPostalCode'];
            }

            if($this->input->post('gender')!='') {
                $gender = $this->input->post('gender');
                $where['em.gender'] = $gender;
            }

            if($this->input->post('DriveOnJob')!='') {
                $DriveOnJob = $this->input->post('DriveOnJob');
                $where['em.DriveOnJob'] = $DriveOnJob;
            }

            if($this->input->post('supervisor')!='') {
                $supervisor = $this->input->post('supervisor');
                $where['em.supervisor_id'] = $supervisor;
            }

            if($this->input->post('fhca')!='') {
                $fhca = $this->input->post('fhca');
                $where['em.fhca'] = $fhca;
            }

            if($this->input->post('race')!='') {
                $race = $this->input->post('race');
                $where['em.race'] = $race;
            }

            if($this->input->post('location')!='') {
                $location = $this->input->post('location');
                $where['su.agency_location'] = $location;
            }

            if($this->input->post('language')!='') {
                $language = $this->input->post('language');
                $where['find_in_set("'.$language.'",em.language)<>'] = 0; 
            }

            $agency = $this->session->userdata('agency');
            if(!empty($this->input->post('byAgency'))) {
                $agency = $this->input->post('byAgency');
            }

            $where['em.EmployeeAddressAddr1!='] = '';
            $where['em.Agency'] = $agency;
            $where['em.popnotes is NOT NULL'] = NULL;
            $where['em.popnotes!='] = 'NULL';
            $where['em.agency_location'] = $data['patientData']['agency_location'];
            $data['employeeData']    =   $this->Employee_model->getNearByEmployeeData($where, $limit, $start);
            //print_r($data['employeeData']);die;
            //$data['employeeData']    =   $this->Comman_model->get_rows('employee', $where, '', '', '', $limit);

            $nearByEmployee = [];
            if(!empty($data['employeeData'])) {
                foreach ($data['employeeData'] as $key => $row) {
                    $total_limit = 0;
                    $where = [];
                    $where['employee_id'] = $row['employee_id'];
                    $result = $this->Comman_model->get_rows('employee_assignment', $where);
                    if(!empty($result)) {
                        foreach ($result as $key1 => $row2) {
                            $pin2 = $row2['pin'];
                            if (substr($pin2,0,1) != '+')  {
                                $total_limit = $total_limit + $row2['total_limit'];
                            }
                        }
                    }

                    if($total_limit>=40) {
                        continue;
                    }

                    $destinations = $row['EmployeeAddressAddr1'].' '.$row['EmployeeAddressCity'].' '.$row['EmployeeAddressState'];
  
                    $ch = curl_init();
                    $url = "https://maps.googleapis.com/maps/api/distancematrix/json";
                    $options = array(
                        "origins" => $origins,
                        "destinations" => $destinations,
                        "units" => "imperial",
                        "language" => "en-GB",
                        "key" => 'AIzaSyB3iE3D6Mksh20jN9n1lYT9Aawul-q97m0'
                    );

                    $request = $url . "?" . http_build_query( $options );
                
                    curl_setopt($ch, CURLOPT_URL, $request);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $output = json_decode(curl_exec($ch));

                    curl_close($ch);

                    $status = $output->status;

                    $cdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->value:0;
                    $sdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->text:0;

                    $nearByEmployee[$key]['employee_id'] = $row['employee_id'];  
                    $nearByEmployee[$key]['name'] = $row['name'];
                    if($row['gender']=='0') {
                        $nearByEmployee[$key]['gender'] = 'Male';  
                    }else if($row['gender']=='1') {
                        $nearByEmployee[$key]['gender'] = 'Female';
                    } else {
                        $nearByEmployee[$key]['gender'] = '';
                    }
                    if($row['DriveOnJob']=='-1') {
                        $nearByEmployee[$key]['DriveOnJob'] = 'Yes';  
                    } else {
                        $nearByEmployee[$key]['DriveOnJob'] = 'No';
                    }
                    $nearByEmployee[$key]['address'] = $destinations;
                    $nearByEmployee[$key]['cdistance'] = $cdistance;
                    //$nearByEmployee[$key]['sdistance'] = $sdistance;
                    $nearByEmployee[$key]['sdistance'] = number_format(round(($cdistance/1609.34), 1), 2);

                    $nearByEmployee[$key]['phone'] = $row['mobile'];
                    $nearByEmployee[$key]['total_limit'] = $total_limit;

                    /*$where = [];
                    if(!empty($supervisor)) {  
                    $where['supervisor_id'] = $supervisor;
                    } else {
                    $where['supervisor_id'] = $row['supervisor_id'];
                    }  
                    $nearByEmployee[$key]['supervisor'] = $this->Comman_model->get_row('supervisor', $where, 'name');  */

                    $nearByEmployee[$key]['supervisor_name'] = $row['supervisor_name']; 

                    $where = [];
                    $where['agency_code'] = $agency;
                    $nearByEmployee[$key]['agency'] = $this->Comman_model->get_row('agency', $where, 'agency_codename');  

                    $nearByEmployee[$key]['race'] = $row['race'];  
                    $nearByEmployee[$key]['language'] = $row['language'];  
                    $nearByEmployee[$key]['popnotesColor'] = trim($row['popnotes'])!=''?'btn-danger':'btn-primary';  
                    $nearByEmployee[$key]['popnotes'] = trim($row['popnotes'])!=''?$row['popnotes']:'No Message';  
                }
            }

            $data['limit'] = $limit;
            $data['filterBy'] = $filterBy;
            $data['gender'] = $gender;
            $data['DriveOnJob'] = $DriveOnJob;
            $data['location'] = $location;
            $data['start'] = $start;
            $data['fhca'] = $fhca;
            $data['zipCode']=$data['patientData']['ShipAddressPostalCode'];

            $nearByEmployee = $this->sortNestedArrayAssoc($nearByEmployee);

            $data['nearByEmployeeData'] = $nearByEmployee;
            $data['supervisor'] = $supervisor;
            $data['race'] = $race;
            $data['language'] = $language;
            $data['agency'] = $agency;
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', '', 'name', 'asc');
            $data['agencyData'] = $this->Comman_model->get_rows('agency');
            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location');

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/near-by-employee.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('patient/near-by-employee-new.php',$data);
            //$this->load->view('patient/near-by-employee.php',$data);
      } else {
          redirect();
      }
    }


    public function findAvailableApplicants() {
      if(isset($_SESSION['name']) && !empty($_GET['patient'])) {

          $where  = [];
          $where['patient_id'] = $_GET['patient'];            
          $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
          $origins = $data['patientData']['ShipAddressAddr2'].' '.$data['patientData']['ShipAddressCity'].' '.$data['patientData']['ShipAddressState'];

          $limit = 5; $start = 0;
          if(!empty($this->input->post('showLimit'))) {
            $limit = $this->input->post('showLimit');
          }

          if(!empty($this->input->post('start'))) {
            $start = $this->input->post('start');
          }

          $cond = '';

          if($this->input->post('gender')!='') {
            $gender = $this->input->post('gender');
            $cond .= " AND gender = $gender";
          }

          $query = "SELECT * FROM employee where hired=0 ".$cond." order by applicant_id desc limit ".$start.", ".$limit."";
          $applicantData  = get_data_other_db($query, 'result', 'hcp_application');
          $data['applicantData']      = $applicantData;
          
          $nearByApplicant = [];
          if(!empty($data['applicantData'])) {
            foreach ($data['applicantData'] as $key => $row) {

                $destinations = $row['EmployeeAddressAddr1'].' '.$row['EmployeeAddressCity'].' '.$row['EmployeeAddressState'];

                $ch = curl_init();
                $url = "https://maps.googleapis.com/maps/api/distancematrix/json";
                $options = array(
                    "origins" => $origins,
                    "destinations" => $destinations,
                    "units" => "imperial",
                    "language" => "en-GB",
                    "key" => 'AIzaSyB3iE3D6Mksh20jN9n1lYT9Aawul-q97m0'
                );

                $request = $url . "?" . http_build_query( $options );
                
                curl_setopt($ch, CURLOPT_URL, $request);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                $output = json_decode(curl_exec($ch));

                curl_close($ch);

                $status = $output->status;
  
                $cdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->value:0;
                $sdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->text:0;
  
                $nearByApplicant[$key]['applicant_id'] = $row['applicant_id'];  
                $nearByApplicant[$key]['name'] = $row['first_name'].' '.$row['last_name'];
                if($row['gender']=='0') {
                  $nearByApplicant[$key]['gender'] = 'Male';  
                }else if($row['gender']=='1') {
                  $nearByApplicant[$key]['gender'] = 'Female';
                } else {
                  $nearByApplicant[$key]['gender'] = '';
                }
                $nearByApplicant[$key]['address'] = $destinations;
                $nearByApplicant[$key]['cdistance'] = $cdistance;
                $nearByApplicant[$key]['sdistance'] = number_format(round(($cdistance/1609.34), 1), 2);
                $nearByApplicant[$key]['phone'] = $row['contact_number'];                
            }
          }

          $data['limit'] = $limit;
          $data['gender'] = $gender;
          $data['start'] = $start;
          $nearByApplicant = $this->sortNestedArrayAssoc($nearByApplicant);
          $data['nearByApplicantData'] = $nearByApplicant;
          $this->load->view('common/header.php');
          $this->load->view('common/sidebar.php');
          $this->load->view('patient/near-by-applicant.php',$data);
          $this->load->view('common/footer.php');
      } else {
          redirect();
      }
    }


    function sortNestedArrayAssoc($arr) {
      usort($arr, function($a,$b) { 
          return ($a['cdistance'] <= $b['cdistance']) ? -1 : 1;
      });
      return $arr;
    }


    function changeTerminationDate() {
      $reason = $this->input->post('reason');
      $terminationDate = $this->input->post('terminationDate');
      $patient_id = $this->input->post('patient_id');
      if(!empty($patient_id) && !empty($terminationDate) && $reason!='') {
        $where = [];
        $where['patient_id'] = $patient_id;

        $dataArray = [];
        $dataArray['termination_date'] = $terminationDate;
        $dataArray['termination_reason'] = $reason;
        $dataArray['termination_status'] = 1;

        $dataArray['termination_by_user_id'] = $this->session->userdata('id');
        $dataArray['termination_by_username'] = $this->session->userdata('name');

        $this->Comman_model->update('patient', $where, $dataArray);

        ############### USER ACTION TRACKING START ####################
        if($this->session->userdata('id')!=6) {
          $dataArray = [];
          $dataArray['user_id'] = $this->session->userdata('id');
          $dataArray['username'] = $this->session->userdata('name');
          $dataArray['user_action'] = $this->session->userdata('name'). ' user updated termination date '.$terminationDate.' with reason '.$reason.' for client id '.$patient_id.' at '. date('m/d/Y H:i:s');
          $this->Comman_model->insert('users_tracking', $dataArray);    
        }
        ############### USER ACTION TRACKING END ####################

        echo 1;

      } else {
        echo 0;
      }
    }


    function changeNewApproveHours() {
      $newApprovedHourDate = $this->input->post('newApprovedHourDate');
      $newApproveHours = $this->input->post('newApproveHours');
      $patient_id = $this->input->post('patient_id');
      if(!empty($patient_id) && !empty($newApproveHours) && !empty($newApprovedHourDate)) {
        $where = [];
        $where['patient_id'] = $patient_id;

        $dataArray = [];
        $dataArray['newHMKRHours'] = $newApproveHours;
        $dataArray['newApprovedHourDate'] = $newApprovedHourDate;
        $dataArray['newApprovedHourStatus'] = 1;
        $dataArray['newApprovedHourUserId'] = $this->session->userdata('id');
        $dataArray['newApprovedHourUsername'] = $this->session->userdata('name');
        $this->Comman_model->update('patient', $where, $dataArray);
        echo 1;

      } else {
        echo 0;
      }
    }


    public function client() {
        if(isset($_SESSION['name'])) {
            /********** Patient Inactive based on termination date start  *********/
            //$this->checkTerminationDate();
            /********** Patient Inactive based on termination date end  *********/

            $data = [];
            $FULLHOURS = '';
            $data['validateClient'] = 'validate';
            if(isset($_SESSION['client'])) {
                $data['validateClient'] = $_SESSION['client'];
            }

            $agency = $this->session->userdata('agency');

            if(!empty($_GET['patient'])) {
                $where  = [];
                $where['patient_id']    =   $_GET['patient'];
                $data['patientData']    =   $this->Comman_model->get_row('patient', $where);

                if(empty($data['patientData'])){
                    redirect('Admin/AddClient');
                }

                $data['validateClient'] = 'add';

                $where = [];
                $where['patient_id'] = $_GET['patient'];
                $patientService = $this->Comman_model->countrow('tblpatientservices', $where);
                if($patientService==0) {
                    $dataArray = [];
                    $dataArray['patient_id'] = $_GET['patient'];
                    $dataArray['Agency'] = $agency;
                    $this->Comman_model->insert('tblpatientservices', $dataArray);
                }


                $where  =   [];
                $where['agency_code'] =   $data['patientData']['Agency'];
                $data['agencyData'] = $this->Comman_model->get_row('agency', $where);
            }

            $where= [];
            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where);


            $where= [];
            $data['allAgencyData'] = $this->Comman_model->get_rows('agency', $where);

            $where  =   [];
            $where['Agency'] =   $agency;
            $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where, 'DistrictNumber', 'asc');

            $where= [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/client.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function getClientProfile() {
      $patient = $this->input->get('patient');
      $data['patient_image'] = base_url('assets2/texst.jpg');
      if(!empty($patient)) {
        $where  = [];
        $where['patient_id']    =   $patient;
        $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
        if(!empty($data['patientData']['image_path'])) {
          $data['patient_image'] = base_url('image/client_image/'.$data['patientData']['image_path']);
        }

        $data['validateClient'] = 'add';

        $where  =   [];
        $where['agency_code'] =   $data['patientData']['Agency'];
        $data['agencyData'] = $this->Comman_model->get_row('agency', $where);

        $where= [];
        $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where, '', '', '', '');

        $this->load->view('patient/profile.php', $data);
      }
    }

    public function getClientServices() {
      $patient = $this->input->get('patient');
      if(!empty($patient)) {
        $where  = [];
        $where['patient_id']    =   $patient;
        $patientData    =   $this->Comman_model->get_row('patient', $where);
        $data['patientData']    =   $patientData;

        $data['shift2option'] = '';
        $data['shift2optiondisplay'] = 'none';
        if($patientData['mon_limit2']>0 || $patientData['tue_limit2']>0 || $patientData['wed_limit2']>0 || $patientData['thu_limit2']>0 || $patientData['fri_limit2']>0 || $patientData['sat_limit2']>0 || $patientData['sun_limit2']>0) {
            $data['shift2option'] = 'checked';
            $data['shift2optiondisplay'] = 'inline-table';
        }

        $data['fillinoption'] = '';
        $data['fillinoptiondisplay'] = 'none';
        if($patientData['mon_limit1']>0 || $patientData['tue_limit1']>0 || $patientData['wed_limit1']>0 || $patientData['thu_limit1']>0 || $patientData['fri_limit1']>0 || $patientData['sat_limit1']>0 || $patientData['sun_limit1']>0) {
            $data['fillinoption'] = 'checked';
            $data['fillinoptiondisplay'] = 'inline-table';
        }

        $agency = $this->session->userdata('agency');

        $where  =   [];
        $where['Agency'] = $agency;
        $where['firstname!='] = '';
        $where['hcpadmin'] = 0;
        $where['Status'] =   1;
        $data['allEmployeeData'] = $this->Comman_model->get_rows('employee', $where, 'name', 'asc');

        //print_r($data['allEmployeeData']);die;

        $where  =   [];
        $where['Agency'] =   $agency;
        $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where, 'DistrictNumber', 'asc');

        if(!empty($data['patientData']['DistrictID_Ref'])) {
          $where = [];
          $where['DistrictID_Ref'] = $data['patientData']['DistrictID_Ref'];
          $where['Agency'] = $_SESSION['agency'];  
          $data['districtDataMco'] = $this->Comman_model->get_rows('tbldistrictmanagers', $where);

          $where = [];
          $where['DistrictID'] = $data['patientData']['DistrictID_Ref'];
          $where['Agency'] = $_SESSION['agency'];  
          $districtRow = $this->Comman_model->get_row('tbldistricts', $where);
          $data['FULLHOURS'] = $districtRow['full_hours'];
        }

        //$where = [];
        //$where['pt.patient_id'] = $patient;
        $month = date('n')-1;
        $year = date('Y');

        /*if($agency==1 || $agency==3){
          $data['billedHours'] = $this->Comman_model->getBilledtHours($where, $month);
        }

        if($agency==2 || $agency==4){
          //$data['billedHours'] = $this->Comman_model->getBilledtHoursByOther($where, $month);
          $data['billedHours'] = $this->getBilledtHoursFromEmployeeClock($patient, $month);
        }*/

        $where = [];
        $where['patient_id'] = $patient;
        $where['month'] = $month;
        $where['year'] = $year;
        $billedHoursData = $this->Comman_model->get_row('billed_hours_old', $where);
        $data['billedHours'] = $billedHoursData['total_hrs'];


        $data['month'] = $month;
        $data['year'] = $year;

        $where = [];
        $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

        $where= [];
        $where['is_supervisor'] = 1;
        $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');

        $where= [];
        $where['is_supervisor'] = 1;
        $data['supervisorData2'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');


        $where  = [];
        $where['ea.patient_id']    =   $patient;
        $like = [];
        $not_like = [];
        $not_like['ea.pin'] = '+';   
        $data['assignEmployeeData']    =   $this->client->get_assigned_employee($where, $like, $not_like);

        $this->load->view('patient/services.php', $data);
      }
    }


    public function getClientBilling() {
      $patient = $this->input->get('patient');
      if(!empty($patient)) {
        $where  = [];
        $where['patient_id']    =   $patient;
        $patientData            =   $this->Comman_model->get_row('patient', $where);
        $data['patientData']    =   $patientData;

        $where = [];
        $where['zipcode'] = $patientData['ShipAddressPostalCode'];
        $psaData  =   $this->Comman_model->get_row('zipcode_psa', $where);
        $data['psaData']    =   $psaData;

        $agency = $this->session->userdata('agency');

        $where  =   [];
        $where['Agency'] =   $agency;
        $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where, 'DistrictName', 'asc');


        $where  =   [];
        $where['Agency'] =   $agency;
        $where['DistrictID'] =   $patientData['DistrictID_Ref'];
        $data['districtRowData'] = $this->Comman_model->get_row('tbldistricts', $where);

        $where  =   [];
        $where['agency_code'] =   $agency;
        $agencyData = $this->Comman_model->get_row('agency', $where);
        $data['agencyData'] = $agencyData;

        if($agency==1) {
          $psa = '201';
          $impactId = '452238145201';
        } 
        if($agency==3) {
          $psa = '201';
          $impactId = '731709187201';  
        }
        if($agency==2 || $agency==4) {
          $psa = $psaData['psa'];
          $impactId =  $agencyData['agency_tax'].$psaData['psa'];
        }

        $data['psa'] = $psa;
        $data['impactId'] = $impactId;

        $where  =   [];
        $where['dt.patient_id'] =   $patient;
        $where['td.Agency'] =   $agency;
        $data['DistrictID_temp_Data'] = $this->client->getPreviousDistricts($where);

        if(!empty($data['patientData']['DistrictID_Ref'])) {
          $where = [];
          $where['DistrictID_Ref'] = $data['patientData']['DistrictID_Ref'];
          $where['Agency'] = $agency;  
          $data['districtDataMco'] = $this->Comman_model->get_rows('tbldistrictmanagers', $where);

          $where = [];
          $where['DistrictID'] = $data['patientData']['DistrictID_Ref'];
          $where['Agency'] = $agency;  
          $districtRow = $this->Comman_model->get_row('tbldistricts', $where);
          $data['FULLHOURS'] = $districtRow['full_hours'];
        }

        $this->load->view('patient/billing.php', $data);
      }
    }

    public function patientAuth($patient) {
      if(isset($_SESSION['name']) && !empty($patient)) {
        $agency_code = $this->session->userdata('agency');

        $where = [];
        $where['patient_id'] = $patient;
        $data['patientData'] = $this->Comman_model->get_row('patient', $where);

        if ($sort == null) {
          $sort = 2;
        }

        if ($desc == null) {
          $desc = "asc"; 
        }
      
        if ($desc == "asc") {
          $desc = "desc";
        } else {  
          $desc = "asc";  
        }
        
        if ($desc2 != null) {
          $desc  = $_GET['desc2'];
        }     
      
        if ($sort == 0) {
          $sortorder = "patient_auth_history_id";
        }
        
        if ($sort == 1) {
          $sortorder = "validfrom";
        }
        
        if ($sort == 2) {
          $sortorder = "validto";
        } 

        if ($sort == 3) {
          $sortorder = "status";
        }

        $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM patient_auth_history WHERE patient_id = '$patient' ORDER BY ".$sortorder." ".$desc."";

        $data['patientAuth'] = $this->Comman_model->getCustomQueryData($MySQL);

        if(!empty($_GET['recno'])) {
          $recno = $_GET['recno'];
          $data['recno'] = $recno;
          $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM patient_auth_history WHERE patient_auth_history_id = '$recno'";
          $data['patientAuthData'] = $this->Comman_model->getCustomQueryData($MySQL, 'row');          
        }


        $data['patient'] = $patient;

        /*
        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('patient/patient-auth.php',$data);
        $this->load->view('common/footer.php');
        */

        $this->load->view('common/header-new.php');
        $this->load->view('common/sidebar-new.php');
        $this->load->view('patient/patient-auth-new.php',$data);
      } else {
        redirect();
      }    
    }


    public function authDelete() {
      $patient = $this->input->get('patient');
      $delNo = $this->input->get('delno');

      $where = [];
      $where['patient_auth_history_id'] = $delNo;
      $this->Comman_model->delete_row('patient_auth_history', $where);

      $postcomment = "Delete Client PA with Patient No.".$patient." record:".$delNo; 
      $postcategory = "PA Delete";
      $this->postlog($postcomment, $postcategory); 
      $this->session->set_flashdata('message','Record has been deleted successfully.');
      redirect($this->agent->referrer());
    }

    public function updatePatientAuth() {

      $validfrom = $this->input->post('validFrom');
      $validto = $this->input->post('validTo');
      $authorization = $this->input->post('authorization');
      $recno = $this->input->post('recno');
      $patient = $this->input->post('patient');
      $action = $this->input->post('submit');

      if(!empty($action) && !empty($validfrom) && !empty($validto)) {
        $dataArray = [];
        $dataArray['validfrom'] = $validfrom;
        $dataArray['validto'] = $validto;
        $dataArray['authorization'] = $authorization;

        if($action=='update' && !empty($recno)) {
          $where = [];
          $where['patient_auth_history_id'] = $recno;
          $this->Comman_model->update('patient_auth_history', $where, $dataArray);
          $notesid = $recno;
          $postcomment = "Update Client Visits with Patient No.".$recno; 
          $postcategory = "NotesVisit";
          $this->postlog($postcomment, $postcategory);  
          $this->session->set_flashdata('message','Record has been updated successfully.');
        }

        if($action=='add') {
          $dataArray['patient_id'] = $patient;
          $recno = $this->Comman_model->insert('patient_auth_history', $dataArray);
          $notesid = $recno;
          $postcomment = "Added Client Visits with Patient No.".$recno; 
          $postcategory = "NotesVisit";
          $this->postlog($postcomment, $postcategory);  
          $this->session->set_flashdata('message','Record has been added successfully.');
        }
        
        $time1 = strtotime($d1);
        $time2 = strtotime($d2);
      } else {
        $this->session->set_flashdata('error_message', 'Please enter the deatils first.');
      }
      redirect('patient/patientAuth/'.$patient);
      /*$diff = $time2-$time1;
      $plus = abs($diff / 60 / 60 /24);*/
    }

    public function postlog($postcomment='', $postcategory='') {
        $postuser = $this->session->userdata('name');
        $postdate = date("Y-m-d H:i:s");
        $postagency = $this->session->userdata('agency');
        $postmode = 0;
        $notesid = 0;
        $postcategory = $postcategory;

        $dataArray = [];
        $dataArray['postdate'] = $postdate;
        $dataArray['postuser'] = $postuser;
        $dataArray['postagency'] = $postagency;
        $dataArray['postperiod'] = $postmode;
        $dataArray['postcomment'] = $postcomment;
        $dataArray['postcategory'] = $postcategory;
        $dataArray['notesid'] = $notesid;

        $postlog_id = $this->Comman_model->insert('postlog', $dataArray);

    }


    public function overUnderHour() {
      if(isset($_SESSION['name'])) {

        $month = $this->input->post('month');
        $year = $this->input->post('year');
        $location = $this->input->post('location');
        $supervisor_id = $this->input->post('supervisor');
        $billedType = $this->input->post('billedType');

        $where = [];
        if(!empty($month)) {
          $where['month'] = $month;  
        } else {
          $month = date('n')-1;
          $where['month'] = $month;
        }
        if(!empty($year)) {
          $where['year'] = $year;
        }
        if(!empty($location)) {
          $where['location_id'] = $location;
        }
        if(!empty($supervisor_id)) {
          $where['supervisor_id'] = $supervisor_id;
        }
        if(!empty($billedType)) {
          if($billedType=='over') {
            $where['under_over_hours <'] = 0;  
          }
          if($billedType=='under') {
            $where['under_over_hours >='] = 0;  
          }
        }

        $where['Agency'] = $this->session->userdata('agency');

        $data['billedHourData'] = $this->Comman_model->get_rows('billed_hours_old', $where);

        $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location','','agency_location_name', 'asc');

        /*$cond ='';
        if ($supervisor_id != '' ) {
            $supervisor_id = base64_decode($supervisor_id);
            $cond = " supervisor_id = '$supervisor_id' AND ";
        }                
        if(!empty($location)) {
            $location = base64_decode($location);
            $cond .= " agency_location = '$location' AND "; 

            $where = [];
            $where['su.firstname!='] ='';
            $where['su.agency_location'] = $location;
            $data['allSupervisiors'] = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');
        }*/

        $where = [];
        $where['is_supervisor'] = 1;
        $where['lastname!='] = '';
        $data['allSupervisiors'] = $this->Comman_model->get_rows('supervisor',$where,'lastname','asc');

        $data['month'] = $month;
        $data['year'] = $year;
        $data['location'] = $location;
        $data['supervisor'] = $supervisor_id;
        $data['billedType'] = $billedType;

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('patient/overUnderHour.php',$data);
        $this->load->view('common/footer.php');
      } else {
        redirect();
      }
    }

    public function overUnderHour2() {
      if(isset($_SESSION['name'])) {

        $location = $this->input->post('location');
        $supervisor_id = $this->input->post('supervisor');
        $billedType = $this->input->post('billedType');
        $fhca = $this->input->post('fhca');
        $startdate = $this->input->post('startdate');
        $search = $this->input->post('search'); 
        $action = $this->input->post('action'); 

        $cond = '';

        if(!empty($startdate)) {
          $cond .= " bho.start_date = '".$startdate."'";
        }

        if(!empty($location)) {
          $cond .= " AND pt.agency_location = '".$location."'";
        }
        if(!empty($supervisor_id)) {
          $cond .= " AND pt.supervisor_id = '".$supervisor_id."'";
        }
        if($fhca!='' && $fhca!='2') {
            $cond .= " AND pt.FHCA = '".$fhca."'";
        }

        if(!empty($billedType)) {
          if($billedType=='over') {
            $cond .= " HAVING under_over_hours < 0";
          }
          if($billedType=='under') {
            $cond .= " HAVING under_over_hours > 0";
          }
        }

        $sql = "SELECT bho.*, pt.supervisor_id, pt.DistrictID_Ref, pt.agency_location, pt.Agency as pt_agency, pt.supervisor_id, (bho.total_allow - bho.total_left) as under_over_hours FROM employee_2finalsheet as bho INNER JOIN patient as pt ON bho.patient_id = pt.patient_id";
        if(!empty($cond)) {
            $sql .= " WHERE $cond";
        }

        $data['billedHourData'] = [];
        if($search=='search') {
            $billedHourData = $this->Comman_model->getCustomQueryData($sql);
            $data['billedHourData'] = $billedHourData;
        }

        if($action=='KPI' && !empty($startdate)) {
            $sql = "SELECT name as supervisor_name, supervisor_id, Agency, agency_location FROM supervisor WHERE is_supervisor = 1 AND supervisor_id!=0";
            $supData = $this->Comman_model->getCustomQueryData($sql);
            foreach ($supData as $key => $supRow) {
                $sql = "SELECT bho.*, pt.IsActive, pt.supervisor_id, pt.DistrictID_Ref, pt.agency_location, pt.Agency as pt_agency, pt.supervisor_id, (bho.total_allow - bho.total_left) as under_over_hours FROM employee_2finalsheet as bho INNER JOIN patient as pt ON bho.patient_id = pt.patient_id WHERE pt.supervisor_id = '".$supRow['supervisor_id']."' AND pt.IsActive = 1 AND bho.start_date = '".$startdate."'";

                $billedHourData1 = $this->Comman_model->getCustomQueryData($sql);                
                $positive = $negative = 0;
                $active_clients = 0;
                foreach ($billedHourData1 as $key => $row) {                    
                    if($row['under_over_hours']>0) {
                        $positive = $positive + $row['under_over_hours'];
                    } 
                    if($row['under_over_hours']<0) {
                        $negative = $negative + $row['under_over_hours'];
                    }
                    $active_clients++;
                }

                if($positive==0 && $negative==0) {
                    continue;
                }

                $sql = "SELECT agency_location_name as location FROM agency_location where agency_location_code = '".$supRow['agency_location']."'";
                $locRow = get_custom_query_data($sql, 'row');

                $sql = "SELECT agency_codename FROM agency where agency_code = '".$supRow['Agency']."'";
                $agRow = get_custom_query_data($sql, 'row');

                $dataArray = [];
                $dataArray['start_date'] = $startdate;
                $dataArray['supervisor'] = $supRow['supervisor_name'];
                $dataArray['supervisor_id'] = $supRow['supervisor_id'];
                $dataArray['agency'] = $agRow['agency_codename'];
                $dataArray['agency_id'] = $supRow['Agency'];
                $dataArray['location'] = $locRow['location'];
                $dataArray['location_id'] = $supRow['agency_location'];
                $dataArray['active_clients'] = $active_clients;
                $dataArray['over'] = quarter($negative);
                $dataArray['under'] = quarter($positive);
                $this->Comman_model->insert('clients_over_under_bw', $dataArray);
                $this->app->message('KPI has been generated successfully.', 'success');
            }
        }        
        $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location','','agency_location_name', 'asc');

        $where = [];
        $where['is_supervisor'] = 1;
        $where['lastname!='] = '';
        $data['allSupervisiors'] = $this->Comman_model->get_rows('supervisor',$where,'lastname','asc');

        $data['location'] = $location;
        $data['supervisor'] = $supervisor_id;
        $data['billedType'] = $billedType;
        $data['fhca'] = $fhca;
        $data['startdate'] = $startdate;

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('patient/overUnderHour2.php',$data);
        $this->load->view('common/footer.php');
      } else {
        redirect();
      }
    }


    public function facesheetOld($patient_id) {
      if(isset($_SESSION['name'])) {  

        $where = [];
        $where['patient_id'] = $patient_id;
        $patientData = $this->Comman_model->get_row('patient', $where);

        $Agency = $patientData['Agency'];
        if ($Agency == 1) {
        $AgencyName = 'HM';
        }
        if ($Agency == 2) {
        $AgencyName = 'SC';
        }
        if ($Agency == 3) {
        $AgencyName = 'CG';
        }
        if ($Agency == 4) {
        $AgencyName = 'RF';
        }
        $AgencyName = 'hcp_pdf_files/'.$AgencyName; 
        //echo "Filename".$dirname;
        $dirname = $AgencyName."/".$patientData['lastname'].'_'.$patientData['firstname'].'_'.$patientData['patient_id'];

        $data['url'] = "http://gohcp.dyndns.org/Dropbox/".$dirname;

        //$data['url'] = "/media/root/datafiles/Dropbox/".$dirname;

        $data['patient_id'] = $patient_id;
        $this->load->view('patient/facesheet.php',$data);
      } else {
        redirect();
      }
    }


    public function facesheet($patient_id) {
      if(isset($_SESSION['name'])) {  

        $where = [];
        $where['patient_id'] = $patient_id;
        $patientData = $this->Comman_model->get_row('patient', $where);

        $Agency = $patientData['Agency'];
        if ($Agency == 1) {
        $AgencyName = 'HM';
        }
        if ($Agency == 2) {
        $AgencyName = 'SC';
        }
        if ($Agency == 3) {
        $AgencyName = 'CG';
        }
        if ($Agency == 4) {
        $AgencyName = 'RF';
        }
        $AgencyName = 'hcp_pdf_files/'.$AgencyName; 
        //echo "Filename".$dirname;
        $dirname = $AgencyName."/".$patientData['lastname'].'_'.$patientData['firstname'].'_'.$patientData['patient_id'];

        //$data['url'] = "http://gohcp.dyndns.org/Dropbox/".$dirname;
        $data['url'] = "http://sms.1017.solutions/Dropbox/".$dirname;

        //$data['url'] = "/media/root/datafiles/Dropbox/".$dirname;

        $data['patient_id'] = $patient_id;
        //$this->load->view('patient/facesheet2.php',$data);
        $this->load->view('patient/facesheet.php',$data);
      } else {
        redirect();
      }
    }

    public function uploadOld() {

      $upload = 'err'; 
      if(!empty($_FILES['facesheet'])) {
        // File upload configuration 
        $_FILES['file'] = $_FILES['facesheet'];
        $upload = $this->uploadClientFile($_POST['patient_id']);
        //$upload = 'ok'; 
      } 
      echo $upload;
    }

    public function upload() {

      $upload = 'err'; 
      if(!empty($_FILES['facesheet'])) {
        // File upload configuration 
        $_FILES['file'] = $_FILES['facesheet'];
        $upload = $this->uploadClientFile2($_POST['patient_id']);
        //$upload = 'ok'; 
      } 
      echo $upload;
    }

    public function uploadClientFile($patient_id) {
        $Agency = $this->session->userdata('agency');
        if ($Agency == 1) {
            $AgencyName = 'HM';
        }
        if ($Agency == 2) {
            $AgencyName = 'SC';
        }
        if ($Agency == 3) {
            $AgencyName = 'CG';
        }
        if ($Agency == 4) {
            $AgencyName = 'RF';
        }
        $msg = '';
        $AgencyName = 'hcp_pdf_files/'.$AgencyName;
        $allowedExts = array("pdf","PDF");
        $temp = explode(".", $_FILES["file"]["name"]);
        $extension = end($temp);
        $ext =  explode("/",$_FILES["file"]["type"]);
        $recno = $patient_id;
        $pictype = 'doc_';
        $elx = $_FILES["file"]["type"];
        $query = "SELECT * FROM patient WHERE patient_id = '$recno' ";
        $row = $this->Comman_model->getCustomQueryData($query, 'row');
        $lastname = str_replace("'","",$row['lastname']);
        $firstname = str_replace("'","",$row['firstname']);
        $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$recno;

        //$dirname = "/media/root/datafiles/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$recno;

        if (!file_exists($dirname)) {
          mkdir($dirname, 0777, true);
        } 

        $exttype = 'PDF';
        $timestamp = date("Y-m-d H:i:s");
        $xfile = '';

        $dataArray = [];
        $dataArray['patient_image_id'] = NULL;
        $dataArray['file_name'] = $xfile;
        $dataArray['type'] = $exttype;
        $dataArray['timestamp'] = $timestamp;
        $dataArray['uploaded_by'] = $this->session->userdata('name');
        $idfile = $this->Comman_model->insert('patient_image', $dataArray);

        $idfile2 = date("YmdH:i:s");
        $xfile = $pictype.$idfile2;
        $xfile = $_FILES["file"]["name"];   

        $where = [];
        $where['patient_image_id'] = $idfile;

        $dataArray = [];
        $dataArray['file_name'] = $xfile;

        $this->Comman_model->update('patient_image', $where, $dataArray);

        if ((($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "image/jpeg")
        || ($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "application/pdf"))
        && ($_FILES["file"]["size"] < 200000000)
        && in_array($extension, $allowedExts)) {

            if ($_FILES["file"]["error"] > 0) {
                $msg = "Return Code: " . $_FILES["file"]["error"] . "<br>";
            } else {
                $msg = "Upload: " . $_FILES["file"]["name"] . "<br>";
                $msg .= "Type: " . $_FILES["file"]["type"] . "<br>";
                $msg .= "Size: " . ($_FILES["file"]["size"] / 1024) . " kB<br>";
                $msg .= "Temp file: " . $_FILES["file"]["tmp_name"] . "<br>";
                if (file_exists("uploads/".$AgencyName.'/'. $_FILES["file"]["name"])) {
                    $msg = $_FILES["file"]["name"] . " already exists. ";
                } else {
                    move_uploaded_file($_FILES["file"]["tmp_name"],$dirname.'/'. $xfile);
                    //$msg = "Stored in: " .$dirname.'/'. $_FILES["file"]["name"];
                    $msg = "ok";
                }
            }

        } else {
            $msg = "Invalid file";
        }

        return $msg;
    }

    public function uploadClientFile2($patient_id) {
        $Agency = $this->session->userdata('agency');
        if ($Agency == 1) {
            $AgencyName = 'HM';
        }
        if ($Agency == 2) {
            $AgencyName = 'SC';
        }
        if ($Agency == 3) {
            $AgencyName = 'CG';
        }
        if ($Agency == 4) {
            $AgencyName = 'RF';
        }
        $msg = '';
        $AgencyName = 'hcp_pdf_files/'.$AgencyName;
        $allowedExts = array("pdf","PDF");
        $temp = explode(".", $_FILES["file"]["name"]);
        $extension = end($temp);
        $ext =  explode("/",$_FILES["file"]["type"]);
        $recno = $patient_id;
        $pictype = 'doc_';
        $elx = $_FILES["file"]["type"];
        $query = "SELECT * FROM patient WHERE patient_id = '$recno' ";
        $row = $this->Comman_model->getCustomQueryData($query, 'row');
        $lastname = str_replace("'","",$row['lastname']);
        $firstname = str_replace("'","",$row['firstname']);
        $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$recno;

        /*
        if (!file_exists($dirname)) {
            mkdir($dirname, 0777, true);
        } 
        */

        if ((($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "image/jpeg")
        || ($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "application/pdf"))
        && ($_FILES["file"]["size"] < 200000000)
        && in_array($extension, $allowedExts)) {

            if ($_FILES["file"]["error"] > 0) {
                $msg = "Return Code: " . $_FILES["file"]["error"] . "<br>";
            } else {
                /*
                $msg = "Upload: " . $_FILES["file"]["name"] . "<br>";
                $msg .= "Type: " . $_FILES["file"]["type"] . "<br>";
                $msg .= "Size: " . ($_FILES["file"]["size"] / 1024) . " kB<br>";
                $msg .= "Temp file: " . $_FILES["file"]["tmp_name"] . "<br>";
                */
                $folder = 'assets/files/drive';
                $config['upload_path'] = './'."$folder".'/';
                $config['allowed_types'] = '*';
                $this->load->library('upload', $config);                    
                if($this->upload->do_upload('file')) {
                    $file_name =$this->upload->data()['file_name'] ;
                    $target_url = "http://sms.1017.solutions/hcpservices/index.php";
                    $filepath = FCPATH.$folder.'/'.$file_name;

                    $action = 'facesheet';
                    $msg = $this->fileUploadToSmsServer($target_url, $filepath, $file_name, $dirname, $action);

                    if($msg=='ok') { // Successfully upload file in Dropbox
                        $exttype = 'PDF';
                        $timestamp = date("Y-m-d H:i:s");
                        $xfile = '';

                        $dataArray = [];
                        $dataArray['patient_image_id'] = NULL;
                        $dataArray['file_name'] = $xfile;
                        $dataArray['type'] = $exttype;
                        $dataArray['timestamp'] = $timestamp;
                        $dataArray['uploaded_by'] = $this->session->userdata('name');
                        $idfile = $this->Comman_model->insert('patient_image', $dataArray);

                        $idfile2 = date("YmdH:i:s");
                        $xfile = $pictype.$idfile2;
                        $xfile = $_FILES["file"]["name"];   

                        $where = [];
                        $where['patient_image_id'] = $idfile;

                        $dataArray = [];
                        $dataArray['file_name'] = $xfile;

                        $this->Comman_model->update('patient_image', $where, $dataArray);
                    }
                    unlink($filepath);
                }
            }
        } else {
            $msg = "Invalid file";            
        }
        return $msg;
    }

    function fileUploadToSmsServer($target_url, $filepath, $file_name, $dirname, $action) {

        //$filepath = FCPATH.$folder.'/'.$file_name;
        $curl = curl_init();
        $params = array(
            "File" => new \CurlFile($filepath, 'text/txt', $file_name),
            "Filename" => $file_name,
            "action" => $action,
            "dirname" => $dirname
        );

        curl_setopt_array($curl, [
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: multipart/form-data"
            ],
            CURLOPT_POSTFIELDS => $params,
            CURLOPT_URL => $target_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
        ]);

        $response = curl_exec($curl);
        $error = curl_error($curl);
        curl_close($curl);
        if ($error) {
            return "cURL Error #:" . $error;
        } else {
            return $response;
        }
    }

    public function changeStatusReport($patient_id) {
      if(isset($_SESSION['name']) && !empty($patient_id)) {

          $dateFrom = $this->input->post('dateFrom');
          $dateTo = $this->input->post('dateTo');
          $where = [];
          if(!empty($dateFrom) && !empty($dateTo)) {

            $dateFrom = date('Y-m-d', strtotime($dateFrom));
            $dateTo = date('Y-m-d', strtotime($dateTo));

            $where['change_date >='] = $dateFrom;  
            $where['change_date <='] = $dateTo;  
          }
          if(!empty($dateFrom) && empty($dateTo)) {
            $dateFrom = date('Y-m-d', strtotime($dateFrom));
            $where['change_date'] = $dateFrom;  
          }

          $where['patient_id'] = $patient_id;
          $data['changeStatusData'] = $this->Comman_model->get_rows('changeofstatus', $where, 'id', 'desc');

          /*
          $this->load->view('common/header.php');
          $this->load->view('common/sidebar.php');
          $this->load->view('patient/change-status.php',$data);
          $this->load->view('common/footer.php');
          */

          $this->load->view('common/header-new.php');
          $this->load->view('common/sidebar-new.php');
          $this->load->view('patient/change-status-new.php',$data);
      } else {
        redirect('');
      }
    }  

    public function delete_status_history($delete_id='') {
        if(!empty($delete_id)) {
            $where  =   [];
            $where['id']  =   $delete_id;
            $data = $this->Comman_model->delete_row('changeofstatus', $where);              
            if($data) {
                $this->session->set_flashdata('message', 'record has been deleted successfully.');
            } else {
                $this->session->set_flashdata('error_message', 'Oops something went wrong.');
            }
        }
        redirect($this->agent->referrer());
    }

    public function setNextVisitdate() {
      $visit_done_date = $this->input->post('visit_done_date');
      $patient_id = $this->input->post('patient_id');
      if(!empty($patient_id) && !empty($visit_done_date)) {
        $where = [];
        $where['patient_id'] = $patient_id;
        $patientData = $this->Comman_model->get_row('patient', $where);
        $days = 180;
        if($patientData['FHCA']==1) {
          $days = 90;  
        }
        $next = strtotime(date("m/d/Y", strtotime($visit_done_date)) . " + ".$days."days");
        $nextvisit = date("m/d/Y",$next); 
        echo $nextvisit; 
      }
    }

    public function newStatusReport() {
        if(isset($_SESSION['name'])) {

            if(!empty($_GET['from_date'])) {
                $from_date = $_GET['from_date'];
            } else {
                $from_date = date('Y-m-d');
            }

            if(!empty($_GET['to_date'])) {
                $to_date = $_GET['to_date'];
            } else {
                $to_date = date('Y-m-d');
            }

            if(!empty($_GET['day_diff'])) {
                $day_diff = $_GET['day_diff'];
            } else {
                $day_diff = 'All';
            }

            $sql = "SELECT * from client_new_status_tracking INNER JOIN patient ON client_new_status_tracking.patient_id = patient.patient_id WHERE client_new_status_tracking.status = 3 AND transaction_date >= '$from_date' AND transaction_date <= '$to_date'  order by client_new_status_tracking.id desc";

            $newStatusData = $this->Comman_model->getCustomQueryData($sql);

            $dataArray = [];
            foreach ($newStatusData as $key => $row) {
                $diff = '';
                $where = [];
                $where['patient_id'] = $row['patient_id'];
                $where['status'] = 1;
                $statusData = $this->Comman_model->get_row('client_new_status_tracking', $where);

                $dataArray1 = [];
                $dataArray1['status'] = 'New Client';
                $dataArray1['dayDiff'] = 'NA';

                if(!empty($statusData)) {
                    $date1 = date_create($row['transaction_date']);
                    $date2 = date_create($statusData['transaction_date']);
                    $diff  = date_diff($date1,$date2);

                    $ndays = $diff->format("%a");

                    $days = $diff->format("%R%a days");

                    $dataArray1['status'] = 'Active';
                    $dataArray1['dayDiff'] = $days;
                }

                $where = [];
                $where['patient_id'] = $row['patient_id'];
                $patientData = $this->Comman_model->get_row('patient', $where);

                $where = [];
                $where['supervisor_id'] = $patientData['supervisor_id'];
                $supervisorData = $this->Comman_model->get_row('supervisor', $where);

                $dataArray1['agency'] = $row['agency'];
                $dataArray1['client'] = $patientData['name'];
                $dataArray1['supervisor'] = $supervisorData['name'];
                $dataArray1['location'] = $statusData['location'];
                $dataArray1['add_date'] = $row['transaction_date'];
                $dataArray1['change_date'] = $statusData['transaction_date'];

                if($day_diff=='15 Days' && $ndays>=15) {
                    array_push($dataArray, $dataArray1);
                }

                if($day_diff=='All') {
                    array_push($dataArray, $dataArray1);
                }
            }

            $data = [];
            $data['from_date'] = $from_date;
            $data['to_date'] = $to_date;
            $data['day_diff'] = $day_diff;
            $data['newStatusData'] = $dataArray;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('patient/new-status-report.php',$data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect('');
        }
    }

    public function updatePsa() {
      /*$where =[];
      $where['Agency'] = 4;
      $patientData = $this->Comman_model->get_rows('patient', $where);
      $x=0;
      foreach ($patientData as $key => $row) {
        $where = [];
        $where['zipcode'] = $row['ShipAddressPostalCode'];
        $psaData  =   $this->Comman_model->get_row('zipcode_psa', $where);

        $agency = $row['Agency'];

        $where  =   [];
        $where['agency_code'] =   $agency;
        $agencyData = $this->Comman_model->get_row('agency', $where);

        $psa = $psaData['psa'];
        $impactId =  'G2'.$agencyData['agency_tax'].$psaData['psa'];

        $dataArray = [];
        $dataArray['psa'] = $psa;
        $dataArray['impactId'] = $impactId;

        $where = [];
        $where['patient_id'] = $row['patient_id'];
        $this->Comman_model->update('patient', $where, $dataArray);
        $x++;
      }
      echo $x. 'records has been updated';*/
    }

    public function updateTblDIstricts() {
      /*$where =[];
      $agencyData = $this->Comman_model->get_rows('agency', $where);
      $x=0;
      foreach ($agencyData as $key => $row) {
        $agency_npi = $row['agency_npi'];

        $where  =   [];
        $where['billing_id'] =   $agency_npi;

        $dataArray = [];
        if($agency_npi=='1235471566') {
          $dataArray['TIN'] = '452238145';
          $dataArray['Impactid'] = 'G2452238145201';
        }
        if($agency_npi=='1942646112') {
          $dataArray['TIN'] = '731709187';
          $dataArray['Impactid'] = 'G2731709187201';
        }
        if($agency_npi=='1225370554') {
          $dataArray['TIN'] = '870758683';
          $dataArray['Impactid'] = 'G2870758683912';
        }
        //$dataArray['Biller_Company'] = $row['agency_name'];
        $this->Comman_model->update('tbldistricts', $where, $dataArray);

        $x++;
      }
      echo $x. 'records has been updated';*/
    }

    public function getRefreshEmployee() {
      $postData   =   $this->input->post();    
      
      if($postData['status']=='true') { }

      $agency = $this->session->userdata('agency');

      $where  =   [];
      $where['Agency'] = $agency;
      $where['firstname!='] =   '';
      $where['Status'] =   1;
      if($postData['status']=='false') {
        $where['hcpadmin'] = 1;
      }
      $allEmployeeData = $this->Comman_model->get_rows('employee', $where, 'name', 'asc');
      $data = '<option value="">Select</option>';
      if(!empty($allEmployeeData)) {
        foreach ($allEmployeeData as $key => $row) {
          $data .= '<option value="'.$row['employee_id'].'">'.$row['lastname'].',  '.$row['firstname'].'</option>';
        }
      }
      print_r($data);
    }

    public function checkDate() {

      ini_set('display_errors', 1);
      ini_set('display_startup_errors', 1);
      error_reporting(E_ALL);


      $format = 'm-d-Y';
      $date = '12-24-2021';

      if(date($format, strtotime($date)) == '12-31-1969') {
          echo $date;
      } else {
          echo date($format, strtotime($date));
      }


      //echo date($format, strtotime($date));

        /*$objDate = DateTime::createFromFormat($format, $date);
        if ($objDate) {
            echo $objDate->format($format);
        } else {
            echo $date;    
        }*/
    }

    function getEmployeeData() {
        $search = $_REQUEST['search'];
        $agency = $this->session->userdata('agency');
        $sql = "select * from employee where name like '%".$search."%' and Status = 1 and firstname!='' and agency = '".$agency."' order by employee_id desc";
        $res    =   get_custom_query_data($sql);
        $data = [];
        $x=0;
        if(!empty($res)) {            
            foreach ($res as $key => $row) {
                $data[$x]['id'] = $row['employee_id'];
                $data[$x]['text'] = $row['name'];
                $x++;
            }
        } else {
            $data[$x] = 'No results found.';
        }

        if(!empty($search)) {
            print_r(json_encode($data));
        }
    }

    function getPatientData() {
        $search = $_REQUEST['search'];
        $agency = $this->session->userdata('agency');
        //$sql = "select * from patient where name like '%".$search."%' and IsActive = 1 and firstname!='' and agency = '".$agency."' order by patient_id desc";
        $sql = "select * from patient where name like '%".$search."%' and firstname!='' and agency = '".$agency."' order by patient_id desc";
        $res    =   get_custom_query_data($sql);
        $data = [];
        $x=0;
        if(!empty($res)) {            
            foreach ($res as $key => $row) {
                $data[$x]['id'] = $row['patient_id'];
                $data[$x]['text'] = $row['name'];
                $x++;
            }
        } else {
            $data[$x] = 'No results found.';
        }

        if(!empty($search)) {
            print_r(json_encode($data));
        }
    }
} 