<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Setting extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model','comman');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->helper('file');
        $this->load->library('user_agent');
    }

    
    public function index() {
        if (isset($_SESSION['name'])) { 
            $data['page']  = 'Settings';
            $data['user'] = $this->comman->get_rows('users_portal','','user_id','desc');
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('settings/view.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect($this->agent->referrer());
        }
    }  

    public function addUser() {
        if (isset($_SESSION['name'])) { 

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('username', 'Username', 'trim|required');
                //$this->form_validation->set_rules('userLevel', 'User Level', 'trim|required');
                $this->form_validation->set_rules('lastname', 'Last Name', 'trim|required');
                $this->form_validation->set_rules('firstname', 'First Name', 'trim|required');
                $this->form_validation->set_rules('newpassword', 'PIN', 'trim|required');


                if ($this->form_validation->run() != false) {

                    $agency = '';
                    if(!empty($this->input->post('agency'))){
                        $agency = implode(',',$this->input->post('agency',true));    
                    }

                    $userLevel = ''; $backend_allowed = 0;
                    if(!empty($this->input->post('userLevel'))) {
                        $userLevelArr = $this->input->post('userLevel',true);
                        if(in_array('A', $userLevelArr)) {
                            $backend_allowed = 1;
                        } else {
                            $backend_allowed = 0;
                        }
                        $userLevel = implode(',',$userLevelArr);    
                    }

                    $agencyLocation = '';
                    if(!empty($this->input->post('agencyLocation'))){
                        $agencyLocation = implode(',',$this->input->post('agencyLocation',true));    
                    }

                    $dataArray                = [];
                    $dataArray['agency']      = $agency;
                    $dataArray['name']        = $this->input->post('username',true);
                    $dataArray['firstname']   = $this->input->post('firstname',true);
                    $dataArray['lastname']    = $this->input->post('lastname',true);
                    $dataArray['userlevel']   = $userLevel;
                    $dataArray['agency_location']   = $agencyLocation;
                    $dataArray['backend_allowed']   = $backend_allowed;
                    $dataArray['password']    = md5($this->input->post('newpassword', TRUE));

                    /*if(!empty($_POST['outputImage'])) {
                        define("UPLOAD_DIR", FCPATH.'assets2/images/users/signature/'); 
                        $signature = $_POST['outputImage'];
                        $signature = str_replace('data:image/png;base64,', '', $signature);
                        $signature = str_replace(' ', '+', $signature);
                        $data = base64_decode($signature);
                        $signName = md5(microtime().date('Y-m-d')).'.png';
                        $file = UPLOAD_DIR . $signName;
                        if ( ! write_file($file, $data, 'w+')) {
                            //echo 'Unable to write the file';
                        } else {
                            $dataArray['signature'] = $signName;
                        }    
                    }
                    $dataArray['sign_output'] = $this->input->post('output');*/

                    $inserId = $this->comman->insert( "users_portal", $dataArray );

                    if($inserId){
                        $this->app->message('User has been added successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('setting','refresh');
                }
            }

            $data['page'] = 'Add User';

            $data['agencyLocation'] = $this->comman->get_rows('agency_location');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('settings/add.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function editUser($pageId='') {

        if (isset($_SESSION['name'])) { 

            if(!empty($pageId)){
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['user_id'] = $pageId;
                $pageData   =   $this->comman->get_row('users_portal',$where);
                $data['pageData']  =   $pageData;
            }

            //print_r($this->input->post());die;

            if( !empty( $this->input->post( 'update' ) ) ){
                $this->form_validation->set_rules('username', 'Username', 'trim|required');
                //$this->form_validation->set_rules('userLevel', 'User Level', 'trim|required');
                $this->form_validation->set_rules('lastname', 'Last Name', 'trim|required');
                $this->form_validation->set_rules('firstname', 'First Name', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $agency = '';
                    if(!empty($this->input->post('agency'))){
                        $agency = implode(',',$this->input->post('agency',true));    
                    }

                    $userLevel = ''; $backend_allowed = 0;
                    if(!empty($this->input->post('userLevel'))) {
                        $userLevelArr = $this->input->post('userLevel',true);
                        if(in_array('A', $userLevelArr)) {
                            $backend_allowed = 1;
                        } else {
                            $backend_allowed = 0;
                        }
                        $userLevel = implode(',',$userLevelArr);    
                    }

                    $agencyLocation = '';
                    if(!empty($this->input->post('agencyLocation'))){
                        $agencyLocation = implode(',',$this->input->post('agencyLocation',true));    
                    }

                    $dataArray                = [];
                    $dataArray['agency']      = $agency;
                    $dataArray['name']        = $this->input->post('username',true);
                    $dataArray['firstname']   = $this->input->post('firstname',true);
                    $dataArray['lastname']    = $this->input->post('lastname',true);
                    $dataArray['userlevel']   = $userLevel;
                    $dataArray['backend_allowed']   = $backend_allowed;
                    $dataArray['agency_location']   = $agencyLocation;

                    $newpassword = $this->input->post('newpassword', TRUE);
                    if(!empty($newpassword)) {
                        $dataArray['password']    = md5($newpassword);
                    }

                    /*
                    if(!empty($_POST['outputImage'])) {
                        define("UPLOAD_DIR", FCPATH.'assets2/images/users/signature/'); 
                        $signature = $_POST['outputImage'];
                        $signature = str_replace('data:image/png;base64,', '', $signature);
                        $signature = str_replace(' ', '+', $signature);
                        $data1 = base64_decode($signature);
                        $signName = md5(microtime().date('Y-m-d')).'.png';
                        //print_r($signName);
                        $file = UPLOAD_DIR . $signName;
                        if ( ! write_file($file, $data1, 'w+')) {
                            //echo 'Unable to write the file';
                        } else {
                            //echo 'File written!';
                            $dataArray['signature'] = $signName;
                            if(!empty($data['pageData']['signature'])) {
                                $path = UPLOAD_DIR . $data['pageData']['signature'];
                                unlink($path);     
                            }
                        }    
                    }

                    $dataArray['sign_output'] = $this->input->post('output');*/

                    $where          = [];
                    $where['user_id'] = $pageId;

                    $updateId = $this->comman->update( "users_portal", $where, $dataArray );

                    if($updateId){
                        $this->app->message('User has been updated successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('setting','refresh');
                }
            }

            $data['page'] = 'Update User';

            $data['agencyLocation'] = $this->comman->get_rows('agency_location');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('settings/edit.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect('');
        }
    }  

    public function deleteUser($recordId){
        if(!empty($recordId)){
            $recordId       = decode64($recordId);
            $where          = [];
            $where['user_id'] = $recordId;
            $check = $this->comman->delete_row('users_portal',$where);
            $this->app->message('User has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    public function changeUserPassword($pageId='') {

        if (isset($_SESSION['name'])) { 

            if(!empty($pageId)){
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['user_id'] = $pageId;
                $pageData   =   $this->comman->get_row('users_portal',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ){
                $this->form_validation->set_rules('newpassword', 'New Password', 'trim|required');
                $this->form_validation->set_rules('repassword', 'Re-enter Password', 'trim|required|matches[newpassword]');

                //$m_pass2 = mdencode($m_pass2, 1000);

                if ($this->form_validation->run() != false) {

                    $dataArray                = [];
                    $dataArray['password']    = md5($this->input->post('newpassword', TRUE));
                    //$dataArray['password']    = mdencode($this->input->post('newpassword'), 1000);

                    $where          = [];
                    $where['user_id'] = $pageId;
                    $updateId = $this->comman->update( "users_portal", $where, $dataArray );

                    if($updateId){
                        $this->app->message('Password has been updated successfully.', 'success');
                    }else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('setting','refresh');
                }
            }

            $data['page'] = 'Update User';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('settings/update-password.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect('');
        }
    }



    public function changePassword($pageId='') {

        if (isset($_SESSION['name'])) { 
            $pageId = $this->session->userdata('id');
            if(!empty($pageId)){
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['user_id'] = $pageId;
                $pageData   =   $this->comman->get_row('users_portal',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ){
                //$this->form_validation->set_rules('oldpassword', 'Old Password', 'trim|required');
                $this->form_validation->set_rules('newpassword', 'New Password', 'trim|required');
                $this->form_validation->set_rules('repassword', 'Re-enter Password', 'trim|required|matches[newpassword]');

                if ($this->form_validation->run() != false) {
                   // $oldpassword = $this->input->post('oldpassword');

                    //if($pageData['password']==md5($oldpassword)) {

                        $dataArray                = [];
                        $dataArray['password']    = md5($this->input->post('newpassword', TRUE));

                        $where          = [];
                        $where['user_id'] = $pageId;
                        $updateId = $this->comman->update( "users_portal", $where, $dataArray );

                        if($updateId){
                            $this->app->message('Password has been updated successfully.', 'success');
                        }else{
                            $this->app->message('Oops! something went wrong try again.', 'error');
                        }

                    //} else {
                      //  $this->app->message('Old password does not match.', 'error');
                    //}
                    redirect('setting/changePassword','refresh');
                }
            }

            $data['page'] = 'Update Password';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('settings/change-password.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect('');
        }
    }


    public function updateSignature() {

        if (isset($_SESSION['name'])) {            
            $pageId = $this->session->userdata('googleId');
            if(!empty($pageId)) {
                $data['googleId']       =   $pageId;    
                $where                  =   [];
                $where['googleUserId']  =   $pageId;
                $pageData               =   $this->comman->get_row('supervisor', $where);
                $data['pageData']       =   $pageData;
            }

            if(!empty( $this->input->post('update'))) {


                $dataArray                = [];
                if(!empty($_POST['outputImage'])) {
                    define("UPLOAD_DIR", FCPATH.'assets2/images/supervisor/signature/'); 
                    $signature = $_POST['outputImage'];
                    $signature = str_replace('data:image/png;base64,', '', $signature);
                    $signature = str_replace(' ', '+', $signature);
                    $data1 = base64_decode($signature);
                    $signName = md5(microtime().date('Y-m-d')).'.png';
                    //print_r($signName);
                    $file = UPLOAD_DIR . $signName;
                    if ( ! write_file($file, $data1, 'w+')) {
                        //echo 'Unable to write the file';
                    } else {
                        //echo 'File written!';
                        $dataArray['signature'] = $signName;
                        $dataArray['sign_output'] = $this->input->post('output');
                        if(!empty($data['pageData']['signature'])) {
                            $path = UPLOAD_DIR . $data['pageData']['signature'];
                            unlink($path);     
                        }
                    }
                }

                if(!empty($_FILES['signature'])){
                    $img_data   =   [];
                    $img_data['path']   =   'assets2/images/supervisor/signature';
                    $img_data['file_name']  =   'signature';
                    $img_data['allowed_type']   =   'png|jpg|jpeg';
                    $img_data['old_file']   =   $data['pageData']['signature'];
                    $img_data['width']  =   200;
                    $img_data['height'] =   200;
                    $img_data['quality']    =   '60%';
                    $img_data['image_compress'] =   TRUE;
                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $dataArray['signature'] = $img['url'];
                        $dataArray['sign_output'] = '';
                    }
                }

                

                $where = [];
                $where['googleUserId'] = $this->session->userdata('googleId');
                $updateId  = $this->comman->update('supervisor', $where, $dataArray);

                if ($updateId) {
                    $this->app->message('Signature has been updated successfully.', 'success');
                } else {
                    $this->app->message('Oops! something went wrong try again.', 'error');
                }
                redirect('setting/updateSignature','refresh');
            }

            $data['page'] = 'Update Signature';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('settings/update-signature.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect('');
        }
    }

    public function uploadfiles($img_data=[]){
        $folder =   $img_data['path'];
        $file = $img_data['file_name'];
        $allowed_types =    $img_data['allowed_type'];
        $older =    $img_data['old_file'];
        $width  =   $img_data['width'];
        $height =   $img_data['height'];
        $quality    =   $img_data['quality'];

        if(!empty($_FILES[$file]) && $_FILES[$file]['size'] > 0){          
            if(!empty($older)){
                $postimgurl = FCPATH."$folder/". $older;
                unlink($postimgurl);
            }
            $config =   [];
            $config['upload_path']     = './'."$folder".'/'; 
            $config['allowed_types']   = $allowed_types;
            $new_name = $file.time().rand(0000,9999);
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if($this->upload->do_upload($file)){
                $postimg =$this->upload->data()['file_name'] ;
                $postimgurl = base_url()."$folder/". $postimg;
                chmod($this->upload->data()['full_path'],0777);
                if($img_data['image_compress']){
                    $config =   [];
                    $config['image_library'] = 'gd2';  
                    $config['source_image'] = './'."$folder".'/'.$postimg;  
                    $config['create_thumb'] = FALSE;  
                    $config['maintain_ratio'] = FALSE;  

                    $config['quality'] = $quality;  
                    if(!empty($width)){
                        $config['width'] = $width;  
                    }
                    if(!empty($height)){
                        $config['height'] = $height;  
                    }
                    
                    $config['new_image'] = './'."$folder".'/'.$postimg;  
                    
                    $this->load->library('image_lib', $config);  
                    $this->image_lib->initialize($config);
                    if($this->image_lib->resize()){
                        $this->image_lib->clear();
                        $data['url'] =  $postimg;
                        $data['status'] = 1;
                    }else{
                        $data['status'] = 0;
                        $data['msg']=$this->upload->display_errors();
                    }  
                }else{
                    $data['url'] =  $postimg;
                    $data['status'] = 1;
                }
            }else{
                $data['status']=0;
                $data['msg']=$this->upload->display_errors();
            }
            return $data;
        }
    }
} 