<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Tools extends CI_Controller
{
    public function __construct() {        

        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Supervisor_model', 'supervisor');
        $this->load->helper('file');
        /**** load phpmailer library for send mail ****/ 
        $this->load->library('phpmailer_lib');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        }
        else
            $this->headerData=[];

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
    }

    public function recordsWithAPOSTROPHE() {
        if(isset($_SESSION['name'])) {
            $MySQL = 'SELECT * FROM patient WHERE firstname LIKE "%\'%" OR lastname LIKE "%\'%" OR name LIKE "%\'%"';
            $data['clientData'] = $this->Comman_model->getCustomQueryData($MySQL);

            //print_r($data['clientData']);die;

            $MySQL = 'SELECT * FROM employee WHERE firstname LIKE "%\'%" OR lastname LIKE "%\'%" OR name LIKE "%\'%"';
            $data['employeeData'] = $this->Comman_model->getCustomQueryData($MySQL);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('tools/view.php',$data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect();
        }
    }  


    function clearAllNotification() {
        /************ Notification status updated code start ************/
        //echo $_GET['notify_id'];die;

        $user_id = $this->session->userdata('id');
        if($user_id!=6) {
            if(checkUserLevel('P', $this->session->userdata('userlevel'))) {
                $sql = "SELECT * FROM tbl_cut_check_notifications WHERE notify_to = 'P' AND (status = 1 OR status = 2) AND !find_in_set($user_id, read_by)";
                $notifyData = get_custom_query_data($sql);
            } else {
                $sql = "SELECT * FROM tbl_cut_check_notifications WHERE (notify_to = 'LS' AND find_in_set($user_id, ls_id) AND !find_in_set($user_id, read_by) OR (user_id = '".$user_id."' AND read_by!='".$user_id."'))";
                $notifyData = get_custom_query_data($sql);    
            }
        }


        if(!empty($notifyData)) {
            foreach ($notifyData as $nkey => $nrow) {
                $nid = $nrow['id'];
                $sql = "SELECT read_by FROM tbl_cut_check_notifications WHERE id = '".$nid."'";
                $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                if(!empty($row['read_by'])) {
                    $readByArr = explode(',', $row['read_by']);
                    if(!in_array($user_id, $readByArr)) {
                        array_push($readByArr, $user_id);
                        $where = [];
                        $where['id'] = $nid;

                        $dataArray = [];
                        $dataArray['read_by'] = implode(',', $readByArr);
                        $this->Comman_model->update('tbl_cut_check_notifications', $where, $dataArray);
                    }
                } else {
                    $where = [];
                    $where['id'] = $nid;

                    $dataArray = [];
                    $dataArray['read_by'] = $user_id;
                    $this->Comman_model->update('tbl_cut_check_notifications', $where, $dataArray);
                }
            }
        }
        $this->session->set_flashdata('message','All notifications has been clear.');
        redirect($this->agent->referrer());
        /************ Notification status updated code end ************/
    }

    function notification() {
        $user_id = $this->session->userdata('id');
        $sql = "SELECT * FROM notification_settings WHERE user_id = '".$user_id."'";
        $row = $this->Comman_model->getCustomQueryData($sql, 'row');
        if(!empty($row['user_id'])) {
            $disable = $row['disable'];
            $dataArray = [];
            if($disable==0) {
                $dataArray['disable'] = 1;
            }
            if($disable==1) {
                $dataArray['disable'] = 0;
            }

            $where = [];
            $where['user_id'] = $user_id;
            $this->Comman_model->update('notification_settings', $where, $dataArray);
        } else {
            $dataArray = [];
            $dataArray['user_id'] = $user_id;
            $dataArray['disable'] = 1;
            $this->Comman_model->insert('notification_settings', $dataArray);
        }
        $this->session->set_flashdata('n_message','Notification settings has been updated.');
        redirect('admin/home');
    }

    function readNotification() {
        /************ Notification status updated code start ************/
        //echo $_GET['notify_id'];die;
        if(!empty($_GET['notify_id'])) {
            $user_id = $this->session->userdata('id');
            //if(checkUserLevel('P', $this->session->userdata('userlevel'))) {

            //} else {
                $sql = "SELECT read_by FROM tbl_cut_check_notifications WHERE id = '".$_GET['notify_id']."'";
                $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                if(!empty($row['read_by'])) {
                    $readByArr = explode(',', $row['read_by']);
                    if(!in_array($user_id, $readByArr)) {
                        array_push($readByArr, $user_id);
                        $where = [];
                        $where['id'] = $_GET['notify_id'];

                        $dataArray = [];
                        $dataArray['read_by'] = implode(',', $readByArr);
                        $this->Comman_model->update('tbl_cut_check_notifications', $where, $dataArray);
                    }
                } else {
                    $where = [];
                    $where['id'] = $_GET['notify_id'];

                    $dataArray = [];
                    $dataArray['read_by'] = $user_id;
                    $this->Comman_model->update('tbl_cut_check_notifications', $where, $dataArray);
                }            
            //}        
        }
        redirect('employee/cutCheckRequest');
        /************ Notification status updated code end ************/
    }

    public function cutCheckRequest() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $recno = $_GET['employee'];
            $ptid = $_GET['patient'];
            $recId = $_GET['rec_id'];

            $where  = [];
            $where['patient_id'] = $ptid;
            $patientData = $this->Comman_model->get_row('patient', $where);

            $where  = [];
            $where['agency_code'] = $patientData['Agency'];
            $agencyData = $this->Comman_model->get_row('agency', $where);
            if($patientData['Agency']==2 || $patientData['Agency']==4) {
                $agencyName = 'SENIORCARE';
            } else {
                $agencyName = $agencyData['agency_codename'];
            }
            

            $where  = [];
            $where['employee_id'] = $recno;
            $employeeData = $this->Comman_model->get_row('employee', $where);

            $x = '2';
            $query = "SELECT * FROM employee_clock WHERE employee_id = '$recno' AND patient_id = '$ptid' AND  isIn = '$x' ORDER by employee_clock_id desc";
            $rowdate = get_custom_query_data($query, 'row');

            $t = explode('.',$rowdate['signfilename']);
            $filename = 'https://portal.1017.solutions/hcp/geo/GetSignature/';
            $filename2 = $filename.$rowdate['signfilename'];
            $err = 1;
            if ($t[1] == 'png' || @$t[1] == 'jpg' || @$t[1] == 'jpeg') {
                $err = 0;
                $signpath = '<img src="'.$filename.$rowdate['signfilename'].'" width="80"/>';
            } else {
                $err = 1;
                $signpath = '';
            }

            $where  = [];
            $where['id'] = $recId;
            $row  =   $this->Comman_model->get_row('cut_check', $where);

            $where  = [];
            $where['user_id'] = $row['requested_by'];
            $userRow  =   $this->Comman_model->get_row('users_portal', $where);

            $where  = [];
            $where['googleUserId'] = $userRow['googleUserId'];
            $supRow  =   $this->Comman_model->get_row('supervisor', $where);
            $sup_sign = "";
            if(!empty($supRow['signature'])) {
                $sup_sign = '<img src="'.base_url("assets2/images/supervisor/signature/").$supRow['signature'].'" width="120"/>';
            }

            $userApName = $sup_APsign = "";
            if(!empty($row['approved_by'])) {
                $where  = [];
                $where['user_id'] = $row['approved_by'];
                $userApRow  =   $this->Comman_model->get_row('users_portal', $where);
                $userApName = $userApRow['name'];

                $where  = [];
                $where['googleUserId'] = $userApRow['googleUserId'];
                $supApRow  =   $this->Comman_model->get_row('supervisor', $where);                
                if(!empty($supApRow['signature'])) {
                    $sup_APsign = '<img src="'.base_url("assets2/images/supervisor/signature/").$supApRow['signature'].'" width="120"/>';
                }
            }

            $current_date = date('m/d/Y', strtotime($plcData['created']));

            $ssn = $row['ssn'];    
            if(!empty($row['ssn'])) {
                $ssnArr = explode('-', $row['ssn']);
                $ssn = $ssnArr[2];
            }

            require_once(APPPATH . 'libraries/mpdf/mpdf.php'); 
            $mpdf=new mPDF('en-GB-x','A4','','',20,20,20,20,6,3); 
            $mpdf->showImageErrors = true;
            $mpdf->SetDisplayMode('fullpage');
            $mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
            /*$html = '<style>
            @page {
            margin: 50px;  }
            table.browser { border:1px solid white; margin-bottom: 20px;margin-top:1%;font-family: arial;width:75%;font-size: 75%;}
            table.browser tr.even { background: #EFEFEF }
            table.browser th { background: #222; color: black; font-weight: normal;font-family: verdana }
            table.browser tr:hover td { background-color: #EEE; color: black; }
            table.browser td { border:1px solid white;padding:4px;}
            table.browser th { padding: 8px; border:2px solid white; }
            input { border-top:0px;border-right:0px;border-left:0px;border-bottom:2px solid black }
            p { margin-bottom:1px;margin-top:1px;font-size: 13px;padding-left:7px;}
            </style>';
            $mpdf->WriteHTML($html);
            $html2 = '';
            $html2 = '<style>@page { margin: 10px;} p { margin-bottom:1px;margin-top:1px}</style>';
            $mpdf->WriteHTML($html);*/
            $html = '<table style="width:100%"><tr><td style="width:100%;" align="center">';
            $html = $html.'<img src="'.base_url('assets/images/hcp-all-logo.png').'" width="255px"></td>';
            $html = $html.'</tr></table>';
            $mpdf->WriteHTML($html);

            $html4 = '<table style="width:100%;padding:10px"><tr><td>';
            $html4 .= '<center><h2><p style="arial;width:75%;font-size: 24px; font-family: Italic;">Paycheck Request</p></h2></center>';
            $html4 .= '<center><p style="Italic;width:100%;font-size: 16px;color: green;">Company : '.$agencyName.'</p></center>';
            $html4 .= '</td></tr></table>';
            $mpdf->WriteHTML($html4);

            $html  = '<br>';

            $html .= '<table  style="width:100%;padding-bottom:20px;padding-left:20px;padding-right:20px;">';
            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%"><tr>';
            $html .= '<td style="width:25%;font-weight:bold;">Worker\'s Name:</td>';
            $html .= '<td style="border-bottom:1px solid black;">'.$row['employee_name'].'</td>';
            $html .= '</tr></table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%"><tr>';
            $html .= '<td style="width:30%; font-weight:bold;">Last Four Digits (SSN):</td>';
            $html .= '<td style="border-bottom:1px solid black;"> '.$ssn.'</td>';
            $html .= '</tr></table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">Branch (Circle):</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$row['agency_location_name'].'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">Pay Period:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$row['pay_period'].'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">Pay Rate:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$row['pay_rate'].'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">Reason:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$row['reason'].'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">&nbsp;</td>';
            $html .= '<td style="border-bottom:1px solid black"></td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">&nbsp;</td>';
            $html .= '<td style="border-bottom:1px solid black"></td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<br>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:38%;font-weight:bold;">Where will the check be sent?:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$row['check_sent'].'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">&nbsp;</td>';
            $html .= '<td style="border-bottom:1px solid black"></td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:25%;font-weight:bold;">&nbsp;</td>';
            $html .= '<td style="border-bottom:1px solid black"></td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<br>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:35%;font-weight:bold;">Requested By:</td>';
            $html .= '<td></td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<br>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:35%;font-weight:bold;">Name of requestor:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$userRow['name'].'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:35%;font-weight:bold;">Signature of requestor:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$sup_sign.'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<br>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:35%;font-weight:bold;">Approved By:</td>';
            $html .= '<td></td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<br>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:35%;font-weight:bold;">Name of Lead Supervisor:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$userApName.'</td></tr>';
            $html .= '</table></td></tr>';

            $html .= '<tr><td style="width:100%;">';
            $html .= '<table style="width:100%">';
            $html .= '<tr><td style="width:35%;font-weight:bold;">Signature of Lead Supervisor:</td>';
            $html .= '<td style="border-bottom:1px solid black">'.$sup_APsign.'</td></tr>';
            $html .= '</table></td></tr>';

            if(!empty($row['pay_history_id'])) {
                $html .= '<br><br><table border=1 cellpadding=10 cellspacing=0 style="width:100%">
                <tr><th>Start Date</th><th>Check #</th><th>Pay Date</th><th>Net Pay</th><th>Gross Pay</th><th>Reg Hrs</th><th>Overtime Hrs</th><th>Total Hrs</th><th>CST</th></tr>';
                $sqlP = "SELECT * FROM portal_pay_history WHERE id IN (".$row['pay_history_id'].")";
                $payHistoryData = $this->Comman_model->getCustomQueryData($sqlP);
                foreach ($payHistoryData as $pkey => $prow) {
                    // code...
                    $html .= "<tr><td>".date('m/d/Y', strtotime($prow['period_beginning_date']))."</td><td>".$prow['check_voucher']."</td><td>".$prow['pay_date']."</td><td>".$prow['net_pay']."</td><td>".$prow['gross_pay']."</td><td>".$prow['regular_hours']."</td><td>".$prow['overtime_hours']."</td><td>".$prow['total_hours']."</td><td>".$prow['cst']."</td></tr>";
                }
                $html .= "</table>";
            }

            $html .= '</table>';
             
            $mpdf->WriteHTML($html);
             
            $mpdf->Output();
            //$mpdf->Output($filename,'F');
            exit;
        } else {
            redirect();
        }
    }

    public function getCutCheckRequest() {
        if(isset($_SESSION['name'])) {
            if(!empty( $this->input->post('submit'))) {
                //$this->form_validation->set_rules('pay_rate', 'Pay rate', 'trim|required');
                $this->form_validation->set_rules('reason', 'Reason', 'trim|required');
                $this->form_validation->set_rules('check_sent', 'Field is required ', 'trim|required');
                $this->form_validation->set_rules('request', 'Request ', 'trim|required');
                if ($this->form_validation->run() != false) {

                    $requestType = $this->input->post('request',true);

                    $payHistory = $this->input->post('payHistory',true);

                    if(!empty($payHistory)) {
                        $payHistory = implode(',', $payHistory);
                    } else {
                        $payHistory = '';    
                    }

                    $employee = $this->input->post('employee',true);
                    $patient = $this->input->post('patient',true);
                    $datetrans = $this->input->post('datetrans',true);

                    //$paydata = unserialize(base64_decode($_POST['paydata']));
                    $paydata = $this->input->post('paydata',true);

                    $where = [];
                    $where['employee_id'] = $employee;
                    $employeeRow = $this->Comman_model->get_row('employee', $where);

                    $where = [];
                    $where['patient_id'] = $patient;
                    $patientRow = $this->Comman_model->get_row('patient', $where);

                    $where = [];
                    $where['agency_code'] = $patientRow['Agency'];
                    $agencyRow = $this->Comman_model->get_row('agency', $where);

                    $where = [];
                    $where['agency_location_code'] = $patientRow['agency_location'];
                    $agencyLocationRow = $this->Comman_model->get_row('agency_location', $where);

                    $where = [];
                    $where['agency_location_code'] = $employeeRow['agency_location'];
                    $emAgencyLocationRow = $this->Comman_model->get_row('agency_location', $where);

                    $empName = $employeeRow['name'];
                    $ptName = $patientRow['name'];
                    $ssn = $employeeRow['ssn'];

                    $insert_sql_array = [];
                    $insert_sql_array['pay_rate'] = $this->input->post('pay_rate',true);
                    $insert_sql_array['reason'] = $this->input->post('reason',true);
                    $insert_sql_array['check_sent'] = $this->input->post('check_sent',true);
                    $insert_sql_array['pay_period'] = $this->input->post('pay_period',true);
                    $insert_sql_array['employee_id'] = $employee;
                    $insert_sql_array['employee_name'] = $empName;
                    $insert_sql_array['ssn'] = $ssn;
                    $insert_sql_array['patient_id'] = $patient;
                    $insert_sql_array['patient_name'] = $ptName;
                    $insert_sql_array['agency_id'] = $patientRow['Agency'];
                    $insert_sql_array['agency_name'] = $agencyRow['agency_codename'];
                    $insert_sql_array['agency_location_id'] = $patientRow['agency_location'];
                    $insert_sql_array['agency_location_name'] = $agencyLocationRow['agency_location_name'];
                    $insert_sql_array['ls_id']  = $agencyLocationRow['lead_supervisor'];
                    $insert_sql_array['ls_id2'] = $agencyLocationRow['lead_supervisor2'];
                    $insert_sql_array['ls_id3'] = $agencyLocationRow['lead_supervisor3'];
                    $insert_sql_array['ls_id4'] = $agencyLocationRow['lead_supervisor4'];
                    $insert_sql_array['ls_id5'] = $agencyLocationRow['lead_supervisor5'];
                    $insert_sql_array['sup_id'] = $patientRow['supervisor_id'];

                    $insert_sql_array['em_ls_id']  = $emAgencyLocationRow['lead_supervisor'];
                    $insert_sql_array['em_ls_id2'] = $emAgencyLocationRow['lead_supervisor2'];
                    $insert_sql_array['em_ls_id3'] = $emAgencyLocationRow['lead_supervisor3'];
                    $insert_sql_array['em_sup_id'] = $employeeRow['supervisor_id'];

                    $insert_sql_array['request_type'] = $requestType;
                    $insert_sql_array['pay_data'] = $paydata;
                    $insert_sql_array['requested_by'] = $this->session->userdata('id');
                    $insert_sql_array['datetrans'] = date('Y-m-d', strtotime($datetrans));
                    $insert_sql_array['pay_history_id'] = $payHistory;

                    $inserId = $this->Comman_model->insert("cut_check", $insert_sql_array);

                    if($inserId) {
                        /************* Code for notification data start *************/
                        $lsArr = [];
                        if(!empty($agencyLocationRow['lead_supervisor'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor']);
                        }
                        if(!empty($agencyLocationRow['lead_supervisor2'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor2']);
                        }
                        if(!empty($agencyLocationRow['lead_supervisor3'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor3']);
                        }
                        if(!empty($agencyLocationRow['lead_supervisor4'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor4']);
                        }
                        if(!empty($agencyLocationRow['lead_supervisor5'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor5']);
                        }

                        if(!empty($emAgencyLocationRow['lead_supervisor'])) {
                            array_push($lsArr, $emAgencyLocationRow['lead_supervisor']);
                        }
                        if(!empty($emAgencyLocationRow['lead_supervisor2'])) {
                            array_push($lsArr, $emAgencyLocationRow['lead_supervisor2']);
                        }
                        if(!empty($emAgencyLocationRow['lead_supervisor3'])) {
                            array_push($lsArr, $emAgencyLocationRow['lead_supervisor3']);
                        }

                        $dataArray = [];
                        $dataArray['ls_id'] = implode(',', $lsArr);
                        $dataArray['sup_id'] = $patientRow['supervisor_id'];
                        $dataArray['content'] = "New cut check request for ".$patientRow['name'];
                        $dataArray['status'] = 'Pending';
                        $dataArray['notify_to'] = 'LS';
                        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
                        $dataArray['notify_to'] = 'S';
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
                        /************* Code for notification data end *************/

                        /************* Send mail to Lead Supervisor Start *************/
                        $this->sendMailToLeadSupervisor($inserId, 'Pending');
                        /************* Send mail to Lead Supervisor End *************/
                        $this->session->set_flashdata('message','Supervisor request has been submitted succesfully.');
                    } else {
                        $this->session->set_flashdata('error_message','Oops! something went wrong try again.');
                    }
                    redirect($this->agent->referrer());
                } else {
                    redirect($this->agent->referrer());
                }
            }
        } else {
            redirect();
        }
    }

    function sendMailToLeadSupervisor($recId, $status) {
        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('cut_check', $where);

        if($row['request_type']==1) {
            $requestType = "Cut check request";
        }
        if($row['request_type']==2) {
            $requestType = "Void/Replacement";
        }

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['patient_id']   =   $row['patient_id'];
        $ptRow = $this->Comman_model->get_row('patient', $where);

        $where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];

        $where  =   [];
        $where['supervisor_id']   =   $row['ls_id'];
        $lsupRow = $this->Comman_model->get_row('supervisor', $where);
        $lsupEmail = $lsupRow['email'];        

        //$ssnArr = explode('-', $row['ssn']);
        //$ssn = $ssnArr[2];

        //$to = "payroll@hcpcaregivers.com";
        //$to2 = trim($lsupEmail);
        $to3 = "demo@hcpcaregivers.com";
        $subject = "Cut Check Request / ".$row['employee_name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Pay Period</th><td>".$row['pay_period']."</td></tr>
        <tr><th>Pay Rate</th><td>".$row['pay_rate']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Where will the check be sent</th><td>".$row['check_sent']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        if(!empty($row['pay_history_id'])) {            
            $message .= "<br><table border=1 cellpadding=10>
            <tr><th>Start Date</th><th>Check #</th><th>Pay Date</th><th>Net Pay</th><th>Gross Pay</th><th>Reg Hrs</th><th>Overtime Hrs</th><th>Total Hrs</th><th>CST</th></tr>";
            $sqlP = "SELECT * FROM portal_pay_history WHERE id IN (".$row['pay_history_id'].")";
            $payHistoryData = $this->Comman_model->getCustomQueryData($sqlP);
            foreach ($payHistoryData as $pkey => $prow) {
                // code...
                $message .= "<tr><td>".date('m/d/Y', strtotime($prow['period_beginning_date']))."</td><td>".$prow['check_voucher']."</td><td>".$prow['pay_date']."</td><td>".$prow['net_pay']."</td><td>".$prow['gross_pay']."</td><td>".$prow['regular_hours']."</td><td>".$prow['overtime_hours']."</td><td>".$prow['total_hours']."</td><td>".$prow['cst']."</td></tr>";
            }
            $message .= "</table>";
        }
        $message .= "</td>";

        $paydata = unserialize(base64_decode($row['pay_data']));

        $message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table><br><table border=1 cellpadding=10><tr><th>Day / Date</th><th>Time In</th><th>Time Out</th><th>Hours</th></tr>";
        foreach ($paydata as $key1 => $row1) {
            if($key1=='data') {
                foreach ($row1 as $key2 => $row2) {
                    $message .= "<tr><td>".$row2['day']." <br> ".$row2['date']."</td><td>".$row2['timein']."</td><td>".$row2['timeout']."</td><td>".$row2['hours']."</td></tr>";                                        
                }
            }
            if($key1=='total') {
                $message .= '<tr><th colspan=4 align="center">Total Hours : '.$row1.'</th></tr>';
            }
        }
        $message .= "</table></td></tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        //$to = "ankityadav036@gmail.com";
        //mail($to,$subject,$message,$headers);die;
        //mail($to2,$subject,$message,$headers);
        //mail($to3,$subject,$message,$headers);

        $this->sendPHPMailerMail($to3,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/
        if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        if(!empty($row['ls_id4'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id4'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id5'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id5'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/

        /************** Mail Send To Employee Lead Supervisors (LS) Start *****************/
        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }

    function sendPHPMailerMail($to, $subject, $message, $headers) {
        if(!empty($to)) {
            $mail = $this->phpmailer_lib->load();
            $mail->IsSMTP(); // set mailer to use SMTP
            $mail->Host        = "smtp.office365.com";  // specify main and backup server
            $mail->SMTPAuth    = true;     // turn on SMTP authentication
            $mail->SMTPDebug   = 0; 
            $mail->SMTPSecure  = "STARTTLS";
            $mail->Port        = 587;
            $mail->Username    = "rdsrm@hcpfinancial.onmicrosoft.com";  // SMTP username
            $mail->Password    = "Onedrive5301!"; // SMTP password
            //$mail->CharSet     = 'UTF-8';
            $mail->SMTPAuth    = true;
            $mail->From        = "rdsrm@hcpfinancial.onmicrosoft.com";
            $mail->FromName    = "HCP Support";
            $mail->AddAddress($to);   // name is optional
            $mail->IsHTML(true);                                  // set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $message;
            if(!$mail->Send()) {
                return false;
            }   
        }
        return true;
    }

    public function getRateRequest() {
        if(isset($_SESSION['name'])) {
            if(!empty( $this->input->post('submit'))) {
                $this->form_validation->set_rules('pay_rate', 'Pay rate', 'trim|required');
                $this->form_validation->set_rules('effective_date', 'Effective Date', 'trim|required');
                $this->form_validation->set_rules('reason', 'Reason ', 'trim|required');
                if ($this->form_validation->run() != false) {

                    $requestType = $this->input->post('request',true);
                    $effective_date = $this->input->post('effective_date',true);
                    $clients = $this->input->post('clients',true);
                    $employee = $this->input->post('employee',true);

                    if($requestType==2 && empty($clients)) {
                        $this->session->set_flashdata('rate_error_message','Please select patient when temporary rate is set.');
                        redirect(base_url('employee/edit?id='.$employee.'&tab_index=1'));
                        exit();
                    }

                    if(!empty($clients)) {
                        $clients = implode(',', $clients);
                    } else {
                        $clients = '';    
                    }

                    $where = [];
                    $where['employee_id'] = $employee;
                    $employeeRow = $this->Comman_model->get_row('employee', $where);

                    $where = [];
                    $where['agency_code'] = $employeeRow['Agency'];
                    $emAgencyRow = $this->Comman_model->get_row('agency', $where);

                    $where = [];
                    $where['agency_location_code'] = $employeeRow['agency_location'];
                    $emAgencyLocationRow = $this->Comman_model->get_row('agency_location', $where);

                    $empName = $employeeRow['name'];
                    $ssn = $employeeRow['ssn'];

                    $insert_sql_array = [];
                    $insert_sql_array['pay_rate'] = $this->input->post('pay_rate',true);
                    $insert_sql_array['effective_date'] = $this->input->post('effective_date',true);
                    $insert_sql_array['reason'] = $this->input->post('reason',true);
                    $insert_sql_array['employee_id'] = $employee;
                    $insert_sql_array['client_ids'] = $clients;
                    $insert_sql_array['employee_name'] = $empName;
                    $insert_sql_array['ssn'] = $ssn;

                    $insert_sql_array['agency_id']  = $emAgencyRow['agency_code'];
                    $insert_sql_array['agency_name']  = $emAgencyRow['agency_codename'];
                    $insert_sql_array['agency_location_id']  = $employeeRow['agency_location'];
                    $insert_sql_array['agency_location_name']  = $emAgencyLocationRow['agency_location_name'];

                    $insert_sql_array['em_ls_id']  = $emAgencyLocationRow['lead_supervisor'];
                    $insert_sql_array['em_ls_id2'] = $emAgencyLocationRow['lead_supervisor2'];
                    $insert_sql_array['em_ls_id3'] = $emAgencyLocationRow['lead_supervisor3'];
                    $insert_sql_array['em_sup_id'] = $employeeRow['supervisor_id'];

                    $insert_sql_array['request_type'] = $requestType;
                    $insert_sql_array['requested_by'] = $this->session->userdata('id');

                    //print_r($insert_sql_array);die;

                    $inserId = $this->Comman_model->insert("rate_request", $insert_sql_array);

                    if($inserId) {
                        /************* Code for notification data start *************/
                        $lsArr = [];
                        /*if(!empty($agencyLocationRow['lead_supervisor'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor']);
                        }
                        if(!empty($agencyLocationRow['lead_supervisor2'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor2']);
                        }
                        if(!empty($agencyLocationRow['lead_supervisor3'])) {
                            array_push($lsArr, $agencyLocationRow['lead_supervisor3']);
                        }*/

                        if(!empty($emAgencyLocationRow['lead_supervisor'])) {
                            array_push($lsArr, $emAgencyLocationRow['lead_supervisor']);
                        }
                        if(!empty($emAgencyLocationRow['lead_supervisor2'])) {
                            array_push($lsArr, $emAgencyLocationRow['lead_supervisor2']);
                        }
                        if(!empty($emAgencyLocationRow['lead_supervisor3'])) {
                            array_push($lsArr, $emAgencyLocationRow['lead_supervisor3']);
                        }

                        $dataArray = [];
                        $dataArray['ls_id'] = implode(',', $lsArr);
                        $dataArray['sup_id'] = $patientRow['supervisor_id'];
                        $dataArray['content'] = "New rate request for ".$patientRow['name'];
                        $dataArray['status'] = 'Pending';
                        $dataArray['notify_to'] = 'LS';
                        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
                        $dataArray['notify_to'] = 'S';
                        $dataArray['user_id'] = $this->session->userdata('id');
                        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
                        /************* Code for notification data end *************/

                        /************* Send mail to Lead Supervisor Start *************/
                        $this->sendRateRequestMailToLeadSupervisor($inserId, 'Pending');
                        /************* Send mail to Lead Supervisor End *************/
                        $this->session->set_flashdata('message','Request for increasing rate has been submitted succesfully.');
                    } else {
                        $this->session->set_flashdata('error_message','Oops! something went wrong try again.');
                    }
                    redirect($this->agent->referrer());
                } else {
                    redirect($this->agent->referrer());
                }
            }
        } else {
            redirect();
        }
    }

    function sendRateRequestMailToLeadSupervisor($recId, $status) {
        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('rate_request', $where);

        if($row['request_type']==1) {
            $requestType = "Permanent Rate";
        }
        if($row['request_type']==2) {
            $requestType = "Temporary Rate";
        }

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['supervisor_id']   =   $row['ls_id'];
        $lsupRow = $this->Comman_model->get_row('supervisor', $where);
        $lsupEmail = $lsupRow['email'];        

        //$ssnArr = explode('-', $row['ssn']);
        //$ssn = $ssnArr[2];

        //$to = "payroll@hcpcaregivers.com";
        //$to2 = trim($lsupEmail);
        $to3 = "demo@hcpcaregivers.com";
        $subject = "Rate Increase Request / ".$row['employee_name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Pay Rate</th><td>".$row['pay_rate']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        if(!empty($row['client_ids'])) {            
            $message .= "<br><table border=1 cellpadding=10>
            <tr><th>Patient Name</th><th>Patient ID</th><th>Location</th><th>Supervisor</th></tr>";
            $sqlP = "SELECT * FROM patient WHERE patient_id IN (".$row['client_ids'].")";
            $patientData = $this->Comman_model->getCustomQueryData($sqlP);
            foreach ($patientData as $pkey => $prow) {
                $where = [];
                $where['supervisor_id'] = $prow['supervisor_id'];
                $supData = get_row('supervisor', $where);

                $where = [];
                $where['agency_location_code'] = $prow['agency_location'];
                $locData = get_row('agency_location', $where);
                // code...
                $message .= "<tr><td>".$prow['name']."</td><td>".$prow['patient_id']."</td><td>".$locData['agency_location_name']."</td><td>".$supData['name']."</td></tr>";
            }
            $message .= "</table>";
        }
        $message .= "</td>";

        $message .= "</tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        //$to = "ankityadav036@gmail.com";
        //mail($to,$subject,$message,$headers);die;
        //mail($to2,$subject,$message,$headers);
        //mail($to3,$subject,$message,$headers);

        $this->sendPHPMailerMail($to3,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/
        /*if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }

        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }

        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }*/
        /************** Mail Send To Lead Supervisors (LS) End *****************/

        /************** Mail Send To Employee Lead Supervisors (LS) Start *****************/
        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }

    function checkMissingActivitylogData() {

        //echo 'Compare data between employee_timesheet and employee_finalsheet table.';
        //echo '<br>';
        //echo '<br>';

        $agency_code = $this->session->userdata('agency');

        $month = date('m');
        if(!empty($_GET['month'])) {
            $month = $_GET['month'];
        }

        $year = date('Y');
        if(!empty($_GET['year'])) {
            $year = $_GET['year'];
        }

        $period = '1';
        if(!empty($_GET['period'])) {
            $period = $_GET['period'];
        }

        $sql = "SELECT 
            employee_timesheet.month,
            employee_timesheet.year,
            employee_timesheet.day01,
            employee_timesheet.day02,
            employee_timesheet.day03,
            employee_timesheet.day04,
            employee_timesheet.day05,
            employee_timesheet.day06,
            employee_timesheet.day07,
            employee_timesheet.day08,
            employee_timesheet.day09,
            employee_timesheet.day10,
            employee_timesheet.day11,
            employee_timesheet.day12,
            employee_timesheet.day13,
            employee_timesheet.day14,
            employee_timesheet.day15,
            employee_timesheet.day16,
            employee_timesheet.day17,
            employee_timesheet.day18,
            employee_timesheet.day19,
            employee_timesheet.day20,
            employee_timesheet.day21,
            employee_timesheet.day22,
            employee_timesheet.day23,
            employee_timesheet.day24,
            employee_timesheet.day25,
            employee_timesheet.day26,
            employee_timesheet.day27,
            employee_timesheet.day28,
            employee_timesheet.day29,
            employee_timesheet.day30,
            employee_timesheet.day31,
            employee_timesheet.period1,
            employee_timesheet.period2,
            employee_timesheet.employee_timesheet_id,
            patient.patient_id, 
            patient.name as pt_name,
            patient.lastname as pt_lastname,
            patient.firstname as pt_firstname,
            patient.phone,
            patient.CustomFieldCaseNumber,
            patient.CustomFieldSSN,
            patient.DistrictID_Ref,
            patient.JobStartDate,
            patient.JobEndDate,
            employee.EmployeeTypeID_Ref,          
            employee.name as empl_name,
            employee.firstname as empl_firstname,
            employee.lastname as empl_lastname,
            employee.employee_id,
            employee.pin,
            patient.Agency,
            patient.HMKRHours,
            patient.CNAHours,
            patient.LPNHours,
            patient.RNHours
            FROM patient,employee_timesheet,employee  
            WHERE (patient.patient_id = employee_timesheet.patient_id AND employee_timesheet.employee_id = employee.employee_id) AND employee_timesheet.Agency = '$agency_code' AND month = '$month' AND year = '$year'";

        $res = $this->Comman_model->getCustomQueryData($sql);
        $dataCheck1 = true;
        $count = 0;
        $pageData = [];
        foreach ($res as $key => $row) {
            $patient_id = $row['patient_id'];
            $employee_id = $row['employee_id'];

            $period1 = $row['period1'];
            $period2 = $row['period2'];

            $ID = $row['EmployeeTypeID_Ref'];
            $service_type = $ID;

            //$year = '2024';
            //$month = '6';
            $eom = '31';
            $cutoff = '1';
            
            $searchSQL="SELECT * FROM employee_finalsheet WHERE patient_id = '$patient_id'  AND employee_id = '$employee_id' AND Agency = '$agency_code' AND month = '$month' AND year = '$year'";
            $searchResult = get_custom_query_data($searchSQL, 'row');
            if(!empty($searchResult)) {
                $dataCheck = false;    

                $fperiod1 = $searchResult['period1'];
                $fperiod2 = $searchResult['period2'];

                $fpsum = $fperiod1 + $fperiod2;

                $dataArray = [];
                $dataArray['period1'] = $row['period1'];
                $dataArray['period2'] = $row['period2'];

                for ($d=$cutoff; $d<=$eom; $d++) {
                    $col = 'day'.sprintf("%02s", $d);
                    $tbl1 = $row[$col];
                    $tbl2 = $searchResult[$col];

                    if($period==1 && $d<=15) {
                        $dataArray[$col] = $row[$col];

                        if($tbl1!=$tbl2 && $fpsum<1) {
                            $dataCheck = true;  
                            $dataCheck1 = false;
                        }
                    }
                    
                    if($period==2 && $d>=16) {
                        $dataArray[$col] = $row[$col];

                        if($tbl1!=$tbl2 && $fpsum<1) {
                            $dataCheck = true;  
                            $dataCheck1 = false;
                        }
                    }
                                        
                }

                if($dataCheck) {                    
                    $empSql = "SELECT * FROM employee WHERE employee_id = '".$row['employee_id']."'";
                    $empRow = $this->Comman_model->getCustomQueryData($empSql, 'row');

                    $ptSql = "SELECT * FROM patient WHERE patient_id = '".$row['patient_id']."'";
                    $ptRow = $this->Comman_model->getCustomQueryData($ptSql, 'row');

                    $pageData[$key]['employee_finalsheet_id'] = $searchResult['employee_finalsheet_id'];
                    $pageData[$key]['employee_timesheet_id'] = $row['employee_timesheet_id'];
                    $pageData[$key]['employee_name'] = $empRow['name'];
                    $pageData[$key]['employee_id'] = $row['employee_id'];
                    $pageData[$key]['patient_name'] = $ptRow['name'];
                    $pageData[$key]['patient_id'] = $row['patient_id'];

                    if(!empty($dataArray) && $_GET['submit']=='RePost') {
                        $n1 = '';
                        $n2 = '';
                        if($period=='1') {
                            if ($month == 1) {
                                $month2 = 12; 
                                $year2 = $year - 1;
                            } else {
                                $month2 = $month - 1;
                                $year2 = $year;  
                            }

                            $prevSQL = "SELECT note1, note2 FROM employee_finalsheet WHERE employee_finalsheet.patient_id = '$patient_id' AND employee_finalsheet.employee_id = '$employee_id' AND Agency = '$agency_code' AND month = '$month2' AND year = '$year2'  AND service_type = '$service_type'";
                            $prevResult = get_custom_query_data($prevSQL, 'row');
                            if (!empty($prevResult)) {
                                $n1 = $prevResult['note1'];
                                $n2 = $prevResult['note2'];
                                $count1 = substr_count($n1 , '*');
                                $count2 = substr_count($n2 , '*');
                                $note1 = explode('*',$n1);
                                $note2 = explode('*',$n2);
                                if ($note1[1] != '') { $anote1 = "*".$note1[$count1]; } else { $anote1 = ''; }   
                                if ($note2[1] != '') { $anote2 = "*".$note2[$count2]; } else { $anote2 = ''; }   
                            }

                            $dataArray['note1'] = $n2;
                        }
               
                        if($period=='2') {
                            $nowSQL = "SELECT note1, note2 FROM employee_finalsheet WHERE employee_finalsheet.patient_id = '$patient_id' AND employee_finalsheet.employee_id = '$employee_id' AND Agency = '$agency_code' AND month = '$month' AND year = '$year' AND service_type = '$service_type'";
                            $nowResult = get_custom_query_data($nowSQL, 'row');
                            if (!empty($nowResult)) {
                                $n1 = $nowResult['note1'];
                                $n2 = $nowResult['note2'];
                                $count1 = substr_count($n1 , '*');
                                $count2 = substr_count($n2 , '*');
                                $note1 = explode('*',$n1);
                                $note2 = explode('*',$n2);

                                if ($note1[1] != '') { $anote1 = "*".$note1[$count1]; } else { $anote1 = ''; }   
                                if ($note2[1] != '') { $anote2 = "*".$note2[$count2]; } else { $anote2 = ''; }   
                            }

                            $dataArray['note2'] = $n1;
                        }

                        $where = [];
                        $where['employee_finalsheet_id'] = $searchResult['employee_finalsheet_id'];
                        $this->Comman_model->update('employee_finalsheet', $where, $dataArray);
                        $count++;
                    }
                }
            }
        }

        if($_GET['submit']=='RePost') {
            if($count>0) {
                $this->session->set_flashdata('message', $count.' Records has been updated.');    
            } else {
                $this->session->set_flashdata('error_message', 'Oops! no record found to update.');
            }
            
            $url = base_url('tools/checkMissingActivitylogData?month='.$month.'&year='.$year.'&search=search');
            header("location:".$url);
            exit();
        }

        if($dataCheck1) {
            //echo 'Oops! no record found.';
        }    

        if($count>0) {
            //echo '<br>';
            //echo $count.' no. of records found.';
        }

        $data = [];
        $data['month']      = $month;
        $data['year']       = $year;
        $data['pageData']   = $pageData;
        $data['period']     = $period;  

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('tools/hours-mismatch.php',$data);
        $this->load->view('common/footer.php');
    }

    function checkDistance() {
        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('tools/show-distance.php',$data);
        $this->load->view('common/footer.php');    
    }

    function calculateDistance() {
        $origin = $_POST['origin'];
        $destination = $_POST['destination'];
        if(!empty($origin) && !empty($destination)) {
            
            $ch = curl_init();
            $url = "https://maps.googleapis.com/maps/api/distancematrix/json";
            $options = array(
                "origins" => $origin,
                "destinations" => $destination,
                "units" => "imperial",
                "language" => "en-GB",
                "key" => 'AIzaSyB3iE3D6Mksh20jN9n1lYT9Aawul-q97m0'
            );

            $request = $url . "?" . http_build_query( $options );
            
            curl_setopt($ch, CURLOPT_URL, $request);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $output = json_decode(curl_exec($ch));

            curl_close($ch);

            $status = $output->status;

            $cdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->value:0;
            $sdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->text:0;

            $sdistance = number_format(round(($cdistance/1609.34), 1), 2);

            $sdistance = $sdistance.' Miles';

            print_r($sdistance);

            //$distance = $this->getDistance($origin, $destination, '');
            //print_r($distance);
        } else {
            print_r('res_error_1');
        }
    }

    function getDistance($addressFrom, $addressTo, $unit = '') {
        // Google API key
        $apiKey = 'AIzaSyB3iE3D6Mksh20jN9n1lYT9Aawul-q97m0';
        
        // Change address format
        $formattedAddrFrom   = str_replace(' ', '+', $addressFrom);
        $formattedAddrTo     = str_replace(' ', '+', $addressTo);
        
        // Geocoding API request with start address
        $geocodeFrom = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?address='.$formattedAddrFrom.'&sensor=false&key='.$apiKey);
        $outputFrom = json_decode($geocodeFrom);
        if(!empty($outputFrom->error_message)){
            return $outputFrom->error_message;
        }
        
        // Geocoding API request with end address
        $geocodeTo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?address='.$formattedAddrTo.'&sensor=false&key='.$apiKey);
        $outputTo = json_decode($geocodeTo);
        if(!empty($outputTo->error_message)){
            return $outputTo->error_message;
        }
        
        // Get latitude and longitude from the geodata
        $latitudeFrom    = $outputFrom->results[0]->geometry->location->lat;
        $longitudeFrom    = $outputFrom->results[0]->geometry->location->lng;
        $latitudeTo        = $outputTo->results[0]->geometry->location->lat;
        $longitudeTo    = $outputTo->results[0]->geometry->location->lng;
        
        // Calculate distance between latitude and longitude
        $theta   = $longitudeFrom - $longitudeTo;
        $dist    = sin(deg2rad($latitudeFrom)) * sin(deg2rad($latitudeTo)) +  cos(deg2rad($latitudeFrom)) * cos(deg2rad($latitudeTo)) * cos(deg2rad($theta));
        $dist    = acos($dist);
        $dist    = rad2deg($dist);
        $miles   = $dist * 60 * 1.1515;
        
        // Convert unit and return distance
        $unit = strtoupper($unit);
        if($unit == "K") {
            return round($miles * 1.609344, 2).' km';
        } elseif($unit == "M") {
            return round($miles * 1609.344, 2).' meters';
        } else {
            return round($miles, 2).' miles';
        }
    }
}