<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class WebService extends CI_Controller
{
    
    public function __construct()
    {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->library('session');
        $this->load->database('');
        $this->load->library('form_validation');
        
        $this->load->library('image_lib');
        $this->load->model('Api_model');
        $this->load->model('Comman_model');
        //Reminders Functions
        
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    }
    
    public function index()
    {
        echo "Hello";
    }
    /*Use Sign in for staff*/
    public function login()
    {
        $staff_number      = $this->input->post('staff_number', TRUE);
        $primary_phone_num = $this->input->post('primary_phone_num', TRUE);
        $password          = $this->input->post('password', TRUE);
        $device_type       = $this->input->post('device_type', TRUE);
        $device_token      = $this->input->post('device_token', TRUE);
        $country_code      = $this->input->post('country_code', TRUE);

        $getdata = $this->Api_model->getSingleRow('staff', array(
            'staff_number' => $staff_number,
            'primary_phone_num' => $primary_phone_num,
            'password' => $password,
            'country_code' => $country_code
        ));
        
        if ($getdata) {
            if ($getdata->status == 1) {
                if ($getdata->image) {
                    $getdata->image = $this->config->base_url() . $getdata->image;
                } else {
                    $getdata->image = $this->config->base_url() . 'assets/images/dummyuser.png';
                }
                $data = array(
                    'device_type' => strtolower($device_type),
                    'device_token' => $device_token
                );
                $this->Api_model->updateSingleRow("staff", array(
                    'staff_number' => $staff_number
                ), $data);
                $this->Api_model->responseSuccess(1, "Login successfully.", $getdata);
            }
        } else {
            $this->Api_model->responseFailed(0, "Please enter your valid details");
            
        }
    }

    //   /*Use Sign in for staff*/
    // public function loginForStaff()
    // {
    //     $staff_number      = $this->input->post('staff_number', TRUE);
    //     $primary_phone_num = $this->input->post('primary_phone_num', TRUE);
    //     $password          = $this->input->post('password', TRUE);
    //     $device_type       = $this->input->post('device_type', TRUE);
    //     $device_token      = $this->input->post('device_token', TRUE);
    //     $country_code      = $this->input->post('country_code', TRUE);
        
    //     $getdata = $this->Api_model->getSingleRow('staff', array(
    //         'staff_number' => $staff_number,
    //         'primary_phone_num' => $primary_phone_num,
    //         'password' => $password,
    //         'country_code'=> $country_code

    //     ));
        
    //     if ($getdata) {
    //         if ($getdata->status == 1) {
    //             if ($getdata->image) {
    //                 $getdata->image = $this->config->base_url() . $getdata->image;
    //             } else {
    //                 $getdata->image = $this->config->base_url() . 'assets/images/dummyuser.png';
    //             }
    //             $data = array(
    //                 'device_type' => strtolower($device_type),
    //                 'device_token' => $device_token
    //             );
    //             $this->Api_model->updateSingleRow("staff", array(
    //                 'staff_number' => $staff_number
    //             ), $data);
    //             $this->Api_model->responseSuccess(1, "Login successfully.", $getdata);
    //         }
    //     } else {
    //         $this->Api_model->responseFailed(0, "Please enter your valid details");
            
    //     }
    // }

    
    /*Use update profile for staff*/
    public function loginEdit()
    {
        $staff_id            = $this->input->post('staff_id', TRUE);
        $first_name          = $this->input->post('first_name', TRUE);
        $middle_name         = $this->input->post('middle_name', TRUE);
        $last_name           = $this->input->post('last_name', TRUE);
        $primary_phone_num   = $this->input->post('primary_phone_num', TRUE);
        $secondary_phone_num = $this->input->post('secondary_phone_num', TRUE);
        $email               = $this->input->post('email', TRUE);
        $local_address       = $this->input->post('local_address', TRUE);
        $permanent_address   = $this->input->post('permanent_address', TRUE);
        $city                = $this->input->post('city', TRUE);
        $state               = $this->input->post('state', TRUE);
        $qualifications      = $this->input->post('qualifications', TRUE);
        $date_of_birth       = $this->input->post('date_of_birth', TRUE);
        if ($staff_id != '' || $staff_id != NULL) {
            $table     = 'staff';
            $condition = array(
                'staff_id' => $staff_id
            );
            
            $getdata = $this->Api_model->getSingleRow($table, $condition);
            if ($getdata) {
                if ($getdata->status == 1) {
                    $this->load->library('upload');
                    $config['upload_path']   = './assets/images/staff/';
                    $config['allowed_types'] = '*';
                    $config['max_size']      = 1000000;
                    $config['file_name']     = time();
                    $this->upload->initialize($config);
                    $profileimage = "";
                    if ($this->upload->do_upload('image')) {
                        $profileimage = 'assets/images/staff/' . $this->upload->data('file_name');
                    } else {
                        
                    }
                    
                    if ($profileimage) {
                        $data['image'] = $profileimage;
                    }
                    
                    $data['first_name']          = $first_name;
                    $data['middle_name']         = $middle_name;
                    $data['last_name']           = $last_name;
                    $data['primary_phone_num']   = $primary_phone_num;
                    $data['secondary_phone_num'] = $secondary_phone_num;
                    $data['email']               = $email;
                    $data['local_address']       = $local_address;
                    $data['permanent_address']   = $permanent_address;
                    $data['city']                = $city;
                    $data['state']               = $state;
                    $data['qualifications']      = $qualifications;
                    $data['date_of_birth']       = $date_of_birth;
                    
                    
                    $this->Api_model->updateSingleRow($table, array(
                        'staff_id' => $staff_id
                    ), $data);
                    $getdata        = $this->Api_model->getSingleRow($table, array(
                        'staff_id' => $staff_id
                    ));
                    $getdata->image = $this->config->base_url() . $getdata->image;
                    $this->Api_model->responseSuccess(1, UPDATE_PROFILE, $getdata);
                } else {
                    $this->Api_model->responseFailed(3, INACTIVATE);
                }
            } else {
                $this->Api_model->responseFailed(0, PROFILE_UPDATE_FAILED);
            }
        } else {
            $this->Api_model->responseFailed(0, NOT_RESPONDING);
        }
    }
    
    
    /*Use Sign in for parent*/
    public function loginSP()
    {
        $parent_number     = $this->input->post('parent_number', TRUE);
        $primary_phone_num = $this->input->post('primary_phone_num', TRUE);
        $password          = $this->input->post('password', TRUE);
        $device_type       = $this->input->post('device_type', TRUE);
        $device_token      = $this->input->post('device_token', TRUE);
        $country_code      = $this->input->post('country_code', TRUE);
        
        $getdata = $this->Api_model->getSingleRow('parent', array(
            'parent_number' => $parent_number,
            'primary_phone_num' => $primary_phone_num,
            'password' => $password,
            'country_code' => $country_code

        ));
        
        if ($getdata) {
            
            $getdata1 = $this->Api_model->getSingleRow('student', array(
                'parent_id' => $getdata->parent_id
            ));
            $getdata2 = $this->Api_model->getSingleRow('class', array(
                'class_id' => $getdata1->class_id
            ));
            
            if ($getdata) {
                if ($getdata->status == 1) {
                    
                    $getdata->student_id = $getdata1->student_id;
                    $getdata->class_id   = $getdata2->class_id;
                    $getdata->class_name = $getdata2->class_name;
                    
                    if ($getdata->image) {
                        $getdata->image = $this->config->base_url() . $getdata->image;
                    } else {
                        $getdata->image = $this->config->base_url() . 'assets/images/dummyuser.png';
                    }
                    $data = array(
                        'device_type' => strtolower($device_type),
                        'device_token' => $device_token
                    );
                    $this->Api_model->updateSingleRow("parent", array(
                        'parent_number' => $parent_number
                    ), $data);
                    $this->Api_model->responseSuccess(1, "Login successfully.", $getdata);
                    
                }
            }
        } else {
            $this->Api_model->responseFailed(0, "Please enter your valid details");
            
        }
    }
    
    //  /*Use Sign in for parent*/
    // public function loginParent()
    // {
    //     $parent_number     = $this->input->post('parent_number', TRUE);
    //     $primary_phone_num = $this->input->post('primary_phone_num', TRUE);
    //     $password          = $this->input->post('password', TRUE);
    //     $device_type       = $this->input->post('device_type', TRUE);
    //     $device_token      = $this->input->post('device_token', TRUE);
    //     $country_code      = $this->input->post('country_code', TRUE);
        
    //     $getdata = $this->Api_model->getSingleRow('parent', array(
    //         'parent_number' => $parent_number,
    //         'primary_phone_num' => $primary_phone_num,
    //         'password' => $password,
    //         'country_code'=>$country_code
    //     ));
        
    //     if ($getdata) {
            
    //         $getdata1 = $this->Api_model->getSingleRow('student', array(
    //             'parent_id' => $getdata->parent_id
    //         ));
    //         $getdata2 = $this->Api_model->getSingleRow('class', array(
    //             'class_id' => $getdata1->class_id
    //         ));
            
    //         if ($getdata) {
    //             if ($getdata->status == 1) {
                    
    //                 $getdata->student_id = $getdata1->student_id;
    //                 $getdata->class_id   = $getdata2->class_id;
    //                 $getdata->class_name = $getdata2->class_name;
                    
    //                 if ($getdata->image) {
    //                     $getdata->image = $this->config->base_url() . $getdata->image;
    //                 } else {
    //                     $getdata->image = $this->config->base_url() . 'assets/images/dummyuser.png';
    //                 }
    //                 $data = array(
    //                     'device_type' => strtolower($device_type),
    //                     'device_token' => $device_token
    //                 );
    //                 $this->Api_model->updateSingleRow("parent", array(
    //                     'parent_number' => $parent_number
    //                 ), $data);
    //                 $this->Api_model->responseSuccess(1, "Login successfully.", $getdata);
                    
    //             }
    //         }
    //     } else {
    //         $this->Api_model->responseFailed(0, "Please enter your valid details");
            
    //     }
    // }
    
    /*Use update profile for parent*/
    public function loginSPEdit()
    {
        $parent_id           = $this->input->post('parent_id', TRUE);
        $father_name         = $this->input->post('father_name', TRUE);
        $mother_name         = $this->input->post('mother_name', TRUE);
        $primary_phone_num   = $this->input->post('primary_phone_num', TRUE);
        $secondary_phone_num = $this->input->post('secondary_phone_num', TRUE);
        $email               = $this->input->post('email', TRUE);
        $local_address       = $this->input->post('local_address', TRUE);
        $permanent_address   = $this->input->post('permanent_address', TRUE);
        
        
        if ($parent_id != '' || $parent_id != NULL) {
            $table     = 'parent';
            $condition = array(
                'parent_id' => $parent_id
            );
            
            $getdata = $this->Api_model->getSingleRow($table, $condition);
            if ($getdata) {
                $getdata1 = $this->Api_model->getSingleRow('student', array(
                    'parent_id' => $getdata->parent_id
                ));
                $class_id = $getdata1->class_id;
                
                
                
                if ($getdata->status == 1) {
                    $this->load->library('upload');
                    $config['upload_path']   = './assets/images/parent/';
                    $config['allowed_types'] = '*';
                    $config['max_size']      = 1000000;
                    $config['file_name']     = time();
                    $this->upload->initialize($config);
                    $profileimage = "";
                    if ($this->upload->do_upload('image')) {
                        $profileimage = 'assets/images/parent/' . $this->upload->data('file_name');
                    } else {
                        
                    }
                    
                    if ($profileimage) {
                        $data['image'] = $profileimage;
                    }
                    
                    $data['father_name']         = $father_name;
                    $data['mother_name']         = $mother_name;
                    $data['primary_phone_num']   = $primary_phone_num;
                    $data['secondary_phone_num'] = $secondary_phone_num;
                    $data['email']               = $email;
                    $data['local_address']       = $local_address;
                    $data['permanent_address']   = $permanent_address;
                    
                    
                    $this->Api_model->updateSingleRow($table, array(
                        'parent_id' => $parent_id
                    ), $data);
                    $getdata        = $this->Api_model->getSingleRow($table, array(
                        'parent_id' => $parent_id
                    ));
                    $getdata->image = $this->config->base_url() . $getdata->image;
                    $getdata2       = $this->Api_model->getSingleRow('class', array(
                        'class_id' => $class_id
                    ));
                    
                    $getdata->student_id = $getdata1->student_id;
                    $getdata->class_id   = $getdata2->class_id;
                    $getdata->class_name = $getdata2->class_name;
                    $this->Api_model->responseSuccess(1, UPDATE_PROFILE, $getdata);
                } else {
                    $this->Api_model->responseFailed(3, INACTIVATE);
                }
            } else {
                $this->Api_model->responseFailed(0, PROFILE_UPDATE_FAILED);
            }
        } else {
            $this->Api_model->responseFailed(0, NOT_RESPONDING);
        }
    }
    
    /*Use Sign in for Student*/
    public function StudentLogin()
    {
        $parent_id = $this->input->post('parent_id', TRUE);
        
        $getdata1 = $this->Api_model->getSingleRow('student', array(
            'parent_id' => $parent_id
        ));
        $getdata2 = $this->Api_model->getSingleRow('class', array(
            'class_id' => $getdata1->class_id
        ));
        
        if ($getdata1) {
            
            $getdata1->student_id = $getdata1->student_id;
            $getdata1->class_id   = $getdata2->class_id;
            $getdata1->class_name = $getdata2->class_name;
            
            if ($getdata1->image) {
                $getdata1->image = $this->config->base_url() . $getdata1->image;
            } else {
                $getdata1->image = $this->config->base_url() . 'assets/images/dummyuser.png';
            }
            
            $this->Api_model->responseSuccess(1, " Student Login successfully.", $getdata1);
            
        } else {
            $this->Api_model->responseFailed(0, "No Record Found");
            
        }
    }
    
    
    /*get ticket(support section) info*/
    public function getTicket()
    {
        $user_id = $this->input->post('user_id', TRUE);
        $role    = $this->input->post('role', TRUE);
        
        $get_ticket = $this->Api_model->getAllDataWhere(array(
            'user_id' => $user_id,
            'role' => $role
        ), "ticket");
        if ($get_ticket) {
            $this->Api_model->responseSuccess(1, "Get my support.", $get_ticket);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any support.");
        }
    }
    
    /*genrate or add ticket(support section) info*/
    public function generateTicket()
    {
        $data['user_id']    = $this->input->post('user_id', TRUE);
        $data['role']       = $this->input->post('role', TRUE);
        $data['reason']     = $this->input->post('reason', TRUE);
        $data['title']      = $this->input->post('title', TRUE);
        $data['craeted_at'] = time();
        // $datas['status'] = '1';
        
        
        $user_id = $this->Api_model->insertGetId('ticket', $data);
        if ($user_id) {
            $datas['user_id']    = $user_id;
            $datas['role']       = $data['role'];
            $datas['title']      = $data['title'];
            $datas['reason']     = $data['reason'];
            $datas['created_at'] = time();
            $datas['status']     = '1';
            
            $this->Api_model->responseFailed(1, "GENRATE MY TICKET");
        } else {
            $this->Api_model->responseFailed(0, NO_DATA);
        }
    }
    
    /*Use to get All Subjects */
    public function getAllSubject()
    {
        $data = $this->Api_model->getAllData("subject");
        
        if ($data) {
            
            
            $this->Api_model->responseSuccess(1, "Get All Subjects", $data);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any subject");
        }
    }
    
    /*Use to get All Subjects By Class*/
    public function getAllSubjectByClass()
    {
        
        $class_id = $this->input->post('class_id');
        
        $data = $this->Api_model->getAllDataWhere(array(
            'class_id' => $class_id
        ), "class_subject_combination");
        
        
        $dataa = array();
        foreach ($data as $data) {
            $get_subject = $this->Api_model->getSingleRow('subject', array(
                'subject_id' => $data->subject_id
            ));
            
            $data->subject_id   = $get_subject->subject_id;
            $data->subject_name = $get_subject->subject_name;
            
            array_push($dataa, $data);
        }
        if ($dataa) {
            
            $this->Api_model->responseSuccess(1, "Get All Subject", $dataa);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Subject");
        }
    }
    
    /*Use to get All Subjects By Staff*/
    public function getSubjectByStaff()
    {
        
        $staff_id = $this->input->post('staff_id');
        $class_id = $this->input->post('class_id');
        
        $data = $this->Api_model->getAllDataWhere(array(
            'staff_id' => $staff_id,
            'class_id' => $class_id
        ), "staff_schedule");
        
        
        $dataa = array();
        foreach ($data as $data) {
            
            $get_staff = $this->Api_model->getSingleRow('staff', array(
                'staff_id' => $staff_id
            ));
            
            $get_class = $this->Api_model->getSingleRow('class', array(
                'class_id' => $class_id
            ));
            
            $get_subject = $this->Api_model->getSingleRow('subject', array(
                'subject_id' => $data->subject_id
            ));
            
            
            $data->first_name   = $get_staff->first_name;
            $data->middle_name  = $get_staff->middle_name;
            $data->last_name    = $get_staff->last_name;
            $data->class_name   = $get_class->class_name;
            $data->subject_name = $get_subject->subject_name;
            
            
            array_push($dataa, $data);
        }
        if ($dataa) {
            
            $this->Api_model->responseSuccess(1, "Get All Subject", $dataa);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Subject");
        }
    }
    
    
    /*Use to get All Class*/
    public function getAllClass()
    {
        
        $data = $this->Api_model->getAllData("class");
        
        if ($data) {
            
            
            $this->Api_model->responseSuccess(1, "Get All Class", $data);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any class");
        }
    }
    
    /*Use to get All Class By Staff*/
    public function getAllClassByStaff()
    {
        
        $staff_id = $this->input->post('staff_id');
        
        $data = $this->Api_model->getAllDataWhere(array(
            'staff_id' => $staff_id
        ), "staff_class");
        
        
        $dataa = array();
        foreach ($data as $data) {
            
            $get_staff = $this->Api_model->getSingleRow('staff', array(
                'staff_id' => $staff_id
            ));
            
            $get_class = $this->Api_model->getSingleRow('class', array(
                'class_id' => $data->class_id
            ));
            
            $data->first_name  = $get_staff->first_name;
            $data->middle_name = $get_staff->middle_name;
            $data->last_name   = $get_staff->last_name;
            $data->class_name  = $get_class->class_name;
            
            array_push($dataa, $data);
        }
        if ($dataa) {
            
            $this->Api_model->responseSuccess(1, "Get All Class", $dataa);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Class");
        }
    }
    
    
    /*Use to get All Student*/
    public function getAllStudent()
    {
        
        $class_id = $this->input->post('class_id');
        
        $data = $this->Api_model->getAllDataWhere(array(
            'class_id' => $class_id
        ), "student");
        
        
        if ($data) {
            $dataa = array();
            foreach ($data as $data) {
                $parent_id                 = $data->parent_id;
                $get_class                 = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $data->class_id
                ));
                $data->class_name          = $get_class->class_name;
                $get_parent                = $this->Api_model->getSingleRow('parent', array(
                    'parent_id' => $parent_id
                ));
                $data->father_name         = $get_parent->father_name;
                $data->mother_name         = $get_parent->mother_name;
                $data->primary_phone_num   = $get_parent->primary_phone_num;
                $data->secondary_phone_num = $get_parent->secondary_phone_num;
                
                if ($data) {
                    
                    $data->image = $this->config->base_url() . $data->image;
                }
                
                array_push($dataa, $data);
            }
            
            $this->Api_model->responseSuccess(1, "Get All Students", $dataa);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Student");
        }
    }
    
    
    /*Use to get All Student By Staff*/
    public function getAllStudentByStaff()
    {
        $staff_id = $this->input->post('staff_id');
        
        $data = $this->Api_model->getAllDataWhere(array(
            'staff_id' => $staff_id
        ), "staff_class");
        
        
        $dataa = array();
        foreach ($data as $staffdata) {
            $class_id = $staffdata->class_id;
            
            $data1     = $this->Api_model->getAllDataWhere(array(
                'class_id' => $class_id
            ), "student");
            $get_class = $this->Api_model->getSingleRow('class', array(
                'class_id' => $class_id
            ));
            
            $studentData = array();
            foreach ($data1 as $data) {
                $data11             = $data;
                $data11->image      = $this->config->base_url() . $data11->image;
                $data11->class_name = $get_class->class_name;
                array_push($dataa, $data11);
            }
            
        }
        if ($dataa) {
            
            $this->Api_model->responseSuccess(1, "Get All Student", $dataa);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Student");
        }
    }
    
    /*Use to get All Students By Session*/
    public function getAllStudentBySession()
    {
        
        $session_id = $this->input->post('session_id');
        
        $data = $this->Api_model->getAllDataWhere(array(
            'session_id' => $session_id
        ), "student");
        
        if ($data) {
            $dataa = array();
            foreach ($data as $data) {
                if ($data) {
                    
                    $data->image = $this->config->base_url() . $data->image;
                }
                
                array_push($dataa, $data);
            }
            
            $this->Api_model->responseSuccess(1, "Get All Students By Session", $dataa);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Student");
        }
    }
    
    /*Use to get Single Student By Session*/
    public function getSingleStudentBySession()
    {
        
        $session_id = $this->input->post('session_id');
        $student_id = $this->input->post('student_id');
        
        $data = $this->Api_model->getAllDataWhere(array(
            'session_id' => $session_id,
            'student_id' => $student_id
        ), "student");
        
        if ($data) {
            $dataa = array();
            foreach ($data as $data) {
                if ($data) {
                    
                    $data->image = $this->config->base_url() . $data->image;
                }
                
                array_push($dataa, $data);
            }
            
            $this->Api_model->responseSuccess(1, "Get All Students By Session", $dataa);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Student");
        }
    }
    
    
    /*Use to get All Staff*/
    public function getAllStaff()
    {
        
        $data = $this->Api_model->getAllData("staff");
        
        if ($data) {
            
            
            $this->Api_model->responseSuccess(1, "Get All staff", $data);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any staff");
        }
    }
    
    /*Use to Add post grade info(subject report) of single student by staff*/
    public function postGrade()
    {
        
        $getData = json_decode(file_get_contents('php://input'), true);
        $subject = $getData['subject'];
        foreach ($subject as $subject) {
            
            $get_student = $this->Api_model->getSingleRow('student', array(
                'student_id' => $subject['student_id']
            ));
            
            $subject['session_id']  = $get_student->session_id;
            $subject['create_date'] = time();
            $subject['update_date'] = time();
            $subject['status']      = '1';
            $getUserId              = $this->Api_model->insertGetId('result', $subject);
            
        }
        $this->Api_model->responseFailed(1, "Add successfully");
        
    }
    
    /*Use to get post grade info(subject report) of single student by staff*/
    public function getPostGrade()
    {
        
        $student_id = $this->input->post('student_id');
        $session_id = $this->input->post('session_id');
        $get_report = $this->Api_model->getAllDataWhere(array(
            'student_id' => $student_id,
            'session_id' => $session_id
        ), "result");
        
        $getreport = array();
        foreach ($get_report as $get_report) {
            
            
            $get_student = $this->Api_model->getSingleRow('student', array(
                'student_id' => $get_report->student_id
            ));
            
            
            $get_subject = $this->Api_model->getSingleRow('subject', array(
                'subject_id' => $get_report->subject_id
            ));
            
            
            $get_class = $this->Api_model->getSingleRow('class', array(
                'class_id' => $get_report->class_id
            ));
            
            
            $get_report->first_name   = $get_student->first_name;
            $get_report->middle_name  = $get_student->middle_name;
            $get_report->last_name    = $get_student->last_name;
            $get_report->subject_name = $get_subject->subject_name;
            $get_report->class_name   = $get_class->class_name;
            array_push($getreport, $get_report);
        }
        
        if ($getreport) {
            
            $this->Api_model->responseSuccess(1, "Get Post Grade info", $getreport);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any Post Grade Info");
        }
    }
    
    
    // /*Use to get post grade info(subject report) of single student by staff*/
    // public function getResult()
    // {
    //     $student_id = $this->input->post('student_id');
    //     $staff_id   = $this->input->post('staff_id');
        
    //     $get_report = $this->Api_model->getAllDataWhere(array(
    //         'student_id' => $student_id,
    //         'staff_id' => $staff_id
    //     ), "result");
    //     if ($get_report) {
    //         $getreport = array();
    //         foreach ($get_report as $get_report) {
                
    //             $get_student = $this->Api_model->getSingleRow('student', array(
    //                 'student_id' => $get_report->student_id
    //             ));
                
                
    //             $get_subject = $this->Api_model->getSingleRow('subject', array(
    //                 'subject_id' => $get_report->subject_id
    //             ));
                
                
    //             $get_class                = $this->Api_model->getSingleRow('class', array(
    //                 'class_id' => $get_report->class_id
    //             ));
    //             $get_report->first_name   = $get_student->first_name;
    //             $get_report->middle_name  = $get_student->middle_name;
    //             $get_report->last_name    = $get_student->last_name;
    //             $get_report->subject_name = $get_subject->subject_name;
    //             $get_report->class_name   = $get_class->class_name;
    //             array_push($getreport, $get_report);
    //         }
    //         if ($getreport) {
    //             $this->Api_model->responseSuccess(1, "Get Post Grade info", $getreport);
    //         } else {
    //             $this->Api_model->responseFailed(0, "Not yet any Post Grade Info");
    //         }
    //     }
        
    //     else {
            
    //         $get_student = $this->Api_model->getSingleRow('student', array(
    //             'student_id' => $student_id
    //         ));
    //         if ($get_student) {
                
    //             $class = $get_student->class_id;
                
    //             $getSubject = $this->Api_model->getAllDataWhere(array(
    //                 'staff_id' => $staff_id,
    //                 'class_id' => $class
    //             ), "staff_schedule");
              

    //             if ($getSubject) {
    //                 foreach ($getSubject as $getSubject) {
    //                     $subject_name        = $this->Api_model->getSingleRow("subject", array(
    //                         'subject_id' => $getSubject->subject_id
    //                     ));
    //                     $data['class_id']    = $class;
    //                     $data['staff_id']    = $staff_id;
    //                     $data['subject_id']  = $getSubject->subject_id;
    //                     $data['student_id']  = $student_id;
    //                     $data['session_id']  = $get_student->session_id;
    //                     $data['marks']       = "0";
    //                     $data['assignment']  = "0";
    //                     $data['assignment1'] = "0";
    //                     $data['lab']         = "0";
    //                     $data['project']     = "0";
    //                     $data['total']       = "0";
    //                     $data['out_of']      = "100";
    //                     $data['grade']       = "0";
    //                     $data['comment']     = "Fail";
    //                     $data['create_date'] = time();
    //                     $data['update_date'] = time();
    //                     $data['status']      = 1;
    //                     $result_insert       = $this->Api_model->insert('result', $data);
    //                     if ($result_insert) {
                            
    //                         $get_report = $this->Api_model->getAllDataWhere(array(
    //                             'student_id' => $student_id,
    //                             'staff_id' => $staff_id
    //                         ), "result");
                            
    //                         $getreport = array();
    //                         foreach ($get_report as $get_report) {
                                
    //                             $get_student = $this->Api_model->getSingleRow('student', array(
    //                                 'student_id' => $get_report->student_id
    //                             ));
                                
                                
    //                             $get_subject = $this->Api_model->getSingleRow('subject', array(
    //                                 'subject_id' => $get_report->subject_id
    //                             ));
                                
                                
    //                             $get_class                = $this->Api_model->getSingleRow('class', array(
    //                                 'class_id' => $get_report->class_id
    //                             ));
    //                             $get_report->first_name   = $get_student->first_name;
    //                             $get_report->middle_name  = $get_student->middle_name;
    //                             $get_report->last_name    = $get_student->last_name;
    //                             $get_report->subject_name = $get_subject->subject_name;
    //                             $get_report->class_name   = $get_class->class_name;
    //                             array_push($getreport, $get_report);
    //                         }
                            
                            
    //                     }
                        
    //                 }
    //                 if ($getreport) {
                        
    //                     $this->Api_model->responseSuccess(1, "Get Post Grade info", $getreport);
    //                 } else {
    //                     $this->Api_model->responseFailed(0, "Not yet any Post Grade Info");
    //                 }
                    
    //             } else {
    //                 $this->Api_model->responseFailed(0, "Staff Id Does not Exist");
    //             }
                
    //         } else {
    //             $this->Api_model->responseFailed(0, "Student Id Does not Exist");
                
    //         }
    //     }
        
    // }
    
    
    /*Use to Update post grade info(subject report) of single student by staff*/
    public function PostGradeUpdate()
    {
        
        $getData = json_decode(file_get_contents('php://input'), true);
        
        $subject = $getData['subject'];
        
        foreach ($subject as $subject) {
            
            $get_student = $this->Api_model->getSingleRow('result', array(
                'student_id' => $subject['student_id'],
                'session_id' => $subject['session_id']
            ));
            if ($get_student) {
                
                $subject['session_id'] = $get_student->session_id;
                
                $subject['update_date'] = time();
                
                $getUserId = $this->Api_model->updateId('result', array(
                    'student_id' => $subject['student_id'],
                    'session_id' => $subject['session_id'],
                    'subject_id' => $subject['subject_id']
                ), $subject);
            }
        }
        $this->Api_model->responseFailed(1, "update successfully");
        
    }
    
    
    // result check /////#####################################
    public function ResultChecker()
    {
        $getData = json_decode(file_get_contents('php://input'), true);
        $subject = $getData['subject'];
        foreach ($subject as $subject) {
            $get_student = $this->Api_model->getSingleRow('result', array(
                'student_id' => $subject['student_id'],
                'session_id' => $subject['session_id']
                // 'subject_id' => $subject['subject_id']
            ));
            if ($get_student) {
                
                $subject['session_id']  = $get_student->session_id;
                $subject['update_date'] = time();
                
                $getUserId = $this->Api_model->updateId('result', array(
                    'student_id' => $subject['student_id'],
                    'session_id' => $subject['session_id']
                    // 'subject_id' => $subject['subject_id']
                ), $subject);
                
            } else {
                $data = $this->Api_model->result($subject['staff_id'], $subject['class_id']);
                if ($data) {
                    
                    $this->Api_model->responseSuccess(1, "Get All Subject", $data);
                } else {
                    $this->Api_model->responseFailed(0, "Not yet any Subject");
                }
                
                $get_student            = $this->Api_model->getSingleRow('student', array(
                    'student_id' => $subject['student_id']
                ));
                $subject['session_id']  = $get_student->session_id;
                $subject['create_date'] = time();
                $subject['update_date'] = time();
                $subject['status']      = '1';
                $getUserId              = $this->Api_model->insertGetId('result', $subject);
            }
            
        }
        $this->Api_model->responseSuccess(1, "Updated successfully", $subject);
    }
    
    
    // result check /////#####################################
    public function ResultCheckerWithData()
    {
        $student_id = $this->input->post('student_id');
        $staff_id   = $this->input->post('staff_id');
        
        $get_report = $this->Api_model->getAllDataWhere(array(
            'student_id' => $student_id,
            'staff_id' => $staff_id
        ), "result");
        
        if ($get_report) {
            
            foreach ($get_report as $getreport) {
                $getUserId = $this->Api_model->updateId('result', array(
                    'student_id' => $getreport->student_id,
                    'session_id' => $getreport->session_id,
                    'subject_id' => $getreport->subject_id,
                    'staff_id' => $getreport->staff_id
                ), $getreport);
            }
            $this->Api_model->responseFailed(0, "Update successfully");
            
        } else {
            
            $get_student = $this->Api_model->getSingleRow('student', array(
                'student_id' => $student_id
                
            ));
            
            $class      = $get_student->class_id;
            $getSubject = $this->Api_model->getAllDataWhere(array(
                'staff_id' => $staff_id,
                'class_id' => $class
            ), "staff_schedule");
            
            foreach ($getSubject as $getSubject) {
                $subject_name = $this->Api_model->getSingleRow("subject", array(
                    'subject_id' => $getSubject->subject_id
                ));
                
                $data1['subject_name'] = $subject_name->subject_name;
                $data1['class_id']     = $class;
                $data1['staff_id']     = $staff_id;
                $data1['subject_id']   = $getSubject->subject_id;
                $data1['student_id']   = $student_id;
                $data1['session_id']   = $get_student->session_id;
                $data1['marks']        = "0";
                $data1['assignment']   = "0";
                $data1['assignment1']  = "0";
                $data1['lab']          = "0";
                $data1['project']      = "0";
                $data1['total']        = "0";
                $data1['out_of']       = "0";
                $data1['grade']        = "0";
                $data1['comment']      = "Fail";
                $data1['create_date']  = time();
                $data1['update_date']  = time();
                $data1['status']       = 1;
                
                // print_r($get_student->session_id);
                // exit();
                //get all subject
                $data['class_id']    = $class;
                $data['staff_id']    = $staff_id;
                $data['subject_id']  = $getSubject->subject_id;
                $data['student_id']  = $student_id;
                $data['session_id']  = $get_student->session_id;
                $data['marks']       = "0";
                $data['assignment']  = "0";
                $data['assignment1'] = "0";
                $data['lab']         = "0";
                $data['project']     = "0";
                $data['total']       = "0";
                $data['out_of']      = "0";
                $data['grade']       = "0";
                $data['comment']     = "Fail";
                $data['create_date'] = time();
                $data['update_date'] = time();
                $data['status']      = 1;
                $result_insert       = $this->Api_model->insert('result', $data);
                $this->Api_model->responseSuccess(1, "Insert Data", $data1);
                
                
            }
        }
        
        
        //ending of public   
    }
    // public function exam()
    // {
        
    //     $student_id = $this->input->post('student_id');
        
    //     $get_exam = $this->Api_model->getAllDataWhere(array(
    //         'student_id' => $student_id
    //     ), "result");
        
    //     $get_exam1 = $this->Api_model->getSumWithWhere('total', 'result', (array(
    //         'student_id' => $student_id
    //     )));

    //     $get_exam2 = $this->Api_model->getSumWithWhere('out_of', 'result', (array(
    //         'student_id' => $student_id
    //     )));
            
    //            $getexam = array();
    //         foreach ($get_exam as $get_exam) {
            
            
    //         $get_subject = $this->Api_model->getSingleRow('subject', array(
    //             'subject_id' => $get_exam->subject_id
    //         ));
            
    //         $get_exam->subject_name = $get_subject->subject_name;
    //         // print_r($get_exam->subject_name);
    //         //  print_r($get_subject->subject_name);
    //         // exit();
            
    //         $get_exam->all_total   = $get_exam1->total;
    //         $get_exam->all_out_of  = $get_exam2->out_of;
    //         $get_exam->get_percent = ($get_exam->all_total / $get_exam->all_out_of) * 100;
    //         $get_exam->get_cgpa    = round($get_exam->get_percent / 9.5, 2);
            
    //         if ($get_exam->get_cgpa > 9) {
    //             $get_exam->get_grade = 'A+';
    //         } else if ($get_exam->get_cgpa > 8) {
    //             $get_exam->get_grade = 'A';
    //         } else if ($get_exam->get_cgpa > 7) {
    //             $$get_exam->get_grade = 'B+';
    //         } else if ($get_exam->get_cgpa > 6) {
    //             $get_exam->get_grade = 'B';
    //         } else if ($get_exam->get_cgpa > 5) {
    //             $get_exam->get_grade = 'c+';
    //         } else if ($get_exam->get_cgpa > 4) {
    //             $get_exam->get_grade = 'c';
    //         } else {
    //             $get_exam->get_grade = 'Fail';
    //         }
    //             // $getexam['all_total'] = $get_exam1->total;
    //             // $getexam['all_out_of'] = $get_exam2->out_of;
    //             // $getexam['get_percent']= ($get_exam->all_total / $get_exam->all_out_of) * 100;
    //             // $getexam['get_cgpa']   = round($get_exam->get_percent / 9.5, 2);
    //         array_push($getexam, $get_exam);
    //     }
    //      if ($getexam) {
            
    //         // $this->Api_model->responseSuccess(1, "Get exam info", $getexam);

    //         $this->Api_model->responseSuccess(1, "Get exam info", $getexam );
    //     } else {
    //         $this->Api_model->responseFailed(0, "Not yet any exam.");
    //     }
    // }
    
        public function exam()
    {
        
        $student_id = $this->input->post('student_id');
        
        $get_exam = $this->Api_model->getAllDataWhere(array(
            'student_id' => $student_id
        ), "result");
        
        $get_exam1 = $this->Api_model->getSumWithWhere('total', 'result', (array(
            'student_id' => $student_id
        )));

        $get_exam2 = $this->Api_model->getSumWithWhere('out_of', 'result', (array(
            'student_id' => $student_id
        )));
            
               $getexam = array();
            foreach ($get_exam as $get_exam) {
            
            
            $get_subject = $this->Api_model->getSingleRow('subject', array(
                'subject_id' => $get_exam->subject_id
            ));
            
            $get_exam->subject_name = $get_subject->subject_name;
            // print_r($get_exam->subject_name);
            //  print_r($get_subject->subject_name);
            // exit();
            
            $get_exam->all_total   = $get_exam1->total;
            $get_exam->all_out_of  = $get_exam2->out_of;
            $get_exam->get_percent = ($get_exam->all_total / $get_exam->all_out_of) * 100;
            $get_exam->get_cgpa    = round($get_exam->get_percent / 9.5, 2);
            
            if ($get_exam->get_cgpa > 9) {
                $get_exam->get_grade = 'A+';
            } else if ($get_exam->get_cgpa > 8) {
                $get_exam->get_grade = 'A';
            } else if ($get_exam->get_cgpa > 7) {
                $$get_exam->get_grade = 'B+';
            } else if ($get_exam->get_cgpa > 6) {
                $get_exam->get_grade = 'B';
            } else if ($get_exam->get_cgpa > 5) {
                $get_exam->get_grade = 'c+';
            } else if ($get_exam->get_cgpa > 4) {
                $get_exam->get_grade = 'c';
            } else {
                $get_exam->get_grade = 'Fail';
            }
            array_push($getexam, $get_exam);
        }
         if ($getexam) {

                $all_total = $get_exam1->total;
                $all_out_of = $get_exam2->out_of;
                $get_percent= ($get_exam->all_total / $get_exam->all_out_of) * 100;
                $get_cgpa   = round($get_exam->get_percent / 9.5, 2);
                $get_grade =  $get_exam->get_grade ;
            // $this->Api_model->responseSuccess(1, "Get exam info", $getexam);

            $arr = array('status' => 1,'message' => "Get exam info", 'data'=> $getexam,'all_out_of'=> $all_out_of,'all_total'=> $all_total,'get_percent'=> $get_percent,'get_cgpa'=> $get_cgpa,'get_grade'=> $get_grade); 
            header('Content-Type: application/json');      
             echo json_encode($arr); 

            //$this->Api_model->responseSuccess(1, "Get exam info", $getexam );
        } else {
            $this->Api_model->responseFailed(0, "Not yet any exam.");
        }
    }
    /* class Schedule for student */
    public function Class_Schedule()
    {
        $class_id = $this->input->post('class_id');
        $day_id   = $this->input->post('day_id');
        if ($day_id == 1) {
            
            $monday = $this->Api_model->getAllDataWhere(array(
                'class_id' => $class_id,
                'day_id' => $day_id
            ), "class_schedule");
            
            $getmonday = array();
            foreach ($monday as $get_monday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_monday->day_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_monday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_monday->class_id
                ));
                
                $get_monday->day          = $get_day->value;
                $get_monday->class_name   = $get_class->class_name;
                $get_monday->subject_name = $get_subject->subject_name;
                array_push($getmonday, $get_monday);
            }
            $data = $getmonday;
        } else if ($day_id == 2) {
            $tuesday    = $this->Api_model->getAllDataWhere(array(
                'class_id' => $class_id,
                'day_id' => $day_id
            ), "class_schedule");
            $gettuesday = array();
            foreach ($tuesday as $get_tuesday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_tuesday->day_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_tuesday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_tuesday->class_id
                ));
                
                $get_tuesday->day          = $get_day->value;
                $get_tuesday->class_name   = $get_class->class_name;
                $get_tuesday->subject_name = $get_subject->subject_name;
                array_push($gettuesday, $get_tuesday);
            }
            $data = $gettuesday;
            
        } else if ($day_id == 3) {
            $wednesday = $this->Api_model->getAllDataWhere(array(
                'class_id' => $class_id,
                'day_id' => $day_id
            ), "class_schedule");
            
            $getwednesday = array();
            foreach ($wednesday as $get_wednesday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_wednesday->day_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_wednesday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_wednesday->class_id
                ));
                
                $get_wednesday->day          = $get_day->value;
                $get_wednesday->class_name   = $get_class->class_name;
                $get_wednesday->subject_name = $get_subject->subject_name;
                array_push($getwednesday, $get_wednesday);
            }
            $data = $getwednesday;
            
        } else if ($day_id == 4) {
            $thursday = $this->Api_model->getAllDataWhere(array(
                'class_id' => $class_id,
                'day_id' => $day_id
            ), "class_schedule");
            
            $getthursday = array();
            foreach ($thursday as $get_thursday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_thursday->day_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_thursday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_thursday->class_id
                ));
                
                $get_thursday->day          = $get_day->value;
                $get_thursday->class_name   = $get_class->class_name;
                $get_thursday->subject_name = $get_subject->subject_name;
                array_push($getthursday, $get_thursday);
            }
            $data = $getthursday;
        }
        
        else if ($day_id == 5) {
            $friday = $this->Api_model->getAllDataWhere(array(
                'class_id' => $class_id,
                'day_id' => $day_id
            ), "class_schedule");
            
            $getfriday = array();
            foreach ($friday as $get_friday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_friday->day_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_friday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_friday->class_id
                ));
                
                $get_friday->day          = $get_day->value;
                $get_friday->class_name   = $get_class->class_name;
                $get_friday->subject_name = $get_subject->subject_name;
                array_push($getfriday, $get_friday);
            }
            $data = $getfriday;
        }
        
        else if ($day_id == 6) {
            $saturday = $this->Api_model->getAllDataWhere(array(
                'class_id' => $class_id,
                'day_id' => $day_id
            ), "class_schedule");
            
            $getsaturday = array();
            foreach ($saturday as $get_saturday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_saturday->day_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_saturday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_saturday->class_id
                ));
                
                $get_saturday->day          = $get_day->value;
                $get_saturday->class_name   = $get_class->class_name;
                $get_saturday->subject_name = $get_subject->subject_name;
                array_push($getsaturday, $get_saturday);
            }
            $data = $getsaturday;
        }
        
        
        if ($data) {
            
            $this->Api_model->responseSuccess(1, "There is Class schedule", $data);
        } else {
            $this->Api_model->responseFailed(0, "Sorry there is no schedule");
        }
    }
    
    /* Staff Schedule for Staff */
    public function Staff_Schedule()
    {
        $staff_id = $this->input->post('staff_id');
        $day_id   = $this->input->post('day_id');
        
        
        if ($day_id == 1) {
            
            $monday = $this->Api_model->getAllDataWhere(array(
                'day_id' => $day_id,
                'staff_id' => $staff_id
            ), "staff_schedule");
            
            
            $getmonday = array();
            foreach ($monday as $get_monday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_monday->day_id
                ));
                
                $get_staffname = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $get_monday->staff_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_monday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_monday->class_id
                ));
                
                $get_monday->day          = $get_day->value;
                $get_monday->first_name   = $get_staffname->first_name;
                $get_monday->middle_name  = $get_staffname->middle_name;
                $get_monday->last_name    = $get_staffname->last_name;
                $get_monday->class_name   = $get_class->class_name;
                $get_monday->subject_name = $get_subject->subject_name;
                
                if ($get_staffname->image) {
                    $get_monday->staff_image = $this->config->base_url() . $get_staffname->image;
                    
                } else {
                    $get_monday->image = "";
                }
                array_push($getmonday, $get_monday);
            }
            
            $data = $getmonday;
        } else if ($day_id == 2) {
            $tuesday    = $this->Api_model->getAllDataWhere(array(
                'day_id' => $day_id,
                'staff_id' => $staff_id
            ), "staff_schedule");
            $gettuesday = array();
            foreach ($tuesday as $get_tuesday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_tuesday->day_id
                ));
                
                $get_staffname = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $get_tuesday->staff_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_tuesday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_tuesday->class_id
                ));
                
                $get_tuesday->day          = $get_day->value;
                $get_tuesday->first_name   = $get_staffname->first_name;
                $get_tuesday->middle_name  = $get_staffname->middle_name;
                $get_tuesday->last_name    = $get_staffname->last_name;
                $get_tuesday->class_name   = $get_class->class_name;
                $get_tuesday->subject_name = $get_subject->subject_name;
                array_push($gettuesday, $get_tuesday);
            }
            $data = $gettuesday;
            
        } else if ($day_id == 3) {
            $wednesday = $this->Api_model->getAllDataWhere(array(
                'day_id' => $day_id,
                'staff_id' => $staff_id
            ), "staff_schedule");
            
            $getwednesday = array();
            foreach ($wednesday as $get_wednesday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_wednesday->day_id
                ));
                
                $get_staffname = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $get_saturday->staff_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_wednesday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_wednesday->class_id
                ));
                
                $get_wednesday->day          = $get_day->value;
                $get_wednesday->first_name   = $get_staffname->first_name;
                $get_wednesday->middle_name  = $get_staffname->middle_name;
                $get_wednesday->last_name    = $get_staffname->last_name;
                $get_wednesday->class_name   = $get_class->class_name;
                $get_wednesday->subject_name = $get_subject->subject_name;
                array_push($getwednesday, $get_wednesday);
            }
            $data = $getwednesday;
            
        } else if ($day_id == 4) {
            $thursday = $this->Api_model->getAllDataWhere(array(
                'day_id' => $day_id,
                'staff_id' => $staff_id
            ), "staff_schedule");
            
            $getthursday = array();
            foreach ($thursday as $get_thursday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_thursday->day_id
                ));
                
                $get_staffname = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $get_thursday->staff_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_thursday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_thursday->class_id
                ));
                
                $get_thursday->day          = $get_day->value;
                $get_thursday->first_name   = $get_staffname->first_name;
                $get_thursday->middle_name  = $get_staffname->middle_name;
                $get_thursday->last_name    = $get_staffname->last_name;
                $get_thursday->class_name   = $get_class->class_name;
                $get_thursday->subject_name = $get_subject->subject_name;
                array_push($getthursday, $get_thursday);
            }
            $data = $getthursday;
        }
        
        else if ($day_id == 5) {
            $friday = $this->Api_model->getAllDataWhere(array(
                'day_id' => $day_id,
                'staff_id' => $staff_id
            ), "staff_schedule");
            
            $getfriday = array();
            foreach ($friday as $get_friday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_friday->day_id
                ));
                
                $get_staffname = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $get_friday->staff_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_friday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_friday->class_id
                ));
                
                $get_friday->day          = $get_day->value;
                $get_friday->first_name   = $get_staffname->first_name;
                $get_friday->middle_name  = $get_staffname->middle_name;
                $get_friday->last_name    = $get_staffname->last_name;
                $get_friday->class_name   = $get_class->class_name;
                $get_friday->subject_name = $get_subject->subject_name;
                array_push($getfriday, $get_friday);
            }
            $data = $getfriday;
        }
        
        else if ($day_id == 6) {
            $saturday = $this->Api_model->getAllDataWhere(array(
                'day_id' => $day_id,
                'staff_id' => $staff_id
            ), "staff_schedule");
            
            $getsaturday = array();
            foreach ($saturday as $get_saturday) {
                
                $get_day = $this->Api_model->getSingleRow('day', array(
                    'id' => $get_saturday->day_id
                ));
                
                $get_staffname = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $get_saturday->staff_id
                ));
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $get_saturday->subject_id
                ));
                
                $get_class = $this->Api_model->getSingleRow('class', array(
                    'class_id' => $get_saturday->class_id
                ));
                
                $get_saturday->day          = $get_day->value;
                $get_saturday->first_name   = $get_staffname->first_name;
                $get_saturday->middle_name  = $get_staffname->middle_name;
                $get_saturday->last_name    = $get_staffname->last_name;
                $get_saturday->class_name   = $get_class->class_name;
                $get_saturday->subject_name = $get_subject->subject_name;
                array_push($getsaturday, $get_saturday);
            }
            $data = $getsaturday;
        }
        
        if ($data) {
            
            $this->Api_model->responseSuccess(1, "Staff Schedule For Staff", $data);
        } else {
            $this->Api_model->responseFailed(0, "Sorry there is no schedule");
        }
    }
    
    
    /*Use to Genrate progress Report for Student
    public function ProgressReport()
    {
    $student_id= $this->input->post('student_id');
    
    $get_report = $this->Api_model->getAllDataWhere(array('student_id' => $student_id
    ), "result");
    
    
    $getreport = array();
    foreach ($get_report as $get_report) {
    
    
    $get_student = $this->Api_model->getSingleRow('student', array(
    'student_id' => $get_report->student_id));
    
    
    $get_subject= $this->Api_model->getSingleRow('subject', array(
    'subject_id' => $get_report->subject_id));
    
    
    $get_class= $this->Api_model->getSingleRow('class', array(
    'class_id' => $get_report->class_id));
    
    
    $get_report->first_name = $get_student->first_name;
    $get_report->middle_name = $get_student->middle_name;
    $get_report->last_name = $get_student->last_name;
    $get_report->subject_name= $get_subject->subject_name;
    $get_report->class_name= $get_class->class_name;
    array_push($getreport, $get_report);
    }
    
    if ($getreport) {
    
    $this->Api_model->responseSuccess(1, "Get Progress Report info", $getreport);
    } 
    else {
    $this->Api_model->responseFailed(0, "Not yet any Progress Report ");
    }
    }
    
    
    /*Use to Genrate Exam Result for student */
    /*Use to Genrate Exam Result for student */
    // public function getTerm()
    //     {
    
    //         $class_id = $this->input->post('class_id', TRUE);
    
    //         $get_term = $this->Api_model->getAllDataWhere(array(
    //             'class_id' => $class_id
    //         ), "term");
    //         if ($get_term) {
    //             $this->Api_model->responseSuccess(1, "Get Term.", $get_term);
    //         } else {
    //             $this->Api_model->responseFailed(0, "Not Term.");
    //         }
    //     }
    
    /*Send message (Chat)*/
    public function sendmsg()
    {
        $image     = $this->input->post('image', TRUE);
        $chat_type = $this->input->post('chat_type', TRUE);
        if (isset($chat_type)) {
            $data['chat_type'] = $this->input->post('chat_type', TRUE);
        } else {
            $data['chat_type'] = '1';
        }
        $data['student_id']      = $this->input->post('student_id', TRUE);
        $data['staff_id']        = $this->input->post('staff_id', TRUE);
        $data['message']         = $this->input->post('message', TRUE);
        $data['send_by']         = $this->input->post('send_by', TRUE);
        $data['send_at']         = time();
        $data['is_read_student'] = $this->input->post('is_read_student', TRUE);
        $data['is_read_staff']   = $this->input->post('is_read_staff', TRUE);
        
        
        $this->load->library('upload');
        
        $config['image_library']  = 'gd2';
        $config['upload_path']    = './assets/images/';
        $config['allowed_types']  = '*';
        $config['max_size']       = 10000;
        $config['file_name']      = time();
        $config['create_thumb']   = TRUE;
        $config['maintain_ratio'] = TRUE;
        $config['width']          = 250;
        $config['height']         = 250;
        $this->upload->initialize($config);
        $updateduserimage = "";
        if ($this->upload->do_upload('image') && $this->load->library('image_lib', $config)) {
            $updateduserimage = 'assets/images/' . $this->upload->data('file_name');
        } else {
            // echo $this->upload->display_errors();
        }
        
        
        if ($updateduserimage) {
            $data['image'] = $updateduserimage;
        }
        
        $chatId = $this->Api_model->insertGetId("chat", $data);
        
        if ($chatId) {
            if ($data['send_by'] == "1") {
                $checkUser     = $this->Api_model->getSingleRow(STU_TBL, array(
                    'student_id' => $data['student_id']
                ));
                $parent_id     = $checkUser->parent_id;
                $parentDetails = $this->Api_model->getSingleRow('parent', array(
                    'parent_id' => $parent_id
                ));
                $device_token  = $parentDetails->device_token;
                $checkUser1    = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $data['staff_id']
                ));
                $msg           = $data['message'];
                $senderName    = $checkUser1->first_name;
                $this->firebase_notification($device_token, $data['staff_id'], $senderName, "Chat", $msg);
            } else if ($data['send_by'] == "2") {
                $checkUser     = $this->Api_model->getSingleRow(STU_TBL, array(
                    'student_id' => $data['student_id']
                ));
                $parent_id     = $checkUser->parent_id;
                $parentDetails = $this->Api_model->getSingleRow('parent', array(
                    'parent_id' => $parent_id
                ));
                $checkUser1    = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $data['staff_id']
                ));
                $msg           = $data['message'];
                //  $msg=$parentDetails->father_name.':'.$data['message'];
                //  $parent_id=$checkUser->parent_id;
                //  $parentDetails=$this->Api_model->getSingleRow('parent', array(
                //     'parent_id' => $parent_id
                // ));
                $senderName    = $parentDetails->father_name;
                $device_token  = $checkUser1->device_token;
                $this->firebase_notification($device_token, $data['student_id'], $senderName, "chat", $msg);
            }
            $get_chat = $this->Api_model->getAllDataWhere(array(
                'student_id' => $data['student_id'],
                'staff_id' => $data['staff_id']
            ), CHT_TBL);
            
            $get_chats = array();
            foreach ($get_chat as $get_chat) {
                if ($get_chat->chat_type == 2) {
                    $get_chat->image = $this->config->base_url() . $get_chat->image;
                }
                
                array_push($get_chats, $get_chat);
            }
            
            $this->Api_model->responseSuccess(1, "Message sent successfully", $get_chats);
        } else {
            $this->Api_model->responseFailed(0, NOT_RESPONDING);
        }
    }
    
    /*get conversation*/
    public function getChat()
    {
        $student_id = $this->input->post('student_id', TRUE);
        $staff_id   = $this->input->post('staff_id', TRUE);
        
        $get_chat = $this->Api_model->getAllDataWhere(array(
            'staff_id' => $staff_id,
            'student_id' => $student_id
        ), "chat");
        if ($get_chat) {
            $get_chats = array();
            foreach ($get_chat as $get_chat) {
                if ($get_chat->chat_type == 2) {
                    // $getdata->image= $this->config->base_url().$getdata->image;
                    $get_chat->image = $this->config->base_url() . $get_chat->image;
                }
                
                array_push($get_chats, $get_chat);
            }
            $this->Api_model->responseSuccess(1, "Get my conversation.", $get_chats);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any conversation.");
        }
    }
    
    
    /*Use to Get Notifications */
    public function getNotifications()
    {
        $user_id = $this->input->post('user_id', TRUE);
        
        $get_notifications = $this->Api_model->getAllDataWhereAndOr(array(
            'user_id' => $user_id
        ), array(
            'type' => "All"
        ), "notifications");
        if ($get_notifications) {
            
            $this->Api_model->responseSuccess(1, "Notifications.", $get_notifications);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any notifications.");
        }
    }
    
    public function firebase_notification($device_token, $sender_id, $senderName, $title, $msg1)
    {
        
        // $staff           = $this->db->where('staff_id', $staff_id)->get('staff')->row();
        // $registrationIds = $staff->device_token;
        // $mobile_sent     = $staff_id;
        
        // $API_ACCESS_KEY = FIRE_BASE_KEY;
        
        // $msg    = array(
        //     'body' => $msg1,
        //     'title' => $title,
        //     'icon' => 'myicon',
        //     /*Default Icon*/
        //     'sound' => 'mySound'
        //     /*Default sound*/
        // );
        // $fields = array(
        //     'to' => $device_token,
        //     'notification' => $msg
        // );
        
        
        // $headers = array(
        //     'Authorization: key=' . $API_ACCESS_KEY,
        //     'Content-Type: application/json'
        // );
        // #Send Reponse To FireBase Server    
        // $ch      = curl_init();
        // curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        // $result = curl_exec($ch);
        // curl_close($ch);
        
        $FCMPushNotification = new \BD\FCMPushNotification(FIRE_BASE_KEY);
        $sDeviceToken        = $device_token;
        $aPayload            = array(
            'data' => array(
                'title' => $title,
                'type' => 7001,
                'senderName' => $senderName,
                "sender_id" => $sender_id,
                'body' => $msg1
                
                // "senderName" => $senderName
            )
        );
        
        $aOptions = array(
            'time_to_live' => 15 //means messages that can't be delivered immediately are discarded. 
        );
        
        $aResult = $FCMPushNotification->sendToDevice($sDeviceToken, $aPayload, $aOptions // optional
            );
        return $aResult;
        
    }
    
    function firebase_with_class($device_token, $sender_id, $senderName, $title, $msg1)
    {
        $staff = $this->Api_model->getSingleRow('staff', array(
            'device_token' => $device_token
        ));
        
        if ($staff->device_type == "ios") {
            $API_ACCESS_KEY = FIRE_BASE_KEY;
            
            $msg    = array(
                'body' => $msg1,
                'title' => $title,
                'icon' => 'myicon',
                /*Default Icon*/
                'sound' => 'default'
                /*Default sound*/
            );
            $fields = array(
                'to' => $device_token,
                'notification' => $msg
            );
            
            
            $headers = array(
                'Authorization: key=' . $API_ACCESS_KEY,
                'Content-Type: application/json'
            );
            #Send Reponse To FireBase Server    
            $ch      = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
            $result = curl_exec($ch);
            curl_close($ch);
        } else {
            $FCMPushNotification = new \BD\FCMPushNotification(FIRE_BASE_KEY);
            $sDeviceToken        = $device_token;
            $aPayload            = array(
                'data' => array(
                    'title' => $title,
                    'type' => $type,
                    "sender_id" => $sender_id,
                    'body' => $msg1,
                    "senderName" => $senderName
                )
            );
            
            $aOptions = array(
                'time_to_live' => 15 //means messages that can't be delivered immediately are discarded. 
            );
            
            $aResult = $FCMPushNotification->sendToDevice($sDeviceToken, $aPayload, $aOptions // optional
                );
            return $aResult;
        }
    }
    
    function firebase_with_class_v1()
    {
        
        $FCMPushNotification = new \BD\FCMPushNotification(FIRE_BASE_KEY);
        $sDeviceToken        = " ";
        $aPayload            = array(
            'data' => array(
                'title' => "Test",
                'type' => "Test",
                "sender_id" => "1",
                'body' => "this is test",
                "senderName" => "senderName"
            )
        );
        
        $aOptions = array(
            'time_to_live' => 15 //means messages that can't be delivered immediately are discarded. 
        );
        
        $aResult = $FCMPushNotification->sendToDevice($sDeviceToken, $aPayload, $aOptions // optional
            );
        
    }
    
    /*get conversation*/
    public function getChatHistoryForStaff()
    {
        $staff_id = $this->input->post('staff_id', TRUE);
        
        // $this->checkUserStatus($staff_id);
        $where     = array(
            'staff_id' => $staff_id
        );
        $get_users = $this->Api_model->getAllDataWhereDistinct1($where, "chat");
        if ($get_users) {
            $chats = array();
            foreach ($get_users as $get_users) {
                $chat              = $this->Api_model->getSingleRowOrderBy(CHT_TBL, array(
                    'staff_id' => $staff_id,
                    'student_id' => $get_users->student_id
                ));
                $user              = $this->Api_model->getSingleRow(STU_TBL, array(
                    'student_id' => $get_users->student_id
                ));
                $chat->StudentName = $user->first_name;
                if ($user->image) {
                    $chat->image = $this->config->base_url() . $user->image;
                } else {
                    $chat->image = $this->config->base_url() . "assets/images/image.png";
                }
                
                array_push($chats, $chat);
            }
            
            if (count($chats) > 1) {
                array_multisort(array_column($chats, 'send_at'), SORT_DESC, $chats);
            }
            
            $this->Api_model->responseSuccess(1, "Get chat history.", $chats);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any conversation.");
        }
    }
    
    /*get conversation*/
    public function getChatHistoryForStudent()
    {
        $student_id = $this->input->post('student_id', TRUE);
        // $this->checkUserStatus($user_id);
        $where      = array(
            'student_id' => $student_id
        );
        $get_users  = $this->Api_model->getAllDataWhereDistinctstudent($where, CHT_TBL);
        
        if ($get_users) {
            $chats = array();
            foreach ($get_users as $get_users) {
                $chat = $this->Api_model->getSingleRowOrderBy(CHT_TBL, array(
                    'staff_id' => $get_users->staff_id,
                    'student_id' => $student_id
                ));
                $user = $this->Api_model->getSingleRow('staff', array(
                    'staff_id' => $get_users->staff_id
                ));
                
                
                $chat->StaffName = $user->first_name;
                if ($user->image) {
                    $chat->image = $this->config->base_url() . $user->image;
                } else {
                    $chat->image = $this->config->base_url() . "assets/images/image.png";
                }
                array_push($chats, $chat);
            }
            
            if (count($chats) > 1) {
                array_multisort(array_column($chats, 'send_at'), SORT_DESC, $chats);
            }
            
            $this->Api_model->responseSuccess(1, "Get chat history.", $chats);
        } else {
            $this->Api_model->responseFailed(0, "Not yet any conversation.");
        }
    }
    
    
    /*Use update profile for parent*/
    public function UpdateStaffToken()
    {
        $user_id              = $this->input->post('staff_id', TRUE);
        $data['device_token'] = $this->input->post('device_token');
        // $data['section'] = $this->input->post('section');
        $where                = array(
            'staff_id' => $user_id
        );
        $data                 = $this->Api_model->updateSingleRow('staff', $where, $data);
        
        
        if ($data) {
            
            $this->Api_model->responseSuccess(1, "device Token Update", $data);
        } else {
            $this->Api_model->responseFailed(0, "Sorry there is some Problem");
        }
        
    }
    //   /*Use update profile for parent*/
    public function UpdateParentToken()
    {
        $user_id              = $this->input->post('parent_id', TRUE);
        $data['device_token'] = $this->input->post('device_token');
        // $data['section'] = $this->input->post('section');
        $where                = array(
            'parent_id' => $user_id
        );
        $datas                = $this->Api_model->updateSingleRow('parent', $where, $data);
        
        
        if ($datas) {
            
            $this->Api_model->responseSuccess(1, "device Token Update", $data);
        } else {
            $this->Api_model->responseFailed(0, "Sorry there is some Problem");
        }
        
    }

    
    //   /*Use update profile for parent*/
    public function getResult()
    {
        $student_id  = $this->input->post('student_id');
        $staff_id    = $this->input->post('staff_id');
        $get_student = $this->Api_model->getSingleRow('student', array(
            'student_id' => $student_id
        ));

        $class       = $get_student->class_id;
        $session_id  = $get_student->session_id;
        $getSubject  = $this->Api_model->GetSubject($staff_id,$class);
        $finalReult=array();
        foreach ($getSubject as $getSubject) 
        {
        	$get_student = $this->Api_model->getSingleRow('result', array(
	            'student_id' => $student_id,'staff_id' => $staff_id,'class_id' => $class,'session_id'=>$session_id,'subject_id'=>$getSubject->subject_id
	        ));
        	if($get_student)
        	{
        		$getResult=array();
        		$getResult=$get_student;
        	}
        	else
        	{
        		$resultId= $this->Api_model->insertGetId("result",array('student_id' => $student_id,'staff_id' => $staff_id,'class_id' => $class,'session_id'=>$session_id,'subject_id'=>$getSubject->subject_id,'marks'=>0,'assignment'=>0,"assignment1"=>0,"lab"=>0,"project"=>0,'out_of'=>100,"grade"=>0,"total"=>0,"comment"=>'Fail',"create_date"=>time(),"update_date"=>time()));
        		$getResult = $this->Api_model->getSingleRow('result', array('result_id' => $resultId));
        	}
                
                
                $get_subject = $this->Api_model->getSingleRow('subject', array(
                    'subject_id' => $getSubject->subject_id
                ));
                //      $get_student = $this->Api_model->getSingleRow('student', array(
                //     'student_id' => $get_student->student_id
                // ));
                
                // $get_class                = $this->Api_model->getSingleRow('class', array(
                //     'class_id' => $get_student->class_id
                // ));
                // $getResult->first_name   = $get_student->first_name;
                // $getResult->middle_name  = $get_student->middle_name;
                // $getResult->last_name    = $get_student->last_name;
                $getResult->subject_name = $get_subject->subject_name;
                // $getResult->class_name   = $get_class->class_name;

        	array_push($finalReult, $getResult);
        }
          if ($getResult) {
            
            $this->Api_model->responseSuccess(1, "data is heare", $finalReult);
        } else {
            $this->Api_model->responseFailed(0, "Sorry there is some Problem");
        }   

     }
    
    
    
}
