<?php
require('fpdf/fpdf.php');
global $global_code,$total,$trans,$page,$srch,$datefrom,$dateto;

$global_code = "ctrl";
class clientPhoneCallReportPDF extends FPDF {

    function addCols( $tab )
    {
        global $colonnes;
        
        $r1  = 1;
        $r2  = $this->w - ($r1 * 2) ;
        $y1  = 30;
        $y2  = $this->h - 30 - $y1;
        $this->SetXY( $r1, $y1 );
        $this->Rect( $r1, $y1, $r2, $y2, "D");
        $this->Line( $r1, $y1+6, $r1+$r2, $y1+6);
        $colX = $r1;
        $colonnes = $tab;
        while ( list( $lib, $pos ) = each ($tab) )
        {
            $this->SetXY( $colX, $y1+2 );
            $this->Cell( $pos, 1, $lib, 0, 0, "C");
            $colX += $pos;
            $this->Line( $colX, $y1, $colX, $y1+$y2);
        }
    }

    function addLine( $ligne, $tab )
    {
        global $colonnes, $format;

        $ordonnee     = 10;
        $maxSize      = $ligne;

        reset( $colonnes );
        while ( list( $lib, $pos ) = each ($colonnes) )
        {
            $longCell  = $pos -2;
            $texte     = $tab[ $lib ];
            $length    = $this->GetStringWidth( $texte );
            $tailleTexte = $this->sizeOfText( $texte, $length );
            $formText  = $format[ $lib ];
            $this->SetXY( $ordonnee, $ligne-1);
            $this->MultiCell( $longCell, 4 , $texte, 0, $formText);
            if ( $maxSize < ($this->GetY()  ) )
                $maxSize = $this->GetY() ;
            $ordonnee += $pos;
        }
        return ( $maxSize - $ligne );
    }

    function addLineFormat( $tab )
    {
        global $format, $colonnes;
        
        while ( list( $lib, $pos ) = each ($colonnes) )
        {
            if ( isset( $tab["$lib"] ) )
                $format[ $lib ] = $tab["$lib"];
        }
    }



    //Page header
    function Header()
    {
        global $agency_code,$IsActive,$fhca;
        
        //Logo
        $this->SetFont('Times','B',20);
        $this->Cell(200,10,$_SESSION['AgencyName'],0,1,'C');       
        $this->SetFont('Times','B',15);
        $this->Cell(200,10,$_SESSION['title'].'Clients Phone Call Report',0,1,'C');
        $this->SetFont('Arial','',8);
        $this->SetFillColor(200,220,255);   
        $this->Cell(40,10,'Client',1,0,'L',true);   
        //$this->Cell(10,10,'Active',1,0,'L',true);                 
        $this->Cell(10,10,'FHCA',1,0,'L',true);
        $this->Cell(42,10,'Supervisor',1,0,'L',true);       
        $this->Cell(22,10,'Last Call Date',1,0,'L',true);       
        $this->Cell(22,10,'Next Call Date',1,0,'L',true);       
        $this->Cell(22,10,'Days Overdue',1,0,'L',true);       
        $this->Cell(32,10,'Days Before Overdue',1,1,'L',true);       
    }

    //Page footer
    function Footer()
    {
    global $global_code,$trans,$total;
    //    $total2 = number_format($total, 2, '.', ',');
    //    $transx = 'No. of Transaction: '.$trans;

    //    $this->ln(8);
    //   $this->Cell(25,5,'',1,0,'C');
    //    $this->Cell(23,5,'',1,0,'C');
    //    $this->Cell(150,5,$transx,1,0,'C');
    //    $this->Cell(15,5,'',1,0,'C');
    //    $this->Cell(25,5,$mtotal,1,0,'C');
    //    $this->Cell(30,5,$total2,1,1,'R');

        //Position at 1.5 cm from bottom
        $this->SetY(-15);
        //Arial italic 8
        $this->SetFont('Arial','I',8);
        //Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'L');
    //    $this->Image('images/tcscoopft.jpg',60,189,30);
    //$this->EAN13(95,85,$global_code);
    //$this->Code39(95,90,$global_code,1,11);

    }

    function temporaire( $texte )
    {
        $this->SetFont('Arial','B',50);
        $this->SetTextColor(203,203,203);
        $this->Rotate(45,55,190);
        $this->Text(140,120,$texte);
        $this->Rotate(0);
        $this->SetTextColor(0,0,0);
    }


    function RoundedRect($x, $y, $w, $h, $r, $style = '')
    {
        $k = $this->k;
        $hp = $this->h;
        if($style=='F')
            $op='f';
        elseif($style=='FD' || $style=='DF')
            $op='B';
        else
            $op='S';
        $MyArc = 4/3 * (sqrt(2) - 1);
        $this->_out(sprintf('%.2F %.2F m',($x+$r)*$k,($hp-$y)*$k ));
        $xc = $x+$w-$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2F %.2F l', $xc*$k,($hp-$y)*$k ));

        $this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
        $xc = $x+$w-$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2F %.2F l',($x+$w)*$k,($hp-$yc)*$k));
        $this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
        $xc = $x+$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2F %.2F l',$xc*$k,($hp-($y+$h))*$k));
        $this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
        $xc = $x+$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2F %.2F l',($x)*$k,($hp-$yc)*$k ));
        $this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
        $this->_out($op);
    }

    function _Arc($x1, $y1, $x2, $y2, $x3, $y3)
    {
        $h = $this->h;
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c ', $x1*$this->k, ($h-$y1)*$this->k,
                            $x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
    }

    function Rotate($angle, $x=-1, $y=-1)
    {
        if($x==-1)
            $x=$this->x;
        if($y==-1)
            $y=$this->y;
        if($this->angle!=0)
            $this->_out('Q');
        $this->angle=$angle;
        if($angle!=0)
        {
            $angle*=M_PI/180;
            $c=cos($angle);
            $s=sin($angle);
            $cx=$x*$this->k;
            $cy=($this->h-$y)*$this->k;
            $this->_out(sprintf('q %.5F %.5F %.5F %.5F %.2F %.2F cm 1 0 0 1 %.2F %.2F cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
        }
    }

    function EAN13($x, $y, $barcode, $h=16, $w=.35)
    {
        $this->Barcode($x,$y,$barcode,$h,$w,13);
    }

    function UPC_A($x, $y, $barcode, $h=16, $w=.35)
    {
        $this->Barcode($x,$y,$barcode,$h,$w,12);
    }

    function GetCheckDigit($barcode)
    {
        //Compute the check digit
        $sum=0;
        for($i=1;$i<=11;$i+=2)
            $sum+=3*$barcode[$i];
        for($i=0;$i<=10;$i+=2)
            $sum+=$barcode[$i];
        $r=$sum%10;
        if($r>0)
            $r=10-$r;
        return $r;
    }

    function TestCheckDigit($barcode)
    {
        //Test validity of check digit
        $sum=0;
        for($i=1;$i<=11;$i+=2)
            $sum+=3*$barcode[$i];
        for($i=0;$i<=10;$i+=2)
            $sum+=$barcode[$i];
        return ($sum+$barcode[12])%10==0;
    }

    function Barcode($x, $y, $barcode, $h, $w, $len)
    {
        //Padding
        $barcode=str_pad($barcode,$len-1,'0',STR_PAD_LEFT);
        if($len==12)
            $barcode='0'.$barcode;
        //Add or control the check digit
        if(strlen($barcode)==12)
            $barcode.=$this->GetCheckDigit($barcode);
        elseif(!$this->TestCheckDigit($barcode))
            $this->Error('Incorrect check digit');
        //Convert digits to bars
        $codes=array(
            'A'=>array(
                '0'=>'0001101','1'=>'0011001','2'=>'0010011','3'=>'0111101','4'=>'0100011',
                '5'=>'0110001','6'=>'0101111','7'=>'0111011','8'=>'0110111','9'=>'0001011'),
            'B'=>array(
                '0'=>'0100111','1'=>'0110011','2'=>'0011011','3'=>'0100001','4'=>'0011101',
                '5'=>'0111001','6'=>'0000101','7'=>'0010001','8'=>'0001001','9'=>'0010111'),
            'C'=>array(
                '0'=>'1110010','1'=>'1100110','2'=>'1101100','3'=>'1000010','4'=>'1011100',
                '5'=>'1001110','6'=>'1010000','7'=>'1000100','8'=>'1001000','9'=>'1110100')
            );
        $parities=array(
            '0'=>array('A','A','A','A','A','A'),
            '1'=>array('A','A','B','A','B','B'),
            '2'=>array('A','A','B','B','A','B'),
            '3'=>array('A','A','B','B','B','A'),
            '4'=>array('A','B','A','A','B','B'),
            '5'=>array('A','B','B','A','A','B'),
            '6'=>array('A','B','B','B','A','A'),
            '7'=>array('A','B','A','B','A','B'),
            '8'=>array('A','B','A','B','B','A'),
            '9'=>array('A','B','B','A','B','A')
            );
        $code='101';
        $p=$parities[$barcode[0]];
        for($i=1;$i<=6;$i++)
            $code.=$codes[$p[$i-1]][$barcode[$i]];
        $code.='01010';
        for($i=7;$i<=12;$i++)
            $code.=$codes['C'][$barcode[$i]];
        $code.='101';
        //Draw bars
        for($i=0;$i<strlen($code);$i++)
        {
            if($code[$i]=='1')
                $this->Rect($x+$i*$w,$y,$w,$h,'F');
        }
        //Print text uder barcode
        $this->SetFont('Arial','',12);
        $this->Text($x,$y+$h+11/$this->k,substr($barcode,-$len));
    }
}
?>