<?php
    /**
    * 
    */
    class Comman_model extends CI_Model
    {
        
        function __construct()
        {
            parent:: __construct();
        }

        public function getCustomQueryData($MySQL, $type='result') {
          $query = $this->db->query($MySQL);
          if($type=='row') {
            return $query->row_array();             
          } else {
            return $query->result_array();           
          }
          
        }

        public function setCustomQueryData($MySQL) {
          $query = $this->db->query($MySQL);          
        }

        public function getpatientVisitData($fromdate, $todate, $nextVisitDate, $orderBy, $orderType) {
          $select   = array(
                            "pt.lastname as LastName",
                            "pt.firstname as FirstName",
                            "pt.name as Full Name",
                            "pt.ShipAddressAddr2 as Street Address",
                            "pt.ShipAddressCity as City",
                            "pt.ShipAddressState as State",
                            "pt.ShipAddressPostalCode as Zip",
                            "pt.phone as Phone",
                            "pt.CustomFieldBirthday as DOB",
                            "su.name as Supervisor",
                            "tpv.VisitDoneDate as Last Visit",
                            "tpv.NextVisitDate as Next Visit",
                            "pt.FHCA as No",
                            "tpv.VisitationNotes as Comments",
                          );
          $this->db->select($select);
          $this->db->from("tblpatientsvisits as tpv");
          $this->db->join('patient as pt', 'pt.patient_id = tpv.patient_id');
          $this->db->join('supervisor as su', 'su.supervisor_id = pt.supervisor_id');

          if(!empty($fromdate)) {
            $this->db->where('tpv.VisitDoneDate>=', $fromdate);
          }
          if(!empty($todate)) {
            $this->db->where('tpv.VisitDoneDate<=', $fromdate);
          }

          if(!empty($nextVisitDate)) {
            $this->db->where('tpv.NextVisitDate=', $nextVisitDate);
          }

          if(!empty($where)){
            $this->db->where($where);
          }
          if($orderBy!='' && $orderType!=''){
            $this->db->order_by($orderBy,$orderType);
          }
          $query =  $this->db->get();  
          //print_r($this->db->last_query());die;
          return $query->result_array();  
        }

        public function getAssignedSupervisor($where=[], $orderBy = '', $orderType = '') {
          $select   = array(
                            "su.*",
                          );
          $this->db->select($select);
          $this->db->from("supervisor as su");
          $this->db->join('patient as pt', 'pt.supervisor_id = su.supervisor_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          $this->db->group_by('su.supervisor_id');
          if($orderBy!='' && $orderType!=''){
            $this->db->order_by($orderBy,$orderType);
          }
          $query =  $this->db->get();  
          return $query->result_array();  
        }

        public function getAssignedClient($where=[]) {
          $select   = array(
                            "pt.*",
                            "su.*",
                          );
          $this->db->select($select);
          $this->db->from("patient as pt");          
          $this->db->join('tbldistricts as td', 'td.DistrictID = pt.DistrictID_Ref');
          $this->db->join('supervisor as su', 'pt.supervisor_id = su.supervisor_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          return $query->num_rows();  
        }

        public function getPatientHistory($where=[], $limit=5) {
          $select   = array(
                            "puh.*",
                            "usr.name as username",
                          );
          $this->db->select($select);
          $this->db->from("patient_update_history as puh");          
          $this->db->join('users_portal as usr', 'usr.user_id = puh.user_id', 'left');
          if(!empty($where)){
            $this->db->where($where);
          }
          $this->db->limit($limit);
          $this->db->order_by('id', 'desc');
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          //return $query->num_rows();  
          return $query->result_array();   
        }


        public function getEmployeeHistory($where=[], $limit=5) {
          $select   = array(
                            "puh.*",
                            "usr.name as username",
                          );
          $this->db->select($select);
          $this->db->from("employee_update_history as puh");          
          $this->db->join('users_portal as usr', 'usr.user_id = puh.user_id', 'left');
          if(!empty($where)){
            $this->db->where($where);
          }
          $this->db->limit($limit);
          $this->db->order_by('id', 'desc');
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          //return $query->num_rows();  
          return $query->result_array();   
        }


        public function getActiveClient($agency_code,$supervisor_id,$IsActive=1,$result=0,$agency_location=''){
          
            $cond1=$cond2=$cond3=$cond4=$cond5=$zipcode=$patient_id=$med_medicaidno=$lastname=$firstname=$phone=$zipcode='';
            if($IsActive) {
                if($IsActive==2) {
                  $cond1  .=  " AND patient.on_hold = 'yes'";  
                  $cond1  .=  " AND patient.IsActive = '1'";
                } else {
                  $cond1 .=  " AND patient.IsActive = '$IsActive'";  
                }                
            }
            if($supervisor_id){
                $suplid    =   $supervisor_id;
                $cond3 = "AND patient.supervisor_id = '$suplid'";
            }

            if($agency_location) {
              $cond1 .= "AND patient.agency_location = '$agency_location'";
            }

            $MySQL = "SELECT SQL_CALC_FOUND_ROWS
                    patient.lastname, 
                    patient.firstname, 
                    patient.middlename,
                    patient.ShipAddressPostalCode,
                    patient.ShipAddressAddr2,
                    patient.ShipAddressCity,
                    patient.ShipAddressState,
                    patient.phone,
                    patient.phone2,
                    patient.useradd,
                    patient.userdate,
                    patient.popalert,
                    patient.popnotes,
                    patient.med_medicaidno,
                    patient.patient_id,
                    patient.CustomFieldBirthday,
                    patient.IsActive,
                    patient.on_hold,
                    patient.JobStartDate,
                    patient.agency_location,
                    tbldistricts.DistrictNumber,
                    tbldistricts.DistrictName,
                    patient.FHCA,
                    supervisor.firstname AS supfirstname, 
                    supervisor.lastname AS suplastname 
        
                    FROM patient,tbldistricts,supervisor
                    WHERE  tbldistricts.DistrictID = patient.DistrictID_Ref AND 
                    tbldistricts.Agency = '$agency_code' AND
                    supervisor.supervisor_id = patient.supervisor_id AND 
                    patient.Agency = '$agency_code'  AND
                    patient.patient_id LIKE '%".$patient_id."%' AND 
                    patient.med_medicaidno LIKE '%".$med_medicaidno."%' AND 
                    patient.ShipAddressPostalCode LIKE '%".$zipcode."%' AND 
                    (patient.phone LIKE '%".$phone."%' OR 
                    patient.phone2 LIKE '%".$phone."%') AND 
                    patient.firstname LIKE '%".$firstname."%' AND patient.lastname LIKE '%".$lastname."%' 
                    ".$cond1.$cond2.$cond3.$cond4.$cond5." ";
                    //ORDER BY ".$sortorder." ".$desc." 
                    //LIMIT " .$from. ", " .$to ."   ";  

                    //echo $MySQL;
            $query = $this->db->query($MySQL);
            if($result) {
              return $query->result_array();  
            } else {
              return $query->num_rows();  
            }
      }


        public function getAssignedClientHours($agency_code,$supervisor_id,$IsActive=1,$agency_location='') {
          $cond1=$cond2=$cond3=$cond4=$cond5=$zipcode=$patient_id=$med_medicaidno=$lastname=$firstname=$phone=$zipcode='';
            if($IsActive){
                $cond1     =   " AND IsActive = '$IsActive'";
            }
            if($supervisor_id){
                $suplid    =   $supervisor_id;
                $cond3 = "AND patient.supervisor_id = '$suplid'";
            }

            if($agency_location) {
              $cond1 .= "AND patient.agency_location = '$agency_location'";
            }

            $MySQL = "SELECT SUM(patient.HMKRHours) as assignedHours
                    FROM patient,tbldistricts,supervisor
                    WHERE  tbldistricts.DistrictID = patient.DistrictID_Ref AND 
                    tbldistricts.Agency = '$agency_code' AND
                    supervisor.supervisor_id = patient.supervisor_id AND 
                    patient.Agency = '$agency_code'  AND
                    patient.patient_id LIKE '%".$patient_id."%' AND 
                    patient.med_medicaidno LIKE '%".$med_medicaidno."%' AND 
                    patient.ShipAddressPostalCode LIKE '%".$zipcode."%' AND 
                    (patient.phone LIKE '%".$phone."%' OR 
                    patient.phone2 LIKE '%".$phone."%') AND 
                    patient.firstname LIKE '%".$firstname."%' AND patient.lastname LIKE '%".$lastname."%' 
                    ".$cond1.$cond2.$cond3.$cond4.$cond5." ";
            $query = $this->db->query($MySQL);
            //print_r($this->db->last_query());
            $assignedHours = $query->row()->assignedHours;
            if($assignedHours!=null){
              return $assignedHours;    
            } else {
              return 0;
            } 
        }

        public function getTotalClientByStatus($agency_code,$supervisor_id,$IsActive=1) {
            $otherdb = $this->load->database('otherdb', TRUE); 
            $MySQL = " SELECT * FROM patient_status WHERE id IN (SELECT MAX(id) FROM patient_status GROUP BY patient_id) and agency = '".$agency_code."' and supervisor_id = '".$supervisor_id."' and new_status = '".$IsActive."'";
            $query = $otherdb->query($MySQL);
            $totalClient = $query->num_rows();
            if($totalClient!=null){
              return $totalClient;    
            } else {
              return 0;
            }
        }


        public function getTotalAssignedClientHours($agency_code,$supervisor_id,$IsActive=1) {
            $otherdb = $this->load->database('otherdb', TRUE); 
            $MySQL = " SELECT SUM(new_approved_hours) as assignedHours FROM patient_approve_hours WHERE id IN (SELECT MAX(id) FROM patient_approve_hours GROUP BY MONTH(changeDate)) and agency = '".$agency_code."' and supervisor_id = ".$supervisor_id."";
            $query = $otherdb->query($MySQL);
            $assignedHours = $query->row()->assignedHours;
            if($assignedHours!=null){
              return $assignedHours;    
            } else {
              return 0;
            }
        }

        public function getAssignedClientHoursByMonth($agency_code,$supervisor_id,$IsActive=1,$month='') {
            $otherdb = $this->load->database('otherdb', TRUE); 
            $MySQL = " SELECT * FROM patient_approve_hours WHERE id IN (SELECT MAX(id) FROM patient_approve_hours GROUP BY MONTH(changeDate)) and agency = '".$agency_code."' and supervisor_id = ".$supervisor_id." and MONTH(changeDate)=$month and YEAR(changeDate)=".date('Y')."";
            $query = $otherdb->query($MySQL);
            $num = $query->num_rows();
            if($num) {
              $assignedHours = $query->row_array();
              if(!empty($assignedHours)) {
                return $assignedHours['new_approved_hours'];     
              } else {
                return 0;
              }
            } else {
              return 0;
            }
        }

        public function getTotalHours($where, $month) {
          $select   = array(
                            //"SUM(ef.period1) as period1",
                            //"SUM(ef.period2) as period2",
                            "SUM(ef.total_hrs) as totalHours",
                          );
          $this->db->select($select);
          $this->db->from("employee_finalsheet as ef");
          $this->db->join('patient as pt', 'ef.patient_id = pt.patient_id');
          $this->db->where("ef.month=",$month);
          $this->db->where("ef.year=",date('Y'));
          if(!empty($where)){
            $this->db->where($where);
          }
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          $totalHours = $query->row()->totalHours;
          if($totalHours!=null){
            return $totalHours;    
          } else {
            return 0;
          }
        }



        public function getBilledtHours($where, $month) {
          $select   = array(
                            //"SUM(ef.period1) as period1",
                            //"SUM(ef.period2) as period2",
                            "SUM(ef.period1) + SUM(ef.period2) as totalBilled",
                          );
          $this->db->select($select);
          $this->db->from("employee_finalsheet as ef");
          $this->db->join('patient as pt', 'ef.patient_id = pt.patient_id');
          $this->db->where("ef.month=",$month);
          $this->db->where("ef.year=",date('Y'));
          if(!empty($where)){
            $this->db->where($where);
          }
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          $totalBilled = $query->row()->totalBilled;
          if($totalBilled!=null){
            return $totalBilled;    
          } else {
            return 0;
          } 
        }

        public function getBilledtHoursByOther($where, $month) {
          $select   = array(
                            //"SUM(ef.period1) as period1",
                            //"SUM(ef.period2) as period2",
                            "SUM(ef.period1) + SUM(ef.period2) as totalBilled",
                          );
          $this->db->select($select);
          $this->db->from("employee_reportsheet as ef");
          $this->db->join('patient as pt', 'ef.patient_id = pt.patient_id');
          $this->db->where("ef.month=",$month);
          $this->db->where("ef.year=",date('Y'));
          if(!empty($where)){
            $this->db->where($where);
          }
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          $totalBilled = $query->row()->totalBilled;
          if($totalBilled!=null){
            return $totalBilled;    
          } else {
            return 0;
          } 
        }


        public function getBilledtHoursOtherAgency($where, $month) {

          $sql = "SELECT start_date,table_2weekly_id FROM table_2weekly WHERE end_date>='".date('Y-m-d')."' AND start_date<='".date('Y-m-d')."'";
          $row = $this->getCustomQueryData($sql, 'row');

          $sql = "SELECT start_date FROM table_2weekly WHERE table_2weekly_id<".$row['table_2weekly_id']." order by table_2weekly_id desc limit 1";
          $row = $this->getCustomQueryData($sql, 'row');


          $select   = array(
                            "SUM(ef.total_2weekly) as totalBilled",
                          );
          $this->db->select($select);
          $this->db->from("employee_2finalsheet as ef");
          $this->db->join('patient as pt', 'ef.patient_id = pt.patient_id');
          //$this->db->where("MONTH(ef.start_date)",$month);
          //$this->db->where("YEAR(ef.start_date)",date('Y'));
          //$this->db->where("ef.start_date",'2020-03-23');
          $this->db->where("ef.start_date",$row['start_date']);
          if(!empty($where)){
            $this->db->where($where);
          }
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          $totalBilled = $query->row()->totalBilled;
          if($totalBilled!=null){
            return $totalBilled;    
          } else {
            return 0;
          }
        }


        public function getTotalClientOnHold($where=[]) {
          $select   = array(
                            "pa.*",
                            "su.*",
                          );
          $this->db->select($select);
          $this->db->from("patient as pa");
          $this->db->join('supervisor as su', 'su.supervisor_id = pa.supervisor_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          return $query->num_rows(); 
        }


        public function getRecentTerminations($where=[], $result=0) {
          $select   = "*";
          $this->db->select($select);
          $this->db->from("patient");
          $this->db->where('date_terminated BETWEEN DATE_SUB(NOW(), INTERVAL 30 DAY) AND NOW()');
          if(!empty($where)){
            $this->db->where($where);
          }
          $query =  $this->db->get();  
          if($result==1) {
            return $query->result_array();
          } else {
            //print_r($this->db->last_query());
            return $query->num_rows();   
          }
          
        }


        public function getListFortyHoursWeek($where, $limit) {
          $select   = array(
                            "SUM(ea.total_limit) as totalLimit",
                            "ea.pin as pinn",
                            "em.*",
                            "ag.agency_codename"
                          );
          $this->db->select($select);
          $this->db->from("employee_assignment as ea");
          $this->db->join('employee as em', 'ea.employee_id = em.employee_id');
          $this->db->join('agency as ag', 'ag.agency_code = em.Agency');
          if(!empty($where)){
            $this->db->where($where);
          }
          $this->db->not_like('ea.pin', '+');
          $this->db->group_by("ea.employee_id");
          $this->db->having('totalLimit > 40');
          $this->db->or_having("em.compliance != '1,2,3,4,5,6,7,8'");
          $this->db->limit($limit);
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          return $query->result_array();   
        }


        public function getListAppUserLocation($where, $limit) {

          $date = '2021-04-01';

          $select   = array(
                              "ec.patient_id AS pt_id",
                              "ec.employee_id",
                              "ec.date",
                              "ec.rec_id",
                              "ec.tagedit",
                              "ec.latitude",
                              "ec.longitude",
                              "ec.macAddress",
                              "ec.employee_clock_id",
                              "ec.isIn",
                              "ec.location_verified",
                              "ec.employee_clock_id",
                              "pt.patient_id", 
                              "pt.name as pt_name",
                              "pt.phone",
                              "pt.longitude as log",
                              "pt.latitude as lat",
                              "pt.macAddress as mac",
                              "pt.Agency",
                              "pt.ShipAddressAddr2",
                              "em.name as empl_name",
                              "em.pin",
                              "em.EmployeeAddressAddr1"
                          );
          $this->db->select($select);
          $this->db->from("employee_clock as ec");
          $this->db->join('patient as pt', 'pt.patient_id = ec.patient_id');
          $this->db->join('employee as em', 'em.employee_id = ec.employee_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          $this->db->where("ec.latitude!=",null);
          $this->db->where("ec.longitude!=",null);
          $this->db->where("ec.location_verified!=",1);
          $this->db->where("DATE(ec.date)>=",$date);
          //$this->db->where("MONTH(ec.date)>=",4);
          //$this->db->where("YEAR(ec.date)",date('Y'));
          //$this->db->where("YEAR(ec.date)>=",2021);
          $this->db->order_by("ec.employee_clock_id",'desc');
          $this->db->limit($limit);
          $query =  $this->db->get();  
          //print_r($this->db->last_query());
          return $query->result_array();   
        }


        public function checkGoogleUser($data = array()){
          $this->db->select('googleUserId, email');
          $this->db->from('users_portal');
          $con = array(
            'googleUserId' => $data['googleUserId'],
          );
          $con1 = array(
            'email' => $data['email'],
          );
          $this->db->where($con);
          $this->db->or_where($con1);
          $query = $this->db->get();
          $check = $query->num_rows();


          if($check <= 0){
            // Insert user data
            $data['updated_at']=time();
            $data['userlevel'] = 'S';
            $data['agency'] = '1,2,3,4';
            $insert = $this->db->insert('users_portal',$data);
            // user id
            // $userID = $this->db->insert_id();
            $userID = $data['googleUserId'];
          } else {
            $row = $query->row();
            //$userID = $row->googleUserId;
            //$this->db->where('googleUserId',$userID);
            $userID = $data['googleUserId'];
            $email = $row->email;
            //print_r($row);die;
            $this->db->where('email',$email);
            $this->db->update('users_portal',['googleUserId'=>$data['googleUserId'],'updated_at'=>time(),'userState'=>1]);
          }


          $this->db->select('googleUserId,email');
          $this->db->from('supervisor');
          $con = array(
            //'googleUserId' => $data['googleUserId'],
            'email' => $data['email'],
          );
          $this->db->where($con);
          $query = $this->db->get();
          $scheck = $query->num_rows();
          if($scheck<=0) {
            $dataArray = [];
            $dataArray['googleUserId'] = $data['googleUserId'];
            $dataArray['name'] = $data['name'];
            $dataArray['firstname'] = $data['name'];
            $dataArray['email'] = $data['email'];
            $dataArray['Agency'] = 0;
            $supervisorId = $this->db->insert('supervisor',$dataArray);  
          } else {
            $row = $query->row();
            $userID = $data['googleUserId'];
            $email = $row->email;
            //$this->db->where('googleUserId',$userID);
            $this->db->where('email',$email);
            $this->db->update('supervisor',['googleUserId'=>$userID]);
          }

          // Return user id
          return $userID?$userID:false;
        }

        public function changeUserState($userId='')
        {
          $time=time();
          $bufferTime = 300;
          if(!empty($userId)){
            $this->db->where('user_id',$userId);
            $this->db->or_where('googleUserId',$userId);
            $this->db->update('users_portal',['updated_at'=>$time,'userState'=>1]);
          }

          $sql = "SELECT * FROM `users_portal` WHERE `updated_at`+$bufferTime < $time";
          $res = $this->db->query($sql);
          if($res->num_rows() > 0)
          {
            $userIds = implode(',',array_column($res->result_array(), 'user_id'));
            $this->db->where_in('user_id',$userIds,FALSE);
            $this->db->update('users_portal',['userState'=>0]);
          }
        }

        /*Update any data*/
         public function updateSingleRow($table, $where, $data)
        {
            $this->db->where($where);
            $this->db->update($table,$data);
        }

        public function getUserByCounrty($country)
        { 
          $country = explode(',',$country);  
          $result = "" . implode ( "', '", $country ) . "";  
          $query =$this->db->query("SELECT * FROM `users` WHERE `country` IN ('".$result."') AND `status`='1'");
          return $query->result();
       }

      public function get_post_by_country($limit, $offset,$where,$userId) {
        $this->db->where($where);
        $this->db->where_in('user_id',$userId);    
        $this->db->select('*');
        $this->db->order_by('postID', 'desc');  
        $this->db->from('post');
        $this->db->limit($limit, $offset);
        $query = $this->db->get();
        return $query->result_array();
      }

      public function get_row( $table, $where=[] , $column='*') {    
        $this->db->select( $column );
        $this->db->from( $table );
        $this->db->where( $where );
        return $this->db->get()->row_array();   
      }
      
      /*
      public function get_rows_old( $table, $where=[], $orderBy='', $orderType='', $column="*", $limit='', $where_in_col, $where_in_arr, $or_where =[]) {   
        $this->db->select( $column );
        $this->db->from( $table );
        if(!empty($where)) {
          $this->db->where( $where );  
        }
        if(!empty($or_where)) {
          $this->db->or_where($or_where);
        }
        if(!empty($where_in_col)) {
          $this->db->where_in($where_in_col, $where_in_arr);    
        }
        if($orderBy!='' && $orderType!='') {
          $this->db->order_by($orderBy,$orderType);
        }
        if($limit) {
          $this->db->limit($limit);
        }
        return $this->db->get()->result_array();          
      }
      */

      public function get_rows( $table, $where=[], $orderBy='', $orderType='', $column='*', $limit='', $where_in_col=[], $where_in_arr=[], $or_where=[]) {   
        if(empty($column)) {
          $column = '*';
        }
        $this->db->select( $column );
        $this->db->from( $table );
        if(!empty($where)) {
          $this->db->where( $where );  
        }
        if(!empty($or_where)) {
          $this->db->or_where($or_where);
        }
        if(!empty($where_in_col)) {
          $this->db->where_in($where_in_col, $where_in_arr);    
        }
        if($orderBy!='' && $orderType!='') {
          $this->db->order_by($orderBy,$orderType);
        }
        if($limit) {
          $this->db->limit($limit);
        }
        return $this->db->get()->result_array();          
      }


      public function get_rows2( $table, $where=[], $or_where =[]) {   
        $this->db->select( $column );
        $this->db->from( $table );
        if(!empty($where)) {
          $this->db->where( $where );  
        }
        if(!empty($or_where)) {
          $this->db->or_where($or_where);
        }
        if(!empty($where_in_col)) {
          $this->db->where_in($where_in_col, $where_in_arr);    
        }
        if($orderBy!='' && $orderType!='') {
          $this->db->order_by($orderBy,$orderType);
        }
        if($limit) {
          $this->db->limit($limit);
        }
        return $this->db->get()->result_array();          
      }
      
      public function delete_row($table,$where){
        $this->db->where($where);
        return $this->db->delete($table);
      }

      public function insert($table, $data){
        $this->db->insert($table,$data);
        $insert_id  = $this->db->insert_id();
        return $insert_id;
      }
      public function update($table, $where, $data) {
        //$data['updatedOn']    = current_datetime();
        $this->db->where($where);
        $update = $this->db->update($table, $data); 
        return $update;
      }
      public function countrow($table, $where){
        if (!empty($table)) {
          $this->db->select('*');
          $this->db->from($table);
          $this->db->where($where);
          $query = $this->db->get();
          //print_r($this->db->last_query());
          return $query->num_rows();
        }        
      }
    }       