<?php
    /**
    * 
    */
    class Employee_model extends CI_Model {
        
      function __construct() {
          parent:: __construct();
      }

      
      public function getCustomQueryData($MySQL) {
          $query = $this->db->query($MySQL);
          return $query->result_array();           
      }

      public function getAssignedPatientData($where=[], $like=[], $not_like=[]) {
        $select   = array(
                            "ea.*",
                            "pa.*",
                          );
          $this->db->select($select);
          $this->db->from("employee_assignment as ea");
          $this->db->join('patient as pa', 'ea.patient_id = pa.patient_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          if(!empty($like)){
            $this->db->like($like);
          }
          if(!empty($not_like)){
            $this->db->not_like($not_like);
          }
          return $this->db->get()->result_array();    
      }

      public function getActiveAssignedEmployeeData($where=[], $like=[], $not_like=[]) {
        $select   = array(
                            "ea.*",
                            "pa.*",
                            "em.ssn",
                          );
          $this->db->select($select);
          $this->db->from("employee_assignment as ea");
          $this->db->join('patient as pa', 'ea.patient_id = pa.patient_id');
          $this->db->join('employee as em', 'em.employee_id = ea.employee_id');
          if(!empty($where)) {
            $this->db->where($where);
          }
          if(!empty($like)) {
            $this->db->like($like);
          }
          if(!empty($not_like)) {
            $this->db->not_like($not_like);
          }
          return $this->db->get()->result_array();    
      }

      public function getActiveAssignedEmployeeData2($where=[], $like=[], $not_like=[]) {
        $select   = array(
                            "ea.*",
                            "pa.*",
                            "em.ssn",
                            "SUM(ea.total_limit) as total_limit"
                          );
          $this->db->select($select);
          $this->db->from("employee_assignment as ea");
          $this->db->join('patient as pa', 'ea.patient_id = pa.patient_id');
          $this->db->join('employee as em', 'em.employee_id = ea.employee_id');          
          if(!empty($where)) {
            $this->db->where($where);
          }
          if(!empty($like)) {
            $this->db->like($like);
          }
          if(!empty($not_like)) {
            $this->db->not_like($not_like);
          }
          $this->db->group_by('ea.employee_id'); 
          return $this->db->get()->result_array();    
      }

      public function getTotalWorkHourEmployeeData($where=[], $like=[], $not_like=[], $having='') {
        $select   = array(
                            "em.employee_id",
                            "em.ssn",
                            "em.name as employee_name",
                            "SUM(ea.total_limit) as totalWorkedHours",
                            "su.name as supervisor_name",
                            "al.agency_location_name",
                          );
          $this->db->select($select);
          $this->db->from("employee_assignment as ea");
          $this->db->join('employee as em', 'em.employee_id = ea.employee_id');
          $this->db->join('supervisor as su', 'su.supervisor_id = em.supervisor_id', 'left');
          $this->db->join('agency_location as al', 'al.agency_location_code = em.agency_location', 'left');
          $this->db->group_by('ea.employee_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          if(!empty($like)){
            $this->db->like($like);
          }
          if(!empty($not_like)){
            $this->db->not_like($not_like);
          }
          if(!empty($having)) {
            $this->db->having($having);
          }

          return $this->db->get()->result_array();    
      }


      public function getNearByEmployeeData($where=[], $limit=10, $start=0) {
        $select   = array(
                            "em.*",
                            "su.name as supervisor_name",
                          );
          $this->db->select($select);
          $this->db->from("employee as em");
          $this->db->join('supervisor as su', 'em.supervisor_id = su.supervisor_id');
          if(!empty($where)){
            $this->db->where($where);
          }

          if($limit!='' && $start!=''){
              $this->db->limit($limit, $start);
          }
          if($limit!='' && $start==''){
            $this->db->limit($limit);
          }
          $this->db->order_by('em.employee_id', 'desc');
          return $this->db->get()->result_array();    
      }

  }       
    