<style type="text/css">
    .custom-name {border-radius: 50%;padding: 13px;height: 50px;width: 50px;}
    .dataTables_filter, .dataTables_length {display: none;}
    .mt-10 { margin-top: 10px; }
</style>
<div id="page-wrapper">
    <div class="container-fluid">
        <div class="row bg-title">
            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
                <h4 class="page-title"></h4>
            </div>
            <div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box" style="padding: 20;margin-bottom: 1px;">
                    <h3 style="display: inline; vertical-align: middle;"><?php echo'Check Distance'; ?></h3>
                </div>
                <div class="white-box" class="table-editable" id="table" style="padding: 10px 25px;">
                    <?php if ($this->session->flashdata('message')) { ?>
                        <?php echo $this->session->flashdata('message'); ?>
                    <?php } ?>
                    <div style="margin-bottom: 20px;">
                        <form class="filter-form" method="post" action="">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="msgError"></div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group mx-sm-3 mb-2 mt-10">
                                        <label>Enter Address From</label>
                                        <input class="form-control" name="origin" id="autocomplete" placeholder="Enter Address From" onfocus="geolocate();">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group mx-sm-3 mb-2 mt-10">
                                        <label>Enter Address To</label>
                                        <input class="form-control" name="destination" id="autocomplete1" placeholder="Enter Address To">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <label style="width: 100%;">&nbsp;</label>
                                    <button type="button" name="cdistance" value="cdistance" class="btn btn-info mb-2 mt-10 cdistance">Calculate Distance</button>
                                </div>
                                <div class="col-sm-12">
                                    <div class="msgSuccess"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>        
        <script src="<?php echo base_url('assets2/');?>plugins/bower_components/jquery/dist/jquery.min.js"></script>
        <script>
        var placeSearch; 
        var autocomplete;
        var componentForm = {
          street_number: 'short_name',
          route: 'long_name',
          locality: 'long_name',
          administrative_area_level_1: 'short_name',
          country: 'long_name',
          postal_code: 'short_name'
        };

        function initAutocomplete() {
            // Create the autocomplete object, restricting the search predictions to
            // geographical location types.
            autocomplete = new google.maps.places.Autocomplete(
              document.getElementById('autocomplete'), {types: ['geocode']});
            // Avoid paying for data that you don't need by restricting the set of
            // place fields that are returned to just the address components.
            autocomplete.setFields(['address_component','geometry']);
            // When the user selects an address from the drop-down, populate the
            // address fields in the form.

            autocomplete1 = new google.maps.places.Autocomplete(
              document.getElementById('autocomplete1'), {types: ['geocode']});
            // Avoid paying for data that you don't need by restricting the set of
            // place fields that are returned to just the address components.
            autocomplete1.setFields(['address_component','geometry']);
            // When the user selects an address from the drop-down, populate the
            // address fields in the form.
        }

        // Bias the autocomplete object to the user's geographical location,
        // as supplied by the browser's 'navigator.geolocation' object.
        function geolocate() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                var circle = new google.maps.Circle(
                  {center: geolocation, radius: position.coords.accuracy});
                autocomplete.setBounds(circle.getBounds());
                });
            }
        }
        </script>

        <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAbxu8Br_aK35UYVJUqvYrUDmDJ9DBe2uY&libraries=places&callback=initAutocomplete"
        async defer></script>
        <script type="text/javascript">
        $(document).ready(function() {
            $('.cdistance').click(function() {                
                var origin;
                origin = $('#autocomplete').val();
                var destination;
                destination = $('#autocomplete1').val();

                if(origin=='') {
                    $('.msgError').html('<label class="alert alert-danger">Address can not be blank.</label>');
                } else if(destination===0) {
                    $('.msgError').html('<label class="alert alert-danger">Address can not be blank.</label>');
                } else if(origin.length===0) {
                    $('.msgError').html('<label class="alert alert-danger">Address can not be blank.</label>');
                } else if(destination.length===0) {
                    $('.msgError').html('<label class="alert alert-danger">Address can not be blank.</label>');
                } else {
                    $('.cdistance').attr('disabled',true);
                    var smsText = $('#smsText').val();
                    var request = $.ajax({
                        url: "<?php echo base_url('tools/calculateDistance'); ?>",
                        method: "POST",
                        data: { origin:origin,destination:destination },
                    });
                    request.done(function( data ) {
                        $('.msgSuccess').html('<h2>Distance : '+data+'</h2>');
                        $('.cdistance').attr('disabled',false);
                        $.toast({
                            heading: 'Distance has been calculated successfully.',
                            position: 'top-right',
                            loaderBg: '#fff',
                            icon: 'success',
                            hideAfter: 4000,
                            stack: 6
                        });
                    });
                    request.fail(function( jqXHR, textStatus ) {
                        $('.cdistance').attr('disabled',false);
                        $.toast({
                            heading: 'Oops! something went wrong. Try Again.',
                            position: 'top-right',
                            loaderBg: '#fff',
                            icon: 'error',
                            hideAfter: 4000,
                            stack: 6
                        });
                    });
                }
            });
        });
        </script>