// Wait for the DOM to be ready
$(function(){
    // Initialize form validation on the registration form.
    // It has the name attribute "registration"
    var form = $('#check_request_frm');
    var errorHandler = $('.errorHandler', form);
    var successHandler = $('.successHandler', form);

    $("form[name='check_request_frm']").validate({
        errorElement: "span", // contain the error msg in a span tag
        errorClass: 'error',
        errorPlacement: function (error, element) { // render error placement for each input type
            if (element.attr("type") == "radio" || element.attr("type") == "checkbox") { // for chosen elements, need to insert the error after the chosen container
                //error.insertAfter($(element).closest('.form-group').children('div').children().last());
                error.insertAfter($(element).closest('.form-group').children().last());
            } else if (element.attr("name") == "dd" || element.attr("name") == "mm" || element.attr("name") == "yyyy") {
                error.insertAfter($(element).closest('.form-group').children('div'));
            } else {
                error.insertAfter(element);
                // for other inputs, just perform default behavior
            }
        },
        // Specify validation rules
        rules: {
            pay_rate: {
                //required: true,
                //number: true,
            },
            reason: {
                required: true,
            },
            check_sent: {
                required: true,
            },
            request: {
                required: true,
            }
        },
        // Specify validation error messages
        messages: {
            pay_rate:{
                //required :"Pay rate is required",
                //number :"Please enter number only",
            },
            reason: "Reason is required",
            check_sent: "This field is required",
            request: "This field is required",
        },
        invalidHandler: function (event, validator) { //display error alert on form submit
            successHandler.hide();
            errorHandler.show();
        },
        highlight: function (element) {
            $(element).closest('.help-block').removeClass('valid');
            // display OK icon
            $(element).closest('.form-group').removeClass('has-success').addClass('has-error').find('.symbol').removeClass('ok').addClass('required');
            // add the Bootstrap error class to the control group
        },
        unhighlight: function (element) { // revert the change done by hightlight
            $(element).closest('.form-group').removeClass('has-error');
            // set error class to the control group
        },
        success: function (label, element) {
            label.addClass('help-block valid');
            // mark the current input as valid and display OK icon
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success').find('.symbol').removeClass('required').addClass('ok');
        },
        submitHandler: function (form) {
            successHandler.show();
            errorHandler.hide();
            return true;
        }
    }); 


    var form = $('#denied_request_frm');
    var errorHandler = $('.errorHandler', form);
    var successHandler = $('.successHandler', form);

    $("form[name='denied_request_frm']").validate({
        errorElement: "span", // contain the error msg in a span tag
        errorClass: 'error',
        errorPlacement: function (error, element) { // render error placement for each input type
            if (element.attr("type") == "radio" || element.attr("type") == "checkbox") { // for chosen elements, need to insert the error after the chosen container
                //error.insertAfter($(element).closest('.form-group').children('div').children().last());
                error.insertAfter($(element).closest('.form-group').children().last());
            } else if (element.attr("name") == "dd" || element.attr("name") == "mm" || element.attr("name") == "yyyy") {
                error.insertAfter($(element).closest('.form-group').children('div'));
            } else {
                error.insertAfter(element);
                // for other inputs, just perform default behavior
            }
        },
        // Specify validation rules
        rules: {
            reason: {
                required: true,
            }
        },
        // Specify validation error messages
        messages: {
            reason: "Reason is required",
        },
        invalidHandler: function (event, validator) { //display error alert on form submit
            successHandler.hide();
            errorHandler.show();
        },
        highlight: function (element) {
            $(element).closest('.help-block').removeClass('valid');
            // display OK icon
            $(element).closest('.form-group').removeClass('has-success').addClass('has-error').find('.symbol').removeClass('ok').addClass('required');
            // add the Bootstrap error class to the control group
        },
        unhighlight: function (element) { // revert the change done by hightlight
            $(element).closest('.form-group').removeClass('has-error');
            // set error class to the control group
        },
        success: function (label, element) {
            label.addClass('help-block valid');
            // mark the current input as valid and display OK icon
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success').find('.symbol').removeClass('required').addClass('ok');
        },
        submitHandler: function (form) {
            successHandler.show();
            errorHandler.hide();
            return true;
        }
    }); 
});