<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Admin extends CI_Controller
{
    public function __construct()
    {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        } else {
            $this->headerData=[];
        }

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }

    public function GoogleLogin() {
        if(isset($_GET['code'])) {
            if($userData = $this->google->getAuthenticate()){
                $domain_name = substr(strrchr($userData['email'], "@"), 1);
               // $validDomains = ['gmail.com','garciapharmacy.com','hcpcaregivers.com'];
                $validDomains = ['hcpcaregivers.com','garciapharmacy.com'];
                if(in_array($domain_name, $validDomains))
                {
                    $userID = $this->Comman_model->checkGoogleUser($userData);
                    $where = [];
                    $where['googleUserId'] = $userData['googleUserId'];
                    $userDetails = $this->Comman_model->get_row('user', $where);

                    $where = [];
                    $where['googleUserId'] = $userData['googleUserId'];
                    $supervisorDetails = $this->Comman_model->get_row('supervisor', $where);

                    //print_r($userDetails);die;

                    $sess_array = array(
                       'name' => $userData['name'],
                       'id' => $userDetails['user_id'],
                       'googleId' => $userID,
                       'userlevel' => $userDetails['userlevel'],
                       'useragency' => $userDetails['agency'],
                       'userId' => $supervisorDetails['supervisor_id'],
                       'image_url' => $userDetails['image_url'],
                       'googleUser'=>true,
                   );
                    $this->session->set_userdata($sess_array);
                    $this->session->set_userdata('name',$userData['name']);
                    redirect('Admin/home'); 
                    //redirect('admin/client');
                }else{
                    $data['loginURL'] = $this->google->get_login_url();
                    $this->session->set_flashdata('msg', 'Sorry, your account is not valid, please contact our technical support team.');
                    redirect('',$data);
                }
            }
        }
        else{
            $data['loginURL'] = $this->google->get_login_url();
            $this->session->set_flashdata('msg', 'Sorry, something went wrong. Try Again.');
            redirect('Admin/login',$data);
        }
    }

    public function calendarData()
    {
        $startDate = $this->input->get('start');
        $endDate = $this->input->get('end');
        $calenderData = $this->google->getCalendarEvent($startDate,$endDate);
        die(json_encode($calenderData));
    }
    public function seeAttach($messageId,$partId)
    {
        $messageId = base64_decode($messageId);
        $partId = base64_decode($partId);
        $data['inboxDetails'] = $this->google->fetchAttachment($messageId,$partId);
    }
    public function inboxEmail($label='INBOX',$nextPageToken='')
    {
        if(isset($_SESSION['name'])) 
        {
            $getResponseEmail = $this->google->inboxEmails($_SESSION['id'],$label,$nextPageToken);
            $data['label'] = $label;
            $data['nextPageToken'] = isset($getResponseEmail['pageToken'])?$getResponseEmail['pageToken']:'';
            unset($getResponseEmail['pageToken']);
            $data['prevPageToken'] = $nextPageToken;
            $data['inboxEmails'] = $getResponseEmail;
            $this->load->view('common/header.php',$this->headerData);
            $this->load->view('common/sidebar.php');
            $this->load->view('inbox_email.php',$data);
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function inboxDetail($messageId)
    {
        if(isset($_SESSION['name'])) 
        {
            $messageId = base64_decode($messageId);
            $data['inboxDetails'] = $this->google->inboxDetails($_SESSION['id'],$messageId);
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('inbox_detail.php',$data);
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function inboxCompose()
    {
        if(isset($_SESSION['name'])) 
        {
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('inbox_compose.php');
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function inboxReply()
    {
        $data['messageId'] = $this->input->post('messageId');
        $data['subject'] = $this->input->post('subject');
        $data['to_email'] = $this->input->post('to_email');
        if(isset($_SESSION['name'])) 
        {
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('inbox_compose.php',$data);
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    function x_week_range($date) {
        $ts = strtotime($date);
        $start = (date('w', $ts) == 0) ? $ts : strtotime('last sunday', $ts);
        return array(date('c',strtotime('-1 day', $start)),
         date('c', strtotime('+1 day',strtotime('next saturday', $start))));
    }
    public function sendCompose()
    {
        $to_email =$this->input->post('to_email'); 
        $subject = $this->input->post('subject');
        $msg = $this->input->post('msg');
        $messageId = $this->input->post('messageId');
        $getResponse = $this->google->sendMail($to_email,$subject,$msg,$messageId);
        redirect('Admin/inboxCompose');    
    }
    public function googleTaskStatus()
    {
        $taskId = $this->input->post('taskId');
        $this->google->changeTaskStatus($taskId);
    }
    public function googleTaskInsert()
    {
        date_default_timezone_set('America/Chicago');
        $title= $this->input->post('title');
        $notes= $this->input->post('desc');
        $dueDate= $this->input->post('dueDate');
        $dueDate = date('c',strtotime($dueDate));
        $this->google->taskInsert($title,$notes,$dueDate);
        redirect('Admin/home', 'refresh');
    }
    public function googleEventAdd()
    {
        $title = $this->input->post('title');
        $startTime = $this->input->post('start');
        $endTime = $this->input->post('end');
        $date = $this->input->post('selectedDate');
        $start = strtotime($date.' '.$startTime);
        $end = strtotime($date.' '.$endTime);
        $reminder = $this->input->post('reminder');
        $eventArr = [
            'summary'=>$title,
            'start'=>['dateTime'=>date('c',$start),'timeZone' => 'America/Chicago'],
            'end'=>['dateTime'=>date('c',$end),'timeZone' => 'America/Chicago'],
        ];
        if($reminder == 'on')
        {
            $eventArr['reminders']=[
                'useDefault' => FALSE,
                'overrides' => 
                array(
                    array('method' => 'email', 'minutes' => 24 * 60),
                )
            ];
        }
        $this->google->googleEventInsert($eventArr);
    }
    public function googleEventDelete()
    {
        $eventId = $this->input->post('id');
        $this->google->googleEventDelete($eventId);
    }
    public function Chats()
    {
        if(isset($_SESSION['name'])) 
        {
            $this ->load -> view('common/header.php',$this->headerData);
            $this ->load -> view('common/sidebar.php');
            $this ->load ->view('chatuser.php');
            $this->load->view('common/footer.php');
        }
        else{
            redirect();
        }
    }
    public function newMessageNotifyList()
    {
        $user_id = $this->receiverId; 
        $sql = "SELECT * from user_chat where receiverId = $user_id and seenState=1 and notified IN (0,1)";
        $res=$this->db->query($sql);
        $i=0;
        $messageArr=[];
        foreach ($res->result_Array() as $key => $value) {
            $messageArr[$i]['senderName'] = $this->db->get_where('user', array('user_id' => $value['senderId']))->row()->name;
            $messageArr[$i]['message'] = $value['message'];
            $i++;
        }
        return $messageArr;
    }


    

    public function index() {
        if (isset($_SESSION['name'])) { 
            $total_parent  = $this->Api_model->count('parent');
            $total_staff   = $this->Api_model->count('staff');
            $total_student = $this->Api_model->count('student');    
            $getstaff              = $this->Api_model->getAllDataLimit('staff', 5);
            $data['getstaff']      = $getstaff;
            $data['total_parent']  = $total_parent;
            $data['total_staff']   = $total_staff;
            $data['total_student'] = $total_student;
            $data['page']          = 'home';
            $this->load->view('common/head.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('dashboard.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }
    
    public function Chatpage() {
        if(isset($_SESSION['name'])) {
            $data['user_reciver_id'] = $this->uri->segment(3);
            $data['task1'] = $this->Api_model->getAllData('task');
            $data['task'] = $this->Api_model->getAllDataLimit('task','5');
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('viewChat.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function Test() {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('test.php');
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function demo_map() {
        // echo "hello"; die;
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('demo_map.php');
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function Addtestclient() {
        if(isset($_SESSION['name'])) {
            $this->load->view('addtestclient.php');
            
            // $this->load->view('common/header.php');
            // $this->load->view('common/sidebar.php');
            // $this->load->view('addtestclient.php');
            // $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    // For View & Insert Client
    public function Client()   //Listing/View Client
    {
        if(isset($_SESSION['name'])) {

        	//print_r($_SESSION);die;
            // $data['patient'] = $this->db->get('patient')->result();
            //$where= [];
            // $where['Agency'] = $_SESSION['agency'];
            //$data['patient'] = $this->Api_model->getAllDataWhere($where, 'patient');

            $data['patient']    =   $this->client->get_clients($_SESSION['agency']);

            $where= [];
            $where['Agency'] = $_SESSION['agency'];
            $data['districts'] = $this->Api_model->getAllDataWhere($where, 'tbldistricts');

            $where= [];
            $data['agencyLocation'] = $this->Api_model->getAllDataWhere($where, 'agency_location');

            $where= [];
            $data['supervisor'] = $this->Api_model->getAllDataWhere($where, 'supervisor');


            $message1 = $message2 = '';
            if (empty($data['patient']) &&  !empty($this->input->post('lastname'))) {
                $lastname = $this->input->post('lastname');
                $MySQLx = "SELECT SQL_CALC_FOUND_ROWS patient.lastname, patient.firstname, Agency FROM patient WHERE patient.lastname LIKE '%".$lastname."%' ";      
                $objExecx = $this->Comman_model->getCustomQueryData($MySQLx);
                $intRows = 0;
                foreach ($objExecx as $key => $objResultx) {
                    $intRows++; 
                    $Agency = $objResultx["Agency"];

                    if ($Agency == 1) {
                        $AgencyName = 'HM';
                    }
                    if ($Agency == 2) {
                        $AgencyName = 'SC';
                    }
                    if ($Agency == 3) {
                        $AgencyName = 'CG';
                    }
                    if ($Agency == 4) {
                        $AgencyName = 'RF';
                    }        
                    $message1 .= '<div class="text-center"><b>"'.$objResultx["lastname"].", ".$objResultx["firstname"].", ".$AgencyName.'"</b></div></br>';
                }

                if ($intRows == 0)  {
                    $message2 .= '<h2 class="text-center">Zero Result. Please check other Agencies.</h2>';
                }
            }

            // $data['patient']    =   [];
            $data['message1'] = $message1;
            $data['message2'] = $message2;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('viewClient.php',$data);
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function importPatientCSV() {
        //print_r($_FILES);die;
        if(!empty($_FILES['patientcsv'])){
            $img_data   =   [];
            $img_data['path']   =   'image/uploads';
            $img_data['file_name']  =   'patientcsv';
            $img_data['allowed_type']   =   '*';
            $img_data['old_file']   =   '';
            $img_data['width']  =   '';
            $img_data['height'] =   '';
            $img_data['quality']    =   '60%';
            $img_data['image_compress'] =   False;

            $img=$this->uploadfiles($img_data);

            //print_r($img);die;
            if(!empty($img['status']=='1')){
                $filename = $img['url'];
                $fileurl = base_url('image/uploads').'/'.$filename;

                if (($handle = fopen($fileurl, "r")) !== FALSE) {
                    while (($data = fgetcsv($handle, 100000, ",")) !== FALSE) {
                        $num = count($data);
                        // echo "<p> $num fields in line $row: <br /></p>\n";
                        //$row++;
                        //for ($c=0; $c < $num; $c++) {
                        //echo $data[$c] . "<br />\n";
                        //}
                        $patient_id = $data[0];
                        $med_medicaidno = $data[4];
                        $med_status2 = $data[3];
                        $med_effdate = date('Y-m-d',strtotime($data[5]));
                        $med_enddate = date('Y-m-d',strtotime($data[6]));

                        /*$query1 = mysql_query("UPDATE  patient 
                        SET med_medicaidno='$med_medicaidno' 
                        WHERE patient_id = '$patient_id'" ) or die (mysql_error());*/

                        $where = [];
                        $where['patient_id'] = $patient_id;
                        $dataArray = [];
                        $dataArray['med_medicaidno'] = $med_medicaidno;
                        $this->Comman_model->update('patient', $where, $dataArray);

                        //echo $med_effdate.' '.$med_enddate.'</br>';               
                        $confirm1 = 0;
                        $confirm2 = 0;
                        list($years,$months,$days)=explode("-",$med_effdate);

                        if(@checkdate($months,$days,$years)) {
                            $confirm1 = 1;
                        }
                        
                        list($years,$months,$days)=explode("-",$med_enddate);
                        if(@checkdate($months,$days,$years)) {
                            $confirm2 = 1;
                        }

                        if ($confirm1 == 1 && $confirm2 == 1 ) {

                            if ( $med_effdate > date('Y-m-d') ) {
                                $med_status = 'Pending';
                                //$query1 = mysql_query("UPDATE  patient SET med_status='$med_status' WHERE patient_id = '$patient_id'" ) or die (mysql_error());
                                //echo "Pending";
                                $where = [];
                                $where['patient_id'] = $patient_id;
                                $dataArray = [];
                                $dataArray['med_status'] = $med_status;
                                $this->Comman_model->update('patient', $where, $dataArray);

                            }

                            if ( date('Y-m-d')  <=  $med_enddate &&    date('Y-m-d') >= $med_effdate ) {
                                $med_status = 'Active';
                                //$query1 = mysql_query("UPDATE  patient SET med_status='$med_status' WHERE patient_id = '$patient_id'" ) or die (mysql_error());
                                //echo "Active";

                                $where = [];
                                $where['patient_id'] = $patient_id;
                                $dataArray = [];
                                $dataArray['med_status'] = $med_status;
                                $this->Comman_model->update('patient', $where, $dataArray);
                            }

                            if(date('Y-m-d')  > $med_enddate) {
                                $med_status = 'Expired';
                                //$query1 = mysql_query("UPDATE  patient SET med_status='$med_status' WHERE patient_id = '$patient_id'" ) or die (mysql_error());
                                //echo "Expired";

                                $where = [];
                                $where['patient_id'] = $patient_id;
                                $dataArray = [];
                                $dataArray['med_status'] = $med_status;
                                $this->Comman_model->update('patient', $where, $dataArray);
                            }

                        }   

                            /*$query1 = mysql_query("UPDATE  patient 
                            SET med_effdate='$med_effdate', 
                            med_enddate='$med_enddate'              
                            WHERE patient_id = '$patient_id'" ) or die (mysql_error());*/

                            $where = [];
                            $where['patient_id'] = $patient_id;
                            $dataArray = [];
                            $dataArray['med_effdate'] = $med_effdate;
                            $this->Comman_model->update('patient', $where, $dataArray);

                        if ($med_status2 == 'NE' )  {
                            /*$query1 = mysql_query("UPDATE  patient 
                            SET med_status='$med_status2' 
                            WHERE patient_id = '$patient_id'" ) or die (mysql_error());*/
                            //echo "hello";

                            $where = [];
                            $where['patient_id'] = $patient_id;
                            $dataArray = [];
                            $dataArray['med_status'] = $med_status2;
                            $this->Comman_model->update('patient', $where, $dataArray);

                        }               

                    }
                    fclose($handle);

                    $data['file'] = $_FILES;

                    //print_r($data['file']);

                    $this->load->view('common/header.php');
                    $this->load->view('common/sidebar.php');
                    $this->load->view('importPatientCSV.php',$data);
                    $this->load->view('common/footer.php');
                }
            }
        }
    }

    public function AddClient()   //Insert AddClient
    {
        //print_r($_SESSION);
        if(isset($_SESSION['name'])) {
            $data = [];
            $data['validateClient'] = 'validate';
            if(isset($_SESSION['client'])) {
                $data['validateClient'] = $_SESSION['client'];
            }
            $data['patient_image'] = base_url('assets2/texst.jpg');
            if(!empty($_GET['patient'])) {
                $where  = [];
                $where['patient_id']    =   $_GET['patient'];
                $data['patientData']    =   $this->Comman_model->get_row('patient', $where);
                if(!empty($data['patientData']['image_path'])) {
                    $data['patient_image'] = base_url('image/client_image/'.$data['patientData']['image_path']);
                }

                if(empty($data['patientData'])){
                    redirect('Admin/AddClient');
                }

                if(!empty($data['patientData']['DistrictID_Ref'])) {
                    $where = [];
                    $where['DistrictID_Ref'] = $data['patientData']['DistrictID_Ref'];
                    $where['Agency'] = $_SESSION['agency'];  
                    $data['districtDataMco'] = $this->Comman_model->get_rows('tbldistrictmanagers', $where);
                }
                

                $where  = [];
                $where['ea.patient_id']    =   $_GET['patient'];
                $data['assignEmployeeData']    =   $this->client->get_assigned_employee($where);

                $data['validateClient'] = 'add';

                $where = [];
                $where['patient_id'] = $_GET['patient'];
                $patientService = $this->Comman_model->countrow('tblpatientservices', $where);
                if($patientService==0) {
                    $dataArray = [];
                    $dataArray['patient_id'] = $_GET['patient'];
                    $dataArray['Agency'] = $_SESSION['agency'];
                    $this->Comman_model->insert('tblpatientservices', $dataArray);
                }


                $where = [];
                $where['patient_id']  = $_GET['patient'];
                $where['category']  = 'facesheet';
                $data['patient_facesheet'] = $this->Comman_model->get_row('patient_image', $where);

                $where = [];
                $where['patient_id']  = $_GET['patient'];
                $where['category']  = 'insurance';
                $data['patient_insurance'] = $this->Comman_model->get_row('patient_image', $where);

                $where = [];
                $where['patient_id']  = $_GET['patient'];
                $where['category']  = 'plan_of_care';
                $data['patient_plan_of_care'] = $this->Comman_model->get_row('patient_image', $where);


                $where  =   [];
                $where['agency_code'] =   $data['patientData']['Agency'];
                $data['agencyData'] = $this->Comman_model->get_row('agency', $where);


                $where  =   [];
                $where['dt.patient_id'] =   $_GET['patient'];
                $where['td.Agency'] =   $_SESSION['agency'];
                $data['DistrictID_temp_Data'] = $this->client->getPreviousDistricts($where);
            }

            if(!empty($_SESSION['agency'])) {

                $where  =   [];
                $where['Agency'] =   $_SESSION['agency'];
                $data['allEmployeeData'] = $this->Comman_model->get_rows('employee', $where);

                $where  =   [];
                $where['Agency'] =   $_SESSION['agency'];
                $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where, 'DistrictNumber', 'asc');

            }

            $where = [];
            $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');


            $where= [];
            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where);

            $where= [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where);

            $where= [];
            $data['allAgencyData'] = $this->Comman_model->get_rows('agency', $where);

            /*$where= [];
            $data['agencyLocation'] = $this->Api_model->getAllDataWhere($where, 'agency_location');

            $where= [];
            $data['supervisor'] = $this->Api_model->getAllDataWhere($where, 'supervisor');*/


            //print_r($_SESSION);die;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('addClient.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function submit_AddClient() {

        $id  = $this->input->post('patient_id');

        if($id) {

            $where = [];
            $where['patient_id']  = $id;
            $patientData = $this->Comman_model->get_row('patient', $where);

            $dataArray = [];
           
            if(!empty($_FILES['client_image'])){
                $img_data   =   [];
                $img_data['path']   =   'image/client_image';
                $img_data['file_name']  =   'client_image';
                $img_data['allowed_type']   =   'png|jpg|jpeg';
                $img_data['old_file']   =   '';
                $img_data['width']  =   200;
                $img_data['height'] =   200;
                $img_data['quality']    =   '60%';
                $img_data['image_compress'] =   False;

                $img=$this->uploadfiles($img_data);
                if(!empty($img['status']=='1')){
                    $dataArray['image_path']=$img['url'];
                }

                //print_r($_FILES);
                //print_r($img);die;
            }


            /****************** Client Profile *********************/
            $dataArray['userdate']  =   date("Y-m-d H:i:s");
            $dataArray['IsActive']  =   $this->input->post('isActive');
            $dataArray['reason']  =   $this->input->post('reason');
            $dataArray['Agency']  =   $this->input->post('agency_code');
            $dataArray['agency_location']  =   $this->input->post('agency_location');
            $dataArray['device']  =   $this->input->post('device');
            $dataArray['firstname']  =   $this->input->post('firstname');
            $dataArray['lastname']  =   $this->input->post('lastname');
            $dataArray['middlename']  =   $this->input->post('mi');
            $dataArray['name']  =   $this->input->post('lastname').', '.$this->input->post('firstname');
            $dataArray['gender']  =   $this->input->post('gender');
            $dataArray['CustomFieldBirthday']  =   $this->input->post('birthday');
            $dataArray['zerotag'] = $this->input->post('zerotag');
            $dataArray['popalert'] = $this->input->post('popalert');
            $dataArray['popnotes']  =   $this->input->post('popnotes');

            // $dataArray['addaddress'] => $this->input->post('addaddress');
            $dataArray['city']  =   $this->input->post('city');
            $dataArray['ShipAddressState'] = $this->input->post('state');
            $dataArray['zipcode']  =   $this->input->post('zipcode');
            $dataArray['ShipAddressCity']  =   $this->input->post('city');
            $dataArray['ShipAddressState']  =   $this->input->post('state');
            $dataArray['ShipAddressPostalCode']  =   $this->input->post('zipcode');
            $dataArray['ShipAddressAddr2'] = $this->input->post('address1');
            $dataArray['ShipAddressAddr3'] = $this->input->post('address2');
            $dataArray['latitude']  =   $this->input->post('latitude');
            $dataArray['longitude']  =   $this->input->post('longitude');
            $dataArray['macAddress']  =   $this->input->post('macaddress');

            if(empty($patientData['phone'])) {
                $dataArray['phone']  =   $this->input->post('phone');
            }

            $dataArray['phone2']  =   $this->input->post('phone2');
            $dataArray['contactperson']  =   $this->input->post('contact_person');
            $dataArray['contactno']  =   $this->input->post('contact_no');
            $dataArray['race']  =   $this->input->post('race');
            $dataArray['DNR']  =   $this->input->post('DNR');

            /******************** Client Services *************************/
            if(empty($patientData['supervisor_id'])) {
                //$dataArray['supervisor_id']  =   $this->input->post('suplid');
            }
            $dataArray['Notes']  =   $this->input->post('notes');
            $dataArray['VisitationNotesNew']  =   $this->input->post('visitationNotesNew');

            if(!empty($this->input->post('daily_hours_check')) && $this->input->post('daily_hours_check')==1){
                $dataArray['dailyhrs']  =   $this->input->post('dailyhrs');    
                $dataArray['dailyhrslimit']  =   $this->input->post('daily_hours_check');    
            }

            if(!empty($this->input->post('listTask'))) {
                $dataArray['tasks']  =   implode(',', $this->input->post('listTask'));    
            }

            $dataArray['mon_limit']  =   $this->input->post('mon_limit', true);    
            $dataArray['tue_limit']  =   $this->input->post('tue_limit', true);    
            $dataArray['wed_limit']  =   $this->input->post('wed_limit', true);    
            $dataArray['thu_limit']  =   $this->input->post('thu_limit', true);    
            $dataArray['fri_limit']  =   $this->input->post('fri_limit', true);    
            $dataArray['sat_limit']  =   $this->input->post('sat_limit', true);    
            $dataArray['sun_limit']  =   $this->input->post('sun_limit', true);    


            /******************** Client Billing *************************/
            $dataArray['DistrictID_Ref']  =   $this->input->post('DistrictID_Ref');
            $dataArray['NewDistrictStartDate'] = $this->input->post('transferred_date');
            //$dataArray['DistrictID_temp'] = $this->input->post('DistrictID_temp');
            $dataArray['phonefax']  =   $this->input->post('phonefax');
            $dataArray['DistrictManagerID_Ref']  =   $this->input->post('DistrictManagerID_Ref');
            $dataArray['BillType']  =   $this->input->post('BillType');
            $dataArray['BillAddressAddr2']  =   $this->input->post('BillAddressAddr2');
            $dataArray['BillAddressAddr3']  =   $this->input->post('BillAddressAddr3');
            $dataArray['BillAddressAddr4']  =   $this->input->post('BillAddressAddr4');
            $dataArray['BillAddressCity']  =   $this->input->post('BillAddressCity');
            $dataArray['BillAddressState']  =   $this->input->post('BillAddressState');
            $dataArray['BillAddressPostalCode']  =   $this->input->post('BillAddressPostalCode');
            $dataArray['CustomFieldCaseNumber']  =   $this->input->post('CustomFieldCaseNumber');
            $dataArray['MedicareNo']  =   $this->input->post('MedicareNo');
            $dataArray['CustomFieldSSN']  =   $this->input->post('CustomFieldSSN');
            $dataArray['FHCA']  =   $this->input->post('FHCA');
            $dataArray['icd10']  =   $this->input->post('icd10');
            $dataArray['JobStartDate'] = $this->input->post('eleme