<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
defined('BASEPATH') OR exit('No direct script access allowed');
class Applicant extends CI_Controller {
    public function __construct() {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        //$this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        } else {
            $this->headerData=[];
        }

        //$this->load->library('PHPReport');
        //$this->load->helper('download');
        //$this->load->model('Excel_export_model');
    }

    public function index() {
        if (isset($_SESSION['name'])) {
            $query = "SELECT * FROM employee where hired = 0";
            $applicantData  = get_data_other_db($query, 'result', 'hcp_application');
            $data['applicantData']      = $applicantData;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('applicant/view.php', $data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php', $data);
            $this->load->view('applicant/view-new.php', $data);
        } else {
            redirect('');
        }
    }

    public function edit($id) {
        if (isset($_SESSION['name'])) {

            $id = base64_decode($id);

            $query = "SELECT * FROM employee where applicant_id='".$id."'";
            $applicantData  = get_data_other_db($query, 'row', 'hcp_application');
            $data['applicantData']      = $applicantData;
            $data['action']      = 'edit';


            if(!empty($this->input->post()) && !empty($id)) {

                $this->form_validation->set_rules('firstname', 'Firstname', 'trim|required');
                $this->form_validation->set_rules('lastname', 'Lastname', 'trim|required');
                $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required');
                $this->form_validation->set_rules('BirthDate', 'Date of Birth', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressAddr1', 'Employee Address', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressCity', 'City', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressState', 'State', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressPostalCode', 'Zipcode', 'trim|required');
                $this->form_validation->set_rules('gender', 'Gender', 'trim|required');

                if ($this->form_validation->run() != false) {
                    $firstname = $this->input->post('firstname', TRUE);
                    $lastname = $this->input->post('lastname', TRUE);
                    $name = $lastname.', '.$firstname;

                    $contact_number = $this->input->post('phone', TRUE);
                    $EmployeeAddressAddr1 = $this->input->post('EmployeeAddressAddr1', TRUE);
                    $EmployeeAddressAddr2 = $this->input->post('EmployeeAddressAddr2', TRUE);
                    $EmployeeAddressAddr3 = $this->input->post('EmployeeAddressAddr3', TRUE);
                    $EmployeeAddressCity = $this->input->post('EmployeeAddressCity', TRUE);
                    $EmployeeAddressState = $this->input->post('EmployeeAddressState', TRUE);
                    $EmployeeAddressPostalCode = $this->input->post('EmployeeAddressPostalCode', TRUE);
                    $gender = $this->input->post('gender', TRUE);
                    $BirthDate = $this->input->post('BirthDate', TRUE);
                    $email = $this->input->post('email', TRUE);
                    $message = $this->input->post('message', TRUE);

                    $old_image = '';
                    if(!empty($data['applicantData']['image_path'])) {
                        $old_image = $data['applicantData']['image_path'];
                    }

                    $image_path = '';
                    if(!empty($_FILES['app_image'])){
                        $img_data   =   [];
                        $img_data['path']   =   'image/app_image';
                        $img_data['file_name']  =   'app_image';
                        $img_data['allowed_type']   =   'png|jpg|jpeg';
                        $img_data['old_file']   =   $old_image;
                        $img_data['width']  =   200;
                        $img_data['height'] =   200;
                        $img_data['quality']    =   '60%';
                        $img_data['image_compress'] =   False;

                        $img=$this->uploadfiles($img_data);
                        if(!empty($img['status']=='1')){
                            $image_path = $img['url'];
                        }
                    }
                    
                    $where = [];
                    $where['applicant_id'] = $id;

                    $updateQuery = "UPDATE employee SET `first_name` = '$firstname', `last_name` = '$lastname', `contact_number` = '$contact_number', `EmployeeAddressAddr1` = '$EmployeeAddressAddr1', `EmployeeAddressAddr2` = '$EmployeeAddressAddr2', `EmployeeAddressAddr3` = '$EmployeeAddressAddr3', `EmployeeAddressCity` = '$EmployeeAddressCity', `EmployeeAddressState` = '$EmployeeAddressState', `EmployeeAddressPostalCode` = '$EmployeeAddressPostalCode', `gender` = '$gender', `BirthDate` = '$BirthDate', `email` = '$email', `message` = '$message', `image_path` = '$image_path'  WHERE applicant_id = '$id'";
                    get_data_other_db($updateQuery, 'query', 'hcp_application');
                }                
            }

            $query = "SELECT * FROM employee where applicant_id='".$id."'";
            $applicantData  = get_data_other_db($query, 'row', 'hcp_application');
            $data['applicantData']      = $applicantData;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('applicant/edit.php', $data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php', $data);
            $this->load->view('applicant/edit-new.php', $data);
        } else {
            redirect('');
        }
    }

    public function deleteRecord($recordId){
        if(!empty($recordId)){
            $recordId       = decode64($recordId);
            $query = "DELETE from employee where applicant_id='".$recordId."'";
            get_data_other_db($query, 'query', 'hcp_application');
            $this->app->message('Applicant has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }
} 