<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Chat extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    $this->load->database();
    $this->load->library('session');
    $this->load->library('google');
    $this->load->library('user_agent');
    $this->load->library('form_validation');
    $this->load->library('excel');
    $this->load->helper('form');
    $this->load->helper('url');
    $this->load->helper('new_helper');
    $this->load->model('Comman_model');
    $this->load->model('Api_model');
    $this->load->model('Client_model', 'client');
    if(isset($_SESSION['googleUser']))
    {
      $userId = $this->session->userdata('id');
      $this->Comman_model->changeUserState($userId);
      $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
      $googleId = $this->session->userdata('id');
      $userData = $this->db->get_where('users_portal',['googleUserId'=>$googleId])->result();
      $this->receiverId = $userData[0]->user_id;
      $this->headerData['chatNotifyList']= $this->newMessageNotifyList();
    }
    else
    {
      $this->headerData=[];
      $this->receiverId = $this->session->userdata('id');
    }
    $this->load->library('PHPReport');
    $this->load->helper('download');
    $this->load->model('Excel_export_model');
  }
  public function index()
  {
    if(isset($_SESSION['name'])) 
    {
      $this ->load -> view('common/header.php',$this->headerData);
      $this ->load -> view('common/sidebar.php');
      $this ->load ->view('chatuser.php');
      $this->load->view('common/footer.php');
    }
    else{
      redirect();
    }
  }
  public function getName()
  {
    $user_id = $this->receiverId;
    $searchQry = $this->input->post('searchQuery');
    if(!empty($searchQry))
    {
    	$sql1 ="SELECT u.user_id,u.name,u.userState from users_portal u where u.name like '%$searchQry%' and u.user_id!=$user_id"; 
    }
    else
    {
      $sql1 ="SELECT DISTINCT u.user_id,u.name,u.userState from user_chat uc left join users_portal u on uc.receiverId=u.user_id left join user_chat uc1 on uc1.senderId=u.user_id where uc.status=0 and (uc.senderId=$user_id OR uc.receiverId=$user_id) OR (uc1.senderId=$user_id OR uc1.receiverId=$user_id)";
    }
    $res=$this->db->query($sql1);
    if ($this->db->affected_rows() > 0) {
      $Names = "";
      foreach ($res->result_Array() as $record1) {
      	if($record1['user_id']!=$this->receiverId)
      	{
      		$Names.='<li><a href="javascript: void(0);" onclick="getChats('.$record1['user_id'].')"><span>'.$record1['name'].' </span>';
          if($record1['userState']==1)
          {
            $Names.='<small class="text-success">Online</small>';
          }else{
            $Names.='<small class="text-warning">Offline</small>';
          }
          $Names.='</a></li>';
      	}
      }
    }else{
      $Names = "";
      $Names.='<li>No Chats</li>';
    }
    echo $Names;
  }
  public function getChats()
  {
    $senderId = $this->input->post('senderId');
    $receiverId = $this->receiverId;
    $sql = "SELECT *,(select name from users_portal where user_id=$senderId) as senderName,(select name from users_portal where user_id=$receiverId) as receiverName from user_chat WHERE (senderId=$senderId AND receiverId=$receiverId) OR (senderId=$receiverId AND receiverId=$senderId) ORDER BY updateTime asc";
    $res=$this->db->query($sql);
    $html = '';
    foreach ($res->result_Array() as $key => $row) {
      if ($row['receiverId']==$receiverId) {
        $this->db->where('id',$row['id']);
        $this->db->update('user_chat',['seenState'=>0]);
        $html.="<li>
          <div class='chat-body'>
              <div class='chat-text'>
                  <h4>{$row['senderName']}</h4>
                  <p> {$row['message']} </p> <b>".date('d, M-y',strtotime($row['updateTime']))."</b> </div>
              </div>
          </li>";
      }else{
        $html.="<li class='odd'>
          <div class='chat-body'>
              <div class='chat-text'>
                  <h4>{$row['receiverName']}</h4>
                  <p> {$row['message']} </p> <b>".date('d, M-y',strtotime($row['updateTime']))."</b> </div>
              </div>
          </li>";
      }
    }
    echo $html;
  }
  public function newMessageNotify()
  {
    /*$user_id = $this->receiverId; 
    $sql = "SELECT * from user_chat where receiverId = $user_id and seenState=1 and notified=1";
    $res=$this->db->query($sql);
    $i=0;
    $messageArr=[];
    foreach ($res->result_Array() as $key => $value) {
      $this->db->where('id',$value['id']);
      $this->db->update('user_chat',['notified'=>0]);
      $messageArr[$i]['senderName'] = $this->db->get_where('users_portal', array('user_id' => $value['senderId']))->row()->name;
      $messageArr[$i]['senderId']=$value['senderId'];
      $messageArr[$i]['message'] = $value['message'];
      $i++;
    }
    die(json_encode($messageArr));*/
  }
  public function newMessageNotifyList()
    {
        /*$user_id = $this->receiverId; 
        $sql = "SELECT * from user_chat where receiverId = '$user_id' and seenState=1 and notified IN (0,1)";
        $res=$this->db->query($sql);
        $i=0;
        $messageArr=[];
        foreach ($res->result_Array() as $key => $value) {
            $messageArr[$i]['senderName'] = $this->db->get_where('users_portal', array('user_id' => $value['senderId']))->row()->name;
            $messageArr[$i]['message'] = $value['message'];
            $i++;
        }
        return $messageArr;*/
    }
  public function addMessage()
  {
  	date_default_timezone_set('America/Chicago');
  	$timestamp = date('Y-m-d H:i:s');
    $receiverId = $this->input->post('senderId');
    $senderId = $this->receiverId;
    $message = $this->input->post('message');
    $insertArr = ['receiverId'=>$receiverId,'senderId'=>$senderId,'message'=>$message,'updateTime'=>$timestamp];
    $record = $this->db->insert('user_chat',$insertArr);
    die(json_encode(['success'=>true]));
  }
}