<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Claimmd extends CI_Controller {
    public function __construct() {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        } else {
            $this->headerData=[];
        }

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
    }

    function getTableRecord() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        $cond = "";

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND (claimmd_requests.ins_number LIKE '%".$search."%' OR claimmd_requests.claimmd_id LIKE '%".$search."%') ";
            //$cond .= "AND (claimmd_requests.ins_number LIKE '%".$search."%' OR claimmd_requests.claimmd_id LIKE '%".$search."%' OR patient.name LIKE '%".$search."%') ";
        }

        if(!empty($_GET['status'])) {            
            $status = $_GET['status'];
            $cond .= "AND claimmd_requests.status = '".$status."' ";
        }

        if(!empty($_GET['datefrom']) && !empty($_GET['dateto'])) {
            $datefrom = $_GET['datefrom']; $dateto = $_GET['dateto'];
            $cond .= "AND DATE(claimmd_requests.timestamp) >= '".$datefrom."' AND DATE(claimmd_requests.timestamp) <= '".$dateto."'";
        } else {
            $datefrom = date('Y-m-d'); $dateto = date('Y-m-d');
            $cond .= "AND DATE(claimmd_requests.timestamp)>='".$datefrom."' AND DATE(claimmd_requests.timestamp)<= '".$dateto."'";
        }

        if(!empty($_GET['agency']) && !empty($_GET['agency'])) {
            $agency_code = $_GET['agency'];
        } else {
            $agency_code = $this->session->userdata('agency');
        }

        $totalRec = 0;
        $datas = [];
        $data = [];
        $i = 0;
        //$sql = "SELECT claimmd_requests.* FROM claimmd_requests WHERE claimmd_requests.agency_code = '$agency_code' $cond AND DATE(claimmd_requests.timestamp)>='$datefrom' AND DATE(claimmd_requests.timestamp)<='$dateto' ORDER BY id ASC";

        //$sql = "SELECT claimmd_requests.*, patient.name as pt_name FROM claimmd_requests, patient WHERE patient.insurance_id_no1a = claimmd_requests.ins_number $cond ORDER BY claimmd_requests.id DESC";

        $sql = "SELECT claimmd_requests.* FROM claimmd_requests WHERE 1 $cond ORDER BY id DESC";

        //$sql = "SELECT claimmd_requests.*, patient.name as pt_name FROM claimmd_requests LEFT JOIN patient ON patient.insurance_id_no1a = claimmd_requests.ins_number $cond ORDER BY claimmd_requests.id DESC";

        $Tsql = $sql;
        $sql .= " $sLimit";
        $res = $this->Comman_model->getCustomQueryData($sql);
        $Tres = $this->Comman_model->getCustomQueryData($Tsql);

        foreach ($res as $key => $row) {

            $patientName = '';
            if(!empty($row['ins_number'])) {
                $sqlp = "SELECT name FROM patient WHERE insurance_id_no1a = '".$row['ins_number']."'";
                $rowp = $this->Comman_model->getCustomQueryData($sqlp, 'row');
                $patientName = $rowp['name'];
            }

            $param  = [];

            $param[0]   = $row['id'];
            $param[1]   = $patientName;
            $param[2]   = $row['ins_number'];
            $param[3]   = $row['claimmd_id'];
            $param[4]   = $row['total_charge'];
            $param[5]   = $row['fdos'];
            $param[6]   = $row['timestamp'];
            $status = $row['status'];
            $message = $row['message'];
            $lblStatus = '<strong>Status: </strong><span class="text-success">'.$status.'</span>';
            $param[7]   .= '<div style="white-space: normal;">';
            $param[7]   .= '<p class="fw-500">'.$lblStatus.'</p>';
            $lblMessage = '<strong>Message: </strong><span class="text-success">'.$message.'</span>';
            $param[7]   .= '<p class="fw-500">'.$lblMessage.'</p>';
            $param[7]   .= '</div>';
            $param[8]   = '<button class="btn btn-info get-info" data-id="'.$row['claimmd_id'].'">Get Details</button>';

            if(!empty($param)) {
                $data[$key] = $param;
            }
        }

        $recordsTotal = count($Tres);
        $recordsFiltered = count($Tres);
                
        $nex = 0;

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        $response['lblTotal'] = $lblTotal;
        $response['sql'] = $sql;
        print_r(json_encode($response));        
    }

    function generateTransactionDetails() {
        $claimmd_id = $_POST['dataId'];
        $data = '';
        if(!empty($claimmd_id)) {
            $curl = curl_init();
            //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ResponseID=1288758946&ClaimID=562474031';
            //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID='.$claimmd_id;
            //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ResponseID=1292317239&ClaimID=3559281196';
            $payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID='.$claimmd_id;

            curl_setopt_array($curl, [
                CURLOPT_HTTPHEADER => [
                    "Accept: application/json",
                    "Content-Type: application/x-www-form-urlencoded"
                ],
                CURLOPT_POSTFIELDS => $payload,
                CURLOPT_URL => "https://svc.claim.md/services/response/",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "POST",
            ]);

            $response1 = curl_exec($curl);
            $error = curl_error($curl);

            curl_close($curl);

            if ($error) {
                echo "cURL Error #:" . $error;
            } else {
                //print_r(json_decode($response, TRUE));
                $response = json_decode($response1, true);
                $data = '<table class="table-bordered table"><tr><th>DATE</th><th>ENTITY</th><th>EVENT</th></tr>';
                foreach ($response['claim'] as $key => $row) {

                    $message = $response['claim'][$key]['messages'][0]['message'];
                    if(!empty($row['sender_icn'])) {
                        $message .= '<br><strong style="color:blue;">'.$row['sender_name'].' Claim ID: '.$row['sender_icn'].'</strong>';
                    }
                    $data .= '<tr>';
                    $data .= '<td>'.$row['response_time'].'</td>';
                    $data .= '<td>'.$row['sender_name'].'</td>';
                    $data .= '<td>'.$message.'</td>';
                    $data .= '</tr>';
                }

                $key = count($response['claim']);
                $key = $key - 1;

                $dataArray = [];
                $dataArray['status'] = $response['claim'][$key]['status'];
                $dataArray['remote_claimid'] = $response['claim'][$key]['remote_claimid'];
                $dataArray['bill_taxid'] = $response['claim'][$key]['bill_taxid'];
                $dataArray['filename'] = $response['claim'][$key]['filename'];
                $dataArray['ins_number'] = $response['claim'][$key]['ins_number'];
                $dataArray['payerid'] = $response['claim'][$key]['payerid'];
                $dataArray['senderid'] = $response['claim'][$key]['senderid'];
                $dataArray['total_charge'] = $response['claim'][$key]['total_charge'];
                $dataArray['pcn'] = $response['claim'][$key]['pcn'];
                $dataArray['claimid'] = $response['claim'][$key]['claimid'];
                $dataArray['claimmd_id'] = $response['claim'][$key]['claimmd_id'];
                $dataArray['fileid'] = $response['claim'][$key]['fileid'];
                $dataArray['batchid'] = $response['claim'][$key]['batchid'];
                $dataArray['sender_name'] = $response['claim'][$key]['sender_name'];
                $dataArray['fdos'] = $response['claim'][$key]['fdos'];
                $dataArray['response'] = $response1;

                $where = [];
                $where['claimmd_id'] = $claimmd_id;

                $this->Comman_model->update('claimmd_requests', $where, $dataArray);
            }
        }
        print_r($data);
    }


    function generateTransactionDetails2() {
        $claimmd_id = '568118445';
        $data = '';
        if(!empty($claimmd_id)) {
            $curl = curl_init();
            $payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID='.$claimmd_id;

            curl_setopt_array($curl, [
                CURLOPT_HTTPHEADER => [
                    "Accept: application/json",
                    "Content-Type: application/x-www-form-urlencoded"
                ],
                CURLOPT_POSTFIELDS => $payload,
                CURLOPT_URL => "https://svc.claim.md/services/response/",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "POST",
            ]);

            $response = curl_exec($curl);
            $error = curl_error($curl);

            curl_close($curl);

            print_r($response); die;

            /*
            $curl = curl_init();
            $payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimMD_ID='.$claimmd_id;

            curl_setopt_array($curl, [
                CURLOPT_HTTPHEADER => [
                    "Accept: application/json",
                    "Content-Type: application/x-www-form-urlencoded"
                ],
                CURLOPT_POSTFIELDS => $payload,
                CURLOPT_URL => "https://svc.claim.md/services/modify/",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "POST",
            ]);

            $response = curl_exec($curl);
            $error = curl_error($curl);

            curl_close($curl);

            print_r($response);
            */
        }
        print_r($data);
    }

    public function index() {
        if (isset($_SESSION['name'])) {

            $data = [];
            $data['status'] = @$_GET['status'];
            $data['datefrom'] = @$_GET['datefrom'];
            $data['dateto'] = @$_GET['dateto'];

            if(!empty($_GET['datefrom']) && !empty($_GET['dateto'])) {
                $datefrom = $_GET['datefrom']; $dateto = $_GET['dateto'];
            } else {
                $datefrom = date('Y-m-d'); $dateto = date('Y-m-d');
            }

            $data['datefrom'] = $datefrom;
            $data['dateto'] = $dateto;

            //$sql = "SELECT * FROM claimmd_requests ORDER BY id DESC";
            //$data['claimmdRequests'] = $this->Comman_model->getCustomQueryData($sql);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('claimmd/upload-file-view.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    function uploadFileToClaimmd() {
        $message = 'err'; 
        if($_FILES['claimmdfile']['name']!="") {
            $img_data                   =   [];
            $img_data['path']           =   'image/claimmd';
            $img_data['file_name']      =   'claimmdfile';
            $img_data['real_file_name'] =   $_FILES['claimmdfile']['name'];
            $img_data['rename']         =   '0';
            $img_data['allowed_type']   =   '*';
            $img_data['old_file']       =   '';
            $img_data['width']          =   '';
            $img_data['height']         =   '';
            $img_data['quality']        =   '';
            $img_data['image_compress'] =   False;

            $img = $this->uploadfiles($img_data);

            if(!empty($img['status']=='1')) {
                $filename = $img['url'];
                //$this->realTimeElegibility($filename);
                $this->sendToClaimmd($filename);
            }
        }
    }

    function sendFileToClaimmd() {
        $message = 'err'; 
        $filename = $_POST['filename'];
        if($filename!="" && !empty($filename)) {
            //echo '1';
            $this->sendToClaimmd($filename);
        }
    }

    /*
    function realTimeElegibility($filename) {
        $filepath = FCPATH.'/image/claimmd/'.$filename;
        $curl = curl_init();
        $payload = array(
            "AccountKey" => '19311_6PMoJN7@*$s0dsCntVijVvwp',
            "File" => new \CurlFile($filepath, 'text/txt', $filename),
            //"Filename" => $filename,
        );

        curl_setopt_array($curl, [
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: multipart/form-data"
            ],
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_URL => "https://svc.claim.md/services/elig/",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
        ]);

        $response = curl_exec($curl);
        $error = curl_error($curl);

        curl_close($curl);

        if ($error) {
            echo "cURL Error #:" . $error;
        } else {
            $result = json_decode($response, true);
            print_r($result);
        }
    }
    */

    function sendToClaimmd($filename) {
        $filepath = FCPATH.'/image/claimmd/'.$filename;
        $curl = curl_init();
        $payload = array(
            "AccountKey" => '19311_6PMoJN7@*$s0dsCntVijVvwp',
            "File" => new \CurlFile($filepath, 'text/txt', $filename),
            "Filename" => $filename,
        );

        curl_setopt_array($curl, [
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: multipart/form-data"
            ],
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_URL => "https://svc.claim.md/services/upload/",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
        ]);

        $response = curl_exec($curl);
        $error = curl_error($curl);

        curl_close($curl);

        if ($error) {
            echo "cURL Error #:" . $error;
        } else {
            $result = json_decode($response, true);
            if(!empty($result['claim'])) {
                foreach ($result['claim'] as $key => $row) {
                    $dataArray = [];
                    $dataArray['status'] = $row['status'];
                    $dataArray['remote_claimid'] = $row['remote_claimid'];
                    $dataArray['bill_taxid'] = $row['bill_taxid'];
                    $dataArray['filename'] = $row['filename'];
                    $dataArray['ins_number'] = $row['ins_number'];
                    $dataArray['payerid'] = $row['payerid'];
                    $dataArray['senderid'] = $row['senderid'];
                    $dataArray['total_charge'] = $row['total_charge'];
                    $dataArray['pcn'] = $row['pcn'];
                    $dataArray['claimid'] = $row['claimid'];
                    $dataArray['claimmd_id'] = $row['claimmd_id'];
                    $dataArray['fileid'] = $row['fileid'];
                    $dataArray['batchid'] = $row['batchid'];
                    $dataArray['sender_name'] = $row['sender_name'];
                    $dataArray['fdos'] = $row['fdos'];
                    $dataArray['response'] = $response;

                    $this->Comman_model->insert('claimmd_requests', $dataArray);
                }
                echo '1';
            }
            if($result['error']['error_mesg']!='' && $result['error']['error_code']=='61') {
                echo 'Duplicate File.';
            }            
        }
    }

    function getRequestStatus() {        
        /**
        * Requires libcurl
        */
        $x=0;
        //$sql = "SELECT * FROM claimmd_requests WHERE status!='A' AND status!='R' ORDER BY id DESC";
        //$sql = "SELECT * FROM claimmd_requests WHERE message = '' ORDER BY id DESC LIMIT 2";
        $sql = "SELECT * FROM claimmd_requests ORDER BY id DESC LIMIT 99";
        $res = $this->Comman_model->getCustomQueryData($sql);
        if(!empty($res)) {
            foreach ($res as $key => $row) {
                // code...
                $claimmd_id = $row['claimmd_id'];

                $curl = curl_init();
                //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ResponseID=1288758946&ClaimID=562474031';
                //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID=562474031';
                $payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID='.$claimmd_id;
                //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID=565834599';

                //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ResponseID=1288758946&ClaimID='.$claimmd_id;

                curl_setopt_array($curl, [
                    CURLOPT_HTTPHEADER => [
                        "Accept: application/json",
                        "Content-Type: application/x-www-form-urlencoded"
                    ],
                    CURLOPT_POSTFIELDS => $payload,
                    CURLOPT_URL => "https://svc.claim.md/services/response/",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_CUSTOMREQUEST => "POST",
                ]);

                $response = curl_exec($curl);
                $error = curl_error($curl);

                curl_close($curl);

                if ($error) {
                    echo "cURL Error #:" . $error;
                } else {
                    $result = json_decode($response, TRUE);

                    $last_response_id = $result['last_responseid'];

                    $key = count($result['claim']);
                    $key = $key - 1;

                    $status = $result['claim'][$key]['status'];
                    $message = $result['claim'][$key]['messages'][0]['message'];

                    $where = [];
                    $where['claimmd_id'] = $claimmd_id;

                    $updateArray = [];
                    $updateArray['last_response_id'] = $last_response_id;
                    $updateArray['status'] = $status;
                    $updateArray['message'] = $message;
                    //$updateArray['response'] = $response;

                    $this->Comman_model->update('claimmd_requests', $where, $updateArray);
                    
                    /*
                    print_r($where);                    
                    print_r($updateArray);
                    print_r($result);die;                    
                    */
                    $x++;
                }
            }
        }

        echo $x.' numbers of request status has been updated.';
    }


    function getRequestStatusAll() {        
        /**
        * Requires libcurl
        */
        $curl = curl_init();
        //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ResponseID=1288758946&ClaimID=562474031';
        //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID=562474031';
        //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID='.$claimmd_id;
        //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ResponseID=1292317239&ClaimID=563146653';
        //$payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID=3559281196';
        $payload = 'AccountKey=19311_6PMoJN7@*$s0dsCntVijVvwp&ClaimID=565834599';
        

        curl_setopt_array($curl, [
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: application/x-www-form-urlencoded"
            ],
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_URL => "https://svc.claim.md/services/response/",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
        ]);

        $response = curl_exec($curl);
        $error = curl_error($curl);

        curl_close($curl);

        if ($error) {
            echo "cURL Error #:" . $error;
        } else {
            $result = json_decode($response, TRUE);
            print_r($result);die;
        }
    }

    public function uploadfiles($img_data=[]){
        $folder =   $img_data['path'];
        $file = $img_data['file_name'];
        $allowed_types =    $img_data['allowed_type'];
        $older =    $img_data['old_file'];
        $width  =   $img_data['width'];
        $height =   $img_data['height'];
        $quality    =   $img_data['quality'];

        if(!empty($_FILES[$file]) && $_FILES[$file]['size'] > 0){          
            if(!empty($older)){
                $postimgurl = FCPATH."$folder/". $older;
                unlink($postimgurl);
            }
            $config =   [];
            $config['upload_path']     = './'."$folder".'/'; 
            $config['allowed_types']   = $allowed_types;
            if($img_data['rename']==1) {
                $new_name = $file.time().rand(0000,9999);
            } else {
                $new_name = $file;
            }
            
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if($this->upload->do_upload($file)){
                $postimg =$this->upload->data()['file_name'] ;
                $postimgurl = base_url()."$folder/". $postimg;
                chmod($this->upload->data()['full_path'],0777);
                if($img_data['image_compress']){
                    $config =   [];
                    $config['image_library'] = 'gd2';  
                    $config['source_image'] = './'."$folder".'/'.$postimg;  
                    $config['create_thumb'] = FALSE;  
                    $config['maintain_ratio'] = FALSE;  

                    $config['quality'] = $quality;  
                    if(!empty($width)){
                        $config['width'] = $width;  
                    }
                    if(!empty($height)){
                        $config['height'] = $height;  
                    }
                  
                    $config['new_image'] = './'."$folder".'/'.$postimg;  
                  
                    $this->load->library('image_lib', $config);  
                    $this->image_lib->initialize($config);
                    if($this->image_lib->resize()){
                        $this->image_lib->clear();
                        $data['url'] =  $postimg;
                        $data['status'] = 1;
                    } else {
                        $data['status'] = 0;
                        $data['msg']=$this->upload->display_errors();
                    }  
                } else {
                    $data['url'] =  $postimg;
                    $data['status'] = 1;
                }
            } else {
                $data['status']=0;
                $data['msg']=$this->upload->display_errors();
            }
            return $data;
        }
    }

    public function getAccessToken() {
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://implementation.hhaexchange.com/identity/connect/token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'client_id=d11d21b0-b0f5-49ff-b582-d1422eda1617&client_secret=4aba6594-e89a-40fb-a6d0-e9d5fc621cde&scope=write%3Aaggregator&grant_type=client_credentials',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
          ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true);
        return $response['access_token'];
    }
    
    public function getCaregiverResponse($data) {
        $accessToken = $this->getAccessToken();
        $data = json_encode($data);
        //print_r($data);die;
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://implementation.hhaexchange.com/api/v1/caregivers',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => json_encode($data),
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$accessToken
          ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function getVisitsResponse($data) {
        $accessToken = $this->getAccessToken();
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://implementation.hhaexchange.com/api/v1/visits',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => json_encode($data),
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$accessToken
          ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    function response() {
        $code = $_REQUEST['code'];
        if(!empty($code)) {
            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://oauth2.googleapis.com/token',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS => array('client_id' => '288831144002-mb7frb83f12q1rcdb00e976s0s20vd3i.apps.googleusercontent.com','client_secret' => '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','code' => $code,'grant_type' => 'authorization_code','redirect_uri' => 'https://portal.1017.solutions/training9/Admin/customer_panel/gsheet/response'),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            print_r($response);die;
        }
    }
} 