<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Dashboardd extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        //$this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Employee_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
    }

    public function index() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('dashboard/view.php', $data);
        } else {
            redirect();
        }
    }

    public function mco1500() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function mco1500LTS() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            //$strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500LTS.php', $data);
            //$this->load->view('common/footer.php');
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function mco1500Monthly() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                redirect('dashboardd/mco1500HMMonthly');
            }
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500-monthly.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function mco1500MonthlyNew() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                redirect('dashboardd/mco1500HMMonthlyNew');
            }
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500-monthly-payor-dropdown.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }


    public function mco1500HMMonthly() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==2 || $agency_code==4) {
                redirect('dashboardd/mco1500Monthly');
            }
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500HM-monthly.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function mco1500HMMonthlyNew() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==2 || $agency_code==4) {
                redirect('dashboardd/mco1500MonthlyNew');
            }
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500HM-monthly-payor-dropdown.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }


    public function mco1500HMLTS() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500HMLTS.php', $data);
            //$this->load->view('common/footer.php');
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }


    public function generateReportBilledUnbilled() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if($agency_code==1 || $agency_code==3) {
                redirect('dashboardd/generateReportBilledUnbilled13');
            }

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2022-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['fromstartdate'])) {
                $fromstartDate = $_GET['fromstartdate'];
                //$tostartdate = $_GET['tostartdate'];
                $tostartdate = $fromstartDate;

                $year = date('Y', strtotime($fromstartDate));
                $startDate1 = $year.'-01-01';

                $strSQL = "SELECT * FROM table_2weekly where start_date >= '".$fromstartDate."' AND start_date <= '".$tostartdate."'";
                $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL);
                foreach ($allStartDateList as $key => $row) {
                    $startDate = $row['start_date'];
                    $totalClients = $this->getTotalClientsByStartDate($startDate, $agency_code);
                    $totalEmployee = $this->getTotalEmployeeByStartDate($startDate, $agency_code);
                    $response = $this->getTotalCurrentHoursAdpAdjTotalBilled($startDate, $agency_code);
                    $totalHoursAdp = $response[0];
                    $totalHoursAdj = $response[1];
                    $totalBilledHoursMCO = $this->getTotalBilledHoursMCOIDOA($startDate, 1);
                    $totalBilledHoursIDOA = $this->getTotalBilledHoursMCOIDOA($startDate, 0);
                    $totalUnbilledHoursMCO = $this->getTotalUnbilledHoursMCOIDOA($startDate, 1);
                    $totalUnbilledHoursIDOA = $this->getTotalUnbilledHoursMCOIDOA($startDate, 0);

                    $sql = "SELECT * FROM billed_unbilled_report WHERE start_date='".$startDate."'";
                    $res = $this->Comman_model->getCustomQueryData($sql);

                    //$sql = "SELECT * FROM table_2weekly WHERE start_date = '".$startDate."'";
                    //$row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    $currentPeriod = date('m/d/Y', strtotime($startDate)).' - '.date('m/d/Y', strtotime($row['end_date']));

                    $dataArray = [];
                    $dataArray['current_period'] = $currentPeriod;
                    $dataArray['start_date'] = $startDate;
                    $dataArray['total_client'] = $totalClients;
                    $dataArray['total_employee'] = $totalEmployee;
                    $dataArray['total_hours_adp'] = $totalHoursAdp;
                    $dataArray['total_hours_adj'] = $totalHoursAdj;
                    $dataArray['total_billed_hours_MCO'] = $totalBilledHoursMCO;
                    $dataArray['total_billed_hours_IDOA'] = $totalBilledHoursIDOA;
                    $dataArray['total_unbilled_hours_MCO'] = $totalUnbilledHoursMCO;
                    $dataArray['total_unbilled_hours_IDOA'] = $totalUnbilledHoursIDOA;                    
                    $dataArray['Agency'] = $agency_code;

                    /*if(count($res)>0) {
                        $where = [];
                        $where['start_date'] = $startDate;
                        $this->Comman_model->update('billed_unbilled_report', $where, $dataArray);
                    } else {
                        $record_id = $this->Comman_model->insert('billed_unbilled_report', $dataArray);    
                    } */
                    $record_id = $this->Comman_model->insert('billed_unbilled_report', $dataArray);                     
                }
                $this->session->set_flashdata('message', 'Record has been updated successfully.');
                redirect('dashboardd/generateReportBilledUnbilled');
            }

            $sql = "SELECT * FROM billed_unbilled_report WHERE Agency = '".$agency_code."' ORDER BY start_date DESC";
            $data['billedUnbilledData'] = $this->Comman_model->getCustomQueryData($sql);            


            $data['fromstartdate'] = @$_GET['fromstartdate'];
            $data['totartdate'] = @$_GET['totartdate'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/billed-unbilled-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function generateReportBilledUnbilled13() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if($agency_code==2 || $agency_code==4) {
                redirect('dashboardd/generateReportBilledUnbilled');
            }

            $strSQL1 = "SELECT * FROM table_1weekly WHERE start_date >= '2022-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year'])) {
                $month = $_GET['month'];
                $year = $_GET['year'];

                $startDate = $year.'-'.$month.'-01';
                $endDate = date('Y-m-t', strtotime($startDate));
                
                $totalClients = $this->getTotalClientsByStartDate13($month, $year, $agency_code);
                $totalEmployee = $this->getTotalEmployeeByStartDate13($month, $year, $agency_code);
                $response = $this->getTotalCurrentHoursAdpAdjTotalBilled13($month, $year, $agency_code);
                $totalHoursAdp = $response[0];
                $totalHoursAdj = $response[1];
                $totalBilledHoursMCO = $this->getTotalBilledHoursMCOIDOA13($month, $year, 1);
                $totalBilledHoursIDOA = $this->getTotalBilledHoursMCOIDOA13($month, $year, 0);
                $totalUnbilledHoursMCO = $this->getTotalUnbilledHoursMCOIDOA13($month, $year, 1);
                $totalUnbilledHoursIDOA = $this->getTotalUnbilledHoursMCOIDOA13($month, $year, 0);

                $currentPeriod = date('m/d/Y', strtotime($startDate)).' - '.date('m/d/Y', strtotime($endDate));

                $dataArray = [];
                $dataArray['current_period'] = $currentPeriod;
                $dataArray['start_date'] = $startDate;
                $dataArray['total_client'] = $totalClients;
                $dataArray['total_employee'] = $totalEmployee;
                $dataArray['total_hours_adp'] = $totalHoursAdp;
                $dataArray['total_hours_adj'] = $totalHoursAdj;
                $dataArray['total_billed_hours_MCO'] = $totalBilledHoursMCO;
                $dataArray['total_billed_hours_IDOA'] = $totalBilledHoursIDOA;
                $dataArray['total_unbilled_hours_MCO'] = $totalUnbilledHoursMCO;
                $dataArray['total_unbilled_hours_IDOA'] = $totalUnbilledHoursIDOA;
                $dataArray['Agency'] = $agency_code;
                $record_id = $this->Comman_model->insert('billed_unbilled_report', $dataArray);

                $this->session->set_flashdata('message', 'Record has been updated successfully.');
                redirect('dashboardd/generateReportBilledUnbilled13');
            }

            $sql = "SELECT * FROM billed_unbilled_report WHERE Agency = '".$agency_code."' ORDER BY run_date DESC";
            $data['billedUnbilledData'] = $this->Comman_model->getCustomQueryData($sql);

            $data['month'] = @$_GET['month'];
            $data['year'] = @$_GET['year'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/billed-unbilled-report-13.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function generateReportPayorBilledUnbilled() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if($agency_code==1 || $agency_code==3) {
                redirect('dashboardd/generateReportPayorBilledUnbilled13');
            }

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2022-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['fromstartdate'])) {
                $fromstartDate = $_GET['fromstartdate'];
                //$tostartdate = $_GET['tostartdate'];
                $tostartdate = $fromstartDate;

                $year = date('Y', strtotime($fromstartDate));
                $startDate1 = $year.'-01-01';

                $x = 0;

                $strSQL = "SELECT * FROM table_2weekly where start_date >= '".$fromstartDate."' AND start_date <= '".$tostartdate."'";
                $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL);
                foreach ($allStartDateList as $key => $row) {
                    $startDate = $row['start_date'];

                    $dsql =  "SELECT * FROM tbldistricts WHERE Agency = '".$agency_code."'";
                    $dresult = get_custom_query_data($dsql);
                    foreach ($dresult as $key => $drow) {
                        // code...
                        $alsql =  "SELECT * FROM agency_location";
                        $alresult = get_custom_query_data($alsql);
                        foreach ($alresult as $key => $alrow) {
                            // code...
                            $agency_location = $alrow['agency_location_code'];
                            $districtId = $drow['DistrictID'];

                            if($drow['mco']==1) {
                                $DistrictName = $drow['DistrictName'];
                            }
                            if($drow['mco']==0) {
                                $DistrictName = 'IDOA';
                            }
                            $response = $this->getTotalADPADJ($startDate, $agency_location, $districtId, $agency_code);
                            $totalHoursAdp = $response[0];
                            $totalHoursAdj = $response[1];
                            $totalBilledHours = $this->getTotalBilledHours($startDate, $agency_location, $districtId, $agency_code);
                            $totalUnbilledHours = $this->getTotalUnbilledHours($startDate, $agency_location, $districtId, $agency_code);
                            $currentPeriod = date('m/d/Y', strtotime($startDate)).' - '.date('m/d/Y', strtotime($row['end_date']));

                            $dataArray = [];
                            $dataArray['current_period'] = $currentPeriod;
                            $dataArray['start_date'] = $startDate;
                            //$dataArray['total_client'] = $totalClients;
                            //$dataArray['total_employee'] = $totalEmployee;                            
                            $dataArray['payor'] = $DistrictName;
                            $dataArray['agency_location'] = $alrow['agency_location_name'];
                            $dataArray['Agency'] = $agency_code;

                            $sqldu = "SELECT * FROM payor_billed_unbilled_report WHERE payor = '".$DistrictName."' AND agency_location = '".$alrow['agency_location_name']."' AND Agency = '".$agency_code."' AND start_date = '".$startDate."'";
                            $rowu = get_custom_query_data($sqldu, 'row');
                            /*if(!empty($rowu)) {
                                $totalHoursAdp = $totalHoursAdp + $rowu['total_hours_adp'];
                                $totalHoursAdj = $totalHoursAdj + $rowu['total_hours_adj'];
                                $totalBilledHours = $totalBilledHours + $rowu['total_billed_hours'];
                                $totalUnbilledHours = $totalUnbilledHours + $rowu['total_unbilled_hours'];

                                $dataArray['total_hours_adp'] = $totalHoursAdp;
                                $dataArray['total_hours_adj'] = $totalHoursAdj;
                                $dataArray['total_billed_hours'] = $totalBilledHours;
                                $dataArray['total_unbilled_hours'] = $totalUnbilledHours;

                                $where = [];
                                $where['id'] = $rowu['id'];
                                $this->Comman_model->update('payor_billed_unbilled_report', $where, $dataArray);
                            } else {*/
                                $dataArray['total_hours_adp'] = $totalHoursAdp;
                                $dataArray['total_hours_adj'] = $totalHoursAdj;
                                $dataArray['total_billed_hours'] = $totalBilledHours;
                                $dataArray['total_unbilled_hours'] = $totalUnbilledHours;

                                if($totalHoursAdp>0) {
                                    $record_id = $this->Comman_model->insert('payor_billed_unbilled_report', $dataArray);
                                    $x++;
                                }                                
                            //}
                        }
                    }
                }
                if($x>0) {
                    $this->session->set_flashdata('message', 'Record has been added successfully.');    
                } else {
                    $this->session->set_flashdata('message', 'No Record Found.');    
                }                
                redirect('dashboardd/generateReportPayorBilledUnbilled');
            }

            $sql = "SELECT * FROM payor_billed_unbilled_report ORDER BY start_date DESC";
            $data['billedUnbilledData'] = $this->Comman_model->getCustomQueryData($sql);            

            $data['fromstartdate'] = @$_GET['fromstartdate'];
            $data['totartdate'] = @$_GET['totartdate'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/payor-billed-unbilled-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function generateReportPayorBilledUnbilled13() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if($agency_code==2 || $agency_code==4) {
                redirect('dashboardd/generateReportPayorBilledUnbilled');
            }

            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year'])) {
                $month = $_GET['month'];
                $year = $_GET['year'];

                $startDate1 = $year.'-'.$month.'-01';
                
                $startDate = date('Y-m-d', strtotime($startDate1));
                $endDate = date('Y-m-t', strtotime($startDate1));

                $x = 0;

                $dsql =  "SELECT * FROM tbldistricts WHERE Agency = '".$agency_code."'";
                $dresult = get_custom_query_data($dsql);
                foreach ($dresult as $key => $drow) {
                    // code...
                    $alsql =  "SELECT * FROM agency_location";
                    $alresult = get_custom_query_data($alsql);
                    foreach ($alresult as $key => $alrow) {
                        // code...
                        $agency_location = $alrow['agency_location_code'];
                        $districtId = $drow['DistrictID'];

                        if($drow['mco']==1) {
                            $DistrictName = $drow['DistrictName'];
                        }
                        if($drow['mco']==0) {
                            $DistrictName = 'IDOA';
                        }
                        $response = $this->getTotalADPADJ13($month, $year, $agency_location, $districtId, $agency_code);
                        $totalHoursAdp = $response[0];
                        $totalHoursAdj = $response[1];
                        $totalBilledHours = $this->getTotalBilledHours13($month, $year, $agency_location, $districtId, $agency_code);
                        $totalUnbilledHours = $this->getTotalUnbilledHours13($month, $year, $agency_location, $districtId, $agency_code);
                        $currentPeriod = date('m/d/Y', strtotime($startDate)).' - '.date('m/d/Y', strtotime($endDate));

                        $dataArray = [];
                        $dataArray['current_period'] = $currentPeriod;
                        $dataArray['start_date'] = $startDate;
                        //$dataArray['total_client'] = $totalClients;
                        //$dataArray['total_employee'] = $totalEmployee;                            
                        $dataArray['payor'] = $DistrictName;
                        $dataArray['agency_location'] = $alrow['agency_location_name'];
                        $dataArray['Agency'] = $agency_code;

                        $sqldu = "SELECT * FROM payor_billed_unbilled_report WHERE payor = '".$DistrictName."' AND agency_location = '".$alrow['agency_location_name']."' AND Agency='".$agency_code."' AND start_date = '".$startDate."'";
                        $rowu = get_custom_query_data($sqldu, 'row');
                        /*if(!empty($rowu)) {
                            $totalHoursAdp = $totalHoursAdp + $rowu['total_hours_adp'];
                            $totalHoursAdj = $totalHoursAdj + $rowu['total_hours_adj'];
                            $totalBilledHours = $totalBilledHours + $rowu['total_billed_hours'];
                            $totalUnbilledHours = $totalUnbilledHours + $rowu['total_unbilled_hours'];

                            $dataArray['total_hours_adp'] = $totalHoursAdp;
                            $dataArray['total_hours_adj'] = $totalHoursAdj;
                            $dataArray['total_billed_hours'] = $totalBilledHours;
                            $dataArray['total_unbilled_hours'] = $totalUnbilledHours;

                            $where = [];
                            $where['id'] = $rowu['id'];
                            $this->Comman_model->update('payor_billed_unbilled_report', $where, $dataArray);
                        } else { */
                            $dataArray['total_hours_adp'] = $totalHoursAdp;
                            $dataArray['total_hours_adj'] = $totalHoursAdj;
                            $dataArray['total_billed_hours'] = $totalBilledHours;
                            $dataArray['total_unbilled_hours'] = $totalUnbilledHours;

                            if($totalHoursAdp>0) {
                                $record_id = $this->Comman_model->insert('payor_billed_unbilled_report', $dataArray);
                                $x++;    
                            }
                            
                        //}                  
                    }
                }
                if($x>0) {
                    $this->session->set_flashdata('message', 'Record has been added successfully.');    
                } else {
                    $this->session->set_flashdata('message', 'No Record Found.');
                }
                
                redirect('dashboardd/generateReportPayorBilledUnbilled13');
            }

            $sql = "SELECT * FROM payor_billed_unbilled_report WHERE Agency = '".$agency_code."' ORDER BY start_date DESC";
            $data['billedUnbilledData'] = $this->Comman_model->getCustomQueryData($sql);            

            $data['month'] = @$_GET['month'];
            $data['year'] = @$_GET['year'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/payor-billed-unbilled-report-13.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function generateReportClientsBilled() {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
        //error_reporting(E_ALL);

        
        redirect('dashboardd/generateReportClientsBilledMCO');

        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                //redirect('dashboardd/generateReportPayorBilledUnbilled13');
            }
                
            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {

                $month      = $_GET['month'];
                $year       = $_GET['year'];
                $mcoIdoa    = $_GET['mco_idoa'];

                $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                $objExec = get_custom_query_data($chkSQL);
                $startDates = array_column($objExec, 'start_date');
                $sdString = "'" . implode ( "', '", $startDates ) . "'";                

                $chkSQL = "SELECT DISTINCT(patient_id) FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code'";
                $objExec = get_custom_query_data($chkSQL);
                $patientIds = array_column($objExec, 'patient_id');
                $patientIds = implode(',', $patientIds);                

                $psql =  "SELECT * FROM patient WHERE Agency = '".$agency_code."' AND FHCA=0 AND patient_id IN (".$patientIds.")";
                $presult = get_custom_query_data($psql);
                foreach ($presult as $key => $prow) {
                    // code...
                    $agency_location = $prow['agency_location'];
                    $districtId      = $prow['DistrictID_Ref'];
                    $ptid            = $prow['patient_id'];
                    $agency_code     = $prow['Agency'];

                    $sqld = "SELECT DistrictName FROM tbldistricts WHERE DistrictID = '".$districtId."' AND Agency = '".$agency_code."'";
                    $rowd = get_custom_query_data($sqld, 'row');

                    $response = $this->getTotalADPADJByClient($startDates, $agency_location, $districtId, $agency_code, $ptid, $month, $year);
                    $totalHoursAdp = $response[0];
                    $totalHoursAdj = $response[1];
                    $totalBilledHours = $this->getTotalBilledHoursByClient($startDates, $agency_location, $districtId, $agency_code, $ptid, $mcoIdoa, $month, $year);
                    //$totalUnbilledHours = $this->getTotalUnbilledHours($startDate, $agency_location, $districtId, $agency_code);
                    //$currentPeriod = date('m/d/Y', strtotime($startDate)).' - '.date('m/d/Y', strtotime($row['end_date']));
                    
                    //$dataArray[$key]['current_period'] = $currentPeriod;
                    //$dataArray[$key]['start_date'] = $startDates;
                    if($totalHoursAdp>0) {
                        $dataArray[$key]['patient_name'] = $prow['name'];
                        $dataArray[$key]['payor'] = $rowd['DistrictName'];
                        $dataArray[$key]['Agency'] = $agency_code;
                        $dataArray[$key]['total_hours_adp'] = $totalHoursAdp;
                        $dataArray[$key]['total_hours_adj'] = $totalHoursAdj;
                        $dataArray[$key]['total_billed_hours'] = $totalBilledHours;
                    }
                }
            }

            $data['billedUnbilledData'] = $dataArray;
            $data['month'] = $month;
            $data['year'] = $year;
            $data['mco_idoa'] = $mcoIdoa;
            $data['agency_code'] = $this->session->userdata('agency');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/hca-billed-unbilled-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    /*
    public function generateReportClientsBilledMCOSlow() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                //redirect('dashboardd/generateReportPayorBilledUnbilled13');
            }
                
            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {

                $month      = $_GET['month'];
                $year       = $_GET['year'];
                $mcoIdoa    = $_GET['mco_idoa'];

                $Tquery = "SELECT DISTINCT(patient_id) FROM eclaims_details WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND status = 'Billed'";
                $TResult = get_custom_query_data($Tquery);
                $patientIds = array_column($TResult, 'patient_id');                

                $TqueryLTS = "SELECT DISTINCT(patient_id) FROM eclaims_detailsLTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND status = 'Billed'";
                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');
                $patientLTSIds = array_column($TResult, 'patient_id');
                $patientIds  = array_unique(array_merge($patientIds, $patientLTSIds));
                $patientIds = implode(',', $patientIds);

                //$patientIds = 2258;

                $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                $objExec = get_custom_query_data($chkSQL);
                $startDates = array_column($objExec, 'start_date');
                $sdString = "'" . implode ( "', '", $startDates ) . "'";                

                $psql =  "SELECT * FROM patient WHERE Agency = '".$agency_code."' AND patient_id IN (".$patientIds.")";
                $presult = get_custom_query_data($psql);
                foreach ($presult as $key => $prow) {
                    // code...
                    $agency_location = $prow['agency_location'];
                    $districtId      = $prow['DistrictID_Ref'];
                    $ptid            = $prow['patient_id'];
                    $agency_code     = $prow['Agency'];

                    $sqld = "SELECT DistrictName FROM tbldistricts WHERE DistrictID = '".$districtId."' AND Agency = '".$agency_code."'";
                    $rowd = get_custom_query_data($sqld, 'row');

                    $response = $this->getTotalADPADJByClient($startDates, $agency_location, $districtId, $agency_code, $ptid, $month, $year, $mcoIdoa);
                    $totalHoursAdp = $response[0];
                    $totalHoursAdj = $response[1];
                    $response = $this->getTotalBilledHoursByClient($startDates, $agency_location, $districtId, $agency_code, $ptid, $mcoIdoa, $month, $year);
                    $totalBilledHours = $response[0];
                    $payorName = $response[1];

                    if($totalHoursAdp>0) {
                        $dataArray[$key]['patient_name'] = $prow['name'];
                        //$dataArray[$key]['payor'] = $rowd['DistrictName'];
                        $dataArray[$key]['payor'] = $payorName;
                        $dataArray[$key]['Agency'] = $agency_code;
                        $dataArray[$key]['total_hours_adp'] = $totalHoursAdp;
                        $dataArray[$key]['total_hours_adj'] = $totalHoursAdj;
                        $dataArray[$key]['total_billed_hours'] = $totalBilledHours;
                    }
                }
            }

            $data['billedUnbilledData'] = $dataArray;
            $data['month'] = $month;
            $data['year'] = $year;
            $data['mco_idoa'] = $mcoIdoa;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/hca-billed-unbilled-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }*/

    public function reportClientsBilledMCOFromActivityLog() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');                
            $dataArray = [];
            if(!empty($_GET['month']) && !empty($_GET['year'])) {
                $month      = $_GET['month'];
                $year       = $_GET['year'];
                $mcoIdoa    = $_GET['mco_idoa'];

                $Tquery = "SELECT DISTINCT(patient_id) FROM eclaims_details WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND status = 'Billed'";
                $TResult = get_custom_query_data($Tquery);
                $patientIds = array_column($TResult, 'patient_id');

                $TqueryLTS = "SELECT DISTINCT(patient_id) FROM eclaims_detailsLTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND status = 'Billed'";
                $TResultLTS = get_custom_query_data($TqueryLTS);

                $patientLTSIds = array_column($TResultLTS, 'patient_id');                

                $patientIdArr  = array_unique(array_merge($patientIds, $patientLTSIds));

                $patientIds = implode(',', $patientIdArr);

                //$patientIdArr = [13173];

                $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                $objExec = get_custom_query_data($chkSQL);
                $startDates = array_column($objExec, 'start_date');
                $sdString = "'" . implode ( "', '", $startDates ) . "'";                


                $x=0; $dataArray = [];
                foreach ($patientIdArr as $ptid) {
                    $psql =  "SELECT SQL_CALC_FOUND_ROWS employee_2finalsheet.employee_2finalsheet_id, employee_2finalsheet.d01, employee_2finalsheet.d02, employee_2finalsheet.d03, employee_2finalsheet.d04, employee_2finalsheet.d05, employee_2finalsheet.d06, employee_2finalsheet.d07, employee_2finalsheet.d08, employee_2finalsheet.d09, employee_2finalsheet.d10, employee_2finalsheet.d11, employee_2finalsheet.d12, employee_2finalsheet.d13, employee_2finalsheet.d14, employee_2finalsheet.date01, employee_2finalsheet.date02, employee_2finalsheet.date03, employee_2finalsheet.date04, employee_2finalsheet.date05, employee_2finalsheet.date06, employee_2finalsheet.date07, employee_2finalsheet.date08, employee_2finalsheet.date09, employee_2finalsheet.date10, employee_2finalsheet.date11, employee_2finalsheet.date12, employee_2finalsheet.date13, employee_2finalsheet.date14, employee_2finalsheet.adj1, employee_2finalsheet.adj2, employee_2finalsheet.note1, employee_2finalsheet.note2, employee_2finalsheet.prog1, employee_2finalsheet.prog2, employee_2finalsheet.cust_change, employee_2finalsheet.hrs_left, employee_2finalsheet.total_hrs, employee_2finalsheet.total_left, employee_2finalsheet.total_allow, employee_2finalsheet.service_type, employee_2finalsheet.total_2weekly, employee_2finalsheet.start_date, patient.patient_id, patient.name as pt_name, patient.middlename, patient.phone, employee.name as empl_name, employee.employee_id, employee.pin, employee.EmployeeTypeID_Ref, patient.Agency, patient.DistrictID_Ref, patient.HMKRHours, patient.CNAHours, patient.supervisor_id, patient.LPNHours, patient.RNHours FROM patient,employee_2finalsheet,employee WHERE (patient.patient_id = employee_2finalsheet.patient_id AND employee_2finalsheet.employee_id = employee.employee_id ) AND employee_2finalsheet.Agency = '".$agency_code."' AND patient.Agency = '".$agency_code."' AND start_date IN (".$sdString.") AND total_2weekly >= 0 AND employee_2finalsheet.patient_id = '".$ptid."'";
                    $presult = get_custom_query_data($psql);

                    $val = 0;                        
                    $ptName = $empName = '';
                    foreach ($presult as $key => $objResult) {
                        $daycnt = 0;

                        $ptName = $objResult['pt_name'];
                        $empName = $objResult['empl_name'];

                        $start = $objResult['start_date'];
                        while($daycnt<=14) {
                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d", $date);      

                            $month11 = date('m', $date);
                            $year11 = date('Y', $date);

                            //if($isMco==$mcocode) {
                            $mcoCheck = false;

                            $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                            $TResult = get_custom_query_data($Tquery, 'row');

                            $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                            $TResultLTS = get_custom_query_data($TqueryLTS, 'row');
                            if(!empty($TResult) || !empty($TResultLTS)) {
                                $mcoCheck = true;
                            }

                            $mcoCheck = true;
                            //echo $month.'=='.$month11.'=='.$year.'=='.$year11;
                            if($mcoCheck && $objResult[$d]>0 && $month==$month11 && $year==$year11) {
                                $val = $val + $objResult[$d];
                                if(!empty($TResult) && $payorName=='') {
                                    $sqll = "SELECT * FROM eclaims WHERE cms1500_id = '".$TResult['cms1500_id']."'";
                                    $rowl = get_custom_query_data($sqll, 'row');
                                    $payorName = $rowl['"Insurance Company Name"'];
                                }
                                if(!empty($TResultLTS) && $payorName=='') {
                                    $sqll = "SELECT * FROM eclaimsLTS WHERE cms1500_id = '".$TResultLTS['cms1500_id']."'";
                                    $rowl = get_custom_query_data($sqll, 'row');
                                    $payorName = $rowl['"Insurance Company Name"'];
                                }
                            }
                            $daycnt++;
                        }
                    }
                    if($val>0) {
                        $dataArray[$x]['Month'] = $_GET['month'];
                        $dataArray[$x]['Year'] = $_GET['year'];
                        $dataArray[$x]['Patient Id'] = $ptid;
                        $dataArray[$x]['Patient Name'] = $ptName;
                        //$dataArray[$x]['Employee Name'] = $empName;
                        $dataArray[$x]['ADP'] = $val;
                        $x++;
                    }                    
                }

                // file name for download
                $filename = "HCA_MCO_ADP_".date('Ymd').".xls";
                header("Content-Disposition: attachment; filename=\"$filename\"");
                header("Content-Type: application/vnd.ms-excel");
                $flag = false;
                $row2 = 0;
                $arry = array(' ',' ',' ',' ',' ');
                foreach ($dataArray as $key => $row) {
                    if(!$flag) {
                        // display field/column names as first row
                        array_walk($row, 'cleanData');
                        echo implode("\t",$arry) . "\r\n";
                        echo implode("\t", array_keys($row)) . "\r\n";
                        $flag = true;
                    }
                    array_walk($row, 'cleanData');
                    $x = 1;
                    echo implode("\t", array_values($row)) . "\r\n";
                }
            }
        } else {
            redirect();
        }
    }

    public function reportClientsBilledIDOAFromActivityLog() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');                
            $dataArray = [];
            if(!empty($_GET['start_date'])) {
                $start_date  = $_GET['start_date'];
                $chkSQL22 = "SELECT DISTINCT(idoadb.patient_id) FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start_date' AND idoadb_details.start_date = '$start_date' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed'";
                $objResult22 = get_custom_query_data($chkSQL22);
                $patientIds = array_column($objResult22, 'patient_id');

                $chkSQL32 = "SELECT DISTINCT(idoadbLTS.patient_id) FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start_date' AND idoadb_detailsLTS.start_date = '$start_date' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed'";
                $objResult32 = get_custom_query_data($chkSQL32);
                $patientLTSIds = array_column($objResult32, 'patient_id');
                $patientIdArr  = array_unique(array_merge($patientIds, $patientLTSIds));
                $patientIds = implode(',', $patientIdArr);

                $x=0; $dataArray = [];
                foreach ($patientIdArr as $ptid) {
                    $psql =  "SELECT SQL_CALC_FOUND_ROWS employee_2finalsheet.employee_2finalsheet_id, employee_2finalsheet.d01, employee_2finalsheet.d02, employee_2finalsheet.d03, employee_2finalsheet.d04, employee_2finalsheet.d05, employee_2finalsheet.d06, employee_2finalsheet.d07, employee_2finalsheet.d08, employee_2finalsheet.d09, employee_2finalsheet.d10, employee_2finalsheet.d11, employee_2finalsheet.d12, employee_2finalsheet.d13, employee_2finalsheet.d14, employee_2finalsheet.date01, employee_2finalsheet.date02, employee_2finalsheet.date03, employee_2finalsheet.date04, employee_2finalsheet.date05, employee_2finalsheet.date06, employee_2finalsheet.date07, employee_2finalsheet.date08, employee_2finalsheet.date09, employee_2finalsheet.date10, employee_2finalsheet.date11, employee_2finalsheet.date12, employee_2finalsheet.date13, employee_2finalsheet.date14, employee_2finalsheet.adj1, employee_2finalsheet.adj2, employee_2finalsheet.note1, employee_2finalsheet.note2, employee_2finalsheet.prog1, employee_2finalsheet.prog2, employee_2finalsheet.cust_change, employee_2finalsheet.hrs_left, employee_2finalsheet.total_hrs, employee_2finalsheet.total_left, employee_2finalsheet.total_allow, employee_2finalsheet.service_type, employee_2finalsheet.total_2weekly, employee_2finalsheet.start_date, patient.patient_id, patient.name as pt_name, patient.middlename, patient.phone, employee.name as empl_name, employee.employee_id, employee.pin, employee.EmployeeTypeID_Ref, patient.Agency, patient.DistrictID_Ref, patient.HMKRHours, patient.CNAHours, patient.supervisor_id, patient.LPNHours, patient.RNHours FROM patient,employee_2finalsheet,employee WHERE (patient.patient_id = employee_2finalsheet.patient_id AND employee_2finalsheet.employee_id = employee.employee_id ) AND employee_2finalsheet.Agency = '".$agency_code."' AND patient.Agency = '".$agency_code."' AND start_date IN ('".$start_date."') AND total_2weekly >= 0 AND employee_2finalsheet.patient_id = '".$ptid."'";
                    $presult = get_custom_query_data($psql);

                    $val = 0;                        
                    $ptName = $empName = '';
                    foreach ($presult as $key => $objResult) {
                        $daycnt = 0;
                        $ptName = $objResult['pt_name'];
                        $empName = $objResult['empl_name'];
                        $start = $objResult['start_date'];
                        while($daycnt<=14) {
                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d", $date);      

                            $month11 = date('m', $date);
                            $year11 = date('Y', $date);

                            $idoaCheck = true;
                            if($idoaCheck && $objResult[$d]>0) {
                                $val = $val + $objResult[$d];
                                $payorName = "IDOA";
                            }
                            $daycnt++;
                        }
                    }
                    if($val>0) {
                        $dataArray[$x]['Start Date'] = $start_date;
                        $dataArray[$x]['Patient Id'] = $ptid;
                        $dataArray[$x]['Patient Name'] = $ptName;
                        $dataArray[$x]['Employee Name'] = $empName;
                        $dataArray[$x]['ADP'] = $val;
                        $x++;
                    }
                }

                if(!empty($dataArray)) {
                    // file name for download
                    $filename = "HCA_IDOA_ADP_".date('Ymd').".xls";
                    header("Content-Disposition: attachment; filename=\"$filename\"");
                    header("Content-Type: application/vnd.ms-excel");
                    $flag = false;
                    $row2 = 0;
                    $arry = array(' ',' ',' ',' ');
                    foreach ($dataArray as $key => $row) {
                        if(!$flag) {
                            // display field/column names as first row
                            array_walk($row, 'cleanData');
                            echo implode("\t",$arry) . "\r\n";
                            echo implode("\t", array_keys($row)) . "\r\n";
                            $flag = true;
                        }
                        array_walk($row, 'cleanData');
                        $x = 1;
                        echo implode("\t", array_values($row)) . "\r\n";
                    }
                }
            }
        } else {
            redirect();
        }
    }

    public function reportClientsBilledIDOAFromActivityLogMonthly() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');                
            $dataArray = [];
            if(!empty($_GET['month']) && !empty($_GET['year'])) {
                
                $chkSQL22 = "SELECT DISTINCT(idoadb.patient_id) FROM idoadb,idoadb_details WHERE idoadb.month = '$month' AND idoadb.year = '$year' AND MONTH(idoadb_details.date) = '$month' AND YEAR(idoadb_details.date) = '$year' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed'";
                $objResult22 = get_custom_query_data($chkSQL22);
                $patientIds = array_column($objResult22, 'patient_id');

                $chkSQL32 = "SELECT DISTINCT(idoadbLTS.patient_id) FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.month = '$month' AND idoadbLTS.year = '$year' AND MONTH(idoadb_detailsLTS.date) = '$month' AND YEAR(idoadb_detailsLTS.date) = '$year' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed'";
                $objResult32 = get_custom_query_data($chkSQL32);
                $patientLTSIds = array_column($objResult32, 'patient_id');
                $patientIdArr  = array_unique(array_merge($patientIds, $patientLTSIds));
                $patientIds = implode(',', $patientIdArr);

                $sdArray = [];
                $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                $objExec = get_custom_query_data($chkSQL);
                $startDates = array_column($objExec, 'start_date');
                $sdString = "'" . implode ( "', '", $startDates ) . "'";

                $x=0; $dataArray = [];
                foreach ($patientIdArr as $ptid) {
                    //$start_date  = $_GET['start_date'];
                    $psql =  "SELECT SQL_CALC_FOUND_ROWS employee_2finalsheet.employee_2finalsheet_id, employee_2finalsheet.d01, employee_2finalsheet.d02, employee_2finalsheet.d03, employee_2finalsheet.d04, employee_2finalsheet.d05, employee_2finalsheet.d06, employee_2finalsheet.d07, employee_2finalsheet.d08, employee_2finalsheet.d09, employee_2finalsheet.d10, employee_2finalsheet.d11, employee_2finalsheet.d12, employee_2finalsheet.d13, employee_2finalsheet.d14, employee_2finalsheet.date01, employee_2finalsheet.date02, employee_2finalsheet.date03, employee_2finalsheet.date04, employee_2finalsheet.date05, employee_2finalsheet.date06, employee_2finalsheet.date07, employee_2finalsheet.date08, employee_2finalsheet.date09, employee_2finalsheet.date10, employee_2finalsheet.date11, employee_2finalsheet.date12, employee_2finalsheet.date13, employee_2finalsheet.date14, employee_2finalsheet.adj1, employee_2finalsheet.adj2, employee_2finalsheet.note1, employee_2finalsheet.note2, employee_2finalsheet.prog1, employee_2finalsheet.prog2, employee_2finalsheet.cust_change, employee_2finalsheet.hrs_left, employee_2finalsheet.total_hrs, employee_2finalsheet.total_left, employee_2finalsheet.total_allow, employee_2finalsheet.service_type, employee_2finalsheet.total_2weekly, employee_2finalsheet.start_date, patient.patient_id, patient.name as pt_name, patient.middlename, patient.phone, employee.name as empl_name, employee.employee_id, employee.pin, employee.EmployeeTypeID_Ref, patient.Agency, patient.DistrictID_Ref, patient.HMKRHours, patient.CNAHours, patient.supervisor_id, patient.LPNHours, patient.RNHours FROM patient,employee_2finalsheet,employee WHERE (patient.patient_id = employee_2finalsheet.patient_id AND employee_2finalsheet.employee_id = employee.employee_id ) AND employee_2finalsheet.Agency = '".$agency_code."' AND patient.Agency = '".$agency_code."' AND start_date IN (".$sdString.") AND total_2weekly >= 0 AND employee_2finalsheet.patient_id = '".$ptid."'";
                    $presult = get_custom_query_data($psql);

                    $val = 0;                        
                    $ptName = $empName = '';
                    foreach ($presult as $key => $objResult) {
                        $daycnt = 0;
                        $ptName = $objResult['pt_name'];
                        $empName = $objResult['empl_name'];
                        $start = $objResult['start_date'];
                        while($daycnt<=14) {
                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d", $date);      

                            $month11 = date('m', $date);
                            $year11 = date('Y', $date);

                            $idoaCheck = true;
                            if($idoaCheck && $objResult[$d]>0) {
                                $val = $val + $objResult[$d];
                                $payorName = "IDOA";
                            }
                            $daycnt++;
                        }
                    }
                    if($val>0) {
                        $dataArray[$x]['Month'] = $month;
                        $dataArray[$x]['Year'] = $year;
                        $dataArray[$x]['Patient Id'] = $ptid;
                        $dataArray[$x]['Patient Name'] = $ptName;
                        $dataArray[$x]['Employee Name'] = $empName;
                        $dataArray[$x]['ADP'] = $val;
                        $x++;
                    }
                }

                if(!empty($dataArray)) {
                    // file name for download
                    $filename = "HCA_IDOA_ADP_".date('Ymd').".xls";
                    header("Content-Disposition: attachment; filename=\"$filename\"");
                    header("Content-Type: application/vnd.ms-excel");
                    $flag = false;
                    $row2 = 0;
                    $arry = array(' ',' ',' ',' ');
                    foreach ($dataArray as $key => $row) {
                        if(!$flag) {
                            // display field/column names as first row
                            array_walk($row, 'cleanData');
                            echo implode("\t",$arry) . "\r\n";
                            echo implode("\t", array_keys($row)) . "\r\n";
                            $flag = true;
                        }
                        array_walk($row, 'cleanData');
                        $x = 1;
                        echo implode("\t", array_values($row)) . "\r\n";
                    }
                }
            }
        } else {
            redirect();
        }
    }

    function generateUnbilledHoursMCO13($month, $year, $agency_code, $patient_ids) {
        $cond = '';
        if(!empty($_GET['payorgroup'])) {
            $cond = " AND tracking_district.payorGrp='".$_GET['payorgroup']."'";
        }

        $totalVal = 0;

        if(!empty($patientIds)) {
            $cond = '';            
            $msql = "SELECT *, patient.mco as ptmco, tbldistricts.mco as mco FROM patient,tbldistricts WHERE patient.Agency = '$agency_code' AND tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code' AND patient.patient_id IN(".$patientIds.") $cond ORDER BY patient.lastname asc";
            $mrow = get_custom_query_data($msql, 'row');
            
            $mcocode =  $mrow['mco'];
            $recno = $mrow['patient_id'];
            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$recno' AND MONTH(start_date) = '$month' AND YEAR(start_date) = '$year'";
            $districtResult = get_custom_query_data($districtSQL, 'row');
            if (!empty($districtResult)) {
            } else {
                $mcocode =  $mrow['mco'];
            }

            $recno = $mrow['patient_id'];
            $ptid = $mrow['patient_id'];
            $mco = $mrow['DistrictID_Ref'];

            $chkSQL2 = "SELECT * FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' and patient_id = '$ptid'";
            $objResult2 = get_custom_query_data($chkSQL2, 'row');
            if (!empty($objResult2)) {
                $emplid = $objResult2["employee_id"];

                $chkSQL = "SELECT * FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' and patient_id = '$ptid'";

                $objExec = get_custom_query_data($chkSQL);

                $tens = 0;
                $weekdays = 1;
                $cntfile = 0;
                $chrg = ARRAY();
                $RATE = 5.07;       

                if ($month >= '12' && $year >= '2019') { 
                    $RATE = 5.46;
                }               

                if ($month >= '04' && $year >= '2021') { 
                    $RATE = 5.85;
                }
                
                
                $totalAdp = 0;
                $NO_DAYS = 31;

                foreach ($objExec as $key => $objResult) {
                    $ID = $objResult['service_type'];   
                    $daycnt = 0;

                    $month1 = $objResult['month'];
                    $year1 = $objResult['year'];

                    $emplid = $objResult['employee_id'];                

                    $start1 = $start2;
                    if (($month==$month1) && ($year==$year1)) {
                        $daycnt = 0;
                        $chrgx = 0;                     

                        while($daycnt<=$NO_DAYS) {

                            $date = strtotime(date("Y-m-d", strtotime($start1)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);
                            $dx = date("d",strtotime($datetrans));
                            $d =  'day'.sprintf("%02s", $dx);

                            $chkSQL11 = "SELECT * FROM table_1weekly WHERE end_date>='$datetrans' AND start_date<='$datetrans'";
                            $chkResult11 = get_custom_query_data($chkSQL11, 'row');
                            if (!empty($chkResult11))  {
                                $start = $chkResult11['start_date'];
                            }

                            if ($start >= '2021-11-01') { 
                                $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date = '$datetrans' AND agency = '$agency_code'";
                                $objRow = get_custom_query_data($chkSQL, 'row');
                                if(!empty($objRow)) {
                                    $RATE = $objRow['rate'];
                                } else {
                                    $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date <= '$datetrans' AND agency = '$agency_code' ORDER BY ID desc";
                                    $objRow = get_custom_query_data($chkSQL, 'row');
                                    if(!empty($objRow)) {
                                        $RATE = $objRow['rate'];
                                    }
                                }
                            }

                            $month11 = date('m', $date);
                            $year11 = date('Y', $date);

                            $idoaCheck = true;
                            $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null";
                            $objResult22 = get_custom_query_data($chkSQL22, 'row');

                            if(!empty($objResult22)) {
                                $idoaCheck = false;
                            }

                            $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null";
                            $objResult32 = get_custom_query_data($chkSQL32, 'row');

                            if(!empty($objResult32)) {
                                $idoaCheck = false;
                            }

                            $mcoCheck = true;

                            $cond = '';
                            $payorGrpCheck = false;
                            if(!empty($_GET['payorgroup'])) {
                                $cond .= " AND payorGrp='".$_GET['payorgroup']."'";
                                $payorGrpCheck = true;
                            }
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' $cond ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                                $mco = $districtResult['DistrictID_Ref'];
                            } else {
                                $cdate = $year.'-'.$month.'-01';
                                $cdate = date('Y-m-d', strtotime($cdate));
                                
                                //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<'$cdate' AND start_date!='0000-00-00' $cond ORDER BY district_id DESC LIMIT 1";
                                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$cdate' AND start_date!='0000-00-00' $cond ORDER BY district_id DESC LIMIT 1";
                                $districtResult = get_custom_query_data($districtSQL, 'row');
                                if (!empty($districtResult)) {
                                    $mcocode = $districtResult['mco'];
                                    $mco = $districtResult['DistrictID_Ref'];
                                } else {
                                    if($payorGrpCheck) {
                                        if($mrow['payorGrp']==$_GET['payorgroup']) {
                                            $mcocode = $mrow['mco'];
                                            $mco = $mrow['DistrictID_Ref'];     
                                        } else {
                                            $mcoCheck = false;
                                        }
                                    } else {
                                        $mcocode = $mrow['mco'];
                                        $mco = $mrow['DistrictID_Ref'];     
                                    }                                   
                                }                               
                            }

                            if($mcocode==0) {
                                $mcoCheck = false;
                            }

                            if($objResult[$d]>0) {
                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');

                                $TquerycmsLTS = "SELECT * FROM cms1500LTS,cms1500_detailsLTS WHERE cms1500_detailsLTS.Agency = '$agency_code' AND cms1500LTS.cms1500_id = cms1500_detailsLTS.cms1500_id AND cms1500LTS.Agency = '$agency_code' AND cms1500_detailsLTS.patient_id='$ptid' AND cms1500_detailsLTS.date = '$datetrans'";
                                $TCmsResultLTS = get_custom_query_data($TquerycmsLTS, 'row');

                                if(empty($TCmsResultLTS) && empty($TResultLTS) && empty($TResult) && $idoaCheck && $objResult[$d]>0 && ($month==$month11) && ($year==$year11) && $mcoCheck) {
                                    $totalVal = $totalVal + $objResult[$d];
                                }

                                if($idoaCheck && $objResult[$d]>0 && ($month==$month11) && ($year==$year11) && $mcoCheck) {
                                    $totalAdp = $totalAdp + $objResult[$d];
                                }
                            }
                            $daycnt++;
                        }
                    }
                }
            }            
        }
        return $totalVal;
    }

    function generateUnbilledHoursMCO24($month, $year, $agency_code, $patient_ids) {
        $totalVal = 0;
        if(!empty($patientIds)) {
            $msql = "SELECT *, patient.mco as ptmco, tbldistricts.mco as mco FROM patient,tbldistricts WHERE patient.Agency = '$agency_code' AND tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code' AND patient.patient_id IN(".$patientIds.") $cond ORDER BY patient.lastname asc";
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';

                $mco = $mrow['DistrictID_Ref'];
                $ptid = $mrow['patient_id'];
                $Agency = $mrow['Agency'];
                
                $sdArray = [];
                $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                $objExec = get_custom_query_data($chkSQL);
                $startDates = array_column($objExec, 'start_date');
                $sdString = "'" . implode ( "', '", $startDates ) . "'";

                $chkSQL = "SELECT * FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL);

                $tens = 0;
                $weekdays = 1;
                $cntfile = 0;
                $chrg = ARRAY();
                $RATE = 5.07;       

                if ($month >= '12' && $year >= '2019') { 
                    $RATE = 5.46;
                }               

                if ($month >= '04' && $year >= '2021') { 
                    $RATE = 5.85;
                }
            
                $duplicateEntry = [];                
                $totalAdp = 0;
                $InsuranceCompanyName = '';
                foreach ($objExec as $key => $objResult) {
                    $emplid = $objResult["employee_id"];
                    $ID = $objResult['service_type'];   
                    $start = $objResult['start_date'];

                    $month1 = date('m', strtotime($objResult['start_date']));
                    $year1 = date('Y', strtotime($objResult['start_date']));
                    
                    $daycnt = 0;
                    $chrgx = 0;

                    while($daycnt<=13) {
                        $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                        $datetrans = date("Y-m-d",$date);

                        if ($start >= '2021-11-01') { 
                            $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date = '$datetrans' AND agency = '$agency_code'";
                            $objRow = get_custom_query_data($chkSQL, 'row');
                            if(!empty($objRow)) {
                                $RATE = $objRow['rate'];
                            } else {
                                $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date <= '$datetrans' AND agency = '$agency_code' ORDER BY ID desc";
                                $objRow = get_custom_query_data($chkSQL, 'row');
                                if(!empty($objRow)) {
                                    $RATE = $objRow['rate'];
                                }
                            }
                        }

                        $d =  'd'.sprintf("%02s", $daycnt + 1);

                        $month11 = date('m', $date);
                        $year11 = date('Y', $date);

                        $idoaCheck = true;
                        $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null";
                        $objResult22 = get_custom_query_data($chkSQL22, 'row');

                        if(!empty($objResult22)) {
                            $idoaCheck = false;
                        }

                        $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null";
                        $objResult32 = get_custom_query_data($chkSQL32, 'row');

                        if(!empty($objResult32)) {
                            $idoaCheck = false;
                        }

                        $mcoCheck = true;

                        $cond = '';
                        $payorGrpCheck = false;
                        if(!empty($_GET['payorgroup'])) {
                            $cond .= " AND payorGrp='".$_GET['payorgroup']."'";
                            $payorGrpCheck = true;
                        }
                        $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' $cond ORDER BY district_id DESC LIMIT 1";
                        $districtResult = get_custom_query_data($districtSQL, 'row');
                        if (!empty($districtResult)) {
                            $mcocode = $districtResult['mco'];
                            $mco = $districtResult['DistrictID_Ref'];
                        } else {
                            $cdate = $year.'-'.$month.'-01';
                            $cdate = date('Y-m-d', strtotime($cdate));

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<'$cdate' AND start_date!='0000-00-00' $cond ORDER BY district_id DESC LIMIT 1";

                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$cdate' AND start_date!='0000-00-00' $cond ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                                $mco = $districtResult['DistrictID_Ref'];
                            } else {
                                if($payorGrpCheck) {
                                    if($mrow['payorGrp']==$_GET['payorgroup']) {
                                        $mcocode = $mrow['mco'];
                                        $mco = $mrow['DistrictID_Ref'];     
                                    } else {
                                        $mcoCheck = false;
                                    }
                                } else {
                                    $mcocode = $mrow['mco'];
                                    $mco = $mrow['DistrictID_Ref'];     
                                }                                   
                            }                               
                        }

                        if($mcocode==0) {
                            $mcoCheck = false;
                        }

                        $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                        $TResult = get_custom_query_data($Tquery, 'row');

                        $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                        $TResultLTS = get_custom_query_data($TqueryLTS, 'row');

                        $TquerycmsLTS = "SELECT * FROM cms1500LTS,cms1500_detailsLTS WHERE cms1500_detailsLTS.Agency = '$agency_code' AND cms1500LTS.cms1500_id = cms1500_detailsLTS.cms1500_id AND cms1500LTS.Agency = '$agency_code' AND cms1500_detailsLTS.patient_id='$ptid' AND cms1500_detailsLTS.date = '$datetrans'";
                        $TCmsResultLTS = get_custom_query_data($TquerycmsLTS, 'row');

                        if($idoaCheck && ($month==$month11) && ($year==$year11) && $mcoCheck && $objResult[$d]>0) { 
                            $totalAdp = $totalAdp + $objResult[$d];
                        }

                        if(empty($TCmsResultLTS) && empty($TResultLTS) && empty($TResult) && $idoaCheck && ($month==$month11) && ($year==$year11) && $mcoCheck && $objResult[$d]>0) {   

                            $sql = "SELECT * FROM tbldistricts WHERE DistrictID = '$mco' AND Agency = '$agency_code'" ;
                            $objRow = get_custom_query_data($sql, 'row');
                            if (!empty($objRow)) {
                                $InsuranceCompanyName = $objRow['DistrictName'];
                            }

                            $totalVal = $totalVal + $objResult[$d];
                        }
                        $daycnt++;
                    }
                }
            }
        }
        return $totalVal;
    }

    public function generateReportClientsBilledMCO() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                //redirect('dashboardd/generateReportClientsBilledIDOAMonthly');
            }
                
            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {

                $batch = date('Y-m-d H:i:s');

                $month      = $_GET['month'];
                $year       = $_GET['year'];

                /**** DELETE DUPLICATE RECORDS FROM eclaims_details TABALE START ****/
                $dsql = "DELETE t1 FROM eclaims_details t1 JOIN eclaims_details t2 ON t1.cms1500_details_id > t2.cms1500_details_id AND t1.date = t2.date AND t1.patient_id = t2.patient_id WHERE t1.status = 'Billed' AND t1.Agency = '$agency_code' AND t1.month = '$month' AND t1.year = '$year'";
                set_custom_query_data($dsql);
                /**** DELETE DUPLICATE RECORDS FROM eclaims_details TABALE END ****/                

                //$this->generateReportClientsBilledMCO2($month, $year, $agency_code);
                $mcoIdoa    = $_GET['mco_idoa'];
                $unbilled   = $_GET['unbilled'];  

                $colName = '"2-PatientName"';
                $payorName = '"Insurance Company Name"';

                $chkSQL22 = "SELECT eclaims.`$colName` as patient_name, eclaims.`$payorName` as payor_name, eclaims.patient_id, SUM(eclaims_details.units) as total_billed FROM eclaims,eclaims_details WHERE eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.status='Billed' AND eclaims.month = '$month' AND eclaims.year = '$year' AND eclaims.Agency = '$agency_code' GROUP BY eclaims_details.patient_id";

                $TResult1 = get_custom_query_data($chkSQL22);


                $chkSQL22 = "SELECT eclaimsLTS.`$colName` as patient_name, eclaimsLTS.`$payorName` as payor_name, eclaimsLTS.patient_id, SUM(eclaims_detailsLTS.units) as total_billed FROM eclaimsLTS,eclaims_detailsLTS WHERE eclaimsLTS.cms1500_id = eclaims_detailsLTS.cms1500_id AND eclaims_detailsLTS.status='Billed' AND eclaimsLTS.month = '$month' AND eclaimsLTS.year = '$year' AND eclaimsLTS.Agency = '$agency_code' GROUP BY eclaims_detailsLTS.patient_id";

                $TResult2 = get_custom_query_data($chkSQL22);


                $TResult3 = array_merge_recursive($TResult1,$TResult2);

                $sdArray = [];
                $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                $objExec = get_custom_query_data($chkSQL);
                $startDates = array_column($objExec, 'start_date');
                $sdString = "'" . implode ( "', '", $startDates ) . "'";

                $dataArray = [];
                foreach ($TResult3 as $key => $row) {
                    $key1 = array_search($row['patient_id'], array_column($TResult3, 'patient_id'));

                    $dataArray[$key]['month'] = $month;
                    $dataArray[$key]['year'] = $year;
                    $dataArray[$key]['patient_id'] = $row['patient_id'];
                    $dataArray[$key]['patient_name'] = $row['patient_name'];
                    $dataArray[$key]['payor'] = $row['payor_name'];
                    $dataArray[$key]['total_billed_hours'] = $row['total_billed'];
                    if(!empty($key1) && $key1!=$key) {                    
                        if($key1!=$key) {
                            $dataArray[$key]['total_billed_hours'] = $row['total_billed'] + $TResult3[$key1]['total_billed'];
                            unset($dataArray[$key1]);
                        }
                    }

                    /*
                    if($agency_code==1 || $agency_code==3) {
                        $findSQL2 =  "SELECT SUM(period2) AS period2 FROM employee_finalsheet WHERE patient_id = '".$row['patient_id']."' AND Agency = '".$agency_code."' AND month = '".$month."' AND year = '".$year."'" ;
                        $findResult2 = get_custom_query_data($findSQL2, 'row');
                        $dataArray[$key]['total_hours_adp'] = $findResult2['period2'];
                    }
                    if($agency_code==2 || $agency_code==4) {
                        $adp = 0;
                        $findSQL2 =  "SELECT * FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' AND patient_id = '".$row['patient_id']."'";
                        $findResult2 = get_custom_query_data($findSQL2);
                        foreach ($findResult2 as $key2 => $row2) {
                            // code...
                            $start = $row2['start_date'];
                            $daycnt1 = 0;
                            while($daycnt<=13) {
                                $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt1."days");
                                $datetrans = date("Y-m-d",$date);
                                $d =  'd'.sprintf("%02s", $daycnt1 + 1);
                                $month11 = date('m', $date);
                                $year11 = date('Y', $date);
                                if($month11==$month && $year11==$year) {
                                    $adp = $adp + $row2[$d];
                                }
                                $daycnt1++;
                            }
                        }

                        $dataArray[$key]['total_hours_adp'] = $adp;
                    }*/
                    //$SUM = "SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours";

                    $findSQL2 =  "SELECT SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours FROM weekly_hours_by_client WHERE patient_id = '".$row['patient_id']."' AND agency_code = '".$agency_code."' AND month = '".$month."' AND year = '".$year."'" ;
                    $findResult2 = get_custom_query_data($findSQL2, 'row');
                    $dataArray[$key]['total_hours_adp'] = '0';
                    if(!is_null($findResult2['totalWorkedHours'])) {
                        $dataArray[$key]['total_hours_adp'] = $findResult2['totalWorkedHours'];
                    } else {
                        $patient_id = $row['patient_id'];
                        $sql = "DELETE FROM weekly_hours_by_client WHERE month='$month' AND year = '$year' AND agency_code = '$agency_code' AND patient_id = '$patient_id'";
                        set_custom_query_data($sql);

                        if($agency_code==2 || $agency_code==4) {
                            $this->workHourReportByClientGenratedForAgency24($month, $year, $agency_code, $patient_id);
                        }
                        if($agency_code==1 || $agency_code==3) {
                            $this->workHourReportByClientGenratedForAgency13($month, $year, $agency_code, $patient_id);
                        }

                        $findSQL2 =  "SELECT SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours FROM weekly_hours_by_client WHERE patient_id = '".$row['patient_id']."' AND agency_code = '".$agency_code."' AND month = '".$month."' AND year = '".$year."'" ;
                        $findResult2 = get_custom_query_data($findSQL2, 'row');
                        $dataArray[$key]['total_hours_adp'] = $findResult2['totalWorkedHours'];
                    }                   

                    $findSQL2 =  "SELECT agency_location, Agency FROM patient WHERE patient_id = '".$row['patient_id']."' AND Agency = '".$agency_code."'";
                    $findRow2 = get_custom_query_data($findSQL2, 'row');

                    $sql2 =  "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$findRow2['agency_location']."'";
                    $row2 = get_custom_query_data($sql2, 'row');
                    $dataArray[$key]['patient_branch_name'] = $row2['agency_location_name'];
                    $dataArray[$key]['patient_agency'] = $findRow2['Agency'];

                    //$idoaData = $this->getIdoaDetails($month, $year, $row['patient_id'], $agency_code);
                    //$dataArray[$key]['total_hours_adp_idoa'] = $idoaData[0];
                    //$dataArray[$key]['total_billed_hours_idoa'] = $idoaData[1];

                    $unbilledHours = 0;

                    if($agency_code==2 || $agency_code==4) {
                        //$unbilledHours = $this->generateUnbilledHoursMCO24($month, $year, $agency_code, $row['patient_id']);
                    }
                    if($agency_code==1 || $agency_code==3) {
                        //$unbilledHours = $this->generateUnbilledHoursMCO13($month, $year, $agency_code, $row['patient_id']);
                    }

                    $unbilledHours = $dataArray[$key]['total_hours_adp'] - $dataArray[$key]['total_billed_hours']; 

                    $dataArray[$key]['total_unbilled_hours'] = $unbilledHours;
                }

                //print_r($dataArray);
                //print_r(count($dataArray));die;
                if(!empty($dataArray)) {
                    foreach ($dataArray as $key => $insertArray) {
                        $patient_id = $insertArray['patient_id'];
                        $sqlh = "SELECT * FROM hca_billed_report_mco WHERE month = '".$month."' AND year = '".$year."' AND patient_agency = '".$agency_code."' AND patient_id = '".$patient_id."'";
                        $rowh = get_custom_query_data($sqlh, 'row');
                        if(!empty($rowh['id'])) {
                            $updateArray = [];
                            $updateArray['total_billed_hours'] = $insertArray['total_billed_hours'];
                            $updateArray['total_billed_hours_idoa'] = $insertArray['total_billed_hours_idoa'];

                            $where = [];
                            $where['id'] = $rowh['id'];

                            $this->Comman_model->update('hca_billed_report_mco', $where, $updateArray);
                        } else {
                            $insertArray['timestamp'] = $batch;
                            $this->Comman_model->insert('hca_billed_report_mco', $insertArray);
                        }                        
                    }
                    $this->session->set_flashdata("message", "Records has been generated successfully.");
                    redirect('dashboardd/generateReportClientsBilledMCO'.'?month='.$month.'&year='.$year.'&search=Search');
                }
            }

            $cond = " WHERE patient_agency='".$agency_code."'";
            $cond1 = "";
            if(!empty($_GET['search']) && $_GET['search']=='Search') {                
                if(!empty($_GET['month'])) {
                    $cond .= " AND month = '".$_GET['month']."'";
                }
                if(!empty($_GET['year'])) {
                    $cond .= " AND year = '".$_GET['year']."'";
                }
                $cond1 = $cond;
                if(!empty($_GET['batchFilter'])) {
                    $cond .= " AND timestamp = '".$_GET['batchFilter']."'";
                }
                if(!empty($_GET['agencyLocation'])) {
                    $cond .= " AND patient_branch_name LIKE '%".$_GET['agencyLocation']."%'";
                }
                if(!empty($_GET['payorgroup'])) {
                    $cond .= " AND payor LIKE '%".$_GET['payorgroup']."%'";
                }
                if(!empty($_GET['unbilled'])) {
                    $cond .= " AND (total_billed_hours = 0 OR total_billed_hours < total_hours_adp)";
                }
            }

            if(!empty($_GET['submit']) && $_GET['submit']=='Generate Excel') {
                if(!empty($_GET['month']) && !empty($_GET['year'])) {
                    redirect('dashboardd/reportClientsBilledMCOFromActivityLog?month='.$_GET['month'].'&year='.$_GET['year']);
                } else {
                    $this->session->set_flashdata("error_message", "Please select month and year.");
                }
            }

            $billedUnbilledData = '';
            if(!empty($_GET['search']) && $_GET['search']=='Search') {                
                $sql = "SELECT * FROM hca_billed_report_mco $cond ORDER BY id ASC";
                $billedUnbilledData = $this->Comman_model->getCustomQueryData($sql);
            }

            $sqlb = "SELECT DISTINCT timestamp FROM hca_billed_report_mco $cond1 ORDER BY id ASC";
            $batchData = $this->Comman_model->getCustomQueryData($sqlb);

            $sqlb = "SELECT * FROM agency_location";
            $agencyLocationData = $this->Comman_model->getCustomQueryData($sqlb);

            $data['billedUnbilledData'] = $billedUnbilledData;
            $data['batchData'] = $batchData;
            $data['agencyLocationData'] = $agencyLocationData;            
            $data['month'] = $_GET['month'];
            $data['year'] = $_GET['year'];
            $data['unbilled'] = $_GET['unbilled'];
            $data['mco_idoa'] = $mcoIdoa;
            $data['agency_code'] = $agency_code;
            $data['batchFilter'] = $_GET['batchFilter'];
            $data['agencyLocation'] = $_GET['agencyLocation'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/hca-billed-unbilled-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    function workHourReportByClientGenratedForAgency24($month, $year, $agency_code, $patient_id) {
        $sdArray = [];
        $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
        $objExec = get_custom_query_data($chkSQL);
        $startDates = array_column($objExec, 'start_date');
        $sdString = "'" . implode ( "', '", $startDates ) . "'";

        $sql = "SELECT patient_id, agency_location FROM patient WHERE Agency = '".$agency_code."'";
        if(!empty($patient_id)) {
            $sql .= " AND patient_id = '".$patient_id."'";
        }
        $res = get_custom_query_data($sql);
        if(!empty($res)) {
            foreach ($res as $ekey => $erow) {
                $patient_id = $erow['patient_id'];

                $chkSQL = "SELECT *, SUM(d01) as d01, SUM(d02) as d02, SUM(d03) as d03, SUM(d04) as d04, SUM(d05) as d05, SUM(d06) as d06, SUM(d07) as d07, SUM(d08) as d08, SUM(d09) as d09, SUM(d10) as d10, SUM(d11) as d11, SUM(d12) as d12, SUM(d13) as d13, SUM(d14) as d14 FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '".$agency_code."' AND patient_id = '".$patient_id."' GROUP BY start_date";
                $objExec = get_custom_query_data($chkSQL);

                $dataArray = [];
                $checkHours = 0;
                $duplicateEntry = [];

                foreach ($objExec as $key => $objResult) {
                    $start = $objResult['start_date'];
                    $month1 = date('m', strtotime($objResult['start_date']));
                    $year1 = date('Y', strtotime($objResult['start_date']));
                    
                    $daycnt = 0;
                    $start = $objResult['start_date'];
                    while($daycnt<=13) {
                        $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                        $datetrans = date("Y-m-d", $date);
                        $d =  'd'.sprintf("%02s", $daycnt + 1);
                        $dd =  'day'.date("d", $date);
                        //echo '<br>';
                        $month11 = date('m', $date);
                        $year11 = date('Y', $date);
                        if($objResult[$d]>0 && $month==$month11 && $year11==$year) {
                            //$dataArray[$dd] = $dataArray[$dd] + $objResult[$d];   
                            $dataArray[$dd] = $objResult[$d];   
                            $checkHours++;                
                        }
                        $daycnt++;
                    }   
                    $dataArray['employee_id'] = $objResult['employee_id'];
                    $dataArray['patient_id'] = $patient_id;
                }
                //$dataArray['ssn'] = $erow['ssn'];
                $dataArray['agency_location'] = $erow['agency_location'];
                $dataArray['month'] = $month;
                $dataArray['year'] = $year;
                $dataArray['agency_code'] = $agency_code;
                if(!empty($dataArray) && $checkHours>0) {
                    $sqln = "SELECT * FROM weekly_hours_by_client WHERE patient_id = '".$patient_id."' AND month = '".$month."' AND year = '".$year."' AND agency_code = '".$agency_code."'";
                    $rown = $this->Comman_model->getCustomQueryData($sqln, 'row');
                    if(!empty($rown)) {
                        $where = [];
                        $where['id'] = $rown['id'];
                        $this->Comman_model->update('weekly_hours_by_client', $where, $dataArray);
                    } else {
                        $this->Comman_model->insert('weekly_hours_by_client', $dataArray);
                    }                    
                }
            }
            echo "Scripts running successfully.";
        }
    }

    function workHourReportByClientGenratedForAgency13($month, $year, $agency_code, $patient_id) {
        $startdate = $year.'-'.$month.'-01';
        $sql = "SELECT patient_id, agency_location FROM patient WHERE Agency = '".$agency_code."'";
        if(!empty($patient_id)) {
            $sql .= " AND patient_id = '".$patient_id."'";
        }
        $res = $this->Comman_model->getCustomQueryData($sql);
        if(!empty($res)) {
            foreach ($res as $ekey => $erow) {
                $patient_id = $erow['patient_id'];

                $chkSQL = "SELECT *, SUM(day01) as day01, SUM(day02) as day02, SUM(day03) as day03, SUM(day04) as day04, SUM(day05) as day05, SUM(day06) as day06, SUM(day07) as day07, SUM(day08) as day08, SUM(day09) as day09, SUM(day10) as day10, SUM(day11) as day11, SUM(day12) as day12, SUM(day13) as day13, SUM(day14) as day14, SUM(day15) as day15, SUM(day16) as day16, SUM(day17) as day17, SUM(day18) as day18, SUM(day19) as day19, SUM(day20) as day20, SUM(day21) as day21, SUM(day22) as day22, SUM(day23) as day23, SUM(day24) as day24, SUM(day25) as day25, SUM(day26) as day26, SUM(day27) as day27, SUM(day28) as day28, SUM(day29) as day29, SUM(day30) as day30, SUM(day31) as day31 FROM employee_finalsheet WHERE month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."' AND patient_id = '".$patient_id."'";
                $objExec = $this->Comman_model->getCustomQueryData($chkSQL);

                $dataArray = [];
                $checkHours = 0;
                $duplicateEntry = [];

                foreach ($objExec as $key => $objResult) {
                    $start = $objResult['start_date'];
                    $month1 = date('m', strtotime($objResult['start_date']));
                    $year1 = date('Y', strtotime($objResult['start_date']));
                    
                    $daycnt = 0;
                    $start = date('Y-m-d', strtotime($startdate));
                    while($daycnt<=30) {
                        $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                        $datetrans = date("Y-m-d", $date);
                        $d =  'day'.sprintf("%02s", $daycnt + 1);
                        if($objResult[$d]>0) {
                            $dataArray[$d] = $objResult[$d];
                            $checkHours++;                
                        }
                        $daycnt++;
                    }   
                    $dataArray['employee_id'] = $objResult['employee_id'];
                    $dataArray['patient_id'] = $patient_id;
                }
                //$dataArray['ssn'] = $erow['ssn'];
                $dataArray['agency_location'] = $erow['agency_location'];
                $dataArray['month'] = $month;
                $dataArray['year'] = $year;
                $dataArray['agency_code'] = $agency_code;
                if(!empty($dataArray) && $checkHours>0) {

                    $sqln = "SELECT * FROM weekly_hours_by_client WHERE patient_id = '".$patient_id."' AND month = '".$month."' AND year = '".$year."' AND agency_code = '".$agency_code."'";
                    $rown = $this->Comman_model->getCustomQueryData($sqln, 'row');
                    if(!empty($rown)) {
                        $where = [];
                        $where['id'] = $rown['id'];
                        $this->Comman_model->update('weekly_hours_by_client', $where, $dataArray);
                    } else {
                        $this->Comman_model->insert('weekly_hours_by_client', $dataArray);
                    }                    
                }
            }
            echo "Scripts running successfully.";
        }
    }


    public function payment() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
                
            $dataArray = [];

            $cond = ' WHERE 1';
            $payorgroup = $_GET['payorgroup'];
            $batchFilter = $_GET['batchFilter'];
            if(!empty($payorgroup)) {
                $cond .= " AND Customer LIKE '%".$payorgroup."%'";
            }

            if(!empty($batchFilter)) {
                $cond .= " AND batch_id LIKE '%".$batchFilter."%'";
            }

            if(!empty($_GET['search']) && $_GET['search']=='Search') {
                if($agency_code==1) {
                    $sql = "SELECT * FROM homemaker_payments.payments $cond ORDER BY S_No ASC";
                } else if($agency_code==3) {
                    $sql = "SELECT * FROM caregivers_payments.payments $cond ORDER BY S_No ASC";
                } else {
                    $sql = "SELECT * FROM seniorcare_payments.payments $cond ORDER BY S_No ASC";
                }                
                $pageData = $this->Comman_model->getCustomQueryData($sql);
            }


            if($agency_code==1) {
                $sqlb = "SELECT DISTINCT batch_id FROM homemaker_payments.payments ORDER BY S_No DESC";
            } else if($agency_code==3) {
                $sqlb = "SELECT DISTINCT batch_id FROM caregivers_payments.payments ORDER BY S_No DESC";
            } else {
                $sqlb = "SELECT DISTINCT batch_id FROM seniorcare_payments.payments ORDER BY S_No DESC";
            }            
            $batchData = $this->Comman_model->getCustomQueryData($sqlb);

            $data['pageData']    = $pageData;
            $data['batchData']   = $batchData;
            $data['payorgroup']  = $payorgroup;
            $data['batchFilter'] = $batchFilter;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/payment-report.php', $data);
            $this->load->view('common/footer-new.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('report/payment-report-new.php', $data);
        } else {
            redirect();
        }
    }

    public function vpr() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
                
            $dataArray = [];

            $cond = ' WHERE 1';
            $payorgroup = $_GET['payorgroup'];
            $batchFilter = $_GET['batchFilter'];
            $status = $_GET['status'];
            if(!empty($payorgroup)) {
                $cond .= " AND Customer LIKE '%".$payorgroup."%'";
            }

            if(!empty($batchFilter)) {
                $cond .= " AND batch_id LIKE '%".$batchFilter."%'";
            }

            if(!empty($status)) {
                $cond .= " AND status LIKE '%".$status."%'";
            }

            if(!empty($_GET['search']) && $_GET['search']=='Search') {
                if($agency_code==1) {
                    $sql = "SELECT * FROM homemaker.payments $cond ORDER BY S_No ASC";
                } else if($agency_code==3) {
                    $sql = "SELECT * FROM caregiver.payments $cond ORDER BY S_No ASC";
                } else {
                    $sql = "SELECT * FROM seniorcare.payments $cond ORDER BY S_No ASC";
                }                
                $pageData = $this->Comman_model->getCustomQueryData($sql);
            }


            if($agency_code==1) {
                $sqlb = "SELECT DISTINCT batch_id FROM homemaker.payments ORDER BY S_No DESC";
            } else if($agency_code==3) {
                $sqlb = "SELECT DISTINCT batch_id FROM caregiver.payments ORDER BY S_No DESC";
            } else {
                $sqlb = "SELECT DISTINCT batch_id FROM seniorcare.payments ORDER BY S_No DESC";
            }            
            $batchData = $this->Comman_model->getCustomQueryData($sqlb);

            $data['pageData']    = $pageData;
            $data['batchData']   = $batchData;
            $data['payorgroup']  = $payorgroup;
            $data['batchFilter'] = $batchFilter;
            $data['status']      = $status;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/vpr-report.php', $data);
            $this->load->view('common/footer-new.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('report/vpr-report-new.php', $data);
        } else {
            redirect();
        }
    }

    function generateReportClientsBilledMCO2($month, $year, $agency_code) {
        if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($month) && !empty($year)) {

            //$month      = $_GET['month'];
            //$year       = $_GET['year'];

            $chkSQL22 = "SELECT * FROM weekly_hours_by_client, patient WHERE weekly_hours_by_client.patient_id = patient.patient_id AND weekly_hours_by_client.month = '$month' AND weekly_hours_by_client.year = '$year' AND weekly_hours_by_client.agency_code = '$agency_code'";
            $TResult2 = get_custom_query_data($chkSQL22);
            
            foreach ($TResult2 as $key => $row) {

                $patient_id = $row['patient_id'];
                $month = $row['month'];
                $year = $row['year'];
                $agency_code = $row['agency_code'];

                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' ORDER BY district_id DESC LIMIT 1";
                $districtResult = get_custom_query_data($districtSQL, 'row');
                if (!empty($districtResult)) {
                    $mco = $districtResult['DistrictID_Ref'];                               
                } else {
                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));
                    //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<'$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";

                    $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<='$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                    $districtResult = get_custom_query_data($districtSQL, 'row');
                    if (!empty($districtResult)) {
                        $mco = $districtResult['DistrictID_Ref'];
                    }                               
                }

                $where = [];
                $where['DistrictID'] = $mco;
                $where['Agency'] = $agency_code;
                $dtData = $this->Comman_model->get_row('tbldistricts', $where);  

                $dataArray = [];

                $dataArray['month'] = $month;
                $dataArray['year'] = $year;
                $dataArray['patient_id'] = $row['patient_id'];
                $dataArray['patient_name'] = $row['name'];
                $dataArray['payor'] = $dtData['DistrictName'];

                $billed = 0; $unbilled = 0;
                for ($i=1; $i<=31; $i++) {
                    $status = '';
                    $date = $year.'-'.$month.'-'.$i;
                    $datetrans = date('Y-m-d', strtotime($date));

                    $chkSQL3 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.idoa_id = idoadb_details.idoa_id AND idoadb.patient_id = '$patient_id' AND idoadb_details.date = '$datetrans' AND idoadb.month='$month' AND idoadb.year='$year' AND idoadb.Agency='$agency_code' AND idoadb_details.status = 'Billed'";
                    $objResult3 = $this->Comman_model->getCustomQueryData($chkSQL3, 'row');
                    if (!empty($objResult3)) { 
                        $status = $objResult3['status'];    
                    }

                    $chkSQL3 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadbLTS.patient_id = '$patient_id' AND date = '$datetrans' AND month='$month' AND year='$year' AND idoadbLTS.Agency='$agency_code' AND idoadb_detailsLTS.status = 'Billed'";
                    $objResult3 = $this->Comman_model->getCustomQueryData($chkSQL3, 'row');
                    if (!empty($objResult3)) { 
                        $status = $objResult3['status'];    
                    }

                    $chkSQL8 = "SELECT * FROM eclaims_details WHERE patient_id = '$patient_id' AND date = '$datetrans' AND status = 'Billed' AND Agency='$agency_code'";
                    $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');
                    if (!empty($objResult8)) { 
                        $status = $objResult8['status'];
                    }

                    $chkSQL8 = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$patient_id' AND date = '$datetrans' AND status = 'Billed' AND Agency='$agency_code'";
                    $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');
                    if (!empty($objResult8))  { 
                        $status = $objResult8['status'];
                    }

                    $d = 'day'.sprintf("%02s", $i);
                    if($status=='Billed') {
                        $billed = $billed + $row[$d];
                    } else {
                        $unbilled = $unbilled + $row[$d];
                    }
                }

                $dataArray['total_billed_hours'] = $billed;
                $dataArray['total_unbilled_hours'] = $unbilled;
                
                $dataArray['total_hours_adp'] = $billed + $unbilled;
                
                $findSQL2 =  "SELECT agency_location, Agency FROM patient WHERE patient_id = '".$row['patient_id']."' AND Agency = '".$agency_code."'";
                $findRow2 = get_custom_query_data($findSQL2, 'row');

                $sql2 =  "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$findRow2['agency_location']."'";
                $row2 = get_custom_query_data($sql2, 'row');
                $dataArray['patient_branch_name'] = $row2['agency_location_name'];
                $dataArray['patient_agency'] = $findRow2['Agency'];

                //$idoaData = $this->getIdoaDetails($month, $year, $row['patient_id'], $agency_code);
                //$dataArray['total_hours_adp_idoa'] = $idoaData[0];
                //$dataArray['total_billed_hours_idoa'] = $idoaData[1];



                if(!empty($dataArray)) {
                    $sqlh = "SELECT * FROM hca_billed_report_mco WHERE month = '".$month."' AND year = '".$year."' AND patient_agency = '".$agency_code."' AND patient_id = '".$patient_id."'";
                    $rowh = get_custom_query_data($sqlh, 'row');
                    if(!empty($rowh['id'])) {
                        $where = [];
                        $where['id'] = $rowh['id'];
                        $this->Comman_model->update('hca_billed_report_mco', $where, $dataArray);
                    } else {
                        $this->Comman_model->insert('hca_billed_report_mco', $dataArray);
                    }                    
                }
            }
            $this->session->set_flashdata("message", "Records has been generated successfully.");
            redirect('dashboardd/generateReportClientsBilledMCO'.'?month='.$month.'&year='.$year);
        }
    }

    /*** Using table weekly_hours_by_client***/
    function getTotalBilledHoursByMonth($month,$year,$patient_id,$agency_code) {

    }

    public function generateReportClientsBilledMCOOLD() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                //redirect('dashboardd/generateReportClientsBilledIDOAMonthly');
            }
                
            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {

                $month      = $_GET['month'];
                $year       = $_GET['year'];
                $mcoIdoa    = $_GET['mco_idoa'];
                $unbilled   = $_GET['unbilled'];  

                $colName = '"2-PatientName"';
                $payorName = '"Insurance Company Name"';

                $chkSQL22 = "SELECT eclaims.`$colName` as patient_name, eclaims.`$payorName` as payor_name, eclaims_details.patient_id, SUM(eclaims_details.units) as total_billed FROM eclaims,eclaims_details WHERE eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.status='Billed' AND eclaims_details.month = '$month' AND eclaims_details.year = '$year' AND eclaims_details.Agency = '$agency_code' GROUP BY eclaims_details.patient_id";
                $TResult1 = get_custom_query_data($chkSQL22);

                $chkSQL22 = "SELECT eclaimsLTS.`$colName` as patient_name, eclaimsLTS.`$payorName` as payor_name, eclaims_detailsLTS.patient_id, SUM(eclaims_detailsLTS.units) as total_billed FROM eclaimsLTS,eclaims_detailsLTS WHERE eclaimsLTS.cms1500_id = eclaims_detailsLTS.cms1500_id AND eclaims_detailsLTS.status='Billed' AND eclaims_detailsLTS.month = '$month' AND eclaims_detailsLTS.year = '$year' AND eclaims_detailsLTS.Agency = '$agency_code' GROUP BY eclaims_detailsLTS.patient_id";
                $TResult2 = get_custom_query_data($chkSQL22);

                $TResult3 = array_merge_recursive($TResult1,$TResult2);                

                $dataArray = [];
                foreach ($TResult3 as $key => $row) {
                    $key1 = array_search($row['patient_id'], array_column($TResult3, 'patient_id'));

                    $dataArray[$key]['month'] = $month;
                    $dataArray[$key]['year'] = $year;
                    $dataArray[$key]['patient_id'] = $row['patient_id'];
                    $dataArray[$key]['patient_name'] = $row['patient_name'];
                    $dataArray[$key]['payor'] = $row['payor_name'];
                    $dataArray[$key]['total_billed_hours'] = $row['total_billed'];
                    if(!empty($key1) && $key1!=$key) {                    
                        if($key1!=$key) {
                            $dataArray[$key]['total_billed_hours'] = $row['total_billed'] + $TResult3[$key1]['total_billed'];
                            unset($dataArray[$key1]);
                        }
                    }

                    $findSQL2 =  "SELECT SUM(period2) AS period2 FROM employee_finalsheet WHERE patient_id = '".$row['patient_id']."' AND Agency = '".$agency_code."' AND month = '".$month."' AND year = '".$year."'" ;
                    $findResult2 = get_custom_query_data($findSQL2, 'row');
                    $dataArray[$key]['total_hours_adp'] = $findResult2['period2'];

                    $findSQL2 =  "SELECT agency_location, Agency FROM patient WHERE patient_id = '".$row['patient_id']."' AND Agency = '".$agency_code."'";
                    $findRow2 = get_custom_query_data($findSQL2, 'row');

                    $sql2 =  "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$findRow2['agency_location']."'";
                    $row2 = get_custom_query_data($sql2, 'row');
                    $dataArray[$key]['patient_branch_name'] = $row2['agency_location_name'];
                    $dataArray[$key]['patient_agency'] = $findRow2['Agency'];

                    $idoaData = $this->getIdoaDetails($month, $year, $row['patient_id'], $agency_code);
                    $dataArray[$key]['total_hours_adp_idoa'] = $idoaData[0];
                    $dataArray[$key]['total_billed_hours_idoa'] = $idoaData[1];
                }
                //print_r(count($dataArray));die;
                if(!empty($dataArray)) {
                    foreach ($dataArray as $key => $insertArray) {
                        $this->Comman_model->insert('hca_billed_report_mco', $insertArray);
                        $this->session->set_flashdata("message", "Records has been generated successfully.");
                    }
                    redirect('dashboardd/generateReportClientsBilledMCO');
                }
            }

            $cond = " WHERE patient_agency='".$agency_code."'";
            if(!empty($_GET['search']) && $_GET['search']=='Search') {                
                if(!empty($_GET['month'])) {
                    $cond .= " AND month = '".$_GET['month']."'";
                }
                if(!empty($_GET['year'])) {
                    $cond .= " AND year = '".$_GET['year']."'";
                }
                if(!empty($_GET['unbilled'])) {
                    $cond .= " AND total_billed_hours < total_hours_adp";
                }
            }

            if(!empty($_GET['submit']) && $_GET['submit']=='Generate Excel') {
                if(!empty($_GET['month']) && !empty($_GET['year'])) {
                    redirect('dashboardd/reportClientsBilledMCOFromActivityLog?month='.$_GET['month'].'&year='.$_GET['year']);
                } else {
                    $this->session->set_flashdata("error_message", "Please select month and year.");
                }
            }


            $sql = "SELECT * FROM hca_billed_report_mco $cond ORDER BY id ASC";
            $billedUnbilledData = $this->Comman_model->getCustomQueryData($sql);

            $data['billedUnbilledData'] = $billedUnbilledData;
            $data['month'] = $_GET['month'];
            $data['year'] = $_GET['year'];
            $data['unbilled'] = $_GET['unbilled'];
            $data['mco_idoa'] = $mcoIdoa;
            $data['agency_code'] = $agency_code;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/hca-billed-unbilled-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    function getIdoaDetails($month, $year, $patientId, $agency_code) {
        $sdArray = [];
        $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
        $objExec = get_custom_query_data($chkSQL);
        $startDates = array_column($objExec, 'start_date');        
        $total_hours_adp = $total_billed = 0;
        foreach ($startDates as $start) {
            // code...        
            $chkSQL22 = "SELECT SUM(idoadb_details.units) as total_billed, idoadb.patient_id FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND MONTH(idoadb_details.date) = '$month' AND YEAR(idoadb_details.date) = '$year' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed' AND idoadb_details.Agency = '".$agency_code."' AND idoadb.patient_id = '".$patientId."' GROUP BY idoadb.patient_id";
            $objResult22 = get_custom_query_data($chkSQL22);

            $chkSQL32 = "SELECT SUM(idoadb_detailsLTS.units) as total_billed, idoadbLTS.patient_id FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND MONTH(idoadb_detailsLTS.date) = '$month' AND YEAR(idoadb_detailsLTS.date) = '$year' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed' AND idoadb_detailsLTS.Agency = '".$agency_code."' AND idoadbLTS.patient_id = '".$patientId."' GROUP BY idoadbLTS.patient_id";
            $objResult32 = get_custom_query_data($chkSQL32);

            $TResult3 = array_merge_recursive($objResult22,$objResult32);

            $dataArray = [];
            foreach ($TResult3 as $key => $row) {
                $key1 = array_search($row['patient_id'], array_column($TResult3, 'patient_id'));
                $dataArray[$key]['total_billed_hours'] = $row['total_billed'];
                if(!empty($key1) && $key1!=$key) {                    
                    if($key1!=$key) {
                        $dataArray[$key]['total_billed_hours'] = $row['total_billed'] + $TResult3[$key1]['total_billed'];
                        unset($dataArray[$key1]);
                    }
                }
                $total_billed = $total_billed + $dataArray[$key]['total_billed_hours'];
                $findSQL2 =  "SELECT SUM(total_2weekly) AS adp FROM employee_2finalsheet WHERE start_date = '$start' AND Agency = '$agency_code' AND patient_id = '".$row['patient_id']."'";
                $findResult2 = get_custom_query_data($findSQL2, 'row');
                $total_hours_adp = $total_hours_adp + $findResult2['adp'];
            }
        }

        $data = [];
        $data[0] = $total_hours_adp;
        $data[1] = $total_billed;
        $data[2] = $patientId;
        return $data;
    }   

    function deleteReportClientsBilledMCO() {
        if(!empty($_POST['params'])) {
            $params = rtrim($_POST['params'], '|');
            $recordIds = explode('|', $params);
            $table = 'hca_billed_report_mco' ;
            if(!empty($recordIds)) {
                $updateCheck = false;
                $recordIds = implode(',', $recordIds);
                $query = "DELETE FROM `$table` WHERE id IN (".$recordIds.")";
                set_custom_query_data($query);
                $this->session->set_flashdata('message','Records has been deleted successfully.');
                print_r(1);
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record to delete.');
                print_r(0);
            }
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function deleteReportClientsBilledIDOA() {
        if(!empty($_POST['params'])) {
            $params = rtrim($_POST['params'], '|');
            $recordIds = explode('|', $params);
            $table = 'hca_billed_report_idoa' ;
            if(!empty($recordIds)) {
                $updateCheck = false;
                $recordIds = implode(',', $recordIds);
                $query = "DELETE FROM `$table` WHERE id IN (".$recordIds.")";
                set_custom_query_data($query);
                $this->session->set_flashdata('message','Records has been deleted successfully.');
                print_r(1);
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record to delete.');
                print_r(0);
            }
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    public function generateReportClientsBilledIDOA() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                redirect('dashboardd/generateReportClientsBilledIDOAMonthly');
            }
                
            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['fromstartdate'])  && !empty($_GET['mco_idoa'])) {

                $start      = $_GET['fromstartdate'];
                $mcoIdoa    = $_GET['mco_idoa'];

                $chkSQL22 = "SELECT SUM(idoadb_details.units) as total_billed, idoadb.patient_id FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed' AND idoadb_details.Agency = '".$agency_code."' GROUP BY idoadb.patient_id";
                $objResult22 = get_custom_query_data($chkSQL22);

                $chkSQL32 = "SELECT SUM(idoadb_detailsLTS.units) as total_billed, idoadbLTS.patient_id FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed' AND idoadb_detailsLTS.Agency = '".$agency_code."' GROUP BY idoadbLTS.patient_id";
                $objResult32 = get_custom_query_data($chkSQL32);

                $TResult3 = array_merge_recursive($objResult22,$objResult32);

                //print_r($TResult3);die;

                $dataArray = [];
                foreach ($TResult3 as $key => $row) {
                    $key1 = array_search($row['patient_id'], array_column($TResult3, 'patient_id'));

                    $dataArray[$key]['start_date'] = $start;
                    $dataArray[$key]['patient_id'] = $row['patient_id'];
                    $dataArray[$key]['payor'] = 'IDOA';
                    $dataArray[$key]['total_billed_hours'] = $row['total_billed'];
                    if(!empty($key1) && $key1!=$key) {                    
                        if($key1!=$key) {
                            $dataArray[$key]['total_billed_hours'] = $row['total_billed'] + $TResult3[$key1]['total_billed'];
                            unset($dataArray[$key1]);
                        }
                    }
                    $psql =  "SELECT name FROM patient WHERE patient_id = '".$row['patient_id']."'";
                    $prow = get_custom_query_data($psql, 'row');
                    $dataArray[$key]['patient_name'] = $prow['name'];

                    $findSQL2 =  "SELECT SUM(total_2weekly) AS adp FROM employee_2finalsheet WHERE start_date = '$start' AND Agency = '$agency_code' AND patient_id = '".$row['patient_id']."'";
                    $findResult2 = get_custom_query_data($findSQL2, 'row');
                    $dataArray[$key]['total_hours_adp'] = $findResult2['adp'];
                }

                if(!empty($dataArray)) {
                    foreach ($dataArray as $key => $insertArray) {
                        $this->Comman_model->insert('hca_billed_report_idoa', $insertArray);
                        $this->session->set_flashdata("message", "Records has been generated successfully.");
                    }
                    redirect('dashboardd/generateReportClientsBilledIDOA');
                }
            }

            $cond = " WHERE patient_agency='".$agency_code."'";
            if(!empty($_GET['search']) && $_GET['search']=='Search') {
                if(!empty($_GET['fromstartdate'])) {
                    $cond .= " AND start_date = '".$_GET['fromstartdate']."'";
                }
                if(!empty($_GET['unbilled'])) {
                    $cond .= " AND total_billed_hours < total_hours_adp";
                }
            }

            if(!empty($_GET['submit']) && $_GET['submit']=='Generate Excel') {
                if(!empty($_GET['fromstartdate'])) {
                    redirect('dashboardd/reportClientsBilledIDOAFromActivityLog?start_date='.$_GET['fromstartdate']);
                } else {
                    $this->session->set_flashdata("error_message", "Please select start date.");
                }
            }

            $sql = "SELECT * FROM hca_billed_report_idoa $cond ORDER BY id ASC";
            $billedUnbilledData = $this->Comman_model->getCustomQueryData($sql);

            $data['billedUnbilledData'] = $billedUnbilledData;
            $data['fromstartdate'] = $_GET['fromstartdate'];
            $data['unbilled'] = $_GET['unbilled'];
            $data['mco_idoa'] = $mcoIdoa;
            $data['agency_code'] = $this->session->userdata('agency');

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/hca-billed-idoa-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    function generateUnbilledHoursIdoa($month, $year, $agency_code, $patientIds) {
        $cond = "";
        $totalVal = 0;
        $msql = "SELECT *, patient.mco as ptmco, tbldistricts.mco as mco FROM patient,tbldistricts WHERE patient.Agency = '$agency_code' AND tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code' AND patient.patient_id IN(".$patientIds.") ORDER BY patient_id";
        $mrow = get_custom_query_data($msql, 'row');        
        $mcocode =  $mrow['mco'];
        $recno = $mrow['patient_id'];
        $mcochange = 'no';
        $ptid = $mrow['patient_id'];
        $mco = $mrow['DistrictID_Ref'];
        $clientid = $mrow['patient_id'];
        $Agency = $mrow['Agency'];

        $sdArray = [];
        $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
        $objExec = get_custom_query_data($chkSQL);
        if(!empty($objExec)) {
            foreach ($objExec as $ke1 => $ro1) {
                array_push($sdArray, "'".$ro1['start_date']."'");
            }
        }
        $sdString = implode(',', $sdArray);
        $chkSQL = "SELECT * FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' AND patient_id = '$ptid'";
        $objExec = get_custom_query_data($chkSQL);
        
        $totalVal = 0;                    
        foreach ($objExec as $key => $objResult) {

            $ID     = $objResult['service_type'];
            $start  = $objResult['start_date'];
            $status = 'Pending';                                        

            /*** CALCULATE RATE START ***/
            $strSQL1 = "SELECT * FROM tblemployeetypes WHERE EmployeeTypeID = '$ID' AND Agency = '$agency_code'";
            $objResult1 = get_custom_query_data($strSQL1, 'row');
            $rate = $objResult1['rate'];        

            if ($start <= '2017-09-25') { 
                $rate = $objResult1['rate'];     
            } else {
                $rate = 18.29;   
            }                               

            if ($start >= '2019-12-02') { 
                $rate = 20.28;
                // $rate = 21.84;
            }

            if ($start >= '2019-12-30') { 
                $rate = 21.84;
            }

            if ($start >= '2021-04-05') { 
                $rate = 23.40;
            }

            if ($start >= '2022-01-10') { 
                $chkSQL = "SELECT * FROM idoa_rate_settings WHERE start_date = '$start' AND agency = '$agency_code'";
                $objRow = get_custom_query_data($chkSQL, 'row');
                if(!empty($objRow)) {
                    $rate = $objRow['rate'];
                } else {
                    $chkSQL = "SELECT * FROM idoa_rate_settings WHERE start_date <= '$start' AND agency = '$agency_code' ORDER BY id DESC";
                    $objRow = get_custom_query_data($chkSQL, 'row');
                    if(!empty($objRow)) {
                        $rate = $objRow['rate'];
                    }
                }
            }
            /*** CALCULATE RATE END ***/

            $daycnt = 0;                    
            while($daycnt <= 14 )   {
                $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                $datetrans = date("Y-m-d",$date);
                $d =  'd'.sprintf("%02s", $daycnt + 1);
                $val = $objResult[$d]; // * 100;
                $bil = $objResult[$d] * 100;
                $amount = $val * $rate;                        

                $month11 = date('m', $date);
                $year11 = date('Y', $date);                        

                $idoacheck = true;
                $cond = "";
                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' $cond ORDER BY district_id DESC LIMIT 1";
                $districtResult = get_custom_query_data($districtSQL, 'row');
                if (!empty($districtResult)) {
                    $mcocode = $districtResult['mco'];
                    $mco = $districtResult['DistrictID_Ref'];
                } else {
                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));
                    //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<'$cdate' AND start_date!='0000-00-00' $cond ORDER BY district_id DESC LIMIT 1";

                    $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$cdate' AND start_date!='0000-00-00' $cond ORDER BY district_id DESC LIMIT 1";
                    $districtResult = get_custom_query_data($districtSQL, 'row');
                    if (!empty($districtResult)) {
                        $mcocode = $districtResult['mco'];
                        $mco = $districtResult['DistrictID_Ref'];
                    } else {
                        $mcocode = $mrow['mco'];
                        $mco = $mrow['DistrictID_Ref'];     
                    }                               
                }

                if($mcocode==1) {
                    $idoacheck = false;
                }

                if ($val != 0 && $idoacheck && ($month==$month11) && ($year==$year11))  {
                    $totalAdp = $totalAdp + $val;
                }

                $chkSQL2 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.Agency = '$agency_code' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                $objResult2 = get_custom_query_data($chkSQL2, 'row');

                $chkSQLTS = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND  idoadbLTS.patient_id = '$ptid' AND idoadbLTS.Agency = '$agency_code' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                $objResultLTS = get_custom_query_data($chkSQLTS, 'row');

                if ($val != 0 && empty($objResult2) && empty($objResultLTS)  && $idoacheck && ($month==$month11) && ($year==$year11))  {
                    $totalVal = $totalVal + $val;
                }   
                $daycnt++;
            }
        }        
        return $totalVal;
    }

    public function generateReportClientsBilledIDOAMonthly() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $dataArray13 = [];

            $batch = date('Y-m-d H:i:s');

            if($agency_code==1 || $agency_code==3) {                
                if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {
                    $month = $_GET['month'];
                    $year = $_GET['year'];                    

                    $sql = "SELECT SQL_CALC_FOUND_ROWS distinct
                        employee_finaldetail.month,
                        employee_finaldetail.year,
                        employee_finaldetail.invoice_num,
                        employee_finaldetail.rate,
                        employee_finaldetail.service_type,
                        employee_finaldetail.total_bill,
                        employee_finaldetail.total_unit,
                        employee_finaldetail.unit,
                        patient.patient_id, 
                        patient.name as pt_name,
                        patient.phone,
                        patient.CustomFieldCaseNumber,
                        patient.CustomFieldSSN,
                        patient.DistrictID_Ref,   
                        patient.JobStartDate,
                        patient.agency_location,
                        patient.JobEndDate,
                        patient.HMKRHours,
                        tbldistricts.DistrictName,
                        tbldistricts.mco
                        FROM patient,employee_finaldetail,tbldistricts 
                        WHERE (patient.patient_id = employee_finaldetail.patient_id) AND 
                        tbldistricts.DistrictID = patient.DistrictID_Ref AND 
                        tbldistricts.mco != 1 AND 
                        tbldistricts.Agency = '$agency_code' AND patient.Agency = '$agency_code' AND month = '$month' AND year = '$year' AND employee_finaldetail.total_bill>0 AND errorstat >= 0 ORDER BY patient_id ASC";
                    $result = $this->Comman_model->getCustomQueryData($sql);
                    foreach ($result as $key => $row) {

                        $sqll = "SELECT agency_location_name FROM agency_location WHERE agency_location_code='".$row['agency_location']."'";
                        $rowl = $this->Comman_model->getCustomQueryData($sqll, 'row');

                        $dataArray13[$key]['id'] = $key+1;
                        $dataArray13[$key]['month'] = $row['month'];
                        $dataArray13[$key]['year'] = $row['year'];
                        $dataArray13[$key]['patient_name'] = $row['pt_name'];
                        $dataArray13[$key]['patient_location'] = $rowl['agency_location_name'];
                        $dataArray13[$key]['patient_id'] = $row['patient_id'];
                        $dataArray13[$key]['case_number'] = $row['CustomFieldCaseNumber'];
                        $dataArray13[$key]['district'] = $row['DistrictName'];
                        $dataArray13[$key]['hours'] = $row['total_bill'];
                        $dataArray13[$key]['hour_rate'] = $row['rate'];
                        $dataArray13[$key]['total_amount'] = number_format($row['total_bill']*$row['rate'],2);
                        $dataArray13[$key]['total_unit'] = $row['total_unit'];
                        $dataArray13[$key]['unit'] = $row['unit'];
                    }
                }
            }                

            if($agency_code==2 || $agency_code==4) {
                $dataArray = [];
                if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {

                    $month = $_GET['month'];
                    $year = $_GET['year'];
                    $mcoIdoa = $_GET['mco_idoa'];

                    //$chkSQL22 = "SELECT SUM(idoadb_details.units) as total_billed, idoadb.patient_id FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed' AND idoadb_details.Agency = '".$agency_code."' GROUP BY idoadb.patient_id";

                    $chkSQL22 = "SELECT SUM(idoadb_details.units) as total_billed, idoadb.patient_id, idoadb.servicedate FROM idoadb,idoadb_details WHERE idoadb.month = '$month' AND idoadb.year = '$year' AND MONTH(idoadb_details.date) = '$month' AND YEAR(idoadb_details.date) = '$year' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed' AND idoadb_details.Agency = '".$agency_code."' GROUP BY idoadb.patient_id";
                    $objResult22 = get_custom_query_data($chkSQL22);

                    //$chkSQL32 = "SELECT SUM(idoadb_detailsLTS.units) as total_billed, idoadbLTS.patient_id FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed' AND idoadb_detailsLTS.Agency = '".$agency_code."' GROUP BY idoadbLTS.patient_id";

                    $chkSQL32 = "SELECT SUM(idoadb_detailsLTS.units) as total_billed, idoadbLTS.patient_id, idoadbLTS.servicedate FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.month = '$month' AND idoadbLTS.year = '$year' AND MONTH(idoadb_detailsLTS.date) = '$month' AND YEAR(idoadb_detailsLTS.date) = '$year' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed' AND idoadb_detailsLTS.Agency = '".$agency_code."' GROUP BY idoadbLTS.patient_id";
                    $objResult32 = get_custom_query_data($chkSQL32);

                    $TResult3 = array_merge_recursive($objResult22,$objResult32);

                    //print_r($TResult3);die;

                    $sdArray = [];
                    $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                    $objExec = get_custom_query_data($chkSQL);
                    $startDates = array_column($objExec, 'start_date');
                    $sdString = "'" . implode ( "', '", $startDates ) . "'";

                    $dataArray = [];
                    foreach ($TResult3 as $key => $row) {
                        $key1 = array_search($row['patient_id'], array_column($TResult3, 'patient_id'));

                        $start = $row['servicedate'];

                        $dataArray[$key]['start_date'] = $start;
                        $dataArray[$key]['month'] = $month;
                        $dataArray[$key]['year'] = $year;
                        $dataArray[$key]['patient_id'] = $row['patient_id'];
                        $dataArray[$key]['payor'] = 'IDOA';
                        $dataArray[$key]['total_billed_hours'] = $row['total_billed'];
                        if(!empty($key1) && $key1!=$key) {                    
                            if($key1!=$key) {
                                $dataArray[$key]['total_billed_hours'] = $row['total_billed'] + $TResult3[$key1]['total_billed'];
                                unset($dataArray[$key1]);
                            }
                        }
                        $psql =  "SELECT name, Agency, agency_location FROM patient WHERE patient_id = '".$row['patient_id']."'";
                        $prow = get_custom_query_data($psql, 'row');
                        $dataArray[$key]['patient_name'] = $prow['name'];
                        $dataArray[$key]['patient_agency'] = $prow['Agency'];

                        $psql =  "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$prow['agency_location']."'";
                        $prow = get_custom_query_data($psql, 'row');
                        $dataArray[$key]['patient_branch_name'] = $prow['agency_location_name'];

                        //$findSQL2 =  "SELECT SUM(total_2weekly) AS adp FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' AND patient_id = '".$row['patient_id']."'";
                        //$findResult2 = get_custom_query_data($findSQL2, 'row');
                        $adp = 0;
                        /*$findSQL2 =  "SELECT * FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' AND patient_id = '".$row['patient_id']."'";
                        $findResult2 = get_custom_query_data($findSQL2);
                        foreach ($findResult2 as $key2 => $row2) {
                            // code...
                            $start = $row2['start_date'];
                            $daycnt = 0;
                            while($daycnt<=13) {
                                $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                                $datetrans = date("Y-m-d",$date);
                                $d =  'd'.sprintf("%02s", $daycnt + 1);
                                $month11 = date('m', $date);
                                $year11 = date('Y', $date);
                                if($month11==$month && $year11==$year) {
                                    $adp = $adp + $row2[$d];
                                }
                                $daycnt++;
                            }
                        }*/

                        $findSQL2 =  "SELECT SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours FROM weekly_hours_by_client WHERE patient_id = '".$row['patient_id']."' AND agency_code = '".$agency_code."' AND month = '".$month."' AND year = '".$year."'" ;
                        $findResult2 = get_custom_query_data($findSQL2, 'row');
                        $dataArray[$key]['total_hours_adp'] = $findResult2['totalWorkedHours']; 
                        //$dataArray[$key]['total_hours_adp'] = $findResult2['adp'];
                        //$dataArray[$key]['total_hours_adp'] = $adp;

                        $dataArray[$key]['timestamp'] = $batch;
                        $dataArray[$key]['total_unbilled_hours'] = $this->generateUnbilledHoursIdoa($month, $year, $agency_code, $row['patient_id']);
                    }
                    //print_r($dataArray);die;

                    if(!empty($dataArray)) {
                        foreach ($dataArray as $key => $insertArray) {
                            $patient_id = $insertArray['patient_id'];
                            $sqlh = "SELECT * FROM hca_billed_report_idoa WHERE month = '".$month."' AND year = '".$year."' AND patient_agency = '".$agency_code."' AND patient_id = '".$patient_id."'";
                            $rowh = get_custom_query_data($sqlh, 'row');
                            if(!empty($rowh['id'])) {
                                $updateArray = [];
                                $updateArray['total_billed_hours'] = $insertArray['total_billed_hours'];

                                $where = [];
                                $where['id'] = $rowh['id'];

                                $this->Comman_model->update('hca_billed_report_idoa', $where, $updateArray);
                            } else {
                                //$insertArray['timestamp'] = $batch;
                                $this->Comman_model->insert('hca_billed_report_idoa', $insertArray);
                            }                            
                            $this->session->set_flashdata("message", "Records has been generated successfully.");
                        }
                        //$this->generateUnbilledHoursIdoa($month, $year, $agency_code);
                        redirect('dashboardd/generateReportClientsBilledIDOAMonthly'.'?month='.$month.'&year='.$year.'&search=Search');
                    }
                }
            }

            $cond = " WHERE patient_agency='".$agency_code."'";
            $cond1 = "";
            if(!empty($_GET['search']) && $_GET['search']=='Search') {
                if(!empty($_GET['fromstartdate'])) {
                    $cond .= " AND start_date = '".$_GET['fromstartdate']."'";
                }

                if(!empty($_GET['month'])) {
                    $cond .= " AND month = '".$_GET['month']."'";
                }

                if(!empty($_GET['year'])) {
                    $cond .= " AND year = '".$_GET['year']."'";
                }

                $cond1 = $cond;
                if(!empty($_GET['batchFilter'])) {
                    $cond .= " AND timestamp = '".$_GET['batchFilter']."'";
                }

                if(!empty($_GET['unbilled'])) {
                    $cond .= " AND (total_billed_hours = 0 OR total_billed_hours < total_hours_adp)";
                }
            }

            if($agency_code==2 || $agency_code==4) {
                if(!empty($_GET['submit']) && $_GET['submit']=='Generate Excel') {
                    if(!empty($_GET['month']) && !empty($_GET['year'])) {
                        redirect('dashboardd/reportClientsBilledIDOAFromActivityLogMonthly?month='.$_GET['month'].'&year='.$_GET['year']);
                    } else {
                        $this->session->set_flashdata("error_message", "Please select month and year.");
                    }
                }
            }

            $sql = "SELECT * FROM hca_billed_report_idoa $cond ORDER BY id ASC";
            $billedUnbilledData = $this->Comman_model->getCustomQueryData($sql);

            $sqlb = "SELECT DISTINCT timestamp FROM hca_billed_report_idoa $cond1 ORDER BY id ASC";
            $batchData = $this->Comman_model->getCustomQueryData($sqlb);

            $month = $_GET['month'];
            $year = $_GET['year'];

            if($agency_code==2 || $agency_code==4) {
                $data['billedUnbilledData'] = $billedUnbilledData;
            }
            if($agency_code==1 || $agency_code==3) {
                $data['billedUnbilledData'] = $dataArray13;
            }
            $data['fromstartdate'] = $_GET['fromstartdate'];
            $data['unbilled'] = $_GET['unbilled'];
            $data['mco_idoa'] = $mcoIdoa;
            $data['month'] = $month;
            $data['year'] = $year;
            $data['batchFilter'] = $_GET['batchFilter'];
            $data['batchData'] = $batchData;
            $data['agency_code'] = $this->session->userdata('agency');

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            if($agency_code==2 || $agency_code==4) {
                $this->load->view('report/hca-billed-idoa-report.php', $data);
            }
            if($agency_code==1 || $agency_code==3) {
                $this->load->view('report/hca-billed-dhs-report.php', $data);
            }
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function generateReportClientsBilledIDOAMonthlyOLD() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $dataArray13 = [];
            if($agency_code==1 || $agency_code==3) {                
                if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {
                    $month = $_GET['month'];
                    $year = $_GET['year'];

                    $sql = "SELECT SQL_CALC_FOUND_ROWS distinct
                        employee_finaldetail.month,
                        employee_finaldetail.year,
                        employee_finaldetail.invoice_num,
                        employee_finaldetail.rate,
                        employee_finaldetail.service_type,
                        employee_finaldetail.total_bill,
                        employee_finaldetail.total_unit,
                        employee_finaldetail.unit,
                        patient.patient_id, 
                        patient.name as pt_name,
                        patient.phone,
                        patient.CustomFieldCaseNumber,
                        patient.CustomFieldSSN,
                        patient.DistrictID_Ref,   
                        patient.JobStartDate,
                        patient.agency_location,
                        patient.JobEndDate,
                        patient.HMKRHours,
                        tbldistricts.DistrictName,
                        tbldistricts.mco
                        FROM patient,employee_finaldetail,tbldistricts 
                        WHERE (patient.patient_id = employee_finaldetail.patient_id) AND 
                        tbldistricts.DistrictID = patient.DistrictID_Ref AND 
                        tbldistricts.mco != 1 AND 
                        tbldistricts.Agency = '$agency_code' AND patient.Agency = '$agency_code' AND month = '$month' AND year = '$year' AND employee_finaldetail.total_bill>0 AND errorstat >= 0 ORDER BY patient_id ASC";
                    $result = $this->Comman_model->getCustomQueryData($sql);
                    foreach ($result as $key => $row) {

                        $sqll = "SELECT agency_location_name FROM agency_location WHERE agency_location_code='".$row['agency_location']."'";
                        $rowl = $this->Comman_model->getCustomQueryData($sqll, 'row');

                        $dataArray13[$key]['id'] = $key+1;
                        $dataArray13[$key]['month'] = $row['month'];
                        $dataArray13[$key]['year'] = $row['year'];
                        $dataArray13[$key]['patient_name'] = $row['pt_name'];
                        $dataArray13[$key]['patient_location'] = $rowl['agency_location_name'];
                        $dataArray13[$key]['patient_id'] = $row['patient_id'];
                        $dataArray13[$key]['case_number'] = $row['CustomFieldCaseNumber'];
                        $dataArray13[$key]['district'] = $row['DistrictName'];
                        $dataArray13[$key]['hours'] = $row['total_bill'];
                        $dataArray13[$key]['hour_rate'] = $row['rate'];
                        $dataArray13[$key]['total_amount'] = number_format($row['total_bill']*$row['rate'],2);
                        $dataArray13[$key]['total_unit'] = $row['total_unit'];
                        $dataArray13[$key]['unit'] = $row['unit'];
                    }
                }
            }                

            if($agency_code==2 || $agency_code==4) {
                $dataArray = [];
                if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['month']) && !empty($_GET['year']) && !empty($_GET['mco_idoa'])) {

                    $month = $_GET['month'];
                    $year = $_GET['year'];
                    $mcoIdoa = $_GET['mco_idoa'];

                    //$chkSQL22 = "SELECT SUM(idoadb_details.units) as total_billed, idoadb.patient_id FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed' AND idoadb_details.Agency = '".$agency_code."' GROUP BY idoadb.patient_id";

                    $chkSQL22 = "SELECT SUM(idoadb_details.units) as total_billed, idoadb.patient_id, idoadb.servicedate FROM idoadb,idoadb_details WHERE idoadb.month = '$month' AND idoadb.year = '$year' AND MONTH(idoadb_details.date) = '$month' AND YEAR(idoadb_details.date) = '$year' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed' AND idoadb_details.Agency = '".$agency_code."' GROUP BY idoadb.patient_id";
                    $objResult22 = get_custom_query_data($chkSQL22);

                    //$chkSQL32 = "SELECT SUM(idoadb_detailsLTS.units) as total_billed, idoadbLTS.patient_id FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed' AND idoadb_detailsLTS.Agency = '".$agency_code."' GROUP BY idoadbLTS.patient_id";

                    $chkSQL32 = "SELECT SUM(idoadb_detailsLTS.units) as total_billed, idoadbLTS.patient_id, idoadbLTS.servicedate FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.month = '$month' AND idoadbLTS.year = '$year' AND MONTH(idoadb_detailsLTS.date) = '$month' AND YEAR(idoadb_detailsLTS.date) = '$year' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed' AND idoadb_detailsLTS.Agency = '".$agency_code."' GROUP BY idoadbLTS.patient_id";
                    $objResult32 = get_custom_query_data($chkSQL32);

                    $TResult3 = array_merge_recursive($objResult22,$objResult32);

                    //print_r($TResult3);die;

                    $sdArray = [];
                    $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                    $objExec = get_custom_query_data($chkSQL);
                    $startDates = array_column($objExec, 'start_date');
                    $sdString = "'" . implode ( "', '", $startDates ) . "'";

                    $dataArray = [];
                    foreach ($TResult3 as $key => $row) {
                        $key1 = array_search($row['patient_id'], array_column($TResult3, 'patient_id'));

                        $start = $row['servicedate'];

                        $dataArray[$key]['start_date'] = $start;
                        $dataArray[$key]['month'] = $month;
                        $dataArray[$key]['year'] = $year;
                        $dataArray[$key]['patient_id'] = $row['patient_id'];
                        $dataArray[$key]['payor'] = 'IDOA';
                        $dataArray[$key]['total_billed_hours'] = $row['total_billed'];
                        if(!empty($key1) && $key1!=$key) {                    
                            if($key1!=$key) {
                                $dataArray[$key]['total_billed_hours'] = $row['total_billed'] + $TResult3[$key1]['total_billed'];
                                unset($dataArray[$key1]);
                            }
                        }
                        $psql =  "SELECT name, Agency, agency_location FROM patient WHERE patient_id = '".$row['patient_id']."'";
                        $prow = get_custom_query_data($psql, 'row');
                        $dataArray[$key]['patient_name'] = $prow['name'];
                        $dataArray[$key]['patient_agency'] = $prow['Agency'];

                        $psql =  "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$prow['agency_location']."'";
                        $prow = get_custom_query_data($psql, 'row');
                        $dataArray[$key]['patient_branch_name'] = $prow['agency_location_name'];

                        //$findSQL2 =  "SELECT SUM(total_2weekly) AS adp FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' AND patient_id = '".$row['patient_id']."'";
                        //$findResult2 = get_custom_query_data($findSQL2, 'row');
                        $adp = 0;
                        $findSQL2 =  "SELECT * FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' AND patient_id = '".$row['patient_id']."'";
                        $findResult2 = get_custom_query_data($findSQL2);
                        foreach ($findResult2 as $key2 => $row2) {
                            // code...
                            $start = $row2['start_date'];
                            $daycnt = 0;
                            while($daycnt<=13) {
                                $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                                $datetrans = date("Y-m-d",$date);
                                $d =  'd'.sprintf("%02s", $daycnt + 1);
                                $month11 = date('m', $date);
                                $year11 = date('Y', $date);
                                if($month11==$month && $year11==$year) {
                                    $adp = $adp + $row2[$d];
                                }
                                $daycnt++;
                            }
                        }
                        //$dataArray[$key]['total_hours_adp'] = $findResult2['adp'];
                        $dataArray[$key]['total_hours_adp'] = $adp;
                    }
                    //print_r($dataArray);die;

                    if(!empty($dataArray)) {
                        foreach ($dataArray as $key => $insertArray) {
                            $this->Comman_model->insert('hca_billed_report_idoa', $insertArray);
                            $this->session->set_flashdata("message", "Records has been generated successfully.");
                        }
                        redirect('dashboardd/generateReportClientsBilledIDOAMonthly');
                    }
                }
            }

            $cond = " WHERE patient_agency='".$agency_code."'";
            if(!empty($_GET['search']) && $_GET['search']=='Search') {
                if(!empty($_GET['fromstartdate'])) {
                    $cond .= " AND start_date = '".$_GET['fromstartdate']."'";
                }

                if(!empty($_GET['month'])) {
                    $cond .= " AND month = '".$_GET['month']."'";
                }

                if(!empty($_GET['year'])) {
                    $cond .= " AND year = '".$_GET['year']."'";
                }

                if(!empty($_GET['unbilled'])) {
                    $cond .= " AND total_billed_hours < total_hours_adp";
                }
            }

            if($agency_code==2 || $agency_code==4) {
                if(!empty($_GET['submit']) && $_GET['submit']=='Generate Excel') {
                    if(!empty($_GET['month']) && !empty($_GET['year'])) {
                        redirect('dashboardd/reportClientsBilledIDOAFromActivityLogMonthly?month='.$_GET['month'].'&year='.$_GET['year']);
                    } else {
                        $this->session->set_flashdata("error_message", "Please select month and year.");
                    }
                }
            }

            $sql = "SELECT * FROM hca_billed_report_idoa $cond ORDER BY id ASC";
            $billedUnbilledData = $this->Comman_model->getCustomQueryData($sql);

            $month = $_GET['month'];
            $year = $_GET['year'];

            if($agency_code==2 || $agency_code==4) {
                $data['billedUnbilledData'] = $billedUnbilledData;
            }
            if($agency_code==1 || $agency_code==3) {
                $data['billedUnbilledData'] = $dataArray13;
            }
            $data['fromstartdate'] = $_GET['fromstartdate'];
            $data['unbilled'] = $_GET['unbilled'];
            $data['mco_idoa'] = $mcoIdoa;
            $data['month'] = $month;
            $data['year'] = $year;
            $data['agency_code'] = $this->session->userdata('agency');

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            if($agency_code==2 || $agency_code==4) {
                $this->load->view('report/hca-billed-idoa-report.php', $data);
            }
            if($agency_code==1 || $agency_code==3) {
                $this->load->view('report/hca-billed-dhs-report.php', $data);
            }
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    /*
    public function generateReportClientsBilledIDOASlow() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                //redirect('dashboardd/generateReportPayorBilledUnbilled13');
            }
                
            $dataArray = [];
            if(!empty($_GET['btnGenerate']) && $_GET['btnGenerate']=='Generate Report' && !empty($_GET['fromstartdate']) && !empty($_GET['mco_idoa'])) {

                $start      = $_GET['fromstartdate'];
                $mcoIdoa    = $_GET['mco_idoa'];

                $chkSQL22 = "SELECT DISTINCT(idoadb.patient_id) FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.status='Billed'";
                $objResult22 = get_custom_query_data($chkSQL22);
                $patientIds = array_column($objResult22, 'patient_id');

                $chkSQL32 = "SELECT DISTINCT(idoadbLTS.patient_id) FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadb_detailsLTS.status='Billed'";
                $objResult32 = get_custom_query_data($chkSQL32);
                $patientLTSIds = array_column($objResult32, 'patient_id');
                $patientIds  = array_unique(array_merge($patientIds, $patientLTSIds));
                $patientIds = implode(',', $patientIds);

                //$patientIds = 1242;

                $psql =  "SELECT * FROM patient WHERE Agency = '".$agency_code."' AND patient_id IN (".$patientIds.")";
                $presult = get_custom_query_data($psql);

                foreach ($presult as $key => $prow) {
                    // code...
                    $agency_location = $prow['agency_location'];
                    $districtId      = $prow['DistrictID_Ref'];
                    $ptid            = $prow['patient_id'];
                    $agency_code     = $prow['Agency'];

                    $sqld = "SELECT DistrictName FROM tbldistricts WHERE DistrictID = '".$districtId."' AND Agency = '".$agency_code."'";
                    $rowd = get_custom_query_data($sqld, 'row');

                    $month = date('m', strtotime($start));
                    $year = date('Y', strtotime($start));

                    $response = $this->getTotalADPADJByClientIDOA($start, $agency_location, $districtId, $agency_code, $ptid, $month, $year, $mcoIdoa);
                    $totalHoursAdp = $response[0];
                    $totalHoursAdj = $response[1];

                    $response = $this->getTotalBilledHoursByClient($start, $agency_location, $districtId, $agency_code, $ptid, $mcoIdoa, $month, $year);
                    $totalBilledHours = $response[0];
                    $payorName = $response[1];

                    if($totalHoursAdp>0) {
                        $dataArray[$key]['patient_name'] = $prow['name'];
                        //$dataArray[$key]['payor'] = $rowd['DistrictName'];
                        $dataArray[$key]['payor'] = $payorName;
                        $dataArray[$key]['Agency'] = $agency_code;
                        $dataArray[$key]['total_hours_adp'] = $totalHoursAdp;
                        $dataArray[$key]['total_hours_adj'] = $totalHoursAdj;
                        $dataArray[$key]['total_billed_hours'] = $totalBilledHours;
                    }
                }
            }

            $data['billedUnbilledData'] = $dataArray;
            $data['month'] = $month;
            $data['year'] = $year;
            $data['fromstartdate'] = $start;
            $data['mco_idoa'] = $mcoIdoa;

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('report/hca-billed-idoa-report.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }*/

    function getTotalADPADJByClient($startDates, $agency_location, $districtId, $agency_code, $ptid, $month, $year, $mcoIdoa) {
        if(!empty($startDates)) {
            //$sdString = "'" . implode ( "', '", $startDates ) . "'";            
            $adj = $adp = 0;

            $findSQL2 =  "SELECT SUM(period2) AS period2 FROM employee_finalsheet WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND month = '$month' AND year = '$year'" ;
            $findResult2 = get_custom_query_data($findSQL2, 'row');
            $adp = $findResult2['period2'];

            $resultArray = [];
            $resultArray[0] = $adp;
            $resultArray[1] = $adj;
            return $resultArray;
        }
    }

    function getTotalADPADJByClientIDOA($start_date, $agency_location, $districtId, $agency_code, $ptid, $month, $year, $mcoIdoa) {
        if(!empty($start_date)) {
            //$sdString = "'" . implode ( "', '", $startDates ) . "'";            
            $adj = $adp = 0;

            $findSQL2 =  "SELECT SUM(total_2weekly) AS adp FROM employee_2finalsheet WHERE start_date = '$start_date' AND Agency = '$agency_code' AND patient_id = '$ptid'";
            $findResult2 = get_custom_query_data($findSQL2, 'row');
            $adp = $findResult2['adp'];

            $resultArray = [];
            $resultArray[0] = $adp;
            $resultArray[1] = $adj;
            return $resultArray;
        }
    }

    function getTotalBilledHoursByClient($startDates, $agency_location, $districtId, $agency_code, $ptid, $mcoIdoa, $month, $year) {
        if(!empty($startDates)) {
            $val = 0;
            $payorName = '';
            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.DistrictID_Ref = '".$districtId."' AND patient.agency_location = '".$agency_location."' AND patient.patient_id='".$ptid."'";            
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];
                $mco = $mrow['DistrictID_Ref'];
                if($mcoIdoa==1) {
                    $sdString = "'" . implode ( "', '", $startDates ) . "'";
                } else {
                    $sdString = "'".$startDates."'";
                }

                $chkSQL = "SELECT * FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start = $objResult['start_date'];
                        while($daycnt<=14) {
                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);      

                            $month11 = date('m', $date);
                            $year11 = date('Y', $date);                      

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            //if($isMco==$mcocode) {
                            $idoaCheck = false;
                            $mcoCheck = false;

                            $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                            $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                            $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                            $objResult32 = get_custom_query_data($chkSQL32, 'row');
                            if(!empty($objResult22) || !empty($objResult32)) {
                                $idoaCheck = true;
                            }
                            $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                            $TResult = get_custom_query_data($Tquery, 'row');

                            $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                            $TResultLTS = get_custom_query_data($TqueryLTS, 'row');
                            if(!empty($TResult) || !empty($TResultLTS)) {
                                $mcoCheck = true;
                            }

                            if($mcoIdoa==1 && $mcoCheck && $objResult[$d]>0 && $month==$month11 && $year==$year11) {
                                $val = $val + $objResult[$d];
                                if(!empty($TResult) && $payorName=='') {
                                    $sqll = "SELECT * FROM eclaims WHERE cms1500_id = '".$TResult['cms1500_id']."'";
                                    $rowl = get_custom_query_data($sqll, 'row');
                                    $payorName = $rowl['"Insurance Company Name"'];
                                }
                                if(!empty($TResultLTS) && $payorName=='') {
                                    $sqll = "SELECT * FROM eclaimsLTS WHERE cms1500_id = '".$TResultLTS['cms1500_id']."'";
                                    $rowl = get_custom_query_data($sqll, 'row');
                                    $payorName = $rowl['"Insurance Company Name"'];
                                }                                
                            }

                            if($mcoIdoa==2 && $idoaCheck && $objResult[$d]>0) {
                                $val = $val + $objResult[$d];
                                $payorName = "IDOA";
                            }
                            //}
                            $daycnt++;
                        }
                    }
                }                
            }   
            $resultArray = [];
            $resultArray[0] = $val;
            $resultArray[1] = $payorName;
            return $resultArray;
            //return $val;
        }
    }

    function getPayorForBilledUnbilled($startDate) {
        if(!empty($startDate)) {
            $payorData = [];
            $agency_code = $this->session->userdata('agency');
            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' ORDER BY patient.lastname asc";            

            //$msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.patient_id = '10371' ORDER BY patient.lastname asc";
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];
                $mco = $mrow['DistrictID_Ref'];

                $agency_location =  $mrow['agency_location'];
                $sql =  "SELECT * FROM agency_location WHERE agency_location_code = '$agency_location'";
                $row = get_custom_query_data($sql, 'row');

                if($mcocode==0) {
                    //$payorAgencyLocationData = 'IDOA'.' | '.$row['agency_location_name'].' | '.$recno;
                    $payorAgencyLocationData = 'IDOA'.' | '.$row['agency_location_name'];
                    array_push($payorData, $payorAgencyLocationData);
                }
                if($mcocode==1) {
                    //$payorAgencyLocationData = $mrow['DistrictName'].'|'.$row['agency_location_name'].' | '.$recno;
                    $payorAgencyLocationData = $mrow['DistrictName'].' | '.$row['agency_location_name'];
                    array_push($payorData, $payorAgencyLocationData);    
                }                

                $chkSQL2 = "SELECT * FROM employee_2finalsheet WHERE start_date = '$startDate' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start = $objResult['start_date'];
                        $payorCheck = true;
                        while($daycnt<=14) {
                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);
                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                                if($mcocode==0 && $payorCheck && $mco!=$districtResult['DistrictID_Ref']) {
                                    //$payorAgencyLocationData = 'IDOA'.' | '.$row['agency_location_name'].' | '.$recno;
                                    $payorAgencyLocationData = 'IDOA'.' | '.$row['agency_location_name'];
                                    array_push($payorData, $payorAgencyLocationData);
                                    $payorCheck = false;
                                }
                                if($mcocode==1 && $payorCheck  && $mco!=$districtResult['DistrictID_Ref']) {
                                    $dsql =  "SELECT * FROM tbldistricts WHERE DistrictID = '".$districtResult['DistrictID_Ref']."'";
                                    $drow = get_custom_query_data($dsql, 'row');
                                    //$payorAgencyLocationData = $drow['DistrictName'].' | '.$row['agency_location_name'].' | '.$recno;
                                    $payorAgencyLocationData = $drow['DistrictName'].' | '.$row['agency_location_name'];
                                    array_push($payorData, $payorAgencyLocationData);
                                    $payorCheck = false;
                                }                                
                            } else {
                                $mcocode = $mrow['mco'];
                            }
                            $daycnt++;
                        }
                    }
                }                
            }   
            return implode(',', $payorData);
        }
    }

    function getTotalADPADJ($startDate, $agency_location, $districtId, $agency_code) {
        if(!empty($startDate)) {
            $adj = $adp = 0;
            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.DistrictID_Ref = '".$districtId."' AND patient.agency_location = '".$agency_location."'";            
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $ptid = $mrow['patient_id'];
                $agency_code = $mrow['ptAgency'];

                $chkSQL2 = "SELECT * FROM employee_2finalsheet WHERE start_date = '$startDate' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    foreach ($objExec as $key => $objResult) {
                        $adj = $adj + $objResult['adj1'];
                        $adp = $adp + $objResult['total_2weekly'];
                    }
                }                
            }   

            $resultArray = [];
            $resultArray[0] = $adp;
            $resultArray[1] = $adj;
            return $resultArray;
        }
    }

    function getTotalADPADJ13($month, $year, $agency_location, $districtId, $agency_code) {
        if(!empty($month) && !empty($year)) {
            $adj = $adp = 0;
            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.DistrictID_Ref = '".$districtId."' AND patient.agency_location = '".$agency_location."'";            
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $ptid = $mrow['patient_id'];
                $agency_code = $mrow['ptAgency'];

                $chkSQL2 = "SELECT * FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    foreach ($objExec as $key => $objResult) {
                        $adj = $adj + ($objResult['adj1'] + $objResult['adj2']);
                        $adp = $adp + ($objResult['period1'] + $objResult['period2']);
                    }
                }                
            }   

            $resultArray = [];
            $resultArray[0] = $adp;
            $resultArray[1] = $adj;
            return $resultArray;
        }
    }

    function getTotalBilledHours($startDate, $agency_location, $districtId, $agency_code) {
        if(!empty($startDate)) {
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.DistrictID_Ref = '".$districtId."' AND patient.agency_location = '".$agency_location."'";            
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_2finalsheet WHERE start_date = '$startDate' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {

                        $daycnt = 0;
                        $start = $objResult['start_date'];
                        while($daycnt<=14) {

                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);                            

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            //if($isMco==$mcocode) {
                                $idoaCheck = false;
                                $mcoCheck = false;

                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');
                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = true;
                                }
                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');
                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = true;
                                }
                                if(($mcoCheck || $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }
                            //}
                            $daycnt++;
                        }
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalBilledHours13($month, $year, $agency_location, $districtId, $agency_code) {
        if(!empty($month) && !empty($year)) {
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.DistrictID_Ref = '".$districtId."' AND patient.agency_location = '".$agency_location."'";            
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start1 = $year.'-'.$month.'-01';
                        while($daycnt<=31) {

                            $d = 'day'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start1)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);                            

                            $chkSQL = "SELECT * FROM table_1weekly WHERE end_date>='$datetrans' AND start_date<='$datetrans'";
                            $chkResult = get_custom_query_data($chkSQL, 'row');
                            if (!empty($chkResult))  {
                                $start = $chkResult['start_date'];
                            }

                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            //if($isMco==$mcocode) {
                                $idoaCheck = false;
                                $mcoCheck = false;

                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');
                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = true;
                                }
                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');
                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = true;
                                }
                                if(($mcoCheck || $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }
                            //}
                            $daycnt++;
                        }
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalUnbilledHours($startDate, $agency_location, $districtId, $agency_code) {
        if(!empty($startDate)) {
            $agency_code = $this->session->userdata('agency');
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.DistrictID_Ref = '".$districtId."' AND patient.agency_location = '".$agency_location."'";

            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_2finalsheet WHERE start_date = '$startDate' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start = $objResult['start_date'];
                        while($daycnt<=14) {

                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);

                            $idoaCheck = true;
                            $mcoCheck = true;                            

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            //if($isMco==$mcocode) {
                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');

                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = false;
                                }

                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');

                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = false;
                                }
                                if(($mcoCheck && $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }               
                            //}             
                            /*if(empty($TResultLTS) && empty($TResult) && $idoaCheck && $objResult[$d]>0) {
                                $val = $val + $objResult[$d];
                            }*/
                            //$val = $val + $objResult[$d];
                            $daycnt++;
                        }                        
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalUnbilledHours13($month, $year, $agency_location, $districtId, $agency_code) {
        if(!empty($month) && !empty($year)) {
            $agency_code = $this->session->userdata('agency');
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.DistrictID_Ref = '".$districtId."' AND patient.agency_location = '".$agency_location."'";

            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start1 = $year.'-'.$month.'-01';
                        while($daycnt<=31) {

                            $d = 'day'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start1)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);

                            $chkSQL = "SELECT * FROM table_1weekly WHERE end_date>='$datetrans' AND start_date<='$datetrans'";
                            $chkResult = get_custom_query_data($chkSQL, 'row');
                            if (!empty($chkResult))  {
                                $start = $chkResult['start_date'];
                            }

                            $idoaCheck = true;
                            $mcoCheck = true;                            

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            //if($isMco==$mcocode) {
                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');

                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = false;
                                }

                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');

                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = false;
                                }
                                if(($mcoCheck && $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }               
                            //}             
                            /*if(empty($TResultLTS) && empty($TResult) && $idoaCheck && $objResult[$d]>0) {
                                $val = $val + $objResult[$d];
                            }*/
                            //$val = $val + $objResult[$d];
                            $daycnt++;
                        }                        
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalBilledHoursMCOIDOA($startDate, $isMco) {
        if(!empty($startDate)) {
            $agency_code = $this->session->userdata('agency');
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' ORDER BY patient.lastname asc";

            //$msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.patient_id = '4975' ORDER BY patient.lastname asc";
            
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_2finalsheet WHERE start_date = '$startDate' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {

                        $total2Weekly = $objResult['total_2weekly'];
                        $dAll = 0;

                        $daycnt = 0;
                        $start = $objResult['start_date'];
                        while($daycnt<=14) {

                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);                            

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                //$mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            if($isMco==$mcocode) {
                                $idoaCheck = false;
                                $mcoCheck = false;

                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');
                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = true;
                                }
                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');
                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = true;
                                }
                                if(($mcoCheck || $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }
                            }
                            $daycnt++;
                        }
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalBilledHoursMCOIDOA13($month, $year, $isMco) {
        if(!empty($month) && !empty($year)) {
            $agency_code = $this->session->userdata('agency');
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' ORDER BY patient.lastname asc";

            //$msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.patient_id = '4975' ORDER BY patient.lastname asc";
            
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start1 = $year.'-'.$month.'-01';
                        while($daycnt<=31) {

                            $d = 'day'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);

                            //$d = 'day'.sprintf("%02s", $i + 1);
                            //$date111 = 'date'.sprintf("%02s", $i + 1);

                            $date = strtotime(date("Y-m-d", strtotime($start1)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);

                            $chkSQL = "SELECT * FROM table_1weekly WHERE end_date>='$datetrans' AND start_date<='$datetrans'";
                            $chkResult = get_custom_query_data($chkSQL, 'row');
                            if (!empty($chkResult))  {
                                $start = $chkResult['start_date'];
                            }

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                //$mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            if($isMco==$mcocode) {
                                $idoaCheck = false;
                                $mcoCheck = false;

                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');
                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = true;
                                }
                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');
                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = true;
                                }
                                if(($mcoCheck || $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }
                            }
                            $daycnt++;
                        }
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalUnbilledHoursMCOIDOA($startDate, $isMco) {
        if(!empty($startDate)) {
            $agency_code = $this->session->userdata('agency');
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' ORDER BY patient.lastname asc";

            //$msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.patient_id = '4975' ORDER BY patient.lastname asc";

            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_2finalsheet WHERE start_date = '$startDate' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start = $objResult['start_date'];
                        while($daycnt<=14) {

                            $d = 'd'.sprintf("%02s", $daycnt + 1);
                            $date111 = 'date'.sprintf("%02s", $daycnt + 1);                         

                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);

                            $idoaCheck = true;
                            $mcoCheck = true;                            

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                //$mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            if($isMco==$mcocode) {
                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');

                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = false;
                                }

                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');

                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = false;
                                }
                                if(($mcoCheck && $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }               
                            }             
                            /*if(empty($TResultLTS) && empty($TResult) && $idoaCheck && $objResult[$d]>0) {
                                $val = $val + $objResult[$d];
                            }*/
                            //$val = $val + $objResult[$d];
                            $daycnt++;
                        }                        
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalUnbilledHoursMCOIDOA13($month, $year, $isMco) {
        if(!empty($month) && !empty($year)) {
            $agency_code = $this->session->userdata('agency');
            $val = 0;            

            $msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' ORDER BY patient.lastname asc";

            //$msql = "SELECT *, patient.Agency as ptAgency FROM patient,tbldistricts WHERE tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = patient.Agency AND tbldistricts.Agency = '$agency_code' AND patient.patient_id = '4975' ORDER BY patient.lastname asc";

            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $recno = $mrow['patient_id'];
                $ptid = $mrow['patient_id'];
                $mcochange = 'no';
                $DistrictTemp = '';
                $agency_code = $mrow['ptAgency'];

                $PreviousDistrictName = '';
                $districtSQLL =  "SELECT * FROM district WHERE patient_id = '$recno' order by district_id desc limit 1";
                $districtResultT = get_custom_query_data($districtSQLL, 'row');
                if (!empty($districtResultT)) {
                    $PreviousDistrict = $districtResultT['DistrictID_Ref'];
                    $districtSQLLL =  "SELECT * FROM tbldistricts WHERE DistrictID = '$PreviousDistrict' AND Agency = '$agency_code'";
                    $districtResultTT = get_custom_query_data($districtSQLLL, 'row');
                    $PreviousDistrictName = $districtResultTT['DistrictName'];
                } else {
                    //$PreviousDistrict = $mrow['DistrictID_Ref'];
                    //$PreviousDistrictName = $districtResultTT['DistrictName'];
                }                
                $mco = $mrow['DistrictID_Ref'];

                $chkSQL2 = "SELECT * FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' and patient_id = '$ptid'";
                $objExec = get_custom_query_data($chkSQL2);
                if (!empty($objExec)) {
                    $x=0;
                    $startAllDate = [];
                    foreach ($objExec as $key => $objResult) {
                        $daycnt = 0;
                        $start1 = $year.'-'.$month.'-01';
                        while($daycnt<=31) {

                            $d = 'day'.sprintf("%02s", $i + 1);
                            $date111 = 'date'.sprintf("%02s", $i + 1);

                            $date = strtotime(date("Y-m-d", strtotime($start1)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);

                            $chkSQL = "SELECT * FROM table_1weekly WHERE end_date>='$datetrans' AND start_date<='$datetrans'";
                            $chkResult = get_custom_query_data($chkSQL, 'row');
                            if (!empty($chkResult))  {
                                $start = $chkResult['start_date'];
                            }

                            $idoaCheck = true;
                            $mcoCheck = true;                            

                            //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date>='$datetrans' ORDER BY district_id ASC LIMIT 1";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$datetrans' ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                //$mcocode = $districtResult['mco'];
                            } else {
                                $mcocode = $mrow['mco'];
                            }

                            if($isMco==$mcocode) {
                                $chkSQL22 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$start' AND idoadb_details.start_date = '$start' AND idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_details.status='Billed'";
                                $objResult22 = get_custom_query_data($chkSQL22, 'row');                         

                                $chkSQL32 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.servicedate = '$start' AND idoadb_detailsLTS.start_date = '$start' AND idoadbLTS.patient_id = '$ptid' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND idoadb_detailsLTS.status='Billed'";
                                $objResult32 = get_custom_query_data($chkSQL32, 'row');

                                if(!empty($objResult22) || !empty($objResult32)) {
                                    $idoaCheck = false;
                                }

                                $Tquery = "SELECT * FROM eclaims_details WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResult = get_custom_query_data($Tquery, 'row');

                                $TqueryLTS = "SELECT * FROM eclaims_detailsLTS WHERE patient_id = '$ptid' AND Agency = '$agency_code' AND date = '$datetrans' AND status = 'Billed'";
                                $TResultLTS = get_custom_query_data($TqueryLTS, 'row');

                                if(!empty($TResult) || !empty($TResultLTS)) {
                                    $mcoCheck = false;
                                }
                                if(($mcoCheck && $idoaCheck) && $objResult[$d]>0) {
                                    $val = $val + $objResult[$d];
                                }               
                            }
                            $daycnt++;
                        }                        
                    }
                }                
            }   
            return $val;
        }
    }

    function getTotalCurrentHoursAdpAdjTotalBilled($startDate, $agency_code) {
        $sql = "SELECT SQL_CALC_FOUND_ROWS 
            SUM(employee_2finalsheet.total_2weekly) AS TOTAL_BILLED,     
            SUM(employee_2finalsheet.adj1) AS ADJ,
            /*SUM(employee_2finalsheet.total_2weekly + employee_2finalsheet.adj1) AS PD_ADP,*/
            SUM(employee_2finalsheet.total_2weekly) AS PD_ADP
            FROM employee_2finalsheet WHERE start_date = '$startDate' AND total_2weekly >= 0 AND Agency='".$agency_code."'";
        /*$sql = "SELECT SQL_CALC_FOUND_ROWS 
            SUM(employee_2finalsheet.total_2weekly) AS TOTAL_BILLED,     
            SUM(employee_2finalsheet.adj1) AS ADJ,
            SUM(employee_2finalsheet.total_2weekly + employee_2finalsheet.adj1) AS PD_ADP
            FROM employee_2finalsheet WHERE start_date = '$startDate' AND total_2weekly >= 0 AND Agency='".$agency_code."' AND patient_id='4975'";*/
        $row = $this->Comman_model->getCustomQueryData($sql, 'row');

        $TOTAL_BILLED = $row["TOTAL_BILLED"];   
        $ADJ = $row["ADJ"];        
        $PD_ADP = $row["PD_ADP"];

        $resultArray = [];

        $resultArray[0] = $PD_ADP;
        $resultArray[1] = $ADJ;
        $resultArray[2] = $TOTAL_BILLED;

        return $resultArray;
    }

    function getTotalCurrentHoursAdpAdjTotalBilled13($month, $year, $agency_code) {
        $sql = "SELECT SQL_CALC_FOUND_ROWS 
            SUM(employee_finalsheet.period1 + employee_finalsheet.period2) AS TOTAL_BILLED,     
            SUM(employee_finalsheet.adj1 + employee_finalsheet.adj2) AS ADJ
            FROM employee_finalsheet WHERE month = '$month' AND year = '$year' AND Agency='".$agency_code."'";
        $row = $this->Comman_model->getCustomQueryData($sql, 'row');

        $TOTAL_BILLED = $row["TOTAL_BILLED"];   
        $ADJ = $row["ADJ"];        

        $resultArray = [];

        $resultArray[0] = $TOTAL_BILLED;
        $resultArray[1] = $ADJ;

        return $resultArray;
    }

    function getTotalClientsByStartDate($startDate, $agency_code) {
        $strSQL1 = "SELECT distinct patient_id FROM employee_2finalsheet WHERE start_date = '".$startDate."' AND Agency='".$agency_code."'";
        $patientData = $this->Comman_model->getCustomQueryData($strSQL1);
        return count($patientData);
    }

    function getTotalEmployeeByStartDate($startDate, $agency_code) {
        $strSQL1 = "SELECT distinct employee_id FROM employee_2finalsheet WHERE start_date = '".$startDate."' AND Agency='".$agency_code."'";
        $employeeData = $this->Comman_model->getCustomQueryData($strSQL1);
        return count($employeeData);
    }

    function getTotalClientsByStartDate13($month, $year, $agency_code) {
        $strSQL1 = "SELECT distinct patient_id FROM employee_finalsheet WHERE month = '".$month."' AND year = '".$year."' AND Agency='".$agency_code."'";
        $patientData = $this->Comman_model->getCustomQueryData($strSQL1);
        return count($patientData);
    }

    function getTotalEmployeeByStartDate13($month, $year, $agency_code) {
        $strSQL1 = "SELECT distinct employee_id FROM employee_finalsheet WHERE month = '".$month."' AND year = '".$year."' AND Agency='".$agency_code."'";
        $employeeData = $this->Comman_model->getCustomQueryData($strSQL1);
        return count($employeeData);
    }

    public function monthlyBilledHours() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if($agency_code==1 || $agency_code==3) {
                redirect('dashboardd/monthlyBilledHoursHM');
            }

            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/monthly-billed-hours.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function mco1500LTSAll() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if($agency_code==1 || $agency_code==3) {
                redirect('dashboardd/mco1500LTSAll');
            }

            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500LTSAll.php', $data);
            //$this->load->view('common/footer.php');
            $this->load->view('common/footer-new.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('mco/mco1500LTSAll-new.php', $data);
        } else {
            redirect();
        }
    }

    public function mco1500LTSAllHM() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if($agency_code==2 || $agency_code==4) {
                redirect('dashboardd/mco1500LTSAll');
            }


            $data = [];
            /*$strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;*/

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500LTSAllHM.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function splitMco1500() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly where start_date >= '2020-01-01' AND start_date <= '2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/split-mco1500.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function mco1500HM() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $data = [];
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_1weekly where start_date >= '2020-01-01' AND start_date <= '2023-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/mco1500HM.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function postlog($postcomment) {
        $postuser = $this->session->userdata('name');
        $postdate = date("Y-m-d H:i:s");
        $postagency = $this->session->userdata('agency');
        $postmode = 0;
        $notesid = 0;
        $postcategory = '';

        $dataArray = [];
        $dataArray['postdate'] = $postdate;
        $dataArray['postuser'] = $postuser;
        $dataArray['postagency'] = $postagency;
        $dataArray['postperiod'] = $postmode;
        $dataArray['postcomment'] = $postcomment;
        $dataArray['postcategory'] = $postcategory;
        $dataArray['notesid'] = $notesid;

        $postlog_id = $this->Comman_model->insert('postlog', $dataArray);

    }

    public function mcostat() {
        $rec_id = $_POST['rec_id'];
        $msql = "SELECT SQL_CALC_FOUND_ROWS * FROM cms1500 WHERE cms1500_id = '$rec_id'";
        $data['utotal'] = 0;
        $data['mrow'] = $this->Comman_model->getCustomQueryData($msql, 'row');
        $this->load->view('mco/mcostat.php', $data);
    }

    public function mcostat2() {
        $rec_id = $_POST['rec_id'];
        $msql = "SELECT  SQL_CALC_FOUND_ROWS * FROM eclaims  WHERE  cms1500_id = '$rec_id' ";
        $data['utotal'] = 0;
        $data['mrow'] = $this->Comman_model->getCustomQueryData($msql, 'row');
        $this->load->view('mco/mcostat2.php', $data);
    }

    public function billedReverse() {
        $cms1500id = $_POST['cms1500id'];
        $msql = "SELECT * FROM eclaims_details WHERE cms1500_id = '$cms1500id'";
        $mrow = $this->Comman_model->getCustomQueryData($msql, 'row');
        if(!empty($mrow)) {
            $dataArray = [];
            $dataArray['status'] = 'Unbilled';

            $where = [];
            $where['cms1500_id'] = $cms1500id;
            $this->Comman_model->update('eclaims_details', $where, $dataArray);

            echo '1';
        } else {
            echo '2';
        }
    }

    public function billedReverseLTS() {
        $cms1500id = $_POST['cms1500id'];
        $msql = "SELECT * FROM eclaims_detailsLTS WHERE cms1500_id = '$cms1500id'";
        $mrow = $this->Comman_model->getCustomQueryData($msql, 'row');
        if(!empty($mrow)) {
            $dataArray = [];
            $dataArray['status'] = 'Unbilled';

            $where = [];
            $where['cms1500_id'] = $cms1500id;
            $this->Comman_model->update('eclaims_detailsLTS', $where, $dataArray);

            echo '1';
        } else {
            echo '2';
        }
    }

    public function billedReverseIdoa() {
        $idoaId = $_POST['idoaId'];
        $msql = "SELECT * FROM idoadb WHERE idoa_id = '$idoaId'";
        $mrow = $this->Comman_model->getCustomQueryData($msql, 'row');
        if(!empty($mrow)) {
            $dataArray = [];
            $dataArray['status'] = 'Unbilled';

            $where = [];
            $where['idoa_id'] = $idoaId;
            $this->Comman_model->update('idoadb', $where, $dataArray);

            $where = [];
            $where['idoa_id'] = $idoaId;
            $this->Comman_model->update('idoadb_details', $where, $dataArray);

            echo '1';
        } else {
            echo '2';
        }
    }

    public function billedReverseIdoaLTS() {
        $idoaId = $_POST['idoaId'];
        $msql = "SELECT * FROM idoadbLTS WHERE idoa_id = '$idoaId'";
        $mrow = $this->Comman_model->getCustomQueryData($msql, 'row');
        if(!empty($mrow)) {
            $dataArray = [];
            $dataArray['status'] = 'Unbilled';

            $where = [];
            $where['idoa_id'] = $idoaId;
            $this->Comman_model->update('idoadbLTS', $where, $dataArray);

            $where = [];
            $where['idoa_id'] = $idoaId;
            $this->Comman_model->update('idoadb_detailsLTS', $where, $dataArray);

            echo '1';
        } else {
            echo '2';
        }
    }

    

    public function mcostatLTS() {
        $rec_id = $_POST['rec_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $msql = "SELECT SQL_CALC_FOUND_ROWS * FROM cms1500LTS WHERE cms1500_id = '$rec_id' AND month='$month' AND year='$year'";
        $data['utotal'] = 0;
        $data['mrow'] = $this->Comman_model->getCustomQueryData($msql, 'row');
        $this->load->view('mco/mcostat.php', $data);
    }

    public function mcostat2LTS() {
        $rec_id = $_POST['rec_id'];
        $msql = "SELECT  SQL_CALC_FOUND_ROWS * FROM eclaimsLTS  WHERE  cms1500_id = '$rec_id' ";
        $data['utotal'] = 0;
        $data['mrow'] = $this->Comman_model->getCustomQueryData($msql, 'row');
        $this->load->view('mco/mcostat2.php', $data);
    }


    public function mcostatMonthly() {
        $rec_id = $_POST['rec_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $msql = "SELECT SQL_CALC_FOUND_ROWS * FROM cms1500 WHERE cms1500_id = '$rec_id' AND month='$month' AND year='$year'";
        $data['utotal'] = 0;
        $data['mrow'] = $this->Comman_model->getCustomQueryData($msql, 'row');
        $this->load->view('mco/mcostat.php', $data);
    }

    public function mcostat2Monthly() {
        $rec_id = $_POST['rec_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $msql = "SELECT  SQL_CALC_FOUND_ROWS * FROM eclaims  WHERE  cms1500_id = '$rec_id' AND month='$month' AND year='$year'";
        $data['utotal'] = 0;
        $data['mrow'] = $this->Comman_model->getCustomQueryData($msql, 'row');
        $this->load->view('mco/mcostat2.php', $data);
    }

    function createEclaimsRecord22() {
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM eclaims WHERE qb = '' AND month = '1' AND year = '2023' AND Agency = '2' AND (eclaims.paid = 0 OR eclaims.paid = 3)";
        $mresult = $this->Comman_model->getCustomQueryData($sql);        
        foreach ($mresult as $key => $row) {
            $cms1500id = $row['cms1500_id'];
            for ($i=1;$i<=6;$i++) { 
                $from = '"24.'.$i.'.a-DOSFrom"';
                $Charges = '"24.'.$i.'.f-Charges"';
                $Units = '"24.'.$i.'.g-Units"';

                if(!empty($row[$from])) {
                    $dataArray = [];
                    $dataArray['cms1500_id'] = $cms1500id;
                    $dataArray['patient_id'] = $row['patient_id'];
                    $dataArray['Agency'] = 2;
                    $dataArray['status'] = 'Billed';
                    $dataArray['month'] = '1';
                    $dataArray['year'] = '2023';  
                    $dataArray['date'] = date('Y-m-d', strtotime($row[$from]));
                    $dataArray['bill'] = $row[$Charges];
                    $dataArray['units'] = $row[$Units];
                    //print_r($dataArray);
                    //$this->Comman_model->insert('eclaims_details', $dataArray);
                    //$this->Comman_model->insert('eclaims_details22', $dataArray);
                }                
            }
        }        
        echo "Insert successfully";
    }

    public function mcoSeparate() {
        $cmsId = $_POST['cmsId'];
        $msql = "SELECT SQL_CALC_FOUND_ROWS * FROM cms1500 WHERE cms1500_id = '$cmsId'";
        $mrow = $this->Comman_model->getCustomQueryData($msql, 'row');
        $data = '<option value="">Select</option>';
        if(!empty($mrow)) {
            if($mrow['"24.1.a-DOSFrom"']) {
                $data .= '<option val="'.$mrow['"24.1.a-DOSFrom"'].'">'.$mrow['"24.1.a-DOSFrom"'].'</option>';
            }
            if($mrow['"24.2.a-DOSFrom"']) {
                $data .= '<option val="'.$mrow['"24.2.a-DOSFrom"'].'">'.$mrow['"24.2.a-DOSFrom"'].'</option>';
            }
            if($mrow['"24.3.a-DOSFrom"']) {
                $data .= '<option val="'.$mrow['"24.3.a-DOSFrom"'].'">'.$mrow['"24.3.a-DOSFrom"'].'</option>';
            }
            if($mrow['"24.4.a-DOSFrom"']) {
                $data .= '<option val="'.$mrow['"24.4.a-DOSFrom"'].'">'.$mrow['"24.4.a-DOSFrom"'].'</option>';
            }
            if($mrow['"24.5.a-DOSFrom"']) {
                $data .= '<option val="'.$mrow['"24.5.a-DOSFrom"'].'">'.$mrow['"24.5.a-DOSFrom"'].'</option>';
            }
            if($mrow['"24.6.a-DOSFrom"']) {
                $data .= '<option val="'.$mrow['"24.6.a-DOSFrom"'].'">'.$mrow['"24.6.a-DOSFrom"'].'</option>';
            }
        }
        print_r($data);
    }


    public function mcoSeparateSubmit() {
        $cmsId = $_POST['cmsid'];
        $mcoselect = $_POST['mcoselect'];

        $msql = "SELECT SQL_CALC_FOUND_ROWS * FROM cms1500 WHERE cms1500_id = '$cmsId'";
        $mrow = $this->Comman_model->getCustomQueryData($msql, 'row');            

        if(!empty($mrow)) {
            if(!empty($mcoselect)) {
                $insert_data = "INSERT INTO `cms1500` (";
                $insert_value = ") VALUES (";
                $update_data = "UPDATE  cms1500 SET ";

                foreach ($mrow as $key => $value) {
                    if($key!='cms1500_id') {
                        if($key=='is_mco') {
                            $insert_data .= '`'.$key.'`';    
                            $insert_value .= "'".$value."'";
                        } else {
                            $insert_data .= '`'.$key.'`'.',';   
                            $insert_value .= "'".$value."'".','; 
                        }
                    }
                }

                $insert_value .= ")";
                $insert_query = $insert_data.$insert_value;

                $newCmsID = customInsertHelper($insert_query);

                $keyCOll = [];
                $totalCharges = $charges = 0;
                
                $s_24_1_a_DOSFrom = '';
                $s_24_1_a_DOSTo = '';
                $s_24_1_b_Place = '';
                $s_24_1_c_EMG = '';
                $s_24_1_d_CPT = '';
                $s_24_1_d_Modifier = '';
                $s_24_1_e_Code = '';
                $s_24_1_f_Charges = '';
                $s_24_1_g_Units = '';
                $s_24_1_h_Epsot = '';
                $s_24_1_i_Qualifier = '';
                $s_24_1_j_ProvLegacyNo = '';
                $s_24_1_j_ProvNPI = '';
                $s_24_1_S_vComment= '';

                $s_24_2_a_DOSFrom = '';
                $s_24_2_a_DOSTo = '';
                $s_24_2_b_Place = '';
                $s_24_2_c_EMG = '';
                $s_24_2_d_CPT = '';
                $s_24_2_d_Modifier = '';
                $s_24_2_e_Code = '';
                $s_24_2_f_Charges = '';
                $s_24_2_g_Units = '';
                $s_24_2_h_Epsot = '';
                $s_24_2_i_Qualifier = '';
                $s_24_2_j_ProvLegacyNo = '';
                $s_24_2_j_ProvNPI = '';
                $s_24_2_S_vComment= '';

                $s_24_3_a_DOSFrom = '';
                $s_24_3_a_DOSTo = '';
                $s_24_3_b_Place = '';
                $s_24_3_c_EMG = '';
                $s_24_3_d_CPT = '';
                $s_24_3_d_Modifier = '';
                $s_24_3_e_Code = '';
                $s_24_3_f_Charges = '';
                $s_24_3_g_Units = '';
                $s_24_3_h_Epsot = '';
                $s_24_3_i_Qualifier = '';
                $s_24_3_j_ProvLegacyNo = '';
                $s_24_3_j_ProvNPI = '';
                $s_24_3_S_vComment= '';

                $s_24_4_a_DOSFrom = '';
                $s_24_4_a_DOSTo = '';
                $s_24_4_b_Place = '';
                $s_24_4_c_EMG = '';
                $s_24_4_d_CPT = '';
                $s_24_4_d_Modifier = '';
                $s_24_4_e_Code = '';
                $s_24_4_f_Charges = '';
                $s_24_4_g_Units = '';
                $s_24_4_h_Epsot = '';
                $s_24_4_i_Qualifier = '';
                $s_24_4_j_ProvLegacyNo = '';
                $s_24_4_j_ProvNPI = '';
                $s_24_4_S_vComment= '';

                $s_24_5_a_DOSFrom = '';
                $s_24_5_a_DOSTo = '';
                $s_24_5_b_Place = '';
                $s_24_5_c_EMG = '';
                $s_24_5_d_CPT = '';
                $s_24_5_d_Modifier = '';
                $s_24_5_e_Code = '';
                $s_24_5_f_Charges = '';
                $s_24_5_g_Units = '';
                $s_24_5_h_Epsot = '';
                $s_24_5_i_Qualifier = '';
                $s_24_5_j_ProvLegacyNo = '';
                $s_24_5_j_ProvNPI = '';
                $s_24_5_S_vComment= '';

                $s_24_6_a_DOSFrom = '';
                $s_24_6_a_DOSTo = '';
                $s_24_6_b_Place = '';
                $s_24_6_c_EMG = '';
                $s_24_6_d_CPT = '';
                $s_24_6_d_Modifier = '';
                $s_24_6_e_Code = '';
                $s_24_6_f_Charges = '';
                $s_24_6_g_Units = '';
                $s_24_6_h_Epsot = '';
                $s_24_6_i_Qualifier = '';
                $s_24_6_j_ProvLegacyNo = '';
                $s_24_6_j_ProvNPI = '';
                $s_24_6_S_vComment= '';


                $o_24_1_a_DOSFrom = $mrow['"24.1.a-DOSFrom"'];
                $o_24_1_a_DOSTo = $mrow['"24.1.a-DOSTo"'];
                $o_24_1_b_Place = $mrow['"24.1.b-Place"'];
                $o_24_1_c_EMG = $mrow['"24.1.c-EMG"'];
                $o_24_1_d_CPT = $mrow['"24.1.d-CPT"'];
                $o_24_1_d_Modifier = $mrow['"24.1.d-Modifier"'];
                $o_24_1_e_Code = $mrow['"24.1.e-Code"'];
                $o_24_1_f_Charges = $mrow['"24.1.f-Charges"'];
                $o_24_1_g_Units = $mrow['"24.1.g-Units"'];
                $o_24_1_h_Epsot = $mrow['"24.1.h-Epsot"'];
                $o_24_1_i_Qualifier = $mrow['"24.1.i-Qualifier"'];
                $o_24_1_j_ProvLegacyNo = $mrow['"24.1.j-ProvLegacyNo"'];
                $o_24_1_j_ProvNPI = $mrow['"24.1.j-ProvNPI"'];
                $o_24_1_S_vComment= $mrow['"24.1.SrvComment"'];

                $o_24_2_a_DOSFrom = $mrow['"24.2.a-DOSFrom"'];
                $o_24_2_a_DOSTo = $mrow['"24.2.a-DOSTo"'];
                $o_24_2_b_Place = $mrow['"24.2.b-Place"'];
                $o_24_2_c_EMG = $mrow['"24.2.c-EMG"'];
                $o_24_2_d_CPT = $mrow['"24.2.d-CPT"'];
                $o_24_2_d_Modifier = $mrow['"24.2.d-Modifier"'];
                $o_24_2_e_Code = $mrow['"24.2.e-Code"'];
                $o_24_2_f_Charges = $mrow['"24.2.f-Charges"'];
                $o_24_2_g_Units = $mrow['"24.2.g-Units"'];
                $o_24_2_h_Epsot = $mrow['"24.2.h-Epsot"'];
                $o_24_2_i_Qualifier = $mrow['"24.2.i-Qualifier"'];
                $o_24_2_j_ProvLegacyNo = $mrow['"24.2.j-ProvLegacyNo"'];
                $o_24_2_j_ProvNPI = $mrow['"24.2.j-ProvNPI"'];
                $o_24_2_S_vComment= $mrow['"24.2.SrvComment"'];

                $o_24_3_a_DOSFrom = $mrow['"24.3.a-DOSFrom"'];
                $o_24_3_a_DOSTo = $mrow['"24.3.a-DOSTo"'];
                $o_24_3_b_Place = $mrow['"24.3.b-Place"'];
                $o_24_3_c_EMG = $mrow['"24.3.c-EMG"'];
                $o_24_3_d_CPT = $mrow['"24.3.d-CPT"'];
                $o_24_3_d_Modifier = $mrow['"24.3.d-Modifier"'];
                $o_24_3_e_Code = $mrow['"24.3.e-Code"'];
                $o_24_3_f_Charges = $mrow['"24.3.f-Charges"'];
                $o_24_3_g_Units = $mrow['"24.3.g-Units"'];
                $o_24_3_h_Epsot = $mrow['"24.3.h-Epsot"'];
                $o_24_3_i_Qualifier = $mrow['"24.3.i-Qualifier"'];
                $o_24_3_j_ProvLegacyNo = $mrow['"24.3.j-ProvLegacyNo"'];
                $o_24_3_j_ProvNPI = $mrow['"24.3.j-ProvNPI"'];
                $o_24_3_S_vComment= $mrow['"24.3.SrvComment"'];

                $o_24_4_a_DOSFrom = $mrow['"24.4.a-DOSFrom"'];
                $o_24_4_a_DOSTo = $mrow['"24.4.a-DOSTo"'];
                $o_24_4_b_Place = $mrow['"24.4.b-Place"'];
                $o_24_4_c_EMG = $mrow['"24.4.c-EMG"'];
                $o_24_4_d_CPT = $mrow['"24.4.d-CPT"'];
                $o_24_4_d_Modifier = $mrow['"24.4.d-Modifier"'];
                $o_24_4_e_Code = $mrow['"24.4.e-Code"'];
                $o_24_4_f_Charges = $mrow['"24.4.f-Charges"'];
                $o_24_4_g_Units = $mrow['"24.4.g-Units"'];
                $o_24_4_h_Epsot = $mrow['"24.4.h-Epsot"'];
                $o_24_4_i_Qualifier = $mrow['"24.4.i-Qualifier"'];
                $o_24_4_j_ProvLegacyNo = $mrow['"24.4.j-ProvLegacyNo"'];
                $o_24_4_j_ProvNPI = $mrow['"24.4.j-ProvNPI"'];
                $o_24_4_S_vComment= $mrow['"24.4.SrvComment"'];

                $o_24_5_a_DOSFrom = $mrow['"24.5.a-DOSFrom"'];
                $o_24_5_a_DOSTo = $mrow['"24.5.a-DOSTo"'];
                $o_24_5_b_Place = $mrow['"24.5.b-Place"'];
                $o_24_5_c_EMG = $mrow['"24.5.c-EMG"'];
                $o_24_5_d_CPT = $mrow['"24.5.d-CPT"'];
                $o_24_5_d_Modifier = $mrow['"24.5.d-Modifier"'];
                $o_24_5_e_Code = $mrow['"24.5.e-Code"'];
                $o_24_5_f_Charges = $mrow['"24.5.f-Charges"'];
                $o_24_5_g_Units = $mrow['"24.5.g-Units"'];
                $o_24_5_h_Epsot = $mrow['"24.5.h-Epsot"'];
                $o_24_5_i_Qualifier = $mrow['"24.5.i-Qualifier"'];
                $o_24_5_j_ProvLegacyNo = $mrow['"24.5.j-ProvLegacyNo"'];
                $o_24_5_j_ProvNPI = $mrow['"24.5.j-ProvNPI"'];
                $o_24_5_S_vComment= $mrow['"24.5.SrvComment"'];

                $o_24_6_a_DOSFrom = $mrow['"24.6.a-DOSFrom"'];
                $o_24_6_a_DOSTo = $mrow['"24.6.a-DOSTo"'];
                $o_24_6_b_Place = $mrow['"24.6.b-Place"'];
                $o_24_6_c_EMG = $mrow['"24.6.c-EMG"'];
                $o_24_6_d_CPT = $mrow['"24.6.d-CPT"'];
                $o_24_6_d_Modifier = $mrow['"24.6.d-Modifier"'];
                $o_24_6_e_Code = $mrow['"24.6.e-Code"'];
                $o_24_6_f_Charges = $mrow['"24.6.f-Charges"'];
                $o_24_6_g_Units = $mrow['"24.6.g-Units"'];
                $o_24_6_h_Epsot = $mrow['"24.6.h-Epsot"'];
                $o_24_6_i_Qualifier = $mrow['"24.6.i-Qualifier"'];
                $o_24_6_j_ProvLegacyNo = $mrow['"24.6.j-ProvLegacyNo"'];
                $o_24_6_j_ProvNPI = $mrow['"24.6.j-ProvNPI"'];
                $o_24_6_S_vComment= $mrow['"24.6.SrvComment"'];


                foreach ($mcoselect as $key1 => $DOSFrom) {
                    if($mrow['"24.1.a-DOSFrom"']==$DOSFrom) {

                        $s_24_1_a_DOSFrom = $mrow['"24.1.a-DOSFrom"'];
                        $s_24_1_a_DOSTo = $mrow['"24.1.a-DOSTo"'];
                        $s_24_1_b_Place = $mrow['"24.1.b-Place"'];
                        $s_24_1_c_EMG = $mrow['"24.1.c-EMG"'];
                        $s_24_1_d_CPT = $mrow['"24.1.d-CPT"'];
                        $s_24_1_d_Modifier = $mrow['"24.1.d-Modifier"'];
                        $s_24_1_e_Code = $mrow['"24.1.e-Code"'];
                        $s_24_1_f_Charges = $mrow['"24.1.f-Charges"'];
                        $s_24_1_g_Units = $mrow['"24.1.g-Units"'];
                        $s_24_1_h_Epsot = $mrow['"24.1.h-Epsot"'];
                        $s_24_1_i_Qualifier = $mrow['"24.1.i-Qualifier"'];
                        $s_24_1_j_ProvLegacyNo = $mrow['"24.1.j-ProvLegacyNo"'];
                        $s_24_1_j_ProvNPI = $mrow['"24.1.j-ProvNPI"'];
                        $s_24_1_S_vComment= $mrow['"24.1.SrvComment"'];

                        array_push($keyCOll, $key); 
                        $charges += (float)$mrow['"24.1.f-Charges"'];


                        /********* entry for previous record **************/
                        $o_24_1_a_DOSFrom = '';
                        $o_24_1_a_DOSTo = '';
                        $o_24_1_b_Place = '';
                        $o_24_1_c_EMG = '';
                        $o_24_1_d_CPT = '';
                        $o_24_1_d_Modifier = '';
                        $o_24_1_e_Code = '';
                        $o_24_1_f_Charges = '';
                        $o_24_1_g_Units = '';
                        $o_24_1_h_Epsot = '';
                        $o_24_1_i_Qualifier = '';
                        $o_24_1_j_ProvLegacyNo = '';
                        $o_24_1_j_ProvNPI = '';
                        $o_24_1_S_vComment= '';

                    }
                    if($mrow['"24.2.a-DOSFrom"']==$DOSFrom) {

                        $s_24_2_a_DOSFrom = $mrow['"24.2.a-DOSFrom"'];
                        $s_24_2_a_DOSTo = $mrow['"24.2.a-DOSTo"'];
                        $s_24_2_b_Place = $mrow['"24.2.b-Place"'];
                        $s_24_2_c_EMG = $mrow['"24.2.c-EMG"'];
                        $s_24_2_d_CPT = $mrow['"24.2.d-CPT"'];
                        $s_24_2_d_Modifier = $mrow['"24.2.d-Modifier"'];
                        $s_24_2_e_Code = $mrow['"24.2.e-Code"'];
                        $s_24_2_f_Charges = $mrow['"24.2.f-Charges"'];
                        $s_24_2_g_Units = $mrow['"24.2.g-Units"'];
                        $s_24_2_h_Epsot = $mrow['"24.2.h-Epsot"'];
                        $s_24_2_i_Qualifier = $mrow['"24.2.i-Qualifier"'];
                        $s_24_2_j_ProvLegacyNo = $mrow['"24.2.j-ProvLegacyNo"'];
                        $s_24_2_j_ProvNPI = $mrow['"24.2.j-ProvNPI"'];
                        $s_24_2_S_vComment= $mrow['"24.2.SrvComment"'];

                        array_push($keyCOll, $key); 
                        $charges += (float)$mrow['"24.2.f-Charges"'];

                        /********* entry for previous record **************/
                        $o_24_2_a_DOSFrom = '';
                        $o_24_2_a_DOSTo = '';
                        $o_24_2_b_Place = '';
                        $o_24_2_c_EMG = '';
                        $o_24_2_d_CPT = '';
                        $o_24_2_d_Modifier = '';
                        $o_24_2_e_Code = '';
                        $o_24_2_f_Charges = '';
                        $o_24_2_g_Units = '';
                        $o_24_2_h_Epsot = '';
                        $o_24_2_i_Qualifier = '';
                        $o_24_2_j_ProvLegacyNo = '';
                        $o_24_2_j_ProvNPI = '';
                        $o_24_2_S_vComment= '';
                    }
                    if($mrow['"24.3.a-DOSFrom"']==$DOSFrom) {

                        $s_24_3_a_DOSFrom = $mrow['"24.3.a-DOSFrom"'];
                        $s_24_3_a_DOSTo = $mrow['"24.3.a-DOSTo"'];
                        $s_24_3_b_Place = $mrow['"24.3.b-Place"'];
                        $s_24_3_c_EMG = $mrow['"24.3.c-EMG"'];
                        $s_24_3_d_CPT = $mrow['"24.3.d-CPT"'];
                        $s_24_3_d_Modifier = $mrow['"24.3.d-Modifier"'];
                        $s_24_3_e_Code = $mrow['"24.3.e-Code"'];
                        $s_24_3_f_Charges = $mrow['"24.3.f-Charges"'];
                        $s_24_3_g_Units = $mrow['"24.3.g-Units"'];
                        $s_24_3_h_Epsot = $mrow['"24.3.h-Epsot"'];
                        $s_24_3_i_Qualifier = $mrow['"24.3.i-Qualifier"'];
                        $s_24_3_j_ProvLegacyNo = $mrow['"24.3.j-ProvLegacyNo"'];
                        $s_24_3_j_ProvNPI = $mrow['"24.3.j-ProvNPI"'];
                        $s_24_3_S_vComment= $mrow['"24.3.SrvComment"'];

                        array_push($keyCOll, $key); 
                        $charges += (float)$mrow['"24.3.f-Charges"'];

                        /********* entry for previous record **************/
                        $o_24_3_a_DOSFrom = '';
                        $o_24_3_a_DOSTo = '';
                        $o_24_3_b_Place = '';
                        $o_24_3_c_EMG = '';
                        $o_24_3_d_CPT = '';
                        $o_24_3_d_Modifier = '';
                        $o_24_3_e_Code = '';
                        $o_24_3_f_Charges = '';
                        $o_24_3_g_Units = '';
                        $o_24_3_h_Epsot = '';
                        $o_24_3_i_Qualifier = '';
                        $o_24_3_j_ProvLegacyNo = '';
                        $o_24_3_j_ProvNPI = '';
                        $o_24_3_S_vComment= '';
                    }
                    if($mrow['"24.4.a-DOSFrom"']==$DOSFrom) {

                        $s_24_4_a_DOSFrom = $mrow['"24.4.a-DOSFrom"'];
                        $s_24_4_a_DOSTo = $mrow['"24.4.a-DOSTo"'];
                        $s_24_4_b_Place = $mrow['"24.4.b-Place"'];
                        $s_24_4_c_EMG = $mrow['"24.4.c-EMG"'];
                        $s_24_4_d_CPT = $mrow['"24.4.d-CPT"'];
                        $s_24_4_d_Modifier = $mrow['"24.4.d-Modifier"'];
                        $s_24_4_e_Code = $mrow['"24.4.e-Code"'];
                        $s_24_4_f_Charges = $mrow['"24.4.f-Charges"'];
                        $s_24_4_g_Units = $mrow['"24.4.g-Units"'];
                        $s_24_4_h_Epsot = $mrow['"24.4.h-Epsot"'];
                        $s_24_4_i_Qualifier = $mrow['"24.4.i-Qualifier"'];
                        $s_24_4_j_ProvLegacyNo = $mrow['"24.4.j-ProvLegacyNo"'];
                        $s_24_4_j_ProvNPI = $mrow['"24.4.j-ProvNPI"'];
                        $s_24_4_S_vComment= $mrow['"24.4.SrvComment"'];


                        array_push($keyCOll, $key); 
                        $charges += (float)$mrow['"24.4.f-Charges"'];

                        /********* entry for previous record **************/
                        $o_24_4_a_DOSFrom = '';
                        $o_24_4_a_DOSTo = '';
                        $o_24_4_b_Place = '';
                        $o_24_4_c_EMG = '';
                        $o_24_4_d_CPT = '';
                        $o_24_4_d_Modifier = '';
                        $o_24_4_e_Code = '';
                        $o_24_4_f_Charges = '';
                        $o_24_4_g_Units = '';
                        $o_24_4_h_Epsot = '';
                        $o_24_4_i_Qualifier = '';
                        $o_24_4_j_ProvLegacyNo = '';
                        $o_24_4_j_ProvNPI = '';
                        $o_24_4_S_vComment= '';
                    }
                    if($mrow['"24.5.a-DOSFrom"']==$DOSFrom) {

                        $s_24_5_a_DOSFrom = $mrow['"24.5.a-DOSFrom"'];
                        $s_24_5_a_DOSTo = $mrow['"24.5.a-DOSTo"'];
                        $s_24_5_b_Place = $mrow['"24.5.b-Place"'];
                        $s_24_5_c_EMG = $mrow['"24.5.c-EMG"'];
                        $s_24_5_d_CPT = $mrow['"24.5.d-CPT"'];
                        $s_24_5_d_Modifier = $mrow['"24.5.d-Modifier"'];
                        $s_24_5_e_Code = $mrow['"24.5.e-Code"'];
                        $s_24_5_f_Charges = $mrow['"24.5.f-Charges"'];
                        $s_24_5_g_Units = $mrow['"24.5.g-Units"'];
                        $s_24_5_h_Epsot = $mrow['"24.5.h-Epsot"'];
                        $s_24_5_i_Qualifier = $mrow['"24.5.i-Qualifier"'];
                        $s_24_5_j_ProvLegacyNo = $mrow['"24.5.j-ProvLegacyNo"'];
                        $s_24_5_j_ProvNPI = $mrow['"24.5.j-ProvNPI"'];
                        $s_24_5_S_vComment= $mrow['"24.5.SrvComment"'];

                        array_push($keyCOll, $key); 
                        $charges += (float)$mrow['"24.5.f-Charges"'];

                        $o_24_5_a_DOSFrom = '';
                        $o_24_5_a_DOSTo = '';
                        $o_24_5_b_Place = '';
                        $o_24_5_c_EMG = '';
                        $o_24_5_d_CPT = '';
                        $o_24_5_d_Modifier = '';
                        $o_24_5_e_Code = '';
                        $o_24_5_f_Charges = '';
                        $o_24_5_g_Units = '';
                        $o_24_5_h_Epsot = '';
                        $o_24_5_i_Qualifier = '';
                        $o_24_5_j_ProvLegacyNo = '';
                        $o_24_5_j_ProvNPI = '';
                        $o_24_5_S_vComment= '';
                    }
                    if($mrow['"24.6.a-DOSFrom"']==$DOSFrom) {

                        $s_24_6_a_DOSFrom = $mrow['"24.6.a-DOSFrom"'];
                        $s_24_6_a_DOSTo = $mrow['"24.6.a-DOSTo"'];
                        $s_24_6_b_Place = $mrow['"24.6.b-Place"'];
                        $s_24_6_c_EMG = $mrow['"24.6.c-EMG"'];
                        $s_24_6_d_CPT = $mrow['"24.6.d-CPT"'];
                        $s_24_6_d_Modifier = $mrow['"24.6.d-Modifier"'];
                        $s_24_6_e_Code = $mrow['"24.6.e-Code"'];
                        $s_24_6_f_Charges = $mrow['"24.6.f-Charges"'];
                        $s_24_6_g_Units = $mrow['"24.6.g-Units"'];
                        $s_24_6_h_Epsot = $mrow['"24.6.h-Epsot"'];
                        $s_24_6_i_Qualifier = $mrow['"24.6.i-Qualifier"'];
                        $s_24_6_j_ProvLegacyNo = $mrow['"24.6.j-ProvLegacyNo"'];
                        $s_24_6_j_ProvNPI = $mrow['"24.6.j-ProvNPI"'];
                        $s_24_6_S_vComment= $mrow['"24.6.SrvComment"'];

                        array_push($keyCOll, $key); 
                        $charges += (float)$mrow['"24.6.f-Charges"'];

                        $o_24_6_a_DOSFrom = '';
                        $o_24_6_a_DOSTo = '';
                        $o_24_6_b_Place = '';
                        $o_24_6_c_EMG = '';
                        $o_24_6_d_CPT = '';
                        $o_24_6_d_Modifier = '';
                        $o_24_6_e_Code = '';
                        $o_24_6_f_Charges = '';
                        $o_24_6_g_Units = '';
                        $o_24_6_h_Epsot = '';
                        $o_24_6_i_Qualifier = '';
                        $o_24_6_j_ProvLegacyNo = '';
                        $o_24_6_j_ProvNPI = '';
                        $o_24_6_S_vComment= '';
                    }
                }

                $totalChargesP = (float)$mrow['"28-TotalCharge"']-$charges;
                $totalChargesS = number_format($charges, 2);

                $update_data .= "
                                `\"24.1.a-DOSFrom\"` = '$s_24_1_a_DOSFrom',
                                `\"24.1.a-DOSTo\"` = '$s_24_1_a_DOSTo',
                                `\"24.1.b-Place\"` = '$s_24_1_b_Place',
                                `\"24.1.c-EMG\"` = '$s_24_1_c_EMG',
                                `\"24.1.d-CPT\"` = '$s_24_1_d_CPT',
                                `\"24.1.d-Modifier\"` = '$s_24_1_d_Modifier',
                                `\"24.1.e-Code\"` = '$s_24_1_e_Code',
                                `\"24.1.f-Charges\"` = '$s_24_1_f_Charges',
                                `\"24.1.g-Units\"` = '$s_24_1_g_Units',
                                `\"24.1.h-Epsot\"` = '$s_24_1_h_Epsot',
                                `\"24.1.i-Qualifier\"` = '$s_24_1_i_Qualifier',
                                `\"24.1.j-ProvLegacyNo\"` = '$s_24_1_j_ProvLegacyNo',
                                `\"24.1.j-ProvNPI\"` = '$s_24_1_j_ProvNPI',
                                `\"24.1.SrvComment\"`= '$s_24_1_SrvComment',

                                `\"24.2.a-DOSFrom\"` = '$s_24_2_a_DOSFrom',
                                `\"24.2.a-DOSTo\"` = '$s_24_2_a_DOSTo',
                                `\"24.2.b-Place\"` = '$s_24_2_b_Place',
                                `\"24.2.c-EMG\"` = '$s_24_2_c_EMG',
                                `\"24.2.d-CPT\"` = '$s_24_2_d_CPT',
                                `\"24.2.d-Modifier\"` = '$s_24_2_d_Modifier',
                                `\"24.2.e-Code\"` = '$s_24_2_e_Code',
                                `\"24.2.f-Charges\"` = '$s_24_2_f_Charges',
                                `\"24.2.g-Units\"` = '$s_24_2_g_Units',
                                `\"24.2.h-Epsot\"` = '$s_24_2_h_Epsot',
                                `\"24.2.i-Qualifier\"` = '$s_24_2_i_Qualifier',
                                `\"24.2.j-ProvLegacyNo\"` = '$s_24_2_j_ProvLegacyNo',
                                `\"24.2.j-ProvNPI\"` = '$s_24_2_j_ProvNPI',
                                `\"24.2.SrvComment\"`= '$s_24_2_SrvComment',

                                `\"24.3.a-DOSFrom\"` = '$s_24_3_a_DOSFrom',
                                `\"24.3.a-DOSTo\"` = '$s_24_3_a_DOSTo',
                                `\"24.3.b-Place\"` = '$s_24_3_b_Place',
                                `\"24.3.c-EMG\"` = '$s_24_3_c_EMG',
                                `\"24.3.d-CPT\"` = '$s_24_3_d_CPT',
                                `\"24.3.d-Modifier\"` = '$s_24_3_d_Modifier',
                                `\"24.3.e-Code\"` = '$s_24_3_e_Code',
                                `\"24.3.f-Charges\"` = '$s_24_3_f_Charges',
                                `\"24.3.g-Units\"` = '$s_24_3_g_Units',
                                `\"24.3.h-Epsot\"` = '$s_24_3_h_Epsot',
                                `\"24.3.i-Qualifier\"` = '$s_24_3_i_Qualifier',
                                `\"24.3.j-ProvLegacyNo\"` = '$s_24_3_j_ProvLegacyNo',
                                `\"24.3.j-ProvNPI\"` = '$s_24_3_j_ProvNPI',
                                `\"24.3.SrvComment\"`= '$s_24_1_SrvComment',

                                `\"24.4.a-DOSFrom\"` = '$s_24_4_a_DOSFrom',
                                `\"24.4.a-DOSTo\"` = '$s_24_4_a_DOSTo',
                                `\"24.4.b-Place\"` = '$s_24_4_b_Place',
                                `\"24.4.c-EMG\"` = '$s_24_4_c_EMG',
                                `\"24.4.d-CPT\"` = '$s_24_4_d_CPT',
                                `\"24.4.d-Modifier\"` = '$s_24_4_d_Modifier',
                                `\"24.4.e-Code\"` = '$s_24_4_e_Code',
                                `\"24.4.f-Charges\"` = '$s_24_4_f_Charges',
                                `\"24.4.g-Units\"` = '$s_24_4_g_Units',
                                `\"24.4.h-Epsot\"` = '$s_24_4_h_Epsot',
                                `\"24.4.i-Qualifier\"` = '$s_24_4_i_Qualifier',
                                `\"24.4.j-ProvLegacyNo\"` = '$s_24_4_j_ProvLegacyNo',
                                `\"24.4.j-ProvNPI\"` = '$s_24_4_j_ProvNPI',
                                `\"24.4.SrvComment\"`= '$s_24_4_SrvComment',

                                `\"24.5.a-DOSFrom\"` = '$s_24_5_a_DOSFrom',
                                `\"24.5.a-DOSTo\"` = '$s_24_5_a_DOSTo',
                                `\"24.5.b-Place\"` = '$s_24_5_b_Place',
                                `\"24.5.c-EMG\"` = '$s_24_5_c_EMG',
                                `\"24.5.d-CPT\"` = '$s_24_5_d_CPT',
                                `\"24.5.d-Modifier\"` = '$s_24_5_d_Modifier',
                                `\"24.5.e-Code\"` = '$s_24_5_e_Code',
                                `\"24.5.f-Charges\"` = '$s_24_5_f_Charges',
                                `\"24.5.g-Units\"` = '$s_24_5_g_Units',
                                `\"24.5.h-Epsot\"` = '$s_24_5_h_Epsot',
                                `\"24.5.i-Qualifier\"` = '$s_24_5_i_Qualifier',
                                `\"24.5.j-ProvLegacyNo\"` = '$s_24_5_j_ProvLegacyNo',
                                `\"24.5.j-ProvNPI\"` = '$s_24_5_j_ProvNPI',
                                `\"24.5.SrvComment\"`= '$s_24_5_SrvComment',

                                `\"24.6.a-DOSFrom\"` = '$s_24_6_a_DOSFrom',
                                `\"24.6.a-DOSTo\"` = '$s_24_6_a_DOSTo',
                                `\"24.6.b-Place\"` = '$s_24_6_b_Place',
                                `\"24.6.c-EMG\"` = '$s_24_6_c_EMG',
                                `\"24.6.d-CPT\"` = '$s_24_6_d_CPT',
                                `\"24.6.d-Modifier\"` = '$s_24_6_d_Modifier',
                                `\"24.6.e-Code\"` = '$s_24_6_e_Code',
                                `\"24.6.f-Charges\"` = '$s_24_6_f_Charges',
                                `\"24.6.g-Units\"` = '$s_24_6_g_Units',
                                `\"24.6.h-Epsot\"` = '$s_24_6_h_Epsot',
                                `\"24.6.i-Qualifier\"` = '$s_24_6_i_Qualifier',
                                `\"24.6.j-ProvLegacyNo\"` = '$s_24_6_j_ProvLegacyNo',
                                `\"24.6.j-ProvNPI\"` = '$s_24_6_j_ProvNPI',
                                `\"24.6.SrvComment\"`= '$s_24_6_SrvComment',

                                `\"28-TotalCharge\"` = $totalChargesS, ";
                $update_data = substr(trim($update_data), 0, -1);
                $update_data .= " WHERE cms1500_id = '$newCmsID'"; 
                set_custom_query_data($update_data);

                $update_data = "UPDATE  cms1500 SET ";
                $update_data .= "
                                `\"24.1.a-DOSFrom\"` = '$o_24_1_a_DOSFrom',
                                `\"24.1.a-DOSTo\"` = '$o_24_1_a_DOSTo',
                                `\"24.1.b-Place\"` = '$o_24_1_b_Place',
                                `\"24.1.c-EMG\"` = '$o_24_1_c_EMG',
                                `\"24.1.d-CPT\"` = '$o_24_1_d_CPT',
                                `\"24.1.d-Modifier\"` = '$o_24_1_d_Modifier',
                                `\"24.1.e-Code\"` = '$o_24_1_e_Code',
                                `\"24.1.f-Charges\"` = '$o_24_1_f_Charges',
                                `\"24.1.g-Units\"` = '$o_24_1_g_Units',
                                `\"24.1.h-Epsot\"` = '$o_24_1_h_Epsot',
                                `\"24.1.i-Qualifier\"` = '$o_24_1_i_Qualifier',
                                `\"24.1.j-ProvLegacyNo\"` = '$o_24_1_j_ProvLegacyNo',
                                `\"24.1.j-ProvNPI\"` = '$o_24_1_j_ProvNPI',
                                `\"24.1.SrvComment\"`= '$o_24_1_SrvComment',

                                `\"24.2.a-DOSFrom\"` = '$o_24_2_a_DOSFrom',
                                `\"24.2.a-DOSTo\"` = '$o_24_2_a_DOSTo',
                                `\"24.2.b-Place\"` = '$o_24_2_b_Place',
                                `\"24.2.c-EMG\"` = '$o_24_2_c_EMG',
                                `\"24.2.d-CPT\"` = '$o_24_2_d_CPT',
                                `\"24.2.d-Modifier\"` = '$o_24_2_d_Modifier',
                                `\"24.2.e-Code\"` = '$o_24_2_e_Code',
                                `\"24.2.f-Charges\"` = '$o_24_2_f_Charges',
                                `\"24.2.g-Units\"` = '$o_24_2_g_Units',
                                `\"24.2.h-Epsot\"` = '$o_24_2_h_Epsot',
                                `\"24.2.i-Qualifier\"` = '$o_24_2_i_Qualifier',
                                `\"24.2.j-ProvLegacyNo\"` = '$o_24_2_j_ProvLegacyNo',
                                `\"24.2.j-ProvNPI\"` = '$o_24_2_j_ProvNPI',
                                `\"24.2.SrvComment\"`= '$o_24_2_SrvComment',

                                `\"24.3.a-DOSFrom\"` = '$o_24_3_a_DOSFrom',
                                `\"24.3.a-DOSTo\"` = '$o_24_3_a_DOSTo',
                                `\"24.3.b-Place\"` = '$o_24_3_b_Place',
                                `\"24.3.c-EMG\"` = '$o_24_3_c_EMG',
                                `\"24.3.d-CPT\"` = '$o_24_3_d_CPT',
                                `\"24.3.d-Modifier\"` = '$o_24_3_d_Modifier',
                                `\"24.3.e-Code\"` = '$o_24_3_e_Code',
                                `\"24.3.f-Charges\"` = '$o_24_3_f_Charges',
                                `\"24.3.g-Units\"` = '$o_24_3_g_Units',
                                `\"24.3.h-Epsot\"` = '$o_24_3_h_Epsot',
                                `\"24.3.i-Qualifier\"` = '$o_24_3_i_Qualifier',
                                `\"24.3.j-ProvLegacyNo\"` = '$o_24_3_j_ProvLegacyNo',
                                `\"24.3.j-ProvNPI\"` = '$o_24_3_j_ProvNPI',
                                `\"24.3.SrvComment\"`= '$o_24_1_SrvComment',

                                `\"24.4.a-DOSFrom\"` = '$o_24_4_a_DOSFrom',
                                `\"24.4.a-DOSTo\"` = '$o_24_4_a_DOSTo',
                                `\"24.4.b-Place\"` = '$o_24_4_b_Place',
                                `\"24.4.c-EMG\"` = '$o_24_4_c_EMG',
                                `\"24.4.d-CPT\"` = '$o_24_4_d_CPT',
                                `\"24.4.d-Modifier\"` = '$o_24_4_d_Modifier',
                                `\"24.4.e-Code\"` = '$o_24_4_e_Code',
                                `\"24.4.f-Charges\"` = '$o_24_4_f_Charges',
                                `\"24.4.g-Units\"` = '$o_24_4_g_Units',
                                `\"24.4.h-Epsot\"` = '$o_24_4_h_Epsot',
                                `\"24.4.i-Qualifier\"` = '$o_24_4_i_Qualifier',
                                `\"24.4.j-ProvLegacyNo\"` = '$o_24_4_j_ProvLegacyNo',
                                `\"24.4.j-ProvNPI\"` = '$o_24_4_j_ProvNPI',
                                `\"24.4.SrvComment\"`= '$o_24_4_SrvComment',

                                `\"24.5.a-DOSFrom\"` = '$o_24_5_a_DOSFrom',
                                `\"24.5.a-DOSTo\"` = '$o_24_5_a_DOSTo',
                                `\"24.5.b-Place\"` = '$o_24_5_b_Place',
                                `\"24.5.c-EMG\"` = '$o_24_5_c_EMG',
                                `\"24.5.d-CPT\"` = '$o_24_5_d_CPT',
                                `\"24.5.d-Modifier\"` = '$o_24_5_d_Modifier',
                                `\"24.5.e-Code\"` = '$o_24_5_e_Code',
                                `\"24.5.f-Charges\"` = '$o_24_5_f_Charges',
                                `\"24.5.g-Units\"` = '$o_24_5_g_Units',
                                `\"24.5.h-Epsot\"` = '$o_24_5_h_Epsot',
                                `\"24.5.i-Qualifier\"` = '$o_24_5_i_Qualifier',
                                `\"24.5.j-ProvLegacyNo\"` = '$o_24_5_j_ProvLegacyNo',
                                `\"24.5.j-ProvNPI\"` = '$o_24_5_j_ProvNPI',
                                `\"24.5.SrvComment\"`= '$o_24_5_SrvComment',

                                `\"24.6.a-DOSFrom\"` = '$o_24_6_a_DOSFrom',
                                `\"24.6.a-DOSTo\"` = '$o_24_6_a_DOSTo',
                                `\"24.6.b-Place\"` = '$o_24_6_b_Place',
                                `\"24.6.c-EMG\"` = '$o_24_6_c_EMG',
                                `\"24.6.d-CPT\"` = '$o_24_6_d_CPT',
                                `\"24.6.d-Modifier\"` = '$o_24_6_d_Modifier',
                                `\"24.6.e-Code\"` = '$o_24_6_e_Code',
                                `\"24.6.f-Charges\"` = '$o_24_6_f_Charges',
                                `\"24.6.g-Units\"` = '$o_24_6_g_Units',
                                `\"24.6.h-Epsot\"` = '$o_24_6_h_Epsot',
                                `\"24.6.i-Qualifier\"` = '$o_24_6_i_Qualifier',
                                `\"24.6.j-ProvLegacyNo\"` = '$o_24_6_j_ProvLegacyNo',
                                `\"24.6.j-ProvNPI\"` = '$o_24_6_j_ProvNPI',
                                `\"24.6.SrvComment\"`= '$o_24_6_SrvComment',

                                `\"28-TotalCharge\"` = $totalChargesP, ";
                $update_data = substr(trim($update_data), 0, -1);
                $update_data .= " WHERE cms1500_id = '$cmsId'"; 
                set_custom_query_data($update_data); 
            }            
        }

        $DistrictID_Ref2 = $_POST['DistrictID_Ref2'];
        $search = $_POST['search'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $viewmode = $_POST['viewmode'];
        $startdate = $_POST['startdate'];

        redirect('dashboardd/splitMco1500?DistrictID_Ref2='.$DistrictID_Ref2.'&search='.$search.'&month='.$month.'&year='.$year.'&viewmode='.$viewmode.'&startdate='.$startdate);
    }


    public function exceltime17b1() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/exceltime17b1.php', $data);
        } else {
            redirect();
        }  
    }

    public function exceltime17b1Monthly() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/exceltime17b1Monthly.php', $data);
        } else {
            redirect();
        }    
    }

    public function exceltime17b1MonthlyLTS() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/exceltime17b1MonthlyLTS.php', $data);
        } else {
            redirect();
        }    
    }

    public function exceltime17b1LTS() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/exceltime17b1LTS.php', $data);
        } else {
            redirect();
        }  
    }

    public function exceltime19() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/exceltime19.php', $data);
        } else {
            redirect();
        }    
    }

    public function exceltime17e() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/exceltime17e.php', $data);
        } else {
            redirect();
        }    
    }

    public function mcoviewerltsnew() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/mcoviewerltsnew.php', $data);
        } else {
            redirect();
        }    
    }

    public function mcoviewerltsnewHM() {
        if(isset($_SESSION['name'])) {
            $data = [];
            $this->load->view('mco/mcoviewerltsnewHM.php', $data);
        } else {
            redirect();
        }    
    }

    public function savefile() {
        if(isset($_SESSION['name'])) {
            $filename = $_GET['filename'];
            echo $filename;

            $myfile = fopen($filename, "r") or die("Unable to open file!");
            // Output one line until end-of-file
            $ctr = 0;
            while(!feof($myfile)) {
                $ctr++;
                $x = fgets($myfile);
            }
            fclose($myfile);

            if ($ctr > 1 ) {
                header("Pragma: public");
                header("Content-Description: File Transfer");
                header('Cache-Control: must-revalidate');
                header("Content-Length: ". filesize("$filename").";");
                //header("Content-Length: 100000; ");
                header("Content-Disposition: attachment; filename=".basename($filename)."");
                //header("Content-Type: application/octet-stream; "); 
                header("Content-Transfer-Encoding: binary");
                header("Content-Type: plain/text; "); 
                ob_clean();   // discard any data in the output buffer (if possible)
                flush();      // flush headers (if possible)
                readfile($filename);
                unlink($filename);
            }
            echo  "<script type='text/javascript'>";
            //echo "window.close();";
            echo "</script>";

        } else {
            redirect();
        }
    }


    public function excelView() {
        if(isset($_SESSION['name'])) {
            $MySQL = $_SESSION["MAINSQL"];
            echo "SQL".$MySQL;

            // file name for download
            $filename = "EXCEL_" . date('Ymd') . ".xls";

            header("Content-Disposition: attachment; filename=\"$filename\"");
            header("Content-Type: application/vnd.ms-excel");

            $flag = false;
            $row2 = 0;
            $arry = array(' ',' ',' ',' ');
            //$result = mysql_query("SELECT * FROM temp_trans") or die('Query failed!');
            $result = $this->Comman_model->getCustomQueryData($MySQL);
            foreach ($result as $key => $row) {
                $rec_id = $row['cms1500_id'];
                if ($_SESSION['rxx'] [$rec_id]  == 'Yes')  {
                    //echo $row["cms1500_id"];
                    if(!$flag) {
                        // display field/column names as first row
                        array_walk($row, 'cleanData');
                        echo implode("\t",$arry) . "\r\n";
                        echo implode("\t", array_keys($row)) . "\r\n";
                        $flag = true;
                    }
                    array_walk($row, 'cleanData');
                    $x = 1;
                    echo implode("\t", array_values($row)) . "\r\n";
                }
            }     

        } else {
            redirect();
        }
    }



    public function addclassRefid() {
        $agency = $this->session->userdata('agency');

        $where = [];
        $where['Agency'] = $agency;
        //$where['IsActive'] = 1;
        $patientData = $this->Comman_model->get_rows('patient', $where);

        foreach ($patientData as $key => $row) {
            $patient_agency_location = $row['agency_location'];

            $where = [];
            $where['agency_location_code'] = $patient_agency_location;

            if($agency==3) {
                $QBData = $this->Comman_model->get_row('qb_class_cg', $where);
            } else if($agency==1) {
                $QBData = $this->Comman_model->get_row('qb_class_hm', $where);
            } else {
                $QBData = $this->Comman_model->get_row('qb_class_sc', $where);
            }


            $ClassRef_ListID = $QBData['ClassRef_ListID'];
            $ClassRef_FullName = $QBData['ClassRef_FullName'];
            //$med_medicaidno = $row['med_medicaidno'];
            if(($agency==1 || $agency==3) && $row['mco']==1) {
                $CustomField1 = $row['med_medicaidno'];
            } else {
                $CustomField1 = $row['CustomFieldCaseNumber'];    
            }

            $query = "UPDATE invoice SET ClassRef_ListID = '$ClassRef_ListID', ClassRef_FullName = '$ClassRef_FullName' WHERE CustomField1 = '$CustomField1' "; 
            //echo $query;    
            if($agency==3) {
                get_data_other_db($query, 'query', 'caregiver');    
            } else if($agency==1) {
                get_data_other_db($query, 'query', 'homemaker');    
            } else {
                get_data_other_db($query, 'query');    
            }  
            
            //die;
        }
        $this->session->set_flashdata('message','Invoice Table Has Been Updated Successfully.');
        redirect($this->agent->referrer());
    }  


    public function addclassRefidIDOA() {
        $agency = $this->session->userdata('agency');

        $where = [];
        $where['Agency'] = $agency;
        //$where['IsActive'] = 1;
        $patientData = $this->Comman_model->get_rows('patient', $where);

        foreach ($patientData as $key => $row) {
            $patient_agency_location = $row['agency_location'];

            $where = [];
            $where['agency_location_code'] = $patient_agency_location;

            if($agency==3) {
                $QBData = $this->Comman_model->get_row('qb_class_cg', $where);
            } else if($agency==1) {
                $QBData = $this->Comman_model->get_row('qb_class_hm', $where);
            } else {
                $QBData = $this->Comman_model->get_row('qb_class_sc', $where);
            }

            $ClassRef_ListID = $QBData['ClassRef_ListID'];
            $ClassRef_FullName = $QBData['ClassRef_FullName'];


            if(($agency==2 || $agency==4) && $row['mco']==1) {
                $CustomField1 = $row['med_medicaidno'];
            } else {
                $CustomField1 = $row['patient_id'];    
            }

            //$patient_id = $row['patient_id'];

            $query = "UPDATE invoice SET ClassRef_ListID = '$ClassRef_ListID', ClassRef_FullName = '$ClassRef_FullName' WHERE CustomField1 = '$CustomField1' "; 
            //echo $query;            
            if($agency==3) {
                get_data_other_db($query, 'query', 'caregiver');    
            } else if($agency==1) {
                get_data_other_db($query, 'query', 'homemaker');    
            } else {
                get_data_other_db($query, 'query');    
            }
        }
        $this->session->set_flashdata('message','Invoice Table Has Been Updated Successfully.');
        redirect($this->agent->referrer());
    } 

    public function invoice() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $where = [];
            $where['Agency'] = $agency_code;
            //$where['IsActive'] = 1;
            $patientData = $this->Comman_model->get_rows('patient', $where);

            $invoiceData = [];

            $invoiceBalance = 0;

            foreach ($patientData as $key => $row) {
                if(($agency_code==1 || $agency_code==3) && $row['mco']==1) {
                    $CustomField1 = $row['med_medicaidno'];
                    $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining FROM invoice WHERE CustomField1 = '$CustomField1'";

                    if($agency_code==3) {
                        $invoiceRow = get_data_other_db($query, 'row', 'caregiver'); 
                    } else if($agency_code==1) {
                        $invoiceRow = get_data_other_db($query, 'row', 'homemaker'); 
                    } else {
                        $invoiceRow = get_data_other_db($query, 'row');
                    }

                    if(!empty($invoiceRow)) {
                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }                    
                } else {
                    $CustomField1 = $row['CustomFieldCaseNumber'];
                    $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining FROM invoice WHERE CustomField1 = '$CustomField1'";

                    if($agency_code==3) {
                        $invoiceRow = get_data_other_db($query, 'row', 'caregiver'); 
                    } else if($agency_code==1) {
                        $invoiceRow = get_data_other_db($query, 'row', 'homemaker'); 
                    } else {
                        $invoiceRow = get_data_other_db($query, 'row');
                    }

                    if(!empty($invoiceRow)) {
                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }
            }

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function invoiceDHS() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if(!empty($_GET['formSubmit']) && $_GET['formSubmit']=='Update TxnDate' && !empty($_GET['txnID'])) {
                $txnDate = $_GET['txnDate'];
                $txnID = $_GET['txnID'];
                $ItemRef_ListID = $_GET['itemreflistid'];

                $query1 = "UPDATE invoice SET TxnDate='$txnDate'";
                get_custom_query_data_other_db($query1, 'query', $agency_code); 

                if(!empty($ItemRef_ListID)) {
                    $query1 = "UPDATE invoicelinedetail SET ItemRef_ListID='$ItemRef_ListID'";
                    get_custom_query_data_other_db($query1, 'query', $agency_code);
                }

                $this->session->set_flashdata('message','Records Has Been Updated Successfully.');
            }
            
            $where = [];
            $where['Agency'] = $agency_code;
            $where['CustomFieldCaseNumber!='] = 'NA'; 
            $where['CustomFieldCaseNumber!='] = ''; 
            //$where['patient_id'] = '10291';
            //$where['IsActive'] = 1;
            $patientData = $this->Comman_model->get_rows('patient', $where);

            $invoiceData = [];

            $invoiceBalance = 0;

            foreach ($patientData as $key => $row) {
                if(($agency_code==1 || $agency_code==3)) {
                    $CustomField1 = $row['CustomFieldCaseNumber'];
                    $query = "SELECT TxnID, CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, CustomerRef_ListID, Status FROM invoice WHERE CustomField1 = '$CustomField1' AND CustomField1!='NA' AND CustomField1!='' AND CustomField1!='N/A'";

                    if($agency_code==3) {
                        $invoiceRow = get_data_other_db($query, 'row', 'caregiver'); 
                    } else if($agency_code==1) {
                        $invoiceRow = get_data_other_db($query, 'row', 'homemaker'); 
                    } else {
                        $invoiceRow = get_data_other_db($query, 'row');
                    }

                    if(!empty($invoiceRow)) {
                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];
                        $invoiceData[$key]['CustomField1'] = $invoiceRow['CustomField1'];
                        $invoiceData[$key]['CustomerRef_ListID'] = $invoiceRow['CustomerRef_ListID'];
                        $invoiceData[$key]['Status'] = $invoiceRow['Status'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }                    
                } else {
                    $CustomField1 = $row['CustomFieldCaseNumber'];
                    $query = "SELECT TxnID, CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, CustomerRef_ListID, Status FROM invoice WHERE CustomField1 = '$CustomField1'";

                    if($agency_code==3) {
                        $invoiceRow = get_data_other_db($query, 'row', 'caregiver'); 
                    } else if($agency_code==1) {
                        $invoiceRow = get_data_other_db($query, 'row', 'homemaker'); 
                    } else {
                        $invoiceRow = get_data_other_db($query, 'row');
                    }

                    if(!empty($invoiceRow)) {
                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['CustomerRef_ListID'] = $invoiceRow['CustomerRef_ListID'];
                        $invoiceData[$key]['Status'] = $invoiceRow['Status'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }
            }

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('dhs/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function invoiceDHSNew() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $invoiceData = [];
            $invoiceBalance = 0;
            if($agency_code==1 || $agency_code==3) {
                //$CustomField1 = $row['CustomFieldCaseNumber'];
                //$query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, CustomerRef_ListID, Status FROM invoice WHERE CustomField1 = '$CustomField1' AND CustomField1!='NA' AND CustomField1!='' AND CustomField1!='N/A'";

                $query = "SELECT TxnID, CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, CustomerRef_ListID, Status FROM invoice";

                if($agency_code==3) {
                    $invoiceResult = get_data_other_db($query, 'result', 'caregiver'); 
                } else if($agency_code==1) {
                    $invoiceResult = get_data_other_db($query, 'result', 'homemaker'); 
                } else {
                    $invoiceResult = get_data_other_db($query, 'result');
                }

                if(!empty($invoiceResult)) {
                    foreach ($invoiceResult as $key => $invoiceRow) {
                        // code...
                        $query = "SELECT name FROM patient WHERE CustomFieldCaseNumber LIKE '%".$invoiceRow['CustomField1']."%'";
                        $row = $this->Comman_model->getCustomQueryData($query, 'row');

                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];
                        $invoiceData[$key]['CustomField1'] = $invoiceRow['CustomField1'];
                        $invoiceData[$key]['CustomerRef_ListID'] = $invoiceRow['CustomerRef_ListID'];
                        $invoiceData[$key]['Status'] = $invoiceRow['Status'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }                    
            } else {
                //$CustomField1 = $row['CustomFieldCaseNumber'];
                $query = "SELECT TxnID, CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, CustomerRef_ListID, Status FROM invoice";

                if($agency_code==3) {
                    $invoiceResult = get_data_other_db($query, 'result', 'caregiver'); 
                } else if($agency_code==1) {
                    $invoiceResult = get_data_other_db($query, 'result', 'homemaker'); 
                } else {
                    $invoiceResult = get_data_other_db($query, 'result');
                }

                if(!empty($invoiceResult)) {
                    foreach ($invoiceResult as $key => $invoiceRow) {

                        $query = "SELECT name FROM patient WHERE CustomFieldCaseNumber LIKE '%".$invoiceRow['CustomField1']."%'";
                        $row = $this->Comman_model->getCustomQueryData($query, 'row');

                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['CustomerRef_ListID'] = $invoiceRow['CustomerRef_ListID'];
                        $invoiceData[$key]['Status'] = $invoiceRow['Status'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }
            }

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('dhs/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function invoiceIDOANEW() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if(!empty($_GET['formSubmit']) && $_GET['formSubmit']=='Update TxnDate' && !empty($_GET['txnID'])) {
                $txnDate = $_GET['txnDate'];
                $txnID = $_GET['txnID'];
                $ItemRef_ListID = $_GET['itemreflistid'];

                $query1 = "UPDATE invoice SET TxnDate='$txnDate'";
                get_custom_query_data_other_db($query1, 'query', $agency_code); 

                if(!empty($ItemRef_ListID)) {
                    $query1 = "UPDATE invoicelinedetail SET ItemRef_ListID='$ItemRef_ListID'";
                    get_custom_query_data_other_db($query1, 'query', $agency_code);
                }

                $this->session->set_flashdata('message','Records Has Been Updated Successfully.');
            }
            
            $invoiceData = [];
            $invoiceBalance = 0;

            if(($agency_code==2 || $agency_code==4)) {
                //$CustomField1 = trim($row['med_medicaidno']);
                $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, TxnID FROM invoice";
                if($agency_code==3) {
                    $invoiceResult = get_data_other_db($query, 'result', 'caregiver'); 
                } else if($agency_code==1) {
                    $invoiceResult = get_data_other_db($query, 'result', 'homemaker'); 
                } else {
                    $invoiceResult = get_data_other_db($query, 'result');
                }

                if(!empty($invoiceResult)) {
                    foreach ($invoiceResult as $key => $invoiceRow) {
                        // code...
                        $CustomField1 = trim($invoiceRow['CustomField1']);
                        $query = "SELECT name FROM patient WHERE med_medicaidno LIKE '%".$CustomField1."%'";
                        $row = $this->Comman_model->getCustomQueryData($query, 'row');

                        //$IDKEY = $row['TxnID'];
                        $IDKEY = $invoiceRow['TxnID'];

                        $query = "SELECT ItemRef_ListID FROM invoicelinedetail WHERE IDKEY LIKE '%".$IDKEY."%'";
                        $invoiceLineRow = get_data_other_db($query, 'row');

                        $query = "SELECT * FROM items WHERE ListID LIKE '%".$invoiceLineRow['ItemRef_ListID']."%'";
                        $itemRow = get_data_other_db($query, 'row');

                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];
                        $invoiceData[$key]['ItemRef_ListID'] = $invoiceLineRow['ItemRef_ListID'];
                        $invoiceData[$key]['ItemRef_ListName'] = $itemRow['FullName'];

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }                    
            } else {
                //$CustomField1 = $row['patient_id'];
                //$CustomField1 = trim($row['med_medicaidno']);
                $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, TxnID FROM invoice";

                if($agency_code==3) {
                    $invoiceResult = get_data_other_db($query, 'result', 'caregiver'); 
                } else if($agency_code==1) {
                    $invoiceResult = get_data_other_db($query, 'result', 'homemaker'); 
                } else {
                    $invoiceResult = get_data_other_db($query, 'result');
                }

                if(!empty($invoiceResult)) {
                    foreach ($invoiceResult as $key => $invoiceRow) {

                        //echo $IDKEY = $row['TxnID'];die;
                        $IDKEY = $invoiceRow['TxnID'];

                        $CustomField1 = trim($invoiceRow['CustomField1']);
                        $query = "SELECT name FROM patient WHERE med_medicaidno LIKE '%".$CustomField1."%'";
                        $row = $this->Comman_model->getCustomQueryData($query, 'row');

                        $query = "SELECT ItemRef_ListID FROM invoicelinedetail WHERE IDKEY LIKE '%".$IDKEY."%'";
                        if($agency_code==1) {
                            $invoiceLineRow = get_data_other_db($query, 'row', 'homemaker');
                        }
                        if($agency_code==3) {
                            $invoiceLineRow = get_data_other_db($query, 'row', 'caregiver');
                        }

                        $query = "SELECT * FROM items WHERE ListID LIKE '%".$invoiceLineRow['ItemRef_ListID']."%'";
                        if($agency_code==1) {
                            $itemRow = get_data_other_db($query, 'row', 'homemaker');
                        }
                        if($agency_code==3) {
                            $itemRow = get_data_other_db($query, 'row', 'caregiver');
                        }

                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];   
                        $invoiceData[$key]['ItemRef_ListID'] = $invoiceLineRow['ItemRef_ListID']; 
                        $invoiceData[$key]['ItemRef_ListName'] = $itemRow['FullName'];

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }
            }

            if($agency_code==1) {
                $query = "SELECT * FROM items";
                $itemResult = get_data_other_db($query, 'result', 'homemaker');
            }

            if($agency_code==3) {
                $query = "SELECT * FROM items";
                $itemResult = get_data_other_db($query, 'result', 'caregiver');
            }

            if($agency_code==2 || $agency_code==4) {
                $query = "SELECT * FROM items";
                $itemResult = get_data_other_db($query, 'result', 'seniorcare');
            }            

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;
            $data['itemResult'] = $itemResult;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function invoiceIDOA() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');

            if(!empty($_GET['formSubmit']) && $_GET['formSubmit']=='Update TxnDate' && !empty($_GET['txnID'])) {
                $txnDate = $_GET['txnDate'];
                $txnID = $_GET['txnID'];
                $ItemRef_ListID = $_GET['itemreflistid'];

                $query1 = "UPDATE invoice SET TxnDate='$txnDate'";
                get_custom_query_data_other_db($query1, 'query', $agency_code); 

                if(!empty($ItemRef_ListID)) {
                    $query1 = "UPDATE invoicelinedetail SET ItemRef_ListID='$ItemRef_ListID'";
                    get_custom_query_data_other_db($query1, 'query', $agency_code);
                }

                $this->session->set_flashdata('message','Records Has Been Updated Successfully.');
            }


            $where = [];
            $where['Agency'] = $agency_code;
            //$where['IsActive'] = 1;
            $patientData = $this->Comman_model->get_rows('patient', $where);

            $invoiceData = [];
            $invoiceBalance = 0;

            foreach ($patientData as $key => $row) {
                if(($agency_code==2 || $agency_code==4) && $row['mco']==1) {
                    $CustomField1 = trim($row['med_medicaidno']);
                    $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, TxnID, CustomerRef_ListID, Status FROM invoice WHERE CustomField1 = '$CustomField1'";

                    if($agency_code==3) {
                        $invoiceRow = get_data_other_db($query, 'row', 'caregiver'); 
                    } else if($agency_code==1) {
                        $invoiceRow = get_data_other_db($query, 'row', 'homemaker'); 
                    } else {
                        $invoiceRow = get_data_other_db($query, 'row');
                    }

                    if(!empty($invoiceRow)) {

                        //$IDKEY = $row['TxnID'];
                        $IDKEY = $invoiceRow['TxnID'];

                        $query = "SELECT ItemRef_ListID FROM invoicelinedetail WHERE IDKEY LIKE '%".$IDKEY."%'";
                        $invoiceLineRow = get_data_other_db($query, 'row');

                        $query = "SELECT * FROM items WHERE ListID LIKE '%".$invoiceLineRow['ItemRef_ListID']."%'";
                        $itemRow = get_data_other_db($query, 'row');

                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['CustomerRef_ListID'] = $invoiceRow['CustomerRef_ListID'];
                        $invoiceData[$key]['Status'] = $invoiceRow['Status'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];
                        $invoiceData[$key]['ItemRef_ListID'] = $invoiceLineRow['ItemRef_ListID'];
                        $invoiceData[$key]['ItemRef_ListName'] = $itemRow['FullName'];

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];

                    }                    
                } else {
                    //$CustomField1 = $row['patient_id'];
                    $CustomField1 = trim($row['med_medicaidno']);
                    $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, TxnID, CustomerRef_ListID, Status FROM invoice WHERE CustomField1 = '$CustomField1'";

                    if($agency_code==3) {
                        $invoiceRow = get_data_other_db($query, 'row', 'caregiver'); 
                    } else if($agency_code==1) {
                        $invoiceRow = get_data_other_db($query, 'row', 'homemaker'); 
                    } else {
                        $invoiceRow = get_data_other_db($query, 'row');
                    }

                    if(!empty($invoiceRow)) {

                        //echo $IDKEY = $row['TxnID'];die;
                        $IDKEY = $invoiceRow['TxnID'];

                        $query = "SELECT ItemRef_ListID FROM invoicelinedetail WHERE IDKEY LIKE '%".$IDKEY."%'";
                        if($agency_code==1) {
                            $invoiceLineRow = get_data_other_db($query, 'row', 'homemaker');
                        }
                        if($agency_code==3) {
                            $invoiceLineRow = get_data_other_db($query, 'row', 'caregiver');
                        }

                        $query = "SELECT * FROM items WHERE ListID LIKE '%".$invoiceLineRow['ItemRef_ListID']."%'";
                        if($agency_code==1) {
                            $itemRow = get_data_other_db($query, 'row', 'homemaker');
                        }
                        if($agency_code==3) {
                            $itemRow = get_data_other_db($query, 'row', 'caregiver');
                        }

                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['CustomerRef_ListID'] = $invoiceRow['CustomerRef_ListID'];
                        $invoiceData[$key]['Status'] = $invoiceRow['Status'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];
                        $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];   
                        $invoiceData[$key]['ItemRef_ListID'] = $invoiceLineRow['ItemRef_ListID']; 
                        $invoiceData[$key]['ItemRef_ListName'] = $itemRow['FullName'];

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }
            }

            if($agency_code==1) {
                $query = "SELECT * FROM items";
                $itemResult = get_data_other_db($query, 'result', 'homemaker');
            }

            if($agency_code==3) {
                $query = "SELECT * FROM items";
                $itemResult = get_data_other_db($query, 'result', 'caregiver');
            }

            if($agency_code==2 || $agency_code==4) {
                $query = "SELECT * FROM items";
                $itemResult = get_data_other_db($query, 'result', 'seniorcare');
            }            

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;
            $data['itemResult'] = $itemResult;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function invoiceIDOA2Old() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $where = [];
            $where['Agency'] = $agency_code;
            //$where['IsActive'] = 1;
            $patientData = $this->Comman_model->get_rows('patient', $where);

            $invoiceData = [];
            $invoiceBalance = 0;

            foreach ($patientData as $key => $row) {
                if(($agency_code==2 || $agency_code==4)) {
                    $CustomerRef_ListID = $row['CustomerRef_ListID'];
                    //$query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining FROM invoice WHERE CustomerRef_ListID = '$CustomerRef_ListID'";

                    $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining FROM invoice WHERE CustomerRef_ListID = '$CustomerRef_ListID'";

                    $invoiceRow = get_data_other_db($query, 'row');

                    if(!empty($invoiceRow)) {
                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];

                    }                    
                } else {
                    $CustomField1 = $row['patient_id'];
                    $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining FROM invoice WHERE CustomField1 = '$CustomField1'";

                    if($agency_code==3) {
                        $invoiceRow = get_data_other_db($query, 'row', 'caregiver'); 
                    } else if($agency_code==1) {
                        $invoiceRow = get_data_other_db($query, 'row', 'homemaker'); 
                    } else {
                        $invoiceRow = get_data_other_db($query, 'row');
                    }

                    if(!empty($invoiceRow)) {
                        $invoiceData[$key]['clientName'] = $row['name'];
                        $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                        $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                        $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                        $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];
                    }
                }
            }

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;




            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function invoiceIDOA2() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $query = "SELECT ListID,FullName from customer";
            $customerData = get_data_other_db($query, 'result');

            if(!empty($_GET['formSubmit']) && $_GET['formSubmit']=='Update TxnDate' && !empty($_GET['txnID'])) {
                $txnDate = $_GET['txnDate'];
                $txnID = $_GET['txnID'];
                $ItemRef_ListID = $_GET['itemreflistid'];

                $query1 = "UPDATE invoice SET TxnDate='$txnDate'";
                get_custom_query_data_other_db($query1, 'query', $agency_code); 

                if(!empty($ItemRef_ListID)) {
                    $query1 = "UPDATE invoicelinedetail SET ItemRef_ListID='$ItemRef_ListID'";
                    get_custom_query_data_other_db($query1, 'query', $agency_code);
                }                

                $this->session->set_flashdata('message','Records Has Been Updated Successfully.');
            }

            $invoiceData = [];
            $invoiceBalance = 0;
            if(($agency_code==2 || $agency_code==4)) {
                if(!empty($customerData)) {
                    foreach ($customerData as $key => $row) {                    
                        $CustomerRef_ListID = $row['ListID'];
                        $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining, TxnID, CustomerRef_ListID, Status FROM invoice WHERE CustomerRef_ListID = '$CustomerRef_ListID'";

                        $invoiceRow = get_data_other_db($query, 'row');

                        if(!empty($invoiceRow)) {

                            $IDKEY = $row['TxnID'];

                            $query = "SELECT ItemRef_ListID FROM invoicelinedetail WHERE IDKEY LIKE '%".$IDKEY."%'";
                            $invoiceLineRow = get_data_other_db($query, 'row');

                            $query = "SELECT * FROM items WHERE ListID LIKE '%".$invoiceLineRow['ItemRef_ListID']."%'";
                            $itemRow = get_data_other_db($query, 'row');

                            $invoiceData[$key]['clientName'] = $row['FullName'];
                            $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                            $invoiceData[$key]['CustomerRef_ListID'] = $invoiceRow['CustomerRef_ListID'];
                            $invoiceData[$key]['Status'] = $invoiceRow['Status'];
                            $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                            $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];   
                            $invoiceData[$key]['TxnID'] = $invoiceRow['TxnID'];
                            $invoiceData[$key]['ItemRef_ListID'] = $invoiceLineRow['ItemRef_ListID'];
                            $invoiceData[$key]['ItemRef_ListName'] = $itemRow['FullName'];

                            $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];

                        }                    
                    }
                }
            }

            $query = "SELECT * FROM items";
            $itemResult = get_data_other_db($query, 'result');
            

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;
            $data['itemResult'] = $itemResult;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('idoa/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function invoiceIDOA3() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            $query = "SELECT ListID,FullName from customer";
            $customerData = get_data_other_db($query, 'result');

            $invoiceData = [];
            $invoiceBalance = 0;
            if(($agency_code==2 || $agency_code==4)) {
                if(!empty($customerData)) {
                    foreach ($customerData as $key => $row) {                    
                        $CustomerRef_ListID = $row['ListID'];
                        $query = "SELECT CustomField1, CustomerRef_FullName, ClassRef_FullName, TxnDate, BalanceRemaining FROM invoice WHERE CustomerRef_ListID = '$CustomerRef_ListID'";

                        $invoiceRow = get_data_other_db($query, 'row');

                        if(!empty($invoiceRow)) {
                            $invoiceData[$key]['clientName'] = $row['FullName'];
                            $invoiceData[$key]['CustomerRef_FullName'] = $invoiceRow['CustomerRef_FullName'];
                            $invoiceData[$key]['ClassRef_FullName'] = $invoiceRow['ClassRef_FullName'];
                            $invoiceData[$key]['TxnDate'] = $invoiceRow['TxnDate'];    

                            $invoiceBalance = $invoiceBalance + $invoiceRow['BalanceRemaining'];

                        }                    
                    }
                }
            }

            $data['invoiceData'] = $invoiceData;
            $data['invoiceBalance'] = $invoiceBalance;
            $data['agency'] = $agency_code;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('idoa/invoice.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function updateEmployeeClockZero() {
        if(isset($_SESSION['name'])) {
            /*$where = [];
            $clockData = $this->Comman_model->get_rows('employee_clock-zero', $where);

            $x=0;
            foreach ($clockData as $key => $row) {

                $where = [];
                $where['employee_id'] = $row['employee_id'];
                $employeeData = $this->Comman_model->get_row('employee', $where);

                $where = [];
                $where['patient_id'] = $row['patient_id'];
                $patientData = $this->Comman_model->get_row('patient', $where);

                $dataArray = [];
                $dataArray['emp_lastname'] = $employeeData['lastname'];
                $dataArray['emp_firstname'] = $employeeData['firstname'];
                $dataArray['pt_lastname'] = $patientData['lastname'];
                $dataArray['pt_firstname'] = $patientData['firstname'];

                $where = [];
                $where['employee_clock_id'] = $row['employee_clock_id'];

                $this->Comman_model->update('employee_clock-zero', $where, $dataArray);

                $x++;
            }
            echo $x.' record has been updated.';*/
        } else {
            redirect();
        }
    }


    public function updateEmployeeTotalHours() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Status'] = 1;
            $employeeDataResult = $this->Comman_model->get_rows('employee', $where);
            foreach ($employeeDataResult as $key => $employeeData) {
                /*$where = [];
                $where['ssn'] = $employeeData['ssn'];
                $where['BirthDate'] = $employeeData['BirthDate'];
                $otherAgencyEmployee = $this->Comman_model->get_rows('employee', $where);
                if(!empty($otherAgencyEmployee)) {
                    $agencyHours = [];
                    foreach ($otherAgencyEmployee as $key => $otherEmp) {*/
                        $where = [];
                        $where['agency_id'] = $employeeData['Agency'];
                        $otherAgencyData = $this->Comman_model->get_row('agency', $where);
                        $otherAgencyName = $otherAgencyData['agency_codename'];

                        $total_limit = 0;
                        /*$where = [];
                        $where['ea.employee_id'] = $employeeData['employee_id'];
                        $like = [];
                        $not_like = [];
                        $not_like['ea.pin'] = '+';   
                        $otherAssignedPatientData = $this->Employee_model->getAssignedPatientData($where, $like, $not_like);*/

                        if($employeeData['Agency']==2 || $employeeData['Agency']==4) {
                            $where = [];
                            $where['employee_id'] = $employeeData['employee_id'];
                            $where['start_date>='] = '2021-01-11';
                            $otherAssignedPatientData = $this->Comman_model->get_rows('employee_2finalsheet', $where);

                            if(!empty($otherAssignedPatientData)) {
                                foreach ($otherAssignedPatientData as $key => $otherAssign) {
                                    $total_limit = $total_limit + $otherAssign['total_2weekly'];                                
                                }
                    
                                if(!empty($total_limit)) {
                                    $update_data = [];
                                    $update_data['total_hours_year'] = $total_limit;

                                    $where = [];
                                    $where['employee_id'] = $employeeData['employee_id'];

                                    $this->Comman_model->update('employee_rewards', $where, $update_data);
                                }                            
                            }    
                        }


                        if($employeeData['Agency']==1 || $employeeData['Agency']==3) {
                            $where = [];
                            $where['employee_id'] = $employeeData['employee_id'];
                            $where['month>='] = '01';
                            $where['year>='] = '2021';
                            $otherAssignedPatientData = $this->Comman_model->get_rows('employee_finalsheet', $where);

                            if(!empty($otherAssignedPatientData)) {
                                foreach ($otherAssignedPatientData as $key => $otherAssign) {
                                    //$total_limit = $total_limit + $otherAssign['total_hrs'];
                                    $total_limit = $total_limit + $otherAssign['period1'] + $otherAssign['period2'];
                                }
                    
                                if(!empty($total_limit)) {
                                    $update_data = [];
                                    $update_data['total_hours_year'] = $total_limit;

                                    $where = [];
                                    $where['employee_id'] = $employeeData['employee_id'];

                                    $this->Comman_model->update('employee_rewards', $where, $update_data);
                                }                            
                            }    
                        }
                        
                    /*}
                }*/
            }         
            echo 'Records has been updated Successfully.';   
        } else {
            redirect();
        }
    }


    public function updateEmployeeRewards() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $resultData = $this->Comman_model->get_rows('employee_rewards', $where);
            foreach ($resultData as $key => $row) {
                $update_data = [];

                $total_hours = $row['total_hours_year'] - $row['manual_entry_hours'];
                if($total_hours<=0) {
                    $total_hours = 0;    
                }

                $update_data['rewards_cash'] = $total_hours*.075;
                $update_data['rewards_points'] = $total_hours*1000;
                $update_data['available_cash'] = $total_hours*.075;

                $where = [];
                $where['employee_id'] = $row['employee_id'];

                $this->Comman_model->update('employee_rewards', $where, $update_data);
            }         
            echo 'Records has been updated Successfully.';   
        } else {
            redirect();
        }
    }


    public function updateEmployeeTotalHoursBySSN() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Status'] = 1;
            $employeeDataResult = $this->Comman_model->get_rows('employee', $where);
            foreach ($employeeDataResult as $key => $employeeData) {
                $where = [];
                $where['ssn'] = $employeeData['ssn'];
                //$where['BirthDate'] = $employeeData['BirthDate'];
                $otherAgencyEmployee = $this->Comman_model->get_rows('employee', $where);
                if(!empty($otherAgencyEmployee)) {
                    $agencyHours = [];
                    $total_limit = 0;
                    foreach ($otherAgencyEmployee as $key => $otherEmp) {
                        $where = [];
                        $where['agency_id'] = $employeeData['Agency'];
                        $otherAgencyData = $this->Comman_model->get_row('agency', $where);
                        $otherAgencyName = $otherAgencyData['agency_codename'];
                        
                        if($employeeData['Agency']==2 || $employeeData['Agency']==4) {
                            $where = [];
                            $where['employee_id'] = $employeeData['employee_id'];
                            $where['start_date>='] = '2021-01-11';
                            $otherAssignedPatientData = $this->Comman_model->get_rows('employee_2finalsheet', $where);

                            if(!empty($otherAssignedPatientData)) {
                                foreach ($otherAssignedPatientData as $key => $otherAssign) {
                                    $total_limit = $total_limit + $otherAssign['total_2weekly'];                                
                                }
                    
                                /*if(!empty($total_limit)) {
                                    $update_data = [];
                                    $update_data['total_hours_year'] = $total_limit;

                                    $where = [];
                                    $where['employee_id'] = $employeeData['employee_id'];

                                    $this->Comman_model->update('employee_rewards', $where, $update_data);
                                }*/                           
                            }    
                        }


                        if($employeeData['Agency']==1 || $employeeData['Agency']==3) {
                            $where = [];
                            $where['employee_id'] = $employeeData['employee_id'];
                            $where['month>='] = '01';
                            $where['year>='] = '2021';
                            $otherAssignedPatientData = $this->Comman_model->get_rows('employee_finalsheet', $where);

                            if(!empty($otherAssignedPatientData)) {
                                foreach ($otherAssignedPatientData as $key => $otherAssign) {
                                    //$total_limit = $total_limit + $otherAssign['total_hrs'];
                                    $total_limit = $total_limit + $otherAssign['period1'] + $otherAssign['period2'];
                                }
                    
                                /*if(!empty($total_limit)) {
                                    $update_data = [];
                                    $update_data['total_hours_year'] = $total_limit;

                                    $where = [];
                                    $where['employee_id'] = $employeeData['employee_id'];

                                    $this->Comman_model->update('employee_rewards', $where, $update_data);
                                }*/                           
                            }    
                        }
                        
                    }

                    if(!empty($total_limit)) {
                        $dataArray = [];
                        $dataArray['total_hours_year'] = $total_limit;

                        //$where = [];
                        //$where['employee_id'] = $employeeData['employee_id'];

                        $this->Comman_model->insert('employee_rewards', $dataArray);
                    }
                }
            }         
            echo 'Records has been updated Successfully.';   
        } else {
            redirect();
        }
    }


    public function updateManualHourEntry() {
        if(isset($_SESSION['name'])) {
            $where = [];
            $where['Status'] = 1;
            $employeeDataResult = $this->Comman_model->get_rows('employee', $where);
            $x=0;            
            foreach ($employeeDataResult as $key => $employeeData) {

                $manual_hours = 0;

                $where = [];
                $where['employee_id'] = $employeeData['employee_id'];
                $where['tagedit'] = '3';
                $where['isIn'] = '1';
                $where['date>='] = '2021-01-01';
                $employeeClockData = $this->Comman_model->get_rows('employee_clock', $where);
                if(!empty($employeeClockData)) {
                    foreach ($employeeClockData as $key => $row) {
                        $where = [];
                        $where['rec_id'] = $row['rec_id'];
                        $where['tagedit'] = '3';
                        $where['isIn'] = '2';
                        $employeeClockData2 = $this->Comman_model->get_row('employee_clock', $where);

                        $datetime1 = new DateTime($employeeClockData2['date']);
                        $datetime2 = new DateTime($row['date']);
                        $interval = $datetime1->diff($datetime2);
                        $hours = $interval->format('%h');
                        $minutes = $interval->format('%i');

                        $manual_hours = $manual_hours + $hours + ($minutes/60);
                        //$manual_hours = quarter($disp1);

                        //echo $row['date'].'<br>';
                        //echo $employeeClockData2['date'].'<br>';
                        //echo $hours.':'.$minutes.'<br>';
                        $x++;
                    }
                    if(!empty($manual_hours)) {
                        $update_data = [];
                        $update_data['manual_entry_hours'] = (int)$manual_hours;

                        $where = [];
                        $where['employee_id'] = $employeeData['employee_id'];

                        $this->Comman_model->update('employee_rewards', $where, $update_data);
                    }
                }
            }
            echo 'Records has been updated Successfully.';   
        } else {
            redirect();
        }
    }


    public function updateEmployee2Weekly() {
        if(isset($_SESSION['name'])) {
            $sql = "select * from employee_clock where DATE(date) between '2021-08-23' AND '2021-08-26' AND isIn = '2' AND tagedit = '6' ";

            //$sql = "select * from employee_clock where DATE(date) between '2021-08-23' AND '2021-08-26' AND isIn = '2' AND tagedit = '6' AND employee_id = '11598' AND patient_id = '11753'";
            $employeeDataResult = $this->Comman_model->getCustomQueryData($sql);
            foreach ($employeeDataResult as $key => $row) {
                $start_date = date('Y-m-d', strtotime($row['date']));
                //$sql = "select * from employee_2weekly where start_date <= '".$start_date."' AND end_date >= '".$start_date."' AND employee_id = '".$row['employee_id']."' AND patient_id = '".$row['patient_id']."'";
                //$weeklyResult = $this->Comman_model->getCustomQueryData($sql);
                //if(empty($weeklyResult)) {
                    //$start_date = '2021-08-23';

                    $sql = "select Agency from employee where employee_id = '".$row['employee_id']."'";
                    $empData = $this->Comman_model->getCustomQueryData($sql, 'row');

                    $agency_code = $empData['Agency'];
                    $emplid = $row['employee_id'];
                    $ptid = $row['patient_id'];

                    //$addate = date("Y-m-d");
                    //$con = new mysqli("localhost", "admin", "G0hcp3949$", "demoivr");
                    $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$start_date' AND start_date  <= '$start_date'";
                    $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                    //$addate = date("Y-m-d");
                    $end_date = '';

                    $addate = $start_date;    
                    $transdate = $addate;

                    $val='';
                    if (!empty($chkResult)) {
                        $start_date = $chkResult['start_date'];
                        $end_date = $chkResult['end_date'];
                        $dy = date("d", strtotime(date("Y-m-d", strtotime($addate))));
                        $mn = date("m", strtotime(date("Y-m-d", strtotime($addate))));
                        $yr = date("Y", strtotime(date("Y-m-d", strtotime($addate))));
                    }

                    $a1 = $agency_code;
                    $datetime1 = date_create($addate);
                    $datetime2 = date_create($start_date);
                    $interval = date_diff($datetime1, $datetime2);

                    $cnt =  $interval->format('%a');
                    $cl = $cnt + 1;;
                    $day = 'd' . sprintf("%02s", $cl);

                    $query = "UPDATE employee_2weekly SET " . $day . " = 0  WHERE Agency = '$agency_code' AND start_date = '$start_date' AND employee_id = '$emplid'  AND  patient_id = '$ptid' ";
                    customUpdateHelper($query);

                    $manSQL = "SELECT * FROM employee_clock  WHERE  employee_clock.employee_id = '$emplid'  AND  employee_clock.patient_id =  '$ptid'   AND `isIn` = 1  AND DATE(date) = '$transdate'   ORDER BY employee_clock_id ";
                    $manExec = $this->Comman_model->getCustomQueryData($manSQL);

                    $intRows = 0;

                    foreach ($manExec as $key1 => $manrows) {
                        $hr2=00;
                        $hr1=00;
                        $mn2=00;
                        $mn1=00;
                        $addate = date("Y-m-d", strtotime($manrows['date']));
                        $emplid = $manrows['employee_id'];
                        $ptid = $manrows['patient_id'];
                        $rec_id = $manrows['rec_id'];

                        $temp = date('H:i', strtotime($manrows['date']));
                        $t = explode(":", $temp);
                        $hr1 = $t[0];
                        $mn1 = $t[1];
                        $fdate = date('Y-m-d', strtotime($manrows['date']));
                        $idate = $fdate . ' ' . $hr1 . ':' . $mn1 . ':' . '00';

                        $disp1 = $hr1 + ($mn1 / 60);
                        $tot1 = quarter($disp1);
                        $tot1 = number_format($tot1, 2);
                        $from_time = $tot1;

                        $strSQL2 = "SELECT * FROM employee_clock WHERE isIn = 2 AND DATE(date) = '$addate' AND employee_id = '$emplid' AND patient_id = '$ptid'  AND rec_id = '$rec_id' ";

                        $objResult2 = $this->Comman_model->getCustomQueryData($strSQL2, 'row');

                        if (!empty($objResult2)) {
                            $temp = date('H:i', strtotime($objResult2['date']));
                            $t = explode(":", $temp);
                            $hr2 = $t[0];
                            $mn2 = $t[1];
                            $fdate = date('Y-m-d', strtotime($objResult2['date']));
                            $idate = $fdate . ' ' . $hr2 . ':' . $mn2 . ':' . '00';
                            $disp2 = $hr2 + ($mn2 / 60);
                            $tot2 = quarter($disp2);
                            $tot2 = number_format($tot2, 2);
                            $to_time = $tot2;
                            $to = strtotime($idate);
                        }

                        if (($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00')) {
                            $total = 0;
                        } else {
                            $val = $to_time - $from_time;
                        }

                        $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$addate' AND start_date  <= '$addate'";
                        $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                        if (!empty($chkResult)) {
                            $start_date = $chkResult['start_date'];
                            $end_date = $chkResult['end_date'];
                            $dy = date("d", strtotime(date("Y-m-d", strtotime($addate))));
                            $mn = date("m", strtotime(date("Y-m-d", strtotime($addate))));
                            $yr = date("Y", strtotime(date("Y-m-d", strtotime($addate))));
                        }

                        $a1 = $agency_code;
                        $datetime1 = date_create($addate);
                        $datetime2 = date_create($start_date);
                        $interval = date_diff($datetime1, $datetime2);
                        $cnt =  $interval->format('%a');
                        $cl = $cnt + 1;;

                        $day = 'd' . sprintf("%02s", $cl);
                        $date = 'date' . sprintf("%02s", $cl);
                        if ($cl > 14) {
                            // echo "error ";
                        }

                        $findSQL = "SELECT * FROM employee_2weekly WHERE  employee_id = '$emplid' AND patient_id  = '$ptid' AND start_date ='$start_date'  AND Agency = '$a1'";
                        $findResult = $this->Comman_model->getCustomQueryData($findSQL, 'row');
                        if (empty($findResult)) {
                            $insert = "INSERT INTO employee_2weekly (employee_2weekly_id,Agency,patient_id,employee_id,start_date,end_date," . $day . "," . $date . ") 
                            VALUES (null,'$a1','$ptid','$emplid','$start_date','$end_date','$val','$addate')";
                            $weekly_id = customInsertHelper($insert);
                        } else {
                            $hour = quarter($findResult[$day] + $val);
                            $weekly_id = $findResult['employee_2weekly_id'];
                            $query = "UPDATE employee_2weekly SET " . $day . "='$hour'," . $date . "='$addate' WHERE employee_2weekly_id = '$weekly_id' ";
                            customUpdateHelper($query);
                        }

                        $sumSQL = "SELECT * FROM employee_2weekly WHERE employee_2weekly_id = '$weekly_id'";
                        $sumResult = $this->Comman_model->getCustomQueryData($sumSQL, 'row');

                        $sum_left =  $sumResult['d01']  +
                        $sumResult['d02']  +
                        $sumResult['d03']  +
                        $sumResult['d04']  +
                        $sumResult['d05']  +
                        $sumResult['d06']  +
                        $sumResult['d07']  +
                        $sumResult['d08']  +
                        $sumResult['d09']  +
                        $sumResult['d10']  +
                        $sumResult['d11']  +
                        $sumResult['d12']  +
                        $sumResult['d13']  +
                        $sumResult['d14'];
                        $query = "UPDATE employee_2weekly SET total_2weekly = '$sum_left' WHERE employee_2weekly_id = '$weekly_id'";
                        customUpdateHelper($query);
                    }
                //}
            }
            echo 'Records has been updated Successfully.';   
        } else {
            redirect();
        }
    }


    public function updateEmployee2WeeklyNew() {
        if(isset($_SESSION['name'])) {

            $sql11 = "SELECT * FROM table_2weekly WHERE start_date >= '2020-08-28' AND start_date <= '2021-08-23'";
            $result11 = $this->Comman_model->getCustomQueryData($sql11);

            foreach ($result11 as $key11 => $row11) {
                // code...
                $sql = "select * from employee_clock_083121 where DATE(date) between '".$row11['start_date']."' AND '".$row11['end_date']."' AND isIn = '2'";
                $employeeDataResult = $this->Comman_model->getCustomQueryData($sql);
                foreach ($employeeDataResult as $key => $row) {
                    $start_date = date('Y-m-d', strtotime($row['date']));

                    $sql = "select Agency from employee where employee_id = '".$row['employee_id']."'";
                    $empData = $this->Comman_model->getCustomQueryData($sql, 'row');

                    $agency_code = $empData['Agency'];
                    $emplid = $row['employee_id'];
                    $ptid = $row['patient_id'];

                    $chkSQL = "SELECT * FROM table_2weekly WHERE end_date >= '$start_date' AND start_date  <= '$start_date'";
                    $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                    $end_date = '';

                    $addate = $start_date;    
                    $transdate = $addate;

                    $val='';
                    if (!empty($chkResult)) {
                        $start_date = $chkResult['start_date'];
                        $end_date = $chkResult['end_date'];
                        $dy = date("d", strtotime(date("Y-m-d", strtotime($addate))));
                        $mn = date("m", strtotime(date("Y-m-d", strtotime($addate))));
                        $yr = date("Y", strtotime(date("Y-m-d", strtotime($addate))));
                    }

                    $a1 = $agency_code;
                    $datetime1 = date_create($addate);
                    $datetime2 = date_create($start_date);
                    $interval = date_diff($datetime1, $datetime2);

                    $cnt =  $interval->format('%a');
                    $cl = $cnt + 1;;
                    $day = 'd' . sprintf("%02s", $cl);

                    $query = "UPDATE employee_2weekly_090121 SET " . $day . " = 0  WHERE Agency = '$agency_code' AND start_date = '$start_date' AND employee_id = '$emplid'  AND  patient_id = '$ptid' ";
                    customUpdateHelper($query);

                    $manSQL = "SELECT * FROM employee_clock_083121  WHERE  employee_id = '$emplid' AND patient_id =  '$ptid' AND `isIn` = 1  AND DATE(date) = '$transdate' ORDER BY employee_clock_id ";
                    $manExec = $this->Comman_model->getCustomQueryData($manSQL);

                    $intRows = 0;

                    foreach ($manExec as $key1 => $manrows) {
                        $hr2=00;
                        $hr1=00;
                        $mn2=00;
                        $mn1=00;
                        $addate = date("Y-m-d", strtotime($manrows['date']));
                        $emplid = $manrows['employee_id'];
                        $ptid = $manrows['patient_id'];
                        $rec_id = $manrows['rec_id'];

                        $temp = date('H:i', strtotime($manrows['date']));
                        $t = explode(":", $temp);
                        $hr1 = $t[0];
                        $mn1 = $t[1];
                        $fdate = date('Y-m-d', strtotime($manrows['date']));
                        $idate = $fdate . ' ' . $hr1 . ':' . $mn1 . ':' . '00';

                        $disp1 = $hr1 + ($mn1 / 60);
                        $tot1 = quarter($disp1);
                        $tot1 = number_format($tot1, 2);
                        $from_time = $tot1;

                        $strSQL2 = "SELECT * FROM employee_clock_083121 WHERE isIn = 2 AND DATE(date) = '$addate' AND employee_id = '$emplid' AND patient_id = '$ptid'  AND rec_id = '$rec_id' ";

                        $objResult2 = $this->Comman_model->getCustomQueryData($strSQL2, 'row');

                        if (!empty($objResult2)) {
                            $temp = date('H:i', strtotime($objResult2['date']));
                            $t = explode(":", $temp);
                            $hr2 = $t[0];
                            $mn2 = $t[1];
                            $fdate = date('Y-m-d', strtotime($objResult2['date']));
                            $idate = $fdate . ' ' . $hr2 . ':' . $mn2 . ':' . '00';
                            $disp2 = $hr2 + ($mn2 / 60);
                            $tot2 = quarter($disp2);
                            $tot2 = number_format($tot2, 2);
                            $to_time = $tot2;
                            $to = strtotime($idate);
                        }

                        if (($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00')) {
                            $total = 0;
                        } else {
                            $val = $to_time - $from_time;
                        }

                        $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$addate' AND start_date  <= '$addate'";
                        $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                        if (!empty($chkResult)) {
                            $start_date = $chkResult['start_date'];
                            $end_date = $chkResult['end_date'];
                            $dy = date("d", strtotime(date("Y-m-d", strtotime($addate))));
                            $mn = date("m", strtotime(date("Y-m-d", strtotime($addate))));
                            $yr = date("Y", strtotime(date("Y-m-d", strtotime($addate))));
                        }

                        $a1 = $agency_code;
                        $datetime1 = date_create($addate);
                        $datetime2 = date_create($start_date);
                        $interval = date_diff($datetime1, $datetime2);
                        $cnt =  $interval->format('%a');
                        $cl = $cnt + 1;;

                        $day = 'd' . sprintf("%02s", $cl);
                        $date = 'date' . sprintf("%02s", $cl);
                        if ($cl > 14) {
                            // echo "error ";
                        }

                        $ssn = $manrows['ssn'];

                        $findSQL = "SELECT * FROM employee_2weekly_090121 WHERE  employee_id = '$emplid' AND patient_id  = '$ptid' AND start_date ='$start_date'  AND Agency = '$a1'";
                        $findResult = $this->Comman_model->getCustomQueryData($findSQL, 'row');
                        if (empty($findResult)) {
                            $insert = "INSERT INTO employee_2weekly_090121 (employee_2weekly_id,Agency,patient_id,employee_id,start_date,end_date," . $day . "," . $date . ",ssn) 
                            VALUES (null,'$a1','$ptid','$emplid','$start_date','$end_date','$val','$addate','$ssn')";
                            $weekly_id = customInsertHelper($insert);
                        } else {
                            $hour = quarter($findResult[$day] + $val);
                            $weekly_id = $findResult['employee_2weekly_id'];
                            $query = "UPDATE employee_2weekly_090121 SET " . $day . "='$hour'," . $date . "='$addate' WHERE employee_2weekly_id = '$weekly_id' ";
                            customUpdateHelper($query);
                        }

                        $sumSQL = "SELECT * FROM employee_2weekly_090121 WHERE employee_2weekly_id = '$weekly_id'";
                        $sumResult = $this->Comman_model->getCustomQueryData($sumSQL, 'row');

                        $sum_left =  $sumResult['d01']  +
                        $sumResult['d02']  +
                        $sumResult['d03']  +
                        $sumResult['d04']  +
                        $sumResult['d05']  +
                        $sumResult['d06']  +
                        $sumResult['d07']  +
                        $sumResult['d08']  +
                        $sumResult['d09']  +
                        $sumResult['d10']  +
                        $sumResult['d11']  +
                        $sumResult['d12']  +
                        $sumResult['d13']  +
                        $sumResult['d14'];
                        $query = "UPDATE employee_2weekly_090121 SET total_2weekly = '$sum_left' WHERE employee_2weekly_id = '$weekly_id'";
                        customUpdateHelper($query);
                    }
                }
            }
            
            echo 'Records has been updated Successfully.';   
        } else {
            redirect();
        }
    }


    function createServiceDate() {

        //$month = $_GET['month'];
        for ($i=0; $i<10 ; $i++) {
            $sql = "SELECT * FROM table_2weekly order by table_2weekly_id desc limit 1";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');

            $start_date = date('Y-m-d', strtotime($row['end_date'] . ' +1 day'));
            $batch_2weekly = date('Ymd', strtotime($start_date));
            $end_date = date('Y-m-d', strtotime($row['end_date'] . ' +14 day'));

            $dataArray = [];
            $dataArray['start_date'] = $start_date;
            $dataArray['batch_2weekly'] = $batch_2weekly;
            $dataArray['end_date'] = $end_date;
            $this->Comman_model->insert('table_2weekly', $dataArray);
        }

        echo 'Service date has been added successfully';
    }


    function createServiceDateWeekly() {

        //$month = $_GET['month'];
        for ($i=0; $i<10 ; $i++) {
            $sql = "SELECT * FROM table_weekly ORDER BY table_weekly_id DESC LIMIT 1";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');

            $start_date = date('Y-m-d', strtotime($row['end_date'] . ' +1 day'));
            $batch_weekly = date('Ymd', strtotime($start_date));
            $end_date = date('Y-m-d', strtotime($row['end_date'] . ' +7 day'));

            $dataArray = [];
            $dataArray['start_date'] = $start_date;
            $dataArray['batch_weekly'] = $batch_weekly;
            $dataArray['end_date'] = $end_date;
            $this->Comman_model->insert('table_weekly', $dataArray);
        }

        echo 'WEEKLY Service date has been added successfully.';
    }

    function mcoSettings() {

        
        $sql = "SELECT mco_rate_settings.*, agency.agency_codename FROM mco_rate_settings LEFT JOIN agency ON mco_rate_settings.agency = agency.agency_code ORDER BY mco_rate_settings.id desc";
        $settingsData = $this->Comman_model->getCustomQueryData($sql);

        $data = [];
        $data['settingsData'] = $settingsData;

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('mco/settings', $data);
        $this->load->view('common/footer-view.php');      
    }

    function addMcoSettings() {
        if (isset($_SESSION['name'])) { 

            if( !empty( $this->input->post( 'submit' ) ) ){

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                $this->form_validation->set_rules('ItemRef_ListID', 'ItemRef List ID', 'trim|required');
                $this->form_validation->set_rules('agency', 'Agency', 'trim|required');

                if ($this->form_validation->run() != false) {
                    $dataArray                          = [];
                    $dataArray['start_date']  = $this->input->post('start_date',true);
                    $dataArray['rate']  = $this->input->post('rate',true);
                    $dataArray['ItemRef_ListID']      = $this->input->post('ItemRef_ListID',true);
                    $dataArray['agency']      = $this->input->post('agency',true);
                    $inserId = $this->Comman_model->insert("mco_rate_settings", $dataArray);
                    if ($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user added mco rate id '.$inserId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('MCO rate has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/mcoSettings','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);

            $data = [];
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Add MCO Settings';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('mco/add-mco-settings', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    function editMcoSettings($pageId='') {

        if (isset($_SESSION['name'])) { 
            $pageId = $this->uri->segment('3');
            if(!empty($pageId)) {
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['id'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('mco_rate_settings',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                $this->form_validation->set_rules('ItemRef_ListID', 'ItemRef List ID', 'trim|required');
                $this->form_validation->set_rules('agency', 'Agency', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $dataArray                          = [];
                    $dataArray['start_date']  = $this->input->post('start_date',true);
                    $dataArray['rate']  = $this->input->post('rate',true);
                    $dataArray['ItemRef_ListID']      = $this->input->post('ItemRef_ListID',true);
                    $dataArray['agency']      = $this->input->post('agency',true);

                    $where  =   [];
                    $where['id'] =   $pageId;

                    $updateId = $this->Comman_model->update( "mco_rate_settings", $where, $dataArray );

                    if ($updateId) {

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated mco rate id '.$pageId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('MCO rate has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/mcoSettings','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Update MCO Rate';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('mco/edit-mco-settings.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }  

    function deleteMcoSettings($recordId) {
        if(!empty($recordId)){
            $recordId = decode64($recordId);
            $where  = [];
            $where['id'] = $recordId;
            $check = $this->Comman_model->delete_row('mco_rate_settings',$where);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted mco rate id '.$recordId.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################


            $this->app->message('MCO rate has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    function dhsSettings() {
        
        $sql = "SELECT dhs_rate_settings.*, agency.agency_codename FROM dhs_rate_settings LEFT JOIN agency ON dhs_rate_settings.agency = agency.agency_code ORDER BY dhs_rate_settings.id desc";
        $settingsData = $this->Comman_model->getCustomQueryData($sql);

        $data = [];
        $data['settingsData'] = $settingsData;

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('dhs/settings', $data);
        $this->load->view('common/footer-view.php');      
    }

    function addDhsSettings() {
        if (isset($_SESSION['name'])) { 

            if( !empty( $this->input->post( 'submit' ) ) ){

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                $this->form_validation->set_rules('ItemRef_ListID', 'ItemRef List ID', 'trim|required');
                $this->form_validation->set_rules('agency', 'Agency', 'trim|required');

                if ($this->form_validation->run() != false) {
                    $dataArray                          = [];
                    $dataArray['start_date']  = $this->input->post('start_date',true);
                    $dataArray['rate']  = $this->input->post('rate',true);
                    $dataArray['ItemRef_ListID']      = $this->input->post('ItemRef_ListID',true);
                    $dataArray['agency']      = $this->input->post('agency',true);
                    $inserId = $this->Comman_model->insert("dhs_rate_settings", $dataArray);
                    if ($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user added mco rate id '.$inserId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('DHS rate has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/dhsSettings','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);

            $data = [];
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Add DHS Settings';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('dhs/add-dhs-settings', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    function editDhsSettings($pageId='') {

        if (isset($_SESSION['name'])) { 
            $pageId = $this->uri->segment('3');
            if(!empty($pageId)) {
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['id'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('dhs_rate_settings',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                $this->form_validation->set_rules('ItemRef_ListID', 'ItemRef List ID', 'trim|required');
                $this->form_validation->set_rules('agency', 'Agency', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $dataArray                          = [];
                    $dataArray['start_date']  = $this->input->post('start_date',true);
                    $dataArray['rate']  = $this->input->post('rate',true);
                    $dataArray['ItemRef_ListID']      = $this->input->post('ItemRef_ListID',true);
                    $dataArray['agency']      = $this->input->post('agency',true);

                    $where  =   [];
                    $where['id'] =   $pageId;

                    $updateId = $this->Comman_model->update( "dhs_rate_settings", $where, $dataArray );

                    if ($updateId) {

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated dhs rate id '.$pageId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('DHS rate has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/dhsSettings','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Update DHS Rate';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('dhs/edit-dhs-settings.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }  

    function deleteDhsSettings($recordId){
        if(!empty($recordId)){
            $recordId = decode64($recordId);
            $where  = [];
            $where['id'] = $recordId;
            $check = $this->Comman_model->delete_row('dhs_rate_settings',$where);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted dhs rate id '.$recordId.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################


            $this->app->message('DHS rate has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    function idoaSettings() {
        
        $sql = "SELECT idoa_rate_settings.*, agency.agency_codename FROM idoa_rate_settings LEFT JOIN agency ON idoa_rate_settings.agency = agency.agency_code ORDER BY idoa_rate_settings.id desc";
        $settingsData = $this->Comman_model->getCustomQueryData($sql);

        $data = [];
        $data['settingsData'] = $settingsData;

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('idoa/settings', $data);
        $this->load->view('common/footer-view.php');      
    }

    function addIdoaSettings() {
        if (isset($_SESSION['name'])) { 

            if( !empty( $this->input->post( 'submit' ) ) ){

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                $this->form_validation->set_rules('ItemRef_ListID', 'ItemRef List ID', 'trim|required');
                $this->form_validation->set_rules('agency', 'Agency', 'trim|required');

                if ($this->form_validation->run() != false) {
                    $dataArray                          = [];
                    $dataArray['start_date']  = $this->input->post('start_date',true);
                    $dataArray['rate']  = $this->input->post('rate',true);
                    $dataArray['ItemRef_ListID']      = $this->input->post('ItemRef_ListID',true);
                    $dataArray['agency']      = $this->input->post('agency',true);
                    $inserId = $this->Comman_model->insert("idoa_rate_settings", $dataArray);
                    if ($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user added idoa rate id '.$inserId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('IDOA rate has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/idoaSettings','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);

            $data = [];
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Add IDOA Settings';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('idoa/add-idoa-settings', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    function editIdoaSettings($pageId='') {

        if (isset($_SESSION['name'])) { 
            $pageId = $this->uri->segment('3');
            if(!empty($pageId)) {
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['id'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('idoa_rate_settings',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                $this->form_validation->set_rules('ItemRef_ListID', 'ItemRef List ID', 'trim|required');
                $this->form_validation->set_rules('agency', 'Agency', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $dataArray                          = [];
                    $dataArray['start_date']  = $this->input->post('start_date',true);
                    $dataArray['rate']  = $this->input->post('rate',true);
                    $dataArray['ItemRef_ListID']      = $this->input->post('ItemRef_ListID',true);
                    $dataArray['agency']      = $this->input->post('agency',true);

                    $where  =   [];
                    $where['id'] =   $pageId;

                    $updateId = $this->Comman_model->update( "idoa_rate_settings", $where, $dataArray );

                    if ($updateId) {

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated idoa rate id '.$pageId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('IDOA rate has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/idoaSettings','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Update IDOA Rate';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('idoa/edit-idoa-settings.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }  

    function deleteIdoaSettings($recordId){
        if(!empty($recordId)){
            $recordId = decode64($recordId);
            $where  = [];
            $where['id'] = $recordId;
            $check = $this->Comman_model->delete_row('idoa_rate_settings',$where);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted idoa rate id '.$recordId.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################


            $this->app->message('IDOA rate has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    function deleteIdoaControl($recordId){
        if(!empty($recordId)){
            $recordId = decode64($recordId);
            $where  = [];
            $where['recid'] = $recordId;
            $check = $this->Comman_model->delete_row('idoa',$where);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted idoa control recid '.$recordId.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################
            $this->app->message('IDOA control has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    function idoaControl() {
        
        $sql = "SELECT * FROM idoa ORDER BY recid desc";
        $pageData = $this->Comman_model->getCustomQueryData($sql);

        $data = [];
        $data['pageData'] = $pageData;

        /*
        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('idoa/view-control.php', $data);
        $this->load->view('common/footer-view.php');      
        */

        $this->load->view('common/header-new.php');
        $this->load->view('common/sidebar-new.php');
        $this->load->view('idoa/view-control-new.php', $data);
    }

    function addIdoaControl() {
        if (isset($_SESSION['name'])) { 
            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('controlno', 'Control No', 'trim|required');
                $this->form_validation->set_rules('servicecode', 'Service Code', 'trim|required');

                if ($this->form_validation->run() != false) {
                    $dataArray                          = [];
                    $dataArray['controlno']  = $this->input->post('controlno',true);
                    $dataArray['servicecode']  = $this->input->post('servicecode',true);
                    $inserId = $this->Comman_model->insert("idoa", $dataArray);
                    if ($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user added idoa controlno rec id '.$inserId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('IDOA control no. has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/idoaControl','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);

            $data = [];
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Add IDOA Settings';
            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('idoa/add-idoa-control.php', $data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new');
            $this->load->view('common/sidebar-new', $data);
            $this->load->view('idoa/add-idoa-control-new', $data);
        } else {
            redirect($this->agent->referrer());
        }
    }


    function editIdoaControl($pageId='') {

        if (isset($_SESSION['name'])) { 
            $pageId = $this->uri->segment('3');
            if(!empty($pageId)) {
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['recid'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('idoa',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('controlno', 'Control No', 'trim|required');
                $this->form_validation->set_rules('servicecode', 'Service Code', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $dataArray                          = [];
                    $dataArray['controlno']  = $this->input->post('controlno',true);
                    $dataArray['servicecode']  = $this->input->post('servicecode',true);

                    $where  =   [];
                    $where['recid'] =   $pageId;

                    $updateId = $this->Comman_model->update( "idoa", $where, $dataArray );

                    if ($updateId) {

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated idoa control no. rec id '.$pageId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('IDOA control no. has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/idoaControl','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Update IDOA Control No.';

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('idoa/edit-idoa-control.php', $data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new');
            $this->load->view('common/sidebar-new', $data);
            $this->load->view('idoa/edit-idoa-control-new', $data);
        } else {
            redirect('');
        }
    }

    function checkNonFormatDecimal() {
        
        $sql = "SELECT * FROM employee_2finalsheet WHERE start_date>='2022-01-01'";
        $empData = $this->Comman_model->getCustomQueryData($sql);
        foreach ($empData as $key => $row) {
            // code...
            $d01 = explode('.', $row['d01']);
            if($d01[1]!=25 && $d01[1]!=50 && $d01[1]!=75 && $d01[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d01 = '.$row['d01'];
                echo '<br>';
            }

            $d02 = explode('.', $row['d02']);
            if($d02[1]!=25 && $d02[1]!=50 && $d02[1]!=75 && $d02[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d02 = '.$row['d02'];
                echo '<br>';
            }

            $d03 = explode('.', $row['d03']);
            if($d03[1]!=25 && $d03[1]!=50 && $d03[1]!=75 && $d03[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d03 = '.$row['d03'];
                echo '<br>';
            }

            $d04 = explode('.', $row['d04']);
            if($d04[1]!=25 && $d04[1]!=50 && $d04[1]!=75 && $d04[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d04 = '.$row['d04'];
                echo '<br>';
            }

            $d05 = explode('.', $row['d05']);
            if($d05[1]!=25 && $d05[1]!=50 && $d05[1]!=75 && $d05[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d05 = '.$row['d05'];
                echo '<br>';
            }

            $d06 = explode('.', $row['d06']);
            if($d06[1]!=25 && $d06[1]!=50 && $d06[1]!=75 && $d06[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d06 = '.$row['d06'];
                echo '<br>';
            }            

            $d07 = explode('.', $row['d07']);
            if($d07[1]!=25 && $d07[1]!=50 && $d07[1]!=75 && $d07[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d07 = '.$row['d07'];
                echo '<br>';
            }

            $d08 = explode('.', $row['d08']);
            if($d08[1]!=25 && $d08[1]!=50 && $d08[1]!=75 && $d08[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d08 = '.$row['d08'];
                echo '<br>';
            }

            $d09 = explode('.', $row['d09']);
            if($d09[1]!=25 && $d09[1]!=50 && $d09[1]!=75 && $d09[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d09 = '.$row['d09'];
                echo '<br>';
            }

            $d10 = explode('.', $row['d10']);
            if($d10[1]!=25 && $d10[1]!=50 && $d10[1]!=75 && $d10[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d10 = '.$row['d10'];
                echo '<br>';
            }

            $d11 = explode('.', $row['d11']);
            if($d11[1]!=25 && $d11[1]!=50 && $d11[1]!=75 && $d11[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d11 = '.$row['d11'];
                echo '<br>';
            }

            $d12 = explode('.', $row['d12']);
            if($d12[1]!=25 && $d12[1]!=50 && $d12[1]!=75 && $d12[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d12 = '.$row['d12'];
                echo '<br>';
            }

            $d13 = explode('.', $row['d13']);
            if($d13[1]!=25 && $d13[1]!=50 && $d13[1]!=75 && $d13[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d13 = '.$row['d13'];
                echo '<br>';
            }

            $d14 = explode('.', $row['d14']);
            if($d14[1]!=25 && $d14[1]!=50 && $d14[1]!=75 && $d14[1]!=00) {
                echo 'employee_2finalsheet_id = '.$row['employee_2finalsheet_id'].' - d14 = '.$row['d14'];
                echo '<br>';
            }
        }
        
    }

    function updateToUpperCase() {
        
        $sql = "SELECT ShipAddressCity, ShipAddressState, patient_id FROM patient";
        $patientData = $this->Comman_model->getCustomQueryData($sql);

        if(!empty($patientData)) {
            $x=0;
            foreach ($patientData as $key => $row) {
                $where = [];
                $where['patient_id'] = $row['patient_id'];

                $dataArray = [];
                if(!empty($row['ShipAddressCity'])) {
                    $dataArray['ShipAddressCity'] = strtoupper($row['ShipAddressCity']);
                }
                if(!empty($row['ShipAddressState'])) {
                    $dataArray['ShipAddressState'] = strtoupper($row['ShipAddressState']);
                }
                if(!empty($dataArray)) {
                    //$this->Comman_model->update('patient', $where, $dataArray);
                    $x++;
                }
            }
            echo $x.' number of patient data has been updated.';
        }
    }

    function viewClientMonthlyHoursTracking() {
        
        $sql = "SELECT * FROM client_monthly_hours_tracking ORDER BY id desc";
        $pageData = $this->Comman_model->getCustomQueryData($sql);

        $data = [];
        $data['pageData'] = $pageData;

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        //$this->load->view('idoa/view-control.php', $data);
        $this->load->view('report/view-client-monthly-hours-tracking.php', $data);
        $this->load->view('common/footer-view.php');      
    }


    public function clientMonthlyHoursTracking() {
        $year = $_POST['year'];
        $month = $_POST['month'];

        if(!empty($year) && !empty($month)) {
            //for ($i=1; $i<=12; $i++) {
                //$month = $i;

                $this->db->where('month',$month);
                $this->db->where('year',$year);
                $this->db->delete('client_monthly_hours_tracking');

                $where = [];
                $where['supervisor_id!='] = 0;
                $supervisorData = $this->Comman_model->get_rows('supervisor', $where);  
                
                foreach ($supervisorData as $key => $row) {
                    $agency_code = $row['Agency'];  
                    $supervisor_id = $row['supervisor_id'];
                    $location_id = $row['agency_location'];

                    $where = [];
                    $where['agency_location_code'] = $location_id;
                    $locationData = $this->Comman_model->get_row('agency_location', $where);
                    $location_name = $locationData['agency_location_name'];

                    $totalActiveClient = 0;

                    $where = [];
                    $where['supervisor_id'] = $supervisor_id;
                    $where['IsActive'] = 1;
                    $patientData = $this->Comman_model->get_rows('patient', $where);
                    if(!empty($patientData)) {
                        foreach ($patientData as $key1 => $row1) {
                            // code...
                            if($row1['Agency']==2 || $row1['Agency']==4) {
                                $response = $this->getActiveClientsHoursMonthly($row1['patient_id'], $row1['Agency'], $month, $year);
                                if($response) {
                                    $totalActiveClient++;
                                }
                            }

                            if($row1['Agency']==1 || $row1['Agency']==3) {
                                $response = $this->getActiveClientsHoursMonthly13($row1['patient_id'], $row1['Agency'], $month, $year);
                                if($response) {
                                    $totalActiveClient++;
                                }
                            }
                        }
                    }            
                    
                    $where = [];
                    $where['agency_code'] = $agency_code;
                    $agencyData = $this->Comman_model->get_row('agency', $where);

                    $dataArray = [];
                    $dataArray['transaction_date'] = date('Y-m-d');
                    $dataArray['supervisor'] = $row['name'];
                    $dataArray['supervisor_id'] = $row['supervisor_id'];
                    $dataArray['agency'] = $agencyData['agency_codename'];
                    $dataArray['agency_id'] = $agency_code;
                    $dataArray['location'] = $location_name;
                    $dataArray['location_id'] = $location_id;
                    $dataArray['active_clients'] = $totalActiveClient;
                    $dataArray['month'] = $month;
                    $dataArray['year'] = $year;
                    //$dataArray[$key]['HMKRHours'] = $HMKRHours;
                    if($totalActiveClient>0) {
                      $this->Comman_model->insert('client_monthly_hours_tracking', $dataArray);  
                    }
                }
            //}
            $this->session->set_flashdata('message', 'Records has been generated successfully.');
        } else {
            $this->session->set_flashdata('error_message', 'Please select year and month first.');            
        }
        redirect('dashboardd/viewClientMonthlyHoursTracking');        
    }

    function viewSupervisorClientMonthlyHoursTracking() {
        
        $sql = "SELECT * FROM client_supervisor_monthly_hours_tracking ORDER BY id DESC";
        $pageData = $this->Comman_model->getCustomQueryData($sql);

        $data = [];
        $data['pageData'] = $pageData;

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        //$this->load->view('idoa/view-control.php', $data);
        $this->load->view('report/view-supervisor-client-monthly-hours-tracking.php', $data);
        $this->load->view('common/footer-view.php');      
    }

    public function clientSupervisorMonthlyHoursTracking() {
        $year = $_POST['year'];
        $month = $_POST['month'];

        if(!empty($year) && !empty($month)) {
            //for ($i=1; $i<=12; $i++) {
                //$month = $i;

                $this->db->where('month',$month);
                $this->db->where('year',$year);
                $this->db->delete('client_supervisor_monthly_hours_tracking');

                $where = [];
                $agencyData = $this->Comman_model->get_rows('agency', $where);

                foreach ($agencyData as $akey => $arow) {
                    // code...
                    $agency_code = $arow['agency_code'];  

                    $where = [];
                    $where['supervisor_id!='] = 0;
                    //$where['Agency'] = $agency_code;
                    $supervisorData = $this->Comman_model->get_rows('supervisor', $where);  
                    
                    foreach ($supervisorData as $key => $row) {                      
                        $supervisor_id = $row['supervisor_id'];
                        $location_id = $row['agency_location'];

                        $where = [];
                        $where['agency_location_code'] = $location_id;
                        $locationData = $this->Comman_model->get_row('agency_location', $where);
                        $location_name = $locationData['agency_location_name'];

                        $totalActiveClient = 0;

                        $where = [];
                        $where['supervisor_id'] = $supervisor_id;
                        $where['IsActive'] = 1;
                        $where['Agency'] = $agency_code;
                        $patientData = $this->Comman_model->get_rows('patient', $where);
                        if(!empty($patientData)) {
                            foreach ($patientData as $key1 => $row1) {
                                // code...
                                if($row1['Agency']==2 || $row1['Agency']==4) {
                                    $response = $this->getActiveClientsHoursMonthly($row1['patient_id'], $row1['Agency'], $month, $year);
                                    if($response) {
                                        $totalActiveClient++;
                                    }
                                }

                                if($row1['Agency']==1 || $row1['Agency']==3) {
                                    $response = $this->getActiveClientsHoursMonthly13New($row1['patient_id'], $row1['Agency'], $month, $year);
                                    if($response) {
                                        $totalActiveClient++;
                                    }
                                }
                            }
                        }            
                        
                        $where = [];
                        $where['agency_code'] = $agency_code;
                        $agencyData = $this->Comman_model->get_row('agency', $where);

                        $dataArray = [];
                        $dataArray['transaction_date'] = date('Y-m-d');
                        $dataArray['supervisor'] = $row['name'];
                        $dataArray['supervisor_id'] = $row['supervisor_id'];
                        $dataArray['agency'] = $agencyData['agency_codename'];
                        $dataArray['agency_id'] = $agency_code;
                        $dataArray['location'] = $location_name;
                        $dataArray['location_id'] = $location_id;
                        $dataArray['active_clients'] = $totalActiveClient;
                        $dataArray['month'] = $month;
                        $dataArray['year'] = $year;
                        //$dataArray[$key]['HMKRHours'] = $HMKRHours;
                        if($totalActiveClient>0) {
                          $this->Comman_model->insert('client_supervisor_monthly_hours_tracking', $dataArray);  
                        }
                    }
                }
            //}
            $this->session->set_flashdata('message', 'Records has been generated successfully.');
        } else {
            $this->session->set_flashdata('error_message', 'Please select year and month first.');            
        }
        redirect('dashboardd/viewSupervisorClientMonthlyHoursTracking');        
    }

    function getActiveClientsHoursMonthly($patientId, $agency_code, $month, $year) {
        $sql2 = "SELECT SQL_CALC_FOUND_ROWS SUM(employee_2finalsheet.total_2weekly) as TOTAL_BILLED FROM patient,employee_2finalsheet,employee WHERE (patient.patient_id = employee_2finalsheet.patient_id AND employee_2finalsheet.employee_id = employee.employee_id ) AND employee_2finalsheet.Agency = '$agency_code' AND patient.Agency = '$agency_code' AND patient.patient_id = '$patientId' AND MONTH(start_date) = '$month' AND YEAR(start_date) = '$year' GROUP BY employee_2finalsheet.employee_id HAVING TOTAL_BILLED>0";
        /*if($patientId=='1213') {
            echo $sql;die;    
        }*/        
        $row2 = $this->Comman_model->getCustomQueryData($sql2, 'row');
        if(!empty($row2) && $row2['TOTAL_BILLED']>0) {
            return true;
        } else {
            return false;
        }
    }

    function getActiveClientsHoursMonthly13($patientId, $agency_code, $month, $year) {
        $sql3 = "SELECT SQL_CALC_FOUND_ROWS DISTINCT SUM(employee_finalsheet.period1) as TOTAL_BILLED1, SUM(employee_finalsheet.period2) as TOTAL_BILLED2 FROM patient,employee_finalsheet,employee WHERE (patient.patient_id = employee_finalsheet.patient_id AND employee_finalsheet.employee_id = employee.employee_id ) AND employee_finalsheet.Agency = '$agency_code' AND patient.Agency = '$agency_code' AND patient.patient_id = '$patientId' AND month = '$month' AND year = '$year' GROUP BY employee_finalsheet.employee_id HAVING TOTAL_BILLED1>0 OR TOTAL_BILLED2>0";
        $row3 = $this->Comman_model->getCustomQueryData($sql3, 'row');
        if(!empty($row3) && ($row3['TOTAL_BILLED1']>0 || $row3['TOTAL_BILLED2']>0)) {
            return true;
        } else {
            return false;
        }
    }

    function getActiveClientsHoursMonthly13New($patientId, $agency_code, $month, $year) {
        $sql3 = "SELECT SQL_CALC_FOUND_ROWS SUM(employee_finalsheet.period1) as TOTAL_BILLED1, SUM(employee_finalsheet.period2) as TOTAL_BILLED2 FROM patient,employee_finalsheet,employee WHERE (patient.patient_id = employee_finalsheet.patient_id AND employee_finalsheet.employee_id = employee.employee_id ) AND employee_finalsheet.Agency = '$agency_code' AND patient.Agency = '$agency_code' AND patient.patient_id = '$patientId' AND month = '$month' AND year = '$year' GROUP BY employee_finalsheet.employee_id HAVING TOTAL_BILLED1>0 OR TOTAL_BILLED2>0";        
        $row3 = $this->Comman_model->getCustomQueryData($sql3, 'row');
        if(!empty($row3) && ($row3['TOTAL_BILLED1']>0 || $row3['TOTAL_BILLED2']>0)) {
            return true;
        } else {
            return false;
        }
    }
} 