<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Employee extends CI_Controller
{
    public function __construct() {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->model('Employee_model', 'employee');
        /**** load phpmailer library for send mail ****/ 
        $this->load->library('phpmailer_lib');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        }
        else
            $this->headerData=[];

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }

    public function getAuthenticated() {
        $postData = $this->input->post();
        if(!empty($postData['password'])) {
            $where = [];
            //$where['name'] = $postData['userName'];
            $where['user_id'] = $this->session->userdata('id');
            $where['password'] = md5($postData['password']);
            //$where['find_in_set("A",userlevel)<>'] = 0;
            //$where['find_in_set("A",userlevel)<>'] = 0;
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            //$whereOr['find_in_set("A",userlevel)<>'] = 0;
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);
            //if($check && (checkUserLevel('P', $this->session->userdata('userlevel')) || checkUserLevel('A', $this->session->userdata('userlevel')))) {
            if($check) {
                $this->session->set_userdata('uservalidated', '1');
                echo 1;
            } else {
                $this->session->unset_userdata('uservalidated');
                echo 0;
            }
        }
    }


    public function index() {
        if(isset($_SESSION['name'])) {
            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $employee = $this->Api_model->getAllDataWhere($where, 'employee');
            $data['user'] = $employee;
            $data['page'] = 'employee';

            $search = $this->input->post('search');

            if(!empty($search)) {
                //print_r($this->input->post());die;
            }

            $cond1 = $cond2 = $cond3 = "";
            //$cond1 = " AND Status = '1'";
            if (!empty($_POST['active2'])) { 
               $active2 = $_POST['active2']; 
               $cond1 = " AND Status = '$active2'";
            }

            if (!empty($_POST['flag'])) { 
               $flag = $_POST['flag']; 
               $cond1 .= " AND flag = '$flag'";
            }

            if(isset($_POST['newHire']) && $_POST['newHire']!='') {
                $newHire = $_POST['newHire']; 
                $cond1 .= " AND newHire = '$newHire'";   
            }

            if(isset($_POST['dd']) && $_POST['dd']!='') {
                $dd = $_POST['dd']; 
                $cond1 .= " AND directdeposit = '$dd'";   
            }

            $suplid2 = $_POST['suplid2']; 
            if($suplid2!='') {    
                $cond2 = " AND employee.supervisor_id = '$suplid2'";   
            }

            $dementia = $_POST['dementia']; 
            if($dementia!='') {    
                $cond2 .= " AND employee.dementia = '$dementia'";   
            }

            $covid_vax = $_POST['covid_vax']; 
            if($covid_vax!='') {    
                $cond2 .= " AND employee.covid_vax = '$covid_vax'";   
            }

            $pin2 = $_POST['pin2']; 
            if($pin2!='') {    
                $cond2 .= " AND employee.pin LIKE '%".$pin2."%'";   
            }

            $employee_id2 = $_POST['employee_id2'];
            if($employee_id2!='') {    
                $cond2 .= " AND employee.employee_id LIKE '%".$employee_id2."%'";   
            }

            $zipcode2 = $_POST['zipcode2'];
            if($zipcode2!='') {    
                $cond2 .= " AND employee.EmployeeAddressPostalCode LIKE '%".$zipcode2."%'";   
            }

            $firstname2 = $_POST['firstname2'];
            if($firstname2!='') {    
                $cond2 .= " AND employee.firstname LIKE '%".$firstname2."%'";   
            }

            $lastname2 = $_POST['lastname2'];
            if($lastname2!='') {    
                $cond2 .= " AND employee.lastname LIKE '%".$lastname2."%'";   
            }

            $ssn = $_POST['ssn'];
            if($ssn!='') {    
                $cond2 .= " AND employee.ssn LIKE '%".$ssn."%'";   
            }

            if(!empty($search) && $search=='searchbyKeyword') {                
                $keyword = $_POST['keyword']; 
                if($keyword=="Active") {
                    $cond2 .= " AND Status = 1";   
                }
                if($keyword=="Alzheimer's/Dementia Trained") {
                    $cond2 .= " AND employee.dementia = 1";   
                }
                if($keyword=="Covid19 Vax") {
                    $cond2 .= " AND employee.covid_vax = 1";   
                }
                if($keyword=="Male") {
                    $cond2 .= " AND employee.gender = 0";   
                }
                if($keyword=="Female") {
                    $cond2 .= " AND employee.gender = 1";   
                }
                if($keyword=="White") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Asian") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Black") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="American Indian") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Hispanic") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Mixed") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="Others") {
                    $cond2 .= " AND employee.race = '".$keyword."'";   
                }
                if($keyword=="English") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Spanish") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Tagalog") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="French") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Arabic") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }
                if($keyword=="Other") {
                    $cond2 .= " AND employee.language LIKE '%".$keyword."%'";   
                }                
                if($keyword=="Web App") {
                    $cond2 .= " AND employee.web_app_user = '1'";   
                }
                if($keyword=="App") {
                    $cond2 .= " AND employee.app_user = '1'";   
                }
                if($keyword=="IVR") {
                    $cond2 .= " AND employee.ivr_user = '1'";   
                }
                if($keyword=="Timesheet") {
                    $cond2 .= " AND employee.timesheet = '1'";   
                }
            }

            $agency_code = $this->session->userdata('agency');
            $cond3 = " AND employee.Agency = '$agency_code'";

            if(!empty($_POST['agency_location'])) {
                $agency_location = $_POST['agency_location']; 
                $cond4 = " AND employee.agency_location = '$agency_location'";
            }

            if(!empty($_POST['mobile'])) {
                $mobile = $_POST['mobile']; 
                $cond4 = " AND employee.mobile like '%".$mobile."%'";   
            }

            if(!empty($_POST['phone'])) {
                $phone = $_POST['phone']; 
                $cond5 = " AND employee.phone like '%".$phone."%'";   
            }


            /********* Filter By tags *************/
            if(!empty($_GET['status']) && $_GET['status']=='Active'){
                $cond1     =   " AND Status = '1'";
            }

            if(!empty($_GET['dementia']) && $_GET['dementia']=='dementia'){
                $cond3 .= " AND employee.dementia = '1'";  
            }

            if(!empty($_GET['covid19']) && $_GET['covid19']=='Covid19 Vax'){
                $cond3 .= " AND employee.covid_vax = '1'";  
            }

            if(!empty($_GET['gender'])) {
                $cond3 .= ' AND employee.gender IN ("' . implode('", "', $_GET['gender']) . '")';  
            }

            if(!empty($_GET['race'])) {
                $cond3 .= ' AND employee.race IN ("' . implode('", "', $_GET['race']) . '")';  
            }

            if(!empty($_GET['webapp'])) {    
                $cond3 .= " AND employee.web_app_user = '1'";   
            }
            if(!empty($_GET['app'])) {
                $cond3 .= " AND employee.app_user = '1'";   
            }
            if(!empty($_GET['ivr'])) {    
                $cond3 .= " AND employee.ivr_user = '1'";   
            }
            if(!empty($_GET['timesheet'])) {        
                $cond3 .= " AND employee.timesheet = '1'";   
            }

            $cc = $xx = '';
            if(!empty($_GET['language'])) {
                $language = [];
                $language = $_GET['language'];
                $x=1;
                foreach ($language as $key => $lang) {
                    if($x==1) {
                        $cc .= " AND ( employee.language LIKE '%".$lang."%'";  
                        $xx .= " AND employee.language LIKE '%".$lang."%'";  
                    } else {
                        $cc .= " OR employee.language LIKE '%".$lang."%'";  
                        $xx .= " OR employee.language LIKE '%".$lang."%'";  
                    }
                    $x++;
                }
                if($x==1) {
                    $cond3 .= $xx;
                } else {
                    $cond3 .= $cc.' )';
                }
            }            

            if(!empty($_POST['search']) || (!empty($_GET['action']) && $_GET['action']=='tags')) {
               /*$MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                            employee.employee_id,
                            employee.lastname AS empl_lastname,
                            employee.firstname AS empl_firstname,
                            employee.agency_location,
                            employee.mobile,
                            employee.phone,
                            employee.useradd,
                            employee.userdate,
                            employee.pin,
                            employee.Status,
                            employee.flag,
                            employee.newHire,
                            employee.Agency,
                            employee.name,
                            employee.popalert,
                            employee.popnotes,
                            employee.supervisor_id,
                            employee.ssn,
                            employee.directdeposit,
                            employee.dementia,
                            employee.covid_vax,
                            employee.EmployeeAddressPostalCode,
                            supervisor.firstname AS sup_firstname, 
                            supervisor.name AS sup_name,
                            supervisor.lastname AS sup_lastname     
                            FROM employee,supervisor WHERE supervisor.supervisor_id = employee.supervisor_id AND
                            employee.pin LIKE '%".@$_POST['pin2']."%' AND 
                            employee.employee_id LIKE '%".@$_POST['employee_id2']."%' AND 
                            employee.EmployeeAddressPostalCode LIKE '%".@$_POST['zipcode2']."%' AND 
                            employee.firstname LIKE '%".@$_POST['firstname2']."%' AND employee.lastname LIKE '%".@$_POST['lastname2']."%' AND employee.ssn LIKE '%".@$_POST['ssn']."%' 
                            ".$cond1.$cond2.$cond3.$cond4.$cond5." ";*/
                            //ORDER BY ".$sortorder." ".$desc."    LIMIT " .$from. ", " .$to . " ";

                $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                            employee.employee_id,
                            employee.lastname AS empl_lastname,
                            employee.firstname AS empl_firstname,
                            employee.agency_location,
                            employee.mobile,
                            employee.phone,
                            employee.useradd,
                            employee.userdate,
                            employee.pin,
                            employee.Status,
                            employee.flag,
                            employee.newHire,
                            employee.Agency,
                            employee.name,
                            employee.popalert,
                            employee.popnotes,
                            employee.supervisor_id,
                            employee.ssn,
                            employee.hcpadmin,
                            employee.directdeposit,
                            employee.dementia,
                            employee.covid_vax,
                            employee.EmployeeAddressPostalCode,
                            supervisor.firstname AS sup_firstname, 
                            supervisor.name AS sup_name,
                            supervisor.lastname AS sup_lastname     
                            FROM employee,supervisor WHERE supervisor.supervisor_id = employee.supervisor_id ".$cond1.$cond2.$cond3.$cond4.$cond5." ";            

                            //echo $MySQL;

                $data['employeeData'] = $this->employee->getCustomQueryData($MySQL);  
            }   

            $where= [];
            $data['agencyLocation'] = $this->Api_model->getAllDataWhere($where, 'agency_location');

            //print_r($data['employeeData']);die;
            $where = [];
            $where['is_supervisor'] = 1;
            $where['lastname!='] = '';
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php',$data);
            $this->load->view('employee/view.php',$data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect();
        }
    }

    public function validateEmployee() {
        $postData = $this->input->post();
        if(!empty($postData['firstname']) && !empty($postData['lastname']) && !empty($postData['ssn']) && !empty($postData['agencyLocation'])) {

            $firstname = trim($postData['firstname']);
            $lastname = trim($postData['lastname']);

            $firstname = str_replace("'", '', $firstname);
            $lastname = str_replace("'", '', $lastname);
            
            $ssn = trim($postData['ssn']);
            $agencyLocation = trim($postData['agencyLocation']);

            $where  =   [];
            $where['Agency'] = $this->session->userdata('agency');
            //$where['ssn'] = $postData['ssn'];
            $like   =   [];
            $like['firstname'] = $firstname;
            $like['lastname'] = $lastname;
            $like['ssn'] = $ssn;
            $num_rows = $this->client->get_rows('employee', '', $where, '', $like, true);
            if($num_rows==0) {
                $dataArray  =   [];
                $dataArray['firstname'] =   $firstname;
                $dataArray['lastname'] =   $lastname;
                $dataArray['name'] =   $lastname.', '.$firstname;
                $dataArray['ssn'] =   $ssn;
                $dataArray['Agency'] =   $this->session->userdata('agency');
                $dataArray['agency_location'] =   $agencyLocation;

                $where = [];
                $where['agency_location_code'] = $agencyLocation;
                $locationData = $this->Comman_model->get_row('agency_location', $where);

                $dataArray['geofencing'] =   $locationData['agency_geofence'];


                $insertData = $this->Comman_model->insert('employee', $dataArray);

                if($insertData) {

                    $dataArray1 = [];
                    $dataArray1['pin'] = $insertData;

                    $where = [];
                    $where['employee_id'] = $insertData;

                    $this->Comman_model->update('employee', $where, $dataArray1);

                    ############### USER ACTION TRACKING START ####################
                    if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user added employee id '.$insertData.' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);    
                    }
                    ############### USER ACTION TRACKING END ####################
                    
                    echo $insertData;     
                } else {
                    echo 0;
                }
            } else {
                $this->session->set_flashdata('validate_error','Employee already exists.');
                $this->session->set_userdata('client','validate');
                echo 0;
            }    
        } else {
           echo 2; 
        }
    }


    public function updatePayHistory() {
        $postData = $this->input->post();
        if(!empty($postData['employeeId']) && !empty($postData['recId'])) {

            $recId = $postData['recId'];
            $voided = $postData['voided'];
            $employeeId = $postData['employeeId'];

            $where  =   [];
            $where['id'] = $recId;

            $dataArray   =   [];
            $dataArray['voided'] = $voided;
            $this->Comman_model->update('portal_pay_history', $where, $dataArray);
            $this->session->set_flashdata('message','Pay history record has been updated successfully.');
            echo $employeeId;
        } else {
            $this->session->set_flashdata('error_message','Oops something went wrong. Try again.');
            echo 0;
        }
    }

    public function add() {

        if(isset($_SESSION['name'])) {
            /*$mysql = 'select * from employee order by employee_id desc limit 1';
            $row = $this->Comman_model->getCustomQueryData($mysql, 'row');
            if(!empty($row['employee_id'])) {
                $employee_id = $row['employee_id'] + 1;
            } else {
                $employee_id = 1;
            }

            if($employee_id) {
                if(!empty($_GET['type']) && $_GET['type']=='applicant' && !empty($_GET['applicant_id'])) {
                    redirect('employee/edit?id='.$employee_id.'&action=add&type=applicant&applicant_id='.$_GET['applicant_id']);
                } else {
                    redirect('employee/edit?id='.$employee_id.'&action=add');
                }
            } else {
                redirect('employee');
            }*/

            $where = [];
            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $data['agencyData'] = $this->Comman_model->get_rows('agency', $where);

            $where = [];
            $where['agency_code'] = $this->session->userdata('agency');
            $data['agency'] = $this->Comman_model->get_row('agency', $where);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add.php',$data);
            $this->load->view('common/footer.php');

        } else {
            redirect();
        }
    }

    /*
    public function addOLD1() {
        if(isset($_SESSION['name'])) {

            /*$id = $this->input->get('id');

            $data['row'] = $this->db->where('employee_id',$id)->get('employee')->row_array();
            $employeeData = $data['row'];

            $where = [];
            $where['agency_id'] = $data['row']['Agency'];
            $data['agencyData'] = $this->Comman_model->get_row('agency', $where);

            $AgencyName = 'Hcpemployees/'.$data['agencyData']['agency_codename'];
            $lastname = str_replace("'","",$data['row']['lastname']);
            $firstname = str_replace("'","",$data['row']['firstname']);
            $folderPath = "/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$id;
            $dirname = FCPATH.$folderPath;
            $data['folderPath'] = $folderPath;

            if(!empty($this->input->post())) {

                $firstname = $this->input->post('firstname', TRUE);
                $lastname = $this->input->post('lastname', TRUE);
                $name = $lastname.', '.$firstname;

                $compliance = $this->input->post('formcheck', TRUE);
                if(!empty($compliance)) {
                    $compliance = implode(',', $compliance);
                }

                $dataArray = [];
                $dataArray['employee_id'] = $this->input->post('employee_id', TRUE);
                $dataArray['name'] = $name;
                $dataArray['firstname'] = $firstname;
                $dataArray['lastname'] = $lastname;
                $dataArray['mobile'] = $this->input->post('mobile', TRUE);
                $dataArray['supervisor_id'] = $this->input->post('suplid', TRUE);
                $dataArray['supervisor_id2'] = $this->input->post('suplidS2', TRUE);
                $dataArray['supervisor_id3'] = $this->input->post('suplidS3', TRUE);
                $dataArray['pin'] = $this->input->post('pin', TRUE);
                $dataArray['ADP'] = $this->input->post('ADP', TRUE);
                $dataArray['Agency'] = $this->session->userdata('agency');
                $dataArray['EmployeeAddressAddr1'] = $this->input->post('EmployeeAddressAddr1', TRUE);
                $dataArray['EmployeeAddressAddr2'] = $this->input->post('EmployeeAddressAddr2', TRUE);
                $dataArray['EmployeeAddressCity'] = $this->input->post('EmployeeAddressCity', TRUE);
                $dataArray['EmployeeAddressState'] = $this->input->post('EmployeeAddressState', TRUE);
                $dataArray['EmployeeAddressPostalCode'] = $this->input->post('EmployeeAddressPostalCode', TRUE);
                $dataArray['phone'] = $this->input->post('phone', TRUE);
                $dataArray['height'] = $this->input->post('height', TRUE);
                $dataArray['weight'] = $this->input->post('weight', TRUE);
                $dataArray['CPRCard'] = $this->input->post('CPRCard', TRUE);
                $dataArray['gender'] = $this->input->post('gender', TRUE);

                $language = '';
                if(!empty($this->input->post('language'))) {
                    $language= implode(',', $this->input->post('language'));
                }
                $dataArray['language'] = $language;
                $dataArray['other_language'] = $this->input->post('otherLanguage');

                $dataArray['EmployeeTypeID_Ref'] = $this->input->post('EmployeeTypeID_Ref', TRUE);
                $dataArray['ssn'] = $this->input->post('ssn', TRUE);
                $dataArray['HiredDate'] = $this->input->post('HiredDate', TRUE);
                $dataArray['BirthDate'] = $this->input->post('BirthDate', TRUE);
                $dataArray['StaffingCoordinator'] = $this->input->post('StaffingCoordinator', TRUE);
                $dataArray['Status'] = $this->input->post('Status', TRUE);
                $dataArray['DriveOnJob'] = $this->input->post('DriveOnJob', TRUE);
                $dataArray['InsOnFile'] = $this->input->post('InsOnFile', TRUE);
                $dataArray['StateIDOrLicense'] = $this->input->post('StateIDOrLicense', TRUE);
                $dataArray['SSCARD'] = $this->input->post('SSCARD', TRUE);
                $dataArray['CriminalCheck'] = $this->input->post('CriminalCheck', TRUE);
                $dataArray['TBTEST'] = $this->input->post('TBTEST', TRUE);
                $dataArray['StateLic'] = $this->input->post('StateLic', TRUE);
                $dataArray['shift'] = $this->input->post('shift', TRUE);
                $dataArray['popalert'] = $this->input->post('popalert', TRUE);
                $dataArray['popnotes'] = $this->input->post('popnotes', TRUE);
                $dataArray['email'] = $this->input->post('email2', TRUE);
                $dataArray['Notes'] = $this->input->post('Notes', TRUE);
                $dataArray['useradd'] = $this->input->post('useradd', TRUE);
                $dataArray['userdate'] = $this->input->post('userdate', TRUE);
                $dataArray['compliance'] = $compliance;
                $dataArray['race'] = $this->input->post('race', TRUE);
                $dataArray['geofencing'] = $this->input->post('geofencing', TRUE);

                $old_image = '';
                if(!empty($data['row']['emp_image'])) {
                    $old_image = $data['row']['emp_image'];
                }

                if(!empty($_FILES['emp_image'])){
                    $img_data   =   [];
                    $img_data['path']   =   'image/emp_image';
                    $img_data['file_name']  =   'emp_image';
                    $img_data['allowed_type']   =   'png|jpg|jpeg';
                    $img_data['old_file']   =   $old_image;
                    $img_data['width']  =   200;
                    $img_data['height'] =   200;
                    $img_data['quality']    =   '60%';
                    $img_data['image_compress'] =   False;

                    $img=$this->uploadfiles($img_data);
                    if(!empty($img['status']=='1')){
                        $dataArray['emp_image']=$img['url'];
                    }
                }

                if(!empty($_FILES['workersefile'])){
                    $allowedExts = array("pdf");
                    $temp = explode(".", $_FILES["workersefile"]["name"]);
                    $extension = end($temp);
                    if ((($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "image/jpeg") || ($_FILES["workersefile"]["type"] == "image/jpg") || ($_FILES["workersefile"]["type"] == "application/pdf")) && ($_FILES["workersefile"]["size"] < 200000000) && in_array($extension, $allowedExts)) {
                        
                        if ($_FILES["workersefile"]["error"] > 0) {
                            //echo "Return Code: " . $_FILES["workersefile"]["error"] . "<br>";
                        } else {                                
                            if (!file_exists($dirname)) {
                                mkdir($dirname, 0777, true);
                            }   
                            $exttype = 'PDF';
                            
                            if (file_exists($dirname.'/'. $_FILES["workersefile"]["name"])) {
                                //echo $_FILES["workersefile"]["name"] . " already exists. ";
                            } else {
                                $xfile = $_FILES["workersefile"]["name"];
                                move_uploaded_file($_FILES["workersefile"]["tmp_name"],$dirname.'/'. $xfile);
                                $dataArray1 = [];
                                $dataArray1['file_name'] = $xfile;
                                $dataArray1['type'] = $exttype;
                                $dataArray1['timestamp'] = date("Y-m-d H:i:s");
                                $dataArray1['uploaded_by'] = $this->session->userdata('name');
                                $insert = $this->Comman_model->insert('patient_image', $dataArray1);
                            }
                        }

                    }
                }



                $id = $this->Comman_model->insert('employee', $dataArray);

                if($id) {

                    $dataArray = [];
                    $dataArray['employee_id'] = $id;
                    $dataArray['old_value'] = json_encode($employeeData);
                    $dataArray['new_value'] = json_encode($_POST);
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['user_level'] = $this->session->userdata('userlevel');
                    $dataArray['agency'] = $this->session->userdata('agency');
                    $dataArray['createdOn'] = date('Y-m-d H:i:s');
                    insertHelper('employee_update_history', $dataArray);

                    $this->session->set_flashdata('message','Employee has been added successfully.');
                    redirect('employee/edit?id='.$id);
                } else {
                    $this->session->set_flashdata('message','Somthing Went Wrong');
                    redirect('employee/edit?id='.$id);
                }
                
            }

            //print_r('expression');die;

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['employeetypesData'] = $this->Comman_model->get_rows('tblemployeetypes', $where);

            //$data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            $where = [];
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');

            /*$where = [];
            $where['ea.employee_id'] = $id;
            $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where);

            $where = [];
            $where['start_date <='] = date("Y-m-d");
            $data['weeklyData'] = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);

            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');
            $data['agency_code'] = $this->session->userdata('agency');


            $datetrans = date("Y-m-d");
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
                $action = 1;
            } else { $action = 2; }

            $year = date("Y");
            $month = date("m");

            if ($action == 1) {
                $cutoff = 1;
                $eom = 15;
                $tdate2 = strtotime($year.'-'.$month.'-01');
                $fromdate = date("Y-m-d",$tdate2);
                $tdate2 = strtotime($year.'-'.$month.'-15');
                $todate = date("Y-m-d",$tdate2);        
            } 

            if ($action ==2) {
                $cutoff = 16;
                $eom = 31;
                $tdate2 = strtotime($year.'-'.$month.'-16');
                $fromdate = date("Y-m-d",$tdate2);
                $todate = date("Y-m-t",strtotime($datetrans));          
            }

            $Agency = $this->session->userdata('agency');

            if ($Agency == 2 || $Agency == 4) {
                $thedate = $datetrans;
                $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
                //$chkExec = mysql_query($chkSQL);
                //check for pair
                //$chkResult = mysql_fetch_array($chkExec);
                $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                if (!empty($chkResult))  {
                    $fromdate = $chkResult['start_date'];
                    $todate= $chkResult['end_date'];
                    //$startdate = $thedate;   
                }    

            }          


            /*$aSQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id), 
            missed_punch.patient_id AS pt_id, 
            missed_punch.employee_id, 
            missed_punch.date, 
            missed_punch.rec_id, 
            missed_punch.tagedit, 
            missed_punch.latitude, 
            missed_punch.longitude, 
            missed_punch.isIn, 
            missed_punch.paired, 
            missed_punch.employee_clock_id, 
            patient.patient_id, 
            patient.firstname as pt_name, 
            patient.phone, 
            patient.Agency, 
            employee.name as empl_name, 
            employee.pin, 
            employee.phone, 
            employee.mobile, 
            employee.shift 
            FROM missed_punch,patient,employee 
            WHERE (patient.patient_id = missed_punch.patient_id AND missed_punch.employee_id = employee.employee_id ) AND isIn >= 1 
            AND DATE(date) >= '$fromdate'  AND DATE(date)    <= '$todate'
            AND employee.shift = 0       
            AND employee.employee_id = '$id'
            AND reset IS NULL  AND paired = 0 ORDER BY employee.lastname asc, employee_clock_id ASC ";

            $data['missedPunchData'] = $this->employee->getCustomQueryData($aSQL);

            $data['action'] = 'add';
            if (!empty($this->input->get('action'))) {
                $data['action'] = $this->input->get('action');
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add-employee.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }*/

    public function sendHCPchangeMail($empName, $empId, $agency, $username) {
        $to = "compliance@hcpcaregivers.com";
        //$to = "ankityadav036@gmail.com";
        $subject = "HCP changed message";

        $message = "
        <html>
        <head>
        <title>HCP changed message</title>
        </head>
        <body>
        <table border=1 cellpadding=10>
        <tr>
            <td>Employee Name / id</td>
            <td>".$empName." / ".$empId."</td>
        </tr>
        <tr>
            <td>Agency</td>
            <td>".$agency."</td>
        </tr>
        <tr>
            <td>Username</td>
            <td>".$username."</td>
        </tr>
        </table>
        </body>
        </html>
        ";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <compliance@hcpcaregivers.com>' . "\r\n";

        //mail($to,$subject,$message,$headers);
        $this->sendPHPMailerMail($to,$subject,$message,$headers);
    }

    function sendStatusUpdateMail($empName, $empId, $oldStatus, $newStatus, $agency) {
        if($oldStatus!=$newStatus) {

            if($oldStatus==1) {
                $oldStatusName = 'Active';
            }
            if($oldStatus==3) {
                $oldStatusName = 'Inactive';
            }
            if($newStatus==1) {
                $newStatusName = 'Active';
            }
            if($newStatus==3) {
                $newStatusName = 'Inactive';
            }

            $username = $this->session->userdata('name');

            $to = "compliance@hcpcaregivers.com";
            //$to = "ankityadav036@gmail.com";
            $subject = "Employee status update";
            $message = "
            <html>
            <head>
            <title>Employee status update</title>
            </head>
            <body>
            <table border=1 cellpadding=10>
            <tr>
                <td>Employee Name / id</td>
                <td>".$empName." / ".$empId."</td>
            </tr>
            <tr>
                <td>Username</td>
                <td>".$username."</td>
            </tr>
            <tr>
                <td>Agency</td>
                <td>".$agency."</td>
            </tr>
            <tr>
                <td>Old Status</td>
                <td>".$oldStatusName."</td>
            </tr>
            <tr>
                <td>New Status</td>
                <td>".$newStatusName."</td>
            </tr>
            </table>
            </body>
            </html>
            ";
            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            // More headers
            $headers .= 'From: <compliance@hcpcaregivers.com>' . "\r\n";
            //mail($to,$subject,$message,$headers);
            $this->sendPHPMailerMail($to,$subject,$message,$headers);
        }
    }

    public function changeProfile() {
        $employee_id = $_GET['id'];
        $agency = $_GET['agency'];
        $this->session->set_userdata('agency', $agency);
        redirect('employee/edit?id='.$employee_id);
    }


    public function edit() {

        if(isset($_SESSION['name'])) {

            $id = $this->input->get('id');
            $agency = $this->session->userdata('agency');

            $data['row'] = $this->db->where('employee_id',$id)->get('employee')->row_array();
            $employeeData = $data['row'];
            if(empty($employeeData)) {
                $url = base_url('employee/add');
                header("Location: ".$url);
            }

            $sql = "SELECT agency.agency_codename, agency.agency_code, employee.employee_id FROM employee INNER JOIN agency on employee.Agency=agency.agency_code WHERE employee.ssn LIKE '%".trim($employeeData['ssn'])."%' AND employee.BirthDate = '".$employeeData['BirthDate']."' AND employee.agency!='".$employeeData['Agency']."' AND employee.ssn!='' AND employee.ssn = '".$employeeData['ssn']."' AND employee.BirthDate!=''";
            $data['otherProfileData'] = $this->Comman_model->getCustomQueryData($sql);

            $where = [];
            $where['agency_id'] = $data['row']['Agency'];
            $agencyData = $this->Comman_model->get_row('agency', $where);
            $data['agencyData'] = $agencyData;

            $where = [];
            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $data['allCompliance'] = $this->Comman_model->get_rows('employee_compliance', $where);

            /*$AgencyName = 'Hcpemployees/'.$data['agencyData']['agency_codename'];
            $lastname = str_replace("'","",$data['row']['lastname']);
            $firstname = str_replace("'","",$data['row']['firstname']);
            $folderPath = "/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$id;
            $dirname = FCPATH.$folderPath;
            $data['folderPath'] = $folderPath;*/

            if(!empty($this->input->post()) && !empty($id)) {

                $this->form_validation->set_rules('firstname', 'Firstname', 'trim|required');
                $this->form_validation->set_rules('lastname', 'Lastname', 'trim|required');
                $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required');
                $this->form_validation->set_rules('mobile', 'Mobile Number', 'trim|required');
                $this->form_validation->set_rules('BirthDate', 'Date of Birth', 'trim|required');

                $this->form_validation->set_rules('Status', 'Status', 'trim|required');
                $this->form_validation->set_rules('location', 'Location', 'trim|required');
                
                $this->form_validation->set_rules('EmployeeAddressAddr1', 'Employee Address', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressCity', 'City', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressState', 'State', 'trim|required');
                $this->form_validation->set_rules('EmployeeAddressPostalCode', 'Zipcode', 'trim|required');
                $this->form_validation->set_rules('pin', 'Pin', 'trim|required');
                $this->form_validation->set_rules('shift', 'Shift Code', 'trim|required');
                $this->form_validation->set_rules('race', 'Race', 'trim|required');
                $this->form_validation->set_rules('language[]', 'Language', 'trim|required');

                //$this->form_validation->set_rules('ADP', 'ADP', 'trim|required');
                //$this->form_validation->set_rules('height', 'Height', 'trim|required');
                //$this->form_validation->set_rules('weight', 'Weight', 'trim|required');
                $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
                if(checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('X', $this->session->userdata('userlevel')) || checkUserLevel('P', $this->session->userdata('userlevel'))) {
                    $this->form_validation->set_rules('ssn', 'SSN', 'trim|required');
                }

                //$this->form_validation->set_rules('CPRCard', 'CPR Card', 'trim|required');
                //$this->form_validation->set_rules('InsOnFile', 'InsOnFile', 'trim|required');
                $this->form_validation->set_rules('EmployeeTypeID_Ref', 'Employee Type', 'trim|required');

                $this->form_validation->set_rules('DriveOnJob', 'Drive On Job', 'trim|required');
                //$this->form_validation->set_rules('StateIDOrLicense', 'State License ID', 'trim|required');

                //$this->form_validation->set_rules('StateLic', 'State License No.', 'trim|required');
                $this->form_validation->set_rules('SSCARD', 'SS CARD', 'trim|required');
                $this->form_validation->set_rules('CriminalCheck', 'BackGround Check', 'trim|required');
                //$this->form_validation->set_rules('TBTEST', 'TB TEST', 'trim|required');

                $this->form_validation->set_rules('HiredDate', 'Hired Date', 'trim|required');
                $this->form_validation->set_rules('evaluationDate', 'Evaluation Date', 'trim|required');
                //$this->form_validation->set_rules('aieDate', ' Auto Insurance Expiration Date', 'trim|required');
                

                if ($this->form_validation->run() != false) {

                    $firstname = $this->input->post('firstname', TRUE);
                    $lastname = $this->input->post('lastname', TRUE);
                    $middlename = $this->input->post('middlename', TRUE);
                    $name = $lastname.', '.$firstname;

                    $compliance = $this->input->post('formcheck', TRUE);                    
                    if(!empty($compliance)) {
                        $compliance = implode(',', $compliance);
                    } else {
                        $compliance = '';
                    }

                    $dataArray = [];

                    $Status = $this->input->post('Status', TRUE);                    
                    $dataArray['Status'] = $Status;

                    /*if(checkUserLevel('X', $this->session->userdata('userlevel'))) {
                        $where1 = [];
                        $where1['employee_id'] = $id;
                        $this->Comman_model->update('employee', $where1, $dataArray);
                        $this->session->set_flashdata('message','Compliance user only update status has been updated successfully.');
                        redirect('employee/edit?id='.$id);
                    }*/

                    //$dataArray['employee_id'] = $this->input->post('employee_id', TRUE);
                    $dataArray['name'] = $name;
                    $dataArray['firstname'] = $firstname;
                    $dataArray['lastname'] = $lastname;
                    $dataArray['middlename'] = $middlename;                    
                    $dataArray['mobile'] = $this->input->post('mobile', TRUE);
                    //$dataArray['supervisor_id'] = $this->input->post('suplid', TRUE);
                    //$dataArray['supervisor_id2'] = $this->input->post('suplidS2', TRUE);
                    //$dataArray['supervisor_id3'] = $this->input->post('suplidS3', TRUE);
                    
                    $pin = $this->input->post('pin', TRUE);

                    /********* Check PIN duplicacy here start *********/
                    $empPinCheck = false;
                    $where = [];
                    $where['pin'] = $pin;
                    $where['Agency'] = $agency;
                    $where['employee_id!='] = $id;
                    $num = $this->Comman_model->countrow('employee', $where);
                    if($num>0) {
                        $empDatas = $this->Comman_model->get_rows('employee', $where);
                        foreach ($empDatas as $key => $empData) {
                            // code...                        
                            $where= [];
                            $where['ea.employee_id'] = $id;
                            $like = [];
                            $not_like = [];
                            $not_like['ea.pin'] = '+';
                            $this->load->model('Employee_model', 'employee');
                            $assignedPatientData = $this->employee->getAssignedPatientData($where, $like, $not_like);
                            if(!empty($assignedPatientData)) {
                                foreach ($assignedPatientData as $key => $objResult) {
                                    $where = [];
                                    $where['ea.employee_id'] = $empData['employee_id'];
                                    $where['ea.patient_id'] = $objResult['patient_id'];
                                    $not_like = [];
                                    $not_like['ea.pin'] = '+';
                                    $assignedPatientData1 = $this->employee->getAssignedPatientData($where, $like, $not_like);
                                    if(!empty($assignedPatientData1)) {
                                        $empPinCheck = true;
                                    }
                                }
                                if($empPinCheck) {
                                    $message = 'same PIN has been assigned to other employee ('.$empData['lastname'].' '.$empData['firstname'].')';
                                    $this->session->set_flashdata('error_message',$message);
                                    redirect('employee/edit?id='.$id);
                                    exit();    
                                }
                            }
                        }
                    }
                    /********* Check PIN duplicacy here end *********/

                    $dataArray['pin'] = $pin;

                    $hcpadmin = $this->input->post('hcpAdmin', TRUE);    
                    $dataArray['hcpadmin'] = $hcpadmin;

                    if($employeeData['hcpadmin']!=$hcpadmin) {
                        $this->sendHCPchangeMail($employeeData['name'],$employeeData['employee_id'],$data['agencyData']['agency_codename'],$this->session->userdata('name'));
                    }  

                    $ADP = $this->input->post('ADP', TRUE);

                    $dataArray['ADP'] = $ADP;
                    $dataArray['directdeposit'] = $this->input->post('directDeposit', TRUE);
                    $dataArray['dementia'] = $this->input->post('dementia', TRUE);

                    $dataArray['covid_vax'] = $this->input->post('covid_vax', TRUE);

                    $dataArray['covid_test_positive'] = $this->input->post('covid_test_positive', TRUE);
                    $dataArray['fhca'] = $this->input->post('fhca', TRUE);
                    $dataArray['Agency'] = $this->session->userdata('agency');
                    $dataArray['agency_location'] = $this->input->post('location');
                    $dataArray['EmployeeAddressAddr1'] = $this->input->post('EmployeeAddressAddr1', TRUE);
                    $dataArray['EmployeeAddressAddr2'] = $this->input->post('EmployeeAddressAddr2', TRUE);
                    $dataArray['EmployeeAddressCity'] = $this->input->post('EmployeeAddressCity', TRUE);
                    $dataArray['EmployeeAddressState'] = $this->input->post('EmployeeAddressState', TRUE);
                    $dataArray['EmployeeAddressPostalCode'] = $this->input->post('EmployeeAddressPostalCode', TRUE);
                    $dataArray['phone'] = $this->input->post('phone', TRUE);
                    $dataArray['height'] = $this->input->post('height', TRUE);
                    $dataArray['weight'] = $this->input->post('weight', TRUE);
                    $dataArray['CPRCard'] = $this->input->post('CPRCard', TRUE);
                    $dataArray['gender'] = $this->input->post('gender', TRUE);

                    

                    $language = '';
                    if(!empty($this->input->post('language'))) {
                        $language= implode(',', $this->input->post('language'));
                    }
                    $dataArray['language'] = $language;
                    $dataArray['other_language'] = $this->input->post('otherLanguage');

                    $dataArray['EmployeeTypeID_Ref'] = $this->input->post('EmployeeTypeID_Ref', TRUE);
                    if(checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('X', $this->session->userdata('userlevel')) || checkUserLevel('P', $this->session->userdata('userlevel'))) {
                        $ssn = $this->input->post('ssn', TRUE);
                        if(!empty($ssn) && $ssn!==NULL) {
                            $dataArray['ssn'] = $this->input->post('ssn', TRUE);    
                        }                        
                    }
                    $HiredDate = $this->input->post('HiredDate', TRUE);

                    $dataArray['HiredDate'] = date('Y-m-d', strtotime($HiredDate));;

                    $BirthDate = $this->input->post('BirthDate', TRUE);

                    $dataArray['BirthDate'] = date('Y-m-d', strtotime($BirthDate));
                    $dataArray['StaffingCoordinator'] = $this->input->post('StaffingCoordinator', TRUE); 

                    $dataArray['flag'] = $this->input->post('flag', TRUE);
                    $dataArray['DriveOnJob'] = $this->input->post('DriveOnJob', TRUE);
                    $dataArray['InsOnFile'] = $this->input->post('InsOnFile', TRUE);
                    $dataArray['StateIDOrLicense'] = $this->input->post('StateIDOrLicense', TRUE);
                    $dataArray['SSCARD'] = $this->input->post('SSCARD', TRUE);
                    $dataArray['CriminalCheck'] = $this->input->post('CriminalCheck', TRUE);
                    $dataArray['TBTEST'] = $this->input->post('TBTEST', TRUE);


                    $dataArray['evaluation_date'] = $this->input->post('evaluationDate', TRUE);
                    $dataArray['auto_insurance_expiration_date'] = $this->input->post('aieDate', TRUE);

                    $dataArray['StateLic'] = $this->input->post('StateLic', TRUE);
                    $dataArray['shift'] = $this->input->post('shift', TRUE);
                    if(!empty($this->input->post('popalert', TRUE))) {
                        $popalert = $this->input->post('popalert', TRUE);
                    } else {
                        $popalert = 0;
                    }
                    $dataArray['popalert'] = $popalert;
                    $dataArray['popnotes'] = $this->input->post('popnotes', TRUE);

                    $dataArray['written_warning_first'] = $this->input->post('writtenWarningFirst', TRUE);
                    $dataArray['written_warning_second'] = $this->input->post('writtenWarningSecond', TRUE);                    

                    $dataArray['email'] = $this->input->post('email2', TRUE);
                    $dataArray['Notes'] = $this->input->post('Notes', TRUE);
                    //$dataArray['useradd'] = $this->input->post('useradd', TRUE);
                    //$dataArray['userdate'] = $this->input->post('userdate', TRUE);
                    $dataArray['compliance'] = $compliance;
                    $dataArray['race'] = $this->input->post('race', TRUE);
                    $dataArray['geofencing'] = $this->input->post('geofencing', TRUE);

                    $dataArray['web_app_user'] = $this->input->post('webappuser', TRUE);
                    $dataArray['app_user'] = $this->input->post('appuser', TRUE);
                    $dataArray['ivr_user'] = $this->input->post('ivruser', TRUE);
                    $dataArray['timesheet'] = $this->input->post('timesheetuser', TRUE);

                    $old_image = '';
                    if(!empty($data['row']['emp_image'])) {
                        $old_image = $data['row']['emp_image'];
                    }

                    if(!empty($_FILES['emp_image'])){
                        $img_data   =   [];
                        $img_data['path']   =   'image/emp_image';
                        $img_data['file_name']  =   'emp_image';
                        $img_data['allowed_type']   =   'png|jpg|jpeg';
                        $img_data['old_file']   =   $old_image;
                        $img_data['width']  =   200;
                        $img_data['height'] =   200;
                        $img_data['quality']    =   '60%';
                        $img_data['image_compress'] =   False;

                        $img=$this->uploadfiles($img_data);
                        if(!empty($img['status']=='1')){
                            $dataArray['emp_image']=$img['url'];
                        }
                    }

                    
                    $where = [];
                    $where['employee_id'] = $id;
                    $check = $this->Comman_model->countrow('employee', $where);

                    $pageaction = $this->input->post('pageaction');

                    if($check>0 && $pageaction=='edit') {
                        
                        /*** Unassign employee from client when status is inactive ***/
                        if($Status=='3' && $employeeData['Status']==1) {
                            /****** unassigned all assigned employee ********/
                            $this->unassignedEmployee($id);
                        }
                        
                        if(!empty($ADP) && $ADP!=0) {
                            $dataArray['newHire'] = 0;
                        } else {
                            $dataArray['newHire'] = $this->input->post('newHire', TRUE);     
                        }
                        
                        $update = $this->Comman_model->update('employee', $where, $dataArray);

                        /*** Unassign employee from client when status is inactive ***/
                        if($Status!=$employeeData['Status']) {                            
                            /****** unassigned all assigned employee ********/
                            $this->updateEmployeePin($id, $employeeData['pin'], $Status);
                        }

                        if($employeeData['Status']!=$Status) {
                            /****** send mail to compliance@hcpcaregivers.com ********/
                            $this->sendStatusUpdateMail($name, $id, $employeeData['Status'], $Status, $agencyData['agency_codename']);
                        }

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated employee id '.$id.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################


                    } else {
                        if(!empty($ADP) && $ADP!=0) {
                            $dataArray['newHire'] = 0;
                        } else {
                            $dataArray['newHire'] = 1;    
                        }                        
                        $update = $this->Comman_model->insert('employee', $dataArray);
                        $id = $update;

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user added employee id '.$id.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $dataArray = [];
                        $dataArray['pin'] = $id;
                        $where = [];
                        $where['employee_id'] = $id;
                        $this->Comman_model->update('employee', $where, $dataArray);

                        /***** Update Applicant Hired Status *****/
                        if(!empty($_REQUEST['type']) && $_REQUEST['type']=='applicant') {
                            $applicant_id = $_REQUEST['applicant_id'];
                            $updateQuery = "UPDATE employee SET `hired` = '1' WHERE applicant_id = '$applicant_id'";
                            get_data_other_db($updateQuery, 'query', 'hcp_application');
                        }
                    }                

                    if(!empty($_FILES['workersefile'])){
                        $_FILES['file'] = $_FILES['workersefile'];    
                        $uploadmsg = $this->uploadEmployeeFile($id);
                        $this->session->set_flashdata('message', $uploadmsg);
                    }

                    if($update) {
                        $dataArray = [];
                        $dataArray['employee_id'] = $id;
                        $dataArray['old_value'] = json_encode($employeeData);
                        $dataArray['new_value'] = json_encode($_POST);
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['user_level'] = $this->session->userdata('userlevel');
                        $dataArray['agency'] = $this->session->userdata('agency');
                        $dataArray['createdOn'] = date('Y-m-d H:i:s');
                        insertHelper('employee_update_history', $dataArray);

                        $tab_index = $this->input->post('tab_index');

                        $this->session->set_flashdata('message','Employee has been updated successfully.');
                        redirect('employee/edit?id='.$id.'&tab_index='.$tab_index);
                    } else {
                        $tab_index = $this->input->post('tab_index');
                        $this->session->set_flashdata('message','Somthing Went Wrong');
                        redirect('employee/edit?id='.$id.'&tab_index='.$tab_index);
                    }

                }
                
            }

            

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['employeetypesData'] = $this->Comman_model->get_rows('tblemployeetypes', $where);


            $where = [];
            $where['is_supervisor'] = 1;
            $where['lastname!='] = '';
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'lastname', 'asc');


            if(!empty($id) && !empty($employeeData['ssn']) && $employeeData['BirthDate']!='0000-00-00') {
                $agencyHours = [];
                $where = [];
                //$where['employee_id!='] = $id;
                $where['ssn'] = $employeeData['ssn'];
                $where['BirthDate'] = $employeeData['BirthDate'];
                $otherAgencyEmployee = $this->Comman_model->get_rows('employee', $where);
                if(!empty($otherAgencyEmployee)) {                    
                    foreach ($otherAgencyEmployee as $key => $otherEmp) {
                        $where = [];
                        $where['agency_id'] = $otherEmp['Agency'];
                        $otherAgencyData = $this->Comman_model->get_row('agency', $where);
                        $otherAgencyName = $otherAgencyData['agency_codename'];

                        $total_limit = 0;
                        $where = [];
                        $where['ea.employee_id'] = $otherEmp['employee_id'];
                        $like = [];
                        $not_like = [];
                        $not_like['ea.pin'] = '+';   
                        $otherAssignedPatientData = $this->employee->getAssignedPatientData($where, $like, $not_like);    
                        if(!empty($otherAssignedPatientData)) {
                            foreach ($otherAssignedPatientData as $key => $otherAssign) {
                                $total_limit = $total_limit + $otherAssign['total_limit'];                                
                            }
                            if(!empty($total_limit)) {
                                $agencyHours[$otherAgencyName] = $total_limit;    
                            }                            
                        }
                    }
                }

                $data['agencyHours'] = $agencyHours;


                $where = [];
                $where['ea.employee_id'] = $id;
                $like = [];
                $not_like = [];
                $not_like['ea.pin'] = '+';   
                $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where, $like, $not_like);    


                $otherLocation = [];
                if(!empty($data['assignedPatientData'])) {
                    $x=0;
                    foreach ($data['assignedPatientData'] as $key22 => $row22) {
                        $sqlal = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$row22['agency_location']."'";
                        $rowal = $this->Comman_model->getCustomQueryData($sqlal, 'row');
                        $otherLocation[$x]['location'] = $rowal['agency_location_name'];

                        $sqls = "SELECT name FROM supervisor WHERE supervisor_id = '".$row22['supervisor_id']."'";
                        $rows = $this->Comman_model->getCustomQueryData($sqls, 'row');
                        $otherLocation[$x]['supervisor'] = $rows['name'];
                        $x++;
                    }
                }

                $data['otherLocation'] = $otherLocation;

                $where = [];
                $where['ea.employee_id'] = $id;
                $data['assignedPatientData1'] = $this->employee->getAssignedPatientData($where);    
            }
            

            $where = [];
            $where['start_date <='] = date("Y-m-d");
            $data['weeklyData'] = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);

            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');
            $data['agency_code'] = $this->session->userdata('agency');


            $datetrans = date("Y-m-d");
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
                $action = 1;
            } else { $action = 2; }

            $year = date("Y");
            $month = date("m");

            if ($action == 1) {
                $cutoff = 1;
                $eom = 15;
                $tdate2 = strtotime($year.'-'.$month.'-01');
                $fromdate = date("Y-m-d",$tdate2);
                $tdate2 = strtotime($year.'-'.$month.'-15');
                $todate = date("Y-m-d",$tdate2);        
            } 

            if ($action ==2) {
                $cutoff = 16;
                $eom = 31;
                $tdate2 = strtotime($year.'-'.$month.'-16');
                $fromdate = date("Y-m-d",$tdate2);
                $todate = date("Y-m-t",strtotime($datetrans));          
            }

            $Agency = $this->session->userdata('agency');

            if ($Agency == 2 || $Agency == 4) {
                $thedate = $datetrans;
                $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
                //$chkExec = mysql_query($chkSQL);
                //check for pair
                //$chkResult = mysql_fetch_array($chkExec);
                $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                if (!empty($chkResult))  {
                    $fromdate = $chkResult['start_date'];
                    $todate= $chkResult['end_date'];
                    //$startdate = $thedate;   
                }    

            }          


            $aSQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id), 
            missed_punch.patient_id AS pt_id, 
            missed_punch.employee_id, 
            missed_punch.date, 
            missed_punch.rec_id, 
            missed_punch.tagedit, 
            missed_punch.latitude, 
            missed_punch.longitude, 
            missed_punch.isIn, 
            missed_punch.paired, 
            missed_punch.employee_clock_id, 
            patient.patient_id, 
            patient.firstname as pt_name, 
            patient.phone, 
            patient.Agency, 
            employee.name as empl_name, 
            employee.pin, 
            employee.phone, 
            employee.mobile, 
            employee.shift 
            FROM missed_punch,patient,employee 
            WHERE (patient.patient_id = missed_punch.patient_id AND missed_punch.employee_id = employee.employee_id ) AND isIn >= 1 
            AND DATE(date) >= '$fromdate' AND DATE(date) <= '$todate'
            AND employee.shift = 0       
            AND employee.employee_id = '$id'
            AND reset IS NULL  AND paired = 0 ORDER BY employee.lastname asc, employee_clock_id ASC ";

            $data['missedPunchData'] = $this->employee->getCustomQueryData($aSQL);

            $data['action'] = 'edit';
            if (!empty($this->input->get('action'))) {
                $data['action'] = $this->input->get('action');
            }


            $data['id'] = $id;


            $where = [];
            $where['employee_id'] = $id;
            $data['rewardsData'] = $this->Comman_model->get_row('employee_rewards', $where);



            $sql = "select * from employee_notes_history where employee_id=".$id." order by id desc";
            $employeeNotesData = $this->Comman_model->getCustomQueryData($sql);
            $employeeNotes = '';
            if(!empty($employeeNotesData)) {
                foreach ($employeeNotesData as $key => $row) {
                    $notesDate = date('m/d/Y', strtotime($row['createdOn']));
                    $employeeNotes .= $notesDate.' '.$row['employee_notes']."'\r\n'";
                }
            }

            //$data['employeeNotes'] = $this->Comman_model->getCustomQueryData($sql, 'row');
            $data['employeeNotes'] = $employeeNotes;

            if(!empty($_REQUEST['type']) && $_REQUEST['type']=='applicant') {
                $applicant_id = $_REQUEST['applicant_id'];
                $query = "SELECT * FROM employee where applicant_id='".$applicant_id."'";
                $applicantData  = get_data_other_db($query, 'row', 'hcp_application');
                $data['applicantData']      = $applicantData;

                $data['row']['flag'] = 2;
                $data['row']['newHire'] = 1;
                $data['row']['firstname'] = $applicantData['first_name'];
                $data['row']['lastname'] = $applicantData['last_name'];
                $data['row']['email'] = $applicantData['email'];
                $data['row']['contact_number'] = $applicantData['phone'];
                $data['row']['BirthDate'] = $applicantData['BirthDate'];
                $data['row']['EmployeeAddressAddr1'] = $applicantData['EmployeeAddressAddr1'];
                $data['row']['EmployeeAddressAddr2'] = $applicantData['EmployeeAddressAddr2'];
                $data['row']['EmployeeAddressAddr3'] = $applicantData['EmployeeAddressAddr3'];
                $data['row']['EmployeeAddressCity'] = $applicantData['EmployeeAddressCity'];
                $data['row']['EmployeeAddressState'] = $applicantData['EmployeeAddressState'];
                $data['row']['EmployeeAddressPostalCode'] = $applicantData['EmployeeAddressPostalCode'];

                if($applicantData['gender']=='Male') {
                    $data['row']['gender'] = 0;
                }
                if($applicantData['gender']=='Female') {
                    $data['row']['gender'] = 1;
                }
                if($applicantData['gender']=='Prefer not to say') {
                    $data['row']['gender'] = 2;
                }
                $data['row']['popnotes'] = $applicantData['message'];
            }

            //print_r($data['action']);die;

            $sql = "SELECT * FROM users_portal WHERE FIND_IN_SET('L', userlevel)";
            $data['usersData'] = $this->Comman_model->getCustomQueryData($sql);            

            $sql = "SELECT * FROM cut_check WHERE employee_id = '".$id."'";
            $data['cutcheckData'] = $this->Comman_model->getCustomQueryData($sql);

            if($this->checkAgencyLocation($employeeData['agency_location'])) {
                $sql = "SELECT * FROM portal_pay_history WHERE adp = '".$employeeData['ADP']."'";
                $data['payHistoryData'] = $this->Comman_model->getCustomQueryData($sql);
                $data['payHistoryUsersLocation'] = 1;
            } else {
                $data['payHistoryData'] = [];
                $data['payHistoryUsersLocation'] = 0;
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    function checkAgencyLocation($employeeAgencyLocation){

        $id  = $this->session->userdata('id');
        $sql = "SELECT email FROM users_portal WHERE user_id='".$id."'";
        $row = $this->Comman_model->getCustomQueryData($sql, 'row');

        $sql = "SELECT agency_location FROM supervisor WHERE email='".$row['email']."'";
        $row = $this->Comman_model->getCustomQueryData($sql, 'row');
        //echo $row['agency_location'];
        if(($row['agency_location']==$employeeAgencyLocation) || checkUserLevel('P', $this->session->userdata('userlevel'))) {
            return true;
        } else {
            return false;
        }
    }


    public function workerEfile($employee_id) {
      if(isset($_SESSION['name'])) {  
        $where = [];
        $where['employee_id'] = $employee_id;
        $employeeData = $this->Comman_model->get_row('employee', $where);

        $Agency = $employeeData['Agency'];

        if ($Agency == 1) {
            $AgencyName = 'HM';
        }
        if ($Agency == 2) {
            $AgencyName = 'SC';
        }
        if ($Agency == 3) {
            $AgencyName = 'CG';
        }
        if ($Agency == 4) {
            $AgencyName = 'RF';
        }
        $AgencyName = 'Hcpemployees/'.$AgencyName; 
        $dirname = $AgencyName."/".$employeeData['lastname'].'_'.$employeeData['firstname'].'_'.$employeeData['employee_id'];

        $data['url'] = "http://gohcp.dyndns.org/Dropbox/".$dirname;

        $data['employee_id'] = $employee_id;
        $this->load->view('employee/worker-efile.php',$data);
      } else {
        redirect();
      }
    }

    public function upload() {
      $upload = 'err'; 
      if(!empty($_FILES['workerefile'])) {
        // File upload configuration 
        $_FILES['file'] = $_FILES['workerefile'];
        $upload = $this->uploadEmployeeFile($_POST['employee_id']);
        //$upload = 'ok'; 
      } 
      echo $upload;
    }

    public function uploadEmployeeFile($employee_id) {
        $Agency = $this->session->userdata('agency');
        if ($Agency == 1) {
            $AgencyName = 'HM';
        }
        if ($Agency == 2) {
            $AgencyName = 'SC';
        }
        if ($Agency == 3) {
            $AgencyName = 'CG';
        }
        if ($Agency == 4) {
            $AgencyName = 'RF';
        }
        $msg = '';
        $AgencyName = 'Hcpemployees/'.$AgencyName;
        $allowedExts = array("pdf","PDF");
        $temp = explode(".", $_FILES["file"]["name"]);
        $extension = end($temp);
        $ext =  explode("/",$_FILES["file"]["type"]);
        $recno = $employee_id;
        $pictype = 'doc_';
        $elx = $_FILES["file"]["type"];
        $query = "SELECT * FROM employee WHERE employee_id = '$recno' ";
        $row = $this->Comman_model->getCustomQueryData($query, 'row');
        $lastname = str_replace("'","",$row['lastname']);
        $firstname = str_replace("'","",$row['firstname']);
        $dirname = "/var/www/html/Dropbox/".$AgencyName."/".$lastname.'_'.$firstname.'_'.$recno;

        if (!file_exists($dirname)) {
            mkdir($dirname, 0777, true);
        }   
        $exttype = 'PDF';
        $timestamp = date("Y-m-d H:i:s"); 
        $xfile = '';

        $dataArray = [];
        $dataArray['patient_image_id'] = NULL;
        $dataArray['file_name'] = $xfile;
        $dataArray['type'] = $exttype;
        $dataArray['timestamp'] = $timestamp;
        $dataArray['uploaded_by'] = $this->session->userdata('name');
        $idfile = $this->Comman_model->insert('patient_image', $dataArray);

        $idfile2 = date("YmdH:i:s");
        $xfile = $pictype.$idfile2;
        $xfile = $_FILES["file"]["name"];   

        $where = [];
        $where['patient_image_id'] = $idfile;

        $dataArray = [];
        $dataArray['file_name'] = $xfile;

        $this->Comman_model->update('patient_image', $where, $dataArray);

        if ((($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "image/jpeg")
        || ($_FILES["file"]["type"] == "image/jpg")
        || ($_FILES["file"]["type"] == "application/pdf"))
        && ($_FILES["file"]["size"] < 200000000)
        && in_array($extension, $allowedExts)) {

            if ($_FILES["file"]["error"] > 0) {
                $msg = "Return Code: " . $_FILES["file"]["error"] . "<br>";
            } else {
                $msg = "Upload: " . $_FILES["file"]["name"] . "<br>";
                $msg .= "Type: " . $_FILES["file"]["type"] . "<br>";
                $msg .= "Size: " . ($_FILES["file"]["size"] / 1024) . " kB<br>";
                $msg .= "Temp file: " . $_FILES["file"]["tmp_name"] . "<br>";
                if (file_exists("uploads/".$AgencyName.'/'. $_FILES["file"]["name"])) {
                    $msg = $_FILES["file"]["name"] . " already exists. ";
                } else {
                    move_uploaded_file($_FILES["file"]["tmp_name"],$dirname.'/'. $xfile);
                    //$msg = "Stored in: " .$dirname.'/'. $_FILES["file"]["name"];
                    $msg = "ok";
                }
            }

        } else {
            $msg = "Invalid file";
        }

        return $msg;
    }

    function updateEmployeePin($id, $pin, $status) {
        if($status==1) {
            $pin = str_replace('+', '', $pin);
        }
        if($status==3) {
            $pin = $pin.'+';
        }

        $where = [];
        $where['employee_id'] = $id;

        $dataArray = [];
        $dataArray['pin'] = $pin;

        $this->Comman_model->update('employee', $where, $dataArray);
    }

    public function unassignedEmployee($employeeId) {
        $where  =   [];
        $where['employee_id']   =   $employeeId;
        $eaData = $this->Comman_model->get_rows('employee_assignment', $where);
        if(!empty($eaData)) {

            $where = [];
            $where['employee_id'] = $employeeId;
            $employeeData = $this->Comman_model->get_row('employee', $where);

            foreach ($eaData as $key => $row) {
                $where = [];
                $where['patient_id'] = $row['patient_id'];
                $where['employee_id'] = $row['employee_id'];

                $dataArray  =   [];
                if (substr($row['pin'],0,1) != '+')  {
                    $dataArray['pin'] = '+'.$row['pin'];
                }

                if(!empty($dataArray)) {
                    $this->Comman_model->update('employee_assignment', $where, $dataArray);    

                    ############### USER ACTION TRACKING START ####################
                    if($this->session->userdata('id')!=6) {
                        $dataArray1 = [];
                        $dataArray1['user_id'] = $this->session->userdata('id');
                        $dataArray1['username'] = $this->session->userdata('name');
                        $dataArray1['user_action'] = $this->session->userdata('name'). ' user unassigned worker '.$employeeData['name'].' from client id '.$row['patient_id'].' at '. date('m/d/Y H:i:s').' due to update status Active to Inactive.';
                        $this->Comman_model->insert('users_tracking', $dataArray1);    
                    }
                }
            }
        }
    }


    public function copyNotes() {
        $sql = "select * from employee";
        $employeeData = $this->Comman_model->getCustomQueryData($sql);
        foreach ($employeeData as $key => $row) {
            if(!empty(trim($row['Notes']))) {
                $dataArray = [];
                $dataArray['employee_notes'] = $row['Notes'];
                $dataArray['employee_id'] = $row['employee_id'];
                $dataArray['user_id'] = '6';
                $dataArray['username'] = 'admin';
                $dataArray['createdOn'] = date('Y-m-d H:i:s');

               // $this->Comman_model->insert('employee_notes_history', $dataArray);    
            }
        }

        echo 'successfully';
    }

    

    public function delAssignEmployee($emplId, $patientId) {
        if(!empty($emplId) && !empty($patientId)) {
            $where = [];
            $where['employee_id'] = $emplId;
            $where['patient_id'] = $patientId;
            $data = $this->Comman_model->delete_row('employee_assignment', $where);
            if($data) {
                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted assigned client id '.$patientId.' from employee id '.$emplId.' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################

                $this->session->set_flashdata('message','Delete Data Successfully');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong');
            }
        } 
        redirect($this->agent->referrer());
    }


    public function getByAssignStatus() {
        $postData   =   $this->input->post();
        if(!empty($postData['employee_id'])) {
            $where = [];
            $where['ea.employee_id'] = $postData['employee_id'];
            $like = [];
            if($postData['status']=='false') {
              $like['ea.pin'] = '+'; 
            }
            $not_like = [];
            if($postData['status']=='true') {
              $not_like['ea.pin'] = '+';   
            }
            $eaData    =   $this->employee->getAssignedPatientData($where, $like, $not_like);
            $data = '';
            $total_limit = 0;
            if(!empty($eaData)) {
                $td1 = $td2 = $td3 = $td6 = '';
                foreach ($eaData as $key => $row) {

                    $pin = $row['pin'];
                    if (substr($pin,0,1) != '+')  {
                        $total_limit = $total_limit + $row['total_limit'];
                    }

                    $font_weight = 'normal';
                    $color1 = 'black';
                    if($row['total_limit']>0) {
                        $font_weight = 'bold';
                        $color1 = 'blue';
                    }
                    if($row['total_limit']>40) {
                        $font_weight = 'bold';
                        $color1 = 'red';
                    }

                    $where = [];
                    $where['supervisor_id'] = $row['supervisor_id'];
                    $supervisorData = $this->Comman_model->get_row('supervisor', $where);
                    $supervisorName = 'Supervisor: ';
                    if(!empty($supervisorData['name'])) {
                        $supervisorName .= $supervisorData['name'];    
                    }

                    /*$data .= '<tr><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['patient_id'].'</td><td class="'.$classid.'" bgcolor="'.$color.'"><a target="_blank" href="'.base_url('admin/AddClient?patient=').$row['patient_id'].'" title="'.$supervisorName.'<br>(Click to edit record..)" data-toggle="tooltip" data-html="true" data-placement="top">'.$row['name'].'</a></td><td style="font-weight: <?php echo $font_weight; ?>;color: <?php echo $color1; ?>" align="center">'.$row['total_limit'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['HMKRHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['CNAHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['LPNHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['RNHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['pin'].'</td>';*/

                    /*$data .= '<tr><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['patient_id'].'</td><td class="'.$classid.'" bgcolor="'.$color.'"><a target="_blank" href="'.base_url('admin/AddClient?patient=').$row['patient_id'].'" title="'.$supervisorName.'<br>(Click to edit record..)" data-toggle="tooltip" data-html="true" data-placement="top">'.$row['name'].'</a></td><td class="'.$classid.'"><a target="_blank" href="'.base_url('supervisor/edit?id=').$supervisorData['supervisor_id'].'">'.$supervisorData['name'].'</a></td><td style="font-weight: <?php echo $font_weight; ?>;color: <?php echo $color1; ?>" align="center">'.$row['total_limit'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['HMKRHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['pin'].'</td>';*/ ?>

                    <?php 
                    $sql = "select * from employee_clock where employee_id = ".$row['employee_id']." and patient_id = ".$row['patient_id']." order by date desc limit 2";
                    $LastDayData = get_custom_query_data($sql);
                    $lstData = '';
                    $lstcheck = true;
                    $lstisIn = $lstDate = $lstOut = '';
                    if(!empty($LastDayData)) {
                        foreach ($LastDayData as $key => $lstRow) {
                            if($lstRow['isIn']==1) {
                                $lstcheck = false;
                                $lstDate = '<p style="margin-bottom: 0px;">'.date('m/d/Y', strtotime($lstRow['date'])).'</p>';
                                //lstisIn = '<p style="margin-bottom: 0px;"><b>In:</b> '.date('H:i', strtotime($lstRow['date'])).'</p>';
                            }
                            if($lstRow['isIn']==2) {
                                //$lstOut = '<p style="margin-bottom: 0px;"><b>Out:</b> '.date('h:i:s', strtotime($lstRow['date'])).'</p>';
                            }
                        }
                    }

                    if($lstcheck) {
                        $lstData = 'NA';
                    } else {
                        $lstData = $lstDate;
                    }

                    $data .= '<tr><td class="'.$classid.'" bgcolor="'.$color.'"><p style="margin-bottom: 0px;"><b>PTID :</b> '.$row['patient_id'].'</p><a target="_blank" href="'.base_url('admin/AddClient?patient=').$row['patient_id'].'" title="'.$supervisorName.'<br>(Click to edit record..)" data-toggle="tooltip" data-html="true" data-placement="top">'.$row['name'].'</a></td><td class="'.$classid.'"><a target="_blank" href="'.base_url('supervisor/edit?id=').$supervisorData['supervisor_id'].'">'.$supervisorData['name'].'</a></td><td style="font-weight: <?php echo $font_weight; ?>;color: <?php echo $color1; ?>" align="center">'.$row['total_limit'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['HMKRHours'].'</td><td class="'.$classid.'" bgcolor="'.$color.'">'.$row['pin'].'</td><td class="'.$classid.' text-center" bgcolor="'.$color.'"  data-sql="'.$sql.'">'.$lstData.'</td>';    


                    //if($_SESSION['userlevel']=='A') {    
                    if(checkUserLevel('A', $this->session->userdata('userlevel'))) {   
                        $onclick = "return confirm('Are you sure you want to delete this?');";
                        $data .= '<td class="'.$classid.'" style="width:5%"><center><a href="'.base_url('employee/delAssignEmployee/'.$row['employee_id'].'/'.$row['patient_id']).'" title="Delete" class="btn btn-xs btn-danger" onclick="'.$onclick.'"><i class="fa fa-trash"></i></a></center></td>';
                    }
                  $data .= '</tr>';
                } 
            } else {
                $data = '<tr align="center"><td colspan="9">No data found.</td></tr>';
            }
            print_r($data);
        }
    }


    public function getTimesheetViwer() {
        $postData = $this->input->post();
        if(!empty($postData['employee_id'])) {

            $agency_code = $this->session->userdata('agency');

            $where = [];
            $where['ea.employee_id'] = $postData['employee_id'];
            $like = [];
            if($postData['status']=='false') {
              $like['ea.pin'] = '+'; 
            }
            $not_like = [];
            if($postData['status']=='true') {
              $not_like['ea.pin'] = '+';   
            }
            $eaData    =   $this->employee->getAssignedPatientData($where, $like, $not_like);

            if ($agency_code == 2 || $agency_code == 4 )  {
                $where = [];
                $where['start_date <='] = date("Y-m-d");
                $weeklyData = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', 5);       

                $x=0;$start = [];
                if(!empty($weeklyData)) {
                    foreach ($weeklyData as $key => $roww) {
                        $start[$x] = $roww['start_date'];
                        $x++;
                    }
                }

                $data = '';

                if(!empty($eaData)) {
                    foreach ($eaData as $key => $emprow) {
                        $data .= '<tr>
                        <td>'.$emprow['name'].'
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[0].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 1 <a/>  
                        <center>
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[1].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 2 <a/>  
                        </center>   
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[2].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 3 <a/>
                        </center>
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[3].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 4 <a/>  
                        </center>
                        </td>
                        <td>
                        <center>
                        <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[4].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> 5 <a/>  
                        </center>
                        </td>
                        </tr>';
                    } 
                } else {
                    $data = '<tr align="center"><td colspan="6">No data found.</td></tr>';
                }

                print_r($data);
            }

            if ($agency_code == 1 || $agency_code == 3 )  {
                $dday = date('Y-m-d');
                $mmonth =  date('m',strtotime($dday));
                $yyear = date('Y',strtotime($dday));
                $dday = $yyear.'-'.$mmonth.'-01';
                $period1[0] = $yyear.$mmonth.'15'; 
                $period2[0] = $yyear.$mmonth.'16'; 
                $MONTH[0] =  date('M',strtotime($dday));
                for ($x=1;$x<=4;$x++) {
                    $mdate = strtotime($dday.' -'.$x.' months');
                    $mmonth = date('m',$mdate);
                    $yyear = date('Y',$mdate);
                    $period1[$x] = $yyear.$mmonth.'15'; 
                    $period2[$x] = $yyear.$mmonth.'16'; 
                    $MONTH[$x] =   date('M', strtotime("-".$x." month"));
                    $MONTH[$x] =   date('M',$mdate);
                }

                if(!empty($eaData)) {
                    foreach ($eaData as $key => $emprow) {
                        $data .= '<tr><td>'.$emprow['name'].'</td>';
                        for ($x=0;$x<=4;$x++) {
                        $data .= '<td>
                            <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.$period1[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero="  target="_blank"> Period 1 <a/>  

                            <a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.$period2[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> Period 2 <a/>   
                        </td>';
                        }
                        $data .= '</tr>';
                    }
                }
                print_r($data);
            }
        }
    }



    public function getTimesheetViewer() {
        $postData = $this->input->post();
        if(!empty($postData['employee_id'])) {

            $agency_code = $this->session->userdata('agency');

            $where = [];
            $where['ea.employee_id'] = $postData['employee_id'];            

            $like = [];
            if($postData['status']=='false') {
              $like['ea.pin'] = '+'; 
            }
            if(!empty($postData['patient_name'])) {
               $like['pa.name'] = $postData['patient_name'];
            }

            $not_like = [];
            if($postData['status']=='true') {
              $not_like['ea.pin'] = '+';   
            }
            $eaData    =   $this->employee->getAssignedPatientData($where, $like, $not_like);

            if ($agency_code == 2 || $agency_code == 4 )  {
                $where = [];
                $limit = '';
                if(!empty($postData['tvYear'])) {
                    $where['YEAR(start_date)='] = $postData['tvYear'];                    
                } else {
                    $where['start_date <='] = date("Y-m-d");
                    $limit = '';
                }                
                $weeklyData = $this->Comman_model->get_rows('table_2weekly', $where, 'start_date', 'desc', '*', $limit);       

                $x=0;$start = [];
                if(!empty($weeklyData)) {
                    foreach ($weeklyData as $key => $roww) {
                        $start[$x] = $roww['start_date'];
                        $x++;
                    }
                }

                $data = '';

                $x=0;
                if(!empty($eaData)) {
                    foreach ($eaData as $key => $emprow) {
                        $z=1;
                        foreach ($weeklyData as $key => $roww) {
                            $start[$x] = $roww['start_date'];
                            $check = true; 
                            if(!empty($postData['tvYear'])) {
                                $YEAR = date('Y', strtotime($roww['start_date']));
                                if($YEAR!=$postData['tvYear']) {
                                    $check = false; 
                                }
                            }
                            if($check) {

                                $chkSQL = "SELECT * FROM employee_2finalsheet WHERE patient_id  = '".$emprow['patient_id']."' AND start_date = '".$roww['start_date']."' AND employee_id = '".$emprow['employee_id']."'";
                                $objResult = get_custom_query_data($chkSQL, 'row');

                                $data .= '<tr><td>'.$emprow['name'].'</td><td><center><a href="'.base_url('gpdf/taskPdfView').'?datetrans='.@$start[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank">'.$start[$x].'</a></center></td><td><center><a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.@$start[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank">'.$z.'</a></center></td><td><center>'.$objResult['total_2weekly'].'</center></td></tr>';
                            }
                            $x++;$z++;
                        }
                    } 
                } else {
                    $data = '<tr align="center"><td colspan="5">No data found.</td></tr>';
                }
                print_r($data);
            }

            if ($agency_code == 1 || $agency_code == 3 )  {
                $dday = date('Y-m-d');
                $mmonth =  date('m',strtotime($dday));
                $yyear = date('Y',strtotime($dday));
                $dday = $yyear.'-'.$mmonth.'-01';
                $period1[0] = $yyear.$mmonth.'15'; 
                $period2[0] = $yyear.$mmonth.'16'; 
                $MONTH[0] =  date('M',strtotime($dday));
                for ($x=1;$x<=4;$x++) {
                    $mdate = strtotime($dday.' -'.$x.' months');
                    $mmonth = date('m',$mdate);
                    $yyear = date('Y',$mdate);
                    $period1[$x] = $yyear.$mmonth.'15'; 
                    $period2[$x] = $yyear.$mmonth.'16'; 
                    $MONTH[$x] =   date('M', strtotime("-".$x." month"));
                    $MONTH[$x] =   date('M',$mdate);
                }

                if(!empty($eaData)) {
                    foreach ($eaData as $key => $emprow) {                        
                        for ($x=0;$x<=4;$x++) {

                            $month = date('m', strtotime($period1[$x]));
                            $year = date('Y', strtotime($period1[$x]));

                            $chkSQL = "SELECT * FROM employee_finalsheet WHERE patient_id  = '".$emprow['patient_id']."' AND month = '".$month."' AND year = '".$year."' AND employee_id = '".$emprow['employee_id']."'";
                            $objRow = get_custom_query_data($chkSQL, 'row');
                            $billedHours = $objRow['period1'] + $objRow['period2'];

                            $data .= '<tr><td>'.$emprow['name'].'</td>';
                            $data .= '<td><center><a href="'.base_url('gpdf/taskPdfView').'?datetrans='.$period1[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank">'.$MONTH[$x].'</a></center></td>';
                            $data .= '<td><center><a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.$period1[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero="  target="_blank">Period 1</a><br><a href="'.base_url('timesheet/timesheet').'?mode=brw&datetrans='.$period2[$x].'&emplid='.$emprow['employee_id'].'&ptid='.$emprow['patient_id'].'&IsZero=" target="_blank"> Period 2</a></td><td><center>'.$billedHours.'</center></td>';
                            $data .= '</tr>';    
                        }                        
                    }
                } else {
                    $data = '<tr align="center"><td colspan="5">No data found.</td></tr>';
                }
                print_r($data);
            }
        }
    }



    public function changeAgency(){
        $postData = $this->input->post();

        if(!empty($postData['password'])) {
            $where = [];
            //$where['name'] = $postData['userName'];
            $where['user_id'] = $this->session->userdata('id');
            $where['password'] = md5($postData['password']);
            //$where['find_in_set("A",userlevel)<>'] = 0;
            $where['(find_in_set("A",userlevel) OR find_in_set("C",userlevel) OR find_in_set("I",userlevel))<>'] = 0;
            $whereIn = [];
            //$whereIn['userlevel'] = array('A','C','I');
            $whereOr = [];
            $like = [];
            $check = $this->client->validateUser('users_portal','*',$where,$whereOr,$whereIn,$like,TRUE);
            if($check && (checkUserLevel('A', $this->session->userdata('userlevel')) || checkUserLevel('C', $this->session->userdata('userlevel')) || checkUserLevel('I', $this->session->userdata('userlevel')))) {

                $where = [];
                $where['employee_id'] = $postData['employee_id'];
                $empData = $this->Comman_model->get_row('employee', $where);

                $where = [];
                $where['employee_id'] = $postData['employee_id'];
                $dataArray = [];
                $dataArray['Agency'] = $postData['changeAgency'];
                $dataArray['changenotes'] = $postData['changeNotes'];
                $update = $this->Comman_model->update('employee', $where, $dataArray);
                if($update) {

                    $historyArray = [];
                    $historyArray['employee_id'] = $postData['employee_id'];
                    $historyArray['old_value'] = json_encode($empData);
                    $historyArray['new_value'] = json_encode($postData);
                    $historyArray['user_id'] = $this->session->userdata('id');
                    $historyArray['user_level'] = $this->session->userdata('userlevel');
                    $historyArray['agency'] = $this->session->userdata('agency');
                    $historyArray['createdOn'] = date('Y-m-d H:i:s');
                    insertHelper('employee_update_history', $historyArray);

                    $where = [];
                    $where['agency_code'] = $postData['changeAgency'];
                    $agencyData = $this->Comman_model->get_row('agency', $where);

                    ############### USER ACTION TRACKING START ####################
                    if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user update agency to '.$agencyData['agency_codename'].' for employee id '.$postData['employee_id'].' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);    
                    }
                    ############### USER ACTION TRACKING END ####################


                    echo 1;
                } else {
                    echo 2;
                }
            } else {
                echo 0;
            }
        }
    }

    public function uploadfiles($img_data=[]){
        $folder =   $img_data['path'];
        $file = $img_data['file_name'];
        $allowed_types =    $img_data['allowed_type'];
        $older =    $img_data['old_file'];
        $width  =   $img_data['width'];
        $height =   $img_data['height'];
        $quality    =   $img_data['quality'];

        if(!empty($_FILES[$file]) && $_FILES[$file]['size'] > 0){          
            if(!empty($older)){
                $postimgurl = FCPATH."$folder/". $older;
                unlink($postimgurl);
            }
            $config =   [];
            $config['upload_path']     = './'."$folder".'/'; 
            $config['allowed_types']   = $allowed_types;
            $new_name = $file.time().rand(0000,9999);
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if($this->upload->do_upload($file)){
                $postimg =$this->upload->data()['file_name'] ;
                $postimgurl = base_url()."$folder/". $postimg;
                chmod($this->upload->data()['full_path'],0777);
                if($img_data['image_compress']){
                    $config =   [];
                    $config['image_library'] = 'gd2';  
                    $config['source_image'] = './'."$folder".'/'.$postimg;  
                    $config['create_thumb'] = FALSE;  
                    $config['maintain_ratio'] = FALSE;  

                    $config['quality'] = $quality;  
                    if(!empty($width)){
                        $config['width'] = $width;  
                    }
                    if(!empty($height)){
                        $config['height'] = $height;  
                    }
                    
                    $config['new_image'] = './'."$folder".'/'.$postimg;  
                    
                    $this->load->library('image_lib', $config);  
                    $this->image_lib->initialize($config);
                    if($this->image_lib->resize()){
                        $this->image_lib->clear();
                        $data['url'] =  $postimg;
                        $data['status'] = 1;
                    }else{
                        $data['status'] = 0;
                        $data['msg']=$this->upload->display_errors();
                    }  
                }else{
                    $data['url'] =  $postimg;
                    $data['status'] = 1;
                }
            }else{
                $data['status']=0;
                $data['msg']=$this->upload->display_errors();
            }
            return $data;
        }
    }
    
    public function statusReport() {
        if(isset($_SESSION['name'])) {
            $data['Status'] = @$_GET['Status'];
            $data['race'] = @$_GET['race'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/status-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function getReportPdf() {

        //ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

        ob_start();


        $agency_code = $this->session->userdata('agency');     
        $Status = @$_GET['Status'];                          
        $race = @$_GET['race'];                          

        //array(100,150)
        $cnt = 0;
        $ctr = 0;
        $max  = 40;
        $spc = 40;
        $orient = 'P';
        require_once(APPPATH . 'libraries/employee-report-pdf.php'); 
        $pdf = new employeeReportPDF($orient, 'mm',array(215.9,279.4) );
        //$pdf=new PDF($orient, 'mm',array(215.9,279.4) );

        $where = [];
        $where['agency_code'] = $agency_code;
        $agencyData = $this->Comman_model->get_row('agency', $where);

        $_SESSION['AgencyName'] = $agencyData['agency_shortname'];
        $_SESSION['title'] = "Inactive";
        if($Status==1) {$_SESSION['title'] = "Active"; }
        if($Status==2) {$_SESSION['title'] = "Applicant"; }
        if($Status==3) {$_SESSION['title'] = "InActive"; }
        if($Status==4) {$_SESSION['title'] = "Poor Worker"; } 
        if($Status==5) {$_SESSION['title'] = "Re-Hireable"; } 
        if($Status==6) {$_SESSION['title'] = "Stole Money"; } 
        
        //$pdf=new PDF('L');

        //array(100,150)
        $pdf->AliasNbPages();
        $pdf->AddPage($orient);

        $pdf->SetFont('Arial','',8);
        $pdf->SetLeftMargin(10);


        $sql = "SELECT * FROM employee";
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%'  AND Status = 3 ORDER BY employee.lastname";       

        if ($Status == 1 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code'  AND race LIKE '%$race%' AND Status = 1 ORDER BY employee.lastname";       
        }

        if ($Status == 2 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code'  AND race LIKE '%4race%' AND Status = 2 ORDER BY employee.lastname";       
        }

        if ($Status == 4 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 4 ORDER BY employee.lastname";        
        }

        if ($Status == 5 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 5 ORDER BY employee.lastname";        
        }

        if ($Status == 6 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND race LIKE '%$race%' AND Status = 6 ORDER BY employee.lastname";        
        }

        //$sql .= " LIMIT 1";

        //$result = mysql_query($sql);
        $result = $this->employee->getCustomQueryData($sql);
        $pdf->setxy(10,$spc);
        $page = 0;
        $counter = 0;
        //while(($row = mysql_fetch_array($result))) {
        foreach ($result as $key => $row) {

            if ($cnt >= $max) {
                $page = $page + 1;
                $cnt = 0; 
                $pdf->AliasNbPages();
                $pdf->AddPage($orient);
                $pdf->setxy(10,$spc);
            }

            $counter++;   
            $name = $row['name'];
            $phone = $row['phone'];
            $phone2 = $row['mobile'];
            $race2 = $row['race'];
            $Birthdate = date("m/d/Y",strtotime($row['BirthDate']));

            $cnt = $cnt + 1;
            $pdf->Cell(62,5,$name,1,0,'L');       
            $pdf->Cell(18,5,$Birthdate,1,0,'L');       
            $pdf->Cell(22,5,$phone,1,0,'L');       
            $pdf->Cell(22,5,$phone2,1,0,'L');       
            $pdf->Cell(22,5,$race2,1,1,'L');       

        }

        $pdf->Cell(30,5,'',0,1,'R');
        $pdf->Cell(100,5,'Total:'.$counter,0,0,'L');
        $pdf->Output();

        ob_end_flush(); 
    }

    public function getReportExcel() {
        $agency_code = $this->session->userdata('agency');     
        $Status = $_GET['Status'];                          
        $race = $_GET['race'];                          

        $temp = "CREATE TEMPORARY TABLE `temp_trans` (
        `EmployeeName` varchar(40) NOT NULL,
        `BirthDate` varchar(20) NOT NULL,
        `Phone` varchar(20) NOT NULL,
        `ALTPhone` varchar(20) NOT NULL,
        `race` varchar(20) NOT NULL )";

        $tempresult = $this->client->createTemporaryTable($temp);

        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 3 AND race LIKE '%$race%'  ORDER BY employee.lastname";       

        if ($Status == 1 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 1 AND race LIKE '%$race%'   ORDER BY employee.lastname";          
        }

        if ($Status == 2 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 2 AND race LIKE '%$race%'  ORDER BY employee.lastname";       
        }

        if ($Status == 4 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 4  AND race LIKE '%$race%'  ORDER BY employee.lastname";          
        }

        if ($Status == 5 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 5  AND race LIKE '%$race%'  ORDER BY employee.lastname";          
        }

        if ($Status == 6 )  {
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM  employee WHERE employee.Agency = '$agency_code' AND Status = 6  AND race LIKE '%$race%' ORDER BY employee.lastname";       
        }

        //$result = mysql_query($sql);
        $result = $this->employee->getCustomQueryData($sql);
        //while(($row = mysql_fetch_array($result))) {
        foreach ($result as $key => $row) {

            $phone = $row['phone'];
            $phone2 = $row['mobile'];
            $race2 = $row['race'];
            $BirthDate = date("m/d/Y",strtotime($row['BirthDate']));
            $EmployeeName = $row['name'];   

            $dataArray = [];
            $dataArray['EmployeeName'] = $EmployeeName;
            $dataArray['BirthDate'] = $BirthDate;
            $dataArray['Phone'] = $phone;
            $dataArray['ALTPhone'] = $phone2;
            $dataArray['race'] = $race2;

            $insert = $this->Comman_model->insert('temp_trans', $dataArray);

        } 


        // file name for download
        $filename = "EmployeeStatusReport_" . date('Ymd') . ".xls";

        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $flag = false;
        $row2 = 0;
        $arry = array(' ',' ',' ',' ');
        $result = $this->Comman_model->get_rows('temp_trans');
        foreach ($result as $key => $row) {
            if(!$flag) {
              // display field/column names as first row
              array_walk($row, array($this,'cleanData'));

              echo implode("\t",$arry) . "\r\n";
              echo implode("\t", array_keys($row)) . "\r\n";
              $flag = true;
            }
            array_walk($row, array($this, 'cleanData'));
            $x = 1;
            echo implode("\t", array_values($row)) . "\r\n";
        }                 
    }

    public function cleanData(&$str)  {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    public function compliance() {
        if(isset($_SESSION['name'])) {
            $Agency = $this->session->userdata('agency');
            $drpSQL = "SELECT  
                        employee.lastname AS empl_lastname,
                        employee.firstname AS empl_firstname,
                        compliance
                        FROM employee,supervisor  
                        WHERE supervisor.supervisor_id = employee.supervisor_id  AND  employee.Agency = '$Agency' AND compliance != ''  ORDER BY employee.lastname ASC";

            $data['complianceData'] = $this->employee->getCustomQueryData($drpSQL);            

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/compliance.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function complianceChecklist() {
        $employee_id = $this->input->get('id');
        if(!empty($employee_id)) {
            $drpSQL = "SELECT * FROM employee WHERE employee_id = '".$employee_id."'";
            $data['complianceData'] = $this->Comman_model->getCustomQueryData($drpSQL, 'row');            

            $where = [];
            $data['allCompliance'] = $this->Comman_model->get_rows('employee_compliance', $where);

            // (A) LOAD QR CODE LIBRARY
            //require "vendor/autoload.php";

            

            //echo __DIR__ . '/composer' . '/autoload_real.php';die;
            /*ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);
            error_reporting(E_ALL);
            require_once(APPPATH.'vendor/autoload.php');
            include(APPPATH.'vendor/endroid/qr-code/src/QrCode.php');
            include(APPPATH.'vendor/endroid/qr-code/src/Writer/PngWriter.php');
            
            //use Endroid\QrCode\QrCode;
            //use Endroid\QrCode\Writer\PngWriter;

            // (B) CREATE QR CODE
            //$qr = QrCode::create("https://code-boxx.com");
            $QrCode = new QrCode();
            $qr = $QrCode->create("https://code-boxx.com");
            $writer = new PngWriter();
            $result = $writer->write($qr);

            // (C) OUTPUT QR CODE
            // (C1) SAVE TO FILE
            //$result->saveToFile(__DIR__ . "/qr.png");

            // (C2) DIRECT OUTPUT
            header("Content-Type: " . $result->getMimeType());
            echo $result->getString();

            // (C3) GENERATE DATA URI
            echo "<img src='{$result->getDataUri()}'/>";*/

            //$this->load->view('common/header.php');
            //$this->load->view('common/sidebar.php');
            $this->load->view('employee/compliance-checklist.php',$data);
            //$this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function timesheetReport() {
        if(isset($_SESSION['name'])) {

            $fromD  = date('Y-m-d');
            $toD    = date('Y-m-d');
            $keyword = '';
            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }       
            }

            if(!empty($this->input->post('updategs'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                $sql = "SELECT * FROM manual_timesheet_tracking WHERE DATE(timestamp) BETWEEN '$fromD' AND '$toD'";
                $timesheetReportData = $this->Comman_model->getCustomQueryData($sql);

                foreach ($timesheetReportData as $key => $row) {

                    $sqlp = "SELECT name,supervisor_id,agency_location,Agency FROM patient WHERE patient_id = '".$row['patient_id']."'";
                    $rowp = get_custom_query_data($sqlp, 'row');

                    $sqlpa = "SELECT agency_codename FROM agency WHERE agency_code = '".$rowp['Agency']."'";
                    $rowpa = get_custom_query_data($sqlpa, 'row');

                    $sqle = "SELECT name FROM employee WHERE employee_id = '".$row['employee_id']."'";
                    $rowe = get_custom_query_data($sqle, 'row');

                    $sqls = "SELECT name FROM supervisor WHERE supervisor_id = '".$rowp['supervisor_id']."'";
                    $rows = get_custom_query_data($sqls, 'row');

                    $sqla = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$rowp['agency_location']."'";
                    $rowa = get_custom_query_data($sqla, 'row');

                    // code...
                    $dataArray = [];
                    $dataArray['employee_clock_id'] = $row['employee_clock_id'];
                    $dataArray['employee_id'] = $row['employee_id'];
                    $dataArray['employee_name'] = $rowe['name'];
                    $dataArray['patient_id'] = $row['patient_id'];
                    $dataArray['patient_name'] = $rowp['name'];
                    $dataArray['patient_agency'] = $rowpa['agency_codename'];
                    $dataArray['patient_location'] = $rowa['agency_location_name'];
                    $dataArray['supervisor_name'] = $rows['name'];
                    $dataArray['date'] = $row['date'];
                    $dataArray['timeIn'] = $row['timeIn'];
                    $dataArray['timeOut'] = $row['timeOut'];
                    $dataArray['remarks'] = $row['remarks'];
                    $dataArray['list_option'] = $row['list_option'];
                    $dataArray['userId'] = $row['userId'];
                    $dataArray['username'] = $row['username'];
                    $dataArray['timestamp'] = $row['timestamp'];

                    $this->Comman_model->insert('manual_timsheet_gs', $dataArray);
                    $this->session->set_flashdata('message', 'Record has been added successfully.');
                }
            }

            $sql = "SELECT * FROM manual_timesheet_tracking WHERE DATE(timestamp) BETWEEN '$fromD' AND '$toD'";
            $data['timesheetReportData'] = $this->Comman_model->getCustomQueryData($sql);
                        

            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['keyword'] = $keyword;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/timesheet-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function employeeClockReport() {
        if(isset($_SESSION['name'])) {

            $fromD  = date('Y-m-d');
            $toD    = date('Y-m-d');
            $cond = ' AND isIn=1 AND rec_id IS NOT NULL';
            $data['employeeClockData'] = '';
            if(!empty($_GET['search'])) {
                if(!empty($_GET['fromD'])) {
                    $fromD  = date('Y-m-d', strtotime($_GET['fromD']));    
                }                
                if(!empty($_GET['toD'])) {
                    $toD  = date('Y-m-d', strtotime($_GET['toD']));    
                }

                if(!empty($_GET['employee_id'])) {
                    $employee_id = $_GET['employee_id'];
                    $cond .= " AND employee_id='".$employee_id."'";
                }       

                $sql = "SELECT * FROM employee_clock WHERE DATE(date) BETWEEN '$fromD' AND '$toD'".$cond;
                $data['employeeClockData'] = $this->Comman_model->getCustomQueryData($sql);
            }            

            if ($_GET['formSubmit'] == 'CheckALL' && !empty($_GET['search'])) {
                if(!empty($data['employeeClockData'])) {
                    foreach ($data['employeeClockData'] as $key => $row) {
                        $rec_id = $row['employee_clock_id'];
                        $_SESSION['rxx'][$rec_id]  = 'Yes';  
                    }
                }
            }

            if ($_GET['formSubmit']=='Uncheck') {
                unset($_SESSION['rxx']);
            }

            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['employee_id'] = $employee_id;
            $data['search'] = $_GET['search'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/employee-clock-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    function mispunchUpdate() {
        if(isset($_SESSION['name'])) {

            if(!empty($_GET['fromD'])) {
                $fromD  = date('Y-m-d', strtotime($_GET['fromD']));    
            } else {
                $fromD  = date('Y-m-d');     
            }

            if(!empty($_GET['toD'])) {
                $toD  = date('Y-m-d', strtotime($_GET['toD']));    
            } else {
                $toD    = date('Y-m-d');    
            }

            $cond   = '';
            $data['mispunchData'] = '';
            if(!empty($_GET['search'])) {

                /*if(!empty($_GET['employee_id'])) {
                    $employee_id = $_GET['employee_id'];
                    $cond .= " AND employee_id='".$employee_id."'";
                }       

                $sql = "SELECT * FROM tbl_missedpunch_update WHERE DATE(timestamp) BETWEEN '$fromD' AND '$toD'".$cond;
                $data['mispunchData'] = $this->Comman_model->getCustomQueryData($sql);*/
            }            

            $sql = "SELECT * FROM tbl_missedpunch_update WHERE DATE(timestamp) BETWEEN '$fromD' AND '$toD'".$cond;
            $data['mispunchData'] = $this->Comman_model->getCustomQueryData($sql);


            if($_GET['btnAdd']=='Add Record') {

              $this->db->where('transaction_date',$fromD);
              $this->db->delete('mispunch_update_tracking');

              $where = [];
              $where['su.firstname!='] = '';
              $where['su.supervisor_id!='] = 0;
              $allSupervisorData = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');

              $empHomeMakersAll = $empSeniorcareAll = $empCaregiversAll = $empRockfordAll = 0;
              foreach ($allSupervisorData as $key => $row) {

                $supervisorId = $row['supervisor_id'];

                $MySQLALL = "
                SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
                tbl_missedpunch_update.employee_id,
                employee.Agency as empAgency
                FROM tbl_missedpunch_update,patient,employee,supervisor

                WHERE (patient.patient_id = tbl_missedpunch_update.client_id AND tbl_missedpunch_update.employee_id = employee.employee_id) AND DATE(timestamp) >='$fromD' AND DATE(timestamp) <='$fromD' AND patient.supervisor_id='$supervisorId' GROUP BY patient_id ORDER BY tbl_missedpunch_update.id ASC ";
                $mispunchUpdateDataBySup = $this->Comman_model->getCustomQueryData($MySQLALL);
                $empArr = [];
                $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
                foreach ($mispunchUpdateDataBySup as $key => $row1) {
                  if(!in_array($row1['employee_id'], $empArr)) {
                    array_push($empArr, $row1['employee_id']);
                    if($row1['empAgency']==1) {
                        $empHomeMakers++;
                    }
                    if($row1['empAgency']==2) {
                        $empSeniorcare++;
                    }
                    if($row1['empAgency']==3) {
                        $caregivers++;
                    }
                    if($row1['empAgency']==4) {
                        $rockford++;
                    }
                  }
                }

                $total_employee = 'Homemakers: '.$empHomeMakers.'<br>';
                $total_employee .= 'Seniorcare: '.$empSeniorcare.'<br>';
                $total_employee .= 'Caregivers: '.$caregivers.'<br>';
                $total_employee .= 'Rockford: '.$rockford.'<br>';

                if(count($empArr)>0) {
                  $where = [];
                  $where['agency_location_code'] = $row['agency_location'];
                  $locationData = $this->Comman_model->get_row('agency_location', $where);

                  $where = [];
                  $where['agency_code'] = $row['Agency'];
                  //$where['agency_code'] = $agency_code;              
                  $agencyData = $this->Comman_model->get_row('agency', $where);

                  $dataArray = [];
                  $dataArray['transaction_date'] = $fromD;
                  $dataArray['supervisor'] = $row['name'];
                  $dataArray['supervisor_id'] = $row['supervisor_id'];
                  $dataArray['agency'] = $agencyData['agency_codename'];
                  $dataArray['agency_id'] = $row['Agency'];
                  //$dataArray['agency_id'] = $agency_code;
                  $dataArray['location_id'] = $row['agency_location'];
                  $dataArray['location'] = $locationData['agency_location_name'];
                  $dataArray['total_employee_sup'] = count($empArr);
                  $dataArray['total_employee'] = $total_employee;

                  $this->Comman_model->insert('mispunch_update_tracking', $dataArray);
                  $this->session->set_flashdata('message', 'Record has been added successfully.');
                }
              }



              /************** Agency Wise EMployees *****************/
              $this->db->where('transaction_date',$fromD);
              $this->db->delete('mispunch_update_tracking_employee');

              $where = [];
              $allAgencyData = $this->Comman_model->get_rows('agency', $where);

              foreach ($allAgencyData as $key => $row) {

                $agencyCode = $row['agency_code'];

                $MySQLALL = "
                SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
                tbl_missedpunch_update.employee_id,
                employee.Agency as empAgency
                FROM tbl_missedpunch_update,patient,employee

                WHERE (patient.patient_id = tbl_missedpunch_update.client_id AND tbl_missedpunch_update.employee_id = employee.employee_id) AND DATE(timestamp) >='$fromD' AND DATE(timestamp) <='$fromD' AND employee.Agency='$agencyCode' GROUP BY patient_id ORDER BY tbl_missedpunch_update.id ASC ";
                $mispunchUpdateDataBySup = $this->Comman_model->getCustomQueryData($MySQLALL);
                $empArr = [];
                $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
                foreach ($mispunchUpdateDataBySup as $key => $row1) {
                  if(!in_array($row1['employee_id'], $empArr)) {
                    array_push($empArr, $row1['employee_id']);
                  }
                }


                if(count($empArr)>0) {

                  $where = [];
                  $where['agency_code'] = $agencyCode;
                  $agencyData = $this->Comman_model->get_row('agency', $where);

                  $dataArray = [];
                  $dataArray['transaction_date'] = $fromD;
                  $dataArray['agency'] = $row['agency_codename'];
                  $dataArray['agency_id'] = $agencyCode;
                  $dataArray['total_employee'] = count($empArr);

                  $this->Comman_model->insert('mispunch_update_tracking_employee', $dataArray);
                  $this->session->set_flashdata('message', 'Record has been added successfully.');
                }
              }

            }




            //$sql = "SELECT * FROM tbl_missedpunch_update";
            //$data['mispunchData'] = $this->Comman_model->getCustomQueryData($sql);

            /*if ($_GET['formSubmit'] == 'CheckALL' && !empty($_GET['search'])) {
                if(!empty($data['employeeClockData'])) {
                    foreach ($data['employeeClockData'] as $key => $row) {
                        $rec_id = $row['employee_clock_id'];
                        $_SESSION['rxx'][$rec_id]  = 'Yes';  
                    }
                }
            }

            if ($_GET['formSubmit']=='Uncheck') {
                unset($_SESSION['rxx']);
            }

            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['employee_id'] = $employee_id;
            $data['search'] = $_GET['search'];*/

            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location','','agency_location_name','asc');
            if(isset($_GET['location']) && !empty($_GET['location'])) {
                $location = base64_decode($_GET['location']);

                $where = [];
                $where['su.firstname!='] ='';
                $where['su.agency_location'] = $location;
                $data['supervisorData'] = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');
            }

            $data['suplid'] =   $_GET['suplid'];
            $data['fromD']  =   $fromD;
            $data['toD']    =   $toD;




            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/missedpunch-view.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    function mobileUsers() {
        if(isset($_SESSION['name'])) {

            if(!empty($_GET['fromD'])) {
                $fromD  = date('Y-m-d', strtotime($_GET['fromD']));    
            } else {
                $fromD  = date('Y-m-d');     
            }

            if(!empty($_GET['toD'])) {
                $toD  = date('Y-m-d', strtotime($_GET['toD']));    
            } else {
                $toD    = date('Y-m-d');    
            }

            $cond   = '';
            $data['mobileUserData'] = '';
            if(!empty($_GET['search'])) {

            }            

            $data = [];
            $data['allMobileusersData'] = '';

            $where = [];
            $where['su.firstname!='] = '';
            $where['su.supervisor_id!='] = 0;
            $allSupervisorData = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');
            foreach ($allSupervisorData as $key => $row) {
                $supervisorId = $row['supervisor_id'];
                $sql = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(employee_clock_id), employee_clock.tagedit,employee_clock.date,employee_clock.employee_id,employee_clock.patient_id, employee.Agency as empAgency FROM employee_clock,patient,employee WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id) AND DATE(date) >='$fromD' AND DATE(date) <='$toD' AND tagedit IN (4,6,7) AND patient.supervisor_id='$supervisorId' ORDER BY employee_clock.employee_clock_id ASC";
                $mobileUserData = $this->Comman_model->getCustomQueryData($sql);
                $empArr = [];
                $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
                $android = $webapp = $ios = 0;
                foreach ($mobileUserData as $key1 => $row1) {
                  if(!in_array($row1['employee_id'], $empArr)) {
                    array_push($empArr, $row1['employee_id']);

                    if($row1['tagedit']==4) {
                        $android++;
                    }
                    if($row1['tagedit']==6) {
                        $ios++;
                    }
                    if($row1['tagedit']==7) {
                        $webapp++;
                    }
                  }
                }

                if(count($empArr)>0) {
                  $where = [];
                  $where['agency_location_code'] = $row['agency_location'];
                  $locationData = $this->Comman_model->get_row('agency_location', $where);

                  $where = [];
                  $where['agency_code'] = $row['Agency'];
                  $agencyData = $this->Comman_model->get_row('agency', $where);

                  $data['allMobileusersData'][$key]['transaction_date'] = $toD;
                  $data['allMobileusersData'][$key]['supervisor'] = $row['name'];
                  $data['allMobileusersData'][$key]['supervisor_id'] = $row['supervisor_id'];
                  $data['allMobileusersData'][$key]['agency'] = $agencyData['agency_codename'];
                  $data['allMobileusersData'][$key]['agency_id'] = $row['Agency'];
                  $data['allMobileusersData'][$key]['location_id'] = $row['agency_location'];
                  $data['allMobileusersData'][$key]['location'] = $locationData['agency_location_name'];
                  $data['allMobileusersData'][$key]['total_employee_sup'] = count($empArr);
                  $data['allMobileusersData'][$key]['total_employee'] = $total_employee;
                  $data['allMobileusersData'][$key]['android'] = $android;
                  $data['allMobileusersData'][$key]['ios'] = $ios;
                  $data['allMobileusersData'][$key]['webapp'] = $webapp;
                }
            }

            if($_GET['btnAdd']=='Add Record') {

                  $this->db->where('transaction_date',$toD);
                  $this->db->delete('employee_mobileusers_tracking');

                  $where = [];
                  $where['su.firstname!='] = '';
                  $where['su.supervisor_id!='] = 0;
                  $allSupervisorData = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');

                  $empHomeMakersAll = $empSeniorcareAll = $empCaregiversAll = $empRockfordAll = 0;
                  foreach ($allSupervisorData as $key => $row) {

                    $supervisorId = $row['supervisor_id'];

                    /*$MySQLALL = "
                    SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
                    tbl_missedpunch_update.employee_id,
                    employee.Agency as empAgency
                    FROM tbl_missedpunch_update,patient,employee,supervisor

                    WHERE (patient.patient_id = tbl_missedpunch_update.client_id AND tbl_missedpunch_update.employee_id = employee.employee_id) AND DATE(timestamp) >='$fromD' AND DATE(timestamp) <='$fromD' AND patient.supervisor_id='$supervisorId' GROUP BY patient_id ORDER BY tbl_missedpunch_update.id ASC ";*/


                    $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(employee_clock_id), employee_clock.tagedit,employee_clock.date,employee_clock.employee_id,employee_clock.patient_id, employee.Agency as empAgency FROM employee_clock,patient,employee WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id) AND DATE(date) >='$fromD' AND DATE(date) <='$toD' AND tagedit IN (4,6,7) AND patient.supervisor_id='$supervisorId' ORDER BY employee_clock.employee_clock_id ASC";

                    $mobileUserDataBySup = $this->Comman_model->getCustomQueryData($MySQLALL);
                    $empArr = [];
                    $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
                    $android = $webapp = $ios = 0;
                    foreach ($mobileUserDataBySup as $key => $row1) {
                      if(!in_array($row1['employee_id'], $empArr)) {
                        array_push($empArr, $row1['employee_id']);
                        /*if($row1['empAgency']==1) {
                            $empHomeMakers++;
                        }
                        if($row1['empAgency']==2) {
                            $empSeniorcare++;
                        }
                        if($row1['empAgency']==3) {
                            $caregivers++;
                        }
                        if($row1['empAgency']==4) {
                            $rockford++;
                        }*/

                        if($row1['tagedit']==4) {
                            $android++;
                        }
                        if($row1['tagedit']==6) {
                            $ios++;
                        }
                        if($row1['tagedit']==7) {
                            $webapp++;
                        }
                      }
                    }

                    /*$total_employee = 'Homemakers: '.$empHomeMakers.'<br>';
                    $total_employee .= 'Seniorcare: '.$empSeniorcare.'<br>';
                    $total_employee .= 'Caregivers: '.$caregivers.'<br>';
                    $total_employee .= 'Rockford: '.$rockford.'<br>';*/

                    if(count($empArr)>0) {
                      $where = [];
                      $where['agency_location_code'] = $row['agency_location'];
                      $locationData = $this->Comman_model->get_row('agency_location', $where);

                      $where = [];
                      $where['agency_code'] = $row['Agency'];
                      $agencyData = $this->Comman_model->get_row('agency', $where);

                      $dataArray = [];
                      $dataArray['transaction_date'] = $toD;
                      $dataArray['supervisor'] = $row['name'];
                      $dataArray['supervisor_id'] = $row['supervisor_id'];
                      $dataArray['agency'] = $agencyData['agency_codename'];
                      $dataArray['agency_id'] = $row['Agency'];
                      $dataArray['location_id'] = $row['agency_location'];
                      $dataArray['location'] = $locationData['agency_location_name'];
                      $dataArray['total_employee'] = count($empArr);
                      $dataArray['android_user'] = $android;
                      $dataArray['ios_user'] = $ios;
                      $dataArray['webapp_user'] = $webapp;
                      //$dataArray['total_employee'] = $total_employee;

                      $this->Comman_model->insert('employee_mobileusers_tracking', $dataArray);
                      $this->session->set_flashdata('message', 'Record has been added successfully.');
                    }
                }

                /************** Agency Wise Employees *****************/
                $this->db->where('transaction_date',$toD);
                $this->db->delete('mobile_user_tracking_employee');

                $where = [];
                $allAgencyData = $this->Comman_model->get_rows('agency', $where);
                foreach ($allAgencyData as $key => $row) {
                    $agencyCode = $row['agency_code'];
                    /*$MySQLALL = "
                    SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
                    tbl_missedpunch_update.employee_id,
                    employee.Agency as empAgency
                    FROM tbl_missedpunch_update,patient,employee

                    WHERE (patient.patient_id = tbl_missedpunch_update.client_id AND tbl_missedpunch_update.employee_id = employee.employee_id) AND DATE(timestamp) >='$fromD' AND DATE(timestamp) <='$fromD' AND employee.Agency='$agencyCode' GROUP BY patient_id ORDER BY tbl_missedpunch_update.id ASC ";*/

                    $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(employee_clock_id), employee_clock.tagedit,employee_clock.date,employee_clock.employee_id,employee_clock.patient_id, employee.Agency as empAgency FROM employee_clock,patient,employee WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id) AND DATE(date) >='$fromD' AND DATE(date) <='$toD' AND tagedit IN (4,6,7) AND employee.Agency='$agencyCode' ORDER BY employee_clock.employee_clock_id ASC";

                    $mobileUserDataByEmployee = $this->Comman_model->getCustomQueryData($MySQLALL);
                    $empArr = [];
                    $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
                    $android = $webapp = $ios = 0;
                    foreach ($mobileUserDataByEmployee as $key1 => $row1) {
                        if(!in_array($row1['employee_id'], $empArr)) {
                            array_push($empArr, $row1['employee_id']);
                            if($row1['tagedit']==4) {
                                $android++;
                            }
                            if($row1['tagedit']==6) {
                                $ios++;
                            }
                            if($row1['tagedit']==7) {
                                $webapp++;
                            }
                        }
                    }

                    if(count($empArr)>0) {
                        $where = [];
                        $where['agency_code'] = $agencyCode;
                        $agencyData = $this->Comman_model->get_row('agency', $where);

                        $dataArray = [];
                        $dataArray['transaction_date'] = $toD;
                        $dataArray['agency'] = $row['agency_codename'];
                        $dataArray['agency_id'] = $agencyCode;
                        $dataArray['total_employee'] = count($empArr);
                        $dataArray['android_user'] = $android;
                        $dataArray['ios_user'] = $ios;
                        $dataArray['webapp_user'] = $webapp;

                        $this->Comman_model->insert('mobile_user_tracking_employee', $dataArray);
                        $this->session->set_flashdata('message', 'Record has been added successfully.');
                    }
                }
                /************** Agency Wise Employees End*****************/


                /************** Agency Location Wise Employees *****************/
                $this->db->where('transaction_date',$toD);
                $this->db->delete('mobile_location_user_tracking_employee');

                $where = [];
                $allAgencyLocationData = $this->Comman_model->get_rows('agency_location', $where);
                foreach ($allAgencyLocationData as $key => $row) {
                    $agencyLocationCode = $row['agency_location_code'];

                    $MySQLALL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(employee_clock_id), employee_clock.tagedit,employee_clock.date,employee_clock.employee_id,employee_clock.patient_id, employee.Agency as empAgency FROM employee_clock,patient,employee WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id) AND DATE(date) >='$fromD' AND DATE(date) <='$toD' AND tagedit IN (4,6,7) AND employee.agency_location='$agencyLocationCode' ORDER BY employee_clock.employee_clock_id ASC";

                    $mobileUserDataByEmployee = $this->Comman_model->getCustomQueryData($MySQLALL);
                    $empArr = [];
                    $empHomeMakers = $empSeniorcare = $caregivers = $rockford = 0;
                    $android = $webapp = $ios = 0;
                    foreach ($mobileUserDataByEmployee as $key1 => $row1) {
                        if(!in_array($row1['employee_id'], $empArr)) {
                            array_push($empArr, $row1['employee_id']);
                            if($row1['tagedit']==4) {
                                $android++;
                            }
                            if($row1['tagedit']==6) {
                                $ios++;
                            }
                            if($row1['tagedit']==7) {
                                $webapp++;
                            }
                        }
                    }

                    if(count($empArr)>0) {
                        /*$where = [];
                        $where['agency_code'] = $agencyLocationCode;
                        $agencyData = $this->Comman_model->get_row('agency', $where);*/

                        $dataArray = [];
                        $dataArray['transaction_date'] = $toD;
                        $dataArray['location'] = $row['agency_location_name'];
                        $dataArray['location_id'] = $agencyLocationCode;
                        $dataArray['total_employee'] = count($empArr);
                        $dataArray['android_user'] = $android;
                        $dataArray['ios_user'] = $ios;
                        $dataArray['webapp_user'] = $webapp;

                        $this->Comman_model->insert('mobile_location_user_tracking_employee', $dataArray);
                        $this->session->set_flashdata('message', 'Record has been added successfully.');
                    }
                }
                /************** Agency Location Wise Employees End*****************/
            }

            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location','','agency_location_name','asc');
            if(isset($_GET['location']) && !empty($_GET['location'])) {
                $location = base64_decode($_GET['location']);

                $where = [];
                $where['su.firstname!='] ='';
                $where['su.agency_location'] = $location;
                $data['supervisorData'] = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');
            }

            $data['suplid'] =   $_GET['suplid'];
            $data['fromD']  =   $fromD;
            $data['toD']    =   $toD;

            $view = 1;
            if(!empty($_GET['view'])) {
                $view = $_GET['view'];
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');            
            if($view==1) {
                $this->load->view('employee/mobile-user-view.php',$data);
            }
            if($view==2) {
                $mysql = "SELECT * FROM mobile_user_tracking_employee order by id desc";
                $data['mobileUserData'] = $this->Comman_model->getCustomQueryData($mysql);
                $this->load->view('employee/mobile-user-employee-view',$data);
            }
            if($view==3) {
                $mysql = "SELECT * FROM mobile_location_user_tracking_employee order by id desc";
                $data['mobileUserData'] = $this->Comman_model->getCustomQueryData($mysql);
                $this->load->view('employee/mobile-user-employee-location-view',$data);
            }
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    function mispunchUpdateTracking() {
      if(isset($_SESSION['name'])) {

        $view = $_GET['view'];


        $data = [];
        if($view==1) {
            $mysql = "SELECT * FROM mispunch_update_tracking order by id desc";    
        }
        if($view==2) {
            $mysql = "SELECT * FROM mispunch_update_tracking_employee order by id desc";
        }        
        $data['mispunchData'] = $this->Comman_model->getCustomQueryData($mysql);

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        if($view==1) {
            $this->load->view('timesheet/mispunch-update-tracking-view',$data);
        }
        if($view==2) {
            $this->load->view('timesheet/agency-mispunch-update-tracking-view',$data);
        }
        $this->load->view('common/footer.php');
      } else {
        redirect();
      } 
    }


    function mispunchUpdateManually() {
        if(isset($_SESSION['name'])) {

            $fromD  = date('Y-m-d');
            $toD    = date('Y-m-d');
            $cond = ' AND isIn=2 AND rec_id IS NOT NULL AND (tagedit=4 OR tagedit=6 OR tagedit=7) AND upload_time>date';
            $data['employeeClockData'] = '';
            if(!empty($_GET['search'])) {
                if(!empty($_GET['fromD'])) {
                    $fromD  = date('Y-m-d', strtotime($_GET['fromD']));    
                }                
                if(!empty($_GET['toD'])) {
                    $toD  = date('Y-m-d', strtotime($_GET['toD']));    
                }

                if(!empty($_GET['agency'])) {
                    $agency = $_GET['agency'];
                    $cond .= " AND employee.Agency='".$agency."'";
                }

                if(!empty($_GET['employee_id'])) {
                    $employee_id = $_GET['employee_id'];
                    $cond .= " AND employee_id='".$employee_id."'";
                }

                if(!empty($_GET['tagedit'])) {
                    $tagedit = $_GET['tagedit'];
                    $cond .= " AND employee_clock.tagedit='".$tagedit."'";
                }

                //$sql = "SELECT * FROM employee_clock WHERE DATE(date) BETWEEN '$fromD' AND '$toD'".$cond;
                $sql = "SELECT * FROM employee_clock INNER JOIN employee ON employee_clock.employee_id = employee.employee_id WHERE DATE(date) BETWEEN '$fromD' AND '$toD'".$cond;
                $data['employeeClockData'] = $this->Comman_model->getCustomQueryData($sql);
            }            

            //$sql = "SELECT * FROM tbl_missedpunch_update";
            //$data['mispunchData'] = $this->Comman_model->getCustomQueryData($sql);

            if ($_GET['formSubmit'] == 'CheckALL' && !empty($_GET['search'])) {
                if(!empty($data['employeeClockData'])) {
                    foreach ($data['employeeClockData'] as $key => $row) {
                        $rec_id = $row['employee_clock_id'];
                        $_SESSION['rxx'][$rec_id]  = 'Yes';  
                    }
                }
            }

            if ($_GET['formSubmit']=='Uncheck') {
                unset($_SESSION['rxx']);
            }

            if($_GET['updateTimesheet']=='updateTimesheet') {
                if(empty($_SESSION['rxx'])) {
                    $alert = "<script>alert('Please select record to update.')</script>";
                } else {
                    $this->session->set_flashdata('message','Record has been added successfully.');
                }                
            }

            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']    =   date('m/d/Y', strtotime($toD));
            $data['alert']  =   $alert;
            $data['search'] =   $_GET['search'];
            $data['agency'] =   $_GET['agency'];
            $data['tagedit'] =   $_GET['tagedit'];

            $sql = "SELECT * FROM agency";
            $data['agencyData'] = $this->Comman_model->getCustomQueryData($sql);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/missedpunch-update-view.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function employeeClockReportEmployeeFilter() {
        if(isset($_SESSION['name'])) {

            /********************************/
            $cond1 = $cond2 = $cond3 = "";
            //$cond1 = " AND Status = '1'";
            $agency_code = $this->session->userdata('agency');
            $cond1 = " AND employee.Agency = '$agency_code'";
            if(isset($_GET['dob']) && $_GET['dob']!='') {
                $dd = $_GET['dob']; 
                $cond1 .= " AND Birthdate = '$dd'";   
            }

            if(!empty($_GET['searchEmployee'])) {
               $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                            employee.employee_id,
                            employee.lastname AS empl_lastname,
                            employee.firstname AS empl_firstname,
                            employee.agency_location,
                            employee.mobile,
                            employee.phone,
                            employee.useradd,
                            employee.userdate,
                            employee.pin,
                            employee.Status,
                            employee.flag,
                            employee.newHire,
                            employee.Agency,
                            employee.name,
                            employee.popalert,
                            employee.popnotes,
                            employee.supervisor_id,
                            employee.ssn,
                            employee.directdeposit,
                            employee.dementia,
                            employee.covid_vax,
                            employee.Birthdate as empDob,
                            employee.EmployeeAddressPostalCode,
                            supervisor.firstname AS sup_firstname, 
                            supervisor.name AS sup_name,
                            supervisor.lastname AS sup_lastname     
                            FROM employee,supervisor WHERE supervisor.supervisor_id = employee.supervisor_id AND
                            employee.pin LIKE '%".@$_GET['pin2']."%' AND 
                            employee.employee_id LIKE '%".@$_GET['employee_id2']."%' AND 
                            employee.EmployeeAddressPostalCode LIKE '%".@$_GET['zipcode2']."%' AND 
                            employee.firstname LIKE '%".@$_GET['firstname2']."%' AND employee.lastname LIKE '%".@$_GET['lastname2']."%' AND employee.ssn LIKE '%".@$_GET['ssn']."%' 
                            ".$cond1.$cond2.$cond3.$cond4.$cond5." ";
                            //ORDER BY ".$sortorder." ".$desc."    LIMIT " .$from. ", " .$to . " "; 

                $data['employeeData'] = $this->employee->getCustomQueryData($MySQL);  
            }   
            /********************************/
            $fromD  = date('Y-m-d');
            $toD    = date('Y-m-d');
            $cond = ' AND isIn=1 AND rec_id IS NOT NULL';
            $data['employeeClockData'] = '';
            if(!empty($_GET['search'])) {
                if(!empty($_GET['fromD'])) {
                    $fromD  = date('Y-m-d', strtotime($_GET['fromD']));    
                }                
                if(!empty($_GET['toD'])) {
                    $toD  = date('Y-m-d', strtotime($_GET['toD']));    
                }

                if(!empty($_GET['employee_id'])) {
                    $employee_id = $_GET['employee_id'];
                    $cond .= " AND employee_id='".$employee_id."'";
                }       

                $sql = "SELECT * FROM employee_clock WHERE DATE(date) BETWEEN '$fromD' AND '$toD'".$cond;
                $data['employeeClockData'] = $this->Comman_model->getCustomQueryData($sql);
            }            

            if ($_GET['formSubmit'] == 'CheckALL' && !empty($_GET['search'])) {
                if(!empty($data['employeeClockData'])) {
                    foreach ($data['employeeClockData'] as $key => $row) {
                        $rec_id = $row['employee_clock_id'];
                        $_SESSION['rxx'][$rec_id]  = 'Yes';  
                    }
                }
            }

            if ($_GET['formSubmit']=='Uncheck') {
                unset($_SESSION['rxx']);
            }

            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['employee_id'] = $employee_id;
            $data['search'] = $_GET['search'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/employee-clock-report-new.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    
    public function delete_Employee() {
        $id = $this->input->get('employee_id');
        $data = $this->db->where('employee_id',$id)->delete('employee');
        if($data) {

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user delete employee id '.$id.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################

            $this->session->set_flashdata('message','Employee deleted successfully.');
            redirect('employee');
        } else {
            $this->session->set_flashdata('message','Somthing Went Wrong');
            redirect('employee');
        }
    }


    public function copyProfileToAgency() {

        $postData = $this->input->post();
        $userid = $postData['pid']; 
        $newagency = $postData['newag'];
        $usrag = '';

        $cols=array();
        $result = "SHOW COLUMNS FROM employee";

        $result = $this->employee->getCustomQueryData($result);

        foreach ($result as $key => $r) {
            if (!in_array($r["Field"],array("employee_id","Agency","mobile","pin","sms","supervisor_id","VisitationNotes","AssignedStaffingCoordinator","StateLic","upsize_ts","ADP","supervisor_id2","supervisor_id3"))) {
                $cols[]= $r["Field"];
            } 
        }

        //print_r($cols);die;

        $result = "SELECT * FROM employee WHERE employee_id='".$userid."'";
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {    
            $usrag = $r['Agency'];
            $mob = $r['mobile']==''?"' '":"'".$r['mobile']."'";
            $pn = $r['pin']==''?'':$r['pin'];
            $sms = $r['sms']==''?"' '":"'".$r['sms']."'";
            $supid = $r['supervisor_id']==''?"' '":"'".$r['supervisor_id']."'";
            $vsnote = $r['VisitationNotes']==''?"' '":"'".$r['VisitationNotes']."'";
            $ascoor = $r['AssignedStaffingCoordinator']==''?"' '":"'".$r['AssignedStaffingCoordinator']."'";
            $stl = $r['StateLic']==''?"' '":"'".$r['StateLic']."'";
            $upsts = $r['upsize_ts']==''?"' '":"'".$r['upsize_ts']."'";    


            $dataArray = [];
            $dataArray['Agency'] = $newagency;
            $dataArray['mobile'] = $mob;
            $dataArray['pin'] = $pn;
            $dataArray['sms'] = $sms;
            //$dataArray['supervisor_id'] = $supid;
            $dataArray['VisitationNotes'] = $vsnote;
            $dataArray['AssignedStaffingCoordinator'] = $ascoor;
            $dataArray['StateLic'] = $stl;
            $dataArray['upsize_ts'] = $upsts;

            //print_r($dataArray);die;
            $count=count($cols);
            foreach($cols as $counter=>$col) {
                $dataArray[$col] = $r[$col]=='' ? 'NULL' : $r[$col];
            }

            $newuserid = $this->Comman_model->insert('employee', $dataArray);
            
        }

        /*$cols = array();
        $result = "SHOW COLUMNS FROM employee_assignment"; 
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {
            if (!in_array($r["Field"],array("employee_id"))) {
                $cols[]= $r["Field"];
            } 
        }

        $result = "SELECT * FROM employee_assignment WHERE employee_id='".$userid."'";
        $result = $this->employee->getCustomQueryData($result);
        foreach ($result as $key => $r) {

            $dataArray = [];
            $dataArray['employee_id'] = $newuserid;
            $count=count($cols);
            foreach($cols as $counter=>$col) {
                $dataArray[$col] = $r[$col]=='' ? 'NULL' : $r[$col];
            }

            $insertId = $this->Comman_model->insert('employee_assignment', $dataArray);
        }  */

        /*$dataArray = [];
        $dataArray['Status'] = 3;
        $where = [];
        $where['employee_id'] = $userid;
        $update = $this->Comman_model->update('employee', $where, $dataArray);*/

        $where = [];
        $where['employee_id'] = $userid;
        $employeeData = $this->Comman_model->get_row('employee', $where);

        //migrate image too
        $filename = FCPATH."image/emp_image/".$employeeData['emp_image'];
        $newfilename = 'E'.$newuserid.'.jpg';
        if(file_exists($filename)) {
            if(!copy($filename,FCPATH.'image/emp_image/'.$newfilename)){
                //die('unable to copy');    
            }            
        }

        $dataArray = [];
        $dataArray['emp_image'] = $newfilename;
        $where = [];
        $where['employee_id'] = $newuserid;
        $update = $this->Comman_model->update('employee', $where, $dataArray);

        ############### USER ACTION TRACKING START ####################
        if($this->session->userdata('id')!=6) {
            $dataArray = [];
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['user_action'] = $this->session->userdata('name'). ' user copy profile employee id '.$userid.' at '. date('m/d/Y H:i:s');
            $this->Comman_model->insert('users_tracking', $dataArray);    
        }
        ############### USER ACTION TRACKING END ####################

        echo 'success';
    }

    public function history() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $where  = [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            /*$where= [];
            $where['patient_id'] = $_GET['patient'];
            $data['patientVisitData'] = $this->Comman_model->get_rows('tblemployeservicetraining', $where);
            $data['patient_id'] =  $_GET['patient']; */

            $limit = 5;
            if(!empty($this->input->post('limit'))) {
              $limit = $this->input->post('limit');  
            }

            $where  = [];
            $where['puh.employee_id'] = $_GET['employee'];
            $data['patientHistoryData']    =   $this->Comman_model->getEmployeeHistory($where, $limit);

            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

            $where = [];
            $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $where = [];
            $data['agencyLocation'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $data['agencyAll'] = $this->Comman_model->get_rows('agency', $where);

            $data['limit'] = $limit;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/history.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function support() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $where  = [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            $where = [];
            $where['employee_id'] = $_GET['employee'];
            $data['supportData'] = $this->Comman_model->get_rows('tbl_connection_info', $where, 'timestamp', 'DESC');

            $where = [];
            $data['employeeTaskData'] = $this->Comman_model->get_rows('employee_tasks', $where, 'task_code', 'asc');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/support.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function missedPunchUpdate() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $where  = [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            $where = [];
            $where['employee_id'] = $_GET['employee'];
            $data['missedPunchData'] = $this->Comman_model->get_rows('tbl_missedpunch_update', $where);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/missedpunch-update.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    function verifySupportDetails() {
        if(!empty($_POST['updateId'])) {
            $where = [];
            $where['id'] = $_POST['updateId'];

            $zeroHourData = $this->Comman_model->get_row('tbl_connection_info', $where);

            $dataArray = [];
            if($zeroHourData['verify']==0) {
                $dataArray['verify'] = 1;
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['verify_datetime'] = date('Y-m-d h:i:s a');
            } else {
                $dataArray['verify'] = 0;    
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['verify_datetime'] = date('Y-m-d h:i:s a');
            }            
            $this->Comman_model->update('tbl_connection_info', $where, $dataArray);
            print_r(1);
        } else {
            print_r(2);
        }
    }


    function testDatetime() {
        echo date('Y-m-d h:i:s');
    }


    function verifyMissedPunchDetails() {
        if(!empty($_POST['updateId'])) {
            $where = [];
            $where['id'] = $_POST['updateId'];

            $zeroHourData = $this->Comman_model->get_row('tbl_missedpunch_update', $where);

            $dataArray = [];
            if($zeroHourData['verify']==0) {
                $dataArray['verify'] = 1;
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['verify_datetime'] = date('Y-m-d h:i:s a');
            } else {
                $dataArray['verify'] = 0;    
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['verify_datetime'] = date('Y-m-d h:i:s a');
            }            
            $this->Comman_model->update('tbl_missedpunch_update', $where, $dataArray);
            print_r(1);
        } else {
            print_r(2);
        }
    }


    public function customReport() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where);

            $where = [];
            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $where['is_supervisor'] = 1;
            $where['lastname!='] = '';
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'name', 'asc');

            if(isset($_POST['search']) && $_POST['search']=='Search') {
                $data['employeeData']    =   $this->client->getEmployeeCustomReport();
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/custom-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function customReport2() {
        if(isset($_SESSION['name'])) {

            $where = [];
            $where['Agency'] = $this->session->userdata('agency');
            $data['districtData'] = $this->Comman_model->get_rows('tbldistricts', $where);

            $where = [];
            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location', $where);

            $where = [];
            $where['is_supervisor'] = 1;
            $where['lastname!='] = '';
            $data['supervisorData'] = $this->Comman_model->get_rows('supervisor', $where, 'name', 'asc');

            if(isset($_POST['search']) && $_POST['search']=='Search') {
                $data['employeeData']    =   $this->client->getEmployeeCustomReport2();
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/custom-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function billedHours() {
        if(isset($_SESSION['name'])) {

            $MySql = "select * from patient where IsActive = 1 and patient_id=2416";
            $result = $this->Comman_model->getCustomQueryData($MySql);
            foreach ($result as $key => $row) {

                $where  =   [];
                $where['agency_location_code'] =   $row['agency_location'];
                $locationData = $this->Comman_model->get_row('agency_location', $where);

                $where  =   [];
                $where['agency_code'] =   $row['Agency'];
                $agencyData = $this->Comman_model->get_row('agency', $where);

                $where = [];
                $where['supervisor_id'] = $row['supervisor_id'];
                $supervisorData = $this->Comman_model->get_row('supervisor', $where);

                $where  =   [];
                $where['DistrictID'] =   $row['DistrictID_Ref'];
                $where['Agency'] =   $row['Agency'];
                $districtData = $this->Comman_model->get_row('tbldistricts', $where);

                //die;
                $fldnum = 0;
                $stat = "";

                $patient = $row['patient_id'];
                $month = '06';

                $start = date('Y-m-d', strtotime('2020-'.$month.'-01'));
                $end = date('Y-m-t', strtotime($start));
                
                

                $chkSQL = "SELECT * FROM employee_2finalsheet where start_date>='".$start."' AND start_date<='".$end."' AND patient_id = '".$patient."' order by employee_2finalsheet_id";  

                //$chkSQL = "SELECT * FROM employee_2finalsheet where patient_id = '".$patient."' AND MONTH(start_date) = '$month' AND YEAR(start_date) = '2020' order by employee_2finalsheet_id";  

                $objExec = $this->Comman_model->getCustomQueryData($chkSQL);

                $dataArray = [];
                $Total = 0;
                foreach ($objExec as $key => $objResult) {

                    $daycnt = 0;
                    $thrsleft = $objResult['total_hrs'];
                    $thrsallow = $objResult['total_allow'];
                    $EmployeeTypeID_Ref = $objResult['service_type'];
                    $TEmployeeTypeID_Ref = $objResult['service_type'];
                    $xserv = $objResult['service_type'];
                    $note1 = $objResult['note1'];

                    $checkBilled = false;
                    
                    $month = $year = '';
                    for ($cal=0; $cal < 14; $cal++) {
                        $ptid = $objResult['patient_id'];
                        $startdate = $objResult['start_date'];
                        $fldnum = $cal + 1;
                        $date = strtotime(date("Y-m-d", strtotime($startdate)) . " + ".$cal."days");
                        $datetrans = date("Y-m-d",$date);
                        if($datetrans>$end) {
                            break;
                        }
                        //echo '<br>';
                        $month = date("m",$date);
                        $year = date("Y",$date);
                        $d =  'd'.sprintf("%02s", $fldnum);
                        $dt =  'date'.sprintf("%02s", $fldnum);
                        $arr[$fldnum] = $objResult[$d];
                        $stat[$fldnum] = "";

                        $chkSQL2 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND total_paid=0";
                        $objResult2 = $this->Comman_model->getCustomQueryData($chkSQL2, 'row');
                        if (!empty($objResult2))  {
                            $stat[$fldnum] = $objResult2['status'];
                            if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                                if ($objResult2['total_paid'] == 0 )  {
                                    $stat[$fldnum] = "Billed";
                                }
                                if ($objResult2['total_paid'] > 0 )  {
                                    $stat[$fldnum] = "Paid";
                                }
                                if ($objResult2['total_paid'] > 0 && $objResult2['remarks'] != '' )  {
                                    $stat[$fldnum] = "Rejected";
                                }
                           }
                        } else {
                            $chkSQL3 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS null AND total_paid=0";
                            $objResult3 = $this->Comman_model->getCustomQueryData($chkSQL3, 'row');

                            $stat[$fldnum] = $objResult3['status'];
                            if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                               $stat[$fldnum] == 'Pending';
                            }  

                            $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                            $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');
                            if (!empty($objResult4)) { 
                                $stat[$fldnum] = $objResult4['status'];
                            } 
                            $chkSQL5 = "SELECT * FROM eclaims_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans' AND status = 'Billed'";
                            $objResult5 = $this->Comman_model->getCustomQueryData($chkSQL5, 'row');
                            if(!empty($objResult5) )  { 
                                $stat[$fldnum] = $objResult5['status'];
                            } 
                            $month = date("m",strtotime($datetrans));
                            $year = date("Y",strtotime($datetrans));
                            $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                            $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');

                            if(!empty($objResult4) )  { 
                                $stat[$fldnum] = $objResult4['status'];
                            }

                            $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Billed'";
                            $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');

                            if (!empty($objResult8) )  { 
                                $stat[$fldnum] = $objResult8['status'];
                            }

                            $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Reverse'";
                               //echo $chkSQL8;
                               $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');
                                   if (!empty($objResult8) )  { 
                                      $stat[$fldnum] = $objResult8['status'];
                                   }        
                        }

                        //echo $stat[$fldnum];

                        //if($stat[$fldnum]=='Billed') {
                            $d = date('d',$date);
                            //echo $d.' ';
                            //echo date('D',$date).' ';
                            //echo date('m',$date).' ';
                            //echo date('Y',$date).' ';
                            //echo $arr[$fldnum].' ';
                            //echo $stat[$fldnum].' ';
                            $checkBilled = true;
                            
                            //$dataArray[$objResult[$dt]] = $arr[$fldnum];
                            if($objResult[$dt]<=$end) {
                                $Total = $Total + $arr[$fldnum];
                                $dataArray['day'.$d] = $arr[$fldnum];
                            }

                            
                        //} else{
                           // continue;
                        //}
                    } 
                    if($checkBilled) {
                        $monthName = date('F', mktime(0, 0, 0, $month, 10));
                        $dataArray['status'] = 'Billed';
                        $dataArray['month'] = $month;
                        $dataArray['month_name'] = $monthName;
                        $dataArray['year'] = $year;
                        $dataArray['total_hrs'] = $Total;                    
                        $dataArray['patient_id'] = $objResult['patient_id'];
                        //$dataArray['employee_id'] = $objResult['employee_id'];
                        $dataArray['Agency'] = $objResult['Agency'];
                        $dataArray['agency_name'] = $agencyData['agency_codename'];
                        $dataArray['ApproveHours'] = $row['HMKRHours'];
                        $dataArray['location'] = $locationData['agency_location_name'];
                        $dataArray['supervisor_id'] = $row['supervisor_id'];
                        $dataArray['supervisor_name'] = $supervisorData['name'];
                        $dataArray['full_hours'] = $districtData['full_hours'];
                        $dataArray['district_id'] = $districtData['DistrictID'];
                        $dataArray['district'] = $districtData['DistrictNumber'].'-'.$districtData['DistrictName'];
                        $dataArray['patient_name'] = $row['name'];
                    }
                }

                if(!empty($dataArray)){
                    //$this->Comman_model->insert('billed_hours_old', $dataArray);
                }
                print_r($dataArray);
            }
            echo 'Done';
        } else {
            redirect();
        }
    }


    public function billedHourSettings() {
        if(isset($_SESSION['name'])) {

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/billed-hours.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function billedHourSettingsFromTo() {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/billed-hours-from-to.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function setBilledHours() {

        $runYear = $this->input->post('year');
        $runMonth = $this->input->post('month');
        $status = $this->input->post('status');

        //echo $runYear.'-'.$runMonth;die;

        if(!empty($runYear) && !empty($runMonth)) {
            $where = [];
            $where['IsActive'] = $status;
            if($status==1) {
                $or_where['IsActive'] = 3;
            }
            if($status==0) {
                $or_where['IsActive'] = 2;
            }
            //$where['patient_id'] = 11185;
            //$patientData = $this->Comman_model->get_rows('patient', $where, '', '', '', '', '', '', $or_where);
            $patientData = $this->Comman_model->get_rows2('patient', $where, $or_where);
            foreach ($patientData as $key => $row) {

                $where = [];
                $where['supervisor_id'] = $row['supervisor_id'];
                $supervisorData = $this->Comman_model->get_row('supervisor', $where);

                $where  =   [];
                $where['DistrictID'] =   $row['DistrictID_Ref'];
                $where['Agency'] =   $row['Agency'];
                $districtData = $this->Comman_model->get_row('tbldistricts', $where);

                $where  =   [];
                $where['agency_code'] =   $row['Agency'];
                $agencyData = $this->Comman_model->get_row('agency', $where);

                $where  =   [];
                $where['agency_location_code'] =   $row['agency_location'];
                $locationData = $this->Comman_model->get_row('agency_location', $where);

                $patientId = $row['patient_id'];
                $patientName = $row['name'];
                $HMKRHours = $row['HMKRHours'];
                $supervisorId = $supervisorData['supervisor_id'];
                $supervisorName = $supervisorData['name'];
                $districtId = $districtData['DistrictID'];
                $district = $districtData['DistrictNumber'].'-'.$districtData['DistrictName'];
                $full_hours = $districtData['full_hours'];
                $location = $locationData['agency_location_name'];
                $locationId = $locationData['agency_location_code'];
                $agency = $row['Agency'];
                $agency_name = $agencyData['agency_codename'];

                if($row['IsActive']==1 || $row['IsActive']==3) {
                    $clientStatus = 'Active';
                } else {
                    $clientStatus = 'Inactive';
                }

                if($agency==1 || $agency==3) {
                    for ($month=$runMonth; $month <=$runMonth ; $month++) { 
                        $this->billedHours13($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);
                    }
                }
                if($agency==2 || $agency==4) {
                    for ($month=$runMonth; $month <=$runMonth ; $month++) { 
                        //$this->billedHours24($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name);
                        $this->billedHours24New($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);
                        
                    }
                }
            }
            $this->session->set_flashdata('message','Billed hours has been saved successfully.');
            redirect('employee/billedHourSettings');
        } else {
            redirect($this->agent->referrer());
        }
    }

    public function setBilledHoursFromTo() {

        $runYear = $this->input->post('year');
        $runMonth = $this->input->post('fromMonth');
        $toMonth = $this->input->post('toMonth');
        $status = $this->input->post('status');

        //echo $runYear.'-'.$runMonth;die;

        if(!empty($runYear) && !empty($runMonth)) {
            $where = [];
            $where['IsActive'] = $status;
            if($status==1) {
                $or_where['IsActive'] = 3;
            }
            if($status==0) {
                $or_where['IsActive'] = 2;
            }
            //$where['patient_id'] = 11185;
            //$patientData = $this->Comman_model->get_rows('patient', $where, '', '', '', '', '', '', $or_where);
            $patientData = $this->Comman_model->get_rows2('patient', $where, $or_where);
            foreach ($patientData as $key => $row) {

                $where = [];
                $where['supervisor_id'] = $row['supervisor_id'];
                $supervisorData = $this->Comman_model->get_row('supervisor', $where);

                $where  =   [];
                $where['DistrictID'] =   $row['DistrictID_Ref'];
                $where['Agency'] =   $row['Agency'];
                $districtData = $this->Comman_model->get_row('tbldistricts', $where);

                $where  =   [];
                $where['agency_code'] =   $row['Agency'];
                $agencyData = $this->Comman_model->get_row('agency', $where);

                $where  =   [];
                $where['agency_location_code'] =   $row['agency_location'];
                $locationData = $this->Comman_model->get_row('agency_location', $where);

                $patientId = $row['patient_id'];
                $patientName = $row['name'];
                $HMKRHours = $row['HMKRHours'];
                $supervisorId = $supervisorData['supervisor_id'];
                $supervisorName = $supervisorData['name'];
                $districtId = $districtData['DistrictID'];
                $district = $districtData['DistrictNumber'].'-'.$districtData['DistrictName'];
                $full_hours = $districtData['full_hours'];
                $location = $locationData['agency_location_name'];
                $locationId = $locationData['agency_location_code'];
                $agency = $row['Agency'];
                $agency_name = $agencyData['agency_codename'];

                if($row['IsActive']==1 || $row['IsActive']==3) {
                    $clientStatus = 'Active';
                } else {
                    $clientStatus = 'Inactive';
                }

                if($agency==1 || $agency==3) {
                    for ($month=$runMonth; $month<=$toMonth; $month++) { 
                        $this->billedHours13($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);
                    }
                }
                if($agency==2 || $agency==4) {
                    for ($month=$runMonth; $month<=$toMonth; $month++) { 
                        //$this->billedHours24($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name);
                        $this->billedHours24New($patientId, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus);                        
                    }
                }
            }
            $this->session->set_flashdata('message','Billed hours has been saved successfully.');
            redirect('employee/billedHourSettings');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function billedHours13($patient, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus) {
        //$patient ='1213';  
        //$month = 6;
        //$agency = 2;   

        $where = [];
        $where['patient_id'] = $patient;
        $where['year'] = $runYear;
        $where['month'] = $month;
        
        $billedData = $this->Comman_model->get_rows('employee_finalsheet', $where);
        if(!empty($billedData)) {
            $total = 0;
            $dataArray = [];
            $monthName = date('F', mktime(0, 0, 0, $month, 10));
            $dataArray['month']  = $month;
            $dataArray['month_name'] = $monthName;
            $dataArray['year']  = $runYear;
            $dataArray['patient_id'] = $patient;
            $dataArray['Agency'] = $agency;
            $dataArray['agency_name'] = $agency_name;
            $dataArray['status'] = 'Billed';
            $dataArray['patient_name'] = $patientName;
            $dataArray['supervisor_name'] = $supervisorName;
            $dataArray['district'] = $district;
            $dataArray['full_hours'] = $full_hours;
            $dataArray['location'] = $location;
            $dataArray['ApproveHours'] = $HMKRHours;
            $dataArray['district_id'] = $districtId;
            $dataArray['supervisor_id'] = $supervisorId;
            $dataArray['location_id'] = $locationId;
            foreach ($billedData as $key => $row) {
                $total = $total + ($row['period1']+$row['period2']);
            }
            $dataArray['total_hrs'] = $total;
            $dataArray['under_over_hours'] = ($HMKRHours-$total);
            $dataArray['client_status'] = $clientStatus;

            /************ DELETE BILLED HOURS START ***************/
            $where = [];
            $where['month'] = $month;
            $where['year'] = $runYear;
            $where['patient_id'] = $patient;
            $this->Comman_model->delete_row('billed_hours_old', $where);
            /************ DELETE BILLED HOURS END ***************/
            
            $this->Comman_model->insert('billed_hours_old', $dataArray);
        }
    }


    public function billedHours24New($patient, $month_para, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear, $clientStatus) {
        //$patient ='1213';  
        //$month = 6;
        //$agency = 2;   

        $where = [];
        $where['patient_id'] = $patient;
        $where['year'] = $runYear;
        $where['month'] = $month_para;
        
        $billedData = $this->Comman_model->get_rows('employee_finalsheet', $where);
        if(!empty($billedData)) {
            $total = 0;
            $dataArray = [];
            $monthName = date('F', mktime(0, 0, 0, $month_para, 10));
            $dataArray['month']  = $month_para;
            $dataArray['month_name'] = $monthName;
            $dataArray['year']  = $runYear;
            $dataArray['patient_id'] = $patient;
            $dataArray['Agency'] = $agency;
            $dataArray['agency_name'] = $agency_name;
            $dataArray['status'] = 'Billed';
            $dataArray['patient_name'] = $patientName;
            $dataArray['supervisor_name'] = $supervisorName;
            $dataArray['district'] = $district;
            $dataArray['full_hours'] = $full_hours;
            $dataArray['location'] = $location;
            $dataArray['ApproveHours'] = $HMKRHours;
            $dataArray['district_id'] = $districtId;
            $dataArray['supervisor_id'] = $supervisorId;
            $dataArray['location_id'] = $locationId;
            foreach ($billedData as $key => $row) {
                $total = $total + ($row['period1']+$row['period2']);

                for ($cal=1; $cal <= 31; $cal++) {
                    $d =  'day'.sprintf("%02s", $cal);
                    $dataArray[$d] = $dataArray[$d] + $row[$d];
                }

            }
            $dataArray['total_hrs'] = $total;
            $dataArray['under_over_hours'] = ($HMKRHours-$total);
            $dataArray['client_status'] = $clientStatus;


            //print_r($dataArray);die;

            /************ DELETE BILLED HOURS START ***************/
            $where = [];
            $where['month'] = $month_para;
            $where['year'] = $runYear;
            $where['patient_id'] = $patient;
            $this->Comman_model->delete_row('billed_hours_old', $where);
            /************ DELETE BILLED HOURS END ***************/
            
            $this->Comman_model->insert('billed_hours_old', $dataArray);
        }
    }




    public function billedHours24($patient, $month, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name) {
      $patientId = $patient;

      $datetrans = date("Y-m-d", mktime(0, 0, 0, $month, 1));

      /*$year = date("Y",strtotime($datetrans)); 
      $month = date("m",strtotime($datetrans)); 
      $tdate = strtotime($year.'-'.$month.'-01');
      $action = 2;

      if ($action ==2) {
        $cutoff = 16;
        $eom = 31;
        $tdate2 = strtotime($year.'-'.$month.'-01');
        $fromdate = date("Y-m-d",$tdate2);
        $todate = date("Y-m-t",$tdate);         
      }*/

      $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE patient_id = '$patientId' AND isIn = 1 AND MONTH(date) = '$month' AND YEAR(date) = '2020' ORDER BY date ";

      $singleViewData = $this->Comman_model->getCustomQueryData($MySQL); 

      $curdate = date('m/d/Y');
      $index = 0;
      $timetotal = 0;
      $billedHour = 0;
      $dataArray =[];
      foreach($singleViewData as $row) {
        //$bgcolor = ""; 
        $timedate = date("Y-m-d",strtotime($row['date'])) ;
        $temp = '';
        $c1 = $row['employee_clock_id'];
        $temp = date('H:i',strtotime($row['date']));

        $latitude = $row['latitude'];
        $task3 = $row['tasks'];
        $task1 = trim($row['ivr_task']);
        $ivr_task = trim($row['tasks']);
        $task2 = "";
        $t = explode(":",$temp );
        $hr1 = $t[0];
        $mn1 = $t[1];
        $fdate = date('Y-m-d',strtotime($row['date']));
        $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

        $disp1 = $hr1 + ($mn1 / 60);
        $tot1 = quarter($disp1);
        $tot1 = number_format($tot1,2);
        $from_time=$tot1;

        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);
        $timein = '';
        if ($orig != 0) { $timein =  date('H:i',strtotime($orig['date'])); }

        $x = '2';
        $rec_id = $row['rec_id'];

        $where = [];
        $where['employee_id'] = $row['employee_id'];
        $where['patient_id'] = $row['patient_id'];
        $where['DATE(date)'] = $timedate;
        $where['isIn'] = $x;
        $where['rec_id'] = $rec_id;
        $rowdate = get_employee_clock($where);

        $to_time=strtotime($rowdate['date']);
        $total = number_format((($to_time - $from_time) / 60) / 60,2);

        $temp = '';
        $c2 = null;
        if ($rowdate != 0 ) {
          $temp = date('H:i',strtotime($rowdate['date'])); $c2 = $rowdate['employee_clock_id']; $task2 = trim($rowdate['ivr_task']); 
        }
        $t = explode(":",$temp );
        $hr2 = $t[0];
        $mn2 = $t[1];
        $fdate = date('Y-m-d',strtotime($rowdate['date']));
        $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

        $disp2 = $hr2 + ($mn2 / 60);
        $tot2 = quarter($disp2);
        $tot2 = number_format($tot2,2);

        $to_time=$tot2;

        if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') || empty($rowdate) )  {
            $total = 0;
        } else {
            $total = $to_time - $from_time;
        }

        $where = [];
        $where['employee_clock_id'] = $c1; 
        $orig = get_employee_clock_history($where);

        $timeout = '';       
        if ($orig != 0) { $timeout =  date('H:i',strtotime($orig['date'])); }
        if ($from_time != null && $to_time != null ) {
          if ($rowdate != 0 )   {
            $timetotal =  $timetotal + quarter(abs($total));    
          } 
        }  

        $billedHour = $billedHour + quarter(abs($total));

      } 

        $dataArray['month'] = $month;
        $dataArray['year'] = 2020;
        $dataArray['Agency'] = $agency;      
        $dataArray['patient_id'] = $patient;
        $dataArray['status'] = 'Billed';
        $dataArray['total_hrs'] = $billedHour;
        $dataArray['patient_name'] = $patientName;
        $dataArray['supervisor_name'] = $supervisorName;
        $dataArray['district'] = $district;
        $dataArray['full_hours'] = $full_hours;
        $dataArray['location'] = $location;
        $dataArray['HMKRHours'] = $HMKRHours;
        $dataArray['district_id'] = $districtId;
        $dataArray['supervisor_id'] = $supervisorId;
        $dataArray['location_id'] = $locationId;
        $dataArray['under_over_hours'] = ($HMKRHours-$billedHour);

        $this->Comman_model->insert('billed_hours', $dataArray);

    }

    public function billedHours24NewOld($patient, $month_para, $agency, $patientName, $supervisorName, $district, $full_hours, $location, $HMKRHours, $districtId, $supervisorId, $locationId, $agency_name, $runYear) {


        

        //die;
        $fldnum = 0;
        $stat = "";

        $start = date('Y-m-d', strtotime($runYear.'-'.$month_para.'-01'));
        $end = date('Y-m-t', strtotime($start));
        //$patient = $row['patient_id'];

        $chkSQL = "SELECT * FROM table_2weekly where end_date>='".$start."' order by table_2weekly_id limit 1";  

        //$chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$start' AND start_date  <= '$start'";

        $row = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
        $start = $row['start_date'];
        //$end = $row['end_date'];

        echo $chkSQL = "SELECT * FROM employee_2finalsheet where start_date>='".$start."' AND start_date<='".$end."' AND patient_id = '".$patient."' order by employee_2finalsheet_id";  
        //$chkSQL = "SELECT * FROM employee_2finalsheet where patient_id = '".$patient."' AND MONTH(start_date) = '$month_para' AND YEAR(start_date) = '2020' order by employee_2finalsheet_id";  

        echo '<br>';

        $objExec = $this->Comman_model->getCustomQueryData($chkSQL);

        $dataArray = [];
        $totalArray = [];
        $Total = 0;
        foreach ($objExec as $key => $objResult) {

            $daycnt = 0;
            $thrsleft = $objResult['total_hrs'];
            $thrsallow = $objResult['total_allow'];
            $EmployeeTypeID_Ref = $objResult['service_type'];
            $TEmployeeTypeID_Ref = $objResult['service_type'];
            $xserv = $objResult['service_type'];
            $note1 = $objResult['note1'];

            $checkBilled = false;
            
            $month = $year = '';
            for ($cal=0; $cal < 14; $cal++) {
                $ptid = $objResult['patient_id'];
                $startdate = $objResult['start_date'];
                $fldnum = $cal + 1;
                $date = strtotime(date("Y-m-d", strtotime($startdate)) . " + ".$cal."days");
                $datetrans = date("Y-m-d",$date);

                if($datetrans>$end) {
                    //break;
                }
                //echo '<br>';
                $month = date("m",$date);
                $year = date("Y",$date);
                $d =  'd'.sprintf("%02s", $fldnum);
                $dt =  'date'.sprintf("%02s", $fldnum);
                $arr[$fldnum] = $objResult[$d];
                $stat[$fldnum] = "";

                $chkSQL2 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS NOT null AND total_paid=0";
                $objResult2 = $this->Comman_model->getCustomQueryData($chkSQL2, 'row');
                if (!empty($objResult2))  {
                    $stat[$fldnum] = $objResult2['status'];
                    if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                        if ($objResult2['total_paid'] == 0 )  {
                            $stat[$fldnum] = "Billed";
                        }
                        if ($objResult2['total_paid'] > 0 )  {
                            $stat[$fldnum] = "Paid";
                        }
                        if ($objResult2['total_paid'] > 0 && $objResult2['remarks'] != '' )  {
                            $stat[$fldnum] = "Rejected";
                        }
                   }
                } else {
                    $chkSQL3 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.servicedate = '$startdate' AND idoadb_details.start_date = '$startdate' AND  idoadb.patient_id = '$ptid' AND idoadb.idoa_id = idoadb_details.idoa_id AND date = '$datetrans' AND batchno IS null AND total_paid=0";
                    $objResult3 = $this->Comman_model->getCustomQueryData($chkSQL3, 'row');

                    $stat[$fldnum] = $objResult3['status'];
                    if ($stat[$fldnum] == '' || $stat[$fldnum] == null)  {
                       $stat[$fldnum] == 'Pending';
                    }  

                    $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                    $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');
                    if (!empty($objResult4)) { 
                        $stat[$fldnum] = $objResult4['status'];
                    } 
                    $chkSQL5 = "SELECT * FROM eclaims_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans' AND status = 'Billed'";
                    $objResult5 = $this->Comman_model->getCustomQueryData($chkSQL5, 'row');
                    if(!empty($objResult5) )  { 
                        $stat[$fldnum] = $objResult5['status'];
                    } 
                    $month = date("m",strtotime($datetrans));
                    $year = date("Y",strtotime($datetrans));
                    $chkSQL4 = "SELECT * FROM cms1500_details WHERE  patient_id = '$ptid' AND employee_id = '$emp'  AND date = '$datetrans'";
                    $objResult4 = $this->Comman_model->getCustomQueryData($chkSQL4, 'row');

                    if(!empty($objResult4) )  { 
                        $stat[$fldnum] = $objResult4['status'];
                    }

                    $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Billed'";
                    $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');

                    if (!empty($objResult8) )  { 
                        $stat[$fldnum] = $objResult8['status'];
                    }

                    $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$ptid' AND eclaims_details.employee_id = '$emp'  AND date = '$datetrans' AND service_type = '$xserv' AND eclaims_details.status = 'Reverse'";
                    //echo $chkSQL8;
                    $objResult8 = $this->Comman_model->getCustomQueryData($chkSQL8, 'row');
                    if (!empty($objResult8) )  { 
                      $stat[$fldnum] = $objResult8['status'];
                    }        
                }

                //echo $stat[$fldnum];

                //if($stat[$fldnum]=='Billed') {
                    $d = date('d',$date);
                    //echo $d.' ';
                    //echo date('D',$date).' ';
                    //echo date('m',$date).' ';
                    //echo date('Y',$date).' ';
                    //echo $arr[$fldnum].' ';
                    //echo $stat[$fldnum].' ';
                    $checkBilled = true;
                    
                    //$dataArray[$objResult[$dt]] = $arr[$fldnum];

                    //echo $objResult[$dt];
                    //echo $end;die;

                    if($objResult[$dt]<$end) {
                        //$Total = $Total + $arr[$fldnum];
                        $dataArray['day'.$d] = $arr[$fldnum];
                        $totalArray['day'.$d] = $arr[$fldnum];

                        echo $d.'=>'.$dataArray['day'.$d].'<br>';
                    }

                    
                //} else{
                   // continue;
                //}
            } 

            //print_r($dataArray);die;

            if($checkBilled) {
                $monthName = date('F', mktime(0, 0, 0, $month_para, 10));
                $dataArray['status'] = 'Billed';
                $dataArray['month'] = $month_para;
                $dataArray['month_name'] = $monthName;
                $dataArray['year'] = $year;
                //$dataArray['total_hrs'] = $Total;                    
                $dataArray['patient_id'] = $patient;
                //$dataArray['employee_id'] = $objResult['employee_id'];
                $dataArray['Agency'] = $agency;
                $dataArray['agency_name'] = $agency_name;
                $dataArray['ApproveHours'] = $HMKRHours;
                $dataArray['location'] = $location;
                $dataArray['supervisor_id'] = $supervisorId;
                $dataArray['supervisor_name'] = $supervisorName;
                $dataArray['full_hours'] = $full_hours;
                $dataArray['district_id'] = $districtId;
                $dataArray['district'] = $district;
                $dataArray['patient_name'] = $patientName;
                $dataArray['location_id'] = $locationId;
                //$dataArray['under_over_hours'] = ($HMKRHours-$Total);
                //$dataArray['Available_Hours'] = ($HMKRHours-$Total);
            }
        }

        if(!empty($dataArray)) {

            //print_r($dataArray);die;

            $Total = array_sum($totalArray);
            $dataArray['total_hrs'] = $Total;
            $dataArray['under_over_hours'] = ($HMKRHours-$Total);

            print_r($dataArray);die;
            /************ DELETE BILLED HOURS START ***************/
            $where = [];
            $where['month'] = $month_para;
            $where['year'] = $year;
            $where['patient_id'] = $patient;
            $this->Comman_model->delete_row('billed_hours_old', $where);
            /************ DELETE BILLED HOURS END ***************/

            /************ INSERT NEW BILLED HOURS START ***************/
            $this->Comman_model->insert('billed_hours_old', $dataArray);
            /************ INSERT NEW BILLED HOURS START ***************/
        }
    }
  
    public function patientHistory() {
        $employee_id = $this->input->get('employee');
        if(isset($_SESSION['name']) && $employee_id!='') {

            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            $fromD  = date('Y-m-d', strtotime("first day of -2 month"));
            $toD    = date('Y-m-d', strtotime('last day of this month'));
            $keyword = '';
            if(!empty($this->input->post('search'))) {
                if(!empty($this->input->post('fromD'))) {
                    $fromD  = date('Y-m-d', strtotime($this->input->post('fromD')));    
                }                
                if(!empty($this->input->post('toD'))) {
                    $toD  = date('Y-m-d', strtotime($this->input->post('toD')));    
                }

                if(!empty($this->input->post('keyword'))) {
                    $keyword = $this->input->post('keyword');
                }       
            }
            
            $data['patientWeeklytData'] = $this->client->get_weekly_discussions($fromD, $toD, $_GET['patient'], $_SESSION['agency'], $keyword, $employee_id);

            $data['patient_id'] =  $_GET['patient']; 
            $data['fromD']  =   date('m/d/Y', strtotime($fromD));
            $data['toD']  =   date('m/d/Y', strtotime($toD));
            $data['keyword'] = $keyword;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/assigned-patient.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function setEmployeeNotes() {
        $employee_id = $this->input->post('employee_id');
        $Notes = $this->input->post('Notes');
        if(isset($_SESSION['name']) && $employee_id!='' && $Notes!='') {

            $sql = "select * from employee_notes_history where employee_id='".$employee_id."' order by id desc limit 1";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');

            $dataArray = [];
            $dataArray['employee_id'] = $employee_id;
            $dataArray['employee_notes'] = $Notes;
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['createdOn'] = date('Y-m-d H:i:s');
            $result = $this->Comman_model->insert('employee_notes_history', $dataArray);
            if($result) {

                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user add notes to employee id '.$employee_id.' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);  

                    ################## Employee Notes Tracking Start ######################
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['old_notes'] = $row['employee_notes'];
                    $dataArray['message'] = $this->session->userdata('name'). ' user add notes to employee id '.$employee_id.' at '. date('m/d/Y H:i:s');
                    $dataArray['new_notes'] = $Notes;
                    $dataArray['change_user_id'] = $employee_id;
                    $dataArray['user_type'] = 'employee';
                    $this->Comman_model->insert('notes_tracking', $dataArray);
                    ################## Employee Notes Tracking End #########################
                }
                ############### USER ACTION TRACKING END ####################

                echo 1;
            } else {
                echo 0;
            }
        } else {
            echo 0;
        }
    }

    public function notesHistory() {
        $employee_id = $this->input->get('employee');
        if(isset($_SESSION['name']) && $employee_id!='') {
            
            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeNotesData'] = $this->Comman_model->get_rows('employee_notes_history', $where, 'id', 'desc');

            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/notes-history.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function deleteNotes($notesId) {
        if(!empty($notesId)) {
            $where = [];
            $where['id'] = $notesId;
            $notesData = $this->Comman_model->get_row('employee_notes_history', $where);
            $data = $this->Comman_model->delete_row('employee_notes_history', $where);
            if($data) {
                ############### USER ACTION TRACKING START ####################
                if($this->session->userdata('id')!=6) {
                    $dataArray = [];
                    $dataArray['user_id'] = $this->session->userdata('id');
                    $dataArray['username'] = $this->session->userdata('name');
                    $dataArray['user_action'] = $this->session->userdata('name'). ' user delete notes from employee id '.$notesData['employee_id'].' at '. date('m/d/Y H:i:s');
                    $this->Comman_model->insert('users_tracking', $dataArray);    
                }
                ############### USER ACTION TRACKING END ####################
                $this->session->set_flashdata('message','Notes has been deleted successfully.');
            } else {
                $this->session->set_flashdata('message','Somthing Went Wrong.');
            }
        } 
        redirect($this->agent->referrer());      
    }

    /*public function getFlag() {
        $where = [];
        $where['Status!=1 and Status!='] = 3;
        $getEmployeeData = $this->Comman_model->get_rows('employee', $where);
        //print_r(count($getEmployeeData));die;
        $x=0;
        foreach ($getEmployeeData as $key => $row) {
            $dataArray = [];
            $dataArray['flag'] = $row['Status'];

            $where = [];
            $where['employee_id'] = $row['employee_id'];

            $this->Comman_model->update('employee', $where, $dataArray);
            $x++;
        }

        echo $x;
    }*/


    public function report() {
        if(isset($_SESSION['name'])) {

            $data = [];

            $agency = $this->session->userdata('agency');

            $where = [];
            $where['em.Status'] = 1;
            $where['pa.IsActive'] = 1;
            $where['em.Agency'] = $agency;
            $where['pa.Agency'] = $agency;
            $where['ea.total_limit'] = 0;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedPatientData'] = $this->employee->getActiveAssignedEmployeeData($where, $like, $not_like);    

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function manualTimesheet() {
        $employee_id = $this->input->get('employee');
        if(isset($_SESSION['name']) && $employee_id!='') {
            
            $csql = "select manual_timesheet_tracking.*, patient.name from manual_timesheet_tracking left join patient on manual_timesheet_tracking.patient_id=patient.patient_id where manual_timesheet_tracking.employee_id='".$employee_id."' order by manual_timesheet_tracking.id desc";
            $data['manualTimesheetData'] = $this->Comman_model->getCustomQueryData($csql);

            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/manual-timesheet.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }


    public function weeklyHourReport() {
        if(isset($_SESSION['name'])) {

            $data = [];

            $agency = $this->session->userdata('agency');

            /*
            $where = [];
            $where['em.Status'] = 1;
            $where['pa.IsActive'] = 1;
            $where['em.Agency'] = $agency;
            $where['pa.Agency'] = $agency;
            if($_GET['workHour'] && $_GET['workHour']==40) {
                $where['ea.total_limit>'] = 40;
            }
            if($_GET['workHour'] && $_GET['workHour']==50) {
                $where['ea.total_limit>'] = 50;
            }
            //$where['ea.total_limit'] = 0;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedPatientData'] = $this->employee->getActiveAssignedEmployeeData2($where, $like, $not_like);
            */


            /*if(isset($_GET['start_date']) && $_GET['start_date']!='') {
                $startDate = $_GET['start_date'];
                $sql = "SELECT employee_id, patient_id FROM employee_2finalsheet WHERE start_date = '".$startDate."'";
                $res = $this->Comman_model->getCustomQueryData($sql);
                if(!empty($res)) {
                    foreach ($res as $key => $row) {
                        $employee_id = $row['employee_id'];
                        $patient_id = $row['patient_id'];

                        $sql = "SELECT ea.*, pa.*, em.ssn, SUM(ea.total_limit) AS total_limit, SUM(ea.compute_current_week_worked_hours) as compute_current_week_worked_hours FROM employee_assignment AS ea, patient AS pa, employee AS em WHERE ea.patient_id = pa.patient_id AND em.employee_id = ea.employee_id AND em.Status = 1 AND pa.IsActive = 1 AND ea.pin NOT LIKE '%+%'";    


                    }
                }
            }*/

            $sql = "SELECT ea.*, pa.*, em.ssn, SUM(ea.total_limit) AS total_limit, SUM(ea.compute_current_week_worked_hours) as compute_current_week_worked_hours FROM employee_assignment AS ea, patient AS pa, employee AS em WHERE ea.patient_id = pa.patient_id AND em.employee_id = ea.employee_id AND em.Status = 1 AND pa.IsActive = 1 AND ea.pin NOT LIKE '%+%'";

            if($_GET['workHour'] && $_GET['workHour']==40) {
                $sql .= " AND ea.total_limit>40";
            }

            if($_GET['workHour'] && $_GET['workHour']==50) {
                $sql .= " AND ea.total_limit>50";
            }

            $sql .= " GROUP BY em.ssn";

            $data['assignedPatientData'] = $this->Comman_model->getCustomQueryData($sql);

            $sql = "SELECT * FROM table_2weekly";
            $allDates = $this->Comman_model->getCustomQueryData($sql);

            $data['allDates'] = $allDates;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/weekly-hour-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function weeklyHourReportBySSN() {
        if(isset($_SESSION['name'])) {
            $data = [];
            //$agency = $this->session->userdata('agency');

            if(isset($_GET['agency_code']) && $_GET['agency_code']!='') {
                $agency_code = $_GET['agency_code'];
            }

            $SUM = "SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours";            

            if($_GET['start_date'] && $_GET['start_date']!='') {
                $start = $_GET['start_date'];
                $d = date('d', strtotime($_GET['start_date']));
                $month = date('m', strtotime($_GET['start_date']));
                $year = date('Y', strtotime($_GET['start_date']));
                $l = $d+7;

                $day = '';
                $day1 = '';
                $month1 = '';
                $year1 = '';
                for ($i=0; $i<=6; $i++) { 
                    $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$i."days");
                    $datetrans = date("Y-m-d", $date);
                    $m = date("m", $date);
                    $Y = date("Y", $date);
                    if($m==$month && $Y==$year) {
                        $dd = date("d", $date);
                        $day .= 'day'.sprintf("%02s", $dd);
                        $day .= '+';    
                    } else {
                        $month1 = $m;
                        $year1  = $Y;
                        $dd = date("d", $date);
                        $day1 .= 'day'.sprintf("%02s", $dd);
                        $day1 .= '+';    
                    }                    
                }

                if($agency_code!='') {
                    $cond = "AND agency_code='".$agency_code."'";
                    if($agency_code==2) {
                        $cond = "AND agency_code IN (2,4)";    
                    }
                }

                if(isset($_GET['ssn_multiple']) && $_GET['ssn_multiple']==1) {
                    $agency_code = '';
                    $cond = '';
                    $sql = "SELECT count(*), ssn FROM weekly_hours_by_ssn WHERE month = '".$month."' AND year = '".$year."' ".$cond." GROUP BY ssn HAVING count(*) > 1";
                    $res = $this->Comman_model->getCustomQueryData($sql);
                    $ssnIds = array_column($res, 'ssn');
                    $ssnIds = "'" . implode ( "', '", $ssnIds ) . "'";
                }

                $SUM = "SUM(".rtrim($day, '+').") AS totalWorkedHours";
                if(!empty($ssnIds)) {
                    $sql = "SELECT *, ".$SUM." FROM weekly_hours_by_ssn WHERE month = '".$month."' AND year = '".$year."' AND ssn IN (".$ssnIds.") ".$cond." GROUP BY ssn HAVING totalWorkedHours>40";
                } else {
                    $sql = "SELECT *, ".$SUM." FROM weekly_hours_by_ssn WHERE month = '".$month."' AND year = '".$year."' ".$cond." GROUP BY ssn HAVING totalWorkedHours>40";    
                }                
                $res = $this->Comman_model->getCustomQueryData($sql);
                if(!empty($res)) {
                    foreach ($res as $key => $row) {
                        if(!empty($day1) && !empty($month1) && !empty($year1)) {
                            $employee_id = $row['employee_id'];
                            $SUM2 = "SUM(".rtrim($day1, '+').") AS totalWorkedHours";
                            if(!empty($ssnIds)) {
                                $sql2 = "SELECT ".$SUM2." FROM weekly_hours_by_ssn WHERE month = '".$month1."' AND year = '".$year1."' AND ssn IN (".$ssnIds.") AND employee_id = '".$employee_id."' ".$cond."";
                            } else {
                                $sql2 = "SELECT ".$SUM2." FROM weekly_hours_by_ssn WHERE month = '".$month1."' AND year = '".$year1."' AND employee_id = '".$employee_id."' ".$cond."";    
                            }                            
                            $row2 = $this->Comman_model->getCustomQueryData($sql2, 'row');
                            $res[$key]['totalWorkedHours'] = $row['totalWorkedHours'] + $row2['totalWorkedHours'];
                        }
                    }
                } else {
                    if(!empty($day1) && !empty($month1) && !empty($year1)) {
                        $SUM2 = "SUM(".rtrim($day1, '+').") AS totalWorkedHours";
                        if(!empty($ssnIds)) {
                            $sql = "SELECT *, ".$SUM2." FROM weekly_hours_by_ssn WHERE month = '".$month1."' AND year = '".$year1."' AND ssn IN (".$ssnIds.") ".$cond." GROUP BY ssn HAVING totalWorkedHours>40";
                        } else {
                            $sql = "SELECT *, ".$SUM2." FROM weekly_hours_by_ssn WHERE month = '".$month1."' AND year = '".$year1."' ".$cond." GROUP BY ssn HAVING totalWorkedHours>40";    
                        }
                        $res = $this->Comman_model->getCustomQueryData($sql);
                        foreach ($res as $key => $row) {
                            $employee_id = $row['employee_id'];
                            $SUM = "SUM(".rtrim($day, '+').") AS totalWorkedHours";
                            if(!empty($ssnIds)) {
                                $sql2 = "SELECT ".$SUM." FROM weekly_hours_by_ssn WHERE month = '".$month."' AND year = '".$year."' AND ssn IN (".$ssnIds.") AND employee_id = '".$employee_id."' ".$cond."";
                            } else {
                                $sql2 = "SELECT ".$SUM." FROM weekly_hours_by_ssn WHERE month = '".$month."' AND year = '".$year."' AND employee_id = '".$employee_id."' ".$cond."";    
                            }
                            
                            $row2 = $this->Comman_model->getCustomQueryData($sql2, 'row');
                            $res[$key]['totalWorkedHours'] = $row['totalWorkedHours'] + $row2['totalWorkedHours'];
                        }
                    }
                }
                $data['pageData'] = $res;
            } else {
                $sql = "SELECT *, ".$SUM." FROM weekly_hours_by_ssn GROUP BY ssn";
                $data['pageData'] = $this->Comman_model->getCustomQueryData($sql);
                $data['pageData'] = '';
            }            

            //echo $sql;die;

            $sql = "SELECT * FROM table_weekly";
            $allDates = $this->Comman_model->getCustomQueryData($sql);

            $sql = "SELECT * FROM agency WHERE agency_code!=4";
            $agencyData = $this->Comman_model->getCustomQueryData($sql);

            $data['allDates'] = $allDates;
            $data['agencyData'] = $agencyData;
            $data['startdate'] = $_GET['start_date'];
            $data['agency_code'] = $agency_code;
            $data['ssn_multiple'] = $_GET['ssn_multiple'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/weekly-hour-report-ssn.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function workHourReportBySSN() {
        if(isset($_GET['month']) && $_GET['month']!='') {
            $month = $_GET['month'];
        } else {
            $month = date('m');
        }

        if(isset($_GET['year']) && $_GET['year']!='') {
            $year = $_GET['year'];
        } else {
            $year = date('Y');
        } 
        $this->workHourReportBySSNGenratedForAgency24($month, $year, 2);
        $this->workHourReportBySSNGenratedForAgency24($month, $year, 4);  
        $this->workHourReportBySSNGenratedForAgency13($month, $year, 1);
        $this->workHourReportBySSNGenratedForAgency13($month, $year, 3);       
    }

    public function workHourReportBySSN2() {
        if(isset($_GET['month']) && $_GET['month']!='' && isset($_GET['year']) && $_GET['year']!='') {
            $month = $_GET['month'];
            $year = $_GET['year'];
        
            $this->workHourReportBySSNGenratedForAgency24($month, $year, 2);
            $this->workHourReportBySSNGenratedForAgency24($month, $year, 4);  
            $this->workHourReportBySSNGenratedForAgency13($month, $year, 1);
            $this->workHourReportBySSNGenratedForAgency13($month, $year, 3);       

            $this->session->set_flashdata('message', 'Data has been generated successfully.');
        } else {
            $this->session->set_flashdata('error_message', 'Please select month and year first.');
        }
        redirect($this->agent->referrer());
    }

    function workHourReportBySSNGenratedForAgency24($month, $year, $agency_code) {
        $sdArray = [];
        $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
        $objExec = get_custom_query_data($chkSQL);
        $startDates = array_column($objExec, 'start_date');
        $sdString = "'" . implode ( "', '", $startDates ) . "'";

        $sql = "SELECT employee_id, ssn, agency_location FROM employee WHERE Status = 1 AND Agency = '".$agency_code."'";
        if(!empty($employee_id)) {
            $sql .= " AND employee_id = '".$employee_id."'";
        }
        $res = get_custom_query_data($sql);
        if(!empty($res)) {
            foreach ($res as $ekey => $erow) {
                $employee_id = $erow['employee_id'];

                $chkSQL = "SELECT *, SUM(d01) as d01, SUM(d02) as d02, SUM(d03) as d03, SUM(d04) as d04, SUM(d05) as d05, SUM(d06) as d06, SUM(d07) as d07, SUM(d08) as d08, SUM(d09) as d09, SUM(d10) as d10, SUM(d11) as d11, SUM(d12) as d12, SUM(d13) as d13, SUM(d14) as d14 FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '".$agency_code."' AND employee_id = '".$employee_id."' GROUP BY start_date";
                $objExec = get_custom_query_data($chkSQL);

                $dataArray = [];
                $checkHours = 0;
                $duplicateEntry = [];

                foreach ($objExec as $key => $objResult) {
                    $emplid = $objResult["employee_id"];
                    $start = $objResult['start_date'];
                    $month1 = date('m', strtotime($objResult['start_date']));
                    $year1 = date('Y', strtotime($objResult['start_date']));
                    
                    $daycnt = 0;
                    $start = $objResult['start_date'];
                    while($daycnt<=13) {
                        $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                        $datetrans = date("Y-m-d", $date);
                        $d =  'd'.sprintf("%02s", $daycnt + 1);
                        $dd =  'day'.date("d", $date);
                        //echo '<br>';
                        $month11 = date('m', $date);
                        $year11 = date('Y', $date);
                        if($objResult[$d]>0 && $month==$month11 && $year11==$year) {
                            //$dataArray[$dd] = $dataArray[$dd] + $objResult[$d];   
                            $dataArray[$dd] = $objResult[$d];   
                            $checkHours++;                
                        }
                        $daycnt++;
                    }   
                    $dataArray['patient_id'] = $objResult['patient_id'];
                    $dataArray['employee_id'] = $employee_id;
                }
                $dataArray['ssn'] = $erow['ssn'];
                $dataArray['agency_location'] = $erow['agency_location'];
                $dataArray['month'] = $month;
                $dataArray['year'] = $year;
                $dataArray['agency_code'] = $agency_code;
                if(!empty($dataArray) && $checkHours>0) {
                    $sqln = "SELECT * FROM weekly_hours_by_ssn WHERE employee_id = '".$employee_id."' AND month = '".$month."' AND year = '".$year."' AND agency_code = '".$agency_code."' AND ssn = '".$erow['ssn']."'";
                    $rown = $this->Comman_model->getCustomQueryData($sqln, 'row');
                    if(!empty($rown)) {
                        $where = [];
                        $where['id'] = $rown['id'];
                        $this->Comman_model->update('weekly_hours_by_ssn', $where, $dataArray);
                    } else {
                        $this->Comman_model->insert('weekly_hours_by_ssn', $dataArray);
                    }                    
                }
            }
            echo "Scripts running successfully.";
        }
    }

    function workHourReportBySSNGenratedForAgency13($month, $year, $agency_code) {
        $startdate = $year.'-'.$month.'-01';
        $sql = "SELECT employee_id, ssn, agency_location FROM employee WHERE Status = 1 AND Agency = '".$agency_code."'";
        if(!empty($employee_id)) {
            $sql .= " AND employee_id = '".$employee_id."'";
        }
        $res = $this->Comman_model->getCustomQueryData($sql);
        if(!empty($res)) {
            foreach ($res as $ekey => $erow) {
                $employee_id = $erow['employee_id'];

                $chkSQL = "SELECT *, SUM(day01) as day01, SUM(day02) as day02, SUM(day03) as day03, SUM(day04) as day04, SUM(day05) as day05, SUM(day06) as day06, SUM(day07) as day07, SUM(day08) as day08, SUM(day09) as day09, SUM(day10) as day10, SUM(day11) as day11, SUM(day12) as day12, SUM(day13) as day13, SUM(day14) as day14, SUM(day15) as day15, SUM(day16) as day16, SUM(day17) as day17, SUM(day18) as day18, SUM(day19) as day19, SUM(day20) as day20, SUM(day21) as day21, SUM(day22) as day22, SUM(day23) as day23, SUM(day24) as day24, SUM(day25) as day25, SUM(day26) as day26, SUM(day27) as day27, SUM(day28) as day28, SUM(day29) as day29, SUM(day30) as day30, SUM(day31) as day31 FROM employee_finalsheet WHERE month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."' AND employee_id = '".$employee_id."'";
                $objExec = $this->Comman_model->getCustomQueryData($chkSQL);

                $dataArray = [];
                $checkHours = 0;
                $duplicateEntry = [];

                foreach ($objExec as $key => $objResult) {
                    $emplid = $objResult["employee_id"];
                    $start = $objResult['start_date'];
                    $month1 = date('m', strtotime($objResult['start_date']));
                    $year1 = date('Y', strtotime($objResult['start_date']));
                    
                    $daycnt = 0;
                    $start = date('Y-m-d', strtotime($startdate));
                    while($daycnt<=30) {
                        $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                        $datetrans = date("Y-m-d", $date);
                        $d =  'day'.sprintf("%02s", $daycnt + 1);
                        if($objResult[$d]>0) {
                            $dataArray[$d] = $objResult[$d];
                            $checkHours++;                
                        }
                        $daycnt++;
                    }   
                    $dataArray['patient_id'] = $objResult['patient_id'];
                    $dataArray['employee_id'] = $employee_id;
                }
                $dataArray['ssn'] = $erow['ssn'];
                $dataArray['agency_location'] = $erow['agency_location'];
                $dataArray['month'] = $month;
                $dataArray['year'] = $year;
                $dataArray['agency_code'] = $agency_code;
                if(!empty($dataArray) && $checkHours>0) {

                    $sqln = "SELECT * FROM weekly_hours_by_ssn WHERE employee_id = '".$employee_id."' AND month = '".$month."' AND year = '".$year."' AND agency_code = '".$agency_code."' AND ssn = '".$erow['ssn']."'";
                    $rown = $this->Comman_model->getCustomQueryData($sqln, 'row');
                    if(!empty($rown)) {
                        $where = [];
                        $where['id'] = $rown['id'];
                        $this->Comman_model->update('weekly_hours_by_ssn', $where, $dataArray);
                    } else {
                        $this->Comman_model->insert('weekly_hours_by_ssn', $dataArray);
                    }                    
                }
            }
            echo "Scripts running successfully.";
        }
    }

    public function weeklyHourReportByClient() {
        if(isset($_SESSION['name'])) {
            $data = [];
            //$agency = $this->session->userdata('agency');

            if(isset($_GET['agency_code']) && $_GET['agency_code']!='') {
                $agency_code = $_GET['agency_code'];
            }

            $SUM = "SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours";            

            if($_GET['start_date'] && $_GET['start_date']!='') {
                $start = $_GET['start_date'];
                $d = date('d', strtotime($_GET['start_date']));
                $month = date('m', strtotime($_GET['start_date']));
                $year = date('Y', strtotime($_GET['start_date']));
                $l = $d+7;

                $day = '';
                $day1 = '';
                $month1 = '';
                $year1 = '';
                for ($i=0; $i<=6; $i++) { 
                    $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$i."days");
                    $datetrans = date("Y-m-d", $date);
                    $m = date("m", $date);
                    $Y = date("Y", $date);
                    if($m==$month && $Y==$year) {
                        $dd = date("d", $date);
                        $day .= 'day'.sprintf("%02s", $dd);
                        $day .= '+';    
                    } else {
                        $month1 = $m;
                        $year1  = $Y;
                        $dd = date("d", $date);
                        $day1 .= 'day'.sprintf("%02s", $dd);
                        $day1 .= '+';    
                    }                    
                }

                if($agency_code!='') {
                    $cond = "AND agency_code='".$agency_code."'";
                    if($agency_code==2) {
                        $cond = "AND agency_code IN (2,4)";    
                    }
                }

                if(isset($_GET['ssn_multiple']) && $_GET['ssn_multiple']==1) {
                    $agency_code = '';
                    $cond = '';
                    $sql = "SELECT count(*), ssn FROM weekly_hours_by_client WHERE month = '".$month."' AND year = '".$year."' ".$cond." GROUP BY patient_id HAVING count(*) > 1";
                    $res = $this->Comman_model->getCustomQueryData($sql);
                    $ssnIds = array_column($res, 'ssn');
                    $ssnIds = "'" . implode ( "', '", $ssnIds ) . "'";
                }

                $SUM = "SUM(".rtrim($day, '+').") AS totalWorkedHours";
                if(!empty($ssnIds)) {
                    //$sql = "SELECT *, ".$SUM." FROM weekly_hours_by_client WHERE month = '".$month."' AND year = '".$year."' AND ssn IN (".$ssnIds.") ".$cond." GROUP BY patient_id HAVING totalWorkedHours>40";
                } else {
                    $sql = "SELECT *, ".$SUM." FROM weekly_hours_by_client WHERE month = '".$month."' AND year = '".$year."' ".$cond." GROUP BY patient_id HAVING totalWorkedHours>40";    
                }                
                $res = $this->Comman_model->getCustomQueryData($sql);
                if(!empty($res)) {
                    foreach ($res as $key => $row) {
                        if(!empty($day1) && !empty($month1) && !empty($year1)) {
                            $patient_id = $row['patient_id'];
                            $SUM2 = "SUM(".rtrim($day1, '+').") AS totalWorkedHours";
                            if(!empty($ssnIds)) {
                                //$sql2 = "SELECT ".$SUM2." FROM weekly_hours_by_client WHERE month = '".$month1."' AND year = '".$year1."' AND ssn IN (".$ssnIds.") AND employee_id = '".$employee_id."' ".$cond."";
                            } else {
                                $sql2 = "SELECT ".$SUM2." FROM weekly_hours_by_client WHERE month = '".$month1."' AND year = '".$year1."' AND patient_id = '".$patient_id."' ".$cond."";    
                            }                            
                            $row2 = $this->Comman_model->getCustomQueryData($sql2, 'row');
                            $res[$key]['totalWorkedHours'] = $row['totalWorkedHours'] + $row2['totalWorkedHours'];
                        }
                    }
                } else {
                    if(!empty($day1) && !empty($month1) && !empty($year1)) {
                        $SUM2 = "SUM(".rtrim($day1, '+').") AS totalWorkedHours";
                        if(!empty($ssnIds)) {
                            //$sql = "SELECT *, ".$SUM2." FROM weekly_hours_by_client WHERE month = '".$month1."' AND year = '".$year1."' AND ssn IN (".$ssnIds.") ".$cond." GROUP BY patient_id HAVING totalWorkedHours>40";
                        } else {
                            $sql = "SELECT *, ".$SUM2." FROM weekly_hours_by_client WHERE month = '".$month1."' AND year = '".$year1."' ".$cond." GROUP BY patient_id HAVING totalWorkedHours>40";    
                        }
                        $res = $this->Comman_model->getCustomQueryData($sql);
                        foreach ($res as $key => $row) {
                            $patient_id = $row['patient_id'];
                            $SUM = "SUM(".rtrim($day, '+').") AS totalWorkedHours";
                            if(!empty($ssnIds)) {
                                //$sql2 = "SELECT ".$SUM." FROM weekly_hours_by_client WHERE month = '".$month."' AND year = '".$year."' AND ssn IN (".$ssnIds.") AND employee_id = '".$employee_id."' ".$cond."";
                            } else {
                                $sql2 = "SELECT ".$SUM." FROM weekly_hours_by_client WHERE month = '".$month."' AND year = '".$year."' AND patient_id = '".$patient_id."' ".$cond."";    
                            }
                            
                            $row2 = $this->Comman_model->getCustomQueryData($sql2, 'row');
                            $res[$key]['totalWorkedHours'] = $row['totalWorkedHours'] + $row2['totalWorkedHours'];
                        }
                    }
                }
                $data['pageData'] = $res;
            } else {
                $sql = "SELECT *, ".$SUM." FROM weekly_hours_by_client GROUP BY patient_id";
                $data['pageData'] = $this->Comman_model->getCustomQueryData($sql);
                $data['pageData'] = '';
            }            

            //echo $sql;die;

            $sql = "SELECT * FROM table_weekly";
            $allDates = $this->Comman_model->getCustomQueryData($sql);

            $sql = "SELECT * FROM agency WHERE agency_code!=4";
            $agencyData = $this->Comman_model->getCustomQueryData($sql);

            $data['allDates'] = $allDates;
            $data['agencyData'] = $agencyData;
            $data['startdate'] = $_GET['start_date'];
            $data['agency_code'] = $agency_code;
            $data['ssn_multiple'] = $_GET['ssn_multiple'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/weekly-hour-report-client.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function workHourReportByClient() {
        if(isset($_GET['month']) && $_GET['month']!='') {
            $month = $_GET['month'];
        } else {
            $month = date('m');
        }
        if(isset($_GET['year']) && $_GET['year']!='') {
            $year = $_GET['year'];
        } else {
            $year = date('Y');
        }

        $sql = "DELETE FROM weekly_hours_by_client WHERE month='".$month."' AND year = '".$year."'";
        set_custom_query_data($sql);

        $this->workHourReportByClientGenratedForAgency24($month, $year, 2);
        $this->workHourReportByClientGenratedForAgency24($month, $year, 4);  
        $this->workHourReportByClientGenratedForAgency13($month, $year, 1);
        $this->workHourReportByClientGenratedForAgency13($month, $year, 3);

        $this->session->set_flashdata('message', 'Data has been refresh successfully.');
        redirect('employee/monthlyHourReportByClient?month='.$month.'&year='.$year);
    }

    function workHourReportByClientGenratedForAgency24($month, $year, $agency_code) {
        $sdArray = [];
        $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
        $objExec = get_custom_query_data($chkSQL);
        $startDates = array_column($objExec, 'start_date');
        $sdString = "'" . implode ( "', '", $startDates ) . "'";

        $sql = "SELECT patient_id, agency_location FROM patient WHERE Agency = '".$agency_code."'";
        if(!empty($patient_id)) {
            $sql .= " AND patient_id = '".$patient_id."'";
        }
        $res = get_custom_query_data($sql);
        if(!empty($res)) {
            foreach ($res as $ekey => $erow) {
                $patient_id = $erow['patient_id'];

                $chkSQL = "SELECT *, SUM(d01) as d01, SUM(d02) as d02, SUM(d03) as d03, SUM(d04) as d04, SUM(d05) as d05, SUM(d06) as d06, SUM(d07) as d07, SUM(d08) as d08, SUM(d09) as d09, SUM(d10) as d10, SUM(d11) as d11, SUM(d12) as d12, SUM(d13) as d13, SUM(d14) as d14 FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '".$agency_code."' AND patient_id = '".$patient_id."' GROUP BY start_date";
                $objExec = get_custom_query_data($chkSQL);

                $dataArray = [];
                $checkHours = 0;
                $duplicateEntry = [];

                foreach ($objExec as $key => $objResult) {
                    $start = $objResult['start_date'];
                    $month1 = date('m', strtotime($objResult['start_date']));
                    $year1 = date('Y', strtotime($objResult['start_date']));
                    
                    $daycnt = 0;
                    $start = $objResult['start_date'];
                    while($daycnt<=13) {
                        $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                        $datetrans = date("Y-m-d", $date);
                        $d =  'd'.sprintf("%02s", $daycnt + 1);
                        $dd =  'day'.date("d", $date);
                        //echo '<br>';
                        $month11 = date('m', $date);
                        $year11 = date('Y', $date);
                        if($objResult[$d]>0 && $month==$month11 && $year11==$year) {
                            //$dataArray[$dd] = $dataArray[$dd] + $objResult[$d];   
                            $dataArray[$dd] = $objResult[$d];   
                            $checkHours++;                
                        }
                        $daycnt++;
                    }   
                    $dataArray['employee_id'] = $objResult['employee_id'];
                    $dataArray['patient_id'] = $patient_id;
                }
                //$dataArray['ssn'] = $erow['ssn'];
                $dataArray['agency_location'] = $erow['agency_location'];
                $dataArray['month'] = $month;
                $dataArray['year'] = $year;
                $dataArray['agency_code'] = $agency_code;
                if(!empty($dataArray) && $checkHours>0) {
                    $sqln = "SELECT * FROM weekly_hours_by_client WHERE patient_id = '".$patient_id."' AND month = '".$month."' AND year = '".$year."' AND agency_code = '".$agency_code."'";
                    $rown = $this->Comman_model->getCustomQueryData($sqln, 'row');
                    if(!empty($rown)) {
                        $where = [];
                        $where['id'] = $rown['id'];
                        $this->Comman_model->update('weekly_hours_by_client', $where, $dataArray);
                    } else {
                        $this->Comman_model->insert('weekly_hours_by_client', $dataArray);
                    }                    
                }
            }
            echo "Scripts running successfully.";
        }
    }

    function workHourReportByClientGenratedForAgency13($month, $year, $agency_code) {
        $startdate = $year.'-'.$month.'-01';
        $sql = "SELECT patient_id, agency_location FROM patient WHERE Agency = '".$agency_code."'";
        if(!empty($patient_id)) {
            $sql .= " AND patient_id = '".$patient_id."'";
        }
        $res = $this->Comman_model->getCustomQueryData($sql);
        if(!empty($res)) {
            foreach ($res as $ekey => $erow) {
                $patient_id = $erow['patient_id'];

                $chkSQL = "SELECT *, SUM(day01) as day01, SUM(day02) as day02, SUM(day03) as day03, SUM(day04) as day04, SUM(day05) as day05, SUM(day06) as day06, SUM(day07) as day07, SUM(day08) as day08, SUM(day09) as day09, SUM(day10) as day10, SUM(day11) as day11, SUM(day12) as day12, SUM(day13) as day13, SUM(day14) as day14, SUM(day15) as day15, SUM(day16) as day16, SUM(day17) as day17, SUM(day18) as day18, SUM(day19) as day19, SUM(day20) as day20, SUM(day21) as day21, SUM(day22) as day22, SUM(day23) as day23, SUM(day24) as day24, SUM(day25) as day25, SUM(day26) as day26, SUM(day27) as day27, SUM(day28) as day28, SUM(day29) as day29, SUM(day30) as day30, SUM(day31) as day31 FROM employee_finalsheet WHERE month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."' AND patient_id = '".$patient_id."'";
                $objExec = $this->Comman_model->getCustomQueryData($chkSQL);

                $dataArray = [];
                $checkHours = 0;
                $duplicateEntry = [];

                foreach ($objExec as $key => $objResult) {
                    $start = $objResult['start_date'];
                    $month1 = date('m', strtotime($objResult['start_date']));
                    $year1 = date('Y', strtotime($objResult['start_date']));
                    
                    $daycnt = 0;
                    $start = date('Y-m-d', strtotime($startdate));
                    while($daycnt<=30) {
                        $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                        $datetrans = date("Y-m-d", $date);
                        $d =  'day'.sprintf("%02s", $daycnt + 1);
                        if($objResult[$d]>0) {
                            $dataArray[$d] = $objResult[$d];
                            $checkHours++;                
                        }
                        $daycnt++;
                    }   
                    $dataArray['employee_id'] = $objResult['employee_id'];
                    $dataArray['patient_id'] = $patient_id;
                }
                //$dataArray['ssn'] = $erow['ssn'];
                $dataArray['agency_location'] = $erow['agency_location'];
                $dataArray['month'] = $month;
                $dataArray['year'] = $year;
                $dataArray['agency_code'] = $agency_code;
                if(!empty($dataArray) && $checkHours>0) {

                    $sqln = "SELECT * FROM weekly_hours_by_client WHERE patient_id = '".$patient_id."' AND month = '".$month."' AND year = '".$year."' AND agency_code = '".$agency_code."'";
                    $rown = $this->Comman_model->getCustomQueryData($sqln, 'row');
                    if(!empty($rown)) {
                        $where = [];
                        $where['id'] = $rown['id'];
                        $this->Comman_model->update('weekly_hours_by_client', $where, $dataArray);
                    } else {
                        $this->Comman_model->insert('weekly_hours_by_client', $dataArray);
                    }                    
                }
            }
            echo "Scripts running successfully.";
        }
    }

    public function monthlyHourReportByClient() {
        if(isset($_SESSION['name'])) {
            $data = [];
            //$agency = $this->session->userdata('agency');

            if(isset($_GET['agency_code']) && $_GET['agency_code']!='') {
                $agency_code = $_GET['agency_code'];
            }

            //$SUM = "SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours";            

            if(isset($_GET['month']) && $_GET['month']!='') {
                $month = $_GET['month'];
            } else {
                $month = date('m');
            }

            if(isset($_GET['year']) && $_GET['year']!='') {
                $year = $_GET['year'];
            } else {
                $year = date('Y');
            } 

            $payorSource = '';
            if(!empty($_GET['payorSource'])) {
                $payorSource =  $_GET['payorSource'];
            }

            
            $sql = "SELECT * FROM weekly_hours_by_client WHERE month = '".$month."' AND year = '".$year."' ORDER BY id";
            $data['pageData'] = $this->Comman_model->getCustomQueryData($sql);

            //$sql = "SELECT * FROM table_weekly";
            //$allDates = $this->Comman_model->getCustomQueryData($sql);

            $sql = "SELECT * FROM agency WHERE agency_code";
            $agencyData = $this->Comman_model->getCustomQueryData($sql);

            $data['allDates'] = $allDates;
            $data['agencyData'] = $agencyData;
            $data['month'] = $month;
            $data['year'] = $year;
            $data['payorSource'] = $payorSource;
            $data['agency_code'] = $agency_code;
            //$data['ssn_multiple'] = $_GET['ssn_multiple'];

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/monthly-hour-report-client.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    function deleteHarvestData() {
        $month = $_POST['month'];
        $year = $_POST['year'];
        $uservalidated = $this->session->userdata('uservalidated');
        if(!empty($month) && !empty($year) && $uservalidated=='1') {
            $sql = "DELETE FROM weekly_hours_by_client WHERE month='".$month."' AND year = '".$year."'";
            set_custom_query_data($sql);
            $this->session->set_flashdata('message', 'Data has been deleted successfully.');
            echo '1';
        } else {
            echo '0';
        }
        //redirect($this->agent->referrer());
    }

    function workHourReportByClientToMonthlyHoursTable() {
        if(!empty($_GET['month']) && !empty($_GET['year'])) {
            $month = $_GET['month']; $year = $_GET['year'];    

            $sql = "DELETE FROM monthly_hours.monthly_hours WHERE month='".$month."' AND year = '".$year."'";
            set_custom_query_data($sql);

            $sql = "SELECT weekly_hours_by_client.*, patient.name as pt_name FROM weekly_hours_by_client, patient WHERE weekly_hours_by_client.patient_id=patient.patient_id AND weekly_hours_by_client.month = '".$month."' AND weekly_hours_by_client.year = '".$year."'";
            $res = $this->Comman_model->getCustomQueryData($sql);   
            foreach ($res as $key => $row) {
                $patient_id = $row['patient_id'];
                $month = $row['month'];
                $year = $row['year'];
                $agency_code = $row['agency_code'];

                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' ORDER BY district_id DESC LIMIT 1";
                $districtResult = get_custom_query_data($districtSQL, 'row');
                if (!empty($districtResult)) {
                    $mco = $districtResult['DistrictID_Ref'];                               
                } else {
                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));
                    //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<'$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                    $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<='$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                    $districtResult = get_custom_query_data($districtSQL, 'row');
                    if (!empty($districtResult)) {
                        $mco = $districtResult['DistrictID_Ref'];
                    }                               
                }

                $where = [];
                $where['DistrictID'] = $mco;
                $where['Agency'] = $agency_code;
                $dtData = get_row('tbldistricts', $where);            

                $where = [];
                $where['agency_location_code'] = $row['agency_location'];
                $agData = get_row('agency_location', $where);

                $where = [];
                $where['payor_id'] = $dtData['payorGrpName'];
                $pgData = get_row('payor', $where);
                $payorGrpName = '';
                if(!empty($pgData['payor'])) {
                    $payorGrpName = $pgData['payor'];
                }

                $where = [];
                $where['agency_code'] = $row['agency_code'];
                $aData = get_row('agency', $where);                        

                if($aData['agency_code']==1) {
                    $color = 'orange';
                }
                if($aData['agency_code']==2) {
                    $color = 'green';
                }
                if($aData['agency_code']==3) {
                    $color = 'blue';
                }
                if($aData['agency_code']==4) {
                    $color = 'purple';
                }

                $params = [];            
                $params['employee_id'] = $row['employee_id'];
                $params['agency_location'] = $row['agency_location'];
                $params['agency_location_name'] = $agData['agency_location_name'];
                $params['patient_id'] = $patient_id;
                $params['payor_id'] = $mco;
                $params['payor'] = $dtData['DistrictName'];
                $params['PayorGroupNameId'] = $dtData['payorGrpName'];
                $params['PayorGroupName'] = $payorGrpName;
                $params['month'] = $row['month'];
                $params['year'] = $row['year'];
                $params['agency_code'] = $row['agency_code'];
                if($row['agency_code']==4) {
                    $params['agency_name'] = 'SENIORCARE';
                } else {
                    $params['agency_name'] = $aData['agency_codename'];    
                }                
                if($dtData['payorGrp']!=0) {
                    $params['payorGrp'] = 'MCO-'.$dtData['payorGrp'];    
                }

                $totalHrs = 0;

                for ($i=1; $i<=31; $i++) {        
                    $d = 'day'.sprintf("%02s", $i);
                    $params[$d] = $row[$d];
                    $totalHrs = $totalHrs + $row[$d];
                }

                $params['total_hours'] = $totalHrs;

                if(!empty($params)) {
                    $this->Comman_model->insert('monthly_hours.monthly_hours', $params);
                }            
            }
            $this->session->set_flashdata('message','Record has been updated inside monthly_hours database.');
        } else {
            $this->session->set_flashdata('error_message','Please select month and year.');                
        }
        redirect($this->agent->referrer());
    }

    function monthlyHourReportData() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        $start = 0;
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        if(!empty($_POST['length'])) {
            $length = $_POST['length'];
            $sLimit = "LIMIT ".$start.", $length";
        }

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND (patient.name LIKE '%".$search."%' OR weekly_hours_by_client.patient_id LIKE '%".$search."%')";
        }

        if(!empty($_GET['month']) && !empty($_GET['year'])) {
            $month = $_GET['month']; $year = $_GET['year'];
        } else {
            $month = date('m'); $year = date('Y');
        }

        $payorSource = '';
        if(!empty($_GET['payorSource'])) {
            $payorSource =  $_GET['payorSource'];
        }

        $agency_code = $_GET['agency_code'];

        if(!empty($agency_code)) {
            $cond .= " AND weekly_hours_by_client.agency_code='".$agency_code."'";
        }
        
        $sql = "SELECT weekly_hours_by_client.*, patient.name as pt_name FROM weekly_hours_by_client, patient WHERE weekly_hours_by_client.patient_id=patient.patient_id AND weekly_hours_by_client.month = '".$month."' AND weekly_hours_by_client.year = '".$year."' $cond ORDER BY patient.name DESC $sLimit";
        $res = $this->Comman_model->getCustomQueryData($sql);

        /******** Get recordsTotal ********/
        $sqlT = "SELECT weekly_hours_by_client.* FROM weekly_hours_by_client, patient WHERE weekly_hours_by_client.patient_id=patient.patient_id AND weekly_hours_by_client.month = '".$month."' AND weekly_hours_by_client.year = '".$year."' $cond ORDER BY weekly_hours_by_client.id";
        $this->session->set_userdata('SQL', $sqlT);
        $resT = $this->Comman_model->getCustomQueryData($sqlT);        
        $recordsTotal = count($resT);

        /******** Get recordsFiltered ********/
        $sqlF = "SELECT weekly_hours_by_client.* FROM weekly_hours_by_client, patient WHERE weekly_hours_by_client.patient_id=patient.patient_id AND weekly_hours_by_client.month = '".$month."' AND weekly_hours_by_client.year = '".$year."' $cond ORDER BY weekly_hours_by_client.id";
        $resF = $this->Comman_model->getCustomQueryData($sqlF);
        $recordsFiltered = count($resF);

        $totalRec = 0;
        $datas = [];
        $data = [];
        
        $nex = 0; $k = 0;

        if(empty($payorSource)) {
            foreach ($res as $key => $row) {

                $patient_id = $row['patient_id'];
                $month = $row['month'];
                $year = $row['year'];
                $agency_code = $row['agency_code'];

                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' ORDER BY district_id DESC LIMIT 1";
                $districtResult = get_custom_query_data($districtSQL, 'row');
                if (!empty($districtResult)) {
                    $mco = $districtResult['DistrictID_Ref'];                               
                } else {
                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));
                    //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<'$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";

                    $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<='$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                    $districtResult = get_custom_query_data($districtSQL, 'row');
                    if (!empty($districtResult)) {
                        $mco = $districtResult['DistrictID_Ref'];
                    }                               
                }

                $where = [];
                $where['DistrictID'] = $mco;
                $where['Agency'] = $agency_code;
                $dtData = get_row('tbldistricts', $where);            

                $where = [];
                $where['agency_location_code'] = $row['agency_location'];
                $agData = get_row('agency_location', $where);

                $where = [];
                $where['agency_code'] = $row['agency_code'];
                $aData = get_row('agency', $where);                        

                if($aData['agency_code']==1) {
                    $color = 'orange';
                }
                if($aData['agency_code']==2) {
                    $color = 'green';
                }
                if($aData['agency_code']==3) {
                    $color = 'blue';
                }
                if($aData['agency_code']==4) {
                    $color = 'purple';
                }

                $params = [];            
                $params[0] = $row['patient_id'];
                $params[1] = '<a target="_blank" href="'.base_url('employee/patientBilledHours').'?patient_id='.$row['patient_id'].'&month='.$row['month'].'&year='.$row['year'].'">'.$row['pt_name'].'</a><br><a target="_blank" style="color:'.$color.';" href="'.base_url('patient/district/'.$row['patient_id']).'"><small>'.$aData['agency_codename'].'</small></a>';
                $params[2] = $agData['agency_location_name'];
                $params[3] = $dtData['DistrictName'];
                $params[4] = $dtData['payorGrp'];
                if($dtData['payorGrp']!=0) {
                    $params[4] = 'MCO-'.$dtData['payorGrp'];    
                }

                for ($i=1; $i<=31; $i++) {        
                    $status = '';
                    /*$date = $year.'-'.$month.'-'.$i;
                    $datetrans = date('Y-m-d', strtotime($date));

                    $chkSQL3 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.idoa_id = idoadb_details.idoa_id AND idoadb.patient_id = '$patient_id' AND idoadb_details.date = '$datetrans' AND idoadb.month='$month' AND idoadb.year='$year' AND idoadb_details.Agency='$agency_code' AND idoadb_details.status = 'Billed'";
                    $objResult3 = get_custom_query_data($chkSQL3, 'row');
                    if (!empty($objResult3)) { 
                        $status = $objResult3['status'];    
                    }

                    $chkSQL3 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND idoadbLTS.patient_id = '$patient_id' AND date = '$datetrans' AND month='$month' AND year='$year' AND idoadb_detailsLTS.Agency='$agency_code' AND idoadb_detailsLTS.status = 'Billed'";
                    $objResult3 = get_custom_query_data($chkSQL3, 'row');
                    if (!empty($objResult3)) { 
                        $status = $objResult3['status'];    
                    }

                    $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$patient_id' AND date = '$datetrans' AND eclaims_details.status = 'Billed' AND eclaims_details.Agency='$agency_code'";
                    $objResult8 = get_custom_query_data($chkSQL8, 'row');
                    if (!empty($objResult8)) { 
                        $status = $objResult8['status'];
                    }

                    $chkSQL8 = "SELECT * FROM eclaimsLTS,eclaims_detailsLTS WHERE eclaimsLTS.cms1500_id = eclaims_detailsLTS.cms1500_id AND eclaims_detailsLTS.patient_id = '$patient_id' AND date = '$datetrans' AND eclaims_detailsLTS.status = 'Billed' AND eclaims_detailsLTS.Agency='$agency_code'";
                    $objResult8 = get_custom_query_data($chkSQL8, 'row');
                    if (!empty($objResult8))  { 
                        $status = $objResult8['status'];
                    }*/

                    $d = 'day'.sprintf("%02s", $i);
                    $params[$i+4] = '<td>'.$row[$d].'</td>';
                }            

                if(!empty($params)) {
                    $data[$key] = $params;
                }            
            }
        }

        if(!empty($payorSource)) {
            $sql = "SELECT weekly_hours_by_client.*, patient.name as pt_name FROM weekly_hours_by_client, patient WHERE weekly_hours_by_client.patient_id=patient.patient_id AND weekly_hours_by_client.month = '".$month."' AND weekly_hours_by_client.year = '".$year."' $cond ORDER BY patient.name DESC";
            $res = $this->Comman_model->getCustomQueryData($sql);

            foreach ($res as $key => $row) {
                $patient_id = $row['patient_id'];
                $month = $row['month'];
                $year = $row['year'];
                $agency_code = $row['agency_code'];

                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' ORDER BY district_id DESC LIMIT 1";
                $districtResult = get_custom_query_data($districtSQL, 'row');
                if (!empty($districtResult)) {
                    $mco = $districtResult['DistrictID_Ref'];                               
                } else {
                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));
                    //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<'$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";

                    $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<='$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                    $districtResult = get_custom_query_data($districtSQL, 'row');
                    if (!empty($districtResult)) {
                        $mco = $districtResult['DistrictID_Ref'];
                    }                               
                }

                $where = [];
                $where['DistrictID'] = $mco;
                $where['Agency'] = $agency_code;
                $dtData = get_row('tbldistricts', $where);            

                $where = [];
                $where['agency_location_code'] = $row['agency_location'];
                $agData = get_row('agency_location', $where);

                $where = [];
                $where['agency_code'] = $row['agency_code'];
                $aData = get_row('agency', $where);   

                if($aData['agency_code']==1) {
                    $color = 'orange';
                }
                if($aData['agency_code']==2) {
                    $color = 'green';
                }
                if($aData['agency_code']==3) {
                    $color = 'blue';
                }
                if($aData['agency_code']==4) {
                    $color = 'purple';
                }                     

                $params = [];            
                $params[0] = $row['patient_id'];
                $params[1] = '<a target="_blank" href="'.base_url('employee/patientBilledHours').'?patient_id='.$row['patient_id'].'&month='.$row['month'].'&year='.$row['year'].'">'.$row['pt_name'].'</a><br><a target="_blank" style="color:'.$color.';" href="'.base_url('patient/district/'.$row['patient_id']).'"><small>'.$aData['agency_codename'].'</small></a>';
                $params[2] = $agData['agency_location_name'];
                $params[3] = $dtData['DistrictName'];
                $params[4] = $dtData['payorGrp'];
                if($dtData['payorGrp']!=0) {
                    $params[4] = 'MCO-'.$dtData['payorGrp'];    
                }

                for ($i=1; $i<=31; $i++) {        
                    $status = '';
                    $d = 'day'.sprintf("%02s", $i);
                    $params[$i+4] = '<td>'.$row[$d].'</td>';
                }            

                if(!empty($params)) {
                    if($payorSource=='4') {
                        if(empty($dtData['DistrictName'])) {
                            $datas[$nex] = $params;
                            $nex++; $k++;
                        }
                    } else {
                        if($payorSource==$dtData['payor_source_id']) {
                            $datas[$nex] = $params;
                            $nex++; $k++;
                        }
                    }
                }            
            }

            //$recordsTotal = $nex;
            $recordsTotal = count($datas);
            $recordsFiltered = $recordsTotal;

            if($k>10) {
                if(isset($_POST['start'])) {
                    $z = $_POST['start'];
                    $limitt = $z+10;
                    $y = 0;
                    for ($z; $z<$limitt; $z++) { 
                        if(!empty($datas[$z])) {
                            $data[$y] = $datas[$z];
                            $y++;
                        }
                    }
                }
            } else {
                $data = $datas;
            }
        }

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        print_r(json_encode($response));        
    }

    public function excelmonthlyHourReportData() {

        if(!empty($_GET['month'])) {
            $month = $_GET['month'];
        } else {
            $month = date('m');
        }

        if(!empty($_GET['year'])) {
            $year = $_GET['year'];
        } else {
            $year = date('Y');
        }

        $cond = '';
        if(!empty($_GET['search'])) {            
            //$search = $_GET['search'];
            //$cond .= "AND (patient.name LIKE '%".$search."%' OR weekly_hours_by_client.patient_id LIKE '%".$search."%')";
        }

        $payorSource = '';
        if(!empty($_GET['payorSource'])) {
            $payorSource =  $_GET['payorSource'];
        }

        $agency_code = $_GET['agency_code'];
        if(!empty($agency_code)) {
            $cond .= " AND weekly_hours_by_client.agency_code='".$agency_code."'";
        }

        
 
        $flag = false;
        $row2 = 0;

        $arry = array('PATIENT ID', 'PATIENT NAME', 'LOCATION', 'AGENCY', 'PAYOR', 'PAYOR GROUP');


        for($i=1; $i<=31; $i++) { 
            $d = 'day'.sprintf("%02s", $i);
            array_push($arry, $d);
        }

        array_push($arry, 'Total Hours');

        
        $sql = "SELECT weekly_hours_by_client.*, patient.name as pt_name FROM weekly_hours_by_client, patient WHERE weekly_hours_by_client.patient_id=patient.patient_id AND weekly_hours_by_client.month = '".$month."' AND weekly_hours_by_client.year = '".$year."' $cond ORDER BY patient.name DESC";

        //echo $sql;die;
        $res = $this->Comman_model->getCustomQueryData($sql);

        $totalRec = 0;
        $datas = [];
        $data = [];        
        $nex = 0;
        foreach ($res as $key => $row) {

            $patient_id = $row['patient_id'];            

            $where = [];
            $where['agency_location_code'] = $row['agency_location'];
            $agData = get_row('agency_location', $where);

            $where = [];
            $where['agency_code'] = $row['agency_code'];
            $aData = get_row('agency', $where);   

            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' ORDER BY district_id DESC LIMIT 1";
            $districtResult = get_custom_query_data($districtSQL, 'row');
            if (!empty($districtResult)) {
                $mco = $districtResult['DistrictID_Ref'];                               
            } else {
                $cdate = $year.'-'.$month.'-01';
                $cdate = date('Y-m-d', strtotime($cdate));
                //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<'$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<='$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                $districtResult = get_custom_query_data($districtSQL, 'row');
                if (!empty($districtResult)) {
                    $mco = $districtResult['DistrictID_Ref'];
                }                               
            }                     

            $where = [];
            $where['DistrictID'] = $mco;
            $where['Agency'] = $row['agency_code'];
            $dtData = get_row('tbldistricts', $where);

            $params = [];            
            $params[0] = $row['patient_id'];
            $params[1] = $row['pt_name'];
            $params[2] = $agData['agency_location_name'];
            $params[3] = $aData['agency_codename'];
            $params[4] = $dtData['DistrictName'];
            $params[5] = $dtData['payorGrp'];
            if($dtData['payorGrp']!=0) {
                $params[5] = 'MCO-'.$dtData['payorGrp'];    
            }

            $total = 0;
            for($i=1; $i<=31; $i++) { 
                $d = 'day'.sprintf("%02s", $i);
                $total = $total + $row[$d];
                $params[$i+5] = $row[$d];
            }

            $params[37] = $total;

            if(!empty($params)) {
                if(!empty($payorSource)) {
                    if($payorSource=='4' && empty($dtData['DistrictName'])) {
                        $data[$nex] = $params;
                        $nex++; $k++;
                    } else {
                        if($payorSource==$dtData['payor_source_id']) {
                            $data[$nex] = $params;
                            $nex++; $k++;
                        }
                    }
                } else {
                    $data[$key] = $params;    
                }                
            }
        }

        $filename = "MONTHLY_HOURS_REPORT_BY_CLIENTS_".$month."_".$year.".xls";
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");
        
        if(!empty($data)) {
            foreach ($data as $key => $row) {
                if(!$flag) {
                  array_walk($row, array($this,'cleanData'));
                  echo implode("\t",$arry) . "\r\n";
                  $flag = true;
                }
                array_walk($row, array($this, 'cleanData'));
                $x = 1;
                echo implode("\t", array_values($row)) . "\r\n";
            }
        } else {
            $this->session->set_flashdata('error_message', 'Oops no record found.');
            redirect($this->agent->referrer());
        }
    }

    public function excelmonthlyHourReportDataFromMonthlyTable() {

        if(!empty($_GET['month'])) {
            $month = $_GET['month'];
        } else {
            $month = date('m');
        }

        if(!empty($_GET['year'])) {
            $year = $_GET['year'];
        } else {
            $year = date('Y');
        }

        $cond = '';
        if(!empty($_GET['search'])) {            
            //$search = $_GET['search'];
            //$cond .= "AND (patient.name LIKE '%".$search."%' OR weekly_hours_by_client.patient_id LIKE '%".$search."%')";
        }

        $payorSource = '';
        if(!empty($_GET['payorSource'])) {
            $payorSource =  $_GET['payorSource'];
        }

        $agency_code = $_GET['agency_code'];
        if(!empty($agency_code)) {
            $cond .= " AND monthly_hours.monthly_hours.agency_code='".$agency_code."'";
        }

        
 
        $flag = false;
        $row2 = 0;

        $arry = array('PATIENT ID', 'PATIENT NAME', 'LOCATION', 'AGENCY', 'PAYOR', 'PAYOR GROUP', 'PAYOR GROUP NAME');


        for($i=1; $i<=31; $i++) { 
            $d = 'day'.sprintf("%02s", $i);
            array_push($arry, $d);
        }

        array_push($arry, 'Total Hours');

        
        $sql = "SELECT monthly_hours.monthly_hours.*, patient.name as pt_name FROM monthly_hours.monthly_hours, demoivr.patient WHERE monthly_hours.monthly_hours.patient_id = demoivr.patient.patient_id AND month = '".$month."' AND year = '".$year."' $cond ORDER BY patient.name DESC";
        $res = $this->Comman_model->getCustomQueryData($sql);

        $totalRec = 0;
        $datas = [];
        $data = [];        
        $nex = 0;
        foreach ($res as $key => $row) {

            $patient_id = $row['patient_id'];            

            $where = [];
            $where['agency_location_code'] = $row['agency_location'];
            $agData = get_row('agency_location', $where);

            $where = [];
            $where['agency_code'] = $row['agency_code'];
            $aData = get_row('agency', $where);   

            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' ORDER BY district_id DESC LIMIT 1";
            $districtResult = get_custom_query_data($districtSQL, 'row');
            if (!empty($districtResult)) {
                $mco = $districtResult['DistrictID_Ref'];                               
            } else {
                $cdate = $year.'-'.$month.'-01';
                $cdate = date('Y-m-d', strtotime($cdate));
                //$districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<'$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$patient_id' AND start_date<='$cdate' AND start_date!='0000-00-00' ORDER BY district_id DESC LIMIT 1";
                $districtResult = get_custom_query_data($districtSQL, 'row');
                if (!empty($districtResult)) {
                    $mco = $districtResult['DistrictID_Ref'];
                }                               
            }                     

            $where = [];
            $where['DistrictID'] = $mco;
            $where['Agency'] = $row['agency_code'];
            $dtData = get_row('tbldistricts', $where);

            $where = [];
            $where['payor_id'] = $dtData['payorGrpName'];
            $pgData = get_row('payor', $where);
            $payorGrpName = '';
            if(!empty($pgData['payor'])) {
                $payorGrpName = $pgData['payor'];
            }

            $params = [];            
            $params[0] = $row['patient_id'];
            $params[1] = $row['pt_name'];
            $params[2] = $agData['agency_location_name'];
            $params[3] = $aData['agency_codename'];
            $params[4] = $dtData['DistrictName'];
            $params[5] = $dtData['payorGrp'];
            if($dtData['payorGrp']!=0) {
                $params[5] = 'MCO-'.$dtData['payorGrp'];    
            }
            $params[6] = $payorGrpName;

            $total = 0;
            for($i=1; $i<=31; $i++) { 
                $d = 'day'.sprintf("%02s", $i);
                $total = $total + $row[$d];
                $params[$i+6] = $row[$d];
            }

            $params[38] = $total;

            if(!empty($params)) {
                if(!empty($payorSource)) {
                    if($payorSource=='4' && empty($dtData['DistrictName'])) {
                        $data[$nex] = $params;
                        $nex++; $k++;
                    } else {
                        if($payorSource==$dtData['payor_source_id']) {
                            $data[$nex] = $params;
                            $nex++; $k++;
                        }
                    }
                } else {
                    $data[$key] = $params;    
                }                
            }
        }

        $filename = "MONTHLY_HOURS_REPORT_BY_CLIENTS_".$month."_".$year.".xls";
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");
        
        if(!empty($data)) {
            foreach ($data as $key => $row) {
                if(!$flag) {
                  array_walk($row, array($this,'cleanData'));
                  echo implode("\t",$arry) . "\r\n";
                  $flag = true;
                }
                array_walk($row, array($this, 'cleanData'));
                $x = 1;
                echo implode("\t", array_values($row)) . "\r\n";
            }
        } else {
            $this->session->set_flashdata('error_message', 'Oops no record found.');
            redirect($this->agent->referrer());
        }
    }

    public function patientBilledHours($patient_id='') {
        if(isset($_SESSION['name']) && !empty($_GET['patient_id'])) {

            $patient_id = $_GET['patient_id'];

            $month = date('n');
            $year = date('Y');

            if(!empty($_GET['month'])) {
                $month = $_GET['month'];  
            }
            if(!empty($_GET['year'])) {
                $year = $_GET['year'];  
            }

            $SUM = "SUM(day01+day02+day03+day04+day05+day06+day07+day08+day09+day10+day11+day12+day13+day14+day15+day16+day17+day18+day19+day20+day21+day22+day23+day24+day25+day26+day27+day28+day29+day30+day31) AS totalWorkedHours";            

            $sql = "SELECT *, ".$SUM." FROM weekly_hours_by_client WHERE month = '".$month."' AND year = '".$year."' AND patient_id = '".$patient_id."' ORDER BY id";
            $pageData = $this->Comman_model->getCustomQueryData($sql, 'row');

            /*$where = [];
            $where['patient_id'] = $patient_id;
            $where['month'] = $month;
            $where['year'] = $year;
            $pageData = $this->Comman_model->get_row('weekly_hours_by_client', $where); */

            $where = [];
            $where['patient_id'] = $pageData['patient_id'];
            $data['patientData'] = $this->Comman_model->get_row('patient', $where);

            $data['month'] = $month;
            $data['year'] = $year;
            $data['patient_id'] = $pageData['patient_id'];
            $data['pageData'] = $pageData;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/patient-billed-hours.php',$data);
            $this->load->view('common/footer.php');
        } else {
          redirect('');
        }
    }

    public function calendarBilledHours() {

      $patient_id = $this->input->get('patient_id');
      $month = $this->input->get('month');
      $year = $this->input->get('year');

      $where =[];
      $where['patient_id'] = $patient_id;
      $where['month'] = $month;
      $where['year'] = $year;
      $row = $this->Comman_model->get_row('weekly_hours_by_client', $where);

      if(!empty($row)) {

        $agency_code = $row['agency_code'];
        
        $list = '';

        for ($i=1; $i <= 31 ; $i++) { 
            $d =  'day'.sprintf("%02s", $i);
            //$year = date('Y');
            $start_date = date('Y-m-d', strtotime($year.'-'.$month.'-'.$i));

            $billedHour = $row[$d];

            $status = '';
            $datetrans = $start_date;

            $chkSQL3 = "SELECT * FROM idoadb,idoadb_details WHERE idoadb.patient_id = '$patient_id' AND idoadb.idoa_id = idoadb_details.idoa_id AND idoadb_details.date = '$datetrans' AND idoadb.month='$month' AND idoadb.year='$year' AND idoadb_details.Agency='$agency_code' AND idoadb_details.status = 'Billed'";
            $objResult3 = get_custom_query_data($chkSQL3, 'row');
            if (!empty($objResult3)) { 
                $status = $objResult3['status'];    
            }

            if($status!='Billed') {
                $chkSQL3 = "SELECT * FROM idoadbLTS,idoadb_detailsLTS WHERE idoadbLTS.patient_id = '$patient_id' AND idoadbLTS.idoa_id = idoadb_detailsLTS.idoa_id AND date = '$datetrans' AND month='$month' AND year='$year' AND idoadb_detailsLTS.Agency='$agency_code' AND idoadb_detailsLTS.status = 'Billed'";
                $objResult3 = get_custom_query_data($chkSQL3, 'row');
                if (!empty($objResult3)) { 
                    $status = $objResult3['status'];    
                }
            }

            if($status!='Billed') {
                $chkSQL8 = "SELECT * FROM eclaims,eclaims_details WHERE  eclaims.cms1500_id = eclaims_details.cms1500_id AND eclaims_details.patient_id = '$patient_id' AND date = '$datetrans' AND eclaims_details.status = 'Billed' AND eclaims_details.Agency='$agency_code'";
                $objResult8 = get_custom_query_data($chkSQL8, 'row');
                if (!empty($objResult8)) { 
                    $status = $objResult8['status'];
                }
            }

            if($status!='Billed') {
                $chkSQL8 = "SELECT * FROM eclaimsLTS,eclaims_detailsLTS WHERE eclaimsLTS.cms1500_id = eclaims_detailsLTS.cms1500_id AND eclaims_detailsLTS.patient_id = '$patient_id' AND date = '$datetrans' AND eclaims_detailsLTS.status = 'Billed' AND eclaims_detailsLTS.Agency='$agency_code'";
                $objResult8 = get_custom_query_data($chkSQL8, 'row');
                if (!empty($objResult8))  { 
                    $status = $objResult8['status'];
                }
            }

            if(!empty($row[$d]) && $row[$d]!='0.00') {
                $billedHour = $billedHour.' Hr<br><h6 class="billed-text">'.$status.'</h6>';  
            }

            $eventArr[] =
                        [
                          'title'=>$billedHour,
                          'description'=>$list,
                          'start'=>$start_date,
                          'end'=>$start_date,
                          'textEscape' => false,
                          //'color' => '#000000',
                          //'backgroundColor' => '#ffffff'
                        ];
        }
           
      }       
      print_r(json_encode($eventArr));
    }

    public function totalWeeklyHourReport() {
        if(isset($_SESSION['name'])) {

            $data = [];

            $agency = $this->session->userdata('agency');

            $where = [];
            $where['em.Status'] = 1;
            //$where['pa.IsActive'] = 1;
            $where['em.Agency'] = $agency;
            //$where['pa.Agency'] = $agency;
            $having = '';
            if($_GET['workHour'] && $_GET['workHour']==40) {
                $having = "totalWorkedHours>40";
            }
            if($_GET['workHour'] && $_GET['workHour']==50) {
                $having = "totalWorkedHours>50";
            }
            //$where['ea.total_limit'] = 0;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedEmployeeData'] = $this->employee->getTotalWorkHourEmployeeData($where, $like, $not_like, $having);    
            //print_r($data['assignedEmployeeData']);die;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/total-weekly-hour-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function totalMonthHourReport() {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/total-month-hour-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function totalMonthHourReportNew() {
        if(isset($_SESSION['name'])) {
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/total-month-hour-report-new.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        } 
    }

    public function updateSSN() {
        $where = [];
        $where['Status'] = 1;
        $empData = $this->Comman_model->get_rows('employee', $where);
        foreach ($empData as $key => $row) {
            // code...
            if(!empty($row['ssn']) && $row['ssn']!=0 && $row['ssn']!='' && $row['ssn']!='0000-00-000') {
                $where = [];
                $where['employee_id'] = $row['employee_id'];

                $dataArray1 = [];
                $dataArray1['ssn'] = trim($row['ssn']);
                
                //$this->Comman_model->update('employee_clock_083121', $where, $dataArray1);

                $this->Comman_model->update('employee_finalsheet_083121', $where, $dataArray1);
                $this->Comman_model->update('employee_2finalsheet_083121', $where, $dataArray1);
            }
        }
        echo 'updated successfully';
    }

    public function deleteSingleRecordId() {

        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);


        //$where = [];
        //$empData = $this->Comman_model->get_rows('employee_clock_083121', $where);

        $sql = "SELECT * FROM employee_clock_083121 WHERE MONTH(date) = '8' and YEAR(date) = '2021'";
        $empData = $this->Comman_model->getCustomQueryData($sql);

        foreach ($empData as $key => $row) {
            // code...
            if(!empty($row['rec_id']) && $row['rec_id']!='') {
                $where = [];
                $where['employee_clock_id!='] = $row['employee_clock_id'];
                $where['rec_id'] = $row['rec_id'];

                $num = $this->Comman_model->countrow('employee_clock_083121', $where);

                if($num==0) {
                    $where = [];
                    $where['employee_clock_id'] = $row['employee_clock_id'];
                    $this->Comman_model->delete_row('employee_clock_083121', $where);
                }
                //$this->Comman_model->update('employee_finalsheet_083121', $where, $dataArray1);
                //$this->Comman_model->update('employee_2finalsheet_083121', $where, $dataArray1);
            }
        }
        echo 'deleted successfully.';
    }

    public function redeemCash() {
        if(isset($_SESSION['name'])) {
            $cashAmount = $_POST['cashAmount'];
            $emplid = $_POST['emplid'];
            if(!empty($cashAmount) && !empty($emplid)) {
                $where = [];
                $where['employee_id'] = $emplid;
                $rewardsData = $this->Comman_model->get_row('employee_rewards', $where);
                if($rewardsData['available_cash']>=$cashAmount) {

                    $dataArray = [];
                    $dataArray['employee_id'] = $emplid;
                    $dataArray['redeem_cash'] = $cashAmount;
                    $dataArray['created_on'] = date('Y-m-d h:i:s');
                    $this->Comman_model->insert('employee_redeem_history', $dataArray);

                    $where = [];
                    $where['employee_id'] = $emplid;

                    $dataArray1 = [];
                    $dataArray1['available_cash'] = $rewardsData['available_cash']-$cashAmount;

                    $this->Comman_model->update('employee_rewards', $where, $dataArray1);

                    print_r(1);
                } else {
                    print_r(2);
                }
            }
        } else {
            redirect();
        } 
    }


    public function updateAgency() {
        if(isset($_SESSION['name'])) {
            /*$where = [];
            $assData = $this->Comman_model->get_rows('employee_assignment', $where);
            foreach ($assData as $key => $row) {
                $where = [];
                $where['employee_id'] = $row['employee_id'];
                $empData = $this->Comman_model->get_row('employee', $where);

                $where = [];
                $where['patient_id'] = $row['patient_id'];
                $ptData = $this->Comman_model->get_row('patient', $where);

                $where = [];
                $where['employee_id'] = $row['employee_id'];
                $where['patient_id'] = $row['patient_id'];

                $dataArray = [];
                $dataArray['employee_agency'] = $empData['Agency'];
                $dataArray['patient_agency'] = $ptData['Agency'];
                $this->Comman_model->update('employee_assignment', $where, $dataArray);
            }
            echo 'Agency has been updated successfully.';*/
        } else {
            redirect();
        } 
    }


    public function updateEmployeeDevice() {
        if(isset($_SESSION['name'])) {

            $sql = "SELECT * FROM employee_clock WHERE DATE(date)>='2022-02-01' AND isIn=2 AND tagedit=6";
            $empCLockData = $this->Comman_model->getCustomQueryData($sql);
            $x=0;
            foreach ($empCLockData as $key => $row) {

                //echo $row['employee_id'];
                //echo '<br>';

                $where = [];
                $where['employee_id'] = $row['employee_id'];

                $dataArray = [];
                $dataArray['device'] = 6;
                $this->Comman_model->update('employee', $where, $dataArray);
                $x++;
            }
            echo $x.' Device column has been updated successfully.';
        } else {
            redirect();
        } 
    }


    /*public function updateEmployeeWorker() {
        if(isset($_SESSION['name'])) {

            $pdate = date('Y-m-d',strtotime("-1 days"));

            $sql = "SELECT DISTINCT(employee_id), tagedit, employee_clock_id FROM employee_clock WHERE DATE(date)='".$pdate."' AND isIn=2 AND tagedit IS NOT NULL";
            $empCLockData = $this->Comman_model->getCustomQueryData($sql);
            $x=0;
            foreach ($empCLockData as $key => $row) {
                //echo 'Employee Id : '.$row['employee_id'].' |||| tagedit : '.$row['tagedit'].' |||| Employee Clock Id : '.$row['employee_clock_id'];
                //echo '<br>';
                $where = [];
                $where['employee_id'] = $row['employee_id'];
                if($row['tagedit']==7) { // Web App
                    $dataArray = [];
                    $dataArray['web_app_user'] = 1;
                    $this->Comman_model->update('employee', $where, $dataArray);
                    $x++;
                }
                if($row['tagedit']==6 || $row['tagedit']==4) { // IOS OR ANDROID
                    $dataArray = [];
                    $dataArray['app_user'] = 1;
                    $this->Comman_model->update('employee', $where, $dataArray);
                    $x++;
                }
                if($row['tagedit']==3) { // Timesheet
                    $dataArray = [];
                    $dataArray['timesheet'] = 1;
                    $this->Comman_model->update('employee', $where, $dataArray);
                    $x++;
                }
            }

            $sql = "SELECT DISTINCT(employee_id), tagedit, employee_clock_id FROM employee_clock WHERE DATE(date)='".$pdate."' AND isIn=2 AND tagedit IS NULL";
            $empCLockData = $this->Comman_model->getCustomQueryData($sql);
            //$x=0;
            foreach ($empCLockData as $key => $row) {
                $where = [];
                $where['employee_id'] = $row['employee_id'];

                $dataArray = [];
                $dataArray['ivr_user'] = 1;
                $this->Comman_model->update('employee', $where, $dataArray);

                $x++;
            }
            echo $x.' Employee profile updated successfully.';
        } else {
            redirect();
        } 
    }*/

    public function testDate() {
        echo date('Y-m-d h:i a');
    }

    public function complianceList() {
        if (isset($_SESSION['name'])) { 
            $data['page']  = 'Employee Compliance';
            $data['pageData'] = $this->Comman_model->get_rows('employee_compliance','','id','desc');
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employee/compliance-list.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    function complianceAdd() {
        if (isset($_SESSION['name'])) { 
            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('compliance', 'compliance', 'trim|required|is_unique[employee_compliance.compliance]');
                $this->form_validation->set_message('is_unique', 'Compliance already exists. Please enter new one.');

                if ($this->form_validation->run() != false) {
                    $dataArray             = [];
                    $dataArray['compliance']  = $this->input->post('compliance',true);
                    $inserId = $this->Comman_model->insert( "employee_compliance", $dataArray );

                    if($inserId) {
                        $this->app->message('Compliance has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('employee/complianceList','refresh');
                }
            }

            $data['page'] = 'Add Compliance';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employee/compliance-add.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    public function complianceEdit($pageId='') {

        if (isset($_SESSION['name'])) { 

            if(!empty($pageId)) {
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['id'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('employee_compliance',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('compliance', 'compliance', 'trim|required|callback_compliance_check');

                if ($this->form_validation->run() != false) {

                    $dataArray             =    [];
                    $dataArray['compliance']  =    $this->input->post('compliance',true);

                    $where  = [];
                    $where['id'] = $pageId;

                    $updateId = $this->Comman_model->update( "employee_compliance", $where, $dataArray );

                    if($updateId) {
                        $this->app->message('Compliance has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('employee/complianceList','refresh');
                }
            }

            $data['page'] = 'Update compliance';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employee/compliance-edit.php', $data);
            $this->load->view('common/footer-view.php');
        } else {
            redirect('');
        }
    }  

    function compliance_check() {
        $compliance = $this->input->post('compliance',true);
        $pageId = $this->uri->segment('3');
        $pageId = decode64($pageId);

        $sql = "SELECT * FROM employee_compliance WHERE compliance='".$compliance."' AND id!='".$pageId."'";
        $row = $this->Comman_model->getCustomQueryData($sql, 'row');

        if (!empty($row)) {
            $this->form_validation->set_message('compliance_check', 'Compliance already exists. Please enter new one.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function complianceDelete($recordId){
        if(!empty($recordId)) {
            $recordId = decode64($recordId);
            $where = [];
            $where['id'] = $recordId;
            $check = $this->Comman_model->delete_row('employee_compliance',$where);
            $this->app->message('Compliance has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

    function unassignEmployeeBydate() {
        $date = $this->input->get('date');
        $employeeId = $this->input->get('employee_id');

        $where = [];
        $where['ea.employee_id'] = $employeeId;
        $like = [];
        $not_like = [];
        $not_like['ea.pin'] = '+';   
        $assignedPatientData = $this->employee->getAssignedPatientData($where, $like, $not_like);    

        foreach ($assignedPatientData as $key => $row) {
            $where  =   [];
            $where['employee_id']   =   $employeeId;
            $where['patient_id']    =   $row['patient_id'];
            $where['date<=']        =   $date;
            $eaData = $this->Comman_model->get_row('employee_clock', $where);
            if(!empty($eaData)) {

                $where  =   [];
                $where['employee_id']   =   $employeeId;
                $where['patient_id']   =   $eaData['patient_id'];

                $dataArray  =   [];
                $dataArray['pin'] = '+'.$row['pin'];

                $this->Comman_model->update('employee_assignment', $where, $dataArray);
            }
            //echo $eaData['date'];
            //echo '<br>';
        }
        echo 'Records has been updated successfully.';
    }

    public function rateRequest() {
        if (isset($_SESSION['name'])) {
            $cond = " WHERE 1";
            if(checkUserLevel('L', $this->session->userdata('userlevel'))) {
                //$cond = " WHERE status = 0";
            }
            if(checkUserLevel('P', $this->session->userdata('userlevel'))) {
                //$cond = " WHERE status = 1 OR status = 2";
                /************ Notification status updated code start ************/

                /************ Notification status updated code end ************/

            } else {
                $user_id = $this->session->userdata('id');
                //$cond = " WHERE (ls_id = '".$user_id."' OR ls_id2 = '".$user_id."' OR ls_id3 = '".$user_id."' OR sup_id = '".$user_id."')";                
                $cond = " WHERE (ls_id = '".$user_id."' OR ls_id2 = '".$user_id."' OR ls_id3 = '".$user_id."' OR sup_id = '".$user_id."' OR em_ls_id = '".$user_id."' OR em_ls_id2 = '".$user_id."' OR em_ls_id3 = '".$user_id."' OR em_sup_id = '".$user_id."')";
            }

            $status = @$_GET['status'];
            if($status!='') {
                $cond .= " AND status = '".$status."'";
            }

            //print_r($_SESSION);

            $query = "SELECT * FROM rate_request ".$cond." ORDER BY id DESC";
            $pageData  = $this->Comman_model->getCustomQueryData($query);
            $data['pageData'] = $pageData;
            $data['status'] = $status;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employee/rate-request.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function cutCheckRequest() {
        if (isset($_SESSION['name'])) {

            //print_r($_SESSION);

            $cond = " WHERE 1";
            if(checkUserLevel('L', $this->session->userdata('userlevel'))) {
                //$cond = " WHERE status = 0";
            }
            if(checkUserLevel('P', $this->session->userdata('userlevel'))) {
                //$cond = " WHERE status = 1 OR status = 2";


                /************ Notification status updated code start ************/

                /************ Notification status updated code end ************/

            } else {
                $user_id = $this->session->userdata('id');
                //$cond = " WHERE (ls_id = '".$user_id."' OR ls_id2 = '".$user_id."' OR ls_id3 = '".$user_id."' OR sup_id = '".$user_id."')";                
                $cond = " WHERE (ls_id = '".$user_id."' OR ls_id2 = '".$user_id."' OR ls_id3 = '".$user_id."' OR sup_id = '".$user_id."' OR em_ls_id = '".$user_id."' OR em_ls_id2 = '".$user_id."' OR em_ls_id3 = '".$user_id."' OR em_sup_id = '".$user_id."')";
            }

            $status = @$_GET['status'];
            if($status!='') {
                $cond .= " AND status = '".$status."'";
            }

            //print_r($_SESSION);

            $query = "SELECT * FROM cut_check ".$cond." ORDER BY id DESC";
            $pageData  = $this->Comman_model->getCustomQueryData($query);
            $data['pageData'] = $pageData;
            $data['status'] = $status;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employee/cut-check-request.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function attemptedVisitRequest() {
        if (isset($_SESSION['name'])) {

            //print_r($_SESSION);

            $cond = " WHERE 1";
            if(checkUserLevel('L', $this->session->userdata('userlevel'))) {
                $user_id = $this->session->userdata('id');
                $sql = "SELECT agency_location FROM users_portal WHERE user_id = '$user_id'";
                $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                $agency_location = $row['agency_location'];

                $cond = " WHERE agency_location_id = '$agency_location'";

            } else if(checkUserLevel('P', $this->session->userdata('userlevel'))) {

            } else {
                $user_id = $this->session->userdata('id');
                $cond = " WHERE (ls_id = '".$user_id."' OR ls_id2 = '".$user_id."' OR ls_id3 = '".$user_id."' OR ls_id4 = '".$user_id."' OR ls_id5 = '".$user_id."' OR sup_id = '".$user_id."'";                
                if(isset($_SESSION['googleUser'])) {
                    $user_id2 = $this->session->userdata('userId');
                    $cond .= " OR sup_id = '".$user_id2."'";
                }
                $cond .= ")";
            }

            $status = @$_GET['status'];
            if($status!='') {
                $cond .= " AND status = '".$status."'";
            }

            $query = "SELECT * FROM attempted_visit ".$cond." ORDER BY id DESC";
            $pageData  = $this->Comman_model->getCustomQueryData($query);
            $data['pageData'] = $pageData;
            $data['status'] = $status;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('employee/attempted-visit-request.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function cutCheckRequestStatusUpdate() {
        if (isset($_SESSION['name'])) {
            $recId = decode64($_POST['rec_id']);
            $status = $_POST['formsubmit'];

            if(!empty($recId) && $status!='') {
                $where  =   [];
                $where['id']   =   $recId;

                $dataArray  =   [];
                $dataArray['status'] = $status;
                if($status==1) {
                    $dataArray['approved_by'] = $this->session->userdata('id');
                    $dataArray['approved_timestamp'] = date('Y-m-d h:i:s');
                }
                if($status==2) {
                    $dataArray['printed_by'] = $this->session->userdata('id');
                    $dataArray['printed_timestamp'] = date('Y-m-d h:i:s');
                }
                $this->Comman_model->update('cut_check', $where, $dataArray);
                $this->session->set_flashdata('message','Status has been updated successfully.');
                if($status==1) {
                    /******* SEND MAIL TO PAYROLL AND SUP *********/
                    $this->sendMailToPayrollAndSup($recId, 'Approved');
                }
                if($status==2) {
                    /******* SEND MAIL TO PAYROLL AND SUP *********/
                    $this->sendMailToSupAndLS($recId, 'Printed');
                }
                redirect($this->agent->referrer());
            }
        } else {
            redirect('');
        }
    }

    public function rateRequestStatusUpdate() {
        if (isset($_SESSION['name'])) {
            $recId = decode64($_POST['rec_id']);
            $status = $_POST['formsubmit'];

            if(!empty($recId) && $status!='') {
                $where  =   [];
                $where['id']   =   $recId;

                $row = $this->Comman_model->get_row('rate_request', $where);

                $dataArray  =   [];
                $dataArray['status'] = $status;
                if($status==1) {                    
                    $dataArray['approved_by'] = $this->session->userdata('id');
                    $dataArray['approved_timestamp'] = date('Y-m-d h:i:s');
                }
                if($status==2) {
                    $dataArray['printed_by'] = $this->session->userdata('id');
                    $dataArray['printed_timestamp'] = date('Y-m-d h:i:s');
                }
                $this->Comman_model->update('rate_request', $where, $dataArray);
                $this->session->set_flashdata('message','Status has been updated successfully.');
                if($status==1) {
                    if($row['request_type']==1) {
                        $where = [];
                        $where['employee_id'] = $row['employee_id'];

                        $dataArray = [];
                        $dataArray['permanent_rate'] = $row['pay_rate'];

                        $this->Comman_model->update('employee', $where, $dataArray);
                    }

                    if($row['request_type']==2) {
                        $clients = explode(',', $row['client_ids']);
                        foreach ($clients as $clientId) {
                            $updateSql = "UPDATE employee_assignment SET temp_rate = '".$row['pay_rate']."' WHERE employee_id='".$row['employee_id']."' AND patient_id = '".$clientId."' AND pin NOT LIKE '%+%'";
                            set_custom_query_data($updateSql);
                        }
                    }
                    /******* SEND MAIL TO PAYROLL AND SUP *********/
                    $this->sendRateRequestMailToPayrollAndSup($recId, 'Approved');
                }
                if($status==2) {
                    /******* SEND MAIL TO PAYROLL AND SUP *********/
                    $this->sendRateRequestMailToSupAndLS($recId, 'Printed');
                }
                redirect($this->agent->referrer());
            }
        } else {
            redirect('');
        }
    }

    public function attemptedVisitRequestStatusUpdate() {
        if (isset($_SESSION['name'])) {
            $recId = decode64($_POST['rec_id']);
            $status = $_POST['formsubmit'];

            if(!empty($recId) && $status!='') {
                $where  =   [];
                $where['id']   =   $recId;

                $dataArray  =   [];
                $dataArray['status'] = $status;
                if($status==1) {
                    $dataArray['approved_by'] = $this->session->userdata('id');
                    $dataArray['approved_timestamp'] = date('Y-m-d h:i:s');
                }
                if($status==2) {
                    $dataArray['printed_by'] = $this->session->userdata('id');
                    $dataArray['printed_timestamp'] = date('Y-m-d h:i:s');
                }
                $this->Comman_model->update('attempted_visit', $where, $dataArray);
                $this->session->set_flashdata('message','Status has been updated successfully.');
                if($status==1) {
                    /******* SEND MAIL TO PAYROLL AND SUP *********/
                    $this->sendAttemptedVisitMailToPayrollAndSup($recId, 'Approved');
                }
                if($status==2) {
                    /******* SEND MAIL TO PAYROLL AND SUP *********/
                    $this->sendAttemptedVisitMailToSupAndLS($recId, 'Printed');
                }
                redirect($this->agent->referrer());
            }
        } else {
            redirect('');
        }
    }


    public function deniedCutCheckRequest() {
        if (isset($_SESSION['name'])) {
            $recId = decode64($_POST['rec_id']);
            $reason = $_POST['reason'];
            $status = $_POST['request_status'];
            if(!empty($recId) && !empty($reason)) {
                $where  =   [];
                $where['id']   =   $recId;

                $dataArray  =   [];                
                $dataArray['status'] = $status;
                if($status==3) {
                    $dataArray['denied_reason'] = $reason;
                    $dataArray['denied_by'] = $this->session->userdata('id');
                    $dataArray['denied_timestamp'] = date('Y-m-d h:i:s');    
                }
                if($status==4) {
                    $dataArray['cancelled_reason'] = $reason;
                    $dataArray['cancelled_by'] = $this->session->userdata('id');
                    $dataArray['cancelled_timestamp'] = date('Y-m-d h:i:s');    
                }                 
                $this->Comman_model->update('cut_check', $where, $dataArray);

                $this->session->set_flashdata('message','Status has been updated successfully.');
                /******* SEND MAIL TO SUP *********/
                if($status==3) {
                    $this->sendMailToSup($recId, 'Denied');                
                }
                if($status==4) {
                    $this->sendMailToSup($recId, 'Cancelled');
                } 
            } else {
                $this->session->set_flashdata('error_message','Oops! something went wrong try again.');
            }
            redirect($this->agent->referrer());
        } else {
            redirect('');
        }
    }

    public function deniedRateRequest() {
        if (isset($_SESSION['name'])) {
            $recId = decode64($_POST['rec_id']);
            $reason = $_POST['reason'];
            $status = $_POST['request_status'];
            if(!empty($recId) && !empty($reason)) {
                $where  =   [];
                $where['id']   =   $recId;

                $dataArray  =   [];                
                $dataArray['status'] = $status;
                if($status==3) {
                    $dataArray['denied_reason'] = $reason;
                    $dataArray['denied_by'] = $this->session->userdata('id');
                    $dataArray['denied_timestamp'] = date('Y-m-d h:i:s');    
                }
                if($status==4) {
                    $dataArray['cancelled_reason'] = $reason;
                    $dataArray['cancelled_by'] = $this->session->userdata('id');
                    $dataArray['cancelled_timestamp'] = date('Y-m-d h:i:s');    
                }                 
                $this->Comman_model->update('rate_request', $where, $dataArray);

                $this->session->set_flashdata('message','Status has been updated successfully.');
                /******* SEND MAIL TO SUP *********/
                if($status==3) {
                    $this->sendRateRequestMailToSup($recId, 'Denied');                
                }
                if($status==4) {
                    $this->sendRateRequestMailToSup($recId, 'Cancelled');
                } 
            } else {
                $this->session->set_flashdata('error_message','Oops! something went wrong try again.');
            }
            redirect($this->agent->referrer());
        } else {
            redirect('');
        }
    }

    public function deniedattemptedVisitRequest() {
        if (isset($_SESSION['name'])) {
            $recId = decode64($_POST['rec_id']);
            $reason = $_POST['reason'];
            $status = $_POST['request_status'];
            if(!empty($recId) && !empty($reason)) {
                $where  =   [];
                $where['id']   =   $recId;

                $dataArray  =   [];                
                $dataArray['status'] = $status;
                if($status==3) {
                    $dataArray['denied_reason'] = $reason;
                    $dataArray['denied_by'] = $this->session->userdata('id');
                    $dataArray['denied_timestamp'] = date('Y-m-d h:i:s');    
                }
                if($status==4) {
                    $dataArray['cancelled_reason'] = $reason;
                    $dataArray['cancelled_by'] = $this->session->userdata('id');
                    $dataArray['cancelled_timestamp'] = date('Y-m-d h:i:s');    
                }                 
                $this->Comman_model->update('attempted_visit', $where, $dataArray);

                $this->session->set_flashdata('message','Status has been updated successfully.');
                /******* SEND MAIL TO SUP *********/
                if($status==3) {
                    $this->sendAttemptedVisitMailToSup($recId, 'Denied');                
                }
                if($status==4) {
                    $this->sendAttemptedVisitMailToSup($recId, 'Cancelled');
                } 
            } else {
                $this->session->set_flashdata('error_message','Oops! something went wrong try again.');
            }
            redirect($this->agent->referrer());
        } else {
            redirect('');
        }
    }

    /*********** Status : Approved **********/
    function sendRateRequestMailToPayrollAndSup($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('rate_request', $where);

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['approved_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['em_ls_id'])) {
            array_push($lsArr, $row['em_ls_id']);
        }
        if(!empty($row['em_ls_id2'])) {
            array_push($lsArr, $row['em_ls_id2']);
        }
        if(!empty($row['em_ls_id3'])) {
            array_push($lsArr, $row['em_ls_id3']);
        }
        //$dataArray = [];
        //$dataArray['ls_id'] = implode(',', $lsArr);
        //$dataArray['sup_id'] = $row['sup_id'];
        //$dataArray['content'] = "Attempted visit request approved for ".$ptRow['name'];
        //$dataArray['status'] = '1';
        //$dataArray['notify_to'] = 'P';
        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        //$dataArray['notify_to'] = 'LS';
        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        //$dataArray['notify_to'] = 'S';
        //$dataArray['user_id'] = $row['requested_by'];
        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        /************* Code for notification data end *************/

        $requestType = "Rate increase request";

        /*$where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];*/

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];
        
        //$to2 = trim($supEmail);
        //$to3 = "demo@hcpcaregivers.com";
        //$to = "ankityadav036@gmail.com";
        $subject = "Rate increase Approved / ".$row['employee_name'];

        $status = "Approved By ".$userRow['name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</td>";

        //$message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table></td>";
        $message .= "</tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        $to = "payroll@hcpcaregivers.com";
        //mail($to,$subject,$message,$headers);
        $this->sendPHPMailerMail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);
        //mail($to3,$subject,$message,$headers);

        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
    }

    /*********** Status : Approved **********/
    function sendAttemptedVisitMailToPayrollAndSup($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('attempted_visit', $where);

        $where  =   [];
        $where['patient_id']   =   $row['patient_id'];
        $ptRow = $this->Comman_model->get_row('patient', $where);

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['approved_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['ls_id'])) {
            array_push($lsArr, $row['ls_id']);
        }
        if(!empty($row['ls_id2'])) {
            array_push($lsArr, $row['ls_id2']);
        }
        if(!empty($row['ls_id3'])) {
            array_push($lsArr, $row['ls_id3']);
        }
        //$dataArray = [];
        //$dataArray['ls_id'] = implode(',', $lsArr);
        //$dataArray['sup_id'] = $row['sup_id'];
        //$dataArray['content'] = "Attempted visit request approved for ".$ptRow['name'];
        //$dataArray['status'] = '1';
        //$dataArray['notify_to'] = 'P';
        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        //$dataArray['notify_to'] = 'LS';
        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        //$dataArray['notify_to'] = 'S';
        //$dataArray['user_id'] = $row['requested_by'];
        //$this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        /************* Code for notification data end *************/

        $requestType = "Attempted visit request";

        $where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];
        
        //$to2 = trim($supEmail);
        //$to3 = "demo@hcpcaregivers.com";
        //$to = "ankityadav036@gmail.com";
        $subject = "Attempted Visit Request Approved / ".$row['employee_name'];

        $status = "Approved By ".$userRow['name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</td>";

        $message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table>";
        $message .= "</td></tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        $to = "payroll@hcpcaregivers.com";
        //mail($to,$subject,$message,$headers);
        $this->sendPHPMailerMail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);
        //mail($to3,$subject,$message,$headers);

        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
    }

    /*********** Status : Approved **********/
    function sendMailToPayrollAndSup($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('cut_check', $where);

        $where  =   [];
        $where['patient_id']   =   $row['patient_id'];
        $ptRow = $this->Comman_model->get_row('patient', $where);

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['approved_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['ls_id'])) {
            array_push($lsArr, $row['ls_id']);
        }
        if(!empty($row['ls_id2'])) {
            array_push($lsArr, $row['ls_id2']);
        }
        if(!empty($row['ls_id3'])) {
            array_push($lsArr, $row['ls_id3']);
        }

        if(!empty($row['em_ls_id'])) {
            array_push($lsArr, $row['em_ls_id']);
        }
        if(!empty($row['em_ls_id2'])) {
            array_push($lsArr, $row['em_ls_id2']);
        }
        if(!empty($row['em_ls_id3'])) {
            array_push($lsArr, $row['em_ls_id3']);
        }

        $dataArray = [];
        $dataArray['ls_id'] = implode(',', $lsArr);
        $dataArray['sup_id'] = $row['sup_id'];
        $dataArray['content'] = "Cut check request approved for ".$ptRow['name'];
        $dataArray['status'] = '1';
        $dataArray['notify_to'] = 'P';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'LS';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'S';
        $dataArray['user_id'] = $row['requested_by'];
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        /************* Code for notification data end *************/

        if($row['request_type']==1) {
            $requestType = "Cut check request";
        }
        if($row['request_type']==2) {
            $requestType = "Void / Replacement";
        }

        $where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];
        
        //$to2 = trim($supEmail);
        //$to3 = "demo@hcpcaregivers.com";
        //$to = "ankityadav036@gmail.com";
        $subject = "Cut Check Request Approved / ".$row['employee_name'];


        $status = "Approved By ".$userRow['name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Pay Period</th><td>".$row['pay_period']."</td></tr>
        <tr><th>Pay Rate</th><td>".$row['pay_rate']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Where will the check be sent</th><td>".$row['check_sent']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        if(!empty($row['pay_history_id'])) {            
            $message .= "<br><table border=1 cellpadding=10>
            <tr><th>Start Date</th><th>Check #</th><th>Pay Date</th><th>Net Pay</th><th>Gross Pay</th><th>Reg Hrs</th><th>Overtime Hrs</th><th>Total Hrs</th><th>CST</th></tr>";
            $sqlP = "SELECT * FROM portal_pay_history WHERE id IN (".$row['pay_history_id'].")";
            $payHistoryData = $this->Comman_model->getCustomQueryData($sqlP);
            foreach ($payHistoryData as $pkey => $prow) {
                // code...
                $message .= "<tr><td>".date('m/d/Y', strtotime($prow['period_beginning_date']))."</td><td>".$prow['check_voucher']."</td><td>".$prow['pay_date']."</td><td>".$prow['net_pay']."</td><td>".$prow['gross_pay']."</td><td>".$prow['regular_hours']."</td><td>".$prow['overtime_hours']."</td><td>".$prow['total_hours']."</td><td>".$prow['cst']."</td></tr>";
            }
            $message .= "</table>";
        }
        $message .= "</td>";

        $paydata = unserialize(base64_decode($row['pay_data']));

        $message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table><br><table border=1 cellpadding=10><tr><th>Day / Date</th><th>Time In</th><th>Time Out</th><th>Hours</th></tr>";
        foreach ($paydata as $key1 => $row1) {
            if($key1=='data') {
                foreach ($row1 as $key2 => $row2) {
                    $message .= "<tr><td>".$row2['day']." <br> ".$row2['date']."</td><td>".$row2['timein']."</td><td>".$row2['timeout']."</td><td>".$row2['hours']."</td></tr>";                                        
                }
            }
            if($key1=='total') {
                $message .= '<tr><th colspan=4 align="center">Total Hours : '.$row1.'</th></tr>';
            }
        }
        $message .= "</table></td></tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        $to = "payroll@hcpcaregivers.com";
        //mail($to,$subject,$message,$headers);
        $this->sendPHPMailerMail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);
        //mail($to3,$subject,$message,$headers);

        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }


        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
    }


    /*********** Status : Printed **********/
    function sendMailToSupAndLS($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('cut_check', $where);

        if($row['request_type']==1) {
            $requestType = "Cut check request";
        }
        if($row['request_type']==2) {
            $requestType = "Void / Replacement";
        }

        $where  =   [];
        $where['patient_id']   =   $row['patient_id'];
        $ptRow = $this->Comman_model->get_row('patient', $where);

        $where  =   [];
        $where['agency_location_code']   =   $ptRow['agency_location'];
        $alRow = $this->Comman_model->get_row('agency_location', $where);

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['printed_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        $where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['ls_id'])) {
            array_push($lsArr, $row['ls_id']);
        }
        if(!empty($row['ls_id2'])) {
            array_push($lsArr, $row['ls_id2']);
        }
        if(!empty($row['ls_id3'])) {
            array_push($lsArr, $row['ls_id3']);
        }

        if(!empty($row['em_ls_id'])) {
            array_push($lsArr, $row['em_ls_id']);
        }
        if(!empty($row['em_ls_id2'])) {
            array_push($lsArr, $row['em_ls_id2']);
        }
        if(!empty($row['em_ls_id3'])) {
            array_push($lsArr, $row['em_ls_id3']);
        }

        $dataArray = [];
        $dataArray['ls_id'] = implode(',', $lsArr);
        $dataArray['sup_id'] = $row['sup_id'];
        $dataArray['content'] = "Cut check request printed for ".$ptRow['name'];
        $dataArray['status'] = '1';
        $dataArray['notify_to'] = 'P';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'LS';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'S';
        $dataArray['user_id'] = $row['requested_by'];
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        /************* Code for notification data end *************/

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];

        //$to = trim($lsEmail);
        //$to2 = trim($supEmail);        
        //$to2 = "demo@hcpcaregivers.com";
        //$to2 = "dnxtph@gmail.com";
        
        $subject = "Printed Cut Check Req / ".$row['employee_name'];

        $staus = "Printed By ".$userRow['name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Pay Period</th><td>".$row['pay_period']."</td></tr>
        <tr><th>Pay Rate</th><td>".$row['pay_rate']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Where will the check be sent</th><td>".$row['check_sent']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        if(!empty($row['pay_history_id'])) {            
            $message .= "<br><table border=1 cellpadding=10>
            <tr><th>Start Date</th><th>Check #</th><th>Pay Date</th><th>Net Pay</th><th>Gross Pay</th><th>Reg Hrs</th><th>Overtime Hrs</th><th>Total Hrs</th><th>CST</th></tr>";
            $sqlP = "SELECT * FROM portal_pay_history WHERE id IN (".$row['pay_history_id'].")";
            $payHistoryData = $this->Comman_model->getCustomQueryData($sqlP);
            foreach ($payHistoryData as $pkey => $prow) {
                // code...
                $message .= "<tr><td>".date('m/d/Y', strtotime($prow['period_beginning_date']))."</td><td>".$prow['check_voucher']."</td><td>".$prow['pay_date']."</td><td>".$prow['net_pay']."</td><td>".$prow['gross_pay']."</td><td>".$prow['regular_hours']."</td><td>".$prow['overtime_hours']."</td><td>".$prow['total_hours']."</td><td>".$prow['cst']."</td></tr>";
            }
            $message .= "</table>";
        }
        $message .= "</td>";

        $paydata = unserialize(base64_decode($row['pay_data']));


        $message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table><br><table border=1 cellpadding=10><tr><th>Day / Date</th><th>Time In</th><th>Time Out</th><th>Hours</th></tr>";
        foreach ($paydata as $key1 => $row1) {
            if($key1=='data') {
                foreach ($row1 as $key2 => $row2) {
                    $message .= "<tr><td>".$row2['day']." <br> ".$row2['date']."</td><td>".$row2['timein']."</td><td>".$row2['timeout']."</td><td>".$row2['hours']."</td></tr>";                                        
                }
            }
            if($key1=='total') {
                $message .= '<tr><th colspan=4 align="center">Total Hours : '.$row1.'</th></tr>';
            }
        }
        $message .= "</table></td></tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        $to = "payroll@hcpcaregivers.com";
        //mail($to,$subject,$message,$headers);
        $this->sendPHPMailerMail($to,$subject,$message,$headers);

        //$to = "ankityadav036@gmail.com";
        //$this->sendPHPMailerMail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/        
        if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/

        /************** Mail Send To Employee Lead Supervisors (LS) Start *****************/        
        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Employee Lead Supervisors (LS) End *****************/
    }

    /*********** Status : Printed **********/
    function sendRateRequestMailToSupAndLS($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('rate_request', $where);

        $requestType = "Rate increase";

        $where  =   [];
        $where['agency_location_code']   =   $ptRow['agency_location'];
        $alRow = $this->Comman_model->get_row('agency_location', $where);

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['printed_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        /*$where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];*/

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['em_ls_id'])) {
            array_push($lsArr, $row['em_ls_id']);
        }
        if(!empty($row['em_ls_id2'])) {
            array_push($lsArr, $row['em_ls_id2']);
        }
        if(!empty($row['em_ls_id3'])) {
            array_push($lsArr, $row['em_ls_id3']);
        }
        /*$dataArray = [];
        $dataArray['ls_id'] = implode(',', $lsArr);
        $dataArray['sup_id'] = $row['sup_id'];
        $dataArray['content'] = "Attempted visit request printed for ".$ptRow['name'];
        $dataArray['status'] = '1';
        $dataArray['notify_to'] = 'P';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'LS';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'S';
        $dataArray['user_id'] = $row['requested_by'];
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);*/
        /************* Code for notification data end *************/

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];

        //$to = trim($lsEmail);
        //$to2 = trim($supEmail);        
        //$to2 = "demo@hcpcaregivers.com";
        //$to2 = "dnxtph@gmail.com";
        //$to = "ankityadav036@gmail.com";
        $subject = "Printed rate increase Req / ".$row['employee_name'];

        $staus = "Printed By ".$userRow['name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</td>";

        //$message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table></td><";
        $message .= "/tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        $to = "payroll@hcpcaregivers.com";
        //mail($to,$subject,$message,$headers);
        $this->sendPHPMailerMail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/        
        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }

    /*********** Status : Printed **********/
    function sendAttemptedVisitMailToSupAndLS($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('cut_check', $where);

        $requestType = "Attempted Visit";

        $where  =   [];
        $where['patient_id']   =   $row['patient_id'];
        $ptRow = $this->Comman_model->get_row('patient', $where);

        $where  =   [];
        $where['agency_location_code']   =   $ptRow['agency_location'];
        $alRow = $this->Comman_model->get_row('agency_location', $where);

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['printed_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        $where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['ls_id'])) {
            array_push($lsArr, $row['ls_id']);
        }
        if(!empty($row['ls_id2'])) {
            array_push($lsArr, $row['ls_id2']);
        }
        if(!empty($row['ls_id3'])) {
            array_push($lsArr, $row['ls_id3']);
        }
        /*$dataArray = [];
        $dataArray['ls_id'] = implode(',', $lsArr);
        $dataArray['sup_id'] = $row['sup_id'];
        $dataArray['content'] = "Attempted visit request printed for ".$ptRow['name'];
        $dataArray['status'] = '1';
        $dataArray['notify_to'] = 'P';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'LS';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'S';
        $dataArray['user_id'] = $row['requested_by'];
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);*/
        /************* Code for notification data end *************/

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];

        //$to = trim($lsEmail);
        //$to2 = trim($supEmail);        
        //$to2 = "demo@hcpcaregivers.com";
        //$to2 = "dnxtph@gmail.com";
        //$to = "ankityadav036@gmail.com";
        $subject = "Printed Attempted visit Req / ".$row['employee_name'];

        $staus = "Printed By ".$userRow['name'];

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</td>";

        $message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table>";
        $message .= "</td></tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        $to = "payroll@hcpcaregivers.com";
        //mail($to,$subject,$message,$headers);
        $this->sendPHPMailerMail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/        
        if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }


    /*********** Status : Denied **********/
    function sendMailToSup($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('cut_check', $where);

        if($row['request_type']==1) {
            $requestType = "Cut check request";
        }
        if($row['request_type']==2) {
            $requestType = "Void / Replacement";
        }

        $where  =   [];
        $where['patient_id']   =   $row['patient_id'];
        $ptRow = $this->Comman_model->get_row('patient', $where);

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['ls_id'])) {
            array_push($lsArr, $row['ls_id']);
        }
        if(!empty($row['ls_id2'])) {
            array_push($lsArr, $row['ls_id2']);
        }
        if(!empty($row['ls_id3'])) {
            array_push($lsArr, $row['ls_id3']);
        }

        if(!empty($row['em_ls_id'])) {
            array_push($lsArr, $row['em_ls_id']);
        }
        if(!empty($row['em_ls_id2'])) {
            array_push($lsArr, $row['em_ls_id2']);
        }
        if(!empty($row['em_ls_id3'])) {
            array_push($lsArr, $row['em_ls_id3']);
        }

        $dataArray = [];
        $dataArray['ls_id'] = implode(',', $lsArr);
        $dataArray['sup_id'] = $row['sup_id'];

        if($status=='Denied') {
            $dataArray['user_id'] = $row['denied_by'];
            $dataArray['content'] = "Cut check request denied for ".$ptRow['name'];
            $dataArray['status'] = '3';
        }
        if($status=='Cancelled') {
            $dataArray['user_id'] = $row['cancelled_by'];
            $dataArray['content'] = "Cut check request cancelled for ".$ptRow['name'];
            $dataArray['status'] = '4';
        }

        $dataArray['notify_to'] = 'LS';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'S';
        $dataArray['user_id'] = $row['requested_by'];
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        /************* Code for notification data end *************/

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['denied_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        $where  =   [];
        $where['agency_location_code']   =   $ptRow['agency_location'];
        $alRow = $this->Comman_model->get_row('agency_location', $where);

        $where  =   [];
        $where['supervisor_id']   =   $alRow['lead_supervisor'];
        $lsRow = $this->Comman_model->get_row('supervisor', $where);
        $lsEmail = $lsRow['email'];

        $where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];

        //$to = trim($lsEmail);
        //$to2 = trim($supEmail);
        //$to = "payroll@hcpcaregivers.com";
        //$to = "demo@hcpcaregivers.com";
        //$to2 = "dnxtph@gmail.com";
        //$to = "ankityadav036@gmail.com";
        if($status=='Denied') {
            $subject = "Denied Cut Check Req / ".$row['employee_name'];
            $staus = "Denied By ".$userRow['name'];
        }

        if($status=='Cancelled') {
            $subject = "Cancelled Cut Check Req / ".$row['employee_name'];
            $staus = "Cancelled By ".$userRow['name'];
        }

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Pay Period</th><td>".$row['pay_period']."</td></tr>
        <tr><th>Pay Rate</th><td>".$row['pay_rate']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Where will the check be sent</th><td>".$row['check_sent']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        if(!empty($row['pay_history_id'])) {            
            $message .= "<br><table border=1 cellpadding=10>
            <tr><th>Start Date</th><th>Check #</th><th>Pay Date</th><th>Net Pay</th><th>Gross Pay</th><th>Reg Hrs</th><th>Overtime Hrs</th><th>Total Hrs</th><th>CST</th></tr>";
            $sqlP = "SELECT * FROM portal_pay_history WHERE id IN (".$row['pay_history_id'].")";
            $payHistoryData = $this->Comman_model->getCustomQueryData($sqlP);
            foreach ($payHistoryData as $pkey => $prow) {
                // code...
                $message .= "<tr><td>".date('m/d/Y', strtotime($prow['period_beginning_date']))."</td><td>".$prow['check_voucher']."</td><td>".$prow['pay_date']."</td><td>".$prow['net_pay']."</td><td>".$prow['gross_pay']."</td><td>".$prow['regular_hours']."</td><td>".$prow['overtime_hours']."</td><td>".$prow['total_hours']."</td><td>".$prow['cst']."</td></tr>";
            }
            $message .= "</table>";
        }
        $message .= "</td>";

        $paydata = unserialize(base64_decode($row['pay_data']));


        $message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table><br><table border=1 cellpadding=10><tr><th>Day / Date</th><th>Time In</th><th>Time Out</th><th>Hours</th></tr>";
        foreach ($paydata as $key1 => $row1) {
            if($key1=='data') {
                foreach ($row1 as $key2 => $row2) {
                    $message .= "<tr><td>".$row2['day']." <br> ".$row2['date']."</td><td>".$row2['timein']."</td><td>".$row2['timeout']."</td><td>".$row2['hours']."</td></tr>";                                        
                }
            }
            if($key1=='total') {
                $message .= '<tr><th colspan=4 align="center">Total Hours : '.$row1.'</th></tr>';
            }
        }
        $message .= "</table></td></tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";
        //mail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/        
        if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/


        /************** Mail Send To Employee Lead Supervisors (LS) Start *****************/        
        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Employee Lead Supervisors (LS) End *****************/
    }

    /*********** Status : Denied **********/
    function sendRateRequestMailToSup($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('rate_request', $where);

        $requestType = "Rate increase";

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['ls_id'])) {
            array_push($lsArr, $row['ls_id']);
        }
        if(!empty($row['ls_id2'])) {
            array_push($lsArr, $row['ls_id2']);
        }
        if(!empty($row['ls_id3'])) {
            array_push($lsArr, $row['ls_id3']);
        }        

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['denied_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        $where  =   [];
        $where['agency_location_code']   =   $ptRow['agency_location'];
        $alRow = $this->Comman_model->get_row('agency_location', $where);

        $where  =   [];
        $where['supervisor_id']   =   $alRow['lead_supervisor'];
        $lsRow = $this->Comman_model->get_row('supervisor', $where);
        $lsEmail = $lsRow['email'];

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];

        //$to = trim($lsEmail);
        //$to2 = trim($supEmail);
        //$to = "payroll@hcpcaregivers.com";
        //$to = "demo@hcpcaregivers.com";
        //$to2 = "dnxtph@gmail.com";
        //$to = "ankityadav036@gmail.com";
        if($status=='Denied') {
            $subject = "Denied Rate Increase Req / ".$row['employee_name'];
            $staus = "Denied By ".$userRow['name'];
        }

        if($status=='Cancelled') {
            $subject = "Cancelled Rate Increase Req / ".$row['employee_name'];
            $staus = "Cancelled By ".$userRow['name'];
        }

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</td>";

        //$message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table></td>";
        $message .= "</tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";
        //mail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/        
        if(!empty($row['em_ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['em_ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['em_ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }

    /*********** Status : Denied **********/
    function sendAttemptedVisitMailToSup($recId, $status) {

        $where  =   [];
        $where['id']   =   $recId;
        $row = $this->Comman_model->get_row('attempted_visit', $where);

        $requestType = "Attempted Visit";

        $where  =   [];
        $where['patient_id']   =   $row['patient_id'];
        $ptRow = $this->Comman_model->get_row('patient', $where);

        /************* Code for notification data start *************/
        $lsArr = [];
        if(!empty($row['ls_id'])) {
            array_push($lsArr, $row['ls_id']);
        }
        if(!empty($row['ls_id2'])) {
            array_push($lsArr, $row['ls_id2']);
        }
        if(!empty($row['ls_id3'])) {
            array_push($lsArr, $row['ls_id3']);
        }

        /*$dataArray = [];
        $dataArray['ls_id'] = implode(',', $lsArr);
        $dataArray['sup_id'] = $row['sup_id'];

        if($status=='Denied') {
            $dataArray['user_id'] = $row['denied_by'];
            $dataArray['content'] = "Attempted visit request denied for ".$ptRow['name'];
            $dataArray['status'] = '3';
        }
        if($status=='Cancelled') {
            $dataArray['user_id'] = $row['cancelled_by'];
            $dataArray['content'] = "Attempted visit request cancelled for ".$ptRow['name'];
            $dataArray['status'] = '4';
        }

        $dataArray['notify_to'] = 'LS';
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);
        $dataArray['notify_to'] = 'S';
        $dataArray['user_id'] = $row['requested_by'];
        $this->Comman_model->insert("tbl_cut_check_notifications", $dataArray);*/
        /************* Code for notification data end *************/

        $where  =   [];
        $where['employee_id']   =   $row['employee_id'];
        $empRow = $this->Comman_model->get_row('employee', $where);

        $where  =   [];
        $where['user_id']   =   $row['denied_by'];
        $userRow = $this->Comman_model->get_row('users_portal', $where);

        $where  =   [];
        $where['agency_location_code']   =   $ptRow['agency_location'];
        $alRow = $this->Comman_model->get_row('agency_location', $where);

        $where  =   [];
        $where['supervisor_id']   =   $alRow['lead_supervisor'];
        $lsRow = $this->Comman_model->get_row('supervisor', $where);
        $lsEmail = $lsRow['email'];

        $where  =   [];
        $where['supervisor_id']   =   $ptRow['supervisor_id'];
        $supRow = $this->Comman_model->get_row('supervisor', $where);
        $supEmail = $supRow['email'];

        $ssnArr = explode('-', $row['ssn']);
        $ssn = $ssnArr[2];

        //$to = trim($lsEmail);
        //$to2 = trim($supEmail);
        //$to = "payroll@hcpcaregivers.com";
        //$to = "demo@hcpcaregivers.com";
        //$to2 = "dnxtph@gmail.com";
        //$to = "ankityadav036@gmail.com";
        if($status=='Denied') {
            $subject = "Denied Attempted Visit Req / ".$row['employee_name'];
            $staus = "Denied By ".$userRow['name'];
        }

        if($status=='Cancelled') {
            $subject = "Cancelled Attempted Visit Req / ".$row['employee_name'];
            $staus = "Cancelled By ".$userRow['name'];
        }

        $message = "
        <table width=100%>
        <tr><td>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</td>";

        $message .= "<td><table border=1 cellpadding=10><tr><th>Employee Name</th><td>".$row['employee_name']."</td></tr><tr><th>Patient Name</th><td>".$row['patient_name']." / ".$row['patient_id']."</td></tr><tr><th>Supervisor Name</th><td>".$supRow['name']."</td></tr></table>";
        $message .= "</td></tr></table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";
        //mail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            $where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);
            $reqEmail = trim($reqRow['email']);
            //mail($reqEmail,$subject,$message,$headers);
            $this->sendPHPMailerMail($reqEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/        
        if(!empty($row['ls_id'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id'];
            $lsupRow = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id2'];
            $lsupRow2 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $where  =   [];
            $where['user_id']   =   $row['ls_id3'];
            $lsupRow3 = $this->Comman_model->get_row('users_portal', $where);
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }

    public function inservicetraining() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $agency_code = $this->session->userdata('agency');

            $where  = [];
            $where['employee_id']   = $_GET['employee'];
            $employeeData           = $this->Comman_model->get_row('employee', $where);
            $data['employeeData']   = $employeeData;

            $where= [];
            $where['employee_id']   = $_GET['employee'];
            $where['Agency']        = $agency_code;
            $where['status']        = 0;
            $data['pageData']       = $this->Comman_model->get_rows('tblemployeservicetraining', $where, 'VisitDoneDate', 'desc');
            $data['employee_id']    =  $_GET['employee']; 

            $sql = "SELECT * FROM portal_pay_history WHERE adp = '".$employeeData['ADP']."' ORDER BY id DESC LIMIT 1";
            $data['payHistoryData'] = $this->Comman_model->getCustomQueryData($sql, 'row');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/view-service-training.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function attemptedVisit() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $agency_code = $this->session->userdata('agency');

            $where  = [];
            $where['employee_id']   = $_GET['employee'];
            $employeeData           = $this->Comman_model->get_row('employee', $where);
            $data['employeeData']   = $employeeData;

            $where= [];
            $where['employee_id']   = $_GET['employee'];
            $data['pageData']       = $this->Comman_model->get_rows('attempted_visit', $where, 'id', 'desc');

            $data['employee_id']    =  $_GET['employee']; 

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/attempted-visit.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    public function addAttemptedVisit() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {

            $where= [];
            $where['employee_id'] = $_GET['employee'];
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $where= [];
            $where['employee_id'] = $_GET['employee'];
            $data['pageData'] = $this->Comman_model->get_rows('attempted_visit', $where);

            if(!empty( $this->input->post('submit'))){
                $this->form_validation->set_rules('assigned_client', 'Client', 'trim|required');
                $this->form_validation->set_rules('reason', 'Reason', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $employeeId = $_GET['employee'];

                    $clientId = $this->input->post('assigned_client',true);
                    $reason = $this->input->post('reason',true);  

                    $query = "SELECT * FROM employee WHERE employee_id = '$employeeId'";
                    $employeeRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM patient WHERE patient_id = '$clientId'";
                    $patientRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM agency WHERE agency_code = '".$patientRow['Agency']."'";
                    $agencyRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM agency_location WHERE agency_location_code = '".$patientRow['agency_location']."'";
                    $agencyLocationRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $empName = $employeeRow['name'];
                    $ptName = $patientRow['name'];
                    $ssn = $employeeRow['ssn'];

                    $dataArray                       = [];
                    $dataArray['employee_id']        = $_GET['employee'];
                    $dataArray['employee_name']      = $empName;
                    $dataArray['patient_id']         = $clientId;
                    $dataArray['patient_name']       = $ptName;
                    $dataArray['ssn']                = $ssn;
                    $dataArray['reason']             = $reason;
                    $dataArray['requested_by']       = $this->session->userdata('id');
                    //$dataArray['username']         = $this->session->userdata('name');
                    $dataArray['agency_id']          = $patientRow['Agency'];
                    $dataArray['agency_name']        = $agencyRow['agency_codename'];
                    $dataArray['agency_location_id'] = $patientRow['agency_location'];
                    $dataArray['agency_location_name'] = $agencyLocationRow['agency_location_name'];
                    $dataArray['ls_id']  = $agencyLocationRow['lead_supervisor'];
                    $dataArray['ls_id2'] = $agencyLocationRow['lead_supervisor2'];
                    $dataArray['ls_id3'] = $agencyLocationRow['lead_supervisor3'];
                    $dataArray['sup_id'] = $patientRow['supervisor_id'];
                    $dataArray['request_type'] = 'Attempted Visit';
                    $dataArray['datetrans'] = date('Y-m-d');

                    $inserId = $this->Comman_model->insert( "attempted_visit", $dataArray );

                    if($inserId) {

                        /************* Send mail to Lead Supervisor Start *************/
                        $this->sendMailToLeadSupervisor($inserId, 'Pending');
                        /************* Send mail to Lead Supervisor End *************/

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user add employee attempted visit to employee id '.$_GET['employee'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################
                        $this->app->message('Attempted visit has been added successfully.', 'success');
                    } else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('employee/attemptedVisit?employee='.$_GET['employee'],'refresh');
                }
            }


            $where = [];
            $where['ea.employee_id'] = $_GET['employee'];
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where, $like, $not_like);    

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add-attempted-visit.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function addAttemptedVisitFromTimesheet() {
        if(isset($_SESSION['name']) && !empty($_POST['employee']) && !empty($_POST['patient'])) {
            $where= [];
            $where['employee_id'] = $_POST['employee'];
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $where= [];
            $where['employee_id'] = $_POST['employee'];
            $data['pageData'] = $this->Comman_model->get_rows('attempted_visit', $where);

            if(!empty($this->input->post('submit'))) {
                $clock_in = $this->input->post('clock_in',true);
                $clock_in1 = date('Y-m-d', strtotime($clock_in));                

                $atvMonth = date('m', strtotime($clock_in));
                $atvYear = date('Y', strtotime($clock_in));        

                if($clock_in1>date('Y-m-d')) {
                    $this->session->set_flashdata('date_error_message', 'Future date not allowed.');
                    redirect($this->agent->referrer());
                }

                $sqlatv = "SELECT count(*) as totalATV FROM attempted_visit WHERE patient_id = '".$_POST['patient']."' AND employee_id = '".$_POST['employee']."' AND status = 1 AND MONTH(clock_in) = '".$atvMonth."' AND YEAR(clock_in) = '".$atvYear."'";
                $rowatv = $this->Comman_model->getCustomQueryData($sqlatv, 'row');

                if(!empty($rowatv) && $rowatv['totalATV']>=2) {
                    $this->session->set_flashdata('date_error_message', 'Please contact payroll department, max  of 2 ATV per month only.');
                    redirect($this->agent->referrer());
                }

                $this->form_validation->set_rules('clock_in', 'Clock In', 'trim|required');
                $this->form_validation->set_rules('patient', 'Client', 'trim|required');
                $this->form_validation->set_rules('reason', 'Reason', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $employeeId = $_POST['employee'];
                    $clientId = $this->input->post('patient',true);
                    $reason = $this->input->post('reason',true);  
                    $clock_in = $this->input->post('clock_in',true);  
                    $clock_in = date('Y-m-d H:i:s', strtotime($clock_in));

                    $pay_period = $this->input->post('pay_period',true);  
                    $datetrans = $this->input->post('datetrans',true);  
                    $action = $this->input->post('action',true);  
                    $shift = $this->input->post('shift',true);  

                    $query = "SELECT * FROM employee WHERE employee_id = '$employeeId'";
                    $employeeRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM patient WHERE patient_id = '$clientId'";
                    $patientRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM agency WHERE agency_code = '".$patientRow['Agency']."'";
                    $agencyRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM agency_location WHERE agency_location_code = '".$patientRow['agency_location']."'";
                    $agencyLocationRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $empName = $employeeRow['name'];
                    $ptName = $patientRow['name'];
                    $ssn = $employeeRow['ssn'];

                    $dataArray                       = [];
                    $dataArray['employee_id']        = $employeeId;
                    $dataArray['employee_name']      = $empName;
                    $dataArray['patient_id']         = $clientId;
                    $dataArray['patient_name']       = $ptName;
                    $dataArray['ssn']                = $ssn;
                    $dataArray['clock_in']           = $clock_in;
                    $dataArray['pay_period']         = $pay_period;
                    $dataArray['reason']             = $reason;
                    $dataArray['period']             = $action;
                    $dataArray['code']               = $shift;
                    $dataArray['requested_by']       = $this->session->userdata('id');
                    //$dataArray['username']         = $this->session->userdata('name');
                    $dataArray['agency_id']          = $patientRow['Agency'];
                    $dataArray['agency_name']        = $agencyRow['agency_codename'];
                    $dataArray['agency_location_id'] = $patientRow['agency_location'];
                    $dataArray['agency_location_name'] = $agencyLocationRow['agency_location_name'];
                    $dataArray['ls_id']  = $agencyLocationRow['lead_supervisor'];
                    $dataArray['ls_id2'] = $agencyLocationRow['lead_supervisor2'];
                    $dataArray['ls_id3'] = $agencyLocationRow['lead_supervisor3'];
                    $dataArray['ls_id4'] = $agencyLocationRow['lead_supervisor4'];
                    $dataArray['ls_id5'] = $agencyLocationRow['lead_supervisor5'];
                    $dataArray['sup_id'] = $patientRow['supervisor_id'];
                    $dataArray['request_type'] = 'Attempted Visit';
                    $dataArray['datetrans'] = $datetrans;

                    $inserId = $this->Comman_model->insert( "attempted_visit", $dataArray );

                    if($inserId) {

                        /************* Send mail to Lead Supervisor Start *************/
                        $this->sendMailToLeadSupervisor($inserId, 'Pending');
                        /************* Send mail to Lead Supervisor End *************/

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user add employee attempted visit to employee id '.$_GET['employee'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################
                        $this->session->set_flashdata('message', 'Attempted visit has been added successfully.');
                    } else{
                        $this->session->set_flashdata('error_message', 'Oops! something went wrong try again.');
                    }
                }
                redirect($this->agent->referrer());
            }
        } else {
            redirect($this->agent->referrer());
        }
    }

    function sendMailToLeadSupervisor($recId, $status) {

        $query = "SELECT * FROM attempted_visit WHERE id = '$recId'";
        $row = $this->Comman_model->getCustomQueryData($query, 'row');

        $requestType = "Attempted Visit";

        $query = "SELECT * FROM employee WHERE employee_id = '".$row['employee_id']."'";
        $empRow = $this->Comman_model->getCustomQueryData($query, 'row');

        $query = "SELECT * FROM patient WHERE patient_id = '".$row['patient_id']."'";
        $ptRow = $this->Comman_model->getCustomQueryData($query, 'row');

        $query = "SELECT * FROM supervisor WHERE supervisor_id = '".$ptRow['supervisor_id']."'";
        $supRow = $this->Comman_model->getCustomQueryData($query, 'row');
        $supEmail = $supRow['email'];

        $query = "SELECT * FROM supervisor WHERE supervisor_id = '".$row['ls_id']."'";
        $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
        $lsupEmail = $lsupRow['email'];        
        //$ssnArr = explode('-', $row['ssn']);
        //$ssn = $ssnArr[2];

        //$to = "payroll@hcpcaregivers.com";
        //$to2 = trim($lsupEmail);
        $to3 = "demo@hcpcaregivers.com";
        $subject = "Attempted Visit Request / ".$row['employee_name'];

        $message = "
        <table width=100%>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Worker's name</th><td>".$row['employee_name']."</td></tr>
        <tr><th>ADP</th><td>".$empRow['ADP']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        //$to = "ankityadav036@gmail.com";
        //mail($to,$subject,$message,$headers);
        //mail($to2,$subject,$message,$headers);
        //mail($to3,$subject,$message,$headers);
        $this->sendPHPMailerMail($to3,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            /*$where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);            
            $reqEmail = trim($reqRow['email']);
            mail($reqEmail,$subject,$message,$headers);*/
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/        
        if(!empty($row['ls_id'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id']."'";
            $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id2']."'";
            $lsupRow2 = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail2 = trim($lsupRow2['email']);
            //mail($lsupEmail2,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id3']."'";
            $lsupRow3 = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail3 = trim($lsupRow3['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        if(!empty($row['ls_id4'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id4']."'";
            $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id5'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id5']."'";
            $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail = trim($lsupRow['email']);
            //mail($lsupEmail3,$subject,$message,$headers);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }

    public function deleteAttemptedVisit() {
        $id = $this->input->get('delete_id');
        $query = "DELETE FROM attempted_visit WHERE id='".$id."'";
        set_custom_query_data($query);
        ############### USER ACTION TRACKING START ####################
        if($this->session->userdata('id')!=6) {
            $dataArray = [];
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted employee attempted visit from employee id '.$pageData['employee_id'].' at '. date('m/d/Y H:i:s');
            $this->Comman_model->insert('users_tracking', $dataArray);
        }
        ############### USER ACTION TRACKING END ####################
        $this->app->message('Employee attempted visit has been deleted successfully.', 'success');
        redirect($this->agent->referrer());
    }

    public function editAttemptedVisit() {

        if(isset($_SESSION['name']) && !empty($_GET['employee']) && !empty($_GET['recid'])) {
            $where= [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $where= [];
            $where['id'] = decode64($_GET['recid']);
            $data['pageData'] = $this->Comman_model->get_row('attempted_visit', $where);

            if(!empty($this->input->post('submit'))) {

                $this->form_validation->set_rules('assigned_client', 'Client', 'trim|required');
                $this->form_validation->set_rules('reason', 'Reason', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $employeeId = $_GET['employee'];

                    $clientId = $this->input->post('assigned_client',true);
                    $reason = $this->input->post('reason',true);  

                    $query = "SELECT * FROM employee WHERE employee_id = '$employeeId'";
                    $employeeRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM patient WHERE patient_id = '$clientId'";
                    $patientRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM agency WHERE agency_code = '".$patientRow['Agency']."'";
                    $agencyRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $query = "SELECT * FROM agency_location WHERE agency_location_code = '".$patientRow['agency_location']."'";
                    $agencyLocationRow = $this->Comman_model->getCustomQueryData($query, 'row');

                    $empName = $employeeRow['name'];
                    $ptName = $patientRow['name'];
                    $ssn = $employeeRow['ssn'];

                    $dataArray                       = [];
                    $dataArray['employee_id']        = $_GET['employee'];
                    $dataArray['employee_name']      = $empName;
                    $dataArray['patient_id']         = $clientId;
                    $dataArray['patient_name']       = $ptName;
                    $dataArray['ssn']                = $ssn;
                    $dataArray['reason']             = $reason;
                    $dataArray['requested_by']       = $this->session->userdata('id');
                    //$dataArray['username']         = $this->session->userdata('name');
                    $dataArray['agency_id']          = $patientRow['Agency'];
                    $dataArray['agency_name']        = $agencyRow['agency_codename'];
                    $dataArray['agency_location_id'] = $patientRow['agency_location'];
                    $dataArray['agency_location_name'] = $agencyLocationRow['agency_location_name'];
                    $dataArray['ls_id']  = $agencyLocationRow['lead_supervisor'];
                    $dataArray['ls_id2'] = $agencyLocationRow['lead_supervisor2'];
                    $dataArray['ls_id3'] = $agencyLocationRow['lead_supervisor3'];
                    $dataArray['ls_id4'] = $agencyLocationRow['lead_supervisor4'];
                    $dataArray['ls_id5'] = $agencyLocationRow['lead_supervisor5'];
                    $dataArray['sup_id'] = $patientRow['supervisor_id'];
                    $dataArray['request_type'] = 'Attempted Visit';
                    $dataArray['datetrans'] = date('Y-m-d');

                    $where  =   [];
                    $where['id']  =   decode64($_GET['recid']);
                    $update = $this->Comman_model->update( "attempted_visit", $where, $dataArray );

                    if($update){
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user update employee Attempted visit to employee id '.$_GET['employee'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);
                        }
                        ############### USER ACTION TRACKING END ####################
                        $this->app->message('Attempted Visit has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('employee/attemptedVisit?employee='.$_GET['employee'],'refresh');
                }
            }

            $where = [];
            $where['ea.employee_id'] = $_GET['employee'];
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $data['assignedPatientData'] = $this->employee->getAssignedPatientData($where, $like, $not_like);    

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/edit-attempted-visit.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function addInServiceTraining() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {

            $where= [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $where= [];
            $where['employee_id'] = $_GET['employee'];
            $data['pageData'] = $this->Comman_model->get_rows('tblemployeservicetraining', $where);

            if(!empty( $this->input->post('submit'))){
                $this->form_validation->set_rules('next_visit_date', 'Next Visit Date', 'trim|required');
                $this->form_validation->set_rules('visit_done_date', 'Visit Done Date', 'trim|required');
                $this->form_validation->set_rules('visitation_notes', 'Visitation Notes', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $nextVisitDate = $this->input->post('next_visit_date',true);
                    $visitDoneDate = $this->input->post('visit_done_date',true);   

                    $nextVisitDate = date('Y-m-d', strtotime($nextVisitDate));
                    $visitDoneDate = date('Y-m-d', strtotime($visitDoneDate));

                    if($nextVisitDate=='0000-00-00' || $visitDoneDate=='0000-00-00') {
                        $this->app->message('Please select a valid date', 'error');
                        redirect('employee/addInServiceTraining?employee='.$_GET['employee']);
                    }

                    $dataArray                    = [];
                    $dataArray['Agency']          = $this->session->userdata('agency');
                    $dataArray['employee_id']     = $_GET['employee'];
                    $dataArray['NextVisitDate']   = $nextVisitDate;
                    $dataArray['VisitDoneDate']   = $visitDoneDate;
                    $dataArray['VisitationNotes'] = $this->input->post('visitation_notes',true);
                    $dataArray['hours_done']      = $this->input->post('hours_done',true);
                    $dataArray['hours_remaining'] = $this->input->post('hours_remaining',true);
                    $dataArray['user_id']         = $this->session->userdata('id');
                    $dataArray['username']        = $this->session->userdata('name');

                    $inserId = $this->Comman_model->insert( "tblemployeservicetraining", $dataArray );

                    if($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user add employee Inservice training to employee id '.$_GET['employee'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################
                        $this->app->message('Employee Inservice training has been added successfully.', 'success');
                    } else{
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('employee/inservicetraining?employee='.$_GET['employee'],'refresh');
                }
            }
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/add-service-training.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }


    public function editInServiceTraining() {

        if(isset($_SESSION['name']) && !empty($_GET['employee']) && !empty($_GET['recid'])) {
            $where= [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $where= [];
            $where['recid'] = decode64($_GET['recid']);
            $data['pageData'] = $this->Comman_model->get_row('tblemployeservicetraining', $where);
            $data['pageData']['NextVisitDate'] = date('m/d/Y', strtotime($data['pageData']['NextVisitDate']));
            $data['pageData']['VisitDoneDate'] = date('m/d/Y', strtotime($data['pageData']['VisitDoneDate']));

            if(!empty($this->input->post('submit'))) {

                $this->form_validation->set_rules('next_visit_date', 'Next Visit Date', 'trim|required');
                $this->form_validation->set_rules('visit_done_date', 'Visit Done Date', 'trim|required');
                $this->form_validation->set_rules('visitation_notes', 'Visitation Notes', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $nextVisitDate = $this->input->post('next_visit_date',true);
                    $visitDoneDate = $this->input->post('visit_done_date',true);   

                    $nextVisitDate = date('Y-m-d', strtotime($nextVisitDate));
                    $visitDoneDate = date('Y-m-d', strtotime($visitDoneDate));

                    if($nextVisitDate=='0000-00-00' || $visitDoneDate=='0000-00-00') {
                        $this->app->message('Please select a valid date', 'error');
                        redirect('employee/editInServiceTraining?employee='.$_GET['employee'].'&recid='.$_GET['recid']);
                    }

                    $dataArray                    = [];
                    $dataArray['Agency']          = $this->session->userdata('agency');
                    $dataArray['employee_id']     = $_GET['employee'];
                    $dataArray['NextVisitDate']   = $nextVisitDate;
                    $dataArray['VisitDoneDate']   = $visitDoneDate;
                    $dataArray['VisitationNotes'] = $this->input->post('visitation_notes',true);
                    $dataArray['hours_done']      = $this->input->post('hours_done',true);
                    $dataArray['hours_remaining'] = $this->input->post('hours_remaining',true);
                    $dataArray['user_id']         = $this->session->userdata('id');
                    $dataArray['username']        = $this->session->userdata('name');

                    $where  =   [];
                    $where['recid']  =   decode64($_GET['recid']);
                    $update = $this->Comman_model->update( "tblemployeservicetraining", $where, $dataArray );

                    if($update){
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user update employee Inservice training to employee id '.$_GET['employee'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);
                        }
                        ############### USER ACTION TRACKING END ####################
                        $this->app->message('Employee Inservice training has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('employee/inservicetraining?employee='.$_GET['employee'],'refresh');
                }
            }
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/edit-service-training.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    public function deleteServiceTraining() {
        $id = $this->input->get('delete_id');
        $dataArray = [];
        $dataArray['status'] = 1;

        $where = [];
        $where['recid'] = $id;

        $pageData = $this->Comman_model->get_row('tblemployeservicetraining', $where);
        $data = $this->Comman_model->update('tblemployeservicetraining', $where, $dataArray);

        if($data) {
            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted employee service training from employee id '.$pageData['employee_id'].' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);
            }
            ############### USER ACTION TRACKING END ####################
            $this->app->message('Employee service training has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops something went wrong.', 'error');
        }
        redirect($this->agent->referrer());
    }

    public function setNextVisitdate() {
        $visit_done_date = $this->input->post('visit_done_date');
        $employee_id = $this->input->post('employee_id');
        if(!empty($employee_id) && !empty($visit_done_date)) {
            $where = [];
            $where['employee_id'] = $employee_id;
            $employeeData = $this->Comman_model->get_row('employee', $where);
            $days = 365;
            //if($employeeData['FHCA']==1) {
              //  $days = 90;
            //}
            $next = strtotime(date("m/d/Y", strtotime($visit_done_date)) . " + ".$days."days");
            $nextvisit = date("m/d/Y",$next); 
            echo $nextvisit; 
        }
    }

    public function updateNextService() {
        if(isset($_SESSION['name']) && !empty($_POST['employee']) && !empty($_POST['recid']) && !empty($_POST['nextvisitation_date'])) {
            $where= [];
            $where['employee_id'] = $_POST['employee'];            
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('nextvisitation_date', 'Next Service Date', 'trim|required');
                if ($this->form_validation->run() != false) {
                    $nextVisitDate = $this->input->post('nextvisitation_date',true);
                    $nextVisitDate = date('Y-m-d', strtotime($nextVisitDate));
                    if($nextVisitDate=='0000-00-00') {
                        $this->app->message('Please select a valid date', 'error');
                        redirect('employee/editInServiceTraining?employee='.$_POST['employee'].'&recid='.$_POST['recid']);
                    }

                    $dataArray                    = [];
                    $dataArray['NextVisitDate']   = $nextVisitDate;
                    $dataArray['user_id']         = $this->session->userdata('id');
                    $dataArray['username']        = $this->session->userdata('name');

                    $where  =   [];
                    $where['recid']  =   decode64($_POST['recid']);
                    $update = $this->Comman_model->update("tblemployeservicetraining", $where, $dataArray );

                    if($update) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user update client visit next date to client id '.$_POST['patient'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);
                        }
                        ############### USER ACTION TRACKING END ####################
                        $this->app->message('Employee service next date has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('employee/inservicetraining?employee='.$_POST['employee'],'refresh');
                }
            }
        } else {
            redirect($this->agent->referrer());
        }
    }

    public function monthlyHours() {
        $patient_id  = $_GET['patient'];
        $employee_id = $_GET['employee'];
        $month  = $_GET['month'];
        $year   = $_GET['year'];
        if(isset($_SESSION['name']) && !empty($patient_id) && !empty($employee_id)) {
            //$month = date('n')-1;
            $month = date('m');
            $year = date('Y');
            if(!empty($_GET['month'])) {
                $month  = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                $year   = $_GET['year'];
            }

            $fromdate   = $year.'-'.$month.'-01';
            $todate     = $year.'-'.$month.'-31';

            $emplid = $employee_id;
            $ptid = $patient_id;

            $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn >= 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' ORDER BY date asc";  
            $timesheetData = $this->Comman_model->getCustomQueryData($MySQL);

            $totalHours = 0;
            foreach($timesheetData as $row) {
                $timedate = date("Y-m-d",strtotime($row['date'])) ;
                $hr1 = '00';
                $hr2 = '00';
                $mn1 = '00';
                $mn2 = '00';
                $tot1 = 0;
                $tot2 = 0;  
                $recid1 = null;
                $recid2 = null;
                $c1 = null;
                $c2 = null;
                $rec = $row['employee_clock_id'];
                $tmprec = @$row['recid_id'];
                $modeIN = $row['isIn'];
                $okay = 0;
                $godisp = 0;
                $shiftlock = 0;
                if ($shift == 1)  {
                    $rec_t = $row['rec_id'];  
                    $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND  isIn = 2 AND rec_id = '$rec_t'";
                    $row2 = get_custom_query_data($query, 'row'); 
                    $d1 = date("Y-m-d",strtotime($row['date']));
                    $d2 = date("Y-m-d",strtotime($row2['date']));
                    if ($row2 != 0 && $d1 != $d2)  {     
                        $shiftlock = 1;
                    }
                } 

                if ($modeIN == 2 )  {
                    $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND DATE(date) = '$timedate' AND  isIn = 1 AND rec_id != '$tmprec'";  
                    $okay = get_custom_query_data($query, 'row');
                }

                $from_time = $from_time2 = 0;
                if ( $modeIN == 1 ) {
                    $temp = '';
                    $c1 = $row['employee_clock_id'];
                    $temp = date('H:i',strtotime($row['date']));
                    $recid1 = $row['rec_id'];
                    $t = explode(":",$temp );
                    $hr1 = $t[0];
                    $mn1 = $t[1];
                    $fdate = date('Y-m-d',strtotime($row['date']));
                    $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

                    $disp1 = $hr1 + ($mn1 / 60);
                    $tot1 = quarter($disp1);
                    $tot1 = number_format($tot1,2);
                    $from_time = $tot1;
                    $from_time2 = $row['date'];
                } else {
                    $hr1 = "00";
                    $mn2 = "00"; 
                }

                $x = '2';
                $rec_id = $row['rec_id'];
                if ( $modeIN == 1)  {
                    $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND DATE(date) = '$timedate' AND  isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
                    if ($shiftlock == 1 )  {
                        $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
                    }
                } else  {
                    $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$rec' ORDER by employee_clock_id desc";  
                }

                $rowdate = get_custom_query_data($query, 'row');


                $to_time=strtotime($rowdate['date']);
                $recid2 = $row['rec_id'];
                $total = number_format((($to_time - $from_time2) / 60) / 60,2);

                $temp = '';
                $c2 = null;
                if (!empty($rowdate)) { 
                    $temp = date('H:i',strtotime($rowdate['date'])); 
                    $c2 = $rowdate['employee_clock_id']; 
                }
                $t = explode(":",$temp );
                $hr2 = @$t[0];
                $mn2 = @$t[1];
                if ($hr2 == '00' && $shiftlock == 1 )  { $hr2 = '24';}
                $fdate = date('Y-m-d',strtotime($rowdate['date']));
                $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

                $disp2 = $hr2 + ($mn2 / 60);
                $tot2 = quarter($disp2);
                $tot2 = number_format($tot2,2);

                $to_time=$tot2;
                $to_time2=  $rowdate['date'];
                if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') )  {
                    $total = 0;
                } else {
                    $total = $to_time - $from_time;
                    if ($shiftlock == 1 )  {
                        $tdate1 = strtotime($to_time2);
                        $tdate2 = strtotime($from_time2);   
                        $total = number_format((($tdate1 - $tdate2) / 60) / 60,2);
                    }
                }

                if ($from_time != null && $to_time != null ) {
                    if ($rowdate != 0 )   {
                        $totalHours = $totalHours + abs(quarter($total));
                    } 
                }
            }

            $data['totalHours'] = $totalHours;

            $where = [];
            $where['patient_id'] = $patient_id;
            $data['patientData'] = $this->Comman_model->get_row('patient', $where);

            $where = [];
            $where['employee_id'] = $employee_id;
            $data['employeeData'] = $this->Comman_model->get_row('employee', $where);

            $where  = [];
            $where['ea.patient_id'] = $patient_id;
            $like = [];
            $not_like = [];
            $not_like['ea.pin'] = '+';   
            $assignEmployeeData = $this->client->get_assigned_employee($where, $like, $not_like);

            $employeeIds = array_column($assignEmployeeData, 'employee_id');

            $empArr = [];
            $grandTotal = 0;
            if(!empty($employeeIds)) {
                foreach ($employeeIds as $key => $employeeId) {
                    $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$employeeId' AND patient_id = '$ptid' AND isIn >= 1 AND DATE(date) >= '$fromdate' AND DATE(date) <= '$todate' ORDER BY date ASC";
                    $timesheetData = $this->Comman_model->getCustomQueryData($MySQL);

                    $totalHours = 0;
                    foreach($timesheetData as $row) {
                        $timedate = date("Y-m-d",strtotime($row['date'])) ;
                        $hr1 = '00';
                        $hr2 = '00';
                        $mn1 = '00';
                        $mn2 = '00';
                        $tot1 = 0;
                        $tot2 = 0;  
                        $recid1 = null;
                        $recid2 = null;
                        $c1 = null;
                        $c2 = null;
                        $rec = $row['employee_clock_id'];
                        $tmprec = @$row['recid_id'];
                        $modeIN = $row['isIn'];
                        $okay = 0;
                        $godisp = 0;
                        $shiftlock = 0;
                        if ($shift == 1)  {
                            $rec_t = $row['rec_id'];  
                            $query = "SELECT * FROM employee_clock WHERE employee_id = '$employeeId' AND patient_id = '$ptid' AND  isIn = 2 AND rec_id = '$rec_t'";
                            $row2 = get_custom_query_data($query, 'row'); 
                            $d1 = date("Y-m-d",strtotime($row['date']));
                            $d2 = date("Y-m-d",strtotime($row2['date']));
                            if ($row2 != 0 && $d1 != $d2)  {     
                                $shiftlock = 1;
                            }
                        } 

                        if ($modeIN == 2 )  {
                            $query = "SELECT * FROM employee_clock WHERE employee_id = '$employeeId' AND patient_id = '$ptid' AND DATE(date) = '$timedate' AND  isIn = 1 AND rec_id != '$tmprec'";  
                            $okay = get_custom_query_data($query, 'row');
                        }

                        $from_time = $from_time2 = 0;
                        if ( $modeIN == 1 ) {
                            $temp = '';
                            $c1 = $row['employee_clock_id'];
                            $temp = date('H:i',strtotime($row['date']));
                            $recid1 = $row['rec_id'];
                            $t = explode(":",$temp );
                            $hr1 = $t[0];
                            $mn1 = $t[1];
                            $fdate = date('Y-m-d',strtotime($row['date']));
                            $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

                            $disp1 = $hr1 + ($mn1 / 60);
                            $tot1 = quarter($disp1);
                            $tot1 = number_format($tot1,2);
                            $from_time = $tot1;
                            $from_time2 = $row['date'];
                        } else {
                            $hr1 = "00";
                            $mn2 = "00"; 
                        }

                        $x = '2';
                        $rec_id = $row['rec_id'];
                        if ( $modeIN == 1)  {
                            $query = "SELECT * FROM employee_clock WHERE employee_id = '$employeeId' AND patient_id = '$ptid' AND DATE(date) = '$timedate' AND  isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
                            if ($shiftlock == 1 )  {
                                $query = "SELECT * FROM employee_clock WHERE employee_id = '$employeeId' AND patient_id = '$ptid' AND isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
                            }
                        } else  {
                            $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$rec' ORDER by employee_clock_id desc";  
                        }

                        $rowdate = get_custom_query_data($query, 'row');

                        $to_time=strtotime($rowdate['date']);
                        $recid2 = $row['rec_id'];
                        $total = number_format((($to_time - $from_time2) / 60) / 60,2);

                        $temp = '';
                        $c2 = null;
                        if (!empty($rowdate)) { 
                            $temp = date('H:i',strtotime($rowdate['date'])); 
                            $c2 = $rowdate['employee_clock_id']; 
                        }
                        $t = explode(":",$temp );
                        $hr2 = @$t[0];
                        $mn2 = @$t[1];
                        if ($hr2 == '00' && $shiftlock == 1 )  { $hr2 = '24';}
                        $fdate = date('Y-m-d',strtotime($rowdate['date']));
                        $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

                        $disp2 = $hr2 + ($mn2 / 60);
                        $tot2 = quarter($disp2);
                        $tot2 = number_format($tot2,2);

                        $to_time=$tot2;
                        $to_time2=  $rowdate['date'];
                        if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') )  {
                            $total = 0;
                        } else {
                            $total = $to_time - $from_time;
                            if ($shiftlock == 1 )  {
                                $tdate1 = strtotime($to_time2);
                                $tdate2 = strtotime($from_time2);   
                                $total = number_format((($tdate1 - $tdate2) / 60) / 60,2);
                            }
                        }

                        if ($from_time != null && $to_time != null ) {
                            if ($rowdate != 0 )   {
                                $totalHours = $totalHours + abs(quarter($total));
                            } 
                        }
                    }

                    $sql = "SELECT name FROM employee WHERE employee_id = '$employeeId'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    $empArr[$key]['employee_name'] = $row['name'];
                    $empArr[$key]['total_hours'] = $totalHours;
                    $grandTotal = $grandTotal + $totalHours;
                }
            }

            $data['month']  = $month;
            $data['year']   = $year;
            $data['startDate'] = $fromdate;
            $data['empData'] = $empArr;
            $data['grandTotal'] = $grandTotal;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/monthly-hours.php',$data);
            $this->load->view('common/footer.php');
        } else {
          redirect('');
        }
    }

    public function calendarMonthlyHours() {
        $patient_id = $this->input->get('patient');
        $employee_id = $this->input->get('employee');
        $month = $this->input->get('month');
        $year = $this->input->get('year');

        $emplid = $employee_id;
        $ptid   = $patient_id;

        $fromdate   = $year.'-'.$month.'-01';
        $todate     = $year.'-'.$month.'-31';

        $where  = [];
        $where['ea.patient_id'] = $patient_id;
        $like = [];
        $not_like = [];
        $not_like['ea.pin'] = '+';   
        $assignEmployeeData = $this->client->get_assigned_employee($where, $like, $not_like);

        $employeeIds = array_column($assignEmployeeData, 'employee_id');

        $tableData = [];
        foreach ($employeeIds as $key => $emplid) {
            // code...        
            $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn >= 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' ORDER BY date asc";  
            $timesheetData = $this->Comman_model->getCustomQueryData($MySQL);
            
            foreach($timesheetData as $row) {
                $timedate = date("Y-m-d",strtotime($row['date'])) ;
                $hr1 = '00';
                $hr2 = '00';
                $mn1 = '00';
                $mn2 = '00';
                $tot1 = 0;
                $tot2 = 0;  
                $recid1 = null;
                $recid2 = null;
                $c1 = null;
                $c2 = null;
                $rec = $row['employee_clock_id'];
                $tmprec = @$row['recid_id'];
                $modeIN = $row['isIn'];
                $okay = 0;
                $godisp = 0;
                $shiftlock = 0;
                if ($shift == 1)  {
                    $rec_t = $row['rec_id'];  
                    $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND  isIn = 2 AND rec_id = '$rec_t'";
                    $row2 = get_custom_query_data($query, 'row'); 
                    $d1 = date("Y-m-d",strtotime($row['date']));
                    $d2 = date("Y-m-d",strtotime($row2['date']));
                    if ($row2 != 0 && $d1 != $d2)  {     
                        $shiftlock = 1;
                    }
                } 

                if ($modeIN == 2 )  {
                    $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND DATE(date) = '$timedate' AND  isIn = 1 AND rec_id != '$tmprec'";  
                    $okay = get_custom_query_data($query, 'row');
                }

                $from_time = $from_time2 = 0;
                if ( $modeIN == 1 ) {
                    $temp = '';
                    $c1 = $row['employee_clock_id'];
                    $temp = date('H:i',strtotime($row['date']));
                    $recid1 = $row['rec_id'];
                    $t = explode(":",$temp );
                    $hr1 = $t[0];
                    $mn1 = $t[1];
                    $apm1 = date('a',strtotime($row['date']));
                    $apm1 = strtoupper($apm1);

                    $fdate = date('Y-m-d',strtotime($row['date']));
                    $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

                    $disp1 = $hr1 + ($mn1 / 60);
                    $tot1 = quarter($disp1);
                    $tot1 = number_format($tot1,2);
                    $from_time = $tot1;
                    $from_time2 = $row['date'];
                } else {
                    $hr1 = "00";
                    $mn2 = "00"; 
                    $apm1 = "";
                }

                $x = '2';
                $rec_id = $row['rec_id'];
                if ( $modeIN == 1)  {
                    $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND DATE(date) = '$timedate' AND  isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
                    if ($shiftlock == 1 )  {
                        $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
                    }
                } else  {
                    $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$rec' ORDER by employee_clock_id desc";  
                }

                $rowdate = get_custom_query_data($query, 'row');


                $to_time=strtotime($rowdate['date']);
                $recid2 = $row['rec_id'];
                $total = number_format((($to_time - $from_time2) / 60) / 60,2);

                $temp = '';
                $apm2 = '';
                $c2 = null;
                if (!empty($rowdate)) { 
                    $temp = date('H:i',strtotime($rowdate['date'])); 
                    $apm2 = date('a',strtotime($rowdate['date']));
                    $apm2 = strtoupper($apm2);
                    $c2   = $rowdate['employee_clock_id']; 
                }
                $t = explode(":",$temp );
                $hr2 = @$t[0];
                $mn2 = @$t[1];
                if ($hr2 == '00' && $shiftlock == 1 )  { $hr2 = '24';}
                $fdate = date('Y-m-d',strtotime($rowdate['date']));
                $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

                $disp2 = $hr2 + ($mn2 / 60);
                $tot2 = quarter($disp2);
                $tot2 = number_format($tot2,2);

                $to_time=$tot2;
                $to_time2=  $rowdate['date'];
                if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') )  {
                    $total = 0;
                } else {
                    $total = $to_time - $from_time;
                    if ($shiftlock == 1 )  {
                        $tdate1 = strtotime($to_time2);
                        $tdate2 = strtotime($from_time2);   
                        $total = number_format((($tdate1 - $tdate2) / 60) / 60,2);
                    }
                }

                if ($from_time != null && $to_time != null ) {
                    if ($rowdate != 0 )   {
                        $tableData[$timedate][0] = $tableData[$timedate][0] + abs(quarter($total));
                        $tableData[$timedate][1] = $tableData[$timedate][1].'<span class="color'.$key.'">'.$hr1.':'.$mn1.' '.$apm1.' - '.$hr2.':'.$mn2.' '.$apm2.'</span><br>';
                    } 
                }
            }
        }

        if(!empty($tableData)) {        
            $list = '';
            $twh = 0;
            for ($i=1; $i <= 31 ; $i++) { 
                $start_date = date('Y-m-d', strtotime($year.'-'.$month.'-'.$i));
                $billedHour = $tableData[$start_date][0];
                $inout = $tableData[$start_date][1];

                $twh = $twh + $billedHour;

                if(!empty($billedHour)) {
                    $billedHour = $billedHour.' Hr<br><h6 class="billed-text">'.$inout.'</h6>';  
                    if(in_array(date("l", strtotime($start_date)), ["Saturday"])) {
                        $billedHour = $billedHour.'<h6 class="twh-text">TWH='.$twh.'</h6>';  
                    }
                } else {
                    if(in_array(date("l", strtotime($start_date)), ["Saturday"])) {
                        $billedHour = $billedHour.'<h6 class="twh-text">TWH='.$twh.'</h6>';  
                    }
                }

                $eventArr[] =
                        [
                          'title'=>$billedHour,
                          'description'=>$list,
                          'start'=>$start_date,
                          'end'=>$start_date,
                          'textEscape' => false,
                          //'color' => '#000000',
                          //'backgroundColor' => '#ffffff'
                        ];

                if(in_array(date("l", strtotime($start_date)), ["Saturday"])) {
                    $twh = 0;
                }        
            }           
        }       
        print_r(json_encode($eventArr));
    }

    function sendPHPMailerMail($to, $subject, $message, $headers) {
        if(!empty($to)) {
            $mail = $this->phpmailer_lib->load();

            $mail->IsSMTP(); // set mailer to use SMTP
            $mail->Host        = "smtp.office365.com";  // specify main and backup server
            $mail->SMTPAuth    = true;     // turn on SMTP authentication
            $mail->SMTPDebug   = 0; 
            $mail->SMTPSecure  = "STARTTLS";
            $mail->Port        = 587;
            $mail->Username    = "rdsrm@hcpfinancial.onmicrosoft.com";  // SMTP username
            $mail->Password    = "Onedrive5301!"; // SMTP password
            //$mail->CharSet     = 'UTF-8';
            $mail->SMTPAuth    = true;
            $mail->From        = "rdsrm@hcpfinancial.onmicrosoft.com";
            $mail->FromName    = "HCP Support";
            $mail->AddAddress($to);   // name is optional
            $mail->IsHTML(true);                                  // set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $message;
            if(!$mail->Send()) {
                return false;
            }   
        }
        return true;
    }

    /*** GET DATA FROM DEMOIVR9 AND SAVE INTO DEMOIVR DATABASE TABLE ****/
    function retrieveData() {
        $sql = "SELECT * FROM demoivr9.idoadbLTS WHERE month=11 AND year=2022 AND Agency=2";
        $res = $this->Comman_model->getCustomQueryData($sql);
        foreach ($res as $key => $row) {

            $dataArray = [];
            $dataArray['provider'] = $row['provider'];
            $dataArray['invoicenum'] = $row['invoicenum'];
            $dataArray['servicedate'] = $row['servicedate'];
            $dataArray['serviceenddate'] = $row['serviceenddate'];
            $dataArray['billnum'] = $row['billnum'];
            $dataArray['units'] = $row['units'];
            $dataArray['mco'] = $row['mco'];
            $dataArray['month'] = $row['month'];
            $dataArray['year'] = $row['year'];
            $dataArray['patient_id'] = $row['patient_id'];
            $dataArray['Agency'] = $row['Agency'];
            $dataArray['uploadtime'] = $row['uploadtime'];
            $dataArray['batchno'] = $row['batchno'];
            $dataArray['total_paid'] = $row['total_paid'];
            $dataArray['total_amount'] = $row['total_amount'];
            $dataArray['status'] = $row['status'];
            $dataArray['remarks'] = $row['remarks'];
            $dataArray['warrant_number'] = $row['warrant_number'];
            $dataArray['warrant_date'] = $row['warrant_date'];

            //$idoa_id = $this->Comman_model->insert('idoadbLTS', $dataArray);

            // code...
            $sqld = "SELECT * FROM demoivr9.idoadb_detailsLTS WHERE idoa_id='".$row['idoa_id']."'";
            $resd = $this->Comman_model->getCustomQueryData($sqld);
            foreach ($resd as $keyd => $rowd) {
                $dataArray = [];
                $dataArray['idoa_id'] = $idoa_id;
                $dataArray['date'] = $rowd['date'];
                $dataArray['bill'] = $rowd['bill'];
                $dataArray['units'] = $rowd['units'];
                $dataArray['start_date'] = $rowd['start_date'];
                $dataArray['flag'] = $rowd['flag'];
                $dataArray['utotal'] = $rowd['utotal'];
                $dataArray['Agency'] = $rowd['Agency'];
                $dataArray['paid'] = $rowd['paid'];
                $dataArray['amount'] = $rowd['amount'];
                $dataArray['status'] = $rowd['status'];
                $dataArray['remarks'] = $rowd['remarks'];

                //$this->Comman_model->insert('idoadb_detailsLTS', $dataArray);
            }
        }
    }

    public function pqbReport() {
        if(isset($_SESSION['name'])) {
            $data = [];

            $agency = $this->session->userdata('agency');

            $fromDate = date('Y-m-d');
            if(!empty($_GET['fromDate'])) {
                $fromDate = date('Y-m-d', strtotime($_GET['fromDate']));    
            }

            $toDate = date('Y-m-d');
            if(!empty($_GET['toDate'])) {
                $toDate = date('Y-m-d', strtotime($_GET['toDate']));    
            }

            $cond = " AND Status=1";
            if(!empty($_GET['status'])) {
                $status = $_GET['status'];
                if($status==3) {
                    $cond = " AND (Status='".$status."' OR Status!=1)";    
                } else {
                    $cond = " AND Status='".$status."'";
                }
                
            } else {
                $status = 1;
            }

            $sql = "SELECT * FROM employee WHERE DATE(HiredDate) >= '$fromDate' AND DATE(HiredDate) <= '$toDate' AND Agency = '".$agency."' $cond ORDER BY employee_id DESC";
            $data['employeeData'] = $this->Comman_model->getCustomQueryData($sql);


            $data['fromDate']   = $fromDate;
            $data['toDate']     = $toDate;
            $data['status']     = $status;

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/pqb-report.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }

    public function updateEmployeeHiredDate() {
        if(isset($_SESSION['name'])) {

            $sql = "SELECT * FROM employee WHERE HiredDate!='' AND HiredDate!='--'";
            $empData = $this->Comman_model->getCustomQueryData($sql);
            $x=0;
            foreach ($empData as $key => $row) {

                //$hiredDate = date('Y-m-d', strtotime($row['HiredDate']));

                echo $row['employee_id'].'=='.$row['HiredDate'];
                echo '<br>';

                //$where = [];
                //$where['employee_id'] = $row['employee_id'];

                //$dataArray = [];
                //$dataArray['HiredDate'] = $hiredDate;
                //$this->Comman_model->update('employee', $where, $dataArray);
                $x++;
            }
            //echo $x.' Employees has been updated successfully.';
        } else {
            redirect();
        } 
    }

    public function messages() {
        if(isset($_SESSION['name']) && !empty($_GET['employee'])) {
            $where  = [];
            $where['employee_id'] = $_GET['employee'];            
            $data['employeeData']    =   $this->Comman_model->get_row('employee', $where);

            $where = [];
            $where['employee_id'] = $_GET['employee'];
            $data['msgData'] = $this->Comman_model->get_rows('employee_inbox_messages', $where, 'timestamp', 'DESC');

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('employee/message.php',$data);
            $this->load->view('common/footer.php');
        } else {
            redirect();
        }
    }

    public function deleteEmployeeInboxMessage() {
        $id = $this->input->get('delete_id');
        $query = "DELETE FROM employee_inbox_messages WHERE id='".$id."'";
        set_custom_query_data($query);
        ############### USER ACTION TRACKING START ####################
        if($this->session->userdata('id')!=6) {
            $dataArray = [];
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted employee inbox message from employee id '.$pageData['employee_id'].' at '. date('m/d/Y H:i:s');
            $this->Comman_model->insert('users_tracking', $dataArray);
        }
        ############### USER ACTION TRACKING END ####################
        $this->session->set_flashdata('message','Message has been deleted successfully.');
        redirect($this->agent->referrer());
    }

    function sendMessageToEmployee() {
        $postData = $this->input->post();
        if(!empty($postData['message']) && !empty($postData['employee_id'])) {
            $employee_id = $postData['employee_id'];
            $message = $postData['message'];

            $dataArray   =   [];
            $dataArray['employee_id']   = $employee_id;
            $dataArray['message']       = $message;
            $dataArray['sender_id']     = $this->session->userdata('id');
            $dataArray['sender_name']   = $this->session->userdata('name');

            $this->Comman_model->insert('employee_inbox_messages', $dataArray);
            $this->session->set_flashdata('message','Message has been sent successfully.');
        } else {
            $this->session->set_flashdata('error_message','Oops something went wrong. Try again.');
        }      
        redirect($this->agent->referrer());
    }

    function getEmployeeData() {
        $search = $_REQUEST['search'];
        $agency = $this->session->userdata('agency');
        $sql = "SELECT * FROM employee WHERE name LIKE '%".$search."%' AND firstname!='' AND agency = '".$agency."' ORDER BY employee_id DESC";
        $res    =   get_custom_query_data($sql);
        $data = [];
        $x=0;
        if(!empty($res)) {            
            foreach ($res as $key => $row) {
                $data[$x]['id'] = $row['employee_id'];
                $data[$x]['text'] = $row['name'];
                $x++;
            }
        } else {
            $data[$x] = 'No results found.';
        }

        if(!empty($search)) {
            print_r(json_encode($data));
        }
    }
} 