<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Gpdf extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        //$this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Employee_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }


    public function taskPdfView() {
        if(isset($_SESSION['name']) && !empty($_GET['datetrans']) && !empty($_GET['emplid']) && !empty($_GET['ptid'])) {

            $datetrans = $_GET['datetrans'];
            $IsZero =   $_GET['IsZero'];
            $emplid = $_GET['emplid'];
            $ptid = $_GET['ptid'];

            $year = date("Y",strtotime($datetrans)); 
            $month = date("m",strtotime($datetrans)); 
            $monthName = date("M",strtotime($datetrans)); 
            $tdate = strtotime($year.'-'.$month.'-01');

            $agency_code = $this->session->userdata('agency');

            if ($action == null ) {
                $day = date("d",strtotime($datetrans));
                if ($day >= 1 && $day <= 15) {
                    $action = 1;
                } else { 
                    $action = 2; 
                }
            }

            if ($action == 1  )  {
                $cutoff = 1;
                $eom = 15;
                $tdate2 = strtotime($year.'-'.$month.'-01');
                $fromdate = date("Y-m-d",$tdate2);
                $tdate2 = strtotime($year.'-'.$month.'-15');
                $todate = date("Y-m-d",$tdate2);        
            } 

            if ($action ==2)   {
                $cutoff = 16;
                $eom = 31;
                $tdate2 = strtotime($year.'-'.$month.'-16');
                $fromdate = date("Y-m-d",$tdate2);
                $todate = date("Y-m-t",$tdate);         
            }

            if ($agency_code == 2 || $agency_code == 4) {
                $thedate = $datetrans;

                $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
                $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');

                if (!empty($chkResult))  {
                    $fromdate = $chkResult['start_date'];
                    $todate= $chkResult['end_date'];
                }    
            } 

            $ptsql = "SELECT name AS patient_name, supervisor_id, ShipAddressAddr2, FHCA FROM patient WHERE patient_id = '$ptid'"; 
            $ptRow = $this->Comman_model->getCustomQueryData($ptsql, 'row');
            $patientName = $ptRow['patient_name'];
            $patientAddress = $ptRow['ShipAddressAddr2'];
            $fhca = $ptRow['FHCA'];

            $empsql = "SELECT name AS employee_name, supervisor_id, pin FROM employee WHERE employee_id = '$emplid'"; 
            $empRow = $this->Comman_model->getCustomQueryData($empsql, 'row');
            $employeePin = $empRow['pin'];
            $employeeName = $empRow['employee_name'];
            $words = explode(' ', @$employeeName);
            $empInitials = strtoupper(substr($words[0], 0, 1) . substr(end($words), 0, 1));

            $susql = "SELECT name AS sup_name FROM supervisor WHERE supervisor_id = '".$empRow['supervisor_id']."'"; 
            $suRow = $this->Comman_model->getCustomQueryData($susql, 'row');
            $supName = $suRow['sup_name'];

            $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = 1 AND DATE(date) >= '$fromdate' AND DATE(date) <= '$todate' AND reset IS NOT NULL ORDER BY date"; 


            $week = [];

            $mon = $tue = $wed = $thu = $fri = $sat = $sun = [];
            $mon1 = $tue1 = $wed1 = $thu1 = $fri1 = $sat1 = $sun1 = [];

            $timesheetData = $this->Comman_model->getCustomQueryData($MySQL);
            $x=0;
            foreach($timesheetData as $row) {

                $day = date('D',strtotime($row['date']));
                $timedate = date("Y-m-d",strtotime($row['date'])) ;
                //$week['day'][] = $day;                

                $task3 = $row['tasks'];
                $task1 = trim($row['ivr_task']);
                $task2 = "";

                $x = '2';
                $rec_id = $row['rec_id'];
                $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND DATE(date) = '$timedate' AND isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
                $rowdate = get_custom_query_data($query, 'row');

                if (!empty($rowdate)) { $task2 = trim($rowdate['ivr_task']); }

                if ($task2 == '1')  {
                    $task2 = "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16";
                }

                $t = explode(",",$task2 );
                $list = '';
                for ($x = 0;$x <= 16; $x++) {
                    $item = @$t[$x];
                    $drpSQL = "SELECT * FROM employee_tasks WHERE task_code = '$item' ";
                    $drpResult = get_custom_query_data($drpSQL, 'row'); 

                    $mySQL = "SELECT * FROM tblpatientservices WHERE patient_id = '$ptid' ORDER BY ID ASC" ;
                    $objResult2 = get_custom_query_data($mySQL, 'row');

                    if ($objResult2['Eating'] == -1  && $item ==  1) { 
                        $list = $list.$drpResult['task_code'].', ';                           
                    }
                    if ($objResult2['Bathing'] == -1 && $item ==  2) { 
                        $list = $list.$drpResult['task_code'].', ';   
                    }
                    if ($objResult2['Grooming'] == -1 && $item ==  3) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    }
                    if ($objResult2['Dressing'] == -1 && $item ==  4) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    } 
                    if ($objResult2['Transferring'] == -1 && $item ==  5) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    }
                    if ($objResult2['Incontinence'] == -1 && $item ==  6) {
                        $list = $list.$drpResult['task_code'].', ';  
                    }
                    if ($objResult2['ManagingMoney'] == -1 && $item ==  7) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    }
                    if ($objResult2['Telephoning'] == -1 && $item ==  8) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    }
                    if ($objResult2['PreparingMeals'] == -1 && $item ==  9) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    }
                    if ($objResult2['Laundry'] == -1 && $item ==  10) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    } 
                    if ($objResult2['Housework'] == -1 && $item ==  11) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    } 
                    if ($objResult2['OutsideHome'] == -1 && $item ==  12) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    }
                    if ($objResult2['RoutineHealth'] == -1 && $item ==  13) { 
                        $list = $list.$drpResult['task_code'].', ';  
                    } 
                    if ($objResult2['SpecialHealth'] == -1 && $item ==  14) { 
                        $list = $list.$drpResult['task_code'].', '; 
                    }
                    if ($objResult2['BeingAlone'] == -1 && $item ==  15) { 
                        $list = $list.$drpResult['task_code']; 
                    }
                }    

                if($day=='Mon') {
                    if(empty($mon)) {
                        $mon[0] = $timedate;    
                        $mon[1] = rtrim($list, ',');    
                    } else {
                        $mon1[0] = $timedate;    
                        $mon1[1] = rtrim($list, ',');    
                    }                    
                }

                if($day=='Tue') {
                    if(empty($tue)) {
                        $tue[0] = $timedate;    
                        $tue[1] = rtrim($list, ',');    
                    } else {
                        $tue1[0] = $timedate;    
                        $tue1[1] = rtrim($list, ',');    
                    }                    
                }

                if($day=='Wed') {
                    if(empty($wed)) {
                        $wed[0] = $timedate;    
                        $wed[1] = rtrim($list, ',');    
                    } else {
                        $wed1[0] = $timedate;    
                        $wed1[1] = rtrim($list, ',');    
                    }                    
                }

                if($day=='Thu') {
                    if(empty($thu)) {
                        $thu[0] = $timedate;    
                        $thu[1] = rtrim($list, ',');    
                    } else {
                        $thu1[0] = $timedate;    
                        $thu1[1] = rtrim($list, ',');    
                    }                    
                }

                if($day=='Fri') {
                    if(empty($fri)) {
                        $fri[0] = $timedate;    
                        $fri[1] = rtrim($list, ',');    
                    } else {
                        $fri1[0] = $timedate;    
                        $fri1[1] = rtrim($list, ',');    
                    }                    
                }

                if($day=='Sat') {
                    if(empty($sat)) {
                        $sat[0] = $timedate;    
                        $sat[1] = rtrim($list, ',');    
                    } else {
                        $sat1[0] = $timedate;    
                        $sat1[1] = rtrim($list, ',');    
                    }                    
                }

                if($day=='Sun') {
                    if(empty($sun)) {
                        $sun[0] = $timedate;    
                        $sun[1] = rtrim($list, ',');    
                    } else {
                        $sun1[0] = $timedate;    
                        $sun1[1] = rtrim($list, ',');    
                    }                    
                } 
                $x++;
            }

            $where  = [];
            $where['agency_code'] = $this->session->userdata('agency');
            $agency    =   $this->Comman_model->get_row('agency', $where);
            $orient = 'L';
            $current_date = date('m/d/Y');
            require_once(APPPATH . 'libraries/task-pdf.php'); 
            $pdf = new taskPdf($orient, 'mm',array(315.9,379.4));
            //$pdf=new PDF('L');            

            $spc = 80;

            $logo = 'assets/images/agency'.'/'.$agency['agency_logo'];

            //array(100,150)
            $pdf->AliasNbPages();
            $pdf->AddPage($orient);

            $pdf->SetFont('Courier','',8);
            $pdf->SetLeftMargin(10);
            $pdf->setxy(10,$spc);

            $pdf->SetFont('Times','B',15);
            $pdf->Image(base_url($logo),8,6,80);    
            $pdf->SetFont('Arial','B',14);
            $pdf->setxy(120,30);   
            $pdf->cell(200,8,'PARTICIPANT ACTIVITY TASK REPORT',0,1,'L');
            $pdf->text(260,36,'Month');
            $pdf->text(284,34,$monthName);            
            $pdf->line(278,36,310,36);
            $pdf->text(315,36,'Year');
            $pdf->text(334,34,$year);
            
            $pdf->line(330,36,360,36);
            $pdf->setxy(10,50);   
            $pdf->SetFont('Arial','B',11);
            $pdf->text(10,50,'{  } HCA');
            if($fhca==0) {
                $pdf->setxy(8.5,45);   
                $pdf->SetFont('ZapfDingbats','', 10);
                $pdf->Cell(8.66,8,'4',0,0,'C');  
                $pdf->SetFont('Arial','B',11);
                $pdf->setxy(10,50);   
            }
            $pdf->text(40,50,'Participant Name');
            $pdf->text(80,48,$patientName);
            $pdf->line(78,50,150,50);
            $pdf->text(155,50,'Participant Address');
            $pdf->text(204,48,$patientAddress);            
            $pdf->line(200,50,262,50);

            $pdf->setxy(10,60);   
            $pdf->SetFont('Arial','B',11);
            $pdf->text(10,60,'{  } FHCA');
            if($fhca==1) {
                $pdf->setxy(8.5,55);   
                $pdf->SetFont('ZapfDingbats','', 10);
                $pdf->Cell(8.66,8,'4',0,0,'C');  
                $pdf->SetFont('Arial','B',11);
                $pdf->setxy(10,60);   
            }
            $pdf->text(40,60,'Homecare Aide (Worker) Name');
            $pdf->text(108,58,$employeeName);
            $pdf->line(105,60,150,60);
            $pdf->text(155,60,'Worker PIN:');
            $pdf->text(186,58,$employeePin);            
            $pdf->line(182,60,202,60);
            $pdf->text(207,60,'Supervisor Name');
            $pdf->text(248,58,$supName);            
            $pdf->line(245,60,300,60);

            /*** table header start ***/
            $pdf->setxy(10,70);   
            $pdf->Cell(20,26,'',1,0,'C');
            $pdf->text(14,83,'WEEK');
            $pdf->text(16,88,'DAY');
            $pdf->Cell(20,26,'DATE',1,0,'C');
            $pdf->Cell(130,26,'',1,0,'C');
            $pdf->text(89,83,'TASKS COMPLETED');
            $pdf->SetFont('Arial','',10);
            $pdf->text(58,88,'Please check the number for the corresponding task completed that day.');
            $pdf->SetFont('Arial','B',11);
            $pdf->Cell(40,26,'',1,0,'C');
            $pdf->text(189,75,'WORKER');
            $pdf->text(190,80,'INITIALS');
            $pdf->SetFont('Arial','',10);
            $pdf->text(182,85,'My initials certify that i');
            $pdf->text(185,90,'have performed the');
            $pdf->text(188,95,'task specified');
            $pdf->SetFont('Arial','B',11);
            $pdf->Cell(70,26,'',1,0,'C');
            $pdf->text(230,75,'PARTICIPANT SIGNATURE');
            $pdf->SetFont('Arial','',10);
            $pdf->text(230,80,'By signing, I certify that the tasks');
            $pdf->text(228,85,'were complete on the date below by');
            $pdf->text(240,90,'the Homecare Aide');
            $pdf->SetFont('Arial','B',11);
            
            /*** table header end ***/

            /***** First Row Start*****/
            $pdf->setxy(10,96);   
            $pdf->Cell(20,8,'',1,0,'C');
            $pdf->Cell(20,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'1',1,0,'C');
            $pdf->Cell(8.66,8,'2',1,0,'C');
            $pdf->Cell(8.66,8,'3',1,0,'C');
            $pdf->Cell(8.66,8,'4',1,0,'C');
            $pdf->Cell(8.66,8,'5',1,0,'C');
            $pdf->Cell(8.66,8,'6',1,0,'C');
            $pdf->Cell(8.66,8,'7',1,0,'C');
            $pdf->Cell(8.66,8,'8',1,0,'C');
            $pdf->Cell(8.66,8,'9',1,0,'C');
            $pdf->Cell(8.66,8,'10',1,0,'C');
            $pdf->Cell(8.66,8,'11',1,0,'C');
            $pdf->Cell(8.66,8,'12',1,0,'C');
            $pdf->Cell(8.66,8,'13',1,0,'C');
            $pdf->Cell(8.66,8,'14',1,0,'C');
            $pdf->Cell(8.66,8,'15',1,0,'C');
            $pdf->Cell(40,8,'',1,0,'C');
            $pdf->Cell(70,8,'',1,0,'C');
            /***** First Row End*****/

            $pdf->setxy(10,104);   
            $pdf->Cell(20,8,'Mon',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$mon[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);            
            if(!empty($mon)) {
                $monDays = explode(',', $mon[1]);
                for ($i=1; $i<16; $i++) { 
                    $monDay = '';
                    if(in_array($i, $monDays)) {
                        $monDay = '4';
                    }
                    $pdf->Cell(8.66,8,$monDay,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }

            $pdf->SetFont('Arial','B',11);
            if(!empty($mon)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,112);   
            $pdf->Cell(20,8,'Tue',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$tue[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($tue)) {
                $tueDays = explode(',', $tue[1]);
                for ($i=1; $i<16; $i++) { 
                    $tueDay = '';
                    if(in_array($i, $tueDays)) {
                        $tueDay = '4';
                    }
                    $pdf->Cell(8.66,8,$tueDay,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }

            $pdf->SetFont('Arial','B',11);
            if(!empty($tue)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,120);   
            $pdf->Cell(20,8,'Wed',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$wed[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($wed)) {
                $wedDays = explode(',', $wed[1]);
                for ($i=1; $i<16; $i++) { 
                    $wedDay = '';
                    if(in_array($i, $wedDays)) {
                        $wedDay = '4';
                    }
                    $pdf->Cell(8.66,8,$wedDay,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }

            $pdf->SetFont('Arial','B',11);
            if(!empty($wed)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,128);   
            $pdf->Cell(20,8,'Thu',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$thu[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($thu)) {
                $thuDays = explode(',', $thu[1]);
                for ($i=1; $i<16; $i++) { 
                    $thuDay = '';
                    if(in_array($i, $thuDays)) {
                        $thuDay = '4';
                    }
                    $pdf->Cell(8.66,8,$thuDay,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }

            $pdf->SetFont('Arial','B',11);
            if(!empty($thu)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');

            $pdf->setxy(10,136);   
            $pdf->Cell(20,8,'Fri',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$fri[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($fri)) {
                $friDays = explode(',', $fri[1]);
                for ($i=1; $i<16; $i++) { 
                    $friDay = '';
                    if(in_array($i, $friDays)) {
                        $friDay = '4';
                    }
                    $pdf->Cell(8.66,8,$friDay,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            
            $pdf->SetFont('Arial','B',11);
            if(!empty($fri)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');

            $pdf->setxy(10,144);   
            $pdf->Cell(20,8,'Sat',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$sat[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($sat)) {
                $satDays = explode(',', $sat[1]);
                for ($i=1; $i<16; $i++) { 
                    $satDay = '';
                    if(in_array($i, $satDays)) {
                        $satDay = '4';
                    }
                    $pdf->Cell(8.66,8,$satDay,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            
            $pdf->SetFont('Arial','B',11);
            if(!empty($sat)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,152);   
            $pdf->Cell(20,8,'Sun',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$sun[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($sun)) {
                $sunDays = explode(',', $sun[1]);
                for ($i=1; $i<16; $i++) { 
                    $sunDay = '';
                    if(in_array($i, $sunDays)) {
                        $sunDay = '4';
                    }
                    $pdf->Cell(8.66,8,$sunDay,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }

            $pdf->SetFont('Arial','B',11);
            if(!empty($sun)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,160);   
            $pdf->Cell(20,8,'',1,0,'C');
            $pdf->Cell(20,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(8.66,8,'',1,0,'C');
            $pdf->Cell(40,8,'',1,0,'C');
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,168);   
            $pdf->Cell(20,8,'Mon',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$mon1[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($mon1)) {
                $mon1Days = explode(',', $mon1[1]);
                for ($i=1; $i<16; $i++) { 
                    $mon1Day = '';
                    if(in_array($i, $mon1Days)) {
                        $mon1Day = '4';
                    }
                    $pdf->Cell(8.66,8,$mon1Day,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            $pdf->SetFont('Arial','B',11);
            if(!empty($mon1)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,176);   
            $pdf->Cell(20,8,'Tue',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$tue1[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($tue1)) {
                $tue1Days = explode(',', $tue1[1]);
                for ($i=1; $i<16; $i++) { 
                    $tue1Day = '';
                    if(in_array($i, $tue1Days)) {
                        $tue1Day = '4';
                    }
                    $pdf->Cell(8.66,8,$tue1Day,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            $pdf->SetFont('Arial','B',11);
            if(!empty($tue1)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,184);   
            $pdf->Cell(20,8,'Wed',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$wed1[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($wed1)) {
                $wed1Days = explode(',', $wed1[1]);
                for ($i=1; $i<16; $i++) { 
                    $wed1Day = '';
                    if(in_array($i, $wed1Days)) {
                        $wed1Day = '4';
                    }
                    $pdf->Cell(8.66,8,$wed1Day,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            $pdf->SetFont('Arial','B',11);
            if(!empty($wed1)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,192);   
            $pdf->Cell(20,8,'Thu',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$thu1[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($thu1)) {
                $thu1Days = explode(',', $thu1[1]);
                for ($i=1; $i<16; $i++) { 
                    $thu1Day = '';
                    if(in_array($i, $thu1Days)) {
                        $thu1Day = '4';
                    }
                    $pdf->Cell(8.66,8,$thu1Day,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            $pdf->SetFont('Arial','B',11);
            if(!empty($thu1)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');

            $pdf->setxy(10,200);   
            $pdf->Cell(20,8,'Fri',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$fri1[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($fri1)) {
                $fri1Days = explode(',', $fri1[1]);
                for ($i=1; $i<16; $i++) { 
                    $fri1Day = '';
                    if(in_array($i, $fri1Days)) {
                        $fri1Day = '4';
                    }
                    $pdf->Cell(8.66,8,$fri1Day,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            $pdf->SetFont('Arial','B',11);
            if(!empty($fri1)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');

            $pdf->setxy(10,208);   
            $pdf->Cell(20,8,'Sat',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$sat1[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($sat1)) {
                $sat1Days = explode(',', $sat1[1]);
                for ($i=1; $i<16; $i++) { 
                    $sat1Day = '';
                    if(in_array($i, $sat1Days)) {
                        $sat1Day = '4';
                    }
                    $pdf->Cell(8.66,8,$sat1Day,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            $pdf->SetFont('Arial','B',11);
            if(!empty($sat1)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,216);   
            $pdf->Cell(20,8,'Sun',1,0,'C');
            $pdf->SetFont('Arial','',10);
            $pdf->Cell(20,8,$sun1[0],1,0,'C');
            $pdf->SetFont('ZapfDingbats','', 10);
            if(!empty($sun1)) {
                $sun1Days = explode(',', $sun1[1]);
                for ($i=1; $i<16; $i++) { 
                    $sun1Day = '';
                    if(in_array($i, $sun1Days)) {
                        $sun1Day = '4';
                    }
                    $pdf->Cell(8.66,8,$sun1Day,1,0,'C');                    
                }
            } else {
                for ($i=1; $i<16; $i++) { 
                    $pdf->Cell(8.66,8,'',1,0,'C');
                }
            }
            $pdf->SetFont('Arial','B',11);
            if(!empty($sun1)) {
                $pdf->Cell(40,8,$empInitials,1,0,'C');
            } else {
                $pdf->Cell(40,8,'',1,0,'C');
            }
            $pdf->Cell(70,8,'',1,0,'C');


            $pdf->setxy(10,224);   
            $pdf->Cell(280,35,'',1,0,'C');
            $pdf->text(130,230,'TASKS LIST');
            $pdf->setxy(15,232);   
            $pdf->Cell(56,10,'(1) Eating',0,0,'L');
            $pdf->Cell(56,10,'(4) Dressing',0,0,'L');
            $pdf->Cell(56,10,'(7) Managing Money',0,0,'L');
            $pdf->Cell(56,10,'(10) Laundry',0,0,'L');
            $pdf->Cell(56,10,'(13) Routine Health',0,0,'L');
            $pdf->setxy(15,240);   
            $pdf->Cell(56,10,'(2) Bathing',0,0,'L');
            $pdf->Cell(56,10,'(5) Transferring',0,0,'L');
            $pdf->Cell(56,10,'(8) Telephoning',0,0,'L');
            $pdf->Cell(56,10,'(11) Housework',0,0,'L');
            $pdf->Cell(56,10,'(14) Special Health',0,0,'L');
            $pdf->setxy(15,248);   
            $pdf->Cell(56,10,'(3) Grooming',0,0,'L');
            $pdf->Cell(56,10,'(6) Incontinence',0,0,'L');
            $pdf->Cell(56,10,'(9) Preparing Meals',0,0,'L');
            $pdf->Cell(56,10,'(12) Outside Home',0,0,'L');
            $pdf->Cell(56,10,'(15) Being Alone',0,0,'L');
            $pdf->setxy(10,256);   
            $pdf->SetFont('Arial','',10);
            $pdf->text(20,270,'HCA/FHCA(WORKER) SIGNATURE');
            $pdf->line(80,270,160,270);
            $pdf->text(163,270,'DATE');
            $pdf->line(175,270,200,270);
            $pdf->text(203,270,'SUPERVISOR SIGNATURE');
            $pdf->line(250,270,345,270);
            $pdf->SetFont('Arial','B',11);
            $pdf->text(55,278,'BY SIGNING BELOW, YOU CERTIFY THAT THE ABOVE SERVICES WERE PROVIDED TO YOU IN THE DAYS INDICATED ON THIS TASK SHEET');
            $pdf->text(75,286,'PARTICIPANT(CLIENT)/AUTHORIZED REPRESENTATIVE SIGNATURE');
            $pdf->line(208,286,275,286);
            $pdf->text(278,286,'DATE');
            $pdf->line(290,286,330,286);

            $pdf->line(290,70,370,70);
            $pdf->line(370,70,370,259);
            $pdf->line(290,259,370,259);
            $pdf->text(316,75,'2-WAY RECEIPT');

            $pdf->setxy(292,80);   
            $pdf->SetFont('Arial','B',9);
            $pdf->Cell(76,7,'Amount GIVEN to WORKER',1,0,'C');
            $pdf->SetFont('Arial','',9);
            $pdf->setxy(292,87);   
            $pdf->Cell(10,8,'Date',1,0,'C');
            $pdf->Cell(10,8,'Cash',1,0,'C');
            $pdf->Cell(10,8,'Check',1,0,'C');
            $pdf->Cell(15,8,'',1,0,'C');
            $pdf->text(326,91,'Food');
            $pdf->text(325,94,'Stamps');
            $pdf->Cell(31,8,"Worker's Signature",1,0,'C');


            $pdf->setxy(292,95);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,101);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,107);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,113);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,119);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,133);   
            $pdf->SetFont('Arial','B',9);
            $pdf->Cell(76,7,'Amount RETURNED to CLIENT',1,0,'C');
            $pdf->SetFont('Arial','',9);
            $pdf->setxy(292,140);   
            $pdf->Cell(10,8,'Date',1,0,'C');
            $pdf->Cell(10,8,'Cash',1,0,'C');
            $pdf->Cell(10,8,'Check',1,0,'C');
            $pdf->Cell(15,8,'',1,0,'C');
            $pdf->text(326,144,'Food');
            $pdf->text(325,148,'Stamps');
            $pdf->Cell(31,8,"Worker's Signature",1,0,'C');

            $pdf->setxy(292,148);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,154);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,160);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,166);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,172);   
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(10,6,'',1,0,'C');
            $pdf->Cell(15,6,'',1,0,'C');
            $pdf->Cell(31,6,'',1,0,'C');

            $pdf->setxy(292,186);   
            $pdf->Cell(4,4,'',1,0,'L');
            $pdf->text(300,189.5,'Check this box if your client was admitted in the');
            $pdf->text(300,194.5,'hospital/rehab.');

            $pdf->setxy(292,192);   
            $pdf->text(292,199,'Date Admitted');
            $pdf->line(315,199,340,199);
            $pdf->text(292,204,'Date Released');
            $pdf->line(315,204,340,204);

            $pdf->setxy(292,210);   
            $pdf->Cell(4,4,'',1,0,'L');
            $pdf->text(300,213.5,'Check this box if your client refused service.');

            $pdf->text(292,219,'Date Refused');
            $pdf->line(315,219,340,219);


            $pdf->setxy(292,226);   
            $pdf->Cell(4,4,'',1,0,'L');
            $pdf->text(300,229.5,'Check this box if your client had a fall.');

            $pdf->text(292,235,'Date of Incident');
            $pdf->line(317,235,340,235);

            $filename = 'PATR'.date('mdYHis').'.pdf';
            $pdf->Output($filename,'I');
            $pdf->close();
            //exit;
        } else {
            redirect();
        }
    }

}