<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Idoa extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->library('user_agent');
    }

    public function getExcelData() {

        if(!empty($_GET['month'])) {
            $month = $_GET['month'];
        } else {
            $month = date('m');
        }

        if(!empty($_GET['year'])) {
            $year = $_GET['year'];
        } else {
            $year = date('Y');
        }

        $filename = "IDOA_MONTHLY_".$month."_".$year.".xls";
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $viewmode = 1; $qbviewmode = 0;
        if(!empty($_GET['viewmode'])) {
           $viewmode = $_GET['viewmode']; 
        }
        if(!empty($_GET['qbviewmode'])) {
           $qbviewmode = $_GET['qbviewmode']; 
        }

        $table = "idoadb";
        $cond = "";
        if(!empty($_GET['viewmode'])) {
            $viewmode = $_GET['viewmode']; 
            $cond = "AND $table.batchno IS NULL ";
        }

        $flag = false;
        $row2 = 0;
        if($viewmode==2 || $viewmode==3 || $viewmode==33) {
            $arry = array('CLIENT ID','LAST NAME','FIRST NAME','LOCATION','BATCH NO','SERVICE DATE','HOURS','AMOUNT');
        }

        if($viewmode==1) {
            $arry = array('CLIENT ID','LAST NAME','FIRST NAME','LOCATION','CCU CONTRACT#','PROVIDER CONTRACT#','SERVICE CODE','SERVICE DATE','HOURS','AMOUNT');
        }
        
        
        if($viewmode==2) {
            $nbatchno = $_GET['nbatchno'];
            if(!empty($nbatchno)) {
                $cond = "AND $table.batchno = '".$nbatchno."' AND total_paid = 0 ";
            } else {
                $cond = "AND $table.batchno!='' AND total_paid = 0 ";
            }            
        }

        if($viewmode==33) {
            $cond = "AND $table.batchno!='' ";
        }

        if($viewmode==3) {
            $table = "idoadbfinal";
            $nbatchno = $_GET['nbatchno'];
            if(!empty($nbatchno)) {
                $cond = "AND $table.batchno = '".$nbatchno."' AND $table.total_paid = 0 AND $table.status != 'Rejected' ";
            } else {
                $cond = "AND $table.batchno!='' AND $table.total_paid = 0 AND $table.status != 'Rejected' ";
            }
        }

        if($viewmode==6) {
            $nbatchno = $_GET['nbatchno'];
            if(!empty($nbatchno)) {
                $cond = " AND $table.batchno = '".$nbatchno."' ";
            }            
        }
        
        $agency_code = $_GET['agency_code'];
        $controlno = $_GET['controlno'];
        $billable_type = $_GET['billable_type'];
        if($controlno!='') {
            $cond .= "AND patient.controlno = '".$controlno."' ";
        }

        if($billable_type!='' && $billable_type==2) {
            $cond .= "AND (patient.controlno = '' OR patient.clientid = '' OR patient.ccucontract = '') ";
        }

        if($billable_type!='' && $billable_type==1) {
            $cond .= "AND (patient.controlno != '' AND patient.clientid != '' AND patient.ccucontract != '') ";
        }

        if(!empty($DistrictID_Ref2) && $DistrictID_Ref2!='888') {
            $cond .= "AND $table.mco = '".$DistrictID_Ref2."' ";
        }

        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,$table WHERE patient.patient_id = $table.patient_id AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC";
        $res = $this->Comman_model->getCustomQueryData($sql);

        $totalRec = 0;
        $datas = [];
        $data = [];
        if(!empty($_GET['qb_profile']) && ($viewmode==33 || $viewmode==9)) {

            if(!empty($_GET['qb_profile'])) {
                $qb_profile = $_GET['qb_profile'];
            } else {
                $qb_profile = 2;
            }
            $cond1 = "";
            if($qb_profile==1) {
                $sql = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC";          
                $resT = $this->Comman_model->getCustomQueryData($sql);
                foreach ($resT as $keyT => $rowT) {
                    $params = [];

                    $firstname = $rowT['firstname'].' '.$rowT['middlename'];
                    $servicedate = date('m/d/Y',strtotime($rowT['servicedate']));

                    $params[0]  = $rowT['clientid'].'/'.$rowT['patient_id'];
                    $params[1]  = $rowT['lastname'];                    
                    $params[2]  = $firstname;
                    $params[3]  = $rowT['ccucontract'];
                    $params[4]  = $rowT['controlno'];
                    //$params[5]  = '021';
                    $params[5]  = $servicedate;
                    $params[6]  = $rowT['units'];
                    $params[7]  = $rowT['total_amount'];

                    if(!empty($params)) {
                        $data[$keyT] = $params;
                    }
                }
            }

            if($qb_profile==2) {
                $sql = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id NOT IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC";

                $resT = $this->Comman_model->getCustomQueryData($sql);
                foreach ($resT as $keyT => $rowT) {
                    $params = [];
                    $firstname = $rowT['firstname'].' '.$rowT['middlename'];
                    $servicedate = date('m/d/Y',strtotime($rowT['servicedate']));

                    $params[0]  = $rowT['clientid'].'/'.$rowT['patient_id'];
                    $params[1]  = $rowT['lastname'];                    
                    $params[2]  = $firstname;
                    $params[3]  = $rowT['ccucontract'];
                    $params[4]  = $rowT['controlno'];
                    //$params[5]  = '021';
                    $params[5]  = $servicedate;
                    $params[6]  = $rowT['units'];
                    $params[7]  = $rowT['total_amount'];

                    if(!empty($params)) {
                        $data[$keyT] = $params;
                    }
                }
            }
        }
        
        $nex = 0;
        if($viewmode!=33 && $qbviewmode==0) {
            foreach ($res as $key => $row) {

                $sqlal = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$row['agency_location']."'";
                $rowal = $this->Comman_model->getCustomQueryData($sqlal, 'row');
                $agency_location = $rowal['agency_location_name'];

                $params = [];                

                if($viewmode==1) {
                    $firstname = $row['firstname'].' '.$row['middlename'];
                    $servicedate = date('m/d/Y',strtotime($row['servicedate']));

                    $params[0]  = $row['clientid'].'/'.$row['patient_id'];
                    $params[1]  = $row['lastname'];                    
                    $params[2]  = $firstname;
                    $params[3]  = $agency_location;
                    $params[4]  = $row['ccucontract'];
                    $params[5]  = $row['controlno'];
                    $params[6]  = '021';
                    $params[7]  = $servicedate;
                    $params[8]  = $row['units'];
                    $params[9]  = $row['total_amount'];
                }

                if($viewmode==2) {
                    $firstname = $row['firstname'].' '.$row['middlename'];
                    $servicedate = date('m/d/Y',strtotime($row['servicedate']));

                    $params[0]  = $row['clientid'].'/'.$row['patient_id'];
                    $params[1]  = $row['lastname'];
                    $params[2]  = $firstname;
                    $params[3]  = $agency_location;
                    $params[4]  = $row['batchno'];
                    $params[5]  = $servicedate;
                    $params[6]  = $row['units'];
                    $params[7]  = $row['total_amount'];
                }                

                if($viewmode==3) {
                    $firstname = $row['firstname'].' '.$row['middlename'];
                    $servicedate = date('m/d/Y',strtotime($row['servicedate']));

                    $params[0]  = $row['clientid'].'/'.$row['patient_id'];
                    $params[1]  = $row['lastname'];
                    $params[2]  = $firstname;
                    $params[3]  = $agency_location;
                    $params[4]  = $row['batchno'];
                    $params[5]  = $servicedate;
                    $params[6]  = $row['units'];
                    $params[7]  = $row['total_amount'];
                }                
                if(!empty($params)) {
                    $data[$key] = $params;
                }
            }
        }

        if($qbviewmode==1) {
            $qb_profile = 2;
            $cond1 = "";
            
            $sql = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id NOT IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC";

            $resT = $this->Comman_model->getCustomQueryData($sql);
            foreach ($resT as $keyT => $rowT) {

                $sqlal = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '".$rowT['agency_location']."'";
                $rowal = $this->Comman_model->getCustomQueryData($sqlal, 'row');
                $agency_location = $rowal['agency_location_name'];

                $params = [];
                $firstname = $rowT['firstname'].' '.$rowT['middlename'];
                $servicedate = date('m/d/Y',strtotime($rowT['servicedate']));

                $params[0]  = $rowT['clientid'].'/'.$rowT['patient_id'];
                $params[1]  = $rowT['lastname'];                    
                $params[2]  = $firstname;
                $params[3]  = $agency_location;
                $params[4]  = $rowT['ccucontract'];
                $params[5]  = $rowT['controlno'];
                $params[6]  = '021';
                $params[7]  = $servicedate;
                $params[8]  = $rowT['units'];
                $params[9]  = $rowT['total_amount'];

                if(!empty($params)) {
                    $data[$keyT] = $params;
                }
            }            
        }
        
        if(!empty($data)) {
            foreach ($data as $key => $row) {
                if(!$flag) {
                  array_walk($row, array($this,'cleanData'));
                  echo implode("\t",$arry) . "\r\n";
                  $flag = true;
                }
                array_walk($row, array($this, 'cleanData'));
                $x = 1;
                echo implode("\t", array_values($row)) . "\r\n";
            }
        } else {
            $this->session->set_flashdata('error_message', 'Oops no record found.');
            redirect($this->agent->referrer());
        }
    }

    public function cleanData(&$str)  {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    public function monthlySC() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                //redirect('idoa/monthlyHMCG');
            }

            $data = [];
            $data['month'] = date('m');
            $data['year'] = date('Y');
            $data['viewmode'] = 1;
            $data['agency_code'] = $agency_code;
            $data['InterAgency'] = '';
            $data['DistrictID_Ref2'] = '';
            $data['qb_profile'] = '';
            $data['qbviewmode'] = '0';
            $data['formSubmit'] = '';
            $data['controlno'] = '';
            $data['billable_type'] = 1;
            $data['nbatchno'] = '';

            if(!empty($_GET['qbviewmode'])) {
               $data['qbviewmode'] = $_GET['qbviewmode']; 
            }
            if(!empty($_GET['controlno'])) {
                $data['controlno'] = $_GET['controlno'];
            }
            if(!empty($_GET['nbatchno'])) {
                $data['nbatchno'] = $_GET['nbatchno'];
            }
            if(!empty($_GET['month'])) {
                $data['month'] = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                $data['year'] = $_GET['year'];
            }
            if(!empty($_GET['viewmode'])) {
                $data['viewmode'] = $_GET['viewmode'];
            }
            if(!empty($_GET['DistrictID_Ref2'])) {
                $data['DistrictID_Ref2'] = $_GET['DistrictID_Ref2'];
            }
            if(!empty($_GET['qb_profile'])) {
                $data['qb_profile'] = $_GET['qb_profile'];
            }
            if(!empty($_GET['formSubmit'])) {
                $data['formSubmit'] = $_GET['formSubmit'];
            }
            if(isset($_GET['InterAgency']) && $_GET['InterAgency']!='') {
                $data['InterAgency'] = $_GET['InterAgency'];
            }
            if(isset($_GET['billable_type']) && $_GET['billable_type']!='') {
                $data['billable_type'] = $_GET['billable_type'];
            }            

            /*if ($_GET['formSubmit']=='GENERATE IDOA' && $_GET['controlno']=='') {
                $this->session->set_flashdata('error_message', "Please select contract no. then try again.");
                $url = base_url('idoa/monthlySC')."?controlno=".$data['controlno']."&viewmode=".$data['viewmode']."&controlno=".$data['controlno']."&month=".$data['month']."&year=".$data['year']."";
                redirect($url);
            }*/

            $data['displayRate'] = 5.07;
            if ($data['month']>='12' && $data['year']>='2019') { 
                $data['displayRate'] = 5.46;
            }               
            if ($data['month']>='04' && $data['year']>='2021') { 
                $data['displayRate'] = 5.85;
            }


            $chkSQL = "SELECT * FROM idoa_rate_settings WHERE MONTH(start_date) = '".$data['month']."' AND YEAR(start_date) = '".$data['year']."' AND agency = '$agency_code'";
            $objRow = get_custom_query_data($chkSQL, 'row');
            if(!empty($objRow)) {
                $data['displayRate'] = $objRow['rate'];    
            } else {
                $chkSQL = "SELECT * FROM idoa_rate_settings WHERE MONTH(start_date) <= '".$data['month']."' AND YEAR(start_date) <= '".$data['year']."' AND agency = '$agency_code' ORDER BY id DESC";
                $objRow = get_custom_query_data($chkSQL, 'row');
                if(!empty($objRow)) {
                    $data['displayRate'] = $objRow['rate'];
                }
            }
            
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date>='2020-01-01' AND start_date<='2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            if($_GET["startdate"] == null) {
                $thedate = date('Y-m-d');
                $strSQL = "SELECT * FROM table_2weekly WHERE start_date<'$thedate' ORDER BY start_date DESC LIMIT 1";
                $objResult = get_custom_query_data($strSQL, 'row');
                $data['startdate'] = $objResult['start_date'];                   
            }

            $strSQL = "SELECT * FROM idoa";
            $objExec = get_custom_query_data($strSQL);
            $data['contractData'] = $objExec;

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('idoa/monthly.php', $data);
            $this->load->view('common/footer-new.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('idoa/monthly-new.php', $data);
        } else {
            redirect();
        }
    }

    public function postlog($postcomment) {
        $postuser = $this->session->userdata('name');
        $postdate = date("Y-m-d H:i:s");
        $postagency = $this->session->userdata('agency');
        $postmode = 0;
        $notesid = 0;
        $postcategory = '';

        $dataArray = [];
        $dataArray['postdate'] = $postdate;
        $dataArray['postuser'] = $postuser;
        $dataArray['postagency'] = $postagency;
        $dataArray['postperiod'] = $postmode;
        $dataArray['postcomment'] = $postcomment;
        $dataArray['postcategory'] = $postcategory;
        $dataArray['notesid'] = $notesid;

        $postlog_id = $this->Comman_model->insert('postlog', $dataArray);
    }

    function savecms1500info() {
        /******** Save cms_1500 Data Start*********/
        if ($_POST['formSubmit'] == 'Save')  {

            $agency_code = $this->session->userdata('agency');

            $recno      = $_POST['recno'];
            $charges    = $_POST['charges'];
            $units      = $_POST['units'];
            //$memberid   = $_POST['memberid'];
            $pa         = $_POST['pa'];

            $DistrictID_Ref2 = $_POST['DistrictID_Ref2'];
            $totalcharges = $charges;

            $strSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '".$DistrictID_Ref2."' AND Agency = '".$agency_code."'";
            $objResult = $this->Comman_model->getCustomQueryData($strSQL, 'row');

            $InsuranceCompanyName = $objResult['DistrictName'];
            $BillAddressAddr = $objResult['BillingAddress'];
            $BillAddressAddr2 = $objResult['BillingAddress2'];

            $col170 = '"28-TotalCharge"';
            $col088 = '"24.1.a-DOSFrom"';
            $col089 = '"24.1.a-DOSTo"';
            $col006 = '"Insurance Company Name"';
            $col008 = '"Insurance Company Address 1"';
            $col009 = '"Insurance Company Address 2"';
            $col087 = '"23-PriorAuth"';
            $dosfrom = $_POST['frmDate'];  
            $dosto = $dosfrom;
            $query = "UPDATE cms1500 SET `$col088` = '$dosfrom',`$col089` = '$dosto',`$col170` = '$totalcharges', `$col087` = '$pa', `$col006`= '$InsuranceCompanyName', `$col008` = '$BillAddressAddr', `$col009` = '$BillAddressAddr2', mco = '$DistrictID_Ref2' WHERE cms1500_id = '$recno'";
            set_custom_query_data($query);

            $this->session->set_flashdata('message','Data has been updated successfully.');
            redirect($this->agent->referrer());
        }
        /******** Save cms_1500 Data End*********/
    }

    function getPatientData() {
        if(!empty($_POST['cms1500id'])) {
            $table = "cms1500";
            $sql = "SELECT SQL_CALC_FOUND_ROWS *, tbldistricts.mco as tblmco, $table.mco as mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.cms1500_id = '".$_POST['cms1500id']."'";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');
            $data = [];
            $patientName = $row['"2-PatientName"'];
            $fromDate = $row['"24.1.a-DOSFrom"'];
            $data['mco'] = $row['mco'];
            $patient_id = $row['patient_id'];
            $col087 = '"23-PriorAuth"';
            $pa = $row[$col087];
            $agency_code = $this->session->userdata('agency');
            $charges = $row['"28-TotalCharge"'];
            $units = $row['"24.1.g-Units"'] + $row['"24.2.g-Units"'] + $row['"24.3.g-Units"'] + $row['"24.4.g-Units"'] + $row['"24.5.g-Units"'] + $row['"24.6.g-Units"'];

            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $districtData = $this->Comman_model->getCustomQueryData($strSQL);

            $data = '<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h4 class="modal-title">'.$patientName.' Details</h4></div><form method="post" action="'.base_url('mco/savecms1500info').'"><div class="modal-body user-modal-body">';

            $data .= '<div class="row"><div class="col-md-6"><div class="form-group"><label>DISTRICT/MCO</label><select name="DistrictID_Ref2" id="mdDistrictID_Ref2" class="form-control"><option value="">Select</option>';
            if(!empty($districtData)) {
                foreach ($districtData as $key => $objResult) {
                    $selected = '';
                    if($row['mco']==$objResult['DistrictID']) {
                        $selected = ' selected';
                    }
                    $data .= '<option value="'.$objResult['DistrictID'].'"'.$selected.'>'.$objResult['DistrictName'].' ('.$objResult['DistrictNumber'].')</option>';
                }
            }
            $data .= '</select></div></div><div class="col-md-6"><div class="form-group"><label>PA</label><select name="pa" class="form-control">';
            if(empty($pa)) {
                $strSQL = "SELECT * FROM patient_auth_history where patient_id = '".$patient_id."' ORDER BY patient_auth_history_id DESC" ;
                $intRows = 0;
                $objResult = $this->Comman_model->getCustomQueryData($strSQL, 'row');
                $pa = $objResult["authorization"];   
            }
            $strSQL = "SELECT * FROM patient_auth_history where patient_id = '".$patient_id."' ORDER BY patient_auth_history_id DESC" ;
            $objExec = $this->Comman_model->getCustomQueryData($strSQL);
            $intRows = 0;
            foreach ($objExec as $key => $objResult) {
                $intRows++; 
                $selected = '';
                if ($pa==$objResult['authorization']) {
                    $paName = $objResult['authorization'];
                    $selected = ' selected';
                }
                $data .= '<optgroup label="'.date("m/d/Y",strtotime($objResult['validfrom'])).' - '. date("m/d/Y",strtotime($objResult['validto'])).'"><option value="'.$objResult['authorization'].'"'.$selected.'>'.$objResult['authorization'].'</option></optgroup>';
            }
            $data .= '</select></div></div></div>';
            $data .= '<div class="row"><div class="col-md-4"><div class="form-group"><label>FROM</label><input type="text" name="frmDate" id="frmDate" class="form-control mydatepicker-autoclose" value="'.$fromDate.'"><input type="hidden" name="recno" id="recno" value="'.$_POST['cms1500id'].'"></div></div>';

            $data .= '<div class="col-md-4"><div class="form-group"><label>Charges</label><input type="text" name="charges" id="charges" class="form-control" value="'.$charges.'"></div></div>';

            $data .= '<div class="col-md-4"><div class="form-group"><label>Units</label><input type="text" name="units" id="units" class="form-control" value="'.$units.'"></div></div></div>';

            $data .= '</div><div class="modal-footer"><button type="submit" name="formSubmit" value="Save" class="btn btn-primary">Update</button><button type="button" class="btn btn-default" data-dismiss="modal">Close</button></div></form>';

            print_r($data);
        }
    }

    function customerUpdate() {
        $sql = "TRUNCATE customer";
        set_custom_query_data($sql);

        $sql = "INSERT INTO customer SELECT * FROM seniorcare.customer";
        set_custom_query_data($sql);

        $this->session->set_flashdata('message', 'Customer table has been updated successfully.');
        redirect($this->agent->referrer());
    }

    function monthlyData() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        $viewmode = 1; $qbviewmode = 0;
        if(!empty($_GET['viewmode'])) {
            $viewmode = $_GET['viewmode']; 
            $table = "idoadb";
            $cond = "AND $table.batchno IS NULL ";
        }

        if(!empty($_GET['qbviewmode'])) {
           $qbviewmode = $_GET['qbviewmode']; 
        }

        $table = "idoadb";
        if($viewmode==2 && $qbviewmode==0) {
            $table = "idoadb";
            $nbatchno = $_GET['nbatchno'];
            if(!empty($nbatchno)) {
                $cond  = "AND $table.batchno = '".$nbatchno."' AND total_paid = 0 ";    
            } else {
                $cond  = "AND $table.batchno!='' AND total_paid = 0 ";
            }
        }

        if($viewmode==33 || $viewmode==9) {
            $cond  = "AND $table.batchno!='' AND $table.total_paid = 0 ";
        }

        if($viewmode==6) {
            $nbatchno = $_GET['nbatchno'];
            if(!empty($nbatchno)) {
                $cond  = "AND $table.batchno = '".$nbatchno."' ";    
            }
        }

        if($viewmode==3) {
            $nbatchno = $_GET['nbatchno'];
            $table = "idoadbfinal";
            if(!empty($nbatchno)) {
                $cond = " AND $table.batchno = '".$nbatchno."' AND $table.total_paid = 0 AND $table.status != 'Rejected' ";
            } else {
                $cond = " AND $table.batchno != '' AND $table.total_paid = 0 AND $table.status != 'Rejected' ";
            }            
        }

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND patient.lastname LIKE '%".$search."%'";
        }
        if(!empty($_GET['month']) && !empty($_GET['year'])) {
            $month = $_GET['month']; $year = $_GET['year'];
        } else {
            $month = date('m'); $year = date('Y');
        }
        $agency_code = $_GET['agency_code'];
        $controlno = $_GET['controlno'];
        $DistrictID_Ref2 = $_GET['DistrictID_Ref2'];
        $billable_type = $_GET['billable_type'];
        if($controlno!='') {
            $cond .= "AND patient.controlno = '".$controlno."' ";
        }

        if($billable_type!='' && $billable_type==2) {
            $cond .= "AND (patient.controlno = '' OR patient.clientid = '' OR patient.ccucontract = '') ";
        }

        if($billable_type!='' && $billable_type==1) {
            $cond .= "AND (patient.controlno != '' AND patient.clientid != '' AND patient.ccucontract != '') ";
        }

        if(!empty($DistrictID_Ref2) && $DistrictID_Ref2!='888') {
            $cond .= "AND $table.mco = '".$DistrictID_Ref2."' ";
        }        

        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,$table WHERE patient.patient_id = $table.patient_id AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC $sLimit";        
        if($viewmode==6) {
            $sql = "SELECT idoadb.patient_id, lastname, firstname, servicedate,units,batchno,clientid,billnum,total_amount,idoa_id FROM idoadb,patient WHERE idoadb.patient_id IN (SELECT idoadb.patient_id FROM idoadb WHERE month = '$month' AND year = '$year' AND total_paid = 0 and idoadb.Agency = '$agency_code' AND batchno != '' $cond GROUP BY idoadb.patient_id HAVING COUNT(patient_id) > 1) AND month = '$month' AND year = '$year' AND total_paid = 0 AND idoadb.Agency = '$agency_code' AND batchno != '' AND idoadb.patient_id = patient.patient_id $cond ORDER BY patient.lastname  ASC $sLimit";
        }
        $res = $this->Comman_model->getCustomQueryData($sql);


        $sqlGT = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,$table WHERE patient.patient_id = $table.patient_id AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond GROUP BY $table.patient_id";
        if($viewmode==6) {
            $sqlGT = "SELECT idoadb.patient_id, lastname, firstname, servicedate,units,batchno,clientid,billnum,total_amount,idoa_id FROM idoadb,patient WHERE idoadb.patient_id IN (SELECT idoadb.patient_id FROM idoadb WHERE month = '$month' AND year = '$year' AND total_paid = 0 and idoadb.Agency = '$agency_code' AND batchno != '' $cond GROUP BY idoadb.patient_id HAVING COUNT(patient_id) > 1) AND month = '$month' AND year = '$year' AND total_paid = 0 AND idoadb.Agency = '$agency_code' AND batchno != '' AND idoadb.patient_id = patient.patient_id $cond GROUP BY $table.patient_id";
        }
        $resGT = $this->Comman_model->getCustomQueryData($sqlGT);
        $tcnt = count($resGT);

        $sqlGT = "SELECT total_amount as totalIA FROM patient,$table WHERE patient.patient_id = $table.patient_id AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond";
        if($viewmode==6) {
            $sqlGT = "SELECT idoadb.patient_id, lastname, firstname, servicedate,units,batchno,clientid,billnum,total_amount,idoa_id FROM idoadb,patient WHERE idoadb.patient_id IN (SELECT idoadb.patient_id FROM idoadb WHERE month = '$month' AND year = '$year' AND total_paid = 0 and idoadb.Agency = '$agency_code' AND batchno != '' $cond GROUP BY idoadb.patient_id HAVING COUNT(patient_id) > 1) AND month = '$month' AND year = '$year' AND total_paid = 0 AND idoadb.Agency = '$agency_code' AND batchno != '' AND idoadb.patient_id = patient.patient_id $cond";
        }
        $resultGT = $this->Comman_model->getCustomQueryData($sqlGT);
        $tamt = 0;
        foreach ($resultGT as $keyGT => $rowGT) {
            //$amt = number_format(floatvalue($rowGT['totalIA']), 2, '.', '');
            $amt = $rowGT['totalIA'];
            $tamt = $tamt + $amt;
        }
        $amt = number_format($tamt, 2, '.', '');

        $lblTotal = "</br><p class='normal'> Total Clients: ".$tcnt."&nbsp; &nbsp; &nbsp; Total Invoice Amount: ".$amt;

        if($viewmode!=33 && $qbviewmode==0) {
            /******** Get recordsTotal ********/
            $sqlT = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,$table WHERE patient.patient_id = $table.patient_id AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC";
            if($viewmode==6) {
                $sqlT = "SELECT idoadb.patient_id, lastname, firstname, servicedate,units,batchno,clientid,billnum,total_amount,idoa_id FROM idoadb,patient WHERE idoadb.patient_id IN (SELECT idoadb.patient_id FROM idoadb WHERE month = '$month' AND year = '$year' AND total_paid = 0 and idoadb.Agency = '$agency_code' AND batchno != '' $cond GROUP BY idoadb.patient_id HAVING COUNT(patient_id) > 1) AND month = '$month' AND year = '$year' AND total_paid = 0 AND idoadb.Agency = '$agency_code' AND batchno != '' AND idoadb.patient_id = patient.patient_id $cond ORDER BY patient.lastname ASC";
            }
            $this->session->set_userdata('SQL', $sqlT);
            $resT = $this->Comman_model->getCustomQueryData($sqlT);        
            $recordsTotal = count($resT);

            /******** Get recordsFiltered ********/
            $sqlF = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,$table WHERE patient.patient_id = $table.patient_id AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC";
            if($viewmode==6) {
                $sqlF = "SELECT idoadb.patient_id, lastname, firstname, servicedate,units,batchno,clientid,billnum,total_amount,idoa_id FROM idoadb,patient WHERE idoadb.patient_id IN (SELECT idoadb.patient_id FROM idoadb WHERE month = '$month' AND year = '$year' AND total_paid = 0 and idoadb.Agency = '$agency_code' AND batchno != '' $cond GROUP BY idoadb.patient_id HAVING COUNT(patient_id) > 1) AND month = '$month' AND year = '$year' AND total_paid = 0 AND idoadb.Agency = '$agency_code' AND batchno != '' AND idoadb.patient_id = patient.patient_id $cond ORDER BY patient.lastname ASC";
            }
            $resF = $this->Comman_model->getCustomQueryData($sqlF);
            $recordsFiltered = count($resF);
        }

        $totalRec   = 0;
        $datas      = [];
        $data       = [];

        if($viewmode==33) {
            $recordsTotal = 0;
            $recordsFiltered = 0;
        }

        /*if(!empty($_GET['qb_profile']) && ($viewmode==33 || $viewmode==9)) {
            $i = 0;
            foreach ($resT as $keyT => $rowT) {
                $allow = true;
                if(!empty($_GET['qb_profile'])) {
                    $qb_profile = $_GET['qb_profile'];
                } else {
                    $qb_profile = 2;
                }

                $findSQL    =  "SELECT * FROM customer WHERE CustomField1 = '".$rowT['patient_id']."'";
                $findResult =   get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                if($qb_profile==2) {
                    if(empty($findResult)) {
                        $allow = true;
                    } else {
                        $allow = false;
                    }
                }
                if($qb_profile==1) {
                    if(!empty($findResult)) {
                        $allow = true;
                    } else {
                        $allow = false;
                    }
                }
                $params = [];
                if($allow===true) {
                    $totalRec++;
                    $firstname = $rowT['firstname'].' '.$rowT['middlename'];
                    $servicedate = date('m/d/Y',strtotime($rowT['servicedate']));

                    $params[0] = $rowT['idoa_id'];
                    $params[1] = $rowT['clientid'].'/'.$rowT['patient_id'];
                    $params[2] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$rowT['lastname'].'</a>';
                    $params[3] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$firstname.'</a>';
                    $params[4] = $rowT['ccucontract'];
                    $params[5] = $rowT['controlno'];
                    $params[6]  = '021';
                    $params[7]  = '<button class="btn-info idoa-billed" data-toggle="tooltip" data-html="true" data-placement="left" id="'.$rowT['idoa_id'].'" data-patient="'.$rowT['patient_id'].'" data-startdate="'.$rowT['servicedate'].'">'.$servicedate.'</button>';
                    $params[8]  = $rowT['units'];
                    $params[9] = $rowT['total_amount'];
                }
                if(!empty($params)) {
                    $datas[$i] = $params;  
                    $i++;                        
                }
            }
            $recordsTotal = $totalRec;
            $recordsFiltered = $recordsTotal;
            
            if($i>10) {
                if(isset($_POST['start'])) {
                    $z = $_POST['start'];
                    $limitt = $z+10;
                    $y = 0;
                    for ($z; $z<$limitt; $z++) { 
                        $data[$y] = $datas[$z];
                        $y++;
                    }
                }
            } else {
                $data = $datas;
            }
        }*/

        if(!empty($_GET['qb_profile']) && ($viewmode==33 || $viewmode==9)) {
            if(!empty($_GET['qb_profile'])) {
                $qb_profile = $_GET['qb_profile'];
            } else {
                $qb_profile = 2;
            }
            $cond1 = "";
            if($qb_profile==1) {
                $sql = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC $sLimit";          
                $resT = $this->Comman_model->getCustomQueryData($sql);
                foreach ($resT as $keyT => $rowT) {
                    $params = [];

                    $firstname = $rowT['firstname'].' '.$rowT['middlename'];
                    $servicedate = date('m/d/Y',strtotime($rowT['servicedate']));

                    $params[0] = $rowT['idoa_id'];
                    $params[1] = $rowT['clientid'].'/'.$rowT['patient_id'];
                    $params[2] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$rowT['lastname'].'</a>';
                    $params[3] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$firstname.'</a>';
                    $params[4] = $rowT['ccucontract'];
                    $params[5] = $rowT['controlno'];
                    //$params[6]  = '021';
                    $params[6]  = '<button class="btn btn-sm btn-info idoa-billed" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" id="'.$rowT['idoa_id'].'" data-patient="'.$rowT['patient_id'].'" data-startdate="'.$rowT['servicedate'].'">'.$servicedate.'</button>';
                    $params[7]  = $rowT['units'];
                    $params[8] = $rowT['total_amount'];

                    if(!empty($params)) {
                        $data[$keyT] = $params;
                    }
                }

                $sqltotalRec = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond";
                $ressqltotalRec = $this->Comman_model->getCustomQueryData($sqltotalRec);
                $recordsTotal = count($ressqltotalRec);
                $recordsFiltered = $recordsTotal;            
            }

            if($qb_profile==2) {
                $sql = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id NOT IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC $sLimit";

                $resT = $this->Comman_model->getCustomQueryData($sql);
                foreach ($resT as $keyT => $rowT) {
                    $params = [];
                    $firstname = $rowT['firstname'].' '.$rowT['middlename'];
                    $servicedate = date('m/d/Y',strtotime($rowT['servicedate']));

                    $params[0] = $rowT['idoa_id'];
                    $params[1] = $rowT['clientid'].'/'.$rowT['patient_id'];
                    $params[2] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$rowT['lastname'].'</a>';
                    $params[3] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$firstname.'</a>';
                    $params[4] = $rowT['ccucontract'];
                    $params[5] = $rowT['controlno'];
                    //$params[6]  = '021';
                    $params[6]  = '<button class="btn btn-sm btn-info idoa-billed" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" id="'.$rowT['idoa_id'].'" data-patient="'.$rowT['patient_id'].'" data-startdate="'.$rowT['servicedate'].'">'.$servicedate.'</button>';
                    $params[7]  = $rowT['units'];
                    $params[8] = $rowT['total_amount'];

                    if(!empty($params)) {
                        $data[$keyT] = $params;
                    }
                }
                $sqltotalRec = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id NOT IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond";
                $ressqltotalRec = $this->Comman_model->getCustomQueryData($sqltotalRec);
                $recordsTotal = count($ressqltotalRec);
                $recordsFiltered = $recordsTotal;            
            }
        }
        
        $nex = 0;
        if($viewmode!=33 && $viewmode!=9 && $qbviewmode==0) {
            foreach ($res as $key => $row) {
                $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '".$agency_code."' AND mco = 0 AND DistrictID = '".$row['mco']."'";
                $districtData = $this->Comman_model->getCustomQueryData($strSQL, 'row');
                $disName = $districtData['DistrictName'].' ('.$districtData['DistrictNumber'].')';

                $params = [];
                if($viewmode==1) {
                    $firstname = $row['firstname'].' '.$row['middlename'];
                    $servicedate = date('m/d/Y',strtotime($row['servicedate']));

                    $params[0] = $row['idoa_id'];
                    $params[1] = $row['clientid'].'/'.$row['patient_id'];
                    $params[2] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$row['lastname'].'</a>';
                    $params[3] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$firstname.'</a>';
                    $params[4] = $row['ccucontract'];
                    $params[5] = $row['controlno'];
                    //$params[6]  = '021';
                    $params[6]  = '<input type="submit" name="formSubmit" class="btn btn-primary btn-sm" value="Save" />';
                    $params[7]  = '<button class="btn btn-sm btn-info idoa-billed" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" id="'.$row['idoa_id'].'" data-patient="'.$row['patient_id'].'" data-startdate="'.$row['servicedate'].'">'.$servicedate.'</button>';
                    $params[8]  = $row['units'];
                    $params[9] = $row['total_amount'];
                }

                if($viewmode==2 || $viewmode==3 || $viewmode==6 || $viewmode==9) {
                    $firstname = $row['firstname'].' '.$row['middlename'];
                    $servicedate = date('m/d/Y',strtotime($row['servicedate']));

                    $params[0] = $row['idoa_id'];
                    $params[1] = $row['clientid'].'/'.$row['patient_id'];
                    $params[2] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$row['lastname'].'</a>';
                    $params[3] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$firstname.'</a>';
                    //$params[4] = '<input type="submit" name="formSubmit" style="height:25px;background-color:#1448E4;color:#fff;"  value="Download"/>';
                    $params[4] = $row['batchno'];
                    $params[5]  = '<button class="btn btn-sm btn-info idoa-billed" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" id="'.$row['idoa_id'].'" data-patient="'.$row['patient_id'].'" data-startdate="'.$row['servicedate'].'">'.$servicedate.'</button>';
                    $params[6]  = $row['units'];
                    $params[7] = $row['total_amount'];
                }
                
                if(!empty($params)) {
                    $data[$key] = $params;
                }
            }
        }

        if($qbviewmode==1) {
            $checkPatientCount = []; $tamt = 0;
            $qb_profile = 2;
            $cond1 = "";            
            $sql = "SELECT total_amount as totalIA, patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id NOT IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname ASC $sLimit";

            $resT = $this->Comman_model->getCustomQueryData($sql);
            foreach ($resT as $keyT => $rowT) {

                array_push($checkPatientCount, $rowT['patient_id']);

                $amt = number_format(floatvalue($rowT['totalIA']), 2, '.', '');
                $tamt = $tamt + $amt;

                $params = [];
                $firstname = $rowT['firstname'].' '.$rowT['middlename'];
                $servicedate = date('m/d/Y',strtotime($rowT['servicedate']));

                $params[0] = $rowT['idoa_id'];
                $params[1] = $rowT['clientid'].'/'.$rowT['patient_id'];
                $params[2] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$rowT['lastname'].'</a>';
                $params[3] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$firstname.'</a>';
                $params[4] = $rowT['ccucontract'];
                $params[5] = $rowT['controlno'];
                //$params[6]  = '021';
                $params[6]  = '<input type="submit" name="formSubmit" class="btn btn-primary btn-sm" value="Save" />';
                $params[7]  = '<button class="btn btn-sm btn-info idoa-billed" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" id="'.$rowT['idoa_id'].'" data-patient="'.$rowT['patient_id'].'" data-startdate="'.$rowT['servicedate'].'">'.$servicedate.'</button>';
                $params[8]  = $rowT['units'];
                $params[9] = $rowT['total_amount'];

                if(!empty($params)) {
                    $data[$keyT] = $params;
                }
            }
            $sqltotalRec = "SELECT patient.patient_id, patient.clientid, patient.firstname, patient.middlename, patient.lastname, patient.ccucontract, patient.controlno, $table.patient_id, $table.idoa_id, $table.units, $table.total_amount, $table.servicedate FROM $table,patient WHERE patient.patient_id = $table.patient_id AND $table.patient_id NOT IN (SELECT customer.CustomField1 FROM customer) AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond";
            $ressqltotalRec = $this->Comman_model->getCustomQueryData($sqltotalRec);
            $recordsTotal = count($ressqltotalRec);
            $recordsFiltered = $recordsTotal;   

            $tcnt = count(array_unique($checkPatientCount));
            $amt = number_format(floatvalue($tamt), 2, '.', '');

            $lblTotal = "</br><p class='normal'> Total Clients: ".$tcnt."&nbsp; &nbsp; &nbsp; Total Invoice Amount: ".$amt;         
        }

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        $response['lblTotal'] = $lblTotal;
        $response['sql'] = $sql;
        print_r(json_encode($response));        
    }

    public function idoaStatMonthly() {
        $start = $_POST['startdate'];
        $ptid = $_POST['patient_id'];
        $idoa_id = $_POST['idoa_id'];
        $msql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,idoadb,idoadb_details WHERE start_date = '".$start."' AND patient.patient_id = '".$ptid."' AND idoadb_details.idoa_id = '".$idoa_id."' AND patient.patient_id = idoadb.patient_id AND idoadb_details.idoa_id = idoadb.idoa_id ORDER BY date";
        $data['utotal'] = 0;
        $data['mresult'] = $this->Comman_model->getCustomQueryData($msql);
        $this->load->view('idoa/idoastat.php', $data);
    }

    function saveFileAndBilled() {

        $params = $_POST['params'];        
        $viewmode = $_POST['viewmode'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $action = $_POST['action'];
        $controlno = $_POST['controlno'];
        $option = $_POST['option'];
        $billable_type = $_POST['billable_type'];
        $nbatchno = $_POST['nbatchno'];


        $batchno = date('Y-m-d H:i:s');
        //$sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,idoadb,idoadb_details WHERE start_date = '$start' AND patient.patient_id = idoadb.patient_id AND idoadb_details.idoa_id = idoadb.idoa_id ORDER BY idoadb_details.date, patient.lastname";
        $cond = "";
        if(!empty($controlno)) {
            $cond = "AND patient.controlno='".$controlno."'";
        }        

        if($option==1 || $option==4) {
            $paid = 0;
        }

        if($option==2) {
            $paid = 1;
        }

        if(!empty($params) && !empty($action) && $action=='selected' && !empty($month) && !empty($year) && !empty($agency_code)) {

            $params = rtrim($params, '|');
            $idoaIds = explode('|', $params);
            $idoaIds = implode(',', $idoaIds);

            //$sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,idoadb,idoadb_details WHERE idoadb.month = '$month' AND idoadb.year = '$year' AND idoadb.Agency = '$agency_code' AND idoadb.batchno IS NULL AND patient.patient_id = idoadb.patient_id AND idoadb_details.idoa_id = idoadb.idoa_id AND idoadb.idoa_id IN(".$idoaIds.") $cond ORDER BY idoadb_details.date, patient.lastname";

            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,idoadb,idoadb_details WHERE idoadb.month = '$month' AND idoadb.year = '$year' AND idoadb.Agency = '$agency_code' AND patient.patient_id = idoadb.patient_id AND idoadb_details.idoa_id = idoadb.idoa_id AND idoadb.idoa_id IN(".$idoaIds.") $cond ORDER BY idoadb_details.date, patient.lastname";

            $sumExec = get_custom_query_data($sql);
            $utotal = 0;
            foreach ($sumExec as $key => $sumResult) {
                $rec_id = $sumResult['idoa_id'];
                $utotal =  $utotal + $sumResult['bill'];     
            }     
            $utotal = sprintf("%08s", $utotal);
            $filename = "Batch". $batchno. ".txt";
            $filename2 = "Batch". $batchno . ".txt";
            $filename2 = "/var/www/html/Dropbox/EDI/".$filename2;
            $filename = $filename2;
            $fh = fopen($filename, 'w') or die("can't open file");
            $flag = false;
            $row2 = 0;
            $counter = 0;
            $arry = array(' ',' ',' ',' ');
            $result = get_custom_query_data($sql);

            $firstdate = $year.'-'.$month.'-01';
            $lastdate = date('t', strtotime($firstdate));
            $yy = date('y', strtotime($firstdate));

            foreach ($result as $key => $row) {
                $counter++;
                $PayorID = $year.$month.sprintf("%02s",$counter);     
                $idoa_id = $row['idoa_id'];
                $uploadtime = date("Y-m-d H:i:s");         
                $status = 'Billed';
                $idoadb_details_id = $row['idoadb_details_id'];
                $portal_id = $row['patient_id'];       
                $query = "UPDATE idoadb SET uploadtime = '$uploadtime', invoicenum = '$PayorID' WHERE idoa_id = '$idoa_id'";
                set_custom_query_data($query);
                $clientid = $row['clientid'];
                $provider = $row['provider'];
                $ccucontract = $row['ccucontract'];
                $controlno = $row['controlno'];
                $servicecode = $row['servicecode'];
                $lastname = trim($row['lastname']);
                $firstname = trim($row['firstname']);
                $middlename = '';
                $servicedate = date('Y',strtotime($start)).date('m',strtotime($start)).date('d',strtotime($start))    ;
                if ($ccucontract == null || $ccucontract == '') { $ccucontract = ' '; }
                if ($clientid == null || $clientid == '') { $clientid = ' '; }
                if ($provider == null || $provider =- '') { $provider = ' '; }
                if ($servicecode == null || $servicecode == '') { $servicecode = ' '; }
                if ($lastname == null || $lastname == '') { $lastname = ' '; }
                if ($firstname == null || $firstname == '') { $firstname = ' '; }
                $rec_id = $row['idoa_id'];
                $go =  0;

                if ($go == 0)  {
                    $var = '';
                    $max = 0;
                    $inc++;
                    $z = sprintf("%08s", $inc);
                    //$no = date('m',strtotime($start));
                    //$no = date('m',strtotime($month));
                    //$letter = chr(64 + $no);
                    $letter = chr(64 + $month);
                    $CCYYMM = date('Y',strtotime($row['date'])).date('m',strtotime($row['date']));
                    $mmddyylf = date('m',strtotime($row['servicedate'])).date('d',strtotime($row['servicedate'])).date('y',strtotime($row['servicedate'])).substr($lastname,0,1).substr($firstname,0,1);
                    $mmddyylf = date('m',strtotime($row['date'])).date('d',strtotime($row['date'])).date('y',strtotime($row['date'])).substr($lastname,0,1).substr($firstname,0,1);
                    $pid = sprintf("%05d",$portal_id);
                    $mmddyylf = date('m',strtotime($row['date'])).date('d',strtotime($row['date'])).date('y',strtotime($row['date'])).$pid;
                    //$mmddyylf = $letter.date('d',strtotime($start)).date('y',strtotime($start)).$pid;

                    $mmddyylf = $letter.$lastdate.$yy.$pid;


                    $units = sprintf("%05s", $row['bill']);
                    $sday = date('d',strtotime($row['date']));
                    $sday = sprintf("%02s", $sday);
                    $today = date('Y-m-d');
                    $today = date('Y-m-d',strtotime($row['servicedate']));
                    $daycnt = 1;
                    $date1 = strtotime(date("Y-m-d", strtotime($today)) . " - ".$daycnt."days");
                    $datetrans = date("Y-m-d",$date1);
                    $VRFP = date('Y',strtotime($datetrans)).date('m',strtotime($datetrans)).date('d',strtotime($datetrans));
                    /*01 File ID*/ writelchr($var="PR",$max=2,$fh);
                    /*02  Batch Number*/ writelchr($var="000000",$max=6,$fh);
                    /*03 Record Number */ writelchr($var=$z,$max=8,$fh);  // increment file number 
                    /*04 Provide Name*/ writelchr($var="MEDICAL GEAR LLC",$max=30,$fh);
                    /*05 Provider Contract #*/ writelchr($var=$controlno,$max=10,$fh);  //INH1002020  CLient Contract no.
                    /*06 Program Type*/ writelchr($var="11",$max=2,$fh);  //INH1002020
                    /*07 Service Code*/ writerchr($var='021',$max=3,$fh);//021 service code no 021
                    /*08 CCYYMM*/ writelchr($var=$CCYYMM,$max=6,$fh); //201304 same as service date but ccyymm
                    /*09 Provider Invoice #*/ writelchr($var=$mmddyylf,$max=10,$fh); //042013OM mmddyylf lastname/firstname
                    /*10 Client ID # */ writelchr($var=$clientid,$max=9,$fh);//001057374  get it into portal clientid
                    /*11 Client Last Name */ writelchr($var=$lastname,$max=20,$fh);//MIMMS
                    /*12 Client First Name */ writelchr($var=$firstname,$max=15,$fh);//OPAL 
                    /*13 Client Middle Name */ writelchr($var=$middlename,$max=1,$fh);//A
                    /*14 CCU Contract */ writelchr($var=$ccucontract,$max=10,$fh);//U129602956  get it into portal ccu contract
                    /*15 Days of Service */ writelchr($var=$sday,$max=2,$fh);//29  from date - to c:133-134
                    /*16 Billing Number */ writelchr($var="00",$max=2,$fh);//00
                    /*17 Monthly Units(FY10) */ writelchr($var=$units,$max=5,$fh);//00100  pull the hours to timesheet convert itto units
                    /*18 Total Service Units */ writelchr($var=$utotal,$max=8,$fh);//00000000 
                    /*19 Date of VRFP */ writelchr($var=$VRFP,$max=8,$fh); //20140311
                    /*20 Sequence Number */ writelchr($var=" ",$max=10,$fh); //9946596179
                    /*21 Gross amount paid */ writelchr($var="0000000",$max=7,$fh); //0001714
                    /*22 Reject Code */ writelchr($var=" ",$max=4,$fh); //P369
                    /*23 Fees */ writelchr($var="0000000",$max=7,$fh); //0000000
                    /*24 Invoice Date IDOA */ writelchr($var="00000000",$max=8,$fh);
                    /*25 Invoice Number (IDOA) */ writelchr($var="        ",$max=8,$fh);  
                    /*filler */ writelchr($var=" ",$max=19,$fh);
                    fwrite($fh,Chr(13).Chr(10));

                    $query0 = "UPDATE idoadb SET batchno='$batchno' WHERE idoa_id = '$rec_id' AND batchno IS NULL";
                    set_custom_query_data($query0);
                    $query1 = "UPDATE idoadb SET status = '$status' WHERE idoa_id = '$rec_id' ";
                    set_custom_query_data($query1);
                    $query2 = "UPDATE idoadb_details SET status = '$status' WHERE idoadb_details_id = '$idoadb_details_id'";
                    set_custom_query_data($query2);

                    if ($paid == 1) {
                        $query1 = "UPDATE idoadb_details SET paid=1 WHERE idoa_id = '$rec_id'";
                        set_custom_query_data($query1);

                        $sumSQL="SELECT SUM(units) AS totalunits FROM idoadb_details WHERE idoa_id = '$rec_id' AND paid = 1";
                        $sumResult = get_custom_query_data($sumSQL, 'row');
                        $sum_left = $sumResult['totalunits'];
                        $query2 = "UPDATE idoadb SET total_paid='$sum_left' WHERE idoa_id = '$rec_id'";
                        set_custom_query_data($query2);
                        $status = 'Paid'; 
                        $query3 = "UPDATE  idoadb_details SET status = '$status' WHERE idoadb_details_id = '$idoadb_details_id'";
                        set_custom_query_data($query3);
                    }
                }
            }
            fclose($fh);
            print_r($filename);
        } else if(!empty($action) && $action=='all' && !empty($month) && !empty($year) && !empty($agency_code)) {
            if($viewmode==1) {
                $cond .= " AND idoadb.batchno IS NULL";   
                if($billable_type!='' && $billable_type==2) {
                    $cond .= " AND (patient.controlno = '' OR patient.clientid = '' OR patient.ccucontract = '')";
                }

                if($billable_type!='' && $billable_type==1) {
                    $cond .= " AND (patient.controlno != '' AND patient.clientid != '' AND patient.ccucontract != '')";
                }
            }

            if($viewmode==2) {
                if(!empty($nbatchno)) {
                    $cond .= " AND idoadb.batchno = '".$nbatchno."' AND total_paid = 0";   
                } else {
                    $cond .= " AND idoadb.batchno!='' AND total_paid = 0";       
                }                
            }

            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,idoadb,idoadb_details WHERE idoadb.month = '$month' AND idoadb.year = '$year' AND idoadb.Agency = '$agency_code' AND patient.patient_id = idoadb.patient_id AND idoadb_details.idoa_id = idoadb.idoa_id $cond ORDER BY idoadb_details.date, patient.lastname";
            $sumExec = get_custom_query_data($sql);
            $utotal = 0;
            foreach ($sumExec as $key => $sumResult) {
                $rec_id = $sumResult['idoa_id'];
                $utotal =  $utotal + $sumResult['bill'];     
            }     
            $utotal = sprintf("%08s", $utotal);
            $filename = "Batch". $batchno. ".txt";
            $filename2 = "Batch". $batchno . ".txt";
            $filename2 = "/var/www/html/Dropbox/EDI/".$filename2;
            $filename = $filename2;
            $fh = fopen($filename, 'w') or die("can't open file");
            $flag = false;
            $row2 = 0;
            $counter = 0;
            $arry = array(' ',' ',' ',' ');
            $result = get_custom_query_data($sql);

            $firstdate = $year.'-'.$month.'-01';
            $lastdate = date('t', strtotime($firstdate));
            $yy = date('y', strtotime($firstdate));

            foreach ($result as $key => $row) {
                $start = $row['servicedate'];
                $counter++;
                $PayorID = $year.$month.sprintf("%02s",$counter);     
                $idoa_id = $row['idoa_id'];
                $uploadtime = date("Y-m-d H:i:s");         
                $status = 'Billed';
                $idoadb_details_id = $row['idoadb_details_id'];
                $portal_id = $row['patient_id'];       
                $query = "UPDATE idoadb SET uploadtime = '$uploadtime', invoicenum = '$PayorID' WHERE idoa_id = '$idoa_id'";
                set_custom_query_data($query);
                $clientid = $row['clientid'];
                $provider = $row['provider'];
                $ccucontract = $row['ccucontract'];
                $controlno = $row['controlno'];
                $servicecode = $row['servicecode'];
                $lastname = trim($row['lastname']);
                $firstname = trim($row['firstname']);
                $middlename = '';
                $servicedate = date('Y',strtotime($start)).date('m',strtotime($start)).date('d',strtotime($start))    ;
                if ($ccucontract == null || $ccucontract == '') { $ccucontract = ' '; }
                if ($clientid == null || $clientid == '') { $clientid = ' '; }
                if ($provider == null || $provider =- '') { $provider = ' '; }
                if ($servicecode == null || $servicecode == '') { $servicecode = ' '; }
                if ($lastname == null || $lastname == '') { $lastname = ' '; }
                if ($firstname == null || $firstname == '') { $firstname = ' '; }
                $rec_id = $row['idoa_id'];
                $go =  0;

                if ($go == 0)  {
                    $var = '';
                    $max = 0;
                    $inc++;
                    $z = sprintf("%08s", $inc);
                    //$no = date('m',strtotime($start));
                    //$no = date('m',strtotime($month));
                    //$letter = chr(64 + $no);
                    $letter = chr(64 + $month);
                    $CCYYMM = date('Y',strtotime($row['date'])).date('m',strtotime($row['date']));
                    $mmddyylf = date('m',strtotime($row['servicedate'])).date('d',strtotime($row['servicedate'])).date('y',strtotime($row['servicedate'])).substr($lastname,0,1).substr($firstname,0,1);
                    $mmddyylf = date('m',strtotime($row['date'])).date('d',strtotime($row['date'])).date('y',strtotime($row['date'])).substr($lastname,0,1).substr($firstname,0,1);
                    $pid = sprintf("%05d",$portal_id);
                    $mmddyylf = date('m',strtotime($row['date'])).date('d',strtotime($row['date'])).date('y',strtotime($row['date'])).$pid;
                    //$mmddyylf = $letter.date('d',strtotime($start)).date('y',strtotime($start)).$pid;

                    $mmddyylf = $letter.$lastdate.$yy.$pid;

                    $units = sprintf("%05s", $row['bill']);
                    $sday = date('d',strtotime($row['date']));
                    $sday = sprintf("%02s", $sday);
                    $today = date('Y-m-d');
                    $today = date('Y-m-d',strtotime($row['servicedate']));
                    $daycnt = 1;
                    $date1 = strtotime(date("Y-m-d", strtotime($today)) . " - ".$daycnt."days");
                    $datetrans = date("Y-m-d",$date1);
                    $VRFP = date('Y',strtotime($datetrans)).date('m',strtotime($datetrans)).date('d',strtotime($datetrans));
                    /*01 File ID*/ writelchr($var="PR",$max=2,$fh);
                    /*02  Batch Number*/ writelchr($var="000000",$max=6,$fh);
                    /*03 Record Number */ writelchr($var=$z,$max=8,$fh);  // increment file number 
                    /*04 Provide Name*/ writelchr($var="MEDICAL GEAR LLC",$max=30,$fh);
                    /*05 Provider Contract #*/ writelchr($var=$controlno,$max=10,$fh);  //INH1002020  CLient Contract no.
                    /*06 Program Type*/ writelchr($var="11",$max=2,$fh);  //INH1002020
                    /*07 Service Code*/ writerchr($var='021',$max=3,$fh);//021 service code no 021
                    /*08 CCYYMM*/ writelchr($var=$CCYYMM,$max=6,$fh); //201304 same as service date but ccyymm
                    /*09 Provider Invoice #*/ writelchr($var=$mmddyylf,$max=10,$fh); //042013OM mmddyylf lastname/firstname
                    /*10 Client ID # */ writelchr($var=$clientid,$max=9,$fh);//001057374  get it into portal clientid
                    /*11 Client Last Name */ writelchr($var=$lastname,$max=20,$fh);//MIMMS
                    /*12 Client First Name */ writelchr($var=$firstname,$max=15,$fh);//OPAL 
                    /*13 Client Middle Name */ writelchr($var=$middlename,$max=1,$fh);//A
                    /*14 CCU Contract */ writelchr($var=$ccucontract,$max=10,$fh);//U129602956  get it into portal ccu contract
                    /*15 Days of Service */ writelchr($var=$sday,$max=2,$fh);//29  from date - to c:133-134
                    /*16 Billing Number */ writelchr($var="00",$max=2,$fh);//00
                    /*17 Monthly Units(FY10) */ writelchr($var=$units,$max=5,$fh);//00100  pull the hours to timesheet convert itto units
                    /*18 Total Service Units */ writelchr($var=$utotal,$max=8,$fh);//00000000 
                    /*19 Date of VRFP */ writelchr($var=$VRFP,$max=8,$fh); //20140311
                    /*20 Sequence Number */ writelchr($var=" ",$max=10,$fh); //9946596179
                    /*21 Gross amount paid */ writelchr($var="0000000",$max=7,$fh); //0001714
                    /*22 Reject Code */ writelchr($var=" ",$max=4,$fh); //P369
                    /*23 Fees */ writelchr($var="0000000",$max=7,$fh); //0000000
                    /*24 Invoice Date IDOA */ writelchr($var="00000000",$max=8,$fh);
                    /*25 Invoice Number (IDOA) */ writelchr($var="        ",$max=8,$fh);  
                    /*filler */ writelchr($var=" ",$max=19,$fh);
                    fwrite($fh,Chr(13).Chr(10));

                    $query0 = "UPDATE idoadb SET batchno='$batchno' WHERE idoa_id = '$rec_id' AND batchno IS NULL";
                    set_custom_query_data($query0);
                    $query1 = "UPDATE idoadb SET status = '$status' WHERE idoa_id = '$rec_id' ";
                    set_custom_query_data($query1);
                    $query2 = "UPDATE idoadb_details SET status = '$status' WHERE idoadb_details_id = '$idoadb_details_id'";
                    set_custom_query_data($query2);

                    if ($paid == 1) {
                        $query1 = "UPDATE idoadb_details SET paid=1 WHERE idoa_id = '$rec_id'";
                        set_custom_query_data($query1);

                        $sumSQL="SELECT SUM(units) AS totalunits FROM idoadb_details WHERE idoa_id = '$rec_id' AND paid = 1";
                        $sumResult = get_custom_query_data($sumSQL, 'row');
                        $sum_left = $sumResult['totalunits'];
                        $query2 = "UPDATE idoadb SET total_paid='$sum_left' WHERE idoa_id = '$rec_id'";
                        set_custom_query_data($query2);
                        $status = 'Paid'; 
                        $query3 = "UPDATE  idoadb_details SET status = '$status' WHERE idoadb_details_id = '$idoadb_details_id'";
                        set_custom_query_data($query3);
                    }
                }
            }
            fclose($fh);
            print_r($filename);
        } else {
            print_r(0);
        }
    }

    function updateQbStatusAll() {
        if (!empty($_POST['qb_value']) && !empty($_POST['month']) && !empty($_POST['year'])) {
            $qb2    = $_POST['qb_value'];
            $month  = $_POST['month'];
            $year   = $_POST['year'];
            if ($qb2=='no')  { $qb2 = ''; }
            if ($qb2=='yes')  { $qb2 = 'yes'; }
            $query7 = "UPDATE eclaims SET `qb` = '$qb2' WHERE month = '$month' AND year = '$year' AND paid = 0";
            set_custom_query_data($query7);
            print_r(1);
        } else {
            print_r(0);
        }
    }

    function updateQbStatus() {
        if (!empty($_POST['cms1500id'])) {
            $qb = $_POST['qb'];
            $recno = $_POST['cms1500id'];
            $query7 = "UPDATE eclaims SET `qb` = '$qb' WHERE cms1500_id = '$recno'";
            set_custom_query_data($query7);
            print_r(1);
        } else {
            print_r(0);
        }
    }

    function deleteRecords() {
        $params = $_POST['params'];        
        $viewmode = $_POST['viewmode'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $action = $_POST['action'];
        $controlno = $_POST['controlno'];
        $billable_type = $_POST['billable_type'];
        $nbatchno = $_POST['nbatchno'];

        if(!empty($params) && !empty($viewmode) && !empty($action) && $action=='selected') {
            $params = rtrim($params, '|');
            $idoaIds = explode('|', $params);

            $table = 'idoadb';
            $table2 = 'idoadb_details';

            if ($viewmode==3)  {
                $table = 'idoadbfinal';
                $table2 = 'idoadb_finaldetails';
            }

            if(!empty($idoaIds)) {
                $updateCheck = false;
                foreach ($idoaIds as $key => $idoaId) {
                    if ($viewmode == 1 || $viewmode == 2 || $viewmode == 3 )  {
                        $query = "DELETE FROM `$table` WHERE idoa_id = '$idoaId'";
                        set_custom_query_data($query);
                        $query = "DELETE FROM `$table2` WHERE idoa_id = '$idoaId'";
                        set_custom_query_data($query);
                    }
                    $updateCheck = true;
                }
                if($updateCheck) {
                    $this->session->set_flashdata('message','Selected records has been deleted successfully.');
                    print_r(1);
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record to update.');
                print_r(0);
            }
        } elseif(!empty($viewmode) && !empty($action) && $action=='all' && !empty($month) && !empty($year) && !empty($agency_code)) {

            $table = 'idoadb';
            $table2 = 'idoadb_details';

            if ($viewmode==3)  {
                $table = 'idoadbfinal';
                $table2 = 'idoadb_finaldetails';
            }

            $cond = "";
            if($viewmode==1) {
                $cond = " AND $table.batchno IS NULL";
                if($billable_type!='' && $billable_type==2) {
                    $cond .= " AND (patient.controlno = '' OR patient.clientid = '' OR patient.ccucontract = '') ";
                }

                if($billable_type!='' && $billable_type==1) {
                    $cond .= " AND (patient.controlno != '' AND patient.clientid != '' AND patient.ccucontract != '') ";
                }
            }
            if($viewmode==2) {
                $cond = " AND $table.batchno!='' AND total_paid = 0";
            }

            if($viewmode==3) {
                $cond = " AND $table.batchno != '' AND $table.total_paid = 0 AND $table.status != 'Rejected'";
            }

            if(!empty($controlno)) {
                $cond .= " AND patient.controlno='".$controlno."'";
            }            

            if(!empty($nbatchno)) {
                $cond .= " AND $table.batchno = '".$nbatchno."'";    
            }

            $updateCheck = false;
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM patient,$table WHERE patient.patient_id = $table.patient_id AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' $cond ORDER BY patient.lastname";
            $res = $this->Comman_model->getCustomQueryData($sql);
            $idoa_ids = array_column($res, 'idoa_id');
            if(!empty($idoa_ids)) {
                foreach ($idoa_ids as $key => $idoa_id) {
                    if ($viewmode==1 || $viewmode==2 || $viewmode==3) {
                        $query = "DELETE FROM `$table` WHERE idoa_id = '$idoa_id'";
                        set_custom_query_data($query);
                        $query = "DELETE FROM `$table2` WHERE idoa_id = '$idoa_id'";
                        set_custom_query_data($query);
                    }
                    $updateCheck = true;
                }
            }
            if($updateCheck) {
                $this->session->set_flashdata('message','All records has been deleted successfully.');
                print_r(1);
            }            
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function generateQuickBooks() {


        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $xtracopy = $_POST['xtracopy'];
        $nbatchno = $_POST['nbatchno'];

        if(!empty($month) && !empty($year) && !empty($agency_code)) {
            
            $query1 = "DELETE FROM invoice";
            get_custom_query_data_other_db($query1, 'query', $agency_code);

            $query2 = "DELETE FROM invoicelinedetail";
            get_custom_query_data_other_db($query2, 'query', $agency_code);

            $val = '0';
            $query3 = "UPDATE QBInvoice.errorqb SET errorqb='$val' WHERE Agency = '$agency_code' ";
            get_custom_query_data_other_db($query3, 'query', $agency_code);

            if($xtracopy=='yes') {
            }

            $xbatchno = date("YmdHi");
            $zbatchno = date("m/d/Y g:i a");
            $_SESSION['startprocess'] = time();

            $num = 0;
            if ($agency_code == 4 )  {
                $num = 6000;
            }
            if ($agency_code == 5 )  {
                $num = 9000;
            }

            $firstdate = $year.'-'.$month.'-01';
            $lastdate1 = date('t', strtotime($firstdate));
            $yy = date('y', strtotime($firstdate));

            //$strSQL = "SELECT * FROM idoadbfinal WHERE idoadbfinal.servicedate = '$startdate' AND idoadbfinal.Agency = '$agency_code' AND batchno != '' AND total_paid = 0 AND idoadbfinal.status!='Rejected'";

            $strSQL = "SELECT * FROM idoadbfinal WHERE idoadbfinal.month = '$month' AND idoadbfinal.year = '$year' AND idoadbfinal.Agency = '$agency_code' AND batchno != '' AND total_paid = 0 AND idoadbfinal.status!='Rejected'";

            if(!empty($nbatchno)) {
                $strSQL .= " AND batchno = '".$nbatchno."'";
            }
            $strSQL .= " GROUP BY patient_id";

            //echo $strSQL;die;

            $objExec = get_custom_query_data($strSQL);
            foreach ($objExec as $key => $objResult) {
                $start = $objResult['servicedate'];
                $startdate = $objResult['servicedate'];

                $chkSQL = "SELECT * FROM table_2weekly WHERE start_date = '".$startdate."'";
                $chkResult = get_custom_query_data($chkSQL, 'row');
                if (!empty($chkResult)) {
                    $start = $chkResult['start_date'];
                    $end= $chkResult['end_date'];
                }

                $rec_id2 = $objResult['idoa_id'];
                $case_number = $objResult['case_number'];
                $ptid = $objResult['patient_id'];
                $portal_id = $ptid;
                $year1 = date("Y",strtotime($objResult['servicedate']));
                $month1 = date("m",strtotime($objResult['servicedate']));
                $idoa_id = $objResult['idoa_id'];
                $ptSQL = "SELECT * FROM patient WHERE patient_id = '$ptid' AND Agency = '$agency_code'" ;
                $ptResult = get_custom_query_data($ptSQL, 'row');
                $ID2 = $ptResult['DistrictID_Ref'];
                $clientid = $ptResult['clientid'];
                $firstname = trim($ptResult['firstname']);
                $lastname = trim($ptResult['lastname']);
                $mmddyylf = date('m',strtotime($objResult['date'])).date('d',strtotime($objResult['date'])).date('y',strtotime($objResult['date'])).substr($lastname,0,1).substr($firstname,0,1);
                $num++;
                $z = sprintf("%04s", $num);
                $no = date('m',strtotime($start));
                //$letter = chr(64 + $no);

                $letter = chr(64 + $month);
                $mmddyylf = date("m").''.date("Y").''.$z;
                $mmddyylf = date('m',strtotime($startdate)).date('d',strtotime($startdate)).substr($lastname,0,1).substr($firstname,0,1).$z;
                $pid = sprintf("%05d",$portal_id);
                //$mmddyylf = date('m',strtotime($startdate)).date('d',strtotime($startdate)).date('y',strtotime($startdate)).$pid;
                //$mmddyylf = $letter.date('d',strtotime($start)).date('y',strtotime($start)).$pid;

                $mmddyylf = $letter.$lastdate1.$yy.$pid;

                $sql = "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND month = '$month' AND year = '$year' AND mco = '0' ORDER BY district_id DESC LIMIT 1";
                $row = get_custom_query_data($sql, 'row');
                if(!empty($row['DistrictID_Ref'])) {
                    $ID2 = $row['DistrictID_Ref'];
                } else {
                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));
                    //$sql =  "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND MONTH(start_date)<'$month' AND YEAR(start_date)<='$year' AND start_date!='0000-00-00' AND mco = '1' ORDER BY district_id DESC LIMIT 1";
                    //$sql =  "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND start_date!='0000-00-00' AND start_date<'$cdate' AND mco = '0' ORDER BY district_id DESC LIMIT 1";
                    $sql =  "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND start_date!='0000-00-00' AND start_date<='$cdate' AND mco = '0' ORDER BY district_id DESC LIMIT 1";
                    $row = get_custom_query_data($sql, 'row');
                    if (!empty($row['DistrictID_Ref'])) {
                        $ID2 = $row['DistrictID_Ref'];
                    }
                }

                $distSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$ID2' AND Agency = '$agency_code'" ;
                $distResult = get_custom_query_data($distSQL, 'row');
                $Diagnosis = $distResult['Diagnosis'];
                $ARAccountRef_ListID =  '8000000E-1273000993';
                $ARAccountRef_Fullname = 'A/R - Medicaid';
                $TemplateRef_ListID = '80000010-1359151098';
                $TemplateRef_FullName = 'ORS INVOICE';
                $ItemRef_ListID =  '';  //'80000001-1318262199'; //80000001-1318262199
                $ItemRef_ListID = '80000001-1283628173'; //    Homemaker 17.14

                $rquery = "SELECT * FROM rate_table WHERE Agency = '$agency_code'";
                $rrow = get_custom_query_data($rquery, 'row');
                if (!empty($rrow))  {
                    if ($objResult['rate'] == $rrow['rate']) {
                        $xrate =  $objResult['rate'];
                        $ARAccountRef_ListID = $rrow['ARAccountRef_ListID'];
                        $ItemRef_ListID = $rrow['ItemRef_ListID'];
                        $TemplateRef_ListID = $rrow['TemplateRef_ListID'];
                    }
                    if ($Diagnosis != '' || $Diagnosis != null) {
                        if ($objResult['unit'] == $rrow['unit']) {
                            $xrate =  $objResult['unit'];
                            $ARAccountRef_ListID = $rrow['ARAccountRef_ListID'];
                            $ItemRef_ListID = $rrow['ItemRef_ListID'];
                            $TemplateRef_ListID = $rrow['TemplateRef_ListID'];                          
                        }
                    }
                }  

                $Status = 'add';
                $Quantity = $objResult['total_amount'];
                if ($Diagnosis != '' || $Diagnosis != null) {
                    $Quantity = $objResult['total_unit'];
                }
                $chkSQL =  "SELECT * FROM invoice WHERE TxnID = '$ref_num'";
                $chkResult = get_custom_query_data_other_db($chkSQL, 'row', $agency_code);

                $findSQL =  "SELECT * FROM customer WHERE CustomField1 = '$portal_id'";
                $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                $ListID = $findResult['ListID']; 
                $lastdate = $year1.'-'.$month1.'-01';
                $year1 = date('Y',strtotime($end));
                $month1 = date('m',strtotime($end));                         
                $day = date('d',strtotime($end));

                $tmpdate = date('Y-m-d', strtotime($end."+1 day"));
                $TxnDate = $tmpdate;
                $TemplateRef_ListID = '';
                if ($agency_code == 2  || $agency_code == 4) { 
                    $TemplateRef_ListID = '8000000B-1283985346';
                }                       

                $rquery = "SELECT * FROM  rate_table WHERE Agency = '$agency_code'";
                $rrow = get_custom_query_data($rquery, 'row');
                if (!empty($rrow)) {
                    if ($objResult['rate'] == $rrow['rate']) {
                        $xrate =  $objResult['rate'];                           
                        $ARAccountRef_ListID = $rrow['ARAccountRef_ListID'];
                        $ItemRef_ListID = $rrow['ItemRef_ListID'];
                        $TemplateRef_ListID = $rrow['TemplateRef_ListID'];
                    }

                    if ($Diagnosis != '' || $Diagnosis != null) {
                        if ($objResult['unit'] == $rrow['unit'])   {
                            $xrate =  $objResult['unit'];    
                            $ARAccountRef_ListID = $rrow['ARAccountRef_ListID'];
                            $ItemRef_ListID = $rrow['ItemRef_ListID'];
                            $TemplateRef_ListID = $rrow['TemplateRef_ListID'];                          
                        }
                    }
                }  

                $Tamount = $objResult['total_amount'];

                if (!empty($findResult)) {
                    if ($start >= '2019-12-30') {
                        $ItemRef_ListID = '80000011-1579105856';
                    }
                    if ($agency_code == 2  || $agency_code == 4) { 
                        if ($start >= '2021-04-05') { 
                            $ItemRef_ListID = '80000013-1617140439';
                        }
                        if ($start >= '2022-01-10') {
                            $chkSQL = "SELECT * FROM idoa_rate_settings WHERE start_date = '$start' AND agency = '$agency_code'";
                            $objRow = get_custom_query_data($chkSQL, 'row');
                            if(!empty($objRow)) {
                                $ItemRef_ListID = $objRow['ItemRef_ListID'];    
                            } else {
                                $chkSQL = "SELECT * FROM idoa_rate_settings WHERE start_date <= '$start' AND agency = '$agency_code' ORDER BY id DESC";
                                $objRow = get_custom_query_data($chkSQL, 'row');
                                if(!empty($objRow)) {
                                    $ItemRef_ListID = $objRow['ItemRef_ListID'];    
                                }
                            }
                        }
                    }                    

                    /******** For Custom Inserting ********/
                    $ClassRef_FullName = $ClassRef_ListID = '';
                    $agency_location_code = $ptResult['agency_location'];
                    if($agency_code==2 || $agency_code==4) {                        
                        $ptSQL = "SELECT * FROM qb_class_sc WHERE agency_location_code = '$agency_location_code'" ;
                        $qbData = get_custom_query_data($ptSQL, 'row');

                        if(!empty($qbData)) {
                            $ClassRef_FullName = $qbData['ClassRef_FullName'];
                            $ClassRef_ListID = $qbData['ClassRef_ListID'];
                        }
                    }

                    if($agency_code==1) {
                        $ptSQL = "SELECT * FROM qb_class_hm WHERE agency_location_code = '$agency_location_code'" ;
                        $qbData = get_custom_query_data($ptSQL, 'row');

                        if(!empty($qbData)) {
                            $ClassRef_FullName = $qbData['ClassRef_FullName'];
                            $ClassRef_ListID = $qbData['ClassRef_ListID'];
                        }
                    }

                    if($agency_code==3) {
                        $ptSQL = "SELECT * FROM qb_class_cg WHERE agency_location_code = '$agency_location_code'" ;
                        $qbData = get_custom_query_data($ptSQL, 'row');

                        if(!empty($qbData)) {
                            $ClassRef_FullName = $qbData['ClassRef_FullName'];
                            $ClassRef_ListID = $qbData['ClassRef_ListID'];
                        }
                    }
                    /******** For Custom Inserting ********/

                    $insert = "INSERT INTO invoice (
                    TxnID,
                    CustomerRef_ListID,
                    ARAccountRef_ListID,
                    RefNumber,
                    TxnDate,
                    TemplateRef_ListID,
                    Status,
                    ClassRef_ListID,
                    ClassRef_FullName
                    ) VALUES (
                    '$mmddyylf',
                    '$ListID',
                    '$ARAccountRef_ListID',
                    '$mmddyylf',
                    '$TxnDate',
                    '$TemplateRef_ListID',
                    '$Status',
                    '$ClassRef_ListID',
                    '$ClassRef_FullName'
                    ) ";

                    get_custom_query_data_other_db($insert, 'query', $agency_code);
                    
                    if ($xtracopy == 'yes')  {
                        $insert = "INSERT INTO  QBInvoice.invoice (
                        TxnID,
                        CustomerRef_ListID,
                        ARAccountRef_ListID,
                        RefNumber,
                        TxnDate,
                        TemplateRef_ListID,
                        Status,
                        CustomField11,
                        CustomField12,
                        CustomField14,
                        CustomField15
                        ) VALUES (
                        '$mmddyylf',
                        '$ListID',
                        '$ARAccountRef_ListID',
                        '$mmddyylf',
                        '$TxnDate',
                        '$TemplateRef_ListID',
                        '$Status',
                        '$xbatchno',
                        '$Tamount',
                        '$startdate',
                        '$agency_code'                              
                        ) ";
                        get_custom_query_data_other_db($insert, 'query', $agency_code); 
                    }

                    $strSQLL = "SELECT * FROM idoadbfinal WHERE idoadbfinal.month = '$month' AND idoadbfinal.year = '$year' AND idoadbfinal.Agency = '$agency_code' AND batchno != '' AND total_paid = 0 AND idoadbfinal.status!='Rejected' AND patient_id = '$ptid'";
                    $objExecc = get_custom_query_data($strSQLL);

                    foreach ($objExecc as $keyy => $roww) {
                        $idoa_id = $roww['idoa_id'];
                        $startdate = $roww['servicedate'];
                        // code...                    
                        $detSQL="SELECT * FROM idoadb_finaldetails WHERE idoadb_finaldetails.idoa_id = '$idoa_id' ";
                        $detExec = get_custom_query_data($detSQL);
                        $qty = 0;
                        foreach ($detExec as $key => $detResult) {
                            $ServiceDate = $detResult['date'];    
                            $Quantity = $detResult['units']; 
                            $qty = $qty + $Quantity;
                            
                            $insert = "INSERT INTO invoicelinedetail (
                            IDKEY,
                            ItemRef_ListID,
                            Quantity,
                            ServiceDate
                            ) VALUES (
                            '$mmddyylf',
                            '$ItemRef_ListID',
                            '$Quantity',
                            '$ServiceDate'
                            )";

                            

                            get_custom_query_data_other_db($insert, 'query', $agency_code); 
                            
                            if ($xtracopy == 'yes') {
                                $insert = "INSERT INTO  QBInvoice.invoicelinedetail (
                                IDKEY,
                                ItemRef_ListID,
                                Quantity,
                                ServiceDate,
                                CustomField11,
                                CustomField14,
                                CustomField15
                                ) VALUES (
                                '$mmddyylf',
                                '$ItemRef_ListID',
                                '$Quantity',
                                '$xbatchno',
                                '$ServiceDate',
                                '$startdate',
                                '$agency_code'
                                ) ";
                                get_custom_query_data_other_db($insert, 'query', $agency_code); 
                            }
                        }
                    }
                }
            }
            $val = 1;
            $val = '1';
            $query1 = "UPDATE QBInvoice.quickbook SET quickbook='$val', Agency = '$agency_code'";
            get_custom_query_data_other_db($query1, 'query', $agency_code); 
            $query2 = "UPDATE QBInvoice.process SET process='$val', process_date = '$zbatchno' WHERE Agency = '$agency_code'";
            get_custom_query_data_other_db($query2, 'query', $agency_code); 
            
            $postcomment = "Created QuickBooks Month =".$month." And Year=".$year; 
            $this->postlog($postcomment);
            $this->session->set_flashdata('message','QuickBooks has been generated successfully.');
            print_r(1);
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function preTest() {

        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $viewmode = $_POST['viewmode'];

        if(!empty($month) && !empty($year) && !empty($agency_code)) {
            $temp = "CREATE TEMPORARY TABLE `temp_trans` (`PatientID` varchar(11) NOT NULL,`Device` varchar(1) NOT NULL )";
            $tempresult = set_custom_query_data($temp);

            $detSQL="SELECT * FROM idoadbfinal WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND total_paid = 0 AND batchno != ''";
            $detExec = get_custom_query_data($detSQL);
            foreach ($detExec as $key => $detResult) {
                $tmp_id = $detResult['idoa_id'];
                $query = "DELETE FROM idoadb_finaldetails WHERE idoa_id = '$tmp_id'";
                set_custom_query_data($query);
            }

            $query = "DELETE FROM idoadbfinal WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND batchno != '' AND total_paid = 0";
            set_custom_query_data($query);

            $temp = "INSERT INTO idoadbfinal SELECT * FROM idoadb WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND total_paid = 0 AND batchno != ''";
            set_custom_query_data($temp);

            $detSQL="SELECT * FROM idoadb WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND total_paid = 0 AND batchno != ''";
            $detExec = get_custom_query_data($detSQL);
            foreach ($detExec as $key => $detResult) {
                $idoa_id = $detResult['idoa_id'];
                $temp = "INSERT INTO idoadb_finaldetails SELECT * FROM idoadb_details WHERE idoa_id  = '$idoa_id'";
                set_custom_query_data($temp);
            }

            /*$delsql = "SELECT patient_id,idoa_id FROM idoadbfinal WHERE patient_id IN 
            ( SELECT patient_id FROM idoadbfinal WHERE month = '$month' AND year = '$year' AND total_paid = 0 AND idoadbfinal.Agency = '$agency_code' AND batchno != '' GROUP BY patient_id HAVING COUNT(patient_id) > 1 ) AND month = '$month' AND year = '$year' AND total_paid = 0 AND idoadbfinal.Agency = '$agency_code' AND batchno != ''";
            $delresult = get_custom_query_data($delsql);
            foreach ($delresult as $key => $delrow) {
                $tmp_id = $delrow['idoa_id'];
                $PatientID = $delrow['patient_id'];

                $insert = "INSERT INTO temp_trans (PatientID) VALUES ('$PatientID')"; 
                set_custom_query_data($insert);

                $detSQL="SELECT * FROM idoadbfinal WHERE idoa_id = '$tmp_id' ";
                $detExec = get_custom_query_data($detSQL);
                foreach ($detExec as $key => $detResult) {
                    $idoa_id = $detResult['idoa_id'];  
                    $query = "DELETE FROM idoadb_finaldetails WHERE idoa_id = '$idoa_id'";
                    set_custom_query_data($query);
                }
                $query = "DELETE FROM idoadbfinal WHERE idoa_id = '$tmp_id'";
                set_custom_query_data($query);
            }*/

            //die;

            $firstday   = $year.'-'.$month.'-'.'01';
            $tmpid      = 1213;
            $tmpid2     = 5543;

            $batchno    = date('Y-m-d H:i:s');
            $total_paid = 0;   

            $cond = "";
            if(!empty($_POST['controlno'])) {
                $controlno = $_POST['controlno'];
                $cond = " AND patient.controlno='".$controlno."'";
            }
                
            $sql = "SELECT patient.patient_id FROM tracking_district, patient WHERE tracking_district.patient_id = patient.patient_id AND patient.Agency = '".$agency_code."' AND tracking_district.mco = 0 AND tracking_district.month <= '".$month."' AND tracking_district.year <= '$year' $cond GROUP BY tracking_district.patient_id";
            $res = get_custom_query_data($sql);
            $patientIds = array_column($res, 'patient_id');
            $patientIds = implode(',', $patientIds);

            //$patientIds = 12373;

            $msql = "SELECT * FROM patient,tbldistricts WHERE patient.Agency = '$agency_code' AND tbldistricts.DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code' AND patient.patient_id IN(".$patientIds.") ORDER BY patient_id";
            $result2 = get_custom_query_data($msql);
            foreach ($result2 as $key => $mrow) {
                $mcocode =  $mrow['mco'];
                $NewDistrictStartDate = $mrow['NewDistrictStartDate'];
                if ($NewDistrictStartDate == null || $NewDistrictStartDate == '--')  {
                    $NewDistrictStartDate = "1930-01-01";
                }

                $recno = $mrow['patient_id'];
                $mcochange = 'no';
                
                $chkSQL =  "SELECT * FROM temp_trans WHERE PatientID = '$recno'";
                $chkResult = get_custom_query_data($chkSQL, 'row');

                //if ($mcocode == 0  && !empty($chkResult)) {
                if (!empty($chkResult)) {
                    $recno  = $mrow['patient_id'];
                    $ptid   = $mrow['patient_id'];
                    $lastname   = '';   //$mrow['lastname'];
                    $firstname  = '';  //$mrow['firstname'];
                    $middlename = ''; //$mrow['middlename'];

                    $mco = $mrow['DistrictID_Ref'];
                    $provider = $mrow['provider'];
                    $ccucontract = $mrow['ccucontract'];
                    $clientid = $mrow['patient_id'];
                    $ssn = $mrow['CustomFieldSSN'];
                    $Agency = $mrow['Agency'];
                    $servicecode = '021';
                    $servicedate = date("Y-m-d");
                    $strSQL = "SELECT * FROM idoa WHERE controlno = '$provider'";
                    $objResult = get_custom_query_data($strSQL, 'row');
                    $servicecode = $objResult['servicecode'];
                    //echo $firstname;
                    /*$status = 'Pending';                    

                    $dataArray = [];                        
                    $dataArray['idoa_id']       =   null;
                    $dataArray['patient_id']    =   $recno;
                    $dataArray['month']         =   $month;
                    $dataArray['year']          =   $year;
                    $dataArray['Agency']        =   $agency_code;
                    $dataArray['servicedate']   =   $start;
                    $dataArray['status']        =   $status;
                    $dataArray['batchno']       =   $batchno;
                    $dataArray['total_paid']    =   $total_paid;
                    $idoa_id =   insertHelper('idoadbfinal', $dataArray);

                    $query = "UPDATE  idoadbfinal SET `servicedate` = '$start' WHERE idoa_id = '$idoa_id'"; 
                    set_custom_query_data($query);

                    /*$chkSQL = "SELECT * FROM employee_2finalsheet WHERE start_date = '$start' AND Agency = '$agency_code' and employee_2finalsheet.patient_id = '$ptid'";
                    $objExec = get_custom_query_data($chkSQL);
                    $TobjResult = get_custom_query_data($chkSQL, 'row');
                    $ID = $TobjResult['service_type'];*/

                    $sdArray = [];
                    $chkSQL = "SELECT * FROM table_2weekly WHERE ((MONTH(start_date) = '$month' AND YEAR(start_date) = '$year') || (MONTH(end_date) = '$month' AND YEAR(end_date) = '$year'))";
                    $objExec = get_custom_query_data($chkSQL);
                    if(!empty($objExec)) {
                        foreach ($objExec as $ke1 => $ro1) {
                            array_push($sdArray, "'".$ro1['start_date']."'");
                        }
                    }
                    $sdString = implode(',', $sdArray);
                    $chkSQL = "SELECT * FROM employee_2finalsheet WHERE start_date IN(".$sdString.") AND Agency = '$agency_code' and patient_id = '$ptid' GROUP BY start_date";
                    $objExec = get_custom_query_data($chkSQL);


                    /*$strSQL1 = "SELECT * FROM tblemployeetypes WHERE EmployeeTypeID = '$ID' and Agency = '$agency_code' " ;
                    $objResult1 = get_custom_query_data($strSQL1, 'row');
                    $rate = $objResult1['rate'];*/
                    //echo "xx".$rate;
                    foreach ($objExec as $key => $objResult) {
                        $ID = $objResult['service_type'];   
                        $daycnt = 0;

                        $start  = $objResult['start_date'];
                        $status = 'Pending';

                        $sql = "SELECT * FROM idoadbfinal WHERE month = '".$month."' AND year = '".$year."' AND servicedate = '".$start."' AND status='".$status."' AND Agency = '".$agency_code."' AND patient_id = '".$recno."' AND batchno IS NOT NULL";
                        $res = get_custom_query_data($sql, 'row');
                        if(empty($res)) {
                            $dataArray = [];
                            $dataArray['idoa_id']       =   null;
                            $dataArray['patient_id']    =   $recno;
                            $dataArray['month']         =   $month;
                            $dataArray['year']          =   $year;
                            $dataArray['Agency']        =   $agency_code;
                            $dataArray['servicedate']   =   $start;
                            $dataArray['status']        =   $status;
                            $dataArray['batchno']       =   $batchno;
                            $dataArray['total_paid']    =   $total_paid;
                            $idoa_id =   insertHelper('idoadbfinal', $dataArray);
                        } else {
                            $idoa_id = $res['idoa_id'];
                        }                        

                        /*** CALCULATE RATE START ***/
                        $strSQL1 = "SELECT * FROM tblemployeetypes WHERE EmployeeTypeID = '$ID' AND Agency = '$agency_code'";
                        $objResult1 = get_custom_query_data($strSQL1, 'row');
                        $rate = $objResult1['rate'];        

                        if ($start <= '2017-09-25') { 
                            $rate = $objResult1['rate'];     
                        } else {
                            $rate = 18.29;   
                        }                               

                        if ($start >= '2019-12-02') { 
                            $rate = 20.28;
                            // $rate = 21.84;
                        }

                        if ($start >= '2019-12-30') { 
                            $rate = 21.84;
                        }

                        if ($start >= '2021-04-05') { 
                            $rate = 23.40;
                        }

                        if ($start >= '2022-01-10') { 
                            $chkSQL = "SELECT * FROM idoa_rate_settings WHERE start_date = '$start' AND agency = '$agency_code'";
                            $objRow = get_custom_query_data($chkSQL, 'row');
                            if(!empty($objRow)) {
                                $rate = $objRow['rate'];
                            } else {
                                $chkSQL = "SELECT * FROM idoa_rate_settings WHERE start_date <= '$start' AND agency = '$agency_code' ORDER BY id DESC";
                                $objRow = get_custom_query_data($chkSQL, 'row');
                                if(!empty($objRow)) {
                                    $rate = $objRow['rate'];
                                }
                            }
                        }
                        /*** CALCULATE RATE END ***/

                        while($daycnt <= 14 )   {
                            $date = strtotime(date("Y-m-d", strtotime($start)) . " + ".$daycnt."days");
                            $datetrans = date("Y-m-d",$date);
                            $d =  'd'.sprintf("%02s", $daycnt + 1);
                            $val = $objResult[$d]; // * 100;
                            $bil = $objResult[$d] * 100;
                            $amount = $val * $rate;

                            $month11 = date('m', $date);
                            $year11 = date('Y', $date);                            

                            $idoacheck = true;
                            $cond = "";
                            $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND MONTH(start_date)='$month' AND YEAR(start_date)='$year' $cond ORDER BY district_id DESC LIMIT 1";
                            $districtResult = get_custom_query_data($districtSQL, 'row');
                            if (!empty($districtResult)) {
                                $mcocode = $districtResult['mco'];
                                $mco = $districtResult['DistrictID_Ref'];
                            } else {
                                $districtSQL =  "SELECT * FROM tracking_district WHERE patient_id = '$ptid' AND MONTH(start_date)<'$month' AND YEAR(start_date)<='$year' AND start_date!='0000-00-00' $cond ORDER BY district_id DESC LIMIT 1";
                                $districtResult = get_custom_query_data($districtSQL, 'row');
                                if (!empty($districtResult)) {
                                    $mcocode = $districtResult['mco'];
                                    $mco = $districtResult['DistrictID_Ref'];
                                } else {
                                    $mcocode = $mrow['mco'];
                                    $mco = $mrow['DistrictID_Ref'];     
                                }                               
                            }

                            if($mcocode==1) {
                                $idoacheck = false;
                            }

                            $chkSQL2 = "SELECT * FROM idoadbfinal,idoadb_finaldetails WHERE idoadbfinal.servicedate = '$start' AND idoadb_finaldetails.start_date = '$start' AND idoadbfinal.patient_id = '$ptid' AND idoadbfinal.idoa_id = idoadb_finaldetails.idoa_id AND date = '$datetrans' AND batchno IS NOT null";                      
                            $objResult2 = get_custom_query_data($chkSQL2, 'row');

                            if ($val != 0 && empty($objResult2) && $idoacheck && ($month==$month11) && ($year==$year11))  { 
                                $chkSQL3 = "SELECT * FROM idoadbfinal,idoadb_finaldetails WHERE idoadbfinal.servicedate = '$start' AND idoadb_finaldetails.start_date = '$start' AND  idoadbfinal.patient_id = '$ptid' AND idoadbfinal.idoa_id = idoadb_finaldetails.idoa_id AND date = '$datetrans' AND batchno IS null";                      
                                $objResult3 = get_custom_query_data($chkSQL3, 'row');
                                $idoadb_details_id = $objResult3['idoadb_details_id'];
                                $val2 = $objResult3['units'] + $val;
                                $bil2 = $objResult3['bill'] + $bil;
                                $amount2 = $objResult3['amount'] + $amount;
                                if (empty($objResult3)) {
                                    $status = 'Pending';                                
                                    $insert = "INSERT INTO idoadb_finaldetails (idoadb_details_id,idoa_id,date,start_date,units,bill,amount,Agency,status,remarks) VALUES (null,'$idoa_id','$datetrans','$start','$val','$bil','$amount','$agency_code','$status','$remarks') ";
                                    set_custom_query_data($insert); 
                                } else {
                                    $query = "UPDATE  idoadb_finaldetails SET `units` = '$val2',`bill` = '$bil2',`amount` = '$amount2' WHERE idoadb_details_id = '$idoadb_details_id'";
                                    set_custom_query_data($query); 
                                }
                                if ($daycnt > 12)  {
                                //break;
                                }
                            }
                            $daycnt++;
                        }                        
                    }
                    $sql = "SELECT * FROM idoadbfinal WHERE month = '".$month."' AND year = '".$year."' AND servicedate IN(".$sdString.") AND status='".$status."' AND Agency = '".$agency_code."' AND patient_id = '".$recno."'";
                    $res = get_custom_query_data($sql);
                    foreach ($res as $key1 => $row) {
                        // code...
                        $start = $row['servicedate'];
                        $idoa_id = $row['idoa_id'];

                        $sumSQL="SELECT * FROM idoadb_finaldetails WHERE idoadb_finaldetails.idoa_id = '$idoa_id' AND start_date = '$start'";
                        $sumExec = get_custom_query_data($sumSQL);
                        $sum_left = 0;
                        $total_amount = 0;
                        foreach ($sumExec as $key => $sumResult) {
                            $sum_left =  $sum_left + $sumResult['units'];    
                            $total_amount =  $total_amount + $sumResult['amount'];
                        }     

                        $query = "UPDATE idoadb_finaldetails SET `utotal` = '$sum_left' WHERE idoa_id = '$idoa_id'";
                        set_custom_query_data($query);

                        if ($sum_left == 0)  {
                            $query = "DELETE FROM idoadbfinal WHERE idoa_id = '$idoa_id' ";
                            set_custom_query_data($query);          
                        } else {
                            $query = "UPDATE idoadbfinal SET `units` = '$sum_left',`total_amount` = '$total_amount',`status` = '$status' WHERE idoa_id = '$idoa_id'";
                            set_custom_query_data($query);
                        }
                    }
                }
            }
            $this->session->set_flashdata('message','Pre-test has been done successfully.');
            print_r(1);            
        }
    }
} 