<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class McoLTS extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->library('user_agent');
    }

    public function getExcelData() {

        if(!empty($_GET['month'])) {
            $month = $_GET['month'];
        } else {
            $month = date('m');
        }

        if(!empty($_GET['year'])) {
            $year = $_GET['year'];
        } else {
            $year = date('Y');
        }

        $filename = "MCO_LTS_MONTHLY_".$month."_".$year.".xls";
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Content-Type: application/vnd.ms-excel");

        $viewmode = 1; $qbviewmode = 0;
        if(!empty($_GET['viewmode'])) {
           $viewmode = $_GET['viewmode']; 
        }

        if(!empty($_GET['qbviewmode'])) {
           $qbviewmode = $_GET['qbviewmode']; 
        }

        $flag = false;
        $row2 = 0;
        if($viewmode==2 || $viewmode==3 || $viewmode==33) {
            $arry = array('Patient Name','Insured Company Name','24.1.a-DOSFrom','24.1.a-DOSTo','24.1.a-Charges','24.1.a-Units','Hours','Total');
        }

        if($viewmode==1) {
            $arry = array('PATIENT NAME','DISTRICT/MCO','DX','MEMBER ID','INV#','PA','GENDER','FROM','CHARGES','DAYS/UNITS');
        }

        
        $table = "cms1500LTS";
        if($viewmode==2) {
            $table = "eclaimsLTS";
            $cond .= "AND ($table.paid = 0 OR $table.paid = 3) AND qb = '' ";
        }

        if($viewmode==33) {
            $cond .= "AND ($table.paid = 0 OR $table.paid = 3) AND qb = '' ";
        }

        if($viewmode==3) {
            $table = "eclaimsLTS";
            $cond .= "AND $table.paid = 0 AND qb = 'yes' ";
            $nbatchno = $_GET['nbatchno'];
            if(!empty($nbatchno)) {
                $cond .= "AND $table.uploadtime = '".$nbatchno."' ";
            }
        }

        $col012 = '"2-PatientName"';
        $col070 = '"21.1-Diagnosis"';
        $col011 = '"1a-InsuredIDNo"';
        $col168 = '"26-PatientAcctNo"';
        $col014 = '"3-PatientGender"';
        $col088 = '"24.1.a-DOSFrom"';
        $col087 = '"23-PriorAuth"';
        $col170 = '"28-TotalCharge"';
        $col166 = '"25-TaxID"';
        $col200 = '"33-b-GrpLegacyNo"';

        
        $agency_code = $_GET['agency_code'];
        $InterAgency = $_GET['InterAgency'];
        $DistrictID_Ref2 = $_GET['DistrictID_Ref2'];
        $payorgroup = $_GET['payorgroup'];
        if($InterAgency!='') {
            $cond .= "AND tbldistricts.InterAgency = '".$InterAgency."' ";
        }
        if($payorgroup!='') {
            $cond .= "AND tbldistricts.payorGrp = '".$payorgroup."' ";
        }
        if(!empty($DistrictID_Ref2) && $DistrictID_Ref2!='888') {
            $cond .= "AND $table.mco = '".$DistrictID_Ref2."' ";
        }

        $sql = "SELECT SQL_CALC_FOUND_ROWS *, tbldistricts.mco as tblmco, $table.mco as mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' AND tbldistricts.Agency = '".$agency_code."' $cond ORDER BY `$col012` ASC";
        $res = $this->Comman_model->getCustomQueryData($sql);

        $totalRec = 0;
        $datas = [];
        $data = [];
        if($viewmode==33) {
            $i = 0;
            foreach ($res as $keyT => $rowT) {
                $allow = true;
                if(!empty($_GET['qb_profile'])) {
                    $qb_profile = $_GET['qb_profile'];
                } else {
                    $qb_profile = 2;
                }
                $ptSQL = "SELECT * FROM patient WHERE patient_id = '".$rowT['patient_id']."' AND Agency = '".$agency_code."'";
                $ptRow = get_custom_query_data($ptSQL, 'row');
                $med_medicaidno = trim($ptRow['med_medicaidno']);
                $ParentRef_FullName = $rowT['ParentRef_FullName'];

                $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                if($qb_profile==2) {
                    if(empty($findResult)) {
                        $allow = true;
                    } else {
                        $allow = false;
                    }
                }
                if($qb_profile==1) {
                    if(!empty($findResult)) {
                        $allow = true;
                    } else {
                        $allow = false;
                    }
                }
                if($allow===true) {
                    $totalRec++;
                    $params = [];
                    if($viewmode==33) {                        
                        $allow = true;
                        $qb =  $row['qb'];
                        $syes = $sno = '';
                        if($qb=='yes') {
                            $syes = 'selected';
                            $sno = '';
                        }
                        if($qb=='no') {
                            $sno = 'selected';
                            $syes = '';
                        }

                        if(!empty($_GET['qb_profile'])) {
                            $qb_profile = $_GET['qb_profile'];
                        } else {
                            $qb_profile = 2;
                        }

                        $ptSQL = "SELECT * FROM patient WHERE patient_id = '".$rowT['patient_id']."' AND Agency = '$agency_code'";
                        $ptResult = get_custom_query_data($ptSQL, 'row');
                        $ID2 = $ptResult['DistrictID_Ref'];
                        $med_medicaidno = trim($ptResult['med_medicaidno']);

                        $distSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$ID2' AND Agency = '$agency_code'" ;
                        $distResult = get_custom_query_data($distSQL, 'row');
                        $ParentRef_FullName = $distResult['ParentRef_FullName'];

                        $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                        $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                        if($qb_profile==2) {
                            if(empty($findResult)) {
                                $allow = true;
                                $nex++;
                            } else {
                                $allow = false;
                            }
                        }
                        if($qb_profile==1) {
                            if(!empty($findResult)) {
                                $allow = true;
                            } else {
                                $allow = false;
                            }                    
                        }

                        if($allow===true) {
                            //$params[0] = $rowT['cms1500_id'];
                            $params[0] = $rowT['"2-PatientName"'];
                            $params[1] = $rowT['"Insurance Company Name"'];
                            $params[2] = $rowT['"24.1.a-DOSFrom"'];
                            $params[3] = $rowT['"24.1.a-DOSTo"'];
                            $params[4] = $rowT['"24.1.f-Charges"'];
                            $params[5] = $rowT['"24.1.g-Units"'];
                            $params[6] = $rowT['"28-TotalCharge"'];
                            $params[7] = number_format(floatvalue($rowT[$col170]), 2, '.', '');                    
                        }                
                    }
                    if(!empty($params)) {
                        $datas[$i] = $params;  
                        $i++;                        
                    }
                }
            }            
            $data = $datas;
        }

        if($qbviewmode==1) {
            $i = 0;
            $checkPatientCount = []; $tamt = 0;
            foreach ($res as $keyT => $rowT) {
                $allow = false;
                $qb_profile = 2;

                $ptSQL = "SELECT * FROM patient WHERE patient_id = '".$rowT['patient_id']."' AND Agency = '".$agency_code."'";
                $ptRow = get_custom_query_data($ptSQL, 'row');
                $med_medicaidno = trim($ptRow['med_medicaidno']);
                $ParentRef_FullName = $rowT['ParentRef_FullName'];

                $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                $allow = false;
                if(empty($findResult)) {
                    $allow = true;
                }

                if($allow===true) {
                    $totalRec++;

                    array_push($checkPatientCount, $rowT['patient_id']);

                    $amt = number_format(floatvalue($rowT['totalIA']), 2, '.', '');
                    $tamt = $tamt + $amt;

                    $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '".$agency_code."' AND mco = 1 AND DistrictID = '".$rowT['mco']."'";
                    $districtData = $this->Comman_model->getCustomQueryData($strSQL, 'row');
                    $disName = $districtData['DistrictName'].' ('.$districtData['DistrictNumber'].')';

                    $memberid = $rowT[$col011];
                    if ($memberid!='') { $inv = $memberid.'/'.$rowT['patient_id']; } else { $inv = $memberid; }
                    
                    if(!empty($rowT[$col087])) {
                        $pa = $rowT[$col087];    
                    } else {
                        $sqlp = "SELECT * FROM patient_auth_history where patient_id = '".$rowT['patient_id']."' ORDER BY patient_auth_history_id DESC";
                        $rowp = get_custom_query_data($sqlp, 'row');
                        $pa = $rowp["authorization"];      
                    }
                    $dosfrom = $rowT[$col088]; 
                    $units = $rowT['"24.1.g-Units"'] + $rowT['"24.2.g-Units"'] + $rowT['"24.3.g-Units"'] + $rowT['"24.4.g-Units"'] + $rowT['"24.5.g-Units"'] + $rowT['"24.6.g-Units"'];

                    $params = [];
                    
                    $params[0] = $rowT['"2-PatientName"'];
                    $params[1] = $disName;
                    $params[2] = $rowT[$col070];
                    $params[3] = $inv;
                    $params[4] = $rowT[$col168];
                    $params[5] = $pa;
                    $params[6] = $row[$col014];
                    $params[7] = $dosfrom;
                    $params[8] = $rowT['"28-TotalCharge"'];
                    $params[9] = $units;
                    
                    if(!empty($params)) {
                        $datas[$i] = $params;  
                        $i++;                        
                    }
                }
            }            
            $data = $datas;
        }
        
        $nex = 0;
        if($viewmode!=33 && $qbviewmode==0) {
            foreach ($res as $key => $row) {
                $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '".$agency_code."' AND mco = 1 AND DistrictID = '".$row['mco']."'";
                $districtData = $this->Comman_model->getCustomQueryData($strSQL, 'row');
                $disName = $districtData['DistrictName'].' ('.$districtData['DistrictNumber'].')';

                $memberid = $row[$col011];
                if ($memberid!='') { $inv = $memberid.'/'.$row['patient_id']; } else { $inv = $memberid; }
                
                if(!empty($row[$col087])) {
                    $pa = $row[$col087];    
                } else {
                    $sqlp = "SELECT * FROM patient_auth_history where patient_id = '".$row['patient_id']."' ORDER BY patient_auth_history_id DESC";
                    $rowp = get_custom_query_data($sqlp, 'row');
                    $pa = $rowp["authorization"];      
                }
                $dosfrom = $row[$col088]; 
                $units = $row['"24.1.g-Units"'] + $row['"24.2.g-Units"'] + $row['"24.3.g-Units"'] + $row['"24.4.g-Units"'] + $row['"24.5.g-Units"'] + $row['"24.6.g-Units"'];

                $params = [];
                if($viewmode==1) {
                    //$params[0] = $row['cms1500_id'];
                    $params[0] = $row['"2-PatientName"'];
                    $params[1] = $disName;
                    $params[2] = $row[$col070];
                    $params[3] = $inv;
                    $params[4] = $row[$col168];
                    $params[5] = $pa;
                    $params[6] = $row[$col014];
                    $params[7] = $dosfrom;
                    $params[8] = $row['"28-TotalCharge"'];
                    $params[9] = $units;
                }

                if($viewmode==2) {
                    //$params[0] = $row['cms1500_id'];
                    $params[0] = $row['"2-PatientName"'];
                    $params[1] = $row['"Insurance Company Name"'];
                    $params[2] = $row['"24.1.a-DOSFrom"'];
                    $params[3] = $row['"24.1.a-DOSTo"'];
                    $params[4] = $row['"24.1.f-Charges"'];
                    $params[5] = $row['"24.1.g-Units"'];
                    $params[6] = $row['"28-TotalCharge"'];
                    $params[7] = number_format(floatvalue($row[$col170]), 2, '.', '');
                }

                if($viewmode==3) {
                    //$params[0] = $row['cms1500_id'];
                    $params[0] = $row['"2-PatientName"'];
                    $params[1] = $row['"Insurance Company Name"'];
                    $params[2] = $row['"24.1.a-DOSFrom"'];
                    $params[3] = $row['"24.1.a-DOSTo"'];
                    $params[4] = $row['"24.1.f-Charges"'];
                    $params[5] = $row['"24.1.g-Units"'];
                    $params[6] = $row['"28-TotalCharge"'];
                    $params[7] = number_format(floatvalue($row[$col170]), 2, '.', '');
                }                
                if(!empty($params)) {
                    $data[$key] = $params;
                }
            }
        }
        
        if(!empty($data)) {
            foreach ($data as $key => $row) {
                if(!$flag) {
                  array_walk($row, array($this,'cleanData'));
                  echo implode("\t",$arry) . "\r\n";
                  $flag = true;
                }
                array_walk($row, array($this, 'cleanData'));
                $x = 1;
                echo implode("\t", array_values($row)) . "\r\n";
            }
        } else {
            $this->session->set_flashdata('error_message', 'Oops no record found.');
            redirect($this->agent->referrer());
        }
    }

    public function cleanData(&$str)  {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    public function monthlySC() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                redirect('mcoLTS/monthlyHMCG');
            }

            $data = [];
            $data['month'] = date('m');
            $data['year'] = date('Y');
            $data['viewmode'] = 1;
            $data['agency_code'] = $agency_code;
            $data['InterAgency'] = '';
            $data['DistrictID_Ref2'] = '';
            $data['qb_profile'] = '2';
            $data['formSubmit'] = '';
            $data['payorgroup'] = '';

            if(!empty($_GET['payorgroup'])) {
                $data['payorgroup'] = $_GET['payorgroup'];
            }
            if(!empty($_GET['month'])) {
                $data['month'] = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                $data['year'] = $_GET['year'];
            }
            if(!empty($_GET['viewmode'])) {
                $data['viewmode'] = $_GET['viewmode'];
            }
            if(!empty($_GET['DistrictID_Ref2'])) {
                $data['DistrictID_Ref2'] = $_GET['DistrictID_Ref2'];
            }
            if(!empty($_GET['qb_profile'])) {
                $data['qb_profile'] = $_GET['qb_profile'];
            }
            if(!empty($_GET['formSubmit'])) {
                $data['formSubmit'] = $_GET['formSubmit'];
            }
            if(isset($_GET['InterAgency']) && $_GET['InterAgency']!='') {
                $data['InterAgency'] = $_GET['InterAgency'];
            }

            $data['displayRate'] = 5.07;
            if ($data['month']>='12' && $data['year']>='2019') { 
                $data['displayRate'] = 5.46;
            }               
            if ($data['month']>='04' && $data['year']>='2021') { 
                $data['displayRate'] = 5.85;
            }


            $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) = '".$data['month']."' AND YEAR(start_date) = '".$data['year']."' AND agency = '$agency_code'";
            $objRow = get_custom_query_data($chkSQL, 'row');
            if(!empty($objRow)) {
                $data['displayRate'] = $objRow['rate'];    
            } else {
                $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) <= '".$data['month']."' AND YEAR(start_date) <= '".$data['year']."' AND agency = '$agency_code' ORDER BY id DESC";
                $objRow = get_custom_query_data($chkSQL, 'row');
                if(!empty($objRow)) {
                    $data['displayRate'] = $objRow['rate'];
                }
            }
            
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date>='2020-01-01' AND start_date<='2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            if($_GET["startdate"] == null) {
                $thedate = date('Y-m-d');
                $strSQL = "SELECT * FROM table_2weekly WHERE start_date<'$thedate' ORDER BY start_date DESC LIMIT 1";
                $objResult = get_custom_query_data($strSQL, 'row');
                $data['startdate'] = $objResult['start_date'];                   
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco_1500LTS/monthly.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function monthlyHMCG() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==2 || $agency_code==4) {
                redirect('mcoLTS/monthlySC');
            }

            $data = [];
            $data['month'] = date('m');
            $data['year'] = date('Y');
            $data['viewmode'] = 1;
            $data['agency_code'] = $agency_code;
            $data['InterAgency'] = '';
            $data['DistrictID_Ref2'] = '';
            $data['qb_profile'] = '2';
            $data['formSubmit'] = '';
            $data['payorgroup'] = '';

            if(!empty($_GET['payorgroup'])) {
                $data['payorgroup'] = $_GET['payorgroup'];
            }
            if(!empty($_GET['month'])) {
                $data['month'] = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                $data['year'] = $_GET['year'];
            }
            if(!empty($_GET['viewmode'])) {
                $data['viewmode'] = $_GET['viewmode'];
            }
            if(!empty($_GET['DistrictID_Ref2'])) {
                $data['DistrictID_Ref2'] = $_GET['DistrictID_Ref2'];
            }
            if(!empty($_GET['qb_profile'])) {
                $data['qb_profile'] = $_GET['qb_profile'];
            }
            if(!empty($_GET['formSubmit'])) {
                $data['formSubmit'] = $_GET['formSubmit'];
            }
            if(isset($_GET['InterAgency']) && $_GET['InterAgency']!='') {
                $data['InterAgency'] = $_GET['InterAgency'];
            }

            $data['displayRate'] = 5.07;
            if ($data['month']>='12' && $data['year']>='2019') { 
                $data['displayRate'] = 5.46;
            }               
            if ($data['month']>='04' && $data['year']>='2021') { 
                $data['displayRate'] = 5.85;
            }


            $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) = '".$data['month']."' AND YEAR(start_date) = '".$data['year']."' AND agency = '$agency_code'";
            $objRow = get_custom_query_data($chkSQL, 'row');
            if(!empty($objRow)) {
                $data['displayRate'] = $objRow['rate'];    
            } else {
                $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) <= '".$data['month']."' AND YEAR(start_date) <= '".$data['year']."' AND agency = '$agency_code' ORDER BY id DESC";
                $objRow = get_custom_query_data($chkSQL, 'row');
                if(!empty($objRow)) {
                    $data['displayRate'] = $objRow['rate'];
                }
            }
            
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_1weekly WHERE start_date>='2020-01-01' AND start_date<='2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            if($_GET["startdate"] == null) {
                $thedate = date('Y-m-d');
                $strSQL = "SELECT * FROM table_1weekly WHERE start_date<'$thedate' ORDER BY start_date DESC LIMIT 1";
                $objResult = get_custom_query_data($strSQL, 'row');
                $data['startdate'] = $objResult['start_date'];                   
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco_1500LTS/monthlyHM.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function monthlySC3() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==1 || $agency_code==3) {
                redirect('mcoLTS/monthlyHMCG3');
            }

            $data = [];
            $data['month'] = date('m');
            $data['year'] = date('Y');
            $data['viewmode'] = 1;
            $data['agency_code'] = $agency_code;
            $data['InterAgency'] = '';
            $data['DistrictID_Ref2'] = '';
            $data['qb_profile'] = '2';
            $data['qbviewmode'] = '0';
            $data['formSubmit'] = '';
            $data['payorgroup'] = '';
            $data['nbatchno'] = '';

            if(!empty($_GET['qbviewmode'])) {
                $data['qbviewmode'] = $_GET['qbviewmode'];
            }
            if(!empty($_GET['nbatchno'])) {
                $data['nbatchno'] = $_GET['nbatchno'];
            }
            if(!empty($_GET['payorgroup'])) {
                $data['payorgroup'] = $_GET['payorgroup'];
            }
            if(!empty($_GET['month'])) {
                $data['month'] = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                $data['year'] = $_GET['year'];
            }
            if(!empty($_GET['viewmode'])) {
                $data['viewmode'] = $_GET['viewmode'];
            }
            if(!empty($_GET['DistrictID_Ref2'])) {
                $data['DistrictID_Ref2'] = $_GET['DistrictID_Ref2'];
            }
            if(!empty($_GET['qb_profile'])) {
                $data['qb_profile'] = $_GET['qb_profile'];
            }
            if(!empty($_GET['formSubmit'])) {
                $data['formSubmit'] = $_GET['formSubmit'];
            }
            if(isset($_GET['InterAgency']) && $_GET['InterAgency']!='') {
                $data['InterAgency'] = $_GET['InterAgency'];
            }

            $data['displayRate'] = 5.07;
            if ($data['month']>='12' && $data['year']>='2019') { 
                $data['displayRate'] = 5.46;
            }               
            if ($data['month']>='04' && $data['year']>='2021') { 
                $data['displayRate'] = 5.85;
            }


            $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) = '".$data['month']."' AND YEAR(start_date) = '".$data['year']."' AND agency = '$agency_code'";
            $objRow = get_custom_query_data($chkSQL, 'row');
            if(!empty($objRow)) {
                $data['displayRate'] = $objRow['rate'];    
            } else {
                $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) <= '".$data['month']."' AND YEAR(start_date) <= '".$data['year']."' AND agency = '$agency_code' ORDER BY id DESC";
                $objRow = get_custom_query_data($chkSQL, 'row');
                if(!empty($objRow)) {
                    $data['displayRate'] = $objRow['rate'];
                }
            }
            
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_2weekly WHERE start_date>='2020-01-01' AND start_date<='2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            if($_GET["startdate"] == null) {
                $thedate = date('Y-m-d');
                $strSQL = "SELECT * FROM table_2weekly WHERE start_date<'$thedate' ORDER BY start_date DESC LIMIT 1";
                $objResult = get_custom_query_data($strSQL, 'row');
                $data['startdate'] = $objResult['start_date'];                   
            }

            //$this->load->view('common/header.php');
            //$this->load->view('common/sidebar.php');
            //$this->load->view('mco_1500LTS/monthly3.php', $data);
            //$this->load->view('common/footer-new.php');

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('mco_1500LTS/monthly3-new.php', $data);
        } else {
            redirect();
        }
    }

    public function monthlyHMCG3() {
        if(isset($_SESSION['name'])) {
            $agency_code = $this->session->userdata('agency');
            if($agency_code==2 || $agency_code==4) {
                redirect('mcoLTS/monthlySC3');
            }

            $data = [];
            $data['month'] = date('m');
            $data['year'] = date('Y');
            $data['viewmode'] = 1;
            $data['agency_code'] = $agency_code;
            $data['InterAgency'] = '';
            $data['DistrictID_Ref2'] = '';
            $data['qb_profile'] = '2';
            $data['qbviewmode'] = '0';
            $data['formSubmit'] = '';
            $data['payorgroup'] = '';
            $data['nbatchno'] = '';

            if(!empty($_GET['qbviewmode'])) {
               $data['qbviewmode'] = $_GET['qbviewmode']; 
            }
            if(!empty($_GET['nbatchno'])) {
                $data['nbatchno'] = $_GET['nbatchno'];
            }
            if(!empty($_GET['payorgroup'])) {
                $data['payorgroup'] = $_GET['payorgroup'];
            }
            if(!empty($_GET['month'])) {
                $data['month'] = $_GET['month'];
            }
            if(!empty($_GET['year'])) {
                $data['year'] = $_GET['year'];
            }
            if(!empty($_GET['viewmode'])) {
                $data['viewmode'] = $_GET['viewmode'];
            }
            if(!empty($_GET['DistrictID_Ref2'])) {
                $data['DistrictID_Ref2'] = $_GET['DistrictID_Ref2'];
            }
            if(!empty($_GET['qb_profile'])) {
                $data['qb_profile'] = $_GET['qb_profile'];
            }
            if(!empty($_GET['formSubmit'])) {
                $data['formSubmit'] = $_GET['formSubmit'];
            }
            if(isset($_GET['InterAgency']) && $_GET['InterAgency']!='') {
                $data['InterAgency'] = $_GET['InterAgency'];
            }

            $data['displayRate'] = 5.07;
            if ($data['month']>='12' && $data['year']>='2019') { 
                $data['displayRate'] = 5.46;
            }               
            if ($data['month']>='04' && $data['year']>='2021') { 
                $data['displayRate'] = 5.85;
            }


            $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) = '".$data['month']."' AND YEAR(start_date) = '".$data['year']."' AND agency = '$agency_code'";
            $objRow = get_custom_query_data($chkSQL, 'row');
            if(!empty($objRow)) {
                $data['displayRate'] = $objRow['rate'];    
            } else {
                $chkSQL = "SELECT * FROM mco_rate_settings WHERE MONTH(start_date) <= '".$data['month']."' AND YEAR(start_date) <= '".$data['year']."' AND agency = '$agency_code' ORDER BY id DESC";
                $objRow = get_custom_query_data($chkSQL, 'row');
                if(!empty($objRow)) {
                    $data['displayRate'] = $objRow['rate'];
                }
            }
            
            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $data['districtData'] = $this->Comman_model->getCustomQueryData($strSQL);

            $strSQL1 = "SELECT * FROM table_1weekly WHERE start_date>='2020-01-01' AND start_date<='2030-01-01'";
            $allStartDateList = $this->Comman_model->getCustomQueryData($strSQL1);
            $data['allStartDateList'] = $allStartDateList;

            if($_GET["startdate"] == null) {
                $thedate = date('Y-m-d');
                $strSQL = "SELECT * FROM table_1weekly WHERE start_date<'$thedate' ORDER BY start_date DESC LIMIT 1";
                $objResult = get_custom_query_data($strSQL, 'row');
                $data['startdate'] = $objResult['start_date'];                   
            }

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('mco_1500LTS/monthlyHM3.php', $data);
            $this->load->view('common/footer-new.php');
        } else {
            redirect();
        }
    }

    public function postlog($postcomment) {
        $postuser = $this->session->userdata('name');
        $postdate = date("Y-m-d H:i:s");
        $postagency = $this->session->userdata('agency');
        $postmode = 0;
        $notesid = 0;
        $postcategory = '';

        $dataArray = [];
        $dataArray['postdate'] = $postdate;
        $dataArray['postuser'] = $postuser;
        $dataArray['postagency'] = $postagency;
        $dataArray['postperiod'] = $postmode;
        $dataArray['postcomment'] = $postcomment;
        $dataArray['postcategory'] = $postcategory;
        $dataArray['notesid'] = $notesid;

        $postlog_id = $this->Comman_model->insert('postlog', $dataArray);
    }

    function savecms1500info() {
        /******** Save cms_1500 Data Start*********/
        if ($_POST['formSubmit'] == 'Save')  {

            $agency_code = $this->session->userdata('agency');

            $recno      = $_POST['recno'];
            $charges    = $_POST['charges'];
            $units      = $_POST['units'];
            //$memberid   = $_POST['memberid'];
            $pa         = $_POST['pa'];

            $DistrictID_Ref2 = $_POST['DistrictID_Ref2'];
            $totalcharges = $charges;

            $strSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '".$DistrictID_Ref2."' AND Agency = '".$agency_code."'";
            $objResult = $this->Comman_model->getCustomQueryData($strSQL, 'row');

            $InsuranceCompanyName = $objResult['DistrictName'];
            $BillAddressAddr = $objResult['BillingAddress'];
            $BillAddressAddr2 = $objResult['BillingAddress2'];

            $col170 = '"28-TotalCharge"';
            $col088 = '"24.1.a-DOSFrom"';
            $col089 = '"24.1.a-DOSTo"';
            $col006 = '"Insurance Company Name"';
            $col008 = '"Insurance Company Address 1"';
            $col009 = '"Insurance Company Address 2"';
            $col087 = '"23-PriorAuth"';
            $dosfrom = $_POST['frmDate'];  
            $dosto = $dosfrom;
            $query = "UPDATE cms1500LTS SET `$col088` = '$dosfrom',`$col089` = '$dosto',`$col170` = '$totalcharges', `$col087` = '$pa', `$col006`= '$InsuranceCompanyName', `$col008` = '$BillAddressAddr', `$col009` = '$BillAddressAddr2', mco = '$DistrictID_Ref2' WHERE cms1500_id = '$recno'";
            set_custom_query_data($query);

            $this->session->set_flashdata('message','Data has been updated successfully.');
            redirect($this->agent->referrer());
        }
        /******** Save cms_1500 Data End*********/
    }

    function getPatientData() {
        if(!empty($_POST['cms1500id'])) {
            $table = "cms1500LTS";
            $sql = "SELECT SQL_CALC_FOUND_ROWS *, tbldistricts.mco as tblmco, $table.mco as mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.cms1500_id = '".$_POST['cms1500id']."'";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');
            $data = [];
            $patientName = $row['"2-PatientName"'];
            $fromDate = $row['"24.1.a-DOSFrom"'];
            $data['mco'] = $row['mco'];
            $patient_id = $row['patient_id'];
            $col087 = '"23-PriorAuth"';
            $pa = $row[$col087];
            $agency_code = $this->session->userdata('agency');
            $charges = $row['"28-TotalCharge"'];
            $units = $row['"24.1.g-Units"'] + $row['"24.2.g-Units"'] + $row['"24.3.g-Units"'] + $row['"24.4.g-Units"'] + $row['"24.5.g-Units"'] + $row['"24.6.g-Units"'];

            $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '$agency_code' AND mco = 1 ORDER BY DistrictName ASC";
            $districtData = $this->Comman_model->getCustomQueryData($strSQL);

            $data = '<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h4 class="modal-title">'.$patientName.' Details</h4></div><form method="post" action="'.base_url('mco/savecms1500info').'"><div class="modal-body user-modal-body">';

            $data .= '<div class="row"><div class="col-md-6"><div class="form-group"><label>DISTRICT/MCO</label><select name="DistrictID_Ref2" id="mdDistrictID_Ref2" class="form-control"><option value="">Select</option>';
            if(!empty($districtData)) {
                foreach ($districtData as $key => $objResult) {
                    $selected = '';
                    if($row['mco']==$objResult['DistrictID']) {
                        $selected = ' selected';
                    }
                    $data .= '<option value="'.$objResult['DistrictID'].'"'.$selected.'>'.$objResult['DistrictName'].' ('.$objResult['DistrictNumber'].')</option>';
                }
            }
            $data .= '</select></div></div><div class="col-md-6"><div class="form-group"><label>PA</label><select name="pa" class="form-control">';
            if(empty($pa)) {
                $strSQL = "SELECT * FROM patient_auth_history where patient_id = '".$patient_id."' ORDER BY patient_auth_history_id DESC" ;
                $intRows = 0;
                $objResult = $this->Comman_model->getCustomQueryData($strSQL, 'row');
                $pa = $objResult["authorization"];   
            }
            $strSQL = "SELECT * FROM patient_auth_history where patient_id = '".$patient_id."' ORDER BY patient_auth_history_id DESC" ;
            $objExec = $this->Comman_model->getCustomQueryData($strSQL);
            $intRows = 0;
            foreach ($objExec as $key => $objResult) {
                $intRows++; 
                $selected = '';
                if ($pa==$objResult['authorization']) {
                    $paName = $objResult['authorization'];
                    $selected = ' selected';
                }
                $data .= '<optgroup label="'.date("m/d/Y",strtotime($objResult['validfrom'])).' - '. date("m/d/Y",strtotime($objResult['validto'])).'"><option value="'.$objResult['authorization'].'"'.$selected.'>'.$objResult['authorization'].'</option></optgroup>';
            }
            $data .= '</select></div></div></div>';
            $data .= '<div class="row"><div class="col-md-4"><div class="form-group"><label>FROM</label><input type="text" name="frmDate" id="frmDate" class="form-control mydatepicker-autoclose" value="'.$fromDate.'"><input type="hidden" name="recno" id="recno" value="'.$_POST['cms1500id'].'"></div></div>';

            $data .= '<div class="col-md-4"><div class="form-group"><label>Charges</label><input type="text" name="charges" id="charges" class="form-control" value="'.$charges.'"></div></div>';

            $data .= '<div class="col-md-4"><div class="form-group"><label>Units</label><input type="text" name="units" id="units" class="form-control" value="'.$units.'"></div></div></div>';

            $data .= '</div><div class="modal-footer"><button type="submit" name="formSubmit" value="Save" class="btn btn-primary">Update</button><button type="button" class="btn btn-default" data-dismiss="modal">Close</button></div></form>';

            print_r($data);
        }
    }

    function monthlyData() {        
        /* 
        * Paging
        */
        $sLimit = "LIMIT 0, 10"; $cond = '';
        if(!empty($_POST['start'])) {
            $start = $_POST['start'];
            $sLimit = "LIMIT ".$start.", 10";
        }

        $viewmode = 1; $qbviewmode = 0;
        if(!empty($_GET['viewmode'])) {
           $viewmode = $_GET['viewmode']; 
        }

        if(!empty($_GET['qbviewmode'])) {
           $qbviewmode = $_GET['qbviewmode']; 
        }

        $table = "cms1500LTS";
        if($viewmode==2) {
            $table = "eclaimsLTS";
            $cond .= "AND ($table.paid = 0 OR $table.paid = 3) AND qb = '' ";
        }

        if($viewmode==33) {
            $cond .= "AND ($table.paid = 0 OR $table.paid = 3) AND qb = '' ";
        }

        if($viewmode==3) {
            $table = "eclaimsLTS";
            $cond .= "AND $table.paid = 0 AND qb = 'yes' ";
            $nbatchno = $_GET['nbatchno'];
            if(!empty($nbatchno)) {
                $cond .= "AND $table.uploadtime = '".$nbatchno."' ";
            }
        }

        $col012 = '"2-PatientName"';
        $col070 = '"21.1-Diagnosis"';
        $col011 = '"1a-InsuredIDNo"';
        $col168 = '"26-PatientAcctNo"';
        $col014 = '"3-PatientGender"';
        $col088 = '"24.1.a-DOSFrom"';
        $col087 = '"23-PriorAuth"';
        $col170 = '"28-TotalCharge"';
        $col166 = '"25-TaxID"';
        $col200 = '"33-b-GrpLegacyNo"';

        if(!empty($_POST['search']['value'])) {            
            $search = $_POST['search']['value'];
            $cond .= "AND ($table.`$col012` LIKE '%".$search."%' OR tbldistricts.DistrictName LIKE '%".$search."%')";
        }
        if(!empty($_GET['month']) && !empty($_GET['year'])) {
            $month = $_GET['month']; $year = $_GET['year'];
        } else {
            $month = date('m'); $year = date('Y');
        }
        $agency_code = $_GET['agency_code'];
        $InterAgency = $_GET['InterAgency'];
        $DistrictID_Ref2 = $_GET['DistrictID_Ref2'];
        $payorgroup = $_GET['payorgroup'];
        if($InterAgency!='') {
            $cond .= "AND tbldistricts.InterAgency = '".$InterAgency."' ";
        }
        if($payorgroup!='') {
            $cond .= "AND tbldistricts.payorGrp = '".$payorgroup."' ";
        }
        if(!empty($DistrictID_Ref2) && $DistrictID_Ref2!='888') {
            $cond .= "AND $table.mco = '".$DistrictID_Ref2."' ";
        }

        $sql = "SELECT SQL_CALC_FOUND_ROWS *, tbldistricts.mco as tblmco, $table.mco as mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' AND tbldistricts.Agency = '".$agency_code."' $cond ORDER BY `$col012` ASC $sLimit";
        $res = $this->Comman_model->getCustomQueryData($sql);

        //
        $sqlGT = "SELECT SQL_CALC_FOUND_ROWS *, tbldistricts.mco as tblmco, $table.mco as mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' AND tbldistricts.Agency = '".$agency_code."' $cond GROUP BY $table.patient_id";
        $resGT = $this->Comman_model->getCustomQueryData($sqlGT);
        $tcnt = count($resGT);

        //$sqlGT = "SELECT SUM(`$col170`) as totalIA FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' AND tbldistricts.Agency = '".$agency_code."' $cond";
        //$rowGT = $this->Comman_model->getCustomQueryData($sqlGT, 'row');
        //$amt = number_format(floatvalue($rowGT['totalIA']), 2, '.', '');
        //$amt = number_format((float)$rowGT['totalIA'], 2, '.', '');

        $sqlGT = "SELECT `$col170` as totalIA FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' AND tbldistricts.Agency = '".$agency_code."' $cond";
        $resultGT = $this->Comman_model->getCustomQueryData($sqlGT);
        $tamt = 0;
        foreach ($resultGT as $keyGT => $rowGT) {
            // code...
            $amt = number_format(floatvalue($rowGT['totalIA']), 2, '.', '');
            $tamt = $tamt + $amt;
        }
        $amt = number_format(floatvalue($tamt), 2, '.', '');

        $lblTotal = "</br><p class='normal'> Total Clients: ".$tcnt."&nbsp; &nbsp; &nbsp; Total Invoice Amount: ".$amt;

        /******** Get recordsTotal ********/
        $sqlT = "SELECT SQL_CALC_FOUND_ROWS *, tbldistricts.mco as tblmco, $table.mco as mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' AND tbldistricts.Agency = '".$agency_code."' $cond ORDER BY `$col012` ASC";
        $this->session->set_userdata('SQL', $sqlT);
        $resT = $this->Comman_model->getCustomQueryData($sqlT);        
        $recordsTotal = count($resT);

        /******** Get recordsFiltered ********/
        $sqlF = "SELECT SQL_CALC_FOUND_ROWS *, tbldistricts.mco as tblmco, $table.mco as mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '".$month."' AND $table.year = '".$year."' AND $table.Agency = '".$agency_code."' AND tbldistricts.Agency = '".$agency_code."' $cond ORDER BY `$col012` ASC";
        $resF = $this->Comman_model->getCustomQueryData($sqlF);
        $recordsFiltered = count($resF);

        $totalRec = 0;
        $datas = [];
        $data = [];
        if($viewmode==33) {
            $i = 0;
            foreach ($resT as $keyT => $rowT) {
                $allow = true;
                if(!empty($_GET['qb_profile'])) {
                    $qb_profile = $_GET['qb_profile'];
                } else {
                    $qb_profile = 2;
                }
                $ptSQL = "SELECT * FROM patient WHERE patient_id = '".$rowT['patient_id']."' AND Agency = '".$agency_code."'";
                $ptRow = get_custom_query_data($ptSQL, 'row');
                $med_medicaidno = trim($ptRow['med_medicaidno']);
                $ParentRef_FullName = $rowT['ParentRef_FullName'];

                $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                if($qb_profile==2) {
                    if(empty($findResult)) {
                        $allow = true;
                    } else {
                        $allow = false;
                    }
                }
                if($qb_profile==1) {
                    if(!empty($findResult)) {
                        $allow = true;
                    } else {
                        $allow = false;
                    }
                }
                if($allow===true) {
                    $totalRec++;
                    $params = [];
                    if($viewmode==33) {                        
                        $allow = true;
                        $qb =  $row['qb'];
                        $syes = $sno = '';
                        if($qb=='yes') {
                            $syes = 'selected';
                            $sno = '';
                        }
                        if($qb=='no') {
                            $sno = 'selected';
                            $syes = '';
                        }

                        if(!empty($_GET['qb_profile'])) {
                            $qb_profile = $_GET['qb_profile'];
                        } else {
                            $qb_profile = 2;
                        }

                        $ptSQL = "SELECT * FROM patient WHERE patient_id = '".$rowT['patient_id']."' AND Agency = '$agency_code'";
                        $ptResult = get_custom_query_data($ptSQL, 'row');
                        $ID2 = $ptResult['DistrictID_Ref'];
                        $med_medicaidno = trim($ptResult['med_medicaidno']);

                        $distSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$ID2' AND Agency = '$agency_code'" ;
                        $distResult = get_custom_query_data($distSQL, 'row');
                        $ParentRef_FullName = $distResult['ParentRef_FullName'];

                        $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                        $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                        if($qb_profile==2) {
                            if(empty($findResult)) {
                                $allow = true;
                                $nex++;
                            } else {
                                $allow = false;
                            }
                        }
                        if($qb_profile==1) {
                            if(!empty($findResult)) {
                                $allow = true;
                            } else {
                                $allow = false;
                            }                    
                        }

                        if($allow===true) {
                            $params[0] = $rowT['cms1500_id'];
                            $params[1] = '<select name="qb" class="qb" style="width:72px;height:30px;margin-bottom:5px;border:1px solid #fff;color: #fff; border-radius: 2px;background:#F781F3;" data-id="'.$rowT['cms1500_id'].'"><option value="" '.$sno.'>No</option><option value="yes" '.$syes.'>Yes</option></select>';
                            $params[2] = '<a target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$rowT['"2-PatientName"'].'</a>';
                            $params[3] = $rowT['"Insurance Company Name"'];
                            $params[4] = $rowT['"24.1.a-DOSFrom"'];
                            $params[5] = $rowT['"24.1.a-DOSTo"'];
                            $params[6] = $rowT['"24.1.f-Charges"'];
                            $params[7] = $rowT['"24.1.g-Units"'];
                            $params[8] = $rowT['"28-TotalCharge"'];
                            $params[9] = number_format(floatvalue($rowT[$col170]), 2, '.', '');                    
                        }                
                    }
                    if(!empty($params)) {
                        $datas[$i] = $params;  
                        $i++;                        
                    }
                }
            }
            $recordsTotal = $totalRec;
            $recordsFiltered = $recordsTotal;
            
            if($i>10) {
                if(isset($_POST['start'])) {
                    $z = $_POST['start'];
                    $limitt = $z+10;
                    $y = 0;
                    for ($z; $z<$limitt; $z++) { 
                        $data[$y] = $datas[$z];
                        $y++;
                    }
                }
            } else {
                $data = $datas;
            }
        }

        if($qbviewmode==1) {
            $i = 0;
            $checkPatientCount = []; $tamt = 0;
            foreach ($resT as $keyT => $rowT) {
                $qb_profile = 2;
                $ptSQL = "SELECT * FROM patient WHERE patient_id = '".$rowT['patient_id']."' AND Agency = '".$agency_code."'";
                $ptRow = get_custom_query_data($ptSQL, 'row');
                $med_medicaidno = trim($ptRow['med_medicaidno']);
                $ParentRef_FullName = $rowT['ParentRef_FullName'];

                $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                $allow = false;
                if(empty($findResult)) {
                    $allow = true;
                }

                if($allow===true) {
                    $totalRec++;

                    array_push($checkPatientCount, $rowT['patient_id']);

                    $amt = number_format(floatvalue($rowT['totalIA']), 2, '.', '');
                    $tamt = $tamt + $amt;

                    $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '".$agency_code."' AND mco = 1 AND DistrictID = '".$rowT['mco']."'";
                    $districtData = $this->Comman_model->getCustomQueryData($strSQL, 'row');
                    $disName = $districtData['DistrictName'].' ('.$districtData['DistrictNumber'].')';

                    $memberid = $rowT[$col011];
                    if ($memberid!='') { $inv = $memberid.'/'.$rowT['patient_id']; } else { $inv = $memberid; }
                    
                    if(!empty($rowT[$col087])) {
                        $pa = $rowT[$col087];    
                    } else {
                        $sqlp = "SELECT * FROM patient_auth_history where patient_id = '".$rowT['patient_id']."' ORDER BY patient_auth_history_id DESC";
                        $rowp = get_custom_query_data($sqlp, 'row');
                        $pa = $rowp["authorization"];      
                    }
                    $dosfrom = $rowT[$col088]; 
                    $units = (float)$rowT['"24.1.g-Units"'] + (float)$rowT['"24.2.g-Units"'] + (float)$rowT['"24.3.g-Units"'] + (float)$rowT['"24.4.g-Units"'] + (float)$rowT['"24.5.g-Units"'] + (float)$rowT['"24.6.g-Units"'];

                    $params = [];
                    
                    $params[0] = $rowT['cms1500_id'];
                    $params[1] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$rowT['patient_id'].'" title="Edit record..">'.$rowT['"2-PatientName"'].'</a>';
                    $params[2] = $disName;
                    $params[3] = $rowT[$col070];
                    $params[4] = $inv;
                    $params[5] = '<p title="'.$rowT[$col166].' | '.$rowT[$col200].'">'.$rowT[$col168].'</p>';
                    $params[6] = $pa;
                    $params[7] = $rowT[$col014];
                    $params[8] = $dosfrom;
                    $params[9] = $rowT['"28-TotalCharge"'];
                    $params[10] = $units;
                    $params[11] = '<button type="button" class="btn-info mco-view" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" title="" id="'.$rowT['cms1500_id'].'" data-month="'.$month.'" data-year="'.$year.'">View</button>';
                    
                    if(!empty($params)) {
                        $datas[$i] = $params;  
                        $i++;                        
                    }
                }
            }

            $tcnt = count(array_unique($checkPatientCount));
            $amt = number_format(floatvalue($tamt), 2, '.', '');

            $lblTotal = "</br><p class='normal'> Total Clients: ".$tcnt."&nbsp; &nbsp; &nbsp; Total Invoice Amount: ".$amt;

            $recordsTotal = $totalRec;
            $recordsFiltered = $recordsTotal;
            $sql = $sqlT;
            
            if($i>10) {
                if(isset($_POST['start'])) {
                    $z = $_POST['start'];
                    $limitt = $z+10;
                    $y = 0;
                    for ($z; $z<$limitt; $z++) { 
                        $data[$y] = $datas[$z];
                        $y++;
                    }
                }
            } else {
                $data = $datas;
            }
        }
        
        $nex = 0;
        if($viewmode!=33 && $qbviewmode==0) {
            foreach ($res as $key => $row) {
                $strSQL = "SELECT * FROM tbldistricts WHERE Agency = '".$agency_code."' AND mco = 1 AND DistrictID = '".$row['mco']."'";
                $districtData = $this->Comman_model->getCustomQueryData($strSQL, 'row');
                $disName = $districtData['DistrictName'].' ('.$districtData['DistrictNumber'].')';

                $memberid = $row[$col011];
                if ($memberid!='') { $inv = $memberid.'/'.$row['patient_id']; } else { $inv = $memberid; }
                
                if(!empty($row[$col087])) {
                    $pa = $row[$col087];    
                } else {
                    $sqlp = "SELECT * FROM patient_auth_history where patient_id = '".$row['patient_id']."' ORDER BY patient_auth_history_id DESC";
                    $rowp = get_custom_query_data($sqlp, 'row');
                    $pa = $rowp["authorization"];      
                }
                $dosfrom = $row[$col088]; 
                $units = (float)$row['"24.1.g-Units"'] + (float)$row['"24.2.g-Units"'] + (float)$row['"24.3.g-Units"'] + (float)$row['"24.4.g-Units"'] + (float)$row['"24.5.g-Units"'] + (float)$row['"24.6.g-Units"'];

                $params = [];
                if($viewmode==1) {
                    $params[0] = $row['cms1500_id'];
                    $params[1] = '<a class="'.$acolor.'" target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$row['"2-PatientName"'].'</a>';
                    $params[2] = $disName;
                    $params[3] = $row[$col070];
                    $params[4] = $inv;
                    $params[5] = '<p title="'.$row[$col166].' | '.$row[$col200].'">'.$row[$col168].'</p>';
                    $params[6] = $pa;
                    $params[7] = $row[$col014];
                    $params[8] = $dosfrom;
                    $params[9] = $row['"28-TotalCharge"'];
                    $params[10] = $units;
                    $params[11] = '<button type="button" class="btn-info mco-view" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" title="" id="'.$row['cms1500_id'].'" data-month="'.$month.'" data-year="'.$year.'">View</button>';
                }

                if($viewmode==2) {
                    $qb =  $row['qb'];
                    $syes = $sno = '';
                    if($qb=='yes') {
                        $syes = 'selected';
                        $sno = '';
                    }
                    if($qb=='no') {
                        $sno = 'selected';
                        $syes = '';
                    }

                    $params[0] = $row['cms1500_id'];
                    $params[1] = '<select name="qb" class="qb" style="width:72px;height:30px;margin-bottom:5px;border:1px solid #fff;color: #fff; border-radius: 2px;background:#F781F3;" data-id="'.$row['cms1500_id'].'"><option value="" '.$sno.'>No</option><option value="yes" '.$syes.'>Yes</option></select>';
                    //$params[2] = '<a target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$row['"2-PatientName"'].'</a>';
                    $params[2] = '<a target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$row['"2-PatientName"'].'</a><p><small>'.$row['uploadtime'].'</small></p>';

                    $params[3] = $row['"Insurance Company Name"'];
                    $params[4] = $row['"24.1.a-DOSFrom"'];
                    $params[5] = $row['"24.1.a-DOSTo"'];
                    $params[6] = $row['"24.1.f-Charges"'];
                    $params[7] = $row['"24.1.g-Units"'];
                    $params[8] = $row['"28-TotalCharge"'];
                    $params[9] = number_format(floatvalue($row[$col170]), 2, '.', '');
                    $params[10] = '<a href="javascript:void(0)" class="white billed-reverse" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" title="" id="'.$row['cms1500_id'].'" data-month="'.$month.'" data-year="'.$year.'">Billed</a> ';
                }

                if($viewmode==3) {
                    $qb =  $row['qb'];
                    $syes = $sno = '';
                    if($qb=='yes') {
                        $syes = 'selected';
                        $sno = '';
                    }
                    if($qb=='no') {
                        $sno = 'selected';
                        $syes = '';
                    }

                    $params[0] = $row['cms1500_id'];
                    $params[1] = '<select name="qb" class="qb" style="width:72px;height:30px;margin-bottom:5px;border:1px solid #fff;color: #fff; border-radius: 2px;background:#F781F3;" data-id="'.$row['cms1500_id'].'"><option value="" '.$sno.'>No</option><option value="yes" '.$syes.'>Yes</option></select>';
                    //$params[2] = '<a target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$row['"2-PatientName"'].'</a>';
                    $params[2] = '<a target="_blank" href="'.base_url('admin/AddClient').'?patient='.$row['patient_id'].'" title="Edit record..">'.$row['"2-PatientName"'].'</a><p><small>'.$row['uploadtime'].'</small></p>';
                    $params[3] = $row['"Insurance Company Name"'].'<br><small>'.$row['username'].'</small>';
                    $params[4] = $row['"24.1.a-DOSFrom"'];
                    $params[5] = $row['"24.1.a-DOSTo"'];
                    $params[6] = $row['"24.1.f-Charges"'];
                    $params[7] = $row['"24.1.g-Units"'];
                    $params[8] = $row['"28-TotalCharge"'];
                    $params[9] = number_format(floatvalue($row[$col170]), 2, '.', '');

                    $sqlre = "SELECT status FROM eclaims_detailsLTS WHERE cms1500_id = '".$row['cms1500_id']."'";
                    $rowre = get_custom_query_data($sqlre, 'row');
                    if($rowre['status']=='Unbilled') {
                        $params[10] = '<a href="javascript:void(0)" class="white billed-reverse" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" title="" id="'.$row['cms1500_id'].'" data-month="'.$month.'" data-year="'.$year.'"><strong style="color: #000000;">Unbilled</strong></a>';
                    } else {
                        $params[10] = '<a href="javascript:void(0)" class="white billed-reverse reverse" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="left" title="" id="'.$row['cms1500_id'].'" data-month="'.$month.'" data-year="'.$year.'">Reverse</a>';
                    }
                }
                
                if(!empty($params)) {
                    $data[$key] = $params;
                }
            }
        }

        $response = [];
        $response['draw'] = intval($_REQUEST['draw']);
        $response['recordsTotal'] = intval($recordsTotal);
        $response['recordsFiltered'] = intval($recordsFiltered);
        $response['data'] = $data;
        $response['lblTotal'] = $lblTotal;
        $response['sql'] = $sql;
        
        print_r(json_encode($response));        
    }

    function updateImpact() {
        $imapctId = $TIN = "";
        $interagency = @$_POST['InterAgency'];
        $DistrictID_Ref2 = @$_POST['DistrictID_Ref2'];
        $agency_code = @$_POST['agency_code'];
        $action = @$_POST['action'];
        $month = @$_POST['month'];
        $year = @$_POST['year'];

        if(!empty($_POST['params']) && !empty($action) && $action=='selected') {
            $params = rtrim($_POST['params'], '|');
            $cms1500Ids = explode('|', $params);
            if(!empty($cms1500Ids)) {
                if($interagency!='') {
                    $updateCheck = false;
                    foreach ($cms1500Ids as $key => $cms1500Id) {
                        $sqlD = "SELECT mco from cms1500LTS WHERE cms1500_id = '".$cms1500Id."'";
                        $rowD = get_custom_query_data($sqlD, 'row');

                        $sqlD = "SELECT * from tbldistricts WHERE DistrictID = '".$rowD['mco']."'";
                        $rowD = get_custom_query_data($sqlD, 'row');
                        $imapctId  = $rowD['Impactid'];
                        $TIN  = $rowD['TIN'];                

                        $sql = "UPDATE cms1500LTS SET `$col178` = '$TIN', `$col200` = '$imapctId' WHERE cms1500_id = '$cms1500Id'";
                        set_custom_query_data($sql);
                        $updateCheck = true;
                    }
                    if($updateCheck) {
                        $this->session->set_flashdata('message','Records has been updated successfully.');
                        print_r(1);
                    }
                } else {
                    if(!empty($DistrictID_Ref2) && $DistrictID_Ref2!='888') {
                        $ID2 = $DistrictID_Ref2;
                        $distSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$ID2' AND Agency = '$agency_code'" ;
                        $row = get_custom_query_data($distSQL, 'row');
                        $imapctId  = $row['Impactid'];
                        $TIN  = $row['TIN'];

                        $col178 = '"25-TaxID"';
                        $col200 = '"33-b-GrpLegacyNo"';
                        $updateCheck = false;

                        foreach ($cms1500Ids as $key => $cms1500Id) {
                            $sql = "UPDATE cms1500LTS SET `$col178` = '$TIN', `$col200` = '$imapctId' WHERE cms1500_id = '$cms1500Id'";
                            set_custom_query_data($sql);
                            $updateCheck = true;
                        }
                        if($updateCheck) {
                            $this->session->set_flashdata('message','Records has been updated successfully.');
                            print_r(1);
                        }
                    } else {
                        $this->session->set_flashdata('error_message','Please select District/MCO to update.');
                        print_r(0);
                    }
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record to update.');
                print_r(0);
            }
        }

        if(!empty($action) && $action=='all') {
            $col178 = '"25-TaxID"';
            $col200 = '"33-b-GrpLegacyNo"';
            $updateCheck = false;
            $sql = "SELECT cms1500LTS.cms1500_id, tbldistricts.Impactid, tbldistricts.TIN FROM cms1500LTS,tbldistricts WHERE tbldistricts.DistrictID = cms1500LTS.mco AND cms1500LTS.month = '$month' AND cms1500LTS.year = '$year' AND cms1500LTS.Agency = '$agency_code' AND tbldistricts.InterAgency = '$interagency' AND tbldistricts.Agency = '$agency_code'";
            $res = $this->Comman_model->getCustomQueryData($sql);
            foreach ($res as $key => $row) {
                $imapctId  = $row['Impactid'];
                $TIN  = $row['TIN'];
                // code...
                $cms1500Id = $row['cms1500_id'];
                $sql = "UPDATE cms1500LTS SET `$col178` = '$TIN', `$col200` = '$imapctId' WHERE cms1500_id = '$cms1500Id'";
                set_custom_query_data($sql);
                $updateCheck = true;
            }
            if($updateCheck) {
                $this->session->set_flashdata('message','Records has been updated successfully.');
                print_r(1);
            } else {
                $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
                print_r(0);    
            }
        }
    }

    function updateQbStatusByTimestamp() {
        if (!empty($_POST['qb_value']) && $_POST['qb_value']!='NA' && !empty($_POST['month']) && !empty($_POST['year'])) {
            $qb2        = $_POST['qb_value'];
            $month      = $_POST['month'];
            $year       = $_POST['year'];
            $Agency     = $_POST['agency_code'];
            $ftimestamp  = $_POST['ftimestamp'];
            $ttimestamp  = $_POST['ttimestamp'];

            $ftimestamp = str_replace('+', ' ', $ftimestamp);
            $ttimestamp = str_replace('+', ' ', $ttimestamp);

            if ($qb2=='no')  { $qb2 = ''; }
            //if ($qb2=='yes')  { $qb2 = 'yes'; }            
            if(!empty($ftimestamp) && empty($ttimestamp)) {
                $query7 = "UPDATE eclaimsLTS SET `qb` = '$qb2' WHERE month = '$month' AND year = '$year' AND Agency = '$Agency' AND paid = 0 AND uploadtime = '".$ftimestamp."'";                
            } elseif(!empty($ftimestamp) && !empty($ttimestamp)) {
                $query7 = "UPDATE eclaimsLTS SET `qb` = '$qb2' WHERE month = '$month' AND year = '$year' AND Agency = '$Agency' AND paid = 0 AND uploadtime >= '".$ftimestamp."' AND uploadtime <= '".$ttimestamp."'";
            } else {
                $query7 = "UPDATE eclaimsLTS SET `qb` = '$qb2' WHERE month = '$month' AND year = '$year' AND Agency = '$Agency' AND paid = 0";
            }

            set_custom_query_data($query7);
            print_r(1);
        } else {
            print_r(0);
        }
    }

    function updateQbStatusAll() {
        if (!empty($_POST['qb_value']) && !empty($_POST['month']) && !empty($_POST['year'])) {
            $qb2    = $_POST['qb_value'];
            $month  = $_POST['month'];
            $year   = $_POST['year'];
            $Agency   = $_POST['agency_code'];
            if ($qb2=='no')  { $qb2 = ''; }
            if ($qb2=='yes')  { $qb2 = 'yes'; }
            $query7 = "UPDATE eclaimsLTS SET `qb` = '$qb2' WHERE month = '$month' AND year = '$year' AND paid = 0 AND Agency = '$Agency'";
            set_custom_query_data($query7);
            print_r(1);
        } else {
            print_r(0);
        }
    }

    function updateQbStatus() {
        if (!empty($_POST['cms1500id'])) {
            $qb = $_POST['qb'];
            $recno = $_POST['cms1500id'];
            $query7 = "UPDATE eclaimsLTS SET `qb` = '$qb' WHERE cms1500_id = '$recno'";
            set_custom_query_data($query7);
            print_r(1);
        } else {
            print_r(0);
        }
    }

    function deleteRecords() {
        $params = $_POST['params'];        
        $viewmode = $_POST['viewmode'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $nbatchno = $_POST['nbatchno'];
        $action = $_POST['action'];
        if(!empty($params) && !empty($viewmode) && !empty($action) && $action=='selected') {
            $params = rtrim($params, '|');
            $cms1500Ids = explode('|', $params);
            //$cms1500Ids = implode(',', $cms1500Ids);

            $table = 'cms1500LTS' ;
            $table2 = 'cms1500_detailsLTS' ;
            if($viewmode>=2) {
                $table = 'eclaimsLTS';
                $table2 = 'eclaims_detailsLTS';
            }

            if(!empty($cms1500Ids)) {
                $updateCheck = false;
                foreach ($cms1500Ids as $key => $cms1500Id) {
                    if ($viewmode == 1  || $viewmode == 3 )  {
                        $query = "DELETE FROM `$table` WHERE cms1500_id = '$cms1500Id'";
                        set_custom_query_data($query);
                        $query = "DELETE FROM `$table2` WHERE cms1500_id = '$cms1500Id'";
                        set_custom_query_data($query);
                        //$postcomment = "Patient EDI Records deleted with Record No.".$cms1500Id; 
                        //include("postlog.php");
                    }
                    if ($viewmode == 2) {
                        $query = "DELETE FROM eclaimsLTS WHERE cms1500_id = '$cms1500Id'";
                        set_custom_query_data($query);
                        $query = "DELETE FROM eclaims_detailsLTS WHERE cms1500_id = '$cms1500Id'";
                        set_custom_query_data($query);
                        //$postcomment = "Patient EDI Records deleted with Record No.".$cms1500Id; 
                        //include("postlog.php");
                    }
                    if ($viewmode==2) {
                        $paid = 3;                               
                        $query = "UPDATE eclaimsLTS SET `paid` = '$paid' WHERE cms1500_id = '$cms1500Id'";
                        set_custom_query_data($query);
                    }
                    $updateCheck = true;
                }
                if($updateCheck) {
                    $this->session->set_flashdata('message','Selected records has been deleted successfully.');
                    print_r(1);
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record to update.');
                print_r(0);
            }
        } elseif(!empty($viewmode) && !empty($action) && $action=='all' && !empty($month) && !empty($year) && !empty($agency_code)) {
            $table = 'cms1500LTS' ;
            $table2 = 'cms1500_detailsLTS' ;
            $cond = "";
            if($viewmode>=2) {
                $table = 'eclaimsLTS';
                $table2 = 'eclaims_detailsLTS';
                $cond = " AND eclaimsLTS.qb=''";
            }
            if($viewmode==3) {
                $cond = " AND eclaimsLTS.qb='yes'";
            }

            if(!empty($nbatchno)) {
                $cond .= " AND $table.batchno = '".$nbatchno."'";    
            }

            $updateCheck = false;
            $sql = "SELECT $table.cms1500_id FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '$month' AND $table.year = '$year' AND $table.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'".$cond."";
            $res = $this->Comman_model->getCustomQueryData($sql);

            $cms1500_ids = array_column($res, 'cms1500_id');
            $cms1500_ids = implode(',', $cms1500_ids);

            if(!empty($cms1500_ids)) {

                if ($viewmode==1) {
                    $query = "DELETE FROM cms1500LTS WHERE cms1500_id IN(".$cms1500_ids.")";
                    set_custom_query_data($query);
                    $query = "DELETE FROM cms1500_detailsLTS WHERE cms1500_id IN(".$cms1500_ids.")";
                    set_custom_query_data($query);

                    $updateCheck = true;
                }

                if ($viewmode==2 || $viewmode==3) {
                    $query = "DELETE FROM eclaimsLTS WHERE cms1500_id IN(".$cms1500_ids.")";
                    set_custom_query_data($query);
                    $query = "DELETE FROM eclaims_detailsLTS WHERE cms1500_id IN(".$cms1500_ids.")";
                    set_custom_query_data($query);

                    $updateCheck = true;
                }

                /*foreach ($cms1500_ids as $key => $cms1500_id) {
                    if ($viewmode == 1) {
                        $query = "DELETE FROM cms1500LTS WHERE cms1500_id = '$cms1500_id'";
                        set_custom_query_data($query);
                        $query = "DELETE FROM cms1500_detailsLTS WHERE cms1500_id = '$cms1500_id'";
                        set_custom_query_data($query);
                    }

                    if ($viewmode==2) {
                        $query = "DELETE FROM eclaimsLTS WHERE cms1500_id = '$cms1500_id'";
                        set_custom_query_data($query);
                        $query = "DELETE FROM eclaims_detailsLTS WHERE cms1500_id = '$cms1500_id'";
                        set_custom_query_data($query);
                    }

                    if ($viewmode==3) {
                        $query = "DELETE FROM eclaimsLTS WHERE cms1500_id = '$cms1500_id'";
                        set_custom_query_data($query);
                        $query = "DELETE FROM eclaims_detailsLTS WHERE cms1500_id = '$cms1500_id'";
                        set_custom_query_data($query);
                    }

                    if ($viewmode==2) {
                        $paid = 3;                               
                        $query = "UPDATE eclaimsLTS SET `paid` = '$paid' WHERE cms1500_id = '$cms1500_id'";
                        set_custom_query_data($query);
                    }
                    $updateCheck = true;
                }*/
            }
            if($updateCheck) {
                $this->session->set_flashdata('message','All records has been deleted successfully.');
                print_r(1);
            }            
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function saveMiClaim() {
        $action = $_POST['action'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];

        if(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code)) {

            $cond = "";
            $payorgroup = $_POST['payorgroup'];
            if($payorgroup!='') {
                $cond = " AND tbldistricts.payorGrp = '".$payorgroup."'";
            }

            $table = "cms1500LTS";
            $sql = "SELECT DISTINCT $table.mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '$month' AND $table.year = '$year' AND $table.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'$cond";
            $mcoresult = $this->Comman_model->getCustomQueryData($sql);

            if(!empty($mcoresult)) {
                if ($agency_code == 1 ) {$agentdir =  "HOMEMAKERS/"; }
                if ($agency_code == 2 ) {$agentdir =  "SENIORCARES/"; }
                if ($agency_code == 3 ) {$agentdir =  "CAREGIVERS/"; }
                if ($agency_code == 4 ) {$agentdir =  "ROCKFORD/"; }
            }
            foreach ($mcoresult as $key => $mcorow) {
                $District = "Invalid District";
                $mco = $mcorow['mco'];    
                $strSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$mco' AND Agency = '$agency_code'" ;
                $objResult = get_custom_query_data($strSQL, 'row');
                if (!empty($objResult)) {
                    $District = 'District '.$objResult['DistrictNumber'];
                    $InsuranceCompanyName = $objResult['DistrictName'];
                }

                /*if ($agency_code == 2 || $agency_code == 4) {
                    $sql = "SELECT * FROM cms1500LTS WHERE month = '$month'  AND year = '$year' AND Agency = '$agency_code' AND mco = '$mco' AND username = '$USERCODE' ";
                } else {
                    $sql = "SELECT * FROM cms1500LTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND mco = '$mco'  AND username = '$USERCODE' ";    
                } */

                $sql = "SELECT * FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '$month' AND $table.year = '$year' AND $table.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code' AND $table.mco = '$mco' AND $table.username = '$USERCODE'$cond";
                $flag = false;
                $row2 = 0;
                $counter = 0;
                $arry = array(' ',' ',' ',' ');
                $temptime = date("Y-m-d H:i:s");
                $result = get_custom_query_data($sql);
              
                foreach ($result as $key => $row) {
                    $cms_id2 = $row['cms1500_id'];
                    $uploadtime = $temptime;
                    // For All Records
                    if(!empty($action) && $action=='all') {
                        if(!$flag) {
                            $stringData = array_keys($row);
                            for ($cnt=5;$cnt<=200;$cnt++) {
                                //$str  = $str + ($stringData[$cnt] + ',');
                                if ($cnt < 200)  {    
                                    //fwrite($fh, $stringData[$cnt].",");
                                } else {
                                    //fwrite($fh, $stringData[$cnt]);   
                                }  
                            }
                            //fwrite($fh,Chr(13).Chr(10));
                            $flag = true;
                        } else {
                            $counter++;
                            $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                            $cms_id = $row['cms1500_id'];
                        }

                        $where = [];
                        $where['cms1500_id'] = $cms_id2;

                        $dataArray = [];
                        $dataArray['uploadtime'] = $uploadtime;
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_id'] = $this->session->userdata('id');

                        updateHelper('cms1500LTS', $where, $dataArray);


                        $where = [];
                        $where['cms1500_id'] = $cms_id2;

                        $dataArray = [];
                        $dataArray['status'] = 'Billed';

                        updateHelper('cms1500_detailsLTS', $where, $dataArray);


                        $query = "INSERT INTO eclaimsLTS  SELECT * FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";  
                        set_custom_query_data($query);

                        $query = "INSERT INTO eclaims_detailsLTS   SELECT cms1500_details_id IS NULL, cms1500_id,date,bill,units,start_date,flag,utotal,Agency,paid,amount,status,remarks,month,year,patient_id,employee_id FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2' ";
                        set_custom_query_data($query);

                        $query = "DELETE FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2'";
                        set_custom_query_data($query);

                        $query = "DELETE FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";
                        set_custom_query_data($query);

                        $_SESSION['rxx'][$cms_id2] = 'Yes';

                        $postcomment = "Patient EDI Records UPLOADED with Record No.".$cms_id; 
                        include("postlog.php");

                        $x = 1;
                        $stringData = array_values($row);  
                        $stringData = array_values($row);

                        for ($cnt=5;$cnt<=200;$cnt++) {
                            if ($cnt < 200)  {    
                                //fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                            } else {
                                //fwrite($fh, '"'.$stringData[$cnt].'"');   
                            }  
                        }
                        //fwrite($fh,Chr(13).Chr(10));      
                    }
                    // For Selected Records
                    if(!empty($action) && $action=='selected') {
                        $params = $_POST['params'];
                        $params = rtrim($params, '|');
                        $cms1500Ids = explode('|', $params);
                        if (in_array($cms_id2, $cms1500Ids)) {    
                            if(!$flag) {
                                $stringData = array_keys($row);
                                for ($cnt=5;$cnt<=200;$cnt++) {
                                    //$str  = $str + ($stringData[$cnt] + ',');
                                    if ($cnt < 200)  {    
                                        //fwrite($fh, $stringData[$cnt].",");
                                    } else {
                                        //fwrite($fh, $stringData[$cnt]);   
                                    }  
                                }
                                //fwrite($fh,Chr(13).Chr(10));
                                $flag = true;
                            } else {
                                $counter++;
                                $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                                $cms_id = $row['cms1500_id'];
                            }

                            $where = [];
                            $where['cms1500_id'] = $cms_id2;

                            $dataArray = [];
                            $dataArray['uploadtime'] = $uploadtime;
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_id'] = $this->session->userdata('id');

                            updateHelper('cms1500LTS', $where, $dataArray);


                            $where = [];
                            $where['cms1500_id'] = $cms_id2;

                            $dataArray = [];
                            $dataArray['status'] = 'Billed';

                            updateHelper('cms1500_detailsLTS', $where, $dataArray);


                            $query = "INSERT INTO eclaimsLTS  SELECT * FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";  
                            set_custom_query_data($query);

                            $query = "INSERT INTO eclaims_detailsLTS   SELECT cms1500_details_id IS NULL, cms1500_id,date,bill,units,start_date,flag,utotal,Agency,paid,amount,status,remarks,month,year,patient_id,employee_id FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2' ";
                            set_custom_query_data($query);

                            $query = "DELETE FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2'";
                            set_custom_query_data($query);

                            $query = "DELETE FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";
                            set_custom_query_data($query);
                            $postcomment = "Patient EDI Records UPLOADED with Record No.".$cms_id; 
                            include("postlog.php");

                            $x = 1;
                            $stringData = array_values($row);  
                            $stringData = array_values($row);

                            for ($cnt=5;$cnt<=200;$cnt++) {
                                if ($cnt < 200)  {    
                                    //fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                                } else {
                                    //fwrite($fh, '"'.$stringData[$cnt].'"');   
                                }  
                            }
                            //fwrite($fh,Chr(13).Chr(10));      
                        } 
                    }
                }
            }
            print_r(1);
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function saveClaimMD() {
        $action = $_POST['action'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];

        if(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code)) {

            $cond = "";
            $payorgroup = $_POST['payorgroup'];
            if($payorgroup!='') {
                $cond = " AND tbldistricts.payorGrp = '".$payorgroup."'";
            }            

            $table = "cms1500LTS";
            $sql = "SELECT DISTINCT $table.mco FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '$month' AND $table.year = '$year' AND $table.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'$cond";
            $mcoresult = $this->Comman_model->getCustomQueryData($sql);
            if(!empty($mcoresult)) {
                if ($agency_code == 1 ) {$agentdir =  "HOMEMAKERS/"; }
                if ($agency_code == 2 ) {$agentdir =  "SENIORCARES/"; }
                if ($agency_code == 3 ) {$agentdir =  "CAREGIVERS/"; }
                if ($agency_code == 4 ) {$agentdir =  "ROCKFORD/"; }
            }
            foreach ($mcoresult as $key => $mcorow) {
                $District = "Invalid District";
                $mco = $mcorow['mco'];    
                $strSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$mco' AND Agency = '$agency_code'" ;
                $objResult = get_custom_query_data($strSQL, 'row');
                if (!empty($objResult)) {
                    $District = 'District '.$objResult['DistrictNumber'];
                    $InsuranceCompanyName = $objResult['DistrictName'];
                }

                /*if ($agency_code == 2 || $agency_code == 4) {
                    $sql = "SELECT * FROM cms1500LTS WHERE month = '$month'  AND year = '$year' AND Agency = '$agency_code' AND mco = '$mco' AND username = '$USERCODE' ";
                } else {
                    $sql = "SELECT * FROM cms1500LTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND mco = '$mco'  AND username = '$USERCODE' ";    
                }*/ 

                $sql = "SELECT * FROM $table,tbldistricts WHERE tbldistricts.DistrictID = $table.mco AND $table.month = '$month' AND $table.year = '$year' AND $table.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code' AND $table.mco = '$mco' AND $table.username = '$USERCODE'$cond";

                $flag = false;
                $row2 = 0;
                $counter = 0;
                $arry = array(' ',' ',' ',' ');     
                $temptime = date("Y-m-d H:i:s");           
                $result = $this->Comman_model->getCustomQueryData($sql);
              
                foreach ($result as $key => $row) {
                    $cms_id2 = $row['cms1500_id'];
                    $uploadtime = $temptime;

                    // For All Records
                    if(!empty($action) && $action=='all') {
                        if(!$flag) {
                            $stringData = array_keys($row);
                            for ($cnt=5;$cnt<=200;$cnt++) {
                                //$str  = $str + ($stringData[$cnt] + ',');
                                if ($cnt < 200)  {    
                                    //fwrite($fh, $stringData[$cnt].",");
                                } else {
                                    //fwrite($fh, $stringData[$cnt]);   
                                }  
                            }
                            //fwrite($fh,Chr(13).Chr(10));
                            $flag = true;
                        } else {
                            $counter++;
                            $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                            $cms_id = $row['cms1500_id'];
                        }

                        $where = [];
                        $where['cms1500_id'] = $cms_id2;

                        $dataArray = [];
                        $dataArray['uploadtime'] = $uploadtime;
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_id'] = $this->session->userdata('id');

                        updateHelper('cms1500LTS', $where, $dataArray);


                        $where = [];
                        $where['cms1500_id'] = $cms_id2;

                        $dataArray = [];
                        $dataArray['status'] = 'Billed';

                        updateHelper('cms1500_detailsLTS', $where, $dataArray);


                        $query = "INSERT INTO eclaimsLTS  SELECT * FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";  
                        set_custom_query_data($query);

                        $query = "INSERT INTO eclaims_detailsLTS   SELECT cms1500_details_id IS NULL, cms1500_id,date,bill,units,start_date,flag,utotal,Agency,paid,amount,status,remarks,month,year,patient_id,employee_id FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2' ";
                        set_custom_query_data($query);

                        $query = "DELETE FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2'";
                        set_custom_query_data($query);

                        $query = "DELETE FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";
                        set_custom_query_data($query);

                        $_SESSION['rxx'][$cms_id2] = 'Yes';

                        $postcomment = "Patient EDI Records UPLOADED with Record No.".$cms_id; 
                        include("postlog.php");

                        $x = 1;
                        $stringData = array_values($row);  
                        $stringData = array_values($row);

                        for ($cnt=5;$cnt<=200;$cnt++) {
                            if ($cnt < 200)  {    
                                //fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                            } else {
                                //fwrite($fh, '"'.$stringData[$cnt].'"');   
                            }  
                        }
                        //fwrite($fh,Chr(13).Chr(10));      
                    }

                    // For Selected Records
                    if(!empty($action) && $action=='selected') {
                        $params = $_POST['params'];
                        $params = rtrim($params, '|');
                        $cms1500Ids = explode('|', $params);
                        if (in_array($cms_id2, $cms1500Ids)) {    
                            if(!$flag) {
                                $stringData = array_keys($row);
                                for ($cnt=5;$cnt<=200;$cnt++) {
                                    //$str  = $str + ($stringData[$cnt] + ',');
                                    if ($cnt < 200)  {    
                                        //fwrite($fh, $stringData[$cnt].",");
                                    } else {
                                        //fwrite($fh, $stringData[$cnt]);   
                                    }  
                                }
                                //fwrite($fh,Chr(13).Chr(10));
                                $flag = true;
                            } else {
                                $counter++;
                                $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                                $cms_id = $row['cms1500_id'];
                            }

                            $where = [];
                            $where['cms1500_id'] = $cms_id2;

                            $dataArray = [];
                            $dataArray['uploadtime'] = $uploadtime;
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_id'] = $this->session->userdata('id');

                            updateHelper('cms1500LTS', $where, $dataArray);


                            $where = [];
                            $where['cms1500_id'] = $cms_id2;

                            $dataArray = [];
                            $dataArray['status'] = 'Billed';

                            updateHelper('cms1500_detailsLTS', $where, $dataArray);


                            $query = "INSERT INTO eclaimsLTS  SELECT * FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";  
                            set_custom_query_data($query);

                            $query = "INSERT INTO eclaims_detailsLTS   SELECT cms1500_details_id IS NULL, cms1500_id,date,bill,units,start_date,flag,utotal,Agency,paid,amount,status,remarks,month,year,patient_id,employee_id FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2' ";
                            set_custom_query_data($query);

                            $query = "DELETE FROM cms1500_detailsLTS WHERE cms1500_id = '$cms_id2'";
                            set_custom_query_data($query);

                            $query = "DELETE FROM cms1500LTS WHERE cms1500_id = '$cms_id2'";
                            set_custom_query_data($query);
                            $postcomment = "Patient EDI Records UPLOADED with Record No.".$cms_id; 
                            include("postlog.php");

                            $x = 1;
                            $stringData = array_values($row);  
                            $stringData = array_values($row);

                            for ($cnt=5;$cnt<=200;$cnt++) {
                                if ($cnt < 200)  {    
                                    //fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                                } else {
                                    //fwrite($fh, '"'.$stringData[$cnt].'"');   
                                }  
                            }
                            //fwrite($fh,Chr(13).Chr(10));      
                        } 
                    }
                }
            }
            print_r(1);
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function generateEdiClaim() {
        $action = $_POST['action'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $viewmode = $_POST['viewmode'];
        $agency_code = $_POST['agency_code'];

        if(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code) && $action=='selected') {
            $params = $_POST['params'];
            $params = rtrim($params, '|');
            $cms1500Ids = explode('|', $params);

            if(!empty($cms1500Ids)) {
                $x=1; $check = true; $clientArr = [];
                foreach ($cms1500Ids as $key => $cms1500_id) {
                    $sql = "select * from eclaimsLTS where cms1500_id='".$cms1500_id."'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');                        
                    $clientArr[$cms1500_id] = $row['patient_id'];           
                }

                $vals = array_count_values($clientArr);
                $checkPatient = [];

                foreach ($cms1500Ids as $key => $cms1500_id) {
                    $LScheck = true;
                    $TotalCharge = 0;
                    $checkNoOfCharges = 0;
                    /********** Start 837p file generation code ************/
                    $sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id='".$cms1500_id."'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    if(empty($row['cms1500_id'])) {
                        continue;
                    }

                    $cond = "";
                    if($viewmode==1 || $viewmode==2) {
                        $cond = " AND qb = '' AND (eclaimsLTS.paid = 0 OR eclaimsLTS.paid = 3)";
                    }
                    if($viewmode==3) {
                        $cond = " AND qb = 'yes' AND (eclaimsLTS.paid = 0)";
                    }

                    $checkDates = [];
                    $Charges = [];
                    $Units = [];

                    $sql = "SELECT * FROM eclaimsLTS WHERE patient_id='".$row['patient_id']."' AND month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."'".$cond."";
                    $result = $this->Comman_model->getCustomQueryData($sql);
                    foreach ($result as $key1 => $value1) {
                        // code...
                        if(!empty($value1['"24.1.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.2.f-Charges"'])) {
                            $checkNoOfCharges++;    
                        }
                        if(!empty($value1['"24.3.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.4.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.5.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.6.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        $num = floatval(str_replace(",","",$value1['"28-TotalCharge"']));
                        $TotalCharge = $TotalCharge + $num;

                        if(!empty($value1['"24.1.a-DOSFrom"'])) {
                            if(in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.1.a-DOSFrom"']] = $Charges[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.f-Charges"'];
                                $Units[$value1['"24.1.a-DOSFrom"']] = $Units[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.1.a-DOSFrom"']);    
                                $Charges[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.f-Charges"'];
                                $Units[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.g-Units"'];
                            }                            
                        }

                        if(!empty($value1['"24.2.a-DOSFrom"'])) {
                            if(in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.2.a-DOSFrom"']] = $Charges[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.f-Charges"'];
                                $Units[$value1['"24.2.a-DOSFrom"']] = $Units[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.2.a-DOSFrom"']);    
                                $Charges[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.f-Charges"'];
                                $Units[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.3.a-DOSFrom"'])) {
                            if(in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.3.a-DOSFrom"']] = $Charges[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.f-Charges"'];
                                $Units[$value1['"24.3.a-DOSFrom"']] = $Units[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.3.a-DOSFrom"']);    
                                $Charges[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.f-Charges"'];
                                $Units[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.4.a-DOSFrom"'])) {
                            if(in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.4.a-DOSFrom"']] = $Charges[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.f-Charges"'];
                                $Units[$value1['"24.4.a-DOSFrom"']] = $Units[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.4.a-DOSFrom"']);    
                                $Charges[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.f-Charges"'];
                                $Units[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.5.a-DOSFrom"'])) {
                            if(in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.5.a-DOSFrom"']] = $Charges[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.f-Charges"'];
                                $Units[$value1['"24.5.a-DOSFrom"']] = $Units[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.5.a-DOSFrom"']);    
                                $Charges[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.f-Charges"'];
                                $Units[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.6.a-DOSFrom"'])) {
                            if(in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.6.a-DOSFrom"']] = $Charges[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.f-Charges"'];
                                $Units[$value1['"24.6.a-DOSFrom"']] = $Units[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.6.a-DOSFrom"']);    
                                $Charges[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.f-Charges"'];
                                $Units[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.g-Units"'];
                            }
                        }
                    }

                    if($checkNoOfCharges>6) {
                        $TotalCharge = number_format((float)$TotalCharge, 2, '.', '');
                    } else {
                        $num = floatval(str_replace(",","",$row['"28-TotalCharge"']));
                        $TotalCharge = number_format((float)$num, 2, '.', '');
                    }            

                    if(in_array($row['patient_id'], $checkPatient)) {
                        //continue;
                        $LScheck = false;
                    }

                    if (array_key_exists($row['patient_id'],$vals)) {
                        $LScount = $vals[$row['patient_id']];
                        array_push($checkPatient, $row['patient_id']);
                    }

                    //print_r($row);die;

                    $check = false;
                   
                    $linefeed="\n"; 
                    $infomsg="";
                    $errormsg="";

                    $check__count=0;
                    $claim__count=0;
                    $proc__count=0;
                    $charges=0;
                    $net__amount=0;
                    $total__NumberofIncludedSegments=0;


                    if($x==1) { // Write only once.

                        //$name = preg_replace('/[ ,]+/', '', $row['"2-PatientName"']);
                        //$name .= "-837p.txt";
                        $name = "837p.txt";
                        $url = FCPATH."/assets/edi/".$name;
                        $filename = $url;

                        $X12__811__File = fopen($filename,'w');
                        $ISA01__AuthorInfoQual="00";      
                        $ISA02__AuthorInformation=" ";
                        $ISA03__SecurityInfoQual="00";
                        $ISA04__SecurityInformation=" ";
                        $ISA05__InterchangeIDQual="ZZ";
                        $ISA06__InterchangeSenderID="AV09311993";
                        $ISA07__InterchangeIDQual="01";
                        $ISA08__InterchangeReceiverID="030240928";
                        $ISA09__InterchangeDate=date("ymd");
                        $ISA10__InterchangeTime=date("hm");
                        $ISA11__InterchangeStandardID="^";
                        $ISA12__InterchangeControlVersionID="00401";
                        $ISA13__InterchangeControlNumber="0".date("mdHi");
                        $ISA14__InterchangeAckRequested="1";
                        $ISA15__TestIndicator="P";        
                        $ISA16__SubElementSeperator=":";

                        fwrite($X12__811__File, "ISA*"
                            .$ISA01__AuthorInfoQual."*"
                            .$ISA02__AuthorInformation."*"
                            .$ISA03__SecurityInfoQual."*"
                            .$ISA04__SecurityInformation."*"
                            .$ISA05__InterchangeIDQual."*"
                            .$ISA06__InterchangeSenderID." *"
                            .$ISA07__InterchangeIDQual."*"
                            .$ISA08__InterchangeReceiverID." *"
                            .$ISA09__InterchangeDate."*"
                            .$ISA10__InterchangeTime."*"
                            .$ISA11__InterchangeStandardID."*"
                            .$ISA12__InterchangeControlVersionID."*"
                            .$ISA13__InterchangeControlNumber."*"
                            .$ISA14__InterchangeAckRequested."*"
                            .$ISA15__TestIndicator."*"
                            .$ISA16__SubElementSeperator
                            ."~".$linefeed);

                        $GS01__FunctionalIdentifierCode="HC";
                        $GS02__ApplicationSendersCode="AV01101957";
                        $GS03__ApplicationReceiversCode="030240928";
                        $GS04__GroupDate=date("Ymd");
                        $GS05__GroupTime=date("hm");
                        $GS06__GroupControlNumber="120264701";
                        $GS07__ResponsibleAgencyCode="X";
                        $GS08__VersionRelease="005010X222A1";

                        fwrite($X12__811__File, "GS*".
                            $GS01__FunctionalIdentifierCode."*".
                            $GS02__ApplicationSendersCode."*".
                            $GS03__ApplicationReceiversCode."*".
                            $GS04__GroupDate."*".
                            $GS05__GroupTime."*".
                            $GS06__GroupControlNumber."*".
                            $GS07__ResponsibleAgencyCode."*".
                            $GS08__VersionRelease.
                            "~".$linefeed);

                        $ST01__TransactionSetId="837";
                        $ST02__TransactionSetId="49731";
                        $ST02__TransactionSetControlNumber="005010X222A1";

                        fwrite($X12__811__File, "ST*".
                            $ST01__TransactionSetId."*".
                            $ST02__TransactionSetId."*".
                            $ST02__TransactionSetControlNumber.
                            "~".$linefeed);

                        $TransactionSegmentCount=1;

                        $BIG01 = "0019";
                        $BIG02 = "00";
                        $BIG03 = "202647";
                        $BIG04 = "20210818";
                        $BIG05 = "0939";
                        $BIG06 = "CH";

                        fwrite($X12__811__File, "BHT*".$BIG01."*".$BIG02."*".$BIG03."*".$BIG04."*".$BIG05."*".$BIG06."~".$linefeed);

                        $TransactionSegmentCount=1;
                        $NM101="41";
                        $NM102="2";
                        $NM103 = "ANVICARE";
                        $NM104 = "46";
                        $NM105 = "582628754";

                        fwrite($X12__811__File, "NM1*".$NM101."*".$NM102."*".$NM103."*****".$NM104."*".$NM105."~".$linefeed);
                        $TransactionSegmentCount++;

                        $PER = "PER*IC*QUOC NGUYEN*TE*2813250208*EM*QDN@ANVICARE.COM*FX*2813130925~";
                        fwrite($X12__811__File, $PER.$linefeed);            

                        $NM1 = "NM1*40*2*".strtoupper($row['"Insurance Company Name"'])."*****46*68024~";
                        fwrite($X12__811__File, $NM1.$linefeed);
                    }

                    if($LScheck) {
                        $HL = "HL*1**20*1~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $taxo = $row['"33-B-TAXO"'];

                        $PRV = "PRV*BI*PXC*".$taxo."~";
                        fwrite($X12__811__File, $PRV.$linefeed);

                        $clinicName = strtoupper($row['"33-ClinicName"']);

                        $NM1 = "NM1*85*2*".$clinicName."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $clinicAddress = strtoupper($row['"33-ClinicAddressLine1"']);

                        $N3 = "N3*".$clinicAddress."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $ClinicCityStateZip = strtoupper(str_replace(',','*',$row['"33-ClinicCityStateZip"']));

                        $N4 = "N4*".$ClinicCityStateZip."3103~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*EI*".$row['"25-TaxID"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $PER = "PER*IC*".$clinicName."*TE*8005551212~";
                        fwrite($X12__811__File, $PER.$linefeed);

                        $HL = "HL*2*1*22*0~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $SBR = "SBR*P*18*******CI~";
                        fwrite($X12__811__File, $SBR.$linefeed);

                        $ptName = strtoupper(str_replace(', ', '*', $row['"2-PatientName"']));

                        $NM1 = "NM1*".$row['"5-PatientState"']."*1*".$ptName."****MI*".$row['"1a-InsuredIDNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $InsuredAddr = strtoupper($row['"7-InsuredAddr"']);

                        $N3 = "N3*".$InsuredAddr."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $city = strtoupper($row['"5-PatientCity"']);
                        $state = strtoupper($row['"5-PatientState"']);
                        $zipcode = $row['"5-PatientZip"'];

                        $N4 = "N4*".$city."*".$state."*".$zipcode."~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $DOB = date('Ymd', strtotime($row['"3-PatientDOB"']));
                        $GENDER = $row['"3-PatientGender"'];

                        $DMG = "DMG*D8*".$DOB."*".$GENDER."~";
                        fwrite($X12__811__File, $DMG.$linefeed);

                        $NM1 = "NM1*PR*2*".strtoupper($row['"Insurance Company Name"'])."*****PI*".$row['"26-PatientAcctNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $address1 = $row['"Insurance Company Address 1"'];
                        $address1 = strtoupper(str_replace(".", "", $address1));

                        $N3 = "N3*".$address1."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $N4 = "N4*PHOENIX*AZ*85082~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*G2*".$row['"33-b-GrpLegacyNo"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        //$CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$row['"28-TotalCharge"']."***12:B:1*Y*A*Y*Y*P~";
                        $CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$TotalCharge."***12:B:1*Y*A*Y*Y*P~";               
                        fwrite($X12__811__File, $CLM.$linefeed);

                        $REF = "REF*G1*".$row['"23-PriorAuth"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $REF = "REF*D9*73629855~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $HI = "HI*ABK:R6889~";
                        fwrite($X12__811__File, $HI.$linefeed);
                    }

                    if($LScheck) {
                        $z = 1;
                    }
                    //for ($i=0; $i < $LScount ; $i++) { 
                        // code...              
                    if($LScheck) {
                        foreach ($result as $key1 => $value1) {

                            if(!empty($value1['"24.1.f-Charges"']) && in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.1.f-Charges"']."*UN*".$value1['"24.1.g-Units"']."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                $SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.1.a-DOSFrom"']]."*UN*".$Units[$value1['"24.1.a-DOSFrom"']]."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom1 = date('Ymd', strtotime($value1['"24.1.a-DOSFrom"']));
                                $dto1 = date('Ymd', strtotime($value1['"24.1.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom1."-".$dto1."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985501~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment1 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.1.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment1."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                                
                                if (($key = array_search($value1['"24.1.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.2.f-Charges"']) && in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.2.f-Charges"']."*UN*".$value1['"24.2.g-Units"']."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.2.a-DOSFrom"']]."*UN*".$Units[$value1['"24.2.a-DOSFrom"']]."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom2 = date('Ymd', strtotime($value1['"24.2.a-DOSFrom"']));
                                $dto2 = date('Ymd', strtotime($value1['"24.2.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom2."-".$dto2."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985502~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment2 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.2.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment2."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.2.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.3.f-Charges"']) && in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.3.f-Charges"']."*UN*".$value1['"24.3.g-Units"']."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.3.a-DOSFrom"']]."*UN*".$Units[$value1['"24.3.a-DOSFrom"']]."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom3 = date('Ymd', strtotime($value1['"24.3.a-DOSFrom"']));
                                $dto3 = date('Ymd', strtotime($value1['"24.3.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom3."-".$dto3."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985503~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment3 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.3.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment3."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.3.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.4.f-Charges"']) && in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.4.f-Charges"']."*UN*".$value1['"24.4.g-Units"']."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.4.a-DOSFrom"']]."*UN*".$Units[$value1['"24.4.a-DOSFrom"']]."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom4 = date('Ymd', strtotime($value1['"24.4.a-DOSFrom"']));
                                $dto4 = date('Ymd', strtotime($value1['"24.4.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom4."-".$dto4."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985504~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment4 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.4.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment4."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.4.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.5.f-Charges"']) && in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.5.f-Charges"']."*UN*".$value1['"24.5.g-Units"']."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.5.a-DOSFrom"']]."*UN*".$Units[$value1['"24.5.a-DOSFrom"']]."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom5 = date('Ymd', strtotime($value1['"24.5.a-DOSFrom"']));
                                $dto5 = date('Ymd', strtotime($value1['"24.5.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom5."-".$dto5."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985505~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment5 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.5.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment5."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.5.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.6.f-Charges"']) && in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.6.f-Charges"']."*UN*".$value1['"24.6.g-Units"']."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.6.a-DOSFrom"']]."*UN*".$Units[$value1['"24.6.a-DOSFrom"']]."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom6 = date('Ymd', strtotime($value1['"24.6.a-DOSFrom"']));
                                $dto6 = date('Ymd', strtotime($value1['"24.6.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom6."-".$dto6."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985506~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment6 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.6.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment6."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.6.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            } 
                        }
                    }
                    //}
                    /********** Start 837p file generation code ************/
                    $x++;
                }

                if($x>1) {
                    $SE = "SE*57*49731~";
                    fwrite($X12__811__File, $SE.$linefeed);
                    $GE = "GE*1*120264701~";
                    fwrite($X12__811__File, $GE.$linefeed);
                    $IEA = "IEA*1*001202647~";
                    fwrite($X12__811__File, $IEA.$linefeed);
                    fclose($X12__811__File);
                    //echo $filename; die;
                    $this->session->set_flashdata('message','Edi claim file has been generated successfully.');
                    print_r($filename);
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record.');
                print_r(0);
            }
        } elseif(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code) && $action=='all') {
            //$params = $_POST['params'];
            //$params = rtrim($params, '|');
            //$cms1500Ids = explode('|', $params);
            $cond = "";
            if($viewmode==1 || $viewmode==2) {
                $cond = " AND qb = '' AND (eclaimsLTS.paid = 0 OR eclaimsLTS.paid = 3)";
            }
            if($viewmode==3) {
                $cond = " AND qb = 'yes' AND (eclaimsLTS.paid = 0)";
                $nbatchno = $_POST['nbatchno'];
                if(!empty($nbatchno)) {
                    $cond .= " AND eclaimsLTS.uploadtime = '".$nbatchno."'";    
                }
            }

            $sql = "SELECT eclaimsLTS.cms1500_id, eclaimsLTS.patient_id FROM eclaimsLTS,tbldistricts WHERE tbldistricts.DistrictID = eclaimsLTS.mco AND eclaimsLTS.month = '$month' AND eclaimsLTS.year = '$year' AND eclaimsLTS.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'".$cond."";
            $res = $this->Comman_model->getCustomQueryData($sql);
            if(!empty($res)) {                
                $x=1; $check = true; $clientArr = [];
                foreach ($res as $key => $row) {
                    $cms_id2 = $row['cms1500_id'];
                    if ($_SESSION['rxx'][$cms_id2]=='Yes')  {
                        $cms1500_id = $row['cms1500_id'];
                        $clientArr[$cms1500_id] = $row['patient_id'];           
                    }
                }

                $vals = array_count_values($clientArr);
                $checkPatient = [];

                foreach ($res as $key => $row) {  
                    $cms_id2 = $row['cms1500_id'];
                    if ($_SESSION['rxx'][$cms_id2]=='Yes') {
                        $cms1500_id = $row['cms1500_id'];
                        $LScheck = true;
                        $TotalCharge = 0;
                        $checkNoOfCharges = 0;
                        /********** Start 837p file generation code ************/
                        $sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id='".$cms1500_id."'";
                        $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                        if(empty($row['cms1500_id'])) {
                            continue;
                        }

                        $checkDates = [];
                        $Charges = [];
                        $Units = [];

                        $sql = "SELECT * FROM eclaimsLTS WHERE patient_id='".$row['patient_id']."' AND month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."'".$cond."";
                        $result = $this->Comman_model->getCustomQueryData($sql);
                        foreach ($result as $key1 => $value1) {
                            // code...
                            if(!empty($value1['"24.1.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.2.f-Charges"'])) {
                                $checkNoOfCharges++;    
                            }
                            if(!empty($value1['"24.3.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.4.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.5.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.6.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            $num = floatval(str_replace(",","",$value1['"28-TotalCharge"']));
                            $TotalCharge = $TotalCharge + $num;


                            if(!empty($value1['"24.1.a-DOSFrom"'])) {
                                if(in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.1.a-DOSFrom"']] = $Charges[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.f-Charges"'];
                                    $Units[$value1['"24.1.a-DOSFrom"']] = $Units[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.1.a-DOSFrom"']);    
                                    $Charges[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.f-Charges"'];
                                    $Units[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.g-Units"'];
                                }                            
                            }

                            if(!empty($value1['"24.2.a-DOSFrom"'])) {
                                if(in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.2.a-DOSFrom"']] = $Charges[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.f-Charges"'];
                                    $Units[$value1['"24.2.a-DOSFrom"']] = $Units[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.2.a-DOSFrom"']);    
                                    $Charges[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.f-Charges"'];
                                    $Units[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.g-Units"'];
                                }
                            }

                            if(!empty($value1['"24.3.a-DOSFrom"'])) {
                                if(in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.3.a-DOSFrom"']] = $Charges[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.f-Charges"'];
                                    $Units[$value1['"24.3.a-DOSFrom"']] = $Units[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.3.a-DOSFrom"']);    
                                    $Charges[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.f-Charges"'];
                                    $Units[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.g-Units"'];
                                }
                            }

                            if(!empty($value1['"24.4.a-DOSFrom"'])) {
                                if(in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.4.a-DOSFrom"']] = $Charges[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.f-Charges"'];
                                    $Units[$value1['"24.4.a-DOSFrom"']] = $Units[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.4.a-DOSFrom"']);    
                                    $Charges[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.f-Charges"'];
                                    $Units[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.g-Units"'];
                                }
                            }
                            
                            if(!empty($value1['"24.5.a-DOSFrom"'])) {
                                if(in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.5.a-DOSFrom"']] = $Charges[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.f-Charges"'];
                                    $Units[$value1['"24.5.a-DOSFrom"']] = $Units[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.5.a-DOSFrom"']);    
                                    $Charges[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.f-Charges"'];
                                    $Units[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.g-Units"'];
                                }
                            }

                            if(!empty($value1['"24.6.a-DOSFrom"'])) {
                                if(in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.6.a-DOSFrom"']] = $Charges[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.f-Charges"'];
                                    $Units[$value1['"24.6.a-DOSFrom"']] = $Units[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.6.a-DOSFrom"']);    
                                    $Charges[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.f-Charges"'];
                                    $Units[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.g-Units"'];
                                }
                            }
                        }

                        if($checkNoOfCharges>6) {
                            $TotalCharge = number_format((float)$TotalCharge, 2, '.', '');
                        } else {
                            $num = floatval(str_replace(",","",$row['"28-TotalCharge"']));
                            $TotalCharge = number_format((float)$num, 2, '.', '');
                        }            

                        if(in_array($row['patient_id'], $checkPatient)) {
                            //continue;
                            $LScheck = false;
                        }

                        if (array_key_exists($row['patient_id'],$vals)) {
                            $LScount = $vals[$row['patient_id']];
                            array_push($checkPatient, $row['patient_id']);
                        }

                        //print_r($row);die;

                        $check = false;
                       
                        $linefeed="\n"; 
                        $infomsg="";
                        $errormsg="";

                        $check__count=0;
                        $claim__count=0;
                        $proc__count=0;
                        $charges=0;
                        $net__amount=0;
                        $total__NumberofIncludedSegments=0;


                        if($x==1) { // Write only once.
                            //$name = preg_replace('/[ ,]+/', '', $row['"2-PatientName"']);
                            //$name .= "-837p.txt";
                            $name = "837p.txt";
                            $url = FCPATH."/assets/edi/".$name;
                            $filename = $url;

                            $X12__811__File = fopen($filename,'w');
                            $ISA01__AuthorInfoQual="00";      
                            $ISA02__AuthorInformation=" ";
                            $ISA03__SecurityInfoQual="00";
                            $ISA04__SecurityInformation=" ";
                            $ISA05__InterchangeIDQual="ZZ";
                            $ISA06__InterchangeSenderID="AV09311993";
                            $ISA07__InterchangeIDQual="01";
                            $ISA08__InterchangeReceiverID="030240928";
                            $ISA09__InterchangeDate=date("ymd");
                            $ISA10__InterchangeTime=date("hm");
                            $ISA11__InterchangeStandardID="^";
                            $ISA12__InterchangeControlVersionID="00401";
                            $ISA13__InterchangeControlNumber="0".date("mdHi");
                            $ISA14__InterchangeAckRequested="1";
                            $ISA15__TestIndicator="P";        
                            $ISA16__SubElementSeperator=":";

                            fwrite($X12__811__File, "ISA*"
                                .$ISA01__AuthorInfoQual."*"
                                .$ISA02__AuthorInformation."*"
                                .$ISA03__SecurityInfoQual."*"
                                .$ISA04__SecurityInformation."*"
                                .$ISA05__InterchangeIDQual."*"
                                .$ISA06__InterchangeSenderID." *"
                                .$ISA07__InterchangeIDQual."*"
                                .$ISA08__InterchangeReceiverID." *"
                                .$ISA09__InterchangeDate."*"
                                .$ISA10__InterchangeTime."*"
                                .$ISA11__InterchangeStandardID."*"
                                .$ISA12__InterchangeControlVersionID."*"
                                .$ISA13__InterchangeControlNumber."*"
                                .$ISA14__InterchangeAckRequested."*"
                                .$ISA15__TestIndicator."*"
                                .$ISA16__SubElementSeperator
                                ."~".$linefeed);

                            $GS01__FunctionalIdentifierCode="HC";
                            $GS02__ApplicationSendersCode="AV01101957";
                            $GS03__ApplicationReceiversCode="030240928";
                            $GS04__GroupDate=date("Ymd");
                            $GS05__GroupTime=date("hm");
                            $GS06__GroupControlNumber="120264701";
                            $GS07__ResponsibleAgencyCode="X";
                            $GS08__VersionRelease="005010X222A1";

                            fwrite($X12__811__File, "GS*".
                                $GS01__FunctionalIdentifierCode."*".
                                $GS02__ApplicationSendersCode."*".
                                $GS03__ApplicationReceiversCode."*".
                                $GS04__GroupDate."*".
                                $GS05__GroupTime."*".
                                $GS06__GroupControlNumber."*".
                                $GS07__ResponsibleAgencyCode."*".
                                $GS08__VersionRelease.
                                "~".$linefeed);

                            $ST01__TransactionSetId="837";
                            $ST02__TransactionSetId="49731";
                            $ST02__TransactionSetControlNumber="005010X222A1";

                            fwrite($X12__811__File, "ST*".
                                $ST01__TransactionSetId."*".
                                $ST02__TransactionSetId."*".
                                $ST02__TransactionSetControlNumber.
                                "~".$linefeed);

                            $TransactionSegmentCount=1;

                            $BIG01 = "0019";
                            $BIG02 = "00";
                            $BIG03 = "202647";
                            $BIG04 = "20210818";
                            $BIG05 = "0939";
                            $BIG06 = "CH";

                            fwrite($X12__811__File, "BHT*".$BIG01."*".$BIG02."*".$BIG03."*".$BIG04."*".$BIG05."*".$BIG06."~".$linefeed);

                            $TransactionSegmentCount=1;
                            $NM101="41";
                            $NM102="2";
                            $NM103 = "ANVICARE";
                            $NM104 = "46";
                            $NM105 = "582628754";

                            fwrite($X12__811__File, "NM1*".$NM101."*".$NM102."*".$NM103."*****".$NM104."*".$NM105."~".$linefeed);
                            $TransactionSegmentCount++;

                            $PER = "PER*IC*QUOC NGUYEN*TE*2813250208*EM*QDN@ANVICARE.COM*FX*2813130925~";
                            fwrite($X12__811__File, $PER.$linefeed);            

                            $NM1 = "NM1*40*2*".strtoupper($row['"Insurance Company Name"'])."*****46*68024~";
                            fwrite($X12__811__File, $NM1.$linefeed);
                        }

                        if($LScheck) {
                            $HL = "HL*1**20*1~";
                            fwrite($X12__811__File, $HL.$linefeed);

                            $taxo = $row['"33-B-TAXO"'];

                            $PRV = "PRV*BI*PXC*".$taxo."~";
                            fwrite($X12__811__File, $PRV.$linefeed);

                            $clinicName = strtoupper($row['"33-ClinicName"']);

                            $NM1 = "NM1*85*2*".$clinicName."~";
                            fwrite($X12__811__File, $NM1.$linefeed);

                            $clinicAddress = strtoupper($row['"33-ClinicAddressLine1"']);

                            $N3 = "N3*".$clinicAddress."~";
                            fwrite($X12__811__File, $N3.$linefeed);

                            $ClinicCityStateZip = strtoupper(str_replace(',','*',$row['"33-ClinicCityStateZip"']));

                            $N4 = "N4*".$ClinicCityStateZip."3103~";
                            fwrite($X12__811__File, $N4.$linefeed);

                            $REF = "REF*EI*".$row['"25-TaxID"']."~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            $PER = "PER*IC*".$clinicName."*TE*8005551212~";
                            fwrite($X12__811__File, $PER.$linefeed);

                            $HL = "HL*2*1*22*0~";
                            fwrite($X12__811__File, $HL.$linefeed);

                            $SBR = "SBR*P*18*******CI~";
                            fwrite($X12__811__File, $SBR.$linefeed);

                            $ptName = strtoupper(str_replace(', ', '*', $row['"2-PatientName"']));

                            $NM1 = "NM1*".$row['"5-PatientState"']."*1*".$ptName."****MI*".$row['"1a-InsuredIDNo"']."~";
                            fwrite($X12__811__File, $NM1.$linefeed);

                            $InsuredAddr = strtoupper($row['"7-InsuredAddr"']);

                            $N3 = "N3*".$InsuredAddr."~";
                            fwrite($X12__811__File, $N3.$linefeed);

                            $city = strtoupper($row['"5-PatientCity"']);
                            $state = strtoupper($row['"5-PatientState"']);
                            $zipcode = $row['"5-PatientZip"'];

                            $N4 = "N4*".$city."*".$state."*".$zipcode."~";
                            fwrite($X12__811__File, $N4.$linefeed);

                            $DOB = date('Ymd', strtotime($row['"3-PatientDOB"']));
                            $GENDER = $row['"3-PatientGender"'];

                            $DMG = "DMG*D8*".$DOB."*".$GENDER."~";
                            fwrite($X12__811__File, $DMG.$linefeed);

                            $NM1 = "NM1*PR*2*".strtoupper($row['"Insurance Company Name"'])."*****PI*".$row['"26-PatientAcctNo"']."~";
                            fwrite($X12__811__File, $NM1.$linefeed);

                            $address1 = $row['"Insurance Company Address 1"'];
                            $address1 = strtoupper(str_replace(".", "", $address1));

                            $N3 = "N3*".$address1."~";
                            fwrite($X12__811__File, $N3.$linefeed);

                            $N4 = "N4*PHOENIX*AZ*85082~";
                            fwrite($X12__811__File, $N4.$linefeed);

                            $REF = "REF*G2*".$row['"33-b-GrpLegacyNo"']."~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            //$CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$row['"28-TotalCharge"']."***12:B:1*Y*A*Y*Y*P~";
                            $CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$TotalCharge."***12:B:1*Y*A*Y*Y*P~";               
                            fwrite($X12__811__File, $CLM.$linefeed);

                            $REF = "REF*G1*".$row['"23-PriorAuth"']."~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            $REF = "REF*D9*73629855~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            $HI = "HI*ABK:R6889~";
                            fwrite($X12__811__File, $HI.$linefeed);
                        }

                        if($LScheck) {
                            $z = 1;
                        }
                        //for ($i=0; $i < $LScount ; $i++) { 
                            // code...              
                        if($LScheck) {
                            foreach ($result as $key1 => $value1) {

                                if(!empty($value1['"24.1.f-Charges"']) && in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.1.f-Charges"']."*UN*".$value1['"24.1.g-Units"']."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                    $SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.1.a-DOSFrom"']]."*UN*".$Units[$value1['"24.1.a-DOSFrom"']]."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom1 = date('Ymd', strtotime($value1['"24.1.a-DOSFrom"']));
                                    $dto1 = date('Ymd', strtotime($value1['"24.1.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom1."-".$dto1."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985501~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment1 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.1.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment1."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;
                                    
                                    if (($key = array_search($value1['"24.1.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.2.f-Charges"']) && in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.2.f-Charges"']."*UN*".$value1['"24.2.g-Units"']."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.2.a-DOSFrom"']]."*UN*".$Units[$value1['"24.2.a-DOSFrom"']]."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom2 = date('Ymd', strtotime($value1['"24.2.a-DOSFrom"']));
                                    $dto2 = date('Ymd', strtotime($value1['"24.2.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom2."-".$dto2."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985502~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment2 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.2.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment2."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.2.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.3.f-Charges"']) && in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.3.f-Charges"']."*UN*".$value1['"24.3.g-Units"']."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.3.a-DOSFrom"']]."*UN*".$Units[$value1['"24.3.a-DOSFrom"']]."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom3 = date('Ymd', strtotime($value1['"24.3.a-DOSFrom"']));
                                    $dto3 = date('Ymd', strtotime($value1['"24.3.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom3."-".$dto3."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985503~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment3 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.3.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment3."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.3.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.4.f-Charges"']) && in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.4.f-Charges"']."*UN*".$value1['"24.4.g-Units"']."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.4.a-DOSFrom"']]."*UN*".$Units[$value1['"24.4.a-DOSFrom"']]."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom4 = date('Ymd', strtotime($value1['"24.4.a-DOSFrom"']));
                                    $dto4 = date('Ymd', strtotime($value1['"24.4.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom4."-".$dto4."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985504~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment4 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.4.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment4."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.4.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.5.f-Charges"']) && in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.5.f-Charges"']."*UN*".$value1['"24.5.g-Units"']."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.5.a-DOSFrom"']]."*UN*".$Units[$value1['"24.5.a-DOSFrom"']]."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom5 = date('Ymd', strtotime($value1['"24.5.a-DOSFrom"']));
                                    $dto5 = date('Ymd', strtotime($value1['"24.5.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom5."-".$dto5."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985505~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment5 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.5.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment5."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.5.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.6.f-Charges"']) && in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.6.f-Charges"']."*UN*".$value1['"24.6.g-Units"']."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.6.a-DOSFrom"']]."*UN*".$Units[$value1['"24.6.a-DOSFrom"']]."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom6 = date('Ymd', strtotime($value1['"24.6.a-DOSFrom"']));
                                    $dto6 = date('Ymd', strtotime($value1['"24.6.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom6."-".$dto6."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985506~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment6 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.6.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment6."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.6.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                } 
                            }
                        }
                        //}
                        /********** Start 837p file generation code ************/
                        $x++;
                    }
                }

                unset($_SESSION['rxx']);

                if($x>1) {
                    $SE = "SE*57*49731~";
                    fwrite($X12__811__File, $SE.$linefeed);
                    $GE = "GE*1*120264701~";
                    fwrite($X12__811__File, $GE.$linefeed);
                    $IEA = "IEA*1*001202647~";
                    fwrite($X12__811__File, $IEA.$linefeed);
                    fclose($X12__811__File);
                    //echo $filename; die;

                    $this->session->set_flashdata('message','Edi claim file has been generated successfully.');
                    print_r($filename);
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record.');
                print_r(0);
            }
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function generateClaimMD() {
        $action = $_POST['action'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $viewmode = $_POST['viewmode'];
        $agency_code = $_POST['agency_code'];

        if(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code) && $action=='selected') {
            $params = $_POST['params'];
            $params = rtrim($params, '|');
            $cms1500Ids = explode('|', $params);

            $sqlclmd = "SELECT * FROM claimmd_settings";
            $rowclmd = $this->Comman_model->getCustomQueryData($sqlclmd, 'row');

            if(!empty($cms1500Ids)) {
                $x=1; $check = true; $clientArr = [];
                foreach ($cms1500Ids as $key => $cms1500_id) {
                    //$sql = "select * from eclaimsLTS where cms1500_id='".$cms1500_id."'";
                    $sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id = '$cms1500_id' AND year = '$year' AND month = '$month'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');                        
                    $clientArr[$cms1500_id] = $row['patient_id'];           
                }

                $vals = array_count_values($clientArr);
                $checkPatient = [];

                foreach ($cms1500Ids as $key => $cms1500_id) {
                    $LScheck = true;
                    $TotalCharge = 0;
                    $checkNoOfCharges = 0;
                    /********** Start 837p file generation code ************/
                    //$sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id='".$cms1500_id."'";
                    $sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id = '$cms1500_id' AND year = '$year' AND month = '$month'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    if(empty($row['cms1500_id'])) {
                        continue;
                    }

                    $cond = "";
                    if($viewmode==1 || $viewmode==2) {
                        $cond = " AND qb = '' AND (eclaimsLTS.paid = 0 OR eclaimsLTS.paid = 3)";
                    }
                    if($viewmode==3) {
                        $cond = " AND qb = 'yes' AND (eclaimsLTS.paid = 0)";
                    }

                    $checkDates = [];
                    $Charges = [];
                    $Units = [];

                    $sql = "SELECT * FROM eclaimsLTS WHERE patient_id='".$row['patient_id']."' AND month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."'".$cond."";
                    $result = $this->Comman_model->getCustomQueryData($sql);
                    foreach ($result as $key1 => $value1) {
                        // code...
                        if(!empty($value1['"24.1.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.2.f-Charges"'])) {
                            $checkNoOfCharges++;    
                        }
                        if(!empty($value1['"24.3.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.4.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.5.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.6.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        $num = floatval(str_replace(",","",$value1['"28-TotalCharge"']));
                        $TotalCharge = $TotalCharge + $num;

                        if(!empty($value1['"24.1.a-DOSFrom"'])) {
                            if(in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.1.a-DOSFrom"']] = $Charges[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.f-Charges"'];
                                $Units[$value1['"24.1.a-DOSFrom"']] = $Units[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.1.a-DOSFrom"']);    
                                $Charges[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.f-Charges"'];
                                $Units[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.g-Units"'];
                            }                            
                        }

                        if(!empty($value1['"24.2.a-DOSFrom"'])) {
                            if(in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.2.a-DOSFrom"']] = $Charges[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.f-Charges"'];
                                $Units[$value1['"24.2.a-DOSFrom"']] = $Units[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.2.a-DOSFrom"']);    
                                $Charges[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.f-Charges"'];
                                $Units[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.3.a-DOSFrom"'])) {
                            if(in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.3.a-DOSFrom"']] = $Charges[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.f-Charges"'];
                                $Units[$value1['"24.3.a-DOSFrom"']] = $Units[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.3.a-DOSFrom"']);    
                                $Charges[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.f-Charges"'];
                                $Units[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.4.a-DOSFrom"'])) {
                            if(in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.4.a-DOSFrom"']] = $Charges[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.f-Charges"'];
                                $Units[$value1['"24.4.a-DOSFrom"']] = $Units[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.4.a-DOSFrom"']);    
                                $Charges[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.f-Charges"'];
                                $Units[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.5.a-DOSFrom"'])) {
                            if(in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.5.a-DOSFrom"']] = $Charges[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.f-Charges"'];
                                $Units[$value1['"24.5.a-DOSFrom"']] = $Units[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.5.a-DOSFrom"']);    
                                $Charges[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.f-Charges"'];
                                $Units[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.g-Units"'];
                            }
                        }

                        if(!empty($value1['"24.6.a-DOSFrom"'])) {
                            if(in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {                                
                                $Charges[$value1['"24.6.a-DOSFrom"']] = $Charges[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.f-Charges"'];
                                $Units[$value1['"24.6.a-DOSFrom"']] = $Units[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.g-Units"'];
                            } else {
                                array_push($checkDates, $value1['"24.6.a-DOSFrom"']);    
                                $Charges[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.f-Charges"'];
                                $Units[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.g-Units"'];
                            }
                        }
                    }

                    if($checkNoOfCharges>6) {
                        $TotalCharge = number_format((float)$TotalCharge, 2, '.', '');
                    } else {
                        $num = floatval(str_replace(",","",$row['"28-TotalCharge"']));
                        $TotalCharge = number_format((float)$num, 2, '.', '');
                    }            

                    if(in_array($row['patient_id'], $checkPatient)) {
                        //continue;
                        $LScheck = false;
                    }

                    if (array_key_exists($row['patient_id'],$vals)) {
                        $LScount = $vals[$row['patient_id']];
                        array_push($checkPatient, $row['patient_id']);
                    }

                    //print_r($row);die;

                    $check = false;
                   
                    $linefeed="\n"; 
                    $infomsg="";
                    $errormsg="";

                    $check__count=0;
                    $claim__count=0;
                    $proc__count=0;
                    $charges=0;
                    $net__amount=0;
                    $total__NumberofIncludedSegments=0;


                    if($x==1) { // Write only once.

                        //$name = preg_replace('/[ ,]+/', '', $row['"2-PatientName"']);
                        //$name .= "-837p.txt";
                        $name = "837p.txt";
                        //$url = FCPATH."/assets/edi/".$name;
                        $url = FCPATH."/image/claimmd/".$name;
                        $filename = $url;

                        $X12__811__File = fopen($filename,'w');
                        $ISA01__AuthorInfoQual=$rowclmd['ISA01'];
                        $ISA02__AuthorInformation=" ";
                        $ISA03__SecurityInfoQual=$rowclmd['ISA03'];
                        $ISA04__SecurityInformation=" ";
                        $ISA05__InterchangeIDQual=$rowclmd['ISA05'];
                        $ISA06__InterchangeSenderID=$rowclmd['ISA06'];
                        $ISA07__InterchangeIDQual=$rowclmd['ISA07'];
                        //$ISA08__InterchangeReceiverID="030240928";
                        $ISA08__InterchangeReceiverID=$rowclmd['ISA08'];
                        $ISA09__InterchangeDate=date("ymd");
                        $ISA10__InterchangeTime=date("hm");
                        $ISA11__InterchangeStandardID="^";
                        $ISA12__InterchangeControlVersionID="00401";
                        $ISA13__InterchangeControlNumber="0".date("mdHi");
                        $ISA14__InterchangeAckRequested="1";
                        $ISA15__TestIndicator="P";        
                        $ISA16__SubElementSeperator=":";

                        fwrite($X12__811__File, "ISA*"
                            .$ISA01__AuthorInfoQual."*"
                            .$ISA02__AuthorInformation."*"
                            .$ISA03__SecurityInfoQual."*"
                            .$ISA04__SecurityInformation."*"
                            .$ISA05__InterchangeIDQual."*"
                            .$ISA06__InterchangeSenderID." *"
                            .$ISA07__InterchangeIDQual."*"
                            .$ISA08__InterchangeReceiverID." *"
                            .$ISA09__InterchangeDate."*"
                            .$ISA10__InterchangeTime."*"
                            .$ISA11__InterchangeStandardID."*"
                            .$ISA12__InterchangeControlVersionID."*"
                            .$ISA13__InterchangeControlNumber."*"
                            .$ISA14__InterchangeAckRequested."*"
                            .$ISA15__TestIndicator."*"
                            .$ISA16__SubElementSeperator
                            ."~".$linefeed);

                        $GS01__FunctionalIdentifierCode="HC";
                        $GS02__ApplicationSendersCode=$rowclmd['GS02'];
                        $GS03__ApplicationReceiversCode=$rowclmd['GS03'];
                        $GS04__GroupDate=date("Ymd");
                        $GS05__GroupTime=date("hm");
                        $GS06__GroupControlNumber="120264701";
                        $GS07__ResponsibleAgencyCode="X";
                        $GS08__VersionRelease="005010X222A1";

                        fwrite($X12__811__File, "GS*".
                            $GS01__FunctionalIdentifierCode."*".
                            $GS02__ApplicationSendersCode."*".
                            $GS03__ApplicationReceiversCode."*".
                            $GS04__GroupDate."*".
                            $GS05__GroupTime."*".
                            $GS06__GroupControlNumber."*".
                            $GS07__ResponsibleAgencyCode."*".
                            $GS08__VersionRelease.
                            "~".$linefeed);

                        $ST01__TransactionSetId="837";
                        $ST02__TransactionSetId="49731";
                        $ST02__TransactionSetControlNumber="005010X222A1";

                        fwrite($X12__811__File, "ST*".
                            $ST01__TransactionSetId."*".
                            $ST02__TransactionSetId."*".
                            $ST02__TransactionSetControlNumber.
                            "~".$linefeed);

                        $TransactionSegmentCount=1;

                        $BIG01 = "0019";
                        $BIG02 = "00";
                        $BIG03 = "202647";
                        $BIG04 = "20210818";
                        $BIG05 = "0939";
                        $BIG06 = "CH";

                        fwrite($X12__811__File, "BHT*".$BIG01."*".$BIG02."*".$BIG03."*".$BIG04."*".$BIG05."*".$BIG06."~".$linefeed);

                        $TransactionSegmentCount=1;
                        $NM101="41";
                        $NM102="2";
                        $NM103 = "ANVICARE";
                        $NM104 = "46";
                        $NM105 = "582628754";

                        fwrite($X12__811__File, "NM1*".$NM101."*".$NM102."*".$NM103."*****".$NM104."*".$NM105."~".$linefeed);
                        $TransactionSegmentCount++;

                        $PER = "PER*IC*QUOC NGUYEN*TE*2813250208*EM*QDN@ANVICARE.COM*FX*2813130925~";
                        fwrite($X12__811__File, $PER.$linefeed);            

                        $NM1 = "NM1*40*2*".strtoupper($row['"Insurance Company Name"'])."*****46*68024~";
                        fwrite($X12__811__File, $NM1.$linefeed);
                    }

                    if($LScheck) {
                        $HL = "HL*1**20*1~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $taxo = $row['"33-B-TAXO"'];

                        $PRV = "PRV*BI*PXC*".$taxo."~";
                        fwrite($X12__811__File, $PRV.$linefeed);

                        $clinicName = strtoupper($row['"33-ClinicName"']);

                        $NM1 = "NM1*85*2*".$clinicName."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $clinicAddress = strtoupper($row['"33-ClinicAddressLine1"']);

                        $N3 = "N3*".$clinicAddress."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $ClinicCityStateZip = strtoupper(str_replace(',','*',$row['"33-ClinicCityStateZip"']));

                        $N4 = "N4*".$ClinicCityStateZip."3103~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*EI*".$row['"25-TaxID"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $PER = "PER*IC*".$clinicName."*TE*8005551212~";
                        fwrite($X12__811__File, $PER.$linefeed);

                        $HL = "HL*2*1*22*0~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $SBR = "SBR*P*18*******CI~";
                        fwrite($X12__811__File, $SBR.$linefeed);

                        $ptName = strtoupper(str_replace(', ', '*', $row['"2-PatientName"']));

                        $NM1 = "NM1*".$row['"5-PatientState"']."*1*".$ptName."****MI*".$row['"1a-InsuredIDNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $InsuredAddr = strtoupper($row['"7-InsuredAddr"']);

                        $N3 = "N3*".$InsuredAddr."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $city = strtoupper($row['"5-PatientCity"']);
                        $state = strtoupper($row['"5-PatientState"']);
                        $zipcode = $row['"5-PatientZip"'];

                        $N4 = "N4*".$city."*".$state."*".$zipcode."~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $DOB = date('Ymd', strtotime($row['"3-PatientDOB"']));
                        $GENDER = $row['"3-PatientGender"'];

                        $DMG = "DMG*D8*".$DOB."*".$GENDER."~";
                        fwrite($X12__811__File, $DMG.$linefeed);

                        $NM1 = "NM1*PR*2*".strtoupper($row['"Insurance Company Name"'])."*****PI*".$row['"26-PatientAcctNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $address1 = $row['"Insurance Company Address 1"'];
                        $address1 = strtoupper(str_replace(".", "", $address1));

                        $N3 = "N3*".$address1."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $N4 = "N4*PHOENIX*AZ*85082~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*G2*".$row['"33-b-GrpLegacyNo"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        //$CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$row['"28-TotalCharge"']."***12:B:1*Y*A*Y*Y*P~";
                        $CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$TotalCharge."***12:B:1*Y*A*Y*Y*P~";               
                        fwrite($X12__811__File, $CLM.$linefeed);

                        $REF = "REF*G1*".$row['"23-PriorAuth"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $REF = "REF*D9*73629855~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $HI = "HI*ABK:R6889~";
                        fwrite($X12__811__File, $HI.$linefeed);
                    }

                    if($LScheck) {
                        $z = 1;
                    }
                    //for ($i=0; $i < $LScount ; $i++) { 
                        // code...              
                    if($LScheck) {
                        foreach ($result as $key1 => $value1) {

                            if(!empty($value1['"24.1.f-Charges"']) && in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.1.f-Charges"']."*UN*".$value1['"24.1.g-Units"']."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                $SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.1.a-DOSFrom"']]."*UN*".$Units[$value1['"24.1.a-DOSFrom"']]."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom1 = date('Ymd', strtotime($value1['"24.1.a-DOSFrom"']));
                                $dto1 = date('Ymd', strtotime($value1['"24.1.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom1."-".$dto1."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985501~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment1 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.1.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment1."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                                
                                if (($key = array_search($value1['"24.1.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.2.f-Charges"']) && in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.2.f-Charges"']."*UN*".$value1['"24.2.g-Units"']."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.2.a-DOSFrom"']]."*UN*".$Units[$value1['"24.2.a-DOSFrom"']]."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom2 = date('Ymd', strtotime($value1['"24.2.a-DOSFrom"']));
                                $dto2 = date('Ymd', strtotime($value1['"24.2.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom2."-".$dto2."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985502~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment2 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.2.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment2."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.2.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.3.f-Charges"']) && in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.3.f-Charges"']."*UN*".$value1['"24.3.g-Units"']."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.3.a-DOSFrom"']]."*UN*".$Units[$value1['"24.3.a-DOSFrom"']]."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom3 = date('Ymd', strtotime($value1['"24.3.a-DOSFrom"']));
                                $dto3 = date('Ymd', strtotime($value1['"24.3.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom3."-".$dto3."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985503~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment3 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.3.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment3."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.3.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.4.f-Charges"']) && in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.4.f-Charges"']."*UN*".$value1['"24.4.g-Units"']."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.4.a-DOSFrom"']]."*UN*".$Units[$value1['"24.4.a-DOSFrom"']]."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom4 = date('Ymd', strtotime($value1['"24.4.a-DOSFrom"']));
                                $dto4 = date('Ymd', strtotime($value1['"24.4.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom4."-".$dto4."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985504~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment4 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.4.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment4."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.4.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.5.f-Charges"']) && in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.5.f-Charges"']."*UN*".$value1['"24.5.g-Units"']."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.5.a-DOSFrom"']]."*UN*".$Units[$value1['"24.5.a-DOSFrom"']]."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom5 = date('Ymd', strtotime($value1['"24.5.a-DOSFrom"']));
                                $dto5 = date('Ymd', strtotime($value1['"24.5.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom5."-".$dto5."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985505~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment5 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.5.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment5."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.5.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            }

                            if(!empty($value1['"24.6.f-Charges"']) && in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                //$SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.6.f-Charges"']."*UN*".$value1['"24.6.g-Units"']."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";

                                $SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.6.a-DOSFrom"']]."*UN*".$Units[$value1['"24.6.a-DOSFrom"']]."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom6 = date('Ymd', strtotime($value1['"24.6.a-DOSFrom"']));
                                $dto6 = date('Ymd', strtotime($value1['"24.6.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom6."-".$dto6."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985506~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment6 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.6.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment6."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;

                                if (($key = array_search($value1['"24.6.a-DOSFrom"'], $checkDates)) !== false) {
                                    unset($checkDates[$key]);
                                }
                            } 
                        }
                    }
                    //}
                    /********** Start 837p file generation code ************/
                    $x++;
                }

                if($x>1) {
                    $SE = "SE*57*49731~";
                    fwrite($X12__811__File, $SE.$linefeed);
                    $GE = "GE*1*120264701~";
                    fwrite($X12__811__File, $GE.$linefeed);
                    $IEA = "IEA*1*001202647~";
                    fwrite($X12__811__File, $IEA.$linefeed);
                    fclose($X12__811__File);
                    //echo $filename; die;
                    $this->session->set_flashdata('message','Edi claim file has been generated successfully.');
                    print_r('837p.txt');
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record.');
                print_r(0);
            }
        } elseif(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code) && $action=='all') {
            //$params = $_POST['params'];
            //$params = rtrim($params, '|');
            //$cms1500Ids = explode('|', $params);

            $sqlclmd = "SELECT * FROM claimmd_settings";
            $rowclmd = $this->Comman_model->getCustomQueryData($sqlclmd, 'row');

            $cond = "";
            if($viewmode==1 || $viewmode==2) {
                $cond = " AND qb = '' AND (eclaimsLTS.paid = 0 OR eclaimsLTS.paid = 3)";
            }
            if($viewmode==3) {
                $cond = " AND qb = 'yes' AND (eclaimsLTS.paid = 0)";
                $nbatchno = $_POST['nbatchno'];
                if(!empty($nbatchno)) {
                    $cond .= " AND eclaimsLTS.uploadtime = '".$nbatchno."'";    
                }
            }

            $sql = "SELECT eclaimsLTS.cms1500_id, eclaimsLTS.patient_id FROM eclaimsLTS,tbldistricts WHERE tbldistricts.DistrictID = eclaimsLTS.mco AND eclaimsLTS.month = '$month' AND eclaimsLTS.year = '$year' AND eclaimsLTS.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'".$cond."";
            $res = $this->Comman_model->getCustomQueryData($sql);
            if(!empty($res)) {                
                $x=1; $check = true; $clientArr = [];
                foreach ($res as $key => $row) {
                    $cms_id2 = $row['cms1500_id'];
                    if ($_SESSION['rxx'][$cms_id2]=='Yes')  {
                        $cms1500_id = $row['cms1500_id'];
                        $clientArr[$cms1500_id] = $row['patient_id'];           
                    }
                }

                $vals = array_count_values($clientArr);
                $checkPatient = [];

                foreach ($res as $key => $row) {  
                    $cms_id2 = $row['cms1500_id'];
                    if ($_SESSION['rxx'][$cms_id2]=='Yes') {
                        $cms1500_id = $row['cms1500_id'];
                        $LScheck = true;
                        $TotalCharge = 0;
                        $checkNoOfCharges = 0;
                        /********** Start 837p file generation code ************/
                        //$sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id='".$cms1500_id."'";
                        $sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id='$cms1500_id' AND year = '$year' AND month = '$month'";
                        $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                        if(empty($row['cms1500_id'])) {
                            continue;
                        }

                        $checkDates = [];
                        $Charges = [];
                        $Units = [];

                        $sql = "SELECT * FROM eclaimsLTS WHERE patient_id='".$row['patient_id']."' AND month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."'".$cond."";
                        $result = $this->Comman_model->getCustomQueryData($sql);
                        foreach ($result as $key1 => $value1) {
                            // code...
                            if(!empty($value1['"24.1.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.2.f-Charges"'])) {
                                $checkNoOfCharges++;    
                            }
                            if(!empty($value1['"24.3.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.4.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.5.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            if(!empty($value1['"24.6.f-Charges"'])) {
                                $checkNoOfCharges++;
                            }
                            $num = floatval(str_replace(",","",$value1['"28-TotalCharge"']));
                            $TotalCharge = $TotalCharge + $num;


                            if(!empty($value1['"24.1.a-DOSFrom"'])) {
                                if(in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.1.a-DOSFrom"']] = $Charges[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.f-Charges"'];
                                    $Units[$value1['"24.1.a-DOSFrom"']] = $Units[$value1['"24.1.a-DOSFrom"']] + $value1['"24.1.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.1.a-DOSFrom"']);    
                                    $Charges[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.f-Charges"'];
                                    $Units[$value1['"24.1.a-DOSFrom"']] = $value1['"24.1.g-Units"'];
                                }                            
                            }

                            if(!empty($value1['"24.2.a-DOSFrom"'])) {
                                if(in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.2.a-DOSFrom"']] = $Charges[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.f-Charges"'];
                                    $Units[$value1['"24.2.a-DOSFrom"']] = $Units[$value1['"24.2.a-DOSFrom"']] + $value1['"24.2.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.2.a-DOSFrom"']);    
                                    $Charges[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.f-Charges"'];
                                    $Units[$value1['"24.2.a-DOSFrom"']] = $value1['"24.2.g-Units"'];
                                }
                            }

                            if(!empty($value1['"24.3.a-DOSFrom"'])) {
                                if(in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.3.a-DOSFrom"']] = $Charges[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.f-Charges"'];
                                    $Units[$value1['"24.3.a-DOSFrom"']] = $Units[$value1['"24.3.a-DOSFrom"']] + $value1['"24.3.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.3.a-DOSFrom"']);    
                                    $Charges[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.f-Charges"'];
                                    $Units[$value1['"24.3.a-DOSFrom"']] = $value1['"24.3.g-Units"'];
                                }
                            }

                            if(!empty($value1['"24.4.a-DOSFrom"'])) {
                                if(in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.4.a-DOSFrom"']] = $Charges[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.f-Charges"'];
                                    $Units[$value1['"24.4.a-DOSFrom"']] = $Units[$value1['"24.4.a-DOSFrom"']] + $value1['"24.4.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.4.a-DOSFrom"']);    
                                    $Charges[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.f-Charges"'];
                                    $Units[$value1['"24.4.a-DOSFrom"']] = $value1['"24.4.g-Units"'];
                                }
                            }
                            
                            if(!empty($value1['"24.5.a-DOSFrom"'])) {
                                if(in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.5.a-DOSFrom"']] = $Charges[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.f-Charges"'];
                                    $Units[$value1['"24.5.a-DOSFrom"']] = $Units[$value1['"24.5.a-DOSFrom"']] + $value1['"24.5.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.5.a-DOSFrom"']);    
                                    $Charges[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.f-Charges"'];
                                    $Units[$value1['"24.5.a-DOSFrom"']] = $value1['"24.5.g-Units"'];
                                }
                            }

                            if(!empty($value1['"24.6.a-DOSFrom"'])) {
                                if(in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {                                
                                    $Charges[$value1['"24.6.a-DOSFrom"']] = $Charges[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.f-Charges"'];
                                    $Units[$value1['"24.6.a-DOSFrom"']] = $Units[$value1['"24.6.a-DOSFrom"']] + $value1['"24.6.g-Units"'];
                                } else {
                                    array_push($checkDates, $value1['"24.6.a-DOSFrom"']);    
                                    $Charges[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.f-Charges"'];
                                    $Units[$value1['"24.6.a-DOSFrom"']] = $value1['"24.6.g-Units"'];
                                }
                            }
                        }

                        if($checkNoOfCharges>6) {
                            $TotalCharge = number_format((float)$TotalCharge, 2, '.', '');
                        } else {
                            $num = floatval(str_replace(",","",$row['"28-TotalCharge"']));
                            $TotalCharge = number_format((float)$num, 2, '.', '');
                        }            

                        if(in_array($row['patient_id'], $checkPatient)) {
                            //continue;
                            $LScheck = false;
                        }

                        if (array_key_exists($row['patient_id'],$vals)) {
                            $LScount = $vals[$row['patient_id']];
                            array_push($checkPatient, $row['patient_id']);
                        }

                        //print_r($row);die;

                        $check = false;
                       
                        $linefeed="\n"; 
                        $infomsg="";
                        $errormsg="";

                        $check__count=0;
                        $claim__count=0;
                        $proc__count=0;
                        $charges=0;
                        $net__amount=0;
                        $total__NumberofIncludedSegments=0;


                        if($x==1) { // Write only once.
                            //$name = preg_replace('/[ ,]+/', '', $row['"2-PatientName"']);
                            //$name .= "-837p.txt";
                            $name = "837p.txt";
                            //$url = FCPATH."/assets/edi/".$name;
                            $url = FCPATH."/image/claimmd/".$name;
                            $filename = $url;

                            $X12__811__File = fopen($filename,'w');
                            $ISA01__AuthorInfoQual=$rowclmd['ISA01'];
                            $ISA02__AuthorInformation=" ";
                            $ISA03__SecurityInfoQual=$rowclmd['ISA03'];
                            $ISA04__SecurityInformation=" ";
                            $ISA05__InterchangeIDQual=$rowclmd['ISA05'];
                            $ISA06__InterchangeSenderID=$rowclmd['ISA06'];
                            $ISA07__InterchangeIDQual=$rowclmd['ISA07'];
                            $ISA08__InterchangeReceiverID=$rowclmd['ISA08'];
                            $ISA09__InterchangeDate=date("ymd");
                            $ISA10__InterchangeTime=date("hm");
                            $ISA11__InterchangeStandardID="^";
                            $ISA12__InterchangeControlVersionID="00401";
                            $ISA13__InterchangeControlNumber="0".date("mdHi");
                            $ISA14__InterchangeAckRequested="1";
                            $ISA15__TestIndicator="P";        
                            $ISA16__SubElementSeperator=":";

                            fwrite($X12__811__File, "ISA*"
                                .$ISA01__AuthorInfoQual."*"
                                .$ISA02__AuthorInformation."*"
                                .$ISA03__SecurityInfoQual."*"
                                .$ISA04__SecurityInformation."*"
                                .$ISA05__InterchangeIDQual."*"
                                .$ISA06__InterchangeSenderID." *"
                                .$ISA07__InterchangeIDQual."*"
                                .$ISA08__InterchangeReceiverID." *"
                                .$ISA09__InterchangeDate."*"
                                .$ISA10__InterchangeTime."*"
                                .$ISA11__InterchangeStandardID."*"
                                .$ISA12__InterchangeControlVersionID."*"
                                .$ISA13__InterchangeControlNumber."*"
                                .$ISA14__InterchangeAckRequested."*"
                                .$ISA15__TestIndicator."*"
                                .$ISA16__SubElementSeperator
                                ."~".$linefeed);

                            $GS01__FunctionalIdentifierCode="HC";
                            $GS02__ApplicationSendersCode=$rowclmd['GS02'];
                            $GS03__ApplicationReceiversCode=$rowclmd['GS03'];
                            $GS04__GroupDate=date("Ymd");
                            $GS05__GroupTime=date("hm");
                            $GS06__GroupControlNumber="120264701";
                            $GS07__ResponsibleAgencyCode="X";
                            $GS08__VersionRelease="005010X222A1";

                            fwrite($X12__811__File, "GS*".
                                $GS01__FunctionalIdentifierCode."*".
                                $GS02__ApplicationSendersCode."*".
                                $GS03__ApplicationReceiversCode."*".
                                $GS04__GroupDate."*".
                                $GS05__GroupTime."*".
                                $GS06__GroupControlNumber."*".
                                $GS07__ResponsibleAgencyCode."*".
                                $GS08__VersionRelease.
                                "~".$linefeed);

                            $ST01__TransactionSetId="837";
                            $ST02__TransactionSetId="49731";
                            $ST02__TransactionSetControlNumber="005010X222A1";

                            fwrite($X12__811__File, "ST*".
                                $ST01__TransactionSetId."*".
                                $ST02__TransactionSetId."*".
                                $ST02__TransactionSetControlNumber.
                                "~".$linefeed);

                            $TransactionSegmentCount=1;

                            $BIG01 = "0019";
                            $BIG02 = "00";
                            $BIG03 = "202647";
                            $BIG04 = "20210818";
                            $BIG05 = "0939";
                            $BIG06 = "CH";

                            fwrite($X12__811__File, "BHT*".$BIG01."*".$BIG02."*".$BIG03."*".$BIG04."*".$BIG05."*".$BIG06."~".$linefeed);

                            $TransactionSegmentCount=1;
                            $NM101="41";
                            $NM102="2";
                            $NM103 = "ANVICARE";
                            $NM104 = "46";
                            $NM105 = "582628754";

                            fwrite($X12__811__File, "NM1*".$NM101."*".$NM102."*".$NM103."*****".$NM104."*".$NM105."~".$linefeed);
                            $TransactionSegmentCount++;

                            $PER = "PER*IC*QUOC NGUYEN*TE*2813250208*EM*QDN@ANVICARE.COM*FX*2813130925~";
                            fwrite($X12__811__File, $PER.$linefeed);            

                            $NM1 = "NM1*40*2*".strtoupper($row['"Insurance Company Name"'])."*****46*68024~";
                            fwrite($X12__811__File, $NM1.$linefeed);
                        }

                        if($LScheck) {
                            $HL = "HL*1**20*1~";
                            fwrite($X12__811__File, $HL.$linefeed);

                            $taxo = $row['"33-B-TAXO"'];

                            $PRV = "PRV*BI*PXC*".$taxo."~";
                            fwrite($X12__811__File, $PRV.$linefeed);

                            $clinicName = strtoupper($row['"33-ClinicName"']);

                            $NM1 = "NM1*85*2*".$clinicName."~";
                            fwrite($X12__811__File, $NM1.$linefeed);

                            $clinicAddress = strtoupper($row['"33-ClinicAddressLine1"']);

                            $N3 = "N3*".$clinicAddress."~";
                            fwrite($X12__811__File, $N3.$linefeed);

                            $ClinicCityStateZip = strtoupper(str_replace(',','*',$row['"33-ClinicCityStateZip"']));

                            $N4 = "N4*".$ClinicCityStateZip."3103~";
                            fwrite($X12__811__File, $N4.$linefeed);

                            $REF = "REF*EI*".$row['"25-TaxID"']."~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            $PER = "PER*IC*".$clinicName."*TE*8005551212~";
                            fwrite($X12__811__File, $PER.$linefeed);

                            $HL = "HL*2*1*22*0~";
                            fwrite($X12__811__File, $HL.$linefeed);

                            $SBR = "SBR*P*18*******CI~";
                            fwrite($X12__811__File, $SBR.$linefeed);

                            $ptName = strtoupper(str_replace(', ', '*', $row['"2-PatientName"']));

                            $NM1 = "NM1*".$row['"5-PatientState"']."*1*".$ptName."****MI*".$row['"1a-InsuredIDNo"']."~";
                            fwrite($X12__811__File, $NM1.$linefeed);

                            $InsuredAddr = strtoupper($row['"7-InsuredAddr"']);

                            $N3 = "N3*".$InsuredAddr."~";
                            fwrite($X12__811__File, $N3.$linefeed);

                            $city = strtoupper($row['"5-PatientCity"']);
                            $state = strtoupper($row['"5-PatientState"']);
                            $zipcode = $row['"5-PatientZip"'];

                            $N4 = "N4*".$city."*".$state."*".$zipcode."~";
                            fwrite($X12__811__File, $N4.$linefeed);

                            $DOB = date('Ymd', strtotime($row['"3-PatientDOB"']));
                            $GENDER = $row['"3-PatientGender"'];

                            $DMG = "DMG*D8*".$DOB."*".$GENDER."~";
                            fwrite($X12__811__File, $DMG.$linefeed);

                            $NM1 = "NM1*PR*2*".strtoupper($row['"Insurance Company Name"'])."*****PI*".$row['"26-PatientAcctNo"']."~";
                            fwrite($X12__811__File, $NM1.$linefeed);

                            $address1 = $row['"Insurance Company Address 1"'];
                            $address1 = strtoupper(str_replace(".", "", $address1));

                            $N3 = "N3*".$address1."~";
                            fwrite($X12__811__File, $N3.$linefeed);

                            $N4 = "N4*PHOENIX*AZ*85082~";
                            fwrite($X12__811__File, $N4.$linefeed);

                            $REF = "REF*G2*".$row['"33-b-GrpLegacyNo"']."~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            //$CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$row['"28-TotalCharge"']."***12:B:1*Y*A*Y*Y*P~";
                            $CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$TotalCharge."***12:B:1*Y*A*Y*Y*P~";               
                            fwrite($X12__811__File, $CLM.$linefeed);

                            $REF = "REF*G1*".$row['"23-PriorAuth"']."~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            $REF = "REF*D9*73629855~";
                            fwrite($X12__811__File, $REF.$linefeed);

                            $HI = "HI*ABK:R6889~";
                            fwrite($X12__811__File, $HI.$linefeed);
                        }

                        if($LScheck) {
                            $z = 1;
                        }
                        //for ($i=0; $i < $LScount ; $i++) { 
                            // code...              
                        if($LScheck) {
                            foreach ($result as $key1 => $value1) {

                                if(!empty($value1['"24.1.f-Charges"']) && in_array($value1['"24.1.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.1.f-Charges"']."*UN*".$value1['"24.1.g-Units"']."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                    $SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.1.a-DOSFrom"']]."*UN*".$Units[$value1['"24.1.a-DOSFrom"']]."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom1 = date('Ymd', strtotime($value1['"24.1.a-DOSFrom"']));
                                    $dto1 = date('Ymd', strtotime($value1['"24.1.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom1."-".$dto1."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985501~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment1 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.1.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment1."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;
                                    
                                    if (($key = array_search($value1['"24.1.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.2.f-Charges"']) && in_array($value1['"24.2.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.2.f-Charges"']."*UN*".$value1['"24.2.g-Units"']."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.2.a-DOSFrom"']]."*UN*".$Units[$value1['"24.2.a-DOSFrom"']]."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom2 = date('Ymd', strtotime($value1['"24.2.a-DOSFrom"']));
                                    $dto2 = date('Ymd', strtotime($value1['"24.2.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom2."-".$dto2."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985502~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment2 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.2.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment2."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.2.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.3.f-Charges"']) && in_array($value1['"24.3.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.3.f-Charges"']."*UN*".$value1['"24.3.g-Units"']."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.3.a-DOSFrom"']]."*UN*".$Units[$value1['"24.3.a-DOSFrom"']]."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom3 = date('Ymd', strtotime($value1['"24.3.a-DOSFrom"']));
                                    $dto3 = date('Ymd', strtotime($value1['"24.3.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom3."-".$dto3."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985503~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment3 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.3.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment3."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.3.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.4.f-Charges"']) && in_array($value1['"24.4.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.4.f-Charges"']."*UN*".$value1['"24.4.g-Units"']."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.4.a-DOSFrom"']]."*UN*".$Units[$value1['"24.4.a-DOSFrom"']]."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom4 = date('Ymd', strtotime($value1['"24.4.a-DOSFrom"']));
                                    $dto4 = date('Ymd', strtotime($value1['"24.4.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom4."-".$dto4."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985504~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment4 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.4.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment4."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.4.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.5.f-Charges"']) && in_array($value1['"24.5.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.5.f-Charges"']."*UN*".$value1['"24.5.g-Units"']."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.5.a-DOSFrom"']]."*UN*".$Units[$value1['"24.5.a-DOSFrom"']]."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom5 = date('Ymd', strtotime($value1['"24.5.a-DOSFrom"']));
                                    $dto5 = date('Ymd', strtotime($value1['"24.5.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom5."-".$dto5."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985505~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment5 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.5.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment5."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.5.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                }

                                if(!empty($value1['"24.6.f-Charges"']) && in_array($value1['"24.6.a-DOSFrom"'], $checkDates)) {
                                    $LX = "LX*".$z."~";
                                    fwrite($X12__811__File, $LX.$linefeed);
                                    //$SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.6.f-Charges"']."*UN*".$value1['"24.6.g-Units"']."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";

                                    $SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$Charges[$value1['"24.6.a-DOSFrom"']]."*UN*".$Units[$value1['"24.6.a-DOSFrom"']]."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";
                                    fwrite($X12__811__File, $SV1.$linefeed);

                                    $dfrom6 = date('Ymd', strtotime($value1['"24.6.a-DOSFrom"']));
                                    $dto6 = date('Ymd', strtotime($value1['"24.6.a-DOSTo"']));

                                    $DTP = "DTP*472*RD8*".$dfrom6."-".$dto6."~";
                                    fwrite($X12__811__File, $DTP.$linefeed);

                                    $REF = "REF*6R*7362985506~";
                                    fwrite($X12__811__File, $REF.$linefeed);

                                    $comment6 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.6.SrvComment"'])));
                                    $NTE = "NTE*ADD*".$comment6."~";
                                    fwrite($X12__811__File, $NTE.$linefeed);

                                    $z++;

                                    if (($key = array_search($value1['"24.6.a-DOSFrom"'], $checkDates)) !== false) {
                                        unset($checkDates[$key]);
                                    }
                                } 
                            }
                        }
                        //}
                        /********** Start 837p file generation code ************/
                        $x++;
                    }
                }

                unset($_SESSION['rxx']);

                if($x>1) {
                    $SE = "SE*57*49731~";
                    fwrite($X12__811__File, $SE.$linefeed);
                    $GE = "GE*1*120264701~";
                    fwrite($X12__811__File, $GE.$linefeed);
                    $IEA = "IEA*1*001202647~";
                    fwrite($X12__811__File, $IEA.$linefeed);
                    fclose($X12__811__File);
                    //echo $filename; die;

                    $this->session->set_flashdata('message','Edi claim file has been generated successfully.');
                    print_r('837p.txt');
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record.');
                print_r(0);
            }
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function generateEdiClaimOld() {
        $action = $_POST['action'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $viewmode = $_POST['viewmode'];
        $agency_code = $_POST['agency_code'];

        if(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code) && $action=='selected') {
            $params = $_POST['params'];
            $params = rtrim($params, '|');
            $cms1500Ids = explode('|', $params);

            if(!empty($cms1500Ids)) {
                $x=1; $check = true; $clientArr = [];
                foreach ($cms1500Ids as $key => $cms1500_id) {
                    $sql = "select * from eclaimsLTS where cms1500_id='".$cms1500_id."'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');                        
                    $clientArr[$cms1500_id] = $row['patient_id'];           
                }

                $vals = array_count_values($clientArr);
                $checkPatient = [];

                foreach ($cms1500Ids as $key => $cms1500_id) {
                    $LScheck = true;
                    $TotalCharge = 0;
                    $checkNoOfCharges = 0;
                    /********** Start 837p file generation code ************/
                    $sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id='".$cms1500_id."'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    if(empty($row['cms1500_id'])) {
                        continue;
                    }

                    $cond = "";
                    if($viewmode==1 || $viewmode==2) {
                        $cond = " AND qb = '' AND (eclaimsLTS.paid = 0 OR eclaimsLTS.paid = 3)";
                    }
                    if($viewmode==3) {
                        $cond = " AND qb = 'yes' AND (eclaimsLTS.paid = 0)";
                    }

                    $sql = "SELECT * FROM eclaimsLTS WHERE patient_id='".$row['patient_id']."' AND month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."'".$cond."";
                    $result = $this->Comman_model->getCustomQueryData($sql);
                    foreach ($result as $key1 => $value1) {
                        // code...
                        if(!empty($value1['"24.1.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.2.f-Charges"'])) {
                            $checkNoOfCharges++;    
                        }
                        if(!empty($value1['"24.3.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.4.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.5.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.6.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        $num = floatval(str_replace(",","",$value1['"28-TotalCharge"']));
                        $TotalCharge = $TotalCharge + $num;
                    }

                    if($checkNoOfCharges>6) {
                        $TotalCharge = number_format((float)$TotalCharge, 2, '.', '');
                    } else {
                        $num = floatval(str_replace(",","",$row['"28-TotalCharge"']));
                        $TotalCharge = number_format((float)$num, 2, '.', '');
                    }            

                    if(in_array($row['patient_id'], $checkPatient)) {
                        //continue;
                        $LScheck = false;
                    }

                    if (array_key_exists($row['patient_id'],$vals)) {
                        $LScount = $vals[$row['patient_id']];
                        array_push($checkPatient, $row['patient_id']);
                    }

                    //print_r($row);die;

                    $check = false;
                   
                    $linefeed="\n"; 
                    $infomsg="";
                    $errormsg="";

                    $check__count=0;
                    $claim__count=0;
                    $proc__count=0;
                    $charges=0;
                    $net__amount=0;
                    $total__NumberofIncludedSegments=0;


                    if($x==1) { // Write only once.

                        //$name = preg_replace('/[ ,]+/', '', $row['"2-PatientName"']);
                        //$name .= "-837p.txt";
                        $name = "837p.txt";
                        $url = FCPATH."/assets/edi/".$name;
                        $filename = $url;

                        $X12__811__File = fopen($filename,'w');
                        $ISA01__AuthorInfoQual="00";      
                        $ISA02__AuthorInformation=" ";
                        $ISA03__SecurityInfoQual="00";
                        $ISA04__SecurityInformation=" ";
                        $ISA05__InterchangeIDQual="ZZ";
                        $ISA06__InterchangeSenderID="AV09311993";
                        $ISA07__InterchangeIDQual="01";
                        $ISA08__InterchangeReceiverID="030240928";
                        $ISA09__InterchangeDate=date("ymd");
                        $ISA10__InterchangeTime=date("hm");
                        $ISA11__InterchangeStandardID="^";
                        $ISA12__InterchangeControlVersionID="00401";
                        $ISA13__InterchangeControlNumber="0".date("mdHi");
                        $ISA14__InterchangeAckRequested="1";
                        $ISA15__TestIndicator="P";        
                        $ISA16__SubElementSeperator=":";

                        fwrite($X12__811__File, "ISA*"
                            .$ISA01__AuthorInfoQual."*"
                            .$ISA02__AuthorInformation."*"
                            .$ISA03__SecurityInfoQual."*"
                            .$ISA04__SecurityInformation."*"
                            .$ISA05__InterchangeIDQual."*"
                            .$ISA06__InterchangeSenderID." *"
                            .$ISA07__InterchangeIDQual."*"
                            .$ISA08__InterchangeReceiverID." *"
                            .$ISA09__InterchangeDate."*"
                            .$ISA10__InterchangeTime."*"
                            .$ISA11__InterchangeStandardID."*"
                            .$ISA12__InterchangeControlVersionID."*"
                            .$ISA13__InterchangeControlNumber."*"
                            .$ISA14__InterchangeAckRequested."*"
                            .$ISA15__TestIndicator."*"
                            .$ISA16__SubElementSeperator
                            ."~".$linefeed);

                        $GS01__FunctionalIdentifierCode="HC";
                        $GS02__ApplicationSendersCode="AV01101957";
                        $GS03__ApplicationReceiversCode="030240928";
                        $GS04__GroupDate=date("Ymd");
                        $GS05__GroupTime=date("hm");
                        $GS06__GroupControlNumber="120264701";
                        $GS07__ResponsibleAgencyCode="X";
                        $GS08__VersionRelease="005010X222A1";

                        fwrite($X12__811__File, "GS*".
                            $GS01__FunctionalIdentifierCode."*".
                            $GS02__ApplicationSendersCode."*".
                            $GS03__ApplicationReceiversCode."*".
                            $GS04__GroupDate."*".
                            $GS05__GroupTime."*".
                            $GS06__GroupControlNumber."*".
                            $GS07__ResponsibleAgencyCode."*".
                            $GS08__VersionRelease.
                            "~".$linefeed);

                        $ST01__TransactionSetId="837";
                        $ST02__TransactionSetId="49731";
                        $ST02__TransactionSetControlNumber="005010X222A1";

                        fwrite($X12__811__File, "ST*".
                            $ST01__TransactionSetId."*".
                            $ST02__TransactionSetId."*".
                            $ST02__TransactionSetControlNumber.
                            "~".$linefeed);

                        $TransactionSegmentCount=1;

                        $BIG01 = "0019";
                        $BIG02 = "00";
                        $BIG03 = "202647";
                        $BIG04 = "20210818";
                        $BIG05 = "0939";
                        $BIG06 = "CH";

                        fwrite($X12__811__File, "BHT*".$BIG01."*".$BIG02."*".$BIG03."*".$BIG04."*".$BIG05."*".$BIG06."~".$linefeed);

                        $TransactionSegmentCount=1;
                        $NM101="41";
                        $NM102="2";
                        $NM103 = "ANVICARE";
                        $NM104 = "46";
                        $NM105 = "582628754";

                        fwrite($X12__811__File, "NM1*".$NM101."*".$NM102."*".$NM103."*****".$NM104."*".$NM105."~".$linefeed);
                        $TransactionSegmentCount++;

                        $PER = "PER*IC*QUOC NGUYEN*TE*2813250208*EM*QDN@ANVICARE.COM*FX*2813130925~";
                        fwrite($X12__811__File, $PER.$linefeed);            

                        $NM1 = "NM1*40*2*".strtoupper($row['"Insurance Company Name"'])."*****46*68024~";
                        fwrite($X12__811__File, $NM1.$linefeed);
                    }

                    if($LScheck) {
                        $HL = "HL*1**20*1~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $taxo = $row['"33-B-TAXO"'];

                        $PRV = "PRV*BI*PXC*".$taxo."~";
                        fwrite($X12__811__File, $PRV.$linefeed);

                        $clinicName = strtoupper($row['"33-ClinicName"']);

                        $NM1 = "NM1*85*2*".$clinicName."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $clinicAddress = strtoupper($row['"33-ClinicAddressLine1"']);

                        $N3 = "N3*".$clinicAddress."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $ClinicCityStateZip = strtoupper(str_replace(',','*',$row['"33-ClinicCityStateZip"']));

                        $N4 = "N4*".$ClinicCityStateZip."3103~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*EI*".$row['"25-TaxID"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $PER = "PER*IC*".$clinicName."*TE*8005551212~";
                        fwrite($X12__811__File, $PER.$linefeed);

                        $HL = "HL*2*1*22*0~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $SBR = "SBR*P*18*******CI~";
                        fwrite($X12__811__File, $SBR.$linefeed);

                        $ptName = strtoupper(str_replace(', ', '*', $row['"2-PatientName"']));

                        $NM1 = "NM1*".$row['"5-PatientState"']."*1*".$ptName."****MI*".$row['"1a-InsuredIDNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $InsuredAddr = strtoupper($row['"7-InsuredAddr"']);

                        $N3 = "N3*".$InsuredAddr."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $city = strtoupper($row['"5-PatientCity"']);
                        $state = strtoupper($row['"5-PatientState"']);
                        $zipcode = $row['"5-PatientZip"'];

                        $N4 = "N4*".$city."*".$state."*".$zipcode."~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $DOB = date('Ymd', strtotime($row['"3-PatientDOB"']));
                        $GENDER = $row['"3-PatientGender"'];

                        $DMG = "DMG*D8*".$DOB."*".$GENDER."~";
                        fwrite($X12__811__File, $DMG.$linefeed);

                        $NM1 = "NM1*PR*2*".strtoupper($row['"Insurance Company Name"'])."*****PI*".$row['"26-PatientAcctNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $address1 = $row['"Insurance Company Address 1"'];
                        $address1 = strtoupper(str_replace(".", "", $address1));

                        $N3 = "N3*".$address1."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $N4 = "N4*PHOENIX*AZ*85082~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*G2*".$row['"33-b-GrpLegacyNo"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        //$CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$row['"28-TotalCharge"']."***12:B:1*Y*A*Y*Y*P~";
                        $CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$TotalCharge."***12:B:1*Y*A*Y*Y*P~";               
                        fwrite($X12__811__File, $CLM.$linefeed);

                        $REF = "REF*G1*".$row['"23-PriorAuth"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $REF = "REF*D9*73629855~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $HI = "HI*ABK:R6889~";
                        fwrite($X12__811__File, $HI.$linefeed);
                    }

                    if($LScheck) {
                        $z = 1;
                    }
                    //for ($i=0; $i < $LScount ; $i++) { 
                        // code...              
                    if($LScheck) {
                        foreach ($result as $key1 => $value1) {

                            if(!empty($value1['"24.1.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.1.f-Charges"']."*UN*".$value1['"24.1.g-Units"']."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom1 = date('Ymd', strtotime($value1['"24.1.a-DOSFrom"']));
                                $dto1 = date('Ymd', strtotime($value1['"24.1.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom1."-".$dto1."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985501~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment1 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.1.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment1."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.2.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.2.f-Charges"']."*UN*".$value1['"24.2.g-Units"']."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom2 = date('Ymd', strtotime($value1['"24.2.a-DOSFrom"']));
                                $dto2 = date('Ymd', strtotime($value1['"24.2.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom2."-".$dto2."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985502~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment2 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.2.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment2."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.3.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.3.f-Charges"']."*UN*".$value1['"24.3.g-Units"']."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom3 = date('Ymd', strtotime($value1['"24.3.a-DOSFrom"']));
                                $dto3 = date('Ymd', strtotime($value1['"24.3.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom3."-".$dto3."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985503~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment3 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.3.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment3."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.4.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.4.f-Charges"']."*UN*".$value1['"24.4.g-Units"']."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom4 = date('Ymd', strtotime($value1['"24.4.a-DOSFrom"']));
                                $dto4 = date('Ymd', strtotime($value1['"24.4.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom4."-".$dto4."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985504~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment4 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.4.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment4."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.5.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.5.f-Charges"']."*UN*".$value1['"24.5.g-Units"']."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom5 = date('Ymd', strtotime($value1['"24.5.a-DOSFrom"']));
                                $dto5 = date('Ymd', strtotime($value1['"24.5.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom5."-".$dto5."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985505~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment5 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.5.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment5."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.6.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.6.f-Charges"']."*UN*".$value1['"24.6.g-Units"']."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom6 = date('Ymd', strtotime($value1['"24.6.a-DOSFrom"']));
                                $dto6 = date('Ymd', strtotime($value1['"24.6.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom6."-".$dto6."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985506~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment6 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.6.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment6."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            } 
                        }
                    }
                    //}
                    /********** Start 837p file generation code ************/
                    $x++;
                }

                if($x>1) {
                    $SE = "SE*57*49731~";
                    fwrite($X12__811__File, $SE.$linefeed);
                    $GE = "GE*1*120264701~";
                    fwrite($X12__811__File, $GE.$linefeed);
                    $IEA = "IEA*1*001202647~";
                    fwrite($X12__811__File, $IEA.$linefeed);
                    fclose($X12__811__File);
                    //echo $filename; die;
                    $this->session->set_flashdata('message','Edi claim file has been generated successfully.');
                    print_r($filename);
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record.');
                print_r(0);
            }
        } elseif(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code) && $action=='all') {
            //$params = $_POST['params'];
            //$params = rtrim($params, '|');
            //$cms1500Ids = explode('|', $params);
            $cond = "";
            if($viewmode==1 || $viewmode==2) {
                $cond = " AND qb = '' AND (eclaimsLTS.paid = 0 OR eclaimsLTS.paid = 3)";
            }
            if($viewmode==3) {
                $cond = " AND qb = 'yes' AND (eclaimsLTS.paid = 0)";
            }

            $sql = "SELECT eclaimsLTS.cms1500_id, eclaimsLTS.patient_id FROM eclaimsLTS,tbldistricts WHERE tbldistricts.DistrictID = eclaimsLTS.mco AND eclaimsLTS.month = '$month' AND eclaimsLTS.year = '$year' AND eclaimsLTS.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'".$cond."";
            $res = $this->Comman_model->getCustomQueryData($sql);
            if(!empty($res)) {
                $x=1; $check = true; $clientArr = [];
                //foreach ($cms1500Ids as $key => $cms1500_id) {
                foreach ($res as $key => $row) {
                    $cms1500_id = $row['cms1500_id'];
                    //$sql = "select * from eclaimsLTS where cms1500_id='".$cms1500_id."'";
                    //$row = $this->Comman_model->getCustomQueryData($sql, 'row');                        
                    $clientArr[$cms1500_id] = $row['patient_id'];           
                }

                $vals = array_count_values($clientArr);
                $checkPatient = [];

                //foreach ($cms1500Ids as $key => $cms1500_id) {
                foreach ($res as $key => $row) {  
                    $cms1500_id = $row['cms1500_id'];
                    $LScheck = true;
                    $TotalCharge = 0;
                    $checkNoOfCharges = 0;
                    /********** Start 837p file generation code ************/
                    $sql = "SELECT * FROM eclaimsLTS WHERE cms1500_id='".$cms1500_id."'";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    if(empty($row['cms1500_id'])) {
                        continue;
                    }

                    $sql = "SELECT * FROM eclaimsLTS WHERE patient_id='".$row['patient_id']."' AND month = '".$month."' AND year = '".$year."' AND Agency = '".$agency_code."'".$cond."";
                    $result = $this->Comman_model->getCustomQueryData($sql);
                    foreach ($result as $key1 => $value1) {
                        // code...
                        if(!empty($value1['"24.1.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.2.f-Charges"'])) {
                            $checkNoOfCharges++;    
                        }
                        if(!empty($value1['"24.3.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.4.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.5.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        if(!empty($value1['"24.6.f-Charges"'])) {
                            $checkNoOfCharges++;
                        }
                        $num = floatval(str_replace(",","",$value1['"28-TotalCharge"']));
                        $TotalCharge = $TotalCharge + $num;
                    }

                    if($checkNoOfCharges>6) {
                        $TotalCharge = number_format((float)$TotalCharge, 2, '.', '');
                    } else {
                        $num = floatval(str_replace(",","",$row['"28-TotalCharge"']));
                        $TotalCharge = number_format((float)$num, 2, '.', '');
                    }            

                    if(in_array($row['patient_id'], $checkPatient)) {
                        //continue;
                        $LScheck = false;
                    }

                    if (array_key_exists($row['patient_id'],$vals)) {
                        $LScount = $vals[$row['patient_id']];
                        array_push($checkPatient, $row['patient_id']);
                    }

                    //print_r($row);die;

                    $check = false;
                   
                    $linefeed="\n"; 
                    $infomsg="";
                    $errormsg="";

                    $check__count=0;
                    $claim__count=0;
                    $proc__count=0;
                    $charges=0;
                    $net__amount=0;
                    $total__NumberofIncludedSegments=0;


                    if($x==1) { // Write only once.
                        //$name = preg_replace('/[ ,]+/', '', $row['"2-PatientName"']);
                        //$name .= "-837p.txt";
                        $name = "837p.txt";
                        $url = FCPATH."/assets/edi/".$name;
                        $filename = $url;

                        $X12__811__File = fopen($filename,'w');
                        $ISA01__AuthorInfoQual="00";      
                        $ISA02__AuthorInformation=" ";
                        $ISA03__SecurityInfoQual="00";
                        $ISA04__SecurityInformation=" ";
                        $ISA05__InterchangeIDQual="ZZ";
                        $ISA06__InterchangeSenderID="AV09311993";
                        $ISA07__InterchangeIDQual="01";
                        $ISA08__InterchangeReceiverID="030240928";
                        $ISA09__InterchangeDate=date("ymd");
                        $ISA10__InterchangeTime=date("hm");
                        $ISA11__InterchangeStandardID="^";
                        $ISA12__InterchangeControlVersionID="00401";
                        $ISA13__InterchangeControlNumber="0".date("mdHi");
                        $ISA14__InterchangeAckRequested="1";
                        $ISA15__TestIndicator="P";        
                        $ISA16__SubElementSeperator=":";

                        fwrite($X12__811__File, "ISA*"
                            .$ISA01__AuthorInfoQual."*"
                            .$ISA02__AuthorInformation."*"
                            .$ISA03__SecurityInfoQual."*"
                            .$ISA04__SecurityInformation."*"
                            .$ISA05__InterchangeIDQual."*"
                            .$ISA06__InterchangeSenderID." *"
                            .$ISA07__InterchangeIDQual."*"
                            .$ISA08__InterchangeReceiverID." *"
                            .$ISA09__InterchangeDate."*"
                            .$ISA10__InterchangeTime."*"
                            .$ISA11__InterchangeStandardID."*"
                            .$ISA12__InterchangeControlVersionID."*"
                            .$ISA13__InterchangeControlNumber."*"
                            .$ISA14__InterchangeAckRequested."*"
                            .$ISA15__TestIndicator."*"
                            .$ISA16__SubElementSeperator
                            ."~".$linefeed);

                        $GS01__FunctionalIdentifierCode="HC";
                        $GS02__ApplicationSendersCode="AV01101957";
                        $GS03__ApplicationReceiversCode="030240928";
                        $GS04__GroupDate=date("Ymd");
                        $GS05__GroupTime=date("hm");
                        $GS06__GroupControlNumber="120264701";
                        $GS07__ResponsibleAgencyCode="X";
                        $GS08__VersionRelease="005010X222A1";

                        fwrite($X12__811__File, "GS*".
                            $GS01__FunctionalIdentifierCode."*".
                            $GS02__ApplicationSendersCode."*".
                            $GS03__ApplicationReceiversCode."*".
                            $GS04__GroupDate."*".
                            $GS05__GroupTime."*".
                            $GS06__GroupControlNumber."*".
                            $GS07__ResponsibleAgencyCode."*".
                            $GS08__VersionRelease.
                            "~".$linefeed);

                        $ST01__TransactionSetId="837";
                        $ST02__TransactionSetId="49731";
                        $ST02__TransactionSetControlNumber="005010X222A1";

                        fwrite($X12__811__File, "ST*".
                            $ST01__TransactionSetId."*".
                            $ST02__TransactionSetId."*".
                            $ST02__TransactionSetControlNumber.
                            "~".$linefeed);

                        $TransactionSegmentCount=1;

                        $BIG01 = "0019";
                        $BIG02 = "00";
                        $BIG03 = "202647";
                        $BIG04 = "20210818";
                        $BIG05 = "0939";
                        $BIG06 = "CH";

                        fwrite($X12__811__File, "BHT*".$BIG01."*".$BIG02."*".$BIG03."*".$BIG04."*".$BIG05."*".$BIG06."~".$linefeed);

                        $TransactionSegmentCount=1;
                        $NM101="41";
                        $NM102="2";
                        $NM103 = "ANVICARE";
                        $NM104 = "46";
                        $NM105 = "582628754";

                        fwrite($X12__811__File, "NM1*".$NM101."*".$NM102."*".$NM103."*****".$NM104."*".$NM105."~".$linefeed);
                        $TransactionSegmentCount++;

                        $PER = "PER*IC*QUOC NGUYEN*TE*2813250208*EM*QDN@ANVICARE.COM*FX*2813130925~";
                        fwrite($X12__811__File, $PER.$linefeed);            

                        $NM1 = "NM1*40*2*".strtoupper($row['"Insurance Company Name"'])."*****46*68024~";
                        fwrite($X12__811__File, $NM1.$linefeed);
                    }

                    if($LScheck) {
                        $HL = "HL*1**20*1~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $taxo = $row['"33-B-TAXO"'];

                        $PRV = "PRV*BI*PXC*".$taxo."~";
                        fwrite($X12__811__File, $PRV.$linefeed);

                        $clinicName = strtoupper($row['"33-ClinicName"']);

                        $NM1 = "NM1*85*2*".$clinicName."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $clinicAddress = strtoupper($row['"33-ClinicAddressLine1"']);

                        $N3 = "N3*".$clinicAddress."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $ClinicCityStateZip = strtoupper(str_replace(',','*',$row['"33-ClinicCityStateZip"']));

                        $N4 = "N4*".$ClinicCityStateZip."3103~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*EI*".$row['"25-TaxID"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $PER = "PER*IC*".$clinicName."*TE*8005551212~";
                        fwrite($X12__811__File, $PER.$linefeed);

                        $HL = "HL*2*1*22*0~";
                        fwrite($X12__811__File, $HL.$linefeed);

                        $SBR = "SBR*P*18*******CI~";
                        fwrite($X12__811__File, $SBR.$linefeed);

                        $ptName = strtoupper(str_replace(', ', '*', $row['"2-PatientName"']));

                        $NM1 = "NM1*".$row['"5-PatientState"']."*1*".$ptName."****MI*".$row['"1a-InsuredIDNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $InsuredAddr = strtoupper($row['"7-InsuredAddr"']);

                        $N3 = "N3*".$InsuredAddr."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $city = strtoupper($row['"5-PatientCity"']);
                        $state = strtoupper($row['"5-PatientState"']);
                        $zipcode = $row['"5-PatientZip"'];

                        $N4 = "N4*".$city."*".$state."*".$zipcode."~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $DOB = date('Ymd', strtotime($row['"3-PatientDOB"']));
                        $GENDER = $row['"3-PatientGender"'];

                        $DMG = "DMG*D8*".$DOB."*".$GENDER."~";
                        fwrite($X12__811__File, $DMG.$linefeed);

                        $NM1 = "NM1*PR*2*".strtoupper($row['"Insurance Company Name"'])."*****PI*".$row['"26-PatientAcctNo"']."~";
                        fwrite($X12__811__File, $NM1.$linefeed);

                        $address1 = $row['"Insurance Company Address 1"'];
                        $address1 = strtoupper(str_replace(".", "", $address1));

                        $N3 = "N3*".$address1."~";
                        fwrite($X12__811__File, $N3.$linefeed);

                        $N4 = "N4*PHOENIX*AZ*85082~";
                        fwrite($X12__811__File, $N4.$linefeed);

                        $REF = "REF*G2*".$row['"33-b-GrpLegacyNo"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        //$CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$row['"28-TotalCharge"']."***12:B:1*Y*A*Y*Y*P~";
                        $CLM = "CLM*".$row['"26-PatientAcctNo"']."*".$TotalCharge."***12:B:1*Y*A*Y*Y*P~";               
                        fwrite($X12__811__File, $CLM.$linefeed);

                        $REF = "REF*G1*".$row['"23-PriorAuth"']."~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $REF = "REF*D9*73629855~";
                        fwrite($X12__811__File, $REF.$linefeed);

                        $HI = "HI*ABK:R6889~";
                        fwrite($X12__811__File, $HI.$linefeed);
                    }

                    if($LScheck) {
                        $z = 1;
                    }
                    //for ($i=0; $i < $LScount ; $i++) { 
                        // code...              
                    if($LScheck) {
                        foreach ($result as $key1 => $value1) {

                            if(!empty($value1['"24.1.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.1.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.1.f-Charges"']."*UN*".$value1['"24.1.g-Units"']."*".$value1['"24.1.b-Place"']."**".$value1['"24.1.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom1 = date('Ymd', strtotime($value1['"24.1.a-DOSFrom"']));
                                $dto1 = date('Ymd', strtotime($value1['"24.1.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom1."-".$dto1."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985501~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment1 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.1.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment1."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.2.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.2.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.2.f-Charges"']."*UN*".$value1['"24.2.g-Units"']."*".$value1['"24.2.b-Place"']."**".$value1['"24.2.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom2 = date('Ymd', strtotime($value1['"24.2.a-DOSFrom"']));
                                $dto2 = date('Ymd', strtotime($value1['"24.2.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom2."-".$dto2."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985502~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment2 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.2.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment2."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.3.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.3.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.3.f-Charges"']."*UN*".$value1['"24.3.g-Units"']."*".$value1['"24.3.b-Place"']."**".$value1['"24.3.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom3 = date('Ymd', strtotime($value1['"24.3.a-DOSFrom"']));
                                $dto3 = date('Ymd', strtotime($value1['"24.3.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom3."-".$dto3."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985503~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment3 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.3.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment3."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.4.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.4.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.4.f-Charges"']."*UN*".$value1['"24.4.g-Units"']."*".$value1['"24.4.b-Place"']."**".$value1['"24.4.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom4 = date('Ymd', strtotime($value1['"24.4.a-DOSFrom"']));
                                $dto4 = date('Ymd', strtotime($value1['"24.4.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom4."-".$dto4."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985504~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment4 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.4.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment4."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.5.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.5.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.5.f-Charges"']."*UN*".$value1['"24.5.g-Units"']."*".$value1['"24.5.b-Place"']."**".$value1['"24.5.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom5 = date('Ymd', strtotime($value1['"24.5.a-DOSFrom"']));
                                $dto5 = date('Ymd', strtotime($value1['"24.5.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom5."-".$dto5."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985505~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment5 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.5.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment5."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            }

                            if(!empty($value1['"24.6.f-Charges"'])) {
                                $LX = "LX*".$z."~";
                                fwrite($X12__811__File, $LX.$linefeed);
                                $SV1 = "SV1*HC:".$value1['"24.6.d-CPT"'].":::::HOMAKER SRVC*".$value1['"24.6.f-Charges"']."*UN*".$value1['"24.6.g-Units"']."*".$value1['"24.6.b-Place"']."**".$value1['"24.6.e-Code"']."~";
                                fwrite($X12__811__File, $SV1.$linefeed);

                                $dfrom6 = date('Ymd', strtotime($value1['"24.6.a-DOSFrom"']));
                                $dto6 = date('Ymd', strtotime($value1['"24.6.a-DOSTo"']));

                                $DTP = "DTP*472*RD8*".$dfrom6."-".$dto6."~";
                                fwrite($X12__811__File, $DTP.$linefeed);

                                $REF = "REF*6R*7362985506~";
                                fwrite($X12__811__File, $REF.$linefeed);

                                $comment6 = strtoupper(str_replace(';', ' ', str_replace(',', ' ', $value1['"24.6.SrvComment"'])));
                                $NTE = "NTE*ADD*".$comment6."~";
                                fwrite($X12__811__File, $NTE.$linefeed);

                                $z++;
                            } 
                        }
                    }
                    //}
                    /********** Start 837p file generation code ************/
                    $x++;
                }

                if($x>1) {
                    $SE = "SE*57*49731~";
                    fwrite($X12__811__File, $SE.$linefeed);
                    $GE = "GE*1*120264701~";
                    fwrite($X12__811__File, $GE.$linefeed);
                    $IEA = "IEA*1*001202647~";
                    fwrite($X12__811__File, $IEA.$linefeed);
                    fclose($X12__811__File);
                    //echo $filename; die;

                    $this->session->set_flashdata('message','Edi claim file has been generated successfully.');
                    print_r($filename);
                }
            } else {
                $this->session->set_flashdata('error_message','Please select atleast one record.');
                print_r(0);
            }
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function downloadMiClaim() {
        $action = $_POST['action'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];

        if(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code)) {
            if ($agency_code == 1 ) { $agentdir =  "HOMEMAKERS/"; }
            if ($agency_code == 2 ) { $agentdir =  "SENIORCARES/"; }
            if ($agency_code == 3 ) { $agentdir =  "CAREGIVERS/"; }
            if ($agency_code == 4 ) { $agentdir =  "ROCKFORD/"; }

            //$sql = "SELECT * FROM eclaimsLTS WHERE month = '$month' AND year='$year' AND Agency = '$agency_code'";

            $cond = '';
            if($viewmode==2) {
                $cond = " AND qb = ''";
            }
            if($viewmode==3) {
                $cond = " AND qb = 'yes'";   
            }
            $payorgroup = $_POST['payorgroup'];
            if($payorgroup!='') {
                $cond .= " AND tbldistricts.payorGrp = '".$payorgroup."'";
            }
            $sql = "SELECT * FROM eclaimsLTS,tbldistricts WHERE tbldistricts.DistrictID = eclaims.mco AND eclaims.month = '$month' AND eclaims.year = '$year' AND eclaims.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'".$cond."";

            $filename   = "DOWNLOAD-MI-CLAIM-".date('Ymd His').".txt";
            //$filename2  = $District." ". date('Ymd His') . ".dat";
            //$filename = "/var/www/html/Dropbox/EDI/".$agentdir.$filename;
            $filename = "/var/www/html/Dropbox/EDI/".$agentdir.$filename;
            //$filename = "late.txt";
            $fh = fopen($filename, 'w') or die("can't open file");
            $flag = false;
            $row2 = 0;
            $counter = 0;
            $arry = array(' ',' ',' ',' ');
            $temptime = date("Y-m-d H:i:s");
            $result = get_custom_query_data($sql);
            foreach ($result as $key => $row) {
                $cms_id2 = $row['cms1500_id'];
                $uploadtime = $temptime;
                if(!empty($action) && $action=='all') {
                    if(!$flag) {
                        $stringData = array_keys($row);
                        for ($cnt=5;$cnt<=200;$cnt++) {
                            if ($cnt < 200)  {
                                fwrite($fh, $stringData[$cnt].",");
                            } else {
                                fwrite($fh, $stringData[$cnt]);    
                            }  
                        }
                        fwrite($fh,Chr(13).Chr(10));
                        $flag = true;
                    } else {
                        $counter++;
                        $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                        $cms_id = $row['cms1500_id'];
                    }
                    $query = "UPDATE eclaims_detailsLTS SET `status` = 'Billed' WHERE cms1500_id = '$cms_id2'";
                    set_custom_query_data($query);

                    $x = 1;
                    $stringData = array_values($row);  

                    for ($cnt=5;$cnt<=200;$cnt++) {
                        if ($cnt < 200)  {    
                            fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                        } else {
                            fwrite($fh, '"'.$stringData[$cnt].'"');    
                        }  
                    }
                    fwrite($fh,Chr(13).Chr(10));
                }

                if(!empty($action) && $action=='selected') {
                    $params = $_POST['params'];
                    $params = rtrim($params, '|');
                    $cms1500Ids = explode('|', $params);
                    if (in_array($cms_id2, $cms1500Ids)) {
                        if(!$flag) {
                            $stringData = array_keys($row);
                            for ($cnt=5;$cnt<=200;$cnt++) {
                                if ($cnt < 200)  {
                                    fwrite($fh, $stringData[$cnt].",");
                                } else {
                                    fwrite($fh, $stringData[$cnt]);    
                                }  
                            }
                            fwrite($fh,Chr(13).Chr(10));
                            $flag = true;
                        } else {
                            $counter++;
                            $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                            $cms_id = $row['cms1500_id'];
                        }
                        $query = "UPDATE eclaims_detailsLTS SET `status` = 'Billed' WHERE cms1500_id = '$cms_id2'";
                        set_custom_query_data($query);

                        $x = 1;
                        $stringData = array_values($row);  

                        for ($cnt=5;$cnt<=200;$cnt++) {
                            if ($cnt < 200)  {    
                                fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                            } else {
                                fwrite($fh, '"'.$stringData[$cnt].'"');    
                            }  
                        }
                        fwrite($fh,Chr(13).Chr(10));
                    } 
                }
            }         
            fclose($fh);
            $this->session->set_flashdata('message','Download MI Claim file has been generated successfully.');
            print_r($filename);
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }  

    function downloadEDIClaim() {
        $action = $_POST['action'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $viewmode = $_POST['viewmode'];
        $nbatchno = $_POST['nbatchno'];

        if(!empty($action) && !empty($month) && !empty($year) && !empty($agency_code)) {

            $cond = '';
            if($viewmode==2) {
                $cond = " AND qb = ''";
            }
            if($viewmode==3) {
                $cond = " AND qb = 'yes'";   
            }
            $payorgroup = $_POST['payorgroup'];
            if($payorgroup!='') {
                $cond .= " AND tbldistricts.payorGrp = '".$payorgroup."'";
            }
            if($nbatchno!='') {
                $cond .= " AND eclaimsLTS.uploadtime = '".$nbatchno."'";
            }
            $sql = "SELECT * FROM eclaimsLTS,tbldistricts WHERE tbldistricts.DistrictID = eclaimsLTS.mco AND eclaimsLTS.month = '$month' AND eclaimsLTS.year = '$year' AND eclaimsLTS.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code'".$cond."";
            //$sql = "SELECT * FROM eclaimsLTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code'";
            $flag = false;
            $row2 = 0;
            $counter = 0;
            $arry = array(' ',' ',' ',' ');
            $temptime = date("Y-m-d H:i:s");
            $result = get_custom_query_data($sql);
            foreach ($result as $key => $row) {
                $cms_id2 = $row['cms1500_id'];
                $uploadtime = $temptime;
                if(!empty($action) && $action=='all') {
                    if(!$flag) {
                        $stringData = array_keys($row);
                        for ($cnt=5;$cnt<=200;$cnt++) {
                            //$str  = $str + ($stringData[$cnt] + ',');
                            if ($cnt < 200)  {
                                //fwrite($fh, $stringData[$cnt].",");
                            } else {
                                //fwrite($fh, $stringData[$cnt]);    
                            }  
                        }
                        //fwrite($fh,Chr(13).Chr(10));
                        $flag = true;
                    } else {
                        $counter++;
                        $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                        $cms_id = $row['cms1500_id'];
                    }
                    $query = "UPDATE eclaims_detailsLTS SET `status` = 'Billed' WHERE cms1500_id = '$cms_id2'";
                    set_custom_query_data($query);

                    $_SESSION['rxx'][$cms_id2] = 'Yes';

                    $x = 1;
                    $stringData = array_values($row);  

                    for ($cnt=5;$cnt<=200;$cnt++) {
                        if ($cnt < 200) {
                            //fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                        } else {
                            //fwrite($fh, '"'.$stringData[$cnt].'"');    
                        }
                    }
                    //fwrite($fh,Chr(13).Chr(10));
                }

                if(!empty($action) && $action=='selected') {
                    $params = $_POST['params'];
                    $params = rtrim($params, '|');
                    $cms1500Ids = explode('|', $params);
                    if (in_array($cms_id2, $cms1500Ids)) {
                        if(!$flag) {
                            $stringData = array_keys($row);
                            for ($cnt=5;$cnt<=200;$cnt++) {
                                //$str  = $str + ($stringData[$cnt] + ',');
                                if ($cnt < 200)  {
                                    //fwrite($fh, $stringData[$cnt].",");
                                } else {
                                    //fwrite($fh, $stringData[$cnt]);    
                                }  
                            }
                            //fwrite($fh,Chr(13).Chr(10));
                            $flag = true;
                        } else {
                            $counter++;
                            $PayorID = $year.$month.'01'.sprintf("%03s",$counter );
                            $cms_id = $row['cms1500_id'];
                        }
                        $query = "UPDATE eclaims_detailsLTS SET `status` = 'Billed' WHERE cms1500_id = '$cms_id2'";
                        set_custom_query_data($query);

                        $x = 1;
                        $stringData = array_values($row);  

                        for ($cnt=5;$cnt<=200;$cnt++) {
                            if ($cnt < 200) {
                                //fwrite($fh, '"'.$stringData[$cnt].'"'.',');
                            } else {
                                //fwrite($fh, '"'.$stringData[$cnt].'"');    
                            }
                        }
                        //fwrite($fh,Chr(13).Chr(10));
                    }
                }
            }
            print_r(1);
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function generateQuickBooks() {
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $nbatchno = $_POST['nbatchno'];

        if(!empty($month) && !empty($year) && !empty($agency_code)) {

            $query1 = "DELETE  FROM invoice";
            get_custom_query_data_other_db($query1, 'query', $agency_code);
            $query2 = "DELETE  FROM invoicelinedetail";
            get_custom_query_data_other_db($query2, 'query', $agency_code);

            $num = 0;
            if ($agency_code == 4 )  {
                $num = 6000;
            }

            $qb = 'yes';
            $strSQL = "SELECT * FROM eclaimsLTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND paid = 0 AND qb!='$qb'";
            if(!empty($nbatchno)) {
                $strSQL .= " AND uploadtime = '$nbatchno'";                
            }
            $strSQL .= " GROUP BY patient_id";

            $objExec = get_custom_query_data($strSQL);
            foreach ($objExec as $key => $objResult) {

                $start = $objResult['start_date'];
                $cms1500_id = $objResult['cms1500_id'];
                $ptid = $objResult['patient_id'];
                $portal_id = $ptid;

                $lastdate = $year.'-'.$month.'-01';
                $lastday = date('t',strtotime($lastdate));
                $TxnDate = $lastdate;
                $ptSQL = "SELECT * FROM patient WHERE patient_id = '$ptid' AND Agency = '$agency_code'" ;
                $ptResult = get_custom_query_data($ptSQL, 'row');

                $ID2 = $ptResult['DistrictID_Ref'];
                $clientid = $ptResult['clientid'];
                $firstname = trim($ptResult['firstname']);
                $lastname = trim($ptResult['lastname']);
                $med_medicaidno = $ptResult['med_medicaidno'];   
                $mmddyylf = date('m',strtotime($objResult['date'])).date('d',strtotime($objResult['date'])).date('y',strtotime($objResult['date'])).substr($lastname,0,1).substr($firstname,0,1);
                $num++;
                $z = sprintf("%04s", $num);

                //$no = date('m',strtotime($start));
                $no = $month;
                $letter = chr(64 + $no);
                $pid = sprintf("%05d",$portal_id);
                //$mmddyylf = $letter.date('d',strtotime($start)).date('y',strtotime($start)).$pid;
                //$mmddyylf = $letter.date('d',strtotime($start)).date('y',strtotime($start)).$pid.'L';

                $mmddyylf = $letter.date('d',strtotime($lastdate)).date('y',strtotime($lastdate)).$pid.'L';

                $sql = "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND month = '$month' AND year = '$year' AND mco = '1' ORDER BY district_id DESC LIMIT 1";
                $row = get_custom_query_data($sql, 'row');
                if(!empty($row['DistrictID_Ref'])) {
                    $ID2 = $row['DistrictID_Ref'];
                } else {
                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));
                    //$sql =  "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND start_date<'$cdate' AND start_date!='0000-00-00' AND mco = '1' ORDER BY district_id DESC LIMIT 1";
                    $sql =  "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$cdate' AND start_date!='0000-00-00' AND mco = '1' ORDER BY district_id DESC LIMIT 1";
                    $row = get_custom_query_data($sql, 'row');
                    if (!empty($row['DistrictID_Ref'])) {
                        $ID2 = $row['DistrictID_Ref'];
                    }
                }

                $distSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$ID2' AND Agency = '$agency_code'" ;
                $distResult = get_custom_query_data($distSQL, 'row');
                $Diagnosis = $distResult['Diagnosis'];
                $ParentRef_FullName = $distResult['ParentRef_FullName'];

                $ARAccountRef_ListID =  '8000000E-1273000993';
                $ARAccountRef_ListID =  '8000000B-1283985346';

                $ARAccountRef_Fullname = 'A/R - Medicaid';
                $TemplateRef_ListID = '80000010-1359151098';
                $TemplateRef_FullName = 'ORS INVOICE';
                $ItemRef_ListID =  '';  //'80000001-1318262199'; //80000001-1318262199
                $ItemRef_ListID = '80000014-1617140511'; //    Homemaker 17.14
                if ($agency_code == 2 || $agency_code == 4  )  { 
                    if ($objResult['rate'] == '17.14')   { 
                    }
                    if ($objResult['rate'] == '13.75')   { 
                        $ItemRef_ListID = '80000002-1321469206'; //    HOMEMAKER CNA  13.75
                    } 
                    if ($objResult['rate'] == '24.47')   {                      
                        $ItemRef_ListID = '80000006-1336977587'; //    HOMEMAKER LPN  24.47
                    }
                    if ($objResult['rate'] == '25.47')   {                      
                        $ItemRef_ListID = '80000006-1336977587'; //   CAREGIVER LPN  VISIT MEDICAID 25.47
                    }
                    if ($objResult['rate'] == '29.55')   {                      
                        $ItemRef_ListID = '80000004-1327339583'; //   CAREGIVER RN  VISIT 29.55
                    }
                    if ($objResult['rate'] == '42.00')   {                      
                        $ItemRef_ListID = '80000003-1325791353'; //   CAREGIVER CNA  VISIT 42.00
                    }
                    if ($objResult['rate'] == '6.24')   {
                        $ItemRef_ListID = '8000001B-1637205197'; //   CAREGIVER CNA  VISIT 42.00
                    }

                    if ($Diagnosis != '' || $Diagnosis != null) {
                        //4.57
                        if ($objResult['unit'] == '4.57' || $objResult['unit'] == '4.29' || $objResult['unit'] == '5.07' || $objResult['unit'] == '5.46' || $objResult['unit'] == '6.24') {
                            //$ItemRef_ListID = '80000001-1318262199'; //    Homemaker 17.14
                            $ItemRef_ListID = '80000015-1414638066'; //    Homemaker 17.14
                            if ($objResult['unit'] == '5.46') {
                                $ItemRef_ListID = '80000014-1617140511'; 
                            } //    Homemaker 17.14
                            if ($objResult['unit'] == '6.24') {
                                $ItemRef_ListID = '8000001B-1637205197'; 
                            }
                            $ARAccountRef_ListID = '80000016-1313684319';
                            $ARAccountRef_Fullname = 'A/R - Insurance';
                        }                     
                    }
                }

                $Status = 'add';
                $Quantity = $objResult['total_amount'];
                if ($Diagnosis != '' || $Diagnosis != null) {
                    $Quantity = $objResult['total_unit'];
                }

                $ItemRef_ListID = '80000015-1414638066';

                //if ($objResult['start_date'] >= '2019-12-30')    { 
                if ($objResult['month'] >= '12' && $objResult['year'] >= '2019') { 
                    $ItemRef_ListID = '80000014-1617140511'; 
                }

                $rate = '';
                if ($objResult['start_date'] >= '2021-11-01') { 
                //if ($objResult['month'] >= '11' && $objResult['year'] >= '2021') {                
                    $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date = '$start' AND agency = '$agency_code'";
                    $objRow = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                    if(!empty($objRow)) {
                        $rate = $objRow['rate'];
                        $ItemRef_ListID = $objRow['ItemRef_ListID'];    
                    } else {
                        $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date <= '$start' AND agency = '$agency_code' ORDER BY id DESC";
                        $objRow = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
                        if(!empty($objRow)) {
                            $rate = $objRow['rate'];
                            $ItemRef_ListID = $objRow['ItemRef_ListID'];
                        }
                    }
                }

                if($rate=='6.24') {
                    $ItemRef_ListID = '8000001B-1637205197';
                }

                $chkSQL =  "SELECT * FROM invoice WHERE TxnID = '$ref_num'";
                $chkResult = get_custom_query_data_other_db($chkSQL, 'row', $agency_code);
                $med_medicaidno = trim($med_medicaidno);
                $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);
                $ListID = $findResult['ListID'];

                $TemplateRef_ListID = '';
                if ($agency_code == 2  || $agency_code == 4) { 
                    $TemplateRef_ListID = '8000000B-1283985346';
                }

                if (!empty($findResult)) {
                    $TemplateRef_ListID =  '8000000B-1283985346';
                    $ARAccountRef_ListID = '8000000F-1273000993';

                    $TemplateRef_ListID = '8000000C-1297378284';
                    $ARAccountRef_ListID = '8000000F-1273000993';

                    $chkSQL = " SELECT * FROM  invoice WHERE  CustomerRef_ListID = '$ListID'";
                    $chkResult = get_custom_query_data_other_db($chkSQL, 'row', $agency_code);
                    if (empty($chkResult))  {

                        $ClassRef_FullName = $ClassRef_ListID = '';
                        $agency_location_code = $ptResult['agency_location'];
                        if($agency_code==2 || $agency_code==4) {                        
                            $ptSQL = "SELECT * FROM qb_class_sc WHERE agency_location_code = '$agency_location_code'" ;
                            $qbData = $this->Comman_model->getCustomQueryData($ptSQL, 'row');

                            if(!empty($qbData)) {
                                $ClassRef_FullName = $qbData['ClassRef_FullName'];
                                $ClassRef_ListID = $qbData['ClassRef_ListID'];
                            }
                        }

                        if($agency_code==1) {
                            $ptSQL = "SELECT * FROM qb_class_hm WHERE agency_location_code = '$agency_location_code'" ;
                            $qbData = $this->Comman_model->getCustomQueryData($ptSQL, 'row');

                            if(!empty($qbData)) {
                                $ClassRef_FullName = $qbData['ClassRef_FullName'];
                                $ClassRef_ListID = $qbData['ClassRef_ListID'];
                            }
                        }

                        if($agency_code==3) {
                            $ptSQL = "SELECT * FROM qb_class_cg WHERE agency_location_code = '$agency_location_code'" ;
                            $qbData = $this->Comman_model->getCustomQueryData($ptSQL, 'row');

                            if(!empty($qbData)) {
                                $ClassRef_FullName = $qbData['ClassRef_FullName'];
                                $ClassRef_ListID = $qbData['ClassRef_ListID'];
                            }
                        }


                        $insert = "INSERT INTO invoice (TxnID,CustomerRef_ListID,ARAccountRef_ListID,
                        RefNumber,TxnDate,TemplateRef_ListID,CustomField1,Status,ClassRef_ListID,ClassRef_FullName) VALUES ('$mmddyylf','$ListID',
                        '$ARAccountRef_ListID','$mmddyylf','$TxnDate','$TemplateRef_ListID','$med_medicaidno',
                        '$Status','$ClassRef_ListID','$ClassRef_FullName')";
                        get_custom_query_data_other_db($insert, 'query', $agency_code);
                    }

                    $arry[1] = '"24.1.a-DOSFrom"';
                    $arrx[1] = '"24.1.f-Charges"';
                    $arrz[1] = '"24.1.g-Units"';

                    $arry[2] = '"24.2.a-DOSFrom"';
                    $arrx[2] = '"24.2.f-Charges"';
                    $arrz[2] = '"24.2.g-Units"';

                    $arry[3] = '"24.3.a-DOSFrom"';
                    $arrx[3] = '"24.3.f-Charges"';
                    $arrz[3] = '"24.3.g-Units"';

                    $arry[4] = '"24.4.a-DOSFrom"';   
                    $arrx[4] = '"24.4.f-Charges"';
                    $arrz[4] = '"24.4.g-Units"';

                    $arry[5] = '"24.5.a-DOSFrom"';
                    $arrx[5] = '"24.5.f-Charges"';
                    $arrz[5] = '"24.5.g-Units"';

                    $arry[6] = '"24.6.a-DOSFrom"';
                    $arrx[6] = '"24.6.f-Charges"';
                    $arrz[6] = '"24.6.g-Units"';

                    $chkSQL2 = "SELECT  * FROM eclaimsLTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code'  AND patient_id = '$portal_id'";
                    $chkExec2 = $this->Comman_model->getCustomQueryData($chkSQL2); 
                    foreach ($chkExec2 as $key => $chkResult2) {
                        for ($ax=1;$ax<=6;$ax++ ) {
                            $fldz = $arrz[$ax];
                            $fldy = $arry[$ax];                             
                            $Quantity = $chkResult2[$fldz];
                            $tmpdate = $chkResult2[$fldy];
                            $ServiceDate = date("Y-m-d",strtotime($tmpdate));
                            if ($Quantity != 0 )  {
                                $insert = "INSERT INTO invoicelinedetail (IDKEY,ItemRef_ListID,
                                Quantity,ServiceDate) VALUES ('$mmddyylf','$ItemRef_ListID','$Quantity','$ServiceDate')";
                                get_custom_query_data_other_db($insert, 'query', $agency_code);
                            }
                        }
                        $qb2 = 'yes';
                        $query7 = "UPDATE eclaimsLTS SET `qb` = '$qb2' WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND patient_id = '$portal_id' AND paid = 0 ";
                        set_custom_query_data($query7);
                    } 
                }
            }  
            $postcomment = "Created QuickBooks ".$startdate; 
            $this->postlog($postcomment);
            $this->session->set_flashdata('message','QuickBooks has been generated successfully.');
            print_r(1);
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }

    function generateQuickBooksHM() {
        $month = $_POST['month'];
        $year = $_POST['year'];
        $agency_code = $_POST['agency_code'];
        $nbatchno = $_POST['nbatchno'];

        if(!empty($month) && !empty($year) && !empty($agency_code)) {

            $month2 = $month;
            $year2 = $year;
            $query1 = "DELETE FROM invoice";
            get_custom_query_data_other_db($query1, 'query', $agency_code);
            $query2 = "DELETE FROM invoicelinedetail";
            get_custom_query_data_other_db($query2, 'query', $agency_code);

            $chkSQL = "SELECT * FROM table_1weekly WHERE start_date = '$startdate' ";
            $chkResult = get_custom_query_data($chkSQL, 'row');
            if (!empty($chkResult))  {
                $start = $chkResult['start_date'];
                $end= $chkResult['end_date'];
            }   

            $num = 0;
            if ($agency_code == 3)  {
                $num = 6000;
            }
            $qb = 'yes';
            //$strSQL = "SELECT * FROM eclaims WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND paid = 0 GROUP BY patient_id";
            $strSQL = "SELECT * FROM eclaimsLTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND paid = 0 AND qb!='$qb'";
            if(!empty($nbatchno)) {
                $strSQL .= " AND uploadtime = '$nbatchno'";                
            }
            $strSQL .= " GROUP BY patient_id";

            $objExec = get_custom_query_data($strSQL);
            foreach ($objExec as $key => $objResult) {
                $start = $objResult['start_date'];
                $cms1500_id = $objResult['cms1500_id'];
                $ptid = $objResult['patient_id'];
                $portal_id = $ptid;

                $lastdate = $year.'-'.$month.'-01';
                $lastday = date('t',strtotime($lastdate));
                //$TxnDate = date('Y-m-d', strtotime($start. ' +14 days'));   
                $TxnDate = $lastdate;
                $ptSQL = "SELECT * FROM patient WHERE patient_id = '$ptid' AND Agency = '$agency_code'" ;
                $ptResult = get_custom_query_data($ptSQL, 'row');

                $ID2 = $ptResult['DistrictID_Ref'];
                $clientid = $ptResult['clientid'];
                $firstname = trim($ptResult['firstname']);
                $lastname = trim($ptResult['lastname']);
                //$case_number = $ptResult['CustomFieldCaseNumber'];
                $med_medicaidno = $ptResult['med_medicaidno'];   
                $mmddyylf = date('m',strtotime($objResult['date'])).date('d',strtotime($objResult['date'])).date('y',strtotime($objResult['date'])).substr($lastname,0,1).substr($firstname,0,1);
                $num++;
                $z = sprintf("%04s", $num);
                //$no = date('m',strtotime($start));
                $no = $month;
                $letter = chr(64 + $no);
                $pid = sprintf("%05d",$portal_id);
                //$mmddyylf = $letter.date('d',strtotime($start)).date('y',strtotime($start)).$pid;
                //$mmddyylf = $letter.date('d',strtotime($start)).date('y',strtotime($start)).$pid.'L';

                $mmddyylf = $letter.date('d',strtotime($lastdate)).date('y',strtotime($lastdate)).$pid.'L';

                $sql = "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND month = '$month' AND year = '$year' AND mco = '1' ORDER BY district_id DESC LIMIT 1";
                $row = get_custom_query_data($sql, 'row');
                if(!empty($row['DistrictID_Ref'])) {
                    $ID2 = $row['DistrictID_Ref'];
                } else {
                    //$sql =  "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND MONTH(start_date)<'$month' AND YEAR(start_date)<='$year' AND start_date!='0000-00-00' AND mco = '1' ORDER BY district_id DESC LIMIT 1";

                    $cdate = $year.'-'.$month.'-01';
                    $cdate = date('Y-m-d', strtotime($cdate));                    
                    $sql =  "SELECT DistrictID_Ref FROM tracking_district WHERE patient_id = '$ptid' AND start_date<='$cdate' AND start_date!='0000-00-00' AND mco = '1' ORDER BY district_id DESC LIMIT 1";
                    $row = get_custom_query_data($sql, 'row');
                    if (!empty($row['DistrictID_Ref'])) {
                        $ID2 = $row['DistrictID_Ref'];
                    }
                }

                $distSQL = "SELECT * FROM tbldistricts WHERE DistrictID = '$ID2' AND Agency = '$agency_code'" ;
                $distResult = get_custom_query_data($distSQL, 'row');
                $Diagnosis = $distResult['Diagnosis'];
                $ParentRef_FullName = $distResult['ParentRef_FullName'];

                $ARAccountRef_ListID =  '8000000E-1273000993';
                $ARAccountRef_ListID =  '8000000B-1283985346';

                $ARAccountRef_Fullname = 'A/R - Medicaid';
                $TemplateRef_ListID = '80000010-1359151098';
                $TemplateRef_FullName = 'ORS INVOICE';
                $ItemRef_ListID =  '';  //'80000001-1318262199'; //80000001-1318262199
                $ItemRef_ListID = '80000014-1617140511'; //    Homemaker 17.14
                if ($agency_code == 1 || $agency_code == 3  )  { 
                    if ($objResult['rate'] == '17.14')   { 
                    }
                    if ($objResult['rate'] == '13.75')   { 
                        $ItemRef_ListID = '80000002-1321469206'; //    HOMEMAKER CNA  13.75
                    } 
                    if ($objResult['rate'] == '24.47')   {                      
                        $ItemRef_ListID = '80000006-1336977587'; //    HOMEMAKER LPN  24.47
                    }
                    if ($objResult['rate'] == '25.47')   {                      
                        $ItemRef_ListID = '80000006-1336977587'; //   CAREGIVER LPN  VISIT MEDICAID 25.47
                    }
                    if ($objResult['rate'] == '29.55')   {                      
                        $ItemRef_ListID = '80000004-1327339583'; //   CAREGIVER RN  VISIT 29.55
                    }
                    if ($objResult['rate'] == '42.00')   {                      
                        $ItemRef_ListID = '80000003-1325791353'; //   CAREGIVER CNA  VISIT 42.00
                    }
                    if ($objResult['rate'] == '6.24')   {
                        $ItemRef_ListID = '8000001B-1637205197'; //   CAREGIVER CNA  VISIT 42.00
                    }

                    if ($Diagnosis != '' || $Diagnosis != null) {
                        //4.57
                        if ($objResult['unit'] == '4.57' || $objResult['unit'] == '4.29' || $objResult['unit'] == '5.07' || $objResult['unit'] == '5.46' || $objResult['unit'] == '6.24')   { 
                            //$ItemRef_ListID = '80000001-1318262199'; //    Homemaker 17.14
                            $ItemRef_ListID = '80000015-1414638066'; //    Homemaker 17.14
                            if ($objResult['unit'] == '5.46') {
                                $ItemRef_ListID = '80000014-1617140511'; 
                            } //    Homemaker 17.14
                            if ($objResult['unit'] == '6.24') {
                                $ItemRef_ListID = '8000001B-1637205197'; 
                            }
                            $ARAccountRef_ListID = '80000016-1313684319';
                            $ARAccountRef_Fullname = 'A/R - Insurance';
                        }                     
                    }
                }

                $Status = 'add';
                $Quantity = $objResult['total_amount'];
                if ($Diagnosis != '' || $Diagnosis != null) {
                    $Quantity = $objResult['total_unit'];
                }

                $ItemRef_ListID = '80000015-1414638066';

                //if ($objResult['start_date'] >= '2019-12-30')    { 
                if ($objResult['month'] >= '12' && $objResult['year'] >= '2019') { 
                    $ItemRef_ListID = '80000014-1617140511'; 
                }

                $rate = '';
                if ($objResult['start_date'] >= '2021-11-01') { 
                //if ($objResult['month'] >= '11' && $objResult['year'] >= '2021') {                
                    $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date = '$start' AND agency = '$agency_code'";
                    $objRow = get_custom_query_data($chkSQL, 'row');
                    if(!empty($objRow)) {
                        $rate = $objRow['rate'];
                        $ItemRef_ListID = $objRow['ItemRef_ListID'];    
                    } else {
                        $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date <= '$start' AND agency = '$agency_code' ORDER BY id DESC";
                        $objRow = get_custom_query_data($chkSQL, 'row');
                        if(!empty($objRow)) {
                            $rate = $objRow['rate'];
                            $ItemRef_ListID = $objRow['ItemRef_ListID'];
                        }
                    }
                }

                if($rate=='6.24') {
                    $ItemRef_ListID = '8000001B-1637205197';
                }

                $chkSQL =  "SELECT * FROM invoice WHERE TxnID = '$ref_num'";
                $chkResult = get_custom_query_data_other_db($chkSQL, 'row', $agency_code);
                $med_medicaidno = trim($med_medicaidno);
                $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField2) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);

                if(empty($findResult)) {
                    $findSQL =  "SELECT * FROM customer WHERE UPPER(CustomField1) = '$med_medicaidno' AND upper(ParentRef_FullName) = UPPER('$ParentRef_FullName')";
                    $findResult = get_custom_query_data_other_db($findSQL, 'row', $agency_code);
                }

                $ListID = $findResult['ListID'];

                $TemplateRef_ListID = '';
                if ($agency_code == 1  || $agency_code == 3) { 
                    $TemplateRef_ListID = '8000000B-1283985346';
                }

                if (!empty($findResult)) {
                    $TemplateRef_ListID =  '8000000B-1283985346';
                    $ARAccountRef_ListID = '8000000F-1273000993';

                    $TemplateRef_ListID = '8000000C-1297378284';
                    $ARAccountRef_ListID = '8000000F-1273000993';

                    if ($agency_code == 1 )  {
                        $ARAccountRef_ListID = '80000016-1313684319';
                        $TemplateRef_ListID  = '80000010-1359151098';
                        $ItemRef_ListID = '80000025-1637205051';
                    }                           

                    if ($agency_code == 3 )  {
                        $ARAccountRef_ListID = '110001-1114276597';
                        $TemplateRef_ListID  = '1C0000-1112285492';
                        $ItemRef_ListID = '800000A8-1637204760';
                    }

                    $start = $objResult['start_date'];
                    $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date = '$start' AND agency = '$agency_code'";
                    $objRow = get_custom_query_data($chkSQL, 'row');
                    if(!empty($objRow)) {
                        $ItemRef_ListID = $objRow['ItemRef_ListID'];
                    } else {
                        $chkSQL = "SELECT * FROM mco_rate_settings WHERE start_date <= '$start' AND agency = '$agency_code' ORDER BY id DESC";
                        $objRow = get_custom_query_data($chkSQL, 'row');
                        if(!empty($objRow)) {
                            $ItemRef_ListID = $objRow['ItemRef_ListID'];
                        }
                    }   

                    $chkSQL = "SELECT * FROM invoice WHERE CustomerRef_ListID = '$ListID'";
                    $chkResult = get_custom_query_data_other_db($chkSQL, 'row', $agency_code);

                    if (empty($chkResult))  {

                        $ClassRef_FullName = $ClassRef_ListID = '';
                        $agency_location_code = $ptResult['agency_location'];
                        if($agency_code==2 || $agency_code==4) {                        
                            $ptSQL = "SELECT * FROM qb_class_sc WHERE agency_location_code = '$agency_location_code'" ;
                            $qbData = get_custom_query_data($ptSQL, 'row');

                            if(!empty($qbData)) {
                                $ClassRef_FullName = $qbData['ClassRef_FullName'];
                                $ClassRef_ListID = $qbData['ClassRef_ListID'];
                            }
                        }

                        if($agency_code==1) {
                            $ptSQL = "SELECT * FROM qb_class_hm WHERE agency_location_code = '$agency_location_code'" ;
                            $qbData = get_custom_query_data($ptSQL, 'row');

                            if(!empty($qbData)) {
                                $ClassRef_FullName = $qbData['ClassRef_FullName'];
                                $ClassRef_ListID = $qbData['ClassRef_ListID'];
                            }
                        }

                        if($agency_code==3) {
                            $ptSQL = "SELECT * FROM qb_class_cg WHERE agency_location_code = '$agency_location_code'" ;
                            $qbData = get_custom_query_data($ptSQL, 'row');

                            if(!empty($qbData)) {
                                $ClassRef_FullName = $qbData['ClassRef_FullName'];
                                $ClassRef_ListID = $qbData['ClassRef_ListID'];
                            }
                        }

                        $insert = "INSERT INTO invoice (TxnID,CustomerRef_ListID,ARAccountRef_ListID,
                        RefNumber,TxnDate,TemplateRef_ListID,CustomField1,Status,ClassRef_ListID,ClassRef_FullName) VALUES ('$mmddyylf','$ListID','$ARAccountRef_ListID','$mmddyylf','$TxnDate','$TemplateRef_ListID','$med_medicaidno','$Status','$ClassRef_ListID','$ClassRef_FullName')";
                        get_custom_query_data_other_db($insert, 'query', $agency_code);
                    }

                    $arry[1] = '"24.1.a-DOSFrom"';
                    $arrx[1] = '"24.1.f-Charges"';
                    $arrz[1] = '"24.1.g-Units"';

                    $arry[2] = '"24.2.a-DOSFrom"';
                    $arrx[2] = '"24.2.f-Charges"';
                    $arrz[2] = '"24.2.g-Units"';

                    $arry[3] = '"24.3.a-DOSFrom"';
                    $arrx[3] = '"24.3.f-Charges"';
                    $arrz[3] = '"24.3.g-Units"';

                    $arry[4] = '"24.4.a-DOSFrom"';   
                    $arrx[4] = '"24.4.f-Charges"';
                    $arrz[4] = '"24.4.g-Units"';

                    $arry[5] = '"24.5.a-DOSFrom"';
                    $arrx[5] = '"24.5.f-Charges"';
                    $arrz[5] = '"24.5.g-Units"';

                    $arry[6] = '"24.6.a-DOSFrom"';
                    $arrx[6] = '"24.6.f-Charges"';
                    $arrz[6] = '"24.6.g-Units"';

                    //$chkSQL2 = "SELECT  * FROM eclaims WHERE start_date = '$start' AND Agency = '$agency_code'  AND patient_id = '$portal_id'";

                    $chkSQL2 = "SELECT * FROM eclaimsLTS WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND patient_id = '$portal_id'";
                    $chkExec2 = get_custom_query_data($chkSQL2); 
                    foreach ($chkExec2 as $key => $chkResult2) {
                        for ($ax=1;$ax<=6;$ax++ ) {
                            $fldz = $arrz[$ax];
                            $fldy = $arry[$ax];                             
                            $Quantity = $chkResult2[$fldz];
                            $tmpdate = $chkResult2[$fldy];
                            $ServiceDate = date("Y-m-d",strtotime($tmpdate));
                            if ($Quantity != 0 )  {
                                $insert = "INSERT INTO invoicelinedetail (IDKEY,ItemRef_ListID,
                                Quantity,ServiceDate) VALUES ('$mmddyylf','$ItemRef_ListID','$Quantity','$ServiceDate')";
                                get_custom_query_data_other_db($insert, 'query', $agency_code);
                            }
                        }
                        $qb2 = 'yes';                 
                        //$query7 = "UPDATE eclaimsLTS SET `qb` = '$qb2' WHERE start_date = '$start' AND Agency = '$agency_code'  AND patient_id = '$portal_id'  AND paid = 0 ";
                        $query7 = "UPDATE eclaimsLTS SET `qb` = '$qb2' WHERE month = '$month' AND year = '$year' AND Agency = '$agency_code' AND patient_id = '$portal_id' AND paid = 0 ";
                        set_custom_query_data($query7);
                    } 
                }
            }  
            $postcomment = "Created QuickBooks Month =".$month." And Year=".$year; 
            $this->postlog($postcomment);
            $this->session->set_flashdata('message','QuickBooks has been generated successfully.');
            print_r(1);
        } else {
            $this->session->set_flashdata('error_message','Oops! something went wrong. Try again.');
            print_r(0);
        }
    }
} 