<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Rates extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Employee_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
    }

    function addATV() {
        if (isset($_SESSION['name'])) { 
            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                if ($this->form_validation->run() != false) {

                    $dataArray = [];
                    $dataArray['rate']  = $this->input->post('rate',true);

                    $sql = "SELECT * FROM adv_rate_settings";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    if(!empty($row['id'])) {
                        $inserId = $row['id'];

                        $where = [];
                        $where['id'] = $inserId;

                        $this->Comman_model->update("atv_rate_settings", $where, $dataArray);
                    } else {
                        $inserId = $this->Comman_model->insert("atv_rate_settings", $dataArray);
                    }                    

                    if ($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated adv rate id '.$inserId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('ATV rate has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('rates/addATV','refresh');
                }
            }

            //$where = [];
            //$agencyData = $this->Comman_model->get_rows('agency', $where);

            //$data = [];
            //$data['agencyData'] = $agencyData;

            $data['rate'] = '';
            $sql = "SELECT * FROM atv_rate_settings";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');
            if(!empty($row['rate'])) {
                $data['rate'] = $row['rate'];    
            }            

            $data['page'] = 'Add ATV Settings';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('rates/atv-rates', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    function addVMR() {
        if (isset($_SESSION['name'])) { 
            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                if ($this->form_validation->run() != false) {

                    $dataArray = [];
                    $dataArray['rate']  = $this->input->post('rate',true);

                    $sql = "SELECT * FROM vmr_rate_settings";
                    $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                    if(!empty($row['id'])) {
                        $inserId = $row['id'];

                        $where = [];
                        $where['id'] = $inserId;

                        $this->Comman_model->update("vmr_rate_settings", $where, $dataArray);
                    } else {
                        $inserId = $this->Comman_model->insert("vmr_rate_settings", $dataArray);
                    }                    

                    if ($inserId) {
                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated vmr rate id '.$inserId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('VMR rate has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('rates/addVMR','refresh');
                }
            }

            //$where = [];
            //$agencyData = $this->Comman_model->get_rows('agency', $where);

            //$data = [];
            //$data['agencyData'] = $agencyData;

            $data['rate'] = '';
            $sql = "SELECT * FROM vmr_rate_settings";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');
            if(!empty($row['rate'])) {
                $data['rate'] = $row['rate'];    
            }            

            $data['page'] = 'Add VMR Settings';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('rates/vmr-rates', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect($this->agent->referrer());
        }
    }

    function editMcoSettings($pageId='') {

        if (isset($_SESSION['name'])) { 
            $pageId = $this->uri->segment('3');
            if(!empty($pageId)) {
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['id'] = $pageId;
                $pageData   =   $this->Comman_model->get_row('mco_rate_settings',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
                $this->form_validation->set_rules('rate', 'Rate', 'trim|required');
                $this->form_validation->set_rules('ItemRef_ListID', 'ItemRef List ID', 'trim|required');
                $this->form_validation->set_rules('agency', 'Agency', 'trim|required');

                if ($this->form_validation->run() != false) {

                    $dataArray                          = [];
                    $dataArray['start_date']  = $this->input->post('start_date',true);
                    $dataArray['rate']  = $this->input->post('rate',true);
                    $dataArray['ItemRef_ListID']      = $this->input->post('ItemRef_ListID',true);
                    $dataArray['agency']      = $this->input->post('agency',true);

                    $where  =   [];
                    $where['id'] =   $pageId;

                    $updateId = $this->Comman_model->update( "mco_rate_settings", $where, $dataArray );

                    if ($updateId) {

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user updated mco rate id '.$pageId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->app->message('MCO rate has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('dashboardd/mcoSettings','refresh');
                }
            }

            $where = [];
            $agencyData = $this->Comman_model->get_rows('agency', $where);
            $data['agencyData'] = $agencyData;

            $data['page'] = 'Update MCO Rate';
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('mco/edit-mco-settings.php', $data);
            $this->load->view('common/footer.php');
        } else {
            redirect('');
        }
    }  

    function deleteMcoSettings($recordId) {
        if(!empty($recordId)){
            $recordId = decode64($recordId);
            $where  = [];
            $where['id'] = $recordId;
            $check = $this->Comman_model->delete_row('mco_rate_settings',$where);

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted mco rate id '.$recordId.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################


            $this->app->message('MCO rate has been deleted successfully.', 'success');
        }else{
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }
} 