<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Sms extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->model('Employee_model', 'employee');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        }
        else
            $this->headerData=[];

        $this->load->library('PHPReport');
        $this->load->helper('download');
        $this->load->model('Excel_export_model');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }
    public function index()
    {
        $filterBy = isset($_POST['filterBy'])?$_POST['filterBy']:'';
        if(isset($_SESSION['name'])) {
            if(!empty($filterBy) && $filterBy!="viewAll")
            {
                $messageData= $this->db->order_by('sentDate', 'DESC')->get_where('employee_messages',['sender'=>$_SESSION['name'],'status'=>$filterBy])->result_array();
            }else{
                $messageData= $this->db->order_by('sentDate', 'DESC')->get_where('employee_messages',['sender'=>$_SESSION['name']])->result_array();
            }
            foreach ($messageData as $key => $row) {
                if($row['status']!= 'delivered' && $row['status']!= 'undelivered')
                {
                    $updatedStatus = $this->UpdateSmsStatus($row['msgId']);
                    $row['status']= $updatedStatus;
                }
                $msgData[]=[
                    'id'=>$row['id'],
                    'msgId'=>$row['msgId'],
                    'sender'=>$row['sender'],
                    'client'=>$row['client'],
                    'employee'=>$row['employee'],
                    'messageText'=>$row['messageText'],
                    'sentDate'=>$row['sentDate'],
                    'status'=>$row['status'],
                ];
            }
            $data['messageData']=$msgData;
            $data['filterBy']=$filterBy;
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('sms_view.php',$data);
            $this->load->view('common/footer.php');
        }
        else{
          redirect();
        }
    }
    function SendSms()
    {
        $smsText = $this->input->post('smsText');
        $numbersData = $this->input->post('numbersData');
        $clientId = $this->input->post('clientId');
        if(!empty($smsText) && !empty($numbersData))
        {
            $data = array('smsText' => $smsText, 'numbersData' => $numbersData);
            $url = 'http://sms.1017.solutions/Api/Sms.php';
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            if (is_array($data)) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            }
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            if(!empty($result))
            {
                $arrRes = json_decode($result,true);
                foreach ($arrRes as $key => $value) {
                    if(!empty($clientId))
                        $clientName   =  $this->db->get_where('patient',array('patient_id' => $clientId))->row()->name;
                    else
                        $clientName = '-';
                    $senderName   =  $_SESSION['name'];
                    $insertArr=[
                        'msgId'=>$value['msgId'],
                        'sender'=>$senderName,
                        'employee'=>$value['empid'],
                        'client'=>$clientName,
                        'messageText'=>$smsText,
                        'status'=>$value['status'],
                    ];
                    $this->db->insert('employee_messages',$insertArr);
                }
                die(json_encode(['status'=>'success','message'=>'sms sent']));
            }
        }
    }
    function SendTollFreeSms()
    {
        $numbersData = $this->input->post('numbersData');
        if(!empty($numbersData))
        {
            $data = array('smsText' => $smsText, 'numbersD' => $numbersData);
            $url = 'http://sms.1017.solutions/Api/Sms.php';
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            if (is_array($data)) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            }
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            if(!empty($result))
            {
                $arrRes = json_decode($result,true);
                foreach ($arrRes as $key => $value) {
                    $this->db->update('employee_messages',
                        ['msgId'=>$value['msgId'],'status'=>$value['status']],
                        ['id'=>$value['empid']]
                    );
                }
                die(json_encode(['status'=>'success','message'=>'sms sent']));
            }
        }
    }
    function UpdateSmsStatus($msgId)
    {
        if(!empty($msgId))
        {
            $data = array('msgId' => $msgId);
            $url = 'http://sms.1017.solutions/Api/Sms.php';
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            if (is_array($data)) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            }
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            if(!empty($result))
            {
                $arrRes = json_decode($result,true);
                $this->db->update('employee_messages',['status'=>$arrRes['status']],['msgId'=>$arrRes['msgId']]);
                return $arrRes['status'];
            }
        }
    }
}