<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Supervisor extends CI_Controller
{
    public function __construct() {
        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        //$this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Supervisor_model', 'supervisor');
        $this->load->helper('file');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        }
        else
            $this->headerData=[];

        //$this->load->library('PHPReport');
        //$this->load->helper('download');
        //$this->load->model('Excel_export_model');
    }

    public function index() {

        if(isset($_SESSION['name'])) {

            $supervisor_id2 = $phone2 = $email2 = $firstname2 = $lastname2 = $cond3 = '';

            if(!empty($_GET['supervisor_id2'])) {
                $supervisor_id2 = $_GET['supervisor_id2'];
            }

            if(!empty($_GET['phone2'])) {
                $phone2 = $_GET['phone2'];
            }

            if(!empty($_GET['email2'])) {
                $email2 = $_GET['email2'];
            }

            if(!empty($_GET['firstname2'])) {
                $firstname2 = $_GET['firstname2'];
            }

            if(!empty($_GET['lastname2'])) {
                $lastname2 = $_GET['lastname2'];
            }

            if(!empty($_GET['Agency2'])) {
                $Agency2 = $_GET['Agency2'];
                $cond3 = "AND supervisor.Agency = '$Agency2'";
            }

            if(isset($_GET['isSupervisor']) && $_GET['isSupervisor']!='') {
                $isSupervisor = $_GET['isSupervisor'];
                $cond3 .= "AND supervisor.is_supervisor = '$isSupervisor'";
            }


            $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM  supervisor WHERE supervisor.supervisor_id LIKE '%".$supervisor_id2."%' ";
            if(!empty($phone2)) {
                $MySQL .= "AND supervisor.phone LIKE '%".$phone2."%'  ";
            }

            if(!empty($email2)) {
                $MySQL .= "AND supervisor.email LIKE '%".$email2."%'  ";
            }

            if(!empty($firstname2)) {
                $MySQL .= "AND supervisor.firstname LIKE '%".$firstname2."%'  ";
            }

            if(!empty($lastname2)) {
                $MySQL .= "AND supervisor.lastname LIKE '%".$lastname2."%'  ";
            }

            if(!empty($cond3)) {
                $MySQL .= $cond3;
            }

            $MySQL .= " order by supervisor_id desc";
            //ORDER BY ".$sortorder." ".$desc."    LIMIT " .$from. ", " .$to . " "; 

            $data['isSupervisor'] = $_GET['isSupervisor'];

            //echo $MySQL;

            $data['supervisor'] = $this->Comman_model->getCustomQueryData($MySQL);
            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('supervisor/view.php',$data);
            $this->load->view('common/footer-view.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('supervisor/view-new.php',$data);
        } else {
            redirect();
        }
    }

    public function add() {

        if(isset($_SESSION['name'])) {

            if(!empty($this->input->post('submit'))) {

                $this->form_validation->set_rules('firstname', 'Firstname', 'trim|required');
                $this->form_validation->set_rules('lastname', 'Lastname', 'trim|required');
                //$this->form_validation->set_rules('username', 'Username', 'trim|required');
                $this->form_validation->set_rules('email', 'Email', 'trim|required|is_unique[supervisor.email]');
                $this->form_validation->set_rules('phone', 'Phone', 'trim|required');
                $this->form_validation->set_rules('location', 'Agency Location', 'trim|required');
                $this->form_validation->set_message('is_unique', 'The %s is already taken');

                if ($this->form_validation->run() != false) {
                    
                    
                    $firstname = $this->input->post('firstname', TRUE);
                    $lastname = $this->input->post('lastname', TRUE);
                    $name = $lastname.', '.$firstname;
                    $username = $this->input->post('username', TRUE);

                    if(!empty($this->input->post('isSupervsior'))){
                        $isSupervsior = $this->input->post('isSupervsior');
                        if($isSupervsior=='on') {
                           $is_supervisor  = 1;
                        } else {
                           $is_supervisor  = 0; 
                        }
                    }

                    $dataArray = [];
                    $dataArray['username'] = $username;
                    $dataArray['name'] = $name;
                    $dataArray['firstname'] = $firstname;
                    $dataArray['lastname'] = $lastname;
                    $dataArray['email'] = $this->input->post('email', TRUE);
                    $dataArray['phone'] = $this->input->post('phone', TRUE);
                    $dataArray['Agency'] = $this->input->post('Agency', TRUE);
                    $dataArray['is_active'] = $this->input->post('is_active', TRUE);
                    $dataArray['agency_location'] = $this->input->post('location', TRUE);

                    /*if(!empty($_POST['outputImage'])) {
                        define("UPLOAD_DIR", FCPATH.'assets2/images/supervisor/signature/'); 
                        $signature = $_POST['outputImage'];
                        $signature = str_replace('data:image/png;base64,', '', $signature);
                        $signature = str_replace(' ', '+', $signature);
                        $data = base64_decode($signature);
                        $signName = md5(microtime().date('Y-m-d')).'.png';
                        $file = UPLOAD_DIR . $signName;
                        if ( ! write_file($file, $data, 'w+')) {
                            //echo 'Unable to write the file';
                        } else {
                            $dataArray['signature'] = $signName;
                        }    
                    }*/

                    //$dataArray['sign_output'] = $this->input->post('output');
                    $dataArray['is_supervisor']   = $is_supervisor;

                    $insertId  = $this->Comman_model->insert('supervisor', $dataArray);

                    if($insertId) {

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user add supervisor id '.$insertId.' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################

                        $this->session->set_flashdata('message','Supervisor has been added successfully.');
                        redirect('supervisor');
                    } else {
                        $this->session->set_flashdata('message','Somthing Went Wrong');
                        redirect('supervisor');
                    }

                }
            }

            $sql = "select * from supervisor order by supervisor_id desc limit 1";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');
            if(!empty($row['supervisor_id'])) {
                $data['supervisor_id'] = $row['supervisor_id'] + 1;
            } else {
                $data['supervisor_id'] = 1;
            }
            

            $strSQL = "SELECT * FROM users WHERE userlevel = 'S' OR userlevel = 'A' ORDER BY username  ASC" ;
            $data['userData'] = $this->Comman_model->getCustomQueryData($strSQL);               

            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');
            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location');

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('supervisor/add.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('supervisor/add-new.php',$data);

        } else {
            redirect();
        }

    }

    public function edit() {
        if(isset($_SESSION['name'])) {
            $id = $this->input->get('id');
            $data['row'] = $this->db->where('supervisor_id',$id)->get('supervisor')->row_array();
            $data['allAgencyData'] = $this->Comman_model->get_rows('agency');

            //$strSQL = "SELECT * FROM users_portal WHERE userlevel = 'S' OR userlevel = 'A' ORDER BY name  ASC" ;
            $strSQL = "SELECT * FROM users WHERE userlevel = 'S' OR userlevel = 'A' ORDER BY username  ASC" ;
            $data['userData'] = $this->Comman_model->getCustomQueryData($strSQL);


            if(!empty($this->input->post()) && !empty($id)) {

                

                $firstname = $this->input->post('firstname', TRUE);
                $lastname = $this->input->post('lastname', TRUE);
                $name = $lastname.', '.$firstname;
                $username = $this->input->post('username', TRUE);

                if(!empty($this->input->post('isSupervsior'))){
                    $isSupervsior = $this->input->post('isSupervsior');
                    if($isSupervsior=='on') {
                       $is_supervisor  = 1;
                    } else {
                       $is_supervisor  = 0; 
                    }
                }

                $is_active = $this->input->post('is_active', TRUE);

                $dataArray = [];
                $dataArray['username'] = $username;
                $dataArray['name'] = $name;
                $dataArray['firstname'] = $firstname;
                $dataArray['lastname'] = $lastname;
                $dataArray['email'] = $this->input->post('email', TRUE);
                $dataArray['phone'] = $this->input->post('phone', TRUE);
                $dataArray['Agency'] = $this->input->post('Agency', TRUE);
                $dataArray['is_active'] = $is_active;
                $dataArray['agency_location'] = $this->input->post('location', TRUE);
                
                /*
                if(!empty($_POST['outputImage'])) {
                    define("UPLOAD_DIR", FCPATH.'assets2/images/supervisor/signature/'); 
                    $signature = $_POST['outputImage'];
                    $signature = str_replace('data:image/png;base64,', '', $signature);
                    $signature = str_replace(' ', '+', $signature);
                    $data1 = base64_decode($signature);
                    $signName = md5(microtime().date('Y-m-d')).'.png';
                    //print_r($signName);
                    $file = UPLOAD_DIR . $signName;
                    if ( ! write_file($file, $data1, 'w+')) {
                        //echo 'Unable to write the file';
                    } else {
                        //echo 'File written!';
                        $dataArray['signature'] = $signName;
                        if(!empty($data['row']['signature'])) {
                            $path = UPLOAD_DIR . $data['row']['signature'];
                            unlink($path);     
                        }
                    }    
                }*/

                //$dataArray['sign_output'] = $this->input->post('output');
                $dataArray['is_supervisor']   = $is_supervisor;

                $where = [];
                $where['supervisor_id'] = $id;
                $updateId  = $this->Comman_model->update('supervisor', $where, $dataArray);

                if($updateId) {

                    ############### USER ACTION TRACKING START ####################
                    if($this->session->userdata('id')!=6) {
                        $dataArray = [];
                        $dataArray['user_id'] = $this->session->userdata('id');
                        $dataArray['username'] = $this->session->userdata('name');
                        $dataArray['user_action'] = $this->session->userdata('name'). ' user updated supervisor id '.$id.' at '. date('m/d/Y H:i:s');
                        $this->Comman_model->insert('users_tracking', $dataArray);    
                    }
                    ############### USER ACTION TRACKING END ####################

                    if($is_active==2) {
                        $this->unassignedSupervisorFromClient($id);    
                    }                    

                    $this->session->set_flashdata('message','Supervisor has been updated successfully.');
                    redirect('supervisor');                    
                } else {
                    $this->session->set_flashdata('message','Somthing Went Wrong');
                    redirect('supervisor');
                }

            }


            $data['agencyLocationData'] = $this->Comman_model->get_rows('agency_location');

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('supervisor/edit.php',$data);
            $this->load->view('common/footer.php');
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('supervisor/edit-new.php',$data);
        } else {
            redirect();
        }
    }

    function unassignedSupervisorFromClient($sid) {
        $dataArray['supervisor_id']   = 0;
        $where = [];
        $where['supervisor_id'] = $sid;
        $this->Comman_model->update('patient', $where, $dataArray);

        ############### USER ACTION TRACKING START ####################
        if($this->session->userdata('id')!=6) {
            /*$dataArray = [];
            $dataArray['user_id'] = $this->session->userdata('id');
            $dataArray['username'] = $this->session->userdata('name');
            $dataArray['user_action'] = 'Supervisor status InActive by '.$this->session->userdata('name'). ' user updated supervisor id '.$id.' at '. date('m/d/Y H:i:s');
            $this->Comman_model->insert('users_tracking', $dataArray);*/
        }
        ############### USER ACTION TRACKING END ####################
    }

    public function delete_Supervisor() {
        $id = $this->input->get('supervisor_id');
        $data = $this->db->where('supervisor_id',$id)->delete('supervisor');
        if($data) {

            ############### USER ACTION TRACKING START ####################
            if($this->session->userdata('id')!=6) {
                $dataArray = [];
                $dataArray['user_id'] = $this->session->userdata('id');
                $dataArray['username'] = $this->session->userdata('name');
                $dataArray['user_action'] = $this->session->userdata('name'). ' user deleted supervisor id '.$id.' at '. date('m/d/Y H:i:s');
                $this->Comman_model->insert('users_tracking', $dataArray);    
            }
            ############### USER ACTION TRACKING END ####################

            $this->session->set_flashdata('message','Supervisor has been deleted successfully.');
            redirect('supervisor');
        } else {
            $this->session->set_flashdata('message','Somthing Went Wrong');
            redirect('supervisor');
        }
    }
    
} 