<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Timesheet extends CI_Controller
{
  public function __construct() {
    parent::__construct();
    $this->load->database();
    $this->load->library('session');
    $this->load->library('google');
    $this->load->library('user_agent');
    $this->load->library('form_validation');
    $this->load->library('excel');
    $this->load->helper('form');
    $this->load->helper('url');
    $this->load->helper('new_helper');
    $this->load->model('Comman_model');
    $this->load->model('Api_model');
    $this->load->model('Client_model', 'client');
        // $this->load->model('excel_import_model');
        // patientReportexcel
  }


  public function index() {
    if(isset($_SESSION['name'])) {

      $tmpdte = date('Y-m-d'); 
      if(!empty($_GET['fromDate'])) {
        $fromDate = $_GET['fromDate'];
        if(!empty($_GET['action'])) {
          if($_GET['action']=='previous') {
            $fromDate = date('Y-m-d',(strtotime ( '-1 day' , strtotime ( $fromDate) ) ));    
          }
          if($_GET['action']=='next') {
            $fromDate = date('Y-m-d',(strtotime ( '+1 day' , strtotime ( $fromDate) ) ));    
          }
        }
        $tmpdte = date( 'Y-m-d', strtotime($fromDate));     
        $this->session->set_userdata('date', $fromDate);
      } else {
        if(!empty($this->session->userdata('date'))) {
          $datetrans = $this->session->userdata('date');
          $tmpdte = date( 'Y-m-d', strtotime($datetrans));     
        }
      }

      $IsZero = @$_GET['IsZero'];
      $dropdevice = @$_GET['dropdevice'];
      $search = @$_GET['search'];
      $submit = @$_GET['btnSubmit'];

      $agency_code = $this->session->userdata('agency');

      $datetrans = $tmpdte;
      $payroll = [];
      $payroll['msg'] = @$msg;
      $payroll['okaymsgs'] = @$okaymsgs;
      $payroll['cmpmsgs'] = @$cmpmsgs;

      if(empty($_GET['show'])) {
        $_GET['show'] = '5';
      }

      if (!empty($_GET['btnSubmit']) || !empty($_GET['show'])) {

        $payroll = $this->checkPayroll($datetrans, $agency_code);

      }

      if (!empty($_GET['action']) && $_GET['action'] == 'refresh') {
        $this->manualupd($datetrans);
        $addate = $datetrans;
        $this->dashupd4($addate);
        $postcomment = "Employee Timesheets  Refresh ".$datetrans;
        $this->postlog($postcomment); 
      }


      $from = 0;$to = 0;
      if(!empty($_GET['show']) && $_GET['show']!='all') {
        $to = $_GET['show'];
      }




      $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
      employee_clock.patient_id AS pt_id,
      employee_clock.employee_id,
      employee_clock.date,
      employee_clock.rec_id,
      employee_clock.tagedit,
      employee_clock.latitude,
      employee_clock.longitude,
      employee_clock.employee_clock_id,
      patient.patient_id, 
      patient.name as pt_name,
      patient.phone,
      patient.Agency,
      employee.name as empl_name,
      employee.pin,
      employee.shift

      FROM employee_clock,patient,employee
      WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn = 1 AND DATE(date) = '$tmpdte' AND  (patient.name LIKE '%".$search."%' OR employee.name LIKE '%".$search."%')  AND patient.Agency = '$agency_code' AND reset IS NOT NULL ";
                      //ORDER BY ".$sortorder." ".$desc.", employee_clock_id ASC LIMIT " .$from. ", " .$to . " ";

      if ($IsZero == 1 )  {
        $MySQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
        employee_clock.patient_id AS pt_id,
        employee_clock.employee_id,
        employee_clock.date,
        employee_clock.tagedit,
        employee_clock.latitude,
        employee_clock.longitude,
        employee_clock.isIn,
        employee_clock.employee_clock_id,
        patient.patient_id, 
        patient.name as pt_name,
        patient.phone,
        patient.Agency,
        employee.name as empl_name,
        employee.pin,
        employee.shift

        FROM employee_clock,patient,employee

        WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn >=  1  AND DATE(date) = '$tmpdte'  AND  (patient.name LIKE '%".$search."%' OR employee.name LIKE '%".$search."%') AND patient.Agency = '$agency_code' AND reset IS NULL ";
                           // ORDER BY ".$sortorder." ".$desc.", employee_clock_id ASC    LIMIT " .$from. ", " .$to . " ";
                            //AND (TIME(date) = '00:00:00' OR rec_id IS NULL )
      }

      if ($IsZero == "" )  {
        $MySQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
        employee_clock.patient_id AS pt_id,
        employee_clock.employee_id,
        employee_clock.date,
        employee_clock.tagedit,
        employee_clock.latitude,
        employee_clock.longitude,
        employee_clock.isIn,
        employee_clock.employee_clock_id,
        patient.patient_id, 
        patient.name as pt_name,
        patient.phone,
        patient.Agency,
        employee.name as empl_name,
        employee.pin,
        employee.shift
        FROM employee_clock,patient,employee
        WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND (isIn =  1 OR  (isIn = 2 AND reset IS  NULL) ) AND DATE(date) = '$tmpdte'  AND  (patient.name LIKE '%".$search."%' OR employee.name LIKE '%".$search."%') AND patient.Agency = '$agency_code' ";
                            //ORDER BY ".$sortorder." ".$desc.", employee_clock_id ASC    LIMIT " .$from. ", " .$to . " ";
                            //AND (TIME(date) = '00:00:00' OR rec_id IS NULL )
      }
      if(!empty($dropdevice))
      {
        if ($dropdevice == 'P') { 
          $MySQL.=' AND (employee_clock.latitude = "" OR employee_clock.longitude = "") ';
        }elseif ($dropdevice == 'G') { 
          $MySQL.=' AND (employee_clock.latitude != "" OR employee_clock.longitude != "" ) ';
        }elseif ($dropdevice == 'M') {
          $MySQL.=' AND employee_clock.tagedit = 4 ';
        }
      }
      if(isset($_GET['duplicate']) && $_GET['duplicate']=='yes') {
        $MySQL .= "GROUP BY employee_clock.patient_id , employee_clock.employee_id HAVING COUNT(employee_clock.patient_id) > 1 AND COUNT(employee_clock.employee_id) > 1 "; 
      } else {
        $MySQL .= 'ORDER BY employee.lastname asc, employee_clock_id ASC ';      
      }

      if(empty($_GET['show']) || $_GET['show']!='all') {
        $MySQL .= "LIMIT ".$from. ", " .$to; 
      }

            //echo $MySQL;

      $data = [];

      $data['datetrans'] = $tmpdte;
      $data['IsZero'] =   $IsZero;
      $data['dropdevice'] = $dropdevice;
      $data['search'] = $search;
      $data['payroll'] = $payroll;
      $data['show'] = !empty($_GET['show'])?$_GET['show']:'0';
      $data['timesheetData'] = [];

      if (!empty($_GET['btnSubmit']) || !empty($_GET['show'])) {
        $data['timesheetData'] = $this->client->getTimesheetData($MySQL);
      }

      $this->load->view('common/header.php');
      $this->load->view('common/sidebar.php');
      $this->load->view('timesheet/view.php',$data);
      $this->load->view('common/footer.php');
    } else {
      redirect();
    }
  }

  public function manualupd($datetrans) {
    $datetemp = date('Y-m-d',strtotime($datetrans));
        //echo 'Updating records '.$datetemp.'... Done! <br>';

    $MySQL2 = "SELECT SQL_CALC_FOUND_ROWS 
    employee_clock.patient_id AS pt_id,
    employee_clock.employee_id,
    employee_clock.patient_id,
    employee_clock.date,
    employee_clock.rec_id,
    employee_clock.tagedit,
    employee_clock.latitude,
    employee_clock.longitude,
    employee_clock.employee_clock_id

    FROM employee_clock
    WHERE reset is NULL  AND DATE(date) = '$datetemp'  order by employee_clock_id";

    $tstSQL = $MySQL2;
    $tstExec = $this->Comman_model->getCustomQueryData($tstSQL);

    foreach ($tstExec as $key => $tstResult) {

      $emplid2 = $tstResult['employee_id'];
      $ptid2 = $tstResult['patient_id'];
      $employee_clock_id = $tstResult['employee_clock_id'];   

      $strSQL3 = "SELECT * FROM employee_clock WHERE DATE(date) = '$datetemp' AND employee_id = '$emplid2' AND patient_id = '$ptid2'  AND latitude != '' and reset is null ORDER BY employee_clock_id ";
      $objResult3 = $this->Comman_model->getCustomQueryData($strSQL3, 'row');
      $reset = 1;
      /* check for next day logout */
      if (!empty($objResult3) && $objResult3['isIn']  == 2 && $objResult3['reset'] == null) {
        $tagedit = 3;
        $x = 1;
        $latitude = $objResult3['latitude'];
        $longitude = $objResult3['longitude'];
                /*$insert = mysql_query("INSERT INTO  employee_clock    (
                employee_clock_id,
                employee_id,
                patient_id,
                tagedit,
                isIn,
                date,
                latitude,
                longitude
                ) VALUES (
                NULL,
                '$emplid2',
                '$ptid2',
                '$tagedit',
                '$x', 
                '$datetemp',
                '$latitude',
                '$longitude'
              ) ") or die (mysql_error());*/

              $dataArray = [];
              $dataArray['employee_clock_id'] = NULL;
              $dataArray['employee_id'] = $emplid2;
              $dataArray['patient_id'] = $ptid2;
              $dataArray['tagedit'] = $tagedit;
              $dataArray['isIn'] = $x;
              $dataArray['date'] = $datetemp;
              $dataArray['latitude'] = $latitude;
              $dataArray['longitude'] = $longitude;

              $insert = $this->Comman_model->insert('employee_clock', $dataArray);

            }

            $lstSQL = "SELECT * FROM employee_clock WHERE isIn = 1 AND DATE(date) = '$datetrans' AND employee_id = '$emplid2' AND patient_id = '$ptid2'  AND latitude != '' and reset is  not null ORDER BY rec_id ASC ";

            $lstResult = $this->Comman_model->getCustomQueryData($lstSQL, 'row');
            if (!empty($lstResult)) { 
              $intRows =  $lstResult['rec_id'];
            } else {
              $intRows = 10000;
            }
            
            $strSQL4 = "SELECT * FROM employee_clock WHERE isIn = 1 AND DATE(date) = '$datetemp' AND employee_id = '$emplid2' AND patient_id = '$ptid2'  AND latitude != '' and reset is null ORDER BY employee_clock_id ";
            $objExec4 = $this->Comman_model->getCustomQueryData($strSQL4);
            //$intRows = 1000;

            foreach ($objExec4 as $key => $objResult4) {

              $employee_clock_id = $objResult4['employee_clock_id'];              
                //echo   $employee_clock_id .' - '.$ptid2.' - '.$emplid2.'  '.$objResult['isIn'] . '</br>';
              ++$intRows; 
              $findSQL2 = "SELECT * FROM employee_clock WHERE isIn = 2 AND DATE(date) = '$datetemp' AND employee_id = '$emplid2' AND patient_id = '$ptid2'  AND latitude != ''  and reset is null  ORDER BY employee_clock_id";

              $findResult2 = $this->Comman_model->getCustomQueryData($findSQL2, 'row');

              if (!empty($findResult2))  {

               $employee_clock_id2 = $findResult2['employee_clock_id'];

               $where = [];
               $where['employee_clock_id'] = $employee_clock_id2;

               $dataArray = [];
               $dataArray['rec_id'] = $intRows;
               $dataArray['reset'] = $reset;

               $query3 = $this->Comman_model->update('employee_clock', $where, $dataArray);


               $where = [];
               $where['employee_clock_id'] = $employee_clock_id;
               $query4 = $this->Comman_model->update('employee_clock', $where, $dataArray);

                   //$query3 = mysql_query("UPDATE  employee_clock SET rec_id='$intRows',reset='$reset' WHERE employee_clock_id = '$employee_clock_id2' " );         

                   //$query4 = mysql_query("UPDATE  employee_clock SET rec_id='$intRows',reset='$reset' WHERE employee_clock_id = '$employee_clock_id' " );          
             }                       

           }
         }
       }

       public function dashupd4($addate) {

        $day = date("d",strtotime($addate));
        $year = date("Y",strtotime($addate));
        $month = date("m",strtotime($addate));
        if ($day >= 1 && $day <= 15) {
          $period = 1;
        } else { $period = 2; }

        if ($period == 1  )  {
          $cutoff = 1;
          $eom = 15;
          $tdate2 = strtotime($year.'-'.$month.'-01');
          $fromdate = date("Y-m-d",$tdate2);
          $tdate2 = strtotime($year.'-'.$month.'-15');
          $todate = date("Y-m-d",$tdate2);        
        } 

        if ($period ==2) {
         $cutoff = 16;
         $eom = 31;
         $tdate2 = strtotime($year.'-'.$month.'-16');
         $fromdate = date("Y-m-d",$tdate2);
           //$todate = date("Y-m-t",$tdate);         
       }

       $tdate = strtotime($year.'-'.$month.'-01');
       $update = date("Y-m-d",$tdate);

       $Agency =  $this->session->userdata('agency');

       $MySQL2 = "SELECT SQL_CALC_FOUND_ROWS DISTINCT
       employee_assignment.patient_id AS pt_id,
       employee_assignment.employee_id,
       employee_assignment.hours,
       patient.patient_id, 
       patient.name as pt_name,
       patient.phone,
       patient.patient_ref_id,
       patient.Agency
       FROM patient,employee_assignment  
       WHERE patient.patient_id = employee_assignment.patient_id  AND patient.Agency = '$Agency'  ";

       $brwExec2 = $this->Comman_model->getCustomQueryData($MySQL2);

       foreach ($brwExec2 as $key => $row2) {

        $emplid = $row2['employee_id'];
        $ptid = $row2['patient_id'];
        $timesheet = 0;
        $month = date("m",strtotime($update));
        $year = date("Y",strtotime($update));
        $lastday = date("t",strtotime($update));
        $findquery = "SELECT * FROM employee_timesheet WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND month = '$month' AND year = '$year' AND Agency = '$Agency' ";  

        $findrow = $this->Comman_model->getCustomQueryData($findquery, 'row');

        if (empty($findrow)) {

          $dataArray = [];
          $dataArray['employee_timesheet_id'] = null;
          $dataArray['patient_id'] = $ptid;
          $dataArray['employee_id'] = $emplid;
          $dataArray['year'] = $year;
          $dataArray['month'] = $month;
          $dataArray['Agency'] = $Agency;

          $timesheet = $this->Comman_model->insert('employee_timesheet', $dataArray);


        }  else {

         $timesheet = $findrow['employee_timesheet_id'];
       }

       $arr = '';
       $gtotal = 0;
       for ( $d=$cutoff;$d <= $eom; $d++) {
        $date = date("Y",strtotime($update)).'-'.date('m',strtotime($update)).'-'.sprintf("%02s", $d);
        $tmpdte = $date;
        $ctotal = 0;
        $c = 0;
        if (date('d',strtotime($addate)) == date('d',strtotime($tmpdte))) {
                  //include("dashcalc.php");
          $ctotal =  $this->dashcalc($tmpdte,$emplid,$ptid);
          $c = quarter($ctotal);  
        }  else {
          $fquery = "SELECT * FROM employee_timesheet WHERE employee_timesheet_id = '$timesheet'";  
          $frow = $this->Comman_model->getCustomQueryData($fquery, 'row');
          if (empty($frow))  {
            $fcol = 'day'.sprintf("%02s", $d);
            $c = quarter($frow[$fcol]); 
          }

        }
        $arr[$d] = $c;
        $gtotal = $gtotal + $c;
      }


      if ($period == 1  )  {
        $where = [];
        $where['employee_timesheet_id'] = $timesheet;

        $dataArray = [];
        $dataArray['day01'] = $arr[1];
        $dataArray['day02'] = $arr[2];
        $dataArray['day03'] = $arr[3];
        $dataArray['day04'] = $arr[4];
        $dataArray['day05'] = $arr[5];
        $dataArray['day06'] = $arr[6];
        $dataArray['day07'] = $arr[7];
        $dataArray['day08'] = $arr[8];
        $dataArray['day09'] = $arr[9];
        $dataArray['day10'] = $arr[10];
        $dataArray['day11'] = $arr[11];
        $dataArray['day12'] = $arr[12];
        $dataArray['day13'] = $arr[13];
        $dataArray['day14'] = $arr[14];
        $dataArray['day15'] = $arr[15];

        $upd = $this->Comman_model->update('employee_timesheet', $where, $dataArray);
      }

      if ($period == 2  )  {

        $where = [];
        $where['employee_timesheet_id'] = $timesheet;

        $dataArray = [];
        $dataArray['day16'] = $arr[16];
        $dataArray['day17'] = $arr[17];
        $dataArray['day18'] = $arr[18];
        $dataArray['day19'] = $arr[19];
        $dataArray['day20'] = $arr[20];
        $dataArray['day21'] = $arr[21];
        $dataArray['day22'] = $arr[22];
        $dataArray['day23'] = $arr[23];
        $dataArray['day24'] = $arr[24];
        $dataArray['day25'] = $arr[25];
        $dataArray['day26'] = $arr[26];
        $dataArray['day27'] = $arr[27];
        $dataArray['day28'] = $arr[28];
        $dataArray['day29'] = $arr[29];
        $dataArray['day30'] = $arr[30];
        $dataArray['day31'] = $arr[31];
        $dataArray['period2'] = $gtotal;

        $upd = $this->Comman_model->update('employee_timesheet', $where, $dataArray);
      }

    }       
  }

  public function postlog($postcomment) {
    $postuser = $this->session->userdata('name');
    $postdate = date("Y-m-d H:i:s");
    $postagency = $this->session->userdata('agency');
    $postmode = 0;
    $notesid = 0;
    $postcategory = '';

    $dataArray = [];
    $dataArray['postdate'] = $postdate;
    $dataArray['postuser'] = $postuser;
    $dataArray['postagency'] = $postagency;
    $dataArray['postperiod'] = $postmode;
    $dataArray['postcomment'] = $postcomment;
    $dataArray['postcategory'] = $postcategory;
    $dataArray['notesid'] = $notesid;

    $postlog_id = $this->Comman_model->insert('postlog', $dataArray);

  }

  public function checkPayroll($datetrans, $agency_code) {
    $thedate = date('Y-m-d',strtotime($datetrans)); 
    $month  = date('m',strtotime($datetrans));
    $year  = date('Y',strtotime($datetrans));
    $day  = date('d',strtotime($datetrans));
    $MON = date('M',strtotime($datetrans));
    $msg = '';
    $okaymsgs = 0;
    $cmpmsgs = '';

        //echo $datetrans;
    if ($agency_code == 2 || $agency_code == 4 ) {
      $cmpmsgs = "Payroll for service date ( ".$thedate." is locked) please inform payroll support for timesheet changes/update...";
      $TchkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
      $TchkResult = $this->Comman_model->getCustomQueryData($TchkSQL, 'row');

      if (!empty($TchkResult))  {
        $start_date = $TchkResult['start_date'];
        $SchkSQL = "SELECT * FROM employee_finalheader WHERE start_date = '$start_date'  AND Agency = '$agency_code' AND payroll = 1";
        $SchkResult = $this->Comman_model->getCustomQueryData($SchkSQL, 'row');
        if (!empty($SchkResult))  {
          $msg = "Payroll Locked!";
          $okaymsgs = 1;
        }      
      }        

    }                       

    if ($agency_code == 1 || $agency_code == 3 ) {

      if ($day <= 15 )  { $pd = 1;}
      if ($day >= 16 )  { $pd = 2;}

      $cmpmsgs = "Payroll for month period ( ".$MON." period".$pd." is locked) please inform payroll support for timesheet changes/update...";
      $xfindSQL =  "SELECT * FROM employee_finalheader WHERE year = '$year' AND month = '$month' AND Agency = '$agency_code'";
      $xfindResult = $this->Comman_model->getCustomQueryData($xfindSQL, 'row');
      if ($xfindResult['payroll'] == 1 && $day <= 15 )  {
        $okaymsgs = 1; 
        $msg = "Payroll Locked";
      }
      if ($xfindResult['payroll2'] == 1 && $day  >= 16 )  {
        $okaymsgs = 1; 
        $msg = "Payroll Locked";
      }
    }

    $payroll = [];
    $payroll['msg'] = $msg;
    $payroll['okaymsgs'] = $okaymsgs;
    $payroll['cmpmsgs'] = $cmpmsgs;

    return $payroll;
  }


  public function dashAdd() {
    if(isset($_SESSION['name'])) {

            /*$tmpdte = date('Y-m-d'); 
            if(!empty($_GET['fromDate'])) {
                $fromDate = $_GET['fromDate'];
                if(!empty($_GET['action'])) {
                    if($_GET['action']=='previous') {
                        $fromDate = date('Y-m-d',(strtotime ( '-1 day' , strtotime ( $fromDate) ) ));    
                    }
                    if($_GET['action']=='next') {
                        $fromDate = date('Y-m-d',(strtotime ( '+1 day' , strtotime ( $fromDate) ) ));    
                    }
                }
                $tmpdte = date( 'Y-m-d', strtotime($fromDate));     
                $this->session->set_userdata('date', $fromDate);
            } else {
                if(!empty($this->session->userdata('date'))) {
                    $datetrans = $this->session->userdata('date');
                    $tmpdte = date( 'Y-m-d', strtotime($datetrans));     
                }
              }*/

              $action = @$_GET['action'];
              $datetrans = @$_GET['datetrans'];
              $IsZero = @$_GET['IsZero'];
              $search = @$_GET['search'];
              $from = 0;$to = 0;
              if(!empty($_GET['show']) && $_GET['show']!='all') {
                $to = $_GET['show'];
              }


              $agency_code = $this->session->userdata('agency');
              $MySQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT
              employee_assignment.patient_id AS pt_id,
              employee_assignment.hours,
              patient.patient_id, 
              patient.name as pt_name,
              patient.phone,
              employee.name as empl_name,
              employee.employee_id,
              employee.pin,
              patient.Agency
              FROM patient,employee_assignment,employee  

              WHERE (patient.patient_id = employee_assignment.patient_id AND employee_assignment.employee_id = employee.employee_id )  AND (employee.name LIKE '%".$search."%'  OR  patient.name LIKE '%".$search."%') AND  patient.Agency = '$agency_code' " ;  

              if(empty($_GET['show']) || $_GET['show']!='all') {
                $MySQL .= "LIMIT ".$from. ", " .$to; 
              }
            //ORDER BY ".$sortorder." ".$desc."    LIMIT " .$from. ", " .$to . " ";

            //echo $MySQL;die;

              $data = [];

              $data['datetrans'] = $datetrans;
              $data['IsZero'] =   $IsZero;
              $data['search'] = $search;
              $data['show'] = $to;

            //print_r($data);die;


              $data['dashAddData'] = $this->Comman_model->getCustomQueryData($MySQL);

              $this->load->view('common/header.php');
              $this->load->view('common/sidebar.php');
              $this->load->view('timesheet/dashadd',$data);
              $this->load->view('common/footer.php');
            } else {
              redirect();
            }
          }




          public function singleview() {

            if(!isset($_SESSION['name'])) {
              redirect();
            }

            $data               = [];
            $agency_code = $this->session->userdata('agency');

            $year = date("Y",strtotime($_GET['datetrans'])); 
            $month = date("m",strtotime($_GET['datetrans'])); 
            $tdate = strtotime($year.'-'.$month.'-01');
            $action = @$_GET['action'];
            if (empty($action) ) {
              $day = date("d",strtotime($_GET['datetrans']));
              if ($day >= 1 && $day <= 15) {
                $action = 1;
              } else { 
                $action = 2; 
              }
            }

            if ($action == 1  )  {
              $cutoff = 1;
              $eom = 15;
              $tdate2 = strtotime($year.'-'.$month.'-01');
              $fromdate = date("Y-m-d",$tdate2);
              $tdate2 = strtotime($year.'-'.$month.'-15');
              $todate = date("Y-m-d",$tdate2);        
            } 


            if ($action ==2)   {
              $cutoff = 16;
              $eom = 31;
              $tdate2 = strtotime($year.'-'.$month.'-16');
              $fromdate = date("Y-m-d",$tdate2);
              $todate = date("Y-m-t",$tdate);         
            }


            if ($agency_code == 2 || $agency_code == 4) {
              $thedate = $_GET['datetrans'];

              $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
            //$chkExec = mysql_query($chkSQL);
            //check for pair
            //$chkResult = mysql_fetch_array($chkExec);

              $chkResult = $this->Comman_model->getCustomQueryData($chkSQL);

              if (!empty($chkResult))  {
                $fromdate = $chkResult[0]['start_date'];
                $todate= $chkResult[0]['end_date'];
              }    

            }          

            $emplid = $_GET['emplid'];
            $ptid = $_GET['ptid'];

            $where = [];
            $where['employee_id'] = $emplid;
            $empResult = $this->Comman_model->get_row('employee', $where);

            $where = [];
            $where['patient_id'] = $ptid;
            $ptResult = $this->Comman_model->get_row('patient', $where);


            if ($agency_code == 1 || $agency_code == 3 )  {
             $data['heading'] = "  Employee Name:".$empResult['name'].'/Patient Name: '.$ptResult['name'].' Period '.$action . '</br> ';
           } else {
             $data['heading'] = "  Employee Name:".$empResult['name'].'/Patient Name: '.$ptResult['name'].' '. '</br> ';                        
           } 

           $taskSQL = "SELECT * FROM employee_clock WHERE (employee_id = '$emplid' AND patient_id = '$ptid') AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate'  " ;
           $taskExec = $this->Comman_model->getCustomQueryData($taskSQL);
           foreach ($taskExec as $key => $taskResult) {
            $t = explode('.',$taskResult['signfilename']);
            if (@$t[1] == 'png')  {
              $ovrsign = $taskResult['signfilename'];
            }
            if($taskResult['latitude'] != '' ) {
              if ($taskResult['tasks'] != '' ) {
                $ovrtask = $taskResult['tasks'];
              } 
            } else {
              if ($taskResult['ivr_task'] != '' ) {
                $ovrtask = $taskResult['ivr_task'];
              }                         
            }
          }

        //echo $ovrsign;    

        //$tmpdte = $timedate;    

          $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' AND reset IS NOT NULL ORDER BY date ";

          $data['singleViewData'] = $this->Comman_model->getCustomQueryData($MySQL);


          $data['fromdate']   = $fromdate;
          $data['todate']     = $todate;
          $data['ptResult']   = $ptResult;  
          $data['action']   = $action;  


          if (empty($_GET["view"])) { 
            $data['view'] = "OFF";     
          }

          if (!empty($_GET["formSubmit"]) && $_GET["formSubmit"] == "View History") {
            if ($data['view']  == "OFF" )  {
              $data['view'] = "ON"; 
            } else {
              $data['view'] = "OFF";
            }
          } else {
            $data['view'] = @$_GET['view']; 
          }

          $this->load->view('common/header.php');
          $this->load->view('common/sidebar.php');
          $this->load->view('timesheet/single-view.php',$data);
          $this->load->view('common/footer.php');
        }

        public function viewPdf() {

          $cnt = 30;
          $ctr = 0;
          $max  = 14;
          $spc = 55;
          $total = 0;
          $srptot = 0;
          $trans = 0;
          $xrow = $spc - 20;
          $orient = 'L';
          require_once(APPPATH . 'libraries/timesheet-view-pdf.php'); 
          $pdf = new timesheetViewPDF($orient, 'mm',array(215.9,330.2) );

          $pdf->AliasNbPages();
          $pdf->AddPage($orient);

          $pdf->SetFont('Arial','',14);
          $pdf->SetLeftMargin(10);

          $curdate =  date('d/m/Y'); 
          $ptid = $_GET['ptid'];
          $emplid = $_GET['emplid']; 
          $year = date("Y",strtotime($_GET['datetrans'])); 
          $month = date("m",strtotime($_GET['datetrans'])); 
          $action = $_GET['action'];


          $tdate = strtotime($year.'-'.$month.'-01');
          if ($action == null ) {
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
              $action = 1;
            } else { 
              $action = 2; 
            }
          }

          if ( $action == 1 ) {
            $cutoff = 1;
            $eom = 15;
            $tdate2 = strtotime($year.'-'.$month.'-01');
            $fromdate = date("Y-m-d",$tdate2);
            $tdate2 = strtotime($year.'-'.$month.'-15');
            $todate = date("Y-m-d",$tdate2);        
          } 

          if ( $action ==2 ) {
            $cutoff = 16;
            $eom = 31;
            $tdate2 = strtotime($year.'-'.$month.'-16');
            $fromdate = date("Y-m-d",$tdate2);
            $todate = date("Y-m-t",$tdate);         
          }

          $fromdate = $_GET['fromdate'];
          $todate = $_GET['todate'];

          $where = [];
          $where['employee_id'] = $emplid;
          $empResult = $this->Comman_model->get_row('employee', $where);

          $where = [];
          $where['patient_id'] = $ptid;
          $ptResult = $this->Comman_model->get_row('patient', $where);

          $taskSQL = "SELECT * FROM employee_clock WHERE (employee_id = '$emplid' AND patient_id = '$ptid') AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate'  " ;
          $taskExec = $this->Comman_model->getCustomQueryData($taskSQL);
          foreach ($taskExec as $key => $taskResult) {
            $t = explode('.',$taskResult['signfilename']);
            if (@$t[1] == 'png')  {
              $ovrsign = $taskResult['signfilename'];
            }
            if($taskResult['latitude'] != '' ) {
              if ($taskResult['tasks'] != '' ) {
                $ovrtask = $taskResult['tasks'];
              } 
            } else {
              if ($taskResult['ivr_task'] != '' ) {
                $ovrtask = $taskResult['ivr_task'];
              }                         
            }
          }


          $agency_code = $this->session->userdata('agency');

          $piclogo='';
          if ( $agency_code == 1)  {
            $piclogo = "Homemakers.png";
          }  
          if ( $agency_code == 2)  {
            $piclogo = "Seniorcares.png";
          }  
          if ( $agency_code == 3)  {
            $piclogo = "Caregivers.png";
          }  
          if ( $agency_code == 4)  {
            $piclogo = "Rockford.png";
          }           


          $pdf->setxy(10,30);
          $pdf->Image(base_url('assets/images/agency').'/'.$piclogo,150,10);

          $pdf->Cell(50,5, 'Worker Name:'.$empResult['name'],0,1,'L');
          $pdf->Cell(50,5, 'Client Name:'.$ptResult['name'],0,1,'L');

        //$tmpdte = $timedate;

          $MySQL = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' ORDER BY date";

          $objExec = $this->Comman_model->getCustomQueryData($MySQL);

          $pdf->SetFont('Arial','',9);

          $pdf->Cell(18,10,'Date',1,0,'C');
          $pdf->Cell(12,10,'In',1,0,'C');
          $pdf->Cell(12,10,'Out',1,0,'C');
          $pdf->Cell(12,10,'Total',1,0,'C');
          $pdf->Cell(230,10,'Services Provided',1,0,'C');
          $pdf->Cell(30,10,'EVV',1,1,'C');
          $cntr = 44;

          $index = 0;

          $timetotal = 0;

          foreach ($objExec as $key => $row) {
            $temp = '';
        //$sl = "disabled='disabled'";
            $c1 = $row['employee_clock_id'];
            $temp = date('H:i',strtotime($row['date']));
            $curdate = date('m/d/Y',strtotime($row['date']));
            $latitude = $row['latitude'];
            $task3 = $row['tasks'];
            $ivr_task = $row['tasks'];
            $task1 = trim($row['ivr_task']);
            $t = explode(":",$temp );
            $hr1 = $t[0];
            $mn1 = $t[1];
        //echo $hr1.':'.$mn1;
            $timedate = date('Y-m-d',strtotime($row['date']));
            $fdate = date('Y-m-d',strtotime($row['date']));
            $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

            $disp1 = $hr1 + ($mn1 / 60);
            $tot1 = quarter($disp1);
            $tot1 = number_format($tot1,2);
            $from_time=$tot1;
            $x = '2';
            $rec_id = $row['rec_id'];

            $where = [];
            $where['employee_id'] = $emplid;
            $where['patient_id'] = $ptid;
            $where['DATE(date)'] = $timedate;
            $where['isIn'] = $x;
            $where['rec_id'] = $rec_id;
            $rowdate = $this->Comman_model->get_row('employee_clock', $where);

            $to_time=strtotime($rowdate['date']);
            $total = number_format((($to_time - $from_time) / 60) / 60,2);
            $temp = '';
            $c2 = null;
            if ($rowdate != 0 )  {$temp = date('H:i',strtotime($rowdate['date'])); $c2 = $rowdate['employee_clock_id'];     
            $task2 = trim($rowdate['ivr_task']);}
            $t = explode(":",$temp );
            $hr2 = $t[0];
            $mn2 = $t[1];
            $fdate = date('Y-m-d',strtotime($rowdate['date']));
            $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

            $disp2 = $hr2 + ($mn2 / 60);
            $tot2 = quarter($disp2);
            $tot2 = number_format($tot2,2);

            $to_time=$tot2;


            if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') )  {
              $total = 0;
            } else {
              $total = $to_time - $from_time;
              $timetotal = $timetotal + $total;
            }

            if ($task1 != null ) {
              $task2 = $task1;
            }

            if ($latitude != null ) {
              $task2 = $task3;
            }

            $list = ""; 

            if ($task2 == '1' || $task1 == '1' || $row['ivr_task'] == '1')  {
              $task2 = "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16";
            }


            $t = explode(",",$task2 );
            $list = '';
            for ($x = 0;$x <= 16; $x++) {
              $item = @$t[$x];

              $where = [];
              $where['task_code'] = $item;
              $drpResult = $this->Comman_model->get_row('employee_tasks', $where);

              $where = [];
              $where['patient_id'] = $ptid;
              $objResult2 = $this->Comman_model->get_row('tblpatientservices', $where);

              if ($objResult2['Eating'] == -1  && $item ==  1)   { $list = $list.$drpResult['task_name'].', ';   }
              if ($objResult2['Bathing'] == -1 && $item ==  2)   { $list = $list.$drpResult['task_name'].', ';   }
              if ($objResult2['Grooming'] == -1 && $item ==  3)   { $list = $list.$drpResult['task_name'].', '; }
              if ($objResult2['Dressing'] == -1 && $item ==  4)   { $list = $list.$drpResult['task_name'].', '; } 
              if ($objResult2['Transferring'] == -1 && $item ==  5)   { $list = $list.$drpResult['task_name'].', '; }
              if ($objResult2['Incontinence'] == -1 && $item ==  6)   {$list = $list.$drpResult['task_name'].', ';  }
              if ($objResult2['ManagingMoney'] == -1 && $item ==  7)   { $list = $list.$drpResult['task_name'].', '; }
              if ($objResult2['Telephoning'] == -1 && $item ==  8)   { $list = $list.$drpResult['task_name'].', '; }
              if ($objResult2['PreparingMeals'] == -1 && $item ==  9)   { $list = $list.$drpResult['task_name'].', '; }
              if ($objResult2['Laundry'] == -1 && $item ==  10)   { $list = $list.$drpResult['task_name'].', '; } 
              if ($objResult2['Housework'] == -1 && $item ==  11)   { $list = $list.$drpResult['task_name'].', '; } 
              if ($objResult2['OutsideHome'] == -1 && $item ==  12)   { $list = $list.$drpResult['task_name'].', '; }
              if ($objResult2['RoutineHealth'] == -1 && $item ==  13)   { $list = $list.$drpResult['task_name'].', ';  } 
              if ($objResult2['SpecialHealth'] == -1 && $item ==  14)   { $list = $list.$drpResult['task_name'].', '; }
              if ($objResult2['BeingAlone'] == -1 && $item ==  15)   { $list = $list.$drpResult['task_name'].', '; }

            }  



            if ($task2 == '1' || $task1 == '1' || $row['ivr_task'] == '1')  {
              $list = "ALL SERVICES";
              $l1 = 'Eating, Bathing, Grooming, Dressing,'; 
              $l2 = 'Transferring, Incontinence,';  
              $l3 = 'Managing Money, Telephoning, Preparing Meals, Laundry, Housework'; 
            }


            $pdf->Cell(18,8,$curdate,1,0,'C');
            $pdf->Cell(12,8,$hr1.':'.$mn1,1,0,'C');
            $pdf->Cell(12,8,$hr2.':'.$mn2,1,0,'C');
            $pdf->Cell(12,8,$total,1,0,'C');
            $pdf->Cell(230,8,$list,1,0,'C');

            if ($latitude == null ) {
              $pdf->Cell(30,8,$ptResult['phone'],1,1,'C');
            } else {
              $t = explode('.',$row['signfilename']);

              $filename = 'geo/GetSignature/'.$row['signfilename'];
              $err = 1;
              if ($t[1] == 'png' ) {
                $err = 0;
              }
              if ($row['signfilename'] == 'null' || $err == 1) {   
                $filename = 'geo/GetSignature/'.$ovrsign;
                $err = 0;
              }

              $cntr = $cntr + 8;    
              if (file_exists($filename)  && $err == 0 ) { 
                $pdf->Cell(30,8,'',1,1,'C');   
                $pdf->Image($filename,295,$cntr,25);
              }  else {
                $pdf->Cell(30,8,'No Image',1,1,'C');    
              }
            }


            $cnt = $cnt + 10;
          }

          $pdf->SetFont('Arial','',14);
          $pdf->Cell(80,10,'Total:'.$timetotal,0,1,'C');
          $pdf->Cell(100,5, date("M",strtotime($fromdate)).'-'.date("Y",strtotime($fromdate)),0,0,'L');
          $pdf->Output();
        }

        public function printTask() {
          if(!isset($_SESSION['name'])) {
            redirect();
          }

          $data               = [];
          $agency_code = $this->session->userdata('agency');

          $year = date("Y",strtotime($_GET['datetrans'])); 
          $month = date("m",strtotime($_GET['datetrans'])); 
          $tdate = strtotime($year.'-'.$month.'-01');
          $action = @$_GET['action'];
          if (empty($action) ) {
            $day = date("d",strtotime($_GET['datetrans']));
            if ($day >= 1 && $day <= 15) {
              $action = 1;
            } else { 
              $action = 2; 
            }
          }

          if ($action == 1  )  {
            $cutoff = 1;
            $eom = 15;
            $tdate2 = strtotime($year.'-'.$month.'-01');
            $fromdate = date("Y-m-d",$tdate2);
            $tdate2 = strtotime($year.'-'.$month.'-15');
            $todate = date("Y-m-d",$tdate2);        
          } 


          if ($action ==2)   {
            $cutoff = 16;
            $eom = 31;
            $tdate2 = strtotime($year.'-'.$month.'-16');
            $fromdate = date("Y-m-d",$tdate2);
            $todate = date("Y-m-t",$tdate);         
          }


          if ($agency_code == 2 || $agency_code == 4) {
            $thedate = $_GET['datetrans'];

            $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
            //$chkExec = mysql_query($chkSQL);
            //check for pair
            //$chkResult = mysql_fetch_array($chkExec);

            $chkResult = $this->Comman_model->getCustomQueryData($chkSQL);

            if (!empty($chkResult))  {
              $fromdate = $chkResult[0]['start_date'];
              $todate= $chkResult[0]['end_date'];
            }    

          }          

          $emplid = $_GET['emplid'];
          $ptid = $_GET['ptid'];

          $where = [];
          $where['employee_id'] = $emplid;
          $empResult = $this->Comman_model->get_row('employee', $where);

          $where = [];
          $where['patient_id'] = $ptid;
          $ptResult = $this->Comman_model->get_row('patient', $where);


          if ($agency_code == 1 || $agency_code == 3 )  {
           $data['heading'] = "  Employee Name:".$empResult['name'].'/Patient Name: '.$ptResult['name'].' Period '.$action . '</br> ';
         } else {
           $data['heading'] = "  Employee Name:".$empResult['name'].'/Patient Name: '.$ptResult['name'].' '. '</br> ';                        
         } 

         $taskSQL = "SELECT * FROM employee_clock WHERE (employee_id = '$emplid' AND patient_id = '$ptid') AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate'  " ;
         $taskExec = $this->Comman_model->getCustomQueryData($taskSQL);
         foreach ($taskExec as $key => $taskResult) {
          $t = explode('.',$taskResult['signfilename']);
          if (@$t[1] == 'png')  {
            $ovrsign = $taskResult['signfilename'];
          }
          if($taskResult['latitude'] != '' ) {
            if ($taskResult['tasks'] != '' ) {
              $ovrtask = $taskResult['tasks'];
            } 
          } else {
            if ($taskResult['ivr_task'] != '' ) {
              $ovrtask = $taskResult['ivr_task'];
            }                         
          }
        }

        //echo $ovrsign;    
        
        //$tmpdte = $timedate;    
        
        $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' AND reset IS NOT NULL ORDER BY date ";

        $data['singleViewData'] = $this->Comman_model->getCustomQueryData($MySQL);

        $where = [];
        $where['agency_code'] = $agency_code;    
        $agencyData = $this->Comman_model->get_row('agency', $where);

        $data['fromdate']   = $fromdate;
        $data['todate']     = $todate;
        $data['ptResult']   = $ptResult;  
        $data['empResult']  = $empResult;  
        $data['action']     = $action; 
        $data['agencyData'] = $agencyData;


        if (empty($_GET["view"])) { 
          $data['view'] = "OFF";     
        }

        if (!empty($_GET["formSubmit"]) && $_GET["formSubmit"] == "View History") {
          if ($data['view']  == "OFF" )  {
            $data['view'] = "ON"; 
          } else {
            $data['view'] = "OFF";
          }
        } else {
          $data['view'] = @$_GET['view']; 
        }

        $data['piclogo']='';
        if ( $agency_code == 1)  {
          $data['piclogo'] = "Homemakers.png";
        }  
        if ( $agency_code == 2)  {
          $data['piclogo'] = "Seniorcares.png";
        }  
        if ( $agency_code == 3)  {
          $data['piclogo'] = "Caregivers.png";
        }  
        if ( $agency_code == 4)  {
          $data['piclogo'] = "Rockford.png";
        }   


        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('timesheet/print-task.php',$data);
        $this->load->view('common/footer.php');
      }


      public function timesheet() {

        if(!isset($_SESSION['name'])) {
          redirect();
        }

        $datetrans = $_GET['datetrans'];
        $IsZero =   $_GET['IsZero'];
        $emplid = $_GET['emplid'];
        $ptid = $_GET['ptid'];

        $data               = [];
        $agency_code = $this->session->userdata('agency');

        $year = date("Y",strtotime($datetrans)); 
        $month = date("m",strtotime($datetrans)); 
        $tdate = strtotime($year.'-'.$month.'-01');

        $action = @$_GET['action'];

        if ($action == null ) {
          $day = date("d",strtotime($datetrans));
          if ($day >= 1 && $day <= 15) {
            $action = 1;
          } else { 
            $action = 2; 
          }
        }
        if ($action == 1  )  {
          $cutoff = 1;
          $eom = 15;
          $tdate2 = strtotime($year.'-'.$month.'-01');
          $fromdate = date("Y-m-d",$tdate2);
          $tdate2 = strtotime($year.'-'.$month.'-15');
          $todate = date("Y-m-d",$tdate2);        
        } 

        if ($action ==2)   {
          $cutoff = 16;
          $eom = 31;
          $tdate2 = strtotime($year.'-'.$month.'-16');
          $fromdate = date("Y-m-d",$tdate2);
          $todate = date("Y-m-t",$tdate);         
        }

        if ($agency_code == 2 || $agency_code == 4) {
          $thedate = $datetrans;

          $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
          $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');

          if (!empty($chkResult))  {
            $fromdate = $chkResult['start_date'];
            $todate= $chkResult['end_date'];
          }    
        }       


        
        $shift = 0;
        //$datetrans = $timedate;
        $where = [];
        $where['employee_id'] = $emplid;
        $empResult = $this->Comman_model->get_row('employee', $where);
        $shift = $empResult['shift'];

        $where = [];
        $where['patient_id'] = $ptid;
        $ptResult = $this->Comman_model->get_row('patient', $where);

        $data['heading'] = "  Employee Name:".$emplid.'-'.$empResult['name'].'/Patient:'.$ptid.'-'.$ptResult['name'].' Period '.$action . ' Code: '.$shift. '</br> ';


        ///  ***  //
        $thedate = date('Y-m-d',strtotime($datetrans)); 
        $month  = date('m',strtotime($datetrans));
        $year  = date('Y',strtotime($datetrans));
        $day  = date('d',strtotime($datetrans));
        $MON = date('M',strtotime($datetrans));
        $msg = '';
        $okaymsgs = 0;

        //echo $datetrans;
        if ($agency_code == 2 || $agency_code == 4 ) {
          $cmpmsgs = "Payroll for service date ( ".$thedate." is locked) please inform payroll support for timesheet changes/update...";
          $TchkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
            //$TchkExec = mysql_query($TchkSQL);
            //check for pair
            //$TchkResult = mysql_fetch_array($TchkExec);

          $TchkResult = $this->Comman_model->getCustomQueryData($TchkSQL, 'row');


          if (!empty($TchkResult))  {
            $start_date = $TchkResult['start_date'];
            $SchkSQL = "SELECT * FROM employee_finalheader WHERE start_date = '$start_date'  AND Agency = '$agency_code' AND payroll = 1";
                //$SchkExec = mysql_query($SchkSQL);
                //$SchkResult = mysql_fetch_array($SchkExec);

            $SchkResult = $this->Comman_model->getCustomQueryData($SchkSQL, 'row');                
            if (!empty($SchkResult) )  {
              $msg = "Payroll Locked!";
              $okaymsgs = 1;
            }      
          }        

        }                       

        if ($agency_code == 1 || $agency_code == 3 ) {

          if ( $action  == 1 )  { $pd = 1; }
          if ( $action  == 2 ) { $pd = 2; }
          $cmpmsgs = "Payroll for month period ( ".$MON." period".$pd." is locked) please inform payroll support for timesheet changes/update...";

          $xfindSQL =  "SELECT * FROM employee_finalheader WHERE year = '$year' AND month = '$month' AND Agency = '$agency_code'";
            //$xfindExec = mysql_query($xfindSQL);
            //$xfindResult =  mysql_fetch_array($xfindExec);

          $xfindResult =  $this->Comman_model->getCustomQueryData($xfindSQL, 'row');

          if ($xfindResult['payroll'] == 1 && $action == 1 )  {
            $okaymsgs = 1; 
            $msg = "Payroll Locked";
          }                       
          if ($xfindResult['payroll2'] == 1 && $action  == 2 )  {
            $okaymsgs = 1; 
            $msg = "Payroll Locked";
          }                       

        }


        $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn >= 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' ORDER BY date ";  
        //LIMIT " .$from. ", " .$to . " ";

        if ($IsZero == 3 )  {    
          $MySQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
          employee_clock.patient_id,
          employee_clock.employee_id,
          employee_clock.date,
          employee_clock.tagedit,
          employee_clock.latitude,
          employee_clock.longitude,
          employee_clock.isIn,
          employee_clock.upload_time,
          employee_clock.employee_clock_id  
          FROM employee_clock           
          WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn >= 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' AND reset IS NULL ORDER BY date ";  
                     //LIMIT " .$from. ", " .$to . " ";
        }

       // echo $MySQL;die;


        if ( empty($_GET["view"]) ) { 
          $data['view'] = "OFF";
        } else{
          if ($_GET["view"]  == "OFF" ) {
            $data['view'] = "ON"; 
          } else {
            $data['view'] = "OFF";
          }
        }


        $data['fromdate']       =   $fromdate;
        $data['todate']         =   $todate;
        $data['emplid']         =   $emplid;
        $data['ptid']           =   $ptid;
        $data['agency_code']    =   $agency_code;
        $data['datetrans']      =   $datetrans;
        $data['action']         =   $action;
        $data['year']           =   $year;
        $data['month']          =   $month;
        $data['IsZero']         =   $IsZero;
        $data['okaymsgs']       =   $okaymsgs;
        $data['cmpmsgs']        =   $cmpmsgs;


        $data['timesheetData'] = $this->Comman_model->getCustomQueryData($MySQL);

        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('timesheet/timesheet.php',$data);
        $this->load->view('common/footer.php');
      }




      public function dashupd3($addate='', $emplid='', $ptid='') {


        if(empty($emplid)) {
          $emplid = $_GET['emplid'];  
        }

        if(empty($emplid)) {
          $ptid = $_GET['ptid'];
        }

        $day = date("d",strtotime($addate));
        $year = date("Y",strtotime($addate));
        $month = date("m",strtotime($addate));

        if ($day >= 1 && $day <= 15) {
          $period = 1;
        } else { $period = 2; }

        if ($period == 1  )  {
          $cutoff = 1;
          $eom = 15;
          $tdate2 = strtotime($year.'-'.$month.'-01');
          $fromdate = date("Y-m-d",$tdate2);
          $tdate2 = strtotime($year.'-'.$month.'-15');
          $todate = date("Y-m-d",$tdate2);        
        } 

        if ($period ==2)   {
          $cutoff = 16;
          $eom = 31;
          $tdate2 = strtotime($year.'-'.$month.'-16');
          $fromdate = date("Y-m-d",$tdate2);
          $todate = date("Y-m-t",@$tdate);         
        }

        $tdate = strtotime($year.'-'.$month.'-01');
        $update = date("Y-m-d",$tdate);

        $Agency =  $this->session->userdata('agency');
        $MySQL2 = "SELECT SQL_CALC_FOUND_ROWS DISTINCT
        employee_assignment.patient_id AS pt_id,
        employee_assignment.hours,
        patient.patient_id, 
        patient.name as pt_name,
        patient.phone,
        patient.patient_ref_id,
        employee.name as empl_name,
        employee.employee_id,
        employee.pin,
        employee.ADP,
        patient.Agency
        FROM patient,employee_assignment,employee  
        WHERE (patient.patient_id = employee_assignment.patient_id AND employee_assignment.employee_id = employee.employee_id ) AND patient.Agency = '$Agency' and  employee_assignment.employee_id = '$emplid' AND patient.patient_id = '$ptid' ";

        $brwExec2 = $this->Comman_model->getCustomQueryData($MySQL2);

        foreach ($brwExec2 as $key => $row2) {

          $emplid = $row2['employee_id'];
          $ptid = $row2['patient_id'];
          $timesheet = 0;
          $month = date("m",strtotime($update));
          $year = date("Y",strtotime($update));
          $lastday = date("t",strtotime($update));

          $where = [];
          $where['employee_id'] = $emplid;
          $where['patient_id'] = $ptid;
          $where['month'] = $month;
          $where['year'] = $year;
          $where['Agency'] = $Agency;

          $findrow = $this->Comman_model->get_row('employee_timesheet', $where);


          if ( empty($findrow) ) {

            $dataArray = [];
            $dataArray['employee_timesheet_id'] = null;
            $dataArray['patient_id'] = $ptid;
            $dataArray['employee_id'] = $emplid;
            $dataArray['year'] = $year;
            $dataArray['month'] = $month;
            $dataArray['Agency'] = $Agency;

            $timesheet = $this->Comman_model->insert('employee_timesheet', $dataArray);    

          }  else {

            $timesheet = $findrow['employee_timesheet_id'];
          }

          $arr = '';
          $gtotal = 0;
          for ( $d=$cutoff;$d <= $eom; $d++) {
            $date = date("Y",strtotime($update)).'-'.date('m',strtotime($update)).'-'.sprintf("%02s", $d);
            $tmpdte = $date; 
            $ctotal = 0;
            if (date('m',strtotime($update)) == date('m',strtotime($tmpdte))) {
                    //include("dashcalc.php");
              $ctotal =  $this->dashcalc($tmpdte,$emplid,$ptid);
            }
                //print_r($ctotal);die;
            $c = quarter($ctotal);  
            $z = intval(date("d",strtotime($date)));
            
            $arr[$d] = $c;
            $gtotal = $gtotal + $c;
          }


          if ($period == 1  )  {

            $dataArray = [];
            $dataArray['day01']  =  $arr[1]; 
            $dataArray['day02']  =  $arr[2]; 
            $dataArray['day03']  =  $arr[3]; 
            $dataArray['day04']  =  $arr[4]; 
            $dataArray['day05']  =  $arr[5]; 
            $dataArray['day06']  =  $arr[6]; 
            $dataArray['day07']  =  $arr[7]; 
            $dataArray['day08']  =  $arr[8]; 
            $dataArray['day09']  =  $arr[9]; 
            $dataArray['day10']  =  $arr[10]; 
            $dataArray['day11']  =  $arr[11]; 
            $dataArray['day12']  =  $arr[12]; 
            $dataArray['day13']  =  $arr[13]; 
            $dataArray['day14']  =  $arr[14]; 
            $dataArray['day15']  =  $arr[15]; 
            $dataArray['period1']  =  $gtotal;

            $where = [];
            $where['employee_timesheet_id'] =  $timesheet;

            $upd = $this->Comman_model->update('employee_timesheet', $where, $dataArray);
          }

          if ($period == 2  )  {

            $dataArray = [];
            $dataArray['day16']  =  $arr[16]; 
            $dataArray['day17']  =  $arr[17]; 
            $dataArray['day18']  =  $arr[18]; 
            $dataArray['day19']  =  $arr[19]; 
            $dataArray['day20']  =  $arr[20]; 
            $dataArray['day21']  =  $arr[21]; 
            $dataArray['day22']  =  $arr[22]; 
            $dataArray['day23']  =  $arr[23]; 
            $dataArray['day24']  =  $arr[24]; 
            $dataArray['day25']  =  $arr[25]; 
            $dataArray['day26']  =  $arr[26]; 
            $dataArray['day27']  =  $arr[27]; 
            $dataArray['day28']  =  $arr[28]; 
            $dataArray['day29']  =  $arr[29]; 
            $dataArray['day30']  =  $arr[30]; 
            $dataArray['day31']  =  $arr[31]; 
            $dataArray['period1']  =  $gtotal;

            $where = [];
            $where['employee_timesheet_id'] =  $timesheet;

            $upd = $this->Comman_model->update('employee_timesheet', $where, $dataArray);
          }

        }       
      }

      public function dashseniorupdate2($transdate, $start_date, $addate, $emplid='', $ptid='') {

        if(empty($emplid)) {
          $emplid = $_GET['emplid'];  
        }

        if(empty($ptid)) {
          $ptid = $_GET['ptid'];
        }

        $agency_code = $this->session->userdata('agency');

        $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$start_date' AND start_date  <= '$start_date'";

        $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');

        if (!empty($chkResult)) {
          $start_date = $chkResult['start_date'];
          $end_date = $chkResult['end_date'];
          $dy = date("d",strtotime(date("Y-m-d", strtotime($addate))));
          $mn = date("m",strtotime(date("Y-m-d", strtotime($addate))));
          $yr = date("Y",strtotime(date("Y-m-d", strtotime($addate))));
        }

        $a1 = $agency_code;                     
        $datetime1 = date_create($addate);
        $datetime2 = date_create($start_date);
        $interval = date_diff($datetime1, $datetime2);


        $cnt =  $interval->format('%a');
        $cl = $cnt + 1;;

        $day = 'd'.sprintf("%02s", $cl);

        //$query = mysql_query("UPDATE  employee_2weekly SET ".$day." = 0  WHERE Agency = '$agency_code' AND start_date = '$start_date' AND employee_id = '$emplid'  AND  patient_id =  '$ptid'    " ) or die (mysql_error());

        $manSQL = "SELECT * FROM employee_clock  WHERE  employee_clock.employee_id = '$emplid'  AND  employee_clock.patient_id =  '$ptid'   AND `isIn` = 1  AND DATE(date) = '$transdate'   ORDER BY employee_clock_id ";
        //$manExec = mysql_query($manSQL);

        $manExec = $this->Comman_model->getCustomQueryData($manSQL);

        $intRows = 0;
        foreach ($manExec as $key => $manrows) {
          $addate= date("Y-m-d",strtotime($manrows['date'])); 
          $emplid = $manrows['employee_id'];
          $ptid = $manrows['patient_id'];
          $rec_id = $manrows['rec_id'];

          $temp = date('H:i',strtotime($manrows['date']));
          $t = explode(":",$temp );
          $hr1 = @$t[0];
          $mn1 = @$t[1];
          $fdate = date('Y-m-d',strtotime($manrows['date']));
          $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

          $disp1 = $hr1 + ($mn1 / 60);
          $tot1 = quarter($disp1);
          $tot1 = number_format($tot1,2);
          $from_time=$tot1;       

          $strSQL2 = "SELECT * FROM employee_clock WHERE isIn = 2 AND DATE(date) = '$addate' AND employee_id = '$emplid' AND patient_id = '$ptid'  AND rec_id = '$rec_id' ";
            //$objExec2 = mysql_query($strSQL2);
            //$objResult2 = mysql_fetch_array($objExec2);

          $objResult2 = $this->Comman_model->getCustomQueryData($strSQL2, 'row');


          if ($objResult2 != 0 ) { 
            $temp = date('H:i',strtotime($objResult2['date']));
            $t = explode(":",$temp );
            $hr2 = @$t[0];
            $mn2 = @$t[1];
            $fdate = date('Y-m-d',strtotime($objResult2['date']));
            $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

            $disp2 = $hr2 + ($mn2 / 60);
            $tot2 = quarter($disp2);
            $tot2 = number_format($tot2,2);
            $to_time=$tot2;

            $to=strtotime($idate);
          }

          if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') )  {
            $total = 0;
          } else {
            $val = $to_time - $from_time;
          }

          $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$addate' AND start_date  <= '$addate'";
            //$chkExec = mysql_query($chkSQL);
            //check for pair
            //$chkResult = mysql_fetch_array($chkExec);
          $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');
          if ($chkResult != 0)  {
            $start_date = $chkResult['start_date'];
            $end_date = $chkResult['end_date'];
            $addate = $_GET['add_date'];
            $dy = date("d",strtotime(date("Y-m-d", strtotime($addate))));
            $mn = date("m",strtotime(date("Y-m-d", strtotime($addate))));
            $yr = date("Y",strtotime(date("Y-m-d", strtotime($addate))));
          }

          $a1 = $agency_code;                     
          $datetime1 = date_create($addate);
          $datetime2 = date_create($start_date);
          $interval = date_diff($datetime1, $datetime2);


          $cnt =  $interval->format('%a');
          $cl = $cnt + 1;;

          $day = 'd'.sprintf("%02s", $cl);
          $date = 'date'.sprintf("%02s", $cl);
          if ($c1   > 14)  {
          }                           


          $findSQL = "SELECT * FROM employee_2weekly WHERE  employee_id = '$emplid' AND patient_id  = '$ptid' AND start_date ='$start_date'  AND Agency = '$a1'";
            //$findExec = mysql_query($findSQL);
            //check for pair
            //$findResult = mysql_fetch_array($findExec);

          $findResult = $this->Comman_model->getCustomQueryData($findSQL, 'row');

          if ($findResult == 0)  {
                /*$insert = mysql_query("INSERT INTO  employee_2weekly (
                employee_2weekly_id,
                Agency,
                patient_id,
                employee_id,
                start_date,
                end_date,
                ".$day.",
                ".$date."
                ) VALUES (
                null,
                '$a1',
                '$ptid',
                '$emplid',          
                '$start_date',
                '$end_date',
                '$val',
                '$addate'
                ) ") or die (mysql_error()); 
                $weekly_id = mysql_insert_id();  */

                $dataArray = [];
                $dataArray['employee_2weekly_id'] = null;
                $dataArray['Agency'] = $a1;
                $dataArray['patient_id'] = $ptid;
                $dataArray['employee_id'] = $emplid;
                $dataArray['start_date'] = $start_date;
                $dataArray['end_date'] = $end_date;
                $dataArray[$day] = $val;
                $dataArray[$date] = $addate;

                $weekly_id = $this->Comman_model->insert('employee_2weekly', $dataArray);

              } else {
                $hour = quarter($findResult[$day] + $val);
                $weekly_id = $findResult['employee_2weekly_id'];
                /*$query = mysql_query("UPDATE  employee_2weekly SET 
                ".$day."='$hour',
                ".$date."='$addate'
                WHERE employee_2weekly_id = '$weekly_id' " );           */

                $dataArray = [];
                $dataArray[$day] = $hour;
                $dataArray[$date] = $addate;

                $where = [];
                $where['employee_2weekly_id'] = $weekly_id;

                $this->Comman_model->update('employee_2weekly', $where, $dataArray);
              }

              $sumSQL="SELECT * FROM employee_2weekly WHERE employee_2weekly_id = '$weekly_id'  ";
            //$sumExec = mysql_query($sumSQL);
            //$sumResult =  mysql_fetch_array($sumExec);

              $sumResult = $this->Comman_model->getCustomQueryData($sumSQL, 'row');

              $sum_left =     $sumResult['d01']  +
              $sumResult['d02']  +
              $sumResult['d03']  +
              $sumResult['d04']  +
              $sumResult['d05']  +
              $sumResult['d06']  +
              $sumResult['d07']  +
              $sumResult['d08']  +
              $sumResult['d09']  +
              $sumResult['d10']  +
              $sumResult['d11']  +
              $sumResult['d12']  +
              $sumResult['d13']  +
              $sumResult['d14'];                                              

            /*$query = mysql_query("UPDATE employee_2weekly 
            SET total_2weekly = '$sum_left'
            WHERE employee_2weekly_id = '$weekly_id' ") or die (mysql_error()); */

            $dataArray = [];
            $dataArray['total_2weekly'] = $sum_left;

            $where = [];
            $where['employee_2weekly_id'] = $weekly_id;

            $this->Comman_model->update('employee_2weekly', $where, $dataArray);


          }   
        }


        public function updateTimesheet() {

          $agency_code = $this->session->userdata('agency');

          $emplid = $_GET['emplid'];
          $ptid   = $_GET['ptid'];
          $initial1  =  $this->session->userdata('name');
          if(empty($_GET['reason1'])) {
            $this->session->set_flashdata('error_message', 'Blank remarks are not allowed, please try again...');
            redirect($this->agent->referrer());
            exit();
          } else {
            $reason1 = $_GET['reason1'];  
          }

          $upload_date = !empty($_GET['upload_date'])?$_GET['upload_date']:'';

          if (empty($reason1) && $_GET['in'] == 'in' &&  $_GET['out'] == 'out'  ) {
            $error_message = "Blank remarks are not allowed, please try again...";
            $this->session->set_flashdata('error_message', $error_message);
            redirect($this->agent->referrer());    
            die;        
          }  

          if ($_GET['in'] == 'in') {
            $pairout = $_GET['strdate'];
            $indate =  $_GET['strdate'].' '.$_GET['hr1'].':'.$_GET['mn1'].':00';
            $modeIN = $_GET['modeIN'];
            $rec = $_GET['rec'];
            $intRows = $rec;                      
            $xdate = date("Y-m-d H:i:s",strtotime($indate));
            $c1= $_GET['c1'];
            $prevdate = $_GET['prevdate'];

            $x = '1';
            if ($c1 == null)  {
              $tagedit=3;
              $reset = 1;                     

              $dataArray = [];
              $dataArray['employee_clock_id'] = NULL;
              $dataArray['employee_id'] = $emplid;
              $dataArray['patient_id'] = $ptid;
              $dataArray['isIn'] = $x;
              $dataArray['tagedit'] = $tagedit;
              $dataArray['date'] = $xdate;
              $dataArray['reset'] = $reset;
              $dataArray['rec_id'] = $intRows;

              $c1 = $this->Comman_model->insert('employee_clock', $dataArray);
                //echo "C1:".$c1.' Rec ID '.$intRows;
            } 


            $x = '1'; 

            $dataArray = [];
            $dataArray['date'] = $xdate;
            $dataArray['tagedit'] = $x;
            $dataArray['rec_id'] = $intRows;

            $where = [];
            $where['employee_clock_id'] = $c1;

            $this->Comman_model->update('employee_clock', $where, $dataArray);


            $rec_id = 0;

            $dataArray = [];
            $dataArray['hist_id'] = NULL;
            $dataArray['date'] = $prevdate;
            $dataArray['isIn'] = $x;
            $dataArray['employee_clock_id'] = $c1;
            $dataArray['employee_id'] = $emplid;
            $dataArray['patient_id'] = $ptid;
            $dataArray['initial'] = $initial1;
            $dataArray['reason'] = $reason1;
            $dataArray['upload_date'] = $upload_date;
            $dataArray['rec_id'] = $intRows;

            $insert = $this->Comman_model->insert('employee_clock_history', $dataArray);

            $addate = $xdate;
            if ($agency_code == 1 || $agency_code == 3)  {
              $this->dashupd3($addate);
            }                      

            if ($agency_code == 2 || $agency_code == 4)  {      
              $transdate = date("Y-m-d",strtotime($addate));           
              $start_date = date("Y-m-d",strtotime($addate));   
              $this->dashseniorupdate2($transdate, $start_date, $addate);
            }                      

            $data['postcomment'] = "Employee Timesheet + Dashboard updated with Record No.".$c1; 
          } 

          if ($_GET['out'] == 'out')  {
            $outdate =  $_GET['strdate2'].' '.$_GET['hr2'].':'.$_GET['mn2'].':00';
            $xdate = date("Y-m-d H:i:s",strtotime($outdate));
            $c2= $_GET['c2'];
            $previd = $_GET['previd'];
            $intRows = $_GET['rec'];

            $x = '2';
            $reset = 1;
            $prevdate2 = $_GET['prevdate2'];
            $tmpdte = date("Y-m-d",strtotime($outdate));

            $where = [];
            $where['employee_clock_id'] = $c2;
            $row = $this->Comman_model->get_row('employee_clock', $where);

            if ( empty($row)  ||  $c2 == '' ) {


              $tagedit=3;                                                  

              $dataArray              = [];
              $dataArray['tagedit']   = $tagedit;
              $dataArray['reset']     = $reset;
              $dataArray['rec_id']    = $intRows;

              $where = [];
              $where['employee_clock_id'] = $previd;

              $this->Comman_model->update('employee_clock', $where, $dataArray);

              $dataArray = [];
              $dataArray['employee_clock_id'] = NULL;
              $dataArray['employee_id'] = $emplid;
              $dataArray['patient_id'] = $ptid;
              $dataArray['isIn'] = $x;
              $dataArray['tagedit'] = $tagedit;
              $dataArray['date'] = $xdate;
              $dataArray['reset'] = $reset;
              $dataArray['rec_id'] = $intRows;

              $c2 = $this->Comman_model->insert('employee_clock', $dataArray);

            } else {

              $dataArray = [];
              $dataArray['date'] = $xdate;
              $dataArray['tagedit'] = $x;
              $dataArray['rec_id'] = $intRows;
              $dataArray['reset'] = 1;

              $where = [];
              $where['employee_clock_id'] = $c2;

              $this->Comman_model->update('employee_clock', $where, $dataArray);
            }   

            $rec_id = 0;

            $dataArray = [];
            $dataArray['hist_id'] = NULL;
            $dataArray['date'] = $prevdate2;
            $dataArray['isIn'] = $x;
            $dataArray['employee_clock_id'] = $c2;
            $dataArray['rec_id'] = $intRows;
            $dataArray['employee_id'] = $emplid;
            $dataArray['patient_id'] = $ptid;
            $dataArray['reason'] = $reason1;
            $dataArray['upload_date'] = $upload_date;
            $dataArray['initial'] = $initial1;

            $this->Comman_model->insert('employee_clock_history', $dataArray);

            $addate = $xdate;
            if ($agency_code == 1 || $agency_code == 3)  {
                //include("dashupd3.php");
              $this->dashupd3($addate);
            }                      

            if ($agency_code == 2 || $agency_code == 4)  {
              $transdate = $addate;            
              $transdate = date("Y-m-d",strtotime($addate));           
              $start_date = date("Y-m-d",strtotime($addate));          
                //include("dashseniorupdate2.php");
              $this->dashseniorupdate2($transdate, $start_date, $addate);
            }                      
            $data['postcomment'] = "Employee Timesheet + Dashboard updated with Record No.".$c2; 
            
            //include("postlog.php");

            $this->postlog($data['postcomment']);
          } 

          $this->session->set_flashdata('message', $data['postcomment']);
          redirect($this->agent->referrer());

        }



        public function dashcalc($tmpdte,$emplid,$ptid) {
          $ctotal = 0;
          $strSQL = "SELECT * FROM employee_clock WHERE isIn = 1 AND DATE(date) = '$tmpdte' AND employee_id = '$emplid' AND patient_id = '$ptid'  ORDER BY rec_id DESC ";
        //$objExec = mysql_query($strSQL);
        //$objExec2 = mysql_query($strSQL);

          $objExec = $this->Comman_model->getCustomQueryData($strSQL);
        //$objExec2 = mysql_query($strSQL);


          $intRows = 0;
        //$check = mysql_fetch_array($objExec2);

          $check = $this->Comman_model->getCustomQueryData($strSQL, 'row');

          if (!empty($check)) {
            foreach ($objExec as $key => $objResult) {

              $rec_id = $objResult['rec_id'];
              $strSQL2 = "SELECT * FROM employee_clock WHERE isIn = 2 AND DATE(date) = '$tmpdte' AND employee_id = '$emplid' AND patient_id = '$ptid'  AND rec_id = '$rec_id' ";
                //$objExec2 = mysql_query($strSQL2);
                //$objResult2 = mysql_fetch_array($objExec2);

              $objResult2 = $this->Comman_model->getCustomQueryData($strSQL2, 'row');    

              $err = '';
              if ($objResult['tagedit'] == 3) { $err='';   }
              $from_time = strtotime(0);
              $to_time = strtotime(0);
              $hr1 = $hr2 = $mn1 = $mn2 = '00';
              if ($err != '*') {  
                $temp = date('H:i',strtotime($objResult['date']));
                $t = explode(":",$temp );
                $hr1 = $t[0];
                $mn1 = $t[1];
                $fdate = date('Y-m-d',strtotime($objResult['date']));
                $idate = $fdate.' '.$hr1.':'.$mn1.':'.'00';

                $disp1 = $hr1 + ($mn1 / 60);
                $tot1 = quarter($disp1);
                $tot1 = number_format($tot1,2);
                $from_time=$tot1;
              } 
              if (!empty($objResult2)) { 
                $temp = date('H:i',strtotime($objResult2['date']));
                $t = explode(":",$temp );
                $hr2 = $t[0];
                $mn2 = $t[1];
                $fdate = date('Y-m-d',strtotime($objResult2['date']));
                $idate = $fdate.' '.$hr2.':'.$mn2.':'.'00';

                $disp2 = $hr2 + ($mn2 / 60);
                $tot2 = quarter($disp2);
                $tot2 = number_format($tot2,2);
                $to_time=$tot2;

                $to=strtotime($idate);
              } 
              if ( ($hr2 == '00' && $mn2 == '00')  || ($hr1 == '00' && $mn1 == '00') )  {
                $total = 0;
              } else {
                $total = $to_time - $from_time;
              }
              if ($err != '*' && $objResult2 != 0)  {   $ctotal = $ctotal + ($total);  } 
            }
          }
          return $ctotal;
        }


        public function multiple() {
          if(!isset($_SESSION['name'])) {
            redirect();
          }

          $datetrans = $_GET['datetrans'];
          $IsZero =   $_GET['IsZero'];
          $emplid = $_GET['emplid'];
          $ptid = $_GET['ptid'];

          $data               = [];
          $agency_code = $this->session->userdata('agency');

          $year = date("Y",strtotime($datetrans)); 
          $month = date("m",strtotime($datetrans)); 
          $tdate = strtotime($year.'-'.$month.'-01');

          $action = @$_GET['action'];

          if ($action == null ) {
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
              $action = 1;
            } else { 
              $action = 2; 
            }
          }
          if ($action == 1  )  {
            $cutoff = 1;
            $eom = 15;
            $tdate2 = strtotime($year.'-'.$month.'-01');
            $fromdate = date("Y-m-d",$tdate2);
            $tdate2 = strtotime($year.'-'.$month.'-15');
            $todate = date("Y-m-d",$tdate2);        
          } 

          if ($action ==2)   {
            $cutoff = 16;
            $eom = 31;
            $tdate2 = strtotime($year.'-'.$month.'-16');
            $fromdate = date("Y-m-d",$tdate2);
            $todate = date("Y-m-t",$tdate);         
          }

          if ($agency_code == 2 || $agency_code == 4) {
            $thedate = $datetrans;

            $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
            $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');

            if (!empty($chkResult))  {
              $fromdate = $chkResult['start_date'];
              $todate= $chkResult['end_date'];
            }    
          }       



          $shift = 0;
        //$datetrans = $timedate;
          $where = [];
          $where['employee_id'] = $emplid;
          $empResult = $this->Comman_model->get_row('employee', $where);
          $shift = $empResult['shift'];

          $where = [];
          $where['patient_id'] = $ptid;
          $ptResult = $this->Comman_model->get_row('patient', $where);

          $data['heading'] = "  Employee Name:".$emplid.'-'.$empResult['name'].'/Patient:'.$ptid.'-'.$ptResult['name'].' Period '.$action . ' Code: '.$shift. '</br> ';


        ///  ***  //
          $thedate = date('Y-m-d',strtotime($datetrans)); 
          $month  = date('m',strtotime($datetrans));
          $year  = date('Y',strtotime($datetrans));
          $day  = date('d',strtotime($datetrans));
          $MON = date('M',strtotime($datetrans));
          $msg = '';
          $okaymsgs = 0;

        //echo $datetrans;
          if ($agency_code == 2 || $agency_code == 4 ) {
            $cmpmsgs = "Payroll for service date ( ".$thedate." is locked) please inform payroll support for timesheet changes/update...";
            $TchkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
            //$TchkExec = mysql_query($TchkSQL);
            //check for pair
            //$TchkResult = mysql_fetch_array($TchkExec);

            $TchkResult = $this->Comman_model->getCustomQueryData($TchkSQL, 'row');


            if (!empty($TchkResult))  {
              $start_date = $TchkResult['start_date'];
              $SchkSQL = "SELECT * FROM employee_finalheader WHERE start_date = '$start_date'  AND Agency = '$agency_code' AND payroll = 1";
                //$SchkExec = mysql_query($SchkSQL);
                //$SchkResult = mysql_fetch_array($SchkExec);

              $SchkResult = $this->Comman_model->getCustomQueryData($SchkSQL, 'row');                
              if (!empty($SchkResult) )  {
                $msg = "Payroll Locked!";
                $okaymsgs = 1;
              }      
            }        

          }                       

          if ($agency_code == 1 || $agency_code == 3 ) {

            if ( $action  == 1 )  { $pd = 1; }
            if ( $action  == 2 ) { $pd = 2; }
            $cmpmsgs = "Payroll for month period ( ".$MON." period".$pd." is locked) please inform payroll support for timesheet changes/update...";
            
            $xfindSQL =  "SELECT * FROM employee_finalheader WHERE year = '$year' AND month = '$month' AND Agency = '$agency_code'";
            //$xfindExec = mysql_query($xfindSQL);
            //$xfindResult =  mysql_fetch_array($xfindExec);

            $xfindResult =  $this->Comman_model->getCustomQueryData($xfindSQL, 'row');

            if ($xfindResult['payroll'] == 1 && $action == 1 )  {
              $okaymsgs = 1; 
              $msg = "Payroll Locked";
            }                       
            if ($xfindResult['payroll2'] == 1 && $action  == 2 )  {
              $okaymsgs = 1; 
              $msg = "Payroll Locked";
            }                       

          }


          $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn >= 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' ORDER BY date ";  
        //LIMIT " .$from. ", " .$to . " ";

          if ($IsZero == 3 )  {    
            $MySQL = "SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
            employee_clock.patient_id,
            employee_clock.employee_id,
            employee_clock.date,
            employee_clock.tagedit,
            employee_clock.latitude,
            employee_clock.longitude,
            employee_clock.isIn,
            employee_clock.upload_time,
            employee_clock.employee_clock_id  
            FROM employee_clock           
            WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn >= 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' AND reset IS NULL ORDER BY date ";  
                     //LIMIT " .$from. ", " .$to . " ";
          }

       // echo $MySQL;die;


          if ( empty($_GET["view"]) ) { 
            $data['view'] = "OFF";
          } else{
            if ($_GET["formSubmit"] == "View History") {
              if ($_GET["view"]  == "OFF" ) {
                $data['view'] = "ON"; 
              } else {
                $data['view'] = "OFF";
              }
            } else {
              $data['view'] = $_GET['view']; 
            }    
          }


          $data['fromdate']       =   $fromdate;
          $data['todate']         =   $todate;
          $data['emplid']         =   $emplid;
          $data['ptid']           =   $ptid;
          $data['agency_code']    =   $agency_code;
          $data['datetrans']      =   $datetrans;
          $data['action']         =   $action;
          $data['year']           =   $year;
          $data['month']          =   $month;
          $data['IsZero']         =   $IsZero;
          $data['okaymsgs']       =   $okaymsgs;
          $data['cmpmsgs']        =   $cmpmsgs;



          $data['timesheetData'] = $this->Comman_model->getCustomQueryData($MySQL);

          $this->load->view('common/header.php');
          $this->load->view('common/sidebar.php');
          $this->load->view('timesheet/addtimesheet.php',$data);
          $this->load->view('common/footer.php');
        }



        public function add() {

          $data = [];

          $agency_code = $this->session->userdata('agency');
          $emplid = $_GET['emplid'];
          $ptid = $_GET['ptid'];
          $IsZero = $_GET['IsZero'];
          $datetrans = $_GET['datetrans'];
          $fromdate = $_GET['fromdate'];
          $todate = $_GET['todate'];
          $action = $_GET['action'];
          $okaymsgs = $_GET['okaymsgs'];
          $upload_date = !empty($_GET['upload_date'])?$_GET['upload_date']:'';


          $intRows = 0;
          $okaymsgs2 = 0;
          $stxx = '';
          $strSQL4 = "SELECT * FROM employee_assignment WHERE patient_id = '$ptid' AND employee_id = '$emplid' ";
        //$objExec4 = mysql_query($strSQL4);
        //$objResult4 = mysql_fetch_array($objExec4);

          $objResult4 = $this->Comman_model->getCustomQueryData($strSQL4, 'row');

          $pin = $objResult4['pin'];
          if (substr($pin,0,1) == '+')  {
            $err = 1;  
            $okaymsgs2 = 1;
            $stxx = "disabled='disabled'";
          }   


          if ($okaymsgs2 == 1 )  {
            print'<SCRIPT type="text/javascript">
            alert("WARNING: Please Verify To Supervisor If Assigned Worker is Authorized To Work For This Client...");
            </SCRIPT>';                                

            print'<SCRIPT type="text/javascript">
            alert("WARNING: Please Verify To Supervisor If Assigned Worker is Authorized To Work For This Client...");
            </SCRIPT>';                                
          }


          $where = [];
          $where['employee_id'] = $emplid;
          $empResult = $this->Comman_model->get_row('employee', $where);
          $shift = $empResult['shift'];

          $where = [];
          $where['patient_id'] = $ptid;
          $ptResult = $this->Comman_model->get_row('patient', $where);

          $data['heading'] = "  Employee Name:".$emplid.'-'.$empResult['name'].'/Patient:'.$ptid.'-'.$ptResult['name'].' Period '.$action . ' Code: '.$shift. '</br> ';


          if(!empty($this->input->get('submit'))) {

            $date = $_GET['date'];
            $time1 = $_GET['time1'];
            $time2 = $_GET['time2'];
            $field = $_GET['field'];
            $first = $_GET['first'];


            $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = 1 AND DATE(date) >= '$fromdate' AND DATE(date) <= '$todate'   AND reset IS NOT NULL ORDER BY date ";

            $row = $this->Comman_model->getCustomQueryData($MySQL, 'row'); 
            $rec_id = $row['rec_id'];

            for ($a = 0;$a < count($_GET['date']); $a++ ) {

              $field1 = $field[$a];  

              $hdate1 = $date[$a];   

              $htime1 = $time1[$a];   

              $htime2 = $time2[$a];  

              $c1 = $this->checktime($htime2);
              $b1 = $this->checktime($htime1); 
              $d1 = $this->checkdte($hdate1); 

              $t1 = explode(":",$b1);
              $hhr1[$a]= $t1[0];      
              $mmn1[$a]= $t1[1];      

              $t1 = explode(":",$c1);
              $hhr2[$a]= $t1[0];      
              $mmn2[$a]= $t1[1];      

              $addate = $hdate1;
              $addate = date("Y-m-d",strtotime($addate));

              $addate = $d1;
              $indate =  $addate.' '.$hhr1[$a].':'.$mmn1[$a].':00';
              $indate = date("Y-m-d H:i:s",strtotime($indate));

              $outdate =  $addate.' '.$hhr2[$a].':'.$mmn2[$a].':00';
              $outdate = date("Y-m-d H:i:s",strtotime($outdate));
              if ($okaymsgs == 0  )  {  
                $reason1a = $field1;  
              } else {
                $reason1a = $reason1.$field1;
              }
              $initial1 = $this->session->userdata('name');
              $errstat = "ok"; 
              if ( $d1 == '' || $c1 == '' || $b1 == '' || $reason1a == '' ) {  echo $errstat = "not";die; }

              if ($indate > $outdate) { $errstat = "not"; }

              if ($errstat == "ok") {
                $latitude = '';
                $longitude = '';
                $tagedit = 3;
                $reset = 1;

                $x = 1;

                $dataArray = [];
                $dataArray['employee_clock_id'] = NULL;
                $dataArray['employee_id'] = $emplid;
                $dataArray['patient_id'] = $ptid;
                $dataArray['tagedit'] = $tagedit;
                $dataArray['isIn'] = $x;
                $dataArray['date'] = $indate;
                $dataArray['rec_id'] = $intRows;
                $dataArray['reset'] = $reset;
                $dataArray['latitude'] = $latitude;
                $dataArray['longitude'] = $longitude;

                $r1 = $this->Comman_model->insert('employee_clock', $dataArray);

                $dataArray = [];
                $dataArray['rec_id'] = $r1;

                $where = [];
                $where['employee_clock_id'] = $r1;

                $this->Comman_model->update('employee_clock', $where, $dataArray);

                $data['postcomment'] = "Employee Timesheets + Dashboard added with Record No.".$r1; 
                    //include("postlog.php");
                $this->postlog($data['postcomment']);


                $x = 2;
                $taskcode = 1;

                $dataArray = [];
                $dataArray['employee_clock_id'] = NULL;
                $dataArray['employee_id'] = $emplid;
                $dataArray['patient_id'] = $ptid;
                $dataArray['tagedit'] = $tagedit;
                $dataArray['isIn'] = $x;
                $dataArray['date'] = $outdate;
                $dataArray['rec_id'] = $intRows;
                $dataArray['reset'] = $reset;
                $dataArray['latitude'] = $latitude;
                $dataArray['longitude'] = $longitude;
                $dataArray['ivr_task'] = $taskcode;

                $r2 = $this->Comman_model->insert('employee_clock', $dataArray);

                $dataArray = [];
                $dataArray['rec_id'] = $r1;

                $where = [];
                $where['employee_clock_id'] = $r2;

                $this->Comman_model->update('employee_clock', $where, $dataArray);

                $data['postcomment'] = "Employee Timesheet + Dashboard added with Record No.".$r2; 
                    //include("postlog.php");
                $this->postlog($data['postcomment']);


                $x = 1;

                $dataArray = [];
                $dataArray['hist_id'] = NULL;
                $dataArray['date'] = $indate;
                $dataArray['isIn'] = $x;
                $dataArray['employee_clock_id'] = $r1;
                $dataArray['employee_id'] = $emplid;
                $dataArray['patient_id'] = $ptid;
                $dataArray['initial'] = $initial1;
                $dataArray['reason'] = $reason1a;
                $dataArray['rec_id'] = $intRows;
                $dataArray['upload_date'] = $upload_date;

                $this->Comman_model->insert('employee_clock_history', $dataArray);


                $x = 2;

                $dataArray = [];
                $dataArray['hist_id'] = NULL;
                $dataArray['date']  =   $outdate;
                $dataArray['isIn']  =   $x;
                $dataArray['employee_clock_id']  =   $r2;
                $dataArray['employee_id']  =   $emplid;
                $dataArray['patient_id']  =   $ptid;
                $dataArray['initial']  =   $initial1;
                $dataArray['reason']  =   $reason1a;
                $dataArray['rec_id']  =   $intRows;
                $dataArray['upload_date']  =   $upload_date;

                $this->Comman_model->insert('employee_clock_history', $dataArray);


                if ($agency_code == 1 || $agency_code == 3)  {   
                  $this->dashupd3($addate);
                }                      

                if ($agency_code == 2 || $agency_code == 4)  {
                  $start_date = date("Y-m-d",strtotime($indate)); 
                  $transdate = $addate;            
                        //include("dashseniorupdate2.php");
                  $this->dashseniorupdate2($transdate, $start_date, $addate);
                }                      

              }
            }
          }


          $this->session->set_flashdata('message', $data['postcomment']);
          redirect($this->agent->referrer());

        }

        function checkdte($date1)  {    

          preg_match( '/^[+]?([\d]{0,2})?[\(\.\-\s]?([\d]{2})[\)\.\-\s]*([\d]{2})/', $date1, $matches );
          $date1 = ' '.$matches[1] .'/'. $matches[2] .'/'. $matches[3];    

          list($month,$day,$year) = explode("/",$date1);
          if(@checkdate($month,$day,$year)) {
            $x = $month.'/'.$day.'/'.$year;
            $x = date('Y-m-d',strtotime($x));
            $GLOBALS["MSG"] = "";
            if ($x > date('Y-m-d'))  {
              $error = 1;
              $x = "";  
              $this->session->set_flashdata('error_message', "Invalid Date! (Later date is not accepted...)");
            }
          } else {
            $error = 1;
            $x = "";
          }

        //print_r($data);print_r('vghvgdfhvgdfh');die;
          return $x;
        }

        function checktime($timex) {
          $timex = strtolower($timex);
          if (strlen($timex) < 5 )  {
            $timex = '0'.$timex;
          }

          $time2 = $timex;
          preg_match( '/^[+]?([\d]{0,3})?[\(\.\-\s]?([\d]{2})[\)\.\-\s]*([\d]{2})/', $timex, $matches );
          $timex = '' .$matches[2] . ':' . $matches[3];
        //echo $time1;
          $t = explode(':',$timex);

          $err = 0;
          if ($t[0] > 12 || $t[0] < 1 || $t[1] > 59 || $t[1] < 0 ) {
            echo "";
            $err = 1;
          }

          if (strpos($time2,'p') != false && $err == 0) {
           if ($t[0] != 12 ) { $t[0] =  $t[0] + 12;}
           if ($t[0] >= 24 )  {
            $t[0] = 0;
          }
          $err = 0;
        }

        if (strpos($time2,'a') != false && $err == 0) {
         if ($t[0] == 12 ) { $t[0] =  $t[0] - 12;}
         $err = 0;  
       }


       if ($err == 0) {
        $x = $t[0].':'.$t[1];
      }  
      return $x;
    }


    public function dts() {
      $agency_code = $this->session->userdata('agency');         

      $IsZero = 2;
      if(!empty($_GET['IsZero'])) {
        $IsZero = $_GET['IsZero'];
      } 

      $fromdate = date('Y-m-d');
      if(!empty($_GET['fromdate'])) {
        $fromdate = $_GET['fromdate'];
      }

      $todate2 = date('Y-m-d');
      if(!empty($_GET['todate'])) {
        $todate2 = $_GET['todate'];
      }

      $isIn = '';
      if(!empty($_GET['isIn'])) {
        $isIn = $_GET['isIn'];
      }

      $shift = '';
      if(!empty($_GET['shift'])) {
        $shift = $_GET['shift'];
      }

      $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
      employee_clock.patient_id AS pt_id,
      employee_clock.employee_id,
      employee_clock.date,
      employee_clock.rec_id,
      employee_clock.tagedit,
      employee_clock.latitude,
      employee_clock.longitude,
      employee_clock.employee_clock_id,
      patient.patient_id, 
      patient.name as pt_name,
      patient.phone,
      patient.Agency,
      employee.name as empl_name,
      employee.pin,
      employee.shift

      FROM employee_clock,patient,employee
      WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate2' AND patient.Agency = '$agency_code' AND reset IS NOT NULL  ORDER BY employee_clock_id ASC ";


      if ($IsZero == 1 )  {
        $MySQL = "
        SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
        employee_clock.patient_id AS pt_id,
        employee_clock.employee_id,
        employee_clock.date,
        employee_clock.tagedit,
        employee_clock.latitude,
        employee_clock.longitude,
        employee_clock.isIn,
        employee_clock.employee_clock_id,
        patient.patient_id, 
        patient.name as pt_name,
        patient.phone,
        patient.Agency,
        employee.name as empl_name,
        employee.pin,
        employee.shift

        FROM employee_clock,patient,employee
        WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn >=  1  AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate2' AND patient.Agency = '$agency_code' AND reset IS NULL ORDER BY employee_clock_id ASC ";
      }

      if ($IsZero == "" )  {
        $MySQL = "
        SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
        employee_clock.patient_id AS pt_id,
        employee_clock.employee_id,
        employee_clock.date,
        employee_clock.tagedit,
        employee_clock.latitude,
        employee_clock.longitude,
        employee_clock.isIn,
        employee_clock.employee_clock_id,
        patient.patient_id, 
        patient.name as pt_name,
        patient.phone,
        patient.Agency,
        employee.name as empl_name,
        employee.pin,
        employee.shift

        FROM employee_clock,patient,employee
        WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND (isIn =  1 OR  (isIn = 2 AND reset IS  NULL) ) AND DATE(date) >= '$fromdate' AND DATE(date) <= '$todate2' AND patient.Agency = '$agency_code' ORDER BY employee_clock_id ASC LIMIT ";
      } 

      $dtsData = $this->Comman_model->getCustomQueryData($MySQL);

        //print_r($dtsData);die;

      foreach ($dtsData as $key => $row) {

        $emplid = $row['employee_id'];
        $ptid = $row['patient_id'];

        $t2 = 0;   
        if ($shift == 1  )  {
          $rec_t = $row['rec_id'];
          $tempdate = $row['date'];
          $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND DATE(date) > '$tempdate' AND  isIn = 2 AND rec_id = '$rec_t' ORDER by employee_clock_id desc";
          $shiftcode = $this->Comman_model->getCustomQueryData($query, 'row');
          if ( !empty($shiftcode) ) {    
            $t2 = 1;
          }     
        }  

        $hr1 = '00';
        $hr2 = '00';
        $mn1 = '00';
        $mn2 = '00';
        $tot1 = 0;
        $tot2 = 0;
        $rec = $row['employee_clock_id'];
        $sl = "disabled='disabled'";
        if ($IsZero != 1  || $isIn == 1 ) {
          $temp = '';
          $c1 = $row['employee_clock_id'];
          $temp = date('H:i',strtotime($row['date']));
          $pairdate = date('Y-m-d',strtotime($row['date']));
          $t = explode(":",$temp );
          $hrr1 = $t[0];
          $mnn1 = $t[1];

          $actual1 = $hrr1.':'.$mnn1; 
          $disp1 = $hrr1 + ($mnn1 / 60);
          $tot1 = quarter($disp1);
                //echo $tot1;
          $disp1 = quarter2($disp1);
          $disp1 = number_format($disp1,2);

          $tot1 = number_format($tot1,2);

          $t = explode(".",$disp1 );
          $hr1 = $t[0];
          $mn1 = $t[1];

          $rec_id = $row['rec_id'];
          $fdate = date('Y-m-d',strtotime($row['date']));
          $timedate = date('Y-m-d',strtotime($row['date']));
          $idate = $fdate.' '.$hrr1.':'.$mnn1.':'.'00';
          $from_time=strtotime($idate);

        } else {

          $hr1 = '00';
          $mn1 = '00';
          $pairdate = date('Y-m-d',strtotime($row['date']));
          $c1 = $row['employee_clock_id'];

        }
        $scolor = '';
        if ($row['tagedit'] != null ) { $scolor = "red"; }

            /*$query = mysql_query("SELECT * FROM employee_clock_history WHERE employee_clock_id = '$c1' ORDER BY hist_id desc ")  or die (mysql_error());
            $orig = mysql_fetch_array($query);*/

            $where = [];
            $where['employee_clock_id'] = $c1;
            $orig = $this->Comman_model->get_row('employee_clock_history', $where);

            $timein = '';
            if ($orig != 0) { $timein =  date('H:i',strtotime($orig['date'])); }

            $miss = 0;
            if ($isIn != 2)  {
              $timeIn = $hr1.':'.$mn1;
            }  else { 
              if ($IsZero == '' )  {
                $rec_t = $row['rec_id'];
                $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND  isIn = 1 AND rec_id = '$rec_t' ORDER by employee_clock_id desc";
                    //$shiftcode = mysql_fetch_array($query);

                $shiftcode = $this->Comman_model->getCustomQueryData($query, 'row');

                if ( !empty($shiftcode) ) {     
                  $timeIn = date("H : i",strtotime($shiftcode['date']));
                }  
                $thr2 = $hr1; $tmn2 = $mn1; $miss = 1; $trec = $row['employee_clock_id'];

              }
            } 

            if ($IsZero != 1 || $isIn == 1) {
              $x = '2';
              if ($shift == 1 )  {
                $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND  
                isIn = '$x' AND rec_id = '$rec_id' ORDER by employee_clock_id desc";
              } else {
                $query = "SELECT * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND  
                DATE(date) = '$pairdate' AND  isIn = '$x' AND rec_id = '$rec_id'  ORDER by employee_clock_id desc";
              }  

                //$rowdate = mysql_fetch_array($query);
              $rowdate = $this->Comman_model->getCustomQueryData($query, 'row');
              if ($miss == 0 ) {
                $trec = $rowdate['employee_clock_id'];
              }
            } else {
              $x = '2';
              $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$rec'  ORDER by employee_clock_id desc";
               // $rowdate = mysql_fetch_array($query);
              $rowdate = $this->Comman_model->getCustomQueryData($query, 'row');
            }
            $to_time=strtotime($rowdate['date']);
            $transdate=date('Y-m-d',strtotime($rowdate['date']));
            $total = number_format((($to_time - $from_time) / 60) / 60,2);

            $temp = '';
            $c2 = null;
            if ($rowdate != 0 )  {$temp = date('H:i',strtotime($rowdate['date'])); $c2 = $rowdate['employee_clock_id']; }

            $t = explode(":",$temp );
            //print_r($t);die;
            $hrr2 = @$t[0];
            $mnn2 = @$t[1];
            $actual2 = $hrr2.':'.$mnn2; 
            $disp2 = $hrr2 + ($mnn2 / 60);
            $tot2 = quarter($disp2);
            $disp2 = quarter2($disp2);
            $disp2 = number_format($disp2,2);
            $tot2 = number_format($tot2,2);

            $t = explode(".",$disp2 );
            $hr2 = $t[0];
            $mn2 = $t[1];

            if ($miss == 1)  {
              $hr2 = $thr2;
              $mn2 = $tmn2;     
            } 

            $fdate = date('Y-m-d',strtotime($rowdate['date']));
            $idate = $fdate.' '.$hrr2.':'.$mnn2.':'.'00';
            $to_time=strtotime($idate);
            if ( ($hrr2 == '00' && $mnn2 == '00')  || ($hrr1 == '00' && $mnn1 == '00') )  {
              $total = 0;
              $total2 = 0;
            } else {
              $total = number_format((($to_time - $from_time) / 60) / 60,2);
              $total2 =  $tot2 - $tot1;
            }

            $query = "SELECT * FROM employee_clock_history WHERE employee_clock_id = '$c2' ORDER BY hist_id desc";
            //$orig = mysql_fetch_array($query);

            $orig = $this->Comman_model->getCustomQueryData($query, 'row');
            $timeout = '';      
            if ($orig != 0) { $timeout =  date('H:i',strtotime($orig['date'])); }
            $scolor = '';
            if ($rowdate['tagedit'] != null ) { $scolor = "red"; }
            $timeOut = $hr2.':'.$mn2;  //echo $hr2;: //echo $mn2;

            $hours = '';
            if ($from_time != null && $to_time != null ) {
              if ($IsZero !=  1 && $t2 == 0 ) {
                $hours = abs($total2);
              }        
            }  
            

            $dtsData[$key]['column1'] = date('m/d/Y', strtotime($row['date']));
            $dtsData[$key]['column2'] = $timeIn;
            $dtsData[$key]['column3'] = $hr2.':'.$mn2;
            $dtsData[$key]['column4'] = $hours;
            $dtsData[$key]['column5'] = $row['empl_name'];
            $dtsData[$key]['column6'] = $row['employee_id'];
            $dtsData[$key]['column7'] = $row['latitude'];
            $dtsData[$key]['column8'] = $row['longitude'];

          }    


          $data = [];
          $data['fromdate'] = $fromdate;
          $data['todate'] = $todate2;
          $data['IsZero'] = $IsZero;
          $data['dtsData'] = $dtsData;

          $where = [];
          $where['agency_code'] = $agency_code;
          $data['agencyData'] = $this->Comman_model->get_row('agency', $where);

          $this->load->view('common/header.php');
          $this->load->view('common/sidebar.php');
          $this->load->view('timesheet/dts.php',$data);
          $this->load->view('common/footer.php');

        }


        public function delete() {

          $timein = $_GET['timein'];
          $timeout = $_GET['timeout'];
          $agency_code = $this->session->userdata('agency');

          $where = [];
          $where['employee_clock_id'] = $timein;
          $objResult = $this->Comman_model->get_row('employee_clock', $where);

          $id = $objResult['employee_id'];

          $where = [];
          $where['employee_id'] = $id;
          $objResult = $this->Comman_model->get_row('employee', $where);        


          $name = $objResult['name'];

          $timein = $_GET['timein'];
          $timeout = $_GET['timeout'];

          $where = [];
          $where['employee_clock_id'] = $timein;
          $objResult = $this->Comman_model->get_row('employee_clock', $where);

          $addate = date("Y-m-d",strtotime($objResult['date']));
          $emplid = $objResult['employee_id'];
          $ptid = $objResult['patient_id']; 
          $empl = $objResult['employee_id'] + 100000;

          $where = [];
          $where['employee_clock_id'] = $timein;

          $dataArray = [];
          $dataArray['employee_id'] = $empl;

          $this->Comman_model->update('employee_clock', $where, $dataArray);

          $where = [];
          $where['employee_clock_id'] = $timeout;

          $dataArray = [];
          $dataArray['employee_id'] = $empl;

          $this->Comman_model->update('employee_clock', $where, $dataArray);

          if ($agency_code == 1 || $agency_code == 3)  {
            //include("dashupd3.php");
            $this->dashupd3($addate);
          }                      

          if ($agency_code == 2 || $agency_code == 4)  {
            $transdate = $addate;            
            $start_date = date("Y-m-d",strtotime($addate)); 
            //include("dashseniorupdate2.php");
            $this->dashseniorupdate2($transdate, $start_date, $addate);
          }                      

          $postcomment = "Employee Timesheet + Dashboard deleted with Record No.".$timein; 
        //include("postlog.php");
          $this->postlog($postcomment);
          $postcomment = "Employee Timesheet + Dashboard deleted with Record No.".$timeout; 
        //include("postlog.php");
          $this->postlog($postcomment);

          $this->session->set_flashdata('message', $postcomment);
          redirect($this->agent->referrer());
        }

        public function deleteMultipleTimesheet() {

          $deleteId = $_POST['deleteId'];
          $deleteId = explode('|', $deleteId);

        //print_r($deleteId);die;

          $timein = $deleteId[0];
          $timeout = $deleteId[1];

          $agency_code = $this->session->userdata('agency');

          $where = [];
          $where['employee_clock_id'] = $timein;
          $objResult = $this->Comman_model->get_row('employee_clock', $where);

          $id = $objResult['employee_id'];

          $where = [];
          $where['employee_id'] = $id;
          $objResult = $this->Comman_model->get_row('employee', $where);        


          $name = $objResult['name'];

          $where = [];
          $where['employee_clock_id'] = $timein;
          $objResult = $this->Comman_model->get_row('employee_clock', $where);

          $addate = date("Y-m-d",strtotime($objResult['date']));
          $emplid = $objResult['employee_id'];
          $ptid = $objResult['patient_id']; 
          $empl = $objResult['employee_id'] + 100000;

          $where = [];
          $where['employee_clock_id'] = $timein;

          $dataArray = [];
          $dataArray['employee_id'] = $empl;

          $this->Comman_model->update('employee_clock', $where, $dataArray);

          $where = [];
          $where['employee_clock_id'] = $timeout;

          $dataArray = [];
          $dataArray['employee_id'] = $empl;

          $this->Comman_model->update('employee_clock', $where, $dataArray);

          if ($agency_code == 1 || $agency_code == 3)  {
            //include("dashupd3.php");
            $this->dashupd3($addate, $emplid, $ptid);
          }                      

          if ($agency_code == 2 || $agency_code == 4)  {
            $transdate = $addate;            
            $start_date = date("Y-m-d",strtotime($addate)); 
            //include("dashseniorupdate2.php");
            $this->dashseniorupdate2($transdate, $start_date, $addate, $emplid, $ptid);
          }                      

          $postcomment = "Employee Timesheet + Dashboard deleted with Record No.".$timein; 
        //include("postlog.php");
          $this->postlog($postcomment);
          $postcomment = "Employee Timesheet + Dashboard deleted with Record No.".$timeout; 
        //include("postlog.php");
          $this->postlog($postcomment);

          echo '1';
        }

        public function singleprint() {


          if(!isset($_SESSION['name'])) {
            redirect();
          }

          $datetrans = $_GET['datetrans'];
          $IsZero =   $_GET['IsZero'];
          $emplid = $_GET['emplid'];
          $ptid = $_GET['ptid'];

          $data               = [];
          $agency_code = $this->session->userdata('agency');

          $year = date("Y",strtotime($datetrans)); 
          $month = date("m",strtotime($datetrans)); 
          $tdate = strtotime($year.'-'.$month.'-01');

          $action = @$_GET['action'];

          if ($action == null ) {
            $day = date("d",strtotime($datetrans));
            if ($day >= 1 && $day <= 15) {
              $action = 1;
            } else { 
              $action = 2; 
            }
          }
          if ($action == 1  )  {
            $cutoff = 1;
            $eom = 15;
            $tdate2 = strtotime($year.'-'.$month.'-01');
            $fromdate = date("Y-m-d",$tdate2);
            $tdate2 = strtotime($year.'-'.$month.'-15');
            $todate = date("Y-m-d",$tdate2);        
          } 

          if ($action ==2)   {
            $cutoff = 16;
            $eom = 31;
            $tdate2 = strtotime($year.'-'.$month.'-16');
            $fromdate = date("Y-m-d",$tdate2);
            $todate = date("Y-m-t",$tdate);         
          }

          if ($agency_code == 2 || $agency_code == 4) {
            $thedate = $datetrans;

            $chkSQL = "SELECT * FROM table_2weekly WHERE  end_date >= '$thedate' AND start_date  <= '$thedate'";
            $chkResult = $this->Comman_model->getCustomQueryData($chkSQL, 'row');

            if (!empty($chkResult))  {
              $fromdate = $chkResult['start_date'];
              $todate= $chkResult['end_date'];
            }    
          }       



          $shift = 0;
          $where = [];
          $where['employee_id'] = $emplid;
          $empResult = $this->Comman_model->get_row('employee', $where);
          $shift = $empResult['shift'];

          $where = [];
          $where['patient_id'] = $ptid;
          $ptResult = $this->Comman_model->get_row('patient', $where);

        //$data['heading'] = "  Employee Name:".$emplid.'-'.$empResult['name'].'/Patient:'.$ptid.'-'.$ptResult['name'].' Period '.$action . ' Code: '.$shift. '</br> ';


          $thedate = date('Y-m-d',strtotime($datetrans)); 
          $month  = date('m',strtotime($datetrans));
          $year  = date('Y',strtotime($datetrans));
          $day  = date('d',strtotime($datetrans));
          $MON = date('M',strtotime($datetrans));
          $msg = '';
          $cmpmsgs='';
          $okaymsgs = 0;

          if ($agency_code == 2 || $agency_code == 4 ) {
            $cmpmsgs = "Payroll for service date ( ".$thedate." is locked) please inform payroll support for timesheet changes/update...";
            $TchkSQL = "SELECT * FROM table_2weekly WHERE end_date >= '$thedate' AND start_date  <= '$thedate'";

            $TchkResult = $this->Comman_model->getCustomQueryData($TchkSQL, 'row');


            if (!empty($TchkResult))  {
              $start_date = $TchkResult['start_date'];
              $SchkSQL = "SELECT * FROM employee_finalheader WHERE start_date = '$start_date'  AND Agency = '$agency_code' AND payroll = 1";

              $SchkResult = $this->Comman_model->getCustomQueryData($SchkSQL, 'row');                
              if (!empty($SchkResult) )  {
                $msg = "Payroll Locked!";
                $okaymsgs = 1;
              }      
            }        

          }                       

          if ($agency_code == 1 || $agency_code == 3 )  {
            $data['comment'] = date("M",strtotime($fromdate)).'-'.date("Y",strtotime($fromdate)).' Period:'.$action.'</br>  ';
          } else {
            $data['comment'] = date("m/d/Y",strtotime($fromdate)).'-'.date("m/d/Y",strtotime($todate)).' '.'</br>  ';
            
          }


          $taskSQL = "SELECT * FROM employee_clock WHERE (employee_id = '$emplid' AND patient_id = '$ptid') AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate'  " ;
        //$taskExec = mysql_query($taskSQL);

          $taskExec = $this->Comman_model->getCustomQueryData($taskSQL);

          $ovrsign = '';
          foreach ($taskExec as $key => $taskResult) {

            $t = explode('.',$taskResult['signfilename']);
            //print_r($t);die;
            if (!empty($t[1]) && $t[1] == 'png')  {
              $ovrsign = $taskResult['signfilename'];
            }
            
            //echo $taskResult['tasks'];
            if($taskResult['latitude'] != '' ) {
              if ($taskResult['tasks'] != '' ) {
                $ovrtask = $taskResult['tasks'];
              } 
            } else {
              if ($taskResult['ivr_task'] != '' ) {
                $ovrtask = $taskResult['ivr_task'];
              }                         
            }
          } 


          $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM employee_clock WHERE employee_id = '$emplid' AND patient_id = '$ptid' AND isIn = 1 AND DATE(date) >= '$fromdate'  AND DATE(date) <= '$todate' AND reset IS NOT NULL ORDER BY date"; 

          if ( empty($_GET["view"]) ) { 
            $data['view'] = "OFF";
          } else{
            if ($_GET["view"]  == "OFF" ) {
              $data['view'] = "ON"; 
            } else {
              $data['view'] = "OFF";
            }
          }


          $where = [];
          $where['agency_code'] = $agency_code;
          $data['agencyData'] = $this->Comman_model->get_row('agency', $where);


          $data['fromdate']       =   $fromdate;
          $data['todate']         =   $todate;
          $data['emplid']         =   $emplid;
          $data['ptid']           =   $ptid;
          $data['agency_code']    =   $agency_code;
          $data['datetrans']      =   $datetrans;
          $data['action']         =   $action;
          $data['year']           =   $year;
          $data['month']          =   $month;
          $data['IsZero']         =   $IsZero;
          $data['okaymsgs']       =   $okaymsgs;
          $data['cmpmsgs']        =   $cmpmsgs;
          $data['ovrsign']        =   $ovrsign;
          $data['empResult']      =   $empResult;
          $data['ptResult']       =   $ptResult;


          $data['timesheetData'] = $this->Comman_model->getCustomQueryData($MySQL);

          $this->load->view('common/header.php');
          $this->load->view('common/sidebar.php');
          $this->load->view('timesheet/single-print.php',$data);
          $this->load->view('common/footer.php');
        }


        public function timesheet4() {
          if(isset($_SESSION['name'])) {

            $tmpdte = date('Y-m-d'); 

            if(!empty($_GET['fromDate'])) {
              $tmpdte = date( 'Y-m-d', strtotime($_GET['fromDate']));     
              $this->session->set_userdata('date', $_GET['fromDate']);
            } else {
              if(!empty($this->session->userdata('date'))) {
                $datetrans = $this->session->userdata('date');
                $tmpdte = date( 'Y-m-d', strtotime($datetrans));     
              }
            }

            $search = @$_GET['search'];

            $agency_code = $this->session->userdata('agency');
            $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
            employee_clock.patient_id AS pt_id,
            employee_clock.employee_id,
            employee_clock.date,
            employee_clock.rec_id,
            employee_clock.tagedit,
            employee_clock.latitude,
            employee_clock.longitude,
            employee_clock.macAddress,
            employee_clock.employee_clock_id,
            patient.patient_id, 
            patient.name as pt_name,
            patient.phone,
            patient.longitude as log,
            patient.latitude as lat,
            patient.macAddress as mac,
            patient.Agency,
            employee.name as empl_name,
            employee.pin

            FROM employee_clock,patient,employee
            WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id  AND isIn = 1 AND DATE(date) = '$tmpdte' AND  substr(employee.name,1,char_length('$search'))  = '$search' AND patient.Agency = '$agency_code' AND  (employee_clock.latitude != '' OR employee_clock.longitude != '' OR employee_clock.macAddress != '' )  )";  
                     //ORDER BY ".$sortorder." ".$desc.", employee_clock_id ASC    LIMIT " .$from. ", " .$to . " ";

            //echo $MySQL;die;

            $data = [];
            $data['datetrans'] = $tmpdte;
            $data['search'] = $search;
            $data['timesheet4Data'] = $this->Comman_model->getCustomQueryData($MySQL);

            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('timesheet/timesheet4',$data);
            $this->load->view('common/footer.php');
          } else {
            redirect();
          }
        }


        public function mismatchSubmit() {
        //print_r($_REQUEST);die;

          $xr1 = $_GET['xr1'];
          $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$xr1' ";
        //$Vrow = mysql_fetch_array($query);   
          $Vrow = $this->Comman_model->getCustomQueryData($query, 'row');

          $Vemplid = $Vrow['employee_id']; 
          $Vptid = $Vrow['patient_id']; 
          $Vtagedit = $Vrow['tagedit']; 
          $Vindate = $Vrow['date']; 
          $VintRows = $Vrow['rec_id']; 
          $Vreset = $Vrow['reset']; 
          $Vlatitude = $Vrow['latitude']; 
          $Vlongitude = $Vrow['longitude']; 
          $Vupload_time = $Vrow['upload_time']; 
          $Vtasks = $Vrow['tasks']; 
          $Vvnotes= $Vrow['vnotes']; 

          $Vx = 1;
       /* $insert = mysql_query("INSERT INTO  employee_clock_pin_mismatched (
                    employee_clock_id,
                    employee_id,
                    patient_id,
                    tagedit,
                    isIn,
                    date,
                    rec_id,
                    reset,
                    latitude,
                    longitude,
                    upload_time,
                    tasks,
                    vnotes
                    ) VALUES (
                    NULL,
                    '$Vemplid',
                    '$Vptid',
                    '$Vtagedit',
                    '$Vx', 
                    '$Vindate',
                    '$VintRows',
                    '$Vreset',
                    '$Vlatitude',
                    '$Vlongitude',
                    '$Vupload_time',
                    '$Vtasks',
                    '$Vvnotes'
                  ) ") or die (mysql_error());   */


                  $dataArray = [];
                  $dataArray['employee_clock_id'] =  NULL;
                  $dataArray['employee_id']=$Vemplid;
                  $dataArray['patient_id']=$Vptid;
                  $dataArray['tagedit']=$Vtagedit;
                  $dataArray['isIn']=$Vx;
                  $dataArray['date']=$Vindate;                                                                     
                  $dataArray['rec_id']=$VintRows;
                  $dataArray['reset']=$Vreset;
                  $dataArray['latitude']=$Vlatitude;
                  $dataArray['longitude']=$Vlongitude;
                  $dataArray['upload_time']=$Vupload_time;
                  $dataArray['tasks']=$Vtasks;
                  $dataArray['vnotes']=$Vvnotes;
                  $this->Comman_model->insert('employee_clock_pin_mismatched', $dataArray);


                  $xr2 = $_GET['xr2'];
                  $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$xr2' ";
        //$Vrow = mysql_fetch_array($query);    
                  $Vrow = $this->Comman_model->getCustomQueryData($query, 'row');

                  $Vemplid = $Vrow['employee_id']; 
                  $Vptid = $Vrow['patient_id']; 
                  $Vtagedit = $Vrow['tagedit']; 
                  $Vindate = $Vrow['date']; 
                  $VintRows = $Vrow['rec_id']; 
                  $Vreset = $Vrow['reset']; 
                  $Vlatitude = $Vrow['latitude']; 
                  $Vlongitude = $Vrow['longitude']; 
                  $Vupload_time = $Vrow['upload_time']; 
                  $Vtasks = $Vrow['tasks']; 
                  $Vvnotes= $Vrow['vnotes']; 

                  $Vx = 2;
        /*$insert = mysql_query("INSERT INTO  employee_clock_pin_mismatched    (
        employee_clock_id,
        employee_id,
        patient_id,
        tagedit,
        isIn,
        date,
        rec_id,
        reset,
        latitude,
        longitude,
        upload_time,
        tasks,
        vnotes
        ) VALUES (
        NULL,
        '$Vemplid',
        '$Vptid',
        '$Vtagedit',
        '$Vx', 
        '$Vindate',
        '$VintRows',
        '$Vreset',
        '$Vlatitude',
        '$Vlongitude',
        '$Vupload_time',
        '$Vtasks',
        '$Vvnotes'
      ) ") or die (mysql_error());  */

      $dataArray = [];
      $dataArray['employee_clock_id'] =  NULL;
      $dataArray['employee_id']=$Vemplid;
      $dataArray['patient_id']=$Vptid;
      $dataArray['tagedit']=$Vtagedit;
      $dataArray['isIn']=$Vx;
      $dataArray['date']=$Vindate;                                                                     
      $dataArray['rec_id']=$VintRows;
      $dataArray['reset']=$Vreset;
      $dataArray['latitude']=$Vlatitude;
      $dataArray['longitude']=$Vlongitude;
      $dataArray['upload_time']=$Vupload_time;
      $dataArray['tasks']=$Vtasks;
      $dataArray['vnotes']=$Vvnotes;

      $this->Comman_model->insert('employee_clock_pin_mismatched', $dataArray);

      $where = [];
      $where['employee_clock_id'] = $xr1;
      $this->Comman_model->delete_row('employee_clock', $where);

      $where = [];
      $where['employee_clock_id'] = $xr2;        
      $this->Comman_model->delete_row('employee_clock', $where);

        //$this->session->set_flashdata('message', $postcomment);
      redirect($this->agent->referrer());

    }


    public function emplcal() {
      if(isset($_SESSION['name'])) {

        $emplid = $_GET['emplid'];
        $ptid = $_GET['ptid'];
        $datetrans = $_GET['datetrans'];
        $datefrom = @$_GET['datefrom'];
        $dateto = @$_GET['dateto'];


        if(empty($datefrom)) {
          $element_4_1 = date("m", strtotime("0 month") ) ;
          $d = date("d",time());
          if ( $d < 16 ) { 
            $element_4_2 = date("1", strtotime("0 month") ); 
          } else {
            $element_4_2 = date("16", strtotime("0 month") );
          }  
          $m_year = date("Y", strtotime("0 month") ) ; 

          $date1 = $m_year.'-'.$element_4_1.'-'.$element_4_2;
          $datefrom = strtotime($date1);
          $datefrom = date( 'm/d/Y', $datefrom);
        }

        if(empty($dateto)) {
          $element_5_1 = date("m", strtotime("0 month") ) ;
          $d  = date("d",time());
          if ( $d < 16 ) {
            $element_5_2 = date("15", strtotime("0 month") ) ;
          } else {
            $element_5_2 = date("t", strtotime("0 month") ) ; 
          }
          $m_year2 = date("Y", strtotime("0 month") ) ; 
          $date2 = $m_year2.'-'.$element_5_1.'-'.$element_5_2;
          $dateto = strtotime($date2);
          $dateto = date( 'm/d/Y', $dateto);
        }



        $search = @$_GET['search'];

        $agency_code = $this->session->userdata('agency');
        $datefrom  =  date("Y-m-d",strtotime($datefrom));
        $dateto  =  date("Y-m-d",strtotime($dateto));


        if (!empty($_GET['in']) && $_GET['in'] == 'in')  {
          $indate =  $_GET['strdate'].' '.$_GET['hr1'].':'.$_GET['mn1'].':00';
          $xdate = date("Y-m-d H:i:s",strtotime($indate));
          $c1= $_GET['c1'];
          $x = '1';
          $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$c1' ";
                //$row = mysql_fetch_array($query);   
          $row = $this->Comman_model->getCustomQueryData($query, 'row');   

          if (empty($row)) {
            $dataArray = [];
            $dataArray['employee_clock_id'] = NULL;
            $dataArray['employee_id'] = $emplid;
            $dataArray['patient_id'] = $ptid;
            $dataArray['isIn'] = $x;
            $dataArray['date'] = $xdate;

            $insert = $this->Comman_model->insert('employee_clock', $dataArray);

          } else {
                    //$query = mysql_query("UPDATE employee_clock SET date='$xdate' WHERE employee_clock_id = '$c1' " ) or die (mysql_error()); 

            $where = [];
            $where['employee_clock_id'] = $c1;

            $dataArray = [];
            $dataArray['date'] = $xdate; 
            $this->Comman_model->update('employee_clock', $where, $dataArray);     
          }           

        } 

        if (!empty($_GET['out']) && $_GET['out'] == 'out')  {
          $outdate =  $_GET['strdate'].' '.$_GET['hr2'].':'.$_GET['mn2'].':00';
          $xdate = date("Y-m-d H:i:s",strtotime($outdate));
          $c2= $_GET['c2'];
          $x = '2';
          $query = "SELECT * FROM employee_clock WHERE employee_clock_id = '$c2' ";
                //$row = mysql_fetch_array($query);  
          $row = $this->Comman_model->getCustomQueryData($query, 'row');   
          if (empty($row)) {
                    /*$insert = mysql_query("INSERT INTO  employee_clock    (
                                  employee_clock_id,
                                  employee_id,
                                  patient_id,
                                  isIn,
                                  date
                                  ) VALUES (
                                    NULL,
                                   '$emplid',
                                   '$ptid',
                                   '$x', 
                                   '$xdate'
                                 ) ") or die (mysql_error()); */

                                 $dataArray = [];
                                 $dataArray['employee_clock_id'] = NULL;
                                 $dataArray['employee_id'] = $emplid;
                                 $dataArray['patient_id'] = $ptid;
                                 $dataArray['isIn'] = $x;
                                 $dataArray['date'] = $xdate;

                                 $insert = $this->Comman_model->insert('employee_clock', $dataArray);

                               } else {
                                /*$query = mysql_query("UPDATE  employee_clock SET date='$xdate' WHERE employee_clock_id = '$c2' " ) or die (mysql_error());      */

                                $where = [];
                                $where['employee_clock_id'] = $c2;

                                $dataArray = [];
                                $dataArray['date'] = $xdate; 
                                $this->Comman_model->update('employee_clock', $where, $dataArray); 
                              }   
                            } 



                            $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM calendar where date >= '$datefrom'   AND date <= '$dateto'";  
                    //LIMIT " .$from. ", " .$to . " ";

            //echo $MySQL;die;
                            $data = [];
                            $where = [];
                            $where['patient_id'] = $ptid;
                            $data['ptResult'] = $this->Comman_model->get_row('patient', $where);

                            $where = [];
                            $where['employee_id'] = $emplid;
                            $data['empResult'] = $this->Comman_model->get_row('employee', $where);


                            $data['datetrans'] = $datetrans;
                            $data['search'] = $search;
                            $data['datefrom'] = $datefrom;
                            $data['dateto'] = $dateto;
                            $data['emplid'] = $emplid;
                            $data['ptid'] = $ptid;
                            $data['emplcalData'] = $this->Comman_model->getCustomQueryData($MySQL);

                            $this->load->view('common/header.php');
                            $this->load->view('common/sidebar.php');
                            $this->load->view('timesheet/emplcalview',$data);
                            $this->load->view('common/footer.php');
                          } else {
                            redirect();
                          }
                        }

                        public function mispunch(){
                          if(isset($_SESSION['name'])) {

                            $tmpdte = date('Y-m-d'); 
                            if(!empty($_GET['fromDate'])) {
                              $tmpdte = date( 'Y-m-d', strtotime($_GET['fromDate']));     
                              $this->session->set_userdata('date', $_GET['fromDate']);
                            } else {
                              if(!empty($this->session->userdata('date'))) {
                                $datetrans = $this->session->userdata('date');
                                $tmpdte = date( 'Y-m-d', strtotime($datetrans));     
                              }
                            }

                            $IsZero = @$_GET['IsZero'];
                            $IsZero = 1;
                            $search = @$_GET['search'];
                            $suplid = @$_GET['suplid'];
                            $suplid = "ALL";
                            if (!empty($_GET['suplid'])) {
                             $suplid = $_GET['suplid'];
                           }

                           $agency_code = $this->session->userdata('agency');

                           if ($suplid == 'ALL')  {
                            $cond = " AND employee.supervisor_id = supervisor.supervisor_id  ";
                            $cond2 ="";
                          } else {
                            $cond = "  AND supervisor.supervisor_id = '$suplid' ";
                            $cond2 = " (employee.supervisor_id = supervisor.supervisor_id OR employee.supervisor_id2 = supervisor.supervisor_id OR employee.supervisor_id3 = supervisor.supervisor_id  ) AND patient.supervisor_id = supervisor.supervisor_id and ";
                          }

                          $MySQL = "
                          SELECT SQL_CALC_FOUND_ROWS DISTINCT(rec_id),
                          employee_clock.patient_id AS pt_id,
                          employee_clock.employee_id,
                          employee_clock.date,
                          employee_clock.tagedit,
                          employee_clock.latitude,
                          employee_clock.longitude,
                          employee_clock.isIn,
                          employee_clock.employee_clock_id,
                          employee.supervisor_id,
                          patient.patient_id, 
                          patient.name as pt_name,
                          patient.phone,
                          patient.Agency,
                          employee.name as empl_name,
                          employee.pin,
                          supervisor.lastname as supl_lastname,
                          supervisor.firstname as supl_firstname,
                          supervisor.name as supl_name
                          FROM employee_clock,patient,employee,supervisor

                          WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id ) AND isIn >=  1  AND DATE(date) = '$tmpdte' AND ".$cond2." (patient.name LIKE '%".$search."%' OR employee.name LIKE '%".$search."%' ) ".$cond." AND patient.Agency = '$agency_code' AND reset IS NULL GROUP BY patient_id ORDER BY employee_clock_id ASC ";
            //AND (TIME(date) = '00:00:00' OR rec_id IS NULL )

            //echo $MySQL;        

                          $_SESSION["TSQL"] = $MySQL."000000";

                          $data = [];

                          $data['datetrans'] = $tmpdte;
                          $data['suplid'] =   $suplid;
                          $data['IsZero'] = $IsZero;
                          $data['search'] = $search;
                          $data['mispunchData'] = $this->Comman_model->getCustomQueryData($MySQL);
                          $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');

                          $this->load->view('common/header.php');
                          $this->load->view('common/sidebar.php');
                          $this->load->view('timesheet/mispunch-view',$data);
                          $this->load->view('common/footer.php');
                        } else {
                          redirect();
                        }       
                      }

                      public function logs() {
                        if(isset($_SESSION['name'])) {

                          $tmpdte = date('Y-m-d'); 
                          if(!empty($_GET['fromDate'])) {
                            $tmpdte = date( 'Y-m-d', strtotime($_GET['fromDate']));     
                            $this->session->set_userdata('date', $_GET['fromDate']);
                          } else {
                            if(!empty($this->session->userdata('date'))) {
                              $datetrans = $this->session->userdata('date');
                              $tmpdte = date( 'Y-m-d', strtotime($datetrans));     
                            }
                          }

                          $search = @$_GET['search'];

                          $mismatched = "B";
                          if (!empty($_GET['mismatched']))  {
                            $mismatched = $_GET['mismatched'];  
                          }

                          $agency_code = $this->session->userdata('agency');

                          $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                          employee_clock.patient_id AS pt_id,
                          employee_clock.employee_id,
                          employee_clock.date,
                          employee_clock.rec_id,
                          employee_clock.tagedit,
                          employee_clock.latitude,
                          employee_clock.isIn,
                          employee_clock.longitude,
                          employee_clock.macAddress,
                          employee_clock.employee_clock_id,
                          patient.patient_id, 
                          patient.name as pt_name,
                          patient.phone,
                          patient.Agency,
                          employee.name as empl_name,
                          employee.pin
                          FROM employee_clock,patient,employee
                          WHERE (patient.patient_id = employee_clock.patient_id AND employee_clock.employee_id = employee.employee_id )  AND patient.Agency = '$agency_code' ORDER BY employee_clock_id ASC limit 500"; 
                // ORDER BY ".$sortorder." ".$desc.", employee_clock_id ASC LIMIT " .$from. ", " .$to . " ";
            //AND (TIME(date) = '00:00:00' OR rec_id IS NULL )

            //echo $MySQL;        

                          $_SESSION["TSQL"] = $MySQL."000000";

                          $data = [];

                          $data['datetrans'] = $tmpdte;
                          $data['search'] = $search;
                          $data['mispunchData'] = $this->Comman_model->getCustomQueryData($MySQL);
                          $data['supervisorData'] = $this->Comman_model->get_rows('supervisor');


                          $CountSQL = "SELECT * FROM employee WHERE employee.name LIKE '%".$search."%' ";
                          $result2 = $this->Comman_model->getCustomQueryData($CountSQL);

                          if (empty($result2) )  { 
                            $MySQL = "SELECT  SQL_CALC_FOUND_ROWS * FROM pin_log  WHERE ( pin_log.pin LIKE '%".$search."%' ) limit 500"; 
                          } else {
                            $MySQL = "SELECT  SQL_CALC_FOUND_ROWS * FROM pin_log,employee WHERE pin_log.pin = employee.pin  AND employee.name LIKE '%".$search."%' limit 500"; 
                          }

                          $data['pinlogData'] = $this->Comman_model->getCustomQueryData($MySQL);

                          $this->load->view('common/header.php');
                          $this->load->view('common/sidebar.php');
                          $this->load->view('timesheet/log-view',$data);
                          $this->load->view('common/footer.php');
                        } else {
                          redirect();
                        } 
                      }

                    } 