<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
defined('BASEPATH') OR exit('No direct script access allowed');
class Vmr extends CI_Controller {
    
    public function __construct() {        

        require_once APPPATH . "/third_party/FCMPushNotification.php";
        parent::__construct();
        $this->load->database();
        $this->load->library('session');
        $this->load->library('google');
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        //$this->load->library('excel');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->model('Comman_model');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        /**** load phpmailer library for send mail ****/ 
        $this->load->library('phpmailer_lib');
        if(isset($_SESSION['googleUser'])) {
            $userId = $this->session->userdata('id');
            $this->headerData['mailMsgs'] = $this->google->listMessages($userId);
        } else {
            $this->headerData=[];
        }

        //$this->load->library('PHPReport');
        //$this->load->helper('download');
        //$this->load->model('Excel_export_model');
        // $this->load->model('excel_import_model');
        // patientReportexcel
    }

    function calculateDistance($origin, $destination) {
        //$origin = $_POST['origin'];
        //$destination = $_POST['destination'];
        if(!empty($origin) && !empty($destination)) {
            
            $ch = curl_init();
            $url = "https://maps.googleapis.com/maps/api/distancematrix/json";
            $options = array(
                "origins" => $origin,
                "destinations" => $destination,
                "units" => "imperial",
                "language" => "en-GB",
                "key" => 'AIzaSyB3iE3D6Mksh20jN9n1lYT9Aawul-q97m0'
            );

            $request = $url . "?" . http_build_query( $options );
            
            curl_setopt($ch, CURLOPT_URL, $request);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $output = json_decode(curl_exec($ch));

            curl_close($ch);

            $status = $output->status;

            $cdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->value:0;
            $sdistance = ($status=="OK")?$output->rows[0]->elements[0]->distance->text:0;

            $sdistance = number_format(round(($cdistance/1609.34), 1), 2);
            return $sdistance;

            //$sdistance = $sdistance.' Miles';
            //print_r($sdistance);
            //$distance = $this->getDistance($origin, $destination, '');
            //print_r($distance);
        } else {
            return 0;
        }
    }

    function index() {

        $data = [];

        $patientId = $_GET['patient'];
        if(!empty($patientId)) {
            $sql = "SELECT lastname, firstname, agency_location, supervisor_id, Agency, ShipAddressAddr2, ShipAddressCity, ShipAddressState, ShipAddressPostalCode FROM patient WHERE patient_id = '$patientId'";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');
            $aglocation = $row['agency_location'];
            $agency_code = $row['Agency'];
            $supervisor_id = $row['supervisor_id'];
            $data['ptname'] = $row['lastname'].', '.$row['firstname'];

            $ptAddress = "";
            if(!empty($row['ShipAddressAddr2'])) {
                $ptAddress = $row['ShipAddressAddr2'];  
            }
            if(!empty($row['ShipAddressCity'])) {
                $ptAddress .= ', '.$row['ShipAddressCity'];  
            }
            if(!empty($row['ShipAddressState'])) {
                $ptAddress .= ', '.$row['ShipAddressState'];  
            }
            if(!empty($row['ShipAddressPostalCode'])) {
                $ptAddress .= ', '.$row['ShipAddressPostalCode'];  
            }

            $data['ptAddress'] = $ptAddress;

            $query = "SELECT * FROM agency WHERE agency_code = '".$row['Agency']."'";
            $agencyRow = $this->Comman_model->getCustomQueryData($query, 'row');

            $sql = "SELECT * FROM agency_location WHERE agency_location_code = '$aglocation'";
            $agencyLocationRow = $this->Comman_model->getCustomQueryData($sql, 'row');
            $data['agency_location_name'] = $agencyLocationRow['agency_location_name'];

            $sql = "SELECT name FROM supervisor WHERE supervisor_id = '$supervisor_id'";
            $row = $this->Comman_model->getCustomQueryData($sql, 'row');
            $data['supervisor_name'] = $row['name'];

            if(!empty($_POST['submit']) && $_POST['submit']=='Submit') {
                $this->form_validation->set_rules('vmrsup', 'Supervisor Name', 'required');
                $this->form_validation->set_rules('vmrbranch', 'Branch Name', 'required');
                $this->form_validation->set_rules('vmrclient', 'Client Name', 'required');
                $this->form_validation->set_rules('vmrsaddress', 'Starting Address', 'required');
                $this->form_validation->set_rules('vmrdaddress', 'Destination Address', 'required');
                $this->form_validation->set_rules('vmrdate', 'Date', 'required');
                $this->form_validation->set_rules('vmrreason', 'Reason For Visit', 'required');

                if ($this->form_validation->run() != false) {

                    $vmrsaddress = $this->input->post('vmrsaddress');
                    $vmrdaddress = $this->input->post('vmrdaddress');

                    $dataArray = [];
                    $dataArray['supervisor_name'] = $this->input->post('vmrsup');
                    $dataArray['patient_name'] = $this->input->post('vmrclient');
                    $dataArray['agency_id'] = $agency_code;
                    $dataArray['agency_name']        = $agencyRow['agency_codename'];
                    $dataArray['agency_location_id'] = $aglocation;
                    $dataArray['agency_location_name'] = $this->input->post('vmrbranch');
                    $dataArray['patient_id'] = $patientId;
                    $dataArray['starting_address'] = $this->input->post('vmrsaddress');
                    $dataArray['destination_address'] = $this->input->post('vmrdaddress');
                    $vmrdate = $this->input->post('vmrdate');
                    $dataArray['request_date'] = date('Y-m-d', strtotime($vmrdate));
                    $dataArray['reason'] = $this->input->post('vmrreason');
                    $dataArray['request_type'] = '2';
                    
                    $dataArray['ls_id']  = $agencyLocationRow['lead_supervisor'];
                    $dataArray['ls_id2'] = $agencyLocationRow['lead_supervisor2'];
                    $dataArray['ls_id3'] = $agencyLocationRow['lead_supervisor3'];
                    $dataArray['ls_id4'] = $agencyLocationRow['lead_supervisor4'];
                    $dataArray['ls_id5'] = $agencyLocationRow['lead_supervisor5'];

                    $dataArray['distance'] = $this->calculateDistance($vmrsaddress, $vmrdaddress);

                    $inserId = $this->Comman_model->insert( "visitation_mileage", $dataArray );

                    if($inserId) {
                        /************* Send mail to Lead Supervisor Start *************/
                        $this->sendVisitationMileageMailToLeadSupervisor($inserId, 'Pending');
                        /************* Send mail to Lead Supervisor End *************/

                        //print_r($dataArray);die;

                        ############### USER ACTION TRACKING START ####################
                        if($this->session->userdata('id')!=6) {
                            $dataArray = [];
                            $dataArray['user_id'] = $this->session->userdata('id');
                            $dataArray['username'] = $this->session->userdata('name');
                            $dataArray['user_action'] = $this->session->userdata('name'). ' user add employee visitation mileage reimbursement to employee id '.$_GET['employee'].' at '. date('m/d/Y H:i:s');
                            $this->Comman_model->insert('users_tracking', $dataArray);    
                        }
                        ############### USER ACTION TRACKING END ####################
                        $this->session->set_flashdata('message', 'visitation mileage request has been added successfully.');
                    } else {
                        $this->session->set_flashdata('error_message', 'Oops! something went wrong try again.');
                    }
                    redirect('vmr?patient='.$patientId);
                }
            }

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php');
            $this->load->view('tools/vmr-view.php',$data);
            $this->load->view('common/footer.php');        
            */

            $this->load->view('common/header-new.php');
            $this->load->view('common/sidebar-new.php');
            $this->load->view('tools/vmr-view-new.php',$data);
        } else {
            redirect($this->agent->referrer());
        }
    }

    function sendVisitationMileageMailToLeadSupervisor($recId, $status) {

        $query = "SELECT * FROM visitation_mileage WHERE id = '$recId'";
        $row = $this->Comman_model->getCustomQueryData($query, 'row');

        $requestType = "Visitation Mileage Reimbursement";

        $query = "SELECT * FROM employee WHERE employee_id = '".$row['employee_id']."'";
        $empRow = $this->Comman_model->getCustomQueryData($query, 'row');

        $query = "SELECT * FROM patient WHERE patient_id = '".$row['patient_id']."'";
        $ptRow = $this->Comman_model->getCustomQueryData($query, 'row');

        $query = "SELECT * FROM supervisor WHERE supervisor_id = '".$ptRow['supervisor_id']."'";
        $supRow = $this->Comman_model->getCustomQueryData($query, 'row');
        $supEmail = $supRow['email'];

        $query = "SELECT * FROM supervisor WHERE supervisor_id = '".$row['ls_id']."'";
        $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
        $lsupEmail = $lsupRow['email'];        

        $to3 = "demo@hcpcaregivers.com";
        $subject = "Visitation Mileage Reimbursement / ".$row['patient_name'];

        $message = "
        <table width=100%>
        <table border=1 cellpadding=10>
        <tr><th>Agency</th><td>".$row['agency_name']."</td></tr>
        <tr><th>Client Name</th><td>".$row['patient_name']."</td></tr>
        <tr><th>Branch</th><td>".$row['agency_location_name']."</td></tr>
        <tr><th>Starting Address</th><td>".$row['starting_address']."</td></tr>
        <tr><th>Destination Address</th><td>".$row['destination_address']."</td></tr>
        <tr><th>Request Date</th><td>".$row['request_date']."</td></tr>
        <tr><th>Reason</th><td>".$row['reason']."</td></tr>
        <tr><th>Status</th><td>".$status."</td></tr>
        <tr><th>Request Type</th><td>".$requestType."</td></tr>
        </table>";
        $message .= "</table>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: <demo@hcpcaregivers.com>' . "\r\n";

        $this->sendPHPMailerMail($to3,$subject,$message,$headers);

        /************** Mail Send To Requested Supervisor Start *****************/
        if(!empty($row['requested_by'])) {
            /*$where  =   [];
            $where['user_id']   =   $row['requested_by'];
            $reqRow = $this->Comman_model->get_row('users_portal', $where);            
            $reqEmail = trim($reqRow['email']);
            mail($reqEmail,$subject,$message,$headers);*/
        }
        /************** Mail Send To Requested Supervisor End *****************/

        /************** Mail Send To Lead Supervisors (LS) Start *****************/  
        if(!empty($row['ls_id'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id']."'";
            $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail = trim($lsupRow['email']);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id2'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id2']."'";
            $lsupRow2 = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail2 = trim($lsupRow2['email']);
            $this->sendPHPMailerMail($lsupEmail2,$subject,$message,$headers);
        }
        if(!empty($row['ls_id3'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id3']."'";
            $lsupRow3 = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail3 = trim($lsupRow3['email']);
            $this->sendPHPMailerMail($lsupEmail3,$subject,$message,$headers);
        }
        if(!empty($row['ls_id4'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id4']."'";
            $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail = trim($lsupRow['email']);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        if(!empty($row['ls_id5'])) {
            $query = "SELECT * FROM users_portal WHERE user_id = '".$row['ls_id5']."'";
            $lsupRow = $this->Comman_model->getCustomQueryData($query, 'row');
            $lsupEmail = trim($lsupRow['email']);
            $this->sendPHPMailerMail($lsupEmail,$subject,$message,$headers);
        }
        /************** Mail Send To Lead Supervisors (LS) End *****************/
    }

    function sendPHPMailerMail($to, $subject, $message, $headers) {
        if(!empty($to)) {
            $mail = $this->phpmailer_lib->load();

            $mail->IsSMTP(); // set mailer to use SMTP
            $mail->Host        = "smtp.office365.com";  // specify main and backup server
            $mail->SMTPAuth    = true;     // turn on SMTP authentication
            $mail->SMTPDebug   = 0; 
            $mail->SMTPSecure  = "STARTTLS";
            $mail->Port        = 587;
            $mail->Username    = "rdsrm@hcpfinancial.onmicrosoft.com";  // SMTP username
            $mail->Password    = "Onedrive5301!"; // SMTP password
            //$mail->CharSet     = 'UTF-8';
            $mail->SMTPAuth    = true;
            $mail->From        = "rdsrm@hcpfinancial.onmicrosoft.com";
            $mail->FromName    = "HCP Support";
            $mail->AddAddress($to);   // name is optional
            $mail->IsHTML(true);                                  // set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $message;
            if(!$mail->Send()) {
                return false;
            }   
        }
        return true;
    }

    function VMRAll() {
        $this->load->view('common/header.php');
        $this->load->view('common/sidebar.php');
        $this->load->view('tools/vmrall-view.php',$data);
        $this->load->view('common/footer-view.php');        
    }

    function getVMRTypeResult() {
        $vmrtype = $_POST['vmrtype'];
        $agency  = $this->session->userdata('agency');
        if(!empty($vmrtype)) {
            if($vmrtype==1) {
                $data = '<option disabled="" selected>Choose Supervisor</option>';
                $where = [];
                $where['su.firstname!='] ='';
                $where['su.Agency'] = $agency;
                $supervisorData = $this->Comman_model->getAssignedSupervisor($where, 'lastname', 'asc');
                if(!empty($supervisorData)) {
                    foreach ($supervisorData as $key => $row) {
                        $id = base64_encode($row['supervisor_id']);
                        $data .= '<option value="'.$id.'">'.$row['name'].'</option>';
                    }
                }
                print_r($data);
            }

            if($vmrtype==2) {
                $data = '<option disabled="" selected>Choose Floaters</option>';
                $sql = "SELECT firstname, lastname, employee_id FROM employee WHERE Agency = '$agency'";
                $res = $this->Comman_model->getCustomQueryData($sql);
                if(!empty($res)) {
                    foreach ($res as $key => $row) {
                        $name = $row['lastname'].', '.$row['firstname'];
                        $id = base64_encode($row['employee_id']);
                        $data .= '<option value="'.$id.'">'.$name.'</option>';
                    }
                }
                print_r($data);
            }
        }
    }

    function getVMRTypeBranch() {
        $vmrsupfloater = $_POST['vmrsupfloater'];
        $vmrtype = $_POST['vmrtype'];
        $response = '';
        if(!empty($vmrtype) && !empty($vmrsupfloater)) {
            if($vmrtype==1) {
                $sid = base64_decode($vmrsupfloater);
                $sql = "SELECT agency_location FROM supervisor WHERE supervisor_id = '$sid'";
                $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                $aglocation = $row['agency_location'];

                $sql = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '$aglocation'";
                $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                $response = $row['agency_location_name'];
            }

            if($vmrtype==2) {
                $empid = base64_decode($vmrsupfloater);
                $sql = "SELECT agency_location FROM employee WHERE employee_id = '$empid'";
                $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                $aglocation = $row['agency_location'];

                $sql = "SELECT agency_location_name FROM agency_location WHERE agency_location_code = '$aglocation'";
                $row = $this->Comman_model->getCustomQueryData($sql, 'row');
                $response = $row['agency_location_name'];
            }
        }
        print_r(trim($response));
    }

    function getVMRTypeClients() {
        $vmrtype = $_POST['vmrtype'];
        $vmrsupfloater = $_POST['vmrsupfloater'];
        $agency  = $this->session->userdata('agency');
        if(!empty($vmrtype) && !empty($vmrsupfloater)) {
            if($vmrtype==1) {
                $data = '<option disabled="" selected>Choose Clients</option>';
                $sid = base64_decode($vmrsupfloater);
                $sql = "SELECT lastname, firstname, patient_id FROM patient WHERE supervisor_id = '$sid'";
                $patientData = $this->Comman_model->getCustomQueryData($sql);
                if(!empty($patientData)) {
                    foreach ($patientData as $key => $row) {
                        $name = $row['lastname'].', '.$row['firstname'];
                        $id = base64_encode($row['patient_id']);
                        $data .= '<option value="'.$id.'">'.$name.'</option>';
                    }
                }
                print_r($data);
            }

            if($vmrtype==2) {
                $data = '<option disabled="" selected>Choose Clients</option>';
                $sql = "SELECT firstname, lastname, patient_id FROM patient WHERE patient_id = '$agency'";
                $res = $this->Comman_model->getCustomQueryData($sql);
                if(!empty($res)) {
                    foreach ($res as $key => $row) {
                        $name = $row['lastname'].', '.$row['firstname'];
                        $id = base64_encode($row['patient_id']);
                        $data .= '<option value="'.$id.'">'.$name.'</option>';
                    }
                }
                print_r($data);
            }
        }
    }
}