<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Zipcode extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('new_helper');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->model('Comman_model','comman');
        $this->load->model('Api_model');
        $this->load->model('Client_model', 'client');
        $this->load->library('user_agent');
    }

    
    public function index() {
        if (isset($_SESSION['name'])) { 
            $data['page']  = 'Zipcode PSA';
            $data['zipcodeData'] = $this->comman->get_rows('zipcode_psa','','zipcode_psa_id','desc');

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('zipcode/view.php', $data);
            $this->load->view('common/footer-view.php');
            */

            $this->load->view('common/header-new');
            $this->load->view('common/sidebar-new', $data);
            $this->load->view('zipcode/view-new', $data);
        } else {
            redirect($this->agent->referrer());
        }
    }  

    public function add() {
        if (isset($_SESSION['name'])) { 

            if( !empty( $this->input->post( 'submit' ) ) ){
                $this->form_validation->set_rules('zipcode', 'zipcode', 'trim|required|is_unique[zipcode_psa.zipcode]');
                $this->form_validation->set_rules('psa', 'psa', 'trim|required');

                $this->form_validation->set_message('is_unique', 'Zipcode already exists. Please enter new one.');


                if ($this->form_validation->run() != false) {

                    $dataArray             = [];
                    $dataArray['zipcode']  = $this->input->post('zipcode',true);
                    $dataArray['psa']      = $this->input->post('psa',true);
                    $inserId = $this->comman->insert( "zipcode_psa", $dataArray );

                    if($inserId) {
                        $this->app->message('Zipcode has been added successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('zipcode','refresh');
                }
            }

            $data['page'] = 'Add Zipcode';

            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('zipcode/add.php', $data);
            $this->load->view('common/footer-view.php');
            */

            $this->load->view('common/header-new');
            $this->load->view('common/sidebar-new', $data);
            $this->load->view('zipcode/add-new', $data);
        } else {
            redirect($this->agent->referrer());
        }
    }


    function zipcode_check() {
        $zipcode = $this->input->post('zipcode',true);
        $pageId = $this->uri->segment('3');
        $pageId = decode64($pageId);

        $sql = "SELECT * FROM zipcode_psa WHERE zipcode='".$zipcode."' AND zipcode_psa_id!='".$pageId."'";
        $row = $this->comman->getCustomQueryData($sql, 'row');

        if (!empty($row)) {
            $this->form_validation->set_message('zipcode_check', 'Zipcode already exists. Please enter new one.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function edit($pageId='') {

        if (isset($_SESSION['name'])) { 

            if(!empty($pageId)) {
                $pageId = decode64($pageId);
                $data['pageId']    =   $pageId;    
                $where  = [];
                $where['zipcode_psa_id'] = $pageId;
                $pageData   =   $this->comman->get_row('zipcode_psa',$where);
                $data['pageData']  =   $pageData;
            }

            if( !empty( $this->input->post( 'update' ) ) ) {

                $this->form_validation->set_rules('zipcode', 'zipcode', 'trim|required|callback_zipcode_check');
                $this->form_validation->set_rules('psa', 'psa', 'trim|required');                

                if ($this->form_validation->run() != false) {

                    $dataArray             =    [];
                    $dataArray['zipcode']  =    $this->input->post('zipcode',true);
                    $dataArray['psa']      =    $this->input->post('psa',true);

                    $where  = [];
                    $where['zipcode_psa_id'] = $pageId;

                    $updateId = $this->comman->update( "zipcode_psa", $where, $dataArray );

                    if($updateId) {
                        $this->app->message('Zipcode has been updated successfully.', 'success');
                    } else {
                        $this->app->message('Oops! something went wrong try again.', 'error');                  
                    }
                    redirect('zipcode','refresh');
                }
            }

            $data['page'] = 'Update zipcode';
            /*
            $this->load->view('common/header.php');
            $this->load->view('common/sidebar.php', $data);
            $this->load->view('zipcode/edit.php', $data);
            $this->load->view('common/footer-view.php');
            */

            $this->load->view('common/header-new');
            $this->load->view('common/sidebar-new', $data);
            $this->load->view('zipcode/edit-new', $data);
        } else {
            redirect('');
        }
    }  

        

    public function delete($recordId){
        if(!empty($recordId)) {
            $recordId = decode64($recordId);
            $where = [];
            $where['zipcode_psa_id'] = $recordId;
            $check = $this->comman->delete_row('zipcode_psa',$where);
            $this->app->message('Zipcode has been deleted successfully.', 'success');
        } else {
            $this->app->message('Oops! something went wrong try again.', 'error');
        }
        redirect($this->agent->referrer());
    }

} 