<?php 
require_once('Google/vendor/autoload.php');

class Google {
	protected $CI;
	// protected $headers;
	public function __construct(){
		$this->CI =& get_instance();
        $this->CI->load->library('session');
        $this->CI->config->load('config');
        $this->CI->config->load('google');
        $this->client = new Google_Client();
		$this->client->setClientId($this->CI->config->item('google_client_id'));
		$this->client->setClientSecret($this->CI->config->item('google_client_secret'));
		$this->client->setRedirectUri($this->CI->config->item('google_redirect_url'));
		$this->client->setScopes(
			array(
				Google_Service_Gmail::GMAIL_COMPOSE,
				Google_Service_Gmail::GMAIL_SEND,
				Google_Service_Gmail::GMAIL_MODIFY,
				Google_Service_Calendar::CALENDAR,
				Google_Service_Tasks::TASKS,
			)
		);
		$this->client->addScope("email");
		$this->client->addScope("profile");
		$this->client->setAccessType('offline');
		$this->client->setApprovalPrompt('force');
	}

	public function get_login_url(){
		return  $this->client->createAuthUrl();

	}

	public function getAuthenticate(){		
		$service = new Google_Service_Oauth2($this->client);
		if (isset($_GET['code'])) {
		  $this->client->authenticate($_GET['code']);
		  $_SESSION['access_token'] = $this->client->getAccessToken();

		}
		if (isset($_SESSION['access_token']) && $_SESSION['access_token']) {
		  $userProfile = $service->userinfo->get();
		  $this->client->setAccessToken($_SESSION['access_token']);
		  // $userData['oauth_provider'] = 'google';
		  $userData['googleUserId'] = $userProfile['id'];
		  $userData['name'] = $userProfile['given_name'].' '.$userProfile['family_name'];
		  $userData['email'] = $userProfile['email'];
		  // $userData['gender'] = $userProfile['gender'];
		  // $userData['locale'] = $userProfile['locale'];
		  // $userData['profile_url'] = $userProfile['link'];
		  $userData['image_url'] = $userProfile['picture'];
		   return  $userData;
		}
	}
	public function getHeader($headers, $name) {
		foreach($headers as $header) {
			if($header['name'] == $name) {
				return $header['value'];
			}
		}
	}
	public function listMessages($userId) {
		if(!empty($_SESSION['access_token']) && !empty($userId))
		{
			$this->client->setAccessToken($_SESSION['access_token']);
			if ($this->client->isAccessTokenExpired()) {
				$this->client->fetchAccessTokenWithRefreshToken($this->client->getRefreshToken());
				$_SESSION['access_token'] = $this->client->getAccessToken();
			}
			$service = new Google_Service_Gmail($this->client);
			$pageToken = NULL;
			$messages = array();
			$optParams = array();
			$optParams['maxResults'] = 5; 
			$optParams['labelIds'] = 'INBOX'; 
			$messages = $service->users_messages->listUsersMessages('me',$optParams);
			$lists = $messages->getMessages();
			$i=0;
			foreach ($lists as $key => $list) {
				$messageId = $list->getId();
				$optParamsGet = [];
				$optParamsGet['format'] = 'full';
				$message = $service->users_messages->get('me',$messageId,$optParamsGet);
				$headers = $message->getPayload()->getHeaders();
				$bodyMessage = $message->getSnippet();
				$mailMsg[$i] = 
				[
					'subject' => $this->getHeader($headers, 'Subject'),
					'date'=>strtotime($this->getHeader($headers, 'Date')),
					'name'=>$this->getHeader($headers, 'From'),
				];
				$i++;
			}
			return $mailMsg;
		}
	}
	public function inboxEmails($userId,$labelIds='INBOX',$NextPageToken='') {
		if(!empty($_SESSION['access_token']) && !empty($userId))
		{
			$this->client->setAccessToken($_SESSION['access_token']);
			if ($this->client->isAccessTokenExpired()) {
				$this->client->fetchAccessTokenWithRefreshToken($this->client->getRefreshToken());
				$_SESSION['access_token'] = $this->client->getAccessToken();
			}
			$service = new Google_Service_Gmail($this->client);
			$pageToken = NULL;
			$messages = array();
			$optParams = array();
			$optParams['maxResults'] = 15; 
			$optParams['labelIds'] = $labelIds;
			if(!empty($NextPageToken))
				$optParams['pageToken'] = $NextPageToken;
			$messages = $service->users_messages->listUsersMessages('me',$optParams);
			$pageToken = $messages->getNextPageToken();
			$lists = $messages->getMessages();
			$i=0;
			$mailMsg = [];
			foreach ($lists as $key => $list) {
				$messageId = $list->getId();
				$optParamsGet = [];
				$optParamsGet['format'] = 'full';
				$message = $service->users_messages->get('me',$messageId,$optParamsGet);
				$headers = $message->getPayload()->getHeaders();
				$bodyMessage = $message->getSnippet();
				$mailMsg[$i] = 
				[
					'subject' => $this->getHeader($headers, 'Subject'),
					'date'=>strtotime($this->getHeader($headers, 'Date')),
					'name'=>$this->getHeader($headers, 'From'),
					'messageId'=>$messageId,
				];
				$mailMsg['pageToken']=$pageToken;
				$i++;
			}
			return $mailMsg;
		}
	}
	public function inboxDetails($userId,$messageId) {
		if(!empty($_SESSION['access_token']) && !empty($userId))
		{
			$this->client->setAccessToken($_SESSION['access_token']);
			if ($this->client->isAccessTokenExpired()) {
				$this->client->fetchAccessTokenWithRefreshToken($this->client->getRefreshToken());
				$_SESSION['access_token'] = $this->client->getAccessToken();
			}
			$service = new Google_Service_Gmail($this->client);
			$optParamsGet = [];
			$optParamsGet['format'] = 'full';
			$message = $service->users_messages->get('me',$messageId,$optParamsGet);
			$threadId = $message->getThreadId();
			$headers = $message->getPayload()->getHeaders();

			$message_parts = $message->getPayload()->getParts();
			$body = $message_parts[1]['body'];
			$rawData = $body->data;
			$sanitizedData = strtr($rawData,'-_', '+/');
			$decodedMessage = base64_decode($sanitizedData);

			$payloadMessage = $message->getPayload();
			/* From email */
			$authEmailResult = $this->getHeader($headers,'Authentication-Results');
			$strFromEmailSub = substr($authEmailResult,strpos($authEmailResult,'smtp.mailfrom'));
			$strFromEmail=str_replace('smtp.mailfrom=','',substr($strFromEmailSub,0,strpos($strFromEmailSub,';')));
            $files = array();
            $attachId = @$message_parts[1]['body']['attachmentId'];
            if(!empty($attachId))
            {
            	$attach = $service->users_messages_attachments->get($userId, $messageId, $attachId);
            	foreach ($message_parts as $key => $value) {
            		if ( isset($value->body->attachmentId) && !isset($value->body->data)) {
            			array_push($files, $value['partId']);
            		}
            	}
            	$decodedMessage = '';
				$body = $message_parts[0]['parts'][1]->body;
				$rawData = $body->data;
				$sanitizedData = strtr($rawData,'-_', '+/');
				$decodedMessage .= base64_decode($sanitizedData);
            }
			$mailMsg = 
			[
				'subject' => $this->getHeader($headers, 'Subject'),
				'date'=>strtotime($this->getHeader($headers, 'Date')),
				'name'=>$this->getHeader($headers, 'From'),
				'fromEmail'=>$strFromEmail,
				'messageId'=>$messageId,
				'files'=>$files,
				'message'=>$decodedMessage,
				'threadId'=>$threadId,
			];
			return $mailMsg;
		}
	}
	public function fetchAttachment($messageId, $partId)
	{
		$attachment = $this->getAttachFromApi($messageId, $partId);
        $content_type = "";
        foreach ($attachment['data']['headers'] as $key => $value) {
            if($value->name == 'Content-Type'){ $content_type = $value->value; }
            header($value->name.':'.$value->value);
        }
        $content_type_val = current(explode("/",$content_type));
        $media_types = ["video", "image", "application"];
        if(in_array($content_type_val, $media_types )){
            echo $this->decodeBase64($attachment['data']['data'], $content_type); // Only for Image files
        } 
        else {
          echo $this->decodeBase64($attachment['data']['data']); // Other than Image Files
        }
        return $imgStr;
	}
	public function getAttachFromApi($messageId, $partId)
    {
        try {
            $gmail = new Google_Service_Gmail($this->client);
            $message = $gmail->users_messages->get('me', $messageId);
            $message_payload_details = $message->getPayload()->getParts();
            $attachmentDetails = array();
            $attachmentDetails['attachmentId'] = $message_payload_details[$partId]['body']['attachmentId'];
            $attachmentDetails['headers'] = $message_payload_details[$partId]['headers'];
            $attachment = $gmail->users_messages_attachments->get('me', $messageId, $attachmentDetails['attachmentId']);
            $attachmentDetails['data'] = $attachment->data;
            return ['status' => true, 'data' => $attachmentDetails];
        } catch (\Google_Service_Exception $e) {
            return ['status' => false, 'message' => $e->getMessage()];
        }
    }
    public function decodeBase64($base64_string, $content_type) {
        $find = ["_","-"]; $replace = ["/","+"];
        $base64_string = str_replace($find,$replace,$base64_string);
        $url_str = 'data:'.$content_type.','.$base64_string;
        $base64_string = "url(".$url_str.")";
        $data = explode(',', $base64_string);
        return base64_decode( $data[ 1 ] );
    }
    public function sendMail($to_email,$strSubject,$msg,$messageId='',$filePath='')
    {
    	$service= new Google_Service_Gmail($this->client);
    	$strRawMessage = '';
    	$strRawMessage .= "To: <$to_email>\r\n";
    	$strRawMessage .= 'Subject: =?utf-8?B?' . base64_encode($strSubject) . "?=\r\n";
    	$strRawMessage .= "MIME-Version: 1.0\r\n";
    	$strRawMessage .= "Content-Type: text/html; charset=utf-8\r\n";
    	$strRawMessage .= 'Content-Transfer-Encoding: quoted-printable' . "\r\n\r\n";
    	$strRawMessage .= "$msg \r\n";
    	$mime = rtrim(strtr(base64_encode($strRawMessage), '+/', '-_'), '=');
    	$msg = new Google_Service_Gmail_Message();
    	$msg->setRaw($mime);
    	if (!empty($messageId)) {
    		$message = $service->users_messages->get('me', $messageId);
    		$threadId = $message->getThreadId();
    		$msg->setThreadId($threadId);
    	}
    	/*if($filePath!=""){
    		$array = explode('/', $filePath);
    		$finfo = finfo_open(FILEINFO_MIME_TYPE); 
    		$mimeType = finfo_file($finfo, $filePath);
    		$fileName = $array[sizeof($array)-1];
    		$fileData = base64_encode(file_get_contents($filePath));

    		$strRawMessage .= "\r\n--{$boundary}\r\n";
    		$strRawMessage .= 'Content-Type: '. $mimeType .'; name="'. $fileName .'";' . "\r\n";            
    		$strRawMessage .= 'Content-ID: <' . $sentMailData->email. '>' . "\r\n";            
    		$strRawMessage .= 'Content-Description: ' . $fileName . ';' . "\r\n";
    		$strRawMessage .= 'Content-Disposition: attachment; filename="' . $fileName . '"; size=' . filesize($filePath). ';' . "\r\n";
    		$strRawMessage .= 'Content-Transfer-Encoding: base64' . "\r\n\r\n";
    		$strRawMessage .= chunk_split(base64_encode(file_get_contents($filePath)), 76, "\n") . "\r\n";
    		$strRawMessage .= "--{$boundary}\r\n";
    	}*/
    	try {
    		$message = $service->users_messages->send('me', $msg);
    		print 'Message with ID: ' . $message->getId() . ' sent.';
    		return $message;
    	} catch (Exception $e) {
    		print 'An error occurred: ' . $e->getMessage();
    	}
    }

    public function getCalendarEvent($start,$end)
    {
    	$timeMin = date("c", strtotime($start));
    	$timeMax = date("c", strtotime($end));
    	$service = new Google_Service_Calendar($this->client);
    	
    	$optParams = array(
    		'maxResults' => 100,
    		'orderBy' => 'startTime',
    		'singleEvents' => true,
    		'timeMin'      => $timeMin,
            'timeMax'      => $timeMax,
    	);


        //$calendarId = 'en.usa#holiday@group.v.calendar.google.com';
        //$calendarId = 'primary';
        $calendarId = []; $bgColor = [];
        $calendarList = $service->calendarList->listCalendarList();
        $calendarItems = $calendarList->getItems();
        if(!empty($calendarItems)) {
            $x=0;
            foreach ($calendarItems as $data) {
                $calendarId[$x] = $data->getId();
                $bgColor[$x] = $data->getBackgroundColor();
                $x++;
            }
        }

        //print_r($bgColor);die;
        //print_r($calendarId);die;

        //$calendarId = array('primary','en.usa#holiday@group.v.calendar.google.com');
        for ($i=0; $i < count($calendarId); $i++) { 
        	$results = $service->events->listEvents($calendarId[$i], $optParams);
        	$events = $results->getItems();

            //print_r($events);die;

        	if (!empty($events)) 
        	{
        		foreach ($events as $event) {
        			$start = $event->start->dateTime;
        			if (empty($start)) 
        				$start = $event->start->date;

                    $end = $event->end->dateTime;
                    if (empty($end)) 
                        $end = $event->end->date;

        			$eventArr[] =
        			[
        				'title'=>$event->getSummary(),
                        'description'=>$event->getDescription(),
        				'start'=>$start,
                        'end'=>$end,
                        'id'=>$event->getId(),
                        'backgroundColor' => $bgColor[$i]
        			]; 
        			// printf("%s (%s)\n", $event->getSummary(), $start);
        		}
        		
        	}

        }

        return $eventArr;

    }
    public function googleEventInsert($eventArr)
    {
        $service = new Google_Service_Calendar($this->client);
        $event = new Google_Service_Calendar_Event($eventArr);
        $calendarId = 'primary';
        $event = $service->events->insert($calendarId, $event);
    }
    public function googleEventDelete($eventId)
    {
        $service = new Google_Service_Calendar($this->client);
        $service->events->delete('primary', $eventId);
    }
    public function getGoogleTask($startDate,$endDate)
    {
    	// $start = date('m-01-Y'); 
    	// $end = date('t-m-Y');
    	// $timeMin = date("c");
    	// $timeMax = date("c", strtotime('tomorrow'));
    	$service = new Google_Service_Tasks($this->client);

    	$optParams = array(
    		'maxResults'=>100,
    		'showHidden'=>true,
    		'dueMin'=>$startDate,
    		'dueMax'=>$endDate,
    	);
    	$tasks = $service->tasks->listTasks('@default',$optParams);
    	$taskArr = [];
    	foreach($tasks->getItems() as $task) {
    		if($task->getHidden() || !empty($task->getCompleted()))
    		{
    			$taskArr[]=[
    				'taskId'=>$task->getId(),
    				'taskTitle' =>$task->getTitle(),
                    'taskNote' =>$task->getNotes(),
    				'taskDate' =>strtotime('+1 day',strtotime($task->getDue())),
    				'completed'=>true,
    			];
    		}else{
    			$taskArr[]=[
    				'taskId'=>$task->getId(),
    				'taskTitle' =>$task->getTitle(),
                    'taskNote' =>$task->getNotes(),
    				'taskDate' =>strtotime('+1 day',strtotime($task->getDue())),
    				'completed'=>false,
    			];
    		}
    	}
        array_multisort( array_column($taskArr, "taskDate"), SORT_ASC, $taskArr );
    	return $taskArr;
    }
    
    public function changeTaskStatus($taskId)
    {
    	$service = new Google_Service_Tasks($this->client);
    	$task = $service->tasks->get('@default', $taskId);
    	$task->setStatus('completed');
    	$result = $service->tasks->update('@default',$task->getId(), $task);
    }
    public function taskInsert($title,$notes,$date)
    {
        $service = new Google_Service_Tasks($this->client);
        $task = new Google_Service_Tasks_Task();
        $task->setTitle($title);
        $task->setNotes($notes);
        $task->setDue($date);
        $result = $service->tasks->insert('@default', $task);
    }
}