<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
 * Class name: App
 * @description :  This class contains all functions which will be used to show error message, warnings and success message
 * @author: Rachit Agarwal
 */
class App extends CI_Model {
  /*
   * @description :  This function called automatically when we call this call function or use any class variable
   * @Method name: __construct
   */
  public function __construct(){
    parent  :: __construct();
  }

  /*
   * @parameter : message, status
   * @description :  This function is developed for showing messages
   * @Method name: message
   */
   
      
  public function message($message, $status) {
    if ($status == 'warning') {      

        return $this->session->set_flashdata('message', '<div class="alert alert-warning alert-dismissible fade show" role="alert">'. $message .'<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');

    }
    if ($status == 'success') {                                            

       return $this->session->set_flashdata('message', '<div class="alert alert-success alert-dismissible fade show" role="alert">'. $message .'<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
       
    }
    if ($status == 'error') { 
        
        return $this->session->set_flashdata('message', '<div class="alert alert-danger alert-dismissible fade show" role="alert">'. $message .'<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');

    }
  }

  /*
   * @parameter : message, status
   * @description :  This function is developed for showing messages
   * @Method name: display
   */
  public function display($message, $status) {
    if ($status == 'warning') {
        return '<div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">×</button><div class="alert-icon"><i class="fa fa-exclamation-triangle"></i></div><div class="alert-message"><span>'. $message .'</span></div></div>';
    }
    if ($status == 'success') {
        return '<div class="alert alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">×</button><div class="alert-icon"><i class="fa fa-check"></i></div><div class="alert-message"><span>'. $message .'</span></div></div>';
    }
    if ($status == 'error') {
        return '<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">×</button><div class="alert-icon"><i class="fa fa-times"></i></div><div class="alert-message"><span>'. $message .'</span></div></div>';
    }
  }

  public function sendEmailToAdmin($ebody_contact,$esubject_contact,$email, $name){

   /* $this->phpmailer->IsSMTP();                                      // set mailer to use SMTP
    $this->phpmailer->Host      = SMTPHOST;  // specify main and backup server
    $this->phpmailer->SMTPAuth    = true;     // turn on SMTP authentication
    $this->phpmailer->SMTPSecure  = "ssl";
    $this->phpmailer->Port      = SMTPPORT;
    $this->phpmailer->Username    = SMTPEMAIL;  // SMTP username
    $this->phpmailer->Password    = SMTPPASS; // SMTP password
    $this->phpmailer->SMTPAuth    = true;*/
    //$this->phpmailer->From      = ADMINEMAIL;
    $this->phpmailer->From      = ADMINEMAIL;
    $this->phpmailer->FromName    = ucwords(SITE_TITLE);
    $this->phpmailer->AddAddress($email, ucwords(SITE_TITLE));   // name is optional
   // $this->phpmailer->AddReplyTo($email, $name);
    $this->phpmailer->IsHTML(true);                                  // set email format to HTML
    $this->phpmailer->Subject = $esubject_contact;
    $this->phpmailer->Body    = $ebody_contact;
    if(!$this->phpmailer->Send())
    { 
      return false;
      //$msg= "Message could not be sent. <p>";
      // "Mailer Error: " . $this->phpmailer->ErrorInfo;
    }   
    return true;
  }
  
  public function send_mail($ebody_contact,$esubject_contact,$toemail, $toname){
    $this->phpmailer->IsSMTP(); // set mailer to use SMTP
    $this->phpmailer->Host        = SMTPHOST;  // specify main and backup server
    $this->phpmailer->SMTPAuth    = true;     // turn on SMTP authentication
    $this->phpmailer->SMTPSecure  = "tls";
    $this->phpmailer->Port        = SMTPPORT;
    $this->phpmailer->Username    = SMTPUSERNAME;  // SMTP username
    $this->phpmailer->Password    = SMTPPASS; // SMTP password
	$this->phpmailer->CharSet 	  = 'UTF-8';
    $this->phpmailer->SMTPAuth    = true;
    $this->phpmailer->From        = ADMINEMAIL;
    $this->phpmailer->FromName    = ucwords(SITE_TITLE);
    $this->phpmailer->AddAddress($toemail, $toname);   // name is optional
    //$this->phpmailer->AddReplyTo(ADMINEMAIL, ucwords(SITE_TITLE));
    $this->phpmailer->IsHTML(true);                                  // set email format to HTML
    $this->phpmailer->Subject = $esubject_contact;
    $this->phpmailer->Body    = $ebody_contact;
    if(!$this->phpmailer->Send()) {
      return false;
    }   
    return true;
  }

  public function _getNewsLetterTemplate(){
    return '<table style=" background-color: #f6f6f6;width: 100%; margin: 0;padding: 0;font-family: "Helvetica Neue", "Helvetica", Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;background: #fff;border: 1px solid #e9e9e9; border-radius: 3px;"> <tr><td style="display: block !important;max-width: 600px !important;margin: 0 auto !important;clear: both !important;" width="600"><div style="max-width: 600px;margin: 0 auto;display: block;padding: 20px;"><table class="main" width="100%" cellpadding="0" cellspacing="0" itemprop="action" itemscope itemtype="http://schema.org/ConfirmAction"><tr><td style="padding: 20px;background: #fff;border: 1px solid #e9e9e9;border-radius: 3px;"><meta itemprop="name" content="Confirm Email"/><table width="100%" cellpadding="0" cellspacing="0"><tr><td style= " font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><h1>{SITENAME}</h2></td></tr><tr><td style= " padding: 0 0 20px;font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><img src="{IMAGE}" style="width:100%;"/><br/><h2>{HEADING}</h2>{CONTENT}</td></tr><tr><td  style=" padding: 0 0 20px;">Thanks,<br/>{SITENAME} Team</td></tr></table></td></tr></table><div class="footer"><table width="100%"><tr></tr></table></div></div></td></tr></table>';
  }


  public function _getSignupActivationTamplate(){
    return '<table style=" background-color: #f6f6f6;width: 100%; margin: 0;padding: 0;font-family: "Helvetica Neue", "Helvetica", Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;background: #fff;border: 1px solid #e9e9e9; border-radius: 3px;"> <tr><td style="display: block !important;max-width: 600px !important;margin: 0 auto !important;clear: both !important;" width="600"><div style="max-width: 600px;margin: 0 auto;display: block;padding: 20px;"><table class="main" width="100%" cellpadding="0" cellspacing="0" itemprop="action" itemscope itemtype="http://schema.org/ConfirmAction"><tr><td style="padding: 20px;background: #fff;border: 1px solid #e9e9e9;border-radius: 3px;"><meta itemprop="name" content="Confirm Email"/><table width="100%" cellpadding="0" cellspacing="0"><tr><td style= " font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><h1>{SITENAME}</h2></td></tr><tr><td style= " padding: 0 0 20px;font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><p>Dear, {NAME}</p>Please activate your account address by clicking the link below.</td></tr><tr><td  style=" padding: 0 0 20px;"> <a href="{LINK}" style="  text-decoration: none;  color: #FFF;  background-color: #348eda;  border: solid #348eda;  border-width: 10px 20px;  line-height: 2;  font-weight: bold;  text-align: center;  cursor: pointer;  display: inline-block;  border-radius: 5px;  text-transform: capitalize;font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;margin-top: 10px;"" itemprop="url">Confirm email address</a></td></tr><tr><td  style=" padding: 0 0 20px;">Thanks,<br/>{SITENAME} Team</td></tr></table></td></tr></table><div class="footer"><table width="100%"><tr></tr></table></div></div></td></tr></table>';
  }

   public function _getNewSignUpTamplate(){
    return '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width, initial-scale=1"><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><title>UHR</title><style type="text/css">html{background-color:#fff;margin:0;padding:0}body,#bodyTable,#bodyCell,#bodyCell{height:100%!important;margin:0;padding:0;width:100%!important;font-family:Helvetica,Arial,"Lucida Grande",sans-serif}table{border-collapse:collapse}table[id=bodyTable]{width:100%!important;margin:auto;max-width:650px!important;color:#7a7a7a;font-weight:normal}img,a img{border:0;outline:0;text-decoration:none;height:auto;line-height:100%}a{text-decoration:none!important;color:#085fad}h1,h2,h3,h4,h5,h6{color:#5f5f5f;font-weight:normal;font-family:Helvetica;font-size:20px;line-height:125%;text-align:Left;letter-spacing:normal;margin-top:0;margin-right:0;margin-bottom:10px;margin-left:0;padding-top:0;padding-bottom:0;padding-left:0;padding-right:0}.ReadMsgBody{width:100%}.ExternalClass{width:100%}.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%}table,td{mso-table-lspace:0;mso-table-rspace:0}#outlook a{padding:0}img{-ms-interpolation-mode:bicubic;display:block;outline:0;text-decoration:none}body,table,td,p,a,li,blockquote{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}.ExternalClass td[class="ecxflexibleContainerBox"] h3{padding-top:10px!important}h1{display:block;font-size:26px;font-style:normal;font-weight:normal;line-height:100%}h2{display:block;font-size:20px;font-style:normal;font-weight:normal;line-height:120%}h3{display:block;font-size:17px;font-style:normal;font-weight:normal;line-height:110%}h4{display:block;font-size:18px;font-style:italic;font-weight:normal;line-height:100%}.flexibleImage{height:auto}.linkRemoveBorder{border-bottom:0!important}table[class=flexibleContainerCellDivider]{padding-bottom:0!important;padding-top:0!important}body,#bodyTable{background-color:#fff}#emailHeader{background-color:#e1e1e1}#emailBody{background-color:#fff}#emailFooter{background-color:#e1e1e1}.nestedContainer{background-color:#f8f8f8;border:1px solid #ccc}.emailButton{background-color:#205478;border-collapse:separate}.buttonContent{color:#fff;font-family:Helvetica;font-size:18px;font-weight:bold;line-height:100%;padding:15px;text-align:center}.buttonContent a{color:#fff;display:block;text-decoration:none!important;border:0!important}.emailCalendar{background-color:#fff;border:1px solid #ccc}.emailCalendarMonth{background-color:#205478;color:#fff;font-family:Helvetica,Arial,sans-serif;font-size:16px;font-weight:bold;padding-top:10px;padding-bottom:10px;text-align:center}.emailCalendarDay{color:#205478;font-family:Helvetica,Arial,sans-serif;font-size:60px;font-weight:bold;line-height:100%;padding-top:20px;padding-bottom:20px;text-align:center}.imageContentText{margin-top:10px;line-height:0}.imageContentText a{line-height:0}#invisibleIntroduction{display:none!important}@media only screen and (max-width:520px){body{width:100%!important;min-width:100%!important}table[id="emailHeader"],table[id="emailBody"],table[id="emailFooter"],table[class="flexibleContainer"],td[class="flexibleContainerCell"]{width:100%!important}td[class="flexibleContainerBox"],td[class="flexibleContainerBox"] table{display:block;width:100%}td[class="imageContent"] img{height:auto!important;width:100%!important;max-width:100%!important}img[class="flexibleImage"]{height:auto!important;width:100%!important;max-width:100%!important}img[class="flexibleImageSmall"]{height:auto!important;width:auto!important}table[class="flexibleContainerBoxNext"]{padding-top:0!important}table[class="emailButton"]{width:100%!important}td[class="buttonContent"]{padding:0!important}td[class="buttonContent"] a{padding:15px!important}.display{display:none!important}}</style></head><body bgcolor="#fff" leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"><table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable" style="table-layout:fixed;max-width:100%!important;width:100%!important;min-width:100%!important"><tr><td align="center" valign="top" id="bodyCell"><table bgcolor="#FFFFFF" border="0" cellpadding="0" cellspacing="0" width="650" id="emailBody" style="border:1px solid #e5e5e5"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%" style="color:#FFFFFF"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="650" class="flexibleContainer"><tr><td align="center" valign="top" width="650" class="flexibleContainerCell"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td valign="top" class="imageContent"><a href="http://uphereradio.com/uhr/web/" target="_blank"><img src="https://uphereradio.com/assets/images/mail/logo.jpg" width="650" class="flexibleImage" style="max-width:650px;width:100%;display:block" alt="UHR" title="UHR" /></a></td></tr></table></td></tr></table></td></tr></table></td></tr><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="650" class="flexibleContainer"><tr><td valign="top" width="650" class="flexibleContainerCell"><table align="left" border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td align="left" valign="top" class="flexibleContainerBox"><table border="0" cellpadding="0" cellspacing="0" style="max-width:100%"><tr><td align="left" class="textContent" style="padding:0 20px 0 20px"><table cellpadding="0" cellspacing="0" border="0" style="font-size:14px;font-family:Arial,Helvetica,sans-serif;color:#343434;background-color:#fff"><tr><td valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="font-size:14px;color:#000;font-family:Arial,Helvetica,sans-serif;line-height:18px;padding-bottom:0"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td height="60"></td></tr><tr><td style="font-size:18px;font-family:Arial,Helvetica,sans-serif;line-height:23px;width:100%" colspan="3"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tbody><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Hello {NAME}, and welcome to Up Here Radio! its easy to listen at home or on the go - just download our free iPhone and Android apps, press play, and enjoy!</td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"><strong>Log In:</strong> {EMAIL} <br/><strong>Password:</strong> {PASS}</td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Follow us on Facebook, Instagram, and Twitter for all the latest!</td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Happy Listening, <br/>
UHR Team </td></tr><tr><td height="60"></td></tr></tbody></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%" bgcolor="#5e5e5e"><tbody><tr><td valign="top" align="center"><table class="flexibleContainer" width="650" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="flexibleContainerCell" width="650" valign="top" align="center"><table width="100%" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td valign="top" align="center"><table width="100%" cellspacing="0" cellpadding="0" border="0" align="center"><tbody><tr><td height="10" colspan="2"></td></tr><tr><td class="flexibleContainerBox" valign="top" align="center"><table class="flexibleContainerBoxNext" style="max-width:100%" width="180" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="https://www.facebook.com/uphereradio/"><img src="https://uphereradio.com/assets/images/mail/facebook.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="#"><img src="https://uphereradio.com/assets/images/mail/instagram.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="https://twitter.com/UPHERERADIO"><img src="https://uphereradio.com/assets/images/mail/twitter.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><img src="https://uphereradio.com/assets/images/mail/android.jpg" border="0"></td><td class="textContent" align="left"><img src="https://uphereradio.com/assets/images/mail/apple.jpg" border="0"></td></tr></tbody></table></td></tr><tr><td height="10" colspan="2"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr>
</table></td></tr></table></body></html>';
  }
  public function _getForgetPasswordTamplate(){

    return '<html><head><title>{SITETITLE}</title></head><body><table align="center" border="0" cellpadding="0" cellspacing="0" id="bodyTable" style="width:50%"><tbody><tr><td"><table border="0" cellpadding="0" cellspacing="0" id="templateContainer"><tbody><tr><td><table border="0" cellpadding="10" cellspacing="0" id="templateHeader"><tbody><tr><td></td></tr></tbody></table></td></tr><tr><td><table border="0" cellpadding="10" cellspacing="0" id="templateBody" align="center"><tbody><tr><td><p>We heard that you lost your password. Sorry about that!</p><p>But don\'t worry! You can use the following link within the next day to reset your password:</p><p><h3><a href="{LINK}" target="_blank">{LINK}</a></h3></p><p>If you don\'t use this link within 24 hours, it will expire. To get a new password reset link, visit <a href="#" target="_blank"></a></p></td></tr><tr><td>Thanks,<br/><a href="#" target="_blank"></a></td></tr></tbody></table></td></tr> </tbody></table></td></tr></tbody></table></body></html>';
  }
   public function _getfeedbackTamplate(){

 return '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width, initial-scale=1"><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><title>UHR</title><style type="text/css">html{background-color:#fff;margin:0;padding:0}body,#bodyTable,#bodyCell,#bodyCell{height:100%!important;margin:0;padding:0;width:100%!important;font-family:Helvetica,Arial,"Lucida Grande",sans-serif}table{border-collapse:collapse}table[id=bodyTable]{width:100%!important;margin:auto;max-width:650px!important;color:#7a7a7a;font-weight:normal}img,a img{border:0;outline:0;text-decoration:none;height:auto;line-height:100%}a{text-decoration:none!important;color:#085fad}h1,h2,h3,h4,h5,h6{color:#5f5f5f;font-weight:normal;font-family:Helvetica;font-size:20px;line-height:125%;text-align:Left;letter-spacing:normal;margin-top:0;margin-right:0;margin-bottom:10px;margin-left:0;padding-top:0;padding-bottom:0;padding-left:0;padding-right:0}.ReadMsgBody{width:100%}.ExternalClass{width:100%}.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%}table,td{mso-table-lspace:0;mso-table-rspace:0}#outlook a{padding:0}img{-ms-interpolation-mode:bicubic;display:block;outline:0;text-decoration:none}body,table,td,p,a,li,blockquote{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}.ExternalClass td[class="ecxflexibleContainerBox"] h3{padding-top:10px!important}h1{display:block;font-size:26px;font-style:normal;font-weight:normal;line-height:100%}h2{display:block;font-size:20px;font-style:normal;font-weight:normal;line-height:120%}h3{display:block;font-size:17px;font-style:normal;font-weight:normal;line-height:110%}h4{display:block;font-size:18px;font-style:italic;font-weight:normal;line-height:100%}.flexibleImage{height:auto}.linkRemoveBorder{border-bottom:0!important}table[class=flexibleContainerCellDivider]{padding-bottom:0!important;padding-top:0!important}body,#bodyTable{background-color:#fff}#emailHeader{background-color:#e1e1e1}#emailBody{background-color:#fff}#emailFooter{background-color:#e1e1e1}.nestedContainer{background-color:#f8f8f8;border:1px solid #ccc}.emailButton{background-color:#205478;border-collapse:separate}.buttonContent{color:#fff;font-family:Helvetica;font-size:18px;font-weight:bold;line-height:100%;padding:15px;text-align:center}.buttonContent a{color:#fff;display:block;text-decoration:none!important;border:0!important}.emailCalendar{background-color:#fff;border:1px solid #ccc}.emailCalendarMonth{background-color:#205478;color:#fff;font-family:Helvetica,Arial,sans-serif;font-size:16px;font-weight:bold;padding-top:10px;padding-bottom:10px;text-align:center}.emailCalendarDay{color:#205478;font-family:Helvetica,Arial,sans-serif;font-size:60px;font-weight:bold;line-height:100%;padding-top:20px;padding-bottom:20px;text-align:center}.imageContentText{margin-top:10px;line-height:0}.imageContentText a{line-height:0}#invisibleIntroduction{display:none!important}@media only screen and (max-width:520px){body{width:100%!important;min-width:100%!important}table[id="emailHeader"],table[id="emailBody"],table[id="emailFooter"],table[class="flexibleContainer"],td[class="flexibleContainerCell"]{width:100%!important}td[class="flexibleContainerBox"],td[class="flexibleContainerBox"] table{display:block;width:100%}td[class="imageContent"] img{height:auto!important;width:100%!important;max-width:100%!important}img[class="flexibleImage"]{height:auto!important;width:100%!important;max-width:100%!important}img[class="flexibleImageSmall"]{height:auto!important;width:auto!important}table[class="flexibleContainerBoxNext"]{padding-top:0!important}table[class="emailButton"]{width:100%!important}td[class="buttonContent"]{padding:0!important}td[class="buttonContent"] a{padding:15px!important}.display{display:none!important}}</style></head><body bgcolor="#fff" leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"><table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable" style="table-layout:fixed;max-width:100%!important;width:100%!important;min-width:100%!important"><tr><td align="center" valign="top" id="bodyCell"><table bgcolor="#FFFFFF" border="0" cellpadding="0" cellspacing="0" width="650" id="emailBody" style="border:1px solid #e5e5e5"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%" style="color:#FFFFFF"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="650" class="flexibleContainer"><tr><td align="center" valign="top" width="650" class="flexibleContainerCell"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td valign="top" class="imageContent"><a href="http://uphereradio.com/uhr/web/" target="_blank"><img src="https://uphereradio.com/assets/images/mail/logo.jpg" width="650" class="flexibleImage" style="max-width:650px;width:100%;display:block" alt="UHR" title="UHR" /></a></td></tr></table></td></tr></table></td></tr></table></td></tr><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="650" class="flexibleContainer"><tr><td valign="top" width="650" class="flexibleContainerCell"><table align="left" border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td align="left" valign="top" class="flexibleContainerBox"><table border="0" cellpadding="0" cellspacing="0" style="max-width:100%"><tr><td align="left" class="textContent" style="padding:0 20px 0 20px"><table cellpadding="0" cellspacing="0" border="0" style="font-size:14px;font-family:Arial,Helvetica,sans-serif;color:#343434;background-color:#fff"><tr><td valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="font-size:14px;color:#000;font-family:Arial,Helvetica,sans-serif;line-height:18px;padding-bottom:0"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td height="60"></td></tr><tr><td style="font-size:18px;font-family:Arial,Helvetica,sans-serif;line-height:23px;width:100%" colspan="3"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tbody><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Hello Team Member, Here I got a feedback for you</td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"><strong>Topic</strong> {TOPIC} <br/><strong>Message:</strong> {MESSAGE}</td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Follow us on Facebook, Instagram, and Twitter for all the latest!</td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px">Thanks,<br/>{NAME}<br> Email : {EMAIL} </td></tr><tr><td height="60"></td></tr></tbody></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%" bgcolor="#5e5e5e"><tbody><tr><td valign="top" align="center"><table class="flexibleContainer" width="650" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="flexibleContainerCell" width="650" valign="top" align="center"><table width="100%" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td valign="top" align="center"><table width="100%" cellspacing="0" cellpadding="0" border="0" align="center"><tbody><tr><td height="10" colspan="2"></td></tr><tr><td class="flexibleContainerBox" valign="top" align="center"><table class="flexibleContainerBoxNext" style="max-width:100%" width="180" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="https://www.facebook.com/uphereradio/"><img src="https://uphereradio.com/assets/images/mail/facebook.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="#"><img src="https://uphereradio.com/assets/images/mail/instagram.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="https://twitter.com/UPHERERADIO"><img src="https://uphereradio.com/assets/images/mail/twitter.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><img src="https://uphereradio.com/assets/images/mail/android.jpg" border="0"></td><td class="textContent" align="left"><img src="https://uphereradio.com/assets/images/mail/apple.jpg" border="0"></td></tr></tbody></table></td></tr><tr><td height="10" colspan="2"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr>
</table></td></tr></table></body></html>';


    
  }
  
  public function _getfeedback_user_Tamplate(){
      
       return '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width, initial-scale=1"><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><title>UHR</title><style type="text/css">html{background-color:#fff;margin:0;padding:0}body,#bodyTable,#bodyCell,#bodyCell{height:100%!important;margin:0;padding:0;width:100%!important;font-family:Helvetica,Arial,"Lucida Grande",sans-serif}table{border-collapse:collapse}table[id=bodyTable]{width:100%!important;margin:auto;max-width:650px!important;color:#7a7a7a;font-weight:normal}img,a img{border:0;outline:0;text-decoration:none;height:auto;line-height:100%}a{text-decoration:none!important;color:#085fad}h1,h2,h3,h4,h5,h6{color:#5f5f5f;font-weight:normal;font-family:Helvetica;font-size:20px;line-height:125%;text-align:Left;letter-spacing:normal;margin-top:0;margin-right:0;margin-bottom:10px;margin-left:0;padding-top:0;padding-bottom:0;padding-left:0;padding-right:0}.ReadMsgBody{width:100%}.ExternalClass{width:100%}.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%}table,td{mso-table-lspace:0;mso-table-rspace:0}#outlook a{padding:0}img{-ms-interpolation-mode:bicubic;display:block;outline:0;text-decoration:none}body,table,td,p,a,li,blockquote{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}.ExternalClass td[class="ecxflexibleContainerBox"] h3{padding-top:10px!important}h1{display:block;font-size:26px;font-style:normal;font-weight:normal;line-height:100%}h2{display:block;font-size:20px;font-style:normal;font-weight:normal;line-height:120%}h3{display:block;font-size:17px;font-style:normal;font-weight:normal;line-height:110%}h4{display:block;font-size:18px;font-style:italic;font-weight:normal;line-height:100%}.flexibleImage{height:auto}.linkRemoveBorder{border-bottom:0!important}table[class=flexibleContainerCellDivider]{padding-bottom:0!important;padding-top:0!important}body,#bodyTable{background-color:#fff}#emailHeader{background-color:#e1e1e1}#emailBody{background-color:#fff}#emailFooter{background-color:#e1e1e1}.nestedContainer{background-color:#f8f8f8;border:1px solid #ccc}.emailButton{background-color:#205478;border-collapse:separate}.buttonContent{color:#fff;font-family:Helvetica;font-size:18px;font-weight:bold;line-height:100%;padding:15px;text-align:center}.buttonContent a{color:#fff;display:block;text-decoration:none!important;border:0!important}.emailCalendar{background-color:#fff;border:1px solid #ccc}.emailCalendarMonth{background-color:#205478;color:#fff;font-family:Helvetica,Arial,sans-serif;font-size:16px;font-weight:bold;padding-top:10px;padding-bottom:10px;text-align:center}.emailCalendarDay{color:#205478;font-family:Helvetica,Arial,sans-serif;font-size:60px;font-weight:bold;line-height:100%;padding-top:20px;padding-bottom:20px;text-align:center}.imageContentText{margin-top:10px;line-height:0}.imageContentText a{line-height:0}#invisibleIntroduction{display:none!important}@media only screen and (max-width:520px){body{width:100%!important;min-width:100%!important}table[id="emailHeader"],table[id="emailBody"],table[id="emailFooter"],table[class="flexibleContainer"],td[class="flexibleContainerCell"]{width:100%!important}td[class="flexibleContainerBox"],td[class="flexibleContainerBox"] table{display:block;width:100%}td[class="imageContent"] img{height:auto!important;width:100%!important;max-width:100%!important}img[class="flexibleImage"]{height:auto!important;width:100%!important;max-width:100%!important}img[class="flexibleImageSmall"]{height:auto!important;width:auto!important}table[class="flexibleContainerBoxNext"]{padding-top:0!important}table[class="emailButton"]{width:100%!important}td[class="buttonContent"]{padding:0!important}td[class="buttonContent"] a{padding:15px!important}.display{display:none!important}}</style></head><body bgcolor="#fff" leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"><table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable" style="table-layout:fixed;max-width:100%!important;width:100%!important;min-width:100%!important"><tr><td align="center" valign="top" id="bodyCell"><table bgcolor="#FFFFFF" border="0" cellpadding="0" cellspacing="0" width="650" id="emailBody" style="border:1px solid #e5e5e5"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%" style="color:#FFFFFF"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="650" class="flexibleContainer"><tr><td align="center" valign="top" width="650" class="flexibleContainerCell"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td valign="top" class="imageContent"><a href="http://uphereradio.com/uhr/web/" target="_blank"><img src="https://uphereradio.com/assets/images/mail/logo.jpg" width="650" class="flexibleImage" style="max-width:650px;width:100%;display:block" alt="UHR" title="UHR" /></a></td></tr></table></td></tr></table></td></tr></table></td></tr><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="650" class="flexibleContainer"><tr><td valign="top" width="650" class="flexibleContainerCell"><table align="left" border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td align="left" valign="top" class="flexibleContainerBox"><table border="0" cellpadding="0" cellspacing="0" style="max-width:100%"><tr><td align="left" class="textContent" style="padding:0 20px 0 20px"><table cellpadding="0" cellspacing="0" border="0" style="font-size:14px;font-family:Arial,Helvetica,sans-serif;color:#343434;background-color:#fff"><tr><td valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="font-size:14px;color:#000;font-family:Arial,Helvetica,sans-serif;line-height:18px;padding-bottom:0"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td height="60"></td></tr><tr><td style="font-size:18px;font-family:Arial,Helvetica,sans-serif;line-height:23px;width:100%" colspan="3"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tbody><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Hello {NAME}, We value your feedback and will ensure its considered for future development of the application.</td></tr><tr><td height="20"></td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Follow us on Facebook, Instagram, and Twitter for all the latest!</td></tr><tr><td height="20"></td></tr><tr><td style="font-size:16px;color:#333;font-family:Arial,Helvetica,sans-serif;line-height:22px"> Regards, <br/>
UHR Team </td></tr><tr><td height="60"></td></tr></tbody></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr><tr><td align="center" valign="top"><table border="0" cellpadding="0" cellspacing="0" width="100%" bgcolor="#5e5e5e"><tbody><tr><td valign="top" align="center"><table class="flexibleContainer" width="650" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="flexibleContainerCell" width="650" valign="top" align="center"><table width="100%" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td valign="top" align="center"><table width="100%" cellspacing="0" cellpadding="0" border="0" align="center"><tbody><tr><td height="10" colspan="2"></td></tr><tr><td class="flexibleContainerBox" valign="top" align="center"><table class="flexibleContainerBoxNext" style="max-width:100%" width="180" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="https://www.facebook.com/uphereradio/"><img src="https://uphereradio.com/assets/images/mail/facebook.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="#"><img src="https://uphereradio.com/assets/images/mail/instagram.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><a target="_blank" href="https://twitter.com/UPHERERADIO"><img src="https://uphereradio.com/assets/images/mail/twitter.jpg" border="0"></a></td><td class="textContent" style="padding-right:5px" align="left"><img src="https://uphereradio.com/assets/images/mail/android.jpg" border="0"></td><td class="textContent" align="left"><img src="https://uphereradio.com/assets/images/mail/apple.jpg" border="0"></td></tr></tbody></table></td></tr><tr><td height="10" colspan="2"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr>
</table></td></tr></table></body></html>';
      
      
  }
  public function _getSignupstatusTamplate(){
    return '<table style=" background-color: #f6f6f6;width: 100%; margin: 0;padding: 0;font-family: "Helvetica Neue", "Helvetica", Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;background: #fff;border: 1px solid #e9e9e9; border-radius: 3px;"> <tr><td style="display: block !important;max-width: 600px !important;margin: 0 auto !important;clear: both !important;" width="600"><div style="max-width: 600px;margin: 0 auto;display: block;padding: 20px;"><table class="main" width="100%" cellpadding="0" cellspacing="0" itemprop="action" itemscope itemtype="http://schema.org/ConfirmAction"><tr><td style="padding: 20px;background: #fff;border: 1px solid #e9e9e9;border-radius: 3px;"><meta itemprop="name" content="Confirm Email"/><table width="100%" cellpadding="0" cellspacing="0"><tr><td style= " font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><h1><a herf="{BASE_URL}" style="text-decoration:none"> {SITENAME}</a></h2></td></tr><tr><td style= " padding: 0 0 20px;font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><p>Dear {NAME},</p> Just a confirmation that you have successfully signed up for an account with {SITENAME}. Our administrator will be reviewing your request and will be in touch with an approval shortly.</td></tr><tr><td  style=" padding: 0 0 20px;">Thanks,<br/>The {SITENAME} Team</td></tr><tr><td  style=" padding: 0 0 20px;"><img src="{SITEBAR_LOGO}" alt="Site Logo"/></td></tr></table></td></tr></table><div class="footer"><table width="100%"><tr></tr></table></div></div></td></tr></table>';
  }
    public function _getAccountstatusTamplate(){
    return '<table style=" background-color: #f6f6f6;width: 100%; margin: 0;padding: 0;font-family: "Helvetica Neue", "Helvetica", Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;background: #fff;border: 1px solid #e9e9e9; border-radius: 3px;"> <tr><td style="display: block !important;max-width: 600px !important;margin: 0 auto !important;clear: both !important;" width="600"><div style="max-width: 600px;margin: 0 auto;display: block;padding: 20px;"><table class="main" width="100%" cellpadding="0" cellspacing="0" itemprop="action" itemscope itemtype="http://schema.org/ConfirmAction"><tr><td style="padding: 20px;background: #fff;border: 1px solid #e9e9e9;border-radius: 3px;"><meta itemprop="name" content="Confirm Email"/><table width="100%" cellpadding="0" cellspacing="0"><tr><td style= " font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><h1> {SITENAME}</h2></td></tr><tr><td style= " padding: 0 0 20px;font-family: \' Helvetica Neue \', \' Helvetica\', Helvetica, Arial, sans-serif;box-sizing: border-box;font-size: 14px;"><p>Dear {NAME},</p> <p>Just a confirmation that our administrator has approved your account and is now active for use.
Feel free to <A href="{BASE_URL}/login.html"> login-in</a> to {SITENAME} </p></td></tr><tr><td  style=" padding: 0 0 20px;">Thanks,<br/>The {SITENAME} Team</td></tr><tr><td  style=" padding: 0 0 20px;"><img src="{SITEBAR_LOGO}" alt="Site Logo"/></td></tr></table></td></tr></table><div class="footer"><table width="100%"><tr></tr></table></div></div></td></tr></table>';
  }
}
