<?php
    /**
    * 
    */
    class Client_model extends CI_Model {
        
      function __construct() {
          parent:: __construct();
      }

      /*Get All data with where clause*/
      public function get_rows($table, $column='*', $where=[], $whereOr=[], $like=[], $num_rows=false) {
          $this->db->select($column);
          $this->db->from($table);
          if(!empty($where)){
            $this->db->where($where);  
          }
          if(!empty($whereOr)){
            $this->db->or_where($whereOr);
          }
          if(!empty($like)){
            $this->db->like($like);
          }
          //$this->db->order_by("created_at", "desc");
          $query = $this->db->get();          
          if($num_rows){
            return $query->num_rows(); 
          } else {
            return $query->result_array();  
          }
      }

      public function get_clients($agency_code){
          
          if(!empty($this->input->post('search')) || (!empty($_GET['action']) && $_GET['action']=='tags')) {
            $cond1=$cond2=$cond3=$cond4=$cond5=$zipcode=$patient_id=$med_medicaidno=$lastname=$firstname=$phone=$zipcode='';
            if(!empty($this->input->post('byId'))){
                $patient_id    =   $this->input->post('byId', TRUE);
            }
            if(!empty($this->input->post('birthday')) && $this->input->post('birthday')!='__/__/____'){
                $CustomFieldBirthday    =   $this->input->post('birthday', TRUE);
                $d1 = date("Y-m-d",strtotime($CustomFieldBirthday));
                $d2 = date("m/d/Y",strtotime($CustomFieldBirthday));
                $d3 = date("d/m/Y",strtotime($CustomFieldBirthday));
                $cond5 = " AND (CustomFieldBirthday LIKE '%$d1%' OR CustomFieldBirthday LIKE '%$d2%' OR CustomFieldBirthday LIKE '%$d3%')";
            }
            if(!empty($this->input->post('medicaid'))){
                $med_medicaidno    =   $this->input->post('medicaid', TRUE);
            }

            //$cond1     =   " AND IsActive = 1";

            if($this->input->post('byActive')!='' && $this->input->post('byActive')!='all'){
                $active    =   $this->input->post('byActive', TRUE);
                $cond1     =   " AND IsActive = '$active'";
            }
            if(!empty($this->input->post('lastname'))){
                $lastname   =   $this->input->post('lastname', TRUE);
            }
            if(!empty($this->input->post('firstname'))){
                $firstname   =   $this->input->post('firstname', TRUE);
            }
            if(!empty($this->input->post('district'))){
                $DistrictID_Ref    =   $this->input->post('district', TRUE);
                $cond2 = " AND patient.DistrictID_Ref = '$DistrictID_Ref'";
            }
            if(!empty($this->input->post('agency_location'))){
                $agency_location    =   $this->input->post('agency_location', TRUE);
                $cond4 = " AND patient.agency_location = '$agency_location'";
            }
            if(!empty($this->input->post('phone'))){
                $phone    =   $this->input->post('phone', TRUE);
            }
            if(!empty($this->input->post('zipcode'))){
                $zipcode    =   $this->input->post('zipcode', TRUE);
            }
            $suplid    =   $this->input->post('superviser', TRUE);
            if($suplid!='') {
              $cond3 = " AND patient.supervisor_id = '$suplid'";  
            }

            $onHold    =   $this->input->post('onHold', TRUE);
            if($onHold!='') {
              $cond3 .= " AND patient.on_hold = '$onHold'";  
            }

            /*$smoker    =   $this->input->post('smoker', TRUE);
            if($smoker!='') {
              $cond3 .= " AND patient.smoker = '$smoker'";  
            }

            $hoarder    =   $this->input->post('hoarder', TRUE);
            if($hoarder!='') {
              $cond3 .= " AND patient.hoarder = '$hoarder'";  
            }
            $covid_vax    =   $this->input->post('covid_vax', TRUE);
            if($covid_vax!='') {
              $cond3 .= " AND patient.covid_vax = '$covid_vax'";  
            }*/

            $search = $this->input->post('search');
            if(!empty($search) && $search=='searchbyKeyword') {                
                $keyword = $_POST['keyword']; 
                if($keyword=="Active") {
                    $cond3  .=  " AND IsActive = '1'";
                }
                if($keyword=="On Hold") {
                    $cond3  .=  " AND on_hold = 'yes'";
                }
                if($keyword=="Smoker") {
                    $cond3 .= " AND patient.smoker = 1";  
                }
                if($keyword=="Hoarder Level 5") {
                    $cond3 .= " AND patient.hoarder = 1";  
                }
                if($keyword=="Covid19 Vax") {
                    $cond3 .= " AND patient.covid_vax = 1";  
                }
                if($keyword=="Male") {
                    $cond3 .= " AND patient.gender = 'M'";  
                }
                if($keyword=="Female") {
                    $cond3 .= " AND patient.gender = 'F'";  
                }
                if($keyword=="Refused Services") {
                    $cond3 .= " AND patient.reason = 8";
                }
                if($keyword=="Hospital") {
                    $cond3 .= " AND patient.reason = 4";
                }
                if($keyword=="Vacation") {
                    $cond3 .= " AND patient.reason = 5";
                }
                if($keyword=="Out of Town") {
                    $cond3 .= " AND patient.reason = 6";
                }
                if($keyword=="Terminated") {
                    $cond3 .= " AND patient.reason = 3";
                }
                if($keyword=="60 Days") {
                    $cond3 .= " AND patient.reason = 7";
                }
                if($keyword=="White") {
                    $cond3 .= " AND patient.race = 'White'";
                }
                if($keyword=="Asian") {
                    $cond3 .= " AND patient.race = 'Asian'";
                }
                if($keyword=="Black") {
                    $cond3 .= " AND patient.race = 'Black'";
                }
                if($keyword=="American Indian") {
                    $cond3 .= " AND patient.race = 'American Indian'";
                }
                if($keyword=="Spanish") {
                    $cond3 .= " AND patient.race = 'Spanish'";
                }
                if($keyword=="Mixed") {
                    $cond3 .= " AND patient.race = 'Mixed'";
                }
                if($keyword=="Others") {
                    $cond3 .= " AND patient.race = 'Others'";
                }                
                if($keyword=="dementia") {    
                    $cond3 .=   " AND patient.dementia = '1'";
                }
                if($keyword=="alzheimer") {
                    $cond3 .=   " AND patient.alzheimer = '1'";
                }
                if($keyword=="nonverbal") {    
                    $cond3 .=   " AND patient.nonverbal = '1'";
                }
                if($keyword=="poainplace") {    
                    $cond3 .=   " AND patient.poa_in_place = '1'";
                }
                if($keyword=="transferneeded") {
                    $cond3 .=   " AND patient.transfer_needed != ''";
                }
                if($keyword=="pets") {
                    $cond3 .=   " AND patient.pets = '1'";
                }
                if($keyword=="substanceabuse") {
                    $cond3 .=   " AND patient.substance_abuse = '1'";
                }
            }
                

            /********* Filter By tags *************/
            if(!empty($_GET['dementia']) && $_GET['dementia']=='1') {
                $cond3 .=   " AND patient.dementia = '1'";
            }
            if(!empty($_GET['alzheimer']) && $_GET['alzheimer']=='1') {
                $cond3 .=   " AND patient.alzheimer = '1'";
            }
            if(!empty($_GET['nonverbal']) && $_GET['nonverbal']=='1') {
                $cond3 .=   " AND patient.nonverbal = '1'";
            }
            if(!empty($_GET['poainplace']) && $_GET['poainplace']=='1') {
                $cond3 .=   " AND patient.poa_in_place = '1'";
            }
            if(!empty($_GET['transferneeded']) && $_GET['transferneeded']=='1') {
                $cond3 .=   " AND patient.transfer_needed != ''";
            }
            if(!empty($_GET['pets']) && $_GET['pets']=='1') {
                $cond3 .=   " AND patient.pets = '1'";
            }
            if(!empty($_GET['substanceabuse']) && $_GET['substanceabuse']=='1') {
                $cond3 .=   " AND patient.substance_abuse = '1'";
            }

            if(!empty($_GET['home_health']) && $_GET['home_health']=='1') {
                $cond3 .=   " AND patient.home_health = '1'";
            }
            if(!empty($_GET['hospice']) && $_GET['hospice']=='1') {
                $cond3 .=   " AND patient.hospice = '1'";
            }
            if(!empty($_GET['outpatient_therapy']) && $_GET['outpatient_therapy']=='1') {
                $cond3 .=   " AND patient.outpatient_therapy >= '1'";
            }


            if(!empty($_GET['status']) && $_GET['status']=='Active') {
                $cond1     =   " AND IsActive = '1'";
            }
            if(!empty($_GET['onHold']) && $_GET['onHold']=='On Hold'){
                $cond1     =   " AND on_hold = 'yes'";
            }
            if(!empty($_GET['smoker']) && $_GET['smoker']=='Smoker'){
                $cond3 .= " AND patient.smoker = '1'";  
            }
            if(!empty($_GET['hoarder']) && $_GET['hoarder']=='Hoarder Level 5'){
                $cond3 .= " AND patient.hoarder = '1'";  
            }
            if(!empty($_GET['covid19']) && $_GET['covid19']=='Covid19 Vax'){
                $cond3 .= " AND patient.covid_vax = '1'";  
            }
            if(!empty($_GET['reason'])) {
                $reason = implode(',', $_GET['reason']);
                $cond3 .= " AND patient.reason IN ($reason)";  
            }

            if(!empty($_GET['gender'])) {
                $cond3 .= ' AND patient.gender IN ("' . implode('", "', $_GET['gender']) . '")';  
            }
            
            if(!empty($_GET['race'])) {
                $cond3 .= ' AND patient.race IN ("' . implode('", "', $_GET['race']) . '")';  
            }

            $MySQL = "SELECT SQL_CALC_FOUND_ROWS
                    patient.lastname, 
                    patient.firstname, 
                    patient.middlename,
                    patient.ShipAddressPostalCode,
                    patient.phone,
                    patient.phone2,
                    patient.useradd,
                    patient.userdate,
                    patient.popalert,
                    patient.popnotes,
                    patient.med_medicaidno,
                    patient.patient_id,
                    patient.CustomFieldBirthday,
                    patient.IsActive,
                    patient.JobStartDate,
                    patient.agency_location,
                    tbldistricts.DistrictNumber,
                    tbldistricts.DistrictName,
                    patient.FHCA,
                    patient.termination_date,
                    patient.termination_status,
                    patient.smoker,
                    patient.hoarder,
                    patient.covid_vax,
                    patient.on_hold,
                    supervisor.firstname AS supfirstname, 
                    supervisor.lastname AS suplastname 
        
                    FROM patient,tbldistricts,supervisor
                    WHERE  tbldistricts.DistrictID = patient.DistrictID_Ref AND 
                    tbldistricts.Agency = '$agency_code' AND
                    supervisor.supervisor_id = patient.supervisor_id AND 
                    patient.Agency = '$agency_code' ";
                    if(!empty($patient_id)) {
                      $MySQL .= "AND patient.patient_id LIKE '%".$patient_id."%' ";
                    }

                    if(!empty($med_medicaidno)) {
                      $MySQL .= "AND patient.med_medicaidno LIKE '%".$med_medicaidno."%' ";   
                    }

                    if(!empty($zipcode)) {
                      $MySQL .= "AND patient.ShipAddressPostalCode LIKE '%".$zipcode."%' ";  
                    }

                    if(!empty($phone)) {
                      $MySQL .= "AND (patient.phone LIKE '%".$phone."%' OR patient.phone2 LIKE '%".$phone."%') ";  
                    }

                    if(!empty($firstname)) {
                      $MySQL .= "AND patient.firstname LIKE '%".$firstname."%' ";  
                    }

                    if(!empty($lastname)) {
                      $MySQL .= "AND patient.lastname LIKE '%".$lastname."%' ";  
                    }
                      
                    $MySQL .= $cond1.$cond2.$cond3.$cond4.$cond5;
                    //ORDER BY ".$sortorder." ".$desc." 
                    //LIMIT " .$from. ", " .$to ."   ";  

                    //echo $MySQL;
          $query = $this->db->query($MySQL);
          return $query->result_array();
        } else {
          return array();
        }
      }


      public function get_assigned_employee($where, $like = [], $not_like = []) {
          $select   = array(
                            "ea.*",
                            "em.firstname",
                            "em.lastname",
                            "em.employee_id",
                            "em.hcpadmin",
                          );
          $this->db->select($select);
          $this->db->from("employee_assignment as ea");
          $this->db->join('employee as em', 'ea.employee_id = em.employee_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          if(!empty($like)){
            $this->db->like($like);
          }
          if(!empty($not_like)){
            $this->db->not_like($not_like);
          }
          //$this->db->order_by('pp.id','desc');
          $query =  $this->db->get();
          //print_r($this->db->last_query());
          return $query->result_array();  
          
      }


      public function get_plan_of_care_employee($where) {
          $select   = array(
                            "pc.*",
                            "em.firstname",
                            "em.lastname",
                            "em.employee_id",
                          );
          $this->db->select($select);
          $this->db->from("plan_of_care as pc");
          $this->db->join('employee as em', 'pc.employee_id = em.employee_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          $this->db->order_by('pc.plc_id','desc');
          return $this->db->get()->result_array();  
      }

      public function get_plan_of_care_employee_asc($where) {
          $select   = array(
                            "pc.*",
                            "em.firstname",
                            "em.lastname",
                            "em.employee_id",
                          );
          $this->db->select($select);
          $this->db->from("plan_of_care as pc");
          $this->db->join('employee as em', 'pc.employee_id = em.employee_id');
          if(!empty($where)){
            $this->db->where($where);
          }
          $this->db->order_by('pc.plc_id','asc');
          return $this->db->get()->result_array();  
      }




      public function get_weekly_discussions($fromD='', $toD='', $patient_id='', $agency_code='', $keyword = '', $employee_id='', $patientStataus='', $contact_type='') {
        
        $cond = '';
        if($patient_id!='') {
          $cond .= " AND tblweeklydiscussionsnew.patient_id=".$patient_id." ";
        }
        if($employee_id!='') {
          $cond .= " AND tblweeklydiscussionsnew.employee_id=".$employee_id." ";
        }
        if($patientStataus!='') {
          $cond .= " AND patient.IsActive=".$patientStataus." ";  
        }

        if($contact_type!='') {
          $cond .= " AND tblweeklydiscussionsnew.ProgressNotesTypeID_Ref='".$contact_type."'";
        }

        $MySQL = "SELECT SQL_CALC_FOUND_ROWS distinct
                   tblweeklydiscussionsnew.WeeklyDiscussionID,
                   tblweeklydiscussionsnew.recid,
                   tblweeklydiscussionsnew.EmployeeID_Ref,
                   tblweeklydiscussionsnew.WeekStartingDate,
                   tblweeklydiscussionsnew.ProgressNotesTypeID_Ref,
                   tblweeklydiscussionsnew.patient_id,
                   tblweeklydiscussionsnew.username,
                   tblweeklydiscussionsnew.TransactionDate,
                   employee.employee_ref_id,
                   employee.employee_id,
                   employee.lastname,
                   employee.firstname,
                   employee.name as employee_name,
                   tblweeklydiscussionsnew.ProgressNotesDetails,
                   tblweeklydiscussionsnew.ProgressNotesDetailsEmp,                   
                   tblprogressnotestypes.ProgressNotesTypeID,
                   tblprogressnotestypes.ProgressNotesType,
                   patient.FHCA
                 FROM tblweeklydiscussionsnew,employee,patient,tblprogressnotestypes  
               WHERE employee.employee_id = tblweeklydiscussionsnew.employee_id AND patient.patient_id = tblweeklydiscussionsnew.patient_id  AND WeekStartingDate >= '$fromD'  AND WeekStartingDate  <= '$toD' AND tblprogressnotestypes.ProgressNotesTypeID = tblweeklydiscussionsnew.ProgressNotesTypeID_Ref $cond AND tblweeklydiscussionsnew.Agency = '$agency_code' AND  (tblweeklydiscussionsnew.WeekStartingDate like '%".$keyword."%' OR  employee.name like '%".$keyword."%' OR  tblprogressnotestypes.ProgressNotesType like '%".$keyword."%' OR tblweeklydiscussionsnew.ProgressNotesDetails like '%".$keyword."%') AND tblweeklydiscussionsnew.ProgressNotesDetails!='' order by tblweeklydiscussionsnew.WeekStartingDate desc";
               //ORDER BY ".$sortorder." ".$desc."   LIMIT " .$from. ", " .$to . " ";

                //echo $MySQL;
          $query = $this->db->query($MySQL);
          return $query->result_array();
      }

      public function get_weekly_employee($where=[]) {
        $select   = array(
                "ea.*",
                "em.*",
              );
        $this->db->select($select);
        $this->db->from("employee_assignment as ea");
        $this->db->join('employee as em', 'em.employee_id = ea.employee_id','left');
        if(!empty($where)){
          $this->db->where($where);
        }
        //$this->db->order_by('pp.id','desc');
        return $this->db->get()->result_array();  
      }

      public function get_patient_visitation($recno='', $dateofvisit='', $upload_date='', $employee='', $supervisor='') {
        $cond1 = $cond2 = $cond3 = $cond4 = '';

        if (!empty($dateofvisit) ) { 
            $cond2 = " AND date(dateofvisit) = '$dateofvisit'";
        }

        if (!empty($upload_date) ) { 
            $cond1 = " AND date(VisitationQuestion.upload_time) = date('$upload_date')";
        }

        if (!empty($employee) ) { 
            $cond3 = " AND empName = '$employee'";
        }

        if (!empty($supervisor) ) { 
            $cond4 = " AND supervisor.name like '%".$supervisor."%'";
        }

        $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                  patient.name AS pt_name,
                  patient.latitude as lat1,
                  patient.longitude as long1,
                  patient.ShipAddressAddr2,
                  patient.ShipAddressAddr3,
                  patient.ShipAddressCity,
                  EmployeeInHomeVisit.latitude as lat2,
                  EmployeeInHomeVisit.longitude as long2,
                  VisitationQuestion.upload_time,
                  VisitationQuestion.uniqueID,
                  VisitationQuestion.supervisorid,
                  supervisor.name,
                  EmployeeInHomeVisit.empName,
                  EmployeeInHomeVisit.dateofvisit,
                  EmployeeInHomeVisit.date,
                  EmployeeInHomeVisit.timeofvisit
                  FROM VisitationQuestion,patient,EmployeeInHomeVisit,supervisor
                  WHERE supervisor.supervisor_id = VisitationQuestion.supervisorid AND EmployeeInHomeVisit.uniqueID = VisitationQuestion.uniqueID AND VisitationQuestion.clientid = patient.patient_id     AND  VisitationQuestion.clientid = '$recno' ".$cond1.$cond2.$cond3.$cond4." ";
                  //ORDER BY ".$sortorder." ".$desc."    LIMIT " .$from. ", " .$to . " ";

                //echo $MySQL;  

                $query = $this->db->query($MySQL);

                return $query->result_array();
      }


      public function getPreviousDistricts($where=[]) {
        $select   = array(
                            "td.*",
                            "dt.*",
                          );
        $this->db->select($select);
        $this->db->from("tbldistricts as td");
        $this->db->join('district as dt', 'td.DistrictID = dt.DistrictID_Ref','left');
        if(!empty($where)){
          $this->db->where($where);
        }
        $this->db->order_by('dt.district_id','desc');
        return $this->db->get()->result_array();  
      }


      public function get_all_report($agency_code='', $condstatus='') {

        $MySQL = "SELECT 
              patient.lastname, 
              patient.firstname, 
              patient.middlename,
              patient.ShipAddressPostalCode,
              patient.phone,
              patient.phone2,
              patient.patient_id,
              patient.CustomFieldBirthday,
              patient.IsActive,
              patient.name,
              patient.med_effdate,
              patient.med_enddate,
              patient.med_medicaidno,
              patient.med_status,
              patient.JobStartDate,
              patient.agency_location,
              tbldistricts.DistrictNumber,
              tbldistricts.DistrictName,
              patient.FHCA,
              supervisor.firstname AS supfirstname, 
              supervisor.lastname AS suplastname 

              FROM patient,tbldistricts,supervisor
              WHERE  tbldistricts.DistrictID = patient.DistrictID_Ref AND 
              tbldistricts.Agency = '$agency_code' AND
              supervisor.supervisor_id = patient.supervisor_id AND 
              patient.Agency = '$agency_code'".$condstatus."  ORDER BY patient.name";

                $query = $this->db->query($MySQL);
                return $query->result_array();
          }

      /*Get All data with where clause*/
      public function validateUser($table, $column='*', $where=[], $whereOr=[], $whereIn=[], $like=[], $num_rows=false) {
          $this->db->select($column);
          $this->db->from($table);
          if(!empty($where)){
            $this->db->where($where);  
          }
          if(!empty($whereOr)){
            $this->db->or_where($whereOr);
          }
          if(!empty($whereIn)){
            $this->db->where_in($whereIn);
          }
          if(!empty($like)){
            $this->db->like($like);
          }
          //$this->db->order_by("created_at", "desc");
          $query = $this->db->get(); 
          //return $this->db->last_query();         
          if($num_rows){
            return $query->num_rows(); 
          } else {
            return $query->result_array();  
          }
      }


      public function get_districts($agency_code) {

        $DistrictID2 = @$_GET['DistrictID'];
        $DistrictNumber2 = @$_GET['DistrictNumber'];
        $DistrictName2 = @$_GET['DistrictName'];
        $Billing = @$_GET['BillingAddress'];
        $Billing2 = @$_GET['BillingAddress2'];
        $PhoneNumber2 = @$_GET['PhoneNumber'];
        $Diagnosis2 = @$_GET['Diagnosis'];
        $mco2 = @$_GET['mco'];

        $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM tbldistricts WHERE   
                  tbldistricts.DistrictID LIKE '%".$DistrictID2."%' AND 
                  tbldistricts.DistrictName LIKE '%".$DistrictName2."%' AND 
                  tbldistricts.DistrictNumber LIKE '%".$DistrictNumber2."%' AND 
                  tbldistricts.BillingAddress LIKE '%".$Billing."%' AND 
                  tbldistricts.BillingAddress2 LIKE '%".$Billing2."%' AND 
                  tbldistricts.PhoneNumber LIKE '%".$PhoneNumber2."%' AND 
                  tbldistricts.Diagnosis LIKE '%".$Diagnosis2."%' AND 
                  tbldistricts.mco LIKE '%".$mco2."%' AND  
                  tbldistricts.Agency = '$agency_code'";
                  //ORDER BY ".$sortorder." ".$desc."";   

        //echo $MySQL;          


        $query = $this->db->query($MySQL);
        return $query->result();
      }


      public function get_vendor_authorization_patient($agency_code='', $firsdate='', $lastdate='') {
        $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM patient inner JOIN tbldistricts
            ON DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code'  AND patient.Agency = '$agency_code' AND JobEndDate >= '$firsdate' AND JobEndDate <= '$lastdate'  ORDER BY patient.lastname";

        $query = $this->db->query($MySQL);
        return $query->result_array(); 
      }

      public function createTemporaryTable($MySQL) {
        $query = $this->db->query($MySQL);
      }

      public function get_patient_report($agency_code, $IsActive, $idoa) {

        $cond = '';
        if ($idoa == 1  )  {
         $cond = " AND idoa = 'Y' ";   
        }   

        if ($idoa == 2  )  {
         $cond = " AND idoa != 'Y' ";   
        } 

        $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM patient inner JOIN tbldistricts
        ON DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code'  AND patient.Agency = '$agency_code' AND IsActive != 1 ".$cond." ORDER BY patient.lastname";

        if ($IsActive == 1 )  {
          $MySQL = "SELECT SQL_CALC_FOUND_ROWS * FROM patient inner JOIN tbldistricts
          ON DistrictID = patient.DistrictID_Ref AND tbldistricts.Agency = '$agency_code'  AND patient.Agency = '$agency_code' AND IsActive = 1 ".$cond." ORDER BY patient.lastname";       
        }

        $query = $this->db->query($MySQL);
        return $query->result_array(); 
      }

      public function get_client_status_report($agency_code, $cond, $IsActive='', $fhca='') {
        $MySQL = "SELECT * FROM patient WHERE Agency = '$agency_code' AND  ".$cond."   lastname != ''  ";

        if($fhca!=='' && $fhca!=2) {
          $MySQL .= " AND FHCA = '$fhca'";
        }

        if($IsActive!='') {
          $MySQL .= " AND IsActive = '$IsActive'";
        }

        $MySQL .= " ORDER by lastname";

        $query = $this->db->query($MySQL);
        //return $this->db->last_query();         
        return $query->result_array(); 
      }

      

      public function get_pa_report($agency_code, $suplid2, $DistrictID_Ref2, $status='', $payor='') {

        $cond = '';
        if(!empty($suplid2)) {
            $cond .= " AND patient.supervisor_id = '".$suplid2."'";
        }

        if(!empty($DistrictID_Ref2)) {
            $cond .= " AND patient.DistrictID_Ref  = '".$DistrictID_Ref2."'";
        }

        if($status!='') {
            $cond .= " AND patient.IsActive  = '".$status."'";
        }

        if($payor!='') {
            $cond .= " AND tbldistricts.payorGrp  = '".$payor."'";
        }


        $MySQL = "SELECT patient.lastname,
        patient.firstname,
        patient.IsActive,
        DistrictName,
        patient_auth_history.Status, 
        patient.patient_id, 
        patient.termination_date, 
        patient_auth_history.authorization, 
        patient_auth_history.validfrom, 
        patient_auth_history.validto, 
        patient_auth_history.Status,
        supervisor.lastname AS suplastname,
        supervisor.firstname AS supfirstname 
        FROM patient,patient_auth_history,supervisor,tbldistricts 
        WHERE tbldistricts.DistrictID = patient.DistrictID_Ref  AND supervisor.supervisor_id = patient.supervisor_id AND patient.patient_id = patient_auth_history.patient_id and patient_auth_history.Status <> 'Valid' AND patient.Agency = '$agency_code' AND tbldistricts.Agency = '$agency_code' $cond ORDER BY patient_auth_history.validfrom DESC";

        //echo $MySQL;

        $query = $this->db->query($MySQL);
        return $query->result_array(); 
      }


      public function getZeroHourData($supervisor_id, $fromdte, $todte) {
        $MySQL = "SELECT * FROM patient WHERE  patient.supervisor_id  = '$supervisor_id'  AND patient.IsActive = 1  AND patient_id NOT IN (SELECT patient_id FROM temployee_clock WHERE DATE(date)  >= '$fromdte' AND DATE(date) <= '$todte'  ) ";

        $query = $this->db->query($MySQL);
        return $query->result_array(); 
      }


      public function getClientCustomReport() {

        $cond1 = $cond2 = $cond3 = $cond4 = $cond5 = $cond6 = $cond7 = $cond8 = "";

        if(!empty($_POST['active'])) {
          $active = $_POST['active'];
          $cond1 = " AND IsActive = '$active'";
        }

        if(!empty($_POST['DistrictID_Ref2'])) {
          $DistrictID_Ref2 = $_POST['DistrictID_Ref2'];
          $cond2 = " AND patient.DistrictID_Ref = '$DistrictID_Ref2'";
        }

        if(!empty($_POST['suplid2'])) {
          $suplid2 = $_POST['suplid2'];
          $cond3 = " AND patient.supervisor_id = '$suplid2'";
        }  

        if(!empty($_POST['FHCA2'])) {
          $FHCA2 = $_POST['FHCA2'];
          $cond4 = " AND patient.FHCA = '$FHCA2'";
        }  

        if(!empty($_POST['client_birthday']) && $_POST['client_birthday']!='__/__/____') {
          $client_birthday = $_POST['client_birthday'];
          $client_birthday2 = date("Y-m-d",strtotime($client_birthday));
          $cond5 = " AND CustomFieldBirthday = '$client_birthday2'";
        }        

        if(!empty($_POST['agency_location2'])) {
          $agency_location2 = $_POST['agency_location2'];
          //$cond6 = " AND patient.agency_location LIKE '%$agency_location2%'";
          $cond6 = " AND patient.agency_location = '$agency_location2'";
        }  

        if(!empty($_POST['race2'])) {
          $race2 = $_POST['race2'];
          $cond7 = " AND patient.race LIKE '%$race2%'";
        }  

        if(!empty($_POST['patient_id'])) {
          $patient_id = $_POST['patient_id'];
          $cond8 = " AND patient.patient_id = '$patient_id'";
        }

        $smoker    =   $this->input->post('smoker', TRUE);
        if($smoker!='') {
          $cond3 .= " AND patient.smoker = '$smoker'";  
        }

        $hoarder    =   $this->input->post('hoarder', TRUE);
        if($hoarder!='') {
          $cond3 .= " AND patient.hoarder = '$hoarder'";  
        }

        $covid_vax    =   $this->input->post('covid_vax', TRUE);
        if($covid_vax!='') {
          $cond3 .= " AND patient.covid_vax = '$covid_vax'";  
        }

        $gender = $_POST['gender']; 
        if($gender!='') {    
          $cond3 .= "AND patient.gender = '$gender'";   
        }

        $onHold = $_POST['onHold']; 
        if($onHold!='') {    
          $cond3 .= "AND patient.on_hold = '$onHold'";   
        } 

        $reason = $_POST['reason']; 
        if($reason!='') {    
          $cond3 .= "AND patient.reason = '$reason'";   
        }

        $agency_code = $this->session->userdata('agency');
        $phone2 = @$_POST['phone2'];
        $street2 = @$_POST['street2'];
        $zipcode = @$_POST['zipcode'];
        $city2 = @$_POST['city2'];
        $state2 = @$_POST['state2'];
        $firstname2 = @$_POST['firstname2'];
        $lastname2 = @$_POST['lastname2'];
        $mi2 = @$_POST['mi2'];


        $MySQL = "SELECT SQL_CALC_FOUND_ROWS
                        patient.lastname, 
                        patient.firstname, 
                        patient.middlename,
                        patient.patient_id,
                        patient.ShipAddressPostalCode,
                        patient.ShipAddressAddr2,
                        patient.ShipAddressCity,
                        patient.ShipAddressState,
                        patient.street,
                        patient.phone,
                        patient.phone2,
                        patient.popalert,
                        patient.popnotes,
                        patient.med_medicaidno,
                        patient.patient_id,
                        patient.CustomFieldBirthday,
                        patient.IsActive,
                        patient.JobStartDate,
                        patient.agency_location,
                        patient.HMKRHours,
                        patient.CNAHours,
                        patient.LPNHours,
                        patient.race,
                        patient.RNHours,
                        tbldistricts.DistrictNumber,
                        tbldistricts.DistrictName,
                        patient.FHCA,
                        patient.insurance_id_no1a,
                        patient.smoker,
                        patient.hoarder,
                        patient.covid_vax,
                        patient.gender,
                        patient.on_hold,
                        patient.reason,
                        patient.controlno,
                        patient.prev_controlno,
                        patient.latitude,
                        patient.longitude,
                        supervisor.firstname AS supfirstname, 
                        supervisor.lastname AS suplastname 

                        FROM patient,tbldistricts,supervisor
                        WHERE  tbldistricts.DistrictID = patient.DistrictID_Ref AND 
                        tbldistricts.Agency = '$agency_code' AND
                        supervisor.supervisor_id = patient.supervisor_id AND 
                        patient.Agency = '$agency_code'  AND
                        patient.patient_id LIKE '%".@$patient_id2."%' AND 
                        patient.phone LIKE '%".$phone2."%' AND 
                        patient.ShipAddressAddr2 LIKE '%".$street2."%' AND 
                        patient.ShipAddressPostalCode LIKE '%".$zipcode."%' AND 
                        patient.ShipAddressCity LIKE '%".$city2."%' AND 
                        patient.ShipAddressState LIKE '%".$state2."%' AND 
                        patient.firstname LIKE '%".$firstname2."%' AND patient.middlename LIKE '%".$mi2."%' AND patient.lastname LIKE '%".$lastname2."%' 
                        ".$cond1.$cond2.$cond3.$cond4.$cond5.$cond6.$cond7.$cond8." ";
                        //ORDER BY ".$sortorder." ".$desc." 
                        //LIMIT " .$from. ", " .$to ."   ";   

                        //echo $MySQL;

              $query = $this->db->query($MySQL);
              return $query->result_array();           
      }


      public function getEmployeeCustomReport() {

        $cond = "";

        if($_POST['employee_id']!='') {
          $employee_id = $_POST['employee_id'];
          $cond .= " AND employee_id = '$employee_id'";
        }

        if($_POST['active']!='') {
          $active = $_POST['active'];
          $cond .= " AND Status = '$active'";
        }

        if(!empty($_POST['suplid2'])) {
          $suplid2 = $_POST['suplid2'];
          $cond .= " AND employee.supervisor_id = '$suplid2'";
        }  

        if(!empty($_POST['flag'])) {
          $flag = $_POST['flag'];
          $cond .= " AND employee.flag = '$flag'";
        }

        if(!empty($_POST['driveonJob'])) {
          $driveonJob = $_POST['driveonJob'];
          //$cond .= " AND employee.DriveOnJob = '$driveonJob'";
        }  

        $cond .= " AND employee.DriveOnJob = 0";

        if(!empty($_POST['BirthDate']) && $_POST['BirthDate']!='__/__/____') {
          $BirthDate = $_POST['BirthDate'];
          $BirthDate = date("Y-m-d",strtotime($BirthDate));
          $cond .= " AND employee.BirthDate = '$BirthDate'";
        }        

        if(!empty($_POST['geofencing'])) {
          $geofencing = $_POST['geofencing'];
          $cond .= " AND employee.geofencing = '$geofencing'";
        }  

        if(!empty($_POST['race2'])) {
          $race2 = $_POST['race2'];
          $cond .= " AND employee.race LIKE '%$race2%'";
        }  

        $dementia = $_POST['dementia']; 
        if($dementia!='') {    
            $cond .= "AND employee.dementia = '$dementia'";   
        }

        $covid_vax = $_POST['covid_vax']; 
        if($covid_vax!='') {    
            $cond .= "AND employee.covid_vax = '$covid_vax'";   
        }

        $gender = $_POST['gender']; 
        if($gender!='') {    
            $cond .= "AND employee.gender = '$gender'";   
        }

        $agency_code = $this->session->userdata('agency');
        $phone2 = @$_POST['phone'];
        $mobile = @$_POST['mobile'];
        $street2 = @$_POST['street'];
        $zipcode = @$_POST['zipcode'];
        $city2 = @$_POST['city'];
        $state2 = @$_POST['state'];
        $firstname2 = @$_POST['firstname'];
        $lastname2 = @$_POST['lastname'];
        $email = @$_POST['email'];
        $agency_location = @$_POST['agency_location'];


        /*$MySQL = "SELECT SQL_CALC_FOUND_ROWS
                        employee.lastname, 
                        employee.firstname, 
                        employee.EmployeeAddressPostalCode,
                        employee.EmployeeAddressAddr1,
                        employee.EmployeeAddressAddr2,
                        employee.EmployeeAddressCity,
                        employee.EmployeeAddressState,
                        employee.phone,
                        employee.mobile,
                        employee.popalert,
                        employee.popnotes,
                        employee.employee_id,
                        employee.BirthDate,
                        employee.Status,
                        employee.DriveOnJob,
                        employee.Agency,
                        employee.compliance,
                        employee.race,
                        employee.supervisor_id,
                        employee.geofencing,
                        employee.language,
                        supervisor.firstname AS supfirstname, 
                        supervisor.lastname AS suplastname 

                        FROM employee,tbldistricts,supervisor
                        WHERE  tbldistricts.DistrictID = employee.EmployeeTypeID_Ref AND 
                        tbldistricts.Agency = '$agency_code' AND
                        supervisor.supervisor_id = employee.supervisor_id AND 
                        employee.Agency = '$agency_code'  AND
                        employee.employee_id LIKE '%".@$employee_id."%' AND 
                        employee.phone LIKE '%".$phone2."%' AND 
                        employee.mobile LIKE '%".$mobile."%' AND 
                        employee.EmployeeAddressAddr1 LIKE '%".$street2."%' AND 
                        employee.EmployeeAddressAddr2 LIKE '%".$street2."%' AND 
                        employee.EmployeeAddressPostalCode LIKE '%".$zipcode."%' AND 
                        employee.EmployeeAddressCity LIKE '%".$city2."%' AND 
                        employee.EmployeeAddressState LIKE '%".$state2."%' AND 
                        employee.firstname LIKE '%".$firstname2."%' AND employee.lastname LIKE '%".$lastname2."%' 
                        ".$cond." ";*/


            $MySQL = "SELECT SQL_CALC_FOUND_ROWS
                        employee.lastname, 
                        employee.firstname,
                        employee.email,
                        employee.EmployeeAddressPostalCode,
                        employee.EmployeeAddressAddr1,
                        employee.EmployeeAddressAddr2,
                        employee.EmployeeAddressCity,
                        employee.EmployeeAddressState,
                        employee.phone,
                        employee.mobile,
                        employee.popalert,
                        employee.popnotes,
                        employee.employee_id,
                        employee.BirthDate,
                        employee.Status,
                        employee.DriveOnJob,
                        employee.Agency,
                        employee.agency_location,
                        employee.compliance,
                        employee.race,
                        employee.supervisor_id,
                        employee.geofencing,
                        employee.language,
                        employee.directdeposit,
                        employee.dementia,
                        employee.covid_vax,
                        employee.gender,
                        employee.flag,
                        employee.ssn,
                        employee.device,
                        supervisor.firstname AS supfirstname, 
                        supervisor.lastname AS suplastname 

                        FROM employee,supervisor
                        WHERE supervisor.supervisor_id = employee.supervisor_id AND 
                        employee.Agency = '$agency_code'  AND
                        employee.employee_id LIKE '%".@$employee_id."%' AND ";

                        if($phone2!='') {
                          $MySQL .= "employee.phone LIKE '%".$phone2."%' AND ";
                        }
                        if($mobile!='') {
                          $MySQL .= "employee.mobile LIKE '%".$mobile."%' AND ";
                        }
                        if($email!='') {
                          $MySQL .= "employee.email LIKE '%".$email."%' AND ";
                        }
                        if($agency_location!='') {
                          $MySQL .= "employee.agency_location='".$agency_location."' AND ";
                        }
                        if($street2!='') {
                          $MySQL .= "employee.EmployeeAddressAddr1 LIKE '%".$street2."%' AND ";  
                        }
                        if($city2!='') {
                          $MySQL .= "employee.EmployeeAddressCity LIKE '%".$city2."%' AND  ";  
                        }
                        if($state2!='') {
                          $MySQL .= "employee.EmployeeAddressState LIKE '%".$state2."%' AND   ";  
                        }
                        $MySQL .= "employee.EmployeeAddressPostalCode LIKE '%".$zipcode."%' AND 
                        employee.firstname LIKE '%".$firstname2."%' AND employee.lastname LIKE '%".$lastname2."%' 
                        ".$cond." ";            
                        //ORDER BY ".$sortorder." ".$desc." 
                        //LIMIT " .$from. ", " .$to ."   ";   

            $query = $this->db->query($MySQL);
            return $query->result_array();           
      }


      public function getEmployeeCustomReport2() {

        $cond = "";

        if($_POST['employee_id']!='') {
          $employee_id = $_POST['employee_id'];
          $cond .= " AND employee_id = '$employee_id'";
        }

        if($_POST['active']!='') {
          $active = $_POST['active'];
          $cond .= " AND Status = '$active'";
        }

        if(!empty($_POST['suplid2'])) {
          $suplid2 = $_POST['suplid2'];
          $cond .= " AND employee_bkp_27_JUL_2021.supervisor_id = '$suplid2'";
        }  

        if(!empty($_POST['flag'])) {
          $flag = $_POST['flag'];
          $cond .= " AND employee_bkp_27_JUL_2021.flag = '$flag'";
        }

        if(!empty($_POST['driveonJob'])) {
          $driveonJob = $_POST['driveonJob'];
          $cond .= " AND employee_bkp_27_JUL_2021.DriveOnJob = '$driveonJob'";
        }  

        if(!empty($_POST['BirthDate']) && $_POST['BirthDate']!='__/__/____') {
          $BirthDate = $_POST['BirthDate'];
          $BirthDate = date("Y-m-d",strtotime($BirthDate));
          $cond .= " AND employee_bkp_27_JUL_2021.BirthDate = '$BirthDate'";
        }        

        if(!empty($_POST['geofencing'])) {
          $geofencing = $_POST['geofencing'];
          $cond .= " AND employee_bkp_27_JUL_2021.geofencing = '$geofencing'";
        }  

        if(!empty($_POST['race2'])) {
          $race2 = $_POST['race2'];
          $cond .= " AND employee_bkp_27_JUL_2021.race LIKE '%$race2%'";
        }  

        $dementia = $_POST['dementia']; 
        if($dementia!='') {    
            $cond .= "AND employee_bkp_27_JUL_2021.dementia = '$dementia'";   
        }

        $covid_vax = $_POST['covid_vax']; 
        if($covid_vax!='') {    
            $cond .= "AND employee_bkp_27_JUL_2021.covid_vax = '$covid_vax'";   
        }

        $gender = $_POST['gender']; 
        if($gender!='') {    
            $cond .= "AND employee_bkp_27_JUL_2021.gender = '$gender'";   
        }

        $agency_code = $this->session->userdata('agency');
        $phone2 = @$_POST['phone'];
        $mobile = @$_POST['mobile'];
        $street2 = @$_POST['street'];
        $zipcode = @$_POST['zipcode'];
        $city2 = @$_POST['city'];
        $state2 = @$_POST['state'];
        $firstname2 = @$_POST['firstname'];
        $lastname2 = @$_POST['lastname'];


            $MySQL = "SELECT SQL_CALC_FOUND_ROWS
                        employee_bkp_27_JUL_2021.lastname, 
                        employee_bkp_27_JUL_2021.firstname, 
                        employee_bkp_27_JUL_2021.EmployeeAddressPostalCode,
                        employee_bkp_27_JUL_2021.EmployeeAddressAddr1,
                        employee_bkp_27_JUL_2021.EmployeeAddressAddr2,
                        employee_bkp_27_JUL_2021.EmployeeAddressCity,
                        employee_bkp_27_JUL_2021.EmployeeAddressState,
                        employee_bkp_27_JUL_2021.phone,
                        employee_bkp_27_JUL_2021.mobile,
                        employee_bkp_27_JUL_2021.popalert,
                        employee_bkp_27_JUL_2021.popnotes,
                        employee_bkp_27_JUL_2021.employee_id,
                        employee_bkp_27_JUL_2021.BirthDate,
                        employee_bkp_27_JUL_2021.Status,
                        employee_bkp_27_JUL_2021.DriveOnJob,
                        employee_bkp_27_JUL_2021.Agency,
                        employee_bkp_27_JUL_2021.compliance,
                        employee_bkp_27_JUL_2021.race,
                        employee_bkp_27_JUL_2021.supervisor_id,
                        employee_bkp_27_JUL_2021.geofencing,
                        employee_bkp_27_JUL_2021.language,
                        employee_bkp_27_JUL_2021.directdeposit,
                        employee_bkp_27_JUL_2021.dementia,
                        employee_bkp_27_JUL_2021.covid_vax,
                        employee_bkp_27_JUL_2021.gender,
                        employee_bkp_27_JUL_2021.flag,
                        employee_bkp_27_JUL_2021.ssn,
                        supervisor.firstname AS supfirstname, 
                        supervisor.lastname AS suplastname 

                        FROM employee_bkp_27_JUL_2021,supervisor
                        WHERE supervisor.supervisor_id = employee_bkp_27_JUL_2021.supervisor_id AND 
                        employee_bkp_27_JUL_2021.Agency = '$agency_code'  AND
                        employee_bkp_27_JUL_2021.employee_id LIKE '%".@$employee_id."%' AND ";

                        if($phone2!='') {
                          $MySQL .= 'employee_bkp_27_JUL_2021.phone LIKE '%".$phone2."%' AND ';
                        }
                        if($mobile!='') {
                          $MySQL .= 'employee_bkp_27_JUL_2021.mobile LIKE '%".$mobile."%' AND ';
                        }
                        if($street2!='') {
                          $MySQL .= 'employee_bkp_27_JUL_2021.EmployeeAddressAddr1 LIKE '%".$street2."%' AND ';  
                        }
                        if($city2!='') {
                          $MySQL .= 'employee_bkp_27_JUL_2021.EmployeeAddressCity LIKE '%".$city2."%' AND  ';  
                        }
                        if($state2!='') {
                          $MySQL .= 'employee_bkp_27_JUL_2021.EmployeeAddressState LIKE '%".$state2."%' AND   ';  
                        }
                        $MySQL .= "employee_bkp_27_JUL_2021.EmployeeAddressPostalCode LIKE '%".$zipcode."%' AND 
                        employee_bkp_27_JUL_2021.firstname LIKE '%".$firstname2."%' AND employee_bkp_27_JUL_2021.lastname LIKE '%".$lastname2."%' 
                        ".$cond." ";            
                        //ORDER BY ".$sortorder." ".$desc." 
                        //LIMIT " .$from. ", " .$to ."   ";   

            $query = $this->db->query($MySQL);
            return $query->result_array();           
      }


      public function getTimesheetData($MySQL) {
        $query = $this->db->query($MySQL);
        return $query->result_array();           
      }


      public function get_schedule_data() {
        $agency_code = $this->session->userdata('agency');
        $MySQL = "SELECT SQL_CALC_FOUND_ROWS 
                          patient.patient_id,
                          patient.name AS pt_name,
                          employee.employee_id,
                          employee.name AS empl_name,
                          mon,tue,wed,thu,fri,sat,sun             
                          FROM employee_assignment,patient,employee WHERE 
                          patient.IsActive = '".@$_POST['IsActive']."' AND 
                          (patient.name LIKE '%".@$_POST["search"]."%' OR employee.name LIKE '%".@$_POST["search"]."%') AND 
                          employee_assignment.patient_id = patient.patient_id AND 
                          employee_assignment.employee_id = employee.employee_id  
                          AND patient.Agency = '$agency_code'    ";
                          //ORDER BY ".$sortorder." ".$desc."  LIMIT " .$from. ", " .$to . " " ;

              $query = $this->db->query($MySQL);
              return $query->result_array();     
      }

  }       
    