<div id="page-wrapper" onload="chatName()">
    <div class="container-fluid">
        <div class="row bg-title">
            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
                <h4 class="page-title">Chat Messenger</h4> </div>
                <div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
                    <ol class="breadcrumb">
                        <li><a href="<?= base_url('Admin/home') ?>">Dashboard</a></li>
                        <li class="active">Chat Messenger</li>
                    </ol>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- .chat-row -->
            <div class="chat-main-box" style="min-height: 400px;">
                <!-- .chat-left-panel -->
                <div class="chat-left-aside" id="leftAside">
                    <div class="open-panel"><i class="ti-angle-right"></i></div>
                    <div class="chat-left-inner" id="leftInner">
                        <div class="form-material">
                            <input class="form-control p-20" type="text" placeholder="Search Contact" oninput="chatName(this.value)" id="contactSearch">
                        </div>
                        <ul class="chatonline style-none" id="nameList">
                            <li>
                                <a href="javascript:void(0)"><span>Loading... </span></a>
                            </li>
                            <li class="p-20"></li>
                        </ul>
                    </div>
                </div>
                <!-- .chat-left-panel -->
                <!-- .chat-right-panel -->
                <div class="chat-right-aside" id="chatRightPanel">
                    <div class="chat-main-header">
                        <div class="p-10 b-b">
                            <h4 class="box-title">Chat Message</h4> 
                        </div>
                    </div>
                    <div class="chat-box">
                        <ul class="chat-list p-t-30" id="chatMessages">
                        </ul>
                        <div class="row send-chat-box" style="display: none;">
                            <form method="POST">
                                <div class="col-sm-12">
                                    <textarea class="form-control" id="message" placeholder="Type your message" name="message" required></textarea>
                                    <input type="hidden" id="senderId" name="senderId" value="">
                                    <div class="custom-send">
                                        <!-- <a href="javacript:void(0)" class="cst-icon" data-toggle="tooltip" title="Insert Emojis"><i class="ti-face-smile"></i></a>  -->
                                        <!-- <a href="javacript:void(0)" class="cst-icon" data-toggle="tooltip" title="File Attachment"><i class="fa fa-paperclip"></i></a> -->
                                        <button class="btn btn-danger btn-rounded" onclick="submitMsg()" type="button">Send</button>
                                        <!-- <input type="submit" class="btn btn-danger btn-rounded" name="sendMsg" value="send" /> -->
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- .chat-right-panel -->
            </div>
            <!-- /.chat-row -->
            <!-- ============================================================== -->
        </div>
        <!-- /.container-fluid -->
        <footer class="footer text-center"> 2017 &copy; Ample Admin brought to you by themedesigner.in </footer>
    </div>
    <script src="<?php echo base_url('assets/');?>plugins/bower_components/jquery/dist/jquery.min.js"></script>
    <script src="<?php echo base_url('assets/plugins/');?>bower_components/toast-master/js/jquery.toast.js"></script>
    <script type="text/javascript">
        chatName();
        function chatName(searchQuery=''){
            if(searchQuery!='')
            {
                $('body').loadingModal('destroy');
                $('body').loadingModal({text: 'Fetching Name...'});
            }
            var request = $.ajax({
                url: "<?php echo site_url("Chat/getName"); ?>",
                data:{searchQuery:searchQuery},
                method:"POST",
                dataType: "html"
            });
            request.done(function( data, textStatus, jqXHR ) {
                if(searchQuery!='')
                    $('body').loadingModal('hide');
                $('#chatRightPanel').show();
                $("#nameList").html(data);
                var chatNameListHeight= 400;
                $('#leftInner').slimScroll({
                    height: chatNameListHeight+'px',
                    position: 'right',
                    color: '#455A64',
                    distance: '0',
                });
            });
            request.fail(function( jqXHR, textStatus ) {
                alert( "Request failed: " + textStatus );
            });    
        }
        var chatSenderId;
        function getChats(senderId) {
            chatSenderId = senderId;
            $('body').loadingModal('destroy');
            $('body').loadingModal({text: 'Fetching Chats...'});
            var request = $.ajax({
                url: "<?php echo site_url("Chat/getChats"); ?>",
                method:'POST',
                data:{senderId:senderId},
                dataType: "html"
            });
            request.done(function( data, textStatus, jqXHR ) {
                $("#chatMessages").html(data);
                $('#senderId').val(senderId);
                if(data.length!=0)
                {
                	$("#chatMessages").next(".slimScrollBar").remove();
                	$("#chatMessages").next(".slimScrollRail").remove();
                	$("#chatMessages").slimscroll({destroy:true});
                    var chatboxHeight= ($(window).height()) - 410;
                    $('#chatMessages').slimScroll({
                        height: chatboxHeight+'px',
                        start: $('#chatMessages li:last-child'),
                        color: '#455A64',
                    });
                }
                $('.send-chat-box').show();
                $('body').loadingModal('hide');
            });
            request.fail(function( jqXHR, textStatus ) {
                    // alert( "Request failed: " + textStatus );
                });       
        }
        chatNotify();
        function chatNotify() {
        	var senderId=$("#senderId").val();
        	var getChatsFlag=0;
            var request = $.ajax({
                url: "<?php echo site_url("Chat/newMessageNotify"); ?>",
                dataType: "json"
            });
            request.done(function( data, textStatus, jqXHR ) {
                if(data.length!=0)
                {
                    for (var key in data) {
                        $.toast({
                            heading: 'New Message from '+data[key].senderName,
                            text:data[key].message,
                            position: 'bottom-left',
                            loaderBg: '#fff',
                            icon: 'info',
                            hideAfter: 7000,
                            stack: 6
                        });
                        if(data[key].senderId == senderId)
                        {
                        	getChatsFlag = 1;
                        }
                    }
                    if(getChatsFlag==1)
                    	getChats(senderId);
                    else
                    {
                    	$('#notifyChatList').prepend('<li><div class="message-center"><a href="<?php echo base_url('Chat') ?>"><div class="mail-contnet"><h5>'+data[key].senderName+'</h5> <span class="mail-desc">'+data[key].message+'</span></div></a></div></li>');
                    	$('#chatNotify').show();
                    }
                    	
                }
                setTimeout(function() { chatNotify() }, 8000);
            });
            request.fail(function( jqXHR, textStatus ) {
                    // alert( "Request failed: " + textStatus );
                });       
        }
        // setTimeout(function() { getChats(chatSenderId) }, 3000);
        function submitMsg(){
            var message=$("#message").val();
            var senderId=$("#senderId").val();
            if(message.length!=0)
            {
                $('body').loadingModal('destroy');
                $('body').loadingModal({text: 'Sending...'});
                var request = $.ajax({
                    url: "<?php echo site_url("Chat/addMessage"); ?>",
                    method: "POST",
                    data: { senderId:senderId,message:message},
                    dataType: "json"
                });
                request.done(function( data, textStatus, jqXHR ) {
                    $("#message").val("");
                    getChats(senderId);
                    if($('#contactSearch').val())
                    {
                        chatName();
                        $('#contactSearch').val('');
                    }

                });
                request.fail(function( jqXHR, textStatus ) {
                    alert( "Request failed: " + textStatus );
                });    
            }else{
                alert('Type some message and send it.');
            }
        }
    </script>