-- Database Manager 4.2.5 dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `admin`;
CREATE TABLE `admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `email` varchar(25) NOT NULL,
  `password` varchar(100) NOT NULL,
  `status` int(2) NOT NULL COMMENT '1. active 0. inactive',
  `created_on` varchar(50) NOT NULL,
  `updated_on` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `admin` (`id`, `name`, `email`, `password`, `status`, `created_on`, `updated_on`) VALUES
(1,	'Admin',	'admin@gmail.com',	'e10adc3949ba59abbe56e057f20f883e',	1,	'1519209394',	'1519209394');

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `chat`;
CREATE TABLE `chat` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NA',
  `student_id` int(11) NOT NULL,
  `staff_id` varchar(100) NOT NULL,
  `send_by` varchar(200) NOT NULL COMMENT '1=staff,2=student',
  `send_at` varchar(20) NOT NULL,
  `chat_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 = text , 2 = image',
  `is_read_student` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0. Not Read 1. Read',
  `is_read_staff` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0. Not Read 1. Read',
  `image` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`student_id`),
  KEY `photographar_id` (`staff_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `chat` (`id`, `message`, `student_id`, `staff_id`, `send_by`, `send_at`, `chat_type`, `is_read_student`, `is_read_staff`, `image`) VALUES
(1,	'hiii',	1,	'1',	'1',	'1569325339',	1,	0,	0,	''),
(2,	'hello Roshni',	1,	'1',	'2',	'1569476690',	1,	1,	1,	''),
(3,	'how are you',	1,	'1',	'1',	'1569478369',	1,	1,	1,	''),
(4,	'hey',	1,	'1',	'1',	'1569479686',	1,	1,	1,	''),
(5,	'hello',	1,	'1',	'1',	'1569482018',	1,	1,	1,	''),
(6,	'Hello Shivani',	1,	'1',	'1',	'1569491420',	1,	1,	1,	''),
(7,	'',	1,	'1',	'1',	'1569491423',	1,	1,	1,	''),
(8,	'hello',	1,	'1',	'1',	'1569491863',	1,	1,	1,	''),
(9,	'A small candle, 2.5 cm in size is placed at 27 cm in front of a concave mirror of radius of curvature 36 cm. At what distance from the mirror should a screen be placed in order to obtain a sharp image? Describe the nature and size of the image.\nIf the can',	1,	'1',	'1',	'1569492557',	1,	1,	1,	''),
(10,	'I will describe this question’s answer in detail in my next lecture ',	1,	'1',	'2',	'1569495506',	1,	1,	1,	''),
(11,	'hello',	1,	'1',	'1',	'1569649559',	1,	1,	1,	''),
(12,	'hiii',	1,	'1',	'1',	'1569764982',	1,	0,	0,	''),
(13,	'test',	1,	'1',	'1',	'1571010921',	1,	0,	0,	'');

DROP TABLE IF EXISTS `class`;
CREATE TABLE `class` (
  `class_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'primary key',
  `class_name` varchar(255) DEFAULT NULL,
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1.Active 0.Deactive',
  PRIMARY KEY (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `class` (`class_id`, `class_name`, `create_date`, `update_date`, `status`) VALUES
(1,	'First',	'1569318768',	'1569318768',	1),
(2,	'Second',	'1569318776',	'1569318776',	1),
(3,	'Third',	'1569322869',	'1569322869',	1),
(4,	'Fourth',	'1572687713',	'1572687713',	1),
(5,	'Fifth',	'1574344433',	'1574344433',	1);

DROP TABLE IF EXISTS `class_schedule`;
CREATE TABLE `class_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `day_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `created_at` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1. Active 0. Inactive',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `class_schedule` (`id`, `class_id`, `day_id`, `subject_id`, `created_at`, `status`) VALUES
(1,	1,	1,	1,	'1569322914',	1),
(2,	1,	1,	2,	'1569322914',	1),
(5,	1,	2,	1,	'1573115485',	1),
(6,	1,	2,	2,	'1573115485',	1);

DROP TABLE IF EXISTS `class_subject_combination`;
CREATE TABLE `class_subject_combination` (
  `s_c_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1.Active 2.Deactive',
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  PRIMARY KEY (`s_c_id`),
  KEY `class_id` (`class_id`),
  KEY `subject_id` (`subject_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `class_subject_combination` (`s_c_id`, `class_id`, `subject_id`, `status`, `create_date`, `update_date`) VALUES
(1,	1,	1,	1,	'1569322887',	'1569322887'),
(2,	2,	2,	1,	'1569322892',	'1569322892'),
(3,	1,	2,	1,	'1569322897',	'1569322897');

DROP TABLE IF EXISTS `day`;
CREATE TABLE `day` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `day` (`id`, `value`) VALUES
(1,	'Monday'),
(2,	'Tuesday'),
(3,	'Wednesday'),
(4,	'thursday'),
(5,	'Friday'),
(6,	'Saturday');

DROP TABLE IF EXISTS `grade_sheet`;
CREATE TABLE `grade_sheet` (
  `grade_sheet` int(15) NOT NULL AUTO_INCREMENT COMMENT 'primary key',
  `student_id` int(15) NOT NULL,
  `staff_id` int(15) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `out _of` int(11) NOT NULL COMMENT 'Basic 700',
  `total` int(11) NOT NULL,
  `grade` int(11) NOT NULL,
  `comment` int(11) NOT NULL COMMENT '//Very Good',
  PRIMARY KEY (`grade_sheet`),
  KEY `subject_i d` (`subject_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `notification`;
CREATE TABLE `notification` (
  `ntfID` int(10) NOT NULL AUTO_INCREMENT,
  `content` text NOT NULL,
  `deviceToken` varchar(500) NOT NULL,
  `type` int(50) NOT NULL,
  `deviceType` varchar(50) NOT NULL,
  `isRead` int(20) NOT NULL,
  `trueDate` date NOT NULL,
  `trueTime` varchar(225) NOT NULL,
  `user_id` int(10) NOT NULL,
  `sentTime` varchar(225) NOT NULL,
  `sentTimestamp` varchar(225) NOT NULL,
  `flag` int(20) NOT NULL,
  `title` varchar(250) NOT NULL,
  `sentDate` date NOT NULL,
  PRIMARY KEY (`ntfID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `role` varchar(255) NOT NULL DEFAULT '' COMMENT '1=staff , 0=student',
  `title` varchar(250) NOT NULL,
  `type` varchar(250) NOT NULL DEFAULT '' COMMENT 'Individual',
  `msg` tinytext NOT NULL,
  `created_at` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `notifications` (`id`, `user_id`, `role`, `title`, `type`, `msg`, `created_at`) VALUES
(1,	1,	'1',	'hello',	'7002',	'Testing',	'1569323048'),
(2,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1569325659'),
(3,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1569325768'),
(4,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1569331520'),
(5,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1570166090'),
(6,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1570166099'),
(7,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1570166109'),
(8,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1572686024'),
(9,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1572686033'),
(10,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1572686060'),
(11,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1572686072'),
(12,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1572686083'),
(13,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1572686123'),
(14,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1572686127'),
(15,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1574343596'),
(16,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1574343599'),
(17,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1574343601'),
(18,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1574343715'),
(19,	1,	'2',	'Hello',	'7003',	'Your Problem is solved',	'1574842800'),
(20,	1,	'1',	'hello ',	'7002',	'testing',	'1574842829');

DROP TABLE IF EXISTS `parent`;
CREATE TABLE `parent` (
  `parent_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'primary key',
  `parent_number` varchar(255) NOT NULL COMMENT 'random unique number',
  `father_name` varchar(255) NOT NULL,
  `mother_name` varchar(255) NOT NULL,
  `local_address` varchar(255) NOT NULL,
  `permanent_address` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(15) NOT NULL,
  `primary_phone_num` varchar(15) NOT NULL,
  `secondary_phone_num` varchar(15) NOT NULL,
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1. active 0. inactive',
  `image` varchar(255) NOT NULL,
  `device_type` varchar(255) NOT NULL,
  `device_token` text NOT NULL,
  `country_code` varchar(255) NOT NULL,
  PRIMARY KEY (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `parent` (`parent_id`, `parent_number`, `father_name`, `mother_name`, `local_address`, `permanent_address`, `email`, `password`, `primary_phone_num`, `secondary_phone_num`, `create_date`, `update_date`, `status`, `image`, `device_type`, `device_token`, `country_code`) VALUES
(1,	'1569322632',	'Abahay Singh',	'Mandakini Singh',	'vijay Nagar Near sanjeevani hospital ',	'vijay Nagar Near sanjeevani hospital Betul ',	'email@gmail.com',	'123456',	'8989898989',	'8989898989',	'1569322632',	'1569322632',	1,	'assets/images/parent/1569675492.jpeg',	'android',	'cGzIyAKd36U:APA91bH0RzV7v6wBuy8lEJ3DuYldw7QZvDcZ1nUqKFZrcjlY9u0CqP2tw_kui3Hp_IhG9lwpKrfV3mei5xnPaWROCqBYNojVTrLsXiWgxEDy0NIFwkOKB8bnj2gevlyhFrj8bW1GIbDt',	'91'),
(2,	'1572686623',	'ram',	'rama',	'indore',	'indore',	'sudhasingh0455@gmail.com',	'12345',	'8120820792',	'1234567895',	'1572686623',	'1572686884',	1,	'./assets/images/parent/1572686623.png',	'',	'',	'452001');

DROP TABLE IF EXISTS `result`;
CREATE TABLE `result` (
  `result_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'primary key',
  `staff_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `marks` double NOT NULL DEFAULT '0',
  `assignment` double NOT NULL DEFAULT '0',
  `assignment1` double NOT NULL DEFAULT '0',
  `lab` double NOT NULL DEFAULT '0',
  `project` double NOT NULL DEFAULT '0',
  `out_of` int(11) NOT NULL DEFAULT '0',
  `grade` varchar(100) NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `comment` varchar(255) NOT NULL,
  `session_id` int(11) NOT NULL,
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1 Active 0. Inactive',
  PRIMARY KEY (`result_id`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `result` (`result_id`, `staff_id`, `class_id`, `student_id`, `subject_id`, `marks`, `assignment`, `assignment1`, `lab`, `project`, `out_of`, `grade`, `total`, `comment`, `session_id`, `create_date`, `update_date`, `status`) VALUES
(1,	1,	1,	1,	2,	21,	52,	32,	21,	1,	90,	'A',	90,	'Very Good',	1,	'1569483308',	'1569675236',	1),
(2,	1,	1,	1,	1,	30,	10,	20,	14,	2,	120,	'B',	76,	'Good',	1,	'1569503231',	'1571365881',	1),
(3,	1,	1,	1,	1,	30,	10,	20,	14,	2,	120,	'B',	76,	'Good',	1,	'1569504531',	'1571365881',	1),
(4,	1,	1,	1,	1,	30,	10,	20,	14,	2,	120,	'B',	76,	'Good',	1,	'1569504601',	'1571365881',	1);

DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `role_id` int(10) NOT NULL AUTO_INCREMENT,
  `role` varchar(100) NOT NULL,
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1.active 0. deactive',
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `role` (`role_id`, `role`, `create_date`, `update_date`, `status`) VALUES
(1,	'TUTORIAL',	'1569322732',	'1569322732',	1),
(2,	'1',	'1572687195',	'1572687195',	0),
(3,	'rahul singh',	'1572687317',	'1572687317',	1);

DROP TABLE IF EXISTS `session`;
CREATE TABLE `session` (
  `session_id` int(11) NOT NULL AUTO_INCREMENT,
  `start_year` int(11) NOT NULL,
  `end_year` int(11) NOT NULL,
  `created_at` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1.Active 0 Inactive',
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `session` (`session_id`, `start_year`, `end_year`, `created_at`, `status`) VALUES
(1,	2019,	2020,	1566551866,	1),
(2,	2020,	2021,	1566551872,	1),
(3,	2021,	2022,	1566551882,	1),
(4,	2022,	2023,	1566551890,	1),
(5,	2023,	2024,	1566644418,	1),
(6,	2019,	2019,	1566644939,	1),
(7,	2024,	2025,	1566645022,	1),
(8,	2024,	2028,	1566645120,	1),
(9,	2023,	2024,	1566645131,	1),
(10,	2020,	2019,	1566645228,	1),
(11,	2020,	2019,	1566645318,	1),
(12,	2022,	2024,	1566645409,	1),
(13,	2020,	2021,	1566645534,	1),
(14,	2019,	2022,	1566904718,	1),
(15,	2020,	2021,	1566904776,	1),
(16,	2018,	2019,	1566904863,	1),
(17,	2018,	2022,	1572687611,	1);

DROP TABLE IF EXISTS `staff`;
CREATE TABLE `staff` (
  `staff_id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'primary key',
  `staff_number` varchar(255) NOT NULL COMMENT 'unique genrate',
  `staff_role` varchar(255) NOT NULL,
  `staff_position` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `first_name` varchar(255) NOT NULL,
  `middle_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `gender` int(11) NOT NULL COMMENT '0. Male 1.Female  2. Other',
  `date_of_birth` date NOT NULL,
  `local_address` varchar(255) NOT NULL,
  `permanent_address` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(15) NOT NULL,
  `primary_phone_num` varchar(15) NOT NULL,
  `secondary_phone_num` varchar(15) NOT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `qualifications` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1. Active  0. Inactive',
  `device_type` varchar(255) NOT NULL,
  `device_token` text NOT NULL,
  `country_code` varchar(255) NOT NULL,
  PRIMARY KEY (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `staff` (`staff_id`, `staff_number`, `staff_role`, `staff_position`, `title`, `first_name`, `middle_name`, `last_name`, `gender`, `date_of_birth`, `local_address`, `permanent_address`, `email`, `password`, `primary_phone_num`, `secondary_phone_num`, `city`, `state`, `qualifications`, `image`, `status`, `device_type`, `device_token`, `country_code`) VALUES
(1,	'053189327770',	'TUTORIAL',	'SENIOR MASTER',	'Mr',	'Aakash',	'kumar',	'Jain',	2,	'2019-09-21',	'No. 6 Sam Ekwunife Av. Nodu Okpuno',	'No. 6 Sam Ekwunife Av. Nodu Okpuno',	'admin@gmail.com ',	'123456',	'8989898989',	'8989898989',	'indore',	'M.P.',	'MA  Economics',	'./assets/images/staff/1574336979.png',	1,	'android',	'cGzIyAKd36U:APA91bH0RzV7v6wBuy8lEJ3DuYldw7QZvDcZ1nUqKFZrcjlY9u0CqP2tw_kui3Hp_IhG9lwpKrfV3mei5xnPaWROCqBYNojVTrLsXiWgxEDy0NIFwkOKB8bnj2gevlyhFrj8bW1GIbDt',	'91'),
(2,	'504178356630',	'rahul singh',	'senior master',	'Mr',	'rahul ',	'singh',	'patel',	1,	'2017-11-22',	'indore',	'indore',	'rahul@gmail.com',	'12345',	'8120820792',	'8120820792',	'indore',	'mp',	'be',	'./assets/images/staff/1574336994.png',	1,	'',	'',	'452001');

DROP TABLE IF EXISTS `staff_class`;
CREATE TABLE `staff_class` (
  `staff_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(10) NOT NULL,
  `class_id` int(11) NOT NULL,
  `created_at` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1.Active 0 Inactive',
  PRIMARY KEY (`staff_class_id`),
  KEY `staff_id` (`staff_id`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `staff_class` (`staff_class_id`, `staff_id`, `class_id`, `created_at`, `status`) VALUES
(1,	1,	1,	1569319181,	1),
(2,	1,	2,	1569322840,	1),
(3,	2,	2,	1572687554,	1);

DROP TABLE IF EXISTS `staff_position`;
CREATE TABLE `staff_position` (
  `staff_position_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'primary Key',
  `staff_position_name` varchar(255) NOT NULL,
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1. Active, 0.Inactive',
  PRIMARY KEY (`staff_position_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `staff_position` (`staff_position_id`, `staff_position_name`, `create_date`, `update_date`, `status`) VALUES
(1,	'SENIOR MASTER',	'2019-09-24 09:57:11',	'2019-09-24 09:57:11',	1),
(2,	'SENIOR MASTER',	'2019-09-24 10:58:58',	'2019-09-24 10:58:58',	1),
(3,	'3',	'2019-11-02 09:34:06',	'2019-11-02 09:34:06',	1),
(4,	'senior master',	'2019-11-02 09:35:42',	'2019-11-02 09:35:42',	1);

DROP TABLE IF EXISTS `staff_schedule`;
CREATE TABLE `staff_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `day_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `created_at` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `staff_schedule` (`id`, `staff_id`, `class_id`, `day_id`, `subject_id`, `created_at`, `status`) VALUES
(1,	1,	1,	1,	1,	'1569322939',	1),
(2,	1,	1,	1,	2,	'1569322939',	1);

DROP TABLE IF EXISTS `student`;
CREATE TABLE `student` (
  `student_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'primary key',
  `parent_id` int(11) NOT NULL,
  `student_num` varchar(255) NOT NULL COMMENT 'unique genrate number',
  `first_name` varchar(255) NOT NULL,
  `middle_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `gender` int(11) NOT NULL COMMENT '0. Male 1.Female  2. Other',
  `date_of_birth` varchar(15) NOT NULL,
  `class_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `image` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `local_guardian_name` varchar(255) NOT NULL,
  `local_guardian_address` varchar(255) NOT NULL,
  `local_guardian_phone` varchar(255) NOT NULL,
  `local_guardian_email` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1.Active 0.Inactive',
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  PRIMARY KEY (`student_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `student` (`student_id`, `parent_id`, `student_num`, `first_name`, `middle_name`, `last_name`, `gender`, `date_of_birth`, `class_id`, `session_id`, `image`, `email`, `local_guardian_name`, `local_guardian_address`, `local_guardian_phone`, `local_guardian_email`, `status`, `create_date`, `update_date`, `country_code`) VALUES
(1,	1,	'166318595150',	'shivani',	'',	'Singh',	2,	'2019-08-25',	2,	1,	'./assets/images/student/1569322721.jpg',	'kuleep@gmail.com',	'Local Guardian name',	'Indore',	'1234567890',	'test@gmail.com',	1,	'1569322721',	'1569322721',	'+91'),
(2,	2,	'212445593589',	'deepak',	'kumar',	'patel',	2,	'2017-11-12',	3,	1,	'./assets/images/student/1572687060.png',	'sudhasingh0455@gmail.com',	'ram',	'sudha@gmail.com',	'1234567892',	'sudha@gmail.com',	1,	'1572687060',	'1572687060',	'452001');

DROP TABLE IF EXISTS `student_session_map`;
CREATE TABLE `student_session_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1.Active 0 Inactive',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `student_session_map` (`id`, `session_id`, `student_id`, `class_id`, `status`) VALUES
(1,	1,	1,	1,	1),
(2,	1,	2,	1,	1),
(3,	1,	2,	1,	1),
(4,	1,	2,	2,	1),
(5,	1,	2,	3,	1),
(6,	1,	1,	2,	1);

DROP TABLE IF EXISTS `subject`;
CREATE TABLE `subject` (
  `subject_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'primary key',
  `subject_name` varchar(255) NOT NULL,
  `subject_code` varchar(255) NOT NULL,
  `create_date` varchar(255) NOT NULL,
  `update_date` varchar(255) NOT NULL,
  `status` int(5) NOT NULL DEFAULT '1' COMMENT '1.Active 0.Deactive',
  PRIMARY KEY (`subject_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `subject` (`subject_id`, `subject_name`, `subject_code`, `create_date`, `update_date`, `status`) VALUES
(1,	'English',	'E01',	'1569319225',	'1569319225',	1),
(2,	'Maths',	'M01',	'1569319240',	'1569319240',	1),
(3,	'Science',	'S01',	'1569322879',	'1569322879',	1),
(4,	'hindi',	'H01',	'1572687779',	'1572687779',	1);

DROP TABLE IF EXISTS `ticket`;
CREATE TABLE `ticket` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `role` tinyint(4) NOT NULL COMMENT '1 staff, 2 student',
  `reason` tinytext NOT NULL,
  `title` tinytext NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0. Pending 1. Solve 2. Close',
  `craeted_at` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `ticket` (`id`, `user_id`, `role`, `reason`, `title`, `status`, `craeted_at`) VALUES
(1,	1,	1,	'testing',	'hiii',	1,	1569325358),
(2,	1,	2,	'A good teacher can inspire hope, ignite the imagination, and instill a love of learning. ',	'title',	1,	1569332136),
(3,	1,	1,	'I don’t know what it is',	'Problem',	1,	1569483932),
(4,	1,	2,	'Text can be set for such actions as notify by SMS or e-mail, register an event in unit history, or display popup window online.',	'festival is coming',	1,	1569490375),
(5,	1,	2,	'Fjkdsfjklsdfjklds',	'Jklsdfjkldsfjldsg',	1,	1569490663),
(6,	1,	2,	'Dear Lord, help me remember what a difference it makes when I make time with You a priority in my morning. Awaken me in body and spirit each day with a desire to meet with You and to hear You speak words of affirmation, assurance and wisdom over my heart ',	'Morning prayer system',	1,	1569665735),
(7,	1,	1,	'Text can be set for such actions as notify by SMS or e-mail, register an event in unit history, or display popup window online.',	'festival is coming',	1,	1573449936),
(8,	1,	1,	'solution',	'prpoblem',	1,	1574842681);

-- 2019-11-28 09:29:54
